goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_14886 = (function (this$){
var x__4509__auto__ = (((this$ == null))?null:this$);
var m__4510__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4510__auto__.call(null,this$));
} else {
var m__4508__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4508__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_14886(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_14887 = (function (this$){
var x__4509__auto__ = (((this$ == null))?null:this$);
var m__4510__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4510__auto__.call(null,this$));
} else {
var m__4508__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4508__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_14887(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__14186 = coll;
var G__14187 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__14186,G__14187) : shadow.dom.lazy_native_coll_seq.call(null,G__14186,G__14187));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4212__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__14204 = arguments.length;
switch (G__14204) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__14215 = arguments.length;
switch (G__14215) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__14221 = arguments.length;
switch (G__14221) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__14233 = arguments.length;
switch (G__14233) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__14246 = arguments.length;
switch (G__14246) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__14262 = arguments.length;
switch (G__14262) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4212__auto__ = (!((typeof document !== 'undefined')));
if(or__4212__auto__){
return or__4212__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e14272){if((e14272 instanceof Object)){
var e = e14272;
return console.log("didnt support attachEvent",el,e);
} else {
throw e14272;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4212__auto__ = (!((typeof document !== 'undefined')));
if(or__4212__auto__){
return or__4212__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__14284 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__14285 = null;
var count__14286 = (0);
var i__14287 = (0);
while(true){
if((i__14287 < count__14286)){
var el = chunk__14285.cljs$core$IIndexed$_nth$arity$2(null,i__14287);
var handler_14894__$1 = ((function (seq__14284,chunk__14285,count__14286,i__14287,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__14284,chunk__14285,count__14286,i__14287,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_14894__$1);


var G__14895 = seq__14284;
var G__14896 = chunk__14285;
var G__14897 = count__14286;
var G__14898 = (i__14287 + (1));
seq__14284 = G__14895;
chunk__14285 = G__14896;
count__14286 = G__14897;
i__14287 = G__14898;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__14284);
if(temp__5753__auto__){
var seq__14284__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__14284__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__14284__$1);
var G__14899 = cljs.core.chunk_rest(seq__14284__$1);
var G__14900 = c__4638__auto__;
var G__14901 = cljs.core.count(c__4638__auto__);
var G__14902 = (0);
seq__14284 = G__14899;
chunk__14285 = G__14900;
count__14286 = G__14901;
i__14287 = G__14902;
continue;
} else {
var el = cljs.core.first(seq__14284__$1);
var handler_14903__$1 = ((function (seq__14284,chunk__14285,count__14286,i__14287,el,seq__14284__$1,temp__5753__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__14284,chunk__14285,count__14286,i__14287,el,seq__14284__$1,temp__5753__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_14903__$1);


var G__14904 = cljs.core.next(seq__14284__$1);
var G__14905 = null;
var G__14906 = (0);
var G__14907 = (0);
seq__14284 = G__14904;
chunk__14285 = G__14905;
count__14286 = G__14906;
i__14287 = G__14907;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__14302 = arguments.length;
switch (G__14302) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__14316 = cljs.core.seq(events);
var chunk__14317 = null;
var count__14318 = (0);
var i__14319 = (0);
while(true){
if((i__14319 < count__14318)){
var vec__14334 = chunk__14317.cljs$core$IIndexed$_nth$arity$2(null,i__14319);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14334,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14334,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__14909 = seq__14316;
var G__14910 = chunk__14317;
var G__14911 = count__14318;
var G__14912 = (i__14319 + (1));
seq__14316 = G__14909;
chunk__14317 = G__14910;
count__14318 = G__14911;
i__14319 = G__14912;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__14316);
if(temp__5753__auto__){
var seq__14316__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__14316__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__14316__$1);
var G__14913 = cljs.core.chunk_rest(seq__14316__$1);
var G__14914 = c__4638__auto__;
var G__14915 = cljs.core.count(c__4638__auto__);
var G__14916 = (0);
seq__14316 = G__14913;
chunk__14317 = G__14914;
count__14318 = G__14915;
i__14319 = G__14916;
continue;
} else {
var vec__14340 = cljs.core.first(seq__14316__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14340,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14340,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__14917 = cljs.core.next(seq__14316__$1);
var G__14918 = null;
var G__14919 = (0);
var G__14920 = (0);
seq__14316 = G__14917;
chunk__14317 = G__14918;
count__14318 = G__14919;
i__14319 = G__14920;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__14347 = cljs.core.seq(styles);
var chunk__14348 = null;
var count__14349 = (0);
var i__14350 = (0);
while(true){
if((i__14350 < count__14349)){
var vec__14361 = chunk__14348.cljs$core$IIndexed$_nth$arity$2(null,i__14350);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14361,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14361,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__14921 = seq__14347;
var G__14922 = chunk__14348;
var G__14923 = count__14349;
var G__14924 = (i__14350 + (1));
seq__14347 = G__14921;
chunk__14348 = G__14922;
count__14349 = G__14923;
i__14350 = G__14924;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__14347);
if(temp__5753__auto__){
var seq__14347__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__14347__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__14347__$1);
var G__14925 = cljs.core.chunk_rest(seq__14347__$1);
var G__14926 = c__4638__auto__;
var G__14927 = cljs.core.count(c__4638__auto__);
var G__14928 = (0);
seq__14347 = G__14925;
chunk__14348 = G__14926;
count__14349 = G__14927;
i__14350 = G__14928;
continue;
} else {
var vec__14367 = cljs.core.first(seq__14347__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14367,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14367,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__14929 = cljs.core.next(seq__14347__$1);
var G__14930 = null;
var G__14931 = (0);
var G__14932 = (0);
seq__14347 = G__14929;
chunk__14348 = G__14930;
count__14349 = G__14931;
i__14350 = G__14932;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__14380_14933 = key;
var G__14380_14934__$1 = (((G__14380_14933 instanceof cljs.core.Keyword))?G__14380_14933.fqn:null);
switch (G__14380_14934__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_14936 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__4212__auto__ = goog.string.startsWith(ks_14936,"data-");
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return goog.string.startsWith(ks_14936,"aria-");
}
})())){
el.setAttribute(ks_14936,value);
} else {
(el[ks_14936] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__14394){
var map__14395 = p__14394;
var map__14395__$1 = cljs.core.__destructure_map(map__14395);
var props = map__14395__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14395__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__14398 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14398,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14398,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14398,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__14403 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__14403,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__14403;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__14408 = arguments.length;
switch (G__14408) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5753__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5753__auto__)){
var n = temp__5753__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5753__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5753__auto__)){
var n = temp__5753__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__14418){
var vec__14420 = p__14418;
var seq__14421 = cljs.core.seq(vec__14420);
var first__14422 = cljs.core.first(seq__14421);
var seq__14421__$1 = cljs.core.next(seq__14421);
var nn = first__14422;
var first__14422__$1 = cljs.core.first(seq__14421__$1);
var seq__14421__$2 = cljs.core.next(seq__14421__$1);
var np = first__14422__$1;
var nc = seq__14421__$2;
var node = vec__14420;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__14426 = nn;
var G__14427 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__14426,G__14427) : create_fn.call(null,G__14426,G__14427));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__14429 = nn;
var G__14430 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__14429,G__14430) : create_fn.call(null,G__14429,G__14430));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__14434 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14434,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14434,(1),null);
var seq__14439_14938 = cljs.core.seq(node_children);
var chunk__14440_14939 = null;
var count__14441_14940 = (0);
var i__14442_14941 = (0);
while(true){
if((i__14442_14941 < count__14441_14940)){
var child_struct_14942 = chunk__14440_14939.cljs$core$IIndexed$_nth$arity$2(null,i__14442_14941);
var children_14943 = shadow.dom.dom_node(child_struct_14942);
if(cljs.core.seq_QMARK_(children_14943)){
var seq__14485_14944 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_14943));
var chunk__14487_14945 = null;
var count__14488_14946 = (0);
var i__14489_14947 = (0);
while(true){
if((i__14489_14947 < count__14488_14946)){
var child_14948 = chunk__14487_14945.cljs$core$IIndexed$_nth$arity$2(null,i__14489_14947);
if(cljs.core.truth_(child_14948)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_14948);


var G__14949 = seq__14485_14944;
var G__14950 = chunk__14487_14945;
var G__14951 = count__14488_14946;
var G__14952 = (i__14489_14947 + (1));
seq__14485_14944 = G__14949;
chunk__14487_14945 = G__14950;
count__14488_14946 = G__14951;
i__14489_14947 = G__14952;
continue;
} else {
var G__14953 = seq__14485_14944;
var G__14954 = chunk__14487_14945;
var G__14955 = count__14488_14946;
var G__14956 = (i__14489_14947 + (1));
seq__14485_14944 = G__14953;
chunk__14487_14945 = G__14954;
count__14488_14946 = G__14955;
i__14489_14947 = G__14956;
continue;
}
} else {
var temp__5753__auto___14957 = cljs.core.seq(seq__14485_14944);
if(temp__5753__auto___14957){
var seq__14485_14958__$1 = temp__5753__auto___14957;
if(cljs.core.chunked_seq_QMARK_(seq__14485_14958__$1)){
var c__4638__auto___14959 = cljs.core.chunk_first(seq__14485_14958__$1);
var G__14960 = cljs.core.chunk_rest(seq__14485_14958__$1);
var G__14961 = c__4638__auto___14959;
var G__14962 = cljs.core.count(c__4638__auto___14959);
var G__14963 = (0);
seq__14485_14944 = G__14960;
chunk__14487_14945 = G__14961;
count__14488_14946 = G__14962;
i__14489_14947 = G__14963;
continue;
} else {
var child_14964 = cljs.core.first(seq__14485_14958__$1);
if(cljs.core.truth_(child_14964)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_14964);


var G__14965 = cljs.core.next(seq__14485_14958__$1);
var G__14966 = null;
var G__14967 = (0);
var G__14968 = (0);
seq__14485_14944 = G__14965;
chunk__14487_14945 = G__14966;
count__14488_14946 = G__14967;
i__14489_14947 = G__14968;
continue;
} else {
var G__14969 = cljs.core.next(seq__14485_14958__$1);
var G__14970 = null;
var G__14971 = (0);
var G__14972 = (0);
seq__14485_14944 = G__14969;
chunk__14487_14945 = G__14970;
count__14488_14946 = G__14971;
i__14489_14947 = G__14972;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_14943);
}


var G__14973 = seq__14439_14938;
var G__14974 = chunk__14440_14939;
var G__14975 = count__14441_14940;
var G__14976 = (i__14442_14941 + (1));
seq__14439_14938 = G__14973;
chunk__14440_14939 = G__14974;
count__14441_14940 = G__14975;
i__14442_14941 = G__14976;
continue;
} else {
var temp__5753__auto___14977 = cljs.core.seq(seq__14439_14938);
if(temp__5753__auto___14977){
var seq__14439_14978__$1 = temp__5753__auto___14977;
if(cljs.core.chunked_seq_QMARK_(seq__14439_14978__$1)){
var c__4638__auto___14979 = cljs.core.chunk_first(seq__14439_14978__$1);
var G__14980 = cljs.core.chunk_rest(seq__14439_14978__$1);
var G__14981 = c__4638__auto___14979;
var G__14982 = cljs.core.count(c__4638__auto___14979);
var G__14983 = (0);
seq__14439_14938 = G__14980;
chunk__14440_14939 = G__14981;
count__14441_14940 = G__14982;
i__14442_14941 = G__14983;
continue;
} else {
var child_struct_14984 = cljs.core.first(seq__14439_14978__$1);
var children_14985 = shadow.dom.dom_node(child_struct_14984);
if(cljs.core.seq_QMARK_(children_14985)){
var seq__14500_14986 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_14985));
var chunk__14502_14987 = null;
var count__14503_14988 = (0);
var i__14504_14989 = (0);
while(true){
if((i__14504_14989 < count__14503_14988)){
var child_14990 = chunk__14502_14987.cljs$core$IIndexed$_nth$arity$2(null,i__14504_14989);
if(cljs.core.truth_(child_14990)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_14990);


var G__14991 = seq__14500_14986;
var G__14992 = chunk__14502_14987;
var G__14993 = count__14503_14988;
var G__14994 = (i__14504_14989 + (1));
seq__14500_14986 = G__14991;
chunk__14502_14987 = G__14992;
count__14503_14988 = G__14993;
i__14504_14989 = G__14994;
continue;
} else {
var G__14995 = seq__14500_14986;
var G__14996 = chunk__14502_14987;
var G__14997 = count__14503_14988;
var G__14998 = (i__14504_14989 + (1));
seq__14500_14986 = G__14995;
chunk__14502_14987 = G__14996;
count__14503_14988 = G__14997;
i__14504_14989 = G__14998;
continue;
}
} else {
var temp__5753__auto___14999__$1 = cljs.core.seq(seq__14500_14986);
if(temp__5753__auto___14999__$1){
var seq__14500_15000__$1 = temp__5753__auto___14999__$1;
if(cljs.core.chunked_seq_QMARK_(seq__14500_15000__$1)){
var c__4638__auto___15001 = cljs.core.chunk_first(seq__14500_15000__$1);
var G__15002 = cljs.core.chunk_rest(seq__14500_15000__$1);
var G__15003 = c__4638__auto___15001;
var G__15004 = cljs.core.count(c__4638__auto___15001);
var G__15005 = (0);
seq__14500_14986 = G__15002;
chunk__14502_14987 = G__15003;
count__14503_14988 = G__15004;
i__14504_14989 = G__15005;
continue;
} else {
var child_15006 = cljs.core.first(seq__14500_15000__$1);
if(cljs.core.truth_(child_15006)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_15006);


var G__15007 = cljs.core.next(seq__14500_15000__$1);
var G__15008 = null;
var G__15009 = (0);
var G__15010 = (0);
seq__14500_14986 = G__15007;
chunk__14502_14987 = G__15008;
count__14503_14988 = G__15009;
i__14504_14989 = G__15010;
continue;
} else {
var G__15011 = cljs.core.next(seq__14500_15000__$1);
var G__15012 = null;
var G__15013 = (0);
var G__15014 = (0);
seq__14500_14986 = G__15011;
chunk__14502_14987 = G__15012;
count__14503_14988 = G__15013;
i__14504_14989 = G__15014;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_14985);
}


var G__15015 = cljs.core.next(seq__14439_14978__$1);
var G__15016 = null;
var G__15017 = (0);
var G__15018 = (0);
seq__14439_14938 = G__15015;
chunk__14440_14939 = G__15016;
count__14441_14940 = G__15017;
i__14442_14941 = G__15018;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__14519 = cljs.core.seq(node);
var chunk__14520 = null;
var count__14521 = (0);
var i__14522 = (0);
while(true){
if((i__14522 < count__14521)){
var n = chunk__14520.cljs$core$IIndexed$_nth$arity$2(null,i__14522);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__15019 = seq__14519;
var G__15020 = chunk__14520;
var G__15021 = count__14521;
var G__15022 = (i__14522 + (1));
seq__14519 = G__15019;
chunk__14520 = G__15020;
count__14521 = G__15021;
i__14522 = G__15022;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__14519);
if(temp__5753__auto__){
var seq__14519__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__14519__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__14519__$1);
var G__15023 = cljs.core.chunk_rest(seq__14519__$1);
var G__15024 = c__4638__auto__;
var G__15025 = cljs.core.count(c__4638__auto__);
var G__15026 = (0);
seq__14519 = G__15023;
chunk__14520 = G__15024;
count__14521 = G__15025;
i__14522 = G__15026;
continue;
} else {
var n = cljs.core.first(seq__14519__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__15027 = cljs.core.next(seq__14519__$1);
var G__15028 = null;
var G__15029 = (0);
var G__15030 = (0);
seq__14519 = G__15027;
chunk__14520 = G__15028;
count__14521 = G__15029;
i__14522 = G__15030;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__14540 = arguments.length;
switch (G__14540) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__14549 = arguments.length;
switch (G__14549) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__14556 = arguments.length;
switch (G__14556) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4212__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4824__auto__ = [];
var len__4818__auto___15034 = arguments.length;
var i__4819__auto___15035 = (0);
while(true){
if((i__4819__auto___15035 < len__4818__auto___15034)){
args__4824__auto__.push((arguments[i__4819__auto___15035]));

var G__15036 = (i__4819__auto___15035 + (1));
i__4819__auto___15035 = G__15036;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__14575_15037 = cljs.core.seq(nodes);
var chunk__14576_15038 = null;
var count__14577_15039 = (0);
var i__14578_15040 = (0);
while(true){
if((i__14578_15040 < count__14577_15039)){
var node_15041 = chunk__14576_15038.cljs$core$IIndexed$_nth$arity$2(null,i__14578_15040);
fragment.appendChild(shadow.dom._to_dom(node_15041));


var G__15042 = seq__14575_15037;
var G__15043 = chunk__14576_15038;
var G__15044 = count__14577_15039;
var G__15045 = (i__14578_15040 + (1));
seq__14575_15037 = G__15042;
chunk__14576_15038 = G__15043;
count__14577_15039 = G__15044;
i__14578_15040 = G__15045;
continue;
} else {
var temp__5753__auto___15046 = cljs.core.seq(seq__14575_15037);
if(temp__5753__auto___15046){
var seq__14575_15047__$1 = temp__5753__auto___15046;
if(cljs.core.chunked_seq_QMARK_(seq__14575_15047__$1)){
var c__4638__auto___15048 = cljs.core.chunk_first(seq__14575_15047__$1);
var G__15049 = cljs.core.chunk_rest(seq__14575_15047__$1);
var G__15050 = c__4638__auto___15048;
var G__15051 = cljs.core.count(c__4638__auto___15048);
var G__15052 = (0);
seq__14575_15037 = G__15049;
chunk__14576_15038 = G__15050;
count__14577_15039 = G__15051;
i__14578_15040 = G__15052;
continue;
} else {
var node_15053 = cljs.core.first(seq__14575_15047__$1);
fragment.appendChild(shadow.dom._to_dom(node_15053));


var G__15054 = cljs.core.next(seq__14575_15047__$1);
var G__15055 = null;
var G__15056 = (0);
var G__15057 = (0);
seq__14575_15037 = G__15054;
chunk__14576_15038 = G__15055;
count__14577_15039 = G__15056;
i__14578_15040 = G__15057;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq14567){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq14567));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__14588_15058 = cljs.core.seq(scripts);
var chunk__14589_15059 = null;
var count__14590_15060 = (0);
var i__14591_15061 = (0);
while(true){
if((i__14591_15061 < count__14590_15060)){
var vec__14606_15062 = chunk__14589_15059.cljs$core$IIndexed$_nth$arity$2(null,i__14591_15061);
var script_tag_15063 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14606_15062,(0),null);
var script_body_15064 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14606_15062,(1),null);
eval(script_body_15064);


var G__15065 = seq__14588_15058;
var G__15066 = chunk__14589_15059;
var G__15067 = count__14590_15060;
var G__15068 = (i__14591_15061 + (1));
seq__14588_15058 = G__15065;
chunk__14589_15059 = G__15066;
count__14590_15060 = G__15067;
i__14591_15061 = G__15068;
continue;
} else {
var temp__5753__auto___15069 = cljs.core.seq(seq__14588_15058);
if(temp__5753__auto___15069){
var seq__14588_15070__$1 = temp__5753__auto___15069;
if(cljs.core.chunked_seq_QMARK_(seq__14588_15070__$1)){
var c__4638__auto___15071 = cljs.core.chunk_first(seq__14588_15070__$1);
var G__15072 = cljs.core.chunk_rest(seq__14588_15070__$1);
var G__15073 = c__4638__auto___15071;
var G__15074 = cljs.core.count(c__4638__auto___15071);
var G__15075 = (0);
seq__14588_15058 = G__15072;
chunk__14589_15059 = G__15073;
count__14590_15060 = G__15074;
i__14591_15061 = G__15075;
continue;
} else {
var vec__14610_15076 = cljs.core.first(seq__14588_15070__$1);
var script_tag_15077 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14610_15076,(0),null);
var script_body_15078 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14610_15076,(1),null);
eval(script_body_15078);


var G__15079 = cljs.core.next(seq__14588_15070__$1);
var G__15080 = null;
var G__15081 = (0);
var G__15082 = (0);
seq__14588_15058 = G__15079;
chunk__14589_15059 = G__15080;
count__14590_15060 = G__15081;
i__14591_15061 = G__15082;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__14614){
var vec__14615 = p__14614;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14615,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14615,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__14630 = arguments.length;
switch (G__14630) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__14646 = cljs.core.seq(style_keys);
var chunk__14647 = null;
var count__14648 = (0);
var i__14649 = (0);
while(true){
if((i__14649 < count__14648)){
var it = chunk__14647.cljs$core$IIndexed$_nth$arity$2(null,i__14649);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__15084 = seq__14646;
var G__15085 = chunk__14647;
var G__15086 = count__14648;
var G__15087 = (i__14649 + (1));
seq__14646 = G__15084;
chunk__14647 = G__15085;
count__14648 = G__15086;
i__14649 = G__15087;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__14646);
if(temp__5753__auto__){
var seq__14646__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__14646__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__14646__$1);
var G__15088 = cljs.core.chunk_rest(seq__14646__$1);
var G__15089 = c__4638__auto__;
var G__15090 = cljs.core.count(c__4638__auto__);
var G__15091 = (0);
seq__14646 = G__15088;
chunk__14647 = G__15089;
count__14648 = G__15090;
i__14649 = G__15091;
continue;
} else {
var it = cljs.core.first(seq__14646__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__15092 = cljs.core.next(seq__14646__$1);
var G__15093 = null;
var G__15094 = (0);
var G__15095 = (0);
seq__14646 = G__15092;
chunk__14647 = G__15093;
count__14648 = G__15094;
i__14649 = G__15095;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k14659,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__14669 = k14659;
var G__14669__$1 = (((G__14669 instanceof cljs.core.Keyword))?G__14669.fqn:null);
switch (G__14669__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k14659,else__4464__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4484__auto__,p__14674){
var vec__14675 = p__14674;
var k__4485__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14675,(0),null);
var v__4486__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14675,(1),null);
return (f__4482__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4482__auto__.cljs$core$IFn$_invoke$arity$3(ret__4484__auto__,k__4485__auto__,v__4486__auto__) : f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__));
}),init__4483__auto__,this__4481__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer(writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer(writer__4477__auto__,pr_pair__4479__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4478__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__14658){
var self__ = this;
var G__14658__$1 = this;
return (new cljs.core.RecordIter((0),G__14658__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (coll__4458__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__4458__auto__));
})(this__4457__auto____$1);
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this14660,other14661){
var self__ = this;
var this14660__$1 = this;
return (((!((other14661 == null)))) && ((((this14660__$1.constructor === other14661.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14660__$1.x,other14661.x)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14660__$1.y,other14661.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14660__$1.__extmap,other14661.__extmap)))))))));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4472__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4472__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k14659){
var self__ = this;
var this__4468__auto____$1 = this;
var G__14685 = k14659;
var G__14685__$1 = (((G__14685 instanceof cljs.core.Keyword))?G__14685.fqn:null);
switch (G__14685__$1) {
case "x":
case "y":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k14659);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__14658){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__14686 = cljs.core.keyword_identical_QMARK_;
var expr__14687 = k__4470__auto__;
if(cljs.core.truth_((pred__14686.cljs$core$IFn$_invoke$arity$2 ? pred__14686.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__14687) : pred__14686.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__14687)))){
return (new shadow.dom.Coordinate(G__14658,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__14686.cljs$core$IFn$_invoke$arity$2 ? pred__14686.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__14687) : pred__14686.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__14687)))){
return (new shadow.dom.Coordinate(self__.x,G__14658,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4470__auto__,G__14658),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__14658){
var self__ = this;
var this__4460__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__14658,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4467__auto__,(0)),cljs.core._nth(entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write(writer__4506__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__14664){
var extmap__4501__auto__ = (function (){var G__14695 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__14664,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__14664)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__14695);
} else {
return G__14695;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__14664),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__14664),null,cljs.core.not_empty(extmap__4501__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k14707,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__14716 = k14707;
var G__14716__$1 = (((G__14716 instanceof cljs.core.Keyword))?G__14716.fqn:null);
switch (G__14716__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k14707,else__4464__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4484__auto__,p__14719){
var vec__14721 = p__14719;
var k__4485__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14721,(0),null);
var v__4486__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14721,(1),null);
return (f__4482__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4482__auto__.cljs$core$IFn$_invoke$arity$3(ret__4484__auto__,k__4485__auto__,v__4486__auto__) : f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__));
}),init__4483__auto__,this__4481__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer(writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer(writer__4477__auto__,pr_pair__4479__auto__,"#shadow.dom.Size{",", ","}",opts__4478__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__14706){
var self__ = this;
var G__14706__$1 = this;
return (new cljs.core.RecordIter((0),G__14706__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (coll__4458__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__4458__auto__));
})(this__4457__auto____$1);
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this14708,other14709){
var self__ = this;
var this14708__$1 = this;
return (((!((other14709 == null)))) && ((((this14708__$1.constructor === other14709.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14708__$1.w,other14709.w)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14708__$1.h,other14709.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14708__$1.__extmap,other14709.__extmap)))))))));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4472__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4472__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k14707){
var self__ = this;
var this__4468__auto____$1 = this;
var G__14744 = k14707;
var G__14744__$1 = (((G__14744 instanceof cljs.core.Keyword))?G__14744.fqn:null);
switch (G__14744__$1) {
case "w":
case "h":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k14707);

}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__14706){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__14746 = cljs.core.keyword_identical_QMARK_;
var expr__14747 = k__4470__auto__;
if(cljs.core.truth_((pred__14746.cljs$core$IFn$_invoke$arity$2 ? pred__14746.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__14747) : pred__14746.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__14747)))){
return (new shadow.dom.Size(G__14706,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__14746.cljs$core$IFn$_invoke$arity$2 ? pred__14746.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__14747) : pred__14746.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__14747)))){
return (new shadow.dom.Size(self__.w,G__14706,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4470__auto__,G__14706),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__14706){
var self__ = this;
var this__4460__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__14706,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4467__auto__,(0)),cljs.core._nth(entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write(writer__4506__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__14710){
var extmap__4501__auto__ = (function (){var G__14760 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__14710,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__14710)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__14760);
} else {
return G__14760;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__14710),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__14710),null,cljs.core.not_empty(extmap__4501__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4692__auto__ = opts;
var l__4693__auto__ = a__4692__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4693__auto__)){
var G__15100 = (i + (1));
var G__15101 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__15100;
ret = G__15101;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__14785){
var vec__14786 = p__14785;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14786,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14786,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__14794 = arguments.length;
switch (G__14794) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5751__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5751__auto__)){
var child = temp__5751__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__15103 = ps;
var G__15104 = (i + (1));
el__$1 = G__15103;
i = G__15104;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__14817 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14817,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14817,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14817,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__14820_15105 = cljs.core.seq(props);
var chunk__14821_15106 = null;
var count__14822_15107 = (0);
var i__14823_15108 = (0);
while(true){
if((i__14823_15108 < count__14822_15107)){
var vec__14830_15109 = chunk__14821_15106.cljs$core$IIndexed$_nth$arity$2(null,i__14823_15108);
var k_15110 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14830_15109,(0),null);
var v_15111 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14830_15109,(1),null);
el.setAttributeNS((function (){var temp__5753__auto__ = cljs.core.namespace(k_15110);
if(cljs.core.truth_(temp__5753__auto__)){
var ns = temp__5753__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_15110),v_15111);


var G__15112 = seq__14820_15105;
var G__15113 = chunk__14821_15106;
var G__15114 = count__14822_15107;
var G__15115 = (i__14823_15108 + (1));
seq__14820_15105 = G__15112;
chunk__14821_15106 = G__15113;
count__14822_15107 = G__15114;
i__14823_15108 = G__15115;
continue;
} else {
var temp__5753__auto___15116 = cljs.core.seq(seq__14820_15105);
if(temp__5753__auto___15116){
var seq__14820_15117__$1 = temp__5753__auto___15116;
if(cljs.core.chunked_seq_QMARK_(seq__14820_15117__$1)){
var c__4638__auto___15118 = cljs.core.chunk_first(seq__14820_15117__$1);
var G__15119 = cljs.core.chunk_rest(seq__14820_15117__$1);
var G__15120 = c__4638__auto___15118;
var G__15121 = cljs.core.count(c__4638__auto___15118);
var G__15122 = (0);
seq__14820_15105 = G__15119;
chunk__14821_15106 = G__15120;
count__14822_15107 = G__15121;
i__14823_15108 = G__15122;
continue;
} else {
var vec__14833_15123 = cljs.core.first(seq__14820_15117__$1);
var k_15124 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14833_15123,(0),null);
var v_15125 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14833_15123,(1),null);
el.setAttributeNS((function (){var temp__5753__auto____$1 = cljs.core.namespace(k_15124);
if(cljs.core.truth_(temp__5753__auto____$1)){
var ns = temp__5753__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_15124),v_15125);


var G__15126 = cljs.core.next(seq__14820_15117__$1);
var G__15127 = null;
var G__15128 = (0);
var G__15129 = (0);
seq__14820_15105 = G__15126;
chunk__14821_15106 = G__15127;
count__14822_15107 = G__15128;
i__14823_15108 = G__15129;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__14837 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14837,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14837,(1),null);
var seq__14840_15130 = cljs.core.seq(node_children);
var chunk__14842_15131 = null;
var count__14843_15132 = (0);
var i__14844_15133 = (0);
while(true){
if((i__14844_15133 < count__14843_15132)){
var child_struct_15134 = chunk__14842_15131.cljs$core$IIndexed$_nth$arity$2(null,i__14844_15133);
if((!((child_struct_15134 == null)))){
if(typeof child_struct_15134 === 'string'){
var text_15135 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_15135),child_struct_15134].join(''));
} else {
var children_15136 = shadow.dom.svg_node(child_struct_15134);
if(cljs.core.seq_QMARK_(children_15136)){
var seq__14858_15137 = cljs.core.seq(children_15136);
var chunk__14860_15138 = null;
var count__14861_15139 = (0);
var i__14862_15140 = (0);
while(true){
if((i__14862_15140 < count__14861_15139)){
var child_15141 = chunk__14860_15138.cljs$core$IIndexed$_nth$arity$2(null,i__14862_15140);
if(cljs.core.truth_(child_15141)){
node.appendChild(child_15141);


var G__15142 = seq__14858_15137;
var G__15143 = chunk__14860_15138;
var G__15144 = count__14861_15139;
var G__15145 = (i__14862_15140 + (1));
seq__14858_15137 = G__15142;
chunk__14860_15138 = G__15143;
count__14861_15139 = G__15144;
i__14862_15140 = G__15145;
continue;
} else {
var G__15146 = seq__14858_15137;
var G__15147 = chunk__14860_15138;
var G__15148 = count__14861_15139;
var G__15149 = (i__14862_15140 + (1));
seq__14858_15137 = G__15146;
chunk__14860_15138 = G__15147;
count__14861_15139 = G__15148;
i__14862_15140 = G__15149;
continue;
}
} else {
var temp__5753__auto___15150 = cljs.core.seq(seq__14858_15137);
if(temp__5753__auto___15150){
var seq__14858_15151__$1 = temp__5753__auto___15150;
if(cljs.core.chunked_seq_QMARK_(seq__14858_15151__$1)){
var c__4638__auto___15152 = cljs.core.chunk_first(seq__14858_15151__$1);
var G__15153 = cljs.core.chunk_rest(seq__14858_15151__$1);
var G__15154 = c__4638__auto___15152;
var G__15155 = cljs.core.count(c__4638__auto___15152);
var G__15156 = (0);
seq__14858_15137 = G__15153;
chunk__14860_15138 = G__15154;
count__14861_15139 = G__15155;
i__14862_15140 = G__15156;
continue;
} else {
var child_15157 = cljs.core.first(seq__14858_15151__$1);
if(cljs.core.truth_(child_15157)){
node.appendChild(child_15157);


var G__15158 = cljs.core.next(seq__14858_15151__$1);
var G__15159 = null;
var G__15160 = (0);
var G__15161 = (0);
seq__14858_15137 = G__15158;
chunk__14860_15138 = G__15159;
count__14861_15139 = G__15160;
i__14862_15140 = G__15161;
continue;
} else {
var G__15162 = cljs.core.next(seq__14858_15151__$1);
var G__15163 = null;
var G__15164 = (0);
var G__15165 = (0);
seq__14858_15137 = G__15162;
chunk__14860_15138 = G__15163;
count__14861_15139 = G__15164;
i__14862_15140 = G__15165;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_15136);
}
}


var G__15166 = seq__14840_15130;
var G__15167 = chunk__14842_15131;
var G__15168 = count__14843_15132;
var G__15169 = (i__14844_15133 + (1));
seq__14840_15130 = G__15166;
chunk__14842_15131 = G__15167;
count__14843_15132 = G__15168;
i__14844_15133 = G__15169;
continue;
} else {
var G__15170 = seq__14840_15130;
var G__15171 = chunk__14842_15131;
var G__15172 = count__14843_15132;
var G__15173 = (i__14844_15133 + (1));
seq__14840_15130 = G__15170;
chunk__14842_15131 = G__15171;
count__14843_15132 = G__15172;
i__14844_15133 = G__15173;
continue;
}
} else {
var temp__5753__auto___15174 = cljs.core.seq(seq__14840_15130);
if(temp__5753__auto___15174){
var seq__14840_15175__$1 = temp__5753__auto___15174;
if(cljs.core.chunked_seq_QMARK_(seq__14840_15175__$1)){
var c__4638__auto___15176 = cljs.core.chunk_first(seq__14840_15175__$1);
var G__15177 = cljs.core.chunk_rest(seq__14840_15175__$1);
var G__15178 = c__4638__auto___15176;
var G__15179 = cljs.core.count(c__4638__auto___15176);
var G__15180 = (0);
seq__14840_15130 = G__15177;
chunk__14842_15131 = G__15178;
count__14843_15132 = G__15179;
i__14844_15133 = G__15180;
continue;
} else {
var child_struct_15181 = cljs.core.first(seq__14840_15175__$1);
if((!((child_struct_15181 == null)))){
if(typeof child_struct_15181 === 'string'){
var text_15182 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_15182),child_struct_15181].join(''));
} else {
var children_15183 = shadow.dom.svg_node(child_struct_15181);
if(cljs.core.seq_QMARK_(children_15183)){
var seq__14864_15184 = cljs.core.seq(children_15183);
var chunk__14866_15185 = null;
var count__14867_15186 = (0);
var i__14868_15187 = (0);
while(true){
if((i__14868_15187 < count__14867_15186)){
var child_15188 = chunk__14866_15185.cljs$core$IIndexed$_nth$arity$2(null,i__14868_15187);
if(cljs.core.truth_(child_15188)){
node.appendChild(child_15188);


var G__15189 = seq__14864_15184;
var G__15190 = chunk__14866_15185;
var G__15191 = count__14867_15186;
var G__15192 = (i__14868_15187 + (1));
seq__14864_15184 = G__15189;
chunk__14866_15185 = G__15190;
count__14867_15186 = G__15191;
i__14868_15187 = G__15192;
continue;
} else {
var G__15193 = seq__14864_15184;
var G__15194 = chunk__14866_15185;
var G__15195 = count__14867_15186;
var G__15196 = (i__14868_15187 + (1));
seq__14864_15184 = G__15193;
chunk__14866_15185 = G__15194;
count__14867_15186 = G__15195;
i__14868_15187 = G__15196;
continue;
}
} else {
var temp__5753__auto___15197__$1 = cljs.core.seq(seq__14864_15184);
if(temp__5753__auto___15197__$1){
var seq__14864_15198__$1 = temp__5753__auto___15197__$1;
if(cljs.core.chunked_seq_QMARK_(seq__14864_15198__$1)){
var c__4638__auto___15199 = cljs.core.chunk_first(seq__14864_15198__$1);
var G__15200 = cljs.core.chunk_rest(seq__14864_15198__$1);
var G__15201 = c__4638__auto___15199;
var G__15202 = cljs.core.count(c__4638__auto___15199);
var G__15203 = (0);
seq__14864_15184 = G__15200;
chunk__14866_15185 = G__15201;
count__14867_15186 = G__15202;
i__14868_15187 = G__15203;
continue;
} else {
var child_15204 = cljs.core.first(seq__14864_15198__$1);
if(cljs.core.truth_(child_15204)){
node.appendChild(child_15204);


var G__15205 = cljs.core.next(seq__14864_15198__$1);
var G__15206 = null;
var G__15207 = (0);
var G__15208 = (0);
seq__14864_15184 = G__15205;
chunk__14866_15185 = G__15206;
count__14867_15186 = G__15207;
i__14868_15187 = G__15208;
continue;
} else {
var G__15209 = cljs.core.next(seq__14864_15198__$1);
var G__15210 = null;
var G__15211 = (0);
var G__15212 = (0);
seq__14864_15184 = G__15209;
chunk__14866_15185 = G__15210;
count__14867_15186 = G__15211;
i__14868_15187 = G__15212;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_15183);
}
}


var G__15213 = cljs.core.next(seq__14840_15175__$1);
var G__15214 = null;
var G__15215 = (0);
var G__15216 = (0);
seq__14840_15130 = G__15213;
chunk__14842_15131 = G__15214;
count__14843_15132 = G__15215;
i__14844_15133 = G__15216;
continue;
} else {
var G__15217 = cljs.core.next(seq__14840_15175__$1);
var G__15218 = null;
var G__15219 = (0);
var G__15220 = (0);
seq__14840_15130 = G__15217;
chunk__14842_15131 = G__15218;
count__14843_15132 = G__15219;
i__14844_15133 = G__15220;
continue;
}
}
} else {
}
}
break;
}

return node;
});
goog.object.set(shadow.dom.SVGElement,"string",true);

goog.object.set(shadow.dom._to_svg,"string",(function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

goog.object.set(shadow.dom.SVGElement,"null",true);

goog.object.set(shadow.dom._to_svg,"null",(function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4824__auto__ = [];
var len__4818__auto___15221 = arguments.length;
var i__4819__auto___15222 = (0);
while(true){
if((i__4819__auto___15222 < len__4818__auto___15221)){
args__4824__auto__.push((arguments[i__4819__auto___15222]));

var G__15223 = (i__4819__auto___15222 + (1));
i__4819__auto___15222 = G__15223;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq14870){
var G__14871 = cljs.core.first(seq14870);
var seq14870__$1 = cljs.core.next(seq14870);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14871,seq14870__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__14873 = arguments.length;
switch (G__14873) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__4210__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4210__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4210__auto__;
}
})())){
var c__12619__auto___15225 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12620__auto__ = (function (){var switch__12583__auto__ = (function (state_14878){
var state_val_14879 = (state_14878[(1)]);
if((state_val_14879 === (1))){
var state_14878__$1 = state_14878;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14878__$1,(2),once_or_cleanup);
} else {
if((state_val_14879 === (2))){
var inst_14875 = (state_14878[(2)]);
var inst_14876 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_14878__$1 = (function (){var statearr_14880 = state_14878;
(statearr_14880[(7)] = inst_14875);

return statearr_14880;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_14878__$1,inst_14876);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__12584__auto__ = null;
var shadow$dom$state_machine__12584__auto____0 = (function (){
var statearr_14881 = [null,null,null,null,null,null,null,null];
(statearr_14881[(0)] = shadow$dom$state_machine__12584__auto__);

(statearr_14881[(1)] = (1));

return statearr_14881;
});
var shadow$dom$state_machine__12584__auto____1 = (function (state_14878){
while(true){
var ret_value__12585__auto__ = (function (){try{while(true){
var result__12586__auto__ = switch__12583__auto__(state_14878);
if(cljs.core.keyword_identical_QMARK_(result__12586__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12586__auto__;
}
break;
}
}catch (e14882){var ex__12587__auto__ = e14882;
var statearr_14883_15226 = state_14878;
(statearr_14883_15226[(2)] = ex__12587__auto__);


if(cljs.core.seq((state_14878[(4)]))){
var statearr_14884_15227 = state_14878;
(statearr_14884_15227[(1)] = cljs.core.first((state_14878[(4)])));

} else {
throw ex__12587__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12585__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15228 = state_14878;
state_14878 = G__15228;
continue;
} else {
return ret_value__12585__auto__;
}
break;
}
});
shadow$dom$state_machine__12584__auto__ = function(state_14878){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__12584__auto____0.call(this);
case 1:
return shadow$dom$state_machine__12584__auto____1.call(this,state_14878);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__12584__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__12584__auto____0;
shadow$dom$state_machine__12584__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__12584__auto____1;
return shadow$dom$state_machine__12584__auto__;
})()
})();
var state__12621__auto__ = (function (){var statearr_14885 = f__12620__auto__();
(statearr_14885[(6)] = c__12619__auto___15225);

return statearr_14885;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12621__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
