/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import net.razorvine.pickle.PickleException;
import net.razorvine.pickle.Unpickler;
import net.razorvine.pickle.objects.ClassDict;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.SimpleWeightedGraph;
import org.jgrapht.graph.builder.GraphBuilder;

public interface NetworkXFormat {
    public static ClassDict parse(InputStream stream) throws IOException {
        return (ClassDict)new Unpickler().load(Objects.requireNonNull(stream));
    }

    public static Graph<Object, DefaultWeightedEdge> load(ClassDict nx) {
        Objects.requireNonNull(nx);
        if (!nx.get("__class__").equals("networkx.classes.graph.Graph")) {
            throw new PickleException("graph is not networkx.classes.graph.Graph");
        }
        GraphBuilder builder = SimpleWeightedGraph.createBuilder(DefaultWeightedEdge.class);
        Map nodes = (Map)nx.get("_node");
        for (Object node : nodes.keySet()) {
            builder.addVertex(node);
        }
        Map edges = (Map)nx.get("_adj");
        for (Map.Entry source : edges.entrySet()) {
            for (Object target : ((Map)source.getValue()).keySet()) {
                builder.addEdge(source.getKey(), target);
            }
        }
        return builder.build();
    }
}

