/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.util;

import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.graph.SimpleWeightedGraph;
import org.jgrapht.graph.builder.GraphBuilder;

public interface Neighbors {
    public static <V, E> Iterator<V> neighborIterator(Graph<V, E> graph, V node) {
        return graph.edgesOf(node).stream().map(e -> Graphs.getOppositeVertex(graph, e, node)).iterator();
    }

    public static <V, E> Set<V> neighborSetOf(Graph<V, E> graph, V node) {
        return graph.edgesOf(node).stream().map(e -> Graphs.getOppositeVertex(graph, e, node)).collect(Collectors.toSet());
    }

    public static <V, E> Graph<V, E> neighborhoodGraph(Graph<V, E> graph, V node) {
        GraphBuilder<V, E, SimpleWeightedGraph<V, E>> builder = SimpleWeightedGraph.createBuilder(graph.getEdgeSupplier());
        Set<V> neighborhood = Neighbors.neighborSetOf(graph, node);
        neighborhood.forEach(builder::addVertex);
        for (V neighbor : neighborhood) {
            for (E edge : graph.edgesOf(neighbor)) {
                V source = graph.getEdgeSource(edge);
                V target = graph.getEdgeTarget(edge);
                if (!neighborhood.contains(source) || !neighborhood.contains(target)) continue;
                double weight = graph.getEdgeWeight(edge);
                builder.addEdge(source, target, edge, weight);
            }
        }
        return builder.buildAsUnmodifiable();
    }
}

