goog.provide('atlas_ui.sidebar');
atlas_ui.sidebar.definition_entries = (function atlas_ui$sidebar$definition_entries(props,identity){
var definition_keys = atlas.ontology.definition_keys_for_identity(identity);
if(cljs.core.seq(definition_keys)){
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2((function (k){
if(cljs.core.contains_QMARK_(props,k)){
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$2(props,k);
if((!((v == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null);
} else {
return null;
}
} else {
return null;
}
}),definition_keys);
} else {
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.key),cljs.core.remove.cljs$core$IFn$_invoke$arity$2((function (p__18947){
var vec__18948 = p__18947;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18948,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18948,(1),null);
return (v == null);
}),props));
}
});
/**
 * Render an aspect as a styled tag
 */
atlas_ui.sidebar.aspect_tag = (function atlas_ui$sidebar$aspect_tag(aspect){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.aspect-tag","span.aspect-tag",55501450),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.str.cljs$core$IFn$_invoke$arity$1(aspect),new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"borderRadius","borderRadius",-1505621083),new cljs.core.Keyword(null,"fontFamily","fontFamily",1493518353),new cljs.core.Keyword(null,"padding","padding",1660304693),new cljs.core.Keyword(null,"display","display",242065432),new cljs.core.Keyword(null,"fontSize","fontSize",919623033),new cljs.core.Keyword(null,"border","border",1444987323),new cljs.core.Keyword(null,"backgroundColor","backgroundColor",1738438491),new cljs.core.Keyword(null,"margin","margin",-995903681)],["#6b7280","12px","ui-monospace, monospace","4px 10px","inline-block","11px","1px solid #e5e7eb","#f3f4f6","4px 4px 4px 0"])], null),cljs.core.str.cljs$core$IFn$_invoke$arity$1(aspect)], null);
});
atlas_ui.sidebar.value_tag = (function atlas_ui$sidebar$value_tag(value,on_click){
var clickable_QMARK_ = (!((on_click == null)));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.value-tag","span.value-tag",148382889),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"borderRadius","borderRadius",-1505621083),new cljs.core.Keyword(null,"cursor","cursor",1011937484),new cljs.core.Keyword(null,"fontFamily","fontFamily",1493518353),new cljs.core.Keyword(null,"padding","padding",1660304693),new cljs.core.Keyword(null,"display","display",242065432),new cljs.core.Keyword(null,"fontSize","fontSize",919623033),new cljs.core.Keyword(null,"border","border",1444987323),new cljs.core.Keyword(null,"backgroundColor","backgroundColor",1738438491),new cljs.core.Keyword(null,"margin","margin",-995903681)],["#374151","10px",((clickable_QMARK_)?"pointer":null),"ui-monospace, monospace","4px 10px","inline-block","11px","1px solid #e5e7eb",((clickable_QMARK_)?"#e0e7ff":"#f3f4f6"),"4px 6px 4px 0"]),new cljs.core.Keyword(null,"on-click","on-click",1632826543),((clickable_QMARK_)?(function (){
return (on_click.cljs$core$IFn$_invoke$arity$1 ? on_click.cljs$core$IFn$_invoke$arity$1(value) : on_click.call(null,value));
}):null)], null),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value)], null);
});
atlas_ui.sidebar.ordered_items = (function atlas_ui$sidebar$ordered_items(value){
if(cljs.core.set_QMARK_(value)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$1(value);
} else {
if(cljs.core.sequential_QMARK_(value)){
return value;
} else {
return null;

}
}
});
atlas_ui.sidebar.keyword_items_QMARK_ = (function atlas_ui$sidebar$keyword_items_QMARK_(items){
return ((cljs.core.seq(items)) && (cljs.core.every_QMARK_(cljs.core.keyword_QMARK_,items)));
});
atlas_ui.sidebar.render_value = (function atlas_ui$sidebar$render_value(value,on_click,clickable_QMARK_){
if((value instanceof cljs.core.Keyword)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui.sidebar.value_tag,value,(cljs.core.truth_((clickable_QMARK_.cljs$core$IFn$_invoke$arity$1 ? clickable_QMARK_.cljs$core$IFn$_invoke$arity$1(value) : clickable_QMARK_.call(null,value)))?on_click:null)], null);
} else {
if(cljs.core.map_QMARK_(value)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"flexDirection","flexDirection",1286039598),"column",new cljs.core.Keyword(null,"gap","gap",80255254),"6px"], null)], null),(function (){var iter__5480__auto__ = (function atlas_ui$sidebar$render_value_$_iter__18953(s__18954){
return (new cljs.core.LazySeq(null,(function (){
var s__18954__$1 = s__18954;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__18954__$1);
if(temp__5804__auto__){
var s__18954__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__18954__$2)){
var c__5478__auto__ = cljs.core.chunk_first(s__18954__$2);
var size__5479__auto__ = cljs.core.count(c__5478__auto__);
var b__18956 = cljs.core.chunk_buffer(size__5479__auto__);
if((function (){var i__18955 = (0);
while(true){
if((i__18955 < size__5479__auto__)){
var vec__18961 = cljs.core._nth(c__5478__auto__,i__18955);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18961,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18961,(1),null);
cljs.core.chunk_append(b__18956,cljs.core.with_meta(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"gap","gap",80255254),"8px",new cljs.core.Keyword(null,"alignItems","alignItems",410331199),"baseline"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"fontFamily","fontFamily",1493518353),"ui-monospace, monospace",new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"11px",new cljs.core.Keyword(null,"color","color",1011675173),"#6b7280",new cljs.core.Keyword(null,"minWidth","minWidth",-204293526),"120px"], null)], null),cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui.sidebar.render_value,v,on_click,clickable_QMARK_], null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)], null)));

var G__19060 = (i__18955 + (1));
i__18955 = G__19060;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__18956),atlas_ui$sidebar$render_value_$_iter__18953(cljs.core.chunk_rest(s__18954__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__18956),null);
}
} else {
var vec__18964 = cljs.core.first(s__18954__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18964,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18964,(1),null);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"gap","gap",80255254),"8px",new cljs.core.Keyword(null,"alignItems","alignItems",410331199),"baseline"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"fontFamily","fontFamily",1493518353),"ui-monospace, monospace",new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"11px",new cljs.core.Keyword(null,"color","color",1011675173),"#6b7280",new cljs.core.Keyword(null,"minWidth","minWidth",-204293526),"120px"], null)], null),cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui.sidebar.render_value,v,on_click,clickable_QMARK_], null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)], null)),atlas_ui$sidebar$render_value_$_iter__18953(cljs.core.rest(s__18954__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5480__auto__(cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.key),value));
})()], null);
} else {
var temp__5802__auto__ = atlas_ui.sidebar.ordered_items(value);
if(cljs.core.truth_(temp__5802__auto__)){
var items = temp__5802__auto__;
if(atlas_ui.sidebar.keyword_items_QMARK_(items)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"flexWrap","flexWrap",-1972563518),"wrap"], null)], null),(function (){var iter__5480__auto__ = (function atlas_ui$sidebar$render_value_$_iter__18995(s__18996){
return (new cljs.core.LazySeq(null,(function (){
var s__18996__$1 = s__18996;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__18996__$1);
if(temp__5804__auto__){
var s__18996__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__18996__$2)){
var c__5478__auto__ = cljs.core.chunk_first(s__18996__$2);
var size__5479__auto__ = cljs.core.count(c__5478__auto__);
var b__18998 = cljs.core.chunk_buffer(size__5479__auto__);
if((function (){var i__18997 = (0);
while(true){
if((i__18997 < size__5479__auto__)){
var item = cljs.core._nth(c__5478__auto__,i__18997);
cljs.core.chunk_append(b__18998,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui.sidebar.value_tag,item,(cljs.core.truth_((clickable_QMARK_.cljs$core$IFn$_invoke$arity$1 ? clickable_QMARK_.cljs$core$IFn$_invoke$arity$1(item) : clickable_QMARK_.call(null,item)))?on_click:null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.str.cljs$core$IFn$_invoke$arity$1(item)], null)));

var G__19061 = (i__18997 + (1));
i__18997 = G__19061;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__18998),atlas_ui$sidebar$render_value_$_iter__18995(cljs.core.chunk_rest(s__18996__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__18998),null);
}
} else {
var item = cljs.core.first(s__18996__$2);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui.sidebar.value_tag,item,(cljs.core.truth_((clickable_QMARK_.cljs$core$IFn$_invoke$arity$1 ? clickable_QMARK_.cljs$core$IFn$_invoke$arity$1(item) : clickable_QMARK_.call(null,item)))?on_click:null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.str.cljs$core$IFn$_invoke$arity$1(item)], null)),atlas_ui$sidebar$render_value_$_iter__18995(cljs.core.rest(s__18996__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5480__auto__(items);
})()], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"flexDirection","flexDirection",1286039598),"column",new cljs.core.Keyword(null,"gap","gap",80255254),"4px"], null)], null),(function (){var iter__5480__auto__ = (function atlas_ui$sidebar$render_value_$_iter__19008(s__19009){
return (new cljs.core.LazySeq(null,(function (){
var s__19009__$1 = s__19009;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__19009__$1);
if(temp__5804__auto__){
var s__19009__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__19009__$2)){
var c__5478__auto__ = cljs.core.chunk_first(s__19009__$2);
var size__5479__auto__ = cljs.core.count(c__5478__auto__);
var b__19011 = cljs.core.chunk_buffer(size__5479__auto__);
if((function (){var i__19010 = (0);
while(true){
if((i__19010 < size__5479__auto__)){
var item = cljs.core._nth(c__5478__auto__,i__19010);
cljs.core.chunk_append(b__19011,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fontFamily","fontFamily",1493518353),"ui-monospace, monospace",new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"11px",new cljs.core.Keyword(null,"color","color",1011675173),"#374151"], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui.sidebar.render_value,item,on_click,clickable_QMARK_], null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.str.cljs$core$IFn$_invoke$arity$1(item)], null)));

var G__19062 = (i__19010 + (1));
i__19010 = G__19062;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__19011),atlas_ui$sidebar$render_value_$_iter__19008(cljs.core.chunk_rest(s__19009__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__19011),null);
}
} else {
var item = cljs.core.first(s__19009__$2);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fontFamily","fontFamily",1493518353),"ui-monospace, monospace",new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"11px",new cljs.core.Keyword(null,"color","color",1011675173),"#374151"], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui.sidebar.render_value,item,on_click,clickable_QMARK_], null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.str.cljs$core$IFn$_invoke$arity$1(item)], null)),atlas_ui$sidebar$render_value_$_iter__19008(cljs.core.rest(s__19009__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5480__auto__(items);
})()], null);
}
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fontFamily","fontFamily",1493518353),"ui-monospace, monospace",new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"11px",new cljs.core.Keyword(null,"color","color",1011675173),"#374151"], null)], null),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value)], null);
}

}
}
});
/**
 * Display entity type as a colored badge with proper formatting.
 * Uses the color from the entity-type-colors palette.
 */
atlas_ui.sidebar.entity_type_badge = (function atlas_ui$sidebar$entity_type_badge(entity_type){
if(cljs.core.truth_(entity_type)){
var type_color = cljs.core.get.cljs$core$IFn$_invoke$arity$3(atlas_ui.colors_v2.entity_type_colors,entity_type,new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(atlas_ui.colors_v2.entity_type_colors));
var type_name = cljs.core.name(entity_type);
var formatted_name = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.capitalize,clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.replace(type_name,/-/," "),/\//)),/ /)));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"borderRadius","borderRadius",-1505621083),new cljs.core.Keyword(null,"marginTop","marginTop",-1403015220),new cljs.core.Keyword(null,"padding","padding",1660304693),new cljs.core.Keyword(null,"fontWeight","fontWeight",166450581),new cljs.core.Keyword(null,"display","display",242065432),new cljs.core.Keyword(null,"fontSize","fontSize",919623033),new cljs.core.Keyword(null,"boxShadow","boxShadow",-1591689862),new cljs.core.Keyword(null,"backgroundColor","backgroundColor",1738438491),new cljs.core.Keyword(null,"alignItems","alignItems",410331199)],["#1f2937","6px","8px","4px 12px","600","inline-flex","12px","0 1px 2px rgba(0, 0, 0, 0.05)",type_color,"center"])], null),formatted_name], null);
} else {
return null;
}
});
/**
 * Detail panel for an entity.
 * Enhanced in Phase 2 to display type badge and separate aspects.
 */
atlas_ui.sidebar.entity_detail = (function atlas_ui$sidebar$entity_detail(entity,graph_data,registry,on_toggle_aspect,on_select_entity){
var props = new cljs.core.Keyword("atlas-ui.graph.node","props","atlas-ui.graph.node/props",465997681).cljs$core$IFn$_invoke$arity$1(entity);
var entity_type = new cljs.core.Keyword("atlas-ui.graph.node","entity-type","atlas-ui.graph.node/entity-type",-1912090483).cljs$core$IFn$_invoke$arity$1(entity);
var aspects = (function (){var or__5002__auto__ = new cljs.core.Keyword("atlas-ui.graph.node","aspects","atlas-ui.graph.node/aspects",1959787835).cljs$core$IFn$_invoke$arity$1(entity);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return new cljs.core.Keyword("atlas-ui.graph.node","identity","atlas-ui.graph.node/identity",1626823993).cljs$core$IFn$_invoke$arity$1(entity);
}
})();
var full_identity = new cljs.core.Keyword("atlas-ui.graph.node","identity","atlas-ui.graph.node/identity",1626823993).cljs$core$IFn$_invoke$arity$1(entity);
var entity_ids = cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("atlas-ui.graph.node","id","atlas-ui.graph.node/id",-1392721478),new cljs.core.Keyword("atlas-ui.graph.data","entities","atlas-ui.graph.data/entities",-1980533303).cljs$core$IFn$_invoke$arity$1(graph_data)));
var aspect_ids = cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("atlas-ui.graph.node","id","atlas-ui.graph.node/id",-1392721478),new cljs.core.Keyword("atlas-ui.graph.data","aspects","atlas-ui.graph.data/aspects",1960033811).cljs$core$IFn$_invoke$arity$1(graph_data)));
var clickable_QMARK_ = (function (value){
return ((cljs.core.contains_QMARK_(entity_ids,value)) || (cljs.core.contains_QMARK_(aspect_ids,value)));
});
var on_click = (function (value){
if(cljs.core.truth_((function (){var and__5000__auto__ = on_select_entity;
if(cljs.core.truth_(and__5000__auto__)){
return cljs.core.contains_QMARK_(entity_ids,value);
} else {
return and__5000__auto__;
}
})())){
var temp__5804__auto__ = atlas_ui.graph_data.find_node_by_id(graph_data,value);
if(cljs.core.truth_(temp__5804__auto__)){
var node = temp__5804__auto__;
return (on_select_entity.cljs$core$IFn$_invoke$arity$1 ? on_select_entity.cljs$core$IFn$_invoke$arity$1(node) : on_select_entity.call(null,node));
} else {
return null;
}
} else {
if(cljs.core.truth_((function (){var and__5000__auto__ = on_toggle_aspect;
if(cljs.core.truth_(and__5000__auto__)){
return cljs.core.contains_QMARK_(aspect_ids,value);
} else {
return and__5000__auto__;
}
})())){
return (on_toggle_aspect.cljs$core$IFn$_invoke$arity$1 ? on_toggle_aspect.cljs$core$IFn$_invoke$arity$1(value) : on_toggle_aspect.call(null,value));
} else {
return null;

}
}
});
var entries = atlas_ui.sidebar.definition_entries(props,full_identity);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.entity-detail","div.entity-detail",1432163776),(cljs.core.truth_(entity_type)?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),"20px"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h3","h3",2067611163),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"13px",new cljs.core.Keyword(null,"color","color",1011675173),"#6b7280",new cljs.core.Keyword(null,"textTransform","textTransform",-1959669529),"uppercase",new cljs.core.Keyword(null,"letterSpacing","letterSpacing",-1331934989),"0.05em",new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),"4px"], null)], null),"Entity Type"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui.sidebar.entity_type_badge,entity_type], null)], null):null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),"20px"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h3","h3",2067611163),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"13px",new cljs.core.Keyword(null,"color","color",1011675173),"#6b7280",new cljs.core.Keyword(null,"textTransform","textTransform",-1959669529),"uppercase",new cljs.core.Keyword(null,"letterSpacing","letterSpacing",-1331934989),"0.05em",new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),"8px"], null)], null),["Aspects",((cljs.core.seq(aspects))?[" (",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(aspects)),")"].join(''):null)].join('')], null),((cljs.core.seq(aspects))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"flexWrap","flexWrap",-1972563518),"wrap"], null)], null),(function (){var iter__5480__auto__ = (function atlas_ui$sidebar$entity_detail_$_iter__19044(s__19045){
return (new cljs.core.LazySeq(null,(function (){
var s__19045__$1 = s__19045;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__19045__$1);
if(temp__5804__auto__){
var s__19045__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__19045__$2)){
var c__5478__auto__ = cljs.core.chunk_first(s__19045__$2);
var size__5479__auto__ = cljs.core.count(c__5478__auto__);
var b__19047 = cljs.core.chunk_buffer(size__5479__auto__);
if((function (){var i__19046 = (0);
while(true){
if((i__19046 < size__5479__auto__)){
var aspect = cljs.core._nth(c__5478__auto__,i__19046);
cljs.core.chunk_append(b__19047,cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui.sidebar.aspect_tag,aspect], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.str.cljs$core$IFn$_invoke$arity$1(aspect)], null)));

var G__19063 = (i__19046 + (1));
i__19046 = G__19063;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__19047),atlas_ui$sidebar$entity_detail_$_iter__19044(cljs.core.chunk_rest(s__19045__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__19047),null);
}
} else {
var aspect = cljs.core.first(s__19045__$2);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui.sidebar.aspect_tag,aspect], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.str.cljs$core$IFn$_invoke$arity$1(aspect)], null)),atlas_ui$sidebar$entity_detail_$_iter__19044(cljs.core.rest(s__19045__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5480__auto__(cljs.core.sort.cljs$core$IFn$_invoke$arity$1(aspects));
})()], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"12px",new cljs.core.Keyword(null,"color","color",1011675173),"#9ca3af",new cljs.core.Keyword(null,"fontStyle","fontStyle",1246842165),"italic"], null)], null),"No aspects"], null))], null),((cljs.core.seq(entries))?(function (){var iter__5480__auto__ = (function atlas_ui$sidebar$entity_detail_$_iter__19048(s__19049){
return (new cljs.core.LazySeq(null,(function (){
var s__19049__$1 = s__19049;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__19049__$1);
if(temp__5804__auto__){
var s__19049__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__19049__$2)){
var c__5478__auto__ = cljs.core.chunk_first(s__19049__$2);
var size__5479__auto__ = cljs.core.count(c__5478__auto__);
var b__19051 = cljs.core.chunk_buffer(size__5479__auto__);
if((function (){var i__19050 = (0);
while(true){
if((i__19050 < size__5479__auto__)){
var vec__19052 = cljs.core._nth(c__5478__auto__,i__19050);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19052,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19052,(1),null);
cljs.core.chunk_append(b__19051,cljs.core.with_meta(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),"18px"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h3","h3",2067611163),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"13px",new cljs.core.Keyword(null,"color","color",1011675173),"#6b7280",new cljs.core.Keyword(null,"textTransform","textTransform",-1959669529),"uppercase",new cljs.core.Keyword(null,"letterSpacing","letterSpacing",-1331934989),"0.05em",new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),"8px"], null)], null),cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui.sidebar.render_value,v,on_click,clickable_QMARK_], null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)], null)));

var G__19066 = (i__19050 + (1));
i__19050 = G__19066;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__19051),atlas_ui$sidebar$entity_detail_$_iter__19048(cljs.core.chunk_rest(s__19049__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__19051),null);
}
} else {
var vec__19055 = cljs.core.first(s__19049__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19055,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19055,(1),null);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),"18px"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h3","h3",2067611163),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"13px",new cljs.core.Keyword(null,"color","color",1011675173),"#6b7280",new cljs.core.Keyword(null,"textTransform","textTransform",-1959669529),"uppercase",new cljs.core.Keyword(null,"letterSpacing","letterSpacing",-1331934989),"0.05em",new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),"8px"], null)], null),cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui.sidebar.render_value,v,on_click,clickable_QMARK_], null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)], null)),atlas_ui$sidebar$entity_detail_$_iter__19048(cljs.core.rest(s__19049__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5480__auto__(entries);
})():null)], null);
});
/**
 * Sidebar showing details of entity (only shows for entities, not aspects)
 */
atlas_ui.sidebar.sidebar_component = (function atlas_ui$sidebar$sidebar_component(entity,graph_data,registry,on_close,on_toggle_aspect,on_select_entity){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.sidebar","div.sidebar",1454675964),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"width","width",-384071477),"380px",new cljs.core.Keyword(null,"height","height",1025178622),"100%",new cljs.core.Keyword(null,"backgroundColor","backgroundColor",1738438491),"#ffffff",new cljs.core.Keyword(null,"borderLeft","borderLeft",-1938358443),"1px solid #e5e7eb",new cljs.core.Keyword(null,"overflowY","overflowY",1522263150),"auto",new cljs.core.Keyword(null,"padding","padding",1660304693),"24px",new cljs.core.Keyword(null,"boxShadow","boxShadow",-1591689862),"-2px 0 8px rgba(0, 0, 0, 0.05)"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"justifyContent","justifyContent",885406515),"space-between",new cljs.core.Keyword(null,"alignItems","alignItems",410331199),"flex-start",new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),"24px",new cljs.core.Keyword(null,"paddingBottom","paddingBottom",-916694489),"16px",new cljs.core.Keyword(null,"borderBottom","borderBottom",1676563277),"2px solid #e5e7eb"], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"flex","flex",-1425124628),"1"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h2","h2",-372662728),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"18px",new cljs.core.Keyword(null,"fontWeight","fontWeight",166450581),"600",new cljs.core.Keyword(null,"color","color",1011675173),"#111827",new cljs.core.Keyword(null,"margin","margin",-995903681),"0",new cljs.core.Keyword(null,"wordBreak","wordBreak",-1023554627),"break-all"], null)], null),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("atlas-ui.graph.node","id","atlas-ui.graph.node/id",-1392721478).cljs$core$IFn$_invoke$arity$1(entity))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"11px",new cljs.core.Keyword(null,"color","color",1011675173),"#9ca3af",new cljs.core.Keyword(null,"marginTop","marginTop",-1403015220),"4px",new cljs.core.Keyword(null,"textTransform","textTransform",-1959669529),"uppercase",new cljs.core.Keyword(null,"letterSpacing","letterSpacing",-1331934989),"0.05em"], null)], null),cljs.core.name(new cljs.core.Keyword("atlas-ui.graph.node","type","atlas-ui.graph.node/type",1053813014).cljs$core$IFn$_invoke$arity$1(entity))], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),on_close,new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"borderRadius","borderRadius",-1505621083),new cljs.core.Keyword(null,"transition","transition",765692007),new cljs.core.Keyword(null,"cursor","cursor",1011937484),new cljs.core.Keyword(null,"padding","padding",1660304693),new cljs.core.Keyword(null,"lineHeight","lineHeight",-1729831016),new cljs.core.Keyword(null,"fontSize","fontSize",919623033),new cljs.core.Keyword(null,"border","border",1444987323),new cljs.core.Keyword(null,"backgroundColor","backgroundColor",1738438491)],["#6b7280","6px","all 0.2s","pointer","6px 10px","1","16px","1px solid #e5e7eb","white"]),new cljs.core.Keyword(null,"on-mouse-over","on-mouse-over",-858472552),(function (p1__19058_SHARP_){
return (p1__19058_SHARP_.target.style.backgroundColor = "#f9fafb");
}),new cljs.core.Keyword(null,"on-mouse-out","on-mouse-out",643448647),(function (p1__19059_SHARP_){
return (p1__19059_SHARP_.target.style.backgroundColor = "white");
})], null),"\u00D7"], null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui.sidebar.entity_detail,entity,graph_data,registry,on_toggle_aspect,on_select_entity], null)], null)], null);
});

//# sourceMappingURL=atlas_ui.sidebar.js.map
