goog.provide('atlas_ui.lenses');
/**
 * Extract all values for a given aspect keyword from registry entities.
 * 
 *   Example: (extract-aspect-values registry :domain/*)
 *         => #{:domain/auth :domain/users :domain/scheduling}
 */
atlas_ui.lenses.extract_aspect_values = (function atlas_ui$lenses$extract_aspect_values(registry,aspect_ns){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((function (p__18667){
var vec__18668 = p__18667;
var identity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18668,(0),null);
var entity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18668,(1),null);
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__18661_SHARP_){
return (((p1__18661_SHARP_ instanceof cljs.core.Keyword)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(p1__18661_SHARP_),cljs.core.name(aspect_ns))));
}),identity);
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([registry], 0)));
});
/**
 * Check if an entity's identity contains the given aspect keyword.
 */
atlas_ui.lenses.entity_has_aspect_QMARK_ = (function atlas_ui$lenses$entity_has_aspect_QMARK_(identity_set,aspect_kw){
return cljs.core.contains_QMARK_(identity_set,aspect_kw);
});
/**
 * Find all entities that have the given aspect in their identity.
 */
atlas_ui.lenses.find_entities_by_aspect = (function atlas_ui$lenses$find_entities_by_aspect(registry,aspect_kw){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.second,cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p__18676){
var vec__18677 = p__18676;
var identity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18677,(0),null);
var entity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18677,(1),null);
return cljs.core.contains_QMARK_(identity,aspect_kw);
}),registry)));
});
/**
 * Find a single entity by its :atlas/dev-id.
 */
atlas_ui.lenses.find_entity_by_id = (function atlas_ui$lenses$find_entity_by_id(registry,dev_id){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__18680_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553).cljs$core$IFn$_invoke$arity$1(p1__18680_SHARP_),dev_id);
}),cljs.core.vals(registry)));
});
atlas_ui.lenses.first_present = (function atlas_ui$lenses$first_present(m,keys){
return cljs.core.some((function (k){
if(cljs.core.contains_QMARK_(m,k)){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
} else {
return null;
}
}),keys);
});
atlas_ui.lenses.find_prop = (function atlas_ui$lenses$find_prop(entity,keys){
var or__5002__auto__ = atlas_ui.lenses.first_present(entity,keys);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return atlas_ui.lenses.first_present(cljs.core.get.cljs$core$IFn$_invoke$arity$3(entity,new cljs.core.Keyword(null,"props","props",453281727),cljs.core.PersistentArrayMap.EMPTY),keys);
}
});
atlas_ui.lenses.deps_for_entity = (function atlas_ui$lenses$deps_for_entity(entity){
var deps = atlas_ui.lenses.find_prop(entity,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("interface-endpoint","deps","interface-endpoint/deps",-650127208),new cljs.core.Keyword("execution-function","deps","execution-function/deps",1183773524),new cljs.core.Keyword("structure-component","deps","structure-component/deps",742401310),new cljs.core.Keyword("semantic-namespace","deps","semantic-namespace/deps",552841771)], null));
if(cljs.core.set_QMARK_(deps)){
return deps;
} else {
if(cljs.core.coll_QMARK_(deps)){
return cljs.core.set(deps);
} else {
return cljs.core.PersistentHashSet.EMPTY;

}
}
});
atlas_ui.lenses.triggers_for_entity = (function atlas_ui$lenses$triggers_for_entity(entity){
return atlas_ui.lenses.find_prop(entity,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("interaction-intent","triggers","interaction-intent/triggers",897807111),new cljs.core.Keyword("semantic-namespace","triggers","semantic-namespace/triggers",1512099738)], null));
});
/**
 * Show all entities within a specific domain.
 * 
 *   Filters to show only entities that have the domain aspect in their identity.
 *   Uses hierarchical layout to show domain internal structure.
 * 
 *   Example: (domain-lens registry :domain/auth)
 *         => Shows only auth-related entities
 */
atlas_ui.lenses.domain_lens = (function atlas_ui$lenses$domain_lens(registry,domain_kw){
var entities = atlas_ui.lenses.find_entities_by_aspect(registry,domain_kw);
var entity_ids = cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553),entities));
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.Keyword(null,"layout-config","layout-config",-1439964126),new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"entities","entities",1940967403),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"title","title",636505583),new cljs.core.Keyword(null,"show-all-aspects?","show-all-aspects?",1768762674),new cljs.core.Keyword(null,"layout-mode","layout-mode",-1873376486),new cljs.core.Keyword(null,"entity-ids","entity-ids",-963844196)],[["Focused view of ",cljs.core.name(domain_kw)," domain"].join(''),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"directed","directed",1150765886),true,new cljs.core.Keyword(null,"spacingFactor","spacingFactor",-627033670),1.8,new cljs.core.Keyword(null,"animate","animate",1850194573),true,new cljs.core.Keyword(null,"animationDuration","animationDuration",-322932146),(500),new cljs.core.Keyword(null,"avoidOverlap","avoidOverlap",-2113241329),true,new cljs.core.Keyword(null,"nodeDimensionsIncludeLabels","nodeDimensionsIncludeLabels",-315344226),true], null),domain_kw,entities,new cljs.core.Keyword(null,"domain","domain",1847214937),["Domain: ",cljs.core.name(domain_kw)].join(''),false,new cljs.core.Keyword(null,"breadthfirst","breadthfirst",-1410812190),entity_ids]);
});
/**
 * Show all entities within a specific tier.
 * 
 *   Filters to show only entities in the given tier.
 *   Groups by domain within the tier.
 * 
 *   Example: (tier-lens registry :tier/service)
 *         => Shows all service layer entities grouped by domain
 */
atlas_ui.lenses.tier_lens = (function atlas_ui$lenses$tier_lens(registry,tier_kw){
var entities = atlas_ui.lenses.find_entities_by_aspect(registry,tier_kw);
var entity_ids = cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553),entities));
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.Keyword(null,"layout-config","layout-config",-1439964126),new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"entities","entities",1940967403),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"title","title",636505583),new cljs.core.Keyword(null,"show-all-aspects?","show-all-aspects?",1768762674),new cljs.core.Keyword(null,"layout-mode","layout-mode",-1873376486),new cljs.core.Keyword(null,"entity-ids","entity-ids",-963844196)],[["All entities in ",cljs.core.name(tier_kw)," tier"].join(''),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"cols","cols",-1914801295),(3),new cljs.core.Keyword(null,"animate","animate",1850194573),true,new cljs.core.Keyword(null,"animationDuration","animationDuration",-322932146),(500),new cljs.core.Keyword(null,"spacingFactor","spacingFactor",-627033670),1.5,new cljs.core.Keyword(null,"avoidOverlapPadding","avoidOverlapPadding",2097358454),(50)], null),tier_kw,entities,new cljs.core.Keyword(null,"tier","tier",-1071893374),["Tier: ",cljs.core.name(tier_kw)].join(''),false,new cljs.core.Keyword(null,"grid","grid",402978600),entity_ids]);
});
/**
 * Show entities implementing a specific protocol.
 * 
 *   Filters to show protocol definition and all components/functions that implement it.
 *   Uses concentric layout to show protocol at center with implementers in rings.
 * 
 *   Example: (protocol-lens registry :protocol/oauth)
 *         => Shows OAuth protocol and all implementers
 */
atlas_ui.lenses.protocol_lens = (function atlas_ui$lenses$protocol_lens(registry,protocol_kw){
var entities = atlas_ui.lenses.find_entities_by_aspect(registry,protocol_kw);
var entity_ids = cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553),entities));
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.Keyword(null,"layout-config","layout-config",-1439964126),new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"entities","entities",1940967403),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"title","title",636505583),new cljs.core.Keyword(null,"show-all-aspects?","show-all-aspects?",1768762674),new cljs.core.Keyword(null,"layout-mode","layout-mode",-1873376486),new cljs.core.Keyword(null,"entity-ids","entity-ids",-963844196)],[["Protocol ",cljs.core.name(protocol_kw)," and its implementations"].join(''),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"animate","animate",1850194573),true,new cljs.core.Keyword(null,"animationDuration","animationDuration",-322932146),(500),new cljs.core.Keyword(null,"spacingFactor","spacingFactor",-627033670),2.0,new cljs.core.Keyword(null,"minNodeSpacing","minNodeSpacing",-808054637),(80),new cljs.core.Keyword(null,"avoidOverlap","avoidOverlap",-2113241329),true], null),protocol_kw,entities,new cljs.core.Keyword(null,"protocol","protocol",652470118),["Protocol: ",cljs.core.name(protocol_kw)].join(''),false,new cljs.core.Keyword(null,"concentric","concentric",1339072636),entity_ids]);
});
/**
 * Show the flow from a UI intent through endpoints to functions.
 * 
 *   Traces the complete path from user intent to implementation.
 * 
 *   Example: (intent-lens registry :ui-intent/query-availability)
 *         => Shows intent → endpoint → functions flow
 */
atlas_ui.lenses.intent_lens = (function atlas_ui$lenses$intent_lens(registry,intent_id){
var intent = atlas_ui.lenses.find_entity_by_id(registry,intent_id);
var triggers = atlas_ui.lenses.triggers_for_entity(intent);
var endpoints = (cljs.core.truth_(triggers)?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((function (p1__18723_SHARP_){
return atlas_ui.lenses.find_entities_by_aspect(registry,p1__18723_SHARP_);
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([triggers], 0)):null);
var functions = (cljs.core.truth_(endpoints)?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((function (ep){
var deps = atlas_ui.lenses.deps_for_entity(ep);
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((function (p1__18728_SHARP_){
return atlas_ui.lenses.find_entities_by_aspect(registry,p1__18728_SHARP_);
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([deps], 0));
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([endpoints], 0)):null);
var all_entities = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [intent], null),endpoints,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([functions], 0)));
var entity_ids = cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553),all_entities));
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.Keyword(null,"layout-config","layout-config",-1439964126),new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"entities","entities",1940967403),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"title","title",636505583),new cljs.core.Keyword(null,"show-all-aspects?","show-all-aspects?",1768762674),new cljs.core.Keyword(null,"layout-mode","layout-mode",-1873376486),new cljs.core.Keyword(null,"entity-ids","entity-ids",-963844196)],[["Flow from ",cljs.core.name(intent_id)," to implementation"].join(''),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"directed","directed",1150765886),true,new cljs.core.Keyword(null,"spacingFactor","spacingFactor",-627033670),1.5,new cljs.core.Keyword(null,"animate","animate",1850194573),true,new cljs.core.Keyword(null,"animationDuration","animationDuration",-322932146),(500)], null),intent_id,all_entities,new cljs.core.Keyword(null,"ui-intent","ui-intent",-216071742),["Intent: ",cljs.core.name(intent_id)].join(''),false,new cljs.core.Keyword(null,"breadthfirst","breadthfirst",-1410812190),entity_ids]);
});
/**
 * Show all entities related to a specific constraint.
 * 
 *   Useful for understanding security boundaries, access control, etc.
 * 
 *   Example: (constraint-lens registry :constraint/admin-only-user-management)
 *         => Shows all entities enforcing admin access
 */
atlas_ui.lenses.constraint_lens = (function atlas_ui$lenses$constraint_lens(registry,constraint_kw){
var entities = atlas_ui.lenses.find_entities_by_aspect(registry,constraint_kw);
var entity_ids = cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553),entities));
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.Keyword(null,"layout-config","layout-config",-1439964126),new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"entities","entities",1940967403),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"title","title",636505583),new cljs.core.Keyword(null,"show-all-aspects?","show-all-aspects?",1768762674),new cljs.core.Keyword(null,"layout-mode","layout-mode",-1873376486),new cljs.core.Keyword(null,"entity-ids","entity-ids",-963844196)],[["All entities constrained by ",cljs.core.name(constraint_kw)].join(''),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"animate","animate",1850194573),true,new cljs.core.Keyword(null,"animationDuration","animationDuration",-322932146),(500),new cljs.core.Keyword(null,"spacingFactor","spacingFactor",-627033670),1.5,new cljs.core.Keyword(null,"avoidOverlap","avoidOverlap",-2113241329),true,new cljs.core.Keyword(null,"nodeDimensionsIncludeLabels","nodeDimensionsIncludeLabels",-315344226),true], null),constraint_kw,entities,new cljs.core.Keyword(null,"constraint","constraint",1725147424),["Constraint: ",cljs.core.name(constraint_kw)].join(''),false,new cljs.core.Keyword(null,"circle","circle",1903212362),entity_ids]);
});
/**
 * Recursively collect all dependencies from an entity.
 * 
 *   Returns a set of entity IDs that are dependencies (direct and transitive).
 */
atlas_ui.lenses.collect_dependencies = (function atlas_ui$lenses$collect_dependencies(registry,start_id,visited){
if(cljs.core.contains_QMARK_(visited,start_id)){
return visited;
} else {
var entity = atlas_ui.lenses.find_entity_by_id(registry,start_id);
var deps = atlas_ui.lenses.deps_for_entity(entity);
var new_visited = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(visited,start_id);
if(cljs.core.seq(deps)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,dep_id){
return (atlas_ui.lenses.collect_dependencies.cljs$core$IFn$_invoke$arity$3 ? atlas_ui.lenses.collect_dependencies.cljs$core$IFn$_invoke$arity$3(registry,dep_id,acc) : atlas_ui.lenses.collect_dependencies.call(null,registry,dep_id,acc));
}),new_visited,deps);
} else {
return new_visited;
}
}
});
/**
 * Recursively collect all entities that depend on the target entity (reverse deps).
 * 
 *   Returns a set of entity IDs that would be impacted if target changes.
 */
atlas_ui.lenses.collect_dependents = (function atlas_ui$lenses$collect_dependents(registry,target_id,visited){
if(cljs.core.contains_QMARK_(visited,target_id)){
return visited;
} else {
var direct_dependents = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553),cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (entity){
var deps = atlas_ui.lenses.deps_for_entity(entity);
if(cljs.core.truth_(deps)){
if(cljs.core.set_QMARK_(deps)){
return cljs.core.contains_QMARK_(deps,target_id);
} else {
if(cljs.core.coll_QMARK_(deps)){
return cljs.core.some((function (p1__18879_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__18879_SHARP_,target_id);
}),deps);
} else {
return false;

}
}
} else {
return null;
}
}),cljs.core.vals(registry))));
var new_visited = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(visited,target_id);
console.log("\u00F0\u0178\u201D\uFFFD Impact analysis:","\nTarget:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(target_id),"\nDirect dependents:",cljs.core.clj__GT_js(direct_dependents),"\nVisited so far:",cljs.core.clj__GT_js(new_visited));

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,dependent_id){
return (atlas_ui.lenses.collect_dependents.cljs$core$IFn$_invoke$arity$3 ? atlas_ui.lenses.collect_dependents.cljs$core$IFn$_invoke$arity$3(registry,dependent_id,acc) : atlas_ui.lenses.collect_dependents.call(null,registry,dependent_id,acc));
}),new_visited,direct_dependents);
}
});
/**
 * Show dependency flow from a specific entity.
 * 
 *   Traces all dependencies (direct and transitive) from the starting entity,
 *   showing the complete call chain.
 * 
 *   Example: (dependency-flow-lens registry :endpoint/oauth-callback)
 *         => Shows endpoint → functions → components it depends on
 */
atlas_ui.lenses.dependency_flow_lens = (function atlas_ui$lenses$dependency_flow_lens(registry,start_id){
var entity_ids = atlas_ui.lenses.collect_dependencies(registry,start_id,cljs.core.PersistentHashSet.EMPTY);
var entities = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__18884_SHARP_){
return cljs.core.contains_QMARK_(entity_ids,new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553).cljs$core$IFn$_invoke$arity$1(p1__18884_SHARP_));
}),cljs.core.vals(registry)));
var start_entity = atlas_ui.lenses.find_entity_by_id(registry,start_id);
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.Keyword(null,"layout-config","layout-config",-1439964126),new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"entities","entities",1940967403),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"title","title",636505583),new cljs.core.Keyword(null,"show-all-aspects?","show-all-aspects?",1768762674),new cljs.core.Keyword(null,"layout-mode","layout-mode",-1873376486),new cljs.core.Keyword(null,"entity-ids","entity-ids",-963844196)],[["Dependency chain from ",cljs.core.name(start_id)].join(''),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"directed","directed",1150765886),true,new cljs.core.Keyword(null,"spacingFactor","spacingFactor",-627033670),1.8,new cljs.core.Keyword(null,"animate","animate",1850194573),true,new cljs.core.Keyword(null,"animationDuration","animationDuration",-322932146),(500),new cljs.core.Keyword(null,"roots","roots",-1088919250),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.str.cljs$core$IFn$_invoke$arity$1(start_id)], null),new cljs.core.Keyword(null,"avoidOverlap","avoidOverlap",-2113241329),true], null),start_id,entities,new cljs.core.Keyword(null,"dependency-flow","dependency-flow",-1319369283),["Flow from: ",cljs.core.name(start_id)].join(''),false,new cljs.core.Keyword(null,"breadthfirst","breadthfirst",-1410812190),entity_ids]);
});
/**
 * Show impact analysis - what would break if this entity changes?
 * 
 *   Traces all entities that depend on the target (direct and transitive),
 *   showing the complete ripple effect.
 * 
 *   Example: (impact-analysis-lens registry :component/db)
 *         => Shows all functions/endpoints that use the DB component
 */
atlas_ui.lenses.impact_analysis_lens = (function atlas_ui$lenses$impact_analysis_lens(registry,target_id){
var entity_ids = atlas_ui.lenses.collect_dependents(registry,target_id,cljs.core.PersistentHashSet.EMPTY);
var entities = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__18889_SHARP_){
return cljs.core.contains_QMARK_(entity_ids,new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553).cljs$core$IFn$_invoke$arity$1(p1__18889_SHARP_));
}),cljs.core.vals(registry)));
var target_entity = atlas_ui.lenses.find_entity_by_id(registry,target_id);
var impact_count = (cljs.core.count(entity_ids) - (1));
var impact_score = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(impact_count,(0)))?new cljs.core.Keyword(null,"none","none",1333468478):(((impact_count <= (3)))?new cljs.core.Keyword(null,"low","low",-1601362409):(((impact_count <= (10)))?new cljs.core.Keyword(null,"medium","medium",-1864319384):(((impact_count <= (20)))?new cljs.core.Keyword(null,"high","high",2027297808):new cljs.core.Keyword(null,"critical","critical",-838839117)
))));
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.Keyword(null,"layout-config","layout-config",-1439964126),new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"entities","entities",1940967403),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"impact-score","impact-score",-730988594),new cljs.core.Keyword(null,"title","title",636505583),new cljs.core.Keyword(null,"show-all-aspects?","show-all-aspects?",1768762674),new cljs.core.Keyword(null,"layout-mode","layout-mode",-1873376486),new cljs.core.Keyword(null,"impact-count","impact-count",-121528900),new cljs.core.Keyword(null,"entity-ids","entity-ids",-963844196)],[["Impact analysis: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(impact_count)," entities affected"].join(''),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"directed","directed",1150765886),true,new cljs.core.Keyword(null,"spacingFactor","spacingFactor",-627033670),2.0,new cljs.core.Keyword(null,"animate","animate",1850194573),true,new cljs.core.Keyword(null,"animationDuration","animationDuration",-322932146),(500),new cljs.core.Keyword(null,"roots","roots",-1088919250),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.str.cljs$core$IFn$_invoke$arity$1(target_id)], null),new cljs.core.Keyword(null,"avoidOverlap","avoidOverlap",-2113241329),true], null),target_id,entities,new cljs.core.Keyword(null,"impact-analysis","impact-analysis",1563390103),impact_score,["Impact: ",cljs.core.name(target_id)].join(''),false,new cljs.core.Keyword(null,"breadthfirst","breadthfirst",-1410812190),impact_count,entity_ids]);
});
/**
 * Extract all available lens options from the registry.
 * 
 *   Returns a map of lens categories to available values.
 * 
 *   Only extracts from FUNCTIONAL ENTITIES (those with semantic markers like
 *   :semantic-namespace/function, :component, :endpoint, etc.), not aspect nodes.
 *   This prevents showing aspect metadata as if they were entity domains.
 * 
 *   Registry format: {identity-set entity-map, ...}
 */
atlas_ui.lenses.available_lenses = (function atlas_ui$lenses$available_lenses(registry){
var semantic_markers = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword("atlas","interface-protocol","atlas/interface-protocol",-1646715577),null,new cljs.core.Keyword("atlas","interface-endpoint","atlas/interface-endpoint",162094344),null,new cljs.core.Keyword("atlas","execution-function","atlas/execution-function",-633620662),null,new cljs.core.Keyword("atlas","structure-component","atlas/structure-component",-156450702),null,new cljs.core.Keyword("atlas","governance-constraint","atlas/governance-constraint",-1105762794),null,new cljs.core.Keyword("semantic-namespace","interaction-intent","semantic-namespace/interaction-intent",-483708776),null], null), null);
var entities = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p__18901){
var vec__18902 = p__18901;
var identity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18902,(0),null);
var entity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18902,(1),null);
return cljs.core.some((function (p1__18891_SHARP_){
return cljs.core.contains_QMARK_(identity,p1__18891_SHARP_);
}),semantic_markers);
}),registry));
var ui_intent_aspect = new cljs.core.Keyword("semantic-namespace","interaction-intent","semantic-namespace/interaction-intent",-483708776);
var result = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"domains","domains",1410387719),atlas_ui.lenses.extract_aspect_values(entities,new cljs.core.Keyword(null,"domain","domain",1847214937)),new cljs.core.Keyword(null,"tiers","tiers",-46242789),atlas_ui.lenses.extract_aspect_values(entities,new cljs.core.Keyword(null,"tier","tier",-1071893374)),new cljs.core.Keyword(null,"protocols","protocols",-5615896),atlas_ui.lenses.extract_aspect_values(entities,new cljs.core.Keyword(null,"protocol","protocol",652470118)),new cljs.core.Keyword(null,"constraints","constraints",422775616),atlas_ui.lenses.extract_aspect_values(entities,new cljs.core.Keyword(null,"constraint","constraint",1725147424)),new cljs.core.Keyword(null,"ui-intents","ui-intents",1360343789),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.keep.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553),cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.second,cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p__18908){
var vec__18909 = p__18908;
var identity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18909,(0),null);
var entity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18909,(1),null);
return cljs.core.contains_QMARK_(identity,ui_intent_aspect);
}),entities))))], null);
console.log("\uD83D\uDCCA Available lenses:","\nDomains (",cljs.core.count(new cljs.core.Keyword(null,"domains","domains",1410387719).cljs$core$IFn$_invoke$arity$1(result)),"):",cljs.core.clj__GT_js(new cljs.core.Keyword(null,"domains","domains",1410387719).cljs$core$IFn$_invoke$arity$1(result)),"\nTiers (",cljs.core.count(new cljs.core.Keyword(null,"tiers","tiers",-46242789).cljs$core$IFn$_invoke$arity$1(result)),"):",cljs.core.clj__GT_js(new cljs.core.Keyword(null,"tiers","tiers",-46242789).cljs$core$IFn$_invoke$arity$1(result)),"\nProtocols (",cljs.core.count(new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$1(result)),"):",cljs.core.clj__GT_js(new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$1(result)));

return result;
});
/**
 * Combine multiple lens results using intersection.
 * 
 *   Returns a combined lens result showing only entities that appear in ALL lenses.
 * 
 *   Example: (combine-lenses registry [{:type :domain :value :domain/auth}
 *                                     {:type :tier :value :tier/service}])
 *         => Shows only auth domain entities in service tier
 */
atlas_ui.lenses.combine_lenses = (function atlas_ui$lenses$combine_lenses(registry,lens_specs){
if(cljs.core.seq(lens_specs)){
var lens_results = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__18913_SHARP_){
return (atlas_ui.lenses.apply_lens.cljs$core$IFn$_invoke$arity$2 ? atlas_ui.lenses.apply_lens.cljs$core$IFn$_invoke$arity$2(registry,p1__18913_SHARP_) : atlas_ui.lenses.apply_lens.call(null,registry,p1__18913_SHARP_));
}),lens_specs);
var combined_entity_ids = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(clojure.set.intersection,cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"entity-ids","entity-ids",-963844196),lens_results));
var all_entities = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"entities","entities",1940967403),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lens_results], 0));
var combined_entities = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__18915_SHARP_){
return cljs.core.contains_QMARK_(combined_entity_ids,new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553).cljs$core$IFn$_invoke$arity$1(p1__18915_SHARP_));
}),all_entities);
var titles = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"title","title",636505583),lens_results);
var combined_title = ["Combined: ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" \u2229 ",titles)].join('');
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.Keyword(null,"layout-config","layout-config",-1439964126),new cljs.core.Keyword(null,"entities","entities",1940967403),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"title","title",636505583),new cljs.core.Keyword(null,"show-all-aspects?","show-all-aspects?",1768762674),new cljs.core.Keyword(null,"layout-mode","layout-mode",-1873376486),new cljs.core.Keyword(null,"entity-ids","entity-ids",-963844196),new cljs.core.Keyword(null,"lens-specs","lens-specs",467433183)],[["Intersection of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(lens_specs))," lenses"].join(''),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"animate","animate",1850194573),true,new cljs.core.Keyword(null,"animationDuration","animationDuration",-322932146),(500),new cljs.core.Keyword(null,"nodeRepulsion","nodeRepulsion",1340782048),(4000),new cljs.core.Keyword(null,"idealEdgeLength","idealEdgeLength",133869423),(100)], null),cljs.core.vec(combined_entities),new cljs.core.Keyword(null,"combination","combination",1695836532),combined_title,false,new cljs.core.Keyword(null,"cose","cose",977489983),combined_entity_ids,lens_specs]);
} else {
return null;
}
});
/**
 * Apply a lens specification to the registry.
 * 
 *   Returns a lens result with filtered entities and metadata.
 *   If no lens is active, returns nil (full explorer mode).
 * 
 *   Lens spec format:
 *  Single lens: {:type :domain :value :domain/auth}
 *  Combination: {:type :combination :lenses [{:type :domain :value :domain/auth}
 *                                              {:type :tier :value :tier/service}]}
 *  Flow: {:type :dependency-flow :value :endpoint/some-endpoint}
 * 
 *   Example: (apply-lens registry {:type :domain :value :domain/auth})
 *         => {:type :domain
 *             :value :domain/auth
 *             :title "Domain: auth"
 *             :entities [...]
 *             :entity-ids #{...}
 *             :layout-mode :hierarchical
 *             :show-all-aspects? false}
 */
atlas_ui.lenses.apply_lens = (function atlas_ui$lenses$apply_lens(registry,lens_spec){
if(cljs.core.truth_(lens_spec)){
var G__18927 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(lens_spec);
var G__18927__$1 = (((G__18927 instanceof cljs.core.Keyword))?G__18927.fqn:null);
switch (G__18927__$1) {
case "domain":
return atlas_ui.lenses.domain_lens(registry,new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(lens_spec));

break;
case "tier":
return atlas_ui.lenses.tier_lens(registry,new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(lens_spec));

break;
case "protocol":
return atlas_ui.lenses.protocol_lens(registry,new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(lens_spec));

break;
case "ui-intent":
return atlas_ui.lenses.intent_lens(registry,new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(lens_spec));

break;
case "constraint":
return atlas_ui.lenses.constraint_lens(registry,new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(lens_spec));

break;
case "combination":
return atlas_ui.lenses.combine_lenses(registry,new cljs.core.Keyword(null,"lenses","lenses",-740611109).cljs$core$IFn$_invoke$arity$1(lens_spec));

break;
case "dependency-flow":
return atlas_ui.lenses.dependency_flow_lens(registry,new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(lens_spec));

break;
case "impact-analysis":
return atlas_ui.lenses.impact_analysis_lens(registry,new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(lens_spec));

break;
default:
return null;

}
} else {
return null;
}
});
/**
 * Check if a lens is currently active.
 */
atlas_ui.lenses.lens_active_QMARK_ = (function atlas_ui$lenses$lens_active_QMARK_(lens_spec){
return (!((lens_spec == null)));
});
/**
 * Determine if an entity should be shown given the current lens.
 * 
 *   If no lens is active, show all entities.
 *   If lens is active, only show entities in the lens's entity-ids set.
 */
atlas_ui.lenses.should_show_entity_QMARK_ = (function atlas_ui$lenses$should_show_entity_QMARK_(entity,lens_result){
if(cljs.core.truth_(lens_result)){
return cljs.core.contains_QMARK_(new cljs.core.Keyword(null,"entity-ids","entity-ids",-963844196).cljs$core$IFn$_invoke$arity$1(lens_result),new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553).cljs$core$IFn$_invoke$arity$1(entity));
} else {
return true;
}
});

//# sourceMappingURL=atlas_ui.lenses.js.map
