goog.provide('atlas_ui.graph_data');
/**
 * Extract all entities from registry as node data.
 * 
 * Enhanced with explicit :entity-type and :aspects for better performance:
 * - :entity-type - Direct access to entity type (no filtering needed)
 * - :aspects - Pure aspects only (type removed from set)
 * - :identity - Full compound identity (kept for backward compatibility)
 */
atlas_ui.graph_data.entity_nodes = (function atlas_ui$graph_data$entity_nodes(registry){
var iter__5480__auto__ = (function atlas_ui$graph_data$entity_nodes_$_iter__18233(s__18234){
return (new cljs.core.LazySeq(null,(function (){
var s__18234__$1 = s__18234;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__18234__$1);
if(temp__5804__auto__){
var s__18234__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__18234__$2)){
var c__5478__auto__ = cljs.core.chunk_first(s__18234__$2);
var size__5479__auto__ = cljs.core.count(c__5478__auto__);
var b__18236 = cljs.core.chunk_buffer(size__5479__auto__);
if((function (){var i__18235 = (0);
while(true){
if((i__18235 < size__5479__auto__)){
var vec__18237 = cljs.core._nth(c__5478__auto__,i__18235);
var compound_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18237,(0),null);
var props = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18237,(1),null);
if(cljs.core.truth_((function (){var and__5000__auto__ = cljs.core.set_QMARK_(compound_id);
if(and__5000__auto__){
return new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553).cljs$core$IFn$_invoke$arity$1(props);
} else {
return and__5000__auto__;
}
})())){
cljs.core.chunk_append(b__18236,(function (){var entity_type = new cljs.core.Keyword("atlas","type","atlas/type",1535978791).cljs$core$IFn$_invoke$arity$1(props);
var aspects = (cljs.core.truth_(entity_type)?cljs.core.disj.cljs$core$IFn$_invoke$arity$2(compound_id,entity_type):compound_id);
return new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword("atlas-ui.graph.node","id","atlas-ui.graph.node/id",-1392721478),new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553).cljs$core$IFn$_invoke$arity$1(props),new cljs.core.Keyword("atlas-ui.graph.node","type","atlas-ui.graph.node/type",1053813014),new cljs.core.Keyword(null,"entity","entity",-450970276),new cljs.core.Keyword("atlas-ui.graph.node","entity-type","atlas-ui.graph.node/entity-type",-1912090483),entity_type,new cljs.core.Keyword("atlas-ui.graph.node","aspects","atlas-ui.graph.node/aspects",1959787835),aspects,new cljs.core.Keyword("atlas-ui.graph.node","label","atlas-ui.graph.node/label",1764673194),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553).cljs$core$IFn$_invoke$arity$1(props)),new cljs.core.Keyword("atlas-ui.graph.node","identity","atlas-ui.graph.node/identity",1626823993),compound_id,new cljs.core.Keyword("atlas-ui.graph.node","props","atlas-ui.graph.node/props",465997681),props], null);
})());

var G__18282 = (i__18235 + (1));
i__18235 = G__18282;
continue;
} else {
var G__18283 = (i__18235 + (1));
i__18235 = G__18283;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__18236),atlas_ui$graph_data$entity_nodes_$_iter__18233(cljs.core.chunk_rest(s__18234__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__18236),null);
}
} else {
var vec__18240 = cljs.core.first(s__18234__$2);
var compound_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18240,(0),null);
var props = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18240,(1),null);
if(cljs.core.truth_((function (){var and__5000__auto__ = cljs.core.set_QMARK_(compound_id);
if(and__5000__auto__){
return new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553).cljs$core$IFn$_invoke$arity$1(props);
} else {
return and__5000__auto__;
}
})())){
return cljs.core.cons((function (){var entity_type = new cljs.core.Keyword("atlas","type","atlas/type",1535978791).cljs$core$IFn$_invoke$arity$1(props);
var aspects = (cljs.core.truth_(entity_type)?cljs.core.disj.cljs$core$IFn$_invoke$arity$2(compound_id,entity_type):compound_id);
return new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword("atlas-ui.graph.node","id","atlas-ui.graph.node/id",-1392721478),new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553).cljs$core$IFn$_invoke$arity$1(props),new cljs.core.Keyword("atlas-ui.graph.node","type","atlas-ui.graph.node/type",1053813014),new cljs.core.Keyword(null,"entity","entity",-450970276),new cljs.core.Keyword("atlas-ui.graph.node","entity-type","atlas-ui.graph.node/entity-type",-1912090483),entity_type,new cljs.core.Keyword("atlas-ui.graph.node","aspects","atlas-ui.graph.node/aspects",1959787835),aspects,new cljs.core.Keyword("atlas-ui.graph.node","label","atlas-ui.graph.node/label",1764673194),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553).cljs$core$IFn$_invoke$arity$1(props)),new cljs.core.Keyword("atlas-ui.graph.node","identity","atlas-ui.graph.node/identity",1626823993),compound_id,new cljs.core.Keyword("atlas-ui.graph.node","props","atlas-ui.graph.node/props",465997681),props], null);
})(),atlas_ui$graph_data$entity_nodes_$_iter__18233(cljs.core.rest(s__18234__$2)));
} else {
var G__18284 = cljs.core.rest(s__18234__$2);
s__18234__$1 = G__18284;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5480__auto__(registry);
});
/**
 * Extract all unique aspects from all compound identities
 */
atlas_ui.graph_data.aspect_nodes = (function atlas_ui$graph_data$aspect_nodes(registry){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (aspect){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("atlas-ui.graph.node","id","atlas-ui.graph.node/id",-1392721478),aspect,new cljs.core.Keyword("atlas-ui.graph.node","type","atlas-ui.graph.node/type",1053813014),new cljs.core.Keyword(null,"aspect","aspect",-839905246),new cljs.core.Keyword("atlas-ui.graph.node","label","atlas-ui.graph.node/label",1764673194),(cljs.core.truth_(cljs.core.namespace(aspect))?[cljs.core.namespace(aspect),"/",cljs.core.name(aspect)].join(''):cljs.core.str.cljs$core$IFn$_invoke$arity$1(aspect))], null);
}),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.identity,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.set_QMARK_,cljs.core.keys(registry))], 0))));
});
/**
 * Create edges from entities to their aspects (membership)
 */
atlas_ui.graph_data.membership_edges = (function atlas_ui$graph_data$membership_edges(registry){
var iter__5480__auto__ = (function atlas_ui$graph_data$membership_edges_$_iter__18245(s__18246){
return (new cljs.core.LazySeq(null,(function (){
var s__18246__$1 = s__18246;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__18246__$1);
if(temp__5804__auto__){
var xs__6360__auto__ = temp__5804__auto__;
var vec__18251 = cljs.core.first(xs__6360__auto__);
var compound_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18251,(0),null);
var props = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18251,(1),null);
if(cljs.core.truth_((function (){var and__5000__auto__ = cljs.core.set_QMARK_(compound_id);
if(and__5000__auto__){
return new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553).cljs$core$IFn$_invoke$arity$1(props);
} else {
return and__5000__auto__;
}
})())){
var iterys__5476__auto__ = ((function (s__18246__$1,vec__18251,compound_id,props,xs__6360__auto__,temp__5804__auto__){
return (function atlas_ui$graph_data$membership_edges_$_iter__18245_$_iter__18247(s__18248){
return (new cljs.core.LazySeq(null,((function (s__18246__$1,vec__18251,compound_id,props,xs__6360__auto__,temp__5804__auto__){
return (function (){
var s__18248__$1 = s__18248;
while(true){
var temp__5804__auto____$1 = cljs.core.seq(s__18248__$1);
if(temp__5804__auto____$1){
var s__18248__$2 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__18248__$2)){
var c__5478__auto__ = cljs.core.chunk_first(s__18248__$2);
var size__5479__auto__ = cljs.core.count(c__5478__auto__);
var b__18250 = cljs.core.chunk_buffer(size__5479__auto__);
if((function (){var i__18249 = (0);
while(true){
if((i__18249 < size__5479__auto__)){
var aspect = cljs.core._nth(c__5478__auto__,i__18249);
cljs.core.chunk_append(b__18250,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("atlas-ui.graph.edge","source","atlas-ui.graph.edge/source",-454253894),new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553).cljs$core$IFn$_invoke$arity$1(props),new cljs.core.Keyword("atlas-ui.graph.edge","target","atlas-ui.graph.edge/target",298493892),aspect,new cljs.core.Keyword("atlas-ui.graph.edge","type","atlas-ui.graph.edge/type",1052485841),new cljs.core.Keyword(null,"membership","membership",254556333)], null));

var G__18285 = (i__18249 + (1));
i__18249 = G__18285;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__18250),atlas_ui$graph_data$membership_edges_$_iter__18245_$_iter__18247(cljs.core.chunk_rest(s__18248__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__18250),null);
}
} else {
var aspect = cljs.core.first(s__18248__$2);
return cljs.core.cons(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("atlas-ui.graph.edge","source","atlas-ui.graph.edge/source",-454253894),new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553).cljs$core$IFn$_invoke$arity$1(props),new cljs.core.Keyword("atlas-ui.graph.edge","target","atlas-ui.graph.edge/target",298493892),aspect,new cljs.core.Keyword("atlas-ui.graph.edge","type","atlas-ui.graph.edge/type",1052485841),new cljs.core.Keyword(null,"membership","membership",254556333)], null),atlas_ui$graph_data$membership_edges_$_iter__18245_$_iter__18247(cljs.core.rest(s__18248__$2)));
}
} else {
return null;
}
break;
}
});})(s__18246__$1,vec__18251,compound_id,props,xs__6360__auto__,temp__5804__auto__))
,null,null));
});})(s__18246__$1,vec__18251,compound_id,props,xs__6360__auto__,temp__5804__auto__))
;
var fs__5477__auto__ = cljs.core.seq(iterys__5476__auto__(compound_id));
if(fs__5477__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__5477__auto__,atlas_ui$graph_data$membership_edges_$_iter__18245(cljs.core.rest(s__18246__$1)));
} else {
var G__18290 = cljs.core.rest(s__18246__$1);
s__18246__$1 = G__18290;
continue;
}
} else {
var G__18291 = cljs.core.rest(s__18246__$1);
s__18246__$1 = G__18291;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5480__auto__(registry);
});
/**
 * Create edges from entities to their dependencies
 */
atlas_ui.graph_data.dependency_edges = (function atlas_ui$graph_data$dependency_edges(registry){
var deps_for_props = (function atlas_ui$graph_data$dependency_edges_$_deps_for_props(props){
var deps = (function (){var or__5002__auto__ = new cljs.core.Keyword("interface-endpoint","deps","interface-endpoint/deps",-650127208).cljs$core$IFn$_invoke$arity$1(props);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
var or__5002__auto____$1 = new cljs.core.Keyword("execution-function","deps","execution-function/deps",1183773524).cljs$core$IFn$_invoke$arity$1(props);
if(cljs.core.truth_(or__5002__auto____$1)){
return or__5002__auto____$1;
} else {
var or__5002__auto____$2 = new cljs.core.Keyword("structure-component","deps","structure-component/deps",742401310).cljs$core$IFn$_invoke$arity$1(props);
if(cljs.core.truth_(or__5002__auto____$2)){
return or__5002__auto____$2;
} else {
return new cljs.core.Keyword("semantic-namespace","deps","semantic-namespace/deps",552841771).cljs$core$IFn$_invoke$arity$1(props);
}
}
}
})();
if(cljs.core.set_QMARK_(deps)){
return deps;
} else {
if(cljs.core.coll_QMARK_(deps)){
return cljs.core.set(deps);
} else {
return cljs.core.PersistentHashSet.EMPTY;

}
}
});
var iter__5480__auto__ = (function atlas_ui$graph_data$dependency_edges_$_iter__18258(s__18259){
return (new cljs.core.LazySeq(null,(function (){
var s__18259__$1 = s__18259;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__18259__$1);
if(temp__5804__auto__){
var xs__6360__auto__ = temp__5804__auto__;
var vec__18264 = cljs.core.first(xs__6360__auto__);
var compound_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18264,(0),null);
var props = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18264,(1),null);
if(cljs.core.truth_((function (){var and__5000__auto__ = cljs.core.set_QMARK_(compound_id);
if(and__5000__auto__){
return new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553).cljs$core$IFn$_invoke$arity$1(props);
} else {
return and__5000__auto__;
}
})())){
var iterys__5476__auto__ = ((function (s__18259__$1,vec__18264,compound_id,props,xs__6360__auto__,temp__5804__auto__){
return (function atlas_ui$graph_data$dependency_edges_$_iter__18258_$_iter__18260(s__18261){
return (new cljs.core.LazySeq(null,((function (s__18259__$1,vec__18264,compound_id,props,xs__6360__auto__,temp__5804__auto__){
return (function (){
var s__18261__$1 = s__18261;
while(true){
var temp__5804__auto____$1 = cljs.core.seq(s__18261__$1);
if(temp__5804__auto____$1){
var s__18261__$2 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__18261__$2)){
var c__5478__auto__ = cljs.core.chunk_first(s__18261__$2);
var size__5479__auto__ = cljs.core.count(c__5478__auto__);
var b__18263 = cljs.core.chunk_buffer(size__5479__auto__);
if((function (){var i__18262 = (0);
while(true){
if((i__18262 < size__5479__auto__)){
var dep = cljs.core._nth(c__5478__auto__,i__18262);
cljs.core.chunk_append(b__18263,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("atlas-ui.graph.edge","source","atlas-ui.graph.edge/source",-454253894),new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553).cljs$core$IFn$_invoke$arity$1(props),new cljs.core.Keyword("atlas-ui.graph.edge","target","atlas-ui.graph.edge/target",298493892),dep,new cljs.core.Keyword("atlas-ui.graph.edge","type","atlas-ui.graph.edge/type",1052485841),new cljs.core.Keyword(null,"dependency","dependency",1300131203)], null));

var G__18296 = (i__18262 + (1));
i__18262 = G__18296;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__18263),atlas_ui$graph_data$dependency_edges_$_iter__18258_$_iter__18260(cljs.core.chunk_rest(s__18261__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__18263),null);
}
} else {
var dep = cljs.core.first(s__18261__$2);
return cljs.core.cons(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("atlas-ui.graph.edge","source","atlas-ui.graph.edge/source",-454253894),new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553).cljs$core$IFn$_invoke$arity$1(props),new cljs.core.Keyword("atlas-ui.graph.edge","target","atlas-ui.graph.edge/target",298493892),dep,new cljs.core.Keyword("atlas-ui.graph.edge","type","atlas-ui.graph.edge/type",1052485841),new cljs.core.Keyword(null,"dependency","dependency",1300131203)], null),atlas_ui$graph_data$dependency_edges_$_iter__18258_$_iter__18260(cljs.core.rest(s__18261__$2)));
}
} else {
return null;
}
break;
}
});})(s__18259__$1,vec__18264,compound_id,props,xs__6360__auto__,temp__5804__auto__))
,null,null));
});})(s__18259__$1,vec__18264,compound_id,props,xs__6360__auto__,temp__5804__auto__))
;
var fs__5477__auto__ = cljs.core.seq(iterys__5476__auto__(deps_for_props(props)));
if(fs__5477__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__5477__auto__,atlas_ui$graph_data$dependency_edges_$_iter__18258(cljs.core.rest(s__18259__$1)));
} else {
var G__18297 = cljs.core.rest(s__18259__$1);
s__18259__$1 = G__18297;
continue;
}
} else {
var G__18299 = cljs.core.rest(s__18259__$1);
s__18259__$1 = G__18299;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5480__auto__(registry);
});
/**
 * Build complete graph data structure from registry
 */
atlas_ui.graph_data.build_graph_data = (function atlas_ui$graph_data$build_graph_data(registry){
var entities = atlas_ui.graph_data.entity_nodes(registry);
var aspects = atlas_ui.graph_data.aspect_nodes(registry);
var edges = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(atlas_ui.graph_data.membership_edges(registry),atlas_ui.graph_data.dependency_edges(registry));
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("atlas-ui.graph.data","entities","atlas-ui.graph.data/entities",-1980533303),entities,new cljs.core.Keyword("atlas-ui.graph.data","aspects","atlas-ui.graph.data/aspects",1960033811),aspects,new cljs.core.Keyword("atlas-ui.graph.data","edges","atlas-ui.graph.data/edges",-707560193),edges,new cljs.core.Keyword("atlas-ui.graph.data","all-nodes","atlas-ui.graph.data/all-nodes",187343157),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(entities,aspects)], null);
});
/**
 * Find a node in graph data by its ID
 */
atlas_ui.graph_data.find_node_by_id = (function atlas_ui$graph_data$find_node_by_id(graph_data,node_id){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__18271_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("atlas-ui.graph.node","id","atlas-ui.graph.node/id",-1392721478).cljs$core$IFn$_invoke$arity$1(p1__18271_SHARP_),node_id);
}),new cljs.core.Keyword("atlas-ui.graph.data","all-nodes","atlas-ui.graph.data/all-nodes",187343157).cljs$core$IFn$_invoke$arity$1(graph_data)));
});
/**
 * Find all entities that have a specific aspect
 */
atlas_ui.graph_data.entities_with_aspect = (function atlas_ui$graph_data$entities_with_aspect(graph_data,aspect){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (entity){
var identity = new cljs.core.Keyword("atlas-ui.graph.node","identity","atlas-ui.graph.node/identity",1626823993).cljs$core$IFn$_invoke$arity$1(entity);
var has_it = cljs.core.contains_QMARK_(identity,aspect);
return has_it;
}),new cljs.core.Keyword("atlas-ui.graph.data","entities","atlas-ui.graph.data/entities",-1980533303).cljs$core$IFn$_invoke$arity$1(graph_data));
});
/**
 * Get all aspects for an entity
 */
atlas_ui.graph_data.entity_aspects = (function atlas_ui$graph_data$entity_aspects(graph_data,entity_id){
var entity = atlas_ui.graph_data.find_node_by_id(graph_data,entity_id);
return new cljs.core.Keyword("atlas-ui.graph.node","identity","atlas-ui.graph.node/identity",1626823993).cljs$core$IFn$_invoke$arity$1(entity);
});
/**
 * Filter entities by exact entity type - O(1) lookup per entity.
 * 
 * Example:
 *   (entities-by-type graph-data :atlas/interface-endpoint)
 */
atlas_ui.graph_data.entities_by_type = (function atlas_ui$graph_data$entities_by_type(graph_data,entity_type){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__18272_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("atlas-ui.graph.node","entity-type","atlas-ui.graph.node/entity-type",-1912090483).cljs$core$IFn$_invoke$arity$1(p1__18272_SHARP_),entity_type);
}),new cljs.core.Keyword("atlas-ui.graph.data","entities","atlas-ui.graph.data/entities",-1980533303).cljs$core$IFn$_invoke$arity$1(graph_data));
});
/**
 * Filter entities by multiple entity types.
 * 
 * Example:
 *   (entities-by-types graph-data #{:atlas/interface-endpoint
 *                                    :atlas/execution-function})
 */
atlas_ui.graph_data.entities_by_types = (function atlas_ui$graph_data$entities_by_types(graph_data,entity_types){
var type_set = cljs.core.set(entity_types);
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__18277_SHARP_){
return cljs.core.contains_QMARK_(type_set,new cljs.core.Keyword("atlas-ui.graph.node","entity-type","atlas-ui.graph.node/entity-type",-1912090483).cljs$core$IFn$_invoke$arity$1(p1__18277_SHARP_));
}),new cljs.core.Keyword("atlas-ui.graph.data","entities","atlas-ui.graph.data/entities",-1980533303).cljs$core$IFn$_invoke$arity$1(graph_data));
});
/**
 * Group all entities by their entity type - useful for stats/legend.
 * 
 * Returns a map of {entity-type -> [entities]}
 * 
 * Example:
 *   (group-by-type graph-data)
 *   ;; => {:atlas/interface-endpoint [...], :atlas/execution-function [...], ...}
 */
atlas_ui.graph_data.group_by_type = (function atlas_ui$graph_data$group_by_type(graph_data){
return cljs.core.group_by(new cljs.core.Keyword("atlas-ui.graph.node","entity-type","atlas-ui.graph.node/entity-type",-1912090483),new cljs.core.Keyword("atlas-ui.graph.data","entities","atlas-ui.graph.data/entities",-1980533303).cljs$core$IFn$_invoke$arity$1(graph_data));
});
/**
 * Get count of entities for each type.
 * 
 * Returns a map of {entity-type -> count}
 * 
 * Example:
 *   (type-counts graph-data)
 *   ;; => {:atlas/interface-endpoint 15, :atlas/execution-function 42, ...}
 */
atlas_ui.graph_data.type_counts = (function atlas_ui$graph_data$type_counts(graph_data){
return cljs.core.frequencies(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("atlas-ui.graph.node","entity-type","atlas-ui.graph.node/entity-type",-1912090483),new cljs.core.Keyword("atlas-ui.graph.data","entities","atlas-ui.graph.data/entities",-1980533303).cljs$core$IFn$_invoke$arity$1(graph_data)));
});

//# sourceMappingURL=atlas_ui.graph_data.js.map
