goog.provide('atlas_ui.core');
if((typeof atlas_ui !== 'undefined') && (typeof atlas_ui.core !== 'undefined') && (typeof atlas_ui.core.app_state !== 'undefined')){
} else {
atlas_ui.core.app_state = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword("atlas-ui.ui.state","negated-aspects","atlas-ui.ui.state/negated-aspects",1962237344),new cljs.core.Keyword("atlas-ui.ui.state","highlight-aspect","atlas-ui.ui.state/highlight-aspect",-439313600),new cljs.core.Keyword("atlas-ui.ui.state","lens-history","atlas-ui.ui.state/lens-history",534052961),new cljs.core.Keyword("atlas-ui.ui.state","show-presets?","atlas-ui.ui.state/show-presets?",2051990435),new cljs.core.Keyword("atlas-ui.ui.state","legend-focus","atlas-ui.ui.state/legend-focus",1454999652),new cljs.core.Keyword("atlas-ui.ui.state","combination-lenses","atlas-ui.ui.state/combination-lenses",-2020357275),new cljs.core.Keyword("atlas-ui.ui.state","error","atlas-ui.ui.state/error",487381415),new cljs.core.Keyword("atlas-ui.ui.state","active-lens","atlas-ui.ui.state/active-lens",-596367764),new cljs.core.Keyword("atlas-ui.ui.state","show-lens-selector?","atlas-ui.ui.state/show-lens-selector?",522076301),new cljs.core.Keyword("atlas-ui.ui.state","hide-unmatched?","atlas-ui.ui.state/hide-unmatched?",1823675889),new cljs.core.Keyword("atlas-ui.ui.state","selected-types","atlas-ui.ui.state/selected-types",-1062003055),new cljs.core.Keyword("atlas-ui.ui.state","highlighted-entity-aspects","atlas-ui.ui.state/highlighted-entity-aspects",-1183922094),new cljs.core.Keyword("atlas-ui.ui.state","min-score","atlas-ui.ui.state/min-score",-303626122),new cljs.core.Keyword("atlas-ui.ui.state","highlight-selection","atlas-ui.ui.state/highlight-selection",1962029238),new cljs.core.Keyword("atlas-ui.ui.state","lens-history-index","atlas-ui.ui.state/lens-history-index",-21459817),new cljs.core.Keyword("atlas-ui.ui.state","lens-presets","atlas-ui.ui.state/lens-presets",1303851224),new cljs.core.Keyword("atlas-ui.ui.state","selections","atlas-ui.ui.state/selections",275746488),new cljs.core.Keyword("atlas-ui.ui.state","search-term","atlas-ui.ui.state/search-term",-305959559),new cljs.core.Keyword("atlas-ui.ui.state","registry","atlas-ui.ui.state/registry",-446230821),new cljs.core.Keyword("atlas-ui.ui.state","loading?","atlas-ui.ui.state/loading?",-1728094052),new cljs.core.Keyword("atlas-ui.ui.state","query-mode","atlas-ui.ui.state/query-mode",975963741),new cljs.core.Keyword("atlas-ui.ui.state","registry-version","atlas-ui.ui.state/registry-version",-800082913)],[cljs.core.PersistentHashSet.EMPTY,null,cljs.core.PersistentVector.EMPTY,false,null,cljs.core.PersistentVector.EMPTY,null,null,false,false,cljs.core.PersistentHashSet.EMPTY,cljs.core.PersistentHashSet.EMPTY,0.0,null,(-1),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentHashSet.EMPTY,"",cljs.core.PersistentArrayMap.EMPTY,true,new cljs.core.Keyword(null,"count","count",2139924085),null]));
}
if((typeof atlas_ui !== 'undefined') && (typeof atlas_ui.core !== 'undefined') && (typeof atlas_ui.core.graph_data !== 'undefined')){
} else {
atlas_ui.core.graph_data = reagent.ratom.make_reaction((function (){
return atlas_ui.graph_data.build_graph_data(new cljs.core.Keyword("atlas-ui.ui.state","registry","atlas-ui.ui.state/registry",-446230821).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui.core.app_state)));
}));
}
if((typeof atlas_ui !== 'undefined') && (typeof atlas_ui.core !== 'undefined') && (typeof atlas_ui.core.lens_result !== 'undefined')){
} else {
atlas_ui.core.lens_result = reagent.ratom.make_reaction((function (){
var active_lens = new cljs.core.Keyword("atlas-ui.ui.state","active-lens","atlas-ui.ui.state/active-lens",-596367764).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui.core.app_state));
var registry = new cljs.core.Keyword("atlas-ui.ui.state","registry","atlas-ui.ui.state/registry",-446230821).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui.core.app_state));
if(cljs.core.truth_((function (){var and__5000__auto__ = active_lens;
if(cljs.core.truth_(and__5000__auto__)){
return cljs.core.seq(registry);
} else {
return and__5000__auto__;
}
})())){
return atlas_ui.lenses.apply_lens(registry,active_lens);
} else {
return null;
}
}));
}
if((typeof atlas_ui !== 'undefined') && (typeof atlas_ui.core !== 'undefined') && (typeof atlas_ui.core.filtered_graph_data !== 'undefined')){
} else {
atlas_ui.core.filtered_graph_data = reagent.ratom.make_reaction((function (){
var lens = cljs.core.deref(atlas_ui.core.lens_result);
var graph = cljs.core.deref(atlas_ui.core.graph_data);
var selected_types = new cljs.core.Keyword("atlas-ui.ui.state","selected-types","atlas-ui.ui.state/selected-types",-1062003055).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui.core.app_state));
var type_filter_fn = ((cljs.core.seq(selected_types))?(function (entity){
return cljs.core.contains_QMARK_(selected_types,new cljs.core.Keyword("atlas-ui.graph.node","entity-type","atlas-ui.graph.node/entity-type",-1912090483).cljs$core$IFn$_invoke$arity$1(entity));
}):cljs.core.constantly(true));
if(cljs.core.truth_(lens)){
var entity_ids = new cljs.core.Keyword(null,"entity-ids","entity-ids",-963844196).cljs$core$IFn$_invoke$arity$1(lens);
var filtered_entities = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__12014_SHARP_){
var and__5000__auto__ = cljs.core.contains_QMARK_(entity_ids,new cljs.core.Keyword("atlas-ui.graph.node","id","atlas-ui.graph.node/id",-1392721478).cljs$core$IFn$_invoke$arity$1(p1__12014_SHARP_));
if(and__5000__auto__){
return type_filter_fn(p1__12014_SHARP_);
} else {
return and__5000__auto__;
}
}),new cljs.core.Keyword("atlas-ui.graph.data","entities","atlas-ui.graph.data/entities",-1980533303).cljs$core$IFn$_invoke$arity$1(graph));
var filtered_entity_ids = cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("atlas-ui.graph.node","id","atlas-ui.graph.node/id",-1392721478),filtered_entities));
var entity_aspects = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,entity){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,new cljs.core.Keyword("atlas-ui.graph.node","identity","atlas-ui.graph.node/identity",1626823993).cljs$core$IFn$_invoke$arity$1(entity));
}),cljs.core.PersistentHashSet.EMPTY,filtered_entities);
var entities_with_badges = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (entity){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(entity,new cljs.core.Keyword("atlas-ui.graph.node","aspect-badges","atlas-ui.graph.node/aspect-badges",-86040126),cljs.core.vec(cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__12015_SHARP_){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("domain",cljs.core.namespace(p1__12015_SHARP_))) || (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("tier",cljs.core.namespace(p1__12015_SHARP_))) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("protocol",cljs.core.namespace(p1__12015_SHARP_))))));
}),new cljs.core.Keyword("atlas-ui.graph.node","identity","atlas-ui.graph.node/identity",1626823993).cljs$core$IFn$_invoke$arity$1(entity))));
}),filtered_entities);
var filtered_aspects = cljs.core.PersistentVector.EMPTY;
var filtered_edges = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (edge){
return ((cljs.core.contains_QMARK_(filtered_entity_ids,new cljs.core.Keyword("atlas-ui.graph.edge","source","atlas-ui.graph.edge/source",-454253894).cljs$core$IFn$_invoke$arity$1(edge))) && (cljs.core.contains_QMARK_(filtered_entity_ids,new cljs.core.Keyword("atlas-ui.graph.edge","target","atlas-ui.graph.edge/target",298493892).cljs$core$IFn$_invoke$arity$1(edge))));
}),new cljs.core.Keyword("atlas-ui.graph.data","edges","atlas-ui.graph.data/edges",-707560193).cljs$core$IFn$_invoke$arity$1(graph));
var filtered_all_nodes = entities_with_badges;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(graph,new cljs.core.Keyword("atlas-ui.graph.data","entities","atlas-ui.graph.data/entities",-1980533303),entities_with_badges,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("atlas-ui.graph.data","aspects","atlas-ui.graph.data/aspects",1960033811),filtered_aspects,new cljs.core.Keyword("atlas-ui.graph.data","all-nodes","atlas-ui.graph.data/all-nodes",187343157),filtered_all_nodes,new cljs.core.Keyword("atlas-ui.graph.data","edges","atlas-ui.graph.data/edges",-707560193),filtered_edges], 0));
} else {
if(cljs.core.seq(selected_types)){
var filtered_entities = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(type_filter_fn,new cljs.core.Keyword("atlas-ui.graph.data","entities","atlas-ui.graph.data/entities",-1980533303).cljs$core$IFn$_invoke$arity$1(graph));
var filtered_entity_ids = cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("atlas-ui.graph.node","id","atlas-ui.graph.node/id",-1392721478),filtered_entities));
var aspect_ids = cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("atlas-ui.graph.node","id","atlas-ui.graph.node/id",-1392721478),new cljs.core.Keyword("atlas-ui.graph.data","aspects","atlas-ui.graph.data/aspects",1960033811).cljs$core$IFn$_invoke$arity$1(graph)));
var filtered_edges = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (edge){
var source = new cljs.core.Keyword("atlas-ui.graph.edge","source","atlas-ui.graph.edge/source",-454253894).cljs$core$IFn$_invoke$arity$1(edge);
var target = new cljs.core.Keyword("atlas-ui.graph.edge","target","atlas-ui.graph.edge/target",298493892).cljs$core$IFn$_invoke$arity$1(edge);
return ((cljs.core.contains_QMARK_(filtered_entity_ids,source)) && (((cljs.core.contains_QMARK_(aspect_ids,target)) || (cljs.core.contains_QMARK_(filtered_entity_ids,target)))));
}),new cljs.core.Keyword("atlas-ui.graph.data","edges","atlas-ui.graph.data/edges",-707560193).cljs$core$IFn$_invoke$arity$1(graph));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(graph,new cljs.core.Keyword("atlas-ui.graph.data","entities","atlas-ui.graph.data/entities",-1980533303),filtered_entities,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("atlas-ui.graph.data","all-nodes","atlas-ui.graph.data/all-nodes",187343157),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(filtered_entities,new cljs.core.Keyword("atlas-ui.graph.data","aspects","atlas-ui.graph.data/aspects",1960033811).cljs$core$IFn$_invoke$arity$1(graph)),new cljs.core.Keyword("atlas-ui.graph.data","edges","atlas-ui.graph.data/edges",-707560193),filtered_edges], 0));
} else {
return graph;
}
}
}));
}
if((typeof atlas_ui !== 'undefined') && (typeof atlas_ui.core !== 'undefined') && (typeof atlas_ui.core.match_stats !== 'undefined')){
} else {
atlas_ui.core.match_stats = reagent.ratom.make_reaction((function (){
var selections = new cljs.core.Keyword("atlas-ui.ui.state","selections","atlas-ui.ui.state/selections",275746488).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui.core.app_state));
var negated_aspects = new cljs.core.Keyword("atlas-ui.ui.state","negated-aspects","atlas-ui.ui.state/negated-aspects",1962237344).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui.core.app_state));
var query_mode = new cljs.core.Keyword("atlas-ui.ui.state","query-mode","atlas-ui.ui.state/query-mode",975963741).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui.core.app_state));
var min_score = new cljs.core.Keyword("atlas-ui.ui.state","min-score","atlas-ui.ui.state/min-score",-303626122).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui.core.app_state));
var hide_unmatched_QMARK_ = new cljs.core.Keyword("atlas-ui.ui.state","hide-unmatched?","atlas-ui.ui.state/hide-unmatched?",1823675889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui.core.app_state));
var entities = new cljs.core.Keyword("atlas-ui.graph.data","entities","atlas-ui.graph.data/entities",-1980533303).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui.core.filtered_graph_data));
if(((cljs.core.seq(selections)) || (cljs.core.seq(negated_aspects)))){
var query = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("atlas.query","selected","atlas.query/selected",1069414447),selections,new cljs.core.Keyword("atlas.query","negated","atlas.query/negated",1430445364),negated_aspects,new cljs.core.Keyword("atlas.query","mode","atlas.query/mode",1284108834),query_mode,new cljs.core.Keyword("atlas.query","min-score","atlas.query/min-score",-135983776),(cljs.core.truth_(hide_unmatched_QMARK_)?min_score:0.0)], null);
var matches = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__12016_SHARP_){
return atlas.query.query_matches_QMARK_(new cljs.core.Keyword("atlas-ui.graph.node","identity","atlas-ui.graph.node/identity",1626823993).cljs$core$IFn$_invoke$arity$1(p1__12016_SHARP_),query);
}),entities);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("atlas-ui.stats","total","atlas-ui.stats/total",370708601),cljs.core.count(entities),new cljs.core.Keyword("atlas-ui.stats","matching","atlas-ui.stats/matching",-446162268),cljs.core.count(matches),new cljs.core.Keyword("atlas-ui.stats","percentage","atlas-ui.stats/percentage",1552788261),(((cljs.core.count(entities) > (0)))?(((100) * (cljs.core.count(matches) / cljs.core.count(entities))) | (0)):(0))], null);
} else {
return null;
}
}));
}
atlas_ui.core.handle_registry_loaded = (function atlas_ui$core$handle_registry_loaded(response){
console.log("=== HANDLER CALLED (Registry) ===");

console.log("Registry count:",cljs.core.count(new cljs.core.Keyword("atlas-ui.api.response","registry","atlas-ui.api.response/registry",-156359811).cljs$core$IFn$_invoke$arity$1(response)));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(atlas_ui.core.app_state,cljs.core.assoc,new cljs.core.Keyword("atlas-ui.ui.state","registry","atlas-ui.ui.state/registry",-446230821),new cljs.core.Keyword("atlas-ui.api.response","registry","atlas-ui.api.response/registry",-156359811).cljs$core$IFn$_invoke$arity$1(response),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("atlas-ui.ui.state","loading?","atlas-ui.ui.state/loading?",-1728094052),false,new cljs.core.Keyword("atlas-ui.ui.state","error","atlas-ui.ui.state/error",487381415),null], 0));
});
atlas_ui.core.toggle_set_entry = (function atlas_ui$core$toggle_set_entry(s,x){
var s__$1 = ((cljs.core.set_QMARK_(s))?s:cljs.core.PersistentHashSet.EMPTY);
if(cljs.core.contains_QMARK_(s__$1,x)){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(s__$1,x);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(s__$1,x);
}
});
/**
 * Toggle an aspect in the selections or negations set.
 * 
 *   - Click toggles positive selection.
 *   - Shift+click toggles negation (NOT).
 */
atlas_ui.core.handle_toggle_aspect = (function atlas_ui$core$handle_toggle_aspect(var_args){
var G__12018 = arguments.length;
switch (G__12018) {
case 1:
return atlas_ui.core.handle_toggle_aspect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return atlas_ui.core.handle_toggle_aspect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(atlas_ui.core.handle_toggle_aspect.cljs$core$IFn$_invoke$arity$1 = (function (aspect_id){
return atlas_ui.core.handle_toggle_aspect.cljs$core$IFn$_invoke$arity$2(aspect_id,false);
}));

(atlas_ui.core.handle_toggle_aspect.cljs$core$IFn$_invoke$arity$2 = (function (aspect_id,shift_key_QMARK_){
console.log("\u00F0\u0178\u017D\u00AF Toggling aspect:",aspect_id,"shift:",shift_key_QMARK_);

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(atlas_ui.core.app_state,(function (state){
if(cljs.core.truth_(shift_key_QMARK_)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(cljs.core.update.cljs$core$IFn$_invoke$arity$4(state,new cljs.core.Keyword("atlas-ui.ui.state","negated-aspects","atlas-ui.ui.state/negated-aspects",1962237344),atlas_ui.core.toggle_set_entry,aspect_id),new cljs.core.Keyword("atlas-ui.ui.state","selections","atlas-ui.ui.state/selections",275746488),cljs.core.disj,aspect_id);
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(cljs.core.update.cljs$core$IFn$_invoke$arity$4(state,new cljs.core.Keyword("atlas-ui.ui.state","selections","atlas-ui.ui.state/selections",275746488),atlas_ui.core.toggle_set_entry,aspect_id),new cljs.core.Keyword("atlas-ui.ui.state","negated-aspects","atlas-ui.ui.state/negated-aspects",1962237344),cljs.core.disj,aspect_id);
}
}));
}));

(atlas_ui.core.handle_toggle_aspect.cljs$lang$maxFixedArity = 2);

/**
 * Toggle focus based on legend selection.
 */
atlas_ui.core.handle_legend_focus = (function atlas_ui$core$handle_legend_focus(focus){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(atlas_ui.core.app_state,(function (state){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("atlas-ui.ui.state","legend-focus","atlas-ui.ui.state/legend-focus",1454999652).cljs$core$IFn$_invoke$arity$1(state),focus)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(state,new cljs.core.Keyword("atlas-ui.ui.state","legend-focus","atlas-ui.ui.state/legend-focus",1454999652),null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("atlas-ui.ui.state","highlight-aspect","atlas-ui.ui.state/highlight-aspect",-439313600),null], 0));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(state,new cljs.core.Keyword("atlas-ui.ui.state","legend-focus","atlas-ui.ui.state/legend-focus",1454999652),focus,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("atlas-ui.ui.state","highlight-selection","atlas-ui.ui.state/highlight-selection",1962029238),null,new cljs.core.Keyword("atlas-ui.ui.state","highlighted-entity-aspects","atlas-ui.ui.state/highlighted-entity-aspects",-1183922094),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword("atlas-ui.ui.state","highlight-aspect","atlas-ui.ui.state/highlight-aspect",-439313600),null], 0));
}
}));
});
/**
 * Toggle aspect selection and keep its relations pinned.
 */
atlas_ui.core.handle_click_aspect = (function atlas_ui$core$handle_click_aspect(var_args){
var G__12020 = arguments.length;
switch (G__12020) {
case 1:
return atlas_ui.core.handle_click_aspect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return atlas_ui.core.handle_click_aspect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(atlas_ui.core.handle_click_aspect.cljs$core$IFn$_invoke$arity$1 = (function (aspect_id){
return atlas_ui.core.handle_click_aspect.cljs$core$IFn$_invoke$arity$2(aspect_id,false);
}));

(atlas_ui.core.handle_click_aspect.cljs$core$IFn$_invoke$arity$2 = (function (aspect_id,shift_key_QMARK_){
if((aspect_id == null)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(atlas_ui.core.app_state,cljs.core.assoc,new cljs.core.Keyword("atlas-ui.ui.state","highlight-aspect","atlas-ui.ui.state/highlight-aspect",-439313600),null);
} else {
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(atlas_ui.core.app_state,(function (state){
var updated = (cljs.core.truth_(shift_key_QMARK_)?cljs.core.update.cljs$core$IFn$_invoke$arity$4(cljs.core.update.cljs$core$IFn$_invoke$arity$4(state,new cljs.core.Keyword("atlas-ui.ui.state","negated-aspects","atlas-ui.ui.state/negated-aspects",1962237344),atlas_ui.core.toggle_set_entry,aspect_id),new cljs.core.Keyword("atlas-ui.ui.state","selections","atlas-ui.ui.state/selections",275746488),cljs.core.disj,aspect_id):cljs.core.update.cljs$core$IFn$_invoke$arity$4(cljs.core.update.cljs$core$IFn$_invoke$arity$4(state,new cljs.core.Keyword("atlas-ui.ui.state","selections","atlas-ui.ui.state/selections",275746488),atlas_ui.core.toggle_set_entry,aspect_id),new cljs.core.Keyword("atlas-ui.ui.state","negated-aspects","atlas-ui.ui.state/negated-aspects",1962237344),cljs.core.disj,aspect_id));
var selected_QMARK_ = cljs.core.contains_QMARK_(new cljs.core.Keyword("atlas-ui.ui.state","selections","atlas-ui.ui.state/selections",275746488).cljs$core$IFn$_invoke$arity$1(updated),aspect_id);
var negated_QMARK_ = cljs.core.contains_QMARK_(new cljs.core.Keyword("atlas-ui.ui.state","negated-aspects","atlas-ui.ui.state/negated-aspects",1962237344).cljs$core$IFn$_invoke$arity$1(updated),aspect_id);
var active_QMARK_ = ((selected_QMARK_) || (negated_QMARK_));
if(active_QMARK_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(updated,new cljs.core.Keyword("atlas-ui.ui.state","highlight-aspect","atlas-ui.ui.state/highlight-aspect",-439313600),aspect_id,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("atlas-ui.ui.state","highlight-selection","atlas-ui.ui.state/highlight-selection",1962029238),null,new cljs.core.Keyword("atlas-ui.ui.state","highlighted-entity-aspects","atlas-ui.ui.state/highlighted-entity-aspects",-1183922094),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword("atlas-ui.ui.state","legend-focus","atlas-ui.ui.state/legend-focus",1454999652),null], 0));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("atlas-ui.ui.state","highlight-aspect","atlas-ui.ui.state/highlight-aspect",-439313600).cljs$core$IFn$_invoke$arity$1(state),aspect_id)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(updated,new cljs.core.Keyword("atlas-ui.ui.state","highlight-aspect","atlas-ui.ui.state/highlight-aspect",-439313600),null);
} else {
return updated;

}
}
}));
}
}));

(atlas_ui.core.handle_click_aspect.cljs$lang$maxFixedArity = 2);

atlas_ui.core.handle_click_entity = (function atlas_ui$core$handle_click_entity(entity){

var current_highlight = new cljs.core.Keyword("atlas-ui.ui.state","highlight-selection","atlas-ui.ui.state/highlight-selection",1962029238).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui.core.app_state));
if(cljs.core.truth_((function (){var and__5000__auto__ = entity;
if(cljs.core.truth_(and__5000__auto__)){
var and__5000__auto____$1 = current_highlight;
if(cljs.core.truth_(and__5000__auto____$1)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("atlas-ui.graph.node","id","atlas-ui.graph.node/id",-1392721478).cljs$core$IFn$_invoke$arity$1(entity),new cljs.core.Keyword("atlas-ui.graph.node","id","atlas-ui.graph.node/id",-1392721478).cljs$core$IFn$_invoke$arity$1(current_highlight));
} else {
return and__5000__auto____$1;
}
} else {
return and__5000__auto__;
}
})())){
console.log("Deselecting entity");

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(atlas_ui.core.app_state,cljs.core.assoc,new cljs.core.Keyword("atlas-ui.ui.state","highlight-selection","atlas-ui.ui.state/highlight-selection",1962029238),null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("atlas-ui.ui.state","highlighted-entity-aspects","atlas-ui.ui.state/highlighted-entity-aspects",-1183922094),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword("atlas-ui.ui.state","highlight-aspect","atlas-ui.ui.state/highlight-aspect",-439313600),null], 0));
} else {
if(cljs.core.truth_(entity)){
console.log("Showing entity details:",new cljs.core.Keyword("atlas-ui.graph.node","id","atlas-ui.graph.node/id",-1392721478).cljs$core$IFn$_invoke$arity$1(entity));

console.log("   Aspects:",cljs.core.clj__GT_js(new cljs.core.Keyword("atlas-ui.graph.node","identity","atlas-ui.graph.node/identity",1626823993).cljs$core$IFn$_invoke$arity$1(entity)));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(atlas_ui.core.app_state,cljs.core.assoc,new cljs.core.Keyword("atlas-ui.ui.state","highlight-selection","atlas-ui.ui.state/highlight-selection",1962029238),entity,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("atlas-ui.ui.state","highlighted-entity-aspects","atlas-ui.ui.state/highlighted-entity-aspects",-1183922094),(function (){var or__5002__auto__ = new cljs.core.Keyword("atlas-ui.graph.node","identity","atlas-ui.graph.node/identity",1626823993).cljs$core$IFn$_invoke$arity$1(entity);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})(),new cljs.core.Keyword("atlas-ui.ui.state","legend-focus","atlas-ui.ui.state/legend-focus",1454999652),null,new cljs.core.Keyword("atlas-ui.ui.state","highlight-aspect","atlas-ui.ui.state/highlight-aspect",-439313600),null], 0));
} else {
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(atlas_ui.core.app_state,cljs.core.assoc,new cljs.core.Keyword("atlas-ui.ui.state","highlight-selection","atlas-ui.ui.state/highlight-selection",1962029238),null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("atlas-ui.ui.state","highlighted-entity-aspects","atlas-ui.ui.state/highlighted-entity-aspects",-1183922094),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword("atlas-ui.ui.state","highlight-aspect","atlas-ui.ui.state/highlight-aspect",-439313600),null], 0));
}
}
});
atlas_ui.core.handle_clear_selections = (function atlas_ui$core$handle_clear_selections(){

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(atlas_ui.core.app_state,cljs.core.assoc,new cljs.core.Keyword("atlas-ui.ui.state","selections","atlas-ui.ui.state/selections",275746488),cljs.core.PersistentHashSet.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("atlas-ui.ui.state","negated-aspects","atlas-ui.ui.state/negated-aspects",1962237344),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword("atlas-ui.ui.state","min-score","atlas-ui.ui.state/min-score",-303626122),0.0,new cljs.core.Keyword("atlas-ui.ui.state","hide-unmatched?","atlas-ui.ui.state/hide-unmatched?",1823675889),false,new cljs.core.Keyword("atlas-ui.ui.state","highlight-selection","atlas-ui.ui.state/highlight-selection",1962029238),null,new cljs.core.Keyword("atlas-ui.ui.state","highlighted-entity-aspects","atlas-ui.ui.state/highlighted-entity-aspects",-1183922094),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword("atlas-ui.ui.state","highlight-aspect","atlas-ui.ui.state/highlight-aspect",-439313600),null,new cljs.core.Keyword("atlas-ui.ui.state","legend-focus","atlas-ui.ui.state/legend-focus",1454999652),null], 0));
});
atlas_ui.core.handle_set_query_mode = (function atlas_ui$core$handle_set_query_mode(mode){

console.log("\u00F0\u0178\u201D\u201E Query mode:",mode);

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(atlas_ui.core.app_state,cljs.core.assoc,new cljs.core.Keyword("atlas-ui.ui.state","query-mode","atlas-ui.ui.state/query-mode",975963741),mode);
});
atlas_ui.core.handle_toggle_visibility = (function atlas_ui$core$handle_toggle_visibility(){

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(atlas_ui.core.app_state,cljs.core.update,new cljs.core.Keyword("atlas-ui.ui.state","hide-unmatched?","atlas-ui.ui.state/hide-unmatched?",1823675889),cljs.core.not);
});
atlas_ui.core.handle_set_min_score = (function atlas_ui$core$handle_set_min_score(min_score){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(atlas_ui.core.app_state,cljs.core.assoc,new cljs.core.Keyword("atlas-ui.ui.state","min-score","atlas-ui.ui.state/min-score",-303626122),min_score);
});
atlas_ui.core.handle_search_change = (function atlas_ui$core$handle_search_change(term){

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(atlas_ui.core.app_state,cljs.core.assoc,new cljs.core.Keyword("atlas-ui.ui.state","search-term","atlas-ui.ui.state/search-term",-305959559),term);
});
atlas_ui.core.handle_toggle_type = (function atlas_ui$core$handle_toggle_type(entity_type){

console.log("\uD83D\uDD00 Toggle type:",entity_type);

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(atlas_ui.core.app_state,cljs.core.update,new cljs.core.Keyword("atlas-ui.ui.state","selected-types","atlas-ui.ui.state/selected-types",-1062003055),(function (types){
if(cljs.core.contains_QMARK_(types,entity_type)){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(types,entity_type);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(types,entity_type);
}
}));
});
/**
 * Push current lens to history, clearing any forward history
 */
atlas_ui.core.push_to_history_BANG_ = (function atlas_ui$core$push_to_history_BANG_(lens_spec){
if(cljs.core.truth_(lens_spec)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(atlas_ui.core.app_state,(function (state){
var history__$1 = new cljs.core.Keyword("atlas-ui.ui.state","lens-history","atlas-ui.ui.state/lens-history",534052961).cljs$core$IFn$_invoke$arity$1(state);
var index = new cljs.core.Keyword("atlas-ui.ui.state","lens-history-index","atlas-ui.ui.state/lens-history-index",-21459817).cljs$core$IFn$_invoke$arity$1(state);
var new_history = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(history__$1,(0),(index + (1))),lens_spec);
var new_index = (cljs.core.count(new_history) - (1));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(state,new cljs.core.Keyword("atlas-ui.ui.state","lens-history","atlas-ui.ui.state/lens-history",534052961),new_history,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("atlas-ui.ui.state","lens-history-index","atlas-ui.ui.state/lens-history-index",-21459817),new_index], 0));
}));
} else {
return null;
}
});
atlas_ui.core.handle_activate_lens_BANG_ = (function atlas_ui$core$handle_activate_lens_BANG_(lens_type,lens_value){

console.log("\uD83D\uDD0D Activating lens:",lens_type,lens_value);

var lens_spec = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lens_type,new cljs.core.Keyword(null,"combination","combination",1695836532)))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(lens_value,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"combination","combination",1695836532)):new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),lens_type,new cljs.core.Keyword(null,"value","value",305978217),lens_value], null));
atlas_ui.core.push_to_history_BANG_(lens_spec);

(atlas_ui.core.update_url_with_lens_BANG_.cljs$core$IFn$_invoke$arity$1 ? atlas_ui.core.update_url_with_lens_BANG_.cljs$core$IFn$_invoke$arity$1(lens_spec) : atlas_ui.core.update_url_with_lens_BANG_.call(null,lens_spec));

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(atlas_ui.core.app_state,cljs.core.assoc,new cljs.core.Keyword("atlas-ui.ui.state","active-lens","atlas-ui.ui.state/active-lens",-596367764),lens_spec,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("atlas-ui.ui.state","show-lens-selector?","atlas-ui.ui.state/show-lens-selector?",522076301),false,new cljs.core.Keyword("atlas-ui.ui.state","combination-lenses","atlas-ui.ui.state/combination-lenses",-2020357275),cljs.core.PersistentVector.EMPTY], 0));

return setTimeout((function (){
var filtered = cljs.core.deref(atlas_ui.core.filtered_graph_data);
return console.log("\uD83D\uDD0D Lens filtered to:",cljs.core.count(new cljs.core.Keyword("atlas-ui.graph.data","entities","atlas-ui.graph.data/entities",-1980533303).cljs$core$IFn$_invoke$arity$1(filtered)),"entities,",cljs.core.count(new cljs.core.Keyword("atlas-ui.graph.data","aspects","atlas-ui.graph.data/aspects",1960033811).cljs$core$IFn$_invoke$arity$1(filtered)),"aspects,",cljs.core.count(new cljs.core.Keyword("atlas-ui.graph.data","all-nodes","atlas-ui.graph.data/all-nodes",187343157).cljs$core$IFn$_invoke$arity$1(filtered)),"total nodes");
}),(100));
});
atlas_ui.core.handle_clear_lens_BANG_ = (function atlas_ui$core$handle_clear_lens_BANG_(){

console.log("\uD83D\uDDFA\uFE0F Clearing lens - returning to explorer mode");

(atlas_ui.core.update_url_with_lens_BANG_.cljs$core$IFn$_invoke$arity$1 ? atlas_ui.core.update_url_with_lens_BANG_.cljs$core$IFn$_invoke$arity$1(null) : atlas_ui.core.update_url_with_lens_BANG_.call(null,null));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(atlas_ui.core.app_state,cljs.core.assoc,new cljs.core.Keyword("atlas-ui.ui.state","active-lens","atlas-ui.ui.state/active-lens",-596367764),null);
});
atlas_ui.core.handle_toggle_lens_selector_BANG_ = (function atlas_ui$core$handle_toggle_lens_selector_BANG_(){

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(atlas_ui.core.app_state,cljs.core.update,new cljs.core.Keyword("atlas-ui.ui.state","show-lens-selector?","atlas-ui.ui.state/show-lens-selector?",522076301),cljs.core.not);
});
atlas_ui.core.handle_lens_back_BANG_ = (function atlas_ui$core$handle_lens_back_BANG_(){

var state = cljs.core.deref(atlas_ui.core.app_state);
var index = new cljs.core.Keyword("atlas-ui.ui.state","lens-history-index","atlas-ui.ui.state/lens-history-index",-21459817).cljs$core$IFn$_invoke$arity$1(state);
if((index > (0))){
var new_index = (index - (1));
var history__$1 = new cljs.core.Keyword("atlas-ui.ui.state","lens-history","atlas-ui.ui.state/lens-history",534052961).cljs$core$IFn$_invoke$arity$1(state);
var prev_lens = cljs.core.get.cljs$core$IFn$_invoke$arity$2(history__$1,new_index);
console.log("\u2B05\uFE0F  Going back in history to:",prev_lens);

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(atlas_ui.core.app_state,cljs.core.assoc,new cljs.core.Keyword("atlas-ui.ui.state","lens-history-index","atlas-ui.ui.state/lens-history-index",-21459817),new_index,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("atlas-ui.ui.state","active-lens","atlas-ui.ui.state/active-lens",-596367764),prev_lens], 0));
} else {
return null;
}
});
atlas_ui.core.handle_lens_forward_BANG_ = (function atlas_ui$core$handle_lens_forward_BANG_(){

var state = cljs.core.deref(atlas_ui.core.app_state);
var index = new cljs.core.Keyword("atlas-ui.ui.state","lens-history-index","atlas-ui.ui.state/lens-history-index",-21459817).cljs$core$IFn$_invoke$arity$1(state);
var history__$1 = new cljs.core.Keyword("atlas-ui.ui.state","lens-history","atlas-ui.ui.state/lens-history",534052961).cljs$core$IFn$_invoke$arity$1(state);
if((index < (cljs.core.count(history__$1) - (1)))){
var new_index = (index + (1));
var next_lens = cljs.core.get.cljs$core$IFn$_invoke$arity$2(history__$1,new_index);
console.log("\u27A1\uFE0F  Going forward in history to:",next_lens);

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(atlas_ui.core.app_state,cljs.core.assoc,new cljs.core.Keyword("atlas-ui.ui.state","lens-history-index","atlas-ui.ui.state/lens-history-index",-21459817),new_index,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("atlas-ui.ui.state","active-lens","atlas-ui.ui.state/active-lens",-596367764),next_lens], 0));
} else {
return null;
}
});
/**
 * Encode lens spec to URL parameters
 */
atlas_ui.core.lens_spec_to_url_params = (function atlas_ui$core$lens_spec_to_url_params(lens_spec){
if(cljs.core.truth_(lens_spec)){
var type = cljs.core.name(new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(lens_spec));
var value = (((new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(lens_spec) instanceof cljs.core.Keyword))?[cljs.core.namespace(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(lens_spec)),"/",cljs.core.name(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(lens_spec))].join(''):cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(lens_spec)));
return ["?lens=",type,"&value=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(value))].join('');
} else {
return null;
}
});
/**
 * Decode URL parameters to lens spec
 */
atlas_ui.core.url_params_to_lens_spec = (function atlas_ui$core$url_params_to_lens_spec(){
var params = (new URLSearchParams(window.location.search));
var lens_type = params.get("lens");
var lens_value = params.get("value");
if(cljs.core.truth_((function (){var and__5000__auto__ = lens_type;
if(cljs.core.truth_(and__5000__auto__)){
return lens_value;
} else {
return and__5000__auto__;
}
})())){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(lens_type),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(lens_value)], null);
} else {
return null;
}
});
/**
 * Update browser URL with current lens (without reload)
 */
atlas_ui.core.update_url_with_lens_BANG_ = (function atlas_ui$core$update_url_with_lens_BANG_(lens_spec){
var url_params = atlas_ui.core.lens_spec_to_url_params(lens_spec);
var new_url = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(window.location.pathname),(function (){var or__5002__auto__ = url_params;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return "";
}
})()].join('');
return window.history.pushState(null,"",new_url);
});
/**
 * Copy current lens URL to clipboard
 */
atlas_ui.core.copy_lens_url_to_clipboard_BANG_ = (function atlas_ui$core$copy_lens_url_to_clipboard_BANG_(){
var lens_spec = new cljs.core.Keyword("atlas-ui.ui.state","active-lens","atlas-ui.ui.state/active-lens",-596367764).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui.core.app_state));
var url_params = atlas_ui.core.lens_spec_to_url_params(lens_spec);
var full_url = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(window.location.origin),cljs.core.str.cljs$core$IFn$_invoke$arity$1(window.location.pathname),url_params].join('');
if(cljs.core.truth_(lens_spec)){
navigator.clipboard.writeText(full_url);

console.log("\uD83D\uDCCB Copied lens URL to clipboard:",full_url);

return alert("Lens URL copied to clipboard!");
} else {
return null;
}
});
/**
 * Load lens from URL parameters on page load
 */
atlas_ui.core.load_lens_from_url_BANG_ = (function atlas_ui$core$load_lens_from_url_BANG_(){
var lens_spec = atlas_ui.core.url_params_to_lens_spec();
if(cljs.core.truth_(lens_spec)){
console.log("\uD83D\uDD17 Loading lens from URL:",lens_spec);

atlas_ui.core.push_to_history_BANG_(lens_spec);

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(atlas_ui.core.app_state,cljs.core.assoc,new cljs.core.Keyword("atlas-ui.ui.state","active-lens","atlas-ui.ui.state/active-lens",-596367764),lens_spec);
} else {
return null;
}
});
atlas_ui.core.handle_save_preset_BANG_ = (function atlas_ui$core$handle_save_preset_BANG_(preset_name){

var active_lens = new cljs.core.Keyword("atlas-ui.ui.state","active-lens","atlas-ui.ui.state/active-lens",-596367764).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui.core.app_state));
if(cljs.core.truth_(active_lens)){
var preset_id = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(["preset-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid())].join(''));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(atlas_ui.core.app_state,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("atlas-ui.ui.state","lens-presets","atlas-ui.ui.state/lens-presets",1303851224),preset_id], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),preset_name,new cljs.core.Keyword(null,"lens-spec","lens-spec",1953469180),active_lens], null));

return console.log("\uD83D\uDCBE Saved preset:",preset_name);
} else {
return null;
}
});
atlas_ui.core.handle_load_preset_BANG_ = (function atlas_ui$core$handle_load_preset_BANG_(preset_id){

var presets = new cljs.core.Keyword("atlas-ui.ui.state","lens-presets","atlas-ui.ui.state/lens-presets",1303851224).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui.core.app_state));
var preset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(presets,preset_id);
if(cljs.core.truth_(preset)){
console.log("\uD83D\uDCC2 Loading preset:",new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(preset));

var lens_spec = new cljs.core.Keyword(null,"lens-spec","lens-spec",1953469180).cljs$core$IFn$_invoke$arity$1(preset);
atlas_ui.core.push_to_history_BANG_(lens_spec);

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(atlas_ui.core.app_state,cljs.core.assoc,new cljs.core.Keyword("atlas-ui.ui.state","active-lens","atlas-ui.ui.state/active-lens",-596367764),lens_spec,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("atlas-ui.ui.state","show-presets?","atlas-ui.ui.state/show-presets?",2051990435),false], 0));
} else {
return null;
}
});
atlas_ui.core.handle_delete_preset_BANG_ = (function atlas_ui$core$handle_delete_preset_BANG_(preset_id){

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(atlas_ui.core.app_state,cljs.core.update,new cljs.core.Keyword("atlas-ui.ui.state","lens-presets","atlas-ui.ui.state/lens-presets",1303851224),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([preset_id], 0));

return console.log("\uD83D\uDDD1\uFE0F  Deleted preset:",preset_id);
});
atlas_ui.core.handle_toggle_presets_BANG_ = (function atlas_ui$core$handle_toggle_presets_BANG_(){

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(atlas_ui.core.app_state,cljs.core.update,new cljs.core.Keyword("atlas-ui.ui.state","show-presets?","atlas-ui.ui.state/show-presets?",2051990435),cljs.core.not);
});
atlas_ui.core.refresh_registry_BANG_ = (function atlas_ui$core$refresh_registry_BANG_(){
console.log("Refreshing registry...");

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(atlas_ui.core.app_state,cljs.core.assoc,new cljs.core.Keyword("atlas-ui.ui.state","loading?","atlas-ui.ui.state/loading?",-1728094052),true,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("atlas-ui.ui.state","error","atlas-ui.ui.state/error",487381415),null], 0));

return atlas_ui.api.fetch_registry_with_fallback_BANG_(atlas_ui.core.handle_registry_loaded);
});
atlas_ui.core.header_component = (function atlas_ui$core$header_component(){
var state = cljs.core.deref(atlas_ui.core.app_state);
var has_lens_QMARK_ = new cljs.core.Keyword("atlas-ui.ui.state","active-lens","atlas-ui.ui.state/active-lens",-596367764).cljs$core$IFn$_invoke$arity$1(state);
var history__$1 = new cljs.core.Keyword("atlas-ui.ui.state","lens-history","atlas-ui.ui.state/lens-history",534052961).cljs$core$IFn$_invoke$arity$1(state);
var history_index = new cljs.core.Keyword("atlas-ui.ui.state","lens-history-index","atlas-ui.ui.state/lens-history-index",-21459817).cljs$core$IFn$_invoke$arity$1(state);
var can_go_back_QMARK_ = (history_index > (0));
var can_go_forward_QMARK_ = (history_index < (cljs.core.count(history__$1) - (1)));
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.header","div.header",1964513620),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"padding","padding",1660304693),"16px 24px",new cljs.core.Keyword(null,"backgroundColor","backgroundColor",1738438491),"#111827",new cljs.core.Keyword(null,"color","color",1011675173),"#ffffff",new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"justifyContent","justifyContent",885406515),"space-between",new cljs.core.Keyword(null,"alignItems","alignItems",410331199),"center",new cljs.core.Keyword(null,"boxShadow","boxShadow",-1591689862),"0 1px 3px rgba(0, 0, 0, 0.1)"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h1","h1",-1896887462),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"margin","margin",-995903681),"0",new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"20px",new cljs.core.Keyword(null,"fontWeight","fontWeight",166450581),"600",new cljs.core.Keyword(null,"letterSpacing","letterSpacing",-1331934989),"-0.025em"], null)], null),"Atlas Viewer"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"margin","margin",-995903681),"2px 0 0 0",new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"12px",new cljs.core.Keyword(null,"color","color",1011675173),"#9ca3af"], null)], null),"Multi-Aspect Query Explorer"], null)], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"alignItems","alignItems",410331199),"center",new cljs.core.Keyword(null,"gap","gap",80255254),"12px"], null)], null),(cljs.core.truth_(new cljs.core.Keyword("atlas-ui.ui.state","loading?","atlas-ui.ui.state/loading?",-1728094052).cljs$core$IFn$_invoke$arity$1(state))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"12px",new cljs.core.Keyword(null,"color","color",1011675173),"#9ca3af"], null)], null),"Loading..."], null):null),(cljs.core.truth_(has_lens_QMARK_)?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"gap","gap",80255254),"4px",new cljs.core.Keyword(null,"marginRight","marginRight",457313535),"8px"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),atlas_ui.core.handle_lens_back_BANG_,new cljs.core.Keyword(null,"disabled","disabled",-1529784218),(!(can_go_back_QMARK_)),new cljs.core.Keyword(null,"title","title",636505583),"Go back in lens history ([)",new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"padding","padding",1660304693),"6px 10px",new cljs.core.Keyword(null,"backgroundColor","backgroundColor",1738438491),((can_go_back_QMARK_)?"#374151":"#1f2937"),new cljs.core.Keyword(null,"color","color",1011675173),((can_go_back_QMARK_)?"#ffffff":"#6b7280"),new cljs.core.Keyword(null,"border","border",1444987323),"none",new cljs.core.Keyword(null,"borderRadius","borderRadius",-1505621083),"4px",new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"14px",new cljs.core.Keyword(null,"cursor","cursor",1011937484),((can_go_back_QMARK_)?"pointer":"not-allowed"),new cljs.core.Keyword(null,"opacity","opacity",397153780),((can_go_back_QMARK_)?"1":"0.5")], null)], null),"\u25C0"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),atlas_ui.core.handle_lens_forward_BANG_,new cljs.core.Keyword(null,"disabled","disabled",-1529784218),(!(can_go_forward_QMARK_)),new cljs.core.Keyword(null,"title","title",636505583),"Go forward in lens history (])",new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"padding","padding",1660304693),"6px 10px",new cljs.core.Keyword(null,"backgroundColor","backgroundColor",1738438491),((can_go_forward_QMARK_)?"#374151":"#1f2937"),new cljs.core.Keyword(null,"color","color",1011675173),((can_go_forward_QMARK_)?"#ffffff":"#6b7280"),new cljs.core.Keyword(null,"border","border",1444987323),"none",new cljs.core.Keyword(null,"borderRadius","borderRadius",-1505621083),"4px",new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"14px",new cljs.core.Keyword(null,"cursor","cursor",1011937484),((can_go_forward_QMARK_)?"pointer":"not-allowed"),new cljs.core.Keyword(null,"opacity","opacity",397153780),((can_go_forward_QMARK_)?"1":"0.5")], null)], null),"\u25B6"], null)], null):null),(cljs.core.truth_(has_lens_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),atlas_ui.core.copy_lens_url_to_clipboard_BANG_,new cljs.core.Keyword(null,"title","title",636505583),"Copy lens URL to clipboard (Ctrl/Cmd+C)",new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"borderRadius","borderRadius",-1505621083),new cljs.core.Keyword(null,"transition","transition",765692007),new cljs.core.Keyword(null,"cursor","cursor",1011937484),new cljs.core.Keyword(null,"padding","padding",1660304693),new cljs.core.Keyword(null,"fontWeight","fontWeight",166450581),new cljs.core.Keyword(null,"fontSize","fontSize",919623033),new cljs.core.Keyword(null,"boxShadow","boxShadow",-1591689862),new cljs.core.Keyword(null,"border","border",1444987323),new cljs.core.Keyword(null,"backgroundColor","backgroundColor",1738438491)],["#ffffff","6px","all 0.2s","pointer","8px 16px","500","13px","0 1px 2px rgba(0, 0, 0, 0.05)","none","#8b5cf6"])], null),"\uD83D\uDD17 Share"], null):null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),atlas_ui.core.handle_toggle_presets_BANG_,new cljs.core.Keyword(null,"title","title",636505583),"Manage presets (P)",new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"borderRadius","borderRadius",-1505621083),new cljs.core.Keyword(null,"transition","transition",765692007),new cljs.core.Keyword(null,"cursor","cursor",1011937484),new cljs.core.Keyword(null,"padding","padding",1660304693),new cljs.core.Keyword(null,"fontWeight","fontWeight",166450581),new cljs.core.Keyword(null,"fontSize","fontSize",919623033),new cljs.core.Keyword(null,"boxShadow","boxShadow",-1591689862),new cljs.core.Keyword(null,"border","border",1444987323),new cljs.core.Keyword(null,"backgroundColor","backgroundColor",1738438491)],["#ffffff","6px","all 0.2s","pointer","8px 16px","500","13px","0 1px 2px rgba(0, 0, 0, 0.05)","none","#10b981"])], null),"\uD83D\uDCBE Presets"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),atlas_ui.core.handle_toggle_lens_selector_BANG_,new cljs.core.Keyword(null,"title","title",636505583),"Choose lens (L)",new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"borderRadius","borderRadius",-1505621083),new cljs.core.Keyword(null,"transition","transition",765692007),new cljs.core.Keyword(null,"cursor","cursor",1011937484),new cljs.core.Keyword(null,"padding","padding",1660304693),new cljs.core.Keyword(null,"fontWeight","fontWeight",166450581),new cljs.core.Keyword(null,"fontSize","fontSize",919623033),new cljs.core.Keyword(null,"boxShadow","boxShadow",-1591689862),new cljs.core.Keyword(null,"border","border",1444987323),new cljs.core.Keyword(null,"backgroundColor","backgroundColor",1738438491)],["#ffffff","6px","all 0.2s","pointer","8px 16px","500","13px","0 1px 2px rgba(0, 0, 0, 0.05)","none",(cljs.core.truth_(has_lens_QMARK_)?"#3b82f6":"#6b7280")])], null),(cljs.core.truth_(has_lens_QMARK_)?"\uD83D\uDD0D Lens Active":"\uD83D\uDD0D Choose Lens")], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),atlas_ui.core.refresh_registry_BANG_,new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"borderRadius","borderRadius",-1505621083),new cljs.core.Keyword(null,"transition","transition",765692007),new cljs.core.Keyword(null,"cursor","cursor",1011937484),new cljs.core.Keyword(null,"padding","padding",1660304693),new cljs.core.Keyword(null,"fontWeight","fontWeight",166450581),new cljs.core.Keyword(null,"fontSize","fontSize",919623033),new cljs.core.Keyword(null,"boxShadow","boxShadow",-1591689862),new cljs.core.Keyword(null,"border","border",1444987323),new cljs.core.Keyword(null,"backgroundColor","backgroundColor",1738438491)],["#ffffff","6px","background-color 0.2s","pointer","8px 16px","500","13px","0 1px 2px rgba(0, 0, 0, 0.05)","none","#7c3aed"])], null),"\u21BB Refresh"], null)], null)], null);
});
atlas_ui.core.info_panel = (function atlas_ui$core$info_panel(){

var entities = new cljs.core.Keyword("atlas-ui.graph.data","entities","atlas-ui.graph.data/entities",-1980533303).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui.core.filtered_graph_data));
var aspects = new cljs.core.Keyword("atlas-ui.graph.data","aspects","atlas-ui.graph.data/aspects",1960033811).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui.core.filtered_graph_data));
var edges = new cljs.core.Keyword("atlas-ui.graph.data","edges","atlas-ui.graph.data/edges",-707560193).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui.core.filtered_graph_data));
var selections = new cljs.core.Keyword("atlas-ui.ui.state","selections","atlas-ui.ui.state/selections",275746488).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui.core.app_state));
var active_lens = new cljs.core.Keyword("atlas-ui.ui.state","active-lens","atlas-ui.ui.state/active-lens",-596367764).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui.core.app_state));
var lens = cljs.core.deref(atlas_ui.core.lens_result);
var stats = cljs.core.deref(atlas_ui.core.match_stats);
return new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.info-panel","div.info-panel",-300980893),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"backdropFilter","backdropFilter",-221215069),new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"borderRadius","borderRadius",-1505621083),new cljs.core.Keyword(null,"bottom","bottom",-1550509018),new cljs.core.Keyword(null,"minWidth","minWidth",-204293526),new cljs.core.Keyword(null,"padding","padding",1660304693),new cljs.core.Keyword(null,"zIndex","zIndex",-1588341609),new cljs.core.Keyword(null,"position","position",-2011731912),new cljs.core.Keyword(null,"fontSize","fontSize",919623033),new cljs.core.Keyword(null,"boxShadow","boxShadow",-1591689862),new cljs.core.Keyword(null,"backgroundColor","backgroundColor",1738438491),new cljs.core.Keyword(null,"left","left",-399115937)],["blur(8px)","#6b7280","8px","20px","200px","16px",(1000),"absolute","12px","0 4px 6px rgba(0, 0, 0, 0.1)","rgba(255, 255, 255, 0.95)","20px"])], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),"8px",new cljs.core.Keyword(null,"fontWeight","fontWeight",166450581),"600",new cljs.core.Keyword(null,"color","color",1011675173),"#374151"], null)], null),"Registry Statistics"], null),(cljs.core.truth_(lens)?new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),"12px",new cljs.core.Keyword(null,"padding","padding",1660304693),"8px",new cljs.core.Keyword(null,"backgroundColor","backgroundColor",1738438491),"#dbeafe",new cljs.core.Keyword(null,"borderRadius","borderRadius",-1505621083),"6px",new cljs.core.Keyword(null,"border","border",1444987323),"1px solid #3b82f6"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"11px",new cljs.core.Keyword(null,"fontWeight","fontWeight",166450581),"600",new cljs.core.Keyword(null,"color","color",1011675173),"#1e40af",new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),"4px"], null)], null),"\uD83D\uDD0D LENS ACTIVE"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"10px",new cljs.core.Keyword(null,"color","color",1011675173),"#1e3a8a"], null)], null),new cljs.core.Keyword(null,"title","title",636505583).cljs$core$IFn$_invoke$arity$1(lens)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"9px",new cljs.core.Keyword(null,"color","color",1011675173),"#6b7280",new cljs.core.Keyword(null,"marginTop","marginTop",-1403015220),"2px"], null)], null),cljs.core.count(entities)," entities visible"], null)], null):null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),"Entities: ",cljs.core.count(entities)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),"Aspects: ",cljs.core.count(aspects)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),"Edges: ",cljs.core.count(edges)], null),(cljs.core.truth_(stats)?new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"marginTop","marginTop",-1403015220),"12px",new cljs.core.Keyword(null,"paddingTop","paddingTop",-1088692345),"12px",new cljs.core.Keyword(null,"borderTop","borderTop",2080227753),"1px solid #e5e7eb"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fontWeight","fontWeight",166450581),"600",new cljs.core.Keyword(null,"color","color",1011675173),"#374151",new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),"4px"], null)], null),"Query Results"], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"color","color",1011675173),"#059669",new cljs.core.Keyword(null,"fontWeight","fontWeight",166450581),"500"], null)], null),new cljs.core.Keyword("atlas-ui.stats","matching","atlas-ui.stats/matching",-446162268).cljs$core$IFn$_invoke$arity$1(stats)," / ",new cljs.core.Keyword("atlas-ui.stats","total","atlas-ui.stats/total",370708601).cljs$core$IFn$_invoke$arity$1(stats)," matching"], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"10px",new cljs.core.Keyword(null,"color","color",1011675173),"#9ca3af",new cljs.core.Keyword(null,"marginTop","marginTop",-1403015220),"2px"], null)], null),new cljs.core.Keyword("atlas-ui.stats","percentage","atlas-ui.stats/percentage",1552788261).cljs$core$IFn$_invoke$arity$1(stats),"% match"], null)], null):null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"marginTop","marginTop",-1403015220),"12px",new cljs.core.Keyword(null,"paddingTop","paddingTop",-1088692345),"12px",new cljs.core.Keyword(null,"borderTop","borderTop",2080227753),"1px solid #e5e7eb",new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"11px"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),"\uD83D\uDCA1 Click aspects to build query"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"marginTop","marginTop",-1403015220),"4px"], null)], null),"\uD83C\uDFA8 Color intensity = match score"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"marginTop","marginTop",-1403015220),"4px"], null)], null),"\u2328\uFE0F  ESC to clear"], null)], null)], null);
});
atlas_ui.core.lens_banner = (function atlas_ui$core$lens_banner(){

var lens = cljs.core.deref(atlas_ui.core.lens_result);
var impact_score = new cljs.core.Keyword(null,"impact-score","impact-score",-730988594).cljs$core$IFn$_invoke$arity$1(lens);
var impact_count = new cljs.core.Keyword(null,"impact-count","impact-count",-121528900).cljs$core$IFn$_invoke$arity$1(lens);
if(cljs.core.truth_(lens)){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.lens-banner","div.lens-banner",-405844623),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"backdropFilter","backdropFilter",-221215069),new cljs.core.Keyword(null,"transform","transform",1381301764),new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"borderRadius","borderRadius",-1505621083),new cljs.core.Keyword(null,"top","top",-1856271961),new cljs.core.Keyword(null,"padding","padding",1660304693),new cljs.core.Keyword(null,"fontWeight","fontWeight",166450581),new cljs.core.Keyword(null,"gap","gap",80255254),new cljs.core.Keyword(null,"zIndex","zIndex",-1588341609),new cljs.core.Keyword(null,"display","display",242065432),new cljs.core.Keyword(null,"position","position",-2011731912),new cljs.core.Keyword(null,"fontSize","fontSize",919623033),new cljs.core.Keyword(null,"boxShadow","boxShadow",-1591689862),new cljs.core.Keyword(null,"backgroundColor","backgroundColor",1738438491),new cljs.core.Keyword(null,"alignItems","alignItems",410331199),new cljs.core.Keyword(null,"left","left",-399115937)],["blur(8px)","translateX(-50%)","white","12px","20px","12px 24px","500","12px",(1500),"flex","absolute","14px",(function (){var G__12021 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(lens);
var G__12021__$1 = (((G__12021 instanceof cljs.core.Keyword))?G__12021.fqn:null);
switch (G__12021__$1) {
case "impact-analysis":
return "0 4px 12px rgba(239, 68, 68, 0.3)";

break;
default:
return "0 4px 12px rgba(59, 130, 246, 0.3)";

}
})(),(function (){var G__12022 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(lens);
var G__12022__$1 = (((G__12022 instanceof cljs.core.Keyword))?G__12022.fqn:null);
switch (G__12022__$1) {
case "impact-analysis":
return "rgba(239, 68, 68, 0.95)";

break;
default:
return "rgba(59, 130, 246, 0.95)";

}
})(),"center","50%"])], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"16px"], null)], null),(function (){var G__12023 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(lens);
var G__12023__$1 = (((G__12023 instanceof cljs.core.Keyword))?G__12023.fqn:null);
switch (G__12023__$1) {
case "impact-analysis":
return "\uD83D\uDCA5";

break;
default:
return "\uD83D\uDD0D";

}
})()], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"12px",new cljs.core.Keyword(null,"opacity","opacity",397153780),0.9], null)], null),(function (){var G__12024 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(lens);
var G__12024__$1 = (((G__12024 instanceof cljs.core.Keyword))?G__12024.fqn:null);
switch (G__12024__$1) {
case "impact-analysis":
return "IMPACT ANALYSIS";

break;
default:
return "LENS ACTIVE";

}
})()], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"14px",new cljs.core.Keyword(null,"fontWeight","fontWeight",166450581),"600"], null)], null),new cljs.core.Keyword(null,"title","title",636505583).cljs$core$IFn$_invoke$arity$1(lens)], null),((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(lens),new cljs.core.Keyword(null,"impact-analysis","impact-analysis",1563390103)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"11px",new cljs.core.Keyword(null,"opacity","opacity",397153780),0.9,new cljs.core.Keyword(null,"marginTop","marginTop",-1403015220),"2px"], null)], null),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(impact_count)," entities affected - ",cljs.core.name(impact_score)," risk"].join('')], null):null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),atlas_ui.core.handle_clear_lens_BANG_,new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"marginLeft","marginLeft",-551287007),new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"borderRadius","borderRadius",-1505621083),new cljs.core.Keyword(null,"transition","transition",765692007),new cljs.core.Keyword(null,"cursor","cursor",1011937484),new cljs.core.Keyword(null,"padding","padding",1660304693),new cljs.core.Keyword(null,"fontWeight","fontWeight",166450581),new cljs.core.Keyword(null,"fontSize","fontSize",919623033),new cljs.core.Keyword(null,"border","border",1444987323),new cljs.core.Keyword(null,"backgroundColor","backgroundColor",1738438491)],["8px","white","6px","all 0.2s","pointer","6px 12px","600","11px","1px solid rgba(255, 255, 255, 0.3)","rgba(255, 255, 255, 0.2)"])], null),"\u2715 Clear"], null)], null);
} else {
return null;
}
});
atlas_ui.core.lens_selector_component = (function atlas_ui$core$lens_selector_component(){

var registry = new cljs.core.Keyword("atlas-ui.ui.state","registry","atlas-ui.ui.state/registry",-446230821).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui.core.app_state));
var show_QMARK_ = new cljs.core.Keyword("atlas-ui.ui.state","show-lens-selector?","atlas-ui.ui.state/show-lens-selector?",522076301).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui.core.app_state));
var active_lens = new cljs.core.Keyword("atlas-ui.ui.state","active-lens","atlas-ui.ui.state/active-lens",-596367764).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui.core.app_state));
var available = ((cljs.core.seq(registry))?atlas_ui.lenses.available_lenses(registry):null);
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.lens-selector","div.lens-selector",1305906780),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"backdropFilter","backdropFilter",-221215069),new cljs.core.Keyword(null,"maxHeight","maxHeight",-2066822365),new cljs.core.Keyword(null,"maxWidth","maxWidth",-1375124795),new cljs.core.Keyword(null,"borderRadius","borderRadius",-1505621083),new cljs.core.Keyword(null,"top","top",-1856271961),new cljs.core.Keyword(null,"minWidth","minWidth",-204293526),new cljs.core.Keyword(null,"overflowY","overflowY",1522263150),new cljs.core.Keyword(null,"padding","padding",1660304693),new cljs.core.Keyword(null,"zIndex","zIndex",-1588341609),new cljs.core.Keyword(null,"display","display",242065432),new cljs.core.Keyword(null,"position","position",-2011731912),new cljs.core.Keyword(null,"boxShadow","boxShadow",-1591689862),new cljs.core.Keyword(null,"border","border",1444987323),new cljs.core.Keyword(null,"backgroundColor","backgroundColor",1738438491),new cljs.core.Keyword(null,"left","left",-399115937)],["blur(12px)","70vh","320px","12px","80px","280px","auto","20px",(2000),(cljs.core.truth_(show_QMARK_)?"block":"none"),"absolute","0 8px 24px rgba(0, 0, 0, 0.15)","2px solid #e5e7eb","rgba(255, 255, 255, 0.98)","20px"])], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"justifyContent","justifyContent",885406515),"space-between",new cljs.core.Keyword(null,"alignItems","alignItems",410331199),"center",new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),"16px"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h3","h3",2067611163),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"margin","margin",-995903681),"0",new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"16px",new cljs.core.Keyword(null,"fontWeight","fontWeight",166450581),"600",new cljs.core.Keyword(null,"color","color",1011675173),"#111827"], null)], null),"\uD83D\uDD0D Choose Lens"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),atlas_ui.core.handle_toggle_lens_selector_BANG_,new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"background","background",-863952629),"none",new cljs.core.Keyword(null,"border","border",1444987323),"none",new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"20px",new cljs.core.Keyword(null,"cursor","cursor",1011937484),"pointer",new cljs.core.Keyword(null,"color","color",1011675173),"#9ca3af",new cljs.core.Keyword(null,"padding","padding",1660304693),"0",new cljs.core.Keyword(null,"lineHeight","lineHeight",-1729831016),"1"], null)], null),"\u00D7"], null)], null),(cljs.core.truth_(active_lens)?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"padding","padding",1660304693),"12px",new cljs.core.Keyword(null,"backgroundColor","backgroundColor",1738438491),"#f3f4f6",new cljs.core.Keyword(null,"borderRadius","borderRadius",-1505621083),"8px",new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),"16px",new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"justifyContent","justifyContent",885406515),"space-between",new cljs.core.Keyword(null,"alignItems","alignItems",410331199),"center"], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"12px",new cljs.core.Keyword(null,"color","color",1011675173),"#6b7280"], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fontWeight","fontWeight",166450581),"600",new cljs.core.Keyword(null,"color","color",1011675173),"#111827",new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),"2px"], null)], null),"Active: ",cljs.core.name(new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(active_lens))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"11px"], null)], null),(function (){var lens_value = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(active_lens);
if((lens_value instanceof cljs.core.Keyword)){
return cljs.core.name(lens_value);
} else {
if(cljs.core.map_QMARK_(lens_value)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(new cljs.core.Keyword(null,"lenses","lenses",-740611109).cljs$core$IFn$_invoke$arity$1(lens_value)))," combined"].join('');
} else {
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(lens_value);

}
}
})()], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),atlas_ui.core.handle_clear_lens_BANG_,new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"padding","padding",1660304693),"6px 12px",new cljs.core.Keyword(null,"backgroundColor","backgroundColor",1738438491),"#7c3aed",new cljs.core.Keyword(null,"color","color",1011675173),"white",new cljs.core.Keyword(null,"border","border",1444987323),"none",new cljs.core.Keyword(null,"borderRadius","borderRadius",-1505621083),"6px",new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"11px",new cljs.core.Keyword(null,"fontWeight","fontWeight",166450581),"500",new cljs.core.Keyword(null,"cursor","cursor",1011937484),"pointer"], null)], null),"Clear"], null)], null):null),((cljs.core.seq(new cljs.core.Keyword(null,"domains","domains",1410387719).cljs$core$IFn$_invoke$arity$1(available)))?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.lens-category","div.lens-category",1552522922),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),"20px"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h4","h4",2004862993),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"margin","margin",-995903681),"0 0 8px 0",new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"13px",new cljs.core.Keyword(null,"fontWeight","fontWeight",166450581),"600",new cljs.core.Keyword(null,"color","color",1011675173),"#6b7280",new cljs.core.Keyword(null,"textTransform","textTransform",-1959669529),"uppercase",new cljs.core.Keyword(null,"letterSpacing","letterSpacing",-1331934989),"0.05em"], null)], null),"By Domain"], null),(function (){var iter__5480__auto__ = (function atlas_ui$core$lens_selector_component_$_iter__12028(s__12029){
return (new cljs.core.LazySeq(null,(function (){
var s__12029__$1 = s__12029;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__12029__$1);
if(temp__5804__auto__){
var s__12029__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__12029__$2)){
var c__5478__auto__ = cljs.core.chunk_first(s__12029__$2);
var size__5479__auto__ = cljs.core.count(c__5478__auto__);
var b__12031 = cljs.core.chunk_buffer(size__5479__auto__);
if((function (){var i__12030 = (0);
while(true){
if((i__12030 < size__5479__auto__)){
var domain = cljs.core._nth(c__5478__auto__,i__12030);
cljs.core.chunk_append(b__12031,cljs.core.with_meta(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button.lens-btn","button.lens-btn",257357930),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (i__12030,domain,c__5478__auto__,size__5479__auto__,b__12031,s__12029__$2,temp__5804__auto__,registry,show_QMARK_,active_lens,available){
return (function (){
return atlas_ui.core.handle_activate_lens_BANG_(new cljs.core.Keyword(null,"domain","domain",1847214937),domain);
});})(i__12030,domain,c__5478__auto__,size__5479__auto__,b__12031,s__12029__$2,temp__5804__auto__,registry,show_QMARK_,active_lens,available))
,new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"borderRadius","borderRadius",-1505621083),new cljs.core.Keyword(null,"transition","transition",765692007),new cljs.core.Keyword(null,"width","width",-384071477),new cljs.core.Keyword(null,"cursor","cursor",1011937484),new cljs.core.Keyword(null,"padding","padding",1660304693),new cljs.core.Keyword(null,"fontWeight","fontWeight",166450581),new cljs.core.Keyword(null,"textAlign","textAlign",-711351626),new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),new cljs.core.Keyword(null,"display","display",242065432),new cljs.core.Keyword(null,"fontSize","fontSize",919623033),new cljs.core.Keyword(null,"border","border",1444987323),new cljs.core.Keyword(null,"backgroundColor","backgroundColor",1738438491)],["#374151","6px","all 0.2s","100%","pointer","10px 12px","500","left","6px","block","13px","1px solid #e5e7eb",(cljs.core.truth_((function (){var and__5000__auto__ = active_lens;
if(cljs.core.truth_(and__5000__auto__)){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(active_lens),new cljs.core.Keyword(null,"domain","domain",1847214937))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(active_lens),domain)));
} else {
return and__5000__auto__;
}
})())?"#ddd6fe":"#ffffff")])], null),"\uD83C\uDFE2 ",cljs.core.name(domain)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),domain], null)));

var G__12109 = (i__12030 + (1));
i__12030 = G__12109;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__12031),atlas_ui$core$lens_selector_component_$_iter__12028(cljs.core.chunk_rest(s__12029__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__12031),null);
}
} else {
var domain = cljs.core.first(s__12029__$2);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button.lens-btn","button.lens-btn",257357930),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (domain,s__12029__$2,temp__5804__auto__,registry,show_QMARK_,active_lens,available){
return (function (){
return atlas_ui.core.handle_activate_lens_BANG_(new cljs.core.Keyword(null,"domain","domain",1847214937),domain);
});})(domain,s__12029__$2,temp__5804__auto__,registry,show_QMARK_,active_lens,available))
,new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"borderRadius","borderRadius",-1505621083),new cljs.core.Keyword(null,"transition","transition",765692007),new cljs.core.Keyword(null,"width","width",-384071477),new cljs.core.Keyword(null,"cursor","cursor",1011937484),new cljs.core.Keyword(null,"padding","padding",1660304693),new cljs.core.Keyword(null,"fontWeight","fontWeight",166450581),new cljs.core.Keyword(null,"textAlign","textAlign",-711351626),new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),new cljs.core.Keyword(null,"display","display",242065432),new cljs.core.Keyword(null,"fontSize","fontSize",919623033),new cljs.core.Keyword(null,"border","border",1444987323),new cljs.core.Keyword(null,"backgroundColor","backgroundColor",1738438491)],["#374151","6px","all 0.2s","100%","pointer","10px 12px","500","left","6px","block","13px","1px solid #e5e7eb",(cljs.core.truth_((function (){var and__5000__auto__ = active_lens;
if(cljs.core.truth_(and__5000__auto__)){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(active_lens),new cljs.core.Keyword(null,"domain","domain",1847214937))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(active_lens),domain)));
} else {
return and__5000__auto__;
}
})())?"#ddd6fe":"#ffffff")])], null),"\uD83C\uDFE2 ",cljs.core.name(domain)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),domain], null)),atlas_ui$core$lens_selector_component_$_iter__12028(cljs.core.rest(s__12029__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5480__auto__(cljs.core.sort.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"domains","domains",1410387719).cljs$core$IFn$_invoke$arity$1(available)));
})()], null):null),((cljs.core.seq(new cljs.core.Keyword(null,"tiers","tiers",-46242789).cljs$core$IFn$_invoke$arity$1(available)))?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.lens-category","div.lens-category",1552522922),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),"20px"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h4","h4",2004862993),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"margin","margin",-995903681),"0 0 8px 0",new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"13px",new cljs.core.Keyword(null,"fontWeight","fontWeight",166450581),"600",new cljs.core.Keyword(null,"color","color",1011675173),"#6b7280",new cljs.core.Keyword(null,"textTransform","textTransform",-1959669529),"uppercase",new cljs.core.Keyword(null,"letterSpacing","letterSpacing",-1331934989),"0.05em"], null)], null),"By Tier"], null),(function (){var iter__5480__auto__ = (function atlas_ui$core$lens_selector_component_$_iter__12032(s__12033){
return (new cljs.core.LazySeq(null,(function (){
var s__12033__$1 = s__12033;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__12033__$1);
if(temp__5804__auto__){
var s__12033__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__12033__$2)){
var c__5478__auto__ = cljs.core.chunk_first(s__12033__$2);
var size__5479__auto__ = cljs.core.count(c__5478__auto__);
var b__12035 = cljs.core.chunk_buffer(size__5479__auto__);
if((function (){var i__12034 = (0);
while(true){
if((i__12034 < size__5479__auto__)){
var tier = cljs.core._nth(c__5478__auto__,i__12034);
cljs.core.chunk_append(b__12035,cljs.core.with_meta(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button.lens-btn","button.lens-btn",257357930),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (i__12034,tier,c__5478__auto__,size__5479__auto__,b__12035,s__12033__$2,temp__5804__auto__,registry,show_QMARK_,active_lens,available){
return (function (){
return atlas_ui.core.handle_activate_lens_BANG_(new cljs.core.Keyword(null,"tier","tier",-1071893374),tier);
});})(i__12034,tier,c__5478__auto__,size__5479__auto__,b__12035,s__12033__$2,temp__5804__auto__,registry,show_QMARK_,active_lens,available))
,new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"borderRadius","borderRadius",-1505621083),new cljs.core.Keyword(null,"transition","transition",765692007),new cljs.core.Keyword(null,"width","width",-384071477),new cljs.core.Keyword(null,"cursor","cursor",1011937484),new cljs.core.Keyword(null,"padding","padding",1660304693),new cljs.core.Keyword(null,"fontWeight","fontWeight",166450581),new cljs.core.Keyword(null,"textAlign","textAlign",-711351626),new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),new cljs.core.Keyword(null,"display","display",242065432),new cljs.core.Keyword(null,"fontSize","fontSize",919623033),new cljs.core.Keyword(null,"border","border",1444987323),new cljs.core.Keyword(null,"backgroundColor","backgroundColor",1738438491)],["#374151","6px","all 0.2s","100%","pointer","10px 12px","500","left","6px","block","13px","1px solid #e5e7eb",(cljs.core.truth_((function (){var and__5000__auto__ = active_lens;
if(cljs.core.truth_(and__5000__auto__)){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(active_lens),new cljs.core.Keyword(null,"tier","tier",-1071893374))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(active_lens),tier)));
} else {
return and__5000__auto__;
}
})())?"#ddd6fe":"#ffffff")])], null),"\uD83D\uDCCA ",cljs.core.name(tier)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),tier], null)));

var G__12110 = (i__12034 + (1));
i__12034 = G__12110;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__12035),atlas_ui$core$lens_selector_component_$_iter__12032(cljs.core.chunk_rest(s__12033__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__12035),null);
}
} else {
var tier = cljs.core.first(s__12033__$2);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button.lens-btn","button.lens-btn",257357930),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (tier,s__12033__$2,temp__5804__auto__,registry,show_QMARK_,active_lens,available){
return (function (){
return atlas_ui.core.handle_activate_lens_BANG_(new cljs.core.Keyword(null,"tier","tier",-1071893374),tier);
});})(tier,s__12033__$2,temp__5804__auto__,registry,show_QMARK_,active_lens,available))
,new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"borderRadius","borderRadius",-1505621083),new cljs.core.Keyword(null,"transition","transition",765692007),new cljs.core.Keyword(null,"width","width",-384071477),new cljs.core.Keyword(null,"cursor","cursor",1011937484),new cljs.core.Keyword(null,"padding","padding",1660304693),new cljs.core.Keyword(null,"fontWeight","fontWeight",166450581),new cljs.core.Keyword(null,"textAlign","textAlign",-711351626),new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),new cljs.core.Keyword(null,"display","display",242065432),new cljs.core.Keyword(null,"fontSize","fontSize",919623033),new cljs.core.Keyword(null,"border","border",1444987323),new cljs.core.Keyword(null,"backgroundColor","backgroundColor",1738438491)],["#374151","6px","all 0.2s","100%","pointer","10px 12px","500","left","6px","block","13px","1px solid #e5e7eb",(cljs.core.truth_((function (){var and__5000__auto__ = active_lens;
if(cljs.core.truth_(and__5000__auto__)){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(active_lens),new cljs.core.Keyword(null,"tier","tier",-1071893374))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(active_lens),tier)));
} else {
return and__5000__auto__;
}
})())?"#ddd6fe":"#ffffff")])], null),"\uD83D\uDCCA ",cljs.core.name(tier)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),tier], null)),atlas_ui$core$lens_selector_component_$_iter__12032(cljs.core.rest(s__12033__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5480__auto__(cljs.core.sort.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"tiers","tiers",-46242789).cljs$core$IFn$_invoke$arity$1(available)));
})()], null):null),((cljs.core.seq(new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$1(available)))?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.lens-category","div.lens-category",1552522922),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),"20px"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h4","h4",2004862993),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"margin","margin",-995903681),"0 0 8px 0",new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"13px",new cljs.core.Keyword(null,"fontWeight","fontWeight",166450581),"600",new cljs.core.Keyword(null,"color","color",1011675173),"#6b7280",new cljs.core.Keyword(null,"textTransform","textTransform",-1959669529),"uppercase",new cljs.core.Keyword(null,"letterSpacing","letterSpacing",-1331934989),"0.05em"], null)], null),"By Protocol"], null),(function (){var iter__5480__auto__ = (function atlas_ui$core$lens_selector_component_$_iter__12036(s__12037){
return (new cljs.core.LazySeq(null,(function (){
var s__12037__$1 = s__12037;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__12037__$1);
if(temp__5804__auto__){
var s__12037__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__12037__$2)){
var c__5478__auto__ = cljs.core.chunk_first(s__12037__$2);
var size__5479__auto__ = cljs.core.count(c__5478__auto__);
var b__12039 = cljs.core.chunk_buffer(size__5479__auto__);
if((function (){var i__12038 = (0);
while(true){
if((i__12038 < size__5479__auto__)){
var protocol = cljs.core._nth(c__5478__auto__,i__12038);
cljs.core.chunk_append(b__12039,cljs.core.with_meta(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button.lens-btn","button.lens-btn",257357930),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (i__12038,protocol,c__5478__auto__,size__5479__auto__,b__12039,s__12037__$2,temp__5804__auto__,registry,show_QMARK_,active_lens,available){
return (function (){
return atlas_ui.core.handle_activate_lens_BANG_(new cljs.core.Keyword(null,"protocol","protocol",652470118),protocol);
});})(i__12038,protocol,c__5478__auto__,size__5479__auto__,b__12039,s__12037__$2,temp__5804__auto__,registry,show_QMARK_,active_lens,available))
,new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"borderRadius","borderRadius",-1505621083),new cljs.core.Keyword(null,"transition","transition",765692007),new cljs.core.Keyword(null,"width","width",-384071477),new cljs.core.Keyword(null,"cursor","cursor",1011937484),new cljs.core.Keyword(null,"padding","padding",1660304693),new cljs.core.Keyword(null,"fontWeight","fontWeight",166450581),new cljs.core.Keyword(null,"textAlign","textAlign",-711351626),new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),new cljs.core.Keyword(null,"display","display",242065432),new cljs.core.Keyword(null,"fontSize","fontSize",919623033),new cljs.core.Keyword(null,"border","border",1444987323),new cljs.core.Keyword(null,"backgroundColor","backgroundColor",1738438491)],["#374151","6px","all 0.2s","100%","pointer","10px 12px","500","left","6px","block","13px","1px solid #e5e7eb",(cljs.core.truth_((function (){var and__5000__auto__ = active_lens;
if(cljs.core.truth_(and__5000__auto__)){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(active_lens),new cljs.core.Keyword(null,"protocol","protocol",652470118))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(active_lens),protocol)));
} else {
return and__5000__auto__;
}
})())?"#ddd6fe":"#ffffff")])], null),"\uD83D\uDD0C ",cljs.core.name(protocol)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),protocol], null)));

var G__12111 = (i__12038 + (1));
i__12038 = G__12111;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__12039),atlas_ui$core$lens_selector_component_$_iter__12036(cljs.core.chunk_rest(s__12037__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__12039),null);
}
} else {
var protocol = cljs.core.first(s__12037__$2);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button.lens-btn","button.lens-btn",257357930),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (protocol,s__12037__$2,temp__5804__auto__,registry,show_QMARK_,active_lens,available){
return (function (){
return atlas_ui.core.handle_activate_lens_BANG_(new cljs.core.Keyword(null,"protocol","protocol",652470118),protocol);
});})(protocol,s__12037__$2,temp__5804__auto__,registry,show_QMARK_,active_lens,available))
,new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"borderRadius","borderRadius",-1505621083),new cljs.core.Keyword(null,"transition","transition",765692007),new cljs.core.Keyword(null,"width","width",-384071477),new cljs.core.Keyword(null,"cursor","cursor",1011937484),new cljs.core.Keyword(null,"padding","padding",1660304693),new cljs.core.Keyword(null,"fontWeight","fontWeight",166450581),new cljs.core.Keyword(null,"textAlign","textAlign",-711351626),new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),new cljs.core.Keyword(null,"display","display",242065432),new cljs.core.Keyword(null,"fontSize","fontSize",919623033),new cljs.core.Keyword(null,"border","border",1444987323),new cljs.core.Keyword(null,"backgroundColor","backgroundColor",1738438491)],["#374151","6px","all 0.2s","100%","pointer","10px 12px","500","left","6px","block","13px","1px solid #e5e7eb",(cljs.core.truth_((function (){var and__5000__auto__ = active_lens;
if(cljs.core.truth_(and__5000__auto__)){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(active_lens),new cljs.core.Keyword(null,"protocol","protocol",652470118))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(active_lens),protocol)));
} else {
return and__5000__auto__;
}
})())?"#ddd6fe":"#ffffff")])], null),"\uD83D\uDD0C ",cljs.core.name(protocol)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),protocol], null)),atlas_ui$core$lens_selector_component_$_iter__12036(cljs.core.rest(s__12037__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5480__auto__(cljs.core.sort.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$1(available)));
})()], null):null),((cljs.core.seq(new cljs.core.Keyword(null,"constraints","constraints",422775616).cljs$core$IFn$_invoke$arity$1(available)))?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.lens-category","div.lens-category",1552522922),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),"20px"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h4","h4",2004862993),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"margin","margin",-995903681),"0 0 8px 0",new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"13px",new cljs.core.Keyword(null,"fontWeight","fontWeight",166450581),"600",new cljs.core.Keyword(null,"color","color",1011675173),"#6b7280",new cljs.core.Keyword(null,"textTransform","textTransform",-1959669529),"uppercase",new cljs.core.Keyword(null,"letterSpacing","letterSpacing",-1331934989),"0.05em"], null)], null),"By Constraint"], null),(function (){var iter__5480__auto__ = (function atlas_ui$core$lens_selector_component_$_iter__12040(s__12041){
return (new cljs.core.LazySeq(null,(function (){
var s__12041__$1 = s__12041;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__12041__$1);
if(temp__5804__auto__){
var s__12041__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__12041__$2)){
var c__5478__auto__ = cljs.core.chunk_first(s__12041__$2);
var size__5479__auto__ = cljs.core.count(c__5478__auto__);
var b__12043 = cljs.core.chunk_buffer(size__5479__auto__);
if((function (){var i__12042 = (0);
while(true){
if((i__12042 < size__5479__auto__)){
var constraint = cljs.core._nth(c__5478__auto__,i__12042);
cljs.core.chunk_append(b__12043,cljs.core.with_meta(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button.lens-btn","button.lens-btn",257357930),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (i__12042,constraint,c__5478__auto__,size__5479__auto__,b__12043,s__12041__$2,temp__5804__auto__,registry,show_QMARK_,active_lens,available){
return (function (){
return atlas_ui.core.handle_activate_lens_BANG_(new cljs.core.Keyword(null,"constraint","constraint",1725147424),constraint);
});})(i__12042,constraint,c__5478__auto__,size__5479__auto__,b__12043,s__12041__$2,temp__5804__auto__,registry,show_QMARK_,active_lens,available))
,new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"borderRadius","borderRadius",-1505621083),new cljs.core.Keyword(null,"transition","transition",765692007),new cljs.core.Keyword(null,"width","width",-384071477),new cljs.core.Keyword(null,"cursor","cursor",1011937484),new cljs.core.Keyword(null,"padding","padding",1660304693),new cljs.core.Keyword(null,"fontWeight","fontWeight",166450581),new cljs.core.Keyword(null,"textAlign","textAlign",-711351626),new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),new cljs.core.Keyword(null,"display","display",242065432),new cljs.core.Keyword(null,"fontSize","fontSize",919623033),new cljs.core.Keyword(null,"border","border",1444987323),new cljs.core.Keyword(null,"backgroundColor","backgroundColor",1738438491)],["#374151","6px","all 0.2s","100%","pointer","10px 12px","500","left","6px","block","13px","1px solid #e5e7eb",(cljs.core.truth_((function (){var and__5000__auto__ = active_lens;
if(cljs.core.truth_(and__5000__auto__)){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(active_lens),new cljs.core.Keyword(null,"constraint","constraint",1725147424))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(active_lens),constraint)));
} else {
return and__5000__auto__;
}
})())?"#ddd6fe":"#ffffff")])], null),"\uD83D\uDD12 ",cljs.core.name(constraint)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),constraint], null)));

var G__12112 = (i__12042 + (1));
i__12042 = G__12112;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__12043),atlas_ui$core$lens_selector_component_$_iter__12040(cljs.core.chunk_rest(s__12041__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__12043),null);
}
} else {
var constraint = cljs.core.first(s__12041__$2);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button.lens-btn","button.lens-btn",257357930),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (constraint,s__12041__$2,temp__5804__auto__,registry,show_QMARK_,active_lens,available){
return (function (){
return atlas_ui.core.handle_activate_lens_BANG_(new cljs.core.Keyword(null,"constraint","constraint",1725147424),constraint);
});})(constraint,s__12041__$2,temp__5804__auto__,registry,show_QMARK_,active_lens,available))
,new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"borderRadius","borderRadius",-1505621083),new cljs.core.Keyword(null,"transition","transition",765692007),new cljs.core.Keyword(null,"width","width",-384071477),new cljs.core.Keyword(null,"cursor","cursor",1011937484),new cljs.core.Keyword(null,"padding","padding",1660304693),new cljs.core.Keyword(null,"fontWeight","fontWeight",166450581),new cljs.core.Keyword(null,"textAlign","textAlign",-711351626),new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),new cljs.core.Keyword(null,"display","display",242065432),new cljs.core.Keyword(null,"fontSize","fontSize",919623033),new cljs.core.Keyword(null,"border","border",1444987323),new cljs.core.Keyword(null,"backgroundColor","backgroundColor",1738438491)],["#374151","6px","all 0.2s","100%","pointer","10px 12px","500","left","6px","block","13px","1px solid #e5e7eb",(cljs.core.truth_((function (){var and__5000__auto__ = active_lens;
if(cljs.core.truth_(and__5000__auto__)){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(active_lens),new cljs.core.Keyword(null,"constraint","constraint",1725147424))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(active_lens),constraint)));
} else {
return and__5000__auto__;
}
})())?"#ddd6fe":"#ffffff")])], null),"\uD83D\uDD12 ",cljs.core.name(constraint)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),constraint], null)),atlas_ui$core$lens_selector_component_$_iter__12040(cljs.core.rest(s__12041__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5480__auto__(cljs.core.sort.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"constraints","constraints",422775616).cljs$core$IFn$_invoke$arity$1(available)));
})()], null):null),((cljs.core.seq(new cljs.core.Keyword(null,"ui-intents","ui-intents",1360343789).cljs$core$IFn$_invoke$arity$1(available)))?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.lens-category","div.lens-category",1552522922),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),"20px"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h4","h4",2004862993),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"margin","margin",-995903681),"0 0 8px 0",new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"13px",new cljs.core.Keyword(null,"fontWeight","fontWeight",166450581),"600",new cljs.core.Keyword(null,"color","color",1011675173),"#6b7280",new cljs.core.Keyword(null,"textTransform","textTransform",-1959669529),"uppercase",new cljs.core.Keyword(null,"letterSpacing","letterSpacing",-1331934989),"0.05em"], null)], null),"By UI Intent"], null),(function (){var iter__5480__auto__ = (function atlas_ui$core$lens_selector_component_$_iter__12044(s__12045){
return (new cljs.core.LazySeq(null,(function (){
var s__12045__$1 = s__12045;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__12045__$1);
if(temp__5804__auto__){
var s__12045__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__12045__$2)){
var c__5478__auto__ = cljs.core.chunk_first(s__12045__$2);
var size__5479__auto__ = cljs.core.count(c__5478__auto__);
var b__12047 = cljs.core.chunk_buffer(size__5479__auto__);
if((function (){var i__12046 = (0);
while(true){
if((i__12046 < size__5479__auto__)){
var intent = cljs.core._nth(c__5478__auto__,i__12046);
cljs.core.chunk_append(b__12047,cljs.core.with_meta(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button.lens-btn","button.lens-btn",257357930),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (i__12046,intent,c__5478__auto__,size__5479__auto__,b__12047,s__12045__$2,temp__5804__auto__,registry,show_QMARK_,active_lens,available){
return (function (){
return atlas_ui.core.handle_activate_lens_BANG_(new cljs.core.Keyword(null,"ui-intent","ui-intent",-216071742),intent);
});})(i__12046,intent,c__5478__auto__,size__5479__auto__,b__12047,s__12045__$2,temp__5804__auto__,registry,show_QMARK_,active_lens,available))
,new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"borderRadius","borderRadius",-1505621083),new cljs.core.Keyword(null,"transition","transition",765692007),new cljs.core.Keyword(null,"width","width",-384071477),new cljs.core.Keyword(null,"cursor","cursor",1011937484),new cljs.core.Keyword(null,"padding","padding",1660304693),new cljs.core.Keyword(null,"fontWeight","fontWeight",166450581),new cljs.core.Keyword(null,"textAlign","textAlign",-711351626),new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),new cljs.core.Keyword(null,"display","display",242065432),new cljs.core.Keyword(null,"fontSize","fontSize",919623033),new cljs.core.Keyword(null,"border","border",1444987323),new cljs.core.Keyword(null,"backgroundColor","backgroundColor",1738438491)],["#374151","6px","all 0.2s","100%","pointer","10px 12px","500","left","6px","block","13px","1px solid #e5e7eb",(cljs.core.truth_((function (){var and__5000__auto__ = active_lens;
if(cljs.core.truth_(and__5000__auto__)){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(active_lens),new cljs.core.Keyword(null,"ui-intent","ui-intent",-216071742))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(active_lens),intent)));
} else {
return and__5000__auto__;
}
})())?"#ddd6fe":"#ffffff")])], null),"\uD83C\uDFAF ",cljs.core.name(intent)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),intent], null)));

var G__12113 = (i__12046 + (1));
i__12046 = G__12113;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__12047),atlas_ui$core$lens_selector_component_$_iter__12044(cljs.core.chunk_rest(s__12045__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__12047),null);
}
} else {
var intent = cljs.core.first(s__12045__$2);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button.lens-btn","button.lens-btn",257357930),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (intent,s__12045__$2,temp__5804__auto__,registry,show_QMARK_,active_lens,available){
return (function (){
return atlas_ui.core.handle_activate_lens_BANG_(new cljs.core.Keyword(null,"ui-intent","ui-intent",-216071742),intent);
});})(intent,s__12045__$2,temp__5804__auto__,registry,show_QMARK_,active_lens,available))
,new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"borderRadius","borderRadius",-1505621083),new cljs.core.Keyword(null,"transition","transition",765692007),new cljs.core.Keyword(null,"width","width",-384071477),new cljs.core.Keyword(null,"cursor","cursor",1011937484),new cljs.core.Keyword(null,"padding","padding",1660304693),new cljs.core.Keyword(null,"fontWeight","fontWeight",166450581),new cljs.core.Keyword(null,"textAlign","textAlign",-711351626),new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),new cljs.core.Keyword(null,"display","display",242065432),new cljs.core.Keyword(null,"fontSize","fontSize",919623033),new cljs.core.Keyword(null,"border","border",1444987323),new cljs.core.Keyword(null,"backgroundColor","backgroundColor",1738438491)],["#374151","6px","all 0.2s","100%","pointer","10px 12px","500","left","6px","block","13px","1px solid #e5e7eb",(cljs.core.truth_((function (){var and__5000__auto__ = active_lens;
if(cljs.core.truth_(and__5000__auto__)){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(active_lens),new cljs.core.Keyword(null,"ui-intent","ui-intent",-216071742))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(active_lens),intent)));
} else {
return and__5000__auto__;
}
})())?"#ddd6fe":"#ffffff")])], null),"\uD83C\uDFAF ",cljs.core.name(intent)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),intent], null)),atlas_ui$core$lens_selector_component_$_iter__12044(cljs.core.rest(s__12045__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5480__auto__(cljs.core.sort.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"ui-intents","ui-intents",1360343789).cljs$core$IFn$_invoke$arity$1(available)));
})()], null):null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.lens-category","div.lens-category",1552522922),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),"20px",new cljs.core.Keyword(null,"borderTop","borderTop",2080227753),"2px solid #e5e7eb",new cljs.core.Keyword(null,"paddingTop","paddingTop",-1088692345),"16px"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h4","h4",2004862993),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"margin","margin",-995903681),"0 0 8px 0",new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"13px",new cljs.core.Keyword(null,"fontWeight","fontWeight",166450581),"600",new cljs.core.Keyword(null,"color","color",1011675173),"#6b7280",new cljs.core.Keyword(null,"textTransform","textTransform",-1959669529),"uppercase",new cljs.core.Keyword(null,"letterSpacing","letterSpacing",-1331934989),"0.05em"], null)], null),"Advanced Lenses"], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),"12px"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"display","display",242065432),"block",new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"12px",new cljs.core.Keyword(null,"fontWeight","fontWeight",166450581),"600",new cljs.core.Keyword(null,"color","color",1011675173),"#374151",new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),"4px"], null)], null),"\uD83D\uDD04 Dependency Flow"], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-change","on-change",-732046149),(function (p1__12025_SHARP_){
var entity_id = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(p1__12025_SHARP_.target.value);
if(cljs.core.truth_(entity_id)){
return atlas_ui.core.handle_activate_lens_BANG_(new cljs.core.Keyword(null,"dependency-flow","dependency-flow",-1319369283),entity_id);
} else {
return null;
}
}),new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"width","width",-384071477),"100%",new cljs.core.Keyword(null,"padding","padding",1660304693),"8px",new cljs.core.Keyword(null,"border","border",1444987323),"1px solid #e5e7eb",new cljs.core.Keyword(null,"borderRadius","borderRadius",-1505621083),"6px",new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"12px",new cljs.core.Keyword(null,"backgroundColor","backgroundColor",1738438491),"#ffffff",new cljs.core.Keyword(null,"cursor","cursor",1011937484),"pointer"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),""], null),"Select entity to trace..."], null),(function (){var iter__5480__auto__ = (function atlas_ui$core$lens_selector_component_$_iter__12048(s__12049){
return (new cljs.core.LazySeq(null,(function (){
var s__12049__$1 = s__12049;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__12049__$1);
if(temp__5804__auto__){
var s__12049__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__12049__$2)){
var c__5478__auto__ = cljs.core.chunk_first(s__12049__$2);
var size__5479__auto__ = cljs.core.count(c__5478__auto__);
var b__12051 = cljs.core.chunk_buffer(size__5479__auto__);
if((function (){var i__12050 = (0);
while(true){
if((i__12050 < size__5479__auto__)){
var vec__12052 = cljs.core._nth(c__5478__auto__,i__12050);
var identity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12052,(0),null);
var entity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12052,(1),null);
var dev_id = new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553).cljs$core$IFn$_invoke$arity$1(entity);
if(cljs.core.truth_(dev_id)){
cljs.core.chunk_append(b__12051,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),[cljs.core.namespace(dev_id),"/",cljs.core.name(dev_id)].join('')], null),cljs.core.str.cljs$core$IFn$_invoke$arity$1(dev_id)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),dev_id], null)));

var G__12114 = (i__12050 + (1));
i__12050 = G__12114;
continue;
} else {
var G__12115 = (i__12050 + (1));
i__12050 = G__12115;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__12051),atlas_ui$core$lens_selector_component_$_iter__12048(cljs.core.chunk_rest(s__12049__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__12051),null);
}
} else {
var vec__12055 = cljs.core.first(s__12049__$2);
var identity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12055,(0),null);
var entity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12055,(1),null);
var dev_id = new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553).cljs$core$IFn$_invoke$arity$1(entity);
if(cljs.core.truth_(dev_id)){
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),[cljs.core.namespace(dev_id),"/",cljs.core.name(dev_id)].join('')], null),cljs.core.str.cljs$core$IFn$_invoke$arity$1(dev_id)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),dev_id], null)),atlas_ui$core$lens_selector_component_$_iter__12048(cljs.core.rest(s__12049__$2)));
} else {
var G__12116 = cljs.core.rest(s__12049__$2);
s__12049__$1 = G__12116;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5480__auto__(registry);
})()], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),"12px"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"display","display",242065432),"block",new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"12px",new cljs.core.Keyword(null,"fontWeight","fontWeight",166450581),"600",new cljs.core.Keyword(null,"color","color",1011675173),"#374151",new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),"4px"], null)], null),"\uD83D\uDCA5 Impact Analysis"], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-change","on-change",-732046149),(function (p1__12026_SHARP_){
var entity_id = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(p1__12026_SHARP_.target.value);
if(cljs.core.truth_(entity_id)){
return atlas_ui.core.handle_activate_lens_BANG_(new cljs.core.Keyword(null,"impact-analysis","impact-analysis",1563390103),entity_id);
} else {
return null;
}
}),new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"width","width",-384071477),"100%",new cljs.core.Keyword(null,"padding","padding",1660304693),"8px",new cljs.core.Keyword(null,"border","border",1444987323),"1px solid #e5e7eb",new cljs.core.Keyword(null,"borderRadius","borderRadius",-1505621083),"6px",new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"12px",new cljs.core.Keyword(null,"backgroundColor","backgroundColor",1738438491),"#ffffff",new cljs.core.Keyword(null,"cursor","cursor",1011937484),"pointer"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),""], null),"Select entity to analyze..."], null),(function (){var iter__5480__auto__ = (function atlas_ui$core$lens_selector_component_$_iter__12058(s__12059){
return (new cljs.core.LazySeq(null,(function (){
var s__12059__$1 = s__12059;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__12059__$1);
if(temp__5804__auto__){
var s__12059__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__12059__$2)){
var c__5478__auto__ = cljs.core.chunk_first(s__12059__$2);
var size__5479__auto__ = cljs.core.count(c__5478__auto__);
var b__12061 = cljs.core.chunk_buffer(size__5479__auto__);
if((function (){var i__12060 = (0);
while(true){
if((i__12060 < size__5479__auto__)){
var vec__12062 = cljs.core._nth(c__5478__auto__,i__12060);
var identity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12062,(0),null);
var entity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12062,(1),null);
var dev_id = new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553).cljs$core$IFn$_invoke$arity$1(entity);
if(cljs.core.truth_(dev_id)){
cljs.core.chunk_append(b__12061,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),[cljs.core.namespace(dev_id),"/",cljs.core.name(dev_id)].join('')], null),cljs.core.str.cljs$core$IFn$_invoke$arity$1(dev_id)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),dev_id], null)));

var G__12117 = (i__12060 + (1));
i__12060 = G__12117;
continue;
} else {
var G__12118 = (i__12060 + (1));
i__12060 = G__12118;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__12061),atlas_ui$core$lens_selector_component_$_iter__12058(cljs.core.chunk_rest(s__12059__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__12061),null);
}
} else {
var vec__12065 = cljs.core.first(s__12059__$2);
var identity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12065,(0),null);
var entity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12065,(1),null);
var dev_id = new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553).cljs$core$IFn$_invoke$arity$1(entity);
if(cljs.core.truth_(dev_id)){
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),[cljs.core.namespace(dev_id),"/",cljs.core.name(dev_id)].join('')], null),cljs.core.str.cljs$core$IFn$_invoke$arity$1(dev_id)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),dev_id], null)),atlas_ui$core$lens_selector_component_$_iter__12058(cljs.core.rest(s__12059__$2)));
} else {
var G__12119 = cljs.core.rest(s__12059__$2);
s__12059__$1 = G__12119;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5480__auto__(registry);
})()], null)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),"12px"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"display","display",242065432),"block",new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"12px",new cljs.core.Keyword(null,"fontWeight","fontWeight",166450581),"600",new cljs.core.Keyword(null,"color","color",1011675173),"#374151",new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),"4px"], null)], null),"\uD83D\uDD00 Combine Lenses"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"11px",new cljs.core.Keyword(null,"color","color",1011675173),"#6b7280",new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),"6px",new cljs.core.Keyword(null,"fontStyle","fontStyle",1246842165),"italic"], null)], null),"Select a lens, then click + to add more"], null),(function (){var combo_lenses = new cljs.core.Keyword("atlas-ui.ui.state","combination-lenses","atlas-ui.ui.state/combination-lenses",-2020357275).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui.core.app_state));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-change","on-change",-732046149),(function (p1__12027_SHARP_){
var value = p1__12027_SHARP_.target.value;
var vec__12068 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(value,/:/);
var lens_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12068,(0),null);
var lens_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12068,(1),null);
var lens_spec = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(lens_type),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(lens_value)], null);
if(cljs.core.truth_((function (){var and__5000__auto__ = lens_type;
if(cljs.core.truth_(and__5000__auto__)){
return lens_value;
} else {
return and__5000__auto__;
}
})())){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(atlas_ui.core.app_state,cljs.core.update,new cljs.core.Keyword("atlas-ui.ui.state","combination-lenses","atlas-ui.ui.state/combination-lenses",-2020357275),cljs.core.conj,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lens_spec], 0));
} else {
}

return (p1__12027_SHARP_.target.value = "");
}),new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"width","width",-384071477),"100%",new cljs.core.Keyword(null,"padding","padding",1660304693),"8px",new cljs.core.Keyword(null,"border","border",1444987323),"1px solid #e5e7eb",new cljs.core.Keyword(null,"borderRadius","borderRadius",-1505621083),"6px",new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"12px",new cljs.core.Keyword(null,"backgroundColor","backgroundColor",1738438491),"#ffffff",new cljs.core.Keyword(null,"cursor","cursor",1011937484),"pointer",new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),"6px"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),""], null),"Add lens to combine..."], null),((cljs.core.seq(new cljs.core.Keyword(null,"domains","domains",1410387719).cljs$core$IFn$_invoke$arity$1(available)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),"Domains"], null),(function (){var iter__5480__auto__ = (function atlas_ui$core$lens_selector_component_$_iter__12071(s__12072){
return (new cljs.core.LazySeq(null,(function (){
var s__12072__$1 = s__12072;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__12072__$1);
if(temp__5804__auto__){
var s__12072__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__12072__$2)){
var c__5478__auto__ = cljs.core.chunk_first(s__12072__$2);
var size__5479__auto__ = cljs.core.count(c__5478__auto__);
var b__12074 = cljs.core.chunk_buffer(size__5479__auto__);
if((function (){var i__12073 = (0);
while(true){
if((i__12073 < size__5479__auto__)){
var domain = cljs.core._nth(c__5478__auto__,i__12073);
cljs.core.chunk_append(b__12074,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),["domain:",cljs.core.namespace(domain),"/",cljs.core.name(domain)].join('')], null),["Domain: ",cljs.core.name(domain)].join('')], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),domain], null)));

var G__12120 = (i__12073 + (1));
i__12073 = G__12120;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__12074),atlas_ui$core$lens_selector_component_$_iter__12071(cljs.core.chunk_rest(s__12072__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__12074),null);
}
} else {
var domain = cljs.core.first(s__12072__$2);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),["domain:",cljs.core.namespace(domain),"/",cljs.core.name(domain)].join('')], null),["Domain: ",cljs.core.name(domain)].join('')], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),domain], null)),atlas_ui$core$lens_selector_component_$_iter__12071(cljs.core.rest(s__12072__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5480__auto__(cljs.core.sort.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"domains","domains",1410387719).cljs$core$IFn$_invoke$arity$1(available)));
})()], null):null),((cljs.core.seq(new cljs.core.Keyword(null,"tiers","tiers",-46242789).cljs$core$IFn$_invoke$arity$1(available)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),"Tiers"], null),(function (){var iter__5480__auto__ = (function atlas_ui$core$lens_selector_component_$_iter__12075(s__12076){
return (new cljs.core.LazySeq(null,(function (){
var s__12076__$1 = s__12076;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__12076__$1);
if(temp__5804__auto__){
var s__12076__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__12076__$2)){
var c__5478__auto__ = cljs.core.chunk_first(s__12076__$2);
var size__5479__auto__ = cljs.core.count(c__5478__auto__);
var b__12078 = cljs.core.chunk_buffer(size__5479__auto__);
if((function (){var i__12077 = (0);
while(true){
if((i__12077 < size__5479__auto__)){
var tier = cljs.core._nth(c__5478__auto__,i__12077);
cljs.core.chunk_append(b__12078,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),["tier:",cljs.core.namespace(tier),"/",cljs.core.name(tier)].join('')], null),["Tier: ",cljs.core.name(tier)].join('')], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),tier], null)));

var G__12121 = (i__12077 + (1));
i__12077 = G__12121;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__12078),atlas_ui$core$lens_selector_component_$_iter__12075(cljs.core.chunk_rest(s__12076__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__12078),null);
}
} else {
var tier = cljs.core.first(s__12076__$2);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),["tier:",cljs.core.namespace(tier),"/",cljs.core.name(tier)].join('')], null),["Tier: ",cljs.core.name(tier)].join('')], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),tier], null)),atlas_ui$core$lens_selector_component_$_iter__12075(cljs.core.rest(s__12076__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5480__auto__(cljs.core.sort.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"tiers","tiers",-46242789).cljs$core$IFn$_invoke$arity$1(available)));
})()], null):null),((cljs.core.seq(new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$1(available)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),"Protocols"], null),(function (){var iter__5480__auto__ = (function atlas_ui$core$lens_selector_component_$_iter__12079(s__12080){
return (new cljs.core.LazySeq(null,(function (){
var s__12080__$1 = s__12080;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__12080__$1);
if(temp__5804__auto__){
var s__12080__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__12080__$2)){
var c__5478__auto__ = cljs.core.chunk_first(s__12080__$2);
var size__5479__auto__ = cljs.core.count(c__5478__auto__);
var b__12082 = cljs.core.chunk_buffer(size__5479__auto__);
if((function (){var i__12081 = (0);
while(true){
if((i__12081 < size__5479__auto__)){
var protocol = cljs.core._nth(c__5478__auto__,i__12081);
cljs.core.chunk_append(b__12082,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),["protocol:",cljs.core.namespace(protocol),"/",cljs.core.name(protocol)].join('')], null),["Protocol: ",cljs.core.name(protocol)].join('')], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),protocol], null)));

var G__12122 = (i__12081 + (1));
i__12081 = G__12122;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__12082),atlas_ui$core$lens_selector_component_$_iter__12079(cljs.core.chunk_rest(s__12080__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__12082),null);
}
} else {
var protocol = cljs.core.first(s__12080__$2);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),["protocol:",cljs.core.namespace(protocol),"/",cljs.core.name(protocol)].join('')], null),["Protocol: ",cljs.core.name(protocol)].join('')], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),protocol], null)),atlas_ui$core$lens_selector_component_$_iter__12079(cljs.core.rest(s__12080__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5480__auto__(cljs.core.sort.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$1(available)));
})()], null):null)], null),((cljs.core.seq(combo_lenses))?new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"marginTop","marginTop",-1403015220),"8px"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"11px",new cljs.core.Keyword(null,"color","color",1011675173),"#6b7280",new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),"4px"], null)], null),"Selected lenses:"], null),(function (){var iter__5480__auto__ = (function atlas_ui$core$lens_selector_component_$_iter__12083(s__12084){
return (new cljs.core.LazySeq(null,(function (){
var s__12084__$1 = s__12084;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__12084__$1);
if(temp__5804__auto__){
var s__12084__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__12084__$2)){
var c__5478__auto__ = cljs.core.chunk_first(s__12084__$2);
var size__5479__auto__ = cljs.core.count(c__5478__auto__);
var b__12086 = cljs.core.chunk_buffer(size__5479__auto__);
if((function (){var i__12085 = (0);
while(true){
if((i__12085 < size__5479__auto__)){
var vec__12087 = cljs.core._nth(c__5478__auto__,i__12085);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12087,(0),null);
var lens = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12087,(1),null);
cljs.core.chunk_append(b__12086,cljs.core.with_meta(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"11px",new cljs.core.Keyword(null,"padding","padding",1660304693),"4px 8px",new cljs.core.Keyword(null,"backgroundColor","backgroundColor",1738438491),"#f3f4f6",new cljs.core.Keyword(null,"borderRadius","borderRadius",-1505621083),"4px",new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),"2px",new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"justifyContent","justifyContent",885406515),"space-between",new cljs.core.Keyword(null,"alignItems","alignItems",410331199),"center"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),[cljs.core.name(new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(lens)),": ",cljs.core.name(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(lens))].join('')], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (i__12085,vec__12087,idx,lens,c__5478__auto__,size__5479__auto__,b__12086,s__12084__$2,temp__5804__auto__,combo_lenses,registry,show_QMARK_,active_lens,available){
return (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(atlas_ui.core.app_state,cljs.core.update,new cljs.core.Keyword("atlas-ui.ui.state","combination-lenses","atlas-ui.ui.state/combination-lenses",-2020357275),((function (i__12085,vec__12087,idx,lens,c__5478__auto__,size__5479__auto__,b__12086,s__12084__$2,temp__5804__auto__,combo_lenses,registry,show_QMARK_,active_lens,available){
return (function (lenses){
return cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(lenses,(0),idx),cljs.core.subvec.cljs$core$IFn$_invoke$arity$2(lenses,(idx + (1)))));
});})(i__12085,vec__12087,idx,lens,c__5478__auto__,size__5479__auto__,b__12086,s__12084__$2,temp__5804__auto__,combo_lenses,registry,show_QMARK_,active_lens,available))
);
});})(i__12085,vec__12087,idx,lens,c__5478__auto__,size__5479__auto__,b__12086,s__12084__$2,temp__5804__auto__,combo_lenses,registry,show_QMARK_,active_lens,available))
,new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"background","background",-863952629),"none",new cljs.core.Keyword(null,"border","border",1444987323),"none",new cljs.core.Keyword(null,"color","color",1011675173),"#ef4444",new cljs.core.Keyword(null,"cursor","cursor",1011937484),"pointer",new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"10px"], null)], null),"\u2715"], null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),idx], null)));

var G__12123 = (i__12085 + (1));
i__12085 = G__12123;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__12086),atlas_ui$core$lens_selector_component_$_iter__12083(cljs.core.chunk_rest(s__12084__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__12086),null);
}
} else {
var vec__12090 = cljs.core.first(s__12084__$2);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12090,(0),null);
var lens = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12090,(1),null);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"11px",new cljs.core.Keyword(null,"padding","padding",1660304693),"4px 8px",new cljs.core.Keyword(null,"backgroundColor","backgroundColor",1738438491),"#f3f4f6",new cljs.core.Keyword(null,"borderRadius","borderRadius",-1505621083),"4px",new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),"2px",new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"justifyContent","justifyContent",885406515),"space-between",new cljs.core.Keyword(null,"alignItems","alignItems",410331199),"center"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),[cljs.core.name(new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(lens)),": ",cljs.core.name(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(lens))].join('')], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (vec__12090,idx,lens,s__12084__$2,temp__5804__auto__,combo_lenses,registry,show_QMARK_,active_lens,available){
return (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(atlas_ui.core.app_state,cljs.core.update,new cljs.core.Keyword("atlas-ui.ui.state","combination-lenses","atlas-ui.ui.state/combination-lenses",-2020357275),(function (lenses){
return cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(lenses,(0),idx),cljs.core.subvec.cljs$core$IFn$_invoke$arity$2(lenses,(idx + (1)))));
}));
});})(vec__12090,idx,lens,s__12084__$2,temp__5804__auto__,combo_lenses,registry,show_QMARK_,active_lens,available))
,new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"background","background",-863952629),"none",new cljs.core.Keyword(null,"border","border",1444987323),"none",new cljs.core.Keyword(null,"color","color",1011675173),"#ef4444",new cljs.core.Keyword(null,"cursor","cursor",1011937484),"pointer",new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"10px"], null)], null),"\u2715"], null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),idx], null)),atlas_ui$core$lens_selector_component_$_iter__12083(cljs.core.rest(s__12084__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5480__auto__(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,combo_lenses));
})(),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),(function (){
return atlas_ui.core.handle_activate_lens_BANG_(new cljs.core.Keyword(null,"combination","combination",1695836532),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"lenses","lenses",-740611109),combo_lenses], null));
}),new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"borderRadius","borderRadius",-1505621083),new cljs.core.Keyword(null,"width","width",-384071477),new cljs.core.Keyword(null,"cursor","cursor",1011937484),new cljs.core.Keyword(null,"marginTop","marginTop",-1403015220),new cljs.core.Keyword(null,"padding","padding",1660304693),new cljs.core.Keyword(null,"fontWeight","fontWeight",166450581),new cljs.core.Keyword(null,"fontSize","fontSize",919623033),new cljs.core.Keyword(null,"border","border",1444987323),new cljs.core.Keyword(null,"backgroundColor","backgroundColor",1738438491)],["white","6px","100%","pointer","4px","8px","600","12px","none","#8b5cf6"])], null),["\uD83D\uDD00 Apply ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(combo_lenses))," Lenses"].join('')], null)], null):null)], null);
})()], null)], null)], null);
});
atlas_ui.core.presets_panel = (function atlas_ui$core$presets_panel(){

var show_QMARK_ = new cljs.core.Keyword("atlas-ui.ui.state","show-presets?","atlas-ui.ui.state/show-presets?",2051990435).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui.core.app_state));
var presets = new cljs.core.Keyword("atlas-ui.ui.state","lens-presets","atlas-ui.ui.state/lens-presets",1303851224).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui.core.app_state));
var active_lens = new cljs.core.Keyword("atlas-ui.ui.state","active-lens","atlas-ui.ui.state/active-lens",-596367764).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui.core.app_state));
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.presets-panel","div.presets-panel",-1087662708),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"backdropFilter","backdropFilter",-221215069),new cljs.core.Keyword(null,"maxHeight","maxHeight",-2066822365),new cljs.core.Keyword(null,"maxWidth","maxWidth",-1375124795),new cljs.core.Keyword(null,"borderRadius","borderRadius",-1505621083),new cljs.core.Keyword(null,"top","top",-1856271961),new cljs.core.Keyword(null,"minWidth","minWidth",-204293526),new cljs.core.Keyword(null,"overflowY","overflowY",1522263150),new cljs.core.Keyword(null,"padding","padding",1660304693),new cljs.core.Keyword(null,"zIndex","zIndex",-1588341609),new cljs.core.Keyword(null,"right","right",-452581833),new cljs.core.Keyword(null,"display","display",242065432),new cljs.core.Keyword(null,"position","position",-2011731912),new cljs.core.Keyword(null,"boxShadow","boxShadow",-1591689862),new cljs.core.Keyword(null,"border","border",1444987323),new cljs.core.Keyword(null,"backgroundColor","backgroundColor",1738438491)],["blur(12px)","70vh","320px","12px","80px","280px","auto","20px",(2000),"20px",(cljs.core.truth_(show_QMARK_)?"block":"none"),"absolute","0 8px 24px rgba(0, 0, 0, 0.15)","2px solid #e5e7eb","rgba(255, 255, 255, 0.98)"])], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"justifyContent","justifyContent",885406515),"space-between",new cljs.core.Keyword(null,"alignItems","alignItems",410331199),"center",new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),"16px"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h3","h3",2067611163),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"margin","margin",-995903681),"0",new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"16px",new cljs.core.Keyword(null,"fontWeight","fontWeight",166450581),"600",new cljs.core.Keyword(null,"color","color",1011675173),"#111827"], null)], null),"\uD83D\uDCBE Saved Presets"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),atlas_ui.core.handle_toggle_presets_BANG_,new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"background","background",-863952629),"none",new cljs.core.Keyword(null,"border","border",1444987323),"none",new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"20px",new cljs.core.Keyword(null,"cursor","cursor",1011937484),"pointer",new cljs.core.Keyword(null,"color","color",1011675173),"#9ca3af",new cljs.core.Keyword(null,"padding","padding",1660304693),"0",new cljs.core.Keyword(null,"lineHeight","lineHeight",-1729831016),"1"], null)], null),"\u00D7"], null)], null),(cljs.core.truth_(active_lens)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),(function (){
var name = prompt("Preset name:");
if(cljs.core.truth_(name)){
return atlas_ui.core.handle_save_preset_BANG_(name);
} else {
return null;
}
}),new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"borderRadius","borderRadius",-1505621083),new cljs.core.Keyword(null,"transition","transition",765692007),new cljs.core.Keyword(null,"width","width",-384071477),new cljs.core.Keyword(null,"cursor","cursor",1011937484),new cljs.core.Keyword(null,"padding","padding",1660304693),new cljs.core.Keyword(null,"fontWeight","fontWeight",166450581),new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),new cljs.core.Keyword(null,"fontSize","fontSize",919623033),new cljs.core.Keyword(null,"border","border",1444987323),new cljs.core.Keyword(null,"backgroundColor","backgroundColor",1738438491)],["white","8px","all 0.2s","100%","pointer","12px","600","16px","13px","none","#10b981"])], null),"\uD83D\uDCBE Save Current Lens"], null):null),((cljs.core.empty_QMARK_(presets))?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"padding","padding",1660304693),"20px",new cljs.core.Keyword(null,"textAlign","textAlign",-711351626),"center",new cljs.core.Keyword(null,"color","color",1011675173),"#9ca3af",new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"13px"], null)], null),"No saved presets yet",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"marginTop","marginTop",-1403015220),"8px",new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"12px"], null)], null),"Activate a lens and save it"], null)], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.preset-list","div.preset-list",1871517708),(function (){var iter__5480__auto__ = (function atlas_ui$core$presets_panel_$_iter__12093(s__12094){
return (new cljs.core.LazySeq(null,(function (){
var s__12094__$1 = s__12094;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__12094__$1);
if(temp__5804__auto__){
var s__12094__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__12094__$2)){
var c__5478__auto__ = cljs.core.chunk_first(s__12094__$2);
var size__5479__auto__ = cljs.core.count(c__5478__auto__);
var b__12096 = cljs.core.chunk_buffer(size__5479__auto__);
if((function (){var i__12095 = (0);
while(true){
if((i__12095 < size__5479__auto__)){
var vec__12097 = cljs.core._nth(c__5478__auto__,i__12095);
var preset_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12097,(0),null);
var preset = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12097,(1),null);
cljs.core.chunk_append(b__12096,cljs.core.with_meta(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.preset-item","div.preset-item",632560175),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),"8px",new cljs.core.Keyword(null,"padding","padding",1660304693),"12px",new cljs.core.Keyword(null,"backgroundColor","backgroundColor",1738438491),"#f9fafb",new cljs.core.Keyword(null,"borderRadius","borderRadius",-1505621083),"8px",new cljs.core.Keyword(null,"border","border",1444987323),"1px solid #e5e7eb",new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"justifyContent","justifyContent",885406515),"space-between",new cljs.core.Keyword(null,"alignItems","alignItems",410331199),"center"], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (i__12095,vec__12097,preset_id,preset,c__5478__auto__,size__5479__auto__,b__12096,s__12094__$2,temp__5804__auto__,show_QMARK_,presets,active_lens){
return (function (){
return atlas_ui.core.handle_load_preset_BANG_(preset_id);
});})(i__12095,vec__12097,preset_id,preset,c__5478__auto__,size__5479__auto__,b__12096,s__12094__$2,temp__5804__auto__,show_QMARK_,presets,active_lens))
,new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"flex","flex",-1425124628),"1",new cljs.core.Keyword(null,"cursor","cursor",1011937484),"pointer"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"fontWeight","fontWeight",166450581),"600",new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"13px",new cljs.core.Keyword(null,"color","color",1011675173),"#111827",new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),"4px"], null)], null),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(preset)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"11px",new cljs.core.Keyword(null,"color","color",1011675173),"#6b7280"], null)], null),[cljs.core.name(new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"lens-spec","lens-spec",1953469180).cljs$core$IFn$_invoke$arity$1(preset))),": ",cljs.core.name(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"lens-spec","lens-spec",1953469180).cljs$core$IFn$_invoke$arity$1(preset)))].join('')], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (i__12095,vec__12097,preset_id,preset,c__5478__auto__,size__5479__auto__,b__12096,s__12094__$2,temp__5804__auto__,show_QMARK_,presets,active_lens){
return (function (){
return atlas_ui.core.handle_delete_preset_BANG_(preset_id);
});})(i__12095,vec__12097,preset_id,preset,c__5478__auto__,size__5479__auto__,b__12096,s__12094__$2,temp__5804__auto__,show_QMARK_,presets,active_lens))
,new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"padding","padding",1660304693),"4px 8px",new cljs.core.Keyword(null,"backgroundColor","backgroundColor",1738438491),"#ef4444",new cljs.core.Keyword(null,"color","color",1011675173),"white",new cljs.core.Keyword(null,"border","border",1444987323),"none",new cljs.core.Keyword(null,"borderRadius","borderRadius",-1505621083),"4px",new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"11px",new cljs.core.Keyword(null,"cursor","cursor",1011937484),"pointer"], null)], null),"\uD83D\uDDD1\uFE0F"], null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),preset_id], null)));

var G__12124 = (i__12095 + (1));
i__12095 = G__12124;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__12096),atlas_ui$core$presets_panel_$_iter__12093(cljs.core.chunk_rest(s__12094__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__12096),null);
}
} else {
var vec__12100 = cljs.core.first(s__12094__$2);
var preset_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12100,(0),null);
var preset = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12100,(1),null);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.preset-item","div.preset-item",632560175),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),"8px",new cljs.core.Keyword(null,"padding","padding",1660304693),"12px",new cljs.core.Keyword(null,"backgroundColor","backgroundColor",1738438491),"#f9fafb",new cljs.core.Keyword(null,"borderRadius","borderRadius",-1505621083),"8px",new cljs.core.Keyword(null,"border","border",1444987323),"1px solid #e5e7eb",new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"justifyContent","justifyContent",885406515),"space-between",new cljs.core.Keyword(null,"alignItems","alignItems",410331199),"center"], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (vec__12100,preset_id,preset,s__12094__$2,temp__5804__auto__,show_QMARK_,presets,active_lens){
return (function (){
return atlas_ui.core.handle_load_preset_BANG_(preset_id);
});})(vec__12100,preset_id,preset,s__12094__$2,temp__5804__auto__,show_QMARK_,presets,active_lens))
,new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"flex","flex",-1425124628),"1",new cljs.core.Keyword(null,"cursor","cursor",1011937484),"pointer"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"fontWeight","fontWeight",166450581),"600",new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"13px",new cljs.core.Keyword(null,"color","color",1011675173),"#111827",new cljs.core.Keyword(null,"marginBottom","marginBottom",1236079031),"4px"], null)], null),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(preset)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"11px",new cljs.core.Keyword(null,"color","color",1011675173),"#6b7280"], null)], null),[cljs.core.name(new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"lens-spec","lens-spec",1953469180).cljs$core$IFn$_invoke$arity$1(preset))),": ",cljs.core.name(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"lens-spec","lens-spec",1953469180).cljs$core$IFn$_invoke$arity$1(preset)))].join('')], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (vec__12100,preset_id,preset,s__12094__$2,temp__5804__auto__,show_QMARK_,presets,active_lens){
return (function (){
return atlas_ui.core.handle_delete_preset_BANG_(preset_id);
});})(vec__12100,preset_id,preset,s__12094__$2,temp__5804__auto__,show_QMARK_,presets,active_lens))
,new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"padding","padding",1660304693),"4px 8px",new cljs.core.Keyword(null,"backgroundColor","backgroundColor",1738438491),"#ef4444",new cljs.core.Keyword(null,"color","color",1011675173),"white",new cljs.core.Keyword(null,"border","border",1444987323),"none",new cljs.core.Keyword(null,"borderRadius","borderRadius",-1505621083),"4px",new cljs.core.Keyword(null,"fontSize","fontSize",919623033),"11px",new cljs.core.Keyword(null,"cursor","cursor",1011937484),"pointer"], null)], null),"\uD83D\uDDD1\uFE0F"], null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),preset_id], null)),atlas_ui$core$presets_panel_$_iter__12093(cljs.core.rest(s__12094__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5480__auto__(presets);
})()], null))], null);
});
atlas_ui.core.main_view = (function atlas_ui$core$main_view(){
var selections = new cljs.core.Keyword("atlas-ui.ui.state","selections","atlas-ui.ui.state/selections",275746488).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui.core.app_state));
var negated_aspects = new cljs.core.Keyword("atlas-ui.ui.state","negated-aspects","atlas-ui.ui.state/negated-aspects",1962237344).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui.core.app_state));
var query_mode = new cljs.core.Keyword("atlas-ui.ui.state","query-mode","atlas-ui.ui.state/query-mode",975963741).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui.core.app_state));
var min_score = new cljs.core.Keyword("atlas-ui.ui.state","min-score","atlas-ui.ui.state/min-score",-303626122).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui.core.app_state));
var registry = new cljs.core.Keyword("atlas-ui.ui.state","registry","atlas-ui.ui.state/registry",-446230821).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui.core.app_state));
var highlight = new cljs.core.Keyword("atlas-ui.ui.state","highlight-selection","atlas-ui.ui.state/highlight-selection",1962029238).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui.core.app_state));
var highlighted_entity_id = new cljs.core.Keyword("atlas-ui.graph.node","id","atlas-ui.graph.node/id",-1392721478).cljs$core$IFn$_invoke$arity$1(highlight);
var highlighted_entity_aspects = new cljs.core.Keyword("atlas-ui.ui.state","highlighted-entity-aspects","atlas-ui.ui.state/highlighted-entity-aspects",-1183922094).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui.core.app_state));
var highlighted_aspect = new cljs.core.Keyword("atlas-ui.ui.state","highlight-aspect","atlas-ui.ui.state/highlight-aspect",-439313600).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui.core.app_state));
var legend_focus = new cljs.core.Keyword("atlas-ui.ui.state","legend-focus","atlas-ui.ui.state/legend-focus",1454999652).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui.core.app_state));
var hide_unmatched_QMARK_ = new cljs.core.Keyword("atlas-ui.ui.state","hide-unmatched?","atlas-ui.ui.state/hide-unmatched?",1823675889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui.core.app_state));
var search_term = new cljs.core.Keyword("atlas-ui.ui.state","search-term","atlas-ui.ui.state/search-term",-305959559).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui.core.app_state));
var selected_types = new cljs.core.Keyword("atlas-ui.ui.state","selected-types","atlas-ui.ui.state/selected-types",-1062003055).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui.core.app_state));
var active_lens = new cljs.core.Keyword("atlas-ui.ui.state","active-lens","atlas-ui.ui.state/active-lens",-596367764).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui.core.app_state));
var lens = cljs.core.deref(atlas_ui.core.lens_result);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.app","div.app",-99849286),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"flexDirection","flexDirection",1286039598),"column",new cljs.core.Keyword(null,"height","height",1025178622),"100vh",new cljs.core.Keyword(null,"fontFamily","fontFamily",1493518353),"system-ui, -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif"], null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui.core.header_component], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.content","div.content",-298042649),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"flex","flex",-1425124628),"1",new cljs.core.Keyword(null,"overflow","overflow",2058931880),"hidden"], null)], null),new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.graph-wrapper","div.graph-wrapper",-134814916),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"flex","flex",-1425124628),"1",new cljs.core.Keyword(null,"position","position",-2011731912),"relative",new cljs.core.Keyword(null,"overflow","overflow",2058931880),"hidden"], null)], null),((cljs.core.empty_QMARK_(registry))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"alignItems","alignItems",410331199),"center",new cljs.core.Keyword(null,"justifyContent","justifyContent",885406515),"center",new cljs.core.Keyword(null,"height","height",1025178622),"100%",new cljs.core.Keyword(null,"color","color",1011675173),"#9ca3af"], null)], null),"Loading registry..."], null):new cljs.core.PersistentVector(null, 17, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui.graph.graph_component,cljs.core.deref(atlas_ui.core.filtered_graph_data),selections,negated_aspects,query_mode,min_score,registry,highlighted_entity_id,highlighted_entity_aspects,highlighted_aspect,hide_unmatched_QMARK_,search_term,lens,atlas_ui.core.handle_toggle_aspect,atlas_ui.core.handle_click_entity,atlas_ui.core.handle_click_aspect,legend_focus], null)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui.search_bar.search_bar,search_term,atlas_ui.core.handle_search_change], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui.core.lens_banner], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui.core.lens_selector_component], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui.core.presets_panel], null),((((cljs.core.seq(selections)) || (cljs.core.seq(negated_aspects))))?new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui.selection_controls.selection_controls,selections,negated_aspects,query_mode,min_score,atlas_ui.core.handle_toggle_aspect,atlas_ui.core.handle_set_query_mode,atlas_ui.core.handle_clear_selections,atlas_ui.core.handle_toggle_visibility,hide_unmatched_QMARK_,atlas_ui.core.handle_set_min_score], null):null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui.color_legend.semantic_legend,legend_focus,atlas_ui.core.handle_legend_focus], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui.color_legend.color_legend,selections,query_mode], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui.selection_controls.type_filter_panel,cljs.core.deref(atlas_ui.core.filtered_graph_data),selected_types,atlas_ui.core.handle_toggle_type], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui.core.info_panel], null)], null),(cljs.core.truth_(highlight)?new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui.sidebar.sidebar_component,highlight,cljs.core.deref(atlas_ui.core.filtered_graph_data),registry,(function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(atlas_ui.core.app_state,cljs.core.assoc,new cljs.core.Keyword("atlas-ui.ui.state","highlight-selection","atlas-ui.ui.state/highlight-selection",1962029238),null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("atlas-ui.ui.state","highlighted-entity-aspects","atlas-ui.ui.state/highlighted-entity-aspects",-1183922094),cljs.core.PersistentHashSet.EMPTY], 0));
}),atlas_ui.core.handle_toggle_aspect,atlas_ui.core.handle_click_entity], null):null)], null)], null);
});
atlas_ui.core.setup_keyboard_shortcuts_BANG_ = (function atlas_ui$core$setup_keyboard_shortcuts_BANG_(){
return document.addEventListener("keydown",(function (e){
var key = e.key;
var ctrl_QMARK_ = e.ctrlKey;
var meta_QMARK_ = e.metaKey;
var modifier_QMARK_ = (function (){var or__5002__auto__ = ctrl_QMARK_;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return meta_QMARK_;
}
})();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,"Escape")){
if(cljs.core.truth_(new cljs.core.Keyword("atlas-ui.ui.state","active-lens","atlas-ui.ui.state/active-lens",-596367764).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui.core.app_state)))){
return atlas_ui.core.handle_clear_lens_BANG_();
} else {
return atlas_ui.core.handle_clear_selections();
}
} else {
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,"l")) && (cljs.core.not(modifier_QMARK_)))){
e.preventDefault();

return atlas_ui.core.handle_toggle_lens_selector_BANG_();
} else {
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,"p")) && (cljs.core.not(modifier_QMARK_)))){
e.preventDefault();

return atlas_ui.core.handle_toggle_presets_BANG_();
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,"[")){
e.preventDefault();

return atlas_ui.core.handle_lens_back_BANG_();
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,"]")){
e.preventDefault();

return atlas_ui.core.handle_lens_forward_BANG_();
} else {
if(cljs.core.truth_((function (){var and__5000__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,"s");
if(and__5000__auto__){
return modifier_QMARK_;
} else {
return and__5000__auto__;
}
})())){
e.preventDefault();

if(cljs.core.truth_(new cljs.core.Keyword("atlas-ui.ui.state","active-lens","atlas-ui.ui.state/active-lens",-596367764).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui.core.app_state)))){
var name = prompt("Preset name:");
if(cljs.core.truth_(name)){
return atlas_ui.core.handle_save_preset_BANG_(name);
} else {
return null;
}
} else {
return null;
}
} else {
if(cljs.core.truth_((function (){var and__5000__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,"c");
if(and__5000__auto__){
return modifier_QMARK_;
} else {
return and__5000__auto__;
}
})())){
if(cljs.core.truth_(new cljs.core.Keyword("atlas-ui.ui.state","active-lens","atlas-ui.ui.state/active-lens",-596367764).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui.core.app_state)))){
e.preventDefault();

return atlas_ui.core.copy_lens_url_to_clipboard_BANG_();
} else {
return null;
}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,"1")){
e.preventDefault();

return atlas_ui.core.handle_set_query_mode(new cljs.core.Keyword(null,"and","and",-971899817));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,"2")){
e.preventDefault();

return atlas_ui.core.handle_set_query_mode(new cljs.core.Keyword(null,"or","or",235744169));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,"3")){
e.preventDefault();

return atlas_ui.core.handle_set_query_mode(new cljs.core.Keyword(null,"count","count",2139924085));
} else {
return null;

}
}
}
}
}
}
}
}
}
}
}));
});
atlas_ui.core.mount_root = (function atlas_ui$core$mount_root(){
return reagent.dom.render.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui.core.main_view], null),document.getElementById("app"));
});
atlas_ui.core.init = (function atlas_ui$core$init(){
console.log("\uD83D\uDE80 Atlas UI starting with multi-selection...");

atlas_ui.core.setup_keyboard_shortcuts_BANG_();

atlas_ui.core.load_lens_from_url_BANG_();

atlas_ui.core.refresh_registry_BANG_();

return atlas_ui.core.mount_root();
});

//# sourceMappingURL=atlas_ui.core.js.map
