goog.provide('atlas_ui.api');
atlas_ui.api.transit_reader = cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"json","json",1279968570));
atlas_ui.api.decode_transit = (function atlas_ui$api$decode_transit(s){
return cognitect.transit.read(atlas_ui.api.transit_reader,s);
});
/**
 * Fetch registry from backend server (Transit+JSON).
 */
atlas_ui.api.fetch_registry_BANG_ = (function atlas_ui$api$fetch_registry_BANG_(on_success,on_error){
return ajax.core.GET.cljs$core$IFn$_invoke$arity$variadic([cljs.core.str.cljs$core$IFn$_invoke$arity$1(atlas_ui.config.api_base_url()),"/api/atlas/registry"].join(''),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"handler","handler",-195596612),(function (response_text){
try{var G__12012 = atlas_ui.api.decode_transit(response_text);
return (on_success.cljs$core$IFn$_invoke$arity$1 ? on_success.cljs$core$IFn$_invoke$arity$1(G__12012) : on_success.call(null,G__12012));
}catch (e12011){if((e12011 instanceof Error)){
var e = e12011;
console.error("Error parsing registry:",e);

return (on_error.cljs$core$IFn$_invoke$arity$1 ? on_error.cljs$core$IFn$_invoke$arity$1(e) : on_error.call(null,e));
} else {
throw e12011;

}
}}),new cljs.core.Keyword(null,"error-handler","error-handler",-484945776),on_error,new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.PersistentArrayMap(null, 1, ["Accept","application/transit+json"], null),new cljs.core.Keyword(null,"response-format","response-format",1664465322),new cljs.core.Keyword(null,"text","text",-1790561697)], null)], 0));
});
/**
 * Fetch registry with fallback to sample data if server unavailable
 */
atlas_ui.api.fetch_registry_with_fallback_BANG_ = (function atlas_ui$api$fetch_registry_with_fallback_BANG_(on_success){
console.log("Fetching registry from backend...");

return atlas_ui.api.fetch_registry_BANG_((function (data){
console.log("Registry fetch SUCCESS");

return (on_success.cljs$core$IFn$_invoke$arity$1 ? on_success.cljs$core$IFn$_invoke$arity$1(data) : on_success.call(null,data));
}),(function (error){
console.warn("Could not fetch from server, using sample data",error);

var G__12013 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("atlas-ui.api.response","registry","atlas-ui.api.response/registry",-156359811),atlas_ui.sample_registry.sample_registry], null);
return (on_success.cljs$core$IFn$_invoke$arity$1 ? on_success.cljs$core$IFn$_invoke$arity$1(G__12013) : on_success.call(null,G__12013));
}));
});

//# sourceMappingURL=atlas_ui.api.js.map
