goog.provide('atlas.registry');
atlas.registry.registry = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
atlas.registry.format_STAR_ = (function atlas$registry$format_STAR_(var_args){
var args__5732__auto__ = [];
var len__5726__auto___18521 = arguments.length;
var i__5727__auto___18522 = (0);
while(true){
if((i__5727__auto___18522 < len__5726__auto___18521)){
args__5732__auto__.push((arguments[i__5727__auto___18522]));

var G__18523 = (i__5727__auto___18522 + (1));
i__5727__auto___18522 = G__18523;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((1) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((1)),(0),null)):null);
return atlas.registry.format_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5733__auto__);
});

(atlas.registry.format_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(goog.string.format,fmt,args);
}));

(atlas.registry.format_STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(atlas.registry.format_STAR_.cljs$lang$applyTo = (function (seq18331){
var G__18332 = cljs.core.first(seq18331);
var seq18331__$1 = cljs.core.next(seq18331);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18332,seq18331__$1);
}));

/**
 * Replaces anonymous / inline functions with :fun,
 * preserves named vars that refer to functions
 *   Relaces reifies by :reify.
 */
atlas.registry.normalize_callables = (function atlas$registry$normalize_callables(m){
return clojure.walk.postwalk((function (v){
if(((cljs.core.var_QMARK_(v)) && (cljs.core.fn_QMARK_(cljs.core.deref(v))))){
return v;
} else {
if(cljs.core.fn_QMARK_(v)){
return new cljs.core.Keyword(null,"fun","fun",-1265158045);
} else {
return v;


}
}
}),m);
});
/**
 * Returns true if `id` is a valid compound identity.
 * A valid identity is a set of at least 1 qualified keyword.
 */
atlas.registry.valid_QMARK_ = (function atlas$registry$valid_QMARK_(var_args){
var G__18347 = arguments.length;
switch (G__18347) {
case 1:
return atlas.registry.valid_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return atlas.registry.valid_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(atlas.registry.valid_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (id){
return atlas.registry.valid_QMARK_.cljs$core$IFn$_invoke$arity$2(id,false);
}));

(atlas.registry.valid_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (id,verbose_QMARK_){
if((!(cljs.core.set_QMARK_(id)))){
if(cljs.core.truth_(verbose_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"error","error",-978969032),"not-a-set"], null);
} else {
return false;
}
} else {
if(cljs.core.not_every_QMARK_(cljs.core.qualified_keyword_QMARK_,id)){
if(cljs.core.truth_(verbose_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"error","error",-978969032),"unqualified-keywords"], null);
} else {
return false;
}
} else {
return true;

}
}
}));

(atlas.registry.valid_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Fetch the value associated with a compound identity.
 */
atlas.registry.fetch = (function atlas$registry$fetch(identity){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(atlas.registry.registry),identity);
});
/**
 * Check if a compound identity exists in the registry and whether its value matches `value`.
 * Returns {:exists bool :matches bool}.
 */
atlas.registry.exists_QMARK_ = (function atlas$registry$exists_QMARK_(compound_identity,value){
var found = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(atlas.registry.registry),compound_identity);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"exists","exists",1312597120),cljs.core.contains_QMARK_(cljs.core.deref(atlas.registry.registry),compound_identity),new cljs.core.Keyword(null,"matches","matches",635497998),cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(found,value)], null);
});
/**
 * Remove a compound identity from the registry.
 */
atlas.registry.remove = (function atlas$registry$remove(compound_identity){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(atlas.registry.registry,cljs.core.dissoc,compound_identity);
});
/**
 * Find the compound identity that has the given dev-id.
 * Returns [compound-id value] or nil if not found.
 * PRIVATE: Used internally by register! for dev-id uniqueness checking.
 */
atlas.registry.find_by_dev_id = (function atlas$registry$find_by_dev_id(dev_id){
if(cljs.core.truth_(dev_id)){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p__18357){
var vec__18358 = p__18357;
var _k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18358,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18358,(1),null);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553).cljs$core$IFn$_invoke$arity$1(v),dev_id);
}),cljs.core.deref(atlas.registry.registry)));
} else {
return null;
}
});
/**
 * Generate a deterministic dev-id from a compound identity (aspect set).
 * Sorts aspects alphabetically and creates a keyword in the 'auto' namespace.
 */
atlas.registry.generate_dev_id = (function atlas$registry$generate_dev_id(aspect_set){
var sorted_aspects = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(aspect_set);
var aspect_names = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (kw){
return [cljs.core.namespace(kw),"--",cljs.core.name(kw)].join('');
}),sorted_aspects);
var joined = clojure.string.join.cljs$core$IFn$_invoke$arity$2("--",aspect_names);
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2("auto",joined);
});
/**
 * Register a new compound identity with explicit entity type and aspects.
 * 
 * The entity type and aspects are combined to form the complete compound identity.
 * Entity types are registered with :atlas/type and can be validated after load.
 * 
 * Arities:
 * - [type aspects value]: Register with auto-generated dev-id
 * - [dev-id type aspects value]: Register with explicit dev-id
 * 
 * Parameters:
 * - dev-id: Developer ID (keyword, auto-generated if not provided)
 * - type: Entity type keyword (e.g., :atlas/execution-function, :semantic-namespace/flow)
 * - aspects: Set of aspect keywords (e.g., #{:domain/cart :tier/service})
 * - value: Value map with entity-specific keys
 */
atlas.registry.register_BANG_ = (function atlas$registry$register_BANG_(var_args){
var G__18367 = arguments.length;
switch (G__18367) {
case 3:
return atlas.registry.register_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return atlas.registry.register_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(atlas.registry.register_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (type,aspects,value){
return atlas.registry.register_BANG_.cljs$core$IFn$_invoke$arity$4(atlas.registry.generate_dev_id(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(aspects,type)),type,aspects,value);
}));

(atlas.registry.register_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (dev_id,type,aspects,value){
if(cljs.core.qualified_keyword_QMARK_(type)){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(atlas.registry.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Entity type must be a qualified keyword, got: %s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([type], 0))),"\n","(qualified-keyword? type)"].join('')));
}

if(cljs.core.set_QMARK_(aspects)){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(atlas.registry.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Aspects must be a set, got: %s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([aspects], 0))),"\n","(set? aspects)"].join('')));
}

var id = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(aspects,type);
if(cljs.core.truth_(atlas.registry.valid_QMARK_.cljs$core$IFn$_invoke$arity$1(id))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(atlas.registry.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Invalid compound identity: %s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([id], 0))),"\n","(valid? id)"].join('')));
}

if(((cljs.core.contains_QMARK_(cljs.core.deref(atlas.registry.registry),id)) && (cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(atlas.registry.registry),id),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(value,new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553),dev_id))))){
(function (){
var __run_fn_form = null;
var __kind = new cljs.core.Keyword(null,"log","log",-1595516004);
var __ns = "atlas.registry";
var __id = null;
var __level = new cljs.core.Keyword(null,"warn","warn",-436710552);
if(cljs.core.truth_((function (){var sf = taoensso.telemere.impl._STAR_rt_call_filter_STAR_;
if(cljs.core.truth_(sf)){
return (sf.cljs$core$IFn$_invoke$arity$4 ? sf.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"log","log",-1595516004),__ns,__id,__level) : sf.call(null,new cljs.core.Keyword(null,"log","log",-1595516004),__ns,__id,__level));
} else {
return true;
}
})())){
var __inst = (new Date());
var __thread = null;
var __root0 = taoensso.telemere.impl._STAR_trace_root_STAR_;
var __otel_context = null;
var __uid = null;
var __root1 = __root0;
var __run_result = null;
var signal__16897__auto__ = (new cljs.core.Delay((function (){

var signal__16888__auto__ = (new taoensso.telemere.impl.Signal((1),__inst,__uid,__ns,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [130,8], null),null,__kind,__id,__level,taoensso.telemere._STAR_ctx_STAR_,taoensso.telemere.impl._STAR_trace_parent_STAR_,__root1,null,null,(new cljs.core.Delay((function (){
return taoensso.telemere.impl.signal_msg(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Compound identity already exists in registry",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compound-id","compound-id",1095631030),id,new cljs.core.Keyword(null,"existing-value","existing-value",215280633),cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(atlas.registry.registry),id),new cljs.core.Keyword(null,"attempted-value","attempted-value",-915783546),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(value,new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553),dev_id)], null)], null));
}),null)),null,null,null,null,null,null,null,null));
var temp__5802__auto__ = taoensso.telemere._STAR_xfn_STAR_;
if(cljs.core.truth_(temp__5802__auto__)){
var xfn__16889__auto__ = temp__5802__auto__;
return (xfn__16889__auto__.cljs$core$IFn$_invoke$arity$1 ? xfn__16889__auto__.cljs$core$IFn$_invoke$arity$1(signal__16888__auto__) : xfn__16889__auto__.call(null,signal__16888__auto__));
} else {
return signal__16888__auto__;
}
}),null));
taoensso.telemere.impl.dispatch_signal_BANG_((new taoensso.telemere.impl.WrappedSignal(__kind,__ns,__id,__level,signal__16897__auto__)));

if(cljs.core.truth_(__run_result)){
return (__run_result.cljs$core$IFn$_invoke$arity$1 ? __run_result.cljs$core$IFn$_invoke$arity$1(signal__16897__auto__) : __run_result.call(null,signal__16897__auto__));
} else {
return true;
}
} else {
return null;
}
})();

} else {
}

var temp__5804__auto___18528 = atlas.registry.find_by_dev_id(dev_id);
if(cljs.core.truth_(temp__5804__auto___18528)){
var vec__18370_18529 = temp__5804__auto___18528;
var existing_id_18530 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18370_18529,(0),null);
var existing_value_18531 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18370_18529,(1),null);
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(existing_id_18530,id)){
(function (){
var __run_fn_form = null;
var __kind = new cljs.core.Keyword(null,"log","log",-1595516004);
var __ns = "atlas.registry";
var __id = null;
var __level = new cljs.core.Keyword(null,"warn","warn",-436710552);
if(cljs.core.truth_((function (){var sf = taoensso.telemere.impl._STAR_rt_call_filter_STAR_;
if(cljs.core.truth_(sf)){
return (sf.cljs$core$IFn$_invoke$arity$4 ? sf.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"log","log",-1595516004),__ns,__id,__level) : sf.call(null,new cljs.core.Keyword(null,"log","log",-1595516004),__ns,__id,__level));
} else {
return true;
}
})())){
var __inst = (new Date());
var __thread = null;
var __root0 = taoensso.telemere.impl._STAR_trace_root_STAR_;
var __otel_context = null;
var __uid = null;
var __root1 = __root0;
var __run_result = null;
var signal__16897__auto__ = (new cljs.core.Delay((function (){

var signal__16888__auto__ = (new taoensso.telemere.impl.Signal((1),__inst,__uid,__ns,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [136,10], null),null,__kind,__id,__level,taoensso.telemere._STAR_ctx_STAR_,taoensso.telemere.impl._STAR_trace_parent_STAR_,__root1,null,null,(new cljs.core.Delay((function (){
return taoensso.telemere.impl.signal_msg(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["dev-id already exists in registry",new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"dev-id","dev-id",1928680092),dev_id,new cljs.core.Keyword(null,"existing-compound-id","existing-compound-id",-303535613),existing_id_18530,new cljs.core.Keyword(null,"existing-value","existing-value",215280633),existing_value_18531,new cljs.core.Keyword(null,"attempted-compound-id","attempted-compound-id",-583325020),id,new cljs.core.Keyword(null,"attempted-value","attempted-value",-915783546),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(value,new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553),dev_id)], null)], null));
}),null)),null,null,null,null,null,null,null,null));
var temp__5802__auto__ = taoensso.telemere._STAR_xfn_STAR_;
if(cljs.core.truth_(temp__5802__auto__)){
var xfn__16889__auto__ = temp__5802__auto__;
return (xfn__16889__auto__.cljs$core$IFn$_invoke$arity$1 ? xfn__16889__auto__.cljs$core$IFn$_invoke$arity$1(signal__16888__auto__) : xfn__16889__auto__.call(null,signal__16888__auto__));
} else {
return signal__16888__auto__;
}
}),null));
taoensso.telemere.impl.dispatch_signal_BANG_((new taoensso.telemere.impl.WrappedSignal(__kind,__ns,__id,__level,signal__16897__auto__)));

if(cljs.core.truth_(__run_result)){
return (__run_result.cljs$core$IFn$_invoke$arity$1 ? __run_result.cljs$core$IFn$_invoke$arity$1(signal__16897__auto__) : __run_result.call(null,signal__16897__auto__));
} else {
return true;
}
} else {
return null;
}
})();

} else {
}
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(atlas.registry.registry,cljs.core.assoc,id,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(value,new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553),dev_id,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("atlas","type","atlas/type",1535978791),type], 0)));

return id;
}));

(atlas.registry.register_BANG_.cljs$lang$maxFixedArity = 4);

/**
 * Return all registered entity types (those with :atlas/type in their identity).
 */
atlas.registry.registered_types = (function atlas$registry$registered_types(){
return cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (id){
return cljs.core.first(cljs.core.disj.cljs$core$IFn$_invoke$arity$2(id,new cljs.core.Keyword("atlas","type","atlas/type",1535978791)));
}),cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__18373_SHARP_){
return cljs.core.contains_QMARK_(p1__18373_SHARP_,new cljs.core.Keyword("atlas","type","atlas/type",1535978791));
}),cljs.core.keys(cljs.core.deref(atlas.registry.registry)))));
});
/**
 * Extract the entity type from a compound identity.
 * 
 *   An entity type is a member that is registered with :atlas/type,
 *   or if none found, returns the first qualified keyword that could be a type.
 * 
 *   Returns the entity type keyword or nil.
 */
atlas.registry.entity_type = (function atlas$registry$entity_type(identity){
var types = atlas.registry.registered_types();
var type_in_id = cljs.core.first(clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(identity,types));
var or__5002__auto__ = type_in_id;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.first(identity);
}
});
/**
 * Extract all aspects (non-entity-type members) from identity.
 * 
 *   Returns a set of aspect keywords.
 */
atlas.registry.aspects = (function atlas$registry$aspects(identity){
var type = atlas.registry.entity_type(identity);
if(cljs.core.truth_(type)){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(identity,type);
} else {
return null;
}
});
/**
 * Create identity pattern with entity type + aspects.
 * 
 *   Example:
 *  (with-entity-type :atlas/execution-function
 *                    :tier/service
 *                    :domain/cart)
 *  => #{:atlas/execution-function :tier/service :domain/cart}
 */
atlas.registry.with_entity_type = (function atlas$registry$with_entity_type(var_args){
var args__5732__auto__ = [];
var len__5726__auto___18537 = arguments.length;
var i__5727__auto___18538 = (0);
while(true){
if((i__5727__auto___18538 < len__5726__auto___18537)){
args__5732__auto__.push((arguments[i__5727__auto___18538]));

var G__18539 = (i__5727__auto___18538 + (1));
i__5727__auto___18538 = G__18539;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((1) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((1)),(0),null)):null);
return atlas.registry.with_entity_type.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5733__auto__);
});

(atlas.registry.with_entity_type.cljs$core$IFn$_invoke$arity$variadic = (function (entity_type,aspects){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.PersistentHashSet.createAsIfByAssoc([entity_type]),aspects);
}));

(atlas.registry.with_entity_type.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(atlas.registry.with_entity_type.cljs$lang$applyTo = (function (seq18374){
var G__18375 = cljs.core.first(seq18374);
var seq18374__$1 = cljs.core.next(seq18374);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18375,seq18374__$1);
}));

/**
 * Validate that all registered entities use known types.
 * 
 *   Returns:
 *  {:valid? true} or
 *  {:valid? false :violations [...]}
 * 
 *   Call this after all code is loaded to check type consistency.
 */
atlas.registry.validate_registry_types = (function atlas$registry$validate_registry_types(){
var types = atlas.registry.registered_types();
var all_identities = atlas.query.all_identities(cljs.core.deref(atlas.registry.registry));
var violations = (function (){var iter__5480__auto__ = (function atlas$registry$validate_registry_types_$_iter__18376(s__18377){
return (new cljs.core.LazySeq(null,(function (){
var s__18377__$1 = s__18377;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__18377__$1);
if(temp__5804__auto__){
var s__18377__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__18377__$2)){
var c__5478__auto__ = cljs.core.chunk_first(s__18377__$2);
var size__5479__auto__ = cljs.core.count(c__5478__auto__);
var b__18379 = cljs.core.chunk_buffer(size__5479__auto__);
if((function (){var i__18378 = (0);
while(true){
if((i__18378 < size__5479__auto__)){
var id = cljs.core._nth(c__5478__auto__,i__18378);
if((!(cljs.core.contains_QMARK_(id,new cljs.core.Keyword("atlas","type","atlas/type",1535978791))))){
var type = atlas.registry.entity_type(id);
if(cljs.core.truth_((function (){var and__5000__auto__ = type;
if(cljs.core.truth_(and__5000__auto__)){
return (!(cljs.core.contains_QMARK_(types,type)));
} else {
return and__5000__auto__;
}
})())){
cljs.core.chunk_append(b__18379,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"identity","identity",1647396035),id,new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"dev-id","dev-id",1928680092),new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553).cljs$core$IFn$_invoke$arity$1(atlas.registry.fetch(id)),new cljs.core.Keyword(null,"message","message",-406056002),atlas.registry.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Entity uses unregistered type: %s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([type], 0))], null));

var G__18541 = (i__18378 + (1));
i__18378 = G__18541;
continue;
} else {
var G__18542 = (i__18378 + (1));
i__18378 = G__18542;
continue;
}
} else {
var G__18543 = (i__18378 + (1));
i__18378 = G__18543;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__18379),atlas$registry$validate_registry_types_$_iter__18376(cljs.core.chunk_rest(s__18377__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__18379),null);
}
} else {
var id = cljs.core.first(s__18377__$2);
if((!(cljs.core.contains_QMARK_(id,new cljs.core.Keyword("atlas","type","atlas/type",1535978791))))){
var type = atlas.registry.entity_type(id);
if(cljs.core.truth_((function (){var and__5000__auto__ = type;
if(cljs.core.truth_(and__5000__auto__)){
return (!(cljs.core.contains_QMARK_(types,type)));
} else {
return and__5000__auto__;
}
})())){
return cljs.core.cons(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"identity","identity",1647396035),id,new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"dev-id","dev-id",1928680092),new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553).cljs$core$IFn$_invoke$arity$1(atlas.registry.fetch(id)),new cljs.core.Keyword(null,"message","message",-406056002),atlas.registry.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Entity uses unregistered type: %s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([type], 0))], null),atlas$registry$validate_registry_types_$_iter__18376(cljs.core.rest(s__18377__$2)));
} else {
var G__18544 = cljs.core.rest(s__18377__$2);
s__18377__$1 = G__18544;
continue;
}
} else {
var G__18545 = cljs.core.rest(s__18377__$2);
s__18377__$1 = G__18545;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5480__auto__(all_identities);
})();
if(cljs.core.seq(violations)){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"valid?","valid?",-212412379),false,new cljs.core.Keyword(null,"violations","violations",835165468),violations,new cljs.core.Keyword(null,"registered-types","registered-types",-1404859663),types], null);
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"valid?","valid?",-212412379),true,new cljs.core.Keyword(null,"registered-types","registered-types",-1404859663),types], null);
}
});
/**
 * Optionally validate entities using clojure.spec if specs exist.
 * 
 *   Returns:
 *  {:valid? true} or
 *  {:valid? false :violations [...]}
 * 
 *   Only validates entities that have corresponding specs registered.
 */
atlas.registry.validate_with_specs = (function atlas$registry$validate_with_specs(){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"valid?","valid?",-212412379),true,new cljs.core.Keyword(null,"note","note",1426297904),"Spec validation not yet implemented"], null);
});
/**
 * Group identities by primary namespace, returning a map {:ns [identities]}.
 */
atlas.registry.clusters = (function atlas$registry$clusters(){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,id_set){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (inner,aspect){
var ns_part = cljs.core.namespace(aspect);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(inner,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(ns_part),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),id_set);
}),acc,id_set);
}),cljs.core.PersistentArrayMap.EMPTY,atlas.query.all_identities(cljs.core.deref(atlas.registry.registry)));
});
/**
 * Return normalized correlation matrix of aspect co-occurrence (as 0–1 floats).
 */
atlas.registry.correlation_matrix = (function atlas$registry$correlation_matrix(){
var aspects = cljs.core.keys(atlas.query.aspect_frequency(cljs.core.deref(atlas.registry.registry)));
var all_ids = atlas.query.all_identities(cljs.core.deref(atlas.registry.registry));
var total = (function (){var x__5087__auto__ = (1);
var y__5088__auto__ = cljs.core.count(all_ids);
return ((x__5087__auto__ > y__5088__auto__) ? x__5087__auto__ : y__5088__auto__);
})();
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__5480__auto__ = (function atlas$registry$correlation_matrix_$_iter__18388(s__18389){
return (new cljs.core.LazySeq(null,(function (){
var s__18389__$1 = s__18389;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__18389__$1);
if(temp__5804__auto__){
var s__18389__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__18389__$2)){
var c__5478__auto__ = cljs.core.chunk_first(s__18389__$2);
var size__5479__auto__ = cljs.core.count(c__5478__auto__);
var b__18391 = cljs.core.chunk_buffer(size__5479__auto__);
if((function (){var i__18390 = (0);
while(true){
if((i__18390 < size__5479__auto__)){
var a1 = cljs.core._nth(c__5478__auto__,i__18390);
cljs.core.chunk_append(b__18391,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a1,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__5480__auto__ = ((function (i__18390,a1,c__5478__auto__,size__5479__auto__,b__18391,s__18389__$2,temp__5804__auto__,aspects,all_ids,total){
return (function atlas$registry$correlation_matrix_$_iter__18388_$_iter__18392(s__18393){
return (new cljs.core.LazySeq(null,((function (i__18390,a1,c__5478__auto__,size__5479__auto__,b__18391,s__18389__$2,temp__5804__auto__,aspects,all_ids,total){
return (function (){
var s__18393__$1 = s__18393;
while(true){
var temp__5804__auto____$1 = cljs.core.seq(s__18393__$1);
if(temp__5804__auto____$1){
var s__18393__$2 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__18393__$2)){
var c__5478__auto____$1 = cljs.core.chunk_first(s__18393__$2);
var size__5479__auto____$1 = cljs.core.count(c__5478__auto____$1);
var b__18395 = cljs.core.chunk_buffer(size__5479__auto____$1);
if((function (){var i__18394 = (0);
while(true){
if((i__18394 < size__5479__auto____$1)){
var a2 = cljs.core._nth(c__5478__auto____$1,i__18394);
cljs.core.chunk_append(b__18395,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a2,(cljs.core.count(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (i__18394,i__18390,a2,c__5478__auto____$1,size__5479__auto____$1,b__18395,s__18393__$2,temp__5804__auto____$1,a1,c__5478__auto__,size__5479__auto__,b__18391,s__18389__$2,temp__5804__auto__,aspects,all_ids,total){
return (function (p1__18383_SHARP_){
return ((cljs.core.contains_QMARK_(p1__18383_SHARP_,a1)) && (cljs.core.contains_QMARK_(p1__18383_SHARP_,a2)));
});})(i__18394,i__18390,a2,c__5478__auto____$1,size__5479__auto____$1,b__18395,s__18393__$2,temp__5804__auto____$1,a1,c__5478__auto__,size__5479__auto__,b__18391,s__18389__$2,temp__5804__auto__,aspects,all_ids,total))
,all_ids)) / total)], null));

var G__18547 = (i__18394 + (1));
i__18394 = G__18547;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__18395),atlas$registry$correlation_matrix_$_iter__18388_$_iter__18392(cljs.core.chunk_rest(s__18393__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__18395),null);
}
} else {
var a2 = cljs.core.first(s__18393__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a2,(cljs.core.count(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (i__18390,a2,s__18393__$2,temp__5804__auto____$1,a1,c__5478__auto__,size__5479__auto__,b__18391,s__18389__$2,temp__5804__auto__,aspects,all_ids,total){
return (function (p1__18383_SHARP_){
return ((cljs.core.contains_QMARK_(p1__18383_SHARP_,a1)) && (cljs.core.contains_QMARK_(p1__18383_SHARP_,a2)));
});})(i__18390,a2,s__18393__$2,temp__5804__auto____$1,a1,c__5478__auto__,size__5479__auto__,b__18391,s__18389__$2,temp__5804__auto__,aspects,all_ids,total))
,all_ids)) / total)], null),atlas$registry$correlation_matrix_$_iter__18388_$_iter__18392(cljs.core.rest(s__18393__$2)));
}
} else {
return null;
}
break;
}
});})(i__18390,a1,c__5478__auto__,size__5479__auto__,b__18391,s__18389__$2,temp__5804__auto__,aspects,all_ids,total))
,null,null));
});})(i__18390,a1,c__5478__auto__,size__5479__auto__,b__18391,s__18389__$2,temp__5804__auto__,aspects,all_ids,total))
;
return iter__5480__auto__(aspects);
})())], null));

var G__18548 = (i__18390 + (1));
i__18390 = G__18548;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__18391),atlas$registry$correlation_matrix_$_iter__18388(cljs.core.chunk_rest(s__18389__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__18391),null);
}
} else {
var a1 = cljs.core.first(s__18389__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a1,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__5480__auto__ = ((function (a1,s__18389__$2,temp__5804__auto__,aspects,all_ids,total){
return (function atlas$registry$correlation_matrix_$_iter__18388_$_iter__18401(s__18402){
return (new cljs.core.LazySeq(null,(function (){
var s__18402__$1 = s__18402;
while(true){
var temp__5804__auto____$1 = cljs.core.seq(s__18402__$1);
if(temp__5804__auto____$1){
var s__18402__$2 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__18402__$2)){
var c__5478__auto__ = cljs.core.chunk_first(s__18402__$2);
var size__5479__auto__ = cljs.core.count(c__5478__auto__);
var b__18404 = cljs.core.chunk_buffer(size__5479__auto__);
if((function (){var i__18403 = (0);
while(true){
if((i__18403 < size__5479__auto__)){
var a2 = cljs.core._nth(c__5478__auto__,i__18403);
cljs.core.chunk_append(b__18404,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a2,(cljs.core.count(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (i__18403,a2,c__5478__auto__,size__5479__auto__,b__18404,s__18402__$2,temp__5804__auto____$1,a1,s__18389__$2,temp__5804__auto__,aspects,all_ids,total){
return (function (p1__18383_SHARP_){
return ((cljs.core.contains_QMARK_(p1__18383_SHARP_,a1)) && (cljs.core.contains_QMARK_(p1__18383_SHARP_,a2)));
});})(i__18403,a2,c__5478__auto__,size__5479__auto__,b__18404,s__18402__$2,temp__5804__auto____$1,a1,s__18389__$2,temp__5804__auto__,aspects,all_ids,total))
,all_ids)) / total)], null));

var G__18549 = (i__18403 + (1));
i__18403 = G__18549;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__18404),atlas$registry$correlation_matrix_$_iter__18388_$_iter__18401(cljs.core.chunk_rest(s__18402__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__18404),null);
}
} else {
var a2 = cljs.core.first(s__18402__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a2,(cljs.core.count(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (a2,s__18402__$2,temp__5804__auto____$1,a1,s__18389__$2,temp__5804__auto__,aspects,all_ids,total){
return (function (p1__18383_SHARP_){
return ((cljs.core.contains_QMARK_(p1__18383_SHARP_,a1)) && (cljs.core.contains_QMARK_(p1__18383_SHARP_,a2)));
});})(a2,s__18402__$2,temp__5804__auto____$1,a1,s__18389__$2,temp__5804__auto__,aspects,all_ids,total))
,all_ids)) / total)], null),atlas$registry$correlation_matrix_$_iter__18388_$_iter__18401(cljs.core.rest(s__18402__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});})(a1,s__18389__$2,temp__5804__auto__,aspects,all_ids,total))
;
return iter__5480__auto__(aspects);
})())], null),atlas$registry$correlation_matrix_$_iter__18388(cljs.core.rest(s__18389__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5480__auto__(aspects);
})());
});
/**
 * Suggest aspects potentially missing from an identity based on correlation.
 */
atlas.registry.missing_aspects = (function atlas$registry$missing_aspects(identity_set){
var similar = atlas.query.semantic_similarity.cljs$core$IFn$_invoke$arity$3(cljs.core.deref(atlas.registry.registry),identity_set,0.0);
var all_aspects = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(cljs.core.val,cljs.core._GT_,cljs.core.frequencies(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"identity","identity",1647396035),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([similar], 0))));
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p__18405){
var vec__18406 = p__18405;
var aspect = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18406,(0),null);
var freq = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18406,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"aspect","aspect",-839905246),aspect,new cljs.core.Keyword(null,"correlation","correlation",-975773207),(freq / cljs.core.count(similar))], null);
}),cljs.core.take.cljs$core$IFn$_invoke$arity$2((5),cljs.core.remove.cljs$core$IFn$_invoke$arity$2((function (p__18409){
var vec__18410 = p__18409;
var aspect = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18410,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18410,(1),null);
return cljs.core.contains_QMARK_(identity_set,aspect);
}),all_aspects)));
});
/**
 * Return list of identities that violate expected semantic constraints.
 */
atlas.registry.find_anomalies = (function atlas$registry$find_anomalies(){
var all_ids = atlas.query.all_identities(cljs.core.deref(atlas.registry.registry));
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (id){
return ((((cljs.core.contains_QMARK_(id,new cljs.core.Keyword("sync","operation","sync/operation",-1264064523))) && (cljs.core.contains_QMARK_(id,new cljs.core.Keyword("async","operation","async/operation",-876478506))))) || (((cljs.core.contains_QMARK_(id,new cljs.core.Keyword("api","endpoint","api/endpoint",447990930))) && ((!(cljs.core.contains_QMARK_(id,new cljs.core.Keyword("auth","required","auth/required",1804754054))))))));
}),all_ids);
});
/**
 * Return a Graphviz DOT string representing compound-identity relationships.
 */
atlas.registry.to_graphviz = (function atlas$registry$to_graphviz(){
var edges = (function (){var iter__5480__auto__ = (function atlas$registry$to_graphviz_$_iter__18417(s__18418){
return (new cljs.core.LazySeq(null,(function (){
var s__18418__$1 = s__18418;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__18418__$1);
if(temp__5804__auto__){
var xs__6360__auto__ = temp__5804__auto__;
var id = cljs.core.first(xs__6360__auto__);
var iterys__5476__auto__ = ((function (s__18418__$1,id,xs__6360__auto__,temp__5804__auto__){
return (function atlas$registry$to_graphviz_$_iter__18417_$_iter__18419(s__18420){
return (new cljs.core.LazySeq(null,((function (s__18418__$1,id,xs__6360__auto__,temp__5804__auto__){
return (function (){
var s__18420__$1 = s__18420;
while(true){
var temp__5804__auto____$1 = cljs.core.seq(s__18420__$1);
if(temp__5804__auto____$1){
var s__18420__$2 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__18420__$2)){
var c__5478__auto__ = cljs.core.chunk_first(s__18420__$2);
var size__5479__auto__ = cljs.core.count(c__5478__auto__);
var b__18422 = cljs.core.chunk_buffer(size__5479__auto__);
if((function (){var i__18421 = (0);
while(true){
if((i__18421 < size__5479__auto__)){
var aspect = cljs.core._nth(c__5478__auto__,i__18421);
cljs.core.chunk_append(b__18422,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [aspect,id], null));

var G__18551 = (i__18421 + (1));
i__18421 = G__18551;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__18422),atlas$registry$to_graphviz_$_iter__18417_$_iter__18419(cljs.core.chunk_rest(s__18420__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__18422),null);
}
} else {
var aspect = cljs.core.first(s__18420__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [aspect,id], null),atlas$registry$to_graphviz_$_iter__18417_$_iter__18419(cljs.core.rest(s__18420__$2)));
}
} else {
return null;
}
break;
}
});})(s__18418__$1,id,xs__6360__auto__,temp__5804__auto__))
,null,null));
});})(s__18418__$1,id,xs__6360__auto__,temp__5804__auto__))
;
var fs__5477__auto__ = cljs.core.seq(iterys__5476__auto__(id));
if(fs__5477__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__5477__auto__,atlas$registry$to_graphviz_$_iter__18417(cljs.core.rest(s__18418__$1)));
} else {
var G__18552 = cljs.core.rest(s__18418__$1);
s__18418__$1 = G__18552;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5480__auto__(atlas.query.all_identities(cljs.core.deref(atlas.registry.registry)));
})();
return ["digraph CompoundIdentity {\n","  rankdir=LR;\n","  node [shape=box];\n",clojure.string.join.cljs$core$IFn$_invoke$arity$2("\n",(function (){var iter__5480__auto__ = (function atlas$registry$to_graphviz_$_iter__18436(s__18437){
return (new cljs.core.LazySeq(null,(function (){
var s__18437__$1 = s__18437;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__18437__$1);
if(temp__5804__auto__){
var s__18437__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__18437__$2)){
var c__5478__auto__ = cljs.core.chunk_first(s__18437__$2);
var size__5479__auto__ = cljs.core.count(c__5478__auto__);
var b__18439 = cljs.core.chunk_buffer(size__5479__auto__);
if((function (){var i__18438 = (0);
while(true){
if((i__18438 < size__5479__auto__)){
var vec__18440 = cljs.core._nth(c__5478__auto__,i__18438);
var aspect = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18440,(0),null);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18440,(1),null);
cljs.core.chunk_append(b__18439,atlas.registry.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("  \"%s\" -> \"%s\";",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([aspect], 0)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([id], 0))], 0)));

var G__18553 = (i__18438 + (1));
i__18438 = G__18553;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__18439),atlas$registry$to_graphviz_$_iter__18436(cljs.core.chunk_rest(s__18437__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__18439),null);
}
} else {
var vec__18443 = cljs.core.first(s__18437__$2);
var aspect = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18443,(0),null);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18443,(1),null);
return cljs.core.cons(atlas.registry.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("  \"%s\" -> \"%s\";",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([aspect], 0)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([id], 0))], 0)),atlas$registry$to_graphviz_$_iter__18436(cljs.core.rest(s__18437__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5480__auto__(edges);
})()),"\n}"].join('');
});
/**
 * Return a Mermaid diagram (graph TD) for namespace-based clusters.
 */
atlas.registry.to_mermaid = (function atlas$registry$to_mermaid(){
var clusters = atlas.registry.clusters();
return ["graph TD\n",clojure.string.join.cljs$core$IFn$_invoke$arity$2("\n",(function (){var iter__5480__auto__ = (function atlas$registry$to_mermaid_$_iter__18487(s__18488){
return (new cljs.core.LazySeq(null,(function (){
var s__18488__$1 = s__18488;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__18488__$1);
if(temp__5804__auto__){
var s__18488__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__18488__$2)){
var c__5478__auto__ = cljs.core.chunk_first(s__18488__$2);
var size__5479__auto__ = cljs.core.count(c__5478__auto__);
var b__18490 = cljs.core.chunk_buffer(size__5479__auto__);
if((function (){var i__18489 = (0);
while(true){
if((i__18489 < size__5479__auto__)){
var vec__18494 = cljs.core._nth(c__5478__auto__,i__18489);
var ns_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18494,(0),null);
var ids = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18494,(1),null);
cljs.core.chunk_append(b__18490,["  subgraph ",cljs.core.name(ns_key),"\n",clojure.string.join.cljs$core$IFn$_invoke$arity$2("\n",(function (){var iter__5480__auto__ = ((function (i__18489,vec__18494,ns_key,ids,c__5478__auto__,size__5479__auto__,b__18490,s__18488__$2,temp__5804__auto__,clusters){
return (function atlas$registry$to_mermaid_$_iter__18487_$_iter__18502(s__18503){
return (new cljs.core.LazySeq(null,((function (i__18489,vec__18494,ns_key,ids,c__5478__auto__,size__5479__auto__,b__18490,s__18488__$2,temp__5804__auto__,clusters){
return (function (){
var s__18503__$1 = s__18503;
while(true){
var temp__5804__auto____$1 = cljs.core.seq(s__18503__$1);
if(temp__5804__auto____$1){
var s__18503__$2 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__18503__$2)){
var c__5478__auto____$1 = cljs.core.chunk_first(s__18503__$2);
var size__5479__auto____$1 = cljs.core.count(c__5478__auto____$1);
var b__18505 = cljs.core.chunk_buffer(size__5479__auto____$1);
if((function (){var i__18504 = (0);
while(true){
if((i__18504 < size__5479__auto____$1)){
var id = cljs.core._nth(c__5478__auto____$1,i__18504);
cljs.core.chunk_append(b__18505,atlas.registry.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("    %s[\"%s\"]",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.hash(id),clojure.string.join.cljs$core$IFn$_invoke$arity$2(", ",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.name,id))], 0)));

var G__18554 = (i__18504 + (1));
i__18504 = G__18554;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__18505),atlas$registry$to_mermaid_$_iter__18487_$_iter__18502(cljs.core.chunk_rest(s__18503__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__18505),null);
}
} else {
var id = cljs.core.first(s__18503__$2);
return cljs.core.cons(atlas.registry.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("    %s[\"%s\"]",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.hash(id),clojure.string.join.cljs$core$IFn$_invoke$arity$2(", ",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.name,id))], 0)),atlas$registry$to_mermaid_$_iter__18487_$_iter__18502(cljs.core.rest(s__18503__$2)));
}
} else {
return null;
}
break;
}
});})(i__18489,vec__18494,ns_key,ids,c__5478__auto__,size__5479__auto__,b__18490,s__18488__$2,temp__5804__auto__,clusters))
,null,null));
});})(i__18489,vec__18494,ns_key,ids,c__5478__auto__,size__5479__auto__,b__18490,s__18488__$2,temp__5804__auto__,clusters))
;
return iter__5480__auto__(ids);
})()),"\n  end"].join(''));

var G__18556 = (i__18489 + (1));
i__18489 = G__18556;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__18490),atlas$registry$to_mermaid_$_iter__18487(cljs.core.chunk_rest(s__18488__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__18490),null);
}
} else {
var vec__18507 = cljs.core.first(s__18488__$2);
var ns_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18507,(0),null);
var ids = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18507,(1),null);
return cljs.core.cons(["  subgraph ",cljs.core.name(ns_key),"\n",clojure.string.join.cljs$core$IFn$_invoke$arity$2("\n",(function (){var iter__5480__auto__ = ((function (vec__18507,ns_key,ids,s__18488__$2,temp__5804__auto__,clusters){
return (function atlas$registry$to_mermaid_$_iter__18487_$_iter__18516(s__18517){
return (new cljs.core.LazySeq(null,(function (){
var s__18517__$1 = s__18517;
while(true){
var temp__5804__auto____$1 = cljs.core.seq(s__18517__$1);
if(temp__5804__auto____$1){
var s__18517__$2 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__18517__$2)){
var c__5478__auto__ = cljs.core.chunk_first(s__18517__$2);
var size__5479__auto__ = cljs.core.count(c__5478__auto__);
var b__18519 = cljs.core.chunk_buffer(size__5479__auto__);
if((function (){var i__18518 = (0);
while(true){
if((i__18518 < size__5479__auto__)){
var id = cljs.core._nth(c__5478__auto__,i__18518);
cljs.core.chunk_append(b__18519,atlas.registry.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("    %s[\"%s\"]",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.hash(id),clojure.string.join.cljs$core$IFn$_invoke$arity$2(", ",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.name,id))], 0)));

var G__18557 = (i__18518 + (1));
i__18518 = G__18557;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__18519),atlas$registry$to_mermaid_$_iter__18487_$_iter__18516(cljs.core.chunk_rest(s__18517__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__18519),null);
}
} else {
var id = cljs.core.first(s__18517__$2);
return cljs.core.cons(atlas.registry.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("    %s[\"%s\"]",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.hash(id),clojure.string.join.cljs$core$IFn$_invoke$arity$2(", ",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.name,id))], 0)),atlas$registry$to_mermaid_$_iter__18487_$_iter__18516(cljs.core.rest(s__18517__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});})(vec__18507,ns_key,ids,s__18488__$2,temp__5804__auto__,clusters))
;
return iter__5480__auto__(ids);
})()),"\n  end"].join(''),atlas$registry$to_mermaid_$_iter__18487(cljs.core.rest(s__18488__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5480__auto__(clusters);
})())].join('');
});
/**
 * Return data summary of the current identity registry:
 * {:total :unique-aspects :namespaces :top-aspects :largest :anomalies}
 */
atlas.registry.summary = (function atlas$registry$summary(){
var ids = atlas.query.all_identities(cljs.core.deref(atlas.registry.registry));
var aspects = atlas.query.aspect_frequency(cljs.core.deref(atlas.registry.registry));
var clusters = atlas.registry.clusters();
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"total","total",1916810418),cljs.core.count(ids),new cljs.core.Keyword(null,"unique-aspects","unique-aspects",1252838792),cljs.core.count(aspects),new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cljs.core.keys(clusters),new cljs.core.Keyword(null,"top-aspects","top-aspects",1457925672),cljs.core.take.cljs$core$IFn$_invoke$arity$2((5),aspects),new cljs.core.Keyword(null,"largest","largest",415631083),cljs.core.take.cljs$core$IFn$_invoke$arity$2((3),cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(cljs.core.count,cljs.core._GT_,ids)),new cljs.core.Keyword(null,"anomalies","anomalies",620099616),atlas.registry.find_anomalies()], null);
});

//# sourceMappingURL=atlas.registry.js.map
