goog.provide('reagent.dom');
var module$node_modules$react_dom$index=shadow.js.require("module$node_modules$react_dom$index", {});
if((typeof reagent !== 'undefined') && (typeof reagent.dom !== 'undefined') && (typeof reagent.dom.roots !== 'undefined')){
} else {
reagent.dom.roots = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
}
reagent.dom.unmount_comp = (function reagent$dom$unmount_comp(container){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(reagent.dom.roots,cljs.core.dissoc,container);

return module$node_modules$react_dom$index.unmountComponentAtNode(container);
});
reagent.dom.render_comp = (function reagent$dom$render_comp(comp,container,callback){
var _STAR_always_update_STAR__orig_val__22078 = reagent.impl.util._STAR_always_update_STAR_;
var _STAR_always_update_STAR__temp_val__22079 = true;
(reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR__temp_val__22079);

try{return module$node_modules$react_dom$index.render((comp.cljs$core$IFn$_invoke$arity$0 ? comp.cljs$core$IFn$_invoke$arity$0() : comp.call(null)),container,(function (){
var _STAR_always_update_STAR__orig_val__22080 = reagent.impl.util._STAR_always_update_STAR_;
var _STAR_always_update_STAR__temp_val__22081 = false;
(reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR__temp_val__22081);

try{cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(reagent.dom.roots,cljs.core.assoc,container,comp);

reagent.impl.batching.flush_after_render();

if((!((callback == null)))){
return (callback.cljs$core$IFn$_invoke$arity$0 ? callback.cljs$core$IFn$_invoke$arity$0() : callback.call(null));
} else {
return null;
}
}finally {(reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR__orig_val__22080);
}}));
}finally {(reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR__orig_val__22078);
}});
reagent.dom.re_render_component = (function reagent$dom$re_render_component(comp,container){
return reagent.dom.render_comp(comp,container,null);
});
/**
 * Render a Reagent component into the DOM. The first argument may be
 *   either a vector (using Reagent's Hiccup syntax), or a React element.
 *   The second argument should be a DOM node.
 * 
 *   Optionally takes a callback that is called when the component is in place.
 * 
 *   Returns the mounted component instance.
 */
reagent.dom.render = (function reagent$dom$render(var_args){
var G__22084 = arguments.length;
switch (G__22084) {
case 2:
return reagent.dom.render.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return reagent.dom.render.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(reagent.dom.render.cljs$core$IFn$_invoke$arity$2 = (function (comp,container){
return reagent.dom.render.cljs$core$IFn$_invoke$arity$3(comp,container,reagent.impl.template._STAR_current_default_compiler_STAR_);
}));

(reagent.dom.render.cljs$core$IFn$_invoke$arity$3 = (function (comp,container,callback_or_compiler){
reagent.ratom.flush_BANG_();

var vec__22088 = ((cljs.core.map_QMARK_(callback_or_compiler))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compiler","compiler",-267926731).cljs$core$IFn$_invoke$arity$1(callback_or_compiler),new cljs.core.Keyword(null,"callback","callback",-705136228).cljs$core$IFn$_invoke$arity$1(callback_or_compiler)], null):((cljs.core.fn_QMARK_(callback_or_compiler))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [reagent.impl.template._STAR_current_default_compiler_STAR_,callback_or_compiler], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [callback_or_compiler,null], null)
));
var compiler = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22088,(0),null);
var callback = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22088,(1),null);
var f = (function (){
return reagent.impl.protocols.as_element(compiler,((cljs.core.fn_QMARK_(comp))?(comp.cljs$core$IFn$_invoke$arity$0 ? comp.cljs$core$IFn$_invoke$arity$0() : comp.call(null)):comp));
});
return reagent.dom.render_comp(f,container,callback);
}));

(reagent.dom.render.cljs$lang$maxFixedArity = 3);

/**
 * Remove a component from the given DOM node.
 */
reagent.dom.unmount_component_at_node = (function reagent$dom$unmount_component_at_node(container){
return reagent.dom.unmount_comp(container);
});
/**
 * Returns the root DOM node of a mounted component.
 */
reagent.dom.dom_node = (function reagent$dom$dom_node(this$){
return module$node_modules$react_dom$index.findDOMNode(this$);
});
/**
 * Force re-rendering of all mounted Reagent components. This is
 *   probably only useful in a development environment, when you want to
 *   update components in response to some dynamic changes to code.
 * 
 *   Note that force-update-all may not update root components. This
 *   happens if a component 'foo' is mounted with `(render [foo])` (since
 *   functions are passed by value, and not by reference, in
 *   ClojureScript). To get around this you'll have to introduce a layer
 *   of indirection, for example by using `(render [#'foo])` instead.
 */
reagent.dom.force_update_all = (function reagent$dom$force_update_all(){
reagent.ratom.flush_BANG_();

var seq__22094_22121 = cljs.core.seq(cljs.core.deref(reagent.dom.roots));
var chunk__22095_22122 = null;
var count__22096_22123 = (0);
var i__22097_22124 = (0);
while(true){
if((i__22097_22124 < count__22096_22123)){
var vec__22106_22125 = chunk__22095_22122.cljs$core$IIndexed$_nth$arity$2(null,i__22097_22124);
var container_22126 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22106_22125,(0),null);
var comp_22127 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22106_22125,(1),null);
reagent.dom.re_render_component(comp_22127,container_22126);


var G__22128 = seq__22094_22121;
var G__22129 = chunk__22095_22122;
var G__22130 = count__22096_22123;
var G__22131 = (i__22097_22124 + (1));
seq__22094_22121 = G__22128;
chunk__22095_22122 = G__22129;
count__22096_22123 = G__22130;
i__22097_22124 = G__22131;
continue;
} else {
var temp__5804__auto___22132 = cljs.core.seq(seq__22094_22121);
if(temp__5804__auto___22132){
var seq__22094_22133__$1 = temp__5804__auto___22132;
if(cljs.core.chunked_seq_QMARK_(seq__22094_22133__$1)){
var c__5525__auto___22134 = cljs.core.chunk_first(seq__22094_22133__$1);
var G__22135 = cljs.core.chunk_rest(seq__22094_22133__$1);
var G__22136 = c__5525__auto___22134;
var G__22137 = cljs.core.count(c__5525__auto___22134);
var G__22138 = (0);
seq__22094_22121 = G__22135;
chunk__22095_22122 = G__22136;
count__22096_22123 = G__22137;
i__22097_22124 = G__22138;
continue;
} else {
var vec__22113_22139 = cljs.core.first(seq__22094_22133__$1);
var container_22140 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22113_22139,(0),null);
var comp_22141 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22113_22139,(1),null);
reagent.dom.re_render_component(comp_22141,container_22140);


var G__22142 = cljs.core.next(seq__22094_22133__$1);
var G__22143 = null;
var G__22144 = (0);
var G__22145 = (0);
seq__22094_22121 = G__22142;
chunk__22095_22122 = G__22143;
count__22096_22123 = G__22144;
i__22097_22124 = G__22145;
continue;
}
} else {
}
}
break;
}

return reagent.impl.batching.flush_after_render();
});

//# sourceMappingURL=reagent.dom.js.map
