goog.provide('cljs.core.async');
goog.scope(function(){
  cljs.core.async.goog$module$goog$array = goog.module.get('goog.array');
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14689 = (function (f,blockable,meta14690){
this.f = f;
this.blockable = blockable;
this.meta14690 = meta14690;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async14689.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14691,meta14690__$1){
var self__ = this;
var _14691__$1 = this;
return (new cljs.core.async.t_cljs$core$async14689(self__.f,self__.blockable,meta14690__$1));
}));

(cljs.core.async.t_cljs$core$async14689.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14691){
var self__ = this;
var _14691__$1 = this;
return self__.meta14690;
}));

(cljs.core.async.t_cljs$core$async14689.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14689.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async14689.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async14689.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async14689.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta14690","meta14690",662849740,null)], null);
}));

(cljs.core.async.t_cljs$core$async14689.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async14689.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14689");

(cljs.core.async.t_cljs$core$async14689.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async14689");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async14689.
 */
cljs.core.async.__GT_t_cljs$core$async14689 = (function cljs$core$async$__GT_t_cljs$core$async14689(f,blockable,meta14690){
return (new cljs.core.async.t_cljs$core$async14689(f,blockable,meta14690));
});


cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__14684 = arguments.length;
switch (G__14684) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
return (new cljs.core.async.t_cljs$core$async14689(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__14712 = arguments.length;
switch (G__14712) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__14719 = arguments.length;
switch (G__14719) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__14733 = arguments.length;
switch (G__14733) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_17654 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_17654) : fn1.call(null,val_17654));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_17654) : fn1.call(null,val_17654));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__14744 = arguments.length;
switch (G__14744) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5802__auto__)){
var ret = temp__5802__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5802__auto__)){
var retb = temp__5802__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5593__auto___17656 = n;
var x_17657 = (0);
while(true){
if((x_17657 < n__5593__auto___17656)){
(a[x_17657] = x_17657);

var G__17658 = (x_17657 + (1));
x_17657 = G__17658;
continue;
} else {
}
break;
}

cljs.core.async.goog$module$goog$array.shuffle(a);

return a;
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14761 = (function (flag,meta14762){
this.flag = flag;
this.meta14762 = meta14762;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async14761.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14763,meta14762__$1){
var self__ = this;
var _14763__$1 = this;
return (new cljs.core.async.t_cljs$core$async14761(self__.flag,meta14762__$1));
}));

(cljs.core.async.t_cljs$core$async14761.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14763){
var self__ = this;
var _14763__$1 = this;
return self__.meta14762;
}));

(cljs.core.async.t_cljs$core$async14761.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14761.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async14761.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async14761.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async14761.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta14762","meta14762",-1807043072,null)], null);
}));

(cljs.core.async.t_cljs$core$async14761.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async14761.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14761");

(cljs.core.async.t_cljs$core$async14761.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async14761");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async14761.
 */
cljs.core.async.__GT_t_cljs$core$async14761 = (function cljs$core$async$__GT_t_cljs$core$async14761(flag,meta14762){
return (new cljs.core.async.t_cljs$core$async14761(flag,meta14762));
});


cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
return (new cljs.core.async.t_cljs$core$async14761(flag,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14774 = (function (flag,cb,meta14775){
this.flag = flag;
this.cb = cb;
this.meta14775 = meta14775;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async14774.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14776,meta14775__$1){
var self__ = this;
var _14776__$1 = this;
return (new cljs.core.async.t_cljs$core$async14774(self__.flag,self__.cb,meta14775__$1));
}));

(cljs.core.async.t_cljs$core$async14774.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14776){
var self__ = this;
var _14776__$1 = this;
return self__.meta14775;
}));

(cljs.core.async.t_cljs$core$async14774.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14774.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async14774.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async14774.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async14774.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta14775","meta14775",683548064,null)], null);
}));

(cljs.core.async.t_cljs$core$async14774.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async14774.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14774");

(cljs.core.async.t_cljs$core$async14774.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async14774");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async14774.
 */
cljs.core.async.__GT_t_cljs$core$async14774 = (function cljs$core$async$__GT_t_cljs$core$async14774(flag,cb,meta14775){
return (new cljs.core.async.t_cljs$core$async14774(flag,cb,meta14775));
});


cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
return (new cljs.core.async.t_cljs$core$async14774(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__14790_SHARP_){
var G__14801 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__14790_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__14801) : fret.call(null,G__14801));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__14791_SHARP_){
var G__14802 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__14791_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__14802) : fret.call(null,G__14802));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__5002__auto__ = wport;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return port;
}
})()], null));
} else {
var G__17663 = (i + (1));
i = G__17663;
continue;
}
} else {
return null;
}
break;
}
})();
var or__5002__auto__ = ret;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5804__auto__ = (function (){var and__5000__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__5000__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__5000__auto__;
}
})();
if(cljs.core.truth_(temp__5804__auto__)){
var got = temp__5804__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5732__auto__ = [];
var len__5726__auto___17664 = arguments.length;
var i__5727__auto___17665 = (0);
while(true){
if((i__5727__auto___17665 < len__5726__auto___17664)){
args__5732__auto__.push((arguments[i__5727__auto___17665]));

var G__17666 = (i__5727__auto___17665 + (1));
i__5727__auto___17665 = G__17666;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((1) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5733__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__14807){
var map__14808 = p__14807;
var map__14808__$1 = cljs.core.__destructure_map(map__14808);
var opts = map__14808__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq14803){
var G__14804 = cljs.core.first(seq14803);
var seq14803__$1 = cljs.core.next(seq14803);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14804,seq14803__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__14818 = arguments.length;
switch (G__14818) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__14553__auto___17668 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14555__auto__ = (function (){var switch__14401__auto__ = (function (state_14857){
var state_val_14858 = (state_14857[(1)]);
if((state_val_14858 === (7))){
var inst_14851 = (state_14857[(2)]);
var state_14857__$1 = state_14857;
var statearr_14863_17670 = state_14857__$1;
(statearr_14863_17670[(2)] = inst_14851);

(statearr_14863_17670[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14858 === (1))){
var state_14857__$1 = state_14857;
var statearr_14866_17671 = state_14857__$1;
(statearr_14866_17671[(2)] = null);

(statearr_14866_17671[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14858 === (4))){
var inst_14834 = (state_14857[(7)]);
var inst_14834__$1 = (state_14857[(2)]);
var inst_14835 = (inst_14834__$1 == null);
var state_14857__$1 = (function (){var statearr_14867 = state_14857;
(statearr_14867[(7)] = inst_14834__$1);

return statearr_14867;
})();
if(cljs.core.truth_(inst_14835)){
var statearr_14868_17673 = state_14857__$1;
(statearr_14868_17673[(1)] = (5));

} else {
var statearr_14869_17674 = state_14857__$1;
(statearr_14869_17674[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14858 === (13))){
var state_14857__$1 = state_14857;
var statearr_14870_17675 = state_14857__$1;
(statearr_14870_17675[(2)] = null);

(statearr_14870_17675[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14858 === (6))){
var inst_14834 = (state_14857[(7)]);
var state_14857__$1 = state_14857;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14857__$1,(11),to,inst_14834);
} else {
if((state_val_14858 === (3))){
var inst_14854 = (state_14857[(2)]);
var state_14857__$1 = state_14857;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14857__$1,inst_14854);
} else {
if((state_val_14858 === (12))){
var state_14857__$1 = state_14857;
var statearr_14875_17676 = state_14857__$1;
(statearr_14875_17676[(2)] = null);

(statearr_14875_17676[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14858 === (2))){
var state_14857__$1 = state_14857;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14857__$1,(4),from);
} else {
if((state_val_14858 === (11))){
var inst_14844 = (state_14857[(2)]);
var state_14857__$1 = state_14857;
if(cljs.core.truth_(inst_14844)){
var statearr_14876_17677 = state_14857__$1;
(statearr_14876_17677[(1)] = (12));

} else {
var statearr_14877_17678 = state_14857__$1;
(statearr_14877_17678[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14858 === (9))){
var state_14857__$1 = state_14857;
var statearr_14878_17679 = state_14857__$1;
(statearr_14878_17679[(2)] = null);

(statearr_14878_17679[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14858 === (5))){
var state_14857__$1 = state_14857;
if(cljs.core.truth_(close_QMARK_)){
var statearr_14881_17680 = state_14857__$1;
(statearr_14881_17680[(1)] = (8));

} else {
var statearr_14882_17681 = state_14857__$1;
(statearr_14882_17681[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14858 === (14))){
var inst_14849 = (state_14857[(2)]);
var state_14857__$1 = state_14857;
var statearr_14885_17682 = state_14857__$1;
(statearr_14885_17682[(2)] = inst_14849);

(statearr_14885_17682[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14858 === (10))){
var inst_14841 = (state_14857[(2)]);
var state_14857__$1 = state_14857;
var statearr_14886_17683 = state_14857__$1;
(statearr_14886_17683[(2)] = inst_14841);

(statearr_14886_17683[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14858 === (8))){
var inst_14838 = cljs.core.async.close_BANG_(to);
var state_14857__$1 = state_14857;
var statearr_14887_17684 = state_14857__$1;
(statearr_14887_17684[(2)] = inst_14838);

(statearr_14887_17684[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__14402__auto__ = null;
var cljs$core$async$state_machine__14402__auto____0 = (function (){
var statearr_14888 = [null,null,null,null,null,null,null,null];
(statearr_14888[(0)] = cljs$core$async$state_machine__14402__auto__);

(statearr_14888[(1)] = (1));

return statearr_14888;
});
var cljs$core$async$state_machine__14402__auto____1 = (function (state_14857){
while(true){
var ret_value__14403__auto__ = (function (){try{while(true){
var result__14404__auto__ = switch__14401__auto__(state_14857);
if(cljs.core.keyword_identical_QMARK_(result__14404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14404__auto__;
}
break;
}
}catch (e14889){var ex__14405__auto__ = e14889;
var statearr_14891_17685 = state_14857;
(statearr_14891_17685[(2)] = ex__14405__auto__);


if(cljs.core.seq((state_14857[(4)]))){
var statearr_14892_17686 = state_14857;
(statearr_14892_17686[(1)] = cljs.core.first((state_14857[(4)])));

} else {
throw ex__14405__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17687 = state_14857;
state_14857 = G__17687;
continue;
} else {
return ret_value__14403__auto__;
}
break;
}
});
cljs$core$async$state_machine__14402__auto__ = function(state_14857){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14402__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14402__auto____1.call(this,state_14857);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14402__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14402__auto____0;
cljs$core$async$state_machine__14402__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14402__auto____1;
return cljs$core$async$state_machine__14402__auto__;
})()
})();
var state__14556__auto__ = (function (){var statearr_14896 = f__14555__auto__();
(statearr_14896[(6)] = c__14553__auto___17668);

return statearr_14896;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14556__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process__$1 = (function (p__14899){
var vec__14900 = p__14899;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14900,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14900,(1),null);
var job = vec__14900;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__14553__auto___17688 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14555__auto__ = (function (){var switch__14401__auto__ = (function (state_14911){
var state_val_14912 = (state_14911[(1)]);
if((state_val_14912 === (1))){
var state_14911__$1 = state_14911;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14911__$1,(2),res,v);
} else {
if((state_val_14912 === (2))){
var inst_14908 = (state_14911[(2)]);
var inst_14909 = cljs.core.async.close_BANG_(res);
var state_14911__$1 = (function (){var statearr_14924 = state_14911;
(statearr_14924[(7)] = inst_14908);

return statearr_14924;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_14911__$1,inst_14909);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14402__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14402__auto____0 = (function (){
var statearr_14926 = [null,null,null,null,null,null,null,null];
(statearr_14926[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14402__auto__);

(statearr_14926[(1)] = (1));

return statearr_14926;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14402__auto____1 = (function (state_14911){
while(true){
var ret_value__14403__auto__ = (function (){try{while(true){
var result__14404__auto__ = switch__14401__auto__(state_14911);
if(cljs.core.keyword_identical_QMARK_(result__14404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14404__auto__;
}
break;
}
}catch (e14927){var ex__14405__auto__ = e14927;
var statearr_14928_17689 = state_14911;
(statearr_14928_17689[(2)] = ex__14405__auto__);


if(cljs.core.seq((state_14911[(4)]))){
var statearr_14929_17690 = state_14911;
(statearr_14929_17690[(1)] = cljs.core.first((state_14911[(4)])));

} else {
throw ex__14405__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17691 = state_14911;
state_14911 = G__17691;
continue;
} else {
return ret_value__14403__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14402__auto__ = function(state_14911){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14402__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14402__auto____1.call(this,state_14911);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14402__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14402__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14402__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14402__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14402__auto__;
})()
})();
var state__14556__auto__ = (function (){var statearr_14931 = f__14555__auto__();
(statearr_14931[(6)] = c__14553__auto___17688);

return statearr_14931;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14556__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__14933){
var vec__14934 = p__14933;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14934,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14934,(1),null);
var job = vec__14934;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__5593__auto___17695 = n;
var __17696 = (0);
while(true){
if((__17696 < n__5593__auto___17695)){
var G__14940_17697 = type;
var G__14940_17698__$1 = (((G__14940_17697 instanceof cljs.core.Keyword))?G__14940_17697.fqn:null);
switch (G__14940_17698__$1) {
case "compute":
var c__14553__auto___17700 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__17696,c__14553__auto___17700,G__14940_17697,G__14940_17698__$1,n__5593__auto___17695,jobs,results,process__$1,async){
return (function (){
var f__14555__auto__ = (function (){var switch__14401__auto__ = ((function (__17696,c__14553__auto___17700,G__14940_17697,G__14940_17698__$1,n__5593__auto___17695,jobs,results,process__$1,async){
return (function (state_14957){
var state_val_14959 = (state_14957[(1)]);
if((state_val_14959 === (1))){
var state_14957__$1 = state_14957;
var statearr_14960_17701 = state_14957__$1;
(statearr_14960_17701[(2)] = null);

(statearr_14960_17701[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14959 === (2))){
var state_14957__$1 = state_14957;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14957__$1,(4),jobs);
} else {
if((state_val_14959 === (3))){
var inst_14955 = (state_14957[(2)]);
var state_14957__$1 = state_14957;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14957__$1,inst_14955);
} else {
if((state_val_14959 === (4))){
var inst_14947 = (state_14957[(2)]);
var inst_14948 = process__$1(inst_14947);
var state_14957__$1 = state_14957;
if(cljs.core.truth_(inst_14948)){
var statearr_14963_17702 = state_14957__$1;
(statearr_14963_17702[(1)] = (5));

} else {
var statearr_14964_17703 = state_14957__$1;
(statearr_14964_17703[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14959 === (5))){
var state_14957__$1 = state_14957;
var statearr_14966_17704 = state_14957__$1;
(statearr_14966_17704[(2)] = null);

(statearr_14966_17704[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14959 === (6))){
var state_14957__$1 = state_14957;
var statearr_14971_17705 = state_14957__$1;
(statearr_14971_17705[(2)] = null);

(statearr_14971_17705[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14959 === (7))){
var inst_14953 = (state_14957[(2)]);
var state_14957__$1 = state_14957;
var statearr_14972_17706 = state_14957__$1;
(statearr_14972_17706[(2)] = inst_14953);

(statearr_14972_17706[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__17696,c__14553__auto___17700,G__14940_17697,G__14940_17698__$1,n__5593__auto___17695,jobs,results,process__$1,async))
;
return ((function (__17696,switch__14401__auto__,c__14553__auto___17700,G__14940_17697,G__14940_17698__$1,n__5593__auto___17695,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14402__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14402__auto____0 = (function (){
var statearr_14973 = [null,null,null,null,null,null,null];
(statearr_14973[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14402__auto__);

(statearr_14973[(1)] = (1));

return statearr_14973;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14402__auto____1 = (function (state_14957){
while(true){
var ret_value__14403__auto__ = (function (){try{while(true){
var result__14404__auto__ = switch__14401__auto__(state_14957);
if(cljs.core.keyword_identical_QMARK_(result__14404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14404__auto__;
}
break;
}
}catch (e14975){var ex__14405__auto__ = e14975;
var statearr_14976_17710 = state_14957;
(statearr_14976_17710[(2)] = ex__14405__auto__);


if(cljs.core.seq((state_14957[(4)]))){
var statearr_14977_17711 = state_14957;
(statearr_14977_17711[(1)] = cljs.core.first((state_14957[(4)])));

} else {
throw ex__14405__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17712 = state_14957;
state_14957 = G__17712;
continue;
} else {
return ret_value__14403__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14402__auto__ = function(state_14957){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14402__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14402__auto____1.call(this,state_14957);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14402__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14402__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14402__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14402__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14402__auto__;
})()
;})(__17696,switch__14401__auto__,c__14553__auto___17700,G__14940_17697,G__14940_17698__$1,n__5593__auto___17695,jobs,results,process__$1,async))
})();
var state__14556__auto__ = (function (){var statearr_14983 = f__14555__auto__();
(statearr_14983[(6)] = c__14553__auto___17700);

return statearr_14983;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14556__auto__);
});})(__17696,c__14553__auto___17700,G__14940_17697,G__14940_17698__$1,n__5593__auto___17695,jobs,results,process__$1,async))
);


break;
case "async":
var c__14553__auto___17713 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__17696,c__14553__auto___17713,G__14940_17697,G__14940_17698__$1,n__5593__auto___17695,jobs,results,process__$1,async){
return (function (){
var f__14555__auto__ = (function (){var switch__14401__auto__ = ((function (__17696,c__14553__auto___17713,G__14940_17697,G__14940_17698__$1,n__5593__auto___17695,jobs,results,process__$1,async){
return (function (state_14997){
var state_val_14998 = (state_14997[(1)]);
if((state_val_14998 === (1))){
var state_14997__$1 = state_14997;
var statearr_15002_17714 = state_14997__$1;
(statearr_15002_17714[(2)] = null);

(statearr_15002_17714[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14998 === (2))){
var state_14997__$1 = state_14997;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14997__$1,(4),jobs);
} else {
if((state_val_14998 === (3))){
var inst_14994 = (state_14997[(2)]);
var state_14997__$1 = state_14997;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14997__$1,inst_14994);
} else {
if((state_val_14998 === (4))){
var inst_14986 = (state_14997[(2)]);
var inst_14987 = async(inst_14986);
var state_14997__$1 = state_14997;
if(cljs.core.truth_(inst_14987)){
var statearr_15003_17715 = state_14997__$1;
(statearr_15003_17715[(1)] = (5));

} else {
var statearr_15008_17716 = state_14997__$1;
(statearr_15008_17716[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14998 === (5))){
var state_14997__$1 = state_14997;
var statearr_15009_17717 = state_14997__$1;
(statearr_15009_17717[(2)] = null);

(statearr_15009_17717[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14998 === (6))){
var state_14997__$1 = state_14997;
var statearr_15010_17718 = state_14997__$1;
(statearr_15010_17718[(2)] = null);

(statearr_15010_17718[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14998 === (7))){
var inst_14992 = (state_14997[(2)]);
var state_14997__$1 = state_14997;
var statearr_15011_17719 = state_14997__$1;
(statearr_15011_17719[(2)] = inst_14992);

(statearr_15011_17719[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__17696,c__14553__auto___17713,G__14940_17697,G__14940_17698__$1,n__5593__auto___17695,jobs,results,process__$1,async))
;
return ((function (__17696,switch__14401__auto__,c__14553__auto___17713,G__14940_17697,G__14940_17698__$1,n__5593__auto___17695,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14402__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14402__auto____0 = (function (){
var statearr_15012 = [null,null,null,null,null,null,null];
(statearr_15012[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14402__auto__);

(statearr_15012[(1)] = (1));

return statearr_15012;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14402__auto____1 = (function (state_14997){
while(true){
var ret_value__14403__auto__ = (function (){try{while(true){
var result__14404__auto__ = switch__14401__auto__(state_14997);
if(cljs.core.keyword_identical_QMARK_(result__14404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14404__auto__;
}
break;
}
}catch (e15013){var ex__14405__auto__ = e15013;
var statearr_15014_17720 = state_14997;
(statearr_15014_17720[(2)] = ex__14405__auto__);


if(cljs.core.seq((state_14997[(4)]))){
var statearr_15015_17721 = state_14997;
(statearr_15015_17721[(1)] = cljs.core.first((state_14997[(4)])));

} else {
throw ex__14405__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17722 = state_14997;
state_14997 = G__17722;
continue;
} else {
return ret_value__14403__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14402__auto__ = function(state_14997){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14402__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14402__auto____1.call(this,state_14997);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14402__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14402__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14402__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14402__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14402__auto__;
})()
;})(__17696,switch__14401__auto__,c__14553__auto___17713,G__14940_17697,G__14940_17698__$1,n__5593__auto___17695,jobs,results,process__$1,async))
})();
var state__14556__auto__ = (function (){var statearr_15016 = f__14555__auto__();
(statearr_15016[(6)] = c__14553__auto___17713);

return statearr_15016;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14556__auto__);
});})(__17696,c__14553__auto___17713,G__14940_17697,G__14940_17698__$1,n__5593__auto___17695,jobs,results,process__$1,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14940_17698__$1)].join('')));

}

var G__17723 = (__17696 + (1));
__17696 = G__17723;
continue;
} else {
}
break;
}

var c__14553__auto___17724 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14555__auto__ = (function (){var switch__14401__auto__ = (function (state_15042){
var state_val_15043 = (state_15042[(1)]);
if((state_val_15043 === (7))){
var inst_15038 = (state_15042[(2)]);
var state_15042__$1 = state_15042;
var statearr_15044_17725 = state_15042__$1;
(statearr_15044_17725[(2)] = inst_15038);

(statearr_15044_17725[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15043 === (1))){
var state_15042__$1 = state_15042;
var statearr_15045_17726 = state_15042__$1;
(statearr_15045_17726[(2)] = null);

(statearr_15045_17726[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15043 === (4))){
var inst_15023 = (state_15042[(7)]);
var inst_15023__$1 = (state_15042[(2)]);
var inst_15024 = (inst_15023__$1 == null);
var state_15042__$1 = (function (){var statearr_15046 = state_15042;
(statearr_15046[(7)] = inst_15023__$1);

return statearr_15046;
})();
if(cljs.core.truth_(inst_15024)){
var statearr_15047_17727 = state_15042__$1;
(statearr_15047_17727[(1)] = (5));

} else {
var statearr_15048_17728 = state_15042__$1;
(statearr_15048_17728[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15043 === (6))){
var inst_15023 = (state_15042[(7)]);
var inst_15028 = (state_15042[(8)]);
var inst_15028__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_15029 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15030 = [inst_15023,inst_15028__$1];
var inst_15031 = (new cljs.core.PersistentVector(null,2,(5),inst_15029,inst_15030,null));
var state_15042__$1 = (function (){var statearr_15051 = state_15042;
(statearr_15051[(8)] = inst_15028__$1);

return statearr_15051;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15042__$1,(8),jobs,inst_15031);
} else {
if((state_val_15043 === (3))){
var inst_15040 = (state_15042[(2)]);
var state_15042__$1 = state_15042;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15042__$1,inst_15040);
} else {
if((state_val_15043 === (2))){
var state_15042__$1 = state_15042;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15042__$1,(4),from);
} else {
if((state_val_15043 === (9))){
var inst_15035 = (state_15042[(2)]);
var state_15042__$1 = (function (){var statearr_15052 = state_15042;
(statearr_15052[(9)] = inst_15035);

return statearr_15052;
})();
var statearr_15055_17729 = state_15042__$1;
(statearr_15055_17729[(2)] = null);

(statearr_15055_17729[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15043 === (5))){
var inst_15026 = cljs.core.async.close_BANG_(jobs);
var state_15042__$1 = state_15042;
var statearr_15058_17730 = state_15042__$1;
(statearr_15058_17730[(2)] = inst_15026);

(statearr_15058_17730[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15043 === (8))){
var inst_15028 = (state_15042[(8)]);
var inst_15033 = (state_15042[(2)]);
var state_15042__$1 = (function (){var statearr_15059 = state_15042;
(statearr_15059[(10)] = inst_15033);

return statearr_15059;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15042__$1,(9),results,inst_15028);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14402__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14402__auto____0 = (function (){
var statearr_15060 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_15060[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14402__auto__);

(statearr_15060[(1)] = (1));

return statearr_15060;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14402__auto____1 = (function (state_15042){
while(true){
var ret_value__14403__auto__ = (function (){try{while(true){
var result__14404__auto__ = switch__14401__auto__(state_15042);
if(cljs.core.keyword_identical_QMARK_(result__14404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14404__auto__;
}
break;
}
}catch (e15061){var ex__14405__auto__ = e15061;
var statearr_15062_17732 = state_15042;
(statearr_15062_17732[(2)] = ex__14405__auto__);


if(cljs.core.seq((state_15042[(4)]))){
var statearr_15063_17733 = state_15042;
(statearr_15063_17733[(1)] = cljs.core.first((state_15042[(4)])));

} else {
throw ex__14405__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17734 = state_15042;
state_15042 = G__17734;
continue;
} else {
return ret_value__14403__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14402__auto__ = function(state_15042){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14402__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14402__auto____1.call(this,state_15042);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14402__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14402__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14402__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14402__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14402__auto__;
})()
})();
var state__14556__auto__ = (function (){var statearr_15066 = f__14555__auto__();
(statearr_15066[(6)] = c__14553__auto___17724);

return statearr_15066;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14556__auto__);
}));


var c__14553__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14555__auto__ = (function (){var switch__14401__auto__ = (function (state_15105){
var state_val_15106 = (state_15105[(1)]);
if((state_val_15106 === (7))){
var inst_15101 = (state_15105[(2)]);
var state_15105__$1 = state_15105;
var statearr_15112_17735 = state_15105__$1;
(statearr_15112_17735[(2)] = inst_15101);

(statearr_15112_17735[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15106 === (20))){
var state_15105__$1 = state_15105;
var statearr_15114_17736 = state_15105__$1;
(statearr_15114_17736[(2)] = null);

(statearr_15114_17736[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15106 === (1))){
var state_15105__$1 = state_15105;
var statearr_15117_17737 = state_15105__$1;
(statearr_15117_17737[(2)] = null);

(statearr_15117_17737[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15106 === (4))){
var inst_15069 = (state_15105[(7)]);
var inst_15069__$1 = (state_15105[(2)]);
var inst_15070 = (inst_15069__$1 == null);
var state_15105__$1 = (function (){var statearr_15123 = state_15105;
(statearr_15123[(7)] = inst_15069__$1);

return statearr_15123;
})();
if(cljs.core.truth_(inst_15070)){
var statearr_15124_17738 = state_15105__$1;
(statearr_15124_17738[(1)] = (5));

} else {
var statearr_15128_17739 = state_15105__$1;
(statearr_15128_17739[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15106 === (15))){
var inst_15083 = (state_15105[(8)]);
var state_15105__$1 = state_15105;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15105__$1,(18),to,inst_15083);
} else {
if((state_val_15106 === (21))){
var inst_15096 = (state_15105[(2)]);
var state_15105__$1 = state_15105;
var statearr_15131_17740 = state_15105__$1;
(statearr_15131_17740[(2)] = inst_15096);

(statearr_15131_17740[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15106 === (13))){
var inst_15098 = (state_15105[(2)]);
var state_15105__$1 = (function (){var statearr_15140 = state_15105;
(statearr_15140[(9)] = inst_15098);

return statearr_15140;
})();
var statearr_15142_17741 = state_15105__$1;
(statearr_15142_17741[(2)] = null);

(statearr_15142_17741[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15106 === (6))){
var inst_15069 = (state_15105[(7)]);
var state_15105__$1 = state_15105;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15105__$1,(11),inst_15069);
} else {
if((state_val_15106 === (17))){
var inst_15091 = (state_15105[(2)]);
var state_15105__$1 = state_15105;
if(cljs.core.truth_(inst_15091)){
var statearr_15147_17743 = state_15105__$1;
(statearr_15147_17743[(1)] = (19));

} else {
var statearr_15148_17744 = state_15105__$1;
(statearr_15148_17744[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15106 === (3))){
var inst_15103 = (state_15105[(2)]);
var state_15105__$1 = state_15105;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15105__$1,inst_15103);
} else {
if((state_val_15106 === (12))){
var inst_15080 = (state_15105[(10)]);
var state_15105__$1 = state_15105;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15105__$1,(14),inst_15080);
} else {
if((state_val_15106 === (2))){
var state_15105__$1 = state_15105;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15105__$1,(4),results);
} else {
if((state_val_15106 === (19))){
var state_15105__$1 = state_15105;
var statearr_15152_17745 = state_15105__$1;
(statearr_15152_17745[(2)] = null);

(statearr_15152_17745[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15106 === (11))){
var inst_15080 = (state_15105[(2)]);
var state_15105__$1 = (function (){var statearr_15153 = state_15105;
(statearr_15153[(10)] = inst_15080);

return statearr_15153;
})();
var statearr_15154_17746 = state_15105__$1;
(statearr_15154_17746[(2)] = null);

(statearr_15154_17746[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15106 === (9))){
var state_15105__$1 = state_15105;
var statearr_15155_17747 = state_15105__$1;
(statearr_15155_17747[(2)] = null);

(statearr_15155_17747[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15106 === (5))){
var state_15105__$1 = state_15105;
if(cljs.core.truth_(close_QMARK_)){
var statearr_15156_17748 = state_15105__$1;
(statearr_15156_17748[(1)] = (8));

} else {
var statearr_15157_17749 = state_15105__$1;
(statearr_15157_17749[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15106 === (14))){
var inst_15083 = (state_15105[(8)]);
var inst_15085 = (state_15105[(11)]);
var inst_15083__$1 = (state_15105[(2)]);
var inst_15084 = (inst_15083__$1 == null);
var inst_15085__$1 = cljs.core.not(inst_15084);
var state_15105__$1 = (function (){var statearr_15160 = state_15105;
(statearr_15160[(8)] = inst_15083__$1);

(statearr_15160[(11)] = inst_15085__$1);

return statearr_15160;
})();
if(inst_15085__$1){
var statearr_15161_17750 = state_15105__$1;
(statearr_15161_17750[(1)] = (15));

} else {
var statearr_15162_17751 = state_15105__$1;
(statearr_15162_17751[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15106 === (16))){
var inst_15085 = (state_15105[(11)]);
var state_15105__$1 = state_15105;
var statearr_15163_17752 = state_15105__$1;
(statearr_15163_17752[(2)] = inst_15085);

(statearr_15163_17752[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15106 === (10))){
var inst_15076 = (state_15105[(2)]);
var state_15105__$1 = state_15105;
var statearr_15164_17753 = state_15105__$1;
(statearr_15164_17753[(2)] = inst_15076);

(statearr_15164_17753[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15106 === (18))){
var inst_15088 = (state_15105[(2)]);
var state_15105__$1 = state_15105;
var statearr_15170_17756 = state_15105__$1;
(statearr_15170_17756[(2)] = inst_15088);

(statearr_15170_17756[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15106 === (8))){
var inst_15073 = cljs.core.async.close_BANG_(to);
var state_15105__$1 = state_15105;
var statearr_15173_17757 = state_15105__$1;
(statearr_15173_17757[(2)] = inst_15073);

(statearr_15173_17757[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14402__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14402__auto____0 = (function (){
var statearr_15175 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15175[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14402__auto__);

(statearr_15175[(1)] = (1));

return statearr_15175;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14402__auto____1 = (function (state_15105){
while(true){
var ret_value__14403__auto__ = (function (){try{while(true){
var result__14404__auto__ = switch__14401__auto__(state_15105);
if(cljs.core.keyword_identical_QMARK_(result__14404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14404__auto__;
}
break;
}
}catch (e15178){var ex__14405__auto__ = e15178;
var statearr_15179_17758 = state_15105;
(statearr_15179_17758[(2)] = ex__14405__auto__);


if(cljs.core.seq((state_15105[(4)]))){
var statearr_15181_17759 = state_15105;
(statearr_15181_17759[(1)] = cljs.core.first((state_15105[(4)])));

} else {
throw ex__14405__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17760 = state_15105;
state_15105 = G__17760;
continue;
} else {
return ret_value__14403__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14402__auto__ = function(state_15105){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14402__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14402__auto____1.call(this,state_15105);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14402__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14402__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14402__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14402__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14402__auto__;
})()
})();
var state__14556__auto__ = (function (){var statearr_15188 = f__14555__auto__();
(statearr_15188[(6)] = c__14553__auto__);

return statearr_15188;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14556__auto__);
}));

return c__14553__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). The
 *   presumption is that af will return immediately, having launched some
 *   asynchronous operation whose completion/callback will put results on
 *   the channel, then close! it. Outputs will be returned in order
 *   relative to the inputs. By default, the to channel will be closed
 *   when the from channel closes, but can be determined by the close?
 *   parameter. Will stop consuming the from channel if the to channel
 *   closes. See also pipeline, pipeline-blocking.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__15201 = arguments.length;
switch (G__15201) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__15208 = arguments.length;
switch (G__15208) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__15216 = arguments.length;
switch (G__15216) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__14553__auto___17770 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14555__auto__ = (function (){var switch__14401__auto__ = (function (state_15245){
var state_val_15246 = (state_15245[(1)]);
if((state_val_15246 === (7))){
var inst_15241 = (state_15245[(2)]);
var state_15245__$1 = state_15245;
var statearr_15247_17771 = state_15245__$1;
(statearr_15247_17771[(2)] = inst_15241);

(statearr_15247_17771[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15246 === (1))){
var state_15245__$1 = state_15245;
var statearr_15248_17772 = state_15245__$1;
(statearr_15248_17772[(2)] = null);

(statearr_15248_17772[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15246 === (4))){
var inst_15220 = (state_15245[(7)]);
var inst_15220__$1 = (state_15245[(2)]);
var inst_15221 = (inst_15220__$1 == null);
var state_15245__$1 = (function (){var statearr_15249 = state_15245;
(statearr_15249[(7)] = inst_15220__$1);

return statearr_15249;
})();
if(cljs.core.truth_(inst_15221)){
var statearr_15251_17773 = state_15245__$1;
(statearr_15251_17773[(1)] = (5));

} else {
var statearr_15252_17774 = state_15245__$1;
(statearr_15252_17774[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15246 === (13))){
var state_15245__$1 = state_15245;
var statearr_15253_17775 = state_15245__$1;
(statearr_15253_17775[(2)] = null);

(statearr_15253_17775[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15246 === (6))){
var inst_15220 = (state_15245[(7)]);
var inst_15227 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_15220) : p.call(null,inst_15220));
var state_15245__$1 = state_15245;
if(cljs.core.truth_(inst_15227)){
var statearr_15254_17776 = state_15245__$1;
(statearr_15254_17776[(1)] = (9));

} else {
var statearr_15255_17777 = state_15245__$1;
(statearr_15255_17777[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15246 === (3))){
var inst_15243 = (state_15245[(2)]);
var state_15245__$1 = state_15245;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15245__$1,inst_15243);
} else {
if((state_val_15246 === (12))){
var state_15245__$1 = state_15245;
var statearr_15257_17779 = state_15245__$1;
(statearr_15257_17779[(2)] = null);

(statearr_15257_17779[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15246 === (2))){
var state_15245__$1 = state_15245;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15245__$1,(4),ch);
} else {
if((state_val_15246 === (11))){
var inst_15220 = (state_15245[(7)]);
var inst_15232 = (state_15245[(2)]);
var state_15245__$1 = state_15245;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15245__$1,(8),inst_15232,inst_15220);
} else {
if((state_val_15246 === (9))){
var state_15245__$1 = state_15245;
var statearr_15261_17780 = state_15245__$1;
(statearr_15261_17780[(2)] = tc);

(statearr_15261_17780[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15246 === (5))){
var inst_15223 = cljs.core.async.close_BANG_(tc);
var inst_15224 = cljs.core.async.close_BANG_(fc);
var state_15245__$1 = (function (){var statearr_15264 = state_15245;
(statearr_15264[(8)] = inst_15223);

return statearr_15264;
})();
var statearr_15265_17781 = state_15245__$1;
(statearr_15265_17781[(2)] = inst_15224);

(statearr_15265_17781[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15246 === (14))){
var inst_15239 = (state_15245[(2)]);
var state_15245__$1 = state_15245;
var statearr_15269_17782 = state_15245__$1;
(statearr_15269_17782[(2)] = inst_15239);

(statearr_15269_17782[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15246 === (10))){
var state_15245__$1 = state_15245;
var statearr_15271_17784 = state_15245__$1;
(statearr_15271_17784[(2)] = fc);

(statearr_15271_17784[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15246 === (8))){
var inst_15234 = (state_15245[(2)]);
var state_15245__$1 = state_15245;
if(cljs.core.truth_(inst_15234)){
var statearr_15272_17786 = state_15245__$1;
(statearr_15272_17786[(1)] = (12));

} else {
var statearr_15273_17787 = state_15245__$1;
(statearr_15273_17787[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__14402__auto__ = null;
var cljs$core$async$state_machine__14402__auto____0 = (function (){
var statearr_15276 = [null,null,null,null,null,null,null,null,null];
(statearr_15276[(0)] = cljs$core$async$state_machine__14402__auto__);

(statearr_15276[(1)] = (1));

return statearr_15276;
});
var cljs$core$async$state_machine__14402__auto____1 = (function (state_15245){
while(true){
var ret_value__14403__auto__ = (function (){try{while(true){
var result__14404__auto__ = switch__14401__auto__(state_15245);
if(cljs.core.keyword_identical_QMARK_(result__14404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14404__auto__;
}
break;
}
}catch (e15277){var ex__14405__auto__ = e15277;
var statearr_15278_17790 = state_15245;
(statearr_15278_17790[(2)] = ex__14405__auto__);


if(cljs.core.seq((state_15245[(4)]))){
var statearr_15279_17791 = state_15245;
(statearr_15279_17791[(1)] = cljs.core.first((state_15245[(4)])));

} else {
throw ex__14405__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17795 = state_15245;
state_15245 = G__17795;
continue;
} else {
return ret_value__14403__auto__;
}
break;
}
});
cljs$core$async$state_machine__14402__auto__ = function(state_15245){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14402__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14402__auto____1.call(this,state_15245);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14402__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14402__auto____0;
cljs$core$async$state_machine__14402__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14402__auto____1;
return cljs$core$async$state_machine__14402__auto__;
})()
})();
var state__14556__auto__ = (function (){var statearr_15285 = f__14555__auto__();
(statearr_15285[(6)] = c__14553__auto___17770);

return statearr_15285;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14556__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__14553__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14555__auto__ = (function (){var switch__14401__auto__ = (function (state_15307){
var state_val_15308 = (state_15307[(1)]);
if((state_val_15308 === (7))){
var inst_15303 = (state_15307[(2)]);
var state_15307__$1 = state_15307;
var statearr_15335_17797 = state_15307__$1;
(statearr_15335_17797[(2)] = inst_15303);

(statearr_15335_17797[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15308 === (1))){
var inst_15286 = init;
var inst_15287 = inst_15286;
var state_15307__$1 = (function (){var statearr_15336 = state_15307;
(statearr_15336[(7)] = inst_15287);

return statearr_15336;
})();
var statearr_15337_17800 = state_15307__$1;
(statearr_15337_17800[(2)] = null);

(statearr_15337_17800[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15308 === (4))){
var inst_15290 = (state_15307[(8)]);
var inst_15290__$1 = (state_15307[(2)]);
var inst_15291 = (inst_15290__$1 == null);
var state_15307__$1 = (function (){var statearr_15339 = state_15307;
(statearr_15339[(8)] = inst_15290__$1);

return statearr_15339;
})();
if(cljs.core.truth_(inst_15291)){
var statearr_15341_17801 = state_15307__$1;
(statearr_15341_17801[(1)] = (5));

} else {
var statearr_15347_17802 = state_15307__$1;
(statearr_15347_17802[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15308 === (6))){
var inst_15290 = (state_15307[(8)]);
var inst_15294 = (state_15307[(9)]);
var inst_15287 = (state_15307[(7)]);
var inst_15294__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_15287,inst_15290) : f.call(null,inst_15287,inst_15290));
var inst_15295 = cljs.core.reduced_QMARK_(inst_15294__$1);
var state_15307__$1 = (function (){var statearr_15349 = state_15307;
(statearr_15349[(9)] = inst_15294__$1);

return statearr_15349;
})();
if(inst_15295){
var statearr_15350_17803 = state_15307__$1;
(statearr_15350_17803[(1)] = (8));

} else {
var statearr_15352_17804 = state_15307__$1;
(statearr_15352_17804[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15308 === (3))){
var inst_15305 = (state_15307[(2)]);
var state_15307__$1 = state_15307;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15307__$1,inst_15305);
} else {
if((state_val_15308 === (2))){
var state_15307__$1 = state_15307;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15307__$1,(4),ch);
} else {
if((state_val_15308 === (9))){
var inst_15294 = (state_15307[(9)]);
var inst_15287 = inst_15294;
var state_15307__$1 = (function (){var statearr_15357 = state_15307;
(statearr_15357[(7)] = inst_15287);

return statearr_15357;
})();
var statearr_15360_17805 = state_15307__$1;
(statearr_15360_17805[(2)] = null);

(statearr_15360_17805[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15308 === (5))){
var inst_15287 = (state_15307[(7)]);
var state_15307__$1 = state_15307;
var statearr_15361_17807 = state_15307__$1;
(statearr_15361_17807[(2)] = inst_15287);

(statearr_15361_17807[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15308 === (10))){
var inst_15301 = (state_15307[(2)]);
var state_15307__$1 = state_15307;
var statearr_15362_17809 = state_15307__$1;
(statearr_15362_17809[(2)] = inst_15301);

(statearr_15362_17809[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15308 === (8))){
var inst_15294 = (state_15307[(9)]);
var inst_15297 = cljs.core.deref(inst_15294);
var state_15307__$1 = state_15307;
var statearr_15363_17810 = state_15307__$1;
(statearr_15363_17810[(2)] = inst_15297);

(statearr_15363_17810[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__14402__auto__ = null;
var cljs$core$async$reduce_$_state_machine__14402__auto____0 = (function (){
var statearr_15366 = [null,null,null,null,null,null,null,null,null,null];
(statearr_15366[(0)] = cljs$core$async$reduce_$_state_machine__14402__auto__);

(statearr_15366[(1)] = (1));

return statearr_15366;
});
var cljs$core$async$reduce_$_state_machine__14402__auto____1 = (function (state_15307){
while(true){
var ret_value__14403__auto__ = (function (){try{while(true){
var result__14404__auto__ = switch__14401__auto__(state_15307);
if(cljs.core.keyword_identical_QMARK_(result__14404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14404__auto__;
}
break;
}
}catch (e15373){var ex__14405__auto__ = e15373;
var statearr_15374_17821 = state_15307;
(statearr_15374_17821[(2)] = ex__14405__auto__);


if(cljs.core.seq((state_15307[(4)]))){
var statearr_15381_17822 = state_15307;
(statearr_15381_17822[(1)] = cljs.core.first((state_15307[(4)])));

} else {
throw ex__14405__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17824 = state_15307;
state_15307 = G__17824;
continue;
} else {
return ret_value__14403__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__14402__auto__ = function(state_15307){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__14402__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__14402__auto____1.call(this,state_15307);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__14402__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__14402__auto____0;
cljs$core$async$reduce_$_state_machine__14402__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__14402__auto____1;
return cljs$core$async$reduce_$_state_machine__14402__auto__;
})()
})();
var state__14556__auto__ = (function (){var statearr_15398 = f__14555__auto__();
(statearr_15398[(6)] = c__14553__auto__);

return statearr_15398;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14556__auto__);
}));

return c__14553__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__14553__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14555__auto__ = (function (){var switch__14401__auto__ = (function (state_15409){
var state_val_15414 = (state_15409[(1)]);
if((state_val_15414 === (1))){
var inst_15403 = cljs.core.async.reduce(f__$1,init,ch);
var state_15409__$1 = state_15409;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15409__$1,(2),inst_15403);
} else {
if((state_val_15414 === (2))){
var inst_15405 = (state_15409[(2)]);
var inst_15407 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_15405) : f__$1.call(null,inst_15405));
var state_15409__$1 = state_15409;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15409__$1,inst_15407);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__14402__auto__ = null;
var cljs$core$async$transduce_$_state_machine__14402__auto____0 = (function (){
var statearr_15440 = [null,null,null,null,null,null,null];
(statearr_15440[(0)] = cljs$core$async$transduce_$_state_machine__14402__auto__);

(statearr_15440[(1)] = (1));

return statearr_15440;
});
var cljs$core$async$transduce_$_state_machine__14402__auto____1 = (function (state_15409){
while(true){
var ret_value__14403__auto__ = (function (){try{while(true){
var result__14404__auto__ = switch__14401__auto__(state_15409);
if(cljs.core.keyword_identical_QMARK_(result__14404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14404__auto__;
}
break;
}
}catch (e15451){var ex__14405__auto__ = e15451;
var statearr_15452_17830 = state_15409;
(statearr_15452_17830[(2)] = ex__14405__auto__);


if(cljs.core.seq((state_15409[(4)]))){
var statearr_15453_17831 = state_15409;
(statearr_15453_17831[(1)] = cljs.core.first((state_15409[(4)])));

} else {
throw ex__14405__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17832 = state_15409;
state_15409 = G__17832;
continue;
} else {
return ret_value__14403__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__14402__auto__ = function(state_15409){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__14402__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__14402__auto____1.call(this,state_15409);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__14402__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__14402__auto____0;
cljs$core$async$transduce_$_state_machine__14402__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__14402__auto____1;
return cljs$core$async$transduce_$_state_machine__14402__auto__;
})()
})();
var state__14556__auto__ = (function (){var statearr_15456 = f__14555__auto__();
(statearr_15456[(6)] = c__14553__auto__);

return statearr_15456;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14556__auto__);
}));

return c__14553__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__15458 = arguments.length;
switch (G__15458) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__14553__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14555__auto__ = (function (){var switch__14401__auto__ = (function (state_15488){
var state_val_15489 = (state_15488[(1)]);
if((state_val_15489 === (7))){
var inst_15469 = (state_15488[(2)]);
var state_15488__$1 = state_15488;
var statearr_15494_17836 = state_15488__$1;
(statearr_15494_17836[(2)] = inst_15469);

(statearr_15494_17836[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15489 === (1))){
var inst_15462 = cljs.core.seq(coll);
var inst_15463 = inst_15462;
var state_15488__$1 = (function (){var statearr_15502 = state_15488;
(statearr_15502[(7)] = inst_15463);

return statearr_15502;
})();
var statearr_15507_17837 = state_15488__$1;
(statearr_15507_17837[(2)] = null);

(statearr_15507_17837[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15489 === (4))){
var inst_15463 = (state_15488[(7)]);
var inst_15467 = cljs.core.first(inst_15463);
var state_15488__$1 = state_15488;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15488__$1,(7),ch,inst_15467);
} else {
if((state_val_15489 === (13))){
var inst_15482 = (state_15488[(2)]);
var state_15488__$1 = state_15488;
var statearr_15516_17841 = state_15488__$1;
(statearr_15516_17841[(2)] = inst_15482);

(statearr_15516_17841[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15489 === (6))){
var inst_15472 = (state_15488[(2)]);
var state_15488__$1 = state_15488;
if(cljs.core.truth_(inst_15472)){
var statearr_15529_17842 = state_15488__$1;
(statearr_15529_17842[(1)] = (8));

} else {
var statearr_15530_17843 = state_15488__$1;
(statearr_15530_17843[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15489 === (3))){
var inst_15486 = (state_15488[(2)]);
var state_15488__$1 = state_15488;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15488__$1,inst_15486);
} else {
if((state_val_15489 === (12))){
var state_15488__$1 = state_15488;
var statearr_15533_17848 = state_15488__$1;
(statearr_15533_17848[(2)] = null);

(statearr_15533_17848[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15489 === (2))){
var inst_15463 = (state_15488[(7)]);
var state_15488__$1 = state_15488;
if(cljs.core.truth_(inst_15463)){
var statearr_15535_17850 = state_15488__$1;
(statearr_15535_17850[(1)] = (4));

} else {
var statearr_15536_17851 = state_15488__$1;
(statearr_15536_17851[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15489 === (11))){
var inst_15479 = cljs.core.async.close_BANG_(ch);
var state_15488__$1 = state_15488;
var statearr_15537_17852 = state_15488__$1;
(statearr_15537_17852[(2)] = inst_15479);

(statearr_15537_17852[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15489 === (9))){
var state_15488__$1 = state_15488;
if(cljs.core.truth_(close_QMARK_)){
var statearr_15538_17853 = state_15488__$1;
(statearr_15538_17853[(1)] = (11));

} else {
var statearr_15539_17854 = state_15488__$1;
(statearr_15539_17854[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15489 === (5))){
var inst_15463 = (state_15488[(7)]);
var state_15488__$1 = state_15488;
var statearr_15540_17855 = state_15488__$1;
(statearr_15540_17855[(2)] = inst_15463);

(statearr_15540_17855[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15489 === (10))){
var inst_15484 = (state_15488[(2)]);
var state_15488__$1 = state_15488;
var statearr_15541_17856 = state_15488__$1;
(statearr_15541_17856[(2)] = inst_15484);

(statearr_15541_17856[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15489 === (8))){
var inst_15463 = (state_15488[(7)]);
var inst_15475 = cljs.core.next(inst_15463);
var inst_15463__$1 = inst_15475;
var state_15488__$1 = (function (){var statearr_15542 = state_15488;
(statearr_15542[(7)] = inst_15463__$1);

return statearr_15542;
})();
var statearr_15543_17857 = state_15488__$1;
(statearr_15543_17857[(2)] = null);

(statearr_15543_17857[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__14402__auto__ = null;
var cljs$core$async$state_machine__14402__auto____0 = (function (){
var statearr_15546 = [null,null,null,null,null,null,null,null];
(statearr_15546[(0)] = cljs$core$async$state_machine__14402__auto__);

(statearr_15546[(1)] = (1));

return statearr_15546;
});
var cljs$core$async$state_machine__14402__auto____1 = (function (state_15488){
while(true){
var ret_value__14403__auto__ = (function (){try{while(true){
var result__14404__auto__ = switch__14401__auto__(state_15488);
if(cljs.core.keyword_identical_QMARK_(result__14404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14404__auto__;
}
break;
}
}catch (e15547){var ex__14405__auto__ = e15547;
var statearr_15548_17883 = state_15488;
(statearr_15548_17883[(2)] = ex__14405__auto__);


if(cljs.core.seq((state_15488[(4)]))){
var statearr_15549_17884 = state_15488;
(statearr_15549_17884[(1)] = cljs.core.first((state_15488[(4)])));

} else {
throw ex__14405__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17885 = state_15488;
state_15488 = G__17885;
continue;
} else {
return ret_value__14403__auto__;
}
break;
}
});
cljs$core$async$state_machine__14402__auto__ = function(state_15488){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14402__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14402__auto____1.call(this,state_15488);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14402__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14402__auto____0;
cljs$core$async$state_machine__14402__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14402__auto____1;
return cljs$core$async$state_machine__14402__auto__;
})()
})();
var state__14556__auto__ = (function (){var statearr_15550 = f__14555__auto__();
(statearr_15550[(6)] = c__14553__auto__);

return statearr_15550;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14556__auto__);
}));

return c__14553__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__15558 = arguments.length;
switch (G__15558) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_17887 = (function (_){
var x__5350__auto__ = (((_ == null))?null:_);
var m__5351__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5351__auto__.call(null,_));
} else {
var m__5349__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5349__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_17887(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_17888 = (function (m,ch,close_QMARK_){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5351__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__5349__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5349__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_17888(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_17892 = (function (m,ch){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5351__auto__.call(null,m,ch));
} else {
var m__5349__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5349__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_17892(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_17895 = (function (m){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5351__auto__.call(null,m));
} else {
var m__5349__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5349__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_17895(m);
}
});


/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15589 = (function (ch,cs,meta15590){
this.ch = ch;
this.cs = cs;
this.meta15590 = meta15590;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async15589.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15591,meta15590__$1){
var self__ = this;
var _15591__$1 = this;
return (new cljs.core.async.t_cljs$core$async15589(self__.ch,self__.cs,meta15590__$1));
}));

(cljs.core.async.t_cljs$core$async15589.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15591){
var self__ = this;
var _15591__$1 = this;
return self__.meta15590;
}));

(cljs.core.async.t_cljs$core$async15589.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15589.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async15589.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15589.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async15589.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async15589.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async15589.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta15590","meta15590",-1230610581,null)], null);
}));

(cljs.core.async.t_cljs$core$async15589.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async15589.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15589");

(cljs.core.async.t_cljs$core$async15589.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async15589");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async15589.
 */
cljs.core.async.__GT_t_cljs$core$async15589 = (function cljs$core$async$__GT_t_cljs$core$async15589(ch,cs,meta15590){
return (new cljs.core.async.t_cljs$core$async15589(ch,cs,meta15590));
});


/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (new cljs.core.async.t_cljs$core$async15589(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__14553__auto___17902 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14555__auto__ = (function (){var switch__14401__auto__ = (function (state_15730){
var state_val_15731 = (state_15730[(1)]);
if((state_val_15731 === (7))){
var inst_15726 = (state_15730[(2)]);
var state_15730__$1 = state_15730;
var statearr_15740_17904 = state_15730__$1;
(statearr_15740_17904[(2)] = inst_15726);

(statearr_15740_17904[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (20))){
var inst_15631 = (state_15730[(7)]);
var inst_15643 = cljs.core.first(inst_15631);
var inst_15644 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15643,(0),null);
var inst_15645 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15643,(1),null);
var state_15730__$1 = (function (){var statearr_15745 = state_15730;
(statearr_15745[(8)] = inst_15644);

return statearr_15745;
})();
if(cljs.core.truth_(inst_15645)){
var statearr_15746_17906 = state_15730__$1;
(statearr_15746_17906[(1)] = (22));

} else {
var statearr_15747_17908 = state_15730__$1;
(statearr_15747_17908[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (27))){
var inst_15675 = (state_15730[(9)]);
var inst_15673 = (state_15730[(10)]);
var inst_15680 = (state_15730[(11)]);
var inst_15598 = (state_15730[(12)]);
var inst_15680__$1 = cljs.core._nth(inst_15673,inst_15675);
var inst_15681 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_15680__$1,inst_15598,done);
var state_15730__$1 = (function (){var statearr_15750 = state_15730;
(statearr_15750[(11)] = inst_15680__$1);

return statearr_15750;
})();
if(cljs.core.truth_(inst_15681)){
var statearr_15751_17909 = state_15730__$1;
(statearr_15751_17909[(1)] = (30));

} else {
var statearr_15752_17910 = state_15730__$1;
(statearr_15752_17910[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (1))){
var state_15730__$1 = state_15730;
var statearr_15753_17911 = state_15730__$1;
(statearr_15753_17911[(2)] = null);

(statearr_15753_17911[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (24))){
var inst_15631 = (state_15730[(7)]);
var inst_15650 = (state_15730[(2)]);
var inst_15651 = cljs.core.next(inst_15631);
var inst_15608 = inst_15651;
var inst_15609 = null;
var inst_15610 = (0);
var inst_15611 = (0);
var state_15730__$1 = (function (){var statearr_15755 = state_15730;
(statearr_15755[(13)] = inst_15610);

(statearr_15755[(14)] = inst_15650);

(statearr_15755[(15)] = inst_15609);

(statearr_15755[(16)] = inst_15608);

(statearr_15755[(17)] = inst_15611);

return statearr_15755;
})();
var statearr_15758_17912 = state_15730__$1;
(statearr_15758_17912[(2)] = null);

(statearr_15758_17912[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (39))){
var state_15730__$1 = state_15730;
var statearr_15764_17913 = state_15730__$1;
(statearr_15764_17913[(2)] = null);

(statearr_15764_17913[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (4))){
var inst_15598 = (state_15730[(12)]);
var inst_15598__$1 = (state_15730[(2)]);
var inst_15599 = (inst_15598__$1 == null);
var state_15730__$1 = (function (){var statearr_15765 = state_15730;
(statearr_15765[(12)] = inst_15598__$1);

return statearr_15765;
})();
if(cljs.core.truth_(inst_15599)){
var statearr_15766_17914 = state_15730__$1;
(statearr_15766_17914[(1)] = (5));

} else {
var statearr_15767_17915 = state_15730__$1;
(statearr_15767_17915[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (15))){
var inst_15610 = (state_15730[(13)]);
var inst_15609 = (state_15730[(15)]);
var inst_15608 = (state_15730[(16)]);
var inst_15611 = (state_15730[(17)]);
var inst_15627 = (state_15730[(2)]);
var inst_15628 = (inst_15611 + (1));
var tmp15761 = inst_15610;
var tmp15762 = inst_15609;
var tmp15763 = inst_15608;
var inst_15608__$1 = tmp15763;
var inst_15609__$1 = tmp15762;
var inst_15610__$1 = tmp15761;
var inst_15611__$1 = inst_15628;
var state_15730__$1 = (function (){var statearr_15771 = state_15730;
(statearr_15771[(13)] = inst_15610__$1);

(statearr_15771[(15)] = inst_15609__$1);

(statearr_15771[(18)] = inst_15627);

(statearr_15771[(16)] = inst_15608__$1);

(statearr_15771[(17)] = inst_15611__$1);

return statearr_15771;
})();
var statearr_15772_17916 = state_15730__$1;
(statearr_15772_17916[(2)] = null);

(statearr_15772_17916[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (21))){
var inst_15654 = (state_15730[(2)]);
var state_15730__$1 = state_15730;
var statearr_15776_17917 = state_15730__$1;
(statearr_15776_17917[(2)] = inst_15654);

(statearr_15776_17917[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (31))){
var inst_15680 = (state_15730[(11)]);
var inst_15684 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_15680);
var state_15730__$1 = state_15730;
var statearr_15777_17918 = state_15730__$1;
(statearr_15777_17918[(2)] = inst_15684);

(statearr_15777_17918[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (32))){
var inst_15675 = (state_15730[(9)]);
var inst_15673 = (state_15730[(10)]);
var inst_15674 = (state_15730[(19)]);
var inst_15672 = (state_15730[(20)]);
var inst_15686 = (state_15730[(2)]);
var inst_15687 = (inst_15675 + (1));
var tmp15773 = inst_15673;
var tmp15774 = inst_15674;
var tmp15775 = inst_15672;
var inst_15672__$1 = tmp15775;
var inst_15673__$1 = tmp15773;
var inst_15674__$1 = tmp15774;
var inst_15675__$1 = inst_15687;
var state_15730__$1 = (function (){var statearr_15783 = state_15730;
(statearr_15783[(9)] = inst_15675__$1);

(statearr_15783[(10)] = inst_15673__$1);

(statearr_15783[(19)] = inst_15674__$1);

(statearr_15783[(21)] = inst_15686);

(statearr_15783[(20)] = inst_15672__$1);

return statearr_15783;
})();
var statearr_15789_17919 = state_15730__$1;
(statearr_15789_17919[(2)] = null);

(statearr_15789_17919[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (40))){
var inst_15699 = (state_15730[(22)]);
var inst_15703 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_15699);
var state_15730__$1 = state_15730;
var statearr_15792_17920 = state_15730__$1;
(statearr_15792_17920[(2)] = inst_15703);

(statearr_15792_17920[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (33))){
var inst_15690 = (state_15730[(23)]);
var inst_15692 = cljs.core.chunked_seq_QMARK_(inst_15690);
var state_15730__$1 = state_15730;
if(inst_15692){
var statearr_15795_17921 = state_15730__$1;
(statearr_15795_17921[(1)] = (36));

} else {
var statearr_15798_17922 = state_15730__$1;
(statearr_15798_17922[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (13))){
var inst_15621 = (state_15730[(24)]);
var inst_15624 = cljs.core.async.close_BANG_(inst_15621);
var state_15730__$1 = state_15730;
var statearr_15799_17923 = state_15730__$1;
(statearr_15799_17923[(2)] = inst_15624);

(statearr_15799_17923[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (22))){
var inst_15644 = (state_15730[(8)]);
var inst_15647 = cljs.core.async.close_BANG_(inst_15644);
var state_15730__$1 = state_15730;
var statearr_15802_17924 = state_15730__$1;
(statearr_15802_17924[(2)] = inst_15647);

(statearr_15802_17924[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (36))){
var inst_15690 = (state_15730[(23)]);
var inst_15694 = cljs.core.chunk_first(inst_15690);
var inst_15695 = cljs.core.chunk_rest(inst_15690);
var inst_15696 = cljs.core.count(inst_15694);
var inst_15672 = inst_15695;
var inst_15673 = inst_15694;
var inst_15674 = inst_15696;
var inst_15675 = (0);
var state_15730__$1 = (function (){var statearr_15807 = state_15730;
(statearr_15807[(9)] = inst_15675);

(statearr_15807[(10)] = inst_15673);

(statearr_15807[(19)] = inst_15674);

(statearr_15807[(20)] = inst_15672);

return statearr_15807;
})();
var statearr_15810_17925 = state_15730__$1;
(statearr_15810_17925[(2)] = null);

(statearr_15810_17925[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (41))){
var inst_15690 = (state_15730[(23)]);
var inst_15705 = (state_15730[(2)]);
var inst_15706 = cljs.core.next(inst_15690);
var inst_15672 = inst_15706;
var inst_15673 = null;
var inst_15674 = (0);
var inst_15675 = (0);
var state_15730__$1 = (function (){var statearr_15816 = state_15730;
(statearr_15816[(9)] = inst_15675);

(statearr_15816[(10)] = inst_15673);

(statearr_15816[(19)] = inst_15674);

(statearr_15816[(20)] = inst_15672);

(statearr_15816[(25)] = inst_15705);

return statearr_15816;
})();
var statearr_15817_17926 = state_15730__$1;
(statearr_15817_17926[(2)] = null);

(statearr_15817_17926[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (43))){
var state_15730__$1 = state_15730;
var statearr_15819_17927 = state_15730__$1;
(statearr_15819_17927[(2)] = null);

(statearr_15819_17927[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (29))){
var inst_15714 = (state_15730[(2)]);
var state_15730__$1 = state_15730;
var statearr_15820_17928 = state_15730__$1;
(statearr_15820_17928[(2)] = inst_15714);

(statearr_15820_17928[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (44))){
var inst_15723 = (state_15730[(2)]);
var state_15730__$1 = (function (){var statearr_15823 = state_15730;
(statearr_15823[(26)] = inst_15723);

return statearr_15823;
})();
var statearr_15824_17933 = state_15730__$1;
(statearr_15824_17933[(2)] = null);

(statearr_15824_17933[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (6))){
var inst_15664 = (state_15730[(27)]);
var inst_15663 = cljs.core.deref(cs);
var inst_15664__$1 = cljs.core.keys(inst_15663);
var inst_15665 = cljs.core.count(inst_15664__$1);
var inst_15666 = cljs.core.reset_BANG_(dctr,inst_15665);
var inst_15671 = cljs.core.seq(inst_15664__$1);
var inst_15672 = inst_15671;
var inst_15673 = null;
var inst_15674 = (0);
var inst_15675 = (0);
var state_15730__$1 = (function (){var statearr_15825 = state_15730;
(statearr_15825[(9)] = inst_15675);

(statearr_15825[(10)] = inst_15673);

(statearr_15825[(27)] = inst_15664__$1);

(statearr_15825[(19)] = inst_15674);

(statearr_15825[(28)] = inst_15666);

(statearr_15825[(20)] = inst_15672);

return statearr_15825;
})();
var statearr_15827_17934 = state_15730__$1;
(statearr_15827_17934[(2)] = null);

(statearr_15827_17934[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (28))){
var inst_15690 = (state_15730[(23)]);
var inst_15672 = (state_15730[(20)]);
var inst_15690__$1 = cljs.core.seq(inst_15672);
var state_15730__$1 = (function (){var statearr_15829 = state_15730;
(statearr_15829[(23)] = inst_15690__$1);

return statearr_15829;
})();
if(inst_15690__$1){
var statearr_15830_17935 = state_15730__$1;
(statearr_15830_17935[(1)] = (33));

} else {
var statearr_15831_17936 = state_15730__$1;
(statearr_15831_17936[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (25))){
var inst_15675 = (state_15730[(9)]);
var inst_15674 = (state_15730[(19)]);
var inst_15677 = (inst_15675 < inst_15674);
var inst_15678 = inst_15677;
var state_15730__$1 = state_15730;
if(cljs.core.truth_(inst_15678)){
var statearr_15832_17937 = state_15730__$1;
(statearr_15832_17937[(1)] = (27));

} else {
var statearr_15833_17938 = state_15730__$1;
(statearr_15833_17938[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (34))){
var state_15730__$1 = state_15730;
var statearr_15836_17939 = state_15730__$1;
(statearr_15836_17939[(2)] = null);

(statearr_15836_17939[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (17))){
var state_15730__$1 = state_15730;
var statearr_15837_17940 = state_15730__$1;
(statearr_15837_17940[(2)] = null);

(statearr_15837_17940[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (3))){
var inst_15728 = (state_15730[(2)]);
var state_15730__$1 = state_15730;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15730__$1,inst_15728);
} else {
if((state_val_15731 === (12))){
var inst_15659 = (state_15730[(2)]);
var state_15730__$1 = state_15730;
var statearr_15839_17941 = state_15730__$1;
(statearr_15839_17941[(2)] = inst_15659);

(statearr_15839_17941[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (2))){
var state_15730__$1 = state_15730;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15730__$1,(4),ch);
} else {
if((state_val_15731 === (23))){
var state_15730__$1 = state_15730;
var statearr_15840_17942 = state_15730__$1;
(statearr_15840_17942[(2)] = null);

(statearr_15840_17942[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (35))){
var inst_15712 = (state_15730[(2)]);
var state_15730__$1 = state_15730;
var statearr_15842_17943 = state_15730__$1;
(statearr_15842_17943[(2)] = inst_15712);

(statearr_15842_17943[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (19))){
var inst_15631 = (state_15730[(7)]);
var inst_15635 = cljs.core.chunk_first(inst_15631);
var inst_15636 = cljs.core.chunk_rest(inst_15631);
var inst_15637 = cljs.core.count(inst_15635);
var inst_15608 = inst_15636;
var inst_15609 = inst_15635;
var inst_15610 = inst_15637;
var inst_15611 = (0);
var state_15730__$1 = (function (){var statearr_15843 = state_15730;
(statearr_15843[(13)] = inst_15610);

(statearr_15843[(15)] = inst_15609);

(statearr_15843[(16)] = inst_15608);

(statearr_15843[(17)] = inst_15611);

return statearr_15843;
})();
var statearr_15844_17944 = state_15730__$1;
(statearr_15844_17944[(2)] = null);

(statearr_15844_17944[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (11))){
var inst_15631 = (state_15730[(7)]);
var inst_15608 = (state_15730[(16)]);
var inst_15631__$1 = cljs.core.seq(inst_15608);
var state_15730__$1 = (function (){var statearr_15847 = state_15730;
(statearr_15847[(7)] = inst_15631__$1);

return statearr_15847;
})();
if(inst_15631__$1){
var statearr_15848_17945 = state_15730__$1;
(statearr_15848_17945[(1)] = (16));

} else {
var statearr_15849_17949 = state_15730__$1;
(statearr_15849_17949[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (9))){
var inst_15661 = (state_15730[(2)]);
var state_15730__$1 = state_15730;
var statearr_15850_17950 = state_15730__$1;
(statearr_15850_17950[(2)] = inst_15661);

(statearr_15850_17950[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (5))){
var inst_15606 = cljs.core.deref(cs);
var inst_15607 = cljs.core.seq(inst_15606);
var inst_15608 = inst_15607;
var inst_15609 = null;
var inst_15610 = (0);
var inst_15611 = (0);
var state_15730__$1 = (function (){var statearr_15851 = state_15730;
(statearr_15851[(13)] = inst_15610);

(statearr_15851[(15)] = inst_15609);

(statearr_15851[(16)] = inst_15608);

(statearr_15851[(17)] = inst_15611);

return statearr_15851;
})();
var statearr_15852_17951 = state_15730__$1;
(statearr_15852_17951[(2)] = null);

(statearr_15852_17951[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (14))){
var state_15730__$1 = state_15730;
var statearr_15853_17952 = state_15730__$1;
(statearr_15853_17952[(2)] = null);

(statearr_15853_17952[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (45))){
var inst_15720 = (state_15730[(2)]);
var state_15730__$1 = state_15730;
var statearr_15854_17953 = state_15730__$1;
(statearr_15854_17953[(2)] = inst_15720);

(statearr_15854_17953[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (26))){
var inst_15664 = (state_15730[(27)]);
var inst_15716 = (state_15730[(2)]);
var inst_15717 = cljs.core.seq(inst_15664);
var state_15730__$1 = (function (){var statearr_15855 = state_15730;
(statearr_15855[(29)] = inst_15716);

return statearr_15855;
})();
if(inst_15717){
var statearr_15856_17954 = state_15730__$1;
(statearr_15856_17954[(1)] = (42));

} else {
var statearr_15857_17955 = state_15730__$1;
(statearr_15857_17955[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (16))){
var inst_15631 = (state_15730[(7)]);
var inst_15633 = cljs.core.chunked_seq_QMARK_(inst_15631);
var state_15730__$1 = state_15730;
if(inst_15633){
var statearr_15858_17956 = state_15730__$1;
(statearr_15858_17956[(1)] = (19));

} else {
var statearr_15859_17957 = state_15730__$1;
(statearr_15859_17957[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (38))){
var inst_15709 = (state_15730[(2)]);
var state_15730__$1 = state_15730;
var statearr_15860_17958 = state_15730__$1;
(statearr_15860_17958[(2)] = inst_15709);

(statearr_15860_17958[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (30))){
var state_15730__$1 = state_15730;
var statearr_15861_17959 = state_15730__$1;
(statearr_15861_17959[(2)] = null);

(statearr_15861_17959[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (10))){
var inst_15609 = (state_15730[(15)]);
var inst_15611 = (state_15730[(17)]);
var inst_15620 = cljs.core._nth(inst_15609,inst_15611);
var inst_15621 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15620,(0),null);
var inst_15622 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15620,(1),null);
var state_15730__$1 = (function (){var statearr_15862 = state_15730;
(statearr_15862[(24)] = inst_15621);

return statearr_15862;
})();
if(cljs.core.truth_(inst_15622)){
var statearr_15863_17960 = state_15730__$1;
(statearr_15863_17960[(1)] = (13));

} else {
var statearr_15864_17961 = state_15730__$1;
(statearr_15864_17961[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (18))){
var inst_15657 = (state_15730[(2)]);
var state_15730__$1 = state_15730;
var statearr_15865_17962 = state_15730__$1;
(statearr_15865_17962[(2)] = inst_15657);

(statearr_15865_17962[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (42))){
var state_15730__$1 = state_15730;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15730__$1,(45),dchan);
} else {
if((state_val_15731 === (37))){
var inst_15699 = (state_15730[(22)]);
var inst_15598 = (state_15730[(12)]);
var inst_15690 = (state_15730[(23)]);
var inst_15699__$1 = cljs.core.first(inst_15690);
var inst_15700 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_15699__$1,inst_15598,done);
var state_15730__$1 = (function (){var statearr_15872 = state_15730;
(statearr_15872[(22)] = inst_15699__$1);

return statearr_15872;
})();
if(cljs.core.truth_(inst_15700)){
var statearr_15873_17963 = state_15730__$1;
(statearr_15873_17963[(1)] = (39));

} else {
var statearr_15874_17964 = state_15730__$1;
(statearr_15874_17964[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15731 === (8))){
var inst_15610 = (state_15730[(13)]);
var inst_15611 = (state_15730[(17)]);
var inst_15614 = (inst_15611 < inst_15610);
var inst_15615 = inst_15614;
var state_15730__$1 = state_15730;
if(cljs.core.truth_(inst_15615)){
var statearr_15876_17968 = state_15730__$1;
(statearr_15876_17968[(1)] = (10));

} else {
var statearr_15877_17969 = state_15730__$1;
(statearr_15877_17969[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__14402__auto__ = null;
var cljs$core$async$mult_$_state_machine__14402__auto____0 = (function (){
var statearr_15878 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15878[(0)] = cljs$core$async$mult_$_state_machine__14402__auto__);

(statearr_15878[(1)] = (1));

return statearr_15878;
});
var cljs$core$async$mult_$_state_machine__14402__auto____1 = (function (state_15730){
while(true){
var ret_value__14403__auto__ = (function (){try{while(true){
var result__14404__auto__ = switch__14401__auto__(state_15730);
if(cljs.core.keyword_identical_QMARK_(result__14404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14404__auto__;
}
break;
}
}catch (e15880){var ex__14405__auto__ = e15880;
var statearr_15881_17970 = state_15730;
(statearr_15881_17970[(2)] = ex__14405__auto__);


if(cljs.core.seq((state_15730[(4)]))){
var statearr_15882_17971 = state_15730;
(statearr_15882_17971[(1)] = cljs.core.first((state_15730[(4)])));

} else {
throw ex__14405__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17972 = state_15730;
state_15730 = G__17972;
continue;
} else {
return ret_value__14403__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__14402__auto__ = function(state_15730){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__14402__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__14402__auto____1.call(this,state_15730);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__14402__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__14402__auto____0;
cljs$core$async$mult_$_state_machine__14402__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__14402__auto____1;
return cljs$core$async$mult_$_state_machine__14402__auto__;
})()
})();
var state__14556__auto__ = (function (){var statearr_15889 = f__14555__auto__();
(statearr_15889[(6)] = c__14553__auto___17902);

return statearr_15889;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14556__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__15891 = arguments.length;
switch (G__15891) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_17974 = (function (m,ch){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5351__auto__.call(null,m,ch));
} else {
var m__5349__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5349__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_17974(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_17975 = (function (m,ch){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5351__auto__.call(null,m,ch));
} else {
var m__5349__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5349__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_17975(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_17979 = (function (m){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5351__auto__.call(null,m));
} else {
var m__5349__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5349__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_17979(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_17980 = (function (m,state_map){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5351__auto__.call(null,m,state_map));
} else {
var m__5349__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5349__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_17980(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_17981 = (function (m,mode){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5351__auto__.call(null,m,mode));
} else {
var m__5349__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5349__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_17981(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5732__auto__ = [];
var len__5726__auto___17982 = arguments.length;
var i__5727__auto___17983 = (0);
while(true){
if((i__5727__auto___17983 < len__5726__auto___17982)){
args__5732__auto__.push((arguments[i__5727__auto___17983]));

var G__17984 = (i__5727__auto___17983 + (1));
i__5727__auto___17983 = G__17984;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((3) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5733__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__15912){
var map__15914 = p__15912;
var map__15914__$1 = cljs.core.__destructure_map(map__15914);
var opts = map__15914__$1;
var statearr_15915_17987 = state;
(statearr_15915_17987[(1)] = cont_block);


var temp__5804__auto__ = cljs.core.async.do_alts((function (val){
var statearr_15916_17988 = state;
(statearr_15916_17988[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5804__auto__)){
var cb = temp__5804__auto__;
var statearr_15917_17989 = state;
(statearr_15917_17989[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq15903){
var G__15904 = cljs.core.first(seq15903);
var seq15903__$1 = cljs.core.next(seq15903);
var G__15905 = cljs.core.first(seq15903__$1);
var seq15903__$2 = cljs.core.next(seq15903__$1);
var G__15906 = cljs.core.first(seq15903__$2);
var seq15903__$3 = cljs.core.next(seq15903__$2);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15904,G__15905,G__15906,seq15903__$3);
}));


/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15926 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta15927){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta15927 = meta15927;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async15926.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15928,meta15927__$1){
var self__ = this;
var _15928__$1 = this;
return (new cljs.core.async.t_cljs$core$async15926(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta15927__$1));
}));

(cljs.core.async.t_cljs$core$async15926.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15928){
var self__ = this;
var _15928__$1 = this;
return self__.meta15927;
}));

(cljs.core.async.t_cljs$core$async15926.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15926.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async15926.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15926.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async15926.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async15926.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async15926.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async15926.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async15926.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta15927","meta15927",-244975959,null)], null);
}));

(cljs.core.async.t_cljs$core$async15926.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async15926.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15926");

(cljs.core.async.t_cljs$core$async15926.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async15926");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async15926.
 */
cljs.core.async.__GT_t_cljs$core$async15926 = (function cljs$core$async$__GT_t_cljs$core$async15926(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta15927){
return (new cljs.core.async.t_cljs$core$async15926(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta15927));
});


/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (new cljs.core.async.t_cljs$core$async15926(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
var c__14553__auto___17994 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14555__auto__ = (function (){var switch__14401__auto__ = (function (state_16030){
var state_val_16031 = (state_16030[(1)]);
if((state_val_16031 === (7))){
var inst_15987 = (state_16030[(2)]);
var state_16030__$1 = state_16030;
if(cljs.core.truth_(inst_15987)){
var statearr_16036_17995 = state_16030__$1;
(statearr_16036_17995[(1)] = (8));

} else {
var statearr_16039_17996 = state_16030__$1;
(statearr_16039_17996[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16031 === (20))){
var inst_15980 = (state_16030[(7)]);
var state_16030__$1 = state_16030;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16030__$1,(23),out,inst_15980);
} else {
if((state_val_16031 === (1))){
var inst_15960 = calc_state();
var inst_15961 = cljs.core.__destructure_map(inst_15960);
var inst_15962 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_15961,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_15963 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_15961,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_15964 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_15961,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_15965 = inst_15960;
var state_16030__$1 = (function (){var statearr_16044 = state_16030;
(statearr_16044[(8)] = inst_15963);

(statearr_16044[(9)] = inst_15962);

(statearr_16044[(10)] = inst_15964);

(statearr_16044[(11)] = inst_15965);

return statearr_16044;
})();
var statearr_16045_17997 = state_16030__$1;
(statearr_16045_17997[(2)] = null);

(statearr_16045_17997[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16031 === (24))){
var inst_15968 = (state_16030[(12)]);
var inst_15965 = inst_15968;
var state_16030__$1 = (function (){var statearr_16047 = state_16030;
(statearr_16047[(11)] = inst_15965);

return statearr_16047;
})();
var statearr_16048_18000 = state_16030__$1;
(statearr_16048_18000[(2)] = null);

(statearr_16048_18000[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16031 === (4))){
var inst_15980 = (state_16030[(7)]);
var inst_15982 = (state_16030[(13)]);
var inst_15979 = (state_16030[(2)]);
var inst_15980__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15979,(0),null);
var inst_15981 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15979,(1),null);
var inst_15982__$1 = (inst_15980__$1 == null);
var state_16030__$1 = (function (){var statearr_16053 = state_16030;
(statearr_16053[(7)] = inst_15980__$1);

(statearr_16053[(14)] = inst_15981);

(statearr_16053[(13)] = inst_15982__$1);

return statearr_16053;
})();
if(cljs.core.truth_(inst_15982__$1)){
var statearr_16054_18001 = state_16030__$1;
(statearr_16054_18001[(1)] = (5));

} else {
var statearr_16055_18002 = state_16030__$1;
(statearr_16055_18002[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16031 === (15))){
var inst_15969 = (state_16030[(15)]);
var inst_16002 = (state_16030[(16)]);
var inst_16002__$1 = cljs.core.empty_QMARK_(inst_15969);
var state_16030__$1 = (function (){var statearr_16060 = state_16030;
(statearr_16060[(16)] = inst_16002__$1);

return statearr_16060;
})();
if(inst_16002__$1){
var statearr_16065_18005 = state_16030__$1;
(statearr_16065_18005[(1)] = (17));

} else {
var statearr_16067_18006 = state_16030__$1;
(statearr_16067_18006[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16031 === (21))){
var inst_15968 = (state_16030[(12)]);
var inst_15965 = inst_15968;
var state_16030__$1 = (function (){var statearr_16075 = state_16030;
(statearr_16075[(11)] = inst_15965);

return statearr_16075;
})();
var statearr_16077_18007 = state_16030__$1;
(statearr_16077_18007[(2)] = null);

(statearr_16077_18007[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16031 === (13))){
var inst_15995 = (state_16030[(2)]);
var inst_15996 = calc_state();
var inst_15965 = inst_15996;
var state_16030__$1 = (function (){var statearr_16078 = state_16030;
(statearr_16078[(17)] = inst_15995);

(statearr_16078[(11)] = inst_15965);

return statearr_16078;
})();
var statearr_16079_18008 = state_16030__$1;
(statearr_16079_18008[(2)] = null);

(statearr_16079_18008[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16031 === (22))){
var inst_16022 = (state_16030[(2)]);
var state_16030__$1 = state_16030;
var statearr_16080_18009 = state_16030__$1;
(statearr_16080_18009[(2)] = inst_16022);

(statearr_16080_18009[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16031 === (6))){
var inst_15981 = (state_16030[(14)]);
var inst_15985 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_15981,change);
var state_16030__$1 = state_16030;
var statearr_16083_18010 = state_16030__$1;
(statearr_16083_18010[(2)] = inst_15985);

(statearr_16083_18010[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16031 === (25))){
var state_16030__$1 = state_16030;
var statearr_16087_18011 = state_16030__$1;
(statearr_16087_18011[(2)] = null);

(statearr_16087_18011[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16031 === (17))){
var inst_15970 = (state_16030[(18)]);
var inst_15981 = (state_16030[(14)]);
var inst_16004 = (inst_15970.cljs$core$IFn$_invoke$arity$1 ? inst_15970.cljs$core$IFn$_invoke$arity$1(inst_15981) : inst_15970.call(null,inst_15981));
var inst_16005 = cljs.core.not(inst_16004);
var state_16030__$1 = state_16030;
var statearr_16096_18012 = state_16030__$1;
(statearr_16096_18012[(2)] = inst_16005);

(statearr_16096_18012[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16031 === (3))){
var inst_16026 = (state_16030[(2)]);
var state_16030__$1 = state_16030;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16030__$1,inst_16026);
} else {
if((state_val_16031 === (12))){
var state_16030__$1 = state_16030;
var statearr_16098_18013 = state_16030__$1;
(statearr_16098_18013[(2)] = null);

(statearr_16098_18013[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16031 === (2))){
var inst_15965 = (state_16030[(11)]);
var inst_15968 = (state_16030[(12)]);
var inst_15968__$1 = cljs.core.__destructure_map(inst_15965);
var inst_15969 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_15968__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_15970 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_15968__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_15971 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_15968__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_16030__$1 = (function (){var statearr_16103 = state_16030;
(statearr_16103[(18)] = inst_15970);

(statearr_16103[(15)] = inst_15969);

(statearr_16103[(12)] = inst_15968__$1);

return statearr_16103;
})();
return cljs.core.async.ioc_alts_BANG_(state_16030__$1,(4),inst_15971);
} else {
if((state_val_16031 === (23))){
var inst_16013 = (state_16030[(2)]);
var state_16030__$1 = state_16030;
if(cljs.core.truth_(inst_16013)){
var statearr_16111_18018 = state_16030__$1;
(statearr_16111_18018[(1)] = (24));

} else {
var statearr_16112_18019 = state_16030__$1;
(statearr_16112_18019[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16031 === (19))){
var inst_16008 = (state_16030[(2)]);
var state_16030__$1 = state_16030;
var statearr_16114_18020 = state_16030__$1;
(statearr_16114_18020[(2)] = inst_16008);

(statearr_16114_18020[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16031 === (11))){
var inst_15981 = (state_16030[(14)]);
var inst_15992 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_15981);
var state_16030__$1 = state_16030;
var statearr_16117_18024 = state_16030__$1;
(statearr_16117_18024[(2)] = inst_15992);

(statearr_16117_18024[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16031 === (9))){
var inst_15999 = (state_16030[(19)]);
var inst_15969 = (state_16030[(15)]);
var inst_15981 = (state_16030[(14)]);
var inst_15999__$1 = (inst_15969.cljs$core$IFn$_invoke$arity$1 ? inst_15969.cljs$core$IFn$_invoke$arity$1(inst_15981) : inst_15969.call(null,inst_15981));
var state_16030__$1 = (function (){var statearr_16120 = state_16030;
(statearr_16120[(19)] = inst_15999__$1);

return statearr_16120;
})();
if(cljs.core.truth_(inst_15999__$1)){
var statearr_16123_18025 = state_16030__$1;
(statearr_16123_18025[(1)] = (14));

} else {
var statearr_16124_18026 = state_16030__$1;
(statearr_16124_18026[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16031 === (5))){
var inst_15982 = (state_16030[(13)]);
var state_16030__$1 = state_16030;
var statearr_16128_18030 = state_16030__$1;
(statearr_16128_18030[(2)] = inst_15982);

(statearr_16128_18030[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16031 === (14))){
var inst_15999 = (state_16030[(19)]);
var state_16030__$1 = state_16030;
var statearr_16134_18031 = state_16030__$1;
(statearr_16134_18031[(2)] = inst_15999);

(statearr_16134_18031[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16031 === (26))){
var inst_16018 = (state_16030[(2)]);
var state_16030__$1 = state_16030;
var statearr_16136_18032 = state_16030__$1;
(statearr_16136_18032[(2)] = inst_16018);

(statearr_16136_18032[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16031 === (16))){
var inst_16010 = (state_16030[(2)]);
var state_16030__$1 = state_16030;
if(cljs.core.truth_(inst_16010)){
var statearr_16138_18033 = state_16030__$1;
(statearr_16138_18033[(1)] = (20));

} else {
var statearr_16142_18034 = state_16030__$1;
(statearr_16142_18034[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16031 === (10))){
var inst_16024 = (state_16030[(2)]);
var state_16030__$1 = state_16030;
var statearr_16146_18035 = state_16030__$1;
(statearr_16146_18035[(2)] = inst_16024);

(statearr_16146_18035[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16031 === (18))){
var inst_16002 = (state_16030[(16)]);
var state_16030__$1 = state_16030;
var statearr_16147_18036 = state_16030__$1;
(statearr_16147_18036[(2)] = inst_16002);

(statearr_16147_18036[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16031 === (8))){
var inst_15980 = (state_16030[(7)]);
var inst_15990 = (inst_15980 == null);
var state_16030__$1 = state_16030;
if(cljs.core.truth_(inst_15990)){
var statearr_16148_18037 = state_16030__$1;
(statearr_16148_18037[(1)] = (11));

} else {
var statearr_16149_18038 = state_16030__$1;
(statearr_16149_18038[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__14402__auto__ = null;
var cljs$core$async$mix_$_state_machine__14402__auto____0 = (function (){
var statearr_16152 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16152[(0)] = cljs$core$async$mix_$_state_machine__14402__auto__);

(statearr_16152[(1)] = (1));

return statearr_16152;
});
var cljs$core$async$mix_$_state_machine__14402__auto____1 = (function (state_16030){
while(true){
var ret_value__14403__auto__ = (function (){try{while(true){
var result__14404__auto__ = switch__14401__auto__(state_16030);
if(cljs.core.keyword_identical_QMARK_(result__14404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14404__auto__;
}
break;
}
}catch (e16155){var ex__14405__auto__ = e16155;
var statearr_16157_18042 = state_16030;
(statearr_16157_18042[(2)] = ex__14405__auto__);


if(cljs.core.seq((state_16030[(4)]))){
var statearr_16158_18043 = state_16030;
(statearr_16158_18043[(1)] = cljs.core.first((state_16030[(4)])));

} else {
throw ex__14405__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18044 = state_16030;
state_16030 = G__18044;
continue;
} else {
return ret_value__14403__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__14402__auto__ = function(state_16030){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__14402__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__14402__auto____1.call(this,state_16030);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__14402__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__14402__auto____0;
cljs$core$async$mix_$_state_machine__14402__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__14402__auto____1;
return cljs$core$async$mix_$_state_machine__14402__auto__;
})()
})();
var state__14556__auto__ = (function (){var statearr_16162 = f__14555__auto__();
(statearr_16162[(6)] = c__14553__auto___17994);

return statearr_16162;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14556__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_18045 = (function (p,v,ch,close_QMARK_){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5351__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__5349__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5349__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_18045(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_18046 = (function (p,v,ch){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5351__auto__.call(null,p,v,ch));
} else {
var m__5349__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5349__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_18046(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_18054 = (function() {
var G__18055 = null;
var G__18055__1 = (function (p){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5351__auto__.call(null,p));
} else {
var m__5349__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5349__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__18055__2 = (function (p,v){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5351__auto__.call(null,p,v));
} else {
var m__5349__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5349__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__18055 = function(p,v){
switch(arguments.length){
case 1:
return G__18055__1.call(this,p);
case 2:
return G__18055__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18055.cljs$core$IFn$_invoke$arity$1 = G__18055__1;
G__18055.cljs$core$IFn$_invoke$arity$2 = G__18055__2;
return G__18055;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__16200 = arguments.length;
switch (G__16200) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_18054(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_18054(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);



/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16209 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta16210){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta16210 = meta16210;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async16209.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16211,meta16210__$1){
var self__ = this;
var _16211__$1 = this;
return (new cljs.core.async.t_cljs$core$async16209(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta16210__$1));
}));

(cljs.core.async.t_cljs$core$async16209.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16211){
var self__ = this;
var _16211__$1 = this;
return self__.meta16210;
}));

(cljs.core.async.t_cljs$core$async16209.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16209.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async16209.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16209.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async16209.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5804__auto__)){
var m = temp__5804__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async16209.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async16209.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async16209.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta16210","meta16210",757184532,null)], null);
}));

(cljs.core.async.t_cljs$core$async16209.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async16209.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16209");

(cljs.core.async.t_cljs$core$async16209.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async16209");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async16209.
 */
cljs.core.async.__GT_t_cljs$core$async16209 = (function cljs$core$async$__GT_t_cljs$core$async16209(ch,topic_fn,buf_fn,mults,ensure_mult,meta16210){
return (new cljs.core.async.t_cljs$core$async16209(ch,topic_fn,buf_fn,mults,ensure_mult,meta16210));
});


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__16203 = arguments.length;
switch (G__16203) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__5002__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__16201_SHARP_){
if(cljs.core.truth_((p1__16201_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16201_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__16201_SHARP_.call(null,topic)))){
return p1__16201_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__16201_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (new cljs.core.async.t_cljs$core$async16209(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
var c__14553__auto___18062 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14555__auto__ = (function (){var switch__14401__auto__ = (function (state_16285){
var state_val_16286 = (state_16285[(1)]);
if((state_val_16286 === (7))){
var inst_16281 = (state_16285[(2)]);
var state_16285__$1 = state_16285;
var statearr_16287_18063 = state_16285__$1;
(statearr_16287_18063[(2)] = inst_16281);

(statearr_16287_18063[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16286 === (20))){
var state_16285__$1 = state_16285;
var statearr_16288_18064 = state_16285__$1;
(statearr_16288_18064[(2)] = null);

(statearr_16288_18064[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16286 === (1))){
var state_16285__$1 = state_16285;
var statearr_16289_18066 = state_16285__$1;
(statearr_16289_18066[(2)] = null);

(statearr_16289_18066[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16286 === (24))){
var inst_16264 = (state_16285[(7)]);
var inst_16273 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_16264);
var state_16285__$1 = state_16285;
var statearr_16290_18070 = state_16285__$1;
(statearr_16290_18070[(2)] = inst_16273);

(statearr_16290_18070[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16286 === (4))){
var inst_16216 = (state_16285[(8)]);
var inst_16216__$1 = (state_16285[(2)]);
var inst_16217 = (inst_16216__$1 == null);
var state_16285__$1 = (function (){var statearr_16291 = state_16285;
(statearr_16291[(8)] = inst_16216__$1);

return statearr_16291;
})();
if(cljs.core.truth_(inst_16217)){
var statearr_16295_18071 = state_16285__$1;
(statearr_16295_18071[(1)] = (5));

} else {
var statearr_16296_18072 = state_16285__$1;
(statearr_16296_18072[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16286 === (15))){
var inst_16258 = (state_16285[(2)]);
var state_16285__$1 = state_16285;
var statearr_16298_18073 = state_16285__$1;
(statearr_16298_18073[(2)] = inst_16258);

(statearr_16298_18073[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16286 === (21))){
var inst_16278 = (state_16285[(2)]);
var state_16285__$1 = (function (){var statearr_16302 = state_16285;
(statearr_16302[(9)] = inst_16278);

return statearr_16302;
})();
var statearr_16303_18074 = state_16285__$1;
(statearr_16303_18074[(2)] = null);

(statearr_16303_18074[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16286 === (13))){
var inst_16240 = (state_16285[(10)]);
var inst_16242 = cljs.core.chunked_seq_QMARK_(inst_16240);
var state_16285__$1 = state_16285;
if(inst_16242){
var statearr_16304_18075 = state_16285__$1;
(statearr_16304_18075[(1)] = (16));

} else {
var statearr_16305_18076 = state_16285__$1;
(statearr_16305_18076[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16286 === (22))){
var inst_16270 = (state_16285[(2)]);
var state_16285__$1 = state_16285;
if(cljs.core.truth_(inst_16270)){
var statearr_16309_18077 = state_16285__$1;
(statearr_16309_18077[(1)] = (23));

} else {
var statearr_16310_18078 = state_16285__$1;
(statearr_16310_18078[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16286 === (6))){
var inst_16216 = (state_16285[(8)]);
var inst_16264 = (state_16285[(7)]);
var inst_16266 = (state_16285[(11)]);
var inst_16264__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_16216) : topic_fn.call(null,inst_16216));
var inst_16265 = cljs.core.deref(mults);
var inst_16266__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16265,inst_16264__$1);
var state_16285__$1 = (function (){var statearr_16322 = state_16285;
(statearr_16322[(7)] = inst_16264__$1);

(statearr_16322[(11)] = inst_16266__$1);

return statearr_16322;
})();
if(cljs.core.truth_(inst_16266__$1)){
var statearr_16327_18079 = state_16285__$1;
(statearr_16327_18079[(1)] = (19));

} else {
var statearr_16328_18080 = state_16285__$1;
(statearr_16328_18080[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16286 === (25))){
var inst_16275 = (state_16285[(2)]);
var state_16285__$1 = state_16285;
var statearr_16330_18081 = state_16285__$1;
(statearr_16330_18081[(2)] = inst_16275);

(statearr_16330_18081[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16286 === (17))){
var inst_16240 = (state_16285[(10)]);
var inst_16249 = cljs.core.first(inst_16240);
var inst_16250 = cljs.core.async.muxch_STAR_(inst_16249);
var inst_16251 = cljs.core.async.close_BANG_(inst_16250);
var inst_16252 = cljs.core.next(inst_16240);
var inst_16226 = inst_16252;
var inst_16227 = null;
var inst_16228 = (0);
var inst_16229 = (0);
var state_16285__$1 = (function (){var statearr_16336 = state_16285;
(statearr_16336[(12)] = inst_16227);

(statearr_16336[(13)] = inst_16228);

(statearr_16336[(14)] = inst_16229);

(statearr_16336[(15)] = inst_16226);

(statearr_16336[(16)] = inst_16251);

return statearr_16336;
})();
var statearr_16337_18082 = state_16285__$1;
(statearr_16337_18082[(2)] = null);

(statearr_16337_18082[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16286 === (3))){
var inst_16283 = (state_16285[(2)]);
var state_16285__$1 = state_16285;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16285__$1,inst_16283);
} else {
if((state_val_16286 === (12))){
var inst_16260 = (state_16285[(2)]);
var state_16285__$1 = state_16285;
var statearr_16341_18083 = state_16285__$1;
(statearr_16341_18083[(2)] = inst_16260);

(statearr_16341_18083[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16286 === (2))){
var state_16285__$1 = state_16285;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16285__$1,(4),ch);
} else {
if((state_val_16286 === (23))){
var state_16285__$1 = state_16285;
var statearr_16342_18084 = state_16285__$1;
(statearr_16342_18084[(2)] = null);

(statearr_16342_18084[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16286 === (19))){
var inst_16216 = (state_16285[(8)]);
var inst_16266 = (state_16285[(11)]);
var inst_16268 = cljs.core.async.muxch_STAR_(inst_16266);
var state_16285__$1 = state_16285;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16285__$1,(22),inst_16268,inst_16216);
} else {
if((state_val_16286 === (11))){
var inst_16240 = (state_16285[(10)]);
var inst_16226 = (state_16285[(15)]);
var inst_16240__$1 = cljs.core.seq(inst_16226);
var state_16285__$1 = (function (){var statearr_16347 = state_16285;
(statearr_16347[(10)] = inst_16240__$1);

return statearr_16347;
})();
if(inst_16240__$1){
var statearr_16348_18085 = state_16285__$1;
(statearr_16348_18085[(1)] = (13));

} else {
var statearr_16349_18086 = state_16285__$1;
(statearr_16349_18086[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16286 === (9))){
var inst_16262 = (state_16285[(2)]);
var state_16285__$1 = state_16285;
var statearr_16350_18087 = state_16285__$1;
(statearr_16350_18087[(2)] = inst_16262);

(statearr_16350_18087[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16286 === (5))){
var inst_16223 = cljs.core.deref(mults);
var inst_16224 = cljs.core.vals(inst_16223);
var inst_16225 = cljs.core.seq(inst_16224);
var inst_16226 = inst_16225;
var inst_16227 = null;
var inst_16228 = (0);
var inst_16229 = (0);
var state_16285__$1 = (function (){var statearr_16352 = state_16285;
(statearr_16352[(12)] = inst_16227);

(statearr_16352[(13)] = inst_16228);

(statearr_16352[(14)] = inst_16229);

(statearr_16352[(15)] = inst_16226);

return statearr_16352;
})();
var statearr_16353_18088 = state_16285__$1;
(statearr_16353_18088[(2)] = null);

(statearr_16353_18088[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16286 === (14))){
var state_16285__$1 = state_16285;
var statearr_16358_18089 = state_16285__$1;
(statearr_16358_18089[(2)] = null);

(statearr_16358_18089[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16286 === (16))){
var inst_16240 = (state_16285[(10)]);
var inst_16244 = cljs.core.chunk_first(inst_16240);
var inst_16245 = cljs.core.chunk_rest(inst_16240);
var inst_16246 = cljs.core.count(inst_16244);
var inst_16226 = inst_16245;
var inst_16227 = inst_16244;
var inst_16228 = inst_16246;
var inst_16229 = (0);
var state_16285__$1 = (function (){var statearr_16363 = state_16285;
(statearr_16363[(12)] = inst_16227);

(statearr_16363[(13)] = inst_16228);

(statearr_16363[(14)] = inst_16229);

(statearr_16363[(15)] = inst_16226);

return statearr_16363;
})();
var statearr_16364_18090 = state_16285__$1;
(statearr_16364_18090[(2)] = null);

(statearr_16364_18090[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16286 === (10))){
var inst_16227 = (state_16285[(12)]);
var inst_16228 = (state_16285[(13)]);
var inst_16229 = (state_16285[(14)]);
var inst_16226 = (state_16285[(15)]);
var inst_16234 = cljs.core._nth(inst_16227,inst_16229);
var inst_16235 = cljs.core.async.muxch_STAR_(inst_16234);
var inst_16236 = cljs.core.async.close_BANG_(inst_16235);
var inst_16237 = (inst_16229 + (1));
var tmp16354 = inst_16227;
var tmp16355 = inst_16228;
var tmp16356 = inst_16226;
var inst_16226__$1 = tmp16356;
var inst_16227__$1 = tmp16354;
var inst_16228__$1 = tmp16355;
var inst_16229__$1 = inst_16237;
var state_16285__$1 = (function (){var statearr_16368 = state_16285;
(statearr_16368[(12)] = inst_16227__$1);

(statearr_16368[(13)] = inst_16228__$1);

(statearr_16368[(14)] = inst_16229__$1);

(statearr_16368[(15)] = inst_16226__$1);

(statearr_16368[(17)] = inst_16236);

return statearr_16368;
})();
var statearr_16375_18093 = state_16285__$1;
(statearr_16375_18093[(2)] = null);

(statearr_16375_18093[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16286 === (18))){
var inst_16255 = (state_16285[(2)]);
var state_16285__$1 = state_16285;
var statearr_16376_18094 = state_16285__$1;
(statearr_16376_18094[(2)] = inst_16255);

(statearr_16376_18094[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16286 === (8))){
var inst_16228 = (state_16285[(13)]);
var inst_16229 = (state_16285[(14)]);
var inst_16231 = (inst_16229 < inst_16228);
var inst_16232 = inst_16231;
var state_16285__$1 = state_16285;
if(cljs.core.truth_(inst_16232)){
var statearr_16377_18095 = state_16285__$1;
(statearr_16377_18095[(1)] = (10));

} else {
var statearr_16378_18096 = state_16285__$1;
(statearr_16378_18096[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__14402__auto__ = null;
var cljs$core$async$state_machine__14402__auto____0 = (function (){
var statearr_16382 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16382[(0)] = cljs$core$async$state_machine__14402__auto__);

(statearr_16382[(1)] = (1));

return statearr_16382;
});
var cljs$core$async$state_machine__14402__auto____1 = (function (state_16285){
while(true){
var ret_value__14403__auto__ = (function (){try{while(true){
var result__14404__auto__ = switch__14401__auto__(state_16285);
if(cljs.core.keyword_identical_QMARK_(result__14404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14404__auto__;
}
break;
}
}catch (e16385){var ex__14405__auto__ = e16385;
var statearr_16386_18097 = state_16285;
(statearr_16386_18097[(2)] = ex__14405__auto__);


if(cljs.core.seq((state_16285[(4)]))){
var statearr_16389_18098 = state_16285;
(statearr_16389_18098[(1)] = cljs.core.first((state_16285[(4)])));

} else {
throw ex__14405__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18099 = state_16285;
state_16285 = G__18099;
continue;
} else {
return ret_value__14403__auto__;
}
break;
}
});
cljs$core$async$state_machine__14402__auto__ = function(state_16285){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14402__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14402__auto____1.call(this,state_16285);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14402__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14402__auto____0;
cljs$core$async$state_machine__14402__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14402__auto____1;
return cljs$core$async$state_machine__14402__auto__;
})()
})();
var state__14556__auto__ = (function (){var statearr_16391 = f__14555__auto__();
(statearr_16391[(6)] = c__14553__auto___18062);

return statearr_16391;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14556__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__16404 = arguments.length;
switch (G__16404) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__16428 = arguments.length;
switch (G__16428) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__16443 = arguments.length;
switch (G__16443) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
if((cnt === (0))){
cljs.core.async.close_BANG_(out);
} else {
var c__14553__auto___18104 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14555__auto__ = (function (){var switch__14401__auto__ = (function (state_16500){
var state_val_16501 = (state_16500[(1)]);
if((state_val_16501 === (7))){
var state_16500__$1 = state_16500;
var statearr_16502_18105 = state_16500__$1;
(statearr_16502_18105[(2)] = null);

(statearr_16502_18105[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16501 === (1))){
var state_16500__$1 = state_16500;
var statearr_16503_18106 = state_16500__$1;
(statearr_16503_18106[(2)] = null);

(statearr_16503_18106[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16501 === (4))){
var inst_16453 = (state_16500[(7)]);
var inst_16454 = (state_16500[(8)]);
var inst_16456 = (inst_16454 < inst_16453);
var state_16500__$1 = state_16500;
if(cljs.core.truth_(inst_16456)){
var statearr_16504_18107 = state_16500__$1;
(statearr_16504_18107[(1)] = (6));

} else {
var statearr_16505_18108 = state_16500__$1;
(statearr_16505_18108[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16501 === (15))){
var inst_16483 = (state_16500[(9)]);
var inst_16491 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_16483);
var state_16500__$1 = state_16500;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16500__$1,(17),out,inst_16491);
} else {
if((state_val_16501 === (13))){
var inst_16483 = (state_16500[(9)]);
var inst_16483__$1 = (state_16500[(2)]);
var inst_16484 = cljs.core.some(cljs.core.nil_QMARK_,inst_16483__$1);
var state_16500__$1 = (function (){var statearr_16509 = state_16500;
(statearr_16509[(9)] = inst_16483__$1);

return statearr_16509;
})();
if(cljs.core.truth_(inst_16484)){
var statearr_16511_18109 = state_16500__$1;
(statearr_16511_18109[(1)] = (14));

} else {
var statearr_16512_18110 = state_16500__$1;
(statearr_16512_18110[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16501 === (6))){
var state_16500__$1 = state_16500;
var statearr_16515_18111 = state_16500__$1;
(statearr_16515_18111[(2)] = null);

(statearr_16515_18111[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16501 === (17))){
var inst_16493 = (state_16500[(2)]);
var state_16500__$1 = (function (){var statearr_16520 = state_16500;
(statearr_16520[(10)] = inst_16493);

return statearr_16520;
})();
var statearr_16521_18112 = state_16500__$1;
(statearr_16521_18112[(2)] = null);

(statearr_16521_18112[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16501 === (3))){
var inst_16498 = (state_16500[(2)]);
var state_16500__$1 = state_16500;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16500__$1,inst_16498);
} else {
if((state_val_16501 === (12))){
var _ = (function (){var statearr_16522 = state_16500;
(statearr_16522[(4)] = cljs.core.rest((state_16500[(4)])));

return statearr_16522;
})();
var state_16500__$1 = state_16500;
var ex16519 = (state_16500__$1[(2)]);
var statearr_16523_18114 = state_16500__$1;
(statearr_16523_18114[(5)] = ex16519);


if((ex16519 instanceof Object)){
var statearr_16525_18115 = state_16500__$1;
(statearr_16525_18115[(1)] = (11));

(statearr_16525_18115[(5)] = null);

} else {
throw ex16519;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16501 === (2))){
var inst_16452 = cljs.core.reset_BANG_(dctr,cnt);
var inst_16453 = cnt;
var inst_16454 = (0);
var state_16500__$1 = (function (){var statearr_16539 = state_16500;
(statearr_16539[(11)] = inst_16452);

(statearr_16539[(7)] = inst_16453);

(statearr_16539[(8)] = inst_16454);

return statearr_16539;
})();
var statearr_16540_18118 = state_16500__$1;
(statearr_16540_18118[(2)] = null);

(statearr_16540_18118[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16501 === (11))){
var inst_16461 = (state_16500[(2)]);
var inst_16462 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_16500__$1 = (function (){var statearr_16541 = state_16500;
(statearr_16541[(12)] = inst_16461);

return statearr_16541;
})();
var statearr_16542_18119 = state_16500__$1;
(statearr_16542_18119[(2)] = inst_16462);

(statearr_16542_18119[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16501 === (9))){
var inst_16454 = (state_16500[(8)]);
var _ = (function (){var statearr_16543 = state_16500;
(statearr_16543[(4)] = cljs.core.cons((12),(state_16500[(4)])));

return statearr_16543;
})();
var inst_16468 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_16454) : chs__$1.call(null,inst_16454));
var inst_16470 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_16454) : done.call(null,inst_16454));
var inst_16471 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_16468,inst_16470);
var ___$1 = (function (){var statearr_16544 = state_16500;
(statearr_16544[(4)] = cljs.core.rest((state_16500[(4)])));

return statearr_16544;
})();
var state_16500__$1 = state_16500;
var statearr_16545_18120 = state_16500__$1;
(statearr_16545_18120[(2)] = inst_16471);

(statearr_16545_18120[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16501 === (5))){
var inst_16481 = (state_16500[(2)]);
var state_16500__$1 = (function (){var statearr_16548 = state_16500;
(statearr_16548[(13)] = inst_16481);

return statearr_16548;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16500__$1,(13),dchan);
} else {
if((state_val_16501 === (14))){
var inst_16489 = cljs.core.async.close_BANG_(out);
var state_16500__$1 = state_16500;
var statearr_16549_18125 = state_16500__$1;
(statearr_16549_18125[(2)] = inst_16489);

(statearr_16549_18125[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16501 === (16))){
var inst_16496 = (state_16500[(2)]);
var state_16500__$1 = state_16500;
var statearr_16550_18126 = state_16500__$1;
(statearr_16550_18126[(2)] = inst_16496);

(statearr_16550_18126[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16501 === (10))){
var inst_16454 = (state_16500[(8)]);
var inst_16474 = (state_16500[(2)]);
var inst_16475 = (inst_16454 + (1));
var inst_16454__$1 = inst_16475;
var state_16500__$1 = (function (){var statearr_16554 = state_16500;
(statearr_16554[(8)] = inst_16454__$1);

(statearr_16554[(14)] = inst_16474);

return statearr_16554;
})();
var statearr_16555_18128 = state_16500__$1;
(statearr_16555_18128[(2)] = null);

(statearr_16555_18128[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16501 === (8))){
var inst_16479 = (state_16500[(2)]);
var state_16500__$1 = state_16500;
var statearr_16558_18129 = state_16500__$1;
(statearr_16558_18129[(2)] = inst_16479);

(statearr_16558_18129[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__14402__auto__ = null;
var cljs$core$async$state_machine__14402__auto____0 = (function (){
var statearr_16564 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16564[(0)] = cljs$core$async$state_machine__14402__auto__);

(statearr_16564[(1)] = (1));

return statearr_16564;
});
var cljs$core$async$state_machine__14402__auto____1 = (function (state_16500){
while(true){
var ret_value__14403__auto__ = (function (){try{while(true){
var result__14404__auto__ = switch__14401__auto__(state_16500);
if(cljs.core.keyword_identical_QMARK_(result__14404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14404__auto__;
}
break;
}
}catch (e16566){var ex__14405__auto__ = e16566;
var statearr_16568_18130 = state_16500;
(statearr_16568_18130[(2)] = ex__14405__auto__);


if(cljs.core.seq((state_16500[(4)]))){
var statearr_16569_18131 = state_16500;
(statearr_16569_18131[(1)] = cljs.core.first((state_16500[(4)])));

} else {
throw ex__14405__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18132 = state_16500;
state_16500 = G__18132;
continue;
} else {
return ret_value__14403__auto__;
}
break;
}
});
cljs$core$async$state_machine__14402__auto__ = function(state_16500){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14402__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14402__auto____1.call(this,state_16500);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14402__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14402__auto____0;
cljs$core$async$state_machine__14402__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14402__auto____1;
return cljs$core$async$state_machine__14402__auto__;
})()
})();
var state__14556__auto__ = (function (){var statearr_16571 = f__14555__auto__();
(statearr_16571[(6)] = c__14553__auto___18104);

return statearr_16571;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14556__auto__);
}));

}

return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__16574 = arguments.length;
switch (G__16574) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__14553__auto___18139 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14555__auto__ = (function (){var switch__14401__auto__ = (function (state_16622){
var state_val_16623 = (state_16622[(1)]);
if((state_val_16623 === (7))){
var inst_16588 = (state_16622[(7)]);
var inst_16586 = (state_16622[(8)]);
var inst_16586__$1 = (state_16622[(2)]);
var inst_16588__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16586__$1,(0),null);
var inst_16589 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16586__$1,(1),null);
var inst_16590 = (inst_16588__$1 == null);
var state_16622__$1 = (function (){var statearr_16628 = state_16622;
(statearr_16628[(9)] = inst_16589);

(statearr_16628[(7)] = inst_16588__$1);

(statearr_16628[(8)] = inst_16586__$1);

return statearr_16628;
})();
if(cljs.core.truth_(inst_16590)){
var statearr_16629_18140 = state_16622__$1;
(statearr_16629_18140[(1)] = (8));

} else {
var statearr_16630_18141 = state_16622__$1;
(statearr_16630_18141[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16623 === (1))){
var inst_16576 = cljs.core.vec(chs);
var inst_16577 = inst_16576;
var state_16622__$1 = (function (){var statearr_16631 = state_16622;
(statearr_16631[(10)] = inst_16577);

return statearr_16631;
})();
var statearr_16632_18142 = state_16622__$1;
(statearr_16632_18142[(2)] = null);

(statearr_16632_18142[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16623 === (4))){
var inst_16577 = (state_16622[(10)]);
var state_16622__$1 = state_16622;
return cljs.core.async.ioc_alts_BANG_(state_16622__$1,(7),inst_16577);
} else {
if((state_val_16623 === (6))){
var inst_16610 = (state_16622[(2)]);
var state_16622__$1 = state_16622;
var statearr_16637_18143 = state_16622__$1;
(statearr_16637_18143[(2)] = inst_16610);

(statearr_16637_18143[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16623 === (3))){
var inst_16612 = (state_16622[(2)]);
var state_16622__$1 = state_16622;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16622__$1,inst_16612);
} else {
if((state_val_16623 === (2))){
var inst_16577 = (state_16622[(10)]);
var inst_16579 = cljs.core.count(inst_16577);
var inst_16580 = (inst_16579 > (0));
var state_16622__$1 = state_16622;
if(cljs.core.truth_(inst_16580)){
var statearr_16639_18145 = state_16622__$1;
(statearr_16639_18145[(1)] = (4));

} else {
var statearr_16640_18146 = state_16622__$1;
(statearr_16640_18146[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16623 === (11))){
var inst_16577 = (state_16622[(10)]);
var inst_16599 = (state_16622[(2)]);
var tmp16638 = inst_16577;
var inst_16577__$1 = tmp16638;
var state_16622__$1 = (function (){var statearr_16644 = state_16622;
(statearr_16644[(10)] = inst_16577__$1);

(statearr_16644[(11)] = inst_16599);

return statearr_16644;
})();
var statearr_16645_18147 = state_16622__$1;
(statearr_16645_18147[(2)] = null);

(statearr_16645_18147[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16623 === (9))){
var inst_16588 = (state_16622[(7)]);
var state_16622__$1 = state_16622;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16622__$1,(11),out,inst_16588);
} else {
if((state_val_16623 === (5))){
var inst_16608 = cljs.core.async.close_BANG_(out);
var state_16622__$1 = state_16622;
var statearr_16664_18148 = state_16622__$1;
(statearr_16664_18148[(2)] = inst_16608);

(statearr_16664_18148[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16623 === (10))){
var inst_16602 = (state_16622[(2)]);
var state_16622__$1 = state_16622;
var statearr_16665_18150 = state_16622__$1;
(statearr_16665_18150[(2)] = inst_16602);

(statearr_16665_18150[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16623 === (8))){
var inst_16577 = (state_16622[(10)]);
var inst_16589 = (state_16622[(9)]);
var inst_16588 = (state_16622[(7)]);
var inst_16586 = (state_16622[(8)]);
var inst_16594 = (function (){var cs = inst_16577;
var vec__16582 = inst_16586;
var v = inst_16588;
var c = inst_16589;
return (function (p1__16572_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__16572_SHARP_);
});
})();
var inst_16595 = cljs.core.filterv(inst_16594,inst_16577);
var inst_16577__$1 = inst_16595;
var state_16622__$1 = (function (){var statearr_16668 = state_16622;
(statearr_16668[(10)] = inst_16577__$1);

return statearr_16668;
})();
var statearr_16669_18154 = state_16622__$1;
(statearr_16669_18154[(2)] = null);

(statearr_16669_18154[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__14402__auto__ = null;
var cljs$core$async$state_machine__14402__auto____0 = (function (){
var statearr_16670 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16670[(0)] = cljs$core$async$state_machine__14402__auto__);

(statearr_16670[(1)] = (1));

return statearr_16670;
});
var cljs$core$async$state_machine__14402__auto____1 = (function (state_16622){
while(true){
var ret_value__14403__auto__ = (function (){try{while(true){
var result__14404__auto__ = switch__14401__auto__(state_16622);
if(cljs.core.keyword_identical_QMARK_(result__14404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14404__auto__;
}
break;
}
}catch (e16674){var ex__14405__auto__ = e16674;
var statearr_16678_18155 = state_16622;
(statearr_16678_18155[(2)] = ex__14405__auto__);


if(cljs.core.seq((state_16622[(4)]))){
var statearr_16679_18156 = state_16622;
(statearr_16679_18156[(1)] = cljs.core.first((state_16622[(4)])));

} else {
throw ex__14405__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18157 = state_16622;
state_16622 = G__18157;
continue;
} else {
return ret_value__14403__auto__;
}
break;
}
});
cljs$core$async$state_machine__14402__auto__ = function(state_16622){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14402__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14402__auto____1.call(this,state_16622);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14402__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14402__auto____0;
cljs$core$async$state_machine__14402__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14402__auto____1;
return cljs$core$async$state_machine__14402__auto__;
})()
})();
var state__14556__auto__ = (function (){var statearr_16683 = f__14555__auto__();
(statearr_16683[(6)] = c__14553__auto___18139);

return statearr_16683;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14556__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__16688 = arguments.length;
switch (G__16688) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__14553__auto___18159 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14555__auto__ = (function (){var switch__14401__auto__ = (function (state_16724){
var state_val_16725 = (state_16724[(1)]);
if((state_val_16725 === (7))){
var inst_16701 = (state_16724[(7)]);
var inst_16701__$1 = (state_16724[(2)]);
var inst_16702 = (inst_16701__$1 == null);
var inst_16703 = cljs.core.not(inst_16702);
var state_16724__$1 = (function (){var statearr_16727 = state_16724;
(statearr_16727[(7)] = inst_16701__$1);

return statearr_16727;
})();
if(inst_16703){
var statearr_16730_18160 = state_16724__$1;
(statearr_16730_18160[(1)] = (8));

} else {
var statearr_16731_18161 = state_16724__$1;
(statearr_16731_18161[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16725 === (1))){
var inst_16696 = (0);
var state_16724__$1 = (function (){var statearr_16732 = state_16724;
(statearr_16732[(8)] = inst_16696);

return statearr_16732;
})();
var statearr_16733_18162 = state_16724__$1;
(statearr_16733_18162[(2)] = null);

(statearr_16733_18162[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16725 === (4))){
var state_16724__$1 = state_16724;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16724__$1,(7),ch);
} else {
if((state_val_16725 === (6))){
var inst_16719 = (state_16724[(2)]);
var state_16724__$1 = state_16724;
var statearr_16735_18163 = state_16724__$1;
(statearr_16735_18163[(2)] = inst_16719);

(statearr_16735_18163[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16725 === (3))){
var inst_16721 = (state_16724[(2)]);
var inst_16722 = cljs.core.async.close_BANG_(out);
var state_16724__$1 = (function (){var statearr_16737 = state_16724;
(statearr_16737[(9)] = inst_16721);

return statearr_16737;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_16724__$1,inst_16722);
} else {
if((state_val_16725 === (2))){
var inst_16696 = (state_16724[(8)]);
var inst_16698 = (inst_16696 < n);
var state_16724__$1 = state_16724;
if(cljs.core.truth_(inst_16698)){
var statearr_16743_18164 = state_16724__$1;
(statearr_16743_18164[(1)] = (4));

} else {
var statearr_16744_18165 = state_16724__$1;
(statearr_16744_18165[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16725 === (11))){
var inst_16696 = (state_16724[(8)]);
var inst_16706 = (state_16724[(2)]);
var inst_16708 = (inst_16696 + (1));
var inst_16696__$1 = inst_16708;
var state_16724__$1 = (function (){var statearr_16745 = state_16724;
(statearr_16745[(8)] = inst_16696__$1);

(statearr_16745[(10)] = inst_16706);

return statearr_16745;
})();
var statearr_16747_18166 = state_16724__$1;
(statearr_16747_18166[(2)] = null);

(statearr_16747_18166[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16725 === (9))){
var state_16724__$1 = state_16724;
var statearr_16749_18167 = state_16724__$1;
(statearr_16749_18167[(2)] = null);

(statearr_16749_18167[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16725 === (5))){
var state_16724__$1 = state_16724;
var statearr_16750_18168 = state_16724__$1;
(statearr_16750_18168[(2)] = null);

(statearr_16750_18168[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16725 === (10))){
var inst_16716 = (state_16724[(2)]);
var state_16724__$1 = state_16724;
var statearr_16751_18169 = state_16724__$1;
(statearr_16751_18169[(2)] = inst_16716);

(statearr_16751_18169[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16725 === (8))){
var inst_16701 = (state_16724[(7)]);
var state_16724__$1 = state_16724;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16724__$1,(11),out,inst_16701);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__14402__auto__ = null;
var cljs$core$async$state_machine__14402__auto____0 = (function (){
var statearr_16754 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_16754[(0)] = cljs$core$async$state_machine__14402__auto__);

(statearr_16754[(1)] = (1));

return statearr_16754;
});
var cljs$core$async$state_machine__14402__auto____1 = (function (state_16724){
while(true){
var ret_value__14403__auto__ = (function (){try{while(true){
var result__14404__auto__ = switch__14401__auto__(state_16724);
if(cljs.core.keyword_identical_QMARK_(result__14404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14404__auto__;
}
break;
}
}catch (e16755){var ex__14405__auto__ = e16755;
var statearr_16756_18170 = state_16724;
(statearr_16756_18170[(2)] = ex__14405__auto__);


if(cljs.core.seq((state_16724[(4)]))){
var statearr_16757_18171 = state_16724;
(statearr_16757_18171[(1)] = cljs.core.first((state_16724[(4)])));

} else {
throw ex__14405__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18172 = state_16724;
state_16724 = G__18172;
continue;
} else {
return ret_value__14403__auto__;
}
break;
}
});
cljs$core$async$state_machine__14402__auto__ = function(state_16724){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14402__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14402__auto____1.call(this,state_16724);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14402__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14402__auto____0;
cljs$core$async$state_machine__14402__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14402__auto____1;
return cljs$core$async$state_machine__14402__auto__;
})()
})();
var state__14556__auto__ = (function (){var statearr_16759 = f__14555__auto__();
(statearr_16759[(6)] = c__14553__auto___18159);

return statearr_16759;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14556__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16767 = (function (f,ch,meta16764,_,fn1,meta16768){
this.f = f;
this.ch = ch;
this.meta16764 = meta16764;
this._ = _;
this.fn1 = fn1;
this.meta16768 = meta16768;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async16767.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16769,meta16768__$1){
var self__ = this;
var _16769__$1 = this;
return (new cljs.core.async.t_cljs$core$async16767(self__.f,self__.ch,self__.meta16764,self__._,self__.fn1,meta16768__$1));
}));

(cljs.core.async.t_cljs$core$async16767.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16769){
var self__ = this;
var _16769__$1 = this;
return self__.meta16768;
}));

(cljs.core.async.t_cljs$core$async16767.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16767.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async16767.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async16767.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__16760_SHARP_){
var G__16786 = (((p1__16760_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__16760_SHARP_) : self__.f.call(null,p1__16760_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__16786) : f1.call(null,G__16786));
});
}));

(cljs.core.async.t_cljs$core$async16767.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16764","meta16764",-1376437546,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async16763","cljs.core.async/t_cljs$core$async16763",-917489548,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta16768","meta16768",477311017,null)], null);
}));

(cljs.core.async.t_cljs$core$async16767.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async16767.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16767");

(cljs.core.async.t_cljs$core$async16767.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async16767");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async16767.
 */
cljs.core.async.__GT_t_cljs$core$async16767 = (function cljs$core$async$__GT_t_cljs$core$async16767(f,ch,meta16764,_,fn1,meta16768){
return (new cljs.core.async.t_cljs$core$async16767(f,ch,meta16764,_,fn1,meta16768));
});



/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16763 = (function (f,ch,meta16764){
this.f = f;
this.ch = ch;
this.meta16764 = meta16764;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async16763.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16765,meta16764__$1){
var self__ = this;
var _16765__$1 = this;
return (new cljs.core.async.t_cljs$core$async16763(self__.f,self__.ch,meta16764__$1));
}));

(cljs.core.async.t_cljs$core$async16763.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16765){
var self__ = this;
var _16765__$1 = this;
return self__.meta16764;
}));

(cljs.core.async.t_cljs$core$async16763.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16763.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async16763.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async16763.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16763.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(new cljs.core.async.t_cljs$core$async16767(self__.f,self__.ch,self__.meta16764,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY)));
if(cljs.core.truth_((function (){var and__5000__auto__ = ret;
if(cljs.core.truth_(and__5000__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__5000__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__16790 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__16790) : self__.f.call(null,G__16790));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async16763.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16763.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async16763.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16764","meta16764",-1376437546,null)], null);
}));

(cljs.core.async.t_cljs$core$async16763.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async16763.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16763");

(cljs.core.async.t_cljs$core$async16763.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async16763");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async16763.
 */
cljs.core.async.__GT_t_cljs$core$async16763 = (function cljs$core$async$__GT_t_cljs$core$async16763(f,ch,meta16764){
return (new cljs.core.async.t_cljs$core$async16763(f,ch,meta16764));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
return (new cljs.core.async.t_cljs$core$async16763(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16798 = (function (f,ch,meta16799){
this.f = f;
this.ch = ch;
this.meta16799 = meta16799;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async16798.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16800,meta16799__$1){
var self__ = this;
var _16800__$1 = this;
return (new cljs.core.async.t_cljs$core$async16798(self__.f,self__.ch,meta16799__$1));
}));

(cljs.core.async.t_cljs$core$async16798.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16800){
var self__ = this;
var _16800__$1 = this;
return self__.meta16799;
}));

(cljs.core.async.t_cljs$core$async16798.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16798.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async16798.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16798.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async16798.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16798.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async16798.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16799","meta16799",1899190250,null)], null);
}));

(cljs.core.async.t_cljs$core$async16798.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async16798.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16798");

(cljs.core.async.t_cljs$core$async16798.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async16798");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async16798.
 */
cljs.core.async.__GT_t_cljs$core$async16798 = (function cljs$core$async$__GT_t_cljs$core$async16798(f,ch,meta16799){
return (new cljs.core.async.t_cljs$core$async16798(f,ch,meta16799));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
return (new cljs.core.async.t_cljs$core$async16798(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16820 = (function (p,ch,meta16821){
this.p = p;
this.ch = ch;
this.meta16821 = meta16821;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async16820.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16822,meta16821__$1){
var self__ = this;
var _16822__$1 = this;
return (new cljs.core.async.t_cljs$core$async16820(self__.p,self__.ch,meta16821__$1));
}));

(cljs.core.async.t_cljs$core$async16820.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16822){
var self__ = this;
var _16822__$1 = this;
return self__.meta16821;
}));

(cljs.core.async.t_cljs$core$async16820.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16820.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async16820.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async16820.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16820.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async16820.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16820.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async16820.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16821","meta16821",-1871937780,null)], null);
}));

(cljs.core.async.t_cljs$core$async16820.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async16820.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16820");

(cljs.core.async.t_cljs$core$async16820.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async16820");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async16820.
 */
cljs.core.async.__GT_t_cljs$core$async16820 = (function cljs$core$async$__GT_t_cljs$core$async16820(p,ch,meta16821){
return (new cljs.core.async.t_cljs$core$async16820(p,ch,meta16821));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
return (new cljs.core.async.t_cljs$core$async16820(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__16853 = arguments.length;
switch (G__16853) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__14553__auto___18182 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14555__auto__ = (function (){var switch__14401__auto__ = (function (state_16884){
var state_val_16885 = (state_16884[(1)]);
if((state_val_16885 === (7))){
var inst_16878 = (state_16884[(2)]);
var state_16884__$1 = state_16884;
var statearr_16892_18183 = state_16884__$1;
(statearr_16892_18183[(2)] = inst_16878);

(statearr_16892_18183[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16885 === (1))){
var state_16884__$1 = state_16884;
var statearr_16893_18184 = state_16884__$1;
(statearr_16893_18184[(2)] = null);

(statearr_16893_18184[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16885 === (4))){
var inst_16862 = (state_16884[(7)]);
var inst_16862__$1 = (state_16884[(2)]);
var inst_16863 = (inst_16862__$1 == null);
var state_16884__$1 = (function (){var statearr_16894 = state_16884;
(statearr_16894[(7)] = inst_16862__$1);

return statearr_16894;
})();
if(cljs.core.truth_(inst_16863)){
var statearr_16895_18187 = state_16884__$1;
(statearr_16895_18187[(1)] = (5));

} else {
var statearr_16896_18188 = state_16884__$1;
(statearr_16896_18188[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16885 === (6))){
var inst_16862 = (state_16884[(7)]);
var inst_16868 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_16862) : p.call(null,inst_16862));
var state_16884__$1 = state_16884;
if(cljs.core.truth_(inst_16868)){
var statearr_16902_18189 = state_16884__$1;
(statearr_16902_18189[(1)] = (8));

} else {
var statearr_16906_18190 = state_16884__$1;
(statearr_16906_18190[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16885 === (3))){
var inst_16882 = (state_16884[(2)]);
var state_16884__$1 = state_16884;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16884__$1,inst_16882);
} else {
if((state_val_16885 === (2))){
var state_16884__$1 = state_16884;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16884__$1,(4),ch);
} else {
if((state_val_16885 === (11))){
var inst_16872 = (state_16884[(2)]);
var state_16884__$1 = state_16884;
var statearr_16914_18191 = state_16884__$1;
(statearr_16914_18191[(2)] = inst_16872);

(statearr_16914_18191[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16885 === (9))){
var state_16884__$1 = state_16884;
var statearr_16915_18192 = state_16884__$1;
(statearr_16915_18192[(2)] = null);

(statearr_16915_18192[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16885 === (5))){
var inst_16865 = cljs.core.async.close_BANG_(out);
var state_16884__$1 = state_16884;
var statearr_16924_18193 = state_16884__$1;
(statearr_16924_18193[(2)] = inst_16865);

(statearr_16924_18193[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16885 === (10))){
var inst_16875 = (state_16884[(2)]);
var state_16884__$1 = (function (){var statearr_16929 = state_16884;
(statearr_16929[(8)] = inst_16875);

return statearr_16929;
})();
var statearr_16930_18195 = state_16884__$1;
(statearr_16930_18195[(2)] = null);

(statearr_16930_18195[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16885 === (8))){
var inst_16862 = (state_16884[(7)]);
var state_16884__$1 = state_16884;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16884__$1,(11),out,inst_16862);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__14402__auto__ = null;
var cljs$core$async$state_machine__14402__auto____0 = (function (){
var statearr_16936 = [null,null,null,null,null,null,null,null,null];
(statearr_16936[(0)] = cljs$core$async$state_machine__14402__auto__);

(statearr_16936[(1)] = (1));

return statearr_16936;
});
var cljs$core$async$state_machine__14402__auto____1 = (function (state_16884){
while(true){
var ret_value__14403__auto__ = (function (){try{while(true){
var result__14404__auto__ = switch__14401__auto__(state_16884);
if(cljs.core.keyword_identical_QMARK_(result__14404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14404__auto__;
}
break;
}
}catch (e16938){var ex__14405__auto__ = e16938;
var statearr_16939_18196 = state_16884;
(statearr_16939_18196[(2)] = ex__14405__auto__);


if(cljs.core.seq((state_16884[(4)]))){
var statearr_16943_18197 = state_16884;
(statearr_16943_18197[(1)] = cljs.core.first((state_16884[(4)])));

} else {
throw ex__14405__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18198 = state_16884;
state_16884 = G__18198;
continue;
} else {
return ret_value__14403__auto__;
}
break;
}
});
cljs$core$async$state_machine__14402__auto__ = function(state_16884){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14402__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14402__auto____1.call(this,state_16884);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14402__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14402__auto____0;
cljs$core$async$state_machine__14402__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14402__auto____1;
return cljs$core$async$state_machine__14402__auto__;
})()
})();
var state__14556__auto__ = (function (){var statearr_16944 = f__14555__auto__();
(statearr_16944[(6)] = c__14553__auto___18182);

return statearr_16944;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14556__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__16947 = arguments.length;
switch (G__16947) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__14553__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14555__auto__ = (function (){var switch__14401__auto__ = (function (state_17059){
var state_val_17060 = (state_17059[(1)]);
if((state_val_17060 === (7))){
var inst_17052 = (state_17059[(2)]);
var state_17059__$1 = state_17059;
var statearr_17069_18200 = state_17059__$1;
(statearr_17069_18200[(2)] = inst_17052);

(statearr_17069_18200[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17060 === (20))){
var inst_17014 = (state_17059[(7)]);
var inst_17032 = (state_17059[(2)]);
var inst_17033 = cljs.core.next(inst_17014);
var inst_16983 = inst_17033;
var inst_16984 = null;
var inst_16985 = (0);
var inst_16987 = (0);
var state_17059__$1 = (function (){var statearr_17073 = state_17059;
(statearr_17073[(8)] = inst_16985);

(statearr_17073[(9)] = inst_17032);

(statearr_17073[(10)] = inst_16983);

(statearr_17073[(11)] = inst_16984);

(statearr_17073[(12)] = inst_16987);

return statearr_17073;
})();
var statearr_17074_18201 = state_17059__$1;
(statearr_17074_18201[(2)] = null);

(statearr_17074_18201[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17060 === (1))){
var state_17059__$1 = state_17059;
var statearr_17075_18202 = state_17059__$1;
(statearr_17075_18202[(2)] = null);

(statearr_17075_18202[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17060 === (4))){
var inst_16969 = (state_17059[(13)]);
var inst_16969__$1 = (state_17059[(2)]);
var inst_16970 = (inst_16969__$1 == null);
var state_17059__$1 = (function (){var statearr_17080 = state_17059;
(statearr_17080[(13)] = inst_16969__$1);

return statearr_17080;
})();
if(cljs.core.truth_(inst_16970)){
var statearr_17081_18203 = state_17059__$1;
(statearr_17081_18203[(1)] = (5));

} else {
var statearr_17082_18204 = state_17059__$1;
(statearr_17082_18204[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17060 === (15))){
var state_17059__$1 = state_17059;
var statearr_17087_18205 = state_17059__$1;
(statearr_17087_18205[(2)] = null);

(statearr_17087_18205[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17060 === (21))){
var state_17059__$1 = state_17059;
var statearr_17088_18206 = state_17059__$1;
(statearr_17088_18206[(2)] = null);

(statearr_17088_18206[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17060 === (13))){
var inst_16985 = (state_17059[(8)]);
var inst_16983 = (state_17059[(10)]);
var inst_16984 = (state_17059[(11)]);
var inst_16987 = (state_17059[(12)]);
var inst_17006 = (state_17059[(2)]);
var inst_17007 = (inst_16987 + (1));
var tmp17084 = inst_16985;
var tmp17085 = inst_16983;
var tmp17086 = inst_16984;
var inst_16983__$1 = tmp17085;
var inst_16984__$1 = tmp17086;
var inst_16985__$1 = tmp17084;
var inst_16987__$1 = inst_17007;
var state_17059__$1 = (function (){var statearr_17090 = state_17059;
(statearr_17090[(8)] = inst_16985__$1);

(statearr_17090[(14)] = inst_17006);

(statearr_17090[(10)] = inst_16983__$1);

(statearr_17090[(11)] = inst_16984__$1);

(statearr_17090[(12)] = inst_16987__$1);

return statearr_17090;
})();
var statearr_17092_18207 = state_17059__$1;
(statearr_17092_18207[(2)] = null);

(statearr_17092_18207[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17060 === (22))){
var state_17059__$1 = state_17059;
var statearr_17093_18208 = state_17059__$1;
(statearr_17093_18208[(2)] = null);

(statearr_17093_18208[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17060 === (6))){
var inst_16969 = (state_17059[(13)]);
var inst_16979 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_16969) : f.call(null,inst_16969));
var inst_16980 = cljs.core.seq(inst_16979);
var inst_16983 = inst_16980;
var inst_16984 = null;
var inst_16985 = (0);
var inst_16987 = (0);
var state_17059__$1 = (function (){var statearr_17100 = state_17059;
(statearr_17100[(8)] = inst_16985);

(statearr_17100[(10)] = inst_16983);

(statearr_17100[(11)] = inst_16984);

(statearr_17100[(12)] = inst_16987);

return statearr_17100;
})();
var statearr_17101_18209 = state_17059__$1;
(statearr_17101_18209[(2)] = null);

(statearr_17101_18209[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17060 === (17))){
var inst_17014 = (state_17059[(7)]);
var inst_17019 = cljs.core.chunk_first(inst_17014);
var inst_17026 = cljs.core.chunk_rest(inst_17014);
var inst_17027 = cljs.core.count(inst_17019);
var inst_16983 = inst_17026;
var inst_16984 = inst_17019;
var inst_16985 = inst_17027;
var inst_16987 = (0);
var state_17059__$1 = (function (){var statearr_17102 = state_17059;
(statearr_17102[(8)] = inst_16985);

(statearr_17102[(10)] = inst_16983);

(statearr_17102[(11)] = inst_16984);

(statearr_17102[(12)] = inst_16987);

return statearr_17102;
})();
var statearr_17105_18210 = state_17059__$1;
(statearr_17105_18210[(2)] = null);

(statearr_17105_18210[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17060 === (3))){
var inst_17054 = (state_17059[(2)]);
var state_17059__$1 = state_17059;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17059__$1,inst_17054);
} else {
if((state_val_17060 === (12))){
var inst_17041 = (state_17059[(2)]);
var state_17059__$1 = state_17059;
var statearr_17106_18211 = state_17059__$1;
(statearr_17106_18211[(2)] = inst_17041);

(statearr_17106_18211[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17060 === (2))){
var state_17059__$1 = state_17059;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17059__$1,(4),in$);
} else {
if((state_val_17060 === (23))){
var inst_17050 = (state_17059[(2)]);
var state_17059__$1 = state_17059;
var statearr_17107_18212 = state_17059__$1;
(statearr_17107_18212[(2)] = inst_17050);

(statearr_17107_18212[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17060 === (19))){
var inst_17036 = (state_17059[(2)]);
var state_17059__$1 = state_17059;
var statearr_17108_18213 = state_17059__$1;
(statearr_17108_18213[(2)] = inst_17036);

(statearr_17108_18213[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17060 === (11))){
var inst_16983 = (state_17059[(10)]);
var inst_17014 = (state_17059[(7)]);
var inst_17014__$1 = cljs.core.seq(inst_16983);
var state_17059__$1 = (function (){var statearr_17109 = state_17059;
(statearr_17109[(7)] = inst_17014__$1);

return statearr_17109;
})();
if(inst_17014__$1){
var statearr_17110_18214 = state_17059__$1;
(statearr_17110_18214[(1)] = (14));

} else {
var statearr_17112_18215 = state_17059__$1;
(statearr_17112_18215[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17060 === (9))){
var inst_17044 = (state_17059[(2)]);
var inst_17045 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_17059__$1 = (function (){var statearr_17113 = state_17059;
(statearr_17113[(15)] = inst_17044);

return statearr_17113;
})();
if(cljs.core.truth_(inst_17045)){
var statearr_17114_18216 = state_17059__$1;
(statearr_17114_18216[(1)] = (21));

} else {
var statearr_17118_18217 = state_17059__$1;
(statearr_17118_18217[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17060 === (5))){
var inst_16972 = cljs.core.async.close_BANG_(out);
var state_17059__$1 = state_17059;
var statearr_17119_18218 = state_17059__$1;
(statearr_17119_18218[(2)] = inst_16972);

(statearr_17119_18218[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17060 === (14))){
var inst_17014 = (state_17059[(7)]);
var inst_17017 = cljs.core.chunked_seq_QMARK_(inst_17014);
var state_17059__$1 = state_17059;
if(inst_17017){
var statearr_17120_18219 = state_17059__$1;
(statearr_17120_18219[(1)] = (17));

} else {
var statearr_17122_18220 = state_17059__$1;
(statearr_17122_18220[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17060 === (16))){
var inst_17039 = (state_17059[(2)]);
var state_17059__$1 = state_17059;
var statearr_17124_18221 = state_17059__$1;
(statearr_17124_18221[(2)] = inst_17039);

(statearr_17124_18221[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17060 === (10))){
var inst_16984 = (state_17059[(11)]);
var inst_16987 = (state_17059[(12)]);
var inst_17004 = cljs.core._nth(inst_16984,inst_16987);
var state_17059__$1 = state_17059;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17059__$1,(13),out,inst_17004);
} else {
if((state_val_17060 === (18))){
var inst_17014 = (state_17059[(7)]);
var inst_17030 = cljs.core.first(inst_17014);
var state_17059__$1 = state_17059;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17059__$1,(20),out,inst_17030);
} else {
if((state_val_17060 === (8))){
var inst_16985 = (state_17059[(8)]);
var inst_16987 = (state_17059[(12)]);
var inst_16989 = (inst_16987 < inst_16985);
var inst_16990 = inst_16989;
var state_17059__$1 = state_17059;
if(cljs.core.truth_(inst_16990)){
var statearr_17125_18222 = state_17059__$1;
(statearr_17125_18222[(1)] = (10));

} else {
var statearr_17126_18223 = state_17059__$1;
(statearr_17126_18223[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__14402__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__14402__auto____0 = (function (){
var statearr_17127 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17127[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__14402__auto__);

(statearr_17127[(1)] = (1));

return statearr_17127;
});
var cljs$core$async$mapcat_STAR__$_state_machine__14402__auto____1 = (function (state_17059){
while(true){
var ret_value__14403__auto__ = (function (){try{while(true){
var result__14404__auto__ = switch__14401__auto__(state_17059);
if(cljs.core.keyword_identical_QMARK_(result__14404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14404__auto__;
}
break;
}
}catch (e17128){var ex__14405__auto__ = e17128;
var statearr_17129_18224 = state_17059;
(statearr_17129_18224[(2)] = ex__14405__auto__);


if(cljs.core.seq((state_17059[(4)]))){
var statearr_17130_18225 = state_17059;
(statearr_17130_18225[(1)] = cljs.core.first((state_17059[(4)])));

} else {
throw ex__14405__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18226 = state_17059;
state_17059 = G__18226;
continue;
} else {
return ret_value__14403__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__14402__auto__ = function(state_17059){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__14402__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__14402__auto____1.call(this,state_17059);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__14402__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__14402__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__14402__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__14402__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__14402__auto__;
})()
})();
var state__14556__auto__ = (function (){var statearr_17131 = f__14555__auto__();
(statearr_17131[(6)] = c__14553__auto__);

return statearr_17131;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14556__auto__);
}));

return c__14553__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__17137 = arguments.length;
switch (G__17137) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__17154 = arguments.length;
switch (G__17154) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__17185 = arguments.length;
switch (G__17185) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__14553__auto___18230 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14555__auto__ = (function (){var switch__14401__auto__ = (function (state_17221){
var state_val_17223 = (state_17221[(1)]);
if((state_val_17223 === (7))){
var inst_17216 = (state_17221[(2)]);
var state_17221__$1 = state_17221;
var statearr_17228_18235 = state_17221__$1;
(statearr_17228_18235[(2)] = inst_17216);

(statearr_17228_18235[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17223 === (1))){
var inst_17193 = null;
var state_17221__$1 = (function (){var statearr_17231 = state_17221;
(statearr_17231[(7)] = inst_17193);

return statearr_17231;
})();
var statearr_17232_18237 = state_17221__$1;
(statearr_17232_18237[(2)] = null);

(statearr_17232_18237[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17223 === (4))){
var inst_17197 = (state_17221[(8)]);
var inst_17197__$1 = (state_17221[(2)]);
var inst_17201 = (inst_17197__$1 == null);
var inst_17202 = cljs.core.not(inst_17201);
var state_17221__$1 = (function (){var statearr_17234 = state_17221;
(statearr_17234[(8)] = inst_17197__$1);

return statearr_17234;
})();
if(inst_17202){
var statearr_17237_18238 = state_17221__$1;
(statearr_17237_18238[(1)] = (5));

} else {
var statearr_17239_18239 = state_17221__$1;
(statearr_17239_18239[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17223 === (6))){
var state_17221__$1 = state_17221;
var statearr_17240_18240 = state_17221__$1;
(statearr_17240_18240[(2)] = null);

(statearr_17240_18240[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17223 === (3))){
var inst_17218 = (state_17221[(2)]);
var inst_17219 = cljs.core.async.close_BANG_(out);
var state_17221__$1 = (function (){var statearr_17244 = state_17221;
(statearr_17244[(9)] = inst_17218);

return statearr_17244;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_17221__$1,inst_17219);
} else {
if((state_val_17223 === (2))){
var state_17221__$1 = state_17221;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17221__$1,(4),ch);
} else {
if((state_val_17223 === (11))){
var inst_17197 = (state_17221[(8)]);
var inst_17210 = (state_17221[(2)]);
var inst_17193 = inst_17197;
var state_17221__$1 = (function (){var statearr_17248 = state_17221;
(statearr_17248[(10)] = inst_17210);

(statearr_17248[(7)] = inst_17193);

return statearr_17248;
})();
var statearr_17254_18241 = state_17221__$1;
(statearr_17254_18241[(2)] = null);

(statearr_17254_18241[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17223 === (9))){
var inst_17197 = (state_17221[(8)]);
var state_17221__$1 = state_17221;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17221__$1,(11),out,inst_17197);
} else {
if((state_val_17223 === (5))){
var inst_17197 = (state_17221[(8)]);
var inst_17193 = (state_17221[(7)]);
var inst_17205 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_17197,inst_17193);
var state_17221__$1 = state_17221;
if(inst_17205){
var statearr_17263_18243 = state_17221__$1;
(statearr_17263_18243[(1)] = (8));

} else {
var statearr_17264_18244 = state_17221__$1;
(statearr_17264_18244[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17223 === (10))){
var inst_17213 = (state_17221[(2)]);
var state_17221__$1 = state_17221;
var statearr_17267_18245 = state_17221__$1;
(statearr_17267_18245[(2)] = inst_17213);

(statearr_17267_18245[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17223 === (8))){
var inst_17193 = (state_17221[(7)]);
var tmp17258 = inst_17193;
var inst_17193__$1 = tmp17258;
var state_17221__$1 = (function (){var statearr_17269 = state_17221;
(statearr_17269[(7)] = inst_17193__$1);

return statearr_17269;
})();
var statearr_17272_18247 = state_17221__$1;
(statearr_17272_18247[(2)] = null);

(statearr_17272_18247[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__14402__auto__ = null;
var cljs$core$async$state_machine__14402__auto____0 = (function (){
var statearr_17276 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17276[(0)] = cljs$core$async$state_machine__14402__auto__);

(statearr_17276[(1)] = (1));

return statearr_17276;
});
var cljs$core$async$state_machine__14402__auto____1 = (function (state_17221){
while(true){
var ret_value__14403__auto__ = (function (){try{while(true){
var result__14404__auto__ = switch__14401__auto__(state_17221);
if(cljs.core.keyword_identical_QMARK_(result__14404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14404__auto__;
}
break;
}
}catch (e17278){var ex__14405__auto__ = e17278;
var statearr_17280_18248 = state_17221;
(statearr_17280_18248[(2)] = ex__14405__auto__);


if(cljs.core.seq((state_17221[(4)]))){
var statearr_17281_18249 = state_17221;
(statearr_17281_18249[(1)] = cljs.core.first((state_17221[(4)])));

} else {
throw ex__14405__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18250 = state_17221;
state_17221 = G__18250;
continue;
} else {
return ret_value__14403__auto__;
}
break;
}
});
cljs$core$async$state_machine__14402__auto__ = function(state_17221){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14402__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14402__auto____1.call(this,state_17221);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14402__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14402__auto____0;
cljs$core$async$state_machine__14402__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14402__auto____1;
return cljs$core$async$state_machine__14402__auto__;
})()
})();
var state__14556__auto__ = (function (){var statearr_17286 = f__14555__auto__();
(statearr_17286[(6)] = c__14553__auto___18230);

return statearr_17286;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14556__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__17297 = arguments.length;
switch (G__17297) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__14553__auto___18256 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14555__auto__ = (function (){var switch__14401__auto__ = (function (state_17362){
var state_val_17363 = (state_17362[(1)]);
if((state_val_17363 === (7))){
var inst_17355 = (state_17362[(2)]);
var state_17362__$1 = state_17362;
var statearr_17369_18257 = state_17362__$1;
(statearr_17369_18257[(2)] = inst_17355);

(statearr_17369_18257[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17363 === (1))){
var inst_17316 = (new Array(n));
var inst_17317 = inst_17316;
var inst_17318 = (0);
var state_17362__$1 = (function (){var statearr_17371 = state_17362;
(statearr_17371[(7)] = inst_17318);

(statearr_17371[(8)] = inst_17317);

return statearr_17371;
})();
var statearr_17372_18262 = state_17362__$1;
(statearr_17372_18262[(2)] = null);

(statearr_17372_18262[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17363 === (4))){
var inst_17322 = (state_17362[(9)]);
var inst_17322__$1 = (state_17362[(2)]);
var inst_17324 = (inst_17322__$1 == null);
var inst_17325 = cljs.core.not(inst_17324);
var state_17362__$1 = (function (){var statearr_17376 = state_17362;
(statearr_17376[(9)] = inst_17322__$1);

return statearr_17376;
})();
if(inst_17325){
var statearr_17377_18265 = state_17362__$1;
(statearr_17377_18265[(1)] = (5));

} else {
var statearr_17378_18266 = state_17362__$1;
(statearr_17378_18266[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17363 === (15))){
var inst_17349 = (state_17362[(2)]);
var state_17362__$1 = state_17362;
var statearr_17380_18267 = state_17362__$1;
(statearr_17380_18267[(2)] = inst_17349);

(statearr_17380_18267[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17363 === (13))){
var state_17362__$1 = state_17362;
var statearr_17384_18268 = state_17362__$1;
(statearr_17384_18268[(2)] = null);

(statearr_17384_18268[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17363 === (6))){
var inst_17318 = (state_17362[(7)]);
var inst_17345 = (inst_17318 > (0));
var state_17362__$1 = state_17362;
if(cljs.core.truth_(inst_17345)){
var statearr_17386_18269 = state_17362__$1;
(statearr_17386_18269[(1)] = (12));

} else {
var statearr_17387_18270 = state_17362__$1;
(statearr_17387_18270[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17363 === (3))){
var inst_17358 = (state_17362[(2)]);
var state_17362__$1 = state_17362;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17362__$1,inst_17358);
} else {
if((state_val_17363 === (12))){
var inst_17317 = (state_17362[(8)]);
var inst_17347 = cljs.core.vec(inst_17317);
var state_17362__$1 = state_17362;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17362__$1,(15),out,inst_17347);
} else {
if((state_val_17363 === (2))){
var state_17362__$1 = state_17362;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17362__$1,(4),ch);
} else {
if((state_val_17363 === (11))){
var inst_17336 = (state_17362[(2)]);
var inst_17340 = (new Array(n));
var inst_17317 = inst_17340;
var inst_17318 = (0);
var state_17362__$1 = (function (){var statearr_17395 = state_17362;
(statearr_17395[(10)] = inst_17336);

(statearr_17395[(7)] = inst_17318);

(statearr_17395[(8)] = inst_17317);

return statearr_17395;
})();
var statearr_17396_18271 = state_17362__$1;
(statearr_17396_18271[(2)] = null);

(statearr_17396_18271[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17363 === (9))){
var inst_17317 = (state_17362[(8)]);
var inst_17334 = cljs.core.vec(inst_17317);
var state_17362__$1 = state_17362;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17362__$1,(11),out,inst_17334);
} else {
if((state_val_17363 === (5))){
var inst_17329 = (state_17362[(11)]);
var inst_17318 = (state_17362[(7)]);
var inst_17317 = (state_17362[(8)]);
var inst_17322 = (state_17362[(9)]);
var inst_17328 = (inst_17317[inst_17318] = inst_17322);
var inst_17329__$1 = (inst_17318 + (1));
var inst_17330 = (inst_17329__$1 < n);
var state_17362__$1 = (function (){var statearr_17401 = state_17362;
(statearr_17401[(11)] = inst_17329__$1);

(statearr_17401[(12)] = inst_17328);

return statearr_17401;
})();
if(cljs.core.truth_(inst_17330)){
var statearr_17402_18276 = state_17362__$1;
(statearr_17402_18276[(1)] = (8));

} else {
var statearr_17405_18277 = state_17362__$1;
(statearr_17405_18277[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17363 === (14))){
var inst_17352 = (state_17362[(2)]);
var inst_17353 = cljs.core.async.close_BANG_(out);
var state_17362__$1 = (function (){var statearr_17408 = state_17362;
(statearr_17408[(13)] = inst_17352);

return statearr_17408;
})();
var statearr_17410_18279 = state_17362__$1;
(statearr_17410_18279[(2)] = inst_17353);

(statearr_17410_18279[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17363 === (10))){
var inst_17343 = (state_17362[(2)]);
var state_17362__$1 = state_17362;
var statearr_17411_18280 = state_17362__$1;
(statearr_17411_18280[(2)] = inst_17343);

(statearr_17411_18280[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17363 === (8))){
var inst_17329 = (state_17362[(11)]);
var inst_17317 = (state_17362[(8)]);
var tmp17407 = inst_17317;
var inst_17317__$1 = tmp17407;
var inst_17318 = inst_17329;
var state_17362__$1 = (function (){var statearr_17415 = state_17362;
(statearr_17415[(7)] = inst_17318);

(statearr_17415[(8)] = inst_17317__$1);

return statearr_17415;
})();
var statearr_17416_18281 = state_17362__$1;
(statearr_17416_18281[(2)] = null);

(statearr_17416_18281[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__14402__auto__ = null;
var cljs$core$async$state_machine__14402__auto____0 = (function (){
var statearr_17424 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17424[(0)] = cljs$core$async$state_machine__14402__auto__);

(statearr_17424[(1)] = (1));

return statearr_17424;
});
var cljs$core$async$state_machine__14402__auto____1 = (function (state_17362){
while(true){
var ret_value__14403__auto__ = (function (){try{while(true){
var result__14404__auto__ = switch__14401__auto__(state_17362);
if(cljs.core.keyword_identical_QMARK_(result__14404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14404__auto__;
}
break;
}
}catch (e17426){var ex__14405__auto__ = e17426;
var statearr_17427_18282 = state_17362;
(statearr_17427_18282[(2)] = ex__14405__auto__);


if(cljs.core.seq((state_17362[(4)]))){
var statearr_17429_18283 = state_17362;
(statearr_17429_18283[(1)] = cljs.core.first((state_17362[(4)])));

} else {
throw ex__14405__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18284 = state_17362;
state_17362 = G__18284;
continue;
} else {
return ret_value__14403__auto__;
}
break;
}
});
cljs$core$async$state_machine__14402__auto__ = function(state_17362){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14402__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14402__auto____1.call(this,state_17362);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14402__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14402__auto____0;
cljs$core$async$state_machine__14402__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14402__auto____1;
return cljs$core$async$state_machine__14402__auto__;
})()
})();
var state__14556__auto__ = (function (){var statearr_17440 = f__14555__auto__();
(statearr_17440[(6)] = c__14553__auto___18256);

return statearr_17440;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14556__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__17472 = arguments.length;
switch (G__17472) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__14553__auto___18286 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14555__auto__ = (function (){var switch__14401__auto__ = (function (state_17532){
var state_val_17534 = (state_17532[(1)]);
if((state_val_17534 === (7))){
var inst_17526 = (state_17532[(2)]);
var state_17532__$1 = state_17532;
var statearr_17543_18287 = state_17532__$1;
(statearr_17543_18287[(2)] = inst_17526);

(statearr_17543_18287[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17534 === (1))){
var inst_17482 = [];
var inst_17483 = inst_17482;
var inst_17484 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_17532__$1 = (function (){var statearr_17548 = state_17532;
(statearr_17548[(7)] = inst_17484);

(statearr_17548[(8)] = inst_17483);

return statearr_17548;
})();
var statearr_17549_18288 = state_17532__$1;
(statearr_17549_18288[(2)] = null);

(statearr_17549_18288[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17534 === (4))){
var inst_17487 = (state_17532[(9)]);
var inst_17487__$1 = (state_17532[(2)]);
var inst_17488 = (inst_17487__$1 == null);
var inst_17489 = cljs.core.not(inst_17488);
var state_17532__$1 = (function (){var statearr_17555 = state_17532;
(statearr_17555[(9)] = inst_17487__$1);

return statearr_17555;
})();
if(inst_17489){
var statearr_17556_18290 = state_17532__$1;
(statearr_17556_18290[(1)] = (5));

} else {
var statearr_17558_18291 = state_17532__$1;
(statearr_17558_18291[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17534 === (15))){
var inst_17483 = (state_17532[(8)]);
var inst_17518 = cljs.core.vec(inst_17483);
var state_17532__$1 = state_17532;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17532__$1,(18),out,inst_17518);
} else {
if((state_val_17534 === (13))){
var inst_17513 = (state_17532[(2)]);
var state_17532__$1 = state_17532;
var statearr_17562_18293 = state_17532__$1;
(statearr_17562_18293[(2)] = inst_17513);

(statearr_17562_18293[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17534 === (6))){
var inst_17483 = (state_17532[(8)]);
var inst_17515 = inst_17483.length;
var inst_17516 = (inst_17515 > (0));
var state_17532__$1 = state_17532;
if(cljs.core.truth_(inst_17516)){
var statearr_17564_18301 = state_17532__$1;
(statearr_17564_18301[(1)] = (15));

} else {
var statearr_17567_18302 = state_17532__$1;
(statearr_17567_18302[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17534 === (17))){
var inst_17523 = (state_17532[(2)]);
var inst_17524 = cljs.core.async.close_BANG_(out);
var state_17532__$1 = (function (){var statearr_17572 = state_17532;
(statearr_17572[(10)] = inst_17523);

return statearr_17572;
})();
var statearr_17574_18303 = state_17532__$1;
(statearr_17574_18303[(2)] = inst_17524);

(statearr_17574_18303[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17534 === (3))){
var inst_17528 = (state_17532[(2)]);
var state_17532__$1 = state_17532;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17532__$1,inst_17528);
} else {
if((state_val_17534 === (12))){
var inst_17483 = (state_17532[(8)]);
var inst_17505 = cljs.core.vec(inst_17483);
var state_17532__$1 = state_17532;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17532__$1,(14),out,inst_17505);
} else {
if((state_val_17534 === (2))){
var state_17532__$1 = state_17532;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17532__$1,(4),ch);
} else {
if((state_val_17534 === (11))){
var inst_17487 = (state_17532[(9)]);
var inst_17492 = (state_17532[(11)]);
var inst_17483 = (state_17532[(8)]);
var inst_17502 = inst_17483.push(inst_17487);
var tmp17578 = inst_17483;
var inst_17483__$1 = tmp17578;
var inst_17484 = inst_17492;
var state_17532__$1 = (function (){var statearr_17584 = state_17532;
(statearr_17584[(7)] = inst_17484);

(statearr_17584[(8)] = inst_17483__$1);

(statearr_17584[(12)] = inst_17502);

return statearr_17584;
})();
var statearr_17587_18304 = state_17532__$1;
(statearr_17587_18304[(2)] = null);

(statearr_17587_18304[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17534 === (9))){
var inst_17484 = (state_17532[(7)]);
var inst_17498 = cljs.core.keyword_identical_QMARK_(inst_17484,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_17532__$1 = state_17532;
var statearr_17590_18305 = state_17532__$1;
(statearr_17590_18305[(2)] = inst_17498);

(statearr_17590_18305[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17534 === (5))){
var inst_17487 = (state_17532[(9)]);
var inst_17495 = (state_17532[(13)]);
var inst_17484 = (state_17532[(7)]);
var inst_17492 = (state_17532[(11)]);
var inst_17492__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_17487) : f.call(null,inst_17487));
var inst_17495__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_17492__$1,inst_17484);
var state_17532__$1 = (function (){var statearr_17596 = state_17532;
(statearr_17596[(13)] = inst_17495__$1);

(statearr_17596[(11)] = inst_17492__$1);

return statearr_17596;
})();
if(inst_17495__$1){
var statearr_17597_18306 = state_17532__$1;
(statearr_17597_18306[(1)] = (8));

} else {
var statearr_17600_18307 = state_17532__$1;
(statearr_17600_18307[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17534 === (14))){
var inst_17487 = (state_17532[(9)]);
var inst_17492 = (state_17532[(11)]);
var inst_17507 = (state_17532[(2)]);
var inst_17508 = [];
var inst_17510 = inst_17508.push(inst_17487);
var inst_17483 = inst_17508;
var inst_17484 = inst_17492;
var state_17532__$1 = (function (){var statearr_17604 = state_17532;
(statearr_17604[(7)] = inst_17484);

(statearr_17604[(14)] = inst_17507);

(statearr_17604[(15)] = inst_17510);

(statearr_17604[(8)] = inst_17483);

return statearr_17604;
})();
var statearr_17607_18308 = state_17532__$1;
(statearr_17607_18308[(2)] = null);

(statearr_17607_18308[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17534 === (16))){
var state_17532__$1 = state_17532;
var statearr_17610_18309 = state_17532__$1;
(statearr_17610_18309[(2)] = null);

(statearr_17610_18309[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17534 === (10))){
var inst_17500 = (state_17532[(2)]);
var state_17532__$1 = state_17532;
if(cljs.core.truth_(inst_17500)){
var statearr_17612_18310 = state_17532__$1;
(statearr_17612_18310[(1)] = (11));

} else {
var statearr_17614_18311 = state_17532__$1;
(statearr_17614_18311[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17534 === (18))){
var inst_17520 = (state_17532[(2)]);
var state_17532__$1 = state_17532;
var statearr_17615_18312 = state_17532__$1;
(statearr_17615_18312[(2)] = inst_17520);

(statearr_17615_18312[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17534 === (8))){
var inst_17495 = (state_17532[(13)]);
var state_17532__$1 = state_17532;
var statearr_17619_18313 = state_17532__$1;
(statearr_17619_18313[(2)] = inst_17495);

(statearr_17619_18313[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__14402__auto__ = null;
var cljs$core$async$state_machine__14402__auto____0 = (function (){
var statearr_17623 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17623[(0)] = cljs$core$async$state_machine__14402__auto__);

(statearr_17623[(1)] = (1));

return statearr_17623;
});
var cljs$core$async$state_machine__14402__auto____1 = (function (state_17532){
while(true){
var ret_value__14403__auto__ = (function (){try{while(true){
var result__14404__auto__ = switch__14401__auto__(state_17532);
if(cljs.core.keyword_identical_QMARK_(result__14404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14404__auto__;
}
break;
}
}catch (e17624){var ex__14405__auto__ = e17624;
var statearr_17627_18314 = state_17532;
(statearr_17627_18314[(2)] = ex__14405__auto__);


if(cljs.core.seq((state_17532[(4)]))){
var statearr_17628_18315 = state_17532;
(statearr_17628_18315[(1)] = cljs.core.first((state_17532[(4)])));

} else {
throw ex__14405__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18317 = state_17532;
state_17532 = G__18317;
continue;
} else {
return ret_value__14403__auto__;
}
break;
}
});
cljs$core$async$state_machine__14402__auto__ = function(state_17532){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14402__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14402__auto____1.call(this,state_17532);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14402__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14402__auto____0;
cljs$core$async$state_machine__14402__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14402__auto____1;
return cljs$core$async$state_machine__14402__auto__;
})()
})();
var state__14556__auto__ = (function (){var statearr_17629 = f__14555__auto__();
(statearr_17629[(6)] = c__14553__auto___18286);

return statearr_17629;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14556__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
