goog.provide('atlas_ui_v3.core');
if((typeof atlas_ui_v3 !== 'undefined') && (typeof atlas_ui_v3.core !== 'undefined') && (typeof atlas_ui_v3.core.app_state !== 'undefined')){
} else {
atlas_ui_v3.core.app_state = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"registry","registry",1021159018),null,new cljs.core.Keyword(null,"loading?","loading?",1905707049),true,new cljs.core.Keyword(null,"error","error",-978969032),null,new cljs.core.Keyword(null,"filter-path","filter-path",2004323865),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"auth-required?","auth-required?",-1511931840),false,new cljs.core.Keyword(null,"username","username",1605666410),"",new cljs.core.Keyword(null,"password","password",417022471),""], null));
}
atlas_ui_v3.core.namespace_colors = cljs.core.PersistentHashMap.fromArrays(["security","atlas","wrap","operation","scope","domain","effect","compliance","tier","observability","entity","default"],["#ef4a4a","#aaaaaa","#7a4aef","#ef4a9d","#4a7aef","#4a9eff","#ef9d4a","#4aef7a","#9d4aef","#7aef4a","#ef7a4a","#6a6a8a"]);
atlas_ui_v3.core.namespace_color = (function atlas_ui_v3$core$namespace_color(aspect_kw){
var ns_name = cljs.core.namespace(aspect_kw);
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(atlas_ui_v3.core.namespace_colors,ns_name,new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(atlas_ui_v3.core.namespace_colors));
});
/**
 * Count how many entities have each aspect.
 * Returns map of {aspect-kw count}
 */
atlas_ui_v3.core.count_entities_by_aspect = (function atlas_ui_v3$core$count_entities_by_aspect(registry){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__22764){
var vec__22765 = p__22764;
var identity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22765,(0),null);
var _props = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22765,(1),null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc2,aspect){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc2,aspect,cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.inc,(0)));
}),acc,identity);
}),cljs.core.PersistentArrayMap.EMPTY,registry);
});
/**
 * Filter registry to entities containing ALL aspects in aspect-set
 */
atlas_ui_v3.core.filter_entities_by_aspects = (function atlas_ui_v3$core$filter_entities_by_aspects(registry,aspect_set){
if(cljs.core.empty_QMARK_(aspect_set)){
return registry;
} else {
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p__22769){
var vec__22770 = p__22769;
var identity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22770,(0),null);
var _props = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22770,(1),null);
return cljs.core.every_QMARK_((function (p1__22768_SHARP_){
return cljs.core.contains_QMARK_(identity,p1__22768_SHARP_);
}),aspect_set);
}),registry);
}
});
/**
 * Get top N aspects by entity count from filtered registry
 */
atlas_ui_v3.core.top_n_aspects = (function atlas_ui_v3$core$top_n_aspects(registry,aspect_filter,n){
var filtered = atlas_ui_v3.core.filter_entities_by_aspects(registry,aspect_filter);
var counts = atlas_ui_v3.core.count_entities_by_aspect(filtered);
var available_counts = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,counts,aspect_filter);
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(cljs.core.val,cljs.core._GT_,available_counts));
});
/**
 * Calculate rectangle positions for treemap layout.
 * Simple row-based layout: fill rows left-to-right, top-to-bottom
 */
atlas_ui_v3.core.calculate_treemap_rects = (function atlas_ui_v3$core$calculate_treemap_rects(aspects,width,height){
var total = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.second,aspects));
var aspect_data = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__22773){
var vec__22774 = p__22773;
var aspect = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22774,(0),null);
var count = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22774,(1),null);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"aspect","aspect",-839905246),aspect,new cljs.core.Keyword(null,"count","count",2139924085),count,new cljs.core.Keyword(null,"percentage","percentage",-1610213650),(count / total)], null);
}),aspects);
var rects = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (data){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(data,new cljs.core.Keyword(null,"width","width",-384071477),(width * new cljs.core.Keyword(null,"percentage","percentage",-1610213650).cljs$core$IFn$_invoke$arity$1(data)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"height","height",1025178622),(height / (2))], 0));
}),aspect_data);
var positioned = (function (){var remaining = rects;
var positioned = cljs.core.PersistentVector.EMPTY;
var x = (0);
var y = (0);
var row_width = (0);
var row_height = (height / (2));
while(true){
if(cljs.core.empty_QMARK_(remaining)){
return positioned;
} else {
var rect = cljs.core.first(remaining);
var new_x = ((((row_width + new cljs.core.Keyword(null,"width","width",-384071477).cljs$core$IFn$_invoke$arity$1(rect)) > width))?(0):x);
var new_y = ((((row_width + new cljs.core.Keyword(null,"width","width",-384071477).cljs$core$IFn$_invoke$arity$1(rect)) > width))?(y + row_height):y);
var new_row_width = ((((row_width + new cljs.core.Keyword(null,"width","width",-384071477).cljs$core$IFn$_invoke$arity$1(rect)) > width))?new cljs.core.Keyword(null,"width","width",-384071477).cljs$core$IFn$_invoke$arity$1(rect):(row_width + new cljs.core.Keyword(null,"width","width",-384071477).cljs$core$IFn$_invoke$arity$1(rect)));
var G__22816 = cljs.core.rest(remaining);
var G__22817 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(positioned,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(rect,new cljs.core.Keyword(null,"x","x",2099068185),new_x,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776),new_y], 0)));
var G__22818 = (new_x + new cljs.core.Keyword(null,"width","width",-384071477).cljs$core$IFn$_invoke$arity$1(rect));
var G__22819 = new_y;
var G__22820 = new_row_width;
var G__22821 = row_height;
remaining = G__22816;
positioned = G__22817;
x = G__22818;
y = G__22819;
row_width = G__22820;
row_height = G__22821;
continue;
}
break;
}
})();
return positioned;
});
atlas_ui_v3.core.breadcrumb = (function atlas_ui_v3$core$breadcrumb(){
var filter_path = new cljs.core.Keyword(null,"filter-path","filter-path",2004323865).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui_v3.core.app_state));
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"padding","padding",1660304693),"1rem",new cljs.core.Keyword(null,"background","background",-863952629),"#1a1a2e",new cljs.core.Keyword(null,"color","color",1011675173),"#eee",new cljs.core.Keyword(null,"border-bottom","border-bottom",2110948415),"1px solid #333",new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"gap","gap",80255254),"0.5rem",new cljs.core.Keyword(null,"align-items","align-items",-267946462),"center",new cljs.core.Keyword(null,"flex-wrap","flex-wrap",455413707),"wrap"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"font-weight","font-weight",2085804583),"bold",new cljs.core.Keyword(null,"color","color",1011675173),"#8a8aaa"], null)], null),"Filter path:"], null),((cljs.core.empty_QMARK_(filter_path))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"color","color",1011675173),"#6a6a8a",new cljs.core.Keyword(null,"font-style","font-style",-773672352),"italic"], null)], null),"(none - showing all)"], null):(function (){var iter__5480__auto__ = (function atlas_ui_v3$core$breadcrumb_$_iter__22779(s__22780){
return (new cljs.core.LazySeq(null,(function (){
var s__22780__$1 = s__22780;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__22780__$1);
if(temp__5804__auto__){
var s__22780__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__22780__$2)){
var c__5478__auto__ = cljs.core.chunk_first(s__22780__$2);
var size__5479__auto__ = cljs.core.count(c__5478__auto__);
var b__22782 = cljs.core.chunk_buffer(size__5479__auto__);
if((function (){var i__22781 = (0);
while(true){
if((i__22781 < size__5479__auto__)){
var vec__22783 = cljs.core._nth(c__5478__auto__,i__22781);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22783,(0),null);
var aspect = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22783,(1),null);
cljs.core.chunk_append(b__22782,cljs.core.with_meta(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"gap","gap",80255254),"0.5rem",new cljs.core.Keyword(null,"align-items","align-items",-267946462),"center"], null)], null),(((idx > (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"color","color",1011675173),"#555"], null)], null),"\u2192"], null):null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (i__22781,vec__22783,idx,aspect,c__5478__auto__,size__5479__auto__,b__22782,s__22780__$2,temp__5804__auto__,filter_path){
return (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(atlas_ui_v3.core.app_state,cljs.core.assoc,new cljs.core.Keyword(null,"filter-path","filter-path",2004323865),cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2((idx + (1)),filter_path)));
});})(i__22781,vec__22783,idx,aspect,c__5478__auto__,size__5479__auto__,b__22782,s__22780__$2,temp__5804__auto__,filter_path))
,new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"padding","padding",1660304693),"0.3rem 0.6rem",new cljs.core.Keyword(null,"background","background",-863952629),atlas_ui_v3.core.namespace_color(aspect),new cljs.core.Keyword(null,"border-radius","border-radius",419594011),"4px",new cljs.core.Keyword(null,"cursor","cursor",1011937484),"pointer",new cljs.core.Keyword(null,"font-family","font-family",-667419874),"monospace",new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"0.9rem",new cljs.core.Keyword(null,"transition","transition",765692007),"opacity 0.2s",new cljs.core.Keyword(null,"opacity","opacity",397153780),(1)], null),new cljs.core.Keyword(null,"on-mouse-over","on-mouse-over",-858472552),((function (i__22781,vec__22783,idx,aspect,c__5478__auto__,size__5479__auto__,b__22782,s__22780__$2,temp__5804__auto__,filter_path){
return (function (p1__22777_SHARP_){
return (p1__22777_SHARP_.target.style.opacity = "0.7");
});})(i__22781,vec__22783,idx,aspect,c__5478__auto__,size__5479__auto__,b__22782,s__22780__$2,temp__5804__auto__,filter_path))
,new cljs.core.Keyword(null,"on-mouse-out","on-mouse-out",643448647),((function (i__22781,vec__22783,idx,aspect,c__5478__auto__,size__5479__auto__,b__22782,s__22780__$2,temp__5804__auto__,filter_path){
return (function (p1__22778_SHARP_){
return (p1__22778_SHARP_.target.style.opacity = "1");
});})(i__22781,vec__22783,idx,aspect,c__5478__auto__,size__5479__auto__,b__22782,s__22780__$2,temp__5804__auto__,filter_path))
], null),cljs.core.str.cljs$core$IFn$_invoke$arity$1(aspect)], null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),idx], null)));

var G__22822 = (i__22781 + (1));
i__22781 = G__22822;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__22782),atlas_ui_v3$core$breadcrumb_$_iter__22779(cljs.core.chunk_rest(s__22780__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__22782),null);
}
} else {
var vec__22786 = cljs.core.first(s__22780__$2);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22786,(0),null);
var aspect = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22786,(1),null);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"gap","gap",80255254),"0.5rem",new cljs.core.Keyword(null,"align-items","align-items",-267946462),"center"], null)], null),(((idx > (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"color","color",1011675173),"#555"], null)], null),"\u2192"], null):null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (vec__22786,idx,aspect,s__22780__$2,temp__5804__auto__,filter_path){
return (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(atlas_ui_v3.core.app_state,cljs.core.assoc,new cljs.core.Keyword(null,"filter-path","filter-path",2004323865),cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2((idx + (1)),filter_path)));
});})(vec__22786,idx,aspect,s__22780__$2,temp__5804__auto__,filter_path))
,new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"padding","padding",1660304693),"0.3rem 0.6rem",new cljs.core.Keyword(null,"background","background",-863952629),atlas_ui_v3.core.namespace_color(aspect),new cljs.core.Keyword(null,"border-radius","border-radius",419594011),"4px",new cljs.core.Keyword(null,"cursor","cursor",1011937484),"pointer",new cljs.core.Keyword(null,"font-family","font-family",-667419874),"monospace",new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"0.9rem",new cljs.core.Keyword(null,"transition","transition",765692007),"opacity 0.2s",new cljs.core.Keyword(null,"opacity","opacity",397153780),(1)], null),new cljs.core.Keyword(null,"on-mouse-over","on-mouse-over",-858472552),((function (vec__22786,idx,aspect,s__22780__$2,temp__5804__auto__,filter_path){
return (function (p1__22777_SHARP_){
return (p1__22777_SHARP_.target.style.opacity = "0.7");
});})(vec__22786,idx,aspect,s__22780__$2,temp__5804__auto__,filter_path))
,new cljs.core.Keyword(null,"on-mouse-out","on-mouse-out",643448647),((function (vec__22786,idx,aspect,s__22780__$2,temp__5804__auto__,filter_path){
return (function (p1__22778_SHARP_){
return (p1__22778_SHARP_.target.style.opacity = "1");
});})(vec__22786,idx,aspect,s__22780__$2,temp__5804__auto__,filter_path))
], null),cljs.core.str.cljs$core$IFn$_invoke$arity$1(aspect)], null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),idx], null)),atlas_ui_v3$core$breadcrumb_$_iter__22779(cljs.core.rest(s__22780__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5480__auto__(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,filter_path));
})()),((cljs.core.seq(filter_path))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),(function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(atlas_ui_v3.core.app_state,cljs.core.assoc,new cljs.core.Keyword(null,"filter-path","filter-path",2004323865),cljs.core.PersistentVector.EMPTY);
}),new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"padding","padding",1660304693),"0.3rem 0.6rem",new cljs.core.Keyword(null,"background","background",-863952629),"#4a4a6a",new cljs.core.Keyword(null,"color","color",1011675173),"#eee",new cljs.core.Keyword(null,"border","border",1444987323),"none",new cljs.core.Keyword(null,"border-radius","border-radius",419594011),"4px",new cljs.core.Keyword(null,"cursor","cursor",1011937484),"pointer",new cljs.core.Keyword(null,"margin-left","margin-left",2015598377),"1rem"], null)], null),"Clear"], null):null)], null);
});
atlas_ui_v3.core.treemap_rect = (function atlas_ui_v3$core$treemap_rect(p__22791,on_click){
var map__22792 = p__22791;
var map__22792__$1 = cljs.core.__destructure_map(map__22792);
var aspect = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22792__$1,new cljs.core.Keyword(null,"aspect","aspect",-839905246));
var count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22792__$1,new cljs.core.Keyword(null,"count","count",2139924085));
var percentage = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22792__$1,new cljs.core.Keyword(null,"percentage","percentage",-1610213650));
var x = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22792__$1,new cljs.core.Keyword(null,"x","x",2099068185));
var y = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22792__$1,new cljs.core.Keyword(null,"y","y",-1757859776));
var width = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22792__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var height = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22792__$1,new cljs.core.Keyword(null,"height","height",1025178622));
var color = atlas_ui_v3.core.namespace_color(aspect);
var aspect_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(aspect);
var ns_name = cljs.core.namespace(aspect);
var aspect_name = cljs.core.name(aspect);
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g","g",1738089905),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),(function (){
return (on_click.cljs$core$IFn$_invoke$arity$1 ? on_click.cljs$core$IFn$_invoke$arity$1(aspect) : on_click.call(null,aspect));
}),new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cursor","cursor",1011937484),"pointer"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rect","rect",-108902628),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"y","y",-1757859776),new cljs.core.Keyword(null,"rx","rx",1627208482),new cljs.core.Keyword(null,"stroke","stroke",1741823555),new cljs.core.Keyword(null,"on-mouse-out","on-mouse-out",643448647),new cljs.core.Keyword(null,"fill","fill",883462889),new cljs.core.Keyword(null,"width","width",-384071477),new cljs.core.Keyword(null,"stroke-width","stroke-width",716836435),new cljs.core.Keyword(null,"opacity","opacity",397153780),new cljs.core.Keyword(null,"on-mouse-over","on-mouse-over",-858472552),new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"height","height",1025178622)],[y,(4),"#0f0f1a",(function (p1__22790_SHARP_){
return (p1__22790_SHARP_.target.style.opacity = "0.8");
}),color,width,(2),0.8,(function (p1__22789_SHARP_){
return (p1__22789_SHARP_.target.style.opacity = "1");
}),x,height])], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"text","text",-1790561697),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"x","x",2099068185),(x + (8)),new cljs.core.Keyword(null,"y","y",-1757859776),(y + (16)),new cljs.core.Keyword(null,"fill","fill",883462889),"rgba(255,255,255,0.6)",new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"11px",new cljs.core.Keyword(null,"font-family","font-family",-667419874),"monospace",new cljs.core.Keyword(null,"pointer-events","pointer-events",-1053858853),"none"], null),ns_name], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"text","text",-1790561697),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"y","y",-1757859776),new cljs.core.Keyword(null,"text-anchor","text-anchor",585613696),new cljs.core.Keyword(null,"font-size","font-size",-1847940346),new cljs.core.Keyword(null,"font-weight","font-weight",2085804583),new cljs.core.Keyword(null,"fill","fill",883462889),new cljs.core.Keyword(null,"dominant-baseline","dominant-baseline",609259826),new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"pointer-events","pointer-events",-1053858853),new cljs.core.Keyword(null,"font-family","font-family",-667419874)],[(y + (height / (2))),"middle","14px","bold","#fff","middle",(x + (width / (2))),"none","monospace"]),aspect_name], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"text","text",-1790561697),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"x","x",2099068185),(x + (width / (2))),new cljs.core.Keyword(null,"y","y",-1757859776),((y + height) + (-12)),new cljs.core.Keyword(null,"fill","fill",883462889),"rgba(255,255,255,0.8)",new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"12px",new cljs.core.Keyword(null,"font-family","font-family",-667419874),"monospace",new cljs.core.Keyword(null,"text-anchor","text-anchor",585613696),"middle",new cljs.core.Keyword(null,"pointer-events","pointer-events",-1053858853),"none"], null),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(count)," entities (",cljs.core.str.cljs$core$IFn$_invoke$arity$1((percentage * (100)).toFixed((1))),"%)"].join('')], null)], null);
});
atlas_ui_v3.core.treemap_view = (function atlas_ui_v3$core$treemap_view(){
var map__22793 = cljs.core.deref(atlas_ui_v3.core.app_state);
var map__22793__$1 = cljs.core.__destructure_map(map__22793);
var registry = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22793__$1,new cljs.core.Keyword(null,"registry","registry",1021159018));
var filter_path = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22793__$1,new cljs.core.Keyword(null,"filter-path","filter-path",2004323865));
var top_aspects = atlas_ui_v3.core.top_n_aspects(registry,cljs.core.set(filter_path),(10));
var width = (1200);
var height = (600);
var rects = atlas_ui_v3.core.calculate_treemap_rects(top_aspects,width,height);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"padding","padding",1660304693),"2rem",new cljs.core.Keyword(null,"background","background",-863952629),"#0f0f1a",new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"justify-content","justify-content",-1990475787),"center",new cljs.core.Keyword(null,"align-items","align-items",-267946462),"center",new cljs.core.Keyword(null,"min-height","min-height",398480837),"calc(100vh - 120px)"], null)], null),((cljs.core.empty_QMARK_(rects))?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"color","color",1011675173),"#888",new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"1.2rem",new cljs.core.Keyword(null,"text-align","text-align",1786091845),"center"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309),"No more aspects to filter by."], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"0.9rem",new cljs.core.Keyword(null,"margin-top","margin-top",392161226),"1rem"], null)], null),"Click 'Clear' above to start over."], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"width","width",-384071477),width,new cljs.core.Keyword(null,"height","height",1025178622),height,new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"background","background",-863952629),"#1a1a2e",new cljs.core.Keyword(null,"border-radius","border-radius",419594011),"8px",new cljs.core.Keyword(null,"box-shadow","box-shadow",1600206755),"0 4px 12px rgba(0,0,0,0.3)"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g","g",1738089905),(function (){var iter__5480__auto__ = (function atlas_ui_v3$core$treemap_view_$_iter__22794(s__22795){
return (new cljs.core.LazySeq(null,(function (){
var s__22795__$1 = s__22795;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__22795__$1);
if(temp__5804__auto__){
var s__22795__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__22795__$2)){
var c__5478__auto__ = cljs.core.chunk_first(s__22795__$2);
var size__5479__auto__ = cljs.core.count(c__5478__auto__);
var b__22797 = cljs.core.chunk_buffer(size__5479__auto__);
if((function (){var i__22796 = (0);
while(true){
if((i__22796 < size__5479__auto__)){
var rect = cljs.core._nth(c__5478__auto__,i__22796);
cljs.core.chunk_append(b__22797,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v3.core.treemap_rect,rect,((function (i__22796,rect,c__5478__auto__,size__5479__auto__,b__22797,s__22795__$2,temp__5804__auto__,map__22793,map__22793__$1,registry,filter_path,top_aspects,width,height,rects){
return (function (aspect){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(atlas_ui_v3.core.app_state,cljs.core.update,new cljs.core.Keyword(null,"filter-path","filter-path",2004323865),cljs.core.conj,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([aspect], 0));
});})(i__22796,rect,c__5478__auto__,size__5479__auto__,b__22797,s__22795__$2,temp__5804__auto__,map__22793,map__22793__$1,registry,filter_path,top_aspects,width,height,rects))
], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword(null,"aspect","aspect",-839905246).cljs$core$IFn$_invoke$arity$1(rect)], null)));

var G__22823 = (i__22796 + (1));
i__22796 = G__22823;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__22797),atlas_ui_v3$core$treemap_view_$_iter__22794(cljs.core.chunk_rest(s__22795__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__22797),null);
}
} else {
var rect = cljs.core.first(s__22795__$2);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v3.core.treemap_rect,rect,((function (rect,s__22795__$2,temp__5804__auto__,map__22793,map__22793__$1,registry,filter_path,top_aspects,width,height,rects){
return (function (aspect){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(atlas_ui_v3.core.app_state,cljs.core.update,new cljs.core.Keyword(null,"filter-path","filter-path",2004323865),cljs.core.conj,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([aspect], 0));
});})(rect,s__22795__$2,temp__5804__auto__,map__22793,map__22793__$1,registry,filter_path,top_aspects,width,height,rects))
], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword(null,"aspect","aspect",-839905246).cljs$core$IFn$_invoke$arity$1(rect)], null)),atlas_ui_v3$core$treemap_view_$_iter__22794(cljs.core.rest(s__22795__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5480__auto__(rects);
})()], null)], null))], null);
});
atlas_ui_v3.core.header = (function atlas_ui_v3$core$header(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"padding","padding",1660304693),"1.5rem",new cljs.core.Keyword(null,"background","background",-863952629),"#1a1a2e",new cljs.core.Keyword(null,"color","color",1011675173),"#eee",new cljs.core.Keyword(null,"border-bottom","border-bottom",2110948415),"2px solid #333"], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h1","h1",-1896887462),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"margin","margin",-995903681),(0),new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"2rem",new cljs.core.Keyword(null,"font-weight","font-weight",2085804583),(300)], null)], null),"Atlas Explorer v3",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"color","color",1011675173),"#6a6a8a",new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"1rem",new cljs.core.Keyword(null,"margin-left","margin-left",2015598377),"1rem",new cljs.core.Keyword(null,"font-weight","font-weight",2085804583),"normal"], null)], null),"Treemap Aspect Explorer"], null)], null)], null);
});
atlas_ui_v3.core.legend = (function atlas_ui_v3$core$legend(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"padding","padding",1660304693),"1rem",new cljs.core.Keyword(null,"background","background",-863952629),"#1a1a2e",new cljs.core.Keyword(null,"border-top","border-top",-158897573),"1px solid #333",new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"gap","gap",80255254),"1.5rem",new cljs.core.Keyword(null,"flex-wrap","flex-wrap",455413707),"wrap",new cljs.core.Keyword(null,"justify-content","justify-content",-1990475787),"center"], null)], null),(function (){var iter__5480__auto__ = (function atlas_ui_v3$core$legend_$_iter__22798(s__22799){
return (new cljs.core.LazySeq(null,(function (){
var s__22799__$1 = s__22799;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__22799__$1);
if(temp__5804__auto__){
var s__22799__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__22799__$2)){
var c__5478__auto__ = cljs.core.chunk_first(s__22799__$2);
var size__5479__auto__ = cljs.core.count(c__5478__auto__);
var b__22801 = cljs.core.chunk_buffer(size__5479__auto__);
if((function (){var i__22800 = (0);
while(true){
if((i__22800 < size__5479__auto__)){
var vec__22802 = cljs.core._nth(c__5478__auto__,i__22800);
var ns_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22802,(0),null);
var color = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22802,(1),null);
cljs.core.chunk_append(b__22801,((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(ns_name,"default"))?cljs.core.with_meta(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"align-items","align-items",-267946462),"center",new cljs.core.Keyword(null,"gap","gap",80255254),"0.5rem"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"width","width",-384071477),"16px",new cljs.core.Keyword(null,"height","height",1025178622),"16px",new cljs.core.Keyword(null,"background","background",-863952629),color,new cljs.core.Keyword(null,"border-radius","border-radius",419594011),"3px"], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"color","color",1011675173),"#aaa",new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"0.85rem"], null)], null),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns_name),"/"].join('')], null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),ns_name], null)):null));

var G__22824 = (i__22800 + (1));
i__22800 = G__22824;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__22801),atlas_ui_v3$core$legend_$_iter__22798(cljs.core.chunk_rest(s__22799__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__22801),null);
}
} else {
var vec__22805 = cljs.core.first(s__22799__$2);
var ns_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22805,(0),null);
var color = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22805,(1),null);
return cljs.core.cons(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(ns_name,"default"))?cljs.core.with_meta(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"align-items","align-items",-267946462),"center",new cljs.core.Keyword(null,"gap","gap",80255254),"0.5rem"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"width","width",-384071477),"16px",new cljs.core.Keyword(null,"height","height",1025178622),"16px",new cljs.core.Keyword(null,"background","background",-863952629),color,new cljs.core.Keyword(null,"border-radius","border-radius",419594011),"3px"], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"color","color",1011675173),"#aaa",new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"0.85rem"], null)], null),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns_name),"/"].join('')], null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),ns_name], null)):null),atlas_ui_v3$core$legend_$_iter__22798(cljs.core.rest(s__22799__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5480__auto__(cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.first,atlas_ui_v3.core.namespace_colors));
})()], null);
});
atlas_ui_v3.core.stats = (function atlas_ui_v3$core$stats(){
var map__22808 = cljs.core.deref(atlas_ui_v3.core.app_state);
var map__22808__$1 = cljs.core.__destructure_map(map__22808);
var registry = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22808__$1,new cljs.core.Keyword(null,"registry","registry",1021159018));
var filter_path = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22808__$1,new cljs.core.Keyword(null,"filter-path","filter-path",2004323865));
var filtered = atlas_ui_v3.core.filter_entities_by_aspects(registry,cljs.core.set(filter_path));
var total_entities = cljs.core.count(registry);
var filtered_entities = cljs.core.count(filtered);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"padding","padding",1660304693),"1rem",new cljs.core.Keyword(null,"background","background",-863952629),"#2a2a4e",new cljs.core.Keyword(null,"color","color",1011675173),"#aaa",new cljs.core.Keyword(null,"text-align","text-align",1786091845),"center",new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"0.9rem"], null)], null),((cljs.core.empty_QMARK_(filter_path))?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"Showing ",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"color","color",1011675173),"#eee"], null)], null),total_entities], null)," total entities"], null):new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"Filtered to ",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"color","color",1011675173),"#4aef7a"], null)], null),filtered_entities], null)," of ",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"color","color",1011675173),"#eee"], null)], null),total_entities], null)," entities (",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),((filtered_entities / total_entities) * (100)).toFixed((1)),"%"], null),")"], null))], null);
});
atlas_ui_v3.core.loading_view = (function atlas_ui_v3$core$loading_view(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"justify-content","justify-content",-1990475787),"center",new cljs.core.Keyword(null,"align-items","align-items",-267946462),"center",new cljs.core.Keyword(null,"height","height",1025178622),"100vh",new cljs.core.Keyword(null,"background","background",-863952629),"#0f0f1a",new cljs.core.Keyword(null,"color","color",1011675173),"#eee"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),"Loading registry..."], null)], null);
});
atlas_ui_v3.core.login_view = (function atlas_ui_v3$core$login_view(){
var map__22814 = cljs.core.deref(atlas_ui_v3.core.app_state);
var map__22814__$1 = cljs.core.__destructure_map(map__22814);
var username = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22814__$1,new cljs.core.Keyword(null,"username","username",1605666410));
var password = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22814__$1,new cljs.core.Keyword(null,"password","password",417022471));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"justify-content","justify-content",-1990475787),"center",new cljs.core.Keyword(null,"align-items","align-items",-267946462),"center",new cljs.core.Keyword(null,"height","height",1025178622),"100vh",new cljs.core.Keyword(null,"background","background",-863952629),"#0f0f1a",new cljs.core.Keyword(null,"color","color",1011675173),"#eee"], null)], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"background","background",-863952629),"#1a1a2e",new cljs.core.Keyword(null,"padding","padding",1660304693),"2rem",new cljs.core.Keyword(null,"border-radius","border-radius",419594011),"8px",new cljs.core.Keyword(null,"box-shadow","box-shadow",1600206755),"0 4px 12px rgba(0,0,0,0.3)",new cljs.core.Keyword(null,"max-width","max-width",-1939924051),"400px"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h2","h2",-372662728),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"margin","margin",-995903681),"0 0 1rem 0",new cljs.core.Keyword(null,"color","color",1011675173),"#eee"], null)], null),"Authentication Required"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"margin","margin",-995903681),"0 0 1.5rem 0",new cljs.core.Keyword(null,"color","color",1011675173),"#aaa",new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"0.9rem"], null)], null),"The registry server requires authentication."], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"margin-bottom","margin-bottom",388334941),"1rem"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"display","display",242065432),"block",new cljs.core.Keyword(null,"margin-bottom","margin-bottom",388334941),"0.5rem",new cljs.core.Keyword(null,"color","color",1011675173),"#aaa",new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"0.9rem"], null)], null),"Username"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"text",new cljs.core.Keyword(null,"value","value",305978217),username,new cljs.core.Keyword(null,"on-change","on-change",-732046149),(function (p1__22809_SHARP_){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(atlas_ui_v3.core.app_state,cljs.core.assoc,new cljs.core.Keyword(null,"username","username",1605666410),p1__22809_SHARP_.target.value);
}),new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),"atlas",new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"width","width",-384071477),"100%",new cljs.core.Keyword(null,"padding","padding",1660304693),"0.5rem",new cljs.core.Keyword(null,"background","background",-863952629),"#2a2a4e",new cljs.core.Keyword(null,"color","color",1011675173),"#eee",new cljs.core.Keyword(null,"border","border",1444987323),"1px solid #4a4a6a",new cljs.core.Keyword(null,"border-radius","border-radius",419594011),"4px",new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"1rem"], null)], null)], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"margin-bottom","margin-bottom",388334941),"1.5rem"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"display","display",242065432),"block",new cljs.core.Keyword(null,"margin-bottom","margin-bottom",388334941),"0.5rem",new cljs.core.Keyword(null,"color","color",1011675173),"#aaa",new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"0.9rem"], null)], null),"Password"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"type","type",1174270348),"password",new cljs.core.Keyword(null,"value","value",305978217),password,new cljs.core.Keyword(null,"on-change","on-change",-732046149),(function (p1__22810_SHARP_){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(atlas_ui_v3.core.app_state,cljs.core.assoc,new cljs.core.Keyword(null,"password","password",417022471),p1__22810_SHARP_.target.value);
}),new cljs.core.Keyword(null,"on-key-press","on-key-press",-399563677),(function (p1__22811_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__22811_SHARP_.key,"Enter")){
var user = new cljs.core.Keyword(null,"username","username",1605666410).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui_v3.core.app_state));
var pass = new cljs.core.Keyword(null,"password","password",417022471).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui_v3.core.app_state));
var port = (new URLSearchParams(location.search)).get("port");
var new_url = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.protocol),"//",cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.hostname),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.port),"/?port=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(port),"&user=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(user)),"&password=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(pass))].join('');
return (window.location = new_url);
} else {
return null;
}
}),new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),"atlasp",new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"width","width",-384071477),"100%",new cljs.core.Keyword(null,"padding","padding",1660304693),"0.5rem",new cljs.core.Keyword(null,"background","background",-863952629),"#2a2a4e",new cljs.core.Keyword(null,"color","color",1011675173),"#eee",new cljs.core.Keyword(null,"border","border",1444987323),"1px solid #4a4a6a",new cljs.core.Keyword(null,"border-radius","border-radius",419594011),"4px",new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"1rem"], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),(function (){
var user = new cljs.core.Keyword(null,"username","username",1605666410).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui_v3.core.app_state));
var pass = new cljs.core.Keyword(null,"password","password",417022471).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui_v3.core.app_state));
var port = (new URLSearchParams(location.search)).get("port");
var new_url = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.protocol),"//",cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.hostname),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.port),"/?port=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(port),"&user=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(user)),"&password=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(pass))].join('');
return (window.location = new_url);
}),new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"font-size","font-size",-1847940346),new cljs.core.Keyword(null,"transition","transition",765692007),new cljs.core.Keyword(null,"font-weight","font-weight",2085804583),new cljs.core.Keyword(null,"width","width",-384071477),new cljs.core.Keyword(null,"background","background",-863952629),new cljs.core.Keyword(null,"cursor","cursor",1011937484),new cljs.core.Keyword(null,"padding","padding",1660304693),new cljs.core.Keyword(null,"border","border",1444987323),new cljs.core.Keyword(null,"border-radius","border-radius",419594011)],["#fff","1rem","background 0.2s","bold","100%","#4a9eff","pointer","0.75rem","none","4px"]),new cljs.core.Keyword(null,"on-mouse-over","on-mouse-over",-858472552),(function (p1__22812_SHARP_){
return (p1__22812_SHARP_.target.style.background = "#3a8eef");
}),new cljs.core.Keyword(null,"on-mouse-out","on-mouse-out",643448647),(function (p1__22813_SHARP_){
return (p1__22813_SHARP_.target.style.background = "#4a9eff");
})], null),"Login"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"margin","margin",-995903681),"1rem 0 0 0",new cljs.core.Keyword(null,"color","color",1011675173),"#6a6a8a",new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"0.8rem",new cljs.core.Keyword(null,"text-align","text-align",1786091845),"center"], null)], null),"Or add ?user=USERNAME&password=PASSWORD to URL"], null)], null)], null);
});
atlas_ui_v3.core.error_view = (function atlas_ui_v3$core$error_view(error){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"justify-content","justify-content",-1990475787),"center",new cljs.core.Keyword(null,"align-items","align-items",-267946462),"center",new cljs.core.Keyword(null,"height","height",1025178622),"100vh",new cljs.core.Keyword(null,"background","background",-863952629),"#0f0f1a",new cljs.core.Keyword(null,"color","color",1011675173),"#ff6b6b"], null)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"background","background",-863952629),"#1a1a2e",new cljs.core.Keyword(null,"padding","padding",1660304693),"2rem",new cljs.core.Keyword(null,"border-radius","border-radius",419594011),"8px",new cljs.core.Keyword(null,"max-width","max-width",-1939924051),"500px"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h2","h2",-372662728),"Error loading registry"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pre","pre",2118456869),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"color","color",1011675173),"#aaa",new cljs.core.Keyword(null,"background","background",-863952629),"#0f0f1a",new cljs.core.Keyword(null,"padding","padding",1660304693),"1rem",new cljs.core.Keyword(null,"border-radius","border-radius",419594011),"4px",new cljs.core.Keyword(null,"overflow","overflow",2058931880),"auto"], null)], null),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error], 0))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),(function (){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(atlas_ui_v3.core.app_state,cljs.core.assoc,new cljs.core.Keyword(null,"loading?","loading?",1905707049),true,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"error","error",-978969032),null], 0));

return atlas_ui_v2.api.fetch_registry_BANG_(atlas_ui_v3.core.on_registry_loaded,atlas_ui_v3.core.on_registry_error);
}),new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"margin-top","margin-top",392161226),"1rem",new cljs.core.Keyword(null,"padding","padding",1660304693),"0.5rem 1rem",new cljs.core.Keyword(null,"background","background",-863952629),"#4a9eff",new cljs.core.Keyword(null,"color","color",1011675173),"#fff",new cljs.core.Keyword(null,"border","border",1444987323),"none",new cljs.core.Keyword(null,"border-radius","border-radius",419594011),"4px",new cljs.core.Keyword(null,"cursor","cursor",1011937484),"pointer"], null)], null),"Retry"], null)], null)], null);
});
atlas_ui_v3.core.app = (function atlas_ui_v3$core$app(){
var map__22815 = cljs.core.deref(atlas_ui_v3.core.app_state);
var map__22815__$1 = cljs.core.__destructure_map(map__22815);
var loading_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22815__$1,new cljs.core.Keyword(null,"loading?","loading?",1905707049));
var error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22815__$1,new cljs.core.Keyword(null,"error","error",-978969032));
var registry = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22815__$1,new cljs.core.Keyword(null,"registry","registry",1021159018));
var auth_required_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22815__$1,new cljs.core.Keyword(null,"auth-required?","auth-required?",-1511931840));
if(cljs.core.truth_(auth_required_QMARK_)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v3.core.login_view], null);
} else {
if(cljs.core.truth_(loading_QMARK_)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v3.core.loading_view], null);
} else {
if(cljs.core.truth_(error)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v3.core.error_view,error], null);
} else {
if((registry == null)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v3.core.loading_view], null);
} else {
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"flex-direction","flex-direction",364609438),"column",new cljs.core.Keyword(null,"min-height","min-height",398480837),"100vh",new cljs.core.Keyword(null,"background","background",-863952629),"#0f0f1a"], null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v3.core.header], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v3.core.breadcrumb], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v3.core.stats], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v3.core.treemap_view], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v3.core.legend], null)], null);

}
}
}
}
});
atlas_ui_v3.core.on_registry_loaded = (function atlas_ui_v3$core$on_registry_loaded(data){
var registry = (function (){var or__5002__auto__ = new cljs.core.Keyword("atlas-ui.api.response","registry","atlas-ui.api.response/registry",-156359811).cljs$core$IFn$_invoke$arity$1(data);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return data;
}
})();
console.log("Registry loaded - entities:",cljs.core.count(registry));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(atlas_ui_v3.core.app_state,cljs.core.assoc,new cljs.core.Keyword(null,"registry","registry",1021159018),registry,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"loading?","loading?",1905707049),false,new cljs.core.Keyword(null,"error","error",-978969032),null], 0));
});
atlas_ui_v3.core.on_registry_error = (function atlas_ui_v3$core$on_registry_error(error){
console.error("Registry error:",error);

var status = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(error));
var is_401_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(status,(401));
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(atlas_ui_v3.core.app_state,cljs.core.assoc,new cljs.core.Keyword(null,"loading?","loading?",1905707049),false,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"error","error",-978969032),((is_401_QMARK_)?null:error),new cljs.core.Keyword(null,"auth-required?","auth-required?",-1511931840),is_401_QMARK_], 0));
});
atlas_ui_v3.core.mount_root = (function atlas_ui_v3$core$mount_root(){
var temp__5804__auto__ = document.getElementById("app");
if(cljs.core.truth_(temp__5804__auto__)){
var el = temp__5804__auto__;
return reagent.dom.render.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v3.core.app], null),el);
} else {
return null;
}
});
atlas_ui_v3.core.init = (function atlas_ui_v3$core$init(){
console.log("Atlas UI v3 initializing...");

atlas_ui_v2.api.fetch_registry_BANG_(atlas_ui_v3.core.on_registry_loaded,atlas_ui_v3.core.on_registry_error);

return atlas_ui_v3.core.mount_root();
});

//# sourceMappingURL=atlas_ui_v3.core.js.map
