goog.provide('atlas_ui_v2.api');
atlas_ui_v2.api.get_url_params = (function atlas_ui_v2$api$get_url_params(){
var search_params = (new URLSearchParams(location.search));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"port","port",1534937262),search_params.get("port"),new cljs.core.Keyword(null,"user","user",1532431356),search_params.get("user"),new cljs.core.Keyword(null,"password","password",417022471),search_params.get("password")], null);
});
atlas_ui_v2.api.api_url = (function atlas_ui_v2$api$api_url(){
var map__22526 = atlas_ui_v2.api.get_url_params();
var map__22526__$1 = cljs.core.__destructure_map(map__22526);
var port = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22526__$1,new cljs.core.Keyword(null,"port","port",1534937262));
if(cljs.core.truth_(port)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.protocol),"//",cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.hostname),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(port),"/api/atlas/registry"].join('');
} else {
return "/api/atlas/registry";
}
});
atlas_ui_v2.api.basic_auth_header = (function atlas_ui_v2$api$basic_auth_header(user,password){
if(cljs.core.truth_((function (){var and__5000__auto__ = user;
if(cljs.core.truth_(and__5000__auto__)){
return password;
} else {
return and__5000__auto__;
}
})())){
var credentials = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(user),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(password)].join('');
var encoded = goog.crypt.base64.encodeString(credentials);
return ["Basic ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encoded)].join('');
} else {
return null;
}
});
atlas_ui_v2.api.decode_transit = (function atlas_ui_v2$api$decode_transit(s){
var reader = cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"json","json",1279968570));
return cognitect.transit.read(reader,s);
});
/**
 * Fetch registry from backend, call on-success or on-error.
 * 
 * Supports basic auth via URL params:
 * ?port=3002&user=atlas&password=atlasp
 */
atlas_ui_v2.api.fetch_registry_BANG_ = (function atlas_ui_v2$api$fetch_registry_BANG_(on_success,on_error){
var map__22527 = atlas_ui_v2.api.get_url_params();
var map__22527__$1 = cljs.core.__destructure_map(map__22527);
var user = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22527__$1,new cljs.core.Keyword(null,"user","user",1532431356));
var password = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22527__$1,new cljs.core.Keyword(null,"password","password",417022471));
var auth_header = atlas_ui_v2.api.basic_auth_header(user,password);
var headers = (function (){var G__22528 = new cljs.core.PersistentArrayMap(null, 1, ["Accept","application/transit+json"], null);
if(cljs.core.truth_(auth_header)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__22528,"Authorization",auth_header);
} else {
return G__22528;
}
})();
console.log("Fetching registry from:",atlas_ui_v2.api.api_url());

if(cljs.core.truth_(auth_header)){
console.log("Using basic auth for user:",user);
} else {
}

return ajax.core.GET.cljs$core$IFn$_invoke$arity$variadic(atlas_ui_v2.api.api_url(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"response-format","response-format",1664465322),new cljs.core.Keyword(null,"text","text",-1790561697),new cljs.core.Keyword(null,"handler","handler",-195596612),(function (response_text){
try{var data = atlas_ui_v2.api.decode_transit(response_text);
console.log("Registry loaded successfully");

return (on_success.cljs$core$IFn$_invoke$arity$1 ? on_success.cljs$core$IFn$_invoke$arity$1(data) : on_success.call(null,data));
}catch (e22529){var e = e22529;
console.error("Error decoding transit:",e);

var G__22530 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"decode-error","decode-error",-454125835),new cljs.core.Keyword(null,"error","error",-978969032),e], null);
return (on_error.cljs$core$IFn$_invoke$arity$1 ? on_error.cljs$core$IFn$_invoke$arity$1(G__22530) : on_error.call(null,G__22530));
}}),new cljs.core.Keyword(null,"error-handler","error-handler",-484945776),(function (error){
console.warn("API error:",error);

var G__22531 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fetch-error","fetch-error",1710778920),new cljs.core.Keyword(null,"error","error",-978969032),error], null);
return (on_error.cljs$core$IFn$_invoke$arity$1 ? on_error.cljs$core$IFn$_invoke$arity$1(G__22531) : on_error.call(null,G__22531));
})], null)], 0));
});

//# sourceMappingURL=atlas_ui_v2.api.js.map
