goog.provide('cljs.core.async');
goog.scope(function(){
  cljs.core.async.goog$module$goog$array = goog.module.get('goog.array');
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14652 = (function (f,blockable,meta14653){
this.f = f;
this.blockable = blockable;
this.meta14653 = meta14653;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async14652.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14654,meta14653__$1){
var self__ = this;
var _14654__$1 = this;
return (new cljs.core.async.t_cljs$core$async14652(self__.f,self__.blockable,meta14653__$1));
}));

(cljs.core.async.t_cljs$core$async14652.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14654){
var self__ = this;
var _14654__$1 = this;
return self__.meta14653;
}));

(cljs.core.async.t_cljs$core$async14652.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14652.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async14652.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async14652.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async14652.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta14653","meta14653",1896136051,null)], null);
}));

(cljs.core.async.t_cljs$core$async14652.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async14652.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14652");

(cljs.core.async.t_cljs$core$async14652.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async14652");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async14652.
 */
cljs.core.async.__GT_t_cljs$core$async14652 = (function cljs$core$async$__GT_t_cljs$core$async14652(f,blockable,meta14653){
return (new cljs.core.async.t_cljs$core$async14652(f,blockable,meta14653));
});


cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__14650 = arguments.length;
switch (G__14650) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
return (new cljs.core.async.t_cljs$core$async14652(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__14663 = arguments.length;
switch (G__14663) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__14674 = arguments.length;
switch (G__14674) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__14693 = arguments.length;
switch (G__14693) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_17569 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_17569) : fn1.call(null,val_17569));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_17569) : fn1.call(null,val_17569));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__14700 = arguments.length;
switch (G__14700) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5802__auto__)){
var ret = temp__5802__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5802__auto__)){
var retb = temp__5802__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5593__auto___17581 = n;
var x_17583 = (0);
while(true){
if((x_17583 < n__5593__auto___17581)){
(a[x_17583] = x_17583);

var G__17585 = (x_17583 + (1));
x_17583 = G__17585;
continue;
} else {
}
break;
}

cljs.core.async.goog$module$goog$array.shuffle(a);

return a;
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14722 = (function (flag,meta14723){
this.flag = flag;
this.meta14723 = meta14723;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async14722.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14724,meta14723__$1){
var self__ = this;
var _14724__$1 = this;
return (new cljs.core.async.t_cljs$core$async14722(self__.flag,meta14723__$1));
}));

(cljs.core.async.t_cljs$core$async14722.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14724){
var self__ = this;
var _14724__$1 = this;
return self__.meta14723;
}));

(cljs.core.async.t_cljs$core$async14722.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14722.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async14722.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async14722.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async14722.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta14723","meta14723",-1378286140,null)], null);
}));

(cljs.core.async.t_cljs$core$async14722.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async14722.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14722");

(cljs.core.async.t_cljs$core$async14722.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async14722");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async14722.
 */
cljs.core.async.__GT_t_cljs$core$async14722 = (function cljs$core$async$__GT_t_cljs$core$async14722(flag,meta14723){
return (new cljs.core.async.t_cljs$core$async14722(flag,meta14723));
});


cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
return (new cljs.core.async.t_cljs$core$async14722(flag,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14733 = (function (flag,cb,meta14734){
this.flag = flag;
this.cb = cb;
this.meta14734 = meta14734;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async14733.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14735,meta14734__$1){
var self__ = this;
var _14735__$1 = this;
return (new cljs.core.async.t_cljs$core$async14733(self__.flag,self__.cb,meta14734__$1));
}));

(cljs.core.async.t_cljs$core$async14733.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14735){
var self__ = this;
var _14735__$1 = this;
return self__.meta14734;
}));

(cljs.core.async.t_cljs$core$async14733.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14733.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async14733.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async14733.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async14733.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta14734","meta14734",399996709,null)], null);
}));

(cljs.core.async.t_cljs$core$async14733.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async14733.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14733");

(cljs.core.async.t_cljs$core$async14733.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async14733");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async14733.
 */
cljs.core.async.__GT_t_cljs$core$async14733 = (function cljs$core$async$__GT_t_cljs$core$async14733(flag,cb,meta14734){
return (new cljs.core.async.t_cljs$core$async14733(flag,cb,meta14734));
});


cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
return (new cljs.core.async.t_cljs$core$async14733(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__14738_SHARP_){
var G__14740 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__14738_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__14740) : fret.call(null,G__14740));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__14739_SHARP_){
var G__14741 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__14739_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__14741) : fret.call(null,G__14741));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__5002__auto__ = wport;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return port;
}
})()], null));
} else {
var G__17603 = (i + (1));
i = G__17603;
continue;
}
} else {
return null;
}
break;
}
})();
var or__5002__auto__ = ret;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5804__auto__ = (function (){var and__5000__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__5000__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__5000__auto__;
}
})();
if(cljs.core.truth_(temp__5804__auto__)){
var got = temp__5804__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5732__auto__ = [];
var len__5726__auto___17606 = arguments.length;
var i__5727__auto___17608 = (0);
while(true){
if((i__5727__auto___17608 < len__5726__auto___17606)){
args__5732__auto__.push((arguments[i__5727__auto___17608]));

var G__17610 = (i__5727__auto___17608 + (1));
i__5727__auto___17608 = G__17610;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((1) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5733__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__14744){
var map__14745 = p__14744;
var map__14745__$1 = cljs.core.__destructure_map(map__14745);
var opts = map__14745__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq14742){
var G__14743 = cljs.core.first(seq14742);
var seq14742__$1 = cljs.core.next(seq14742);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14743,seq14742__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__14749 = arguments.length;
switch (G__14749) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__14556__auto___17616 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14557__auto__ = (function (){var switch__14360__auto__ = (function (state_14793){
var state_val_14794 = (state_14793[(1)]);
if((state_val_14794 === (7))){
var inst_14788 = (state_14793[(2)]);
var state_14793__$1 = state_14793;
var statearr_14800_17618 = state_14793__$1;
(statearr_14800_17618[(2)] = inst_14788);

(statearr_14800_17618[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14794 === (1))){
var state_14793__$1 = state_14793;
var statearr_14806_17619 = state_14793__$1;
(statearr_14806_17619[(2)] = null);

(statearr_14806_17619[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14794 === (4))){
var inst_14765 = (state_14793[(7)]);
var inst_14765__$1 = (state_14793[(2)]);
var inst_14768 = (inst_14765__$1 == null);
var state_14793__$1 = (function (){var statearr_14811 = state_14793;
(statearr_14811[(7)] = inst_14765__$1);

return statearr_14811;
})();
if(cljs.core.truth_(inst_14768)){
var statearr_14812_17624 = state_14793__$1;
(statearr_14812_17624[(1)] = (5));

} else {
var statearr_14813_17625 = state_14793__$1;
(statearr_14813_17625[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14794 === (13))){
var state_14793__$1 = state_14793;
var statearr_14814_17626 = state_14793__$1;
(statearr_14814_17626[(2)] = null);

(statearr_14814_17626[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14794 === (6))){
var inst_14765 = (state_14793[(7)]);
var state_14793__$1 = state_14793;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14793__$1,(11),to,inst_14765);
} else {
if((state_val_14794 === (3))){
var inst_14791 = (state_14793[(2)]);
var state_14793__$1 = state_14793;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14793__$1,inst_14791);
} else {
if((state_val_14794 === (12))){
var state_14793__$1 = state_14793;
var statearr_14815_17628 = state_14793__$1;
(statearr_14815_17628[(2)] = null);

(statearr_14815_17628[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14794 === (2))){
var state_14793__$1 = state_14793;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14793__$1,(4),from);
} else {
if((state_val_14794 === (11))){
var inst_14779 = (state_14793[(2)]);
var state_14793__$1 = state_14793;
if(cljs.core.truth_(inst_14779)){
var statearr_14816_17631 = state_14793__$1;
(statearr_14816_17631[(1)] = (12));

} else {
var statearr_14817_17633 = state_14793__$1;
(statearr_14817_17633[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14794 === (9))){
var state_14793__$1 = state_14793;
var statearr_14819_17634 = state_14793__$1;
(statearr_14819_17634[(2)] = null);

(statearr_14819_17634[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14794 === (5))){
var state_14793__$1 = state_14793;
if(cljs.core.truth_(close_QMARK_)){
var statearr_14820_17635 = state_14793__$1;
(statearr_14820_17635[(1)] = (8));

} else {
var statearr_14821_17636 = state_14793__$1;
(statearr_14821_17636[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14794 === (14))){
var inst_14786 = (state_14793[(2)]);
var state_14793__$1 = state_14793;
var statearr_14822_17638 = state_14793__$1;
(statearr_14822_17638[(2)] = inst_14786);

(statearr_14822_17638[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14794 === (10))){
var inst_14774 = (state_14793[(2)]);
var state_14793__$1 = state_14793;
var statearr_14829_17639 = state_14793__$1;
(statearr_14829_17639[(2)] = inst_14774);

(statearr_14829_17639[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14794 === (8))){
var inst_14771 = cljs.core.async.close_BANG_(to);
var state_14793__$1 = state_14793;
var statearr_14832_17642 = state_14793__$1;
(statearr_14832_17642[(2)] = inst_14771);

(statearr_14832_17642[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__14361__auto__ = null;
var cljs$core$async$state_machine__14361__auto____0 = (function (){
var statearr_14833 = [null,null,null,null,null,null,null,null];
(statearr_14833[(0)] = cljs$core$async$state_machine__14361__auto__);

(statearr_14833[(1)] = (1));

return statearr_14833;
});
var cljs$core$async$state_machine__14361__auto____1 = (function (state_14793){
while(true){
var ret_value__14362__auto__ = (function (){try{while(true){
var result__14363__auto__ = switch__14360__auto__(state_14793);
if(cljs.core.keyword_identical_QMARK_(result__14363__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14363__auto__;
}
break;
}
}catch (e14835){var ex__14364__auto__ = e14835;
var statearr_14838_17650 = state_14793;
(statearr_14838_17650[(2)] = ex__14364__auto__);


if(cljs.core.seq((state_14793[(4)]))){
var statearr_14841_17651 = state_14793;
(statearr_14841_17651[(1)] = cljs.core.first((state_14793[(4)])));

} else {
throw ex__14364__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14362__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17652 = state_14793;
state_14793 = G__17652;
continue;
} else {
return ret_value__14362__auto__;
}
break;
}
});
cljs$core$async$state_machine__14361__auto__ = function(state_14793){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14361__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14361__auto____1.call(this,state_14793);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14361__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14361__auto____0;
cljs$core$async$state_machine__14361__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14361__auto____1;
return cljs$core$async$state_machine__14361__auto__;
})()
})();
var state__14558__auto__ = (function (){var statearr_14843 = f__14557__auto__();
(statearr_14843[(6)] = c__14556__auto___17616);

return statearr_14843;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14558__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process__$1 = (function (p__14852){
var vec__14853 = p__14852;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14853,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14853,(1),null);
var job = vec__14853;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__14556__auto___17657 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14557__auto__ = (function (){var switch__14360__auto__ = (function (state_14860){
var state_val_14861 = (state_14860[(1)]);
if((state_val_14861 === (1))){
var state_14860__$1 = state_14860;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14860__$1,(2),res,v);
} else {
if((state_val_14861 === (2))){
var inst_14857 = (state_14860[(2)]);
var inst_14858 = cljs.core.async.close_BANG_(res);
var state_14860__$1 = (function (){var statearr_14863 = state_14860;
(statearr_14863[(7)] = inst_14857);

return statearr_14863;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_14860__$1,inst_14858);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14361__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14361__auto____0 = (function (){
var statearr_14868 = [null,null,null,null,null,null,null,null];
(statearr_14868[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14361__auto__);

(statearr_14868[(1)] = (1));

return statearr_14868;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14361__auto____1 = (function (state_14860){
while(true){
var ret_value__14362__auto__ = (function (){try{while(true){
var result__14363__auto__ = switch__14360__auto__(state_14860);
if(cljs.core.keyword_identical_QMARK_(result__14363__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14363__auto__;
}
break;
}
}catch (e14869){var ex__14364__auto__ = e14869;
var statearr_14870_17665 = state_14860;
(statearr_14870_17665[(2)] = ex__14364__auto__);


if(cljs.core.seq((state_14860[(4)]))){
var statearr_14871_17666 = state_14860;
(statearr_14871_17666[(1)] = cljs.core.first((state_14860[(4)])));

} else {
throw ex__14364__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14362__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17667 = state_14860;
state_14860 = G__17667;
continue;
} else {
return ret_value__14362__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14361__auto__ = function(state_14860){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14361__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14361__auto____1.call(this,state_14860);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14361__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14361__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14361__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14361__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14361__auto__;
})()
})();
var state__14558__auto__ = (function (){var statearr_14872 = f__14557__auto__();
(statearr_14872[(6)] = c__14556__auto___17657);

return statearr_14872;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14558__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__14875){
var vec__14876 = p__14875;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14876,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14876,(1),null);
var job = vec__14876;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__5593__auto___17672 = n;
var __17673 = (0);
while(true){
if((__17673 < n__5593__auto___17672)){
var G__14879_17675 = type;
var G__14879_17676__$1 = (((G__14879_17675 instanceof cljs.core.Keyword))?G__14879_17675.fqn:null);
switch (G__14879_17676__$1) {
case "compute":
var c__14556__auto___17678 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__17673,c__14556__auto___17678,G__14879_17675,G__14879_17676__$1,n__5593__auto___17672,jobs,results,process__$1,async){
return (function (){
var f__14557__auto__ = (function (){var switch__14360__auto__ = ((function (__17673,c__14556__auto___17678,G__14879_17675,G__14879_17676__$1,n__5593__auto___17672,jobs,results,process__$1,async){
return (function (state_14894){
var state_val_14895 = (state_14894[(1)]);
if((state_val_14895 === (1))){
var state_14894__$1 = state_14894;
var statearr_14900_17681 = state_14894__$1;
(statearr_14900_17681[(2)] = null);

(statearr_14900_17681[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14895 === (2))){
var state_14894__$1 = state_14894;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14894__$1,(4),jobs);
} else {
if((state_val_14895 === (3))){
var inst_14892 = (state_14894[(2)]);
var state_14894__$1 = state_14894;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14894__$1,inst_14892);
} else {
if((state_val_14895 === (4))){
var inst_14884 = (state_14894[(2)]);
var inst_14885 = process__$1(inst_14884);
var state_14894__$1 = state_14894;
if(cljs.core.truth_(inst_14885)){
var statearr_14902_17686 = state_14894__$1;
(statearr_14902_17686[(1)] = (5));

} else {
var statearr_14903_17687 = state_14894__$1;
(statearr_14903_17687[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14895 === (5))){
var state_14894__$1 = state_14894;
var statearr_14905_17688 = state_14894__$1;
(statearr_14905_17688[(2)] = null);

(statearr_14905_17688[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14895 === (6))){
var state_14894__$1 = state_14894;
var statearr_14907_17689 = state_14894__$1;
(statearr_14907_17689[(2)] = null);

(statearr_14907_17689[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14895 === (7))){
var inst_14890 = (state_14894[(2)]);
var state_14894__$1 = state_14894;
var statearr_14908_17691 = state_14894__$1;
(statearr_14908_17691[(2)] = inst_14890);

(statearr_14908_17691[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__17673,c__14556__auto___17678,G__14879_17675,G__14879_17676__$1,n__5593__auto___17672,jobs,results,process__$1,async))
;
return ((function (__17673,switch__14360__auto__,c__14556__auto___17678,G__14879_17675,G__14879_17676__$1,n__5593__auto___17672,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14361__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14361__auto____0 = (function (){
var statearr_14909 = [null,null,null,null,null,null,null];
(statearr_14909[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14361__auto__);

(statearr_14909[(1)] = (1));

return statearr_14909;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14361__auto____1 = (function (state_14894){
while(true){
var ret_value__14362__auto__ = (function (){try{while(true){
var result__14363__auto__ = switch__14360__auto__(state_14894);
if(cljs.core.keyword_identical_QMARK_(result__14363__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14363__auto__;
}
break;
}
}catch (e14911){var ex__14364__auto__ = e14911;
var statearr_14912_17696 = state_14894;
(statearr_14912_17696[(2)] = ex__14364__auto__);


if(cljs.core.seq((state_14894[(4)]))){
var statearr_14913_17697 = state_14894;
(statearr_14913_17697[(1)] = cljs.core.first((state_14894[(4)])));

} else {
throw ex__14364__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14362__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17700 = state_14894;
state_14894 = G__17700;
continue;
} else {
return ret_value__14362__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14361__auto__ = function(state_14894){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14361__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14361__auto____1.call(this,state_14894);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14361__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14361__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14361__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14361__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14361__auto__;
})()
;})(__17673,switch__14360__auto__,c__14556__auto___17678,G__14879_17675,G__14879_17676__$1,n__5593__auto___17672,jobs,results,process__$1,async))
})();
var state__14558__auto__ = (function (){var statearr_14921 = f__14557__auto__();
(statearr_14921[(6)] = c__14556__auto___17678);

return statearr_14921;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14558__auto__);
});})(__17673,c__14556__auto___17678,G__14879_17675,G__14879_17676__$1,n__5593__auto___17672,jobs,results,process__$1,async))
);


break;
case "async":
var c__14556__auto___17701 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__17673,c__14556__auto___17701,G__14879_17675,G__14879_17676__$1,n__5593__auto___17672,jobs,results,process__$1,async){
return (function (){
var f__14557__auto__ = (function (){var switch__14360__auto__ = ((function (__17673,c__14556__auto___17701,G__14879_17675,G__14879_17676__$1,n__5593__auto___17672,jobs,results,process__$1,async){
return (function (state_14940){
var state_val_14941 = (state_14940[(1)]);
if((state_val_14941 === (1))){
var state_14940__$1 = state_14940;
var statearr_14947_17706 = state_14940__$1;
(statearr_14947_17706[(2)] = null);

(statearr_14947_17706[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14941 === (2))){
var state_14940__$1 = state_14940;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14940__$1,(4),jobs);
} else {
if((state_val_14941 === (3))){
var inst_14938 = (state_14940[(2)]);
var state_14940__$1 = state_14940;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14940__$1,inst_14938);
} else {
if((state_val_14941 === (4))){
var inst_14928 = (state_14940[(2)]);
var inst_14930 = async(inst_14928);
var state_14940__$1 = state_14940;
if(cljs.core.truth_(inst_14930)){
var statearr_14959_17710 = state_14940__$1;
(statearr_14959_17710[(1)] = (5));

} else {
var statearr_14960_17712 = state_14940__$1;
(statearr_14960_17712[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14941 === (5))){
var state_14940__$1 = state_14940;
var statearr_14962_17713 = state_14940__$1;
(statearr_14962_17713[(2)] = null);

(statearr_14962_17713[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14941 === (6))){
var state_14940__$1 = state_14940;
var statearr_14967_17714 = state_14940__$1;
(statearr_14967_17714[(2)] = null);

(statearr_14967_17714[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14941 === (7))){
var inst_14936 = (state_14940[(2)]);
var state_14940__$1 = state_14940;
var statearr_14970_17716 = state_14940__$1;
(statearr_14970_17716[(2)] = inst_14936);

(statearr_14970_17716[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__17673,c__14556__auto___17701,G__14879_17675,G__14879_17676__$1,n__5593__auto___17672,jobs,results,process__$1,async))
;
return ((function (__17673,switch__14360__auto__,c__14556__auto___17701,G__14879_17675,G__14879_17676__$1,n__5593__auto___17672,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14361__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14361__auto____0 = (function (){
var statearr_14973 = [null,null,null,null,null,null,null];
(statearr_14973[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14361__auto__);

(statearr_14973[(1)] = (1));

return statearr_14973;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14361__auto____1 = (function (state_14940){
while(true){
var ret_value__14362__auto__ = (function (){try{while(true){
var result__14363__auto__ = switch__14360__auto__(state_14940);
if(cljs.core.keyword_identical_QMARK_(result__14363__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14363__auto__;
}
break;
}
}catch (e14976){var ex__14364__auto__ = e14976;
var statearr_14980_17719 = state_14940;
(statearr_14980_17719[(2)] = ex__14364__auto__);


if(cljs.core.seq((state_14940[(4)]))){
var statearr_14982_17720 = state_14940;
(statearr_14982_17720[(1)] = cljs.core.first((state_14940[(4)])));

} else {
throw ex__14364__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14362__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17721 = state_14940;
state_14940 = G__17721;
continue;
} else {
return ret_value__14362__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14361__auto__ = function(state_14940){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14361__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14361__auto____1.call(this,state_14940);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14361__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14361__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14361__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14361__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14361__auto__;
})()
;})(__17673,switch__14360__auto__,c__14556__auto___17701,G__14879_17675,G__14879_17676__$1,n__5593__auto___17672,jobs,results,process__$1,async))
})();
var state__14558__auto__ = (function (){var statearr_14994 = f__14557__auto__();
(statearr_14994[(6)] = c__14556__auto___17701);

return statearr_14994;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14558__auto__);
});})(__17673,c__14556__auto___17701,G__14879_17675,G__14879_17676__$1,n__5593__auto___17672,jobs,results,process__$1,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14879_17676__$1)].join('')));

}

var G__17723 = (__17673 + (1));
__17673 = G__17723;
continue;
} else {
}
break;
}

var c__14556__auto___17724 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14557__auto__ = (function (){var switch__14360__auto__ = (function (state_15018){
var state_val_15019 = (state_15018[(1)]);
if((state_val_15019 === (7))){
var inst_15014 = (state_15018[(2)]);
var state_15018__$1 = state_15018;
var statearr_15025_17725 = state_15018__$1;
(statearr_15025_17725[(2)] = inst_15014);

(statearr_15025_17725[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15019 === (1))){
var state_15018__$1 = state_15018;
var statearr_15026_17726 = state_15018__$1;
(statearr_15026_17726[(2)] = null);

(statearr_15026_17726[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15019 === (4))){
var inst_14997 = (state_15018[(7)]);
var inst_14997__$1 = (state_15018[(2)]);
var inst_14998 = (inst_14997__$1 == null);
var state_15018__$1 = (function (){var statearr_15029 = state_15018;
(statearr_15029[(7)] = inst_14997__$1);

return statearr_15029;
})();
if(cljs.core.truth_(inst_14998)){
var statearr_15030_17727 = state_15018__$1;
(statearr_15030_17727[(1)] = (5));

} else {
var statearr_15031_17728 = state_15018__$1;
(statearr_15031_17728[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15019 === (6))){
var inst_15003 = (state_15018[(8)]);
var inst_14997 = (state_15018[(7)]);
var inst_15003__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_15005 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15006 = [inst_14997,inst_15003__$1];
var inst_15007 = (new cljs.core.PersistentVector(null,2,(5),inst_15005,inst_15006,null));
var state_15018__$1 = (function (){var statearr_15032 = state_15018;
(statearr_15032[(8)] = inst_15003__$1);

return statearr_15032;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15018__$1,(8),jobs,inst_15007);
} else {
if((state_val_15019 === (3))){
var inst_15016 = (state_15018[(2)]);
var state_15018__$1 = state_15018;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15018__$1,inst_15016);
} else {
if((state_val_15019 === (2))){
var state_15018__$1 = state_15018;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15018__$1,(4),from);
} else {
if((state_val_15019 === (9))){
var inst_15011 = (state_15018[(2)]);
var state_15018__$1 = (function (){var statearr_15040 = state_15018;
(statearr_15040[(9)] = inst_15011);

return statearr_15040;
})();
var statearr_15043_17729 = state_15018__$1;
(statearr_15043_17729[(2)] = null);

(statearr_15043_17729[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15019 === (5))){
var inst_15001 = cljs.core.async.close_BANG_(jobs);
var state_15018__$1 = state_15018;
var statearr_15046_17730 = state_15018__$1;
(statearr_15046_17730[(2)] = inst_15001);

(statearr_15046_17730[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15019 === (8))){
var inst_15003 = (state_15018[(8)]);
var inst_15009 = (state_15018[(2)]);
var state_15018__$1 = (function (){var statearr_15048 = state_15018;
(statearr_15048[(10)] = inst_15009);

return statearr_15048;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15018__$1,(9),results,inst_15003);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14361__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14361__auto____0 = (function (){
var statearr_15051 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_15051[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14361__auto__);

(statearr_15051[(1)] = (1));

return statearr_15051;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14361__auto____1 = (function (state_15018){
while(true){
var ret_value__14362__auto__ = (function (){try{while(true){
var result__14363__auto__ = switch__14360__auto__(state_15018);
if(cljs.core.keyword_identical_QMARK_(result__14363__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14363__auto__;
}
break;
}
}catch (e15052){var ex__14364__auto__ = e15052;
var statearr_15053_17731 = state_15018;
(statearr_15053_17731[(2)] = ex__14364__auto__);


if(cljs.core.seq((state_15018[(4)]))){
var statearr_15056_17732 = state_15018;
(statearr_15056_17732[(1)] = cljs.core.first((state_15018[(4)])));

} else {
throw ex__14364__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14362__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17733 = state_15018;
state_15018 = G__17733;
continue;
} else {
return ret_value__14362__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14361__auto__ = function(state_15018){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14361__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14361__auto____1.call(this,state_15018);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14361__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14361__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14361__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14361__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14361__auto__;
})()
})();
var state__14558__auto__ = (function (){var statearr_15059 = f__14557__auto__();
(statearr_15059[(6)] = c__14556__auto___17724);

return statearr_15059;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14558__auto__);
}));


var c__14556__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14557__auto__ = (function (){var switch__14360__auto__ = (function (state_15101){
var state_val_15102 = (state_15101[(1)]);
if((state_val_15102 === (7))){
var inst_15097 = (state_15101[(2)]);
var state_15101__$1 = state_15101;
var statearr_15104_17734 = state_15101__$1;
(statearr_15104_17734[(2)] = inst_15097);

(statearr_15104_17734[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15102 === (20))){
var state_15101__$1 = state_15101;
var statearr_15106_17735 = state_15101__$1;
(statearr_15106_17735[(2)] = null);

(statearr_15106_17735[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15102 === (1))){
var state_15101__$1 = state_15101;
var statearr_15107_17736 = state_15101__$1;
(statearr_15107_17736[(2)] = null);

(statearr_15107_17736[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15102 === (4))){
var inst_15066 = (state_15101[(7)]);
var inst_15066__$1 = (state_15101[(2)]);
var inst_15067 = (inst_15066__$1 == null);
var state_15101__$1 = (function (){var statearr_15108 = state_15101;
(statearr_15108[(7)] = inst_15066__$1);

return statearr_15108;
})();
if(cljs.core.truth_(inst_15067)){
var statearr_15109_17737 = state_15101__$1;
(statearr_15109_17737[(1)] = (5));

} else {
var statearr_15110_17738 = state_15101__$1;
(statearr_15110_17738[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15102 === (15))){
var inst_15079 = (state_15101[(8)]);
var state_15101__$1 = state_15101;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15101__$1,(18),to,inst_15079);
} else {
if((state_val_15102 === (21))){
var inst_15092 = (state_15101[(2)]);
var state_15101__$1 = state_15101;
var statearr_15121_17739 = state_15101__$1;
(statearr_15121_17739[(2)] = inst_15092);

(statearr_15121_17739[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15102 === (13))){
var inst_15094 = (state_15101[(2)]);
var state_15101__$1 = (function (){var statearr_15122 = state_15101;
(statearr_15122[(9)] = inst_15094);

return statearr_15122;
})();
var statearr_15123_17740 = state_15101__$1;
(statearr_15123_17740[(2)] = null);

(statearr_15123_17740[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15102 === (6))){
var inst_15066 = (state_15101[(7)]);
var state_15101__$1 = state_15101;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15101__$1,(11),inst_15066);
} else {
if((state_val_15102 === (17))){
var inst_15087 = (state_15101[(2)]);
var state_15101__$1 = state_15101;
if(cljs.core.truth_(inst_15087)){
var statearr_15126_17741 = state_15101__$1;
(statearr_15126_17741[(1)] = (19));

} else {
var statearr_15128_17742 = state_15101__$1;
(statearr_15128_17742[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15102 === (3))){
var inst_15099 = (state_15101[(2)]);
var state_15101__$1 = state_15101;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15101__$1,inst_15099);
} else {
if((state_val_15102 === (12))){
var inst_15076 = (state_15101[(10)]);
var state_15101__$1 = state_15101;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15101__$1,(14),inst_15076);
} else {
if((state_val_15102 === (2))){
var state_15101__$1 = state_15101;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15101__$1,(4),results);
} else {
if((state_val_15102 === (19))){
var state_15101__$1 = state_15101;
var statearr_15133_17743 = state_15101__$1;
(statearr_15133_17743[(2)] = null);

(statearr_15133_17743[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15102 === (11))){
var inst_15076 = (state_15101[(2)]);
var state_15101__$1 = (function (){var statearr_15137 = state_15101;
(statearr_15137[(10)] = inst_15076);

return statearr_15137;
})();
var statearr_15138_17744 = state_15101__$1;
(statearr_15138_17744[(2)] = null);

(statearr_15138_17744[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15102 === (9))){
var state_15101__$1 = state_15101;
var statearr_15141_17745 = state_15101__$1;
(statearr_15141_17745[(2)] = null);

(statearr_15141_17745[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15102 === (5))){
var state_15101__$1 = state_15101;
if(cljs.core.truth_(close_QMARK_)){
var statearr_15142_17746 = state_15101__$1;
(statearr_15142_17746[(1)] = (8));

} else {
var statearr_15145_17747 = state_15101__$1;
(statearr_15145_17747[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15102 === (14))){
var inst_15079 = (state_15101[(8)]);
var inst_15081 = (state_15101[(11)]);
var inst_15079__$1 = (state_15101[(2)]);
var inst_15080 = (inst_15079__$1 == null);
var inst_15081__$1 = cljs.core.not(inst_15080);
var state_15101__$1 = (function (){var statearr_15146 = state_15101;
(statearr_15146[(8)] = inst_15079__$1);

(statearr_15146[(11)] = inst_15081__$1);

return statearr_15146;
})();
if(inst_15081__$1){
var statearr_15147_17748 = state_15101__$1;
(statearr_15147_17748[(1)] = (15));

} else {
var statearr_15148_17749 = state_15101__$1;
(statearr_15148_17749[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15102 === (16))){
var inst_15081 = (state_15101[(11)]);
var state_15101__$1 = state_15101;
var statearr_15149_17750 = state_15101__$1;
(statearr_15149_17750[(2)] = inst_15081);

(statearr_15149_17750[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15102 === (10))){
var inst_15073 = (state_15101[(2)]);
var state_15101__$1 = state_15101;
var statearr_15151_17751 = state_15101__$1;
(statearr_15151_17751[(2)] = inst_15073);

(statearr_15151_17751[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15102 === (18))){
var inst_15084 = (state_15101[(2)]);
var state_15101__$1 = state_15101;
var statearr_15154_17752 = state_15101__$1;
(statearr_15154_17752[(2)] = inst_15084);

(statearr_15154_17752[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15102 === (8))){
var inst_15070 = cljs.core.async.close_BANG_(to);
var state_15101__$1 = state_15101;
var statearr_15158_17753 = state_15101__$1;
(statearr_15158_17753[(2)] = inst_15070);

(statearr_15158_17753[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14361__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14361__auto____0 = (function (){
var statearr_15159 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15159[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14361__auto__);

(statearr_15159[(1)] = (1));

return statearr_15159;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14361__auto____1 = (function (state_15101){
while(true){
var ret_value__14362__auto__ = (function (){try{while(true){
var result__14363__auto__ = switch__14360__auto__(state_15101);
if(cljs.core.keyword_identical_QMARK_(result__14363__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14363__auto__;
}
break;
}
}catch (e15162){var ex__14364__auto__ = e15162;
var statearr_15163_17754 = state_15101;
(statearr_15163_17754[(2)] = ex__14364__auto__);


if(cljs.core.seq((state_15101[(4)]))){
var statearr_15164_17755 = state_15101;
(statearr_15164_17755[(1)] = cljs.core.first((state_15101[(4)])));

} else {
throw ex__14364__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14362__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17756 = state_15101;
state_15101 = G__17756;
continue;
} else {
return ret_value__14362__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14361__auto__ = function(state_15101){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14361__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14361__auto____1.call(this,state_15101);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14361__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14361__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14361__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14361__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14361__auto__;
})()
})();
var state__14558__auto__ = (function (){var statearr_15179 = f__14557__auto__();
(statearr_15179[(6)] = c__14556__auto__);

return statearr_15179;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14558__auto__);
}));

return c__14556__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). The
 *   presumption is that af will return immediately, having launched some
 *   asynchronous operation whose completion/callback will put results on
 *   the channel, then close! it. Outputs will be returned in order
 *   relative to the inputs. By default, the to channel will be closed
 *   when the from channel closes, but can be determined by the close?
 *   parameter. Will stop consuming the from channel if the to channel
 *   closes. See also pipeline, pipeline-blocking.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__15192 = arguments.length;
switch (G__15192) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__15205 = arguments.length;
switch (G__15205) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__15235 = arguments.length;
switch (G__15235) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__14556__auto___17760 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14557__auto__ = (function (){var switch__14360__auto__ = (function (state_15295){
var state_val_15296 = (state_15295[(1)]);
if((state_val_15296 === (7))){
var inst_15290 = (state_15295[(2)]);
var state_15295__$1 = state_15295;
var statearr_15320_17761 = state_15295__$1;
(statearr_15320_17761[(2)] = inst_15290);

(statearr_15320_17761[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (1))){
var state_15295__$1 = state_15295;
var statearr_15321_17762 = state_15295__$1;
(statearr_15321_17762[(2)] = null);

(statearr_15321_17762[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (4))){
var inst_15267 = (state_15295[(7)]);
var inst_15267__$1 = (state_15295[(2)]);
var inst_15272 = (inst_15267__$1 == null);
var state_15295__$1 = (function (){var statearr_15322 = state_15295;
(statearr_15322[(7)] = inst_15267__$1);

return statearr_15322;
})();
if(cljs.core.truth_(inst_15272)){
var statearr_15324_17763 = state_15295__$1;
(statearr_15324_17763[(1)] = (5));

} else {
var statearr_15325_17764 = state_15295__$1;
(statearr_15325_17764[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (13))){
var state_15295__$1 = state_15295;
var statearr_15326_17765 = state_15295__$1;
(statearr_15326_17765[(2)] = null);

(statearr_15326_17765[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (6))){
var inst_15267 = (state_15295[(7)]);
var inst_15277 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_15267) : p.call(null,inst_15267));
var state_15295__$1 = state_15295;
if(cljs.core.truth_(inst_15277)){
var statearr_15328_17766 = state_15295__$1;
(statearr_15328_17766[(1)] = (9));

} else {
var statearr_15331_17767 = state_15295__$1;
(statearr_15331_17767[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (3))){
var inst_15292 = (state_15295[(2)]);
var state_15295__$1 = state_15295;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15295__$1,inst_15292);
} else {
if((state_val_15296 === (12))){
var state_15295__$1 = state_15295;
var statearr_15336_17768 = state_15295__$1;
(statearr_15336_17768[(2)] = null);

(statearr_15336_17768[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (2))){
var state_15295__$1 = state_15295;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15295__$1,(4),ch);
} else {
if((state_val_15296 === (11))){
var inst_15267 = (state_15295[(7)]);
var inst_15281 = (state_15295[(2)]);
var state_15295__$1 = state_15295;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15295__$1,(8),inst_15281,inst_15267);
} else {
if((state_val_15296 === (9))){
var state_15295__$1 = state_15295;
var statearr_15341_17769 = state_15295__$1;
(statearr_15341_17769[(2)] = tc);

(statearr_15341_17769[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (5))){
var inst_15274 = cljs.core.async.close_BANG_(tc);
var inst_15275 = cljs.core.async.close_BANG_(fc);
var state_15295__$1 = (function (){var statearr_15344 = state_15295;
(statearr_15344[(8)] = inst_15274);

return statearr_15344;
})();
var statearr_15345_17770 = state_15295__$1;
(statearr_15345_17770[(2)] = inst_15275);

(statearr_15345_17770[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (14))){
var inst_15288 = (state_15295[(2)]);
var state_15295__$1 = state_15295;
var statearr_15346_17771 = state_15295__$1;
(statearr_15346_17771[(2)] = inst_15288);

(statearr_15346_17771[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (10))){
var state_15295__$1 = state_15295;
var statearr_15355_17772 = state_15295__$1;
(statearr_15355_17772[(2)] = fc);

(statearr_15355_17772[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (8))){
var inst_15283 = (state_15295[(2)]);
var state_15295__$1 = state_15295;
if(cljs.core.truth_(inst_15283)){
var statearr_15356_17773 = state_15295__$1;
(statearr_15356_17773[(1)] = (12));

} else {
var statearr_15361_17774 = state_15295__$1;
(statearr_15361_17774[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__14361__auto__ = null;
var cljs$core$async$state_machine__14361__auto____0 = (function (){
var statearr_15365 = [null,null,null,null,null,null,null,null,null];
(statearr_15365[(0)] = cljs$core$async$state_machine__14361__auto__);

(statearr_15365[(1)] = (1));

return statearr_15365;
});
var cljs$core$async$state_machine__14361__auto____1 = (function (state_15295){
while(true){
var ret_value__14362__auto__ = (function (){try{while(true){
var result__14363__auto__ = switch__14360__auto__(state_15295);
if(cljs.core.keyword_identical_QMARK_(result__14363__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14363__auto__;
}
break;
}
}catch (e15366){var ex__14364__auto__ = e15366;
var statearr_15367_17775 = state_15295;
(statearr_15367_17775[(2)] = ex__14364__auto__);


if(cljs.core.seq((state_15295[(4)]))){
var statearr_15368_17776 = state_15295;
(statearr_15368_17776[(1)] = cljs.core.first((state_15295[(4)])));

} else {
throw ex__14364__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14362__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17778 = state_15295;
state_15295 = G__17778;
continue;
} else {
return ret_value__14362__auto__;
}
break;
}
});
cljs$core$async$state_machine__14361__auto__ = function(state_15295){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14361__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14361__auto____1.call(this,state_15295);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14361__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14361__auto____0;
cljs$core$async$state_machine__14361__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14361__auto____1;
return cljs$core$async$state_machine__14361__auto__;
})()
})();
var state__14558__auto__ = (function (){var statearr_15370 = f__14557__auto__();
(statearr_15370[(6)] = c__14556__auto___17760);

return statearr_15370;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14558__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__14556__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14557__auto__ = (function (){var switch__14360__auto__ = (function (state_15393){
var state_val_15394 = (state_15393[(1)]);
if((state_val_15394 === (7))){
var inst_15389 = (state_15393[(2)]);
var state_15393__$1 = state_15393;
var statearr_15398_17779 = state_15393__$1;
(statearr_15398_17779[(2)] = inst_15389);

(statearr_15398_17779[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15394 === (1))){
var inst_15371 = init;
var inst_15372 = inst_15371;
var state_15393__$1 = (function (){var statearr_15399 = state_15393;
(statearr_15399[(7)] = inst_15372);

return statearr_15399;
})();
var statearr_15400_17780 = state_15393__$1;
(statearr_15400_17780[(2)] = null);

(statearr_15400_17780[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15394 === (4))){
var inst_15375 = (state_15393[(8)]);
var inst_15375__$1 = (state_15393[(2)]);
var inst_15376 = (inst_15375__$1 == null);
var state_15393__$1 = (function (){var statearr_15401 = state_15393;
(statearr_15401[(8)] = inst_15375__$1);

return statearr_15401;
})();
if(cljs.core.truth_(inst_15376)){
var statearr_15402_17781 = state_15393__$1;
(statearr_15402_17781[(1)] = (5));

} else {
var statearr_15403_17782 = state_15393__$1;
(statearr_15403_17782[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15394 === (6))){
var inst_15379 = (state_15393[(9)]);
var inst_15372 = (state_15393[(7)]);
var inst_15375 = (state_15393[(8)]);
var inst_15379__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_15372,inst_15375) : f.call(null,inst_15372,inst_15375));
var inst_15380 = cljs.core.reduced_QMARK_(inst_15379__$1);
var state_15393__$1 = (function (){var statearr_15404 = state_15393;
(statearr_15404[(9)] = inst_15379__$1);

return statearr_15404;
})();
if(inst_15380){
var statearr_15405_17784 = state_15393__$1;
(statearr_15405_17784[(1)] = (8));

} else {
var statearr_15406_17785 = state_15393__$1;
(statearr_15406_17785[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15394 === (3))){
var inst_15391 = (state_15393[(2)]);
var state_15393__$1 = state_15393;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15393__$1,inst_15391);
} else {
if((state_val_15394 === (2))){
var state_15393__$1 = state_15393;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15393__$1,(4),ch);
} else {
if((state_val_15394 === (9))){
var inst_15379 = (state_15393[(9)]);
var inst_15372 = inst_15379;
var state_15393__$1 = (function (){var statearr_15409 = state_15393;
(statearr_15409[(7)] = inst_15372);

return statearr_15409;
})();
var statearr_15410_17787 = state_15393__$1;
(statearr_15410_17787[(2)] = null);

(statearr_15410_17787[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15394 === (5))){
var inst_15372 = (state_15393[(7)]);
var state_15393__$1 = state_15393;
var statearr_15411_17788 = state_15393__$1;
(statearr_15411_17788[(2)] = inst_15372);

(statearr_15411_17788[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15394 === (10))){
var inst_15387 = (state_15393[(2)]);
var state_15393__$1 = state_15393;
var statearr_15414_17789 = state_15393__$1;
(statearr_15414_17789[(2)] = inst_15387);

(statearr_15414_17789[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15394 === (8))){
var inst_15379 = (state_15393[(9)]);
var inst_15382 = cljs.core.deref(inst_15379);
var state_15393__$1 = state_15393;
var statearr_15417_17790 = state_15393__$1;
(statearr_15417_17790[(2)] = inst_15382);

(statearr_15417_17790[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__14361__auto__ = null;
var cljs$core$async$reduce_$_state_machine__14361__auto____0 = (function (){
var statearr_15418 = [null,null,null,null,null,null,null,null,null,null];
(statearr_15418[(0)] = cljs$core$async$reduce_$_state_machine__14361__auto__);

(statearr_15418[(1)] = (1));

return statearr_15418;
});
var cljs$core$async$reduce_$_state_machine__14361__auto____1 = (function (state_15393){
while(true){
var ret_value__14362__auto__ = (function (){try{while(true){
var result__14363__auto__ = switch__14360__auto__(state_15393);
if(cljs.core.keyword_identical_QMARK_(result__14363__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14363__auto__;
}
break;
}
}catch (e15419){var ex__14364__auto__ = e15419;
var statearr_15420_17791 = state_15393;
(statearr_15420_17791[(2)] = ex__14364__auto__);


if(cljs.core.seq((state_15393[(4)]))){
var statearr_15421_17792 = state_15393;
(statearr_15421_17792[(1)] = cljs.core.first((state_15393[(4)])));

} else {
throw ex__14364__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14362__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17793 = state_15393;
state_15393 = G__17793;
continue;
} else {
return ret_value__14362__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__14361__auto__ = function(state_15393){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__14361__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__14361__auto____1.call(this,state_15393);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__14361__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__14361__auto____0;
cljs$core$async$reduce_$_state_machine__14361__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__14361__auto____1;
return cljs$core$async$reduce_$_state_machine__14361__auto__;
})()
})();
var state__14558__auto__ = (function (){var statearr_15422 = f__14557__auto__();
(statearr_15422[(6)] = c__14556__auto__);

return statearr_15422;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14558__auto__);
}));

return c__14556__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__14556__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14557__auto__ = (function (){var switch__14360__auto__ = (function (state_15429){
var state_val_15430 = (state_15429[(1)]);
if((state_val_15430 === (1))){
var inst_15424 = cljs.core.async.reduce(f__$1,init,ch);
var state_15429__$1 = state_15429;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15429__$1,(2),inst_15424);
} else {
if((state_val_15430 === (2))){
var inst_15426 = (state_15429[(2)]);
var inst_15427 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_15426) : f__$1.call(null,inst_15426));
var state_15429__$1 = state_15429;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15429__$1,inst_15427);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__14361__auto__ = null;
var cljs$core$async$transduce_$_state_machine__14361__auto____0 = (function (){
var statearr_15448 = [null,null,null,null,null,null,null];
(statearr_15448[(0)] = cljs$core$async$transduce_$_state_machine__14361__auto__);

(statearr_15448[(1)] = (1));

return statearr_15448;
});
var cljs$core$async$transduce_$_state_machine__14361__auto____1 = (function (state_15429){
while(true){
var ret_value__14362__auto__ = (function (){try{while(true){
var result__14363__auto__ = switch__14360__auto__(state_15429);
if(cljs.core.keyword_identical_QMARK_(result__14363__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14363__auto__;
}
break;
}
}catch (e15457){var ex__14364__auto__ = e15457;
var statearr_15458_17794 = state_15429;
(statearr_15458_17794[(2)] = ex__14364__auto__);


if(cljs.core.seq((state_15429[(4)]))){
var statearr_15459_17795 = state_15429;
(statearr_15459_17795[(1)] = cljs.core.first((state_15429[(4)])));

} else {
throw ex__14364__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14362__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17796 = state_15429;
state_15429 = G__17796;
continue;
} else {
return ret_value__14362__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__14361__auto__ = function(state_15429){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__14361__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__14361__auto____1.call(this,state_15429);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__14361__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__14361__auto____0;
cljs$core$async$transduce_$_state_machine__14361__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__14361__auto____1;
return cljs$core$async$transduce_$_state_machine__14361__auto__;
})()
})();
var state__14558__auto__ = (function (){var statearr_15464 = f__14557__auto__();
(statearr_15464[(6)] = c__14556__auto__);

return statearr_15464;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14558__auto__);
}));

return c__14556__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__15466 = arguments.length;
switch (G__15466) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__14556__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14557__auto__ = (function (){var switch__14360__auto__ = (function (state_15493){
var state_val_15494 = (state_15493[(1)]);
if((state_val_15494 === (7))){
var inst_15475 = (state_15493[(2)]);
var state_15493__$1 = state_15493;
var statearr_15499_17799 = state_15493__$1;
(statearr_15499_17799[(2)] = inst_15475);

(statearr_15499_17799[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15494 === (1))){
var inst_15469 = cljs.core.seq(coll);
var inst_15470 = inst_15469;
var state_15493__$1 = (function (){var statearr_15500 = state_15493;
(statearr_15500[(7)] = inst_15470);

return statearr_15500;
})();
var statearr_15501_17800 = state_15493__$1;
(statearr_15501_17800[(2)] = null);

(statearr_15501_17800[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15494 === (4))){
var inst_15470 = (state_15493[(7)]);
var inst_15473 = cljs.core.first(inst_15470);
var state_15493__$1 = state_15493;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15493__$1,(7),ch,inst_15473);
} else {
if((state_val_15494 === (13))){
var inst_15487 = (state_15493[(2)]);
var state_15493__$1 = state_15493;
var statearr_15509_17801 = state_15493__$1;
(statearr_15509_17801[(2)] = inst_15487);

(statearr_15509_17801[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15494 === (6))){
var inst_15478 = (state_15493[(2)]);
var state_15493__$1 = state_15493;
if(cljs.core.truth_(inst_15478)){
var statearr_15518_17802 = state_15493__$1;
(statearr_15518_17802[(1)] = (8));

} else {
var statearr_15522_17803 = state_15493__$1;
(statearr_15522_17803[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15494 === (3))){
var inst_15491 = (state_15493[(2)]);
var state_15493__$1 = state_15493;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15493__$1,inst_15491);
} else {
if((state_val_15494 === (12))){
var state_15493__$1 = state_15493;
var statearr_15529_17804 = state_15493__$1;
(statearr_15529_17804[(2)] = null);

(statearr_15529_17804[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15494 === (2))){
var inst_15470 = (state_15493[(7)]);
var state_15493__$1 = state_15493;
if(cljs.core.truth_(inst_15470)){
var statearr_15530_17806 = state_15493__$1;
(statearr_15530_17806[(1)] = (4));

} else {
var statearr_15531_17807 = state_15493__$1;
(statearr_15531_17807[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15494 === (11))){
var inst_15484 = cljs.core.async.close_BANG_(ch);
var state_15493__$1 = state_15493;
var statearr_15532_17808 = state_15493__$1;
(statearr_15532_17808[(2)] = inst_15484);

(statearr_15532_17808[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15494 === (9))){
var state_15493__$1 = state_15493;
if(cljs.core.truth_(close_QMARK_)){
var statearr_15533_17810 = state_15493__$1;
(statearr_15533_17810[(1)] = (11));

} else {
var statearr_15534_17811 = state_15493__$1;
(statearr_15534_17811[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15494 === (5))){
var inst_15470 = (state_15493[(7)]);
var state_15493__$1 = state_15493;
var statearr_15537_17812 = state_15493__$1;
(statearr_15537_17812[(2)] = inst_15470);

(statearr_15537_17812[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15494 === (10))){
var inst_15489 = (state_15493[(2)]);
var state_15493__$1 = state_15493;
var statearr_15538_17813 = state_15493__$1;
(statearr_15538_17813[(2)] = inst_15489);

(statearr_15538_17813[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15494 === (8))){
var inst_15470 = (state_15493[(7)]);
var inst_15480 = cljs.core.next(inst_15470);
var inst_15470__$1 = inst_15480;
var state_15493__$1 = (function (){var statearr_15539 = state_15493;
(statearr_15539[(7)] = inst_15470__$1);

return statearr_15539;
})();
var statearr_15540_17814 = state_15493__$1;
(statearr_15540_17814[(2)] = null);

(statearr_15540_17814[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__14361__auto__ = null;
var cljs$core$async$state_machine__14361__auto____0 = (function (){
var statearr_15541 = [null,null,null,null,null,null,null,null];
(statearr_15541[(0)] = cljs$core$async$state_machine__14361__auto__);

(statearr_15541[(1)] = (1));

return statearr_15541;
});
var cljs$core$async$state_machine__14361__auto____1 = (function (state_15493){
while(true){
var ret_value__14362__auto__ = (function (){try{while(true){
var result__14363__auto__ = switch__14360__auto__(state_15493);
if(cljs.core.keyword_identical_QMARK_(result__14363__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14363__auto__;
}
break;
}
}catch (e15542){var ex__14364__auto__ = e15542;
var statearr_15543_17815 = state_15493;
(statearr_15543_17815[(2)] = ex__14364__auto__);


if(cljs.core.seq((state_15493[(4)]))){
var statearr_15544_17816 = state_15493;
(statearr_15544_17816[(1)] = cljs.core.first((state_15493[(4)])));

} else {
throw ex__14364__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14362__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17818 = state_15493;
state_15493 = G__17818;
continue;
} else {
return ret_value__14362__auto__;
}
break;
}
});
cljs$core$async$state_machine__14361__auto__ = function(state_15493){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14361__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14361__auto____1.call(this,state_15493);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14361__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14361__auto____0;
cljs$core$async$state_machine__14361__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14361__auto____1;
return cljs$core$async$state_machine__14361__auto__;
})()
})();
var state__14558__auto__ = (function (){var statearr_15545 = f__14557__auto__();
(statearr_15545[(6)] = c__14556__auto__);

return statearr_15545;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14558__auto__);
}));

return c__14556__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__15547 = arguments.length;
switch (G__15547) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_17820 = (function (_){
var x__5350__auto__ = (((_ == null))?null:_);
var m__5351__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5351__auto__.call(null,_));
} else {
var m__5349__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5349__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_17820(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_17823 = (function (m,ch,close_QMARK_){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5351__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__5349__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5349__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_17823(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_17825 = (function (m,ch){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5351__auto__.call(null,m,ch));
} else {
var m__5349__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5349__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_17825(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_17828 = (function (m){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5351__auto__.call(null,m));
} else {
var m__5349__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5349__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_17828(m);
}
});


/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15553 = (function (ch,cs,meta15554){
this.ch = ch;
this.cs = cs;
this.meta15554 = meta15554;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async15553.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15555,meta15554__$1){
var self__ = this;
var _15555__$1 = this;
return (new cljs.core.async.t_cljs$core$async15553(self__.ch,self__.cs,meta15554__$1));
}));

(cljs.core.async.t_cljs$core$async15553.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15555){
var self__ = this;
var _15555__$1 = this;
return self__.meta15554;
}));

(cljs.core.async.t_cljs$core$async15553.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15553.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async15553.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15553.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async15553.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async15553.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async15553.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta15554","meta15554",-373245071,null)], null);
}));

(cljs.core.async.t_cljs$core$async15553.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async15553.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15553");

(cljs.core.async.t_cljs$core$async15553.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async15553");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async15553.
 */
cljs.core.async.__GT_t_cljs$core$async15553 = (function cljs$core$async$__GT_t_cljs$core$async15553(ch,cs,meta15554){
return (new cljs.core.async.t_cljs$core$async15553(ch,cs,meta15554));
});


/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (new cljs.core.async.t_cljs$core$async15553(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__14556__auto___17830 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14557__auto__ = (function (){var switch__14360__auto__ = (function (state_15698){
var state_val_15699 = (state_15698[(1)]);
if((state_val_15699 === (7))){
var inst_15693 = (state_15698[(2)]);
var state_15698__$1 = state_15698;
var statearr_15705_17831 = state_15698__$1;
(statearr_15705_17831[(2)] = inst_15693);

(statearr_15705_17831[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15699 === (20))){
var inst_15594 = (state_15698[(7)]);
var inst_15606 = cljs.core.first(inst_15594);
var inst_15607 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15606,(0),null);
var inst_15608 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15606,(1),null);
var state_15698__$1 = (function (){var statearr_15707 = state_15698;
(statearr_15707[(8)] = inst_15607);

return statearr_15707;
})();
if(cljs.core.truth_(inst_15608)){
var statearr_15708_17833 = state_15698__$1;
(statearr_15708_17833[(1)] = (22));

} else {
var statearr_15709_17834 = state_15698__$1;
(statearr_15709_17834[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15699 === (27))){
var inst_15646 = (state_15698[(9)]);
var inst_15639 = (state_15698[(10)]);
var inst_15561 = (state_15698[(11)]);
var inst_15641 = (state_15698[(12)]);
var inst_15646__$1 = cljs.core._nth(inst_15639,inst_15641);
var inst_15647 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_15646__$1,inst_15561,done);
var state_15698__$1 = (function (){var statearr_15710 = state_15698;
(statearr_15710[(9)] = inst_15646__$1);

return statearr_15710;
})();
if(cljs.core.truth_(inst_15647)){
var statearr_15711_17835 = state_15698__$1;
(statearr_15711_17835[(1)] = (30));

} else {
var statearr_15712_17836 = state_15698__$1;
(statearr_15712_17836[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15699 === (1))){
var state_15698__$1 = state_15698;
var statearr_15713_17837 = state_15698__$1;
(statearr_15713_17837[(2)] = null);

(statearr_15713_17837[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15699 === (24))){
var inst_15594 = (state_15698[(7)]);
var inst_15616 = (state_15698[(2)]);
var inst_15617 = cljs.core.next(inst_15594);
var inst_15570 = inst_15617;
var inst_15571 = null;
var inst_15572 = (0);
var inst_15573 = (0);
var state_15698__$1 = (function (){var statearr_15716 = state_15698;
(statearr_15716[(13)] = inst_15616);

(statearr_15716[(14)] = inst_15572);

(statearr_15716[(15)] = inst_15573);

(statearr_15716[(16)] = inst_15571);

(statearr_15716[(17)] = inst_15570);

return statearr_15716;
})();
var statearr_15717_17838 = state_15698__$1;
(statearr_15717_17838[(2)] = null);

(statearr_15717_17838[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15699 === (39))){
var state_15698__$1 = state_15698;
var statearr_15722_17839 = state_15698__$1;
(statearr_15722_17839[(2)] = null);

(statearr_15722_17839[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15699 === (4))){
var inst_15561 = (state_15698[(11)]);
var inst_15561__$1 = (state_15698[(2)]);
var inst_15562 = (inst_15561__$1 == null);
var state_15698__$1 = (function (){var statearr_15723 = state_15698;
(statearr_15723[(11)] = inst_15561__$1);

return statearr_15723;
})();
if(cljs.core.truth_(inst_15562)){
var statearr_15724_17840 = state_15698__$1;
(statearr_15724_17840[(1)] = (5));

} else {
var statearr_15725_17841 = state_15698__$1;
(statearr_15725_17841[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15699 === (15))){
var inst_15572 = (state_15698[(14)]);
var inst_15573 = (state_15698[(15)]);
var inst_15571 = (state_15698[(16)]);
var inst_15570 = (state_15698[(17)]);
var inst_15589 = (state_15698[(2)]);
var inst_15590 = (inst_15573 + (1));
var tmp15718 = inst_15572;
var tmp15719 = inst_15571;
var tmp15720 = inst_15570;
var inst_15570__$1 = tmp15720;
var inst_15571__$1 = tmp15719;
var inst_15572__$1 = tmp15718;
var inst_15573__$1 = inst_15590;
var state_15698__$1 = (function (){var statearr_15726 = state_15698;
(statearr_15726[(14)] = inst_15572__$1);

(statearr_15726[(15)] = inst_15573__$1);

(statearr_15726[(16)] = inst_15571__$1);

(statearr_15726[(18)] = inst_15589);

(statearr_15726[(17)] = inst_15570__$1);

return statearr_15726;
})();
var statearr_15727_17844 = state_15698__$1;
(statearr_15727_17844[(2)] = null);

(statearr_15727_17844[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15699 === (21))){
var inst_15620 = (state_15698[(2)]);
var state_15698__$1 = state_15698;
var statearr_15731_17845 = state_15698__$1;
(statearr_15731_17845[(2)] = inst_15620);

(statearr_15731_17845[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15699 === (31))){
var inst_15646 = (state_15698[(9)]);
var inst_15650 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_15646);
var state_15698__$1 = state_15698;
var statearr_15732_17846 = state_15698__$1;
(statearr_15732_17846[(2)] = inst_15650);

(statearr_15732_17846[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15699 === (32))){
var inst_15639 = (state_15698[(10)]);
var inst_15640 = (state_15698[(19)]);
var inst_15638 = (state_15698[(20)]);
var inst_15641 = (state_15698[(12)]);
var inst_15652 = (state_15698[(2)]);
var inst_15653 = (inst_15641 + (1));
var tmp15728 = inst_15639;
var tmp15729 = inst_15640;
var tmp15730 = inst_15638;
var inst_15638__$1 = tmp15730;
var inst_15639__$1 = tmp15728;
var inst_15640__$1 = tmp15729;
var inst_15641__$1 = inst_15653;
var state_15698__$1 = (function (){var statearr_15733 = state_15698;
(statearr_15733[(10)] = inst_15639__$1);

(statearr_15733[(19)] = inst_15640__$1);

(statearr_15733[(20)] = inst_15638__$1);

(statearr_15733[(12)] = inst_15641__$1);

(statearr_15733[(21)] = inst_15652);

return statearr_15733;
})();
var statearr_15734_17847 = state_15698__$1;
(statearr_15734_17847[(2)] = null);

(statearr_15734_17847[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15699 === (40))){
var inst_15666 = (state_15698[(22)]);
var inst_15670 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_15666);
var state_15698__$1 = state_15698;
var statearr_15736_17851 = state_15698__$1;
(statearr_15736_17851[(2)] = inst_15670);

(statearr_15736_17851[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15699 === (33))){
var inst_15656 = (state_15698[(23)]);
var inst_15658 = cljs.core.chunked_seq_QMARK_(inst_15656);
var state_15698__$1 = state_15698;
if(inst_15658){
var statearr_15737_17852 = state_15698__$1;
(statearr_15737_17852[(1)] = (36));

} else {
var statearr_15738_17853 = state_15698__$1;
(statearr_15738_17853[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15699 === (13))){
var inst_15582 = (state_15698[(24)]);
var inst_15586 = cljs.core.async.close_BANG_(inst_15582);
var state_15698__$1 = state_15698;
var statearr_15739_17854 = state_15698__$1;
(statearr_15739_17854[(2)] = inst_15586);

(statearr_15739_17854[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15699 === (22))){
var inst_15607 = (state_15698[(8)]);
var inst_15613 = cljs.core.async.close_BANG_(inst_15607);
var state_15698__$1 = state_15698;
var statearr_15741_17855 = state_15698__$1;
(statearr_15741_17855[(2)] = inst_15613);

(statearr_15741_17855[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15699 === (36))){
var inst_15656 = (state_15698[(23)]);
var inst_15661 = cljs.core.chunk_first(inst_15656);
var inst_15662 = cljs.core.chunk_rest(inst_15656);
var inst_15663 = cljs.core.count(inst_15661);
var inst_15638 = inst_15662;
var inst_15639 = inst_15661;
var inst_15640 = inst_15663;
var inst_15641 = (0);
var state_15698__$1 = (function (){var statearr_15743 = state_15698;
(statearr_15743[(10)] = inst_15639);

(statearr_15743[(19)] = inst_15640);

(statearr_15743[(20)] = inst_15638);

(statearr_15743[(12)] = inst_15641);

return statearr_15743;
})();
var statearr_15744_17856 = state_15698__$1;
(statearr_15744_17856[(2)] = null);

(statearr_15744_17856[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15699 === (41))){
var inst_15656 = (state_15698[(23)]);
var inst_15672 = (state_15698[(2)]);
var inst_15673 = cljs.core.next(inst_15656);
var inst_15638 = inst_15673;
var inst_15639 = null;
var inst_15640 = (0);
var inst_15641 = (0);
var state_15698__$1 = (function (){var statearr_15745 = state_15698;
(statearr_15745[(10)] = inst_15639);

(statearr_15745[(19)] = inst_15640);

(statearr_15745[(20)] = inst_15638);

(statearr_15745[(12)] = inst_15641);

(statearr_15745[(25)] = inst_15672);

return statearr_15745;
})();
var statearr_15746_17858 = state_15698__$1;
(statearr_15746_17858[(2)] = null);

(statearr_15746_17858[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15699 === (43))){
var state_15698__$1 = state_15698;
var statearr_15749_17859 = state_15698__$1;
(statearr_15749_17859[(2)] = null);

(statearr_15749_17859[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15699 === (29))){
var inst_15681 = (state_15698[(2)]);
var state_15698__$1 = state_15698;
var statearr_15752_17860 = state_15698__$1;
(statearr_15752_17860[(2)] = inst_15681);

(statearr_15752_17860[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15699 === (44))){
var inst_15690 = (state_15698[(2)]);
var state_15698__$1 = (function (){var statearr_15757 = state_15698;
(statearr_15757[(26)] = inst_15690);

return statearr_15757;
})();
var statearr_15758_17861 = state_15698__$1;
(statearr_15758_17861[(2)] = null);

(statearr_15758_17861[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15699 === (6))){
var inst_15630 = (state_15698[(27)]);
var inst_15629 = cljs.core.deref(cs);
var inst_15630__$1 = cljs.core.keys(inst_15629);
var inst_15631 = cljs.core.count(inst_15630__$1);
var inst_15632 = cljs.core.reset_BANG_(dctr,inst_15631);
var inst_15637 = cljs.core.seq(inst_15630__$1);
var inst_15638 = inst_15637;
var inst_15639 = null;
var inst_15640 = (0);
var inst_15641 = (0);
var state_15698__$1 = (function (){var statearr_15761 = state_15698;
(statearr_15761[(27)] = inst_15630__$1);

(statearr_15761[(28)] = inst_15632);

(statearr_15761[(10)] = inst_15639);

(statearr_15761[(19)] = inst_15640);

(statearr_15761[(20)] = inst_15638);

(statearr_15761[(12)] = inst_15641);

return statearr_15761;
})();
var statearr_15764_17862 = state_15698__$1;
(statearr_15764_17862[(2)] = null);

(statearr_15764_17862[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15699 === (28))){
var inst_15656 = (state_15698[(23)]);
var inst_15638 = (state_15698[(20)]);
var inst_15656__$1 = cljs.core.seq(inst_15638);
var state_15698__$1 = (function (){var statearr_15765 = state_15698;
(statearr_15765[(23)] = inst_15656__$1);

return statearr_15765;
})();
if(inst_15656__$1){
var statearr_15768_17863 = state_15698__$1;
(statearr_15768_17863[(1)] = (33));

} else {
var statearr_15769_17864 = state_15698__$1;
(statearr_15769_17864[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15699 === (25))){
var inst_15640 = (state_15698[(19)]);
var inst_15641 = (state_15698[(12)]);
var inst_15643 = (inst_15641 < inst_15640);
var inst_15644 = inst_15643;
var state_15698__$1 = state_15698;
if(cljs.core.truth_(inst_15644)){
var statearr_15770_17867 = state_15698__$1;
(statearr_15770_17867[(1)] = (27));

} else {
var statearr_15772_17868 = state_15698__$1;
(statearr_15772_17868[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15699 === (34))){
var state_15698__$1 = state_15698;
var statearr_15773_17869 = state_15698__$1;
(statearr_15773_17869[(2)] = null);

(statearr_15773_17869[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15699 === (17))){
var state_15698__$1 = state_15698;
var statearr_15776_17874 = state_15698__$1;
(statearr_15776_17874[(2)] = null);

(statearr_15776_17874[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15699 === (3))){
var inst_15695 = (state_15698[(2)]);
var state_15698__$1 = state_15698;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15698__$1,inst_15695);
} else {
if((state_val_15699 === (12))){
var inst_15625 = (state_15698[(2)]);
var state_15698__$1 = state_15698;
var statearr_15779_17876 = state_15698__$1;
(statearr_15779_17876[(2)] = inst_15625);

(statearr_15779_17876[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15699 === (2))){
var state_15698__$1 = state_15698;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15698__$1,(4),ch);
} else {
if((state_val_15699 === (23))){
var state_15698__$1 = state_15698;
var statearr_15781_17877 = state_15698__$1;
(statearr_15781_17877[(2)] = null);

(statearr_15781_17877[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15699 === (35))){
var inst_15679 = (state_15698[(2)]);
var state_15698__$1 = state_15698;
var statearr_15786_17878 = state_15698__$1;
(statearr_15786_17878[(2)] = inst_15679);

(statearr_15786_17878[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15699 === (19))){
var inst_15594 = (state_15698[(7)]);
var inst_15598 = cljs.core.chunk_first(inst_15594);
var inst_15599 = cljs.core.chunk_rest(inst_15594);
var inst_15600 = cljs.core.count(inst_15598);
var inst_15570 = inst_15599;
var inst_15571 = inst_15598;
var inst_15572 = inst_15600;
var inst_15573 = (0);
var state_15698__$1 = (function (){var statearr_15790 = state_15698;
(statearr_15790[(14)] = inst_15572);

(statearr_15790[(15)] = inst_15573);

(statearr_15790[(16)] = inst_15571);

(statearr_15790[(17)] = inst_15570);

return statearr_15790;
})();
var statearr_15794_17881 = state_15698__$1;
(statearr_15794_17881[(2)] = null);

(statearr_15794_17881[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15699 === (11))){
var inst_15594 = (state_15698[(7)]);
var inst_15570 = (state_15698[(17)]);
var inst_15594__$1 = cljs.core.seq(inst_15570);
var state_15698__$1 = (function (){var statearr_15798 = state_15698;
(statearr_15798[(7)] = inst_15594__$1);

return statearr_15798;
})();
if(inst_15594__$1){
var statearr_15799_17882 = state_15698__$1;
(statearr_15799_17882[(1)] = (16));

} else {
var statearr_15802_17883 = state_15698__$1;
(statearr_15802_17883[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15699 === (9))){
var inst_15627 = (state_15698[(2)]);
var state_15698__$1 = state_15698;
var statearr_15804_17884 = state_15698__$1;
(statearr_15804_17884[(2)] = inst_15627);

(statearr_15804_17884[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15699 === (5))){
var inst_15568 = cljs.core.deref(cs);
var inst_15569 = cljs.core.seq(inst_15568);
var inst_15570 = inst_15569;
var inst_15571 = null;
var inst_15572 = (0);
var inst_15573 = (0);
var state_15698__$1 = (function (){var statearr_15807 = state_15698;
(statearr_15807[(14)] = inst_15572);

(statearr_15807[(15)] = inst_15573);

(statearr_15807[(16)] = inst_15571);

(statearr_15807[(17)] = inst_15570);

return statearr_15807;
})();
var statearr_15809_17886 = state_15698__$1;
(statearr_15809_17886[(2)] = null);

(statearr_15809_17886[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15699 === (14))){
var state_15698__$1 = state_15698;
var statearr_15812_17887 = state_15698__$1;
(statearr_15812_17887[(2)] = null);

(statearr_15812_17887[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15699 === (45))){
var inst_15687 = (state_15698[(2)]);
var state_15698__$1 = state_15698;
var statearr_15815_17893 = state_15698__$1;
(statearr_15815_17893[(2)] = inst_15687);

(statearr_15815_17893[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15699 === (26))){
var inst_15630 = (state_15698[(27)]);
var inst_15683 = (state_15698[(2)]);
var inst_15684 = cljs.core.seq(inst_15630);
var state_15698__$1 = (function (){var statearr_15816 = state_15698;
(statearr_15816[(29)] = inst_15683);

return statearr_15816;
})();
if(inst_15684){
var statearr_15818_17899 = state_15698__$1;
(statearr_15818_17899[(1)] = (42));

} else {
var statearr_15819_17904 = state_15698__$1;
(statearr_15819_17904[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15699 === (16))){
var inst_15594 = (state_15698[(7)]);
var inst_15596 = cljs.core.chunked_seq_QMARK_(inst_15594);
var state_15698__$1 = state_15698;
if(inst_15596){
var statearr_15821_17905 = state_15698__$1;
(statearr_15821_17905[(1)] = (19));

} else {
var statearr_15822_17906 = state_15698__$1;
(statearr_15822_17906[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15699 === (38))){
var inst_15676 = (state_15698[(2)]);
var state_15698__$1 = state_15698;
var statearr_15826_17907 = state_15698__$1;
(statearr_15826_17907[(2)] = inst_15676);

(statearr_15826_17907[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15699 === (30))){
var state_15698__$1 = state_15698;
var statearr_15828_17908 = state_15698__$1;
(statearr_15828_17908[(2)] = null);

(statearr_15828_17908[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15699 === (10))){
var inst_15573 = (state_15698[(15)]);
var inst_15571 = (state_15698[(16)]);
var inst_15581 = cljs.core._nth(inst_15571,inst_15573);
var inst_15582 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15581,(0),null);
var inst_15583 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15581,(1),null);
var state_15698__$1 = (function (){var statearr_15829 = state_15698;
(statearr_15829[(24)] = inst_15582);

return statearr_15829;
})();
if(cljs.core.truth_(inst_15583)){
var statearr_15830_17909 = state_15698__$1;
(statearr_15830_17909[(1)] = (13));

} else {
var statearr_15831_17910 = state_15698__$1;
(statearr_15831_17910[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15699 === (18))){
var inst_15623 = (state_15698[(2)]);
var state_15698__$1 = state_15698;
var statearr_15834_17911 = state_15698__$1;
(statearr_15834_17911[(2)] = inst_15623);

(statearr_15834_17911[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15699 === (42))){
var state_15698__$1 = state_15698;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15698__$1,(45),dchan);
} else {
if((state_val_15699 === (37))){
var inst_15656 = (state_15698[(23)]);
var inst_15561 = (state_15698[(11)]);
var inst_15666 = (state_15698[(22)]);
var inst_15666__$1 = cljs.core.first(inst_15656);
var inst_15667 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_15666__$1,inst_15561,done);
var state_15698__$1 = (function (){var statearr_15837 = state_15698;
(statearr_15837[(22)] = inst_15666__$1);

return statearr_15837;
})();
if(cljs.core.truth_(inst_15667)){
var statearr_15839_17912 = state_15698__$1;
(statearr_15839_17912[(1)] = (39));

} else {
var statearr_15842_17913 = state_15698__$1;
(statearr_15842_17913[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15699 === (8))){
var inst_15572 = (state_15698[(14)]);
var inst_15573 = (state_15698[(15)]);
var inst_15575 = (inst_15573 < inst_15572);
var inst_15576 = inst_15575;
var state_15698__$1 = state_15698;
if(cljs.core.truth_(inst_15576)){
var statearr_15844_17914 = state_15698__$1;
(statearr_15844_17914[(1)] = (10));

} else {
var statearr_15847_17915 = state_15698__$1;
(statearr_15847_17915[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__14361__auto__ = null;
var cljs$core$async$mult_$_state_machine__14361__auto____0 = (function (){
var statearr_15851 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15851[(0)] = cljs$core$async$mult_$_state_machine__14361__auto__);

(statearr_15851[(1)] = (1));

return statearr_15851;
});
var cljs$core$async$mult_$_state_machine__14361__auto____1 = (function (state_15698){
while(true){
var ret_value__14362__auto__ = (function (){try{while(true){
var result__14363__auto__ = switch__14360__auto__(state_15698);
if(cljs.core.keyword_identical_QMARK_(result__14363__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14363__auto__;
}
break;
}
}catch (e15854){var ex__14364__auto__ = e15854;
var statearr_15855_17916 = state_15698;
(statearr_15855_17916[(2)] = ex__14364__auto__);


if(cljs.core.seq((state_15698[(4)]))){
var statearr_15856_17917 = state_15698;
(statearr_15856_17917[(1)] = cljs.core.first((state_15698[(4)])));

} else {
throw ex__14364__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14362__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17920 = state_15698;
state_15698 = G__17920;
continue;
} else {
return ret_value__14362__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__14361__auto__ = function(state_15698){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__14361__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__14361__auto____1.call(this,state_15698);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__14361__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__14361__auto____0;
cljs$core$async$mult_$_state_machine__14361__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__14361__auto____1;
return cljs$core$async$mult_$_state_machine__14361__auto__;
})()
})();
var state__14558__auto__ = (function (){var statearr_15863 = f__14557__auto__();
(statearr_15863[(6)] = c__14556__auto___17830);

return statearr_15863;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14558__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__15872 = arguments.length;
switch (G__15872) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_17928 = (function (m,ch){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5351__auto__.call(null,m,ch));
} else {
var m__5349__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5349__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_17928(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_17929 = (function (m,ch){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5351__auto__.call(null,m,ch));
} else {
var m__5349__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5349__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_17929(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_17931 = (function (m){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5351__auto__.call(null,m));
} else {
var m__5349__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5349__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_17931(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_17936 = (function (m,state_map){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5351__auto__.call(null,m,state_map));
} else {
var m__5349__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5349__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_17936(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_17937 = (function (m,mode){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5351__auto__.call(null,m,mode));
} else {
var m__5349__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5349__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_17937(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5732__auto__ = [];
var len__5726__auto___17938 = arguments.length;
var i__5727__auto___17939 = (0);
while(true){
if((i__5727__auto___17939 < len__5726__auto___17938)){
args__5732__auto__.push((arguments[i__5727__auto___17939]));

var G__17940 = (i__5727__auto___17939 + (1));
i__5727__auto___17939 = G__17940;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((3) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5733__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__15953){
var map__15955 = p__15953;
var map__15955__$1 = cljs.core.__destructure_map(map__15955);
var opts = map__15955__$1;
var statearr_15958_17941 = state;
(statearr_15958_17941[(1)] = cont_block);


var temp__5804__auto__ = cljs.core.async.do_alts((function (val){
var statearr_15971_17943 = state;
(statearr_15971_17943[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5804__auto__)){
var cb = temp__5804__auto__;
var statearr_15976_17944 = state;
(statearr_15976_17944[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq15942){
var G__15943 = cljs.core.first(seq15942);
var seq15942__$1 = cljs.core.next(seq15942);
var G__15944 = cljs.core.first(seq15942__$1);
var seq15942__$2 = cljs.core.next(seq15942__$1);
var G__15945 = cljs.core.first(seq15942__$2);
var seq15942__$3 = cljs.core.next(seq15942__$2);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15943,G__15944,G__15945,seq15942__$3);
}));


/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16011 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta16012){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta16012 = meta16012;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async16011.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16013,meta16012__$1){
var self__ = this;
var _16013__$1 = this;
return (new cljs.core.async.t_cljs$core$async16011(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta16012__$1));
}));

(cljs.core.async.t_cljs$core$async16011.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16013){
var self__ = this;
var _16013__$1 = this;
return self__.meta16012;
}));

(cljs.core.async.t_cljs$core$async16011.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16011.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async16011.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16011.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async16011.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async16011.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async16011.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async16011.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async16011.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta16012","meta16012",296772455,null)], null);
}));

(cljs.core.async.t_cljs$core$async16011.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async16011.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16011");

(cljs.core.async.t_cljs$core$async16011.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async16011");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async16011.
 */
cljs.core.async.__GT_t_cljs$core$async16011 = (function cljs$core$async$__GT_t_cljs$core$async16011(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta16012){
return (new cljs.core.async.t_cljs$core$async16011(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta16012));
});


/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (new cljs.core.async.t_cljs$core$async16011(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
var c__14556__auto___17949 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14557__auto__ = (function (){var switch__14360__auto__ = (function (state_16112){
var state_val_16114 = (state_16112[(1)]);
if((state_val_16114 === (7))){
var inst_16064 = (state_16112[(2)]);
var state_16112__$1 = state_16112;
if(cljs.core.truth_(inst_16064)){
var statearr_16115_17953 = state_16112__$1;
(statearr_16115_17953[(1)] = (8));

} else {
var statearr_16116_17954 = state_16112__$1;
(statearr_16116_17954[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16114 === (20))){
var inst_16057 = (state_16112[(7)]);
var state_16112__$1 = state_16112;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16112__$1,(23),out,inst_16057);
} else {
if((state_val_16114 === (1))){
var inst_16037 = calc_state();
var inst_16038 = cljs.core.__destructure_map(inst_16037);
var inst_16039 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16038,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_16040 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16038,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_16041 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16038,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_16042 = inst_16037;
var state_16112__$1 = (function (){var statearr_16126 = state_16112;
(statearr_16126[(8)] = inst_16039);

(statearr_16126[(9)] = inst_16042);

(statearr_16126[(10)] = inst_16041);

(statearr_16126[(11)] = inst_16040);

return statearr_16126;
})();
var statearr_16130_17955 = state_16112__$1;
(statearr_16130_17955[(2)] = null);

(statearr_16130_17955[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16114 === (24))){
var inst_16045 = (state_16112[(12)]);
var inst_16042 = inst_16045;
var state_16112__$1 = (function (){var statearr_16131 = state_16112;
(statearr_16131[(9)] = inst_16042);

return statearr_16131;
})();
var statearr_16136_17956 = state_16112__$1;
(statearr_16136_17956[(2)] = null);

(statearr_16136_17956[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16114 === (4))){
var inst_16057 = (state_16112[(7)]);
var inst_16059 = (state_16112[(13)]);
var inst_16056 = (state_16112[(2)]);
var inst_16057__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16056,(0),null);
var inst_16058 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16056,(1),null);
var inst_16059__$1 = (inst_16057__$1 == null);
var state_16112__$1 = (function (){var statearr_16137 = state_16112;
(statearr_16137[(7)] = inst_16057__$1);

(statearr_16137[(13)] = inst_16059__$1);

(statearr_16137[(14)] = inst_16058);

return statearr_16137;
})();
if(cljs.core.truth_(inst_16059__$1)){
var statearr_16138_17957 = state_16112__$1;
(statearr_16138_17957[(1)] = (5));

} else {
var statearr_16139_17958 = state_16112__$1;
(statearr_16139_17958[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16114 === (15))){
var inst_16081 = (state_16112[(15)]);
var inst_16046 = (state_16112[(16)]);
var inst_16081__$1 = cljs.core.empty_QMARK_(inst_16046);
var state_16112__$1 = (function (){var statearr_16146 = state_16112;
(statearr_16146[(15)] = inst_16081__$1);

return statearr_16146;
})();
if(inst_16081__$1){
var statearr_16147_17959 = state_16112__$1;
(statearr_16147_17959[(1)] = (17));

} else {
var statearr_16148_17960 = state_16112__$1;
(statearr_16148_17960[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16114 === (21))){
var inst_16045 = (state_16112[(12)]);
var inst_16042 = inst_16045;
var state_16112__$1 = (function (){var statearr_16153 = state_16112;
(statearr_16153[(9)] = inst_16042);

return statearr_16153;
})();
var statearr_16160_17961 = state_16112__$1;
(statearr_16160_17961[(2)] = null);

(statearr_16160_17961[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16114 === (13))){
var inst_16074 = (state_16112[(2)]);
var inst_16075 = calc_state();
var inst_16042 = inst_16075;
var state_16112__$1 = (function (){var statearr_16163 = state_16112;
(statearr_16163[(17)] = inst_16074);

(statearr_16163[(9)] = inst_16042);

return statearr_16163;
})();
var statearr_16164_17962 = state_16112__$1;
(statearr_16164_17962[(2)] = null);

(statearr_16164_17962[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16114 === (22))){
var inst_16103 = (state_16112[(2)]);
var state_16112__$1 = state_16112;
var statearr_16165_17963 = state_16112__$1;
(statearr_16165_17963[(2)] = inst_16103);

(statearr_16165_17963[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16114 === (6))){
var inst_16058 = (state_16112[(14)]);
var inst_16062 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_16058,change);
var state_16112__$1 = state_16112;
var statearr_16166_17964 = state_16112__$1;
(statearr_16166_17964[(2)] = inst_16062);

(statearr_16166_17964[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16114 === (25))){
var state_16112__$1 = state_16112;
var statearr_16171_17965 = state_16112__$1;
(statearr_16171_17965[(2)] = null);

(statearr_16171_17965[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16114 === (17))){
var inst_16058 = (state_16112[(14)]);
var inst_16047 = (state_16112[(18)]);
var inst_16083 = (inst_16047.cljs$core$IFn$_invoke$arity$1 ? inst_16047.cljs$core$IFn$_invoke$arity$1(inst_16058) : inst_16047.call(null,inst_16058));
var inst_16084 = cljs.core.not(inst_16083);
var state_16112__$1 = state_16112;
var statearr_16172_17966 = state_16112__$1;
(statearr_16172_17966[(2)] = inst_16084);

(statearr_16172_17966[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16114 === (3))){
var inst_16107 = (state_16112[(2)]);
var state_16112__$1 = state_16112;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16112__$1,inst_16107);
} else {
if((state_val_16114 === (12))){
var state_16112__$1 = state_16112;
var statearr_16182_17967 = state_16112__$1;
(statearr_16182_17967[(2)] = null);

(statearr_16182_17967[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16114 === (2))){
var inst_16042 = (state_16112[(9)]);
var inst_16045 = (state_16112[(12)]);
var inst_16045__$1 = cljs.core.__destructure_map(inst_16042);
var inst_16046 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16045__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_16047 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16045__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_16048 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16045__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_16112__$1 = (function (){var statearr_16186 = state_16112;
(statearr_16186[(18)] = inst_16047);

(statearr_16186[(12)] = inst_16045__$1);

(statearr_16186[(16)] = inst_16046);

return statearr_16186;
})();
return cljs.core.async.ioc_alts_BANG_(state_16112__$1,(4),inst_16048);
} else {
if((state_val_16114 === (23))){
var inst_16094 = (state_16112[(2)]);
var state_16112__$1 = state_16112;
if(cljs.core.truth_(inst_16094)){
var statearr_16187_17985 = state_16112__$1;
(statearr_16187_17985[(1)] = (24));

} else {
var statearr_16188_17993 = state_16112__$1;
(statearr_16188_17993[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16114 === (19))){
var inst_16087 = (state_16112[(2)]);
var state_16112__$1 = state_16112;
var statearr_16189_17994 = state_16112__$1;
(statearr_16189_17994[(2)] = inst_16087);

(statearr_16189_17994[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16114 === (11))){
var inst_16058 = (state_16112[(14)]);
var inst_16071 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_16058);
var state_16112__$1 = state_16112;
var statearr_16190_17995 = state_16112__$1;
(statearr_16190_17995[(2)] = inst_16071);

(statearr_16190_17995[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16114 === (9))){
var inst_16058 = (state_16112[(14)]);
var inst_16078 = (state_16112[(19)]);
var inst_16046 = (state_16112[(16)]);
var inst_16078__$1 = (inst_16046.cljs$core$IFn$_invoke$arity$1 ? inst_16046.cljs$core$IFn$_invoke$arity$1(inst_16058) : inst_16046.call(null,inst_16058));
var state_16112__$1 = (function (){var statearr_16191 = state_16112;
(statearr_16191[(19)] = inst_16078__$1);

return statearr_16191;
})();
if(cljs.core.truth_(inst_16078__$1)){
var statearr_16192_17996 = state_16112__$1;
(statearr_16192_17996[(1)] = (14));

} else {
var statearr_16193_17997 = state_16112__$1;
(statearr_16193_17997[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16114 === (5))){
var inst_16059 = (state_16112[(13)]);
var state_16112__$1 = state_16112;
var statearr_16194_17998 = state_16112__$1;
(statearr_16194_17998[(2)] = inst_16059);

(statearr_16194_17998[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16114 === (14))){
var inst_16078 = (state_16112[(19)]);
var state_16112__$1 = state_16112;
var statearr_16195_17999 = state_16112__$1;
(statearr_16195_17999[(2)] = inst_16078);

(statearr_16195_17999[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16114 === (26))){
var inst_16099 = (state_16112[(2)]);
var state_16112__$1 = state_16112;
var statearr_16202_18000 = state_16112__$1;
(statearr_16202_18000[(2)] = inst_16099);

(statearr_16202_18000[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16114 === (16))){
var inst_16089 = (state_16112[(2)]);
var state_16112__$1 = state_16112;
if(cljs.core.truth_(inst_16089)){
var statearr_16203_18001 = state_16112__$1;
(statearr_16203_18001[(1)] = (20));

} else {
var statearr_16204_18002 = state_16112__$1;
(statearr_16204_18002[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16114 === (10))){
var inst_16105 = (state_16112[(2)]);
var state_16112__$1 = state_16112;
var statearr_16205_18003 = state_16112__$1;
(statearr_16205_18003[(2)] = inst_16105);

(statearr_16205_18003[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16114 === (18))){
var inst_16081 = (state_16112[(15)]);
var state_16112__$1 = state_16112;
var statearr_16206_18004 = state_16112__$1;
(statearr_16206_18004[(2)] = inst_16081);

(statearr_16206_18004[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16114 === (8))){
var inst_16057 = (state_16112[(7)]);
var inst_16069 = (inst_16057 == null);
var state_16112__$1 = state_16112;
if(cljs.core.truth_(inst_16069)){
var statearr_16207_18005 = state_16112__$1;
(statearr_16207_18005[(1)] = (11));

} else {
var statearr_16208_18006 = state_16112__$1;
(statearr_16208_18006[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__14361__auto__ = null;
var cljs$core$async$mix_$_state_machine__14361__auto____0 = (function (){
var statearr_16214 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16214[(0)] = cljs$core$async$mix_$_state_machine__14361__auto__);

(statearr_16214[(1)] = (1));

return statearr_16214;
});
var cljs$core$async$mix_$_state_machine__14361__auto____1 = (function (state_16112){
while(true){
var ret_value__14362__auto__ = (function (){try{while(true){
var result__14363__auto__ = switch__14360__auto__(state_16112);
if(cljs.core.keyword_identical_QMARK_(result__14363__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14363__auto__;
}
break;
}
}catch (e16215){var ex__14364__auto__ = e16215;
var statearr_16216_18007 = state_16112;
(statearr_16216_18007[(2)] = ex__14364__auto__);


if(cljs.core.seq((state_16112[(4)]))){
var statearr_16217_18008 = state_16112;
(statearr_16217_18008[(1)] = cljs.core.first((state_16112[(4)])));

} else {
throw ex__14364__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14362__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18009 = state_16112;
state_16112 = G__18009;
continue;
} else {
return ret_value__14362__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__14361__auto__ = function(state_16112){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__14361__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__14361__auto____1.call(this,state_16112);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__14361__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__14361__auto____0;
cljs$core$async$mix_$_state_machine__14361__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__14361__auto____1;
return cljs$core$async$mix_$_state_machine__14361__auto__;
})()
})();
var state__14558__auto__ = (function (){var statearr_16218 = f__14557__auto__();
(statearr_16218[(6)] = c__14556__auto___17949);

return statearr_16218;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14558__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_18014 = (function (p,v,ch,close_QMARK_){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5351__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__5349__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5349__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_18014(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_18015 = (function (p,v,ch){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5351__auto__.call(null,p,v,ch));
} else {
var m__5349__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5349__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_18015(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_18017 = (function() {
var G__18019 = null;
var G__18019__1 = (function (p){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5351__auto__.call(null,p));
} else {
var m__5349__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5349__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__18019__2 = (function (p,v){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5351__auto__.call(null,p,v));
} else {
var m__5349__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5349__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__18019 = function(p,v){
switch(arguments.length){
case 1:
return G__18019__1.call(this,p);
case 2:
return G__18019__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18019.cljs$core$IFn$_invoke$arity$1 = G__18019__1;
G__18019.cljs$core$IFn$_invoke$arity$2 = G__18019__2;
return G__18019;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__16231 = arguments.length;
switch (G__16231) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_18017(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_18017(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);



/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16247 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta16248){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta16248 = meta16248;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async16247.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16249,meta16248__$1){
var self__ = this;
var _16249__$1 = this;
return (new cljs.core.async.t_cljs$core$async16247(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta16248__$1));
}));

(cljs.core.async.t_cljs$core$async16247.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16249){
var self__ = this;
var _16249__$1 = this;
return self__.meta16248;
}));

(cljs.core.async.t_cljs$core$async16247.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16247.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async16247.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16247.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async16247.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5804__auto__)){
var m = temp__5804__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async16247.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async16247.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async16247.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta16248","meta16248",671805351,null)], null);
}));

(cljs.core.async.t_cljs$core$async16247.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async16247.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16247");

(cljs.core.async.t_cljs$core$async16247.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async16247");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async16247.
 */
cljs.core.async.__GT_t_cljs$core$async16247 = (function cljs$core$async$__GT_t_cljs$core$async16247(ch,topic_fn,buf_fn,mults,ensure_mult,meta16248){
return (new cljs.core.async.t_cljs$core$async16247(ch,topic_fn,buf_fn,mults,ensure_mult,meta16248));
});


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__16239 = arguments.length;
switch (G__16239) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__5002__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__16237_SHARP_){
if(cljs.core.truth_((p1__16237_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16237_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__16237_SHARP_.call(null,topic)))){
return p1__16237_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__16237_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (new cljs.core.async.t_cljs$core$async16247(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
var c__14556__auto___18028 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14557__auto__ = (function (){var switch__14360__auto__ = (function (state_16337){
var state_val_16338 = (state_16337[(1)]);
if((state_val_16338 === (7))){
var inst_16333 = (state_16337[(2)]);
var state_16337__$1 = state_16337;
var statearr_16347_18029 = state_16337__$1;
(statearr_16347_18029[(2)] = inst_16333);

(statearr_16347_18029[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16338 === (20))){
var state_16337__$1 = state_16337;
var statearr_16352_18030 = state_16337__$1;
(statearr_16352_18030[(2)] = null);

(statearr_16352_18030[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16338 === (1))){
var state_16337__$1 = state_16337;
var statearr_16354_18031 = state_16337__$1;
(statearr_16354_18031[(2)] = null);

(statearr_16354_18031[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16338 === (24))){
var inst_16316 = (state_16337[(7)]);
var inst_16325 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_16316);
var state_16337__$1 = state_16337;
var statearr_16355_18032 = state_16337__$1;
(statearr_16355_18032[(2)] = inst_16325);

(statearr_16355_18032[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16338 === (4))){
var inst_16266 = (state_16337[(8)]);
var inst_16266__$1 = (state_16337[(2)]);
var inst_16267 = (inst_16266__$1 == null);
var state_16337__$1 = (function (){var statearr_16356 = state_16337;
(statearr_16356[(8)] = inst_16266__$1);

return statearr_16356;
})();
if(cljs.core.truth_(inst_16267)){
var statearr_16357_18033 = state_16337__$1;
(statearr_16357_18033[(1)] = (5));

} else {
var statearr_16358_18034 = state_16337__$1;
(statearr_16358_18034[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16338 === (15))){
var inst_16310 = (state_16337[(2)]);
var state_16337__$1 = state_16337;
var statearr_16359_18035 = state_16337__$1;
(statearr_16359_18035[(2)] = inst_16310);

(statearr_16359_18035[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16338 === (21))){
var inst_16330 = (state_16337[(2)]);
var state_16337__$1 = (function (){var statearr_16360 = state_16337;
(statearr_16360[(9)] = inst_16330);

return statearr_16360;
})();
var statearr_16361_18036 = state_16337__$1;
(statearr_16361_18036[(2)] = null);

(statearr_16361_18036[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16338 === (13))){
var inst_16292 = (state_16337[(10)]);
var inst_16294 = cljs.core.chunked_seq_QMARK_(inst_16292);
var state_16337__$1 = state_16337;
if(inst_16294){
var statearr_16362_18037 = state_16337__$1;
(statearr_16362_18037[(1)] = (16));

} else {
var statearr_16363_18038 = state_16337__$1;
(statearr_16363_18038[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16338 === (22))){
var inst_16322 = (state_16337[(2)]);
var state_16337__$1 = state_16337;
if(cljs.core.truth_(inst_16322)){
var statearr_16365_18039 = state_16337__$1;
(statearr_16365_18039[(1)] = (23));

} else {
var statearr_16366_18040 = state_16337__$1;
(statearr_16366_18040[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16338 === (6))){
var inst_16316 = (state_16337[(7)]);
var inst_16318 = (state_16337[(11)]);
var inst_16266 = (state_16337[(8)]);
var inst_16316__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_16266) : topic_fn.call(null,inst_16266));
var inst_16317 = cljs.core.deref(mults);
var inst_16318__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16317,inst_16316__$1);
var state_16337__$1 = (function (){var statearr_16374 = state_16337;
(statearr_16374[(7)] = inst_16316__$1);

(statearr_16374[(11)] = inst_16318__$1);

return statearr_16374;
})();
if(cljs.core.truth_(inst_16318__$1)){
var statearr_16375_18041 = state_16337__$1;
(statearr_16375_18041[(1)] = (19));

} else {
var statearr_16376_18042 = state_16337__$1;
(statearr_16376_18042[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16338 === (25))){
var inst_16327 = (state_16337[(2)]);
var state_16337__$1 = state_16337;
var statearr_16377_18043 = state_16337__$1;
(statearr_16377_18043[(2)] = inst_16327);

(statearr_16377_18043[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16338 === (17))){
var inst_16292 = (state_16337[(10)]);
var inst_16301 = cljs.core.first(inst_16292);
var inst_16302 = cljs.core.async.muxch_STAR_(inst_16301);
var inst_16303 = cljs.core.async.close_BANG_(inst_16302);
var inst_16304 = cljs.core.next(inst_16292);
var inst_16276 = inst_16304;
var inst_16277 = null;
var inst_16278 = (0);
var inst_16279 = (0);
var state_16337__$1 = (function (){var statearr_16380 = state_16337;
(statearr_16380[(12)] = inst_16303);

(statearr_16380[(13)] = inst_16279);

(statearr_16380[(14)] = inst_16276);

(statearr_16380[(15)] = inst_16278);

(statearr_16380[(16)] = inst_16277);

return statearr_16380;
})();
var statearr_16383_18044 = state_16337__$1;
(statearr_16383_18044[(2)] = null);

(statearr_16383_18044[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16338 === (3))){
var inst_16335 = (state_16337[(2)]);
var state_16337__$1 = state_16337;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16337__$1,inst_16335);
} else {
if((state_val_16338 === (12))){
var inst_16312 = (state_16337[(2)]);
var state_16337__$1 = state_16337;
var statearr_16386_18045 = state_16337__$1;
(statearr_16386_18045[(2)] = inst_16312);

(statearr_16386_18045[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16338 === (2))){
var state_16337__$1 = state_16337;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16337__$1,(4),ch);
} else {
if((state_val_16338 === (23))){
var state_16337__$1 = state_16337;
var statearr_16388_18046 = state_16337__$1;
(statearr_16388_18046[(2)] = null);

(statearr_16388_18046[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16338 === (19))){
var inst_16318 = (state_16337[(11)]);
var inst_16266 = (state_16337[(8)]);
var inst_16320 = cljs.core.async.muxch_STAR_(inst_16318);
var state_16337__$1 = state_16337;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16337__$1,(22),inst_16320,inst_16266);
} else {
if((state_val_16338 === (11))){
var inst_16276 = (state_16337[(14)]);
var inst_16292 = (state_16337[(10)]);
var inst_16292__$1 = cljs.core.seq(inst_16276);
var state_16337__$1 = (function (){var statearr_16391 = state_16337;
(statearr_16391[(10)] = inst_16292__$1);

return statearr_16391;
})();
if(inst_16292__$1){
var statearr_16392_18047 = state_16337__$1;
(statearr_16392_18047[(1)] = (13));

} else {
var statearr_16393_18048 = state_16337__$1;
(statearr_16393_18048[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16338 === (9))){
var inst_16314 = (state_16337[(2)]);
var state_16337__$1 = state_16337;
var statearr_16394_18049 = state_16337__$1;
(statearr_16394_18049[(2)] = inst_16314);

(statearr_16394_18049[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16338 === (5))){
var inst_16273 = cljs.core.deref(mults);
var inst_16274 = cljs.core.vals(inst_16273);
var inst_16275 = cljs.core.seq(inst_16274);
var inst_16276 = inst_16275;
var inst_16277 = null;
var inst_16278 = (0);
var inst_16279 = (0);
var state_16337__$1 = (function (){var statearr_16395 = state_16337;
(statearr_16395[(13)] = inst_16279);

(statearr_16395[(14)] = inst_16276);

(statearr_16395[(15)] = inst_16278);

(statearr_16395[(16)] = inst_16277);

return statearr_16395;
})();
var statearr_16397_18050 = state_16337__$1;
(statearr_16397_18050[(2)] = null);

(statearr_16397_18050[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16338 === (14))){
var state_16337__$1 = state_16337;
var statearr_16403_18057 = state_16337__$1;
(statearr_16403_18057[(2)] = null);

(statearr_16403_18057[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16338 === (16))){
var inst_16292 = (state_16337[(10)]);
var inst_16296 = cljs.core.chunk_first(inst_16292);
var inst_16297 = cljs.core.chunk_rest(inst_16292);
var inst_16298 = cljs.core.count(inst_16296);
var inst_16276 = inst_16297;
var inst_16277 = inst_16296;
var inst_16278 = inst_16298;
var inst_16279 = (0);
var state_16337__$1 = (function (){var statearr_16404 = state_16337;
(statearr_16404[(13)] = inst_16279);

(statearr_16404[(14)] = inst_16276);

(statearr_16404[(15)] = inst_16278);

(statearr_16404[(16)] = inst_16277);

return statearr_16404;
})();
var statearr_16405_18058 = state_16337__$1;
(statearr_16405_18058[(2)] = null);

(statearr_16405_18058[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16338 === (10))){
var inst_16279 = (state_16337[(13)]);
var inst_16276 = (state_16337[(14)]);
var inst_16278 = (state_16337[(15)]);
var inst_16277 = (state_16337[(16)]);
var inst_16284 = cljs.core._nth(inst_16277,inst_16279);
var inst_16287 = cljs.core.async.muxch_STAR_(inst_16284);
var inst_16288 = cljs.core.async.close_BANG_(inst_16287);
var inst_16289 = (inst_16279 + (1));
var tmp16399 = inst_16276;
var tmp16400 = inst_16278;
var tmp16401 = inst_16277;
var inst_16276__$1 = tmp16399;
var inst_16277__$1 = tmp16401;
var inst_16278__$1 = tmp16400;
var inst_16279__$1 = inst_16289;
var state_16337__$1 = (function (){var statearr_16409 = state_16337;
(statearr_16409[(17)] = inst_16288);

(statearr_16409[(13)] = inst_16279__$1);

(statearr_16409[(14)] = inst_16276__$1);

(statearr_16409[(15)] = inst_16278__$1);

(statearr_16409[(16)] = inst_16277__$1);

return statearr_16409;
})();
var statearr_16411_18059 = state_16337__$1;
(statearr_16411_18059[(2)] = null);

(statearr_16411_18059[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16338 === (18))){
var inst_16307 = (state_16337[(2)]);
var state_16337__$1 = state_16337;
var statearr_16412_18060 = state_16337__$1;
(statearr_16412_18060[(2)] = inst_16307);

(statearr_16412_18060[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16338 === (8))){
var inst_16279 = (state_16337[(13)]);
var inst_16278 = (state_16337[(15)]);
var inst_16281 = (inst_16279 < inst_16278);
var inst_16282 = inst_16281;
var state_16337__$1 = state_16337;
if(cljs.core.truth_(inst_16282)){
var statearr_16414_18061 = state_16337__$1;
(statearr_16414_18061[(1)] = (10));

} else {
var statearr_16419_18062 = state_16337__$1;
(statearr_16419_18062[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__14361__auto__ = null;
var cljs$core$async$state_machine__14361__auto____0 = (function (){
var statearr_16421 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16421[(0)] = cljs$core$async$state_machine__14361__auto__);

(statearr_16421[(1)] = (1));

return statearr_16421;
});
var cljs$core$async$state_machine__14361__auto____1 = (function (state_16337){
while(true){
var ret_value__14362__auto__ = (function (){try{while(true){
var result__14363__auto__ = switch__14360__auto__(state_16337);
if(cljs.core.keyword_identical_QMARK_(result__14363__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14363__auto__;
}
break;
}
}catch (e16422){var ex__14364__auto__ = e16422;
var statearr_16423_18063 = state_16337;
(statearr_16423_18063[(2)] = ex__14364__auto__);


if(cljs.core.seq((state_16337[(4)]))){
var statearr_16424_18064 = state_16337;
(statearr_16424_18064[(1)] = cljs.core.first((state_16337[(4)])));

} else {
throw ex__14364__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14362__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18065 = state_16337;
state_16337 = G__18065;
continue;
} else {
return ret_value__14362__auto__;
}
break;
}
});
cljs$core$async$state_machine__14361__auto__ = function(state_16337){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14361__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14361__auto____1.call(this,state_16337);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14361__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14361__auto____0;
cljs$core$async$state_machine__14361__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14361__auto____1;
return cljs$core$async$state_machine__14361__auto__;
})()
})();
var state__14558__auto__ = (function (){var statearr_16425 = f__14557__auto__();
(statearr_16425[(6)] = c__14556__auto___18028);

return statearr_16425;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14558__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__16428 = arguments.length;
switch (G__16428) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__16436 = arguments.length;
switch (G__16436) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__16441 = arguments.length;
switch (G__16441) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
if((cnt === (0))){
cljs.core.async.close_BANG_(out);
} else {
var c__14556__auto___18077 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14557__auto__ = (function (){var switch__14360__auto__ = (function (state_16493){
var state_val_16494 = (state_16493[(1)]);
if((state_val_16494 === (7))){
var state_16493__$1 = state_16493;
var statearr_16495_18078 = state_16493__$1;
(statearr_16495_18078[(2)] = null);

(statearr_16495_18078[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16494 === (1))){
var state_16493__$1 = state_16493;
var statearr_16496_18079 = state_16493__$1;
(statearr_16496_18079[(2)] = null);

(statearr_16496_18079[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16494 === (4))){
var inst_16446 = (state_16493[(7)]);
var inst_16447 = (state_16493[(8)]);
var inst_16450 = (inst_16447 < inst_16446);
var state_16493__$1 = state_16493;
if(cljs.core.truth_(inst_16450)){
var statearr_16497_18080 = state_16493__$1;
(statearr_16497_18080[(1)] = (6));

} else {
var statearr_16499_18082 = state_16493__$1;
(statearr_16499_18082[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16494 === (15))){
var inst_16479 = (state_16493[(9)]);
var inst_16484 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_16479);
var state_16493__$1 = state_16493;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16493__$1,(17),out,inst_16484);
} else {
if((state_val_16494 === (13))){
var inst_16479 = (state_16493[(9)]);
var inst_16479__$1 = (state_16493[(2)]);
var inst_16480 = cljs.core.some(cljs.core.nil_QMARK_,inst_16479__$1);
var state_16493__$1 = (function (){var statearr_16500 = state_16493;
(statearr_16500[(9)] = inst_16479__$1);

return statearr_16500;
})();
if(cljs.core.truth_(inst_16480)){
var statearr_16501_18083 = state_16493__$1;
(statearr_16501_18083[(1)] = (14));

} else {
var statearr_16503_18084 = state_16493__$1;
(statearr_16503_18084[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16494 === (6))){
var state_16493__$1 = state_16493;
var statearr_16504_18085 = state_16493__$1;
(statearr_16504_18085[(2)] = null);

(statearr_16504_18085[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16494 === (17))){
var inst_16486 = (state_16493[(2)]);
var state_16493__$1 = (function (){var statearr_16507 = state_16493;
(statearr_16507[(10)] = inst_16486);

return statearr_16507;
})();
var statearr_16512_18086 = state_16493__$1;
(statearr_16512_18086[(2)] = null);

(statearr_16512_18086[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16494 === (3))){
var inst_16491 = (state_16493[(2)]);
var state_16493__$1 = state_16493;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16493__$1,inst_16491);
} else {
if((state_val_16494 === (12))){
var _ = (function (){var statearr_16515 = state_16493;
(statearr_16515[(4)] = cljs.core.rest((state_16493[(4)])));

return statearr_16515;
})();
var state_16493__$1 = state_16493;
var ex16506 = (state_16493__$1[(2)]);
var statearr_16516_18091 = state_16493__$1;
(statearr_16516_18091[(5)] = ex16506);


if((ex16506 instanceof Object)){
var statearr_16517_18092 = state_16493__$1;
(statearr_16517_18092[(1)] = (11));

(statearr_16517_18092[(5)] = null);

} else {
throw ex16506;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16494 === (2))){
var inst_16445 = cljs.core.reset_BANG_(dctr,cnt);
var inst_16446 = cnt;
var inst_16447 = (0);
var state_16493__$1 = (function (){var statearr_16524 = state_16493;
(statearr_16524[(7)] = inst_16446);

(statearr_16524[(11)] = inst_16445);

(statearr_16524[(8)] = inst_16447);

return statearr_16524;
})();
var statearr_16525_18093 = state_16493__$1;
(statearr_16525_18093[(2)] = null);

(statearr_16525_18093[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16494 === (11))){
var inst_16457 = (state_16493[(2)]);
var inst_16458 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_16493__$1 = (function (){var statearr_16526 = state_16493;
(statearr_16526[(12)] = inst_16457);

return statearr_16526;
})();
var statearr_16527_18094 = state_16493__$1;
(statearr_16527_18094[(2)] = inst_16458);

(statearr_16527_18094[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16494 === (9))){
var inst_16447 = (state_16493[(8)]);
var _ = (function (){var statearr_16536 = state_16493;
(statearr_16536[(4)] = cljs.core.cons((12),(state_16493[(4)])));

return statearr_16536;
})();
var inst_16465 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_16447) : chs__$1.call(null,inst_16447));
var inst_16466 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_16447) : done.call(null,inst_16447));
var inst_16467 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_16465,inst_16466);
var ___$1 = (function (){var statearr_16541 = state_16493;
(statearr_16541[(4)] = cljs.core.rest((state_16493[(4)])));

return statearr_16541;
})();
var state_16493__$1 = state_16493;
var statearr_16542_18095 = state_16493__$1;
(statearr_16542_18095[(2)] = inst_16467);

(statearr_16542_18095[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16494 === (5))){
var inst_16477 = (state_16493[(2)]);
var state_16493__$1 = (function (){var statearr_16543 = state_16493;
(statearr_16543[(13)] = inst_16477);

return statearr_16543;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16493__$1,(13),dchan);
} else {
if((state_val_16494 === (14))){
var inst_16482 = cljs.core.async.close_BANG_(out);
var state_16493__$1 = state_16493;
var statearr_16547_18096 = state_16493__$1;
(statearr_16547_18096[(2)] = inst_16482);

(statearr_16547_18096[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16494 === (16))){
var inst_16489 = (state_16493[(2)]);
var state_16493__$1 = state_16493;
var statearr_16548_18097 = state_16493__$1;
(statearr_16548_18097[(2)] = inst_16489);

(statearr_16548_18097[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16494 === (10))){
var inst_16447 = (state_16493[(8)]);
var inst_16470 = (state_16493[(2)]);
var inst_16471 = (inst_16447 + (1));
var inst_16447__$1 = inst_16471;
var state_16493__$1 = (function (){var statearr_16549 = state_16493;
(statearr_16549[(14)] = inst_16470);

(statearr_16549[(8)] = inst_16447__$1);

return statearr_16549;
})();
var statearr_16550_18098 = state_16493__$1;
(statearr_16550_18098[(2)] = null);

(statearr_16550_18098[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16494 === (8))){
var inst_16475 = (state_16493[(2)]);
var state_16493__$1 = state_16493;
var statearr_16551_18099 = state_16493__$1;
(statearr_16551_18099[(2)] = inst_16475);

(statearr_16551_18099[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__14361__auto__ = null;
var cljs$core$async$state_machine__14361__auto____0 = (function (){
var statearr_16553 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16553[(0)] = cljs$core$async$state_machine__14361__auto__);

(statearr_16553[(1)] = (1));

return statearr_16553;
});
var cljs$core$async$state_machine__14361__auto____1 = (function (state_16493){
while(true){
var ret_value__14362__auto__ = (function (){try{while(true){
var result__14363__auto__ = switch__14360__auto__(state_16493);
if(cljs.core.keyword_identical_QMARK_(result__14363__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14363__auto__;
}
break;
}
}catch (e16556){var ex__14364__auto__ = e16556;
var statearr_16557_18100 = state_16493;
(statearr_16557_18100[(2)] = ex__14364__auto__);


if(cljs.core.seq((state_16493[(4)]))){
var statearr_16559_18101 = state_16493;
(statearr_16559_18101[(1)] = cljs.core.first((state_16493[(4)])));

} else {
throw ex__14364__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14362__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18102 = state_16493;
state_16493 = G__18102;
continue;
} else {
return ret_value__14362__auto__;
}
break;
}
});
cljs$core$async$state_machine__14361__auto__ = function(state_16493){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14361__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14361__auto____1.call(this,state_16493);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14361__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14361__auto____0;
cljs$core$async$state_machine__14361__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14361__auto____1;
return cljs$core$async$state_machine__14361__auto__;
})()
})();
var state__14558__auto__ = (function (){var statearr_16560 = f__14557__auto__();
(statearr_16560[(6)] = c__14556__auto___18077);

return statearr_16560;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14558__auto__);
}));

}

return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__16576 = arguments.length;
switch (G__16576) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__14556__auto___18104 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14557__auto__ = (function (){var switch__14360__auto__ = (function (state_16628){
var state_val_16630 = (state_16628[(1)]);
if((state_val_16630 === (7))){
var inst_16598 = (state_16628[(7)]);
var inst_16597 = (state_16628[(8)]);
var inst_16597__$1 = (state_16628[(2)]);
var inst_16598__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16597__$1,(0),null);
var inst_16599 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16597__$1,(1),null);
var inst_16602 = (inst_16598__$1 == null);
var state_16628__$1 = (function (){var statearr_16637 = state_16628;
(statearr_16637[(7)] = inst_16598__$1);

(statearr_16637[(9)] = inst_16599);

(statearr_16637[(8)] = inst_16597__$1);

return statearr_16637;
})();
if(cljs.core.truth_(inst_16602)){
var statearr_16638_18105 = state_16628__$1;
(statearr_16638_18105[(1)] = (8));

} else {
var statearr_16639_18106 = state_16628__$1;
(statearr_16639_18106[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16630 === (1))){
var inst_16585 = cljs.core.vec(chs);
var inst_16586 = inst_16585;
var state_16628__$1 = (function (){var statearr_16644 = state_16628;
(statearr_16644[(10)] = inst_16586);

return statearr_16644;
})();
var statearr_16645_18107 = state_16628__$1;
(statearr_16645_18107[(2)] = null);

(statearr_16645_18107[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16630 === (4))){
var inst_16586 = (state_16628[(10)]);
var state_16628__$1 = state_16628;
return cljs.core.async.ioc_alts_BANG_(state_16628__$1,(7),inst_16586);
} else {
if((state_val_16630 === (6))){
var inst_16620 = (state_16628[(2)]);
var state_16628__$1 = state_16628;
var statearr_16647_18108 = state_16628__$1;
(statearr_16647_18108[(2)] = inst_16620);

(statearr_16647_18108[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16630 === (3))){
var inst_16622 = (state_16628[(2)]);
var state_16628__$1 = state_16628;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16628__$1,inst_16622);
} else {
if((state_val_16630 === (2))){
var inst_16586 = (state_16628[(10)]);
var inst_16588 = cljs.core.count(inst_16586);
var inst_16589 = (inst_16588 > (0));
var state_16628__$1 = state_16628;
if(cljs.core.truth_(inst_16589)){
var statearr_16650_18109 = state_16628__$1;
(statearr_16650_18109[(1)] = (4));

} else {
var statearr_16651_18110 = state_16628__$1;
(statearr_16651_18110[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16630 === (11))){
var inst_16586 = (state_16628[(10)]);
var inst_16613 = (state_16628[(2)]);
var tmp16648 = inst_16586;
var inst_16586__$1 = tmp16648;
var state_16628__$1 = (function (){var statearr_16653 = state_16628;
(statearr_16653[(11)] = inst_16613);

(statearr_16653[(10)] = inst_16586__$1);

return statearr_16653;
})();
var statearr_16655_18112 = state_16628__$1;
(statearr_16655_18112[(2)] = null);

(statearr_16655_18112[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16630 === (9))){
var inst_16598 = (state_16628[(7)]);
var state_16628__$1 = state_16628;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16628__$1,(11),out,inst_16598);
} else {
if((state_val_16630 === (5))){
var inst_16618 = cljs.core.async.close_BANG_(out);
var state_16628__$1 = state_16628;
var statearr_16661_18113 = state_16628__$1;
(statearr_16661_18113[(2)] = inst_16618);

(statearr_16661_18113[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16630 === (10))){
var inst_16616 = (state_16628[(2)]);
var state_16628__$1 = state_16628;
var statearr_16663_18114 = state_16628__$1;
(statearr_16663_18114[(2)] = inst_16616);

(statearr_16663_18114[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16630 === (8))){
var inst_16598 = (state_16628[(7)]);
var inst_16599 = (state_16628[(9)]);
var inst_16597 = (state_16628[(8)]);
var inst_16586 = (state_16628[(10)]);
var inst_16607 = (function (){var cs = inst_16586;
var vec__16591 = inst_16597;
var v = inst_16598;
var c = inst_16599;
return (function (p1__16570_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__16570_SHARP_);
});
})();
var inst_16609 = cljs.core.filterv(inst_16607,inst_16586);
var inst_16586__$1 = inst_16609;
var state_16628__$1 = (function (){var statearr_16664 = state_16628;
(statearr_16664[(10)] = inst_16586__$1);

return statearr_16664;
})();
var statearr_16665_18116 = state_16628__$1;
(statearr_16665_18116[(2)] = null);

(statearr_16665_18116[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__14361__auto__ = null;
var cljs$core$async$state_machine__14361__auto____0 = (function (){
var statearr_16669 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16669[(0)] = cljs$core$async$state_machine__14361__auto__);

(statearr_16669[(1)] = (1));

return statearr_16669;
});
var cljs$core$async$state_machine__14361__auto____1 = (function (state_16628){
while(true){
var ret_value__14362__auto__ = (function (){try{while(true){
var result__14363__auto__ = switch__14360__auto__(state_16628);
if(cljs.core.keyword_identical_QMARK_(result__14363__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14363__auto__;
}
break;
}
}catch (e16670){var ex__14364__auto__ = e16670;
var statearr_16671_18120 = state_16628;
(statearr_16671_18120[(2)] = ex__14364__auto__);


if(cljs.core.seq((state_16628[(4)]))){
var statearr_16675_18121 = state_16628;
(statearr_16675_18121[(1)] = cljs.core.first((state_16628[(4)])));

} else {
throw ex__14364__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14362__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18122 = state_16628;
state_16628 = G__18122;
continue;
} else {
return ret_value__14362__auto__;
}
break;
}
});
cljs$core$async$state_machine__14361__auto__ = function(state_16628){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14361__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14361__auto____1.call(this,state_16628);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14361__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14361__auto____0;
cljs$core$async$state_machine__14361__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14361__auto____1;
return cljs$core$async$state_machine__14361__auto__;
})()
})();
var state__14558__auto__ = (function (){var statearr_16677 = f__14557__auto__();
(statearr_16677[(6)] = c__14556__auto___18104);

return statearr_16677;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14558__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__16681 = arguments.length;
switch (G__16681) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__14556__auto___18125 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14557__auto__ = (function (){var switch__14360__auto__ = (function (state_16726){
var state_val_16727 = (state_16726[(1)]);
if((state_val_16727 === (7))){
var inst_16704 = (state_16726[(7)]);
var inst_16704__$1 = (state_16726[(2)]);
var inst_16705 = (inst_16704__$1 == null);
var inst_16706 = cljs.core.not(inst_16705);
var state_16726__$1 = (function (){var statearr_16737 = state_16726;
(statearr_16737[(7)] = inst_16704__$1);

return statearr_16737;
})();
if(inst_16706){
var statearr_16738_18126 = state_16726__$1;
(statearr_16738_18126[(1)] = (8));

} else {
var statearr_16739_18127 = state_16726__$1;
(statearr_16739_18127[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16727 === (1))){
var inst_16696 = (0);
var state_16726__$1 = (function (){var statearr_16740 = state_16726;
(statearr_16740[(8)] = inst_16696);

return statearr_16740;
})();
var statearr_16742_18128 = state_16726__$1;
(statearr_16742_18128[(2)] = null);

(statearr_16742_18128[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16727 === (4))){
var state_16726__$1 = state_16726;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16726__$1,(7),ch);
} else {
if((state_val_16727 === (6))){
var inst_16719 = (state_16726[(2)]);
var state_16726__$1 = state_16726;
var statearr_16744_18129 = state_16726__$1;
(statearr_16744_18129[(2)] = inst_16719);

(statearr_16744_18129[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16727 === (3))){
var inst_16721 = (state_16726[(2)]);
var inst_16724 = cljs.core.async.close_BANG_(out);
var state_16726__$1 = (function (){var statearr_16745 = state_16726;
(statearr_16745[(9)] = inst_16721);

return statearr_16745;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_16726__$1,inst_16724);
} else {
if((state_val_16727 === (2))){
var inst_16696 = (state_16726[(8)]);
var inst_16701 = (inst_16696 < n);
var state_16726__$1 = state_16726;
if(cljs.core.truth_(inst_16701)){
var statearr_16750_18131 = state_16726__$1;
(statearr_16750_18131[(1)] = (4));

} else {
var statearr_16751_18132 = state_16726__$1;
(statearr_16751_18132[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16727 === (11))){
var inst_16696 = (state_16726[(8)]);
var inst_16709 = (state_16726[(2)]);
var inst_16710 = (inst_16696 + (1));
var inst_16696__$1 = inst_16710;
var state_16726__$1 = (function (){var statearr_16753 = state_16726;
(statearr_16753[(10)] = inst_16709);

(statearr_16753[(8)] = inst_16696__$1);

return statearr_16753;
})();
var statearr_16754_18133 = state_16726__$1;
(statearr_16754_18133[(2)] = null);

(statearr_16754_18133[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16727 === (9))){
var state_16726__$1 = state_16726;
var statearr_16759_18134 = state_16726__$1;
(statearr_16759_18134[(2)] = null);

(statearr_16759_18134[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16727 === (5))){
var state_16726__$1 = state_16726;
var statearr_16769_18135 = state_16726__$1;
(statearr_16769_18135[(2)] = null);

(statearr_16769_18135[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16727 === (10))){
var inst_16714 = (state_16726[(2)]);
var state_16726__$1 = state_16726;
var statearr_16770_18136 = state_16726__$1;
(statearr_16770_18136[(2)] = inst_16714);

(statearr_16770_18136[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16727 === (8))){
var inst_16704 = (state_16726[(7)]);
var state_16726__$1 = state_16726;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16726__$1,(11),out,inst_16704);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__14361__auto__ = null;
var cljs$core$async$state_machine__14361__auto____0 = (function (){
var statearr_16772 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_16772[(0)] = cljs$core$async$state_machine__14361__auto__);

(statearr_16772[(1)] = (1));

return statearr_16772;
});
var cljs$core$async$state_machine__14361__auto____1 = (function (state_16726){
while(true){
var ret_value__14362__auto__ = (function (){try{while(true){
var result__14363__auto__ = switch__14360__auto__(state_16726);
if(cljs.core.keyword_identical_QMARK_(result__14363__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14363__auto__;
}
break;
}
}catch (e16773){var ex__14364__auto__ = e16773;
var statearr_16774_18137 = state_16726;
(statearr_16774_18137[(2)] = ex__14364__auto__);


if(cljs.core.seq((state_16726[(4)]))){
var statearr_16776_18138 = state_16726;
(statearr_16776_18138[(1)] = cljs.core.first((state_16726[(4)])));

} else {
throw ex__14364__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14362__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18139 = state_16726;
state_16726 = G__18139;
continue;
} else {
return ret_value__14362__auto__;
}
break;
}
});
cljs$core$async$state_machine__14361__auto__ = function(state_16726){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14361__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14361__auto____1.call(this,state_16726);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14361__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14361__auto____0;
cljs$core$async$state_machine__14361__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14361__auto____1;
return cljs$core$async$state_machine__14361__auto__;
})()
})();
var state__14558__auto__ = (function (){var statearr_16780 = f__14557__auto__();
(statearr_16780[(6)] = c__14556__auto___18125);

return statearr_16780;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14558__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16799 = (function (f,ch,meta16785,_,fn1,meta16800){
this.f = f;
this.ch = ch;
this.meta16785 = meta16785;
this._ = _;
this.fn1 = fn1;
this.meta16800 = meta16800;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async16799.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16801,meta16800__$1){
var self__ = this;
var _16801__$1 = this;
return (new cljs.core.async.t_cljs$core$async16799(self__.f,self__.ch,self__.meta16785,self__._,self__.fn1,meta16800__$1));
}));

(cljs.core.async.t_cljs$core$async16799.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16801){
var self__ = this;
var _16801__$1 = this;
return self__.meta16800;
}));

(cljs.core.async.t_cljs$core$async16799.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16799.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async16799.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async16799.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__16783_SHARP_){
var G__16806 = (((p1__16783_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__16783_SHARP_) : self__.f.call(null,p1__16783_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__16806) : f1.call(null,G__16806));
});
}));

(cljs.core.async.t_cljs$core$async16799.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16785","meta16785",-645450188,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async16784","cljs.core.async/t_cljs$core$async16784",-310650330,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta16800","meta16800",1407989009,null)], null);
}));

(cljs.core.async.t_cljs$core$async16799.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async16799.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16799");

(cljs.core.async.t_cljs$core$async16799.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async16799");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async16799.
 */
cljs.core.async.__GT_t_cljs$core$async16799 = (function cljs$core$async$__GT_t_cljs$core$async16799(f,ch,meta16785,_,fn1,meta16800){
return (new cljs.core.async.t_cljs$core$async16799(f,ch,meta16785,_,fn1,meta16800));
});



/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16784 = (function (f,ch,meta16785){
this.f = f;
this.ch = ch;
this.meta16785 = meta16785;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async16784.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16786,meta16785__$1){
var self__ = this;
var _16786__$1 = this;
return (new cljs.core.async.t_cljs$core$async16784(self__.f,self__.ch,meta16785__$1));
}));

(cljs.core.async.t_cljs$core$async16784.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16786){
var self__ = this;
var _16786__$1 = this;
return self__.meta16785;
}));

(cljs.core.async.t_cljs$core$async16784.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16784.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async16784.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async16784.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16784.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(new cljs.core.async.t_cljs$core$async16799(self__.f,self__.ch,self__.meta16785,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY)));
if(cljs.core.truth_((function (){var and__5000__auto__ = ret;
if(cljs.core.truth_(and__5000__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__5000__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__16813 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__16813) : self__.f.call(null,G__16813));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async16784.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16784.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async16784.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16785","meta16785",-645450188,null)], null);
}));

(cljs.core.async.t_cljs$core$async16784.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async16784.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16784");

(cljs.core.async.t_cljs$core$async16784.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async16784");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async16784.
 */
cljs.core.async.__GT_t_cljs$core$async16784 = (function cljs$core$async$__GT_t_cljs$core$async16784(f,ch,meta16785){
return (new cljs.core.async.t_cljs$core$async16784(f,ch,meta16785));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
return (new cljs.core.async.t_cljs$core$async16784(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16822 = (function (f,ch,meta16823){
this.f = f;
this.ch = ch;
this.meta16823 = meta16823;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async16822.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16824,meta16823__$1){
var self__ = this;
var _16824__$1 = this;
return (new cljs.core.async.t_cljs$core$async16822(self__.f,self__.ch,meta16823__$1));
}));

(cljs.core.async.t_cljs$core$async16822.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16824){
var self__ = this;
var _16824__$1 = this;
return self__.meta16823;
}));

(cljs.core.async.t_cljs$core$async16822.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16822.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async16822.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16822.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async16822.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16822.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async16822.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16823","meta16823",-805982157,null)], null);
}));

(cljs.core.async.t_cljs$core$async16822.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async16822.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16822");

(cljs.core.async.t_cljs$core$async16822.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async16822");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async16822.
 */
cljs.core.async.__GT_t_cljs$core$async16822 = (function cljs$core$async$__GT_t_cljs$core$async16822(f,ch,meta16823){
return (new cljs.core.async.t_cljs$core$async16822(f,ch,meta16823));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
return (new cljs.core.async.t_cljs$core$async16822(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16839 = (function (p,ch,meta16840){
this.p = p;
this.ch = ch;
this.meta16840 = meta16840;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async16839.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16841,meta16840__$1){
var self__ = this;
var _16841__$1 = this;
return (new cljs.core.async.t_cljs$core$async16839(self__.p,self__.ch,meta16840__$1));
}));

(cljs.core.async.t_cljs$core$async16839.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16841){
var self__ = this;
var _16841__$1 = this;
return self__.meta16840;
}));

(cljs.core.async.t_cljs$core$async16839.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16839.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async16839.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async16839.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16839.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async16839.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16839.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async16839.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16840","meta16840",1924599581,null)], null);
}));

(cljs.core.async.t_cljs$core$async16839.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async16839.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16839");

(cljs.core.async.t_cljs$core$async16839.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async16839");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async16839.
 */
cljs.core.async.__GT_t_cljs$core$async16839 = (function cljs$core$async$__GT_t_cljs$core$async16839(p,ch,meta16840){
return (new cljs.core.async.t_cljs$core$async16839(p,ch,meta16840));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
return (new cljs.core.async.t_cljs$core$async16839(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__16853 = arguments.length;
switch (G__16853) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__14556__auto___18153 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14557__auto__ = (function (){var switch__14360__auto__ = (function (state_16879){
var state_val_16880 = (state_16879[(1)]);
if((state_val_16880 === (7))){
var inst_16875 = (state_16879[(2)]);
var state_16879__$1 = state_16879;
var statearr_16881_18154 = state_16879__$1;
(statearr_16881_18154[(2)] = inst_16875);

(statearr_16881_18154[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16880 === (1))){
var state_16879__$1 = state_16879;
var statearr_16883_18157 = state_16879__$1;
(statearr_16883_18157[(2)] = null);

(statearr_16883_18157[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16880 === (4))){
var inst_16860 = (state_16879[(7)]);
var inst_16860__$1 = (state_16879[(2)]);
var inst_16861 = (inst_16860__$1 == null);
var state_16879__$1 = (function (){var statearr_16885 = state_16879;
(statearr_16885[(7)] = inst_16860__$1);

return statearr_16885;
})();
if(cljs.core.truth_(inst_16861)){
var statearr_16886_18159 = state_16879__$1;
(statearr_16886_18159[(1)] = (5));

} else {
var statearr_16887_18160 = state_16879__$1;
(statearr_16887_18160[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16880 === (6))){
var inst_16860 = (state_16879[(7)]);
var inst_16866 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_16860) : p.call(null,inst_16860));
var state_16879__$1 = state_16879;
if(cljs.core.truth_(inst_16866)){
var statearr_16889_18162 = state_16879__$1;
(statearr_16889_18162[(1)] = (8));

} else {
var statearr_16890_18163 = state_16879__$1;
(statearr_16890_18163[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16880 === (3))){
var inst_16877 = (state_16879[(2)]);
var state_16879__$1 = state_16879;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16879__$1,inst_16877);
} else {
if((state_val_16880 === (2))){
var state_16879__$1 = state_16879;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16879__$1,(4),ch);
} else {
if((state_val_16880 === (11))){
var inst_16869 = (state_16879[(2)]);
var state_16879__$1 = state_16879;
var statearr_16891_18164 = state_16879__$1;
(statearr_16891_18164[(2)] = inst_16869);

(statearr_16891_18164[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16880 === (9))){
var state_16879__$1 = state_16879;
var statearr_16892_18169 = state_16879__$1;
(statearr_16892_18169[(2)] = null);

(statearr_16892_18169[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16880 === (5))){
var inst_16863 = cljs.core.async.close_BANG_(out);
var state_16879__$1 = state_16879;
var statearr_16895_18170 = state_16879__$1;
(statearr_16895_18170[(2)] = inst_16863);

(statearr_16895_18170[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16880 === (10))){
var inst_16872 = (state_16879[(2)]);
var state_16879__$1 = (function (){var statearr_16896 = state_16879;
(statearr_16896[(8)] = inst_16872);

return statearr_16896;
})();
var statearr_16897_18174 = state_16879__$1;
(statearr_16897_18174[(2)] = null);

(statearr_16897_18174[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16880 === (8))){
var inst_16860 = (state_16879[(7)]);
var state_16879__$1 = state_16879;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16879__$1,(11),out,inst_16860);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__14361__auto__ = null;
var cljs$core$async$state_machine__14361__auto____0 = (function (){
var statearr_16899 = [null,null,null,null,null,null,null,null,null];
(statearr_16899[(0)] = cljs$core$async$state_machine__14361__auto__);

(statearr_16899[(1)] = (1));

return statearr_16899;
});
var cljs$core$async$state_machine__14361__auto____1 = (function (state_16879){
while(true){
var ret_value__14362__auto__ = (function (){try{while(true){
var result__14363__auto__ = switch__14360__auto__(state_16879);
if(cljs.core.keyword_identical_QMARK_(result__14363__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14363__auto__;
}
break;
}
}catch (e16900){var ex__14364__auto__ = e16900;
var statearr_16901_18179 = state_16879;
(statearr_16901_18179[(2)] = ex__14364__auto__);


if(cljs.core.seq((state_16879[(4)]))){
var statearr_16903_18180 = state_16879;
(statearr_16903_18180[(1)] = cljs.core.first((state_16879[(4)])));

} else {
throw ex__14364__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14362__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18182 = state_16879;
state_16879 = G__18182;
continue;
} else {
return ret_value__14362__auto__;
}
break;
}
});
cljs$core$async$state_machine__14361__auto__ = function(state_16879){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14361__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14361__auto____1.call(this,state_16879);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14361__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14361__auto____0;
cljs$core$async$state_machine__14361__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14361__auto____1;
return cljs$core$async$state_machine__14361__auto__;
})()
})();
var state__14558__auto__ = (function (){var statearr_16907 = f__14557__auto__();
(statearr_16907[(6)] = c__14556__auto___18153);

return statearr_16907;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14558__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__16912 = arguments.length;
switch (G__16912) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__14556__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14557__auto__ = (function (){var switch__14360__auto__ = (function (state_16982){
var state_val_16983 = (state_16982[(1)]);
if((state_val_16983 === (7))){
var inst_16977 = (state_16982[(2)]);
var state_16982__$1 = state_16982;
var statearr_16985_18184 = state_16982__$1;
(statearr_16985_18184[(2)] = inst_16977);

(statearr_16985_18184[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16983 === (20))){
var inst_16945 = (state_16982[(7)]);
var inst_16956 = (state_16982[(2)]);
var inst_16958 = cljs.core.next(inst_16945);
var inst_16931 = inst_16958;
var inst_16932 = null;
var inst_16933 = (0);
var inst_16934 = (0);
var state_16982__$1 = (function (){var statearr_16987 = state_16982;
(statearr_16987[(8)] = inst_16933);

(statearr_16987[(9)] = inst_16932);

(statearr_16987[(10)] = inst_16931);

(statearr_16987[(11)] = inst_16956);

(statearr_16987[(12)] = inst_16934);

return statearr_16987;
})();
var statearr_16989_18189 = state_16982__$1;
(statearr_16989_18189[(2)] = null);

(statearr_16989_18189[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16983 === (1))){
var state_16982__$1 = state_16982;
var statearr_16991_18190 = state_16982__$1;
(statearr_16991_18190[(2)] = null);

(statearr_16991_18190[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16983 === (4))){
var inst_16918 = (state_16982[(13)]);
var inst_16918__$1 = (state_16982[(2)]);
var inst_16921 = (inst_16918__$1 == null);
var state_16982__$1 = (function (){var statearr_16992 = state_16982;
(statearr_16992[(13)] = inst_16918__$1);

return statearr_16992;
})();
if(cljs.core.truth_(inst_16921)){
var statearr_16993_18191 = state_16982__$1;
(statearr_16993_18191[(1)] = (5));

} else {
var statearr_16994_18192 = state_16982__$1;
(statearr_16994_18192[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16983 === (15))){
var state_16982__$1 = state_16982;
var statearr_16998_18193 = state_16982__$1;
(statearr_16998_18193[(2)] = null);

(statearr_16998_18193[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16983 === (21))){
var state_16982__$1 = state_16982;
var statearr_17000_18194 = state_16982__$1;
(statearr_17000_18194[(2)] = null);

(statearr_17000_18194[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16983 === (13))){
var inst_16933 = (state_16982[(8)]);
var inst_16932 = (state_16982[(9)]);
var inst_16931 = (state_16982[(10)]);
var inst_16934 = (state_16982[(12)]);
var inst_16941 = (state_16982[(2)]);
var inst_16942 = (inst_16934 + (1));
var tmp16995 = inst_16933;
var tmp16996 = inst_16932;
var tmp16997 = inst_16931;
var inst_16931__$1 = tmp16997;
var inst_16932__$1 = tmp16996;
var inst_16933__$1 = tmp16995;
var inst_16934__$1 = inst_16942;
var state_16982__$1 = (function (){var statearr_17001 = state_16982;
(statearr_17001[(8)] = inst_16933__$1);

(statearr_17001[(9)] = inst_16932__$1);

(statearr_17001[(14)] = inst_16941);

(statearr_17001[(10)] = inst_16931__$1);

(statearr_17001[(12)] = inst_16934__$1);

return statearr_17001;
})();
var statearr_17003_18199 = state_16982__$1;
(statearr_17003_18199[(2)] = null);

(statearr_17003_18199[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16983 === (22))){
var state_16982__$1 = state_16982;
var statearr_17007_18200 = state_16982__$1;
(statearr_17007_18200[(2)] = null);

(statearr_17007_18200[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16983 === (6))){
var inst_16918 = (state_16982[(13)]);
var inst_16929 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_16918) : f.call(null,inst_16918));
var inst_16930 = cljs.core.seq(inst_16929);
var inst_16931 = inst_16930;
var inst_16932 = null;
var inst_16933 = (0);
var inst_16934 = (0);
var state_16982__$1 = (function (){var statearr_17016 = state_16982;
(statearr_17016[(8)] = inst_16933);

(statearr_17016[(9)] = inst_16932);

(statearr_17016[(10)] = inst_16931);

(statearr_17016[(12)] = inst_16934);

return statearr_17016;
})();
var statearr_17018_18204 = state_16982__$1;
(statearr_17018_18204[(2)] = null);

(statearr_17018_18204[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16983 === (17))){
var inst_16945 = (state_16982[(7)]);
var inst_16949 = cljs.core.chunk_first(inst_16945);
var inst_16950 = cljs.core.chunk_rest(inst_16945);
var inst_16951 = cljs.core.count(inst_16949);
var inst_16931 = inst_16950;
var inst_16932 = inst_16949;
var inst_16933 = inst_16951;
var inst_16934 = (0);
var state_16982__$1 = (function (){var statearr_17020 = state_16982;
(statearr_17020[(8)] = inst_16933);

(statearr_17020[(9)] = inst_16932);

(statearr_17020[(10)] = inst_16931);

(statearr_17020[(12)] = inst_16934);

return statearr_17020;
})();
var statearr_17022_18205 = state_16982__$1;
(statearr_17022_18205[(2)] = null);

(statearr_17022_18205[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16983 === (3))){
var inst_16979 = (state_16982[(2)]);
var state_16982__$1 = state_16982;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16982__$1,inst_16979);
} else {
if((state_val_16983 === (12))){
var inst_16966 = (state_16982[(2)]);
var state_16982__$1 = state_16982;
var statearr_17029_18206 = state_16982__$1;
(statearr_17029_18206[(2)] = inst_16966);

(statearr_17029_18206[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16983 === (2))){
var state_16982__$1 = state_16982;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16982__$1,(4),in$);
} else {
if((state_val_16983 === (23))){
var inst_16975 = (state_16982[(2)]);
var state_16982__$1 = state_16982;
var statearr_17032_18207 = state_16982__$1;
(statearr_17032_18207[(2)] = inst_16975);

(statearr_17032_18207[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16983 === (19))){
var inst_16961 = (state_16982[(2)]);
var state_16982__$1 = state_16982;
var statearr_17036_18208 = state_16982__$1;
(statearr_17036_18208[(2)] = inst_16961);

(statearr_17036_18208[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16983 === (11))){
var inst_16931 = (state_16982[(10)]);
var inst_16945 = (state_16982[(7)]);
var inst_16945__$1 = cljs.core.seq(inst_16931);
var state_16982__$1 = (function (){var statearr_17040 = state_16982;
(statearr_17040[(7)] = inst_16945__$1);

return statearr_17040;
})();
if(inst_16945__$1){
var statearr_17041_18209 = state_16982__$1;
(statearr_17041_18209[(1)] = (14));

} else {
var statearr_17042_18210 = state_16982__$1;
(statearr_17042_18210[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16983 === (9))){
var inst_16968 = (state_16982[(2)]);
var inst_16969 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_16982__$1 = (function (){var statearr_17045 = state_16982;
(statearr_17045[(15)] = inst_16968);

return statearr_17045;
})();
if(cljs.core.truth_(inst_16969)){
var statearr_17047_18211 = state_16982__$1;
(statearr_17047_18211[(1)] = (21));

} else {
var statearr_17050_18212 = state_16982__$1;
(statearr_17050_18212[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16983 === (5))){
var inst_16923 = cljs.core.async.close_BANG_(out);
var state_16982__$1 = state_16982;
var statearr_17051_18216 = state_16982__$1;
(statearr_17051_18216[(2)] = inst_16923);

(statearr_17051_18216[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16983 === (14))){
var inst_16945 = (state_16982[(7)]);
var inst_16947 = cljs.core.chunked_seq_QMARK_(inst_16945);
var state_16982__$1 = state_16982;
if(inst_16947){
var statearr_17054_18218 = state_16982__$1;
(statearr_17054_18218[(1)] = (17));

} else {
var statearr_17057_18219 = state_16982__$1;
(statearr_17057_18219[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16983 === (16))){
var inst_16964 = (state_16982[(2)]);
var state_16982__$1 = state_16982;
var statearr_17060_18221 = state_16982__$1;
(statearr_17060_18221[(2)] = inst_16964);

(statearr_17060_18221[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16983 === (10))){
var inst_16932 = (state_16982[(9)]);
var inst_16934 = (state_16982[(12)]);
var inst_16939 = cljs.core._nth(inst_16932,inst_16934);
var state_16982__$1 = state_16982;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16982__$1,(13),out,inst_16939);
} else {
if((state_val_16983 === (18))){
var inst_16945 = (state_16982[(7)]);
var inst_16954 = cljs.core.first(inst_16945);
var state_16982__$1 = state_16982;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16982__$1,(20),out,inst_16954);
} else {
if((state_val_16983 === (8))){
var inst_16933 = (state_16982[(8)]);
var inst_16934 = (state_16982[(12)]);
var inst_16936 = (inst_16934 < inst_16933);
var inst_16937 = inst_16936;
var state_16982__$1 = state_16982;
if(cljs.core.truth_(inst_16937)){
var statearr_17064_18222 = state_16982__$1;
(statearr_17064_18222[(1)] = (10));

} else {
var statearr_17065_18223 = state_16982__$1;
(statearr_17065_18223[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__14361__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__14361__auto____0 = (function (){
var statearr_17066 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17066[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__14361__auto__);

(statearr_17066[(1)] = (1));

return statearr_17066;
});
var cljs$core$async$mapcat_STAR__$_state_machine__14361__auto____1 = (function (state_16982){
while(true){
var ret_value__14362__auto__ = (function (){try{while(true){
var result__14363__auto__ = switch__14360__auto__(state_16982);
if(cljs.core.keyword_identical_QMARK_(result__14363__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14363__auto__;
}
break;
}
}catch (e17067){var ex__14364__auto__ = e17067;
var statearr_17069_18224 = state_16982;
(statearr_17069_18224[(2)] = ex__14364__auto__);


if(cljs.core.seq((state_16982[(4)]))){
var statearr_17070_18225 = state_16982;
(statearr_17070_18225[(1)] = cljs.core.first((state_16982[(4)])));

} else {
throw ex__14364__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14362__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18226 = state_16982;
state_16982 = G__18226;
continue;
} else {
return ret_value__14362__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__14361__auto__ = function(state_16982){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__14361__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__14361__auto____1.call(this,state_16982);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__14361__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__14361__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__14361__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__14361__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__14361__auto__;
})()
})();
var state__14558__auto__ = (function (){var statearr_17074 = f__14557__auto__();
(statearr_17074[(6)] = c__14556__auto__);

return statearr_17074;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14558__auto__);
}));

return c__14556__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__17086 = arguments.length;
switch (G__17086) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__17105 = arguments.length;
switch (G__17105) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__17112 = arguments.length;
switch (G__17112) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__14556__auto___18234 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14557__auto__ = (function (){var switch__14360__auto__ = (function (state_17142){
var state_val_17147 = (state_17142[(1)]);
if((state_val_17147 === (7))){
var inst_17137 = (state_17142[(2)]);
var state_17142__$1 = state_17142;
var statearr_17152_18235 = state_17142__$1;
(statearr_17152_18235[(2)] = inst_17137);

(statearr_17152_18235[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17147 === (1))){
var inst_17115 = null;
var state_17142__$1 = (function (){var statearr_17154 = state_17142;
(statearr_17154[(7)] = inst_17115);

return statearr_17154;
})();
var statearr_17155_18236 = state_17142__$1;
(statearr_17155_18236[(2)] = null);

(statearr_17155_18236[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17147 === (4))){
var inst_17118 = (state_17142[(8)]);
var inst_17118__$1 = (state_17142[(2)]);
var inst_17119 = (inst_17118__$1 == null);
var inst_17120 = cljs.core.not(inst_17119);
var state_17142__$1 = (function (){var statearr_17161 = state_17142;
(statearr_17161[(8)] = inst_17118__$1);

return statearr_17161;
})();
if(inst_17120){
var statearr_17162_18237 = state_17142__$1;
(statearr_17162_18237[(1)] = (5));

} else {
var statearr_17163_18238 = state_17142__$1;
(statearr_17163_18238[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17147 === (6))){
var state_17142__$1 = state_17142;
var statearr_17167_18239 = state_17142__$1;
(statearr_17167_18239[(2)] = null);

(statearr_17167_18239[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17147 === (3))){
var inst_17139 = (state_17142[(2)]);
var inst_17140 = cljs.core.async.close_BANG_(out);
var state_17142__$1 = (function (){var statearr_17168 = state_17142;
(statearr_17168[(9)] = inst_17139);

return statearr_17168;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_17142__$1,inst_17140);
} else {
if((state_val_17147 === (2))){
var state_17142__$1 = state_17142;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17142__$1,(4),ch);
} else {
if((state_val_17147 === (11))){
var inst_17118 = (state_17142[(8)]);
var inst_17131 = (state_17142[(2)]);
var inst_17115 = inst_17118;
var state_17142__$1 = (function (){var statearr_17172 = state_17142;
(statearr_17172[(10)] = inst_17131);

(statearr_17172[(7)] = inst_17115);

return statearr_17172;
})();
var statearr_17175_18240 = state_17142__$1;
(statearr_17175_18240[(2)] = null);

(statearr_17175_18240[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17147 === (9))){
var inst_17118 = (state_17142[(8)]);
var state_17142__$1 = state_17142;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17142__$1,(11),out,inst_17118);
} else {
if((state_val_17147 === (5))){
var inst_17115 = (state_17142[(7)]);
var inst_17118 = (state_17142[(8)]);
var inst_17122 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_17118,inst_17115);
var state_17142__$1 = state_17142;
if(inst_17122){
var statearr_17180_18241 = state_17142__$1;
(statearr_17180_18241[(1)] = (8));

} else {
var statearr_17183_18242 = state_17142__$1;
(statearr_17183_18242[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17147 === (10))){
var inst_17134 = (state_17142[(2)]);
var state_17142__$1 = state_17142;
var statearr_17185_18243 = state_17142__$1;
(statearr_17185_18243[(2)] = inst_17134);

(statearr_17185_18243[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17147 === (8))){
var inst_17115 = (state_17142[(7)]);
var tmp17179 = inst_17115;
var inst_17115__$1 = tmp17179;
var state_17142__$1 = (function (){var statearr_17186 = state_17142;
(statearr_17186[(7)] = inst_17115__$1);

return statearr_17186;
})();
var statearr_17189_18244 = state_17142__$1;
(statearr_17189_18244[(2)] = null);

(statearr_17189_18244[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__14361__auto__ = null;
var cljs$core$async$state_machine__14361__auto____0 = (function (){
var statearr_17192 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17192[(0)] = cljs$core$async$state_machine__14361__auto__);

(statearr_17192[(1)] = (1));

return statearr_17192;
});
var cljs$core$async$state_machine__14361__auto____1 = (function (state_17142){
while(true){
var ret_value__14362__auto__ = (function (){try{while(true){
var result__14363__auto__ = switch__14360__auto__(state_17142);
if(cljs.core.keyword_identical_QMARK_(result__14363__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14363__auto__;
}
break;
}
}catch (e17195){var ex__14364__auto__ = e17195;
var statearr_17196_18245 = state_17142;
(statearr_17196_18245[(2)] = ex__14364__auto__);


if(cljs.core.seq((state_17142[(4)]))){
var statearr_17197_18246 = state_17142;
(statearr_17197_18246[(1)] = cljs.core.first((state_17142[(4)])));

} else {
throw ex__14364__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14362__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18247 = state_17142;
state_17142 = G__18247;
continue;
} else {
return ret_value__14362__auto__;
}
break;
}
});
cljs$core$async$state_machine__14361__auto__ = function(state_17142){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14361__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14361__auto____1.call(this,state_17142);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14361__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14361__auto____0;
cljs$core$async$state_machine__14361__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14361__auto____1;
return cljs$core$async$state_machine__14361__auto__;
})()
})();
var state__14558__auto__ = (function (){var statearr_17198 = f__14557__auto__();
(statearr_17198[(6)] = c__14556__auto___18234);

return statearr_17198;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14558__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__17210 = arguments.length;
switch (G__17210) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__14556__auto___18251 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14557__auto__ = (function (){var switch__14360__auto__ = (function (state_17250){
var state_val_17251 = (state_17250[(1)]);
if((state_val_17251 === (7))){
var inst_17246 = (state_17250[(2)]);
var state_17250__$1 = state_17250;
var statearr_17252_18253 = state_17250__$1;
(statearr_17252_18253[(2)] = inst_17246);

(statearr_17252_18253[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17251 === (1))){
var inst_17213 = (new Array(n));
var inst_17214 = inst_17213;
var inst_17215 = (0);
var state_17250__$1 = (function (){var statearr_17253 = state_17250;
(statearr_17253[(7)] = inst_17214);

(statearr_17253[(8)] = inst_17215);

return statearr_17253;
})();
var statearr_17254_18254 = state_17250__$1;
(statearr_17254_18254[(2)] = null);

(statearr_17254_18254[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17251 === (4))){
var inst_17218 = (state_17250[(9)]);
var inst_17218__$1 = (state_17250[(2)]);
var inst_17219 = (inst_17218__$1 == null);
var inst_17220 = cljs.core.not(inst_17219);
var state_17250__$1 = (function (){var statearr_17256 = state_17250;
(statearr_17256[(9)] = inst_17218__$1);

return statearr_17256;
})();
if(inst_17220){
var statearr_17257_18255 = state_17250__$1;
(statearr_17257_18255[(1)] = (5));

} else {
var statearr_17260_18257 = state_17250__$1;
(statearr_17260_18257[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17251 === (15))){
var inst_17240 = (state_17250[(2)]);
var state_17250__$1 = state_17250;
var statearr_17262_18258 = state_17250__$1;
(statearr_17262_18258[(2)] = inst_17240);

(statearr_17262_18258[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17251 === (13))){
var state_17250__$1 = state_17250;
var statearr_17263_18259 = state_17250__$1;
(statearr_17263_18259[(2)] = null);

(statearr_17263_18259[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17251 === (6))){
var inst_17215 = (state_17250[(8)]);
var inst_17236 = (inst_17215 > (0));
var state_17250__$1 = state_17250;
if(cljs.core.truth_(inst_17236)){
var statearr_17267_18260 = state_17250__$1;
(statearr_17267_18260[(1)] = (12));

} else {
var statearr_17268_18261 = state_17250__$1;
(statearr_17268_18261[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17251 === (3))){
var inst_17248 = (state_17250[(2)]);
var state_17250__$1 = state_17250;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17250__$1,inst_17248);
} else {
if((state_val_17251 === (12))){
var inst_17214 = (state_17250[(7)]);
var inst_17238 = cljs.core.vec(inst_17214);
var state_17250__$1 = state_17250;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17250__$1,(15),out,inst_17238);
} else {
if((state_val_17251 === (2))){
var state_17250__$1 = state_17250;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17250__$1,(4),ch);
} else {
if((state_val_17251 === (11))){
var inst_17230 = (state_17250[(2)]);
var inst_17231 = (new Array(n));
var inst_17214 = inst_17231;
var inst_17215 = (0);
var state_17250__$1 = (function (){var statearr_17273 = state_17250;
(statearr_17273[(7)] = inst_17214);

(statearr_17273[(8)] = inst_17215);

(statearr_17273[(10)] = inst_17230);

return statearr_17273;
})();
var statearr_17274_18265 = state_17250__$1;
(statearr_17274_18265[(2)] = null);

(statearr_17274_18265[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17251 === (9))){
var inst_17214 = (state_17250[(7)]);
var inst_17228 = cljs.core.vec(inst_17214);
var state_17250__$1 = state_17250;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17250__$1,(11),out,inst_17228);
} else {
if((state_val_17251 === (5))){
var inst_17218 = (state_17250[(9)]);
var inst_17214 = (state_17250[(7)]);
var inst_17223 = (state_17250[(11)]);
var inst_17215 = (state_17250[(8)]);
var inst_17222 = (inst_17214[inst_17215] = inst_17218);
var inst_17223__$1 = (inst_17215 + (1));
var inst_17224 = (inst_17223__$1 < n);
var state_17250__$1 = (function (){var statearr_17279 = state_17250;
(statearr_17279[(11)] = inst_17223__$1);

(statearr_17279[(12)] = inst_17222);

return statearr_17279;
})();
if(cljs.core.truth_(inst_17224)){
var statearr_17281_18267 = state_17250__$1;
(statearr_17281_18267[(1)] = (8));

} else {
var statearr_17282_18269 = state_17250__$1;
(statearr_17282_18269[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17251 === (14))){
var inst_17243 = (state_17250[(2)]);
var inst_17244 = cljs.core.async.close_BANG_(out);
var state_17250__$1 = (function (){var statearr_17287 = state_17250;
(statearr_17287[(13)] = inst_17243);

return statearr_17287;
})();
var statearr_17288_18270 = state_17250__$1;
(statearr_17288_18270[(2)] = inst_17244);

(statearr_17288_18270[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17251 === (10))){
var inst_17234 = (state_17250[(2)]);
var state_17250__$1 = state_17250;
var statearr_17290_18271 = state_17250__$1;
(statearr_17290_18271[(2)] = inst_17234);

(statearr_17290_18271[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17251 === (8))){
var inst_17214 = (state_17250[(7)]);
var inst_17223 = (state_17250[(11)]);
var tmp17284 = inst_17214;
var inst_17214__$1 = tmp17284;
var inst_17215 = inst_17223;
var state_17250__$1 = (function (){var statearr_17294 = state_17250;
(statearr_17294[(7)] = inst_17214__$1);

(statearr_17294[(8)] = inst_17215);

return statearr_17294;
})();
var statearr_17295_18272 = state_17250__$1;
(statearr_17295_18272[(2)] = null);

(statearr_17295_18272[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__14361__auto__ = null;
var cljs$core$async$state_machine__14361__auto____0 = (function (){
var statearr_17299 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17299[(0)] = cljs$core$async$state_machine__14361__auto__);

(statearr_17299[(1)] = (1));

return statearr_17299;
});
var cljs$core$async$state_machine__14361__auto____1 = (function (state_17250){
while(true){
var ret_value__14362__auto__ = (function (){try{while(true){
var result__14363__auto__ = switch__14360__auto__(state_17250);
if(cljs.core.keyword_identical_QMARK_(result__14363__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14363__auto__;
}
break;
}
}catch (e17301){var ex__14364__auto__ = e17301;
var statearr_17303_18273 = state_17250;
(statearr_17303_18273[(2)] = ex__14364__auto__);


if(cljs.core.seq((state_17250[(4)]))){
var statearr_17304_18274 = state_17250;
(statearr_17304_18274[(1)] = cljs.core.first((state_17250[(4)])));

} else {
throw ex__14364__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14362__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18282 = state_17250;
state_17250 = G__18282;
continue;
} else {
return ret_value__14362__auto__;
}
break;
}
});
cljs$core$async$state_machine__14361__auto__ = function(state_17250){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14361__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14361__auto____1.call(this,state_17250);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14361__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14361__auto____0;
cljs$core$async$state_machine__14361__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14361__auto____1;
return cljs$core$async$state_machine__14361__auto__;
})()
})();
var state__14558__auto__ = (function (){var statearr_17308 = f__14557__auto__();
(statearr_17308[(6)] = c__14556__auto___18251);

return statearr_17308;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14558__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__17318 = arguments.length;
switch (G__17318) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__14556__auto___18289 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14557__auto__ = (function (){var switch__14360__auto__ = (function (state_17379){
var state_val_17380 = (state_17379[(1)]);
if((state_val_17380 === (7))){
var inst_17373 = (state_17379[(2)]);
var state_17379__$1 = state_17379;
var statearr_17388_18294 = state_17379__$1;
(statearr_17388_18294[(2)] = inst_17373);

(statearr_17388_18294[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17380 === (1))){
var inst_17331 = [];
var inst_17332 = inst_17331;
var inst_17333 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_17379__$1 = (function (){var statearr_17390 = state_17379;
(statearr_17390[(7)] = inst_17333);

(statearr_17390[(8)] = inst_17332);

return statearr_17390;
})();
var statearr_17392_18296 = state_17379__$1;
(statearr_17392_18296[(2)] = null);

(statearr_17392_18296[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17380 === (4))){
var inst_17337 = (state_17379[(9)]);
var inst_17337__$1 = (state_17379[(2)]);
var inst_17338 = (inst_17337__$1 == null);
var inst_17339 = cljs.core.not(inst_17338);
var state_17379__$1 = (function (){var statearr_17395 = state_17379;
(statearr_17395[(9)] = inst_17337__$1);

return statearr_17395;
})();
if(inst_17339){
var statearr_17396_18297 = state_17379__$1;
(statearr_17396_18297[(1)] = (5));

} else {
var statearr_17399_18298 = state_17379__$1;
(statearr_17399_18298[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17380 === (15))){
var inst_17332 = (state_17379[(8)]);
var inst_17365 = cljs.core.vec(inst_17332);
var state_17379__$1 = state_17379;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17379__$1,(18),out,inst_17365);
} else {
if((state_val_17380 === (13))){
var inst_17360 = (state_17379[(2)]);
var state_17379__$1 = state_17379;
var statearr_17402_18300 = state_17379__$1;
(statearr_17402_18300[(2)] = inst_17360);

(statearr_17402_18300[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17380 === (6))){
var inst_17332 = (state_17379[(8)]);
var inst_17362 = inst_17332.length;
var inst_17363 = (inst_17362 > (0));
var state_17379__$1 = state_17379;
if(cljs.core.truth_(inst_17363)){
var statearr_17408_18301 = state_17379__$1;
(statearr_17408_18301[(1)] = (15));

} else {
var statearr_17409_18302 = state_17379__$1;
(statearr_17409_18302[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17380 === (17))){
var inst_17370 = (state_17379[(2)]);
var inst_17371 = cljs.core.async.close_BANG_(out);
var state_17379__$1 = (function (){var statearr_17411 = state_17379;
(statearr_17411[(10)] = inst_17370);

return statearr_17411;
})();
var statearr_17415_18303 = state_17379__$1;
(statearr_17415_18303[(2)] = inst_17371);

(statearr_17415_18303[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17380 === (3))){
var inst_17375 = (state_17379[(2)]);
var state_17379__$1 = state_17379;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17379__$1,inst_17375);
} else {
if((state_val_17380 === (12))){
var inst_17332 = (state_17379[(8)]);
var inst_17353 = cljs.core.vec(inst_17332);
var state_17379__$1 = state_17379;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17379__$1,(14),out,inst_17353);
} else {
if((state_val_17380 === (2))){
var state_17379__$1 = state_17379;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17379__$1,(4),ch);
} else {
if((state_val_17380 === (11))){
var inst_17342 = (state_17379[(11)]);
var inst_17337 = (state_17379[(9)]);
var inst_17332 = (state_17379[(8)]);
var inst_17350 = inst_17332.push(inst_17337);
var tmp17418 = inst_17332;
var inst_17332__$1 = tmp17418;
var inst_17333 = inst_17342;
var state_17379__$1 = (function (){var statearr_17425 = state_17379;
(statearr_17425[(7)] = inst_17333);

(statearr_17425[(8)] = inst_17332__$1);

(statearr_17425[(12)] = inst_17350);

return statearr_17425;
})();
var statearr_17426_18315 = state_17379__$1;
(statearr_17426_18315[(2)] = null);

(statearr_17426_18315[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17380 === (9))){
var inst_17333 = (state_17379[(7)]);
var inst_17346 = cljs.core.keyword_identical_QMARK_(inst_17333,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_17379__$1 = state_17379;
var statearr_17430_18317 = state_17379__$1;
(statearr_17430_18317[(2)] = inst_17346);

(statearr_17430_18317[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17380 === (5))){
var inst_17342 = (state_17379[(11)]);
var inst_17337 = (state_17379[(9)]);
var inst_17333 = (state_17379[(7)]);
var inst_17343 = (state_17379[(13)]);
var inst_17342__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_17337) : f.call(null,inst_17337));
var inst_17343__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_17342__$1,inst_17333);
var state_17379__$1 = (function (){var statearr_17436 = state_17379;
(statearr_17436[(11)] = inst_17342__$1);

(statearr_17436[(13)] = inst_17343__$1);

return statearr_17436;
})();
if(inst_17343__$1){
var statearr_17439_18318 = state_17379__$1;
(statearr_17439_18318[(1)] = (8));

} else {
var statearr_17440_18319 = state_17379__$1;
(statearr_17440_18319[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17380 === (14))){
var inst_17342 = (state_17379[(11)]);
var inst_17337 = (state_17379[(9)]);
var inst_17355 = (state_17379[(2)]);
var inst_17356 = [];
var inst_17357 = inst_17356.push(inst_17337);
var inst_17332 = inst_17356;
var inst_17333 = inst_17342;
var state_17379__$1 = (function (){var statearr_17442 = state_17379;
(statearr_17442[(14)] = inst_17357);

(statearr_17442[(7)] = inst_17333);

(statearr_17442[(15)] = inst_17355);

(statearr_17442[(8)] = inst_17332);

return statearr_17442;
})();
var statearr_17443_18323 = state_17379__$1;
(statearr_17443_18323[(2)] = null);

(statearr_17443_18323[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17380 === (16))){
var state_17379__$1 = state_17379;
var statearr_17444_18325 = state_17379__$1;
(statearr_17444_18325[(2)] = null);

(statearr_17444_18325[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17380 === (10))){
var inst_17348 = (state_17379[(2)]);
var state_17379__$1 = state_17379;
if(cljs.core.truth_(inst_17348)){
var statearr_17445_18326 = state_17379__$1;
(statearr_17445_18326[(1)] = (11));

} else {
var statearr_17446_18327 = state_17379__$1;
(statearr_17446_18327[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17380 === (18))){
var inst_17367 = (state_17379[(2)]);
var state_17379__$1 = state_17379;
var statearr_17449_18328 = state_17379__$1;
(statearr_17449_18328[(2)] = inst_17367);

(statearr_17449_18328[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17380 === (8))){
var inst_17343 = (state_17379[(13)]);
var state_17379__$1 = state_17379;
var statearr_17450_18329 = state_17379__$1;
(statearr_17450_18329[(2)] = inst_17343);

(statearr_17450_18329[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__14361__auto__ = null;
var cljs$core$async$state_machine__14361__auto____0 = (function (){
var statearr_17458 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17458[(0)] = cljs$core$async$state_machine__14361__auto__);

(statearr_17458[(1)] = (1));

return statearr_17458;
});
var cljs$core$async$state_machine__14361__auto____1 = (function (state_17379){
while(true){
var ret_value__14362__auto__ = (function (){try{while(true){
var result__14363__auto__ = switch__14360__auto__(state_17379);
if(cljs.core.keyword_identical_QMARK_(result__14363__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14363__auto__;
}
break;
}
}catch (e17459){var ex__14364__auto__ = e17459;
var statearr_17460_18334 = state_17379;
(statearr_17460_18334[(2)] = ex__14364__auto__);


if(cljs.core.seq((state_17379[(4)]))){
var statearr_17461_18335 = state_17379;
(statearr_17461_18335[(1)] = cljs.core.first((state_17379[(4)])));

} else {
throw ex__14364__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14362__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18336 = state_17379;
state_17379 = G__18336;
continue;
} else {
return ret_value__14362__auto__;
}
break;
}
});
cljs$core$async$state_machine__14361__auto__ = function(state_17379){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14361__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14361__auto____1.call(this,state_17379);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14361__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14361__auto____0;
cljs$core$async$state_machine__14361__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14361__auto____1;
return cljs$core$async$state_machine__14361__auto__;
})()
})();
var state__14558__auto__ = (function (){var statearr_17463 = f__14557__auto__();
(statearr_17463[(6)] = c__14556__auto___18289);

return statearr_17463;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14558__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
