goog.provide('atlas_ui_v2.data');
/**
 * Extract all unique aspects from registry.
 * Returns set of namespaced keywords.
 */
atlas_ui_v2.data.extract_all_aspects = (function atlas_ui_v2$data$extract_all_aspects(registry){
return cljs.core.set(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.keyword_QMARK_,cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.identity,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.keys(registry)], 0))));
});
/**
 * Build hierarchical map of aspects grouped by namespace.
 * 
 * Input: registry
 * Output: {:domain #{:users :auth :scheduling}
 *          :tier #{:service :api :foundation}
 *          :protocol #{:oauth :user-repository}
 *          ...}
 */
atlas_ui_v2.data.build_aspects_map = (function atlas_ui_v2$data$build_aspects_map(registry){
var aspects = atlas_ui_v2.data.extract_all_aspects(registry);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map(),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__14449){
var vec__14450 = p__14449;
var ns_kw = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14450,(0),null);
var aspects_list = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14450,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns_kw,cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__14448_SHARP_){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.name(p1__14448_SHARP_));
}),aspects_list))], null);
}),cljs.core.group_by((function (p1__14447_SHARP_){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.namespace(p1__14447_SHARP_));
}),aspects)));
});
/**
 * Extract the atlas entity type from a compound identity.
 * Returns the :atlas/* keyword if present.
 */
atlas_ui_v2.data.extract_entity_type = (function atlas_ui_v2$data$extract_entity_type(compound_identity){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__14453_SHARP_){
return (((p1__14453_SHARP_ instanceof cljs.core.Keyword)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("atlas",cljs.core.namespace(p1__14453_SHARP_))));
}),compound_identity));
});
/**
 * Build hierarchical map of entities grouped by type.
 * 
 * Input: registry
 * Output: {:atlas/execution-function
 *            {:fn/find-users-by-language #{:tier/service :domain/users ...}
 *             :fn/refresh-oauth-token #{:tier/service :domain/google ...}}
 *          :atlas/structure-component
 *            {:component/db #{:tier/foundation :domain/users ...}}
 *          ...}
 */
atlas_ui_v2.data.build_entities_map = (function atlas_ui_v2$data$build_entities_map(registry){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map(),cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p__14454){
var vec__14455 = p__14454;
var entity_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14455,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14455,(1),null);
return entity_type;
}),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__14458){
var vec__14459 = p__14458;
var entity_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14459,(0),null);
var entries = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14459,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [entity_type,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map(),cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p__14462){
var vec__14463 = p__14462;
var dev_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14463,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14463,(1),null);
return dev_id;
}),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__14466){
var vec__14467 = p__14466;
var identity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14467,(0),null);
var props = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14467,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553).cljs$core$IFn$_invoke$arity$1(props),identity], null);
}),entries)))], null);
}),cljs.core.group_by((function (p__14470){
var vec__14471 = p__14470;
var identity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14471,(0),null);
var _props = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14471,(1),null);
return atlas_ui_v2.data.extract_entity_type(identity);
}),registry))));
});
/**
 * Count how many entities have each aspect.
 * Returns map of {aspect-keyword -> count}
 */
atlas_ui_v2.data.count_entities_by_aspect = (function atlas_ui_v2$data$count_entities_by_aspect(registry){
return cljs.core.frequencies(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.keyword_QMARK_,cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.identity,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.keys(registry)], 0))));
});
/**
 * Count how many entities have each aspect, filtered by current aspect query.
 * Only counts entities that match the AND/OR/NOT criteria.
 * 
 * - If no aspects are selected, returns global counts (same as count-entities-by-aspect)
 * - If aspects are selected, only counts aspects from entities matching the query
 * 
 * Returns map of {aspect-keyword -> count}
 */
atlas_ui_v2.data.count_entities_by_aspect_filtered = (function atlas_ui_v2$data$count_entities_by_aspect_filtered(registry,aspects_and,aspects_or,aspects_not){
if(((cljs.core.empty_QMARK_(aspects_and)) && (((cljs.core.empty_QMARK_(aspects_or)) && (cljs.core.empty_QMARK_(aspects_not)))))){
return atlas_ui_v2.data.count_entities_by_aspect(registry);
} else {
var matching_entities = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p__14477){
var vec__14478 = p__14477;
var identity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14478,(0),null);
var _props = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14478,(1),null);
var matches_and_QMARK_ = ((cljs.core.seq(aspects_and)) && (cljs.core.every_QMARK_((function (p1__14474_SHARP_){
return cljs.core.contains_QMARK_(identity,p1__14474_SHARP_);
}),aspects_and)));
var matches_or_QMARK_ = (function (){var and__5000__auto__ = cljs.core.seq(aspects_or);
if(and__5000__auto__){
return cljs.core.some((function (p1__14475_SHARP_){
return cljs.core.contains_QMARK_(identity,p1__14475_SHARP_);
}),aspects_or);
} else {
return and__5000__auto__;
}
})();
var matches_not_QMARK_ = (function (){var and__5000__auto__ = cljs.core.seq(aspects_not);
if(and__5000__auto__){
return cljs.core.some((function (p1__14476_SHARP_){
return cljs.core.contains_QMARK_(identity,p1__14476_SHARP_);
}),aspects_not);
} else {
return and__5000__auto__;
}
})();
var has_positive_criteria_QMARK_ = ((cljs.core.seq(aspects_and)) || (cljs.core.seq(aspects_or)));
var base_match_QMARK_ = ((has_positive_criteria_QMARK_)?(function (){var or__5002__auto__ = matches_and_QMARK_;
if(or__5002__auto__){
return or__5002__auto__;
} else {
return matches_or_QMARK_;
}
})():true);
var and__5000__auto__ = base_match_QMARK_;
if(cljs.core.truth_(and__5000__auto__)){
return cljs.core.not(matches_not_QMARK_);
} else {
return and__5000__auto__;
}
}),registry));
return cljs.core.frequencies(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.keyword_QMARK_,cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.identity,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([matching_entities], 0))));
}
});
/**
 * Compute statistics about the registry
 */
atlas_ui_v2.data.stats = (function atlas_ui_v2$data$stats(registry){
var aspects_map = atlas_ui_v2.data.build_aspects_map(registry);
var entities_map = atlas_ui_v2.data.build_entities_map(registry);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"aspect-count","aspect-count",-95316145),cljs.core.count(atlas_ui_v2.data.extract_all_aspects(registry)),new cljs.core.Keyword(null,"namespace-count","namespace-count",187554941),cljs.core.count(aspects_map),new cljs.core.Keyword(null,"entity-count","entity-count",870517368),cljs.core.count(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.keys,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.vals(entities_map)], 0))),new cljs.core.Keyword(null,"type-count","type-count",1208627925),cljs.core.count(entities_map)], null);
});
/**
 * Convert aspect-stats from API (vector of {:aspect/aspect kw :aspect/count N})
 * to a map of {aspect-kw -> count} for easier lookup.
 */
atlas_ui_v2.data.aspect_stats__GT_map = (function atlas_ui_v2$data$aspect_stats__GT_map(aspect_stats){
return cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (entry){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("aspect","aspect","aspect/aspect",299955306).cljs$core$IFn$_invoke$arity$1(entry),new cljs.core.Keyword("aspect","count","aspect/count",870152861).cljs$core$IFn$_invoke$arity$1(entry)], null);
})),aspect_stats);
});
/**
 * Compute statistics for each namespace from aspect-stats.
 * Returns map of ns-keyword -> {:total-usage N :aspect-count N}
 */
atlas_ui_v2.data.namespace_stats = (function atlas_ui_v2$data$namespace_stats(aspect_stats_map){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__14481){
var vec__14482 = p__14481;
var aspect = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14482,(0),null);
var cnt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14482,(1),null);
var temp__5802__auto__ = cljs.core.namespace(aspect);
if(cljs.core.truth_(temp__5802__auto__)){
var ns = temp__5802__auto__;
var ns_key = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(ns);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns_key,new cljs.core.Keyword(null,"total-usage","total-usage",-1744675894)], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,(0)),cnt),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns_key,new cljs.core.Keyword(null,"aspect-count","aspect-count",-95316145)], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.inc,(0)));
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,aspect_stats_map);
});
/**
 * Sort the aspects map based on sort-by option.
 * aspect-stats-map: {aspect-kw -> count} from aspect-stats->map
 * 
 * Options:
 * - :alpha-asc - Alphabetical A-Z (default)
 * - :alpha-desc - Alphabetical Z-A
 * - :usage-desc - By total usage (most used first)
 * - :usage-asc - By total usage (least used first)
 * - :count-desc - By aspect count (most aspects first)
 * - :count-asc - By aspect count (fewest aspects first)
 */
atlas_ui_v2.data.sort_aspects_map = (function atlas_ui_v2$data$sort_aspects_map(aspects_map,aspect_stats_map,sort_by){
var ns_stats = atlas_ui_v2.data.namespace_stats(aspect_stats_map);
console.log("sort-aspects-map ns-stats sample:",cljs.core.clj__GT_js(cljs.core.take.cljs$core$IFn$_invoke$arity$2((3),ns_stats)));

var G__14487 = sort_by;
var G__14487__$1 = (((G__14487 instanceof cljs.core.Keyword))?G__14487.fqn:null);
switch (G__14487__$1) {
case "alpha-asc":
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map(),aspects_map);

break;
case "alpha-desc":
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map_by((function (p1__14486_SHARP_,p2__14485_SHARP_){
return cljs.core.compare(p2__14485_SHARP_,p1__14486_SHARP_);
})),aspects_map);

break;
case "usage-desc":
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map_by((function (k1,k2){
var u1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$3(ns_stats,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k1,new cljs.core.Keyword(null,"total-usage","total-usage",-1744675894)], null),(0));
var u2 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$3(ns_stats,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k2,new cljs.core.Keyword(null,"total-usage","total-usage",-1744675894)], null),(0));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(u1,u2)){
return cljs.core.compare(k1,k2);
} else {
return cljs.core.compare(u2,u1);
}
})),aspects_map);

break;
case "usage-asc":
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map_by((function (k1,k2){
var u1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$3(ns_stats,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k1,new cljs.core.Keyword(null,"total-usage","total-usage",-1744675894)], null),(0));
var u2 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$3(ns_stats,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k2,new cljs.core.Keyword(null,"total-usage","total-usage",-1744675894)], null),(0));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(u1,u2)){
return cljs.core.compare(k1,k2);
} else {
return cljs.core.compare(u1,u2);
}
})),aspects_map);

break;
case "count-desc":
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map_by((function (k1,k2){
var c1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$3(ns_stats,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k1,new cljs.core.Keyword(null,"aspect-count","aspect-count",-95316145)], null),(0));
var c2 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$3(ns_stats,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k2,new cljs.core.Keyword(null,"aspect-count","aspect-count",-95316145)], null),(0));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(c1,c2)){
return cljs.core.compare(k1,k2);
} else {
return cljs.core.compare(c2,c1);
}
})),aspects_map);

break;
case "count-asc":
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map_by((function (k1,k2){
var c1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$3(ns_stats,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k1,new cljs.core.Keyword(null,"aspect-count","aspect-count",-95316145)], null),(0));
var c2 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$3(ns_stats,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k2,new cljs.core.Keyword(null,"aspect-count","aspect-count",-95316145)], null),(0));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(c1,c2)){
return cljs.core.compare(k1,k2);
} else {
return cljs.core.compare(c1,c2);
}
})),aspects_map);

break;
default:
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map(),aspects_map);

}
});
/**
 * Sort aspect names within a namespace.
 * 
 * Options:
 * - :alpha-asc - Alphabetical A-Z (default)
 * - :alpha-desc - Alphabetical Z-A
 * - :usage-desc - By usage count (most used first)
 * - :usage-asc - By usage count (least used first)
 */
atlas_ui_v2.data.sort_aspect_names = (function atlas_ui_v2$data$sort_aspect_names(ns_key,aspect_names,aspect_stats_map,sort_by){
var result = (function (){var G__14490 = sort_by;
var G__14490__$1 = (((G__14490 instanceof cljs.core.Keyword))?G__14490.fqn:null);
switch (G__14490__$1) {
case "alpha-asc":
return cljs.core.sort.cljs$core$IFn$_invoke$arity$1(aspect_names);

break;
case "alpha-desc":
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((function (p1__14489_SHARP_,p2__14488_SHARP_){
return cljs.core.compare(p2__14488_SHARP_,p1__14489_SHARP_);
}),aspect_names);

break;
case "usage-desc":
return cljs.core.reverse((function (){var G__14491 = (function (aspect_name){
var full_aspect = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(cljs.core.name(ns_key),cljs.core.name(aspect_name));
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(aspect_stats_map,full_aspect,(0));
});
var G__14492 = aspect_names;
return (sort_by.cljs$core$IFn$_invoke$arity$2 ? sort_by.cljs$core$IFn$_invoke$arity$2(G__14491,G__14492) : sort_by.call(null,G__14491,G__14492));
})());

break;
case "usage-asc":
var G__14493 = (function (aspect_name){
var full_aspect = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(cljs.core.name(ns_key),cljs.core.name(aspect_name));
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(aspect_stats_map,full_aspect,(0));
});
var G__14494 = aspect_names;
return (sort_by.cljs$core$IFn$_invoke$arity$2 ? sort_by.cljs$core$IFn$_invoke$arity$2(G__14493,G__14494) : sort_by.call(null,G__14493,G__14494));

break;
default:
return cljs.core.sort.cljs$core$IFn$_invoke$arity$1(aspect_names);

}
})();
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns_key,new cljs.core.Keyword(null,"domain","domain",1847214937))) && (cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"usage-asc","usage-asc",-762149175),null,new cljs.core.Keyword(null,"usage-desc","usage-desc",-202614700),null], null), null),sort_by)))){
var first_3_14561 = cljs.core.take.cljs$core$IFn$_invoke$arity$2((3),result);
var counts_str_14562 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(", ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (aspect_name){
var full_aspect = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(cljs.core.name(ns_key),cljs.core.name(aspect_name));
var cnt = cljs.core.get.cljs$core$IFn$_invoke$arity$3(aspect_stats_map,full_aspect,(0));
return [cljs.core.name(aspect_name),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cnt)].join('');
}),first_3_14561));
console.log("sort-aspect-names",cljs.core.name(ns_key),"sort-by:",cljs.core.name(sort_by),"first-3:",counts_str_14562);
} else {
}

return result;
});
/**
 * Sort the entities map based on sort-by option.
 * 
 * Options:
 * - :alpha-asc - Alphabetical A-Z by type name (default)
 * - :alpha-desc - Alphabetical Z-A by type name
 * - :count-desc - By count (most entities first)
 * - :count-asc - By count (fewest entities first)
 */
atlas_ui_v2.data.sort_entities_map = (function atlas_ui_v2$data$sort_entities_map(entities_map,sort_by){
console.log("sort-entities-map counts:",cljs.core.clj__GT_js(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__14497){
var vec__14498 = p__14497;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14498,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14498,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,cljs.core.count(v)], null);
}),entities_map))));

var G__14501 = sort_by;
var G__14501__$1 = (((G__14501 instanceof cljs.core.Keyword))?G__14501.fqn:null);
switch (G__14501__$1) {
case "alpha-asc":
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map(),entities_map);

break;
case "alpha-desc":
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map_by((function (p1__14496_SHARP_,p2__14495_SHARP_){
return cljs.core.compare(p2__14495_SHARP_,p1__14496_SHARP_);
})),entities_map);

break;
case "count-desc":
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map_by((function (k1,k2){
var c1 = cljs.core.count(cljs.core.get.cljs$core$IFn$_invoke$arity$2(entities_map,k1));
var c2 = cljs.core.count(cljs.core.get.cljs$core$IFn$_invoke$arity$2(entities_map,k2));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(c1,c2)){
return cljs.core.compare(k1,k2);
} else {
return cljs.core.compare(c2,c1);
}
})),entities_map);

break;
case "count-asc":
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map_by((function (k1,k2){
var c1 = cljs.core.count(cljs.core.get.cljs$core$IFn$_invoke$arity$2(entities_map,k1));
var c2 = cljs.core.count(cljs.core.get.cljs$core$IFn$_invoke$arity$2(entities_map,k2));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(c1,c2)){
return cljs.core.compare(k1,k2);
} else {
return cljs.core.compare(c1,c2);
}
})),entities_map);

break;
default:
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map(),entities_map);

}
});
/**
 * Calculate distance from entity to query aspects.
 * Distance = number of aspects in entity NOT in the query.
 * Lower distance = better match (0 = perfect match)
 */
atlas_ui_v2.data.calculate_entity_distance = (function atlas_ui_v2$data$calculate_entity_distance(identity,query_aspects){
var entity_aspects = cljs.core.set(cljs.core.remove.cljs$core$IFn$_invoke$arity$2((function (p1__14502_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("atlas",cljs.core.namespace(p1__14502_SHARP_));
}),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.keyword_QMARK_,identity)));
var query_set = cljs.core.set(query_aspects);
return cljs.core.count(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(entity_aspects,query_set));
});
/**
 * Sort dev-ids within an entity type.
 * 
 * Options:
 * - :alpha-asc - Alphabetical A-Z (default)
 * - :alpha-desc - Alphabetical Z-A
 * - :aspect-count-desc - By number of aspects (most first)
 * - :aspect-count-asc - By number of aspects (fewest first)
 * - :distance-asc - By distance to query (closest match first) - requires query-aspects
 * - :distance-desc - By distance to query (furthest match first) - requires query-aspects
 */
atlas_ui_v2.data.sort_dev_ids = (function atlas_ui_v2$data$sort_dev_ids(var_args){
var G__14506 = arguments.length;
switch (G__14506) {
case 2:
return atlas_ui_v2.data.sort_dev_ids.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return atlas_ui_v2.data.sort_dev_ids.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(atlas_ui_v2.data.sort_dev_ids.cljs$core$IFn$_invoke$arity$2 = (function (dev_id_map,sort_by){
return atlas_ui_v2.data.sort_dev_ids.cljs$core$IFn$_invoke$arity$3(dev_id_map,sort_by,null);
}));

(atlas_ui_v2.data.sort_dev_ids.cljs$core$IFn$_invoke$arity$3 = (function (dev_id_map,sort_by,query_aspects){
var result = (function (){var G__14507 = sort_by;
var G__14507__$1 = (((G__14507 instanceof cljs.core.Keyword))?G__14507.fqn:null);
switch (G__14507__$1) {
case "alpha-asc":
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map(),dev_id_map);

break;
case "alpha-desc":
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map_by((function (p1__14504_SHARP_,p2__14503_SHARP_){
return cljs.core.compare(p2__14503_SHARP_,p1__14504_SHARP_);
})),dev_id_map);

break;
case "aspect-count-desc":
return cljs.core.reverse((function (){var G__14508 = (function (p__14510){
var vec__14511 = p__14510;
var _dev_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14511,(0),null);
var identity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14511,(1),null);
return cljs.core.count(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.keyword_QMARK_,identity));
});
var G__14509 = dev_id_map;
return (sort_by.cljs$core$IFn$_invoke$arity$2 ? sort_by.cljs$core$IFn$_invoke$arity$2(G__14508,G__14509) : sort_by.call(null,G__14508,G__14509));
})());

break;
case "aspect-count-asc":
var G__14514 = (function (p__14516){
var vec__14517 = p__14516;
var _dev_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14517,(0),null);
var identity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14517,(1),null);
return cljs.core.count(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.keyword_QMARK_,identity));
});
var G__14515 = dev_id_map;
return (sort_by.cljs$core$IFn$_invoke$arity$2 ? sort_by.cljs$core$IFn$_invoke$arity$2(G__14514,G__14515) : sort_by.call(null,G__14514,G__14515));

break;
case "distance-asc":
if(cljs.core.seq(query_aspects)){
var entries = cljs.core.vec(dev_id_map);
var map__14520 = cljs.core.group_by((function (p__14521){
var vec__14522 = p__14521;
var _dev_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14522,(0),null);
var identity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14522,(1),null);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),atlas_ui_v2.data.calculate_entity_distance(identity,query_aspects));
}),entries);
var map__14520__$1 = cljs.core.__destructure_map(map__14520);
var perfect_matches = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14520__$1,true);
var others = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14520__$1,false);
var sorted_others = cljs.core.sort.cljs$core$IFn$_invoke$arity$2((function (p__14525,p__14526){
var vec__14527 = p__14525;
var dev_id_1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14527,(0),null);
var identity_1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14527,(1),null);
var vec__14530 = p__14526;
var dev_id_2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14530,(0),null);
var identity_2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14530,(1),null);
var dist1 = atlas_ui_v2.data.calculate_entity_distance(identity_1,query_aspects);
var dist2 = atlas_ui_v2.data.calculate_entity_distance(identity_2,query_aspects);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(dist1,dist2)){
return cljs.core.compare(cljs.core.str.cljs$core$IFn$_invoke$arity$1(dev_id_1),cljs.core.str.cljs$core$IFn$_invoke$arity$1(dev_id_2));
} else {
return cljs.core.compare(dist1,dist2);
}
}),(function (){var or__5002__auto__ = others;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})());
var sorted_perfect = (function (){var G__14533 = (function (p__14535){
var vec__14536 = p__14535;
var dev_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14536,(0),null);
var _identity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14536,(1),null);
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(dev_id);
});
var G__14534 = (function (){var or__5002__auto__ = perfect_matches;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})();
return (sort_by.cljs$core$IFn$_invoke$arity$2 ? sort_by.cljs$core$IFn$_invoke$arity$2(G__14533,G__14534) : sort_by.call(null,G__14533,G__14534));
})();
var result = cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(sorted_others,sorted_perfect));
console.log("  perfect-matches:",cljs.core.count((function (){var or__5002__auto__ = perfect_matches;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})()),"others:",cljs.core.count((function (){var or__5002__auto__ = others;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})()),"first-3 others:",clojure.string.join.cljs$core$IFn$_invoke$arity$2(", ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__14539){
var vec__14540 = p__14539;
var dev_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14540,(0),null);
var identity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14540,(1),null);
return [cljs.core.name(dev_id),":d",cljs.core.str.cljs$core$IFn$_invoke$arity$1(atlas_ui_v2.data.calculate_entity_distance(identity,query_aspects))].join('');
}),cljs.core.take.cljs$core$IFn$_invoke$arity$2((3),sorted_others))));

return result;
} else {
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map(),dev_id_map);
}

break;
case "distance-desc":
if(cljs.core.seq(query_aspects)){
return cljs.core.reverse((function (){var G__14543 = (function (p__14545){
var vec__14546 = p__14545;
var _dev_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14546,(0),null);
var identity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14546,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v2.data.calculate_entity_distance(identity,query_aspects),cljs.core.str.cljs$core$IFn$_invoke$arity$1(_dev_id)], null);
});
var G__14544 = dev_id_map;
return (sort_by.cljs$core$IFn$_invoke$arity$2 ? sort_by.cljs$core$IFn$_invoke$arity$2(G__14543,G__14544) : sort_by.call(null,G__14543,G__14544));
})());
} else {
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map(),dev_id_map);
}

break;
default:
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map(),dev_id_map);

}
})();
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"aspect-count-asc","aspect-count-asc",1495464104),null,new cljs.core.Keyword(null,"distance-desc","distance-desc",2038868622),null,new cljs.core.Keyword(null,"aspect-count-desc","aspect-count-desc",1617664369),null,new cljs.core.Keyword(null,"distance-asc","distance-asc",1798593047),null], null), null),sort_by)){
var first_3_14595 = cljs.core.take.cljs$core$IFn$_invoke$arity$2((3),result);
var info_str_14596 = ((cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"distance-desc","distance-desc",2038868622),null,new cljs.core.Keyword(null,"distance-asc","distance-asc",1798593047),null], null), null),sort_by))?clojure.string.join.cljs$core$IFn$_invoke$arity$2(", ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__14549){
var vec__14550 = p__14549;
var dev_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14550,(0),null);
var identity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14550,(1),null);
var dist = atlas_ui_v2.data.calculate_entity_distance(identity,(function (){var or__5002__auto__ = query_aspects;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})());
return [cljs.core.name(dev_id),":d",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dist)].join('');
}),first_3_14595)):clojure.string.join.cljs$core$IFn$_invoke$arity$2(", ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__14553){
var vec__14554 = p__14553;
var dev_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14554,(0),null);
var identity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14554,(1),null);
var cnt = cljs.core.count(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.keyword_QMARK_,identity));
return [cljs.core.name(dev_id),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cnt)].join('');
}),first_3_14595)));
console.log("sort-dev-ids sort-by:",cljs.core.name(sort_by),"first-3:",info_str_14596,"total:",cljs.core.count(dev_id_map));
} else {
}

return result;
}));

(atlas_ui_v2.data.sort_dev_ids.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=atlas_ui_v2.data.js.map
