goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = true;

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_12860 = (function (this$){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (shadow.dom._to_dom[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5351__auto__.call(null,this$));
} else {
var m__5349__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5349__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_12860(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_12863 = (function (this$){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (shadow.dom._to_svg[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5351__auto__.call(null,this$));
} else {
var m__5349__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5349__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_12863(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__11684 = coll;
var G__11685 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__11684,G__11685) : shadow.dom.lazy_native_coll_seq.call(null,G__11684,G__11685));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__5002__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__11710 = arguments.length;
switch (G__11710) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__11719 = arguments.length;
switch (G__11719) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__11728 = arguments.length;
switch (G__11728) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__11760 = arguments.length;
switch (G__11760) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__11762 = arguments.length;
switch (G__11762) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__11773 = arguments.length;
switch (G__11773) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__5002__auto__ = (!((typeof document !== 'undefined')));
if(or__5002__auto__){
return or__5002__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e11774){if((e11774 instanceof Object)){
var e = e11774;
return console.log("didnt support attachEvent",el,e);
} else {
throw e11774;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__5002__auto__ = (!((typeof document !== 'undefined')));
if(or__5002__auto__){
return or__5002__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__11783 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__11784 = null;
var count__11785 = (0);
var i__11786 = (0);
while(true){
if((i__11786 < count__11785)){
var el = chunk__11784.cljs$core$IIndexed$_nth$arity$2(null,i__11786);
var handler_12892__$1 = ((function (seq__11783,chunk__11784,count__11785,i__11786,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__11783,chunk__11784,count__11785,i__11786,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_12892__$1);


var G__12896 = seq__11783;
var G__12897 = chunk__11784;
var G__12898 = count__11785;
var G__12899 = (i__11786 + (1));
seq__11783 = G__12896;
chunk__11784 = G__12897;
count__11785 = G__12898;
i__11786 = G__12899;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__11783);
if(temp__5804__auto__){
var seq__11783__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11783__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__11783__$1);
var G__12900 = cljs.core.chunk_rest(seq__11783__$1);
var G__12901 = c__5525__auto__;
var G__12902 = cljs.core.count(c__5525__auto__);
var G__12903 = (0);
seq__11783 = G__12900;
chunk__11784 = G__12901;
count__11785 = G__12902;
i__11786 = G__12903;
continue;
} else {
var el = cljs.core.first(seq__11783__$1);
var handler_12904__$1 = ((function (seq__11783,chunk__11784,count__11785,i__11786,el,seq__11783__$1,temp__5804__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__11783,chunk__11784,count__11785,i__11786,el,seq__11783__$1,temp__5804__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_12904__$1);


var G__12905 = cljs.core.next(seq__11783__$1);
var G__12906 = null;
var G__12907 = (0);
var G__12908 = (0);
seq__11783 = G__12905;
chunk__11784 = G__12906;
count__11785 = G__12907;
i__11786 = G__12908;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__11814 = arguments.length;
switch (G__11814) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__11817 = cljs.core.seq(events);
var chunk__11818 = null;
var count__11819 = (0);
var i__11820 = (0);
while(true){
if((i__11820 < count__11819)){
var vec__11831 = chunk__11818.cljs$core$IIndexed$_nth$arity$2(null,i__11820);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11831,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11831,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__12934 = seq__11817;
var G__12935 = chunk__11818;
var G__12936 = count__11819;
var G__12937 = (i__11820 + (1));
seq__11817 = G__12934;
chunk__11818 = G__12935;
count__11819 = G__12936;
i__11820 = G__12937;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__11817);
if(temp__5804__auto__){
var seq__11817__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11817__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__11817__$1);
var G__12943 = cljs.core.chunk_rest(seq__11817__$1);
var G__12944 = c__5525__auto__;
var G__12945 = cljs.core.count(c__5525__auto__);
var G__12946 = (0);
seq__11817 = G__12943;
chunk__11818 = G__12944;
count__11819 = G__12945;
i__11820 = G__12946;
continue;
} else {
var vec__11836 = cljs.core.first(seq__11817__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11836,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11836,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__12951 = cljs.core.next(seq__11817__$1);
var G__12952 = null;
var G__12953 = (0);
var G__12954 = (0);
seq__11817 = G__12951;
chunk__11818 = G__12952;
count__11819 = G__12953;
i__11820 = G__12954;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__11841 = cljs.core.seq(styles);
var chunk__11842 = null;
var count__11843 = (0);
var i__11844 = (0);
while(true){
if((i__11844 < count__11843)){
var vec__11904 = chunk__11842.cljs$core$IIndexed$_nth$arity$2(null,i__11844);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11904,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11904,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__12956 = seq__11841;
var G__12957 = chunk__11842;
var G__12958 = count__11843;
var G__12959 = (i__11844 + (1));
seq__11841 = G__12956;
chunk__11842 = G__12957;
count__11843 = G__12958;
i__11844 = G__12959;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__11841);
if(temp__5804__auto__){
var seq__11841__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11841__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__11841__$1);
var G__12960 = cljs.core.chunk_rest(seq__11841__$1);
var G__12961 = c__5525__auto__;
var G__12962 = cljs.core.count(c__5525__auto__);
var G__12963 = (0);
seq__11841 = G__12960;
chunk__11842 = G__12961;
count__11843 = G__12962;
i__11844 = G__12963;
continue;
} else {
var vec__11910 = cljs.core.first(seq__11841__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11910,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11910,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__12965 = cljs.core.next(seq__11841__$1);
var G__12966 = null;
var G__12967 = (0);
var G__12968 = (0);
seq__11841 = G__12965;
chunk__11842 = G__12966;
count__11843 = G__12967;
i__11844 = G__12968;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__11913_12969 = key;
var G__11913_12970__$1 = (((G__11913_12969 instanceof cljs.core.Keyword))?G__11913_12969.fqn:null);
switch (G__11913_12970__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_12978 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__5002__auto__ = goog.string.startsWith(ks_12978,"data-");
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return goog.string.startsWith(ks_12978,"aria-");
}
})())){
el.setAttribute(ks_12978,value);
} else {
(el[ks_12978] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__11926){
var map__11927 = p__11926;
var map__11927__$1 = cljs.core.__destructure_map(map__11927);
var props = map__11927__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11927__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__11928 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11928,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11928,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11928,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__11931 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__11931,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__11931;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__11933 = arguments.length;
switch (G__11933) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5804__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5804__auto__)){
var n = temp__5804__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5804__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5804__auto__)){
var n = temp__5804__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__11935){
var vec__11938 = p__11935;
var seq__11939 = cljs.core.seq(vec__11938);
var first__11940 = cljs.core.first(seq__11939);
var seq__11939__$1 = cljs.core.next(seq__11939);
var nn = first__11940;
var first__11940__$1 = cljs.core.first(seq__11939__$1);
var seq__11939__$2 = cljs.core.next(seq__11939__$1);
var np = first__11940__$1;
var nc = seq__11939__$2;
var node = vec__11938;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__11941 = nn;
var G__11942 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__11941,G__11942) : create_fn.call(null,G__11941,G__11942));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__11943 = nn;
var G__11944 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__11943,G__11944) : create_fn.call(null,G__11943,G__11944));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__11945 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11945,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11945,(1),null);
var seq__11948_13001 = cljs.core.seq(node_children);
var chunk__11949_13002 = null;
var count__11950_13003 = (0);
var i__11951_13005 = (0);
while(true){
if((i__11951_13005 < count__11950_13003)){
var child_struct_13007 = chunk__11949_13002.cljs$core$IIndexed$_nth$arity$2(null,i__11951_13005);
var children_13009 = shadow.dom.dom_node(child_struct_13007);
if(cljs.core.seq_QMARK_(children_13009)){
var seq__11982_13011 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_13009));
var chunk__11984_13012 = null;
var count__11985_13013 = (0);
var i__11986_13014 = (0);
while(true){
if((i__11986_13014 < count__11985_13013)){
var child_13015 = chunk__11984_13012.cljs$core$IIndexed$_nth$arity$2(null,i__11986_13014);
if(cljs.core.truth_(child_13015)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_13015);


var G__13016 = seq__11982_13011;
var G__13017 = chunk__11984_13012;
var G__13018 = count__11985_13013;
var G__13019 = (i__11986_13014 + (1));
seq__11982_13011 = G__13016;
chunk__11984_13012 = G__13017;
count__11985_13013 = G__13018;
i__11986_13014 = G__13019;
continue;
} else {
var G__13020 = seq__11982_13011;
var G__13021 = chunk__11984_13012;
var G__13022 = count__11985_13013;
var G__13023 = (i__11986_13014 + (1));
seq__11982_13011 = G__13020;
chunk__11984_13012 = G__13021;
count__11985_13013 = G__13022;
i__11986_13014 = G__13023;
continue;
}
} else {
var temp__5804__auto___13025 = cljs.core.seq(seq__11982_13011);
if(temp__5804__auto___13025){
var seq__11982_13026__$1 = temp__5804__auto___13025;
if(cljs.core.chunked_seq_QMARK_(seq__11982_13026__$1)){
var c__5525__auto___13027 = cljs.core.chunk_first(seq__11982_13026__$1);
var G__13029 = cljs.core.chunk_rest(seq__11982_13026__$1);
var G__13030 = c__5525__auto___13027;
var G__13031 = cljs.core.count(c__5525__auto___13027);
var G__13032 = (0);
seq__11982_13011 = G__13029;
chunk__11984_13012 = G__13030;
count__11985_13013 = G__13031;
i__11986_13014 = G__13032;
continue;
} else {
var child_13033 = cljs.core.first(seq__11982_13026__$1);
if(cljs.core.truth_(child_13033)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_13033);


var G__13038 = cljs.core.next(seq__11982_13026__$1);
var G__13039 = null;
var G__13040 = (0);
var G__13041 = (0);
seq__11982_13011 = G__13038;
chunk__11984_13012 = G__13039;
count__11985_13013 = G__13040;
i__11986_13014 = G__13041;
continue;
} else {
var G__13042 = cljs.core.next(seq__11982_13026__$1);
var G__13043 = null;
var G__13044 = (0);
var G__13045 = (0);
seq__11982_13011 = G__13042;
chunk__11984_13012 = G__13043;
count__11985_13013 = G__13044;
i__11986_13014 = G__13045;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_13009);
}


var G__13051 = seq__11948_13001;
var G__13052 = chunk__11949_13002;
var G__13053 = count__11950_13003;
var G__13054 = (i__11951_13005 + (1));
seq__11948_13001 = G__13051;
chunk__11949_13002 = G__13052;
count__11950_13003 = G__13053;
i__11951_13005 = G__13054;
continue;
} else {
var temp__5804__auto___13055 = cljs.core.seq(seq__11948_13001);
if(temp__5804__auto___13055){
var seq__11948_13057__$1 = temp__5804__auto___13055;
if(cljs.core.chunked_seq_QMARK_(seq__11948_13057__$1)){
var c__5525__auto___13058 = cljs.core.chunk_first(seq__11948_13057__$1);
var G__13059 = cljs.core.chunk_rest(seq__11948_13057__$1);
var G__13060 = c__5525__auto___13058;
var G__13061 = cljs.core.count(c__5525__auto___13058);
var G__13062 = (0);
seq__11948_13001 = G__13059;
chunk__11949_13002 = G__13060;
count__11950_13003 = G__13061;
i__11951_13005 = G__13062;
continue;
} else {
var child_struct_13065 = cljs.core.first(seq__11948_13057__$1);
var children_13066 = shadow.dom.dom_node(child_struct_13065);
if(cljs.core.seq_QMARK_(children_13066)){
var seq__11996_13068 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_13066));
var chunk__11998_13069 = null;
var count__11999_13070 = (0);
var i__12000_13071 = (0);
while(true){
if((i__12000_13071 < count__11999_13070)){
var child_13072 = chunk__11998_13069.cljs$core$IIndexed$_nth$arity$2(null,i__12000_13071);
if(cljs.core.truth_(child_13072)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_13072);


var G__13074 = seq__11996_13068;
var G__13075 = chunk__11998_13069;
var G__13076 = count__11999_13070;
var G__13077 = (i__12000_13071 + (1));
seq__11996_13068 = G__13074;
chunk__11998_13069 = G__13075;
count__11999_13070 = G__13076;
i__12000_13071 = G__13077;
continue;
} else {
var G__13078 = seq__11996_13068;
var G__13079 = chunk__11998_13069;
var G__13080 = count__11999_13070;
var G__13081 = (i__12000_13071 + (1));
seq__11996_13068 = G__13078;
chunk__11998_13069 = G__13079;
count__11999_13070 = G__13080;
i__12000_13071 = G__13081;
continue;
}
} else {
var temp__5804__auto___13082__$1 = cljs.core.seq(seq__11996_13068);
if(temp__5804__auto___13082__$1){
var seq__11996_13084__$1 = temp__5804__auto___13082__$1;
if(cljs.core.chunked_seq_QMARK_(seq__11996_13084__$1)){
var c__5525__auto___13085 = cljs.core.chunk_first(seq__11996_13084__$1);
var G__13086 = cljs.core.chunk_rest(seq__11996_13084__$1);
var G__13087 = c__5525__auto___13085;
var G__13088 = cljs.core.count(c__5525__auto___13085);
var G__13089 = (0);
seq__11996_13068 = G__13086;
chunk__11998_13069 = G__13087;
count__11999_13070 = G__13088;
i__12000_13071 = G__13089;
continue;
} else {
var child_13091 = cljs.core.first(seq__11996_13084__$1);
if(cljs.core.truth_(child_13091)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_13091);


var G__13093 = cljs.core.next(seq__11996_13084__$1);
var G__13094 = null;
var G__13095 = (0);
var G__13096 = (0);
seq__11996_13068 = G__13093;
chunk__11998_13069 = G__13094;
count__11999_13070 = G__13095;
i__12000_13071 = G__13096;
continue;
} else {
var G__13098 = cljs.core.next(seq__11996_13084__$1);
var G__13099 = null;
var G__13100 = (0);
var G__13101 = (0);
seq__11996_13068 = G__13098;
chunk__11998_13069 = G__13099;
count__11999_13070 = G__13100;
i__12000_13071 = G__13101;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_13066);
}


var G__13104 = cljs.core.next(seq__11948_13057__$1);
var G__13105 = null;
var G__13106 = (0);
var G__13107 = (0);
seq__11948_13001 = G__13104;
chunk__11949_13002 = G__13105;
count__11950_13003 = G__13106;
i__11951_13005 = G__13107;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__12009 = cljs.core.seq(node);
var chunk__12010 = null;
var count__12011 = (0);
var i__12012 = (0);
while(true){
if((i__12012 < count__12011)){
var n = chunk__12010.cljs$core$IIndexed$_nth$arity$2(null,i__12012);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__13116 = seq__12009;
var G__13117 = chunk__12010;
var G__13118 = count__12011;
var G__13119 = (i__12012 + (1));
seq__12009 = G__13116;
chunk__12010 = G__13117;
count__12011 = G__13118;
i__12012 = G__13119;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__12009);
if(temp__5804__auto__){
var seq__12009__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__12009__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__12009__$1);
var G__13122 = cljs.core.chunk_rest(seq__12009__$1);
var G__13123 = c__5525__auto__;
var G__13124 = cljs.core.count(c__5525__auto__);
var G__13125 = (0);
seq__12009 = G__13122;
chunk__12010 = G__13123;
count__12011 = G__13124;
i__12012 = G__13125;
continue;
} else {
var n = cljs.core.first(seq__12009__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__13126 = cljs.core.next(seq__12009__$1);
var G__13127 = null;
var G__13128 = (0);
var G__13129 = (0);
seq__12009 = G__13126;
chunk__12010 = G__13127;
count__12011 = G__13128;
i__12012 = G__13129;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__12017 = arguments.length;
switch (G__12017) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__12025 = arguments.length;
switch (G__12025) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__12029 = arguments.length;
switch (G__12029) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__5002__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__5732__auto__ = [];
var len__5726__auto___13163 = arguments.length;
var i__5727__auto___13164 = (0);
while(true){
if((i__5727__auto___13164 < len__5726__auto___13163)){
args__5732__auto__.push((arguments[i__5727__auto___13164]));

var G__13166 = (i__5727__auto___13164 + (1));
i__5727__auto___13164 = G__13166;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((0) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__5733__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__12031_13168 = cljs.core.seq(nodes);
var chunk__12032_13169 = null;
var count__12033_13170 = (0);
var i__12034_13171 = (0);
while(true){
if((i__12034_13171 < count__12033_13170)){
var node_13175 = chunk__12032_13169.cljs$core$IIndexed$_nth$arity$2(null,i__12034_13171);
fragment.appendChild(shadow.dom._to_dom(node_13175));


var G__13176 = seq__12031_13168;
var G__13177 = chunk__12032_13169;
var G__13178 = count__12033_13170;
var G__13179 = (i__12034_13171 + (1));
seq__12031_13168 = G__13176;
chunk__12032_13169 = G__13177;
count__12033_13170 = G__13178;
i__12034_13171 = G__13179;
continue;
} else {
var temp__5804__auto___13181 = cljs.core.seq(seq__12031_13168);
if(temp__5804__auto___13181){
var seq__12031_13182__$1 = temp__5804__auto___13181;
if(cljs.core.chunked_seq_QMARK_(seq__12031_13182__$1)){
var c__5525__auto___13183 = cljs.core.chunk_first(seq__12031_13182__$1);
var G__13185 = cljs.core.chunk_rest(seq__12031_13182__$1);
var G__13186 = c__5525__auto___13183;
var G__13187 = cljs.core.count(c__5525__auto___13183);
var G__13188 = (0);
seq__12031_13168 = G__13185;
chunk__12032_13169 = G__13186;
count__12033_13170 = G__13187;
i__12034_13171 = G__13188;
continue;
} else {
var node_13190 = cljs.core.first(seq__12031_13182__$1);
fragment.appendChild(shadow.dom._to_dom(node_13190));


var G__13191 = cljs.core.next(seq__12031_13182__$1);
var G__13192 = null;
var G__13193 = (0);
var G__13194 = (0);
seq__12031_13168 = G__13191;
chunk__12032_13169 = G__13192;
count__12033_13170 = G__13193;
i__12034_13171 = G__13194;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq12030){
var self__5712__auto__ = this;
return self__5712__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq12030));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__12039_13198 = cljs.core.seq(scripts);
var chunk__12040_13199 = null;
var count__12041_13200 = (0);
var i__12042_13201 = (0);
while(true){
if((i__12042_13201 < count__12041_13200)){
var vec__12050_13204 = chunk__12040_13199.cljs$core$IIndexed$_nth$arity$2(null,i__12042_13201);
var script_tag_13205 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12050_13204,(0),null);
var script_body_13206 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12050_13204,(1),null);
eval(script_body_13206);


var G__13210 = seq__12039_13198;
var G__13211 = chunk__12040_13199;
var G__13212 = count__12041_13200;
var G__13213 = (i__12042_13201 + (1));
seq__12039_13198 = G__13210;
chunk__12040_13199 = G__13211;
count__12041_13200 = G__13212;
i__12042_13201 = G__13213;
continue;
} else {
var temp__5804__auto___13214 = cljs.core.seq(seq__12039_13198);
if(temp__5804__auto___13214){
var seq__12039_13215__$1 = temp__5804__auto___13214;
if(cljs.core.chunked_seq_QMARK_(seq__12039_13215__$1)){
var c__5525__auto___13216 = cljs.core.chunk_first(seq__12039_13215__$1);
var G__13217 = cljs.core.chunk_rest(seq__12039_13215__$1);
var G__13218 = c__5525__auto___13216;
var G__13219 = cljs.core.count(c__5525__auto___13216);
var G__13220 = (0);
seq__12039_13198 = G__13217;
chunk__12040_13199 = G__13218;
count__12041_13200 = G__13219;
i__12042_13201 = G__13220;
continue;
} else {
var vec__12054_13221 = cljs.core.first(seq__12039_13215__$1);
var script_tag_13222 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12054_13221,(0),null);
var script_body_13223 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12054_13221,(1),null);
eval(script_body_13223);


var G__13227 = cljs.core.next(seq__12039_13215__$1);
var G__13228 = null;
var G__13229 = (0);
var G__13230 = (0);
seq__12039_13198 = G__13227;
chunk__12040_13199 = G__13228;
count__12041_13200 = G__13229;
i__12042_13201 = G__13230;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__12058){
var vec__12059 = p__12058;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12059,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12059,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__12069 = arguments.length;
switch (G__12069) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__12080 = cljs.core.seq(style_keys);
var chunk__12081 = null;
var count__12082 = (0);
var i__12083 = (0);
while(true){
if((i__12083 < count__12082)){
var it = chunk__12081.cljs$core$IIndexed$_nth$arity$2(null,i__12083);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__13254 = seq__12080;
var G__13255 = chunk__12081;
var G__13256 = count__12082;
var G__13257 = (i__12083 + (1));
seq__12080 = G__13254;
chunk__12081 = G__13255;
count__12082 = G__13256;
i__12083 = G__13257;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__12080);
if(temp__5804__auto__){
var seq__12080__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__12080__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__12080__$1);
var G__13259 = cljs.core.chunk_rest(seq__12080__$1);
var G__13260 = c__5525__auto__;
var G__13261 = cljs.core.count(c__5525__auto__);
var G__13262 = (0);
seq__12080 = G__13259;
chunk__12081 = G__13260;
count__12082 = G__13261;
i__12083 = G__13262;
continue;
} else {
var it = cljs.core.first(seq__12080__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__13265 = cljs.core.next(seq__12080__$1);
var G__13266 = null;
var G__13267 = (0);
var G__13268 = (0);
seq__12080 = G__13265;
chunk__12081 = G__13266;
count__12082 = G__13267;
i__12083 = G__13268;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5300__auto__,k__5301__auto__){
var self__ = this;
var this__5300__auto____$1 = this;
return this__5300__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5301__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5302__auto__,k12086,else__5303__auto__){
var self__ = this;
var this__5302__auto____$1 = this;
var G__12091 = k12086;
var G__12091__$1 = (((G__12091 instanceof cljs.core.Keyword))?G__12091.fqn:null);
switch (G__12091__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12086,else__5303__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5320__auto__,f__5321__auto__,init__5322__auto__){
var self__ = this;
var this__5320__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5323__auto__,p__12094){
var vec__12095 = p__12094;
var k__5324__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12095,(0),null);
var v__5325__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12095,(1),null);
return (f__5321__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5321__auto__.cljs$core$IFn$_invoke$arity$3(ret__5323__auto__,k__5324__auto__,v__5325__auto__) : f__5321__auto__.call(null,ret__5323__auto__,k__5324__auto__,v__5325__auto__));
}),init__5322__auto__,this__5320__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5315__auto__,writer__5316__auto__,opts__5317__auto__){
var self__ = this;
var this__5315__auto____$1 = this;
var pr_pair__5318__auto__ = (function (keyval__5319__auto__){
return cljs.core.pr_sequential_writer(writer__5316__auto__,cljs.core.pr_writer,""," ","",opts__5317__auto__,keyval__5319__auto__);
});
return cljs.core.pr_sequential_writer(writer__5316__auto__,pr_pair__5318__auto__,"#shadow.dom.Coordinate{",", ","}",opts__5317__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12085){
var self__ = this;
var G__12085__$1 = this;
return (new cljs.core.RecordIter((0),G__12085__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5298__auto__){
var self__ = this;
var this__5298__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5295__auto__){
var self__ = this;
var this__5295__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5304__auto__){
var self__ = this;
var this__5304__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5296__auto__){
var self__ = this;
var this__5296__auto____$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = (function (coll__5297__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__5297__auto__));
})(this__5296__auto____$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12087,other12088){
var self__ = this;
var this12087__$1 = this;
return (((!((other12088 == null)))) && ((((this12087__$1.constructor === other12088.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12087__$1.x,other12088.x)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12087__$1.y,other12088.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12087__$1.__extmap,other12088.__extmap)))))))));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5310__auto__,k__5311__auto__){
var self__ = this;
var this__5310__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__5311__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5310__auto____$1),self__.__meta),k__5311__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5311__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5307__auto__,k12086){
var self__ = this;
var this__5307__auto____$1 = this;
var G__12173 = k12086;
var G__12173__$1 = (((G__12173 instanceof cljs.core.Keyword))?G__12173.fqn:null);
switch (G__12173__$1) {
case "x":
case "y":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k12086);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5308__auto__,k__5309__auto__,G__12085){
var self__ = this;
var this__5308__auto____$1 = this;
var pred__12176 = cljs.core.keyword_identical_QMARK_;
var expr__12177 = k__5309__auto__;
if(cljs.core.truth_((pred__12176.cljs$core$IFn$_invoke$arity$2 ? pred__12176.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__12177) : pred__12176.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__12177)))){
return (new shadow.dom.Coordinate(G__12085,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12176.cljs$core$IFn$_invoke$arity$2 ? pred__12176.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__12177) : pred__12176.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__12177)))){
return (new shadow.dom.Coordinate(self__.x,G__12085,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5309__auto__,G__12085),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5313__auto__){
var self__ = this;
var this__5313__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5299__auto__,G__12085){
var self__ = this;
var this__5299__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__12085,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5305__auto__,entry__5306__auto__){
var self__ = this;
var this__5305__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5306__auto__)){
return this__5305__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__5306__auto__,(0)),cljs.core._nth(entry__5306__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5305__auto____$1,entry__5306__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__5346__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__5346__auto__,writer__5347__auto__){
return cljs.core._write(writer__5347__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__12089){
var extmap__5342__auto__ = (function (){var G__12185 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12089,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__12089)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12185);
} else {
return G__12185;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__12089),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__12089),null,cljs.core.not_empty(extmap__5342__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5300__auto__,k__5301__auto__){
var self__ = this;
var this__5300__auto____$1 = this;
return this__5300__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5301__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5302__auto__,k12199,else__5303__auto__){
var self__ = this;
var this__5302__auto____$1 = this;
var G__12229 = k12199;
var G__12229__$1 = (((G__12229 instanceof cljs.core.Keyword))?G__12229.fqn:null);
switch (G__12229__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12199,else__5303__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5320__auto__,f__5321__auto__,init__5322__auto__){
var self__ = this;
var this__5320__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5323__auto__,p__12231){
var vec__12232 = p__12231;
var k__5324__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12232,(0),null);
var v__5325__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12232,(1),null);
return (f__5321__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5321__auto__.cljs$core$IFn$_invoke$arity$3(ret__5323__auto__,k__5324__auto__,v__5325__auto__) : f__5321__auto__.call(null,ret__5323__auto__,k__5324__auto__,v__5325__auto__));
}),init__5322__auto__,this__5320__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5315__auto__,writer__5316__auto__,opts__5317__auto__){
var self__ = this;
var this__5315__auto____$1 = this;
var pr_pair__5318__auto__ = (function (keyval__5319__auto__){
return cljs.core.pr_sequential_writer(writer__5316__auto__,cljs.core.pr_writer,""," ","",opts__5317__auto__,keyval__5319__auto__);
});
return cljs.core.pr_sequential_writer(writer__5316__auto__,pr_pair__5318__auto__,"#shadow.dom.Size{",", ","}",opts__5317__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12198){
var self__ = this;
var G__12198__$1 = this;
return (new cljs.core.RecordIter((0),G__12198__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5298__auto__){
var self__ = this;
var this__5298__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5295__auto__){
var self__ = this;
var this__5295__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5304__auto__){
var self__ = this;
var this__5304__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5296__auto__){
var self__ = this;
var this__5296__auto____$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = (function (coll__5297__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__5297__auto__));
})(this__5296__auto____$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12200,other12201){
var self__ = this;
var this12200__$1 = this;
return (((!((other12201 == null)))) && ((((this12200__$1.constructor === other12201.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12200__$1.w,other12201.w)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12200__$1.h,other12201.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12200__$1.__extmap,other12201.__extmap)))))))));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5310__auto__,k__5311__auto__){
var self__ = this;
var this__5310__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__5311__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5310__auto____$1),self__.__meta),k__5311__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5311__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5307__auto__,k12199){
var self__ = this;
var this__5307__auto____$1 = this;
var G__12291 = k12199;
var G__12291__$1 = (((G__12291 instanceof cljs.core.Keyword))?G__12291.fqn:null);
switch (G__12291__$1) {
case "w":
case "h":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k12199);

}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5308__auto__,k__5309__auto__,G__12198){
var self__ = this;
var this__5308__auto____$1 = this;
var pred__12297 = cljs.core.keyword_identical_QMARK_;
var expr__12298 = k__5309__auto__;
if(cljs.core.truth_((pred__12297.cljs$core$IFn$_invoke$arity$2 ? pred__12297.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__12298) : pred__12297.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__12298)))){
return (new shadow.dom.Size(G__12198,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12297.cljs$core$IFn$_invoke$arity$2 ? pred__12297.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__12298) : pred__12297.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__12298)))){
return (new shadow.dom.Size(self__.w,G__12198,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5309__auto__,G__12198),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5313__auto__){
var self__ = this;
var this__5313__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5299__auto__,G__12198){
var self__ = this;
var this__5299__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__12198,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5305__auto__,entry__5306__auto__){
var self__ = this;
var this__5305__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5306__auto__)){
return this__5305__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__5306__auto__,(0)),cljs.core._nth(entry__5306__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5305__auto____$1,entry__5306__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__5346__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__5346__auto__,writer__5347__auto__){
return cljs.core._write(writer__5347__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__12226){
var extmap__5342__auto__ = (function (){var G__12393 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12226,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__12226)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12393);
} else {
return G__12393;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__12226),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__12226),null,cljs.core.not_empty(extmap__5342__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__5590__auto__ = opts;
var l__5591__auto__ = a__5590__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__5591__auto__)){
var G__13372 = (i + (1));
var G__13373 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__13372;
ret = G__13373;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__12504){
var vec__12506 = p__12504;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12506,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12506,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__12513 = arguments.length;
switch (G__12513) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5802__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5802__auto__)){
var child = temp__5802__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__13403 = ps;
var G__13404 = (i + (1));
el__$1 = G__13403;
i = G__13404;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__12536 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12536,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12536,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12536,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__12539_13428 = cljs.core.seq(props);
var chunk__12540_13429 = null;
var count__12541_13430 = (0);
var i__12542_13431 = (0);
while(true){
if((i__12542_13431 < count__12541_13430)){
var vec__12581_13433 = chunk__12540_13429.cljs$core$IIndexed$_nth$arity$2(null,i__12542_13431);
var k_13434 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12581_13433,(0),null);
var v_13435 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12581_13433,(1),null);
el.setAttributeNS((function (){var temp__5804__auto__ = cljs.core.namespace(k_13434);
if(cljs.core.truth_(temp__5804__auto__)){
var ns = temp__5804__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_13434),v_13435);


var G__13437 = seq__12539_13428;
var G__13438 = chunk__12540_13429;
var G__13439 = count__12541_13430;
var G__13440 = (i__12542_13431 + (1));
seq__12539_13428 = G__13437;
chunk__12540_13429 = G__13438;
count__12541_13430 = G__13439;
i__12542_13431 = G__13440;
continue;
} else {
var temp__5804__auto___13441 = cljs.core.seq(seq__12539_13428);
if(temp__5804__auto___13441){
var seq__12539_13442__$1 = temp__5804__auto___13441;
if(cljs.core.chunked_seq_QMARK_(seq__12539_13442__$1)){
var c__5525__auto___13443 = cljs.core.chunk_first(seq__12539_13442__$1);
var G__13445 = cljs.core.chunk_rest(seq__12539_13442__$1);
var G__13446 = c__5525__auto___13443;
var G__13447 = cljs.core.count(c__5525__auto___13443);
var G__13448 = (0);
seq__12539_13428 = G__13445;
chunk__12540_13429 = G__13446;
count__12541_13430 = G__13447;
i__12542_13431 = G__13448;
continue;
} else {
var vec__12630_13452 = cljs.core.first(seq__12539_13442__$1);
var k_13453 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12630_13452,(0),null);
var v_13454 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12630_13452,(1),null);
el.setAttributeNS((function (){var temp__5804__auto____$1 = cljs.core.namespace(k_13453);
if(cljs.core.truth_(temp__5804__auto____$1)){
var ns = temp__5804__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_13453),v_13454);


var G__13464 = cljs.core.next(seq__12539_13442__$1);
var G__13465 = null;
var G__13466 = (0);
var G__13467 = (0);
seq__12539_13428 = G__13464;
chunk__12540_13429 = G__13465;
count__12541_13430 = G__13466;
i__12542_13431 = G__13467;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__12655 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12655,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12655,(1),null);
var seq__12660_13474 = cljs.core.seq(node_children);
var chunk__12662_13475 = null;
var count__12663_13476 = (0);
var i__12664_13477 = (0);
while(true){
if((i__12664_13477 < count__12663_13476)){
var child_struct_13478 = chunk__12662_13475.cljs$core$IIndexed$_nth$arity$2(null,i__12664_13477);
if((!((child_struct_13478 == null)))){
if(typeof child_struct_13478 === 'string'){
var text_13479 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_13479),child_struct_13478].join(''));
} else {
var children_13485 = shadow.dom.svg_node(child_struct_13478);
if(cljs.core.seq_QMARK_(children_13485)){
var seq__12733_13489 = cljs.core.seq(children_13485);
var chunk__12735_13490 = null;
var count__12737_13491 = (0);
var i__12738_13492 = (0);
while(true){
if((i__12738_13492 < count__12737_13491)){
var child_13494 = chunk__12735_13490.cljs$core$IIndexed$_nth$arity$2(null,i__12738_13492);
if(cljs.core.truth_(child_13494)){
node.appendChild(child_13494);


var G__13496 = seq__12733_13489;
var G__13497 = chunk__12735_13490;
var G__13498 = count__12737_13491;
var G__13499 = (i__12738_13492 + (1));
seq__12733_13489 = G__13496;
chunk__12735_13490 = G__13497;
count__12737_13491 = G__13498;
i__12738_13492 = G__13499;
continue;
} else {
var G__13500 = seq__12733_13489;
var G__13501 = chunk__12735_13490;
var G__13502 = count__12737_13491;
var G__13503 = (i__12738_13492 + (1));
seq__12733_13489 = G__13500;
chunk__12735_13490 = G__13501;
count__12737_13491 = G__13502;
i__12738_13492 = G__13503;
continue;
}
} else {
var temp__5804__auto___13513 = cljs.core.seq(seq__12733_13489);
if(temp__5804__auto___13513){
var seq__12733_13514__$1 = temp__5804__auto___13513;
if(cljs.core.chunked_seq_QMARK_(seq__12733_13514__$1)){
var c__5525__auto___13515 = cljs.core.chunk_first(seq__12733_13514__$1);
var G__13517 = cljs.core.chunk_rest(seq__12733_13514__$1);
var G__13518 = c__5525__auto___13515;
var G__13519 = cljs.core.count(c__5525__auto___13515);
var G__13520 = (0);
seq__12733_13489 = G__13517;
chunk__12735_13490 = G__13518;
count__12737_13491 = G__13519;
i__12738_13492 = G__13520;
continue;
} else {
var child_13522 = cljs.core.first(seq__12733_13514__$1);
if(cljs.core.truth_(child_13522)){
node.appendChild(child_13522);


var G__13523 = cljs.core.next(seq__12733_13514__$1);
var G__13524 = null;
var G__13525 = (0);
var G__13526 = (0);
seq__12733_13489 = G__13523;
chunk__12735_13490 = G__13524;
count__12737_13491 = G__13525;
i__12738_13492 = G__13526;
continue;
} else {
var G__13528 = cljs.core.next(seq__12733_13514__$1);
var G__13529 = null;
var G__13530 = (0);
var G__13531 = (0);
seq__12733_13489 = G__13528;
chunk__12735_13490 = G__13529;
count__12737_13491 = G__13530;
i__12738_13492 = G__13531;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_13485);
}
}


var G__13533 = seq__12660_13474;
var G__13534 = chunk__12662_13475;
var G__13535 = count__12663_13476;
var G__13536 = (i__12664_13477 + (1));
seq__12660_13474 = G__13533;
chunk__12662_13475 = G__13534;
count__12663_13476 = G__13535;
i__12664_13477 = G__13536;
continue;
} else {
var G__13539 = seq__12660_13474;
var G__13540 = chunk__12662_13475;
var G__13541 = count__12663_13476;
var G__13542 = (i__12664_13477 + (1));
seq__12660_13474 = G__13539;
chunk__12662_13475 = G__13540;
count__12663_13476 = G__13541;
i__12664_13477 = G__13542;
continue;
}
} else {
var temp__5804__auto___13544 = cljs.core.seq(seq__12660_13474);
if(temp__5804__auto___13544){
var seq__12660_13546__$1 = temp__5804__auto___13544;
if(cljs.core.chunked_seq_QMARK_(seq__12660_13546__$1)){
var c__5525__auto___13547 = cljs.core.chunk_first(seq__12660_13546__$1);
var G__13548 = cljs.core.chunk_rest(seq__12660_13546__$1);
var G__13549 = c__5525__auto___13547;
var G__13550 = cljs.core.count(c__5525__auto___13547);
var G__13551 = (0);
seq__12660_13474 = G__13548;
chunk__12662_13475 = G__13549;
count__12663_13476 = G__13550;
i__12664_13477 = G__13551;
continue;
} else {
var child_struct_13554 = cljs.core.first(seq__12660_13546__$1);
if((!((child_struct_13554 == null)))){
if(typeof child_struct_13554 === 'string'){
var text_13556 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_13556),child_struct_13554].join(''));
} else {
var children_13558 = shadow.dom.svg_node(child_struct_13554);
if(cljs.core.seq_QMARK_(children_13558)){
var seq__12786_13559 = cljs.core.seq(children_13558);
var chunk__12788_13560 = null;
var count__12789_13561 = (0);
var i__12790_13562 = (0);
while(true){
if((i__12790_13562 < count__12789_13561)){
var child_13563 = chunk__12788_13560.cljs$core$IIndexed$_nth$arity$2(null,i__12790_13562);
if(cljs.core.truth_(child_13563)){
node.appendChild(child_13563);


var G__13566 = seq__12786_13559;
var G__13567 = chunk__12788_13560;
var G__13568 = count__12789_13561;
var G__13569 = (i__12790_13562 + (1));
seq__12786_13559 = G__13566;
chunk__12788_13560 = G__13567;
count__12789_13561 = G__13568;
i__12790_13562 = G__13569;
continue;
} else {
var G__13572 = seq__12786_13559;
var G__13573 = chunk__12788_13560;
var G__13574 = count__12789_13561;
var G__13575 = (i__12790_13562 + (1));
seq__12786_13559 = G__13572;
chunk__12788_13560 = G__13573;
count__12789_13561 = G__13574;
i__12790_13562 = G__13575;
continue;
}
} else {
var temp__5804__auto___13579__$1 = cljs.core.seq(seq__12786_13559);
if(temp__5804__auto___13579__$1){
var seq__12786_13580__$1 = temp__5804__auto___13579__$1;
if(cljs.core.chunked_seq_QMARK_(seq__12786_13580__$1)){
var c__5525__auto___13582 = cljs.core.chunk_first(seq__12786_13580__$1);
var G__13583 = cljs.core.chunk_rest(seq__12786_13580__$1);
var G__13584 = c__5525__auto___13582;
var G__13585 = cljs.core.count(c__5525__auto___13582);
var G__13586 = (0);
seq__12786_13559 = G__13583;
chunk__12788_13560 = G__13584;
count__12789_13561 = G__13585;
i__12790_13562 = G__13586;
continue;
} else {
var child_13588 = cljs.core.first(seq__12786_13580__$1);
if(cljs.core.truth_(child_13588)){
node.appendChild(child_13588);


var G__13590 = cljs.core.next(seq__12786_13580__$1);
var G__13591 = null;
var G__13592 = (0);
var G__13593 = (0);
seq__12786_13559 = G__13590;
chunk__12788_13560 = G__13591;
count__12789_13561 = G__13592;
i__12790_13562 = G__13593;
continue;
} else {
var G__13594 = cljs.core.next(seq__12786_13580__$1);
var G__13595 = null;
var G__13596 = (0);
var G__13597 = (0);
seq__12786_13559 = G__13594;
chunk__12788_13560 = G__13595;
count__12789_13561 = G__13596;
i__12790_13562 = G__13597;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_13558);
}
}


var G__13598 = cljs.core.next(seq__12660_13546__$1);
var G__13599 = null;
var G__13600 = (0);
var G__13601 = (0);
seq__12660_13474 = G__13598;
chunk__12662_13475 = G__13599;
count__12663_13476 = G__13600;
i__12664_13477 = G__13601;
continue;
} else {
var G__13602 = cljs.core.next(seq__12660_13546__$1);
var G__13603 = null;
var G__13604 = (0);
var G__13605 = (0);
seq__12660_13474 = G__13602;
chunk__12662_13475 = G__13603;
count__12663_13476 = G__13604;
i__12664_13477 = G__13605;
continue;
}
}
} else {
}
}
break;
}

return node;
});
(shadow.dom.SVGElement["string"] = true);

(shadow.dom._to_svg["string"] = (function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

(shadow.dom.SVGElement["null"] = true);

(shadow.dom._to_svg["null"] = (function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__5732__auto__ = [];
var len__5726__auto___13668 = arguments.length;
var i__5727__auto___13669 = (0);
while(true){
if((i__5727__auto___13669 < len__5726__auto___13668)){
args__5732__auto__.push((arguments[i__5727__auto___13669]));

var G__13673 = (i__5727__auto___13669 + (1));
i__5727__auto___13669 = G__13673;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((1) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5733__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq12812){
var G__12813 = cljs.core.first(seq12812);
var seq12812__$1 = cljs.core.next(seq12812);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12813,seq12812__$1);
}));


//# sourceMappingURL=shadow.dom.js.map
