goog.provide('atlas_ui_v2.core');
if((typeof atlas_ui_v2 !== 'undefined') && (typeof atlas_ui_v2.core !== 'undefined') && (typeof atlas_ui_v2.core.app_state !== 'undefined')){
} else {
atlas_ui_v2.core.app_state = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"aspects-or","aspects-or",-313383808),new cljs.core.Keyword(null,"selected-types","selected-types",-1725213152),new cljs.core.Keyword(null,"filter-mode","filter-mode",-84440349),new cljs.core.Keyword(null,"sort-aspects-ns","sort-aspects-ns",387886950),new cljs.core.Keyword(null,"aspect-stats","aspect-stats",-2041038456),new cljs.core.Keyword(null,"loading?","loading?",1905707049),new cljs.core.Keyword(null,"sort-entities-items","sort-entities-items",-1576558518),new cljs.core.Keyword(null,"registry","registry",1021159018),new cljs.core.Keyword(null,"sort-aspects-items","sort-aspects-items",-80674613),new cljs.core.Keyword(null,"aspects-and","aspects-and",-655179438),new cljs.core.Keyword(null,"sort-entities-type","sort-entities-type",-663787821),new cljs.core.Keyword(null,"selected-entities","selected-entities",-961620715),new cljs.core.Keyword(null,"selected-entities-not","selected-entities-not",923796309),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"aspects-not","aspects-not",1911860575)],[cljs.core.PersistentHashSet.EMPTY,cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword(null,"hide","hide",-596913169),new cljs.core.Keyword(null,"alpha-asc","alpha-asc",859183168),null,true,new cljs.core.Keyword(null,"alpha-asc","alpha-asc",859183168),null,new cljs.core.Keyword(null,"alpha-asc","alpha-asc",859183168),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword(null,"alpha-asc","alpha-asc",859183168),cljs.core.PersistentHashSet.EMPTY,cljs.core.PersistentHashSet.EMPTY,null,cljs.core.PersistentHashSet.EMPTY]));
}
/**
 * Build and sort aspects map: namespace -> #{aspect-names}
 */
atlas_ui_v2.core.aspects_map_data = (function atlas_ui_v2$core$aspects_map_data(registry,aspect_stats,sort_ns,sort_items,aspects_and,aspects_or,aspects_not){
if(cljs.core.truth_((function (){var and__5000__auto__ = registry;
if(cljs.core.truth_(and__5000__auto__)){
return aspect_stats;
} else {
return and__5000__auto__;
}
})())){
var aspect_stats_map = atlas_ui_v2.data.aspect_stats__GT_map(aspect_stats);
var _ = console.log("aspect-stats-map size:",cljs.core.count(aspect_stats_map),"first 3:",cljs.core.clj__GT_js(cljs.core.take.cljs$core$IFn$_invoke$arity$2((3),aspect_stats_map)));
var aspects_map = atlas_ui_v2.data.build_aspects_map(registry);
var sorted_map = atlas_ui_v2.data.sort_aspects_map(aspects_map,aspect_stats_map,sort_ns);
var aspects_vec = cljs.core.vec(sorted_map);
var first_3_keys = cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2((3),cljs.core.keys(sorted_map)));
var entity_counts = atlas_ui_v2.data.count_entities_by_aspect_filtered(registry,aspects_and,aspects_or,aspects_not);
console.log("aspects-map-data - sort-ns:",cljs.core.name(sort_ns),"sort-items:",cljs.core.name(sort_items),"namespaces:",cljs.core.count(sorted_map),"first 3:",cljs.core.clj__GT_js(first_3_keys));

return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"aspects-map","aspects-map",-1181198737),aspects_vec,new cljs.core.Keyword(null,"aspect-stats-map","aspect-stats-map",-1178596793),aspect_stats_map,new cljs.core.Keyword(null,"entity-counts","entity-counts",-1040448509),entity_counts,new cljs.core.Keyword(null,"sort-items","sort-items",814834777),sort_items], null);
} else {
return null;
}
});
/**
 * Build and sort entities map: type -> {dev-id -> identity}
 */
atlas_ui_v2.core.entities_map_data = (function atlas_ui_v2$core$entities_map_data(registry,sort_type,sort_items,query_aspects){
if(cljs.core.truth_(registry)){
var entities_map = atlas_ui_v2.data.build_entities_map(registry);
var sorted_map = atlas_ui_v2.data.sort_entities_map(entities_map,sort_type);
var entities_vec = cljs.core.vec(sorted_map);
var all_keys = cljs.core.vec(cljs.core.keys(sorted_map));
console.log("entities-map-data - sort-type:",cljs.core.name(sort_type),"sort-items:",cljs.core.name(sort_items),"types:",cljs.core.count(sorted_map),"order:",cljs.core.clj__GT_js(all_keys));

return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"entities-map","entities-map",-1465680347),entities_vec,new cljs.core.Keyword(null,"sort-items","sort-items",814834777),sort_items,new cljs.core.Keyword(null,"query-aspects","query-aspects",1772440524),query_aspects], null);
} else {
return null;
}
});
/**
 * Cycle aspect through: not selected → AND (blue) → OR (green) → NOT (red) → not selected
 */
atlas_ui_v2.core.cycle_aspect_BANG_ = (function atlas_ui_v2$core$cycle_aspect_BANG_(aspect){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(atlas_ui_v2.core.app_state,(function (state){
var in_and_QMARK_ = cljs.core.contains_QMARK_(new cljs.core.Keyword(null,"aspects-and","aspects-and",-655179438).cljs$core$IFn$_invoke$arity$1(state),aspect);
var in_or_QMARK_ = cljs.core.contains_QMARK_(new cljs.core.Keyword(null,"aspects-or","aspects-or",-313383808).cljs$core$IFn$_invoke$arity$1(state),aspect);
var in_not_QMARK_ = cljs.core.contains_QMARK_(new cljs.core.Keyword(null,"aspects-not","aspects-not",1911860575).cljs$core$IFn$_invoke$arity$1(state),aspect);
var new_state = (((((!(in_and_QMARK_))) && ((((!(in_or_QMARK_))) && ((!(in_not_QMARK_)))))))?cljs.core.update.cljs$core$IFn$_invoke$arity$4(state,new cljs.core.Keyword(null,"aspects-and","aspects-and",-655179438),cljs.core.conj,aspect):((in_and_QMARK_)?cljs.core.update.cljs$core$IFn$_invoke$arity$4(cljs.core.update.cljs$core$IFn$_invoke$arity$4(state,new cljs.core.Keyword(null,"aspects-and","aspects-and",-655179438),cljs.core.disj,aspect),new cljs.core.Keyword(null,"aspects-or","aspects-or",-313383808),cljs.core.conj,aspect):((in_or_QMARK_)?cljs.core.update.cljs$core$IFn$_invoke$arity$4(cljs.core.update.cljs$core$IFn$_invoke$arity$4(state,new cljs.core.Keyword(null,"aspects-or","aspects-or",-313383808),cljs.core.disj,aspect),new cljs.core.Keyword(null,"aspects-not","aspects-not",1911860575),cljs.core.conj,aspect):((in_not_QMARK_)?cljs.core.update.cljs$core$IFn$_invoke$arity$4(state,new cljs.core.Keyword(null,"aspects-not","aspects-not",1911860575),cljs.core.disj,aspect):null))));
var has_aspects_QMARK_ = ((cljs.core.seq(new cljs.core.Keyword(null,"aspects-and","aspects-and",-655179438).cljs$core$IFn$_invoke$arity$1(new_state))) || (((cljs.core.seq(new cljs.core.Keyword(null,"aspects-or","aspects-or",-313383808).cljs$core$IFn$_invoke$arity$1(new_state))) || (cljs.core.seq(new cljs.core.Keyword(null,"aspects-not","aspects-not",1911860575).cljs$core$IFn$_invoke$arity$1(new_state))))));
var new_sort = ((has_aspects_QMARK_)?new cljs.core.Keyword(null,"distance-asc","distance-asc",1798593047):new cljs.core.Keyword(null,"alpha-asc","alpha-asc",859183168));
console.log("cycle-aspect! auto-sort:",cljs.core.name(new_sort),"has-aspects:",has_aspects_QMARK_);

return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_state,new cljs.core.Keyword(null,"sort-entities-items","sort-entities-items",-1576558518),new_sort);
}));
});
/**
 * Toggle selection of an entity type
 */
atlas_ui_v2.core.toggle_type_BANG_ = (function atlas_ui_v2$core$toggle_type_BANG_(entity_type){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(atlas_ui_v2.core.app_state,cljs.core.update,new cljs.core.Keyword(null,"selected-types","selected-types",-1725213152),(function (selected){
if(cljs.core.contains_QMARK_(selected,entity_type)){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(selected,entity_type);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(selected,entity_type);
}
}));
});
/**
 * Cycle entity through: not selected → selected (blue) → NOT (red) → not selected
 */
atlas_ui_v2.core.toggle_entity_BANG_ = (function atlas_ui_v2$core$toggle_entity_BANG_(dev_id){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(atlas_ui_v2.core.app_state,(function (state){
var selected_QMARK_ = cljs.core.contains_QMARK_(new cljs.core.Keyword(null,"selected-entities","selected-entities",-961620715).cljs$core$IFn$_invoke$arity$1(state),dev_id);
var not_selected_QMARK_ = cljs.core.contains_QMARK_(new cljs.core.Keyword(null,"selected-entities-not","selected-entities-not",923796309).cljs$core$IFn$_invoke$arity$1(state),dev_id);
if((((!(selected_QMARK_))) && ((!(not_selected_QMARK_))))){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(state,new cljs.core.Keyword(null,"selected-entities","selected-entities",-961620715),cljs.core.conj,dev_id);
} else {
if(selected_QMARK_){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(cljs.core.update.cljs$core$IFn$_invoke$arity$4(state,new cljs.core.Keyword(null,"selected-entities","selected-entities",-961620715),cljs.core.disj,dev_id),new cljs.core.Keyword(null,"selected-entities-not","selected-entities-not",923796309),cljs.core.conj,dev_id);
} else {
if(not_selected_QMARK_){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(state,new cljs.core.Keyword(null,"selected-entities-not","selected-entities-not",923796309),cljs.core.disj,dev_id);
} else {
return null;
}
}
}
}));
});
/**
 * Clear all selections
 */
atlas_ui_v2.core.clear_selection_BANG_ = (function atlas_ui_v2$core$clear_selection_BANG_(){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(atlas_ui_v2.core.app_state,cljs.core.assoc,new cljs.core.Keyword(null,"aspects-and","aspects-and",-655179438),cljs.core.PersistentHashSet.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"aspects-or","aspects-or",-313383808),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword(null,"aspects-not","aspects-not",1911860575),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword(null,"selected-types","selected-types",-1725213152),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword(null,"selected-entities","selected-entities",-961620715),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword(null,"selected-entities-not","selected-entities-not",923796309),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword(null,"sort-entities-items","sort-entities-items",-1576558518),new cljs.core.Keyword(null,"alpha-asc","alpha-asc",859183168)], 0));
});
/**
 * Toggle between highlight and hide modes
 */
atlas_ui_v2.core.toggle_filter_mode_BANG_ = (function atlas_ui_v2$core$toggle_filter_mode_BANG_(){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(atlas_ui_v2.core.app_state,cljs.core.update,new cljs.core.Keyword(null,"filter-mode","filter-mode",-84440349),(function (mode){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"highlight","highlight",-800930873))){
return new cljs.core.Keyword(null,"hide","hide",-596913169);
} else {
return new cljs.core.Keyword(null,"highlight","highlight",-800930873);
}
}));
});
/**
 * Set sort option for a specific level
 */
atlas_ui_v2.core.set_sort_BANG_ = (function atlas_ui_v2$core$set_sort_BANG_(key,value){
console.log("Setting sort:",cljs.core.name(key),"->",cljs.core.name(value));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(atlas_ui_v2.core.app_state,cljs.core.assoc,key,value);
});
/**
 * Find all dev-ids matching the AND/OR/NOT aspect criteria.
 * - Entity matches if it has ALL aspects from aspects-and
 * - OR entity matches if it has ANY aspect from aspects-or
 * - Entity is excluded if it has ANY aspect from aspects-not
 * - If only NOT is specified, show all entities except those with NOT aspects
 */
atlas_ui_v2.core.entities_matching_aspects = (function atlas_ui_v2$core$entities_matching_aspects(registry,aspects_and,aspects_or,aspects_not){
if(((cljs.core.seq(aspects_and)) || (((cljs.core.seq(aspects_or)) || (cljs.core.seq(aspects_not)))))){
return cljs.core.set(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.some_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__13764){
var vec__13765 = p__13764;
var _identity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13765,(0),null);
var props = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13765,(1),null);
return new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553).cljs$core$IFn$_invoke$arity$1(props);
}),cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p__13768){
var vec__13769 = p__13768;
var identity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13769,(0),null);
var _props = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13769,(1),null);
var matches_and_QMARK_ = ((cljs.core.seq(aspects_and)) && (cljs.core.every_QMARK_((function (p1__13761_SHARP_){
return cljs.core.contains_QMARK_(identity,p1__13761_SHARP_);
}),aspects_and)));
var matches_or_QMARK_ = (function (){var and__5000__auto__ = cljs.core.seq(aspects_or);
if(and__5000__auto__){
return cljs.core.some((function (p1__13762_SHARP_){
return cljs.core.contains_QMARK_(identity,p1__13762_SHARP_);
}),aspects_or);
} else {
return and__5000__auto__;
}
})();
var matches_not_QMARK_ = (function (){var and__5000__auto__ = cljs.core.seq(aspects_not);
if(and__5000__auto__){
return cljs.core.some((function (p1__13763_SHARP_){
return cljs.core.contains_QMARK_(identity,p1__13763_SHARP_);
}),aspects_not);
} else {
return and__5000__auto__;
}
})();
var has_positive_criteria_QMARK_ = ((cljs.core.seq(aspects_and)) || (cljs.core.seq(aspects_or)));
var base_match_QMARK_ = ((has_positive_criteria_QMARK_)?(function (){var or__5002__auto__ = matches_and_QMARK_;
if(or__5002__auto__){
return or__5002__auto__;
} else {
return matches_or_QMARK_;
}
})():true);
var and__5000__auto__ = base_match_QMARK_;
if(cljs.core.truth_(and__5000__auto__)){
return cljs.core.not(matches_not_QMARK_);
} else {
return and__5000__auto__;
}
}),registry))));
} else {
return null;
}
});
/**
 * Get all aspects for a dev-id
 */
atlas_ui_v2.core.aspects_for_entity = (function atlas_ui_v2$core$aspects_for_entity(registry,dev_id){
return cljs.core.first(cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p__13772){
var vec__13773 = p__13772;
var _identity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13773,(0),null);
var props = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13773,(1),null);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(dev_id,new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553).cljs$core$IFn$_invoke$arity$1(props));
}),registry)));
});
/**
 * Get union of all aspects for multiple dev-ids, excluding aspects from not-dev-ids.
 * - If only positive dev-ids: return their aspects
 * - If only negative dev-ids: return all aspects EXCEPT theirs
 * - If both: return positive aspects minus negative aspects
 */
atlas_ui_v2.core.aspects_for_entities = (function atlas_ui_v2$core$aspects_for_entities(registry,dev_ids,not_dev_ids){
var has_positive_QMARK_ = cljs.core.seq(dev_ids);
var has_negative_QMARK_ = cljs.core.seq(not_dev_ids);
if(((has_positive_QMARK_) || (has_negative_QMARK_))){
var negative_aspects = ((has_negative_QMARK_)?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(clojure.set.union,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.some_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__13776_SHARP_){
return atlas_ui_v2.core.aspects_for_entity(registry,p1__13776_SHARP_);
}),not_dev_ids))):null);
if(has_positive_QMARK_){
var positive_aspects = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(clojure.set.union,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.some_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__13777_SHARP_){
return atlas_ui_v2.core.aspects_for_entity(registry,p1__13777_SHARP_);
}),dev_ids)));
if(cljs.core.truth_(negative_aspects)){
return clojure.set.difference.cljs$core$IFn$_invoke$arity$2(positive_aspects,negative_aspects);
} else {
return positive_aspects;
}
} else {
var all_aspects = cljs.core.set(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.keyword_QMARK_,cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.identity,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.keys(registry)], 0))));
return clojure.set.difference.cljs$core$IFn$_invoke$arity$2(all_aspects,negative_aspects);
}
} else {
return null;
}
});
/**
 * Get all aspects used by entities of a type
 */
atlas_ui_v2.core.aspects_for_type = (function atlas_ui_v2$core$aspects_for_type(registry,entity_type){
return cljs.core.set(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((function (p__13778){
var vec__13779 = p__13778;
var identity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13779,(0),null);
var _props = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13779,(1),null);
return identity;
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p__13782){
var vec__13783 = p__13782;
var identity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13783,(0),null);
var _props = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13783,(1),null);
return cljs.core.contains_QMARK_(identity,entity_type);
}),registry)], 0)));
});
/**
 * Get union of all aspects for multiple types
 */
atlas_ui_v2.core.aspects_for_types = (function atlas_ui_v2$core$aspects_for_types(registry,entity_types){
if(cljs.core.seq(entity_types)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(clojure.set.union,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__13786_SHARP_){
return atlas_ui_v2.core.aspects_for_type(registry,p1__13786_SHARP_);
}),entity_types));
} else {
return null;
}
});
atlas_ui_v2.core.header = (function atlas_ui_v2$core$header(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"padding","padding",1660304693),"1rem",new cljs.core.Keyword(null,"background","background",-863952629),"#1a1a2e",new cljs.core.Keyword(null,"color","color",1011675173),"#eee",new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"justify-content","justify-content",-1990475787),"space-between",new cljs.core.Keyword(null,"align-items","align-items",-267946462),"center"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h1","h1",-1896887462),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"margin","margin",-995903681),(0),new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"1.5rem"], null)], null),"Atlas Explorer v2"], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"gap","gap",80255254),"1rem",new cljs.core.Keyword(null,"align-items","align-items",-267946462),"center"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),atlas_ui_v2.core.clear_selection_BANG_,new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"padding","padding",1660304693),"0.5rem 1rem",new cljs.core.Keyword(null,"background","background",-863952629),"#4a4a6a",new cljs.core.Keyword(null,"color","color",1011675173),"#eee",new cljs.core.Keyword(null,"border","border",1444987323),"none",new cljs.core.Keyword(null,"border-radius","border-radius",419594011),"4px",new cljs.core.Keyword(null,"cursor","cursor",1011937484),"pointer"], null)], null),"Clear Selection"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),atlas_ui_v2.core.toggle_filter_mode_BANG_,new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"padding","padding",1660304693),"0.5rem 1rem",new cljs.core.Keyword(null,"background","background",-863952629),((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"filter-mode","filter-mode",-84440349).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui_v2.core.app_state)),new cljs.core.Keyword(null,"highlight","highlight",-800930873)))?"#6a6a8a":"#8a4a4a"),new cljs.core.Keyword(null,"color","color",1011675173),"#eee",new cljs.core.Keyword(null,"border","border",1444987323),"none",new cljs.core.Keyword(null,"border-radius","border-radius",419594011),"4px",new cljs.core.Keyword(null,"cursor","cursor",1011937484),"pointer"], null)], null),((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"filter-mode","filter-mode",-84440349).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui_v2.core.app_state)),new cljs.core.Keyword(null,"highlight","highlight",-800930873)))?"Mode: Highlight":"Mode: Hide")], null)], null)], null);
});
atlas_ui_v2.core.selection_info = (function atlas_ui_v2$core$selection_info(){
var map__13787 = cljs.core.deref(atlas_ui_v2.core.app_state);
var map__13787__$1 = cljs.core.__destructure_map(map__13787);
var aspects_and = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13787__$1,new cljs.core.Keyword(null,"aspects-and","aspects-and",-655179438));
var aspects_or = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13787__$1,new cljs.core.Keyword(null,"aspects-or","aspects-or",-313383808));
var aspects_not = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13787__$1,new cljs.core.Keyword(null,"aspects-not","aspects-not",1911860575));
var selected_types = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13787__$1,new cljs.core.Keyword(null,"selected-types","selected-types",-1725213152));
var selected_entities = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13787__$1,new cljs.core.Keyword(null,"selected-entities","selected-entities",-961620715));
var selected_entities_not = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13787__$1,new cljs.core.Keyword(null,"selected-entities-not","selected-entities-not",923796309));
if(((cljs.core.seq(aspects_and)) || (((cljs.core.seq(aspects_or)) || (((cljs.core.seq(aspects_not)) || (((cljs.core.seq(selected_types)) || (((cljs.core.seq(selected_entities)) || (cljs.core.seq(selected_entities_not)))))))))))){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"padding","padding",1660304693),"0.5rem 1rem",new cljs.core.Keyword(null,"background","background",-863952629),"#2a2a4e",new cljs.core.Keyword(null,"color","color",1011675173),"#aaa",new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"0.85rem",new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"flex-wrap","flex-wrap",455413707),"wrap",new cljs.core.Keyword(null,"gap","gap",80255254),"1rem"], null)], null),((cljs.core.seq(aspects_and))?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"color","color",1011675173),"#4a9eff"], null)], null),"AND: ",cljs.core.count(aspects_and)], null):null),((cljs.core.seq(aspects_or))?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"color","color",1011675173),"#4aef7a"], null)], null),"OR: ",cljs.core.count(aspects_or)], null):null),((cljs.core.seq(aspects_not))?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"color","color",1011675173),"#ef4a4a"], null)], null),"NOT: ",cljs.core.count(aspects_not)], null):null),((cljs.core.seq(selected_types))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"Types: ",cljs.core.count(selected_types)], null):null),((cljs.core.seq(selected_entities))?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"color","color",1011675173),"#4a9eff"], null)], null),"Entities: ",cljs.core.count(selected_entities)], null):null),((cljs.core.seq(selected_entities_not))?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"color","color",1011675173),"#ef4a4a"], null)], null),"Entities NOT: ",cljs.core.count(selected_entities_not)], null):null)], null);
} else {
return null;
}
});
atlas_ui_v2.core.loading_view = (function atlas_ui_v2$core$loading_view(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"justify-content","justify-content",-1990475787),"center",new cljs.core.Keyword(null,"align-items","align-items",-267946462),"center",new cljs.core.Keyword(null,"height","height",1025178622),"100vh",new cljs.core.Keyword(null,"background","background",-863952629),"#0f0f1a",new cljs.core.Keyword(null,"color","color",1011675173),"#eee"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),"Loading registry..."], null)], null);
});
atlas_ui_v2.core.error_view = (function atlas_ui_v2$core$error_view(error){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"justify-content","justify-content",-1990475787),"center",new cljs.core.Keyword(null,"align-items","align-items",-267946462),"center",new cljs.core.Keyword(null,"height","height",1025178622),"100vh",new cljs.core.Keyword(null,"background","background",-863952629),"#0f0f1a",new cljs.core.Keyword(null,"color","color",1011675173),"#ff6b6b"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h2","h2",-372662728),"Error loading registry"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pre","pre",2118456869),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error], 0))], null)], null)], null);
});
/**
 * Sort dropdown component
 */
atlas_ui_v2.core.sort_dropdown = (function atlas_ui_v2$core$sort_dropdown(label,current_value,options,on_change){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"align-items","align-items",-267946462),"center",new cljs.core.Keyword(null,"gap","gap",80255254),"0.5rem"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"0.8rem",new cljs.core.Keyword(null,"color","color",1011675173),"#aaa"], null)], null),label], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),cljs.core.name(current_value),new cljs.core.Keyword(null,"on-change","on-change",-732046149),(function (p1__13788_SHARP_){
var G__13789 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(p1__13788_SHARP_.target.value);
return (on_change.cljs$core$IFn$_invoke$arity$1 ? on_change.cljs$core$IFn$_invoke$arity$1(G__13789) : on_change.call(null,G__13789));
}),new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"padding","padding",1660304693),"0.3rem",new cljs.core.Keyword(null,"background","background",-863952629),"#2a2a4a",new cljs.core.Keyword(null,"color","color",1011675173),"#eee",new cljs.core.Keyword(null,"border","border",1444987323),"1px solid #4a4a6a",new cljs.core.Keyword(null,"border-radius","border-radius",419594011),"4px",new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"0.8rem",new cljs.core.Keyword(null,"cursor","cursor",1011937484),"pointer"], null)], null),(function (){var iter__5480__auto__ = (function atlas_ui_v2$core$sort_dropdown_$_iter__13790(s__13791){
return (new cljs.core.LazySeq(null,(function (){
var s__13791__$1 = s__13791;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__13791__$1);
if(temp__5804__auto__){
var s__13791__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__13791__$2)){
var c__5478__auto__ = cljs.core.chunk_first(s__13791__$2);
var size__5479__auto__ = cljs.core.count(c__5478__auto__);
var b__13793 = cljs.core.chunk_buffer(size__5479__auto__);
if((function (){var i__13792 = (0);
while(true){
if((i__13792 < size__5479__auto__)){
var vec__13794 = cljs.core._nth(c__5478__auto__,i__13792);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13794,(0),null);
var label_text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13794,(1),null);
cljs.core.chunk_append(b__13793,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),cljs.core.name(value)], null),label_text], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),value], null)));

var G__13811 = (i__13792 + (1));
i__13792 = G__13811;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__13793),atlas_ui_v2$core$sort_dropdown_$_iter__13790(cljs.core.chunk_rest(s__13791__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__13793),null);
}
} else {
var vec__13797 = cljs.core.first(s__13791__$2);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13797,(0),null);
var label_text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13797,(1),null);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),cljs.core.name(value)], null),label_text], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),value], null)),atlas_ui_v2$core$sort_dropdown_$_iter__13790(cljs.core.rest(s__13791__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5480__auto__(options);
})()], null)], null);
});
atlas_ui_v2.core.sort_controls = (function atlas_ui_v2$core$sort_controls(){
var map__13804 = cljs.core.deref(atlas_ui_v2.core.app_state);
var map__13804__$1 = cljs.core.__destructure_map(map__13804);
var sort_aspects_ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13804__$1,new cljs.core.Keyword(null,"sort-aspects-ns","sort-aspects-ns",387886950));
var sort_aspects_items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13804__$1,new cljs.core.Keyword(null,"sort-aspects-items","sort-aspects-items",-80674613));
var sort_entities_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13804__$1,new cljs.core.Keyword(null,"sort-entities-type","sort-entities-type",-663787821));
var sort_entities_items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13804__$1,new cljs.core.Keyword(null,"sort-entities-items","sort-entities-items",-1576558518));
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"padding","padding",1660304693),"0.5rem 1rem",new cljs.core.Keyword(null,"background","background",-863952629),"#1a1a2e",new cljs.core.Keyword(null,"border-bottom","border-bottom",2110948415),"1px solid #333",new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"gap","gap",80255254),"2rem",new cljs.core.Keyword(null,"flex-wrap","flex-wrap",455413707),"wrap"], null)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"gap","gap",80255254),"1rem",new cljs.core.Keyword(null,"align-items","align-items",-267946462),"center"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"color","color",1011675173),"#8a8aaa",new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"0.85rem",new cljs.core.Keyword(null,"font-weight","font-weight",2085804583),"bold"], null)], null),"Aspects Sort:"], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v2.core.sort_dropdown,"Namespace",sort_aspects_ns,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"alpha-asc","alpha-asc",859183168),"A-Z"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"alpha-desc","alpha-desc",96961375),"Z-A"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"usage-desc","usage-desc",-202614700),"Most Used"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"usage-asc","usage-asc",-762149175),"Least Used"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"count-desc","count-desc",-386573389),"Most Aspects"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"count-asc","count-asc",-1556365878),"Fewest Aspects"], null)], null),(function (p1__13800_SHARP_){
return atlas_ui_v2.core.set_sort_BANG_(new cljs.core.Keyword(null,"sort-aspects-ns","sort-aspects-ns",387886950),p1__13800_SHARP_);
})], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v2.core.sort_dropdown,"Items",sort_aspects_items,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"alpha-asc","alpha-asc",859183168),"A-Z"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"alpha-desc","alpha-desc",96961375),"Z-A"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"usage-desc","usage-desc",-202614700),"Most Used"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"usage-asc","usage-asc",-762149175),"Least Used"], null)], null),(function (p1__13801_SHARP_){
return atlas_ui_v2.core.set_sort_BANG_(new cljs.core.Keyword(null,"sort-aspects-items","sort-aspects-items",-80674613),p1__13801_SHARP_);
})], null)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"gap","gap",80255254),"1rem",new cljs.core.Keyword(null,"align-items","align-items",-267946462),"center"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"color","color",1011675173),"#8a8aaa",new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"0.85rem",new cljs.core.Keyword(null,"font-weight","font-weight",2085804583),"bold"], null)], null),"Entities Sort:"], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v2.core.sort_dropdown,"Type",sort_entities_type,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"alpha-asc","alpha-asc",859183168),"A-Z"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"alpha-desc","alpha-desc",96961375),"Z-A"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"count-desc","count-desc",-386573389),"Most Entities"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"count-asc","count-asc",-1556365878),"Fewest Entities"], null)], null),(function (p1__13802_SHARP_){
return atlas_ui_v2.core.set_sort_BANG_(new cljs.core.Keyword(null,"sort-entities-type","sort-entities-type",-663787821),p1__13802_SHARP_);
})], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v2.core.sort_dropdown,"Items",sort_entities_items,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"alpha-asc","alpha-asc",859183168),"A-Z"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"alpha-desc","alpha-desc",96961375),"Z-A"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"aspect-count-desc","aspect-count-desc",1617664369),"Most Aspects"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"aspect-count-asc","aspect-count-asc",1495464104),"Fewest Aspects"], null)], null),(function (p1__13803_SHARP_){
return atlas_ui_v2.core.set_sort_BANG_(new cljs.core.Keyword(null,"sort-entities-items","sort-entities-items",-1576558518),p1__13803_SHARP_);
})], null)], null)], null);
});
atlas_ui_v2.core.main_view = (function atlas_ui_v2$core$main_view(){
var map__13809 = cljs.core.deref(atlas_ui_v2.core.app_state);
var map__13809__$1 = cljs.core.__destructure_map(map__13809);
var aspects_not = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13809__$1,new cljs.core.Keyword(null,"aspects-not","aspects-not",1911860575));
var selected_types = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13809__$1,new cljs.core.Keyword(null,"selected-types","selected-types",-1725213152));
var aspects_or = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13809__$1,new cljs.core.Keyword(null,"aspects-or","aspects-or",-313383808));
var filter_mode = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13809__$1,new cljs.core.Keyword(null,"filter-mode","filter-mode",-84440349));
var sort_aspects_ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13809__$1,new cljs.core.Keyword(null,"sort-aspects-ns","sort-aspects-ns",387886950));
var aspect_stats = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13809__$1,new cljs.core.Keyword(null,"aspect-stats","aspect-stats",-2041038456));
var registry = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13809__$1,new cljs.core.Keyword(null,"registry","registry",1021159018));
var sort_entities_items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13809__$1,new cljs.core.Keyword(null,"sort-entities-items","sort-entities-items",-1576558518));
var sort_aspects_items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13809__$1,new cljs.core.Keyword(null,"sort-aspects-items","sort-aspects-items",-80674613));
var aspects_and = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13809__$1,new cljs.core.Keyword(null,"aspects-and","aspects-and",-655179438));
var sort_entities_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13809__$1,new cljs.core.Keyword(null,"sort-entities-type","sort-entities-type",-663787821));
var selected_entities_not = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13809__$1,new cljs.core.Keyword(null,"selected-entities-not","selected-entities-not",923796309));
var selected_entities = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13809__$1,new cljs.core.Keyword(null,"selected-entities","selected-entities",-961620715));
var query_aspects = cljs.core.vec(clojure.set.union.cljs$core$IFn$_invoke$arity$variadic(aspects_and,aspects_or,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([aspects_not], 0)));
var aspects_data = atlas_ui_v2.core.aspects_map_data(registry,aspect_stats,sort_aspects_ns,sort_aspects_items,aspects_and,aspects_or,aspects_not);
var entities_data = atlas_ui_v2.core.entities_map_data(registry,sort_entities_type,sort_entities_items,query_aspects);
var highlight_entities = ((((cljs.core.seq(aspects_and)) || (((cljs.core.seq(aspects_or)) || (cljs.core.seq(aspects_not))))))?atlas_ui_v2.core.entities_matching_aspects(registry,aspects_and,aspects_or,aspects_not):null);
var highlight_aspects = ((((cljs.core.seq(selected_entities)) || (cljs.core.seq(selected_entities_not))))?atlas_ui_v2.core.aspects_for_entities(registry,selected_entities,selected_entities_not):((cljs.core.seq(selected_types))?atlas_ui_v2.core.aspects_for_types(registry,selected_types):null
));
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"flex-direction","flex-direction",364609438),"column",new cljs.core.Keyword(null,"height","height",1025178622),"100vh",new cljs.core.Keyword(null,"background","background",-863952629),"#0f0f1a"], null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v2.core.header], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v2.core.selection_info], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"flex","flex",-1425124628),(1),new cljs.core.Keyword(null,"overflow","overflow",2058931880),"hidden"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"flex","flex",-1425124628),(1),new cljs.core.Keyword(null,"overflow","overflow",2058931880),"auto",new cljs.core.Keyword(null,"border-right","border-right",-668932860),"1px solid #333"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v2.aspects_map.aspects_map_view,aspects_data,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"aspects-or","aspects-or",-313383808),new cljs.core.Keyword(null,"highlight-aspects","highlight-aspects",-369675008),new cljs.core.Keyword(null,"filter-mode","filter-mode",-84440349),new cljs.core.Keyword(null,"sort-ns","sort-ns",128149737),new cljs.core.Keyword(null,"on-click","on-click",1632826543),new cljs.core.Keyword(null,"on-sort-items","on-sort-items",-1283971727),new cljs.core.Keyword(null,"aspects-and","aspects-and",-655179438),new cljs.core.Keyword(null,"sort-items","sort-items",814834777),new cljs.core.Keyword(null,"on-sort-ns","on-sort-ns",274538907),new cljs.core.Keyword(null,"aspects-not","aspects-not",1911860575)],[aspects_or,highlight_aspects,filter_mode,sort_aspects_ns,atlas_ui_v2.core.cycle_aspect_BANG_,(function (p1__13806_SHARP_){
return atlas_ui_v2.core.set_sort_BANG_(new cljs.core.Keyword(null,"sort-aspects-items","sort-aspects-items",-80674613),p1__13806_SHARP_);
}),aspects_and,sort_aspects_items,(function (p1__13805_SHARP_){
return atlas_ui_v2.core.set_sort_BANG_(new cljs.core.Keyword(null,"sort-aspects-ns","sort-aspects-ns",387886950),p1__13805_SHARP_);
}),aspects_not])], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"flex","flex",-1425124628),(1),new cljs.core.Keyword(null,"overflow","overflow",2058931880),"auto"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v2.entities_map.entities_map_view,entities_data,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"aspects-or","aspects-or",-313383808),new cljs.core.Keyword(null,"selected-types","selected-types",-1725213152),new cljs.core.Keyword(null,"on-type-click","on-type-click",535036770),new cljs.core.Keyword(null,"filter-mode","filter-mode",-84440349),new cljs.core.Keyword(null,"highlight-entities","highlight-entities",1314574027),new cljs.core.Keyword(null,"query-aspects","query-aspects",1772440524),new cljs.core.Keyword(null,"sort-type","sort-type",-2053499504),new cljs.core.Keyword(null,"on-sort-items","on-sort-items",-1283971727),new cljs.core.Keyword(null,"aspects-and","aspects-and",-655179438),new cljs.core.Keyword(null,"on-sort-type","on-sort-type",1838409267),new cljs.core.Keyword(null,"selected-entities","selected-entities",-961620715),new cljs.core.Keyword(null,"selected-entities-not","selected-entities-not",923796309),new cljs.core.Keyword(null,"on-aspect-click","on-aspect-click",-753135370),new cljs.core.Keyword(null,"sort-items","sort-items",814834777),new cljs.core.Keyword(null,"on-entity-click","on-entity-click",2106101276),new cljs.core.Keyword(null,"aspects-not","aspects-not",1911860575)],[aspects_or,selected_types,atlas_ui_v2.core.toggle_type_BANG_,filter_mode,highlight_entities,query_aspects,sort_entities_type,(function (p1__13808_SHARP_){
return atlas_ui_v2.core.set_sort_BANG_(new cljs.core.Keyword(null,"sort-entities-items","sort-entities-items",-1576558518),p1__13808_SHARP_);
}),aspects_and,(function (p1__13807_SHARP_){
return atlas_ui_v2.core.set_sort_BANG_(new cljs.core.Keyword(null,"sort-entities-type","sort-entities-type",-663787821),p1__13807_SHARP_);
}),selected_entities,selected_entities_not,atlas_ui_v2.core.cycle_aspect_BANG_,sort_entities_items,atlas_ui_v2.core.toggle_entity_BANG_,aspects_not])], null)], null)], null)], null);
});
atlas_ui_v2.core.app = (function atlas_ui_v2$core$app(){
var map__13810 = cljs.core.deref(atlas_ui_v2.core.app_state);
var map__13810__$1 = cljs.core.__destructure_map(map__13810);
var loading_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13810__$1,new cljs.core.Keyword(null,"loading?","loading?",1905707049));
var error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13810__$1,new cljs.core.Keyword(null,"error","error",-978969032));
var registry = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13810__$1,new cljs.core.Keyword(null,"registry","registry",1021159018));
if(cljs.core.truth_(loading_QMARK_)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v2.core.loading_view], null);
} else {
if(cljs.core.truth_(error)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v2.core.error_view,error], null);
} else {
if((registry == null)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v2.core.loading_view], null);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v2.core.main_view], null);

}
}
}
});
atlas_ui_v2.core.on_registry_loaded = (function atlas_ui_v2$core$on_registry_loaded(data){
var registry = (function (){var or__5002__auto__ = new cljs.core.Keyword("atlas-ui.api.response","registry","atlas-ui.api.response/registry",-156359811).cljs$core$IFn$_invoke$arity$1(data);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return data;
}
})();
var aspect_stats = (function (){var or__5002__auto__ = new cljs.core.Keyword("atlas-ui.api.response","aspect-stats","atlas-ui.api.response/aspect-stats",-936862191).cljs$core$IFn$_invoke$arity$1(data);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})();
console.log("Registry loaded - entities:",cljs.core.count(registry),"aspect-stats:",cljs.core.count(aspect_stats));

if((cljs.core.count(aspect_stats) > (0))){
console.log("First aspect-stat:",cljs.core.first(aspect_stats));
} else {
}

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(atlas_ui_v2.core.app_state,cljs.core.assoc,new cljs.core.Keyword(null,"registry","registry",1021159018),registry,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"aspect-stats","aspect-stats",-2041038456),aspect_stats,new cljs.core.Keyword(null,"loading?","loading?",1905707049),false,new cljs.core.Keyword(null,"error","error",-978969032),null], 0));
});
atlas_ui_v2.core.on_registry_error = (function atlas_ui_v2$core$on_registry_error(error){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(atlas_ui_v2.core.app_state,cljs.core.assoc,new cljs.core.Keyword(null,"loading?","loading?",1905707049),false,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"error","error",-978969032),error], 0));
});
atlas_ui_v2.core.mount_root = (function atlas_ui_v2$core$mount_root(){
var temp__5804__auto__ = document.getElementById("app");
if(cljs.core.truth_(temp__5804__auto__)){
var el = temp__5804__auto__;
return reagent.dom.render.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v2.core.app], null),el);
} else {
return null;
}
});
atlas_ui_v2.core.init = (function atlas_ui_v2$core$init(){
console.log("Atlas UI v2 initializing...");

atlas_ui_v2.api.fetch_registry_BANG_(atlas_ui_v2.core.on_registry_loaded,atlas_ui_v2.core.on_registry_error);

return atlas_ui_v2.core.mount_root();
});

//# sourceMappingURL=atlas_ui_v2.core.js.map
