goog.provide('taoensso.telemere');




















/**
 * See `help:handler-dispatch-opts` for details.
 */
taoensso.telemere.default_handler_dispatch_opts = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(taoensso.encore.signals.default_handler_dispatch_opts,new cljs.core.Keyword(null,"convey-bindings?","convey-bindings?",1403560206));
taoensso.telemere.level_aliases = taoensso.encore.signals.level_aliases;

/**
 * A signal will be provided to a handler iff ALL of the following are true:
 * 
 *  1. Call filters pass:
 *    a. Compile-time: sample rate, kind, ns, id, level, when form, rate limit
 *    b. Runtime:      sample rate, kind, ns, id, level, when form, rate limit
 * 
 *  2. Handler filters pass:
 *    a. Compile-time: not applicable
 *    b. Runtime:      sample rate, kind, ns, id, level, when fn, rate limit
 * 
 *  3. Call    transform (fn [signal]) => ?modified-signal returns non-nil
 *  4. Handler transform (fn [signal]) => ?modified-signal returns non-nil
 * 
 *   Transform fns provides a flexible way to modify and/or filter signals by
 *   arbitrary signal data/content conditions (return nil to skip handling).
 * 
 *   Call and handler filters are ADDITIVE, so handlers can be MORE but not LESS
 *   restrictive than call filters allow. This makes sense: call filters decide
 *   if a signal can be created. Handler filters decide if a particular handler
 *   is allowed to handle a created signal.
 * 
 *   Config:
 * 
 *  To set call filters (1a, 1b):
 * 
 *    Use:
 *      `set-kind-filter!`, `with-kind-filter`
 *      `set-ns-filter!`,   `with-ns-filter`
 *      `set-id-filter!`,   `with-id-filter`
 *      `set-min-level!`,   `with-min-level`
 * 
 *    or see `help:environmental-config`.
 * 
 *  To set handler filters (2b) or transform (4):
 * 
 *    Provide relevant opts when calling `add-handler!` or `with-handler/+`.
 *    See `help:handler-dispatch-options` for details.
 * 
 *    Note: call filters (1a, 1b) should generally be AT LEAST as permissive
 *    as handler filters (2b) since they're always applied first.
 * 
 *  To set call transform (3): use `set-xfn!`, `with-xfn`.
 * 
 *   Compile-time vs runtime filtering:
 * 
 *  Compile-time filters are an advanced feature that can be tricky to set
 *  and use correctly. Most folks will want ONLY runtime filters.
 * 
 *  Compile-time filters works by eliding (completely removing the code for)
 *  disallowed calls. This means zero performance cost for these calls, but
 *  also means that compile-time filters are PERMANENT once applied.
 * 
 *  So if you set `:info` as the compile-time minimum level, that'll REMOVE
 *  CODE for every signal call below `:info` level. To decrease that minimum
 *  level, you'll need to rebuild.
 * 
 *  Compile-time filters can be set ONLY with environmental config
 *  (see `help:environmental-config` for details).
 * 
 *   Signal and handler sampling is multiplicative:
 * 
 *  Both calls and handlers can have independent sample rates, and these
 *  MULTIPLY! If a signal is created with 20% sampling and a handler
 *  handles 50% of received signals, then 10% of possible signals will be
 *  handled (50% of 20%).
 * 
 *  When sampling is active, the final (combined multiplicative) rate is
 *  helpfully reflected in each signal's `:sample` rate value ∈ℝ[0,1].
 * 
 * If anything is unclear, please ping me (@ptaoussanis) so that I can
 * improve these docs!
 */
taoensso.telemere.help_COLON_filters = "See docstring";

/**
 * Signal handlers process created signals to do something with them (analyse them,
 *   write them to console/file/queue/db, etc.).
 * 
 *   Manage handlers with:
 * 
 *  `get-handlers`       - Returns info  on  registered handlers (dispatch options, etc.)
 *  `get-handlers-stats` - Returns stats for registered handlers (handling times,   etc.)
 * 
 *  `add-handler!`       - Registers   given handler
 *  `remove-handler!`    - Unregisters given handler
 * 
 *  `with-handler`       - Executes form with ONLY the given handler        registered
 *  `with-handler+`      - Executes form with      the given handler (also) registered
 * 
 *  `stop-handlers!`     - Stops registered handlers
 *    NB you should always call `stop-handlers!` somewhere appropriate - usually
 *    near the end of your `-main` or shutdown procedure, AFTER all other code has
 *    completed that could create signals.
 * 
 *   See the relevant docstrings for details.
 *   See `help:handler-dispatch-options` for handler filters, etc.
 * 
 *   If anything is unclear, please ping me (@ptaoussanis) so that I can
 *   improve these docs!
 */
taoensso.telemere.help_COLON_handlers = "See docstring";

/**
 * Dispatch options can be provided for each signal handler when calling
 *   `add-handler!` or `with-handler/+`. These options will be merged over the
 *   defaults specified by `default-handler-dispatch-opts`.
 * 
 *   All handlers support the same dispatch options, including:
 * 
 *  `:async` (Clj only) - may be `nil` (=> synchronous) or map with options:
 * 
 *    `:buffer-size` (default 1024)
 *      Size of request buffer, and the max number of pending requests before
 *      configured back-pressure behaviour is triggered (see `:mode`).
 * 
 *    `:mode` (default `:blocking`)
 *      Back-pressure mode ∈ #{:blocking :dropping :sliding}.
 *      Controls what happens when a new request is made while request buffer is full:
 *        `:blocking` => Blocks caller until buffer space is available
 *        `:dropping` => Drops the newest request (noop)
 *        `:sliding`  => Drops the oldest request
 * 
 *    `:n-threads` (default 1)
 *      Number of threads to use for executing fns (servicing request buffer).
 *      NB handling order guaranteed to be be sequential iff n=1.
 * 
 *    `:drain-msecs` (default 6000 msecs)
 *      Maximum time (in milliseconds) to try allow pending execution requests to
 *      complete when stopping handler. nil => no maximum.
 * 
 *  `:priority` (default 100)
 *    Optional handler priority ∈ℤ.
 *    Handlers will be called in descending priority order (larger ints first).
 * 
 *  `:track-stats?` (default true)
 *    Should handler track statistics (e.g. handling times) for
 *    reporting by `get-handlers-stats`?
 * 
 *  `:sample` (default nil => no sampling)
 *    Optional sample rate ∈ℝ[0,1], or (fn dyamic-sample-rate []) => ℝ[0,1].
 *    When present, handle only this (random) proportion of signals:
 *      1.0 => handle 100% of signals (same as nil rate, default)
 *      0.0 => hanel    0% of signals (noop all)
 *      0.5 => handle  50% of signals (random)
 * 
 *  `:kind-filter` - Kind      filter as in `set-kind-filter!` (when relevant)
 *  `:ns-filter`   - Namespace filter as in `set-ns-filter!`
 *  `:id-filter`   - Id        filter as in `set-id-filter!`   (when relevant)
 *  `:min-level`   - Minimum   level  as in `set-min-level!`
 * 
 *   ^^ Recall that all handler filters are ADDITIVE: handlers can be MORE
 *   (but not LESS) restrictive than call filters allow!
 * 
 *  `:when-fn` (default nil => always allow)
 *    Optional NULLARY (fn allow? []) that must return truthy for handler to be
 *    called. When present, called *after* sampling and other filters, but before
 *    rate limiting. Useful for filtering based on external state/context.
 *    See `:xfn` for an alternative that takes a signal argument!
 * 
 *  `:limit` (default nil => no rate limit)
 *    Optional rate limit spec as provided to `taoensso.encore/rate-limiter`,
 *    {<limit-id> [<n-max-calls> <msecs-window>]}.
 * 
 *    Examples:
 *      {"1/sec"  [1   1000]} => Max 1  call  per 1000 msecs
 *      {"1/sec"  [1   1000]
 *       "10/min" [10 60000]} => Max 1  call  per 1000 msecs,
 *                               and 10 calls per 60   secs
 * 
 *  `:xfn` (default nil => no transform)
 *    Optional transform (fn [signal]) => ?modified-signal to apply before
 *    handling signal. When transform returns nil, skips handler.
 * 
 *    Compose multiple transform fns together with `comp-xfn`.
 * 
 *  `:error-fn` - (fn [{:keys [handler-id signal error]}]) to call on handler error.
 *  `:backp-fn` - (fn [{:keys [handler-id             ]}]) to call on handler back-pressure.
 * 
 *   If anything is unclear, please ping me (@ptaoussanis) so that I can
 *   improve these docs!
 */
taoensso.telemere.help_COLON_handler_dispatch_options = "See docstring";

/**
 * Returns current ?{:keys [compile-time runtime]} filter config.
 */
taoensso.telemere.get_filters = (function taoensso$telemere$get_filters(){
return taoensso.encore.assoc_some.cljs$core$IFn$_invoke$arity$2(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"compile-time","compile-time",214692584),taoensso.encore.force_ref(null),new cljs.core.Keyword(null,"runtime","runtime",-1331573996),taoensso.encore.force_ref(taoensso.telemere.impl._STAR_rt_call_filter_STAR_)], null));
});

/**
 * Returns current ?{:keys [compile-time runtime]} minimum call levels
 *   for given/current namespace.
 */
taoensso.telemere.get_min_levels = (function taoensso$telemere$get_min_levels(var_args){
var G__18244 = arguments.length;
switch (G__18244) {
case 0:
return taoensso.telemere.get_min_levels.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.telemere.get_min_levels.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return taoensso.telemere.get_min_levels.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(taoensso.telemere.get_min_levels.cljs$core$IFn$_invoke$arity$0 = (function (){
return taoensso.telemere.get_min_levels.cljs$core$IFn$_invoke$arity$2(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core._STAR_ns_STAR_));
}));

(taoensso.telemere.get_min_levels.cljs$core$IFn$_invoke$arity$1 = (function (kind){
return taoensso.telemere.get_min_levels.cljs$core$IFn$_invoke$arity$2(kind,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core._STAR_ns_STAR_));
}));

(taoensso.telemere.get_min_levels.cljs$core$IFn$_invoke$arity$2 = (function (kind,ns){
return taoensso.encore.assoc_some.cljs$core$IFn$_invoke$arity$2(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"compile-time","compile-time",214692584),taoensso.encore.signals.parse_min_level(cljs.core.get.cljs$core$IFn$_invoke$arity$2(taoensso.encore.force_ref(null),new cljs.core.Keyword(null,"min-level","min-level",1634684919)),kind,cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)),new cljs.core.Keyword(null,"runtime","runtime",-1331573996),taoensso.encore.signals.parse_min_level(cljs.core.get.cljs$core$IFn$_invoke$arity$2(taoensso.encore.force_ref(taoensso.telemere.impl._STAR_rt_call_filter_STAR_),new cljs.core.Keyword(null,"min-level","min-level",1634684919)),kind,cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns))], null));
}));

(taoensso.telemere.get_min_levels.cljs$lang$maxFixedArity = 2);


/**
 * Returns ?{<handler-id> {:keys [dispatch-opts handler-fn handler-stats_]}}
 *   for all registered signal handlers.
 */
taoensso.telemere.get_handlers = (function taoensso$telemere$get_handlers(){
return taoensso.encore.signals.get_handlers_map.cljs$core$IFn$_invoke$arity$1(taoensso.telemere.impl._STAR_sig_handlers_STAR_);
});

/**
 * Alpha, subject to change.
 *   Returns ?{<handler-id> {:keys [handling-nsecs counts]}} for all registered
 *   signal handlers that have the `:track-stats?` dispatch option enabled
 *   (it is by default).
 * 
 *   Stats include:
 * 
 *  `:handling-nsecs` - Summary stats of nanosecond handling times, keys:
 *    `:min`  - Minimum handling time
 *    `:max`  - Maximum handling time
 *    `:mean` - Arithmetic mean handling time
 *    `:mad`  - Mean absolute deviation of handling time (measure of dispersion)
 *    `:var`  - Variance                of handling time (measure of dispersion)
 *    `:p50`  - 50th percentile of handling time (50% of times <= this)
 *    `:p90`  - 90th percentile of handling time (90% of times <= this)
 *    `:p99`  - 99th percentile of handling time
 *    `:last` - Most recent        handling time
 *    ...
 * 
 *  `:counts` - Integer counts for handler outcomes, keys (chronologically):
 * 
 *    `:dropped`       - Noop handler calls due to stopped handler
 *    `:back-pressure` - Handler calls that experienced (async) back-pressure
 *                       (possible noop, depending on back-pressure mode)
 * 
 *    `:sampled`      - Noop  handler calls due to sample rate
 *    `:filtered`     - Noop  handler calls due to kind/ns/id/level/when filtering
 *    `:rate-limited` - Noop  handler calls due to rate limit
 *    `:disallowed`   - Noop  handler calls due to sampling/filtering/rate-limiting
 *    `:allowed`      - Other handler calls    (no sampling/filtering/rate-limiting)
 * 
 *    `:suppressed`   - Noop handler calls due to nil transform (xfn) result
 *    `:handled`      - Handler calls that completed successfully
 *    `:errors`       - Handler calls that threw an error
 * 
 *    Note that for performance reasons returned counts are not mutually atomic,
 *    e.g. `:sampled` count may be incremented before `:disallowed` count is.
 * 
 *   Useful for understanding/debugging how your handlers behave in practice,
 *   especially when they're under stress (high-volumes, etc.).
 * 
 *   Handler stats are tracked from the time each handler is last registered
 *   (e.g. with an `add-handler!` call).
 */
taoensso.telemere.get_handlers_stats = (function taoensso$telemere$get_handlers_stats(){
return taoensso.encore.signals.get_handlers_stats(taoensso.telemere.impl._STAR_sig_handlers_STAR_);
});


/**
 * Sets call kind filter based on given `kind-filter` spec.
 *   `kind-filter` may be:
 * 
 *  - A regex pattern of kind/s to allow
 *  - A str/kw/sym to allow, with "*" and "(.*)" as wildcards:
 *    "foo.*"   will allow "foo.bar"
 *    "foo(.*)" will allow "foo.bar" and "foo"
 * 
 *  - A set/vector of above (allow on any match)
 *  - A map, {:allow <spec> :disallow <spec>} with specs as above:
 *    If present, `:allow`    spec MUST     match, AND
 *    If present, `:disallow` spec MUST NOT match.
 */
taoensso.telemere.set_kind_filter_BANG_ = (function taoensso$telemere$set_kind_filter_BANG_(kind_filter){
return taoensso.encore.force_ref((taoensso.telemere.impl._STAR_rt_call_filter_STAR_ = (function (old__16401__auto__){
return taoensso.encore.signals.update_spec_filter(old__16401__auto__,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"kind-filter","kind-filter",2030810915),kind_filter], null));
})(taoensso.telemere.impl._STAR_rt_call_filter_STAR_)));
});


/**
 * Sets call namespace filter based on given `ns-filter` spec.
 *   `ns-filter` may be:
 * 
 *  - A namespace.
 *  - A regex pattern of namespaces/s to allow
 *  - A str/kw/sym to allow, with "*" and "(.*)" as wildcards:
 *    "foo.*"   will allow "foo.bar"
 *    "foo(.*)" will allow "foo.bar" and "foo"
 * 
 *  - A set/vector of above (allow on any match)
 *  - A map, {:allow <spec> :disallow <spec>} with specs as above:
 *    If present, `:allow`    spec MUST     match, AND
 *    If present, `:disallow` spec MUST NOT match.
 */
taoensso.telemere.set_ns_filter_BANG_ = (function taoensso$telemere$set_ns_filter_BANG_(ns_filter){
return taoensso.encore.force_ref((taoensso.telemere.impl._STAR_rt_call_filter_STAR_ = (function (old__16410__auto__){
return taoensso.encore.signals.update_spec_filter(old__16410__auto__,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"ns-filter","ns-filter",108598448),ns_filter], null));
})(taoensso.telemere.impl._STAR_rt_call_filter_STAR_)));
});


/**
 * Sets call id filter based on given `id-filter` spec.
 *   `id-filter` may be:
 * 
 *  - A regex pattern of id/s to allow
 *  - A str/kw/sym to allow, with "*" and "(.*)" as wildcards:
 *    "foo.*"   will allow "foo.bar"
 *    "foo(.*)" will allow "foo.bar" and "foo"
 * 
 *  - A set/vector of above (allow on any match)
 *  - A map, {:allow <spec> :disallow <spec>} with specs as above:
 *    If present, `:allow`    spec MUST     match, AND
 *    If present, `:disallow` spec MUST NOT match.
 */
taoensso.telemere.set_id_filter_BANG_ = (function taoensso$telemere$set_id_filter_BANG_(id_filter){
return taoensso.encore.force_ref((taoensso.telemere.impl._STAR_rt_call_filter_STAR_ = (function (old__16416__auto__){
return taoensso.encore.signals.update_spec_filter(old__16416__auto__,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"id-filter","id-filter",-572281277),id_filter], null));
})(taoensso.telemere.impl._STAR_rt_call_filter_STAR_)));
});


/**
 * Sets minimum call level based on given `min-level` spec.
 *   `min-level` may be:
 * 
 *  - nil (=> no minimum level).
 *  - A level keyword (see `level-aliases` value for details).
 *  - An integer      (see `level-aliases` value for details).
 *  - (Advanced) [[nf-filter min-level] ...] vector.
 * 
 *   If non-nil `kind` is provided, then the given minimum level will
 *   apply only for that call kind.
 * 
 *   If `ns-filter` is provided, then the given minimum level will
 *   apply only for the namespace/s that match (see `set-ns-filter!`).
 *   Order matters if >1 configured ns filter can match an ns! First
 *   match wins, see `get-filters` or `get-min-levels` to view/debug
 *   (left->right) match order.
 * 
 *   Examples:
 *  (set-min-level! nil)   ; Disable        minimum level
 *  (set-min-level! :info) ; Set `:info` as minimum level
 *  (set-min-level! 100)   ; Set 100     as minimum level
 * 
 *  (set-min-level! nil *ns* :info) ; Set for this ns only
 *  (set-min-level! nil [["my.ns" :debug] ["* :info]]) ; Advanced
 */
taoensso.telemere.set_min_level_BANG_ = (function taoensso$telemere$set_min_level_BANG_(var_args){
var G__18255 = arguments.length;
switch (G__18255) {
case 1:
return taoensso.telemere.set_min_level_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return taoensso.telemere.set_min_level_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return taoensso.telemere.set_min_level_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(taoensso.telemere.set_min_level_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (min_level){
return taoensso.telemere.set_min_level_BANG_.cljs$core$IFn$_invoke$arity$3(null,null,min_level);
}));

(taoensso.telemere.set_min_level_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (kind,min_level){
return taoensso.telemere.set_min_level_BANG_.cljs$core$IFn$_invoke$arity$3(kind,null,min_level);
}));

(taoensso.telemere.set_min_level_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (kind,ns_filter,min_level){
return taoensso.encore.force_ref((taoensso.telemere.impl._STAR_rt_call_filter_STAR_ = (function (old_sf__16426__auto__){
return taoensso.encore.signals.update_spec_filter(old_sf__16426__auto__,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"min-level-fn","min-level-fn",-1014940803),(function (old_ml__16427__auto__){
return taoensso.encore.signals.update_min_level(old_ml__16427__auto__,kind,ns_filter,min_level);
})], null));
})(taoensso.telemere.impl._STAR_rt_call_filter_STAR_)));
}));

(taoensso.telemere.set_min_level_BANG_.cljs$lang$maxFixedArity = 3);





/**
 * Registers given signal handler and returns
 *   {<handler-id> {:keys [dispatch-opts handler-fn]}} for all handlers
 *   now registered. If an old handler already existed under the same id, stop it.
 * 
 *   `handler-fn` should be a fn of exactly 2 arities:
 * 
 *  [signal] ; Single argument
 *    Called asynchronously or synchronously (depending on dispatch options)
 *    to do something useful with the given signal.
 * 
 *    Example actions:
 *      Save data to disk or db, `tap>`, log, `put!` to an appropriate
 *      `core.async` channel, filter, aggregate, use for a realtime analytics
 *      dashboard, examine for outliers or unexpected data, etc.
 * 
 *  [] ; No arguments
 *    Called exactly once when stopping handler to provide an opportunity
 *    for handler to flush buffers, close files, etc. May just noop.
 * 
 *   NB you should always call `stop-handlers!` somewhere appropriate - usually
 *   near the end of your `-main` or shutdown procedure, AFTER all other code has
 *   completed that could create signals.
 * 
 *   See `help:handler-dispatch-options` for handler filters, etc.
 */
taoensso.telemere.add_handler_BANG_ = (function taoensso$telemere$add_handler_BANG_(var_args){
var G__18257 = arguments.length;
switch (G__18257) {
case 2:
return taoensso.telemere.add_handler_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return taoensso.telemere.add_handler_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(taoensso.telemere.add_handler_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (handler_id,handler_fn){
return taoensso.telemere.add_handler_BANG_.cljs$core$IFn$_invoke$arity$3(handler_id,handler_fn,null);
}));

(taoensso.telemere.add_handler_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (handler_id,handler_fn,dispatch_opts){
var removed_handler__16436__auto__ = taoensso.encore.signals.get_wrapped_handler_fn(taoensso.telemere.impl._STAR_sig_handlers_STAR_,handler_id);
var new_handlers_vec__16437__auto__ = (taoensso.telemere.impl._STAR_sig_handlers_STAR_ = (function (m__16438__auto__){
return taoensso.encore.signals.add_handler.cljs$core$IFn$_invoke$arity$5(m__16438__auto__,handler_id,handler_fn,taoensso.telemere.default_handler_dispatch_opts,dispatch_opts);
})(taoensso.telemere.impl._STAR_sig_handlers_STAR_));
if(cljs.core.truth_(removed_handler__16436__auto__)){
(removed_handler__16436__auto__.cljs$core$IFn$_invoke$arity$0 ? removed_handler__16436__auto__.cljs$core$IFn$_invoke$arity$0() : removed_handler__16436__auto__.call(null));
} else {
}

return taoensso.encore.signals.get_handlers_map.cljs$core$IFn$_invoke$arity$1(new_handlers_vec__16437__auto__);
}));

(taoensso.telemere.add_handler_BANG_.cljs$lang$maxFixedArity = 3);


/**
 * Stops and deregisters signal handler with given id, and returns
 *   ?{<handler-id> {:keys [dispatch-opts handler-fn]}} for all handlers
 *   still registered.
 */
taoensso.telemere.remove_handler_BANG_ = (function taoensso$telemere$remove_handler_BANG_(handler_id){
var removed_handler__16440__auto__ = taoensso.encore.signals.get_wrapped_handler_fn(taoensso.telemere.impl._STAR_sig_handlers_STAR_,handler_id);
var new_handlers_vec__16441__auto__ = (taoensso.telemere.impl._STAR_sig_handlers_STAR_ = (function (m__16442__auto__){
return taoensso.encore.signals.remove_handler(m__16442__auto__,handler_id);
})(taoensso.telemere.impl._STAR_sig_handlers_STAR_));
if(cljs.core.truth_(removed_handler__16440__auto__)){
(removed_handler__16440__auto__.cljs$core$IFn$_invoke$arity$0 ? removed_handler__16440__auto__.cljs$core$IFn$_invoke$arity$0() : removed_handler__16440__auto__.call(null));
} else {
}

return taoensso.encore.signals.get_handlers_map.cljs$core$IFn$_invoke$arity$1(new_handlers_vec__16441__auto__);
});

/**
 * Stops registered signal handlers in parallel by calling each
 *   handler-fn with no arguments. This gives each handler the opportunity
 *   to flush buffers, close files, etc.
 * 
 *   Each handler will immediately stop accepting new signals, nooping if called.
 * 
 *   Blocks to return ?{<handler-id> {:keys [okay error]}}, honouring each
 *   handler's `:drain-msecs` value (see `help:handler-dispatch-options`).
 * 
 *   NB you should always call `stop-handlers!` somewhere appropriate - usually
 *   near the end of your `-main` or shutdown procedure, AFTER all other code has
 *   completed that could create signals.
 */
taoensso.telemere.stop_handlers_BANG_ = (function taoensso$telemere$stop_handlers_BANG_(){
return taoensso.encore.signals.stop_handlers_BANG_(taoensso.telemere.impl._STAR_sig_handlers_STAR_);
});

/**
 * Optional context (state) attached to all signals.
 *   Value may be any type, but is usually nil or a map. Default (root) value is nil.
 * 
 *   Useful for dynamically attaching arbitrary app-level state to signals.
 * 
 *   Re/bind dynamic        value using `with-ctx`, `with-ctx+`, or `binding`.
 *   Modify  root (default) value using `set-ctx!`.
 * 
 *   As with all dynamic Clojure vars, "binding conveyance" applies when using
 *   futures, agents, etc.
 * 
 *   Tips:
 *  - Value may be (or may contain) an atom if you want mutable semantics.
 *  - Value may be of form {<scope-id> <data>} for custom scoping, etc.
 *  - Use `get-env` to set default (root) value based on environmental config.
 */
taoensso.telemere._STAR_ctx_STAR_ = null;

/**
 * Set `*ctx*` var's default (root) value. See `*ctx*` for details.
 */
taoensso.telemere.set_ctx_BANG_ = (function taoensso$telemere$set_ctx_BANG_(root_ctx){
return (taoensso.telemere._STAR_ctx_STAR_ = root_ctx);
});

var ret__5781__auto___18337 = (function (){
/**
 * Evaluates given body with given `*ctx*` value. See `*ctx*` for details.
 */
taoensso.telemere.with_ctx = (function taoensso$telemere$with_ctx(var_args){
var args__5732__auto__ = [];
var len__5726__auto___18338 = arguments.length;
var i__5727__auto___18339 = (0);
while(true){
if((i__5727__auto___18339 < len__5726__auto___18338)){
args__5732__auto__.push((arguments[i__5727__auto___18339]));

var G__18340 = (i__5727__auto___18339 + (1));
i__5727__auto___18339 = G__18340;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((3) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((3)),(0),null)):null);
return taoensso.telemere.with_ctx.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5733__auto__);
});

(taoensso.telemere.with_ctx.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,ctx,body){
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol("clojure.core","binding","clojure.core/binding",2144622993,null),null,(1),null)),(new cljs.core.List(null,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("taoensso.telemere","*ctx*","taoensso.telemere/*ctx*",-115690411,null),null,(1),null)),(new cljs.core.List(null,ctx,null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([body], 0)));
}));

(taoensso.telemere.with_ctx.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(taoensso.telemere.with_ctx.cljs$lang$applyTo = (function (seq18267){
var G__18268 = cljs.core.first(seq18267);
var seq18267__$1 = cljs.core.next(seq18267);
var G__18269 = cljs.core.first(seq18267__$1);
var seq18267__$2 = cljs.core.next(seq18267__$1);
var G__18270 = cljs.core.first(seq18267__$2);
var seq18267__$3 = cljs.core.next(seq18267__$2);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18268,G__18269,G__18270,seq18267__$3);
}));

return null;
})()
;
(taoensso.telemere.with_ctx.cljs$lang$macro = true);


var ret__5781__auto___18342 = (function (){
/**
 * Evaluates given body with updated `*ctx*` value.
 * 
 *   `update-map-or-fn` may be:
 *  - A map to merge with    current `*ctx*` value, or
 *  - A unary fn to apply to current `*ctx*` value
 * 
 *   See `*ctx*` for details.
 */
taoensso.telemere.with_ctx_PLUS_ = (function taoensso$telemere$with_ctx_PLUS_(var_args){
var args__5732__auto__ = [];
var len__5726__auto___18343 = arguments.length;
var i__5727__auto___18344 = (0);
while(true){
if((i__5727__auto___18344 < len__5726__auto___18343)){
args__5732__auto__.push((arguments[i__5727__auto___18344]));

var G__18346 = (i__5727__auto___18344 + (1));
i__5727__auto___18344 = G__18346;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((3) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((3)),(0),null)):null);
return taoensso.telemere.with_ctx_PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5733__auto__);
});

(taoensso.telemere.with_ctx_PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,update_map_or_fn,body){
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol("clojure.core","binding","clojure.core/binding",2144622993,null),null,(1),null)),(new cljs.core.List(null,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("taoensso.telemere","*ctx*","taoensso.telemere/*ctx*",-115690411,null),null,(1),null)),(new cljs.core.List(null,cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol("taoensso.encore.signals","update-ctx","taoensso.encore.signals/update-ctx",-270251357,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol("taoensso.telemere","*ctx*","taoensso.telemere/*ctx*",-115690411,null),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,update_map_or_fn,null,(1),null))], 0))),null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([body], 0)));
}));

(taoensso.telemere.with_ctx_PLUS_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(taoensso.telemere.with_ctx_PLUS_.cljs$lang$applyTo = (function (seq18273){
var G__18274 = cljs.core.first(seq18273);
var seq18273__$1 = cljs.core.next(seq18273);
var G__18275 = cljs.core.first(seq18273__$1);
var seq18273__$2 = cljs.core.next(seq18273__$1);
var G__18276 = cljs.core.first(seq18273__$2);
var seq18273__$3 = cljs.core.next(seq18273__$2);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18274,G__18275,G__18276,seq18273__$3);
}));

return null;
})()
;
(taoensso.telemere.with_ctx_PLUS_.cljs$lang$macro = true);


/**
 * Optional transform (fn [signal]) => ?modified-signal to apply to all signals.
 *   When transform returns nil, skips all handlers. Default (root) value is nil.
 * 
 *   Useful for dynamically filtering and/or modifying signals by signal data/content/etc.
 * 
 *   Re/bind dynamic        value using `with-xfn`, `with-xfn+`, `binding`.
 *   Modify  root (default) value using `set-xfn!`.
 * 
 *   As with all dynamic Clojure vars, "binding conveyance" applies when using
 *   futures, agents, etc.
 * 
 *   Examples:
 * 
 *  ;; Filter all signals by returning nil:
 *  (t/set-xfn! (fn [signal] (when-not (:skip-me? signal) signal)))
 * 
 *  ;; Remove key/s from all signals:
 *  (t/set-xfn! (fn [signal] (dissoc signal :unwanted-key1 ...)))
 * 
 *  ;; Remove key/s from signals to specific handler:
 *  (t/add-handler! ::my-handler my-handler
 *    {:xfn (fn [signal] (dissoc signal :unwanted-key1 ...))})
 * 
 *  ;; Dynamic transform for specific signal/s:
 *  (binding [*xfn* (fn [signal] ...)]
 *    (...))
 * 
 *   Tips:
 *  - Compose multiple transform fns together with `comp-xfn`.
 *  - Use `get-env` to set default (root) value based on environmental config.
 */
taoensso.telemere._STAR_xfn_STAR_ = null;

/**
 * Set `*xfn*` var's default (root) value. See `*xfn*` for details.
 */
taoensso.telemere.set_xfn_BANG_ = (function taoensso$telemere$set_xfn_BANG_(_QMARK_root_xfn){
return (taoensso.telemere._STAR_xfn_STAR_ = _QMARK_root_xfn);
});

var ret__5781__auto___18348 = (function (){
/**
 * Evaluates given body with given `*xfn*` value, see `*xfn*` for details.
 */
taoensso.telemere.with_xfn = (function taoensso$telemere$with_xfn(var_args){
var args__5732__auto__ = [];
var len__5726__auto___18349 = arguments.length;
var i__5727__auto___18350 = (0);
while(true){
if((i__5727__auto___18350 < len__5726__auto___18349)){
args__5732__auto__.push((arguments[i__5727__auto___18350]));

var G__18351 = (i__5727__auto___18350 + (1));
i__5727__auto___18350 = G__18351;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((3) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((3)),(0),null)):null);
return taoensso.telemere.with_xfn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5733__auto__);
});

(taoensso.telemere.with_xfn.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,_QMARK_xfn,body){
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol("clojure.core","binding","clojure.core/binding",2144622993,null),null,(1),null)),(new cljs.core.List(null,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("taoensso.telemere","*xfn*","taoensso.telemere/*xfn*",-994507221,null),null,(1),null)),(new cljs.core.List(null,_QMARK_xfn,null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([body], 0)));
}));

(taoensso.telemere.with_xfn.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(taoensso.telemere.with_xfn.cljs$lang$applyTo = (function (seq18278){
var G__18279 = cljs.core.first(seq18278);
var seq18278__$1 = cljs.core.next(seq18278);
var G__18280 = cljs.core.first(seq18278__$1);
var seq18278__$2 = cljs.core.next(seq18278__$1);
var G__18281 = cljs.core.first(seq18278__$2);
var seq18278__$3 = cljs.core.next(seq18278__$2);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18279,G__18280,G__18281,seq18278__$3);
}));

return null;
})()
;
(taoensso.telemere.with_xfn.cljs$lang$macro = true);


var ret__5781__auto___18352 = (function (){
/**
 * Evaluates given body with composed `*xfn*` value.
 *   Same as (with-xfn (comp-xfn *xfn* ?xfn) ...).
 *   See `*xfn*` for details.
 */
taoensso.telemere.with_xfn_PLUS_ = (function taoensso$telemere$with_xfn_PLUS_(var_args){
var args__5732__auto__ = [];
var len__5726__auto___18353 = arguments.length;
var i__5727__auto___18354 = (0);
while(true){
if((i__5727__auto___18354 < len__5726__auto___18353)){
args__5732__auto__.push((arguments[i__5727__auto___18354]));

var G__18355 = (i__5727__auto___18354 + (1));
i__5727__auto___18354 = G__18355;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((3) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((3)),(0),null)):null);
return taoensso.telemere.with_xfn_PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5733__auto__);
});

(taoensso.telemere.with_xfn_PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,_QMARK_xfn,body){
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol("clojure.core","binding","clojure.core/binding",2144622993,null),null,(1),null)),(new cljs.core.List(null,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("taoensso.telemere","*xfn*","taoensso.telemere/*xfn*",-994507221,null),null,(1),null)),(new cljs.core.List(null,cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol("taoensso.encore.signals","comp-xfn","taoensso.encore.signals/comp-xfn",-1050364423,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol("taoensso.telemere","*xfn*","taoensso.telemere/*xfn*",-994507221,null),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,_QMARK_xfn,null,(1),null))], 0))),null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([body], 0)));
}));

(taoensso.telemere.with_xfn_PLUS_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(taoensso.telemere.with_xfn_PLUS_.cljs$lang$applyTo = (function (seq18286){
var G__18287 = cljs.core.first(seq18286);
var seq18286__$1 = cljs.core.next(seq18286);
var G__18288 = cljs.core.first(seq18286__$1);
var seq18286__$2 = cljs.core.next(seq18286__$1);
var G__18289 = cljs.core.first(seq18286__$2);
var seq18286__$3 = cljs.core.next(seq18286__$2);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18287,G__18288,G__18289,seq18286__$3);
}));

return null;
})()
;
(taoensso.telemere.with_xfn_PLUS_.cljs$lang$macro = true);

/**
 * Returns true with given probability ∈ ℝ[0,1].
 */
taoensso.telemere.chance = taoensso.encore.chance;

/**
 * Takes a spec of form
 *  [           [<n-max-reqs> <msecs-window>] ...] or ; Unnamed limits
 *  {<limit-id> [<n-max-reqs> <msecs-window>]}        ;   Named limits
 *   and returns stateful (fn a-rate-limiter [] [req-id] [command req-id]).
 * 
 *   Call the returned limiter fn with a request id (any Clojure value!) to
 *   enforce limits independently for each id.
 * 
 *   For example, (limiter-fn <ip-address-string>) will return:
 *  - Falsey when    allowed (all limits pass for given IP), or
 *  - Truthy when disallowed (any limits fail for given IP):
 *    [<worst-limit-id> <worst-backoff-msecs> {<limit-id> <backoff-msecs>}]
 * 
 *   Or call the returned limiter fn with an extra command argument:
 *  (limiter-fn :rl/peek  <req-id) - Check limits WITHOUT incrementing count
 *  (limiter-fn :rl/reset <req-id) - Reset all limits for given req-id
 */
taoensso.telemere.rate_limiter = taoensso.encore.rate_limiter;

/**
 * Single system newline
 */
taoensso.telemere.newline = "\n";

/**
 * Returns a composite unary signal transform fn (xfn).
 *   Like `core/comp` but takes only unary fns, applies functions left->right(!),
 *   and composite immediately returns nil if any given fn returns nil.
 */
taoensso.telemere.comp_xfn = taoensso.encore.signals.comp_xfn;

/**
 * For use within signal message vectors.
 *   Wraps given arguments so that they're spliced when creating message.
 *   Useful for conditionally splicing in extra message content, etc.:
 * 
 *  (signal! {:msg [(when <cond> (msg-splice ["Username:" "Steve"])) <...>]}) or
 *  (log!          [(when <cond> (msg-splice ["Username:" "Steve"]))])
 * 
 *    %> {:msg_ "Username: Steve"}
 */
taoensso.telemere.msg_splice = taoensso.telemere.impl.msg_splice;

taoensso.telemere.msg_skip = taoensso.telemere.impl.msg_skip;

/**
 * Alpha, subject to change.
 *   Returns a (fn clean [signal]) that:
 *  - Takes a Telemere  signal (map).
 *  - Returns a minimal signal (map) ready for printing, etc.
 * 
 *   Signals are optimized for cheap creation and easy handling, so tend to be
 *   verbose and may contain things like nil values and duplicated content.
 * 
 *   This util efficiently cleans signals of such noise, helping reduce
 *   storage/transmission size, and making key info easier to see.
 * 
 *   Options:
 *  `:incl-nils?` - Include signal's keys with nil values? (default false)
 *  `:incl-kvs?` -- Include signal's app-level root kvs?   (default false)
 *  `:incl-keys` -- Subset of signal keys to retain from those otherwise
 *                  excluded by default: #{:schema :kvs :host :thread}
 */
taoensso.telemere.clean_signal_fn = taoensso.telemere.utils.clean_signal_fn;

/**
 * Alpha, subject to change.
 *   Returns a (fn format [signal]) that:
 *  - Takes a Telemere signal (map).
 *  - Returns a human-readable signal string.
 * 
 *   Options:
 *  `:incl-newline?` - Include terminating system newline? (default true)
 *  `:preamble-fn` --- (fn [signal]) => signal preamble string, see [1]
 *  `:content-fn` ---- (fn [signal]) => signal content  string, see [2]
 * 
 *   [1] `taoensso.telemere.utils/signal-preamble-fn`, etc.
 *   [2] `taoensso.telemere.utils/signal-content-fn`,  etc.
 * 
 *   See also `pr-signal-fn` for an alternative to `format-signal-fn`
 *   that produces machine-readable output (edn, JSON, etc.).
 */
taoensso.telemere.format_signal_fn = taoensso.telemere.utils.format_signal_fn;

/**
 * Alpha, subject to change.
 *   Returns a (fn pr [signal]) that:
 *  - Takes a Telemere signal (map).
 *  - Returns a machine-readable signal string.
 * 
 *   Options:
 *  `:pr-fn` --------- ∈ #{<unary-fn> :edn (default) :json (Cljs only)}
 *  `:clean-fn` ------ (fn [signal]) => clean signal map, see [1]
 *  `:incl-newline?` - Include terminating system newline? (default true)
 * 
 *   Examples:
 * 
 *  ;; To print as edn:
 *  (pr-signal-fn {:pr-fn :edn})
 * 
 *  ;; To print as JSON:
 *  ;; Ref.  <https://github.com/metosin/jsonista> (or any alt JSON lib)
 *  #?(:clj (require '[jsonista.core :as jsonista]))
 *  (pr-signal-fn
 *    {:pr-fn
 *      #?(:cljs :json ; Use js/JSON.stringify
 *         :clj  jsonista/write-value-as-string)})
 * 
 *   [1] `taoensso.telemere.utils/clean-signal-fn`, etc.
 * 
 *   See also `format-signal-fn` for an alternative to `pr-signal-fn`
 *   that produces human-readable output.
 */
taoensso.telemere.pr_signal_fn = taoensso.telemere.utils.pr_signal_fn;

/**
 * Returns true iff given signal has an `:error` value, or a `:kind` or `:level`
 *   that indicates that it's an error.
 */
taoensso.telemere.error_signal_QMARK_ = taoensso.telemere.utils.error_signal_QMARK_;
/**
 * Call a Telemere signal creator to conditionally create a signal at that callsite.
 * 
 * When filtering conditions are met [4], the call creates a Telemere signal [3]
 * and dispatches it to registered handlers for processing (e.g. writing to
 * console/file/queue/db, etc.).
 * 
 * Telemere doesn't make a hard distinction between different kinds of signals
 * (log, event, error, etc.) - they're all just plain Clojure/Script maps with
 * various keys:
 * 
 *   - All signal creators offer the same options [2], and
 *   - All signal kinds can contain the same content [3]
 * 
 * Creators vary only in in their default `:kind` value and call APIs (expected
 * args and return values), making them more/less convenient for certain use cases:
 * 
 *   `log!` ------------- ?level + msg    => nil
 *   `event!` ----------- id     + ?level => nil
 *   `trace!` ----------- ?id    + run    => run result (value or throw)
 *   `spy!` ------------- ?level + run    => run result (value or throw)
 *   `error!` ----------- ?id    + error  => given error
 *   `catch->error!` ---- ?id    + run    => run value or ?catch-val
 *   `uncaught->error!` - ?id             => nil
 *   `signal!` ---------- opts            => allowed? / run result (value or throw)
 * 
 * - `log!` and `event!` are both good default/general-purpose signal creators.
 * - `log!` emphasizes messages, while `event!` emphasizes ids.
 * - `signal!` is the generic creator, and is used by all the others.
 * 
 * ----------------------------------------------------------------------
 * [2] See `help:signal-options` - {:keys [kind level id data ...]}
 * [3] See `help:signal-content` - {:keys [kind level id data ...]}
 * [4] See `help:signal-filters` - (by ns/kind/id/level, sampling, etc.)
 */
taoensso.telemere.help_COLON_signal_creators = "See docstring";

/**
 * Signal options are provided as a map with COMPILE-TIME keys.
 * All options are available for all signal creator calls:
 * 
 * `:inst` -------- Platform instant [1] when signal was created, ∈ #{nil :auto <[1]>}
 * `:level` ------- Signal level ∈ #{<int> :trace :debug :info :warn :error :fatal :report ...}
 * `:kind` -------- Signal ?kind ∈ #{nil :event :error :log :trace :spy <app-val> ...}
 * `:id` ---------- ?id of signal          (common to all  signals created at callsite, contrast with `:uid`)
 * `:uid` --------- ?id of signal instance (unique to each signal  created at callsite, contrast with  `:id`)
 *               Defaults to `:auto` for tracing signals, and nil otherwise
 * 
 * `:msg` --------- Arb app-level ?message to incl. in signal: str or vec of strs to join (with `\space`), may be a delay
 * `:data` -------- Arb app-level ?data    to incl. in signal: usu. a map, LAZY! [3]
 * `:error` ------- Arb app-level ?error   to incl. in signal: platform error [2]
 * 
 * `:run` --------- ?form     to execute UNCONDITIONALLY; will incl. `:run-val` in signal
 * `:do` ---------- ?form     to execute   conditionally (iff signal allowed) and LAZILY [3], before establishing `:let` ?binding
 * `:let` --------- ?bindings to establish conditionally (iff signal allowed) and LAZILY [3], BEFORE evaluating `:data` and `:msg` (useful!)
 * 
 * `:parent` ------ Custom ?{:keys [id uid]} to override auto (dynamic) parent signal tracing info
 * `:root` -------- Custom ?{:keys [id uid]} to override auto (dynamic) root   signal tracing info
 * `:ctx` --------- Custom ?val to override auto (dynamic `*ctx*`) in signal, as per `with-ctx`
 * `:ctx+` -------- Custom ?val to update   auto (dynamic `*ctx*`) in signal, as per `with-ctx+`
 * 
 * `:ns` ---------- Custom ?str namespace to override auto signal callsite info
 * `:coords` ------ Custom ?[line column] to override auto signal callsite info
 * 
 * `:elidable?` --- Should signal be subject to compile-time elision? (default true)
 * `:allow?` ------ Custom override for usual runtime filtering (true => ALWAYS create signal)
 * `:trace?` ------ Should tracing be enabled for `:run` form?
 * 
 * `:sample` ------ Sample ?rate ∈ℝ[0,1] for random signal sampling (0.75 => allow 75% of signals, nil => allow all)
 * `:when` -------- Arb ?form; when present, form must return truthy to allow signal
 * `:limit` ------- Rate limit ?spec given to `taoensso.telemere/rate-limiter`, see its docstring for details
 * `:limit-by` ---- When present, rate limits will be enforced independently for each value (any Clojure value!)
 * `:xfn` --------- Optional       transform (fn [signal]) => ?modified-signal to apply when signal is created, as per `with-xfn`
 * `:xfn+` -------- Optional extra transform (fn [signal]) => ?modified-signal to apply when signal is created, as per `with-xfn+`
 * 
 * <kvs> ---------- Other arb app-level ?kvs to incl. in signal. Typically NOT included in
 *               handler output, so a great way to provide custom data/opts for use
 *               (only) by custom transforms/handlers. LAZY! [3]
 * 
 * If anything is unclear, please ping me (@ptaoussanis) so that I can improve these docs!
 * 
 * [1] `java.time.Instant`   or `js/Date`
 * [2] `java.lang.Throwable` or `js/Error`
 * [3] Most Telemere signal content is evaluated CONDITIONALLY (iff signal allowed),
 *  LAZILY (when signal is created), and on the HANDLING THREAD (not logging thread).
 *  This allows efficient filtering, better control+monitoring of back pressure,
 *  conditional effects, etc. Ref. <https://www.taoensso.com/telemere/flow> for visual!
 */
taoensso.telemere.help_COLON_signal_options = "See docstring";

/**
 * Telemere signals are maps with {:keys [inst id ns level data msg_ ...]},
 * though they can be modified by call and/or handler transform (xfns).
 * 
 * Default signal keys:
 * 
 * `:schema` ------ Int version of signal schema (current: 1)
 * `:inst` -------- Platform instant [1] when signal was created, monotonicity depends on system clock
 * `:ns` ---------- ?str namespace of signal callsite
 * `:coords` ------ ?[line column] of signal callsite
 * 
 * `:kind` -------- Signal ?kind ∈ #{nil :event :error :log :trace :spy :slf4j :tools-logging <app-val> ...}
 * `:level` ------- Signal level ∈ #{<int> :trace :debug :info :warn :error :fatal :report ...}
 * `:id` ---------- Signal callsite ?id (usu. keyword) (common to all  signals created at callsite,              contrast with `:uid`)
 * `:uid` --------- Signal instance ?id (usu. string)  (unique to each signal  created at callsite when tracing, contrast with  `:id`)
 * 
 * `:msg_` -------- Arb app-level message  ?str              given to signal creator - may be a delay, always use `force` to unwrap!
 * `:data` -------- Arb app-level data     ?val (usu. a map) given to signal creator
 * `:error` ------- Arb app-level platform ?error [2]        given to signal creator
 * 
 * `:run-form` ---- Unevaluated ?form given to signal creator as `:run`
 * `:run-val` ----- Successful return ?val of  `:run` ?form
 * `:run-nsecs` --- ?int nanosecs runtime of   `:run` ?form
 * `:end-inst` ---- Platform ?instant [1] when `:run` ?form completed
 * 
 * `:parent` ------ ?{:keys [id uid]} of parent signal, present in nested signals when tracing
 * `:root` -------- ?{:keys [id uid]} of root   signal, present in nested signals when tracing
 * `:ctx` --------- ?val of `*ctx*` (arb app-level state) when signal was created
 * 
 * `:host` -------- (Clj only) {:keys [name ip]}       info for network host
 * `:thread` ------ (Clj only) {:keys [name id group]} info for thread that created signal
 * 
 * `:sample` ------ Sample ?rate ∈ℝ[0,1] for combined call AND handler sampling (0.75 => allow 75% of signals, nil => allow all)
 * 
 * <kvs> ---------- Other arb app-level ?kvs given to signal creator. Typically NOT included
 *               in handler output, so a great way to provide custom data/opts for use
 *               (only) by custom transforms/handlers.
 * 
 * If anything is unclear, please ping me (@ptaoussanis) so that I can improve these docs!
 * 
 * [1] `java.time.Instant`   or `js/Date`
 * [2] `java.lang.Throwable` or `js/Error`
 */
taoensso.telemere.help_COLON_signal_content = "See docstring";

/**
 * Telemere supports extensive environmental config via JVM properties,
 * environment variables, or classpath resources.
 * 
 * Environmental filter config includes:
 * 
 *   1. Minimum level (see signal `:level`):
 *  a.       JVM property: `taoensso.telemere.rt-min-level`
 *  b.       Env variable: `TAOENSSO_TELEMERE_RT_MIN_LEVEL`
 *  c. Classpath resource: `taoensso.telemere.rt-min-level`
 * 
 *   2. Namespace filter (see signal `:ns`):
 *  a.       JVM property: `taoensso.telemere.rt-ns-filter`
 *  b.       Env variable: `TAOENSSO_TELEMERE_RT_NS_FILTER`
 *  c. Classpath resource: `taoensso.telemere.rt-ns-filter`
 * 
 *   3. Id filter (see signal `:id`):
 *  a.       JVM property: `taoensso.telemere.rt-id-filter`
 *  b.       Env variable: `TAOENSSO_TELEMERE_RT_ID_FILTER`
 *  c. Classpath resource: `taoensso.telemere.rt-id-filter`
 * 
 *   4. Kind filter (signal `:kind`):
 *  a.       JVM property: `taoensso.telemere.rt-kind-filter`
 *  b.       Env variable: `TAOENSSO_TELEMERE_RT_KIND_FILTER`
 *  c. Classpath resource: `taoensso.telemere.rt-kind-filter`
 * 
 * Config values are parsed as edn, examples:
 * 
 *   `taoensso.telemere.rt-min-level`       => ":info"
 *   `TAOENSSO_TELEMERE_RT_NS_FILTER`       => "{:disallow \"taoensso.*\"}"
 *   `taoensso.telemere.rt-id-filter.cljs`  => "#{:my-id1 :my-id2}"
 *   `TAOENSSO_TELEMERE_RT_KIND_FILTER_CLJ` => "nil"
 * 
 * Runtime vs compile-time filters
 * 
 *   The above filters (1..4) all apply at RUNTIME ("rt").
 *   This is typically what you want, since it allows you to freely adjust filtering
 *   (making it less OR MORE permissive) through later API calls like `set-min-level!`.
 * 
 *   As an advanced option, you can instead/additionally ELIDE (entirely omit) filtered
 *   callsites at COMPILE-TIME ("ct") by replacing "rt"->"ct" / "RT"->"CT" in the config
 *   ids above. Compile-time filters CANNOT be made MORE permissive at runtime.
 * 
 * Tips:
 * 
 *   - The above config ids will affect both Clj AND Cljs.
 *  For platform-specific filters, use
 *    ".clj"  / "_CLJ"  or
 *    ".cljs" / "_CLJS" suffixes instead.
 *    e.g. "taoensso.telemere.rt-min-level.cljs".
 * 
 *   - To get the right edn syntax, first set your runtime filters using the
 *  standard utils (`set-min-level!`, etc.). Then call `get-filters` and
 *  serialize the relevant parts to edn with `pr-str`.
 * 
 *   - All environmental config uses `get-env` underneath.
 *  See the `get-env` docstring for more/advanced details.
 * 
 *   - Classpath resources are files accessible on your project's
 *  classpath. This usually includes files in your project's
 *  `resources/` dir.
 */
taoensso.telemere.help_COLON_environmental_config = "See docstring";
/**
 * Experimental, subject to change. Feedback welcome!
 *   (fn [root?]) used to generate signal `:uid` values (unique instance ids)
 *   when tracing.
 * 
 *   Relevant only when `otel-tracing?` is false.
 *   If `otel-tracing?` is true, uids are instead generated by `*otel-tracer*`.
 * 
 *   `root?` argument is true iff signal is a top-level trace (i.e. form being
 *   traced is unnested = has no parent form). Root-level uids typically need
 *   more entropy and so are usually longer (e.g. 32 vs 16 hex chars).
 * 
 *   Override default by setting one of the following:
 *  1.       JVM property: `taoensso.telemere.uid-kind`
 *  2.       Env variable: `TAOENSSO_TELEMERE_UID_KIND`
 *  3. Classpath resource: `taoensso.telemere.uid-kind`
 * 
 *  Possible (compile-time) values include:
 *    `:uuid`          - UUID string (Cljs) or `java.util.UUID` (Clj)
 *    `:uuid-str`      - UUID string       (36/36 chars)
 *    `:nano/secure`   - nano-style string (21/10 chars) w/ strong RNG
 *    `:nano/insecure` - nano-style string (21/10 chars) w/ fast   RNG (default)
 *    `:hex/insecure`  - hex-style  string (32/16 chars) w/ strong RNG
 *    `:hex/secure`    - hex-style  string (32/16 chars) w/ fast   RNG
 */
taoensso.telemere._STAR_uid_fn_STAR_ = taoensso.telemere.utils.parse_uid_fn(taoensso.telemere.impl.uid_kind);
/**
 * Dispatches given signal to registered handlers, supports `with-signal/s`.
 *   Normally called automatically (internally) by signal creators, this util
 *   is provided publicly since it's also handy for manually re/dispatching
 *   custom/modified signals, etc.:
 * 
 *  (let [original-signal (with-signal :trap (event! ::my-id1))
 *        modified-signal (assoc original-signal :id ::my-id2)]
 *    (dispatch-signal! modified-signal))
 */
taoensso.telemere.dispatch_signal_BANG_ = (function taoensso$telemere$dispatch_signal_BANG_(signal){
var temp__5804__auto__ = taoensso.telemere.impl.wrap_signal(signal);
if(cljs.core.truth_(temp__5804__auto__)){
var wrapped_signal = temp__5804__auto__;
return taoensso.telemere.impl.dispatch_signal_BANG_(wrapped_signal);
} else {
return null;
}
});
/**
 * Alpha, subject to change.
 *   If `js/console` exists, returns a signal handler that:
 *     - Takes a Telemere signal (map).
 *     - Writes the signal as a string to JavaScript console.
 * 
 *   A general-purpose `println`-style handler that's well suited for outputting
 *   signals as human or machine-readable (edn, JSON) strings.
 * 
 *   Options:
 *     `:output-fn` - (fn [signal]) => string, see `format-signal-fn` or `pr-signal-fn`
 */
taoensso.telemere.handler_COLON_console = taoensso.telemere.consoles.handler_COLON_console;

/**
 * Alpha, subject to change.
 *   If `js/console` exists, returns a signal handler that:
 *     - Takes a Telemere signal (map).
 *     - Writes the raw signal to JavaScript console.
 * 
 *   Intended for use with browser formatting tools like `binaryage/devtools`,
 *   Ref. <https://github.com/binaryage/cljs-devtools>.
 * 
 *   Options:
 *     `:preamble-fn` ----- (fn [signal])   => string, see [1].
 *     `:format-nsecs-fn` - (fn [nanosecs]) => string.
 * 
 *   [1] `taoensso.telemere.utils/signal-preamble-fn`, etc.
 */
taoensso.telemere.handler_COLON_console_raw = taoensso.telemere.consoles.handler_COLON_console_raw;
if((typeof taoensso !== 'undefined') && (typeof taoensso.telemere !== 'undefined') && (typeof taoensso.telemere.__on_init !== 'undefined')){
} else {
taoensso.telemere.__on_init = (function (){
(taoensso.encore.signals._STAR_default_handler_error_fn_STAR_ = (function (p__18320){
var map__18321 = p__18320;
var map__18321__$1 = cljs.core.__destructure_map(map__18321);
var m = map__18321__$1;
var error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18321__$1,new cljs.core.Keyword(null,"error","error",-978969032));
return (function (){
var __run_fn_form = null;
var __kind = new cljs.core.Keyword(null,"error","error",-978969032);
var __ns = "taoensso.encore.signals";
var __id = new cljs.core.Keyword("taoensso.encore.signals","handler-error","taoensso.encore.signals/handler-error",1772750988);
var __level = new cljs.core.Keyword(null,"error","error",-978969032);
if(cljs.core.truth_((function (){var sf = taoensso.telemere.impl._STAR_rt_call_filter_STAR_;
if(cljs.core.truth_(sf)){
return (sf.cljs$core$IFn$_invoke$arity$4 ? sf.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"error","error",-978969032),__ns,__id,__level) : sf.call(null,new cljs.core.Keyword(null,"error","error",-978969032),__ns,__id,__level));
} else {
return true;
}
})())){
var __inst = (new Date());
var __thread = null;
var __root0 = taoensso.telemere.impl._STAR_trace_root_STAR_;
var __otel_context = null;
var __uid = null;
var __root1 = __root0;
var __run_result = null;
var signal__16897__auto__ = (new cljs.core.Delay((function (){

var signal__16888__auto__ = (new taoensso.telemere.impl.Signal((1),__inst,__uid,__ns,null,null,__kind,__id,__level,taoensso.telemere._STAR_ctx_STAR_,taoensso.telemere.impl._STAR_trace_parent_STAR_,__root1,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(m,new cljs.core.Keyword(null,"error","error",-978969032)),null,"Error executing wrapped handler fn",error,null,null,null,null,null,null,null));
var temp__5802__auto__ = taoensso.telemere._STAR_xfn_STAR_;
if(cljs.core.truth_(temp__5802__auto__)){
var xfn__16889__auto__ = temp__5802__auto__;
return (xfn__16889__auto__.cljs$core$IFn$_invoke$arity$1 ? xfn__16889__auto__.cljs$core$IFn$_invoke$arity$1(signal__16888__auto__) : xfn__16889__auto__.call(null,signal__16888__auto__));
} else {
return signal__16888__auto__;
}
}),null));
taoensso.telemere.impl.dispatch_signal_BANG_((new taoensso.telemere.impl.WrappedSignal(__kind,__ns,__id,__level,signal__16897__auto__)));

if(cljs.core.truth_(__run_result)){
return (__run_result.cljs$core$IFn$_invoke$arity$1 ? __run_result.cljs$core$IFn$_invoke$arity$1(signal__16897__auto__) : __run_result.call(null,signal__16897__auto__));
} else {
return true;
}
} else {
return null;
}
})();
}));

(taoensso.encore.signals._STAR_default_handler_backp_fn_STAR_ = (function (data){
return (function (){
var __run_fn_form = null;
var __kind = new cljs.core.Keyword(null,"event","event",301435442);
var __ns = "taoensso.encore.signals";
var __id = new cljs.core.Keyword("taoensso.encore.signals","handler-back-pressure","taoensso.encore.signals/handler-back-pressure",699164801);
var __level = new cljs.core.Keyword(null,"warn","warn",-436710552);
if(cljs.core.truth_((function (){var sf = taoensso.telemere.impl._STAR_rt_call_filter_STAR_;
if(cljs.core.truth_(sf)){
return (sf.cljs$core$IFn$_invoke$arity$4 ? sf.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"event","event",301435442),__ns,__id,__level) : sf.call(null,new cljs.core.Keyword(null,"event","event",301435442),__ns,__id,__level));
} else {
return true;
}
})())){
var __inst = (new Date());
var __thread = null;
var __root0 = taoensso.telemere.impl._STAR_trace_root_STAR_;
var __otel_context = null;
var __uid = null;
var __root1 = __root0;
var __run_result = null;
var signal__16897__auto__ = (new cljs.core.Delay((function (){

var signal__16888__auto__ = (new taoensso.telemere.impl.Signal((1),__inst,__uid,__ns,null,null,__kind,__id,__level,taoensso.telemere._STAR_ctx_STAR_,taoensso.telemere.impl._STAR_trace_parent_STAR_,__root1,data,null,"Back pressure on wrapped handler fn",null,null,null,null,null,null,null,null));
var temp__5802__auto__ = taoensso.telemere._STAR_xfn_STAR_;
if(cljs.core.truth_(temp__5802__auto__)){
var xfn__16889__auto__ = temp__5802__auto__;
return (xfn__16889__auto__.cljs$core$IFn$_invoke$arity$1 ? xfn__16889__auto__.cljs$core$IFn$_invoke$arity$1(signal__16888__auto__) : xfn__16889__auto__.call(null,signal__16888__auto__));
} else {
return signal__16888__auto__;
}
}),null));
taoensso.telemere.impl.dispatch_signal_BANG_((new taoensso.telemere.impl.WrappedSignal(__kind,__ns,__id,__level,signal__16897__auto__)));

if(cljs.core.truth_(__run_result)){
return (__run_result.cljs$core$IFn$_invoke$arity$1 ? __run_result.cljs$core$IFn$_invoke$arity$1(signal__16897__auto__) : __run_result.call(null,signal__16897__auto__));
} else {
return true;
}
} else {
return null;
}
})();
}));

taoensso.telemere.add_handler_BANG_.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword("default","console","default/console",-1389954628),(taoensso.telemere.handler_COLON_console.cljs$core$IFn$_invoke$arity$0 ? taoensso.telemere.handler_COLON_console.cljs$core$IFn$_invoke$arity$0() : taoensso.telemere.handler_COLON_console.call(null)),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"async","async",1050769601),null], null));

return null;
})()

;
}

//# sourceMappingURL=taoensso.telemere.js.map
