goog.provide('atlas.ontology');
/**
 * Return all registered ontologies from the registry.
 */
atlas.ontology.all_ontologies = (function atlas$ontology$all_ontologies(){
return atlas.query.find_by_aspect(cljs.core.deref(atlas.registry.registry),new cljs.core.Keyword("atlas","ontology","atlas/ontology",1061198866));
});
/**
 * Return the ontology definition for a given entity type from the registry.
 * Returns nil if not found.
 */
atlas.ontology.ontology_for = (function atlas$ontology$ontology_for(entity_type){
var results = atlas.query.find_by_aspect(cljs.core.deref(atlas.registry.registry),cljs.core.PersistentHashSet.createAsIfByAssoc([entity_type,new cljs.core.Keyword("atlas","ontology","atlas/ontology",1061198866)]));
if(cljs.core.seq(results)){
return cljs.core.val(cljs.core.first(results));
} else {
return null;
}
});
/**
 * Return the ontology keys for a given entity type from the registry.
 */
atlas.ontology.ontology_keys_for = (function atlas$ontology$ontology_keys_for(entity_type){
return new cljs.core.Keyword("ontology","keys","ontology/keys",-1327766367).cljs$core$IFn$_invoke$arity$1(atlas.ontology.ontology_for(entity_type));
});
atlas.ontology.common_registry_keys = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553)], null);
/**
 * Return registry definition for a semantic-namespace aspect.
 * Queries from the registry (requires register-ontologies! to be called first).
 */
atlas.ontology.registry_definition_for = (function atlas$ontology$registry_definition_for(aspect){
var temp__5804__auto__ = atlas.ontology.ontology_for(aspect);
if(cljs.core.truth_(temp__5804__auto__)){
var ont = temp__5804__auto__;
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("registry-definition","for","registry-definition/for",1558304918),new cljs.core.Keyword("ontology","for","ontology/for",587704578).cljs$core$IFn$_invoke$arity$1(ont),new cljs.core.Keyword("registry-definition","keys","registry-definition/keys",-1425656523),new cljs.core.Keyword("ontology","keys","ontology/keys",-1327766367).cljs$core$IFn$_invoke$arity$1(ont)], null);
} else {
return null;
}
});
atlas.ontology.ordered_distinct = (function atlas$ontology$ordered_distinct(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,item){
if(cljs.core.truth_(cljs.core.some(cljs.core.PersistentHashSet.createAsIfByAssoc([item]),acc))){
return acc;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,item);
}
}),cljs.core.PersistentVector.EMPTY,coll);
});
/**
 * Return ordered definition keys for a compound identity set.
 * Queries from the registry (requires register-ontologies! to be called first).
 */
atlas.ontology.definition_keys_for_identity = (function atlas$ontology$definition_keys_for_identity(identity){
var entity_types = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__18555_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("atlas",cljs.core.namespace(p1__18555_SHARP_));
}),identity);
var ontologies = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(atlas.ontology.ontology_for,entity_types);
var keys = atlas.ontology.ordered_distinct(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(atlas.ontology.common_registry_keys,cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword("ontology","keys","ontology/keys",-1327766367),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ontologies], 0))));
if(cljs.core.seq(ontologies)){
return cljs.core.vec(keys);
} else {
return null;
}
});
/**
 * Show all aspects with usage stats and examples
 */
atlas.ontology.aspect_catalog = (function atlas$ontology$aspect_catalog(){
var freq = atlas.query.aspect_frequency(cljs.core.deref(atlas.registry.registry));
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core.group_by((function (p1__18560_SHARP_){
return cljs.core.namespace(new cljs.core.Keyword(null,"aspect","aspect",-839905246).cljs$core$IFn$_invoke$arity$1(p1__18560_SHARP_));
}),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__18561){
var vec__18562 = p__18561;
var aspect = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18562,(0),null);
var count = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18562,(1),null);
var examples = cljs.core.take.cljs$core$IFn$_invoke$arity$2((2),cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__18558_SHARP_){
return cljs.core.contains_QMARK_(p1__18558_SHARP_,aspect);
}),atlas.query.all_identities(cljs.core.deref(atlas.registry.registry))));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"aspect","aspect",-839905246),aspect,new cljs.core.Keyword(null,"usage-count","usage-count",1415906153),count,new cljs.core.Keyword(null,"examples","examples",-473712556),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__18559_SHARP_){
return new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553).cljs$core$IFn$_invoke$arity$1(atlas.registry.fetch(p1__18559_SHARP_));
}),examples)], null);
}),freq)));
});
/**
 * Given partial identity, suggest aspects based on similar entries
 */
atlas.ontology.suggest_aspects = (function atlas$ontology$suggest_aspects(partial_identity){
var similar = atlas.query.semantic_similarity.cljs$core$IFn$_invoke$arity$3(cljs.core.deref(atlas.registry.registry),partial_identity,0.0);
var all_aspects = cljs.core.take.cljs$core$IFn$_invoke$arity$2((10),cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(cljs.core.val,cljs.core._GT_,cljs.core.remove.cljs$core$IFn$_invoke$arity$2((function (p__18565){
var vec__18566 = p__18565;
var asp = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18566,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18566,(1),null);
return cljs.core.contains_QMARK_(partial_identity,asp);
}),cljs.core.frequencies(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"identity","identity",1647396035),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.take.cljs$core$IFn$_invoke$arity$2((5),similar)], 0))))));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"similar-entries","similar-entries",-819596189),cljs.core.take.cljs$core$IFn$_invoke$arity$2((3),cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"identity","identity",1647396035),similar)),new cljs.core.Keyword(null,"suggested-aspects","suggested-aspects",1869000002),cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,all_aspects),new cljs.core.Keyword(null,"rationale","rationale",-827383118),"Based on 5 most similar entries"], null);
});
/**
 * Analyze what would be affected by changes to an aspect
 */
atlas.ontology.impact_analysis = (function atlas$ontology$impact_analysis(aspect){
var direct_users = atlas.query.find_by_aspect(cljs.core.deref(atlas.registry.registry),aspect);
var by_tier = cljs.core.group_by((function (p__18569){
var vec__18570 = p__18569;
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18570,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18570,(1),null);
if(cljs.core.contains_QMARK_(id,new cljs.core.Keyword("tier","foundation","tier/foundation",-1943771629))){
return new cljs.core.Keyword(null,"foundation","foundation",-1947354115);
} else {
if(cljs.core.contains_QMARK_(id,new cljs.core.Keyword("tier","service","tier/service",-1966897213))){
return new cljs.core.Keyword(null,"service","service",-1963054559);
} else {
if(cljs.core.contains_QMARK_(id,new cljs.core.Keyword("tier","feature","tier/feature",26630782))){
return new cljs.core.Keyword(null,"feature","feature",27242652);
} else {
if(cljs.core.contains_QMARK_(id,new cljs.core.Keyword("tier","api","tier/api",-897042558))){
return new cljs.core.Keyword(null,"api","api",-899839580);
} else {
return new cljs.core.Keyword(null,"other","other",995793544);

}
}
}
}
}),direct_users);
var by_type = cljs.core.group_by((function (p__18577){
var vec__18578 = p__18577;
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18578,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18578,(1),null);
if(cljs.core.contains_QMARK_(id,new cljs.core.Keyword("atlas","structure-component","atlas/structure-component",-156450702))){
return new cljs.core.Keyword(null,"component","component",1555936782);
} else {
if(cljs.core.contains_QMARK_(id,new cljs.core.Keyword("atlas","execution-function","atlas/execution-function",-633620662))){
return new cljs.core.Keyword(null,"function","function",-2127255473);
} else {
if(cljs.core.contains_QMARK_(id,new cljs.core.Keyword("atlas","interface-endpoint","atlas/interface-endpoint",162094344))){
return new cljs.core.Keyword(null,"endpoint","endpoint",447890044);
} else {
if(cljs.core.contains_QMARK_(id,new cljs.core.Keyword("semantic-namespace","error-handler","semantic-namespace/error-handler",848160348))){
return new cljs.core.Keyword(null,"error-handler","error-handler",-484945776);
} else {
if(cljs.core.contains_QMARK_(id,new cljs.core.Keyword("semantic-namespace","architectural-decision","semantic-namespace/architectural-decision",-1719334219))){
return new cljs.core.Keyword(null,"decision","decision",820953053);
} else {
return new cljs.core.Keyword(null,"other","other",995793544);

}
}
}
}
}
}),direct_users);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"aspect","aspect",-839905246),aspect,new cljs.core.Keyword(null,"total-impact","total-impact",2005519673),cljs.core.count(direct_users),new cljs.core.Keyword(null,"by-tier","by-tier",-1284724502),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__18581){
var vec__18582 = p__18581;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18582,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18582,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,cljs.core.count(v)], null);
}),by_tier)),new cljs.core.Keyword(null,"by-type","by-type",460217689),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__18585){
var vec__18586 = p__18585;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18586,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18586,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,cljs.core.count(v)], null);
}),by_type)),new cljs.core.Keyword(null,"examples","examples",-473712556),cljs.core.take.cljs$core$IFn$_invoke$arity$2((3),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__18589){
var vec__18590 = p__18589;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18590,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18590,(1),null);
return new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553).cljs$core$IFn$_invoke$arity$1(v);
}),direct_users))], null);
});
atlas.ontology.default_dataflow_keys = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("dataflow","context-key","dataflow/context-key",1447079710),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword("dataflow","response-key","dataflow/response-key",-166451182),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword("dataflow","deps-key","dataflow/deps-key",-45730480),cljs.core.PersistentVector.EMPTY], null);
/**
 * Find all dataflow keys of given type from registered ontologies.
 * key-type is one of: :dataflow/context-key, :dataflow/response-key, :dataflow/deps-key
 * Merges defaults with ontology-defined keys.
 */
atlas.ontology.dataflow_keys = (function atlas$ontology$dataflow_keys(key_type){
var from_ontologies = cljs.core.vec(cljs.core.keep.cljs$core$IFn$_invoke$arity$2((function (p__18593){
var vec__18594 = p__18593;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18594,(0),null);
var ont = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18594,(1),null);
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(ont,key_type);
}),atlas.ontology.all_ontologies()));
var defaults = cljs.core.get.cljs$core$IFn$_invoke$arity$3(atlas.ontology.default_dataflow_keys,key_type,cljs.core.PersistentVector.EMPTY);
return cljs.core.vec(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(defaults,from_ontologies)));
});
atlas.ontology.first_present = (function atlas$ontology$first_present(props,keys){
return cljs.core.some((function (k){
if(cljs.core.contains_QMARK_(props,k)){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(props,k);
} else {
return null;
}
}),keys);
});
atlas.ontology.deps_for = (function atlas$ontology$deps_for(dev_id){
var deps_keys = atlas.ontology.dataflow_keys(new cljs.core.Keyword("dataflow","deps-key","dataflow/deps-key",-45730480));
var deps = atlas.ontology.first_present(atlas.registry.lookup.props_for(dev_id),deps_keys);
if(cljs.core.set_QMARK_(deps)){
return deps;
} else {
if(cljs.core.coll_QMARK_(deps)){
return cljs.core.set(deps);
} else {
return cljs.core.PersistentHashSet.EMPTY;

}
}
});
atlas.ontology.context_for = (function atlas$ontology$context_for(dev_id){
var context_keys = atlas.ontology.dataflow_keys(new cljs.core.Keyword("dataflow","context-key","dataflow/context-key",1447079710));
var or__5002__auto__ = atlas.ontology.first_present(atlas.registry.lookup.props_for(dev_id),context_keys);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
});
atlas.ontology.response_for = (function atlas$ontology$response_for(dev_id){
var response_keys = atlas.ontology.dataflow_keys(new cljs.core.Keyword("dataflow","response-key","dataflow/response-key",-166451182));
var or__5002__auto__ = atlas.ontology.first_present(atlas.registry.lookup.props_for(dev_id),response_keys);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
});
/**
 * Trace what produces each context key for a given entity.
 * 
 * Queries ontologies for :dataflow/response-key to find which response keys
 * from other entities can satisfy context requirements.
 * 
 * Returns a sequence of maps:
 *   {:needs <key>
 *    :produced-by [<dev-ids>]
 *    :satisfied? <boolean>}
 */
atlas.ontology.trace_data_flow = (function atlas$ontology$trace_data_flow(dev_id){
var context = atlas.ontology.context_for(dev_id);
var response_keys = atlas.ontology.dataflow_keys(new cljs.core.Keyword("dataflow","response-key","dataflow/response-key",-166451182));
var iter__5480__auto__ = (function atlas$ontology$trace_data_flow_$_iter__18609(s__18610){
return (new cljs.core.LazySeq(null,(function (){
var s__18610__$1 = s__18610;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__18610__$1);
if(temp__5804__auto__){
var s__18610__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__18610__$2)){
var c__5478__auto__ = cljs.core.chunk_first(s__18610__$2);
var size__5479__auto__ = cljs.core.count(c__5478__auto__);
var b__18612 = cljs.core.chunk_buffer(size__5479__auto__);
if((function (){var i__18611 = (0);
while(true){
if((i__18611 < size__5479__auto__)){
var ctx_key = cljs.core._nth(c__5478__auto__,i__18611);
var producers_map = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (i__18611,ctx_key,c__5478__auto__,size__5479__auto__,b__18612,s__18610__$2,temp__5804__auto__,context,response_keys){
return (function (acc,key){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([acc,atlas.query.find_producers(cljs.core.deref(atlas.registry.registry),ctx_key,key)], 0));
});})(i__18611,ctx_key,c__5478__auto__,size__5479__auto__,b__18612,s__18610__$2,temp__5804__auto__,context,response_keys))
,cljs.core.PersistentArrayMap.EMPTY,response_keys);
var function_producers = atlas.query.find_by_aspect(cljs.core.deref(atlas.registry.registry),new cljs.core.Keyword("atlas","execution-function","atlas/execution-function",-633620662));
var producer_ids = cljs.core.vec(cljs.core.keep.cljs$core$IFn$_invoke$arity$2(((function (i__18611,producers_map,function_producers,ctx_key,c__5478__auto__,size__5479__auto__,b__18612,s__18610__$2,temp__5804__auto__,context,response_keys){
return (function (p__18617){
var vec__18618 = p__18617;
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18618,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18618,(1),null);
if(cljs.core.contains_QMARK_(function_producers,id)){
return new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553).cljs$core$IFn$_invoke$arity$1(v);
} else {
return null;
}
});})(i__18611,producers_map,function_producers,ctx_key,c__5478__auto__,size__5479__auto__,b__18612,s__18610__$2,temp__5804__auto__,context,response_keys))
,producers_map));
cljs.core.chunk_append(b__18612,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"needs","needs",-1096089118),ctx_key,new cljs.core.Keyword(null,"produced-by","produced-by",2084695420),producer_ids,new cljs.core.Keyword(null,"satisfied?","satisfied?",266861175),cljs.core.seq(producer_ids)], null));

var G__18951 = (i__18611 + (1));
i__18611 = G__18951;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__18612),atlas$ontology$trace_data_flow_$_iter__18609(cljs.core.chunk_rest(s__18610__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__18612),null);
}
} else {
var ctx_key = cljs.core.first(s__18610__$2);
var producers_map = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (ctx_key,s__18610__$2,temp__5804__auto__,context,response_keys){
return (function (acc,key){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([acc,atlas.query.find_producers(cljs.core.deref(atlas.registry.registry),ctx_key,key)], 0));
});})(ctx_key,s__18610__$2,temp__5804__auto__,context,response_keys))
,cljs.core.PersistentArrayMap.EMPTY,response_keys);
var function_producers = atlas.query.find_by_aspect(cljs.core.deref(atlas.registry.registry),new cljs.core.Keyword("atlas","execution-function","atlas/execution-function",-633620662));
var producer_ids = cljs.core.vec(cljs.core.keep.cljs$core$IFn$_invoke$arity$2(((function (producers_map,function_producers,ctx_key,s__18610__$2,temp__5804__auto__,context,response_keys){
return (function (p__18621){
var vec__18629 = p__18621;
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18629,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18629,(1),null);
if(cljs.core.contains_QMARK_(function_producers,id)){
return new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553).cljs$core$IFn$_invoke$arity$1(v);
} else {
return null;
}
});})(producers_map,function_producers,ctx_key,s__18610__$2,temp__5804__auto__,context,response_keys))
,producers_map));
return cljs.core.cons(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"needs","needs",-1096089118),ctx_key,new cljs.core.Keyword(null,"produced-by","produced-by",2084695420),producer_ids,new cljs.core.Keyword(null,"satisfied?","satisfied?",266861175),cljs.core.seq(producer_ids)], null),atlas$ontology$trace_data_flow_$_iter__18609(cljs.core.rest(s__18610__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5480__auto__(context);
});
/**
 * Compute dependencies based on context/response data flow.
 * 
 * Finds all entities whose response keys can satisfy the context
 * requirements of the given entity.
 * 
 * Returns a set of dev-ids that produce data consumed by dev-id.
 */
atlas.ontology.compute_data_deps = (function atlas$ontology$compute_data_deps(dev_id){
var context = cljs.core.set(atlas.ontology.context_for(dev_id));
var all_fns = atlas.registry.lookup.all_with_aspect(new cljs.core.Keyword("atlas","execution-function","atlas/execution-function",-633620662));
var response_keys = atlas.ontology.dataflow_keys(new cljs.core.Keyword("dataflow","response-key","dataflow/response-key",-166451182));
return cljs.core.set(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((function (ctx_key){
var producers = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([acc,atlas.query.find_producers(cljs.core.deref(atlas.registry.registry),ctx_key,key)], 0));
}),cljs.core.PersistentArrayMap.EMPTY,response_keys);
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(all_fns,cljs.core.keep.cljs$core$IFn$_invoke$arity$2((function (p__18633){
var vec__18634 = p__18633;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18634,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18634,(1),null);
return new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553).cljs$core$IFn$_invoke$arity$1(v);
}),producers));
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([context], 0)));
});
/**
 * Check if identity is valid before registering
 */
atlas.ontology.validate_before_register = (function atlas$ontology$validate_before_register(new_identity){
var issues = cljs.core.PersistentVector.EMPTY;
var symmetric_diff = (function (a,b){
return clojure.set.union.cljs$core$IFn$_invoke$arity$2(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(a,b),clojure.set.difference.cljs$core$IFn$_invoke$arity$2(b,a));
});
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(issues,((cljs.core.contains_QMARK_(cljs.core.deref(atlas.registry.registry),new_identity))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"level","level",1290497552),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"collision","collision",-201625508),new cljs.core.Keyword(null,"message","message",-406056002),"Identity already exists",new cljs.core.Keyword(null,"existing-dev-id","existing-dev-id",-150972560),new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553).cljs$core$IFn$_invoke$arity$1(atlas.registry.fetch(new_identity))], null)], null):null)),cljs.core.keep.cljs$core$IFn$_invoke$arity$2((function (existing_id){
var diff = symmetric_diff(new_identity,existing_id);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),cljs.core.count(diff))){
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"level","level",1290497552),new cljs.core.Keyword(null,"warning","warning",-1685650671),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"near-collision","near-collision",1237437824),new cljs.core.Keyword(null,"message","message",-406056002),"Differs by only one aspect from existing",new cljs.core.Keyword(null,"existing-dev-id","existing-dev-id",-150972560),new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553).cljs$core$IFn$_invoke$arity$1(atlas.registry.fetch(existing_id)),new cljs.core.Keyword(null,"difference","difference",1916101396),diff], null);
} else {
return null;
}
}),cljs.core.take.cljs$core$IFn$_invoke$arity$2((100),atlas.query.all_identities(cljs.core.deref(atlas.registry.registry))))),((((cljs.core.contains_QMARK_(new_identity,new cljs.core.Keyword("integration","external","integration/external",-577047833))) && ((!(cljs.core.contains_QMARK_(new_identity,new cljs.core.Keyword("temporal","async","temporal/async",484752867)))))))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"level","level",1290497552),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"invariant-violation","invariant-violation",1251360106),new cljs.core.Keyword(null,"message","message",-406056002),"External integrations must be async"], null)], null):null)),((((cljs.core.contains_QMARK_(new_identity,new cljs.core.Keyword("compliance","pii","compliance/pii",-811893690))) && ((!(cljs.core.contains_QMARK_(new_identity,new cljs.core.Keyword("compliance","audited","compliance/audited",-598614598)))))))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"level","level",1290497552),new cljs.core.Keyword(null,"warning","warning",-1685650671),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"compliance-gap","compliance-gap",-2032547041),new cljs.core.Keyword(null,"message","message",-406056002),"PII handling should be audited"], null)], null):null));
});
/**
 * Fluent query builder
 */
atlas.ontology.where__GT_ = (function atlas$ontology$where__GT_(initial_aspects){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"aspects","aspects",1981182909),((cljs.core.set_QMARK_(initial_aspects))?initial_aspects:cljs.core.PersistentHashSet.createAsIfByAssoc([initial_aspects])),new cljs.core.Keyword(null,"ops","ops",1237330063),cljs.core.PersistentVector.EMPTY], null);
});
atlas.ontology.with_aspect = (function atlas$ontology$with_aspect(query,aspect){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(query,new cljs.core.Keyword(null,"aspects","aspects",1981182909),cljs.core.conj,aspect);
});
atlas.ontology.without_aspect = (function atlas$ontology$without_aspect(query,aspect){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(query,new cljs.core.Keyword(null,"ops","ops",1237330063),cljs.core.conj,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"exclude","exclude",-1230250334),aspect], null));
});
atlas.ontology.in_tier = (function atlas$ontology$in_tier(query,tier){
return atlas.ontology.with_aspect(query,tier);
});
atlas.ontology.execute_query = (function atlas$ontology$execute_query(query){
var map__18681 = query;
var map__18681__$1 = cljs.core.__destructure_map(map__18681);
var aspects = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18681__$1,new cljs.core.Keyword(null,"aspects","aspects",1981182909));
var ops = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18681__$1,new cljs.core.Keyword(null,"ops","ops",1237330063));
var base_results = atlas.query.find_by_aspect(cljs.core.deref(atlas.registry.registry),aspects);
var filtered = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (results,p__18684){
var vec__18685 = p__18684;
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18685,(0),null);
var arg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18685,(1),null);
var G__18693 = op;
var G__18693__$1 = (((G__18693 instanceof cljs.core.Keyword))?G__18693.fqn:null);
switch (G__18693__$1) {
case "exclude":
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.remove.cljs$core$IFn$_invoke$arity$2((function (p__18694){
var vec__18695 = p__18694;
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18695,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18695,(1),null);
return cljs.core.contains_QMARK_(id,arg);
}),results));

break;
default:
return results;

}
}),base_results,ops);
return cljs.core.keys(filtered);
});
/**
 * Safely rename/replace an aspect across the registry
 */
atlas.ontology.refactor_aspect = (function atlas$ontology$refactor_aspect(var_args){
var args__5732__auto__ = [];
var len__5726__auto___18958 = arguments.length;
var i__5727__auto___18959 = (0);
while(true){
if((i__5727__auto___18959 < len__5726__auto___18958)){
args__5732__auto__.push((arguments[i__5727__auto___18959]));

var G__18960 = (i__5727__auto___18959 + (1));
i__5727__auto___18959 = G__18960;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((2) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((2)),(0),null)):null);
return atlas.ontology.refactor_aspect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5733__auto__);
});

(atlas.ontology.refactor_aspect.cljs$core$IFn$_invoke$arity$variadic = (function (old_aspect,new_aspect,p__18705){
var map__18706 = p__18705;
var map__18706__$1 = cljs.core.__destructure_map(map__18706);
var dry_run_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__18706__$1,new cljs.core.Keyword(null,"dry-run?","dry-run?",711274832),true);
var affected = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__18698_SHARP_){
return cljs.core.contains_QMARK_(p1__18698_SHARP_,old_aspect);
}),atlas.query.all_identities(cljs.core.deref(atlas.registry.registry)));
var migrations = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (old_id){
var new_id = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.disj.cljs$core$IFn$_invoke$arity$2(old_id,old_aspect),new_aspect);
var value = atlas.registry.fetch(old_id);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"old-id","old-id",-512581150),old_id,new cljs.core.Keyword(null,"new-id","new-id",638836512),new_id,new cljs.core.Keyword(null,"dev-id","dev-id",1928680092),new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553).cljs$core$IFn$_invoke$arity$1(value),new cljs.core.Keyword(null,"will-collide?","will-collide?",-1259661302),cljs.core.contains_QMARK_(cljs.core.deref(atlas.registry.registry),new_id)], null);
}),affected);
if(cljs.core.truth_(dry_run_QMARK_)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"dry-run","dry-run",-1102788647),true,new cljs.core.Keyword(null,"affected-count","affected-count",-1284666193),cljs.core.count(migrations),new cljs.core.Keyword(null,"migrations","migrations",1963762970),migrations,new cljs.core.Keyword(null,"conflicts","conflicts",-1219561816),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"will-collide?","will-collide?",-1259661302),migrations)], null);
} else {
var seq__18708_18967 = cljs.core.seq(migrations);
var chunk__18710_18968 = null;
var count__18711_18969 = (0);
var i__18712_18970 = (0);
while(true){
if((i__18712_18970 < count__18711_18969)){
var map__18731_18971 = chunk__18710_18968.cljs$core$IIndexed$_nth$arity$2(null,i__18712_18970);
var map__18731_18972__$1 = cljs.core.__destructure_map(map__18731_18971);
var old_id_18973 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18731_18972__$1,new cljs.core.Keyword(null,"old-id","old-id",-512581150));
var new_id_18974 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18731_18972__$1,new cljs.core.Keyword(null,"new-id","new-id",638836512));
if(cljs.core.not(new cljs.core.Keyword(null,"will-collide?","will-collide?",-1259661302).cljs$core$IFn$_invoke$arity$1(cljs.core.first(migrations)))){
var value_18975 = atlas.registry.fetch(old_id_18973);
atlas.registry.remove(old_id_18973);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(atlas.registry.registry,cljs.core.assoc,new_id_18974,value_18975);


var G__18976 = seq__18708_18967;
var G__18977 = chunk__18710_18968;
var G__18978 = count__18711_18969;
var G__18979 = (i__18712_18970 + (1));
seq__18708_18967 = G__18976;
chunk__18710_18968 = G__18977;
count__18711_18969 = G__18978;
i__18712_18970 = G__18979;
continue;
} else {
var G__18980 = seq__18708_18967;
var G__18981 = chunk__18710_18968;
var G__18982 = count__18711_18969;
var G__18983 = (i__18712_18970 + (1));
seq__18708_18967 = G__18980;
chunk__18710_18968 = G__18981;
count__18711_18969 = G__18982;
i__18712_18970 = G__18983;
continue;
}
} else {
var temp__5804__auto___18984 = cljs.core.seq(seq__18708_18967);
if(temp__5804__auto___18984){
var seq__18708_18985__$1 = temp__5804__auto___18984;
if(cljs.core.chunked_seq_QMARK_(seq__18708_18985__$1)){
var c__5525__auto___18986 = cljs.core.chunk_first(seq__18708_18985__$1);
var G__18987 = cljs.core.chunk_rest(seq__18708_18985__$1);
var G__18988 = c__5525__auto___18986;
var G__18989 = cljs.core.count(c__5525__auto___18986);
var G__18990 = (0);
seq__18708_18967 = G__18987;
chunk__18710_18968 = G__18988;
count__18711_18969 = G__18989;
i__18712_18970 = G__18990;
continue;
} else {
var map__18735_18991 = cljs.core.first(seq__18708_18985__$1);
var map__18735_18992__$1 = cljs.core.__destructure_map(map__18735_18991);
var old_id_18993 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18735_18992__$1,new cljs.core.Keyword(null,"old-id","old-id",-512581150));
var new_id_18994 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18735_18992__$1,new cljs.core.Keyword(null,"new-id","new-id",638836512));
if(cljs.core.not(new cljs.core.Keyword(null,"will-collide?","will-collide?",-1259661302).cljs$core$IFn$_invoke$arity$1(cljs.core.first(migrations)))){
var value_18999 = atlas.registry.fetch(old_id_18993);
atlas.registry.remove(old_id_18993);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(atlas.registry.registry,cljs.core.assoc,new_id_18994,value_18999);


var G__19000 = cljs.core.next(seq__18708_18985__$1);
var G__19001 = null;
var G__19002 = (0);
var G__19003 = (0);
seq__18708_18967 = G__19000;
chunk__18710_18968 = G__19001;
count__18711_18969 = G__19002;
i__18712_18970 = G__19003;
continue;
} else {
var G__19004 = cljs.core.next(seq__18708_18985__$1);
var G__19005 = null;
var G__19006 = (0);
var G__19007 = (0);
seq__18708_18967 = G__19004;
chunk__18710_18968 = G__19005;
count__18711_18969 = G__19006;
i__18712_18970 = G__19007;
continue;
}
}
} else {
}
}
break;
}

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"migrated","migrated",2004898985),cljs.core.count(migrations)], null);
}
}));

(atlas.ontology.refactor_aspect.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(atlas.ontology.refactor_aspect.cljs$lang$applyTo = (function (seq18700){
var G__18701 = cljs.core.first(seq18700);
var seq18700__$1 = cljs.core.next(seq18700);
var G__18702 = cljs.core.first(seq18700__$1);
var seq18700__$2 = cljs.core.next(seq18700__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18701,G__18702,seq18700__$2);
}));

/**
 * Generate markdown documentation of the ontology
 */
atlas.ontology.generate_ontology_docs = (function atlas$ontology$generate_ontology_docs(){
var catalog = atlas.ontology.aspect_catalog();
var by_category = cljs.core.group_by((function (p__18746){
var vec__18747 = p__18746;
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18747,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18747,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,"tier")){
return "Architecture Layers";
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,"domain")){
return "Business Domains";
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,"operation")){
return "Operations";
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,"compliance")){
return "Compliance";
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,"temporal")){
return "Temporal Concerns";
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,"observability")){
return "Observability";
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,"integration")){
return "Integration";
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,"protocol")){
return "Protocols";
} else {
return "Other";

}
}
}
}
}
}
}
}
}),catalog);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.str,"# Semantic Ontology Documentation\n\n","Generated from live registry.\n\n",(function (){var iter__5480__auto__ = (function atlas$ontology$generate_ontology_docs_$_iter__18766(s__18767){
return (new cljs.core.LazySeq(null,(function (){
var s__18767__$1 = s__18767;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__18767__$1);
if(temp__5804__auto__){
var s__18767__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__18767__$2)){
var c__5478__auto__ = cljs.core.chunk_first(s__18767__$2);
var size__5479__auto__ = cljs.core.count(c__5478__auto__);
var b__18769 = cljs.core.chunk_buffer(size__5479__auto__);
if((function (){var i__18768 = (0);
while(true){
if((i__18768 < size__5479__auto__)){
var vec__18783 = cljs.core._nth(c__5478__auto__,i__18768);
var category = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18783,(0),null);
var aspects = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18783,(1),null);
cljs.core.chunk_append(b__18769,["## ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(category),"\n\n",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,(function (){var iter__5480__auto__ = ((function (i__18768,vec__18783,category,aspects,c__5478__auto__,size__5479__auto__,b__18769,s__18767__$2,temp__5804__auto__,catalog,by_category){
return (function atlas$ontology$generate_ontology_docs_$_iter__18766_$_iter__18803(s__18804){
return (new cljs.core.LazySeq(null,((function (i__18768,vec__18783,category,aspects,c__5478__auto__,size__5479__auto__,b__18769,s__18767__$2,temp__5804__auto__,catalog,by_category){
return (function (){
var s__18804__$1 = s__18804;
while(true){
var temp__5804__auto____$1 = cljs.core.seq(s__18804__$1);
if(temp__5804__auto____$1){
var xs__6360__auto__ = temp__5804__auto____$1;
var vec__18885 = cljs.core.first(xs__6360__auto__);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18885,(0),null);
var aspect_list = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18885,(1),null);
var iterys__5476__auto__ = ((function (s__18804__$1,i__18768,vec__18885,_,aspect_list,xs__6360__auto__,temp__5804__auto____$1,vec__18783,category,aspects,c__5478__auto__,size__5479__auto__,b__18769,s__18767__$2,temp__5804__auto__,catalog,by_category){
return (function atlas$ontology$generate_ontology_docs_$_iter__18766_$_iter__18803_$_iter__18880(s__18881){
return (new cljs.core.LazySeq(null,((function (s__18804__$1,i__18768,vec__18885,_,aspect_list,xs__6360__auto__,temp__5804__auto____$1,vec__18783,category,aspects,c__5478__auto__,size__5479__auto__,b__18769,s__18767__$2,temp__5804__auto__,catalog,by_category){
return (function (){
var s__18881__$1 = s__18881;
while(true){
var temp__5804__auto____$2 = cljs.core.seq(s__18881__$1);
if(temp__5804__auto____$2){
var s__18881__$2 = temp__5804__auto____$2;
if(cljs.core.chunked_seq_QMARK_(s__18881__$2)){
var c__5478__auto____$1 = cljs.core.chunk_first(s__18881__$2);
var size__5479__auto____$1 = cljs.core.count(c__5478__auto____$1);
var b__18883 = cljs.core.chunk_buffer(size__5479__auto____$1);
if((function (){var i__18882 = (0);
while(true){
if((i__18882 < size__5479__auto____$1)){
var map__18888 = cljs.core._nth(c__5478__auto____$1,i__18882);
var map__18888__$1 = cljs.core.__destructure_map(map__18888);
var aspect = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18888__$1,new cljs.core.Keyword(null,"aspect","aspect",-839905246));
var usage_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18888__$1,new cljs.core.Keyword(null,"usage-count","usage-count",1415906153));
var examples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18888__$1,new cljs.core.Keyword(null,"examples","examples",-473712556));
cljs.core.chunk_append(b__18883,["### ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(aspect),"\n","- **Usage**: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(usage_count)," entries\n","- **Examples**: ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(", ",examples),"\n\n"].join(''));

var G__19012 = (i__18882 + (1));
i__18882 = G__19012;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__18883),atlas$ontology$generate_ontology_docs_$_iter__18766_$_iter__18803_$_iter__18880(cljs.core.chunk_rest(s__18881__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__18883),null);
}
} else {
var map__18890 = cljs.core.first(s__18881__$2);
var map__18890__$1 = cljs.core.__destructure_map(map__18890);
var aspect = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18890__$1,new cljs.core.Keyword(null,"aspect","aspect",-839905246));
var usage_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18890__$1,new cljs.core.Keyword(null,"usage-count","usage-count",1415906153));
var examples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18890__$1,new cljs.core.Keyword(null,"examples","examples",-473712556));
return cljs.core.cons(["### ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(aspect),"\n","- **Usage**: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(usage_count)," entries\n","- **Examples**: ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(", ",examples),"\n\n"].join(''),atlas$ontology$generate_ontology_docs_$_iter__18766_$_iter__18803_$_iter__18880(cljs.core.rest(s__18881__$2)));
}
} else {
return null;
}
break;
}
});})(s__18804__$1,i__18768,vec__18885,_,aspect_list,xs__6360__auto__,temp__5804__auto____$1,vec__18783,category,aspects,c__5478__auto__,size__5479__auto__,b__18769,s__18767__$2,temp__5804__auto__,catalog,by_category))
,null,null));
});})(s__18804__$1,i__18768,vec__18885,_,aspect_list,xs__6360__auto__,temp__5804__auto____$1,vec__18783,category,aspects,c__5478__auto__,size__5479__auto__,b__18769,s__18767__$2,temp__5804__auto__,catalog,by_category))
;
var fs__5477__auto__ = cljs.core.seq(iterys__5476__auto__(aspect_list));
if(fs__5477__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__5477__auto__,atlas$ontology$generate_ontology_docs_$_iter__18766_$_iter__18803(cljs.core.rest(s__18804__$1)));
} else {
var G__19013 = cljs.core.rest(s__18804__$1);
s__18804__$1 = G__19013;
continue;
}
} else {
return null;
}
break;
}
});})(i__18768,vec__18783,category,aspects,c__5478__auto__,size__5479__auto__,b__18769,s__18767__$2,temp__5804__auto__,catalog,by_category))
,null,null));
});})(i__18768,vec__18783,category,aspects,c__5478__auto__,size__5479__auto__,b__18769,s__18767__$2,temp__5804__auto__,catalog,by_category))
;
return iter__5480__auto__(aspects);
})()))].join(''));

var G__19014 = (i__18768 + (1));
i__18768 = G__19014;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__18769),atlas$ontology$generate_ontology_docs_$_iter__18766(cljs.core.chunk_rest(s__18767__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__18769),null);
}
} else {
var vec__18892 = cljs.core.first(s__18767__$2);
var category = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18892,(0),null);
var aspects = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18892,(1),null);
return cljs.core.cons(["## ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(category),"\n\n",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,(function (){var iter__5480__auto__ = ((function (vec__18892,category,aspects,s__18767__$2,temp__5804__auto__,catalog,by_category){
return (function atlas$ontology$generate_ontology_docs_$_iter__18766_$_iter__18916(s__18917){
return (new cljs.core.LazySeq(null,(function (){
var s__18917__$1 = s__18917;
while(true){
var temp__5804__auto____$1 = cljs.core.seq(s__18917__$1);
if(temp__5804__auto____$1){
var xs__6360__auto__ = temp__5804__auto____$1;
var vec__18922 = cljs.core.first(xs__6360__auto__);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18922,(0),null);
var aspect_list = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18922,(1),null);
var iterys__5476__auto__ = ((function (s__18917__$1,vec__18922,_,aspect_list,xs__6360__auto__,temp__5804__auto____$1,vec__18892,category,aspects,s__18767__$2,temp__5804__auto__,catalog,by_category){
return (function atlas$ontology$generate_ontology_docs_$_iter__18766_$_iter__18916_$_iter__18918(s__18919){
return (new cljs.core.LazySeq(null,((function (s__18917__$1,vec__18922,_,aspect_list,xs__6360__auto__,temp__5804__auto____$1,vec__18892,category,aspects,s__18767__$2,temp__5804__auto__,catalog,by_category){
return (function (){
var s__18919__$1 = s__18919;
while(true){
var temp__5804__auto____$2 = cljs.core.seq(s__18919__$1);
if(temp__5804__auto____$2){
var s__18919__$2 = temp__5804__auto____$2;
if(cljs.core.chunked_seq_QMARK_(s__18919__$2)){
var c__5478__auto__ = cljs.core.chunk_first(s__18919__$2);
var size__5479__auto__ = cljs.core.count(c__5478__auto__);
var b__18921 = cljs.core.chunk_buffer(size__5479__auto__);
if((function (){var i__18920 = (0);
while(true){
if((i__18920 < size__5479__auto__)){
var map__18925 = cljs.core._nth(c__5478__auto__,i__18920);
var map__18925__$1 = cljs.core.__destructure_map(map__18925);
var aspect = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18925__$1,new cljs.core.Keyword(null,"aspect","aspect",-839905246));
var usage_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18925__$1,new cljs.core.Keyword(null,"usage-count","usage-count",1415906153));
var examples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18925__$1,new cljs.core.Keyword(null,"examples","examples",-473712556));
cljs.core.chunk_append(b__18921,["### ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(aspect),"\n","- **Usage**: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(usage_count)," entries\n","- **Examples**: ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(", ",examples),"\n\n"].join(''));

var G__19015 = (i__18920 + (1));
i__18920 = G__19015;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__18921),atlas$ontology$generate_ontology_docs_$_iter__18766_$_iter__18916_$_iter__18918(cljs.core.chunk_rest(s__18919__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__18921),null);
}
} else {
var map__18926 = cljs.core.first(s__18919__$2);
var map__18926__$1 = cljs.core.__destructure_map(map__18926);
var aspect = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18926__$1,new cljs.core.Keyword(null,"aspect","aspect",-839905246));
var usage_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18926__$1,new cljs.core.Keyword(null,"usage-count","usage-count",1415906153));
var examples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18926__$1,new cljs.core.Keyword(null,"examples","examples",-473712556));
return cljs.core.cons(["### ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(aspect),"\n","- **Usage**: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(usage_count)," entries\n","- **Examples**: ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(", ",examples),"\n\n"].join(''),atlas$ontology$generate_ontology_docs_$_iter__18766_$_iter__18916_$_iter__18918(cljs.core.rest(s__18919__$2)));
}
} else {
return null;
}
break;
}
});})(s__18917__$1,vec__18922,_,aspect_list,xs__6360__auto__,temp__5804__auto____$1,vec__18892,category,aspects,s__18767__$2,temp__5804__auto__,catalog,by_category))
,null,null));
});})(s__18917__$1,vec__18922,_,aspect_list,xs__6360__auto__,temp__5804__auto____$1,vec__18892,category,aspects,s__18767__$2,temp__5804__auto__,catalog,by_category))
;
var fs__5477__auto__ = cljs.core.seq(iterys__5476__auto__(aspect_list));
if(fs__5477__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__5477__auto__,atlas$ontology$generate_ontology_docs_$_iter__18766_$_iter__18916(cljs.core.rest(s__18917__$1)));
} else {
var G__19016 = cljs.core.rest(s__18917__$1);
s__18917__$1 = G__19016;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});})(vec__18892,category,aspects,s__18767__$2,temp__5804__auto__,catalog,by_category))
;
return iter__5480__auto__(aspects);
})()))].join(''),atlas$ontology$generate_ontology_docs_$_iter__18766(cljs.core.rest(s__18767__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5480__auto__(cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.key,by_category));
})());
});
/**
 * Interactive help system
 */
atlas.ontology.help_ontology = (function atlas$ontology$help_ontology(){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["=== Semantic Ontology Tooling ===\n"], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Discovery:"], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["  (aspect-catalog)              - Browse all aspects with usage"], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["  (suggest-aspects #{...})      - Get aspect suggestions"], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["  (impact-analysis :aspect/x)   - See impact of changes"], 0));

cljs.core.println();

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Validation:"], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["  (validate-before-register #{...}) - Check before registering"], 0));

cljs.core.println();

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Querying:"], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["  (where-> :domain/x)           - Fluent query builder"], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["  (-> (where-> :domain/x) (with-aspect :tier/service) execute-query)"], 0));

cljs.core.println();

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Templates:"], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["  (template:foundation-component :domain/x :external? true)"], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["  ; For execution-function templates, load the EF ontology:"], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["  (require '[atlas.ontology.execution-function :as ef])"], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["  (ef/load!)"], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["  (ef/template:service-function :domain/x :operation/y :pii? true)"], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["  (ef/template:api-endpoint :domain/x :operation/y :rate-limited? true)"], 0));

cljs.core.println();

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Refactoring:"], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["  (refactor-aspect :old :new :dry-run? true)"], 0));

cljs.core.println();

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Documentation:"], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["  (generate-ontology-docs)      - Generate markdown docs"], 0));

return null;
});
/**
 * Quick inspection of a dev-id
 */
atlas.ontology.inspect = (function atlas$ontology$inspect(dev_id){
var matches = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__18928_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(dev_id,new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553).cljs$core$IFn$_invoke$arity$1(atlas.registry.fetch(p1__18928_SHARP_)));
}),atlas.query.all_identities(cljs.core.deref(atlas.registry.registry)));
if(cljs.core.seq(matches)){
var id = cljs.core.first(matches);
var val = atlas.registry.fetch(id);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"dev-id","dev-id",1928680092),dev_id,new cljs.core.Keyword(null,"semantic-identity","semantic-identity",1528201585),id,new cljs.core.Keyword(null,"aspect-count","aspect-count",-95316145),cljs.core.count(id),new cljs.core.Keyword(null,"value","value",305978217),val,new cljs.core.Keyword(null,"docs","docs",-1974280502),new cljs.core.Keyword("docs","content","docs/content",12743235).cljs$core$IFn$_invoke$arity$1(val)], null);
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),"Not found",new cljs.core.Keyword(null,"dev-id","dev-id",1928680092),dev_id], null);
}
});
/**
 * Register all entity types in the registry with :atlas/type.
 * 
 *   This makes entity types discoverable and enables runtime type validation.
 *   Call this once during initialization, after register-ontologies!.
 */
atlas.ontology.register_entity_types_BANG_ = (function atlas$ontology$register_entity_types_BANG_(){
var ontologies = atlas.ontology.all_ontologies();
var seq__18929_19017 = cljs.core.seq(ontologies);
var chunk__18931_19018 = null;
var count__18932_19019 = (0);
var i__18933_19020 = (0);
while(true){
if((i__18933_19020 < count__18932_19019)){
var vec__18941_19021 = chunk__18931_19018.cljs$core$IIndexed$_nth$arity$2(null,i__18933_19020);
var __19022 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18941_19021,(0),null);
var ont_19023 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18941_19021,(1),null);
var entity_type_19024 = new cljs.core.Keyword("ontology","for","ontology/for",587704578).cljs$core$IFn$_invoke$arity$1(ont_19023);
atlas.registry.register_BANG_.cljs$core$IFn$_invoke$arity$4(entity_type_19024,new cljs.core.Keyword("atlas","type","atlas/type",1535978791),cljs.core.PersistentHashSet.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("registry-definition","keys","registry-definition/keys",-1425656523),cljs.core.vec(cljs.core.cons(new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553),new cljs.core.Keyword("ontology","keys","ontology/keys",-1327766367).cljs$core$IFn$_invoke$arity$1(ont_19023)))], null));


var G__19025 = seq__18929_19017;
var G__19026 = chunk__18931_19018;
var G__19027 = count__18932_19019;
var G__19028 = (i__18933_19020 + (1));
seq__18929_19017 = G__19025;
chunk__18931_19018 = G__19026;
count__18932_19019 = G__19027;
i__18933_19020 = G__19028;
continue;
} else {
var temp__5804__auto___19029 = cljs.core.seq(seq__18929_19017);
if(temp__5804__auto___19029){
var seq__18929_19030__$1 = temp__5804__auto___19029;
if(cljs.core.chunked_seq_QMARK_(seq__18929_19030__$1)){
var c__5525__auto___19031 = cljs.core.chunk_first(seq__18929_19030__$1);
var G__19032 = cljs.core.chunk_rest(seq__18929_19030__$1);
var G__19033 = c__5525__auto___19031;
var G__19034 = cljs.core.count(c__5525__auto___19031);
var G__19035 = (0);
seq__18929_19017 = G__19032;
chunk__18931_19018 = G__19033;
count__18932_19019 = G__19034;
i__18933_19020 = G__19035;
continue;
} else {
var vec__18944_19036 = cljs.core.first(seq__18929_19030__$1);
var __19037 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18944_19036,(0),null);
var ont_19038 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18944_19036,(1),null);
var entity_type_19039 = new cljs.core.Keyword("ontology","for","ontology/for",587704578).cljs$core$IFn$_invoke$arity$1(ont_19038);
atlas.registry.register_BANG_.cljs$core$IFn$_invoke$arity$4(entity_type_19039,new cljs.core.Keyword("atlas","type","atlas/type",1535978791),cljs.core.PersistentHashSet.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("registry-definition","keys","registry-definition/keys",-1425656523),cljs.core.vec(cljs.core.cons(new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553),new cljs.core.Keyword("ontology","keys","ontology/keys",-1327766367).cljs$core$IFn$_invoke$arity$1(ont_19038)))], null));


var G__19040 = cljs.core.next(seq__18929_19030__$1);
var G__19041 = null;
var G__19042 = (0);
var G__19043 = (0);
seq__18929_19017 = G__19040;
chunk__18931_19018 = G__19041;
count__18932_19019 = G__19042;
i__18933_19020 = G__19043;
continue;
}
} else {
}
}
break;
}

return cljs.core.count(ontologies);
});
atlas.registry.register_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword("ontology","ontology","ontology/ontology",-871571754),new cljs.core.Keyword("atlas","ontology","atlas/ontology",1061198866),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("atlas","ontology","atlas/ontology",1061198866),null], null), null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("ontology","for","ontology/for",587704578),new cljs.core.Keyword("atlas","ontology","atlas/ontology",1061198866),new cljs.core.Keyword("ontology","keys","ontology/keys",-1327766367),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("ontology","for","ontology/for",587704578),new cljs.core.Keyword("ontology","keys","ontology/keys",-1327766367)], null)], null));

//# sourceMappingURL=atlas.ontology.js.map
