goog.provide('atlas_ui.colors_v2');
/**
 * Core color palette with soft, readable colors
 */
atlas_ui.colors_v2.base_colors = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"aspect-highlighted","aspect-highlighted",1135706496),new cljs.core.Keyword(null,"aspect-negated","aspect-negated",-1274698550),new cljs.core.Keyword(null,"aspect-protocol","aspect-protocol",-1233320502),new cljs.core.Keyword(null,"aspect-feature-type","aspect-feature-type",1577162446),new cljs.core.Keyword(null,"aspect-operation","aspect-operation",488661328),new cljs.core.Keyword(null,"entity-excluded","entity-excluded",1444642353),new cljs.core.Keyword(null,"entity-full-match","entity-full-match",119767602),new cljs.core.Keyword(null,"aspect-other","aspect-other",-1003151340),new cljs.core.Keyword(null,"aspect-tier","aspect-tier",1285902614),new cljs.core.Keyword(null,"aspect-effect","aspect-effect",1700843862),new cljs.core.Keyword(null,"aspect-constraint","aspect-constraint",1815399798),new cljs.core.Keyword(null,"entity-no-match","entity-no-match",-947845929),new cljs.core.Keyword(null,"aspect-lens-type","aspect-lens-type",1289817368),new cljs.core.Keyword(null,"aspect-domain","aspect-domain",727221049),new cljs.core.Keyword(null,"aspect-selected","aspect-selected",1845376058),new cljs.core.Keyword(null,"aspect-unselected","aspect-unselected",234669276)],["#fde68a","#fca5a5","#93c5fd","#f472b6","#86efac","#fee2e2","#ddd6fe","#fed7aa","#fca5a5","#d1d5db","#fbbf24","#f3f4f6","#fb923c","#a78bfa","#c4b5fd","#e5e7eb"]);
atlas_ui.colors_v2.entity_type_colors = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword("semantic-namespace","visual-feature","semantic-namespace/visual-feature",1088200194),new cljs.core.Keyword("atlas","type","atlas/type",1535978791),new cljs.core.Keyword("atlas","interface-protocol","atlas/interface-protocol",-1646715577),new cljs.core.Keyword(null,"default","default",-1987822328),new cljs.core.Keyword("atlas","interface-endpoint","atlas/interface-endpoint",162094344),new cljs.core.Keyword("semantic-namespace","state-derived","semantic-namespace/state-derived",798992265),new cljs.core.Keyword("atlas","risk-failure-mode","atlas/risk-failure-mode",-901843862),new cljs.core.Keyword("atlas","execution-function","atlas/execution-function",-633620662),new cljs.core.Keyword("atlas","structure-component","atlas/structure-component",-156450702),new cljs.core.Keyword("atlas","governance-constraint","atlas/governance-constraint",-1105762794),new cljs.core.Keyword("semantic-namespace","interaction-intent","semantic-namespace/interaction-intent",-483708776),new cljs.core.Keyword("atlas","data-schema","atlas/data-schema",622038329),new cljs.core.Keyword("atlas","identity-role","atlas/identity-role",-1796346566),new cljs.core.Keyword("atlas","experience-journey","atlas/experience-journey",-1932613605),new cljs.core.Keyword("atlas","business-pattern","atlas/business-pattern",-535595556),new cljs.core.Keyword("semantic-namespace","state-atom","semantic-namespace/state-atom",453405021),new cljs.core.Keyword("atlas","value-proposition","atlas/value-proposition",-2066799969)],["#d1fae5","#f5d0fe","#ddd6fe","#e5e7eb","#fde68a","#e9d5ff","#fed7aa","#bfdbfe","#a7f3d0","#fecaca","#fbcfe8","#e0e7ff","#fcd34d","#c7d2fe","#fed7aa","#cffafe","#ccfbf1"]);
atlas_ui.colors_v2.tier_colors = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("tier","foundation","tier/foundation",-1943771629),"#ef4444",new cljs.core.Keyword("tier","service","tier/service",-1966897213),"#f59e0b",new cljs.core.Keyword("tier","api","tier/api",-897042558),"#10b981",new cljs.core.Keyword("tier","ui","tier/ui",-474452591),"#3b82f6"], null);
atlas_ui.colors_v2.domain_colors = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword("domain","users","domain/users",636231163),"#8b5cf6",new cljs.core.Keyword("domain","auth","domain/auth",-2048853662),"#ec4899",new cljs.core.Keyword("domain","scheduling","domain/scheduling",-1289625624),"#06b6d4",new cljs.core.Keyword("domain","admin","domain/admin",1594924161),"#eab308",new cljs.core.Keyword("domain","google","domain/google",-1819316067),"#3b82f6",new cljs.core.Keyword("domain","system","domain/system",1364432480),"#6b7280"], null);
atlas_ui.colors_v2.operation_colors = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword("operation","create","operation/create",1431273313),new cljs.core.Keyword("operation","check","operation/check",-1407766643),new cljs.core.Keyword("operation","read","operation/read",1591254958),new cljs.core.Keyword("operation","delete","operation/delete",-73533293),new cljs.core.Keyword("operation","update","operation/update",-613075597),new cljs.core.Keyword("operation","generate","operation/generate",1664038291),new cljs.core.Keyword("operation","query","operation/query",240529335),new cljs.core.Keyword("operation","list","operation/list",-901711174),new cljs.core.Keyword("operation","collect","operation/collect",-1846852516)],["#10b981","#a78bfa","#3b82f6","#ef4444","#f59e0b","#fbbf24","#06b6d4","#8b5cf6","#34d399"]);
atlas_ui.colors_v2.hex_to_rgb = (function atlas_ui$colors_v2$hex_to_rgb(hex){

var hex__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(hex),"#"))?cljs.core.subs.cljs$core$IFn$_invoke$arity$2(hex,(1)):hex);
var r = parseInt(cljs.core.subs.cljs$core$IFn$_invoke$arity$3(hex__$1,(0),(2)),(16));
var g = parseInt(cljs.core.subs.cljs$core$IFn$_invoke$arity$3(hex__$1,(2),(4)),(16));
var b = parseInt(cljs.core.subs.cljs$core$IFn$_invoke$arity$3(hex__$1,(4),(6)),(16));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [r,g,b], null);
});
atlas_ui.colors_v2.rgb_to_hex = (function atlas_ui$colors_v2$rgb_to_hex(p__18292){
var vec__18293 = p__18292;
var r = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18293,(0),null);
var g = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18293,(1),null);
var b = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18293,(2),null);

return ["#",cljs.core.str.cljs$core$IFn$_invoke$arity$1(Math.round(r).toString((16)).padStart((2),"0")),cljs.core.str.cljs$core$IFn$_invoke$arity$1(Math.round(g).toString((16)).padStart((2),"0")),cljs.core.str.cljs$core$IFn$_invoke$arity$1(Math.round(b).toString((16)).padStart((2),"0"))].join('');
});
atlas_ui.colors_v2.interpolate_color = (function atlas_ui$colors_v2$interpolate_color(color1,color2,ratio){

var vec__18298 = atlas_ui.colors_v2.hex_to_rgb(color1);
var r1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18298,(0),null);
var g1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18298,(1),null);
var b1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18298,(2),null);
var vec__18302 = atlas_ui.colors_v2.hex_to_rgb(color2);
var r2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18302,(0),null);
var g2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18302,(1),null);
var b2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18302,(2),null);
var r = (r1 + ((r2 - r1) * ratio));
var g = (g1 + ((g2 - g1) * ratio));
var b = (b1 + ((b2 - b1) * ratio));
return atlas_ui.colors_v2.rgb_to_hex(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [r,g,b], null));
});
atlas_ui.colors_v2.blend_colors = (function atlas_ui$colors_v2$blend_colors(colors){

if(cljs.core.empty_QMARK_(colors)){
return new cljs.core.Keyword(null,"entity-no-match","entity-no-match",-947845929).cljs$core$IFn$_invoke$arity$1(atlas_ui.colors_v2.base_colors);
} else {
var rgb_values = cljs.core.map.cljs$core$IFn$_invoke$arity$2(atlas_ui.colors_v2.hex_to_rgb,colors);
var n = cljs.core.count(rgb_values);
var avg_rgb = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__18306,p__18307){
var vec__18308 = p__18306;
var r = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18308,(0),null);
var g = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18308,(1),null);
var b = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18308,(2),null);
var vec__18311 = p__18307;
var r2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18311,(0),null);
var g2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18311,(1),null);
var b2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18311,(2),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(r + r2),(g + g2),(b + b2)], null);
}),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0)], null),rgb_values);
var final_rgb = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__18305_SHARP_){
return (p1__18305_SHARP_ / n);
}),avg_rgb);
return atlas_ui.colors_v2.rgb_to_hex(final_rgb);
}
});
/**
 * Find which value an entity has in a given category namespace
 */
atlas_ui.colors_v2.get_entity_value_in_category = (function atlas_ui$colors_v2$get_entity_value_in_category(entity_aspects,category_ns){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__18314_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(p1__18314_SHARP_),category_ns);
}),entity_aspects));
});
atlas_ui.colors_v2.get_category_color = (function atlas_ui$colors_v2$get_category_color(category_ns,value_keyword){

var G__18315 = category_ns;
switch (G__18315) {
case "tier":
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(atlas_ui.colors_v2.tier_colors,value_keyword);

break;
case "domain":
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(atlas_ui.colors_v2.domain_colors,value_keyword);

break;
case "operation":
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(atlas_ui.colors_v2.operation_colors,value_keyword);

break;
default:
return null;

}
});
/**
 * Collect colors from entity's values in selected categories
 */
atlas_ui.colors_v2.collect_category_colors = (function atlas_ui$colors_v2$collect_category_colors(entity_aspects,selected_aspects){
var category_selections = cljs.core.group_by(cljs.core.namespace,selected_aspects);
var iter__5480__auto__ = (function atlas_ui$colors_v2$collect_category_colors_$_iter__18316(s__18317){
return (new cljs.core.LazySeq(null,(function (){
var s__18317__$1 = s__18317;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__18317__$1);
if(temp__5804__auto__){
var s__18317__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__18317__$2)){
var c__5478__auto__ = cljs.core.chunk_first(s__18317__$2);
var size__5479__auto__ = cljs.core.count(c__5478__auto__);
var b__18319 = cljs.core.chunk_buffer(size__5479__auto__);
if((function (){var i__18318 = (0);
while(true){
if((i__18318 < size__5479__auto__)){
var vec__18322 = cljs.core._nth(c__5478__auto__,i__18318);
var category_ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18322,(0),null);
var aspects = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18322,(1),null);
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, ["operation",null,"domain",null,"tier",null], null), null),category_ns)){
var entity_value = atlas_ui.colors_v2.get_entity_value_in_category(entity_aspects,category_ns);
var color = (cljs.core.truth_(entity_value)?atlas_ui.colors_v2.get_category_color(category_ns,entity_value):null);
if(cljs.core.truth_(color)){
cljs.core.chunk_append(b__18319,color);

var G__18361 = (i__18318 + (1));
i__18318 = G__18361;
continue;
} else {
var G__18362 = (i__18318 + (1));
i__18318 = G__18362;
continue;
}
} else {
var G__18363 = (i__18318 + (1));
i__18318 = G__18363;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__18319),atlas_ui$colors_v2$collect_category_colors_$_iter__18316(cljs.core.chunk_rest(s__18317__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__18319),null);
}
} else {
var vec__18325 = cljs.core.first(s__18317__$2);
var category_ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18325,(0),null);
var aspects = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18325,(1),null);
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, ["operation",null,"domain",null,"tier",null], null), null),category_ns)){
var entity_value = atlas_ui.colors_v2.get_entity_value_in_category(entity_aspects,category_ns);
var color = (cljs.core.truth_(entity_value)?atlas_ui.colors_v2.get_category_color(category_ns,entity_value):null);
if(cljs.core.truth_(color)){
return cljs.core.cons(color,atlas_ui$colors_v2$collect_category_colors_$_iter__18316(cljs.core.rest(s__18317__$2)));
} else {
var G__18364 = cljs.core.rest(s__18317__$2);
s__18317__$1 = G__18364;
continue;
}
} else {
var G__18365 = cljs.core.rest(s__18317__$2);
s__18317__$1 = G__18365;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5480__auto__(category_selections);
});
/**
 * Extract semantic type from entity aspects.
 * 
 * DEPRECATED: Use (:atlas-ui.graph.node/entity-type node) directly instead.
 * This function is kept for backward compatibility only.
 */
atlas_ui.colors_v2.get_entity_type = (function atlas_ui$colors_v2$get_entity_type(entity_aspects){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__18328_SHARP_){
return cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["atlas",null,"semantic-namespace",null], null), null),cljs.core.namespace(p1__18328_SHARP_));
}),entity_aspects));
});
/**
 * Calculate entity color based on semantic type.
 * 
 * Parameters:
 * - entity-type: The entity type keyword (e.g., :atlas/interface-endpoint)
 *                Pass directly from (:atlas-ui.graph.node/entity-type node)
 * - aspects: Pure aspect set (without type mixed in)
 * - query: Query map with selected/negated aspects
 */
atlas_ui.colors_v2.entity_color_by_type = (function atlas_ui$colors_v2$entity_color_by_type(entity_type,aspects,query){
var map__18329 = query;
var map__18329__$1 = cljs.core.__destructure_map(map__18329);
var selected = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18329__$1,new cljs.core.Keyword("atlas.query","selected","atlas.query/selected",1069414447));
var negated = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18329__$1,new cljs.core.Keyword("atlas.query","negated","atlas.query/negated",1430445364));
var excluded_QMARK_ = atlas.query.excluded_by_negation_QMARK_(aspects,negated);
if(excluded_QMARK_){
return new cljs.core.Keyword(null,"entity-excluded","entity-excluded",1444642353).cljs$core$IFn$_invoke$arity$1(atlas_ui.colors_v2.base_colors);
} else {
if(cljs.core.truth_(entity_type)){
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(atlas_ui.colors_v2.entity_type_colors,entity_type,new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(atlas_ui.colors_v2.entity_type_colors));
} else {
return new cljs.core.Keyword(null,"entity-no-match","entity-no-match",-947845929).cljs$core$IFn$_invoke$arity$1(atlas_ui.colors_v2.base_colors);

}
}
});
/**
 * Calculate aspect color based on selection state, entity highlighting, and aspect category
 */
atlas_ui.colors_v2.aspect_color = (function atlas_ui$colors_v2$aspect_color(aspect_id,query,highlighted_entity_aspects){
if(cljs.core.contains_QMARK_(cljs.core.set((function (){var or__5002__auto__ = new cljs.core.Keyword("atlas.query","negated","atlas.query/negated",1430445364).cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return new cljs.core.Keyword(null,"negated","negated",-273117033).cljs$core$IFn$_invoke$arity$1(query);
}
})()),aspect_id)){
return new cljs.core.Keyword(null,"aspect-negated","aspect-negated",-1274698550).cljs$core$IFn$_invoke$arity$1(atlas_ui.colors_v2.base_colors);
} else {
if(cljs.core.contains_QMARK_(cljs.core.set((function (){var or__5002__auto__ = new cljs.core.Keyword("atlas.query","selected","atlas.query/selected",1069414447).cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return new cljs.core.Keyword(null,"selected","selected",574897764).cljs$core$IFn$_invoke$arity$1(query);
}
})()),aspect_id)){
return new cljs.core.Keyword(null,"aspect-selected","aspect-selected",1845376058).cljs$core$IFn$_invoke$arity$1(atlas_ui.colors_v2.base_colors);
} else {
if(cljs.core.contains_QMARK_(highlighted_entity_aspects,aspect_id)){
return new cljs.core.Keyword(null,"aspect-highlighted","aspect-highlighted",1135706496).cljs$core$IFn$_invoke$arity$1(atlas_ui.colors_v2.base_colors);
} else {
var aspect_ns = cljs.core.namespace(aspect_id);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(aspect_ns,"tier")){
return new cljs.core.Keyword(null,"aspect-tier","aspect-tier",1285902614).cljs$core$IFn$_invoke$arity$1(atlas_ui.colors_v2.base_colors);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(aspect_ns,"domain")){
return new cljs.core.Keyword(null,"aspect-domain","aspect-domain",727221049).cljs$core$IFn$_invoke$arity$1(atlas_ui.colors_v2.base_colors);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(aspect_ns,"protocol")){
return new cljs.core.Keyword(null,"aspect-protocol","aspect-protocol",-1233320502).cljs$core$IFn$_invoke$arity$1(atlas_ui.colors_v2.base_colors);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(aspect_ns,"operation")){
return new cljs.core.Keyword(null,"aspect-operation","aspect-operation",488661328).cljs$core$IFn$_invoke$arity$1(atlas_ui.colors_v2.base_colors);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(aspect_ns,"constraint")){
return new cljs.core.Keyword(null,"aspect-constraint","aspect-constraint",1815399798).cljs$core$IFn$_invoke$arity$1(atlas_ui.colors_v2.base_colors);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(aspect_ns,"lens-type")){
return new cljs.core.Keyword(null,"aspect-lens-type","aspect-lens-type",1289817368).cljs$core$IFn$_invoke$arity$1(atlas_ui.colors_v2.base_colors);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(aspect_ns,"feature-type")){
return new cljs.core.Keyword(null,"aspect-feature-type","aspect-feature-type",1577162446).cljs$core$IFn$_invoke$arity$1(atlas_ui.colors_v2.base_colors);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(aspect_ns,"effect")){
return new cljs.core.Keyword(null,"aspect-effect","aspect-effect",1700843862).cljs$core$IFn$_invoke$arity$1(atlas_ui.colors_v2.base_colors);
} else {
return new cljs.core.Keyword(null,"aspect-other","aspect-other",-1003151340).cljs$core$IFn$_invoke$arity$1(atlas_ui.colors_v2.base_colors);

}
}
}
}
}
}
}
}

}
}
}
});
/**
 * Main entry point for node coloring.
 * 
 * Now uses direct access to :entity-type and :aspects for better performance.
 * Falls back to :identity for backward compatibility if new fields not present.
 */
atlas_ui.colors_v2.node_color = (function atlas_ui$colors_v2$node_color(node,query,highlighted_entity_id,highlighted_entity_aspects){
var node_id = new cljs.core.Keyword("atlas-ui.graph.node","id","atlas-ui.graph.node/id",-1392721478).cljs$core$IFn$_invoke$arity$1(node);
var node_type = new cljs.core.Keyword("atlas-ui.graph.node","type","atlas-ui.graph.node/type",1053813014).cljs$core$IFn$_invoke$arity$1(node);
var G__18333 = node_type;
var G__18333__$1 = (((G__18333 instanceof cljs.core.Keyword))?G__18333.fqn:null);
switch (G__18333__$1) {
case "entity":
var entity_type = (function (){var or__5002__auto__ = new cljs.core.Keyword("atlas-ui.graph.node","entity-type","atlas-ui.graph.node/entity-type",-1912090483).cljs$core$IFn$_invoke$arity$1(node);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return atlas_ui.colors_v2.get_entity_type(new cljs.core.Keyword("atlas-ui.graph.node","identity","atlas-ui.graph.node/identity",1626823993).cljs$core$IFn$_invoke$arity$1(node));
}
})();
var aspects = (function (){var or__5002__auto__ = new cljs.core.Keyword("atlas-ui.graph.node","aspects","atlas-ui.graph.node/aspects",1959787835).cljs$core$IFn$_invoke$arity$1(node);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return new cljs.core.Keyword("atlas-ui.graph.node","identity","atlas-ui.graph.node/identity",1626823993).cljs$core$IFn$_invoke$arity$1(node);
}
})();
return atlas_ui.colors_v2.entity_color_by_type(entity_type,aspects,query);

break;
case "aspect":
return atlas_ui.colors_v2.aspect_color(node_id,query,highlighted_entity_aspects);

break;
default:
return new cljs.core.Keyword(null,"entity-no-match","entity-no-match",-947845929).cljs$core$IFn$_invoke$arity$1(atlas_ui.colors_v2.base_colors);

}
});
/**
 * Calculate edge color
 */
atlas_ui.colors_v2.edge_color = (function atlas_ui$colors_v2$edge_color(edge_type){
var G__18336 = edge_type;
var G__18336__$1 = (((G__18336 instanceof cljs.core.Keyword))?G__18336.fqn:null);
switch (G__18336__$1) {
case "dependency":
return new cljs.core.Keyword(null,"edge-dependency","edge-dependency",-1423322825).cljs$core$IFn$_invoke$arity$1(atlas_ui.colors_v2.base_colors);

break;
case "membership":
return new cljs.core.Keyword(null,"edge","edge",919909153).cljs$core$IFn$_invoke$arity$1(atlas_ui.colors_v2.base_colors);

break;
default:
return new cljs.core.Keyword(null,"edge","edge",919909153).cljs$core$IFn$_invoke$arity$1(atlas_ui.colors_v2.base_colors);

}
});
/**
 * Calculate node opacity based on match score (with stronger fade for non-matches).
 * 
 * Note: Pass entity aspects (pure aspects, not including type) for accurate scoring.
 */
atlas_ui.colors_v2.calculate_opacity = (function atlas_ui$colors_v2$calculate_opacity(entity_aspects,query){
var map__18341 = query;
var map__18341__$1 = cljs.core.__destructure_map(map__18341);
var selected = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18341__$1,new cljs.core.Keyword("atlas.query","selected","atlas.query/selected",1069414447));
var negated = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18341__$1,new cljs.core.Keyword("atlas.query","negated","atlas.query/negated",1430445364));
var mode = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18341__$1,new cljs.core.Keyword("atlas.query","mode","atlas.query/mode",1284108834));
var selected_set = cljs.core.set(selected);
var excluded_QMARK_ = atlas.query.excluded_by_negation_QMARK_(entity_aspects,negated);
var mode__$1 = (function (){var or__5002__auto__ = mode;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return new cljs.core.Keyword(null,"count","count",2139924085);
}
})();
if(cljs.core.empty_QMARK_(selected_set)){
if(excluded_QMARK_){
return 0.15;
} else {
return 1.0;
}
} else {
var score = atlas.query.query_score(entity_aspects,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(query,new cljs.core.Keyword("atlas.query","selected","atlas.query/selected",1069414447),selected_set,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("atlas.query","mode","atlas.query/mode",1284108834),mode__$1], 0)));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(score,0.0)){
return 0.2;
} else {
return (0.5 + (0.5 * score));
}

}
});

//# sourceMappingURL=atlas_ui.colors_v2.js.map
