goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = true;

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_11547 = (function (this$){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (shadow.dom._to_dom[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5351__auto__.call(null,this$));
} else {
var m__5349__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5349__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_11547(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_11576 = (function (this$){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (shadow.dom._to_svg[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5351__auto__.call(null,this$));
} else {
var m__5349__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5349__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_11576(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__10114 = coll;
var G__10115 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__10114,G__10115) : shadow.dom.lazy_native_coll_seq.call(null,G__10114,G__10115));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__5002__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__10119 = arguments.length;
switch (G__10119) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__10123 = arguments.length;
switch (G__10123) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__10132 = arguments.length;
switch (G__10132) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__10134 = arguments.length;
switch (G__10134) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__10141 = arguments.length;
switch (G__10141) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__10156 = arguments.length;
switch (G__10156) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__5002__auto__ = (!((typeof document !== 'undefined')));
if(or__5002__auto__){
return or__5002__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e10162){if((e10162 instanceof Object)){
var e = e10162;
return console.log("didnt support attachEvent",el,e);
} else {
throw e10162;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__5002__auto__ = (!((typeof document !== 'undefined')));
if(or__5002__auto__){
return or__5002__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__10168 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__10169 = null;
var count__10170 = (0);
var i__10171 = (0);
while(true){
if((i__10171 < count__10170)){
var el = chunk__10169.cljs$core$IIndexed$_nth$arity$2(null,i__10171);
var handler_11706__$1 = ((function (seq__10168,chunk__10169,count__10170,i__10171,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__10168,chunk__10169,count__10170,i__10171,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_11706__$1);


var G__11746 = seq__10168;
var G__11747 = chunk__10169;
var G__11748 = count__10170;
var G__11749 = (i__10171 + (1));
seq__10168 = G__11746;
chunk__10169 = G__11747;
count__10170 = G__11748;
i__10171 = G__11749;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__10168);
if(temp__5804__auto__){
var seq__10168__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10168__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__10168__$1);
var G__11755 = cljs.core.chunk_rest(seq__10168__$1);
var G__11756 = c__5525__auto__;
var G__11757 = cljs.core.count(c__5525__auto__);
var G__11758 = (0);
seq__10168 = G__11755;
chunk__10169 = G__11756;
count__10170 = G__11757;
i__10171 = G__11758;
continue;
} else {
var el = cljs.core.first(seq__10168__$1);
var handler_11760__$1 = ((function (seq__10168,chunk__10169,count__10170,i__10171,el,seq__10168__$1,temp__5804__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__10168,chunk__10169,count__10170,i__10171,el,seq__10168__$1,temp__5804__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_11760__$1);


var G__11762 = cljs.core.next(seq__10168__$1);
var G__11763 = null;
var G__11764 = (0);
var G__11765 = (0);
seq__10168 = G__11762;
chunk__10169 = G__11763;
count__10170 = G__11764;
i__10171 = G__11765;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__10183 = arguments.length;
switch (G__10183) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__10191 = cljs.core.seq(events);
var chunk__10192 = null;
var count__10193 = (0);
var i__10194 = (0);
while(true){
if((i__10194 < count__10193)){
var vec__10215 = chunk__10192.cljs$core$IIndexed$_nth$arity$2(null,i__10194);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10215,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10215,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__11785 = seq__10191;
var G__11787 = chunk__10192;
var G__11788 = count__10193;
var G__11789 = (i__10194 + (1));
seq__10191 = G__11785;
chunk__10192 = G__11787;
count__10193 = G__11788;
i__10194 = G__11789;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__10191);
if(temp__5804__auto__){
var seq__10191__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10191__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__10191__$1);
var G__11792 = cljs.core.chunk_rest(seq__10191__$1);
var G__11793 = c__5525__auto__;
var G__11794 = cljs.core.count(c__5525__auto__);
var G__11795 = (0);
seq__10191 = G__11792;
chunk__10192 = G__11793;
count__10193 = G__11794;
i__10194 = G__11795;
continue;
} else {
var vec__10220 = cljs.core.first(seq__10191__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10220,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10220,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__11796 = cljs.core.next(seq__10191__$1);
var G__11797 = null;
var G__11798 = (0);
var G__11799 = (0);
seq__10191 = G__11796;
chunk__10192 = G__11797;
count__10193 = G__11798;
i__10194 = G__11799;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__10226 = cljs.core.seq(styles);
var chunk__10227 = null;
var count__10228 = (0);
var i__10229 = (0);
while(true){
if((i__10229 < count__10228)){
var vec__10237 = chunk__10227.cljs$core$IIndexed$_nth$arity$2(null,i__10229);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10237,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10237,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__11804 = seq__10226;
var G__11805 = chunk__10227;
var G__11806 = count__10228;
var G__11807 = (i__10229 + (1));
seq__10226 = G__11804;
chunk__10227 = G__11805;
count__10228 = G__11806;
i__10229 = G__11807;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__10226);
if(temp__5804__auto__){
var seq__10226__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10226__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__10226__$1);
var G__11809 = cljs.core.chunk_rest(seq__10226__$1);
var G__11810 = c__5525__auto__;
var G__11811 = cljs.core.count(c__5525__auto__);
var G__11812 = (0);
seq__10226 = G__11809;
chunk__10227 = G__11810;
count__10228 = G__11811;
i__10229 = G__11812;
continue;
} else {
var vec__10240 = cljs.core.first(seq__10226__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10240,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10240,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__11814 = cljs.core.next(seq__10226__$1);
var G__11815 = null;
var G__11816 = (0);
var G__11817 = (0);
seq__10226 = G__11814;
chunk__10227 = G__11815;
count__10228 = G__11816;
i__10229 = G__11817;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__10243_11819 = key;
var G__10243_11820__$1 = (((G__10243_11819 instanceof cljs.core.Keyword))?G__10243_11819.fqn:null);
switch (G__10243_11820__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_11839 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__5002__auto__ = goog.string.startsWith(ks_11839,"data-");
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return goog.string.startsWith(ks_11839,"aria-");
}
})())){
el.setAttribute(ks_11839,value);
} else {
(el[ks_11839] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__10244){
var map__10245 = p__10244;
var map__10245__$1 = cljs.core.__destructure_map(map__10245);
var props = map__10245__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10245__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__10246 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10246,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10246,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10246,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__10249 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__10249,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__10249;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__10252 = arguments.length;
switch (G__10252) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5804__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5804__auto__)){
var n = temp__5804__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5804__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5804__auto__)){
var n = temp__5804__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__10256){
var vec__10257 = p__10256;
var seq__10258 = cljs.core.seq(vec__10257);
var first__10259 = cljs.core.first(seq__10258);
var seq__10258__$1 = cljs.core.next(seq__10258);
var nn = first__10259;
var first__10259__$1 = cljs.core.first(seq__10258__$1);
var seq__10258__$2 = cljs.core.next(seq__10258__$1);
var np = first__10259__$1;
var nc = seq__10258__$2;
var node = vec__10257;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__10281 = nn;
var G__10282 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__10281,G__10282) : create_fn.call(null,G__10281,G__10282));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__10283 = nn;
var G__10284 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__10283,G__10284) : create_fn.call(null,G__10283,G__10284));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__10285 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10285,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10285,(1),null);
var seq__10288_11897 = cljs.core.seq(node_children);
var chunk__10289_11898 = null;
var count__10290_11899 = (0);
var i__10291_11901 = (0);
while(true){
if((i__10291_11901 < count__10290_11899)){
var child_struct_11906 = chunk__10289_11898.cljs$core$IIndexed$_nth$arity$2(null,i__10291_11901);
var children_11907 = shadow.dom.dom_node(child_struct_11906);
if(cljs.core.seq_QMARK_(children_11907)){
var seq__10314_11909 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_11907));
var chunk__10316_11910 = null;
var count__10317_11911 = (0);
var i__10318_11912 = (0);
while(true){
if((i__10318_11912 < count__10317_11911)){
var child_11914 = chunk__10316_11910.cljs$core$IIndexed$_nth$arity$2(null,i__10318_11912);
if(cljs.core.truth_(child_11914)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_11914);


var G__11916 = seq__10314_11909;
var G__11917 = chunk__10316_11910;
var G__11918 = count__10317_11911;
var G__11919 = (i__10318_11912 + (1));
seq__10314_11909 = G__11916;
chunk__10316_11910 = G__11917;
count__10317_11911 = G__11918;
i__10318_11912 = G__11919;
continue;
} else {
var G__11920 = seq__10314_11909;
var G__11921 = chunk__10316_11910;
var G__11922 = count__10317_11911;
var G__11923 = (i__10318_11912 + (1));
seq__10314_11909 = G__11920;
chunk__10316_11910 = G__11921;
count__10317_11911 = G__11922;
i__10318_11912 = G__11923;
continue;
}
} else {
var temp__5804__auto___11925 = cljs.core.seq(seq__10314_11909);
if(temp__5804__auto___11925){
var seq__10314_11927__$1 = temp__5804__auto___11925;
if(cljs.core.chunked_seq_QMARK_(seq__10314_11927__$1)){
var c__5525__auto___11928 = cljs.core.chunk_first(seq__10314_11927__$1);
var G__11930 = cljs.core.chunk_rest(seq__10314_11927__$1);
var G__11931 = c__5525__auto___11928;
var G__11932 = cljs.core.count(c__5525__auto___11928);
var G__11933 = (0);
seq__10314_11909 = G__11930;
chunk__10316_11910 = G__11931;
count__10317_11911 = G__11932;
i__10318_11912 = G__11933;
continue;
} else {
var child_11934 = cljs.core.first(seq__10314_11927__$1);
if(cljs.core.truth_(child_11934)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_11934);


var G__11935 = cljs.core.next(seq__10314_11927__$1);
var G__11936 = null;
var G__11937 = (0);
var G__11938 = (0);
seq__10314_11909 = G__11935;
chunk__10316_11910 = G__11936;
count__10317_11911 = G__11937;
i__10318_11912 = G__11938;
continue;
} else {
var G__11939 = cljs.core.next(seq__10314_11927__$1);
var G__11940 = null;
var G__11941 = (0);
var G__11942 = (0);
seq__10314_11909 = G__11939;
chunk__10316_11910 = G__11940;
count__10317_11911 = G__11941;
i__10318_11912 = G__11942;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_11907);
}


var G__11943 = seq__10288_11897;
var G__11944 = chunk__10289_11898;
var G__11945 = count__10290_11899;
var G__11946 = (i__10291_11901 + (1));
seq__10288_11897 = G__11943;
chunk__10289_11898 = G__11944;
count__10290_11899 = G__11945;
i__10291_11901 = G__11946;
continue;
} else {
var temp__5804__auto___11948 = cljs.core.seq(seq__10288_11897);
if(temp__5804__auto___11948){
var seq__10288_11950__$1 = temp__5804__auto___11948;
if(cljs.core.chunked_seq_QMARK_(seq__10288_11950__$1)){
var c__5525__auto___11951 = cljs.core.chunk_first(seq__10288_11950__$1);
var G__11952 = cljs.core.chunk_rest(seq__10288_11950__$1);
var G__11953 = c__5525__auto___11951;
var G__11954 = cljs.core.count(c__5525__auto___11951);
var G__11955 = (0);
seq__10288_11897 = G__11952;
chunk__10289_11898 = G__11953;
count__10290_11899 = G__11954;
i__10291_11901 = G__11955;
continue;
} else {
var child_struct_11956 = cljs.core.first(seq__10288_11950__$1);
var children_11957 = shadow.dom.dom_node(child_struct_11956);
if(cljs.core.seq_QMARK_(children_11957)){
var seq__10346_11988 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_11957));
var chunk__10348_11989 = null;
var count__10349_11990 = (0);
var i__10350_11991 = (0);
while(true){
if((i__10350_11991 < count__10349_11990)){
var child_11992 = chunk__10348_11989.cljs$core$IIndexed$_nth$arity$2(null,i__10350_11991);
if(cljs.core.truth_(child_11992)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_11992);


var G__11993 = seq__10346_11988;
var G__11994 = chunk__10348_11989;
var G__11995 = count__10349_11990;
var G__11996 = (i__10350_11991 + (1));
seq__10346_11988 = G__11993;
chunk__10348_11989 = G__11994;
count__10349_11990 = G__11995;
i__10350_11991 = G__11996;
continue;
} else {
var G__11997 = seq__10346_11988;
var G__11998 = chunk__10348_11989;
var G__11999 = count__10349_11990;
var G__12000 = (i__10350_11991 + (1));
seq__10346_11988 = G__11997;
chunk__10348_11989 = G__11998;
count__10349_11990 = G__11999;
i__10350_11991 = G__12000;
continue;
}
} else {
var temp__5804__auto___12002__$1 = cljs.core.seq(seq__10346_11988);
if(temp__5804__auto___12002__$1){
var seq__10346_12003__$1 = temp__5804__auto___12002__$1;
if(cljs.core.chunked_seq_QMARK_(seq__10346_12003__$1)){
var c__5525__auto___12004 = cljs.core.chunk_first(seq__10346_12003__$1);
var G__12005 = cljs.core.chunk_rest(seq__10346_12003__$1);
var G__12006 = c__5525__auto___12004;
var G__12007 = cljs.core.count(c__5525__auto___12004);
var G__12008 = (0);
seq__10346_11988 = G__12005;
chunk__10348_11989 = G__12006;
count__10349_11990 = G__12007;
i__10350_11991 = G__12008;
continue;
} else {
var child_12009 = cljs.core.first(seq__10346_12003__$1);
if(cljs.core.truth_(child_12009)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_12009);


var G__12011 = cljs.core.next(seq__10346_12003__$1);
var G__12012 = null;
var G__12013 = (0);
var G__12014 = (0);
seq__10346_11988 = G__12011;
chunk__10348_11989 = G__12012;
count__10349_11990 = G__12013;
i__10350_11991 = G__12014;
continue;
} else {
var G__12015 = cljs.core.next(seq__10346_12003__$1);
var G__12016 = null;
var G__12017 = (0);
var G__12018 = (0);
seq__10346_11988 = G__12015;
chunk__10348_11989 = G__12016;
count__10349_11990 = G__12017;
i__10350_11991 = G__12018;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_11957);
}


var G__12019 = cljs.core.next(seq__10288_11950__$1);
var G__12020 = null;
var G__12021 = (0);
var G__12022 = (0);
seq__10288_11897 = G__12019;
chunk__10289_11898 = G__12020;
count__10290_11899 = G__12021;
i__10291_11901 = G__12022;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__10422 = cljs.core.seq(node);
var chunk__10423 = null;
var count__10424 = (0);
var i__10425 = (0);
while(true){
if((i__10425 < count__10424)){
var n = chunk__10423.cljs$core$IIndexed$_nth$arity$2(null,i__10425);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__12033 = seq__10422;
var G__12034 = chunk__10423;
var G__12035 = count__10424;
var G__12036 = (i__10425 + (1));
seq__10422 = G__12033;
chunk__10423 = G__12034;
count__10424 = G__12035;
i__10425 = G__12036;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__10422);
if(temp__5804__auto__){
var seq__10422__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10422__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__10422__$1);
var G__12038 = cljs.core.chunk_rest(seq__10422__$1);
var G__12039 = c__5525__auto__;
var G__12040 = cljs.core.count(c__5525__auto__);
var G__12041 = (0);
seq__10422 = G__12038;
chunk__10423 = G__12039;
count__10424 = G__12040;
i__10425 = G__12041;
continue;
} else {
var n = cljs.core.first(seq__10422__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__12042 = cljs.core.next(seq__10422__$1);
var G__12043 = null;
var G__12044 = (0);
var G__12045 = (0);
seq__10422 = G__12042;
chunk__10423 = G__12043;
count__10424 = G__12044;
i__10425 = G__12045;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__10495 = arguments.length;
switch (G__10495) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__10542 = arguments.length;
switch (G__10542) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__10613 = arguments.length;
switch (G__10613) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__5002__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__5732__auto__ = [];
var len__5726__auto___12060 = arguments.length;
var i__5727__auto___12061 = (0);
while(true){
if((i__5727__auto___12061 < len__5726__auto___12060)){
args__5732__auto__.push((arguments[i__5727__auto___12061]));

var G__12063 = (i__5727__auto___12061 + (1));
i__5727__auto___12061 = G__12063;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((0) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__5733__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__10664_12064 = cljs.core.seq(nodes);
var chunk__10665_12065 = null;
var count__10666_12066 = (0);
var i__10667_12067 = (0);
while(true){
if((i__10667_12067 < count__10666_12066)){
var node_12068 = chunk__10665_12065.cljs$core$IIndexed$_nth$arity$2(null,i__10667_12067);
fragment.appendChild(shadow.dom._to_dom(node_12068));


var G__12070 = seq__10664_12064;
var G__12071 = chunk__10665_12065;
var G__12072 = count__10666_12066;
var G__12073 = (i__10667_12067 + (1));
seq__10664_12064 = G__12070;
chunk__10665_12065 = G__12071;
count__10666_12066 = G__12072;
i__10667_12067 = G__12073;
continue;
} else {
var temp__5804__auto___12074 = cljs.core.seq(seq__10664_12064);
if(temp__5804__auto___12074){
var seq__10664_12075__$1 = temp__5804__auto___12074;
if(cljs.core.chunked_seq_QMARK_(seq__10664_12075__$1)){
var c__5525__auto___12076 = cljs.core.chunk_first(seq__10664_12075__$1);
var G__12077 = cljs.core.chunk_rest(seq__10664_12075__$1);
var G__12078 = c__5525__auto___12076;
var G__12079 = cljs.core.count(c__5525__auto___12076);
var G__12080 = (0);
seq__10664_12064 = G__12077;
chunk__10665_12065 = G__12078;
count__10666_12066 = G__12079;
i__10667_12067 = G__12080;
continue;
} else {
var node_12081 = cljs.core.first(seq__10664_12075__$1);
fragment.appendChild(shadow.dom._to_dom(node_12081));


var G__12082 = cljs.core.next(seq__10664_12075__$1);
var G__12083 = null;
var G__12084 = (0);
var G__12085 = (0);
seq__10664_12064 = G__12082;
chunk__10665_12065 = G__12083;
count__10666_12066 = G__12084;
i__10667_12067 = G__12085;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq10651){
var self__5712__auto__ = this;
return self__5712__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq10651));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__10677_12091 = cljs.core.seq(scripts);
var chunk__10678_12092 = null;
var count__10679_12093 = (0);
var i__10680_12094 = (0);
while(true){
if((i__10680_12094 < count__10679_12093)){
var vec__10695_12095 = chunk__10678_12092.cljs$core$IIndexed$_nth$arity$2(null,i__10680_12094);
var script_tag_12096 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10695_12095,(0),null);
var script_body_12097 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10695_12095,(1),null);
eval(script_body_12097);


var G__12100 = seq__10677_12091;
var G__12101 = chunk__10678_12092;
var G__12102 = count__10679_12093;
var G__12103 = (i__10680_12094 + (1));
seq__10677_12091 = G__12100;
chunk__10678_12092 = G__12101;
count__10679_12093 = G__12102;
i__10680_12094 = G__12103;
continue;
} else {
var temp__5804__auto___12107 = cljs.core.seq(seq__10677_12091);
if(temp__5804__auto___12107){
var seq__10677_12108__$1 = temp__5804__auto___12107;
if(cljs.core.chunked_seq_QMARK_(seq__10677_12108__$1)){
var c__5525__auto___12110 = cljs.core.chunk_first(seq__10677_12108__$1);
var G__12111 = cljs.core.chunk_rest(seq__10677_12108__$1);
var G__12112 = c__5525__auto___12110;
var G__12113 = cljs.core.count(c__5525__auto___12110);
var G__12114 = (0);
seq__10677_12091 = G__12111;
chunk__10678_12092 = G__12112;
count__10679_12093 = G__12113;
i__10680_12094 = G__12114;
continue;
} else {
var vec__10708_12115 = cljs.core.first(seq__10677_12108__$1);
var script_tag_12116 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10708_12115,(0),null);
var script_body_12117 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10708_12115,(1),null);
eval(script_body_12117);


var G__12118 = cljs.core.next(seq__10677_12108__$1);
var G__12119 = null;
var G__12120 = (0);
var G__12121 = (0);
seq__10677_12091 = G__12118;
chunk__10678_12092 = G__12119;
count__10679_12093 = G__12120;
i__10680_12094 = G__12121;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__10713){
var vec__10715 = p__10713;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10715,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10715,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__10732 = arguments.length;
switch (G__10732) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__10760 = cljs.core.seq(style_keys);
var chunk__10761 = null;
var count__10762 = (0);
var i__10763 = (0);
while(true){
if((i__10763 < count__10762)){
var it = chunk__10761.cljs$core$IIndexed$_nth$arity$2(null,i__10763);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__12125 = seq__10760;
var G__12126 = chunk__10761;
var G__12127 = count__10762;
var G__12128 = (i__10763 + (1));
seq__10760 = G__12125;
chunk__10761 = G__12126;
count__10762 = G__12127;
i__10763 = G__12128;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__10760);
if(temp__5804__auto__){
var seq__10760__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10760__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__10760__$1);
var G__12129 = cljs.core.chunk_rest(seq__10760__$1);
var G__12130 = c__5525__auto__;
var G__12131 = cljs.core.count(c__5525__auto__);
var G__12132 = (0);
seq__10760 = G__12129;
chunk__10761 = G__12130;
count__10762 = G__12131;
i__10763 = G__12132;
continue;
} else {
var it = cljs.core.first(seq__10760__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__12133 = cljs.core.next(seq__10760__$1);
var G__12134 = null;
var G__12135 = (0);
var G__12136 = (0);
seq__10760 = G__12133;
chunk__10761 = G__12134;
count__10762 = G__12135;
i__10763 = G__12136;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5300__auto__,k__5301__auto__){
var self__ = this;
var this__5300__auto____$1 = this;
return this__5300__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5301__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5302__auto__,k10782,else__5303__auto__){
var self__ = this;
var this__5302__auto____$1 = this;
var G__10794 = k10782;
var G__10794__$1 = (((G__10794 instanceof cljs.core.Keyword))?G__10794.fqn:null);
switch (G__10794__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k10782,else__5303__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5320__auto__,f__5321__auto__,init__5322__auto__){
var self__ = this;
var this__5320__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5323__auto__,p__10802){
var vec__10804 = p__10802;
var k__5324__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10804,(0),null);
var v__5325__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10804,(1),null);
return (f__5321__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5321__auto__.cljs$core$IFn$_invoke$arity$3(ret__5323__auto__,k__5324__auto__,v__5325__auto__) : f__5321__auto__.call(null,ret__5323__auto__,k__5324__auto__,v__5325__auto__));
}),init__5322__auto__,this__5320__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5315__auto__,writer__5316__auto__,opts__5317__auto__){
var self__ = this;
var this__5315__auto____$1 = this;
var pr_pair__5318__auto__ = (function (keyval__5319__auto__){
return cljs.core.pr_sequential_writer(writer__5316__auto__,cljs.core.pr_writer,""," ","",opts__5317__auto__,keyval__5319__auto__);
});
return cljs.core.pr_sequential_writer(writer__5316__auto__,pr_pair__5318__auto__,"#shadow.dom.Coordinate{",", ","}",opts__5317__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__10781){
var self__ = this;
var G__10781__$1 = this;
return (new cljs.core.RecordIter((0),G__10781__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5298__auto__){
var self__ = this;
var this__5298__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5295__auto__){
var self__ = this;
var this__5295__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5304__auto__){
var self__ = this;
var this__5304__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5296__auto__){
var self__ = this;
var this__5296__auto____$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = (function (coll__5297__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__5297__auto__));
})(this__5296__auto____$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this10783,other10784){
var self__ = this;
var this10783__$1 = this;
return (((!((other10784 == null)))) && ((((this10783__$1.constructor === other10784.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this10783__$1.x,other10784.x)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this10783__$1.y,other10784.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this10783__$1.__extmap,other10784.__extmap)))))))));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5310__auto__,k__5311__auto__){
var self__ = this;
var this__5310__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__5311__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5310__auto____$1),self__.__meta),k__5311__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5311__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5307__auto__,k10782){
var self__ = this;
var this__5307__auto____$1 = this;
var G__10845 = k10782;
var G__10845__$1 = (((G__10845 instanceof cljs.core.Keyword))?G__10845.fqn:null);
switch (G__10845__$1) {
case "x":
case "y":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k10782);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5308__auto__,k__5309__auto__,G__10781){
var self__ = this;
var this__5308__auto____$1 = this;
var pred__10851 = cljs.core.keyword_identical_QMARK_;
var expr__10852 = k__5309__auto__;
if(cljs.core.truth_((pred__10851.cljs$core$IFn$_invoke$arity$2 ? pred__10851.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__10852) : pred__10851.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__10852)))){
return (new shadow.dom.Coordinate(G__10781,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__10851.cljs$core$IFn$_invoke$arity$2 ? pred__10851.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__10852) : pred__10851.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__10852)))){
return (new shadow.dom.Coordinate(self__.x,G__10781,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5309__auto__,G__10781),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5313__auto__){
var self__ = this;
var this__5313__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5299__auto__,G__10781){
var self__ = this;
var this__5299__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__10781,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5305__auto__,entry__5306__auto__){
var self__ = this;
var this__5305__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5306__auto__)){
return this__5305__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__5306__auto__,(0)),cljs.core._nth(entry__5306__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5305__auto____$1,entry__5306__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__5346__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__5346__auto__,writer__5347__auto__){
return cljs.core._write(writer__5347__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__10787){
var extmap__5342__auto__ = (function (){var G__10876 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__10787,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__10787)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__10876);
} else {
return G__10876;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__10787),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__10787),null,cljs.core.not_empty(extmap__5342__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5300__auto__,k__5301__auto__){
var self__ = this;
var this__5300__auto____$1 = this;
return this__5300__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5301__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5302__auto__,k10889,else__5303__auto__){
var self__ = this;
var this__5302__auto____$1 = this;
var G__10906 = k10889;
var G__10906__$1 = (((G__10906 instanceof cljs.core.Keyword))?G__10906.fqn:null);
switch (G__10906__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k10889,else__5303__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5320__auto__,f__5321__auto__,init__5322__auto__){
var self__ = this;
var this__5320__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5323__auto__,p__10912){
var vec__10913 = p__10912;
var k__5324__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10913,(0),null);
var v__5325__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10913,(1),null);
return (f__5321__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5321__auto__.cljs$core$IFn$_invoke$arity$3(ret__5323__auto__,k__5324__auto__,v__5325__auto__) : f__5321__auto__.call(null,ret__5323__auto__,k__5324__auto__,v__5325__auto__));
}),init__5322__auto__,this__5320__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5315__auto__,writer__5316__auto__,opts__5317__auto__){
var self__ = this;
var this__5315__auto____$1 = this;
var pr_pair__5318__auto__ = (function (keyval__5319__auto__){
return cljs.core.pr_sequential_writer(writer__5316__auto__,cljs.core.pr_writer,""," ","",opts__5317__auto__,keyval__5319__auto__);
});
return cljs.core.pr_sequential_writer(writer__5316__auto__,pr_pair__5318__auto__,"#shadow.dom.Size{",", ","}",opts__5317__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__10888){
var self__ = this;
var G__10888__$1 = this;
return (new cljs.core.RecordIter((0),G__10888__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5298__auto__){
var self__ = this;
var this__5298__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5295__auto__){
var self__ = this;
var this__5295__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5304__auto__){
var self__ = this;
var this__5304__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5296__auto__){
var self__ = this;
var this__5296__auto____$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = (function (coll__5297__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__5297__auto__));
})(this__5296__auto____$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this10890,other10891){
var self__ = this;
var this10890__$1 = this;
return (((!((other10891 == null)))) && ((((this10890__$1.constructor === other10891.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this10890__$1.w,other10891.w)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this10890__$1.h,other10891.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this10890__$1.__extmap,other10891.__extmap)))))))));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5310__auto__,k__5311__auto__){
var self__ = this;
var this__5310__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__5311__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5310__auto____$1),self__.__meta),k__5311__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5311__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5307__auto__,k10889){
var self__ = this;
var this__5307__auto____$1 = this;
var G__10943 = k10889;
var G__10943__$1 = (((G__10943 instanceof cljs.core.Keyword))?G__10943.fqn:null);
switch (G__10943__$1) {
case "w":
case "h":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k10889);

}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5308__auto__,k__5309__auto__,G__10888){
var self__ = this;
var this__5308__auto____$1 = this;
var pred__10951 = cljs.core.keyword_identical_QMARK_;
var expr__10952 = k__5309__auto__;
if(cljs.core.truth_((pred__10951.cljs$core$IFn$_invoke$arity$2 ? pred__10951.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__10952) : pred__10951.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__10952)))){
return (new shadow.dom.Size(G__10888,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__10951.cljs$core$IFn$_invoke$arity$2 ? pred__10951.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__10952) : pred__10951.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__10952)))){
return (new shadow.dom.Size(self__.w,G__10888,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5309__auto__,G__10888),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5313__auto__){
var self__ = this;
var this__5313__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5299__auto__,G__10888){
var self__ = this;
var this__5299__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__10888,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5305__auto__,entry__5306__auto__){
var self__ = this;
var this__5305__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5306__auto__)){
return this__5305__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__5306__auto__,(0)),cljs.core._nth(entry__5306__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5305__auto____$1,entry__5306__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__5346__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__5346__auto__,writer__5347__auto__){
return cljs.core._write(writer__5347__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__10896){
var extmap__5342__auto__ = (function (){var G__10971 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__10896,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__10896)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__10971);
} else {
return G__10971;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__10896),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__10896),null,cljs.core.not_empty(extmap__5342__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__5590__auto__ = opts;
var l__5591__auto__ = a__5590__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__5591__auto__)){
var G__12208 = (i + (1));
var G__12209 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__12208;
ret = G__12209;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__11008){
var vec__11009 = p__11008;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11009,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11009,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__11022 = arguments.length;
switch (G__11022) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5802__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5802__auto__)){
var child = temp__5802__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__12216 = ps;
var G__12217 = (i + (1));
el__$1 = G__12216;
i = G__12217;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__11070 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11070,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11070,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11070,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__11084_12221 = cljs.core.seq(props);
var chunk__11085_12222 = null;
var count__11086_12223 = (0);
var i__11087_12224 = (0);
while(true){
if((i__11087_12224 < count__11086_12223)){
var vec__11110_12225 = chunk__11085_12222.cljs$core$IIndexed$_nth$arity$2(null,i__11087_12224);
var k_12226 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11110_12225,(0),null);
var v_12227 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11110_12225,(1),null);
el.setAttributeNS((function (){var temp__5804__auto__ = cljs.core.namespace(k_12226);
if(cljs.core.truth_(temp__5804__auto__)){
var ns = temp__5804__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_12226),v_12227);


var G__12228 = seq__11084_12221;
var G__12229 = chunk__11085_12222;
var G__12230 = count__11086_12223;
var G__12231 = (i__11087_12224 + (1));
seq__11084_12221 = G__12228;
chunk__11085_12222 = G__12229;
count__11086_12223 = G__12230;
i__11087_12224 = G__12231;
continue;
} else {
var temp__5804__auto___12232 = cljs.core.seq(seq__11084_12221);
if(temp__5804__auto___12232){
var seq__11084_12233__$1 = temp__5804__auto___12232;
if(cljs.core.chunked_seq_QMARK_(seq__11084_12233__$1)){
var c__5525__auto___12234 = cljs.core.chunk_first(seq__11084_12233__$1);
var G__12235 = cljs.core.chunk_rest(seq__11084_12233__$1);
var G__12236 = c__5525__auto___12234;
var G__12237 = cljs.core.count(c__5525__auto___12234);
var G__12238 = (0);
seq__11084_12221 = G__12235;
chunk__11085_12222 = G__12236;
count__11086_12223 = G__12237;
i__11087_12224 = G__12238;
continue;
} else {
var vec__11117_12239 = cljs.core.first(seq__11084_12233__$1);
var k_12240 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11117_12239,(0),null);
var v_12241 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11117_12239,(1),null);
el.setAttributeNS((function (){var temp__5804__auto____$1 = cljs.core.namespace(k_12240);
if(cljs.core.truth_(temp__5804__auto____$1)){
var ns = temp__5804__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_12240),v_12241);


var G__12242 = cljs.core.next(seq__11084_12233__$1);
var G__12243 = null;
var G__12244 = (0);
var G__12245 = (0);
seq__11084_12221 = G__12242;
chunk__11085_12222 = G__12243;
count__11086_12223 = G__12244;
i__11087_12224 = G__12245;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__11139 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11139,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11139,(1),null);
var seq__11142_12247 = cljs.core.seq(node_children);
var chunk__11144_12248 = null;
var count__11145_12249 = (0);
var i__11146_12250 = (0);
while(true){
if((i__11146_12250 < count__11145_12249)){
var child_struct_12251 = chunk__11144_12248.cljs$core$IIndexed$_nth$arity$2(null,i__11146_12250);
if((!((child_struct_12251 == null)))){
if(typeof child_struct_12251 === 'string'){
var text_12252 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_12252),child_struct_12251].join(''));
} else {
var children_12253 = shadow.dom.svg_node(child_struct_12251);
if(cljs.core.seq_QMARK_(children_12253)){
var seq__11306_12254 = cljs.core.seq(children_12253);
var chunk__11308_12255 = null;
var count__11309_12256 = (0);
var i__11310_12257 = (0);
while(true){
if((i__11310_12257 < count__11309_12256)){
var child_12258 = chunk__11308_12255.cljs$core$IIndexed$_nth$arity$2(null,i__11310_12257);
if(cljs.core.truth_(child_12258)){
node.appendChild(child_12258);


var G__12259 = seq__11306_12254;
var G__12260 = chunk__11308_12255;
var G__12261 = count__11309_12256;
var G__12262 = (i__11310_12257 + (1));
seq__11306_12254 = G__12259;
chunk__11308_12255 = G__12260;
count__11309_12256 = G__12261;
i__11310_12257 = G__12262;
continue;
} else {
var G__12263 = seq__11306_12254;
var G__12264 = chunk__11308_12255;
var G__12265 = count__11309_12256;
var G__12266 = (i__11310_12257 + (1));
seq__11306_12254 = G__12263;
chunk__11308_12255 = G__12264;
count__11309_12256 = G__12265;
i__11310_12257 = G__12266;
continue;
}
} else {
var temp__5804__auto___12267 = cljs.core.seq(seq__11306_12254);
if(temp__5804__auto___12267){
var seq__11306_12268__$1 = temp__5804__auto___12267;
if(cljs.core.chunked_seq_QMARK_(seq__11306_12268__$1)){
var c__5525__auto___12269 = cljs.core.chunk_first(seq__11306_12268__$1);
var G__12270 = cljs.core.chunk_rest(seq__11306_12268__$1);
var G__12271 = c__5525__auto___12269;
var G__12272 = cljs.core.count(c__5525__auto___12269);
var G__12273 = (0);
seq__11306_12254 = G__12270;
chunk__11308_12255 = G__12271;
count__11309_12256 = G__12272;
i__11310_12257 = G__12273;
continue;
} else {
var child_12274 = cljs.core.first(seq__11306_12268__$1);
if(cljs.core.truth_(child_12274)){
node.appendChild(child_12274);


var G__12275 = cljs.core.next(seq__11306_12268__$1);
var G__12276 = null;
var G__12277 = (0);
var G__12278 = (0);
seq__11306_12254 = G__12275;
chunk__11308_12255 = G__12276;
count__11309_12256 = G__12277;
i__11310_12257 = G__12278;
continue;
} else {
var G__12279 = cljs.core.next(seq__11306_12268__$1);
var G__12280 = null;
var G__12281 = (0);
var G__12282 = (0);
seq__11306_12254 = G__12279;
chunk__11308_12255 = G__12280;
count__11309_12256 = G__12281;
i__11310_12257 = G__12282;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_12253);
}
}


var G__12283 = seq__11142_12247;
var G__12284 = chunk__11144_12248;
var G__12285 = count__11145_12249;
var G__12286 = (i__11146_12250 + (1));
seq__11142_12247 = G__12283;
chunk__11144_12248 = G__12284;
count__11145_12249 = G__12285;
i__11146_12250 = G__12286;
continue;
} else {
var G__12287 = seq__11142_12247;
var G__12288 = chunk__11144_12248;
var G__12289 = count__11145_12249;
var G__12290 = (i__11146_12250 + (1));
seq__11142_12247 = G__12287;
chunk__11144_12248 = G__12288;
count__11145_12249 = G__12289;
i__11146_12250 = G__12290;
continue;
}
} else {
var temp__5804__auto___12291 = cljs.core.seq(seq__11142_12247);
if(temp__5804__auto___12291){
var seq__11142_12292__$1 = temp__5804__auto___12291;
if(cljs.core.chunked_seq_QMARK_(seq__11142_12292__$1)){
var c__5525__auto___12293 = cljs.core.chunk_first(seq__11142_12292__$1);
var G__12294 = cljs.core.chunk_rest(seq__11142_12292__$1);
var G__12295 = c__5525__auto___12293;
var G__12296 = cljs.core.count(c__5525__auto___12293);
var G__12297 = (0);
seq__11142_12247 = G__12294;
chunk__11144_12248 = G__12295;
count__11145_12249 = G__12296;
i__11146_12250 = G__12297;
continue;
} else {
var child_struct_12298 = cljs.core.first(seq__11142_12292__$1);
if((!((child_struct_12298 == null)))){
if(typeof child_struct_12298 === 'string'){
var text_12299 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_12299),child_struct_12298].join(''));
} else {
var children_12300 = shadow.dom.svg_node(child_struct_12298);
if(cljs.core.seq_QMARK_(children_12300)){
var seq__11348_12301 = cljs.core.seq(children_12300);
var chunk__11350_12302 = null;
var count__11351_12303 = (0);
var i__11352_12304 = (0);
while(true){
if((i__11352_12304 < count__11351_12303)){
var child_12305 = chunk__11350_12302.cljs$core$IIndexed$_nth$arity$2(null,i__11352_12304);
if(cljs.core.truth_(child_12305)){
node.appendChild(child_12305);


var G__12307 = seq__11348_12301;
var G__12308 = chunk__11350_12302;
var G__12309 = count__11351_12303;
var G__12310 = (i__11352_12304 + (1));
seq__11348_12301 = G__12307;
chunk__11350_12302 = G__12308;
count__11351_12303 = G__12309;
i__11352_12304 = G__12310;
continue;
} else {
var G__12318 = seq__11348_12301;
var G__12319 = chunk__11350_12302;
var G__12320 = count__11351_12303;
var G__12321 = (i__11352_12304 + (1));
seq__11348_12301 = G__12318;
chunk__11350_12302 = G__12319;
count__11351_12303 = G__12320;
i__11352_12304 = G__12321;
continue;
}
} else {
var temp__5804__auto___12322__$1 = cljs.core.seq(seq__11348_12301);
if(temp__5804__auto___12322__$1){
var seq__11348_12324__$1 = temp__5804__auto___12322__$1;
if(cljs.core.chunked_seq_QMARK_(seq__11348_12324__$1)){
var c__5525__auto___12325 = cljs.core.chunk_first(seq__11348_12324__$1);
var G__12326 = cljs.core.chunk_rest(seq__11348_12324__$1);
var G__12327 = c__5525__auto___12325;
var G__12328 = cljs.core.count(c__5525__auto___12325);
var G__12329 = (0);
seq__11348_12301 = G__12326;
chunk__11350_12302 = G__12327;
count__11351_12303 = G__12328;
i__11352_12304 = G__12329;
continue;
} else {
var child_12330 = cljs.core.first(seq__11348_12324__$1);
if(cljs.core.truth_(child_12330)){
node.appendChild(child_12330);


var G__12331 = cljs.core.next(seq__11348_12324__$1);
var G__12332 = null;
var G__12333 = (0);
var G__12334 = (0);
seq__11348_12301 = G__12331;
chunk__11350_12302 = G__12332;
count__11351_12303 = G__12333;
i__11352_12304 = G__12334;
continue;
} else {
var G__12335 = cljs.core.next(seq__11348_12324__$1);
var G__12336 = null;
var G__12337 = (0);
var G__12338 = (0);
seq__11348_12301 = G__12335;
chunk__11350_12302 = G__12336;
count__11351_12303 = G__12337;
i__11352_12304 = G__12338;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_12300);
}
}


var G__12339 = cljs.core.next(seq__11142_12292__$1);
var G__12340 = null;
var G__12341 = (0);
var G__12342 = (0);
seq__11142_12247 = G__12339;
chunk__11144_12248 = G__12340;
count__11145_12249 = G__12341;
i__11146_12250 = G__12342;
continue;
} else {
var G__12343 = cljs.core.next(seq__11142_12292__$1);
var G__12344 = null;
var G__12345 = (0);
var G__12346 = (0);
seq__11142_12247 = G__12343;
chunk__11144_12248 = G__12344;
count__11145_12249 = G__12345;
i__11146_12250 = G__12346;
continue;
}
}
} else {
}
}
break;
}

return node;
});
(shadow.dom.SVGElement["string"] = true);

(shadow.dom._to_svg["string"] = (function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

(shadow.dom.SVGElement["null"] = true);

(shadow.dom._to_svg["null"] = (function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__5732__auto__ = [];
var len__5726__auto___12347 = arguments.length;
var i__5727__auto___12348 = (0);
while(true){
if((i__5727__auto___12348 < len__5726__auto___12347)){
args__5732__auto__.push((arguments[i__5727__auto___12348]));

var G__12349 = (i__5727__auto___12348 + (1));
i__5727__auto___12348 = G__12349;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((1) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5733__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq11449){
var G__11450 = cljs.core.first(seq11449);
var seq11449__$1 = cljs.core.next(seq11449);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__11450,seq11449__$1);
}));


//# sourceMappingURL=shadow.dom.js.map
