goog.provide('reagent.dom');
var module$node_modules$react_dom$index=shadow.js.require("module$node_modules$react_dom$index", {});
if((typeof reagent !== 'undefined') && (typeof reagent.dom !== 'undefined') && (typeof reagent.dom.roots !== 'undefined')){
} else {
reagent.dom.roots = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
}
reagent.dom.unmount_comp = (function reagent$dom$unmount_comp(container){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(reagent.dom.roots,cljs.core.dissoc,container);

return module$node_modules$react_dom$index.unmountComponentAtNode(container);
});
reagent.dom.render_comp = (function reagent$dom$render_comp(comp,container,callback){
var _STAR_always_update_STAR__orig_val__8715 = reagent.impl.util._STAR_always_update_STAR_;
var _STAR_always_update_STAR__temp_val__8716 = true;
(reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR__temp_val__8716);

try{return module$node_modules$react_dom$index.render((comp.cljs$core$IFn$_invoke$arity$0 ? comp.cljs$core$IFn$_invoke$arity$0() : comp.call(null)),container,(function (){
var _STAR_always_update_STAR__orig_val__8720 = reagent.impl.util._STAR_always_update_STAR_;
var _STAR_always_update_STAR__temp_val__8721 = false;
(reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR__temp_val__8721);

try{cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(reagent.dom.roots,cljs.core.assoc,container,comp);

reagent.impl.batching.flush_after_render();

if((!((callback == null)))){
return (callback.cljs$core$IFn$_invoke$arity$0 ? callback.cljs$core$IFn$_invoke$arity$0() : callback.call(null));
} else {
return null;
}
}finally {(reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR__orig_val__8720);
}}));
}finally {(reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR__orig_val__8715);
}});
reagent.dom.re_render_component = (function reagent$dom$re_render_component(comp,container){
return reagent.dom.render_comp(comp,container,null);
});
/**
 * Render a Reagent component into the DOM. The first argument may be
 *   either a vector (using Reagent's Hiccup syntax), or a React element.
 *   The second argument should be a DOM node.
 * 
 *   Optionally takes a callback that is called when the component is in place.
 * 
 *   Returns the mounted component instance.
 */
reagent.dom.render = (function reagent$dom$render(var_args){
var G__8736 = arguments.length;
switch (G__8736) {
case 2:
return reagent.dom.render.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return reagent.dom.render.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(reagent.dom.render.cljs$core$IFn$_invoke$arity$2 = (function (comp,container){
return reagent.dom.render.cljs$core$IFn$_invoke$arity$3(comp,container,reagent.impl.template._STAR_current_default_compiler_STAR_);
}));

(reagent.dom.render.cljs$core$IFn$_invoke$arity$3 = (function (comp,container,callback_or_compiler){
reagent.ratom.flush_BANG_();

var vec__8738 = ((cljs.core.map_QMARK_(callback_or_compiler))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compiler","compiler",-267926731).cljs$core$IFn$_invoke$arity$1(callback_or_compiler),new cljs.core.Keyword(null,"callback","callback",-705136228).cljs$core$IFn$_invoke$arity$1(callback_or_compiler)], null):((cljs.core.fn_QMARK_(callback_or_compiler))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [reagent.impl.template._STAR_current_default_compiler_STAR_,callback_or_compiler], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [callback_or_compiler,null], null)
));
var compiler = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8738,(0),null);
var callback = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8738,(1),null);
var f = (function (){
return reagent.impl.protocols.as_element(compiler,((cljs.core.fn_QMARK_(comp))?(comp.cljs$core$IFn$_invoke$arity$0 ? comp.cljs$core$IFn$_invoke$arity$0() : comp.call(null)):comp));
});
return reagent.dom.render_comp(f,container,callback);
}));

(reagent.dom.render.cljs$lang$maxFixedArity = 3);

/**
 * Remove a component from the given DOM node.
 */
reagent.dom.unmount_component_at_node = (function reagent$dom$unmount_component_at_node(container){
return reagent.dom.unmount_comp(container);
});
/**
 * Returns the root DOM node of a mounted component.
 */
reagent.dom.dom_node = (function reagent$dom$dom_node(this$){
return module$node_modules$react_dom$index.findDOMNode(this$);
});
/**
 * Force re-rendering of all mounted Reagent components. This is
 *   probably only useful in a development environment, when you want to
 *   update components in response to some dynamic changes to code.
 * 
 *   Note that force-update-all may not update root components. This
 *   happens if a component 'foo' is mounted with `(render [foo])` (since
 *   functions are passed by value, and not by reference, in
 *   ClojureScript). To get around this you'll have to introduce a layer
 *   of indirection, for example by using `(render [#'foo])` instead.
 */
reagent.dom.force_update_all = (function reagent$dom$force_update_all(){
reagent.ratom.flush_BANG_();

var seq__8762_8831 = cljs.core.seq(cljs.core.deref(reagent.dom.roots));
var chunk__8763_8832 = null;
var count__8764_8833 = (0);
var i__8765_8834 = (0);
while(true){
if((i__8765_8834 < count__8764_8833)){
var vec__8814_8835 = chunk__8763_8832.cljs$core$IIndexed$_nth$arity$2(null,i__8765_8834);
var container_8836 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8814_8835,(0),null);
var comp_8837 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8814_8835,(1),null);
reagent.dom.re_render_component(comp_8837,container_8836);


var G__8838 = seq__8762_8831;
var G__8839 = chunk__8763_8832;
var G__8840 = count__8764_8833;
var G__8841 = (i__8765_8834 + (1));
seq__8762_8831 = G__8838;
chunk__8763_8832 = G__8839;
count__8764_8833 = G__8840;
i__8765_8834 = G__8841;
continue;
} else {
var temp__5804__auto___8842 = cljs.core.seq(seq__8762_8831);
if(temp__5804__auto___8842){
var seq__8762_8843__$1 = temp__5804__auto___8842;
if(cljs.core.chunked_seq_QMARK_(seq__8762_8843__$1)){
var c__5525__auto___8844 = cljs.core.chunk_first(seq__8762_8843__$1);
var G__8845 = cljs.core.chunk_rest(seq__8762_8843__$1);
var G__8846 = c__5525__auto___8844;
var G__8847 = cljs.core.count(c__5525__auto___8844);
var G__8848 = (0);
seq__8762_8831 = G__8845;
chunk__8763_8832 = G__8846;
count__8764_8833 = G__8847;
i__8765_8834 = G__8848;
continue;
} else {
var vec__8822_8849 = cljs.core.first(seq__8762_8843__$1);
var container_8850 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8822_8849,(0),null);
var comp_8851 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8822_8849,(1),null);
reagent.dom.re_render_component(comp_8851,container_8850);


var G__8940 = cljs.core.next(seq__8762_8843__$1);
var G__8941 = null;
var G__8942 = (0);
var G__8943 = (0);
seq__8762_8831 = G__8940;
chunk__8763_8832 = G__8941;
count__8764_8833 = G__8942;
i__8765_8834 = G__8943;
continue;
}
} else {
}
}
break;
}

return reagent.impl.batching.flush_after_render();
});

//# sourceMappingURL=reagent.dom.js.map
