goog.provide('cljs.core.async');
goog.scope(function(){
  cljs.core.async.goog$module$goog$array = goog.module.get('goog.array');
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12466 = (function (f,blockable,meta12467){
this.f = f;
this.blockable = blockable;
this.meta12467 = meta12467;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12466.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12468,meta12467__$1){
var self__ = this;
var _12468__$1 = this;
return (new cljs.core.async.t_cljs$core$async12466(self__.f,self__.blockable,meta12467__$1));
}));

(cljs.core.async.t_cljs$core$async12466.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12468){
var self__ = this;
var _12468__$1 = this;
return self__.meta12467;
}));

(cljs.core.async.t_cljs$core$async12466.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12466.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async12466.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async12466.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async12466.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta12467","meta12467",-1749102253,null)], null);
}));

(cljs.core.async.t_cljs$core$async12466.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12466.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12466");

(cljs.core.async.t_cljs$core$async12466.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async12466");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12466.
 */
cljs.core.async.__GT_t_cljs$core$async12466 = (function cljs$core$async$__GT_t_cljs$core$async12466(f,blockable,meta12467){
return (new cljs.core.async.t_cljs$core$async12466(f,blockable,meta12467));
});


cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__12464 = arguments.length;
switch (G__12464) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
return (new cljs.core.async.t_cljs$core$async12466(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__12473 = arguments.length;
switch (G__12473) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__12476 = arguments.length;
switch (G__12476) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__12478 = arguments.length;
switch (G__12478) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_15000 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_15000) : fn1.call(null,val_15000));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_15000) : fn1.call(null,val_15000));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__12480 = arguments.length;
switch (G__12480) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5802__auto__)){
var ret = temp__5802__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5802__auto__)){
var retb = temp__5802__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5593__auto___15006 = n;
var x_15007 = (0);
while(true){
if((x_15007 < n__5593__auto___15006)){
(a[x_15007] = x_15007);

var G__15008 = (x_15007 + (1));
x_15007 = G__15008;
continue;
} else {
}
break;
}

cljs.core.async.goog$module$goog$array.shuffle(a);

return a;
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12481 = (function (flag,meta12482){
this.flag = flag;
this.meta12482 = meta12482;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12481.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12483,meta12482__$1){
var self__ = this;
var _12483__$1 = this;
return (new cljs.core.async.t_cljs$core$async12481(self__.flag,meta12482__$1));
}));

(cljs.core.async.t_cljs$core$async12481.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12483){
var self__ = this;
var _12483__$1 = this;
return self__.meta12482;
}));

(cljs.core.async.t_cljs$core$async12481.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12481.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async12481.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async12481.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async12481.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta12482","meta12482",849027626,null)], null);
}));

(cljs.core.async.t_cljs$core$async12481.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12481.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12481");

(cljs.core.async.t_cljs$core$async12481.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async12481");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12481.
 */
cljs.core.async.__GT_t_cljs$core$async12481 = (function cljs$core$async$__GT_t_cljs$core$async12481(flag,meta12482){
return (new cljs.core.async.t_cljs$core$async12481(flag,meta12482));
});


cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
return (new cljs.core.async.t_cljs$core$async12481(flag,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12484 = (function (flag,cb,meta12485){
this.flag = flag;
this.cb = cb;
this.meta12485 = meta12485;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12484.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12486,meta12485__$1){
var self__ = this;
var _12486__$1 = this;
return (new cljs.core.async.t_cljs$core$async12484(self__.flag,self__.cb,meta12485__$1));
}));

(cljs.core.async.t_cljs$core$async12484.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12486){
var self__ = this;
var _12486__$1 = this;
return self__.meta12485;
}));

(cljs.core.async.t_cljs$core$async12484.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12484.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async12484.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async12484.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async12484.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta12485","meta12485",109725984,null)], null);
}));

(cljs.core.async.t_cljs$core$async12484.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12484.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12484");

(cljs.core.async.t_cljs$core$async12484.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async12484");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12484.
 */
cljs.core.async.__GT_t_cljs$core$async12484 = (function cljs$core$async$__GT_t_cljs$core$async12484(flag,cb,meta12485){
return (new cljs.core.async.t_cljs$core$async12484(flag,cb,meta12485));
});


cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
return (new cljs.core.async.t_cljs$core$async12484(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__12487_SHARP_){
var G__12489 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__12487_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__12489) : fret.call(null,G__12489));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__12488_SHARP_){
var G__12490 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__12488_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__12490) : fret.call(null,G__12490));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__5002__auto__ = wport;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return port;
}
})()], null));
} else {
var G__15024 = (i + (1));
i = G__15024;
continue;
}
} else {
return null;
}
break;
}
})();
var or__5002__auto__ = ret;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5804__auto__ = (function (){var and__5000__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__5000__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__5000__auto__;
}
})();
if(cljs.core.truth_(temp__5804__auto__)){
var got = temp__5804__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5732__auto__ = [];
var len__5726__auto___15026 = arguments.length;
var i__5727__auto___15027 = (0);
while(true){
if((i__5727__auto___15027 < len__5726__auto___15026)){
args__5732__auto__.push((arguments[i__5727__auto___15027]));

var G__15028 = (i__5727__auto___15027 + (1));
i__5727__auto___15027 = G__15028;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((1) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5733__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__12498){
var map__12500 = p__12498;
var map__12500__$1 = cljs.core.__destructure_map(map__12500);
var opts = map__12500__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq12495){
var G__12496 = cljs.core.first(seq12495);
var seq12495__$1 = cljs.core.next(seq12495);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12496,seq12495__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__12508 = arguments.length;
switch (G__12508) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__12385__auto___15031 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12386__auto__ = (function (){var switch__12086__auto__ = (function (state_12541){
var state_val_12542 = (state_12541[(1)]);
if((state_val_12542 === (7))){
var inst_12537 = (state_12541[(2)]);
var state_12541__$1 = state_12541;
var statearr_12546_15033 = state_12541__$1;
(statearr_12546_15033[(2)] = inst_12537);

(statearr_12546_15033[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12542 === (1))){
var state_12541__$1 = state_12541;
var statearr_12547_15034 = state_12541__$1;
(statearr_12547_15034[(2)] = null);

(statearr_12547_15034[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12542 === (4))){
var inst_12520 = (state_12541[(7)]);
var inst_12520__$1 = (state_12541[(2)]);
var inst_12521 = (inst_12520__$1 == null);
var state_12541__$1 = (function (){var statearr_12558 = state_12541;
(statearr_12558[(7)] = inst_12520__$1);

return statearr_12558;
})();
if(cljs.core.truth_(inst_12521)){
var statearr_12559_15035 = state_12541__$1;
(statearr_12559_15035[(1)] = (5));

} else {
var statearr_12560_15036 = state_12541__$1;
(statearr_12560_15036[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12542 === (13))){
var state_12541__$1 = state_12541;
var statearr_12561_15037 = state_12541__$1;
(statearr_12561_15037[(2)] = null);

(statearr_12561_15037[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12542 === (6))){
var inst_12520 = (state_12541[(7)]);
var state_12541__$1 = state_12541;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12541__$1,(11),to,inst_12520);
} else {
if((state_val_12542 === (3))){
var inst_12539 = (state_12541[(2)]);
var state_12541__$1 = state_12541;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12541__$1,inst_12539);
} else {
if((state_val_12542 === (12))){
var state_12541__$1 = state_12541;
var statearr_12562_15038 = state_12541__$1;
(statearr_12562_15038[(2)] = null);

(statearr_12562_15038[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12542 === (2))){
var state_12541__$1 = state_12541;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12541__$1,(4),from);
} else {
if((state_val_12542 === (11))){
var inst_12530 = (state_12541[(2)]);
var state_12541__$1 = state_12541;
if(cljs.core.truth_(inst_12530)){
var statearr_12563_15039 = state_12541__$1;
(statearr_12563_15039[(1)] = (12));

} else {
var statearr_12564_15040 = state_12541__$1;
(statearr_12564_15040[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12542 === (9))){
var state_12541__$1 = state_12541;
var statearr_12565_15041 = state_12541__$1;
(statearr_12565_15041[(2)] = null);

(statearr_12565_15041[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12542 === (5))){
var state_12541__$1 = state_12541;
if(cljs.core.truth_(close_QMARK_)){
var statearr_12566_15042 = state_12541__$1;
(statearr_12566_15042[(1)] = (8));

} else {
var statearr_12567_15043 = state_12541__$1;
(statearr_12567_15043[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12542 === (14))){
var inst_12535 = (state_12541[(2)]);
var state_12541__$1 = state_12541;
var statearr_12568_15044 = state_12541__$1;
(statearr_12568_15044[(2)] = inst_12535);

(statearr_12568_15044[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12542 === (10))){
var inst_12527 = (state_12541[(2)]);
var state_12541__$1 = state_12541;
var statearr_12569_15048 = state_12541__$1;
(statearr_12569_15048[(2)] = inst_12527);

(statearr_12569_15048[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12542 === (8))){
var inst_12524 = cljs.core.async.close_BANG_(to);
var state_12541__$1 = state_12541;
var statearr_12570_15049 = state_12541__$1;
(statearr_12570_15049[(2)] = inst_12524);

(statearr_12570_15049[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__12087__auto__ = null;
var cljs$core$async$state_machine__12087__auto____0 = (function (){
var statearr_12577 = [null,null,null,null,null,null,null,null];
(statearr_12577[(0)] = cljs$core$async$state_machine__12087__auto__);

(statearr_12577[(1)] = (1));

return statearr_12577;
});
var cljs$core$async$state_machine__12087__auto____1 = (function (state_12541){
while(true){
var ret_value__12088__auto__ = (function (){try{while(true){
var result__12089__auto__ = switch__12086__auto__(state_12541);
if(cljs.core.keyword_identical_QMARK_(result__12089__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12089__auto__;
}
break;
}
}catch (e12578){var ex__12090__auto__ = e12578;
var statearr_12579_15051 = state_12541;
(statearr_12579_15051[(2)] = ex__12090__auto__);


if(cljs.core.seq((state_12541[(4)]))){
var statearr_12580_15052 = state_12541;
(statearr_12580_15052[(1)] = cljs.core.first((state_12541[(4)])));

} else {
throw ex__12090__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15053 = state_12541;
state_12541 = G__15053;
continue;
} else {
return ret_value__12088__auto__;
}
break;
}
});
cljs$core$async$state_machine__12087__auto__ = function(state_12541){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12087__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12087__auto____1.call(this,state_12541);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12087__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12087__auto____0;
cljs$core$async$state_machine__12087__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12087__auto____1;
return cljs$core$async$state_machine__12087__auto__;
})()
})();
var state__12387__auto__ = (function (){var statearr_12581 = f__12386__auto__();
(statearr_12581[(6)] = c__12385__auto___15031);

return statearr_12581;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12387__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process__$1 = (function (p__12596){
var vec__12597 = p__12596;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12597,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12597,(1),null);
var job = vec__12597;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__12385__auto___15062 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12386__auto__ = (function (){var switch__12086__auto__ = (function (state_12604){
var state_val_12605 = (state_12604[(1)]);
if((state_val_12605 === (1))){
var state_12604__$1 = state_12604;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12604__$1,(2),res,v);
} else {
if((state_val_12605 === (2))){
var inst_12601 = (state_12604[(2)]);
var inst_12602 = cljs.core.async.close_BANG_(res);
var state_12604__$1 = (function (){var statearr_12614 = state_12604;
(statearr_12614[(7)] = inst_12601);

return statearr_12614;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_12604__$1,inst_12602);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12087__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12087__auto____0 = (function (){
var statearr_12624 = [null,null,null,null,null,null,null,null];
(statearr_12624[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12087__auto__);

(statearr_12624[(1)] = (1));

return statearr_12624;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12087__auto____1 = (function (state_12604){
while(true){
var ret_value__12088__auto__ = (function (){try{while(true){
var result__12089__auto__ = switch__12086__auto__(state_12604);
if(cljs.core.keyword_identical_QMARK_(result__12089__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12089__auto__;
}
break;
}
}catch (e12625){var ex__12090__auto__ = e12625;
var statearr_12626_15074 = state_12604;
(statearr_12626_15074[(2)] = ex__12090__auto__);


if(cljs.core.seq((state_12604[(4)]))){
var statearr_12627_15075 = state_12604;
(statearr_12627_15075[(1)] = cljs.core.first((state_12604[(4)])));

} else {
throw ex__12090__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15076 = state_12604;
state_12604 = G__15076;
continue;
} else {
return ret_value__12088__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12087__auto__ = function(state_12604){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12087__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12087__auto____1.call(this,state_12604);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12087__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12087__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12087__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12087__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12087__auto__;
})()
})();
var state__12387__auto__ = (function (){var statearr_12629 = f__12386__auto__();
(statearr_12629[(6)] = c__12385__auto___15062);

return statearr_12629;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12387__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__12630){
var vec__12631 = p__12630;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12631,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12631,(1),null);
var job = vec__12631;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__5593__auto___15080 = n;
var __15081 = (0);
while(true){
if((__15081 < n__5593__auto___15080)){
var G__12637_15082 = type;
var G__12637_15083__$1 = (((G__12637_15082 instanceof cljs.core.Keyword))?G__12637_15082.fqn:null);
switch (G__12637_15083__$1) {
case "compute":
var c__12385__auto___15089 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__15081,c__12385__auto___15089,G__12637_15082,G__12637_15083__$1,n__5593__auto___15080,jobs,results,process__$1,async){
return (function (){
var f__12386__auto__ = (function (){var switch__12086__auto__ = ((function (__15081,c__12385__auto___15089,G__12637_15082,G__12637_15083__$1,n__5593__auto___15080,jobs,results,process__$1,async){
return (function (state_12654){
var state_val_12655 = (state_12654[(1)]);
if((state_val_12655 === (1))){
var state_12654__$1 = state_12654;
var statearr_12661_15091 = state_12654__$1;
(statearr_12661_15091[(2)] = null);

(statearr_12661_15091[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12655 === (2))){
var state_12654__$1 = state_12654;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12654__$1,(4),jobs);
} else {
if((state_val_12655 === (3))){
var inst_12652 = (state_12654[(2)]);
var state_12654__$1 = state_12654;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12654__$1,inst_12652);
} else {
if((state_val_12655 === (4))){
var inst_12644 = (state_12654[(2)]);
var inst_12645 = process__$1(inst_12644);
var state_12654__$1 = state_12654;
if(cljs.core.truth_(inst_12645)){
var statearr_12668_15100 = state_12654__$1;
(statearr_12668_15100[(1)] = (5));

} else {
var statearr_12671_15102 = state_12654__$1;
(statearr_12671_15102[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12655 === (5))){
var state_12654__$1 = state_12654;
var statearr_12674_15103 = state_12654__$1;
(statearr_12674_15103[(2)] = null);

(statearr_12674_15103[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12655 === (6))){
var state_12654__$1 = state_12654;
var statearr_12680_15106 = state_12654__$1;
(statearr_12680_15106[(2)] = null);

(statearr_12680_15106[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12655 === (7))){
var inst_12650 = (state_12654[(2)]);
var state_12654__$1 = state_12654;
var statearr_12692_15109 = state_12654__$1;
(statearr_12692_15109[(2)] = inst_12650);

(statearr_12692_15109[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__15081,c__12385__auto___15089,G__12637_15082,G__12637_15083__$1,n__5593__auto___15080,jobs,results,process__$1,async))
;
return ((function (__15081,switch__12086__auto__,c__12385__auto___15089,G__12637_15082,G__12637_15083__$1,n__5593__auto___15080,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12087__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12087__auto____0 = (function (){
var statearr_12708 = [null,null,null,null,null,null,null];
(statearr_12708[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12087__auto__);

(statearr_12708[(1)] = (1));

return statearr_12708;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12087__auto____1 = (function (state_12654){
while(true){
var ret_value__12088__auto__ = (function (){try{while(true){
var result__12089__auto__ = switch__12086__auto__(state_12654);
if(cljs.core.keyword_identical_QMARK_(result__12089__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12089__auto__;
}
break;
}
}catch (e12709){var ex__12090__auto__ = e12709;
var statearr_12710_15110 = state_12654;
(statearr_12710_15110[(2)] = ex__12090__auto__);


if(cljs.core.seq((state_12654[(4)]))){
var statearr_12712_15111 = state_12654;
(statearr_12712_15111[(1)] = cljs.core.first((state_12654[(4)])));

} else {
throw ex__12090__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15112 = state_12654;
state_12654 = G__15112;
continue;
} else {
return ret_value__12088__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12087__auto__ = function(state_12654){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12087__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12087__auto____1.call(this,state_12654);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12087__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12087__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12087__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12087__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12087__auto__;
})()
;})(__15081,switch__12086__auto__,c__12385__auto___15089,G__12637_15082,G__12637_15083__$1,n__5593__auto___15080,jobs,results,process__$1,async))
})();
var state__12387__auto__ = (function (){var statearr_12717 = f__12386__auto__();
(statearr_12717[(6)] = c__12385__auto___15089);

return statearr_12717;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12387__auto__);
});})(__15081,c__12385__auto___15089,G__12637_15082,G__12637_15083__$1,n__5593__auto___15080,jobs,results,process__$1,async))
);


break;
case "async":
var c__12385__auto___15116 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__15081,c__12385__auto___15116,G__12637_15082,G__12637_15083__$1,n__5593__auto___15080,jobs,results,process__$1,async){
return (function (){
var f__12386__auto__ = (function (){var switch__12086__auto__ = ((function (__15081,c__12385__auto___15116,G__12637_15082,G__12637_15083__$1,n__5593__auto___15080,jobs,results,process__$1,async){
return (function (state_12731){
var state_val_12732 = (state_12731[(1)]);
if((state_val_12732 === (1))){
var state_12731__$1 = state_12731;
var statearr_12738_15124 = state_12731__$1;
(statearr_12738_15124[(2)] = null);

(statearr_12738_15124[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12732 === (2))){
var state_12731__$1 = state_12731;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12731__$1,(4),jobs);
} else {
if((state_val_12732 === (3))){
var inst_12729 = (state_12731[(2)]);
var state_12731__$1 = state_12731;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12731__$1,inst_12729);
} else {
if((state_val_12732 === (4))){
var inst_12721 = (state_12731[(2)]);
var inst_12722 = async(inst_12721);
var state_12731__$1 = state_12731;
if(cljs.core.truth_(inst_12722)){
var statearr_12744_15134 = state_12731__$1;
(statearr_12744_15134[(1)] = (5));

} else {
var statearr_12745_15135 = state_12731__$1;
(statearr_12745_15135[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12732 === (5))){
var state_12731__$1 = state_12731;
var statearr_12746_15140 = state_12731__$1;
(statearr_12746_15140[(2)] = null);

(statearr_12746_15140[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12732 === (6))){
var state_12731__$1 = state_12731;
var statearr_12749_15141 = state_12731__$1;
(statearr_12749_15141[(2)] = null);

(statearr_12749_15141[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12732 === (7))){
var inst_12727 = (state_12731[(2)]);
var state_12731__$1 = state_12731;
var statearr_12752_15142 = state_12731__$1;
(statearr_12752_15142[(2)] = inst_12727);

(statearr_12752_15142[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__15081,c__12385__auto___15116,G__12637_15082,G__12637_15083__$1,n__5593__auto___15080,jobs,results,process__$1,async))
;
return ((function (__15081,switch__12086__auto__,c__12385__auto___15116,G__12637_15082,G__12637_15083__$1,n__5593__auto___15080,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12087__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12087__auto____0 = (function (){
var statearr_12754 = [null,null,null,null,null,null,null];
(statearr_12754[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12087__auto__);

(statearr_12754[(1)] = (1));

return statearr_12754;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12087__auto____1 = (function (state_12731){
while(true){
var ret_value__12088__auto__ = (function (){try{while(true){
var result__12089__auto__ = switch__12086__auto__(state_12731);
if(cljs.core.keyword_identical_QMARK_(result__12089__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12089__auto__;
}
break;
}
}catch (e12756){var ex__12090__auto__ = e12756;
var statearr_12757_15145 = state_12731;
(statearr_12757_15145[(2)] = ex__12090__auto__);


if(cljs.core.seq((state_12731[(4)]))){
var statearr_12758_15146 = state_12731;
(statearr_12758_15146[(1)] = cljs.core.first((state_12731[(4)])));

} else {
throw ex__12090__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15147 = state_12731;
state_12731 = G__15147;
continue;
} else {
return ret_value__12088__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12087__auto__ = function(state_12731){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12087__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12087__auto____1.call(this,state_12731);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12087__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12087__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12087__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12087__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12087__auto__;
})()
;})(__15081,switch__12086__auto__,c__12385__auto___15116,G__12637_15082,G__12637_15083__$1,n__5593__auto___15080,jobs,results,process__$1,async))
})();
var state__12387__auto__ = (function (){var statearr_12763 = f__12386__auto__();
(statearr_12763[(6)] = c__12385__auto___15116);

return statearr_12763;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12387__auto__);
});})(__15081,c__12385__auto___15116,G__12637_15082,G__12637_15083__$1,n__5593__auto___15080,jobs,results,process__$1,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__12637_15083__$1)].join('')));

}

var G__15148 = (__15081 + (1));
__15081 = G__15148;
continue;
} else {
}
break;
}

var c__12385__auto___15149 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12386__auto__ = (function (){var switch__12086__auto__ = (function (state_12811){
var state_val_12812 = (state_12811[(1)]);
if((state_val_12812 === (7))){
var inst_12806 = (state_12811[(2)]);
var state_12811__$1 = state_12811;
var statearr_12826_15150 = state_12811__$1;
(statearr_12826_15150[(2)] = inst_12806);

(statearr_12826_15150[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12812 === (1))){
var state_12811__$1 = state_12811;
var statearr_12829_15151 = state_12811__$1;
(statearr_12829_15151[(2)] = null);

(statearr_12829_15151[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12812 === (4))){
var inst_12779 = (state_12811[(7)]);
var inst_12779__$1 = (state_12811[(2)]);
var inst_12780 = (inst_12779__$1 == null);
var state_12811__$1 = (function (){var statearr_12836 = state_12811;
(statearr_12836[(7)] = inst_12779__$1);

return statearr_12836;
})();
if(cljs.core.truth_(inst_12780)){
var statearr_12837_15152 = state_12811__$1;
(statearr_12837_15152[(1)] = (5));

} else {
var statearr_12838_15153 = state_12811__$1;
(statearr_12838_15153[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12812 === (6))){
var inst_12779 = (state_12811[(7)]);
var inst_12788 = (state_12811[(8)]);
var inst_12788__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_12789 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_12794 = [inst_12779,inst_12788__$1];
var inst_12795 = (new cljs.core.PersistentVector(null,2,(5),inst_12789,inst_12794,null));
var state_12811__$1 = (function (){var statearr_12844 = state_12811;
(statearr_12844[(8)] = inst_12788__$1);

return statearr_12844;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12811__$1,(8),jobs,inst_12795);
} else {
if((state_val_12812 === (3))){
var inst_12808 = (state_12811[(2)]);
var state_12811__$1 = state_12811;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12811__$1,inst_12808);
} else {
if((state_val_12812 === (2))){
var state_12811__$1 = state_12811;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12811__$1,(4),from);
} else {
if((state_val_12812 === (9))){
var inst_12803 = (state_12811[(2)]);
var state_12811__$1 = (function (){var statearr_12850 = state_12811;
(statearr_12850[(9)] = inst_12803);

return statearr_12850;
})();
var statearr_12857_15154 = state_12811__$1;
(statearr_12857_15154[(2)] = null);

(statearr_12857_15154[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12812 === (5))){
var inst_12782 = cljs.core.async.close_BANG_(jobs);
var state_12811__$1 = state_12811;
var statearr_12859_15155 = state_12811__$1;
(statearr_12859_15155[(2)] = inst_12782);

(statearr_12859_15155[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12812 === (8))){
var inst_12788 = (state_12811[(8)]);
var inst_12797 = (state_12811[(2)]);
var state_12811__$1 = (function (){var statearr_12860 = state_12811;
(statearr_12860[(10)] = inst_12797);

return statearr_12860;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12811__$1,(9),results,inst_12788);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12087__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12087__auto____0 = (function (){
var statearr_12861 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_12861[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12087__auto__);

(statearr_12861[(1)] = (1));

return statearr_12861;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12087__auto____1 = (function (state_12811){
while(true){
var ret_value__12088__auto__ = (function (){try{while(true){
var result__12089__auto__ = switch__12086__auto__(state_12811);
if(cljs.core.keyword_identical_QMARK_(result__12089__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12089__auto__;
}
break;
}
}catch (e12862){var ex__12090__auto__ = e12862;
var statearr_12866_15156 = state_12811;
(statearr_12866_15156[(2)] = ex__12090__auto__);


if(cljs.core.seq((state_12811[(4)]))){
var statearr_12870_15157 = state_12811;
(statearr_12870_15157[(1)] = cljs.core.first((state_12811[(4)])));

} else {
throw ex__12090__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15158 = state_12811;
state_12811 = G__15158;
continue;
} else {
return ret_value__12088__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12087__auto__ = function(state_12811){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12087__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12087__auto____1.call(this,state_12811);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12087__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12087__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12087__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12087__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12087__auto__;
})()
})();
var state__12387__auto__ = (function (){var statearr_12879 = f__12386__auto__();
(statearr_12879[(6)] = c__12385__auto___15149);

return statearr_12879;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12387__auto__);
}));


var c__12385__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12386__auto__ = (function (){var switch__12086__auto__ = (function (state_12924){
var state_val_12925 = (state_12924[(1)]);
if((state_val_12925 === (7))){
var inst_12920 = (state_12924[(2)]);
var state_12924__$1 = state_12924;
var statearr_12926_15162 = state_12924__$1;
(statearr_12926_15162[(2)] = inst_12920);

(statearr_12926_15162[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12925 === (20))){
var state_12924__$1 = state_12924;
var statearr_12927_15163 = state_12924__$1;
(statearr_12927_15163[(2)] = null);

(statearr_12927_15163[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12925 === (1))){
var state_12924__$1 = state_12924;
var statearr_12929_15164 = state_12924__$1;
(statearr_12929_15164[(2)] = null);

(statearr_12929_15164[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12925 === (4))){
var inst_12888 = (state_12924[(7)]);
var inst_12888__$1 = (state_12924[(2)]);
var inst_12889 = (inst_12888__$1 == null);
var state_12924__$1 = (function (){var statearr_12930 = state_12924;
(statearr_12930[(7)] = inst_12888__$1);

return statearr_12930;
})();
if(cljs.core.truth_(inst_12889)){
var statearr_12931_15165 = state_12924__$1;
(statearr_12931_15165[(1)] = (5));

} else {
var statearr_12932_15172 = state_12924__$1;
(statearr_12932_15172[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12925 === (15))){
var inst_12901 = (state_12924[(8)]);
var state_12924__$1 = state_12924;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12924__$1,(18),to,inst_12901);
} else {
if((state_val_12925 === (21))){
var inst_12915 = (state_12924[(2)]);
var state_12924__$1 = state_12924;
var statearr_12934_15177 = state_12924__$1;
(statearr_12934_15177[(2)] = inst_12915);

(statearr_12934_15177[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12925 === (13))){
var inst_12917 = (state_12924[(2)]);
var state_12924__$1 = (function (){var statearr_12938 = state_12924;
(statearr_12938[(9)] = inst_12917);

return statearr_12938;
})();
var statearr_12939_15178 = state_12924__$1;
(statearr_12939_15178[(2)] = null);

(statearr_12939_15178[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12925 === (6))){
var inst_12888 = (state_12924[(7)]);
var state_12924__$1 = state_12924;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12924__$1,(11),inst_12888);
} else {
if((state_val_12925 === (17))){
var inst_12910 = (state_12924[(2)]);
var state_12924__$1 = state_12924;
if(cljs.core.truth_(inst_12910)){
var statearr_12944_15179 = state_12924__$1;
(statearr_12944_15179[(1)] = (19));

} else {
var statearr_12945_15180 = state_12924__$1;
(statearr_12945_15180[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12925 === (3))){
var inst_12922 = (state_12924[(2)]);
var state_12924__$1 = state_12924;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12924__$1,inst_12922);
} else {
if((state_val_12925 === (12))){
var inst_12898 = (state_12924[(10)]);
var state_12924__$1 = state_12924;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12924__$1,(14),inst_12898);
} else {
if((state_val_12925 === (2))){
var state_12924__$1 = state_12924;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12924__$1,(4),results);
} else {
if((state_val_12925 === (19))){
var state_12924__$1 = state_12924;
var statearr_12951_15181 = state_12924__$1;
(statearr_12951_15181[(2)] = null);

(statearr_12951_15181[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12925 === (11))){
var inst_12898 = (state_12924[(2)]);
var state_12924__$1 = (function (){var statearr_12955 = state_12924;
(statearr_12955[(10)] = inst_12898);

return statearr_12955;
})();
var statearr_12956_15182 = state_12924__$1;
(statearr_12956_15182[(2)] = null);

(statearr_12956_15182[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12925 === (9))){
var state_12924__$1 = state_12924;
var statearr_12957_15183 = state_12924__$1;
(statearr_12957_15183[(2)] = null);

(statearr_12957_15183[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12925 === (5))){
var state_12924__$1 = state_12924;
if(cljs.core.truth_(close_QMARK_)){
var statearr_12959_15184 = state_12924__$1;
(statearr_12959_15184[(1)] = (8));

} else {
var statearr_12960_15185 = state_12924__$1;
(statearr_12960_15185[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12925 === (14))){
var inst_12904 = (state_12924[(11)]);
var inst_12901 = (state_12924[(8)]);
var inst_12901__$1 = (state_12924[(2)]);
var inst_12903 = (inst_12901__$1 == null);
var inst_12904__$1 = cljs.core.not(inst_12903);
var state_12924__$1 = (function (){var statearr_12964 = state_12924;
(statearr_12964[(11)] = inst_12904__$1);

(statearr_12964[(8)] = inst_12901__$1);

return statearr_12964;
})();
if(inst_12904__$1){
var statearr_12965_15186 = state_12924__$1;
(statearr_12965_15186[(1)] = (15));

} else {
var statearr_12969_15187 = state_12924__$1;
(statearr_12969_15187[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12925 === (16))){
var inst_12904 = (state_12924[(11)]);
var state_12924__$1 = state_12924;
var statearr_12970_15188 = state_12924__$1;
(statearr_12970_15188[(2)] = inst_12904);

(statearr_12970_15188[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12925 === (10))){
var inst_12895 = (state_12924[(2)]);
var state_12924__$1 = state_12924;
var statearr_12972_15189 = state_12924__$1;
(statearr_12972_15189[(2)] = inst_12895);

(statearr_12972_15189[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12925 === (18))){
var inst_12907 = (state_12924[(2)]);
var state_12924__$1 = state_12924;
var statearr_12973_15190 = state_12924__$1;
(statearr_12973_15190[(2)] = inst_12907);

(statearr_12973_15190[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12925 === (8))){
var inst_12892 = cljs.core.async.close_BANG_(to);
var state_12924__$1 = state_12924;
var statearr_12978_15191 = state_12924__$1;
(statearr_12978_15191[(2)] = inst_12892);

(statearr_12978_15191[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12087__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12087__auto____0 = (function (){
var statearr_12979 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12979[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12087__auto__);

(statearr_12979[(1)] = (1));

return statearr_12979;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12087__auto____1 = (function (state_12924){
while(true){
var ret_value__12088__auto__ = (function (){try{while(true){
var result__12089__auto__ = switch__12086__auto__(state_12924);
if(cljs.core.keyword_identical_QMARK_(result__12089__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12089__auto__;
}
break;
}
}catch (e12980){var ex__12090__auto__ = e12980;
var statearr_12981_15195 = state_12924;
(statearr_12981_15195[(2)] = ex__12090__auto__);


if(cljs.core.seq((state_12924[(4)]))){
var statearr_12988_15196 = state_12924;
(statearr_12988_15196[(1)] = cljs.core.first((state_12924[(4)])));

} else {
throw ex__12090__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15197 = state_12924;
state_12924 = G__15197;
continue;
} else {
return ret_value__12088__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12087__auto__ = function(state_12924){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12087__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12087__auto____1.call(this,state_12924);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12087__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12087__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12087__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12087__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12087__auto__;
})()
})();
var state__12387__auto__ = (function (){var statearr_12990 = f__12386__auto__();
(statearr_12990[(6)] = c__12385__auto__);

return statearr_12990;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12387__auto__);
}));

return c__12385__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). The
 *   presumption is that af will return immediately, having launched some
 *   asynchronous operation whose completion/callback will put results on
 *   the channel, then close! it. Outputs will be returned in order
 *   relative to the inputs. By default, the to channel will be closed
 *   when the from channel closes, but can be determined by the close?
 *   parameter. Will stop consuming the from channel if the to channel
 *   closes. See also pipeline, pipeline-blocking.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__13002 = arguments.length;
switch (G__13002) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__13017 = arguments.length;
switch (G__13017) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__13027 = arguments.length;
switch (G__13027) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__12385__auto___15215 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12386__auto__ = (function (){var switch__12086__auto__ = (function (state_13057){
var state_val_13058 = (state_13057[(1)]);
if((state_val_13058 === (7))){
var inst_13052 = (state_13057[(2)]);
var state_13057__$1 = state_13057;
var statearr_13059_15219 = state_13057__$1;
(statearr_13059_15219[(2)] = inst_13052);

(statearr_13059_15219[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13058 === (1))){
var state_13057__$1 = state_13057;
var statearr_13060_15221 = state_13057__$1;
(statearr_13060_15221[(2)] = null);

(statearr_13060_15221[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13058 === (4))){
var inst_13033 = (state_13057[(7)]);
var inst_13033__$1 = (state_13057[(2)]);
var inst_13034 = (inst_13033__$1 == null);
var state_13057__$1 = (function (){var statearr_13061 = state_13057;
(statearr_13061[(7)] = inst_13033__$1);

return statearr_13061;
})();
if(cljs.core.truth_(inst_13034)){
var statearr_13062_15222 = state_13057__$1;
(statearr_13062_15222[(1)] = (5));

} else {
var statearr_13063_15223 = state_13057__$1;
(statearr_13063_15223[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13058 === (13))){
var state_13057__$1 = state_13057;
var statearr_13064_15224 = state_13057__$1;
(statearr_13064_15224[(2)] = null);

(statearr_13064_15224[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13058 === (6))){
var inst_13033 = (state_13057[(7)]);
var inst_13039 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_13033) : p.call(null,inst_13033));
var state_13057__$1 = state_13057;
if(cljs.core.truth_(inst_13039)){
var statearr_13066_15228 = state_13057__$1;
(statearr_13066_15228[(1)] = (9));

} else {
var statearr_13067_15229 = state_13057__$1;
(statearr_13067_15229[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13058 === (3))){
var inst_13055 = (state_13057[(2)]);
var state_13057__$1 = state_13057;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13057__$1,inst_13055);
} else {
if((state_val_13058 === (12))){
var state_13057__$1 = state_13057;
var statearr_13068_15230 = state_13057__$1;
(statearr_13068_15230[(2)] = null);

(statearr_13068_15230[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13058 === (2))){
var state_13057__$1 = state_13057;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13057__$1,(4),ch);
} else {
if((state_val_13058 === (11))){
var inst_13033 = (state_13057[(7)]);
var inst_13043 = (state_13057[(2)]);
var state_13057__$1 = state_13057;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13057__$1,(8),inst_13043,inst_13033);
} else {
if((state_val_13058 === (9))){
var state_13057__$1 = state_13057;
var statearr_13070_15231 = state_13057__$1;
(statearr_13070_15231[(2)] = tc);

(statearr_13070_15231[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13058 === (5))){
var inst_13036 = cljs.core.async.close_BANG_(tc);
var inst_13037 = cljs.core.async.close_BANG_(fc);
var state_13057__$1 = (function (){var statearr_13071 = state_13057;
(statearr_13071[(8)] = inst_13036);

return statearr_13071;
})();
var statearr_13072_15235 = state_13057__$1;
(statearr_13072_15235[(2)] = inst_13037);

(statearr_13072_15235[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13058 === (14))){
var inst_13050 = (state_13057[(2)]);
var state_13057__$1 = state_13057;
var statearr_13073_15236 = state_13057__$1;
(statearr_13073_15236[(2)] = inst_13050);

(statearr_13073_15236[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13058 === (10))){
var state_13057__$1 = state_13057;
var statearr_13074_15237 = state_13057__$1;
(statearr_13074_15237[(2)] = fc);

(statearr_13074_15237[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13058 === (8))){
var inst_13045 = (state_13057[(2)]);
var state_13057__$1 = state_13057;
if(cljs.core.truth_(inst_13045)){
var statearr_13075_15238 = state_13057__$1;
(statearr_13075_15238[(1)] = (12));

} else {
var statearr_13076_15239 = state_13057__$1;
(statearr_13076_15239[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__12087__auto__ = null;
var cljs$core$async$state_machine__12087__auto____0 = (function (){
var statearr_13077 = [null,null,null,null,null,null,null,null,null];
(statearr_13077[(0)] = cljs$core$async$state_machine__12087__auto__);

(statearr_13077[(1)] = (1));

return statearr_13077;
});
var cljs$core$async$state_machine__12087__auto____1 = (function (state_13057){
while(true){
var ret_value__12088__auto__ = (function (){try{while(true){
var result__12089__auto__ = switch__12086__auto__(state_13057);
if(cljs.core.keyword_identical_QMARK_(result__12089__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12089__auto__;
}
break;
}
}catch (e13078){var ex__12090__auto__ = e13078;
var statearr_13079_15240 = state_13057;
(statearr_13079_15240[(2)] = ex__12090__auto__);


if(cljs.core.seq((state_13057[(4)]))){
var statearr_13081_15241 = state_13057;
(statearr_13081_15241[(1)] = cljs.core.first((state_13057[(4)])));

} else {
throw ex__12090__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15242 = state_13057;
state_13057 = G__15242;
continue;
} else {
return ret_value__12088__auto__;
}
break;
}
});
cljs$core$async$state_machine__12087__auto__ = function(state_13057){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12087__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12087__auto____1.call(this,state_13057);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12087__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12087__auto____0;
cljs$core$async$state_machine__12087__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12087__auto____1;
return cljs$core$async$state_machine__12087__auto__;
})()
})();
var state__12387__auto__ = (function (){var statearr_13083 = f__12386__auto__();
(statearr_13083[(6)] = c__12385__auto___15215);

return statearr_13083;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12387__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__12385__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12386__auto__ = (function (){var switch__12086__auto__ = (function (state_13106){
var state_val_13107 = (state_13106[(1)]);
if((state_val_13107 === (7))){
var inst_13101 = (state_13106[(2)]);
var state_13106__$1 = state_13106;
var statearr_13108_15243 = state_13106__$1;
(statearr_13108_15243[(2)] = inst_13101);

(statearr_13108_15243[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13107 === (1))){
var inst_13084 = init;
var inst_13085 = inst_13084;
var state_13106__$1 = (function (){var statearr_13109 = state_13106;
(statearr_13109[(7)] = inst_13085);

return statearr_13109;
})();
var statearr_13110_15244 = state_13106__$1;
(statearr_13110_15244[(2)] = null);

(statearr_13110_15244[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13107 === (4))){
var inst_13088 = (state_13106[(8)]);
var inst_13088__$1 = (state_13106[(2)]);
var inst_13089 = (inst_13088__$1 == null);
var state_13106__$1 = (function (){var statearr_13111 = state_13106;
(statearr_13111[(8)] = inst_13088__$1);

return statearr_13111;
})();
if(cljs.core.truth_(inst_13089)){
var statearr_13112_15248 = state_13106__$1;
(statearr_13112_15248[(1)] = (5));

} else {
var statearr_13113_15249 = state_13106__$1;
(statearr_13113_15249[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13107 === (6))){
var inst_13092 = (state_13106[(9)]);
var inst_13085 = (state_13106[(7)]);
var inst_13088 = (state_13106[(8)]);
var inst_13092__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_13085,inst_13088) : f.call(null,inst_13085,inst_13088));
var inst_13093 = cljs.core.reduced_QMARK_(inst_13092__$1);
var state_13106__$1 = (function (){var statearr_13115 = state_13106;
(statearr_13115[(9)] = inst_13092__$1);

return statearr_13115;
})();
if(inst_13093){
var statearr_13116_15252 = state_13106__$1;
(statearr_13116_15252[(1)] = (8));

} else {
var statearr_13117_15253 = state_13106__$1;
(statearr_13117_15253[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13107 === (3))){
var inst_13103 = (state_13106[(2)]);
var state_13106__$1 = state_13106;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13106__$1,inst_13103);
} else {
if((state_val_13107 === (2))){
var state_13106__$1 = state_13106;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13106__$1,(4),ch);
} else {
if((state_val_13107 === (9))){
var inst_13092 = (state_13106[(9)]);
var inst_13085 = inst_13092;
var state_13106__$1 = (function (){var statearr_13119 = state_13106;
(statearr_13119[(7)] = inst_13085);

return statearr_13119;
})();
var statearr_13121_15254 = state_13106__$1;
(statearr_13121_15254[(2)] = null);

(statearr_13121_15254[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13107 === (5))){
var inst_13085 = (state_13106[(7)]);
var state_13106__$1 = state_13106;
var statearr_13123_15260 = state_13106__$1;
(statearr_13123_15260[(2)] = inst_13085);

(statearr_13123_15260[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13107 === (10))){
var inst_13099 = (state_13106[(2)]);
var state_13106__$1 = state_13106;
var statearr_13124_15263 = state_13106__$1;
(statearr_13124_15263[(2)] = inst_13099);

(statearr_13124_15263[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13107 === (8))){
var inst_13092 = (state_13106[(9)]);
var inst_13095 = cljs.core.deref(inst_13092);
var state_13106__$1 = state_13106;
var statearr_13125_15264 = state_13106__$1;
(statearr_13125_15264[(2)] = inst_13095);

(statearr_13125_15264[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__12087__auto__ = null;
var cljs$core$async$reduce_$_state_machine__12087__auto____0 = (function (){
var statearr_13130 = [null,null,null,null,null,null,null,null,null,null];
(statearr_13130[(0)] = cljs$core$async$reduce_$_state_machine__12087__auto__);

(statearr_13130[(1)] = (1));

return statearr_13130;
});
var cljs$core$async$reduce_$_state_machine__12087__auto____1 = (function (state_13106){
while(true){
var ret_value__12088__auto__ = (function (){try{while(true){
var result__12089__auto__ = switch__12086__auto__(state_13106);
if(cljs.core.keyword_identical_QMARK_(result__12089__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12089__auto__;
}
break;
}
}catch (e13131){var ex__12090__auto__ = e13131;
var statearr_13132_15278 = state_13106;
(statearr_13132_15278[(2)] = ex__12090__auto__);


if(cljs.core.seq((state_13106[(4)]))){
var statearr_13133_15279 = state_13106;
(statearr_13133_15279[(1)] = cljs.core.first((state_13106[(4)])));

} else {
throw ex__12090__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15280 = state_13106;
state_13106 = G__15280;
continue;
} else {
return ret_value__12088__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__12087__auto__ = function(state_13106){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__12087__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__12087__auto____1.call(this,state_13106);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__12087__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__12087__auto____0;
cljs$core$async$reduce_$_state_machine__12087__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__12087__auto____1;
return cljs$core$async$reduce_$_state_machine__12087__auto__;
})()
})();
var state__12387__auto__ = (function (){var statearr_13134 = f__12386__auto__();
(statearr_13134[(6)] = c__12385__auto__);

return statearr_13134;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12387__auto__);
}));

return c__12385__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__12385__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12386__auto__ = (function (){var switch__12086__auto__ = (function (state_13144){
var state_val_13145 = (state_13144[(1)]);
if((state_val_13145 === (1))){
var inst_13139 = cljs.core.async.reduce(f__$1,init,ch);
var state_13144__$1 = state_13144;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13144__$1,(2),inst_13139);
} else {
if((state_val_13145 === (2))){
var inst_13141 = (state_13144[(2)]);
var inst_13142 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_13141) : f__$1.call(null,inst_13141));
var state_13144__$1 = state_13144;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13144__$1,inst_13142);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__12087__auto__ = null;
var cljs$core$async$transduce_$_state_machine__12087__auto____0 = (function (){
var statearr_13146 = [null,null,null,null,null,null,null];
(statearr_13146[(0)] = cljs$core$async$transduce_$_state_machine__12087__auto__);

(statearr_13146[(1)] = (1));

return statearr_13146;
});
var cljs$core$async$transduce_$_state_machine__12087__auto____1 = (function (state_13144){
while(true){
var ret_value__12088__auto__ = (function (){try{while(true){
var result__12089__auto__ = switch__12086__auto__(state_13144);
if(cljs.core.keyword_identical_QMARK_(result__12089__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12089__auto__;
}
break;
}
}catch (e13147){var ex__12090__auto__ = e13147;
var statearr_13148_15294 = state_13144;
(statearr_13148_15294[(2)] = ex__12090__auto__);


if(cljs.core.seq((state_13144[(4)]))){
var statearr_13149_15295 = state_13144;
(statearr_13149_15295[(1)] = cljs.core.first((state_13144[(4)])));

} else {
throw ex__12090__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15297 = state_13144;
state_13144 = G__15297;
continue;
} else {
return ret_value__12088__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__12087__auto__ = function(state_13144){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__12087__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__12087__auto____1.call(this,state_13144);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__12087__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__12087__auto____0;
cljs$core$async$transduce_$_state_machine__12087__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__12087__auto____1;
return cljs$core$async$transduce_$_state_machine__12087__auto__;
})()
})();
var state__12387__auto__ = (function (){var statearr_13150 = f__12386__auto__();
(statearr_13150[(6)] = c__12385__auto__);

return statearr_13150;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12387__auto__);
}));

return c__12385__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__13156 = arguments.length;
switch (G__13156) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__12385__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12386__auto__ = (function (){var switch__12086__auto__ = (function (state_13184){
var state_val_13185 = (state_13184[(1)]);
if((state_val_13185 === (7))){
var inst_13166 = (state_13184[(2)]);
var state_13184__$1 = state_13184;
var statearr_13190_15299 = state_13184__$1;
(statearr_13190_15299[(2)] = inst_13166);

(statearr_13190_15299[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13185 === (1))){
var inst_13159 = cljs.core.seq(coll);
var inst_13160 = inst_13159;
var state_13184__$1 = (function (){var statearr_13191 = state_13184;
(statearr_13191[(7)] = inst_13160);

return statearr_13191;
})();
var statearr_13192_15300 = state_13184__$1;
(statearr_13192_15300[(2)] = null);

(statearr_13192_15300[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13185 === (4))){
var inst_13160 = (state_13184[(7)]);
var inst_13164 = cljs.core.first(inst_13160);
var state_13184__$1 = state_13184;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13184__$1,(7),ch,inst_13164);
} else {
if((state_val_13185 === (13))){
var inst_13178 = (state_13184[(2)]);
var state_13184__$1 = state_13184;
var statearr_13194_15301 = state_13184__$1;
(statearr_13194_15301[(2)] = inst_13178);

(statearr_13194_15301[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13185 === (6))){
var inst_13169 = (state_13184[(2)]);
var state_13184__$1 = state_13184;
if(cljs.core.truth_(inst_13169)){
var statearr_13195_15305 = state_13184__$1;
(statearr_13195_15305[(1)] = (8));

} else {
var statearr_13196_15306 = state_13184__$1;
(statearr_13196_15306[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13185 === (3))){
var inst_13182 = (state_13184[(2)]);
var state_13184__$1 = state_13184;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13184__$1,inst_13182);
} else {
if((state_val_13185 === (12))){
var state_13184__$1 = state_13184;
var statearr_13197_15307 = state_13184__$1;
(statearr_13197_15307[(2)] = null);

(statearr_13197_15307[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13185 === (2))){
var inst_13160 = (state_13184[(7)]);
var state_13184__$1 = state_13184;
if(cljs.core.truth_(inst_13160)){
var statearr_13198_15308 = state_13184__$1;
(statearr_13198_15308[(1)] = (4));

} else {
var statearr_13199_15309 = state_13184__$1;
(statearr_13199_15309[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13185 === (11))){
var inst_13175 = cljs.core.async.close_BANG_(ch);
var state_13184__$1 = state_13184;
var statearr_13201_15310 = state_13184__$1;
(statearr_13201_15310[(2)] = inst_13175);

(statearr_13201_15310[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13185 === (9))){
var state_13184__$1 = state_13184;
if(cljs.core.truth_(close_QMARK_)){
var statearr_13202_15311 = state_13184__$1;
(statearr_13202_15311[(1)] = (11));

} else {
var statearr_13203_15312 = state_13184__$1;
(statearr_13203_15312[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13185 === (5))){
var inst_13160 = (state_13184[(7)]);
var state_13184__$1 = state_13184;
var statearr_13204_15313 = state_13184__$1;
(statearr_13204_15313[(2)] = inst_13160);

(statearr_13204_15313[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13185 === (10))){
var inst_13180 = (state_13184[(2)]);
var state_13184__$1 = state_13184;
var statearr_13205_15314 = state_13184__$1;
(statearr_13205_15314[(2)] = inst_13180);

(statearr_13205_15314[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13185 === (8))){
var inst_13160 = (state_13184[(7)]);
var inst_13171 = cljs.core.next(inst_13160);
var inst_13160__$1 = inst_13171;
var state_13184__$1 = (function (){var statearr_13206 = state_13184;
(statearr_13206[(7)] = inst_13160__$1);

return statearr_13206;
})();
var statearr_13207_15315 = state_13184__$1;
(statearr_13207_15315[(2)] = null);

(statearr_13207_15315[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__12087__auto__ = null;
var cljs$core$async$state_machine__12087__auto____0 = (function (){
var statearr_13208 = [null,null,null,null,null,null,null,null];
(statearr_13208[(0)] = cljs$core$async$state_machine__12087__auto__);

(statearr_13208[(1)] = (1));

return statearr_13208;
});
var cljs$core$async$state_machine__12087__auto____1 = (function (state_13184){
while(true){
var ret_value__12088__auto__ = (function (){try{while(true){
var result__12089__auto__ = switch__12086__auto__(state_13184);
if(cljs.core.keyword_identical_QMARK_(result__12089__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12089__auto__;
}
break;
}
}catch (e13209){var ex__12090__auto__ = e13209;
var statearr_13210_15316 = state_13184;
(statearr_13210_15316[(2)] = ex__12090__auto__);


if(cljs.core.seq((state_13184[(4)]))){
var statearr_13212_15317 = state_13184;
(statearr_13212_15317[(1)] = cljs.core.first((state_13184[(4)])));

} else {
throw ex__12090__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15318 = state_13184;
state_13184 = G__15318;
continue;
} else {
return ret_value__12088__auto__;
}
break;
}
});
cljs$core$async$state_machine__12087__auto__ = function(state_13184){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12087__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12087__auto____1.call(this,state_13184);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12087__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12087__auto____0;
cljs$core$async$state_machine__12087__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12087__auto____1;
return cljs$core$async$state_machine__12087__auto__;
})()
})();
var state__12387__auto__ = (function (){var statearr_13213 = f__12386__auto__();
(statearr_13213[(6)] = c__12385__auto__);

return statearr_13213;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12387__auto__);
}));

return c__12385__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__13215 = arguments.length;
switch (G__13215) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_15322 = (function (_){
var x__5350__auto__ = (((_ == null))?null:_);
var m__5351__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5351__auto__.call(null,_));
} else {
var m__5349__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5349__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_15322(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_15324 = (function (m,ch,close_QMARK_){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5351__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__5349__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5349__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_15324(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_15326 = (function (m,ch){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5351__auto__.call(null,m,ch));
} else {
var m__5349__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5349__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_15326(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_15330 = (function (m){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5351__auto__.call(null,m));
} else {
var m__5349__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5349__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_15330(m);
}
});


/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13229 = (function (ch,cs,meta13230){
this.ch = ch;
this.cs = cs;
this.meta13230 = meta13230;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async13229.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13231,meta13230__$1){
var self__ = this;
var _13231__$1 = this;
return (new cljs.core.async.t_cljs$core$async13229(self__.ch,self__.cs,meta13230__$1));
}));

(cljs.core.async.t_cljs$core$async13229.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13231){
var self__ = this;
var _13231__$1 = this;
return self__.meta13230;
}));

(cljs.core.async.t_cljs$core$async13229.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13229.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async13229.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13229.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async13229.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async13229.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async13229.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta13230","meta13230",1532436611,null)], null);
}));

(cljs.core.async.t_cljs$core$async13229.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async13229.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13229");

(cljs.core.async.t_cljs$core$async13229.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async13229");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async13229.
 */
cljs.core.async.__GT_t_cljs$core$async13229 = (function cljs$core$async$__GT_t_cljs$core$async13229(ch,cs,meta13230){
return (new cljs.core.async.t_cljs$core$async13229(ch,cs,meta13230));
});


/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (new cljs.core.async.t_cljs$core$async13229(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__12385__auto___15338 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12386__auto__ = (function (){var switch__12086__auto__ = (function (state_13372){
var state_val_13373 = (state_13372[(1)]);
if((state_val_13373 === (7))){
var inst_13368 = (state_13372[(2)]);
var state_13372__$1 = state_13372;
var statearr_13375_15339 = state_13372__$1;
(statearr_13375_15339[(2)] = inst_13368);

(statearr_13375_15339[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13373 === (20))){
var inst_13272 = (state_13372[(7)]);
var inst_13284 = cljs.core.first(inst_13272);
var inst_13285 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13284,(0),null);
var inst_13286 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13284,(1),null);
var state_13372__$1 = (function (){var statearr_13379 = state_13372;
(statearr_13379[(8)] = inst_13285);

return statearr_13379;
})();
if(cljs.core.truth_(inst_13286)){
var statearr_13381_15341 = state_13372__$1;
(statearr_13381_15341[(1)] = (22));

} else {
var statearr_13382_15342 = state_13372__$1;
(statearr_13382_15342[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13373 === (27))){
var inst_13321 = (state_13372[(9)]);
var inst_13240 = (state_13372[(10)]);
var inst_13314 = (state_13372[(11)]);
var inst_13316 = (state_13372[(12)]);
var inst_13321__$1 = cljs.core._nth(inst_13314,inst_13316);
var inst_13322 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_13321__$1,inst_13240,done);
var state_13372__$1 = (function (){var statearr_13383 = state_13372;
(statearr_13383[(9)] = inst_13321__$1);

return statearr_13383;
})();
if(cljs.core.truth_(inst_13322)){
var statearr_13384_15346 = state_13372__$1;
(statearr_13384_15346[(1)] = (30));

} else {
var statearr_13385_15347 = state_13372__$1;
(statearr_13385_15347[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13373 === (1))){
var state_13372__$1 = state_13372;
var statearr_13386_15348 = state_13372__$1;
(statearr_13386_15348[(2)] = null);

(statearr_13386_15348[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13373 === (24))){
var inst_13272 = (state_13372[(7)]);
var inst_13291 = (state_13372[(2)]);
var inst_13292 = cljs.core.next(inst_13272);
var inst_13250 = inst_13292;
var inst_13251 = null;
var inst_13252 = (0);
var inst_13253 = (0);
var state_13372__$1 = (function (){var statearr_13387 = state_13372;
(statearr_13387[(13)] = inst_13291);

(statearr_13387[(14)] = inst_13251);

(statearr_13387[(15)] = inst_13252);

(statearr_13387[(16)] = inst_13253);

(statearr_13387[(17)] = inst_13250);

return statearr_13387;
})();
var statearr_13388_15358 = state_13372__$1;
(statearr_13388_15358[(2)] = null);

(statearr_13388_15358[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13373 === (39))){
var state_13372__$1 = state_13372;
var statearr_13393_15362 = state_13372__$1;
(statearr_13393_15362[(2)] = null);

(statearr_13393_15362[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13373 === (4))){
var inst_13240 = (state_13372[(10)]);
var inst_13240__$1 = (state_13372[(2)]);
var inst_13241 = (inst_13240__$1 == null);
var state_13372__$1 = (function (){var statearr_13394 = state_13372;
(statearr_13394[(10)] = inst_13240__$1);

return statearr_13394;
})();
if(cljs.core.truth_(inst_13241)){
var statearr_13395_15365 = state_13372__$1;
(statearr_13395_15365[(1)] = (5));

} else {
var statearr_13396_15367 = state_13372__$1;
(statearr_13396_15367[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13373 === (15))){
var inst_13251 = (state_13372[(14)]);
var inst_13252 = (state_13372[(15)]);
var inst_13253 = (state_13372[(16)]);
var inst_13250 = (state_13372[(17)]);
var inst_13268 = (state_13372[(2)]);
var inst_13269 = (inst_13253 + (1));
var tmp13389 = inst_13251;
var tmp13390 = inst_13252;
var tmp13391 = inst_13250;
var inst_13250__$1 = tmp13391;
var inst_13251__$1 = tmp13389;
var inst_13252__$1 = tmp13390;
var inst_13253__$1 = inst_13269;
var state_13372__$1 = (function (){var statearr_13398 = state_13372;
(statearr_13398[(14)] = inst_13251__$1);

(statearr_13398[(15)] = inst_13252__$1);

(statearr_13398[(16)] = inst_13253__$1);

(statearr_13398[(17)] = inst_13250__$1);

(statearr_13398[(18)] = inst_13268);

return statearr_13398;
})();
var statearr_13399_15369 = state_13372__$1;
(statearr_13399_15369[(2)] = null);

(statearr_13399_15369[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13373 === (21))){
var inst_13295 = (state_13372[(2)]);
var state_13372__$1 = state_13372;
var statearr_13403_15371 = state_13372__$1;
(statearr_13403_15371[(2)] = inst_13295);

(statearr_13403_15371[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13373 === (31))){
var inst_13321 = (state_13372[(9)]);
var inst_13325 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_13321);
var state_13372__$1 = state_13372;
var statearr_13405_15381 = state_13372__$1;
(statearr_13405_15381[(2)] = inst_13325);

(statearr_13405_15381[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13373 === (32))){
var inst_13315 = (state_13372[(19)]);
var inst_13313 = (state_13372[(20)]);
var inst_13314 = (state_13372[(11)]);
var inst_13316 = (state_13372[(12)]);
var inst_13327 = (state_13372[(2)]);
var inst_13328 = (inst_13316 + (1));
var tmp13400 = inst_13315;
var tmp13401 = inst_13313;
var tmp13402 = inst_13314;
var inst_13313__$1 = tmp13401;
var inst_13314__$1 = tmp13402;
var inst_13315__$1 = tmp13400;
var inst_13316__$1 = inst_13328;
var state_13372__$1 = (function (){var statearr_13410 = state_13372;
(statearr_13410[(19)] = inst_13315__$1);

(statearr_13410[(20)] = inst_13313__$1);

(statearr_13410[(11)] = inst_13314__$1);

(statearr_13410[(21)] = inst_13327);

(statearr_13410[(12)] = inst_13316__$1);

return statearr_13410;
})();
var statearr_13412_15386 = state_13372__$1;
(statearr_13412_15386[(2)] = null);

(statearr_13412_15386[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13373 === (40))){
var inst_13341 = (state_13372[(22)]);
var inst_13345 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_13341);
var state_13372__$1 = state_13372;
var statearr_13413_15390 = state_13372__$1;
(statearr_13413_15390[(2)] = inst_13345);

(statearr_13413_15390[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13373 === (33))){
var inst_13331 = (state_13372[(23)]);
var inst_13333 = cljs.core.chunked_seq_QMARK_(inst_13331);
var state_13372__$1 = state_13372;
if(inst_13333){
var statearr_13414_15391 = state_13372__$1;
(statearr_13414_15391[(1)] = (36));

} else {
var statearr_13415_15392 = state_13372__$1;
(statearr_13415_15392[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13373 === (13))){
var inst_13262 = (state_13372[(24)]);
var inst_13265 = cljs.core.async.close_BANG_(inst_13262);
var state_13372__$1 = state_13372;
var statearr_13418_15393 = state_13372__$1;
(statearr_13418_15393[(2)] = inst_13265);

(statearr_13418_15393[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13373 === (22))){
var inst_13285 = (state_13372[(8)]);
var inst_13288 = cljs.core.async.close_BANG_(inst_13285);
var state_13372__$1 = state_13372;
var statearr_13419_15396 = state_13372__$1;
(statearr_13419_15396[(2)] = inst_13288);

(statearr_13419_15396[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13373 === (36))){
var inst_13331 = (state_13372[(23)]);
var inst_13335 = cljs.core.chunk_first(inst_13331);
var inst_13336 = cljs.core.chunk_rest(inst_13331);
var inst_13337 = cljs.core.count(inst_13335);
var inst_13313 = inst_13336;
var inst_13314 = inst_13335;
var inst_13315 = inst_13337;
var inst_13316 = (0);
var state_13372__$1 = (function (){var statearr_13424 = state_13372;
(statearr_13424[(19)] = inst_13315);

(statearr_13424[(20)] = inst_13313);

(statearr_13424[(11)] = inst_13314);

(statearr_13424[(12)] = inst_13316);

return statearr_13424;
})();
var statearr_13425_15402 = state_13372__$1;
(statearr_13425_15402[(2)] = null);

(statearr_13425_15402[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13373 === (41))){
var inst_13331 = (state_13372[(23)]);
var inst_13347 = (state_13372[(2)]);
var inst_13348 = cljs.core.next(inst_13331);
var inst_13313 = inst_13348;
var inst_13314 = null;
var inst_13315 = (0);
var inst_13316 = (0);
var state_13372__$1 = (function (){var statearr_13426 = state_13372;
(statearr_13426[(19)] = inst_13315);

(statearr_13426[(20)] = inst_13313);

(statearr_13426[(11)] = inst_13314);

(statearr_13426[(25)] = inst_13347);

(statearr_13426[(12)] = inst_13316);

return statearr_13426;
})();
var statearr_13427_15403 = state_13372__$1;
(statearr_13427_15403[(2)] = null);

(statearr_13427_15403[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13373 === (43))){
var state_13372__$1 = state_13372;
var statearr_13429_15405 = state_13372__$1;
(statearr_13429_15405[(2)] = null);

(statearr_13429_15405[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13373 === (29))){
var inst_13356 = (state_13372[(2)]);
var state_13372__$1 = state_13372;
var statearr_13430_15406 = state_13372__$1;
(statearr_13430_15406[(2)] = inst_13356);

(statearr_13430_15406[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13373 === (44))){
var inst_13365 = (state_13372[(2)]);
var state_13372__$1 = (function (){var statearr_13431 = state_13372;
(statearr_13431[(26)] = inst_13365);

return statearr_13431;
})();
var statearr_13432_15410 = state_13372__$1;
(statearr_13432_15410[(2)] = null);

(statearr_13432_15410[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13373 === (6))){
var inst_13305 = (state_13372[(27)]);
var inst_13304 = cljs.core.deref(cs);
var inst_13305__$1 = cljs.core.keys(inst_13304);
var inst_13306 = cljs.core.count(inst_13305__$1);
var inst_13307 = cljs.core.reset_BANG_(dctr,inst_13306);
var inst_13312 = cljs.core.seq(inst_13305__$1);
var inst_13313 = inst_13312;
var inst_13314 = null;
var inst_13315 = (0);
var inst_13316 = (0);
var state_13372__$1 = (function (){var statearr_13433 = state_13372;
(statearr_13433[(27)] = inst_13305__$1);

(statearr_13433[(19)] = inst_13315);

(statearr_13433[(20)] = inst_13313);

(statearr_13433[(28)] = inst_13307);

(statearr_13433[(11)] = inst_13314);

(statearr_13433[(12)] = inst_13316);

return statearr_13433;
})();
var statearr_13434_15412 = state_13372__$1;
(statearr_13434_15412[(2)] = null);

(statearr_13434_15412[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13373 === (28))){
var inst_13313 = (state_13372[(20)]);
var inst_13331 = (state_13372[(23)]);
var inst_13331__$1 = cljs.core.seq(inst_13313);
var state_13372__$1 = (function (){var statearr_13436 = state_13372;
(statearr_13436[(23)] = inst_13331__$1);

return statearr_13436;
})();
if(inst_13331__$1){
var statearr_13437_15415 = state_13372__$1;
(statearr_13437_15415[(1)] = (33));

} else {
var statearr_13438_15416 = state_13372__$1;
(statearr_13438_15416[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13373 === (25))){
var inst_13315 = (state_13372[(19)]);
var inst_13316 = (state_13372[(12)]);
var inst_13318 = (inst_13316 < inst_13315);
var inst_13319 = inst_13318;
var state_13372__$1 = state_13372;
if(cljs.core.truth_(inst_13319)){
var statearr_13439_15417 = state_13372__$1;
(statearr_13439_15417[(1)] = (27));

} else {
var statearr_13440_15418 = state_13372__$1;
(statearr_13440_15418[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13373 === (34))){
var state_13372__$1 = state_13372;
var statearr_13441_15423 = state_13372__$1;
(statearr_13441_15423[(2)] = null);

(statearr_13441_15423[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13373 === (17))){
var state_13372__$1 = state_13372;
var statearr_13442_15424 = state_13372__$1;
(statearr_13442_15424[(2)] = null);

(statearr_13442_15424[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13373 === (3))){
var inst_13370 = (state_13372[(2)]);
var state_13372__$1 = state_13372;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13372__$1,inst_13370);
} else {
if((state_val_13373 === (12))){
var inst_13300 = (state_13372[(2)]);
var state_13372__$1 = state_13372;
var statearr_13443_15426 = state_13372__$1;
(statearr_13443_15426[(2)] = inst_13300);

(statearr_13443_15426[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13373 === (2))){
var state_13372__$1 = state_13372;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13372__$1,(4),ch);
} else {
if((state_val_13373 === (23))){
var state_13372__$1 = state_13372;
var statearr_13446_15427 = state_13372__$1;
(statearr_13446_15427[(2)] = null);

(statearr_13446_15427[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13373 === (35))){
var inst_13354 = (state_13372[(2)]);
var state_13372__$1 = state_13372;
var statearr_13447_15429 = state_13372__$1;
(statearr_13447_15429[(2)] = inst_13354);

(statearr_13447_15429[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13373 === (19))){
var inst_13272 = (state_13372[(7)]);
var inst_13276 = cljs.core.chunk_first(inst_13272);
var inst_13277 = cljs.core.chunk_rest(inst_13272);
var inst_13278 = cljs.core.count(inst_13276);
var inst_13250 = inst_13277;
var inst_13251 = inst_13276;
var inst_13252 = inst_13278;
var inst_13253 = (0);
var state_13372__$1 = (function (){var statearr_13451 = state_13372;
(statearr_13451[(14)] = inst_13251);

(statearr_13451[(15)] = inst_13252);

(statearr_13451[(16)] = inst_13253);

(statearr_13451[(17)] = inst_13250);

return statearr_13451;
})();
var statearr_13452_15430 = state_13372__$1;
(statearr_13452_15430[(2)] = null);

(statearr_13452_15430[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13373 === (11))){
var inst_13272 = (state_13372[(7)]);
var inst_13250 = (state_13372[(17)]);
var inst_13272__$1 = cljs.core.seq(inst_13250);
var state_13372__$1 = (function (){var statearr_13453 = state_13372;
(statearr_13453[(7)] = inst_13272__$1);

return statearr_13453;
})();
if(inst_13272__$1){
var statearr_13454_15438 = state_13372__$1;
(statearr_13454_15438[(1)] = (16));

} else {
var statearr_13456_15439 = state_13372__$1;
(statearr_13456_15439[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13373 === (9))){
var inst_13302 = (state_13372[(2)]);
var state_13372__$1 = state_13372;
var statearr_13457_15440 = state_13372__$1;
(statearr_13457_15440[(2)] = inst_13302);

(statearr_13457_15440[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13373 === (5))){
var inst_13248 = cljs.core.deref(cs);
var inst_13249 = cljs.core.seq(inst_13248);
var inst_13250 = inst_13249;
var inst_13251 = null;
var inst_13252 = (0);
var inst_13253 = (0);
var state_13372__$1 = (function (){var statearr_13458 = state_13372;
(statearr_13458[(14)] = inst_13251);

(statearr_13458[(15)] = inst_13252);

(statearr_13458[(16)] = inst_13253);

(statearr_13458[(17)] = inst_13250);

return statearr_13458;
})();
var statearr_13459_15441 = state_13372__$1;
(statearr_13459_15441[(2)] = null);

(statearr_13459_15441[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13373 === (14))){
var state_13372__$1 = state_13372;
var statearr_13460_15442 = state_13372__$1;
(statearr_13460_15442[(2)] = null);

(statearr_13460_15442[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13373 === (45))){
var inst_13362 = (state_13372[(2)]);
var state_13372__$1 = state_13372;
var statearr_13461_15447 = state_13372__$1;
(statearr_13461_15447[(2)] = inst_13362);

(statearr_13461_15447[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13373 === (26))){
var inst_13305 = (state_13372[(27)]);
var inst_13358 = (state_13372[(2)]);
var inst_13359 = cljs.core.seq(inst_13305);
var state_13372__$1 = (function (){var statearr_13462 = state_13372;
(statearr_13462[(29)] = inst_13358);

return statearr_13462;
})();
if(inst_13359){
var statearr_13463_15448 = state_13372__$1;
(statearr_13463_15448[(1)] = (42));

} else {
var statearr_13465_15449 = state_13372__$1;
(statearr_13465_15449[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13373 === (16))){
var inst_13272 = (state_13372[(7)]);
var inst_13274 = cljs.core.chunked_seq_QMARK_(inst_13272);
var state_13372__$1 = state_13372;
if(inst_13274){
var statearr_13466_15469 = state_13372__$1;
(statearr_13466_15469[(1)] = (19));

} else {
var statearr_13467_15470 = state_13372__$1;
(statearr_13467_15470[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13373 === (38))){
var inst_13351 = (state_13372[(2)]);
var state_13372__$1 = state_13372;
var statearr_13468_15471 = state_13372__$1;
(statearr_13468_15471[(2)] = inst_13351);

(statearr_13468_15471[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13373 === (30))){
var state_13372__$1 = state_13372;
var statearr_13470_15472 = state_13372__$1;
(statearr_13470_15472[(2)] = null);

(statearr_13470_15472[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13373 === (10))){
var inst_13251 = (state_13372[(14)]);
var inst_13253 = (state_13372[(16)]);
var inst_13261 = cljs.core._nth(inst_13251,inst_13253);
var inst_13262 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13261,(0),null);
var inst_13263 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13261,(1),null);
var state_13372__$1 = (function (){var statearr_13471 = state_13372;
(statearr_13471[(24)] = inst_13262);

return statearr_13471;
})();
if(cljs.core.truth_(inst_13263)){
var statearr_13472_15476 = state_13372__$1;
(statearr_13472_15476[(1)] = (13));

} else {
var statearr_13473_15477 = state_13372__$1;
(statearr_13473_15477[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13373 === (18))){
var inst_13298 = (state_13372[(2)]);
var state_13372__$1 = state_13372;
var statearr_13475_15478 = state_13372__$1;
(statearr_13475_15478[(2)] = inst_13298);

(statearr_13475_15478[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13373 === (42))){
var state_13372__$1 = state_13372;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13372__$1,(45),dchan);
} else {
if((state_val_13373 === (37))){
var inst_13341 = (state_13372[(22)]);
var inst_13331 = (state_13372[(23)]);
var inst_13240 = (state_13372[(10)]);
var inst_13341__$1 = cljs.core.first(inst_13331);
var inst_13342 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_13341__$1,inst_13240,done);
var state_13372__$1 = (function (){var statearr_13480 = state_13372;
(statearr_13480[(22)] = inst_13341__$1);

return statearr_13480;
})();
if(cljs.core.truth_(inst_13342)){
var statearr_13482_15482 = state_13372__$1;
(statearr_13482_15482[(1)] = (39));

} else {
var statearr_13483_15483 = state_13372__$1;
(statearr_13483_15483[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13373 === (8))){
var inst_13252 = (state_13372[(15)]);
var inst_13253 = (state_13372[(16)]);
var inst_13255 = (inst_13253 < inst_13252);
var inst_13256 = inst_13255;
var state_13372__$1 = state_13372;
if(cljs.core.truth_(inst_13256)){
var statearr_13484_15484 = state_13372__$1;
(statearr_13484_15484[(1)] = (10));

} else {
var statearr_13485_15485 = state_13372__$1;
(statearr_13485_15485[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__12087__auto__ = null;
var cljs$core$async$mult_$_state_machine__12087__auto____0 = (function (){
var statearr_13487 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13487[(0)] = cljs$core$async$mult_$_state_machine__12087__auto__);

(statearr_13487[(1)] = (1));

return statearr_13487;
});
var cljs$core$async$mult_$_state_machine__12087__auto____1 = (function (state_13372){
while(true){
var ret_value__12088__auto__ = (function (){try{while(true){
var result__12089__auto__ = switch__12086__auto__(state_13372);
if(cljs.core.keyword_identical_QMARK_(result__12089__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12089__auto__;
}
break;
}
}catch (e13488){var ex__12090__auto__ = e13488;
var statearr_13489_15486 = state_13372;
(statearr_13489_15486[(2)] = ex__12090__auto__);


if(cljs.core.seq((state_13372[(4)]))){
var statearr_13491_15487 = state_13372;
(statearr_13491_15487[(1)] = cljs.core.first((state_13372[(4)])));

} else {
throw ex__12090__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15488 = state_13372;
state_13372 = G__15488;
continue;
} else {
return ret_value__12088__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__12087__auto__ = function(state_13372){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__12087__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__12087__auto____1.call(this,state_13372);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__12087__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__12087__auto____0;
cljs$core$async$mult_$_state_machine__12087__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__12087__auto____1;
return cljs$core$async$mult_$_state_machine__12087__auto__;
})()
})();
var state__12387__auto__ = (function (){var statearr_13495 = f__12386__auto__();
(statearr_13495[(6)] = c__12385__auto___15338);

return statearr_13495;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12387__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__13498 = arguments.length;
switch (G__13498) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_15497 = (function (m,ch){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5351__auto__.call(null,m,ch));
} else {
var m__5349__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5349__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_15497(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_15501 = (function (m,ch){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5351__auto__.call(null,m,ch));
} else {
var m__5349__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5349__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_15501(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_15502 = (function (m){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5351__auto__.call(null,m));
} else {
var m__5349__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5349__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_15502(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_15513 = (function (m,state_map){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5351__auto__.call(null,m,state_map));
} else {
var m__5349__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5349__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_15513(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_15517 = (function (m,mode){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5351__auto__.call(null,m,mode));
} else {
var m__5349__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5349__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_15517(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5732__auto__ = [];
var len__5726__auto___15520 = arguments.length;
var i__5727__auto___15524 = (0);
while(true){
if((i__5727__auto___15524 < len__5726__auto___15520)){
args__5732__auto__.push((arguments[i__5727__auto___15524]));

var G__15525 = (i__5727__auto___15524 + (1));
i__5727__auto___15524 = G__15525;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((3) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5733__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__13518){
var map__13520 = p__13518;
var map__13520__$1 = cljs.core.__destructure_map(map__13520);
var opts = map__13520__$1;
var statearr_13521_15526 = state;
(statearr_13521_15526[(1)] = cont_block);


var temp__5804__auto__ = cljs.core.async.do_alts((function (val){
var statearr_13522_15527 = state;
(statearr_13522_15527[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5804__auto__)){
var cb = temp__5804__auto__;
var statearr_13525_15528 = state;
(statearr_13525_15528[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq13514){
var G__13515 = cljs.core.first(seq13514);
var seq13514__$1 = cljs.core.next(seq13514);
var G__13516 = cljs.core.first(seq13514__$1);
var seq13514__$2 = cljs.core.next(seq13514__$1);
var G__13517 = cljs.core.first(seq13514__$2);
var seq13514__$3 = cljs.core.next(seq13514__$2);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__13515,G__13516,G__13517,seq13514__$3);
}));


/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13531 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta13532){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta13532 = meta13532;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async13531.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13533,meta13532__$1){
var self__ = this;
var _13533__$1 = this;
return (new cljs.core.async.t_cljs$core$async13531(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta13532__$1));
}));

(cljs.core.async.t_cljs$core$async13531.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13533){
var self__ = this;
var _13533__$1 = this;
return self__.meta13532;
}));

(cljs.core.async.t_cljs$core$async13531.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13531.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async13531.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13531.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async13531.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async13531.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async13531.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async13531.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async13531.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta13532","meta13532",929245815,null)], null);
}));

(cljs.core.async.t_cljs$core$async13531.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async13531.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13531");

(cljs.core.async.t_cljs$core$async13531.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async13531");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async13531.
 */
cljs.core.async.__GT_t_cljs$core$async13531 = (function cljs$core$async$__GT_t_cljs$core$async13531(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta13532){
return (new cljs.core.async.t_cljs$core$async13531(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta13532));
});


/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (new cljs.core.async.t_cljs$core$async13531(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
var c__12385__auto___15558 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12386__auto__ = (function (){var switch__12086__auto__ = (function (state_13611){
var state_val_13612 = (state_13611[(1)]);
if((state_val_13612 === (7))){
var inst_13568 = (state_13611[(2)]);
var state_13611__$1 = state_13611;
if(cljs.core.truth_(inst_13568)){
var statearr_13617_15559 = state_13611__$1;
(statearr_13617_15559[(1)] = (8));

} else {
var statearr_13618_15565 = state_13611__$1;
(statearr_13618_15565[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13612 === (20))){
var inst_13561 = (state_13611[(7)]);
var state_13611__$1 = state_13611;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13611__$1,(23),out,inst_13561);
} else {
if((state_val_13612 === (1))){
var inst_13544 = calc_state();
var inst_13545 = cljs.core.__destructure_map(inst_13544);
var inst_13546 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_13545,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_13547 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_13545,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_13548 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_13545,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_13549 = inst_13544;
var state_13611__$1 = (function (){var statearr_13620 = state_13611;
(statearr_13620[(8)] = inst_13546);

(statearr_13620[(9)] = inst_13549);

(statearr_13620[(10)] = inst_13547);

(statearr_13620[(11)] = inst_13548);

return statearr_13620;
})();
var statearr_13621_15566 = state_13611__$1;
(statearr_13621_15566[(2)] = null);

(statearr_13621_15566[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13612 === (24))){
var inst_13552 = (state_13611[(12)]);
var inst_13549 = inst_13552;
var state_13611__$1 = (function (){var statearr_13623 = state_13611;
(statearr_13623[(9)] = inst_13549);

return statearr_13623;
})();
var statearr_13624_15567 = state_13611__$1;
(statearr_13624_15567[(2)] = null);

(statearr_13624_15567[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13612 === (4))){
var inst_13563 = (state_13611[(13)]);
var inst_13561 = (state_13611[(7)]);
var inst_13560 = (state_13611[(2)]);
var inst_13561__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13560,(0),null);
var inst_13562 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13560,(1),null);
var inst_13563__$1 = (inst_13561__$1 == null);
var state_13611__$1 = (function (){var statearr_13625 = state_13611;
(statearr_13625[(14)] = inst_13562);

(statearr_13625[(13)] = inst_13563__$1);

(statearr_13625[(7)] = inst_13561__$1);

return statearr_13625;
})();
if(cljs.core.truth_(inst_13563__$1)){
var statearr_13630_15617 = state_13611__$1;
(statearr_13630_15617[(1)] = (5));

} else {
var statearr_13631_15618 = state_13611__$1;
(statearr_13631_15618[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13612 === (15))){
var inst_13553 = (state_13611[(15)]);
var inst_13583 = (state_13611[(16)]);
var inst_13583__$1 = cljs.core.empty_QMARK_(inst_13553);
var state_13611__$1 = (function (){var statearr_13632 = state_13611;
(statearr_13632[(16)] = inst_13583__$1);

return statearr_13632;
})();
if(inst_13583__$1){
var statearr_13633_15631 = state_13611__$1;
(statearr_13633_15631[(1)] = (17));

} else {
var statearr_13634_15632 = state_13611__$1;
(statearr_13634_15632[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13612 === (21))){
var inst_13552 = (state_13611[(12)]);
var inst_13549 = inst_13552;
var state_13611__$1 = (function (){var statearr_13635 = state_13611;
(statearr_13635[(9)] = inst_13549);

return statearr_13635;
})();
var statearr_13636_15633 = state_13611__$1;
(statearr_13636_15633[(2)] = null);

(statearr_13636_15633[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13612 === (13))){
var inst_13576 = (state_13611[(2)]);
var inst_13577 = calc_state();
var inst_13549 = inst_13577;
var state_13611__$1 = (function (){var statearr_13638 = state_13611;
(statearr_13638[(9)] = inst_13549);

(statearr_13638[(17)] = inst_13576);

return statearr_13638;
})();
var statearr_13639_15635 = state_13611__$1;
(statearr_13639_15635[(2)] = null);

(statearr_13639_15635[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13612 === (22))){
var inst_13603 = (state_13611[(2)]);
var state_13611__$1 = state_13611;
var statearr_13641_15636 = state_13611__$1;
(statearr_13641_15636[(2)] = inst_13603);

(statearr_13641_15636[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13612 === (6))){
var inst_13562 = (state_13611[(14)]);
var inst_13566 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_13562,change);
var state_13611__$1 = state_13611;
var statearr_13642_15644 = state_13611__$1;
(statearr_13642_15644[(2)] = inst_13566);

(statearr_13642_15644[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13612 === (25))){
var state_13611__$1 = state_13611;
var statearr_13643_15645 = state_13611__$1;
(statearr_13643_15645[(2)] = null);

(statearr_13643_15645[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13612 === (17))){
var inst_13554 = (state_13611[(18)]);
var inst_13562 = (state_13611[(14)]);
var inst_13585 = (inst_13554.cljs$core$IFn$_invoke$arity$1 ? inst_13554.cljs$core$IFn$_invoke$arity$1(inst_13562) : inst_13554.call(null,inst_13562));
var inst_13586 = cljs.core.not(inst_13585);
var state_13611__$1 = state_13611;
var statearr_13644_15653 = state_13611__$1;
(statearr_13644_15653[(2)] = inst_13586);

(statearr_13644_15653[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13612 === (3))){
var inst_13607 = (state_13611[(2)]);
var state_13611__$1 = state_13611;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13611__$1,inst_13607);
} else {
if((state_val_13612 === (12))){
var state_13611__$1 = state_13611;
var statearr_13662_15654 = state_13611__$1;
(statearr_13662_15654[(2)] = null);

(statearr_13662_15654[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13612 === (2))){
var inst_13549 = (state_13611[(9)]);
var inst_13552 = (state_13611[(12)]);
var inst_13552__$1 = cljs.core.__destructure_map(inst_13549);
var inst_13553 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_13552__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_13554 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_13552__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_13555 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_13552__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_13611__$1 = (function (){var statearr_13687 = state_13611;
(statearr_13687[(15)] = inst_13553);

(statearr_13687[(18)] = inst_13554);

(statearr_13687[(12)] = inst_13552__$1);

return statearr_13687;
})();
return cljs.core.async.ioc_alts_BANG_(state_13611__$1,(4),inst_13555);
} else {
if((state_val_13612 === (23))){
var inst_13594 = (state_13611[(2)]);
var state_13611__$1 = state_13611;
if(cljs.core.truth_(inst_13594)){
var statearr_13689_15655 = state_13611__$1;
(statearr_13689_15655[(1)] = (24));

} else {
var statearr_13691_15656 = state_13611__$1;
(statearr_13691_15656[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13612 === (19))){
var inst_13589 = (state_13611[(2)]);
var state_13611__$1 = state_13611;
var statearr_13694_15657 = state_13611__$1;
(statearr_13694_15657[(2)] = inst_13589);

(statearr_13694_15657[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13612 === (11))){
var inst_13562 = (state_13611[(14)]);
var inst_13573 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_13562);
var state_13611__$1 = state_13611;
var statearr_13696_15658 = state_13611__$1;
(statearr_13696_15658[(2)] = inst_13573);

(statearr_13696_15658[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13612 === (9))){
var inst_13553 = (state_13611[(15)]);
var inst_13562 = (state_13611[(14)]);
var inst_13580 = (state_13611[(19)]);
var inst_13580__$1 = (inst_13553.cljs$core$IFn$_invoke$arity$1 ? inst_13553.cljs$core$IFn$_invoke$arity$1(inst_13562) : inst_13553.call(null,inst_13562));
var state_13611__$1 = (function (){var statearr_13700 = state_13611;
(statearr_13700[(19)] = inst_13580__$1);

return statearr_13700;
})();
if(cljs.core.truth_(inst_13580__$1)){
var statearr_13701_15659 = state_13611__$1;
(statearr_13701_15659[(1)] = (14));

} else {
var statearr_13703_15660 = state_13611__$1;
(statearr_13703_15660[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13612 === (5))){
var inst_13563 = (state_13611[(13)]);
var state_13611__$1 = state_13611;
var statearr_13704_15661 = state_13611__$1;
(statearr_13704_15661[(2)] = inst_13563);

(statearr_13704_15661[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13612 === (14))){
var inst_13580 = (state_13611[(19)]);
var state_13611__$1 = state_13611;
var statearr_13708_15662 = state_13611__$1;
(statearr_13708_15662[(2)] = inst_13580);

(statearr_13708_15662[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13612 === (26))){
var inst_13599 = (state_13611[(2)]);
var state_13611__$1 = state_13611;
var statearr_13710_15663 = state_13611__$1;
(statearr_13710_15663[(2)] = inst_13599);

(statearr_13710_15663[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13612 === (16))){
var inst_13591 = (state_13611[(2)]);
var state_13611__$1 = state_13611;
if(cljs.core.truth_(inst_13591)){
var statearr_13740_15664 = state_13611__$1;
(statearr_13740_15664[(1)] = (20));

} else {
var statearr_13742_15665 = state_13611__$1;
(statearr_13742_15665[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13612 === (10))){
var inst_13605 = (state_13611[(2)]);
var state_13611__$1 = state_13611;
var statearr_13743_15669 = state_13611__$1;
(statearr_13743_15669[(2)] = inst_13605);

(statearr_13743_15669[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13612 === (18))){
var inst_13583 = (state_13611[(16)]);
var state_13611__$1 = state_13611;
var statearr_13745_15670 = state_13611__$1;
(statearr_13745_15670[(2)] = inst_13583);

(statearr_13745_15670[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13612 === (8))){
var inst_13561 = (state_13611[(7)]);
var inst_13571 = (inst_13561 == null);
var state_13611__$1 = state_13611;
if(cljs.core.truth_(inst_13571)){
var statearr_13749_15671 = state_13611__$1;
(statearr_13749_15671[(1)] = (11));

} else {
var statearr_13750_15672 = state_13611__$1;
(statearr_13750_15672[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__12087__auto__ = null;
var cljs$core$async$mix_$_state_machine__12087__auto____0 = (function (){
var statearr_13752 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13752[(0)] = cljs$core$async$mix_$_state_machine__12087__auto__);

(statearr_13752[(1)] = (1));

return statearr_13752;
});
var cljs$core$async$mix_$_state_machine__12087__auto____1 = (function (state_13611){
while(true){
var ret_value__12088__auto__ = (function (){try{while(true){
var result__12089__auto__ = switch__12086__auto__(state_13611);
if(cljs.core.keyword_identical_QMARK_(result__12089__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12089__auto__;
}
break;
}
}catch (e13756){var ex__12090__auto__ = e13756;
var statearr_13757_15673 = state_13611;
(statearr_13757_15673[(2)] = ex__12090__auto__);


if(cljs.core.seq((state_13611[(4)]))){
var statearr_13758_15674 = state_13611;
(statearr_13758_15674[(1)] = cljs.core.first((state_13611[(4)])));

} else {
throw ex__12090__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15675 = state_13611;
state_13611 = G__15675;
continue;
} else {
return ret_value__12088__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__12087__auto__ = function(state_13611){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__12087__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__12087__auto____1.call(this,state_13611);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__12087__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__12087__auto____0;
cljs$core$async$mix_$_state_machine__12087__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__12087__auto____1;
return cljs$core$async$mix_$_state_machine__12087__auto__;
})()
})();
var state__12387__auto__ = (function (){var statearr_13764 = f__12386__auto__();
(statearr_13764[(6)] = c__12385__auto___15558);

return statearr_13764;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12387__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_15676 = (function (p,v,ch,close_QMARK_){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5351__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__5349__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5349__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_15676(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_15678 = (function (p,v,ch){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5351__auto__.call(null,p,v,ch));
} else {
var m__5349__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5349__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_15678(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_15685 = (function() {
var G__15686 = null;
var G__15686__1 = (function (p){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5351__auto__.call(null,p));
} else {
var m__5349__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5349__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__15686__2 = (function (p,v){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5351__auto__.call(null,p,v));
} else {
var m__5349__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5349__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__15686 = function(p,v){
switch(arguments.length){
case 1:
return G__15686__1.call(this,p);
case 2:
return G__15686__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__15686.cljs$core$IFn$_invoke$arity$1 = G__15686__1;
G__15686.cljs$core$IFn$_invoke$arity$2 = G__15686__2;
return G__15686;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__13796 = arguments.length;
switch (G__13796) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_15685(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_15685(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);



/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13826 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta13827){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta13827 = meta13827;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async13826.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13828,meta13827__$1){
var self__ = this;
var _13828__$1 = this;
return (new cljs.core.async.t_cljs$core$async13826(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta13827__$1));
}));

(cljs.core.async.t_cljs$core$async13826.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13828){
var self__ = this;
var _13828__$1 = this;
return self__.meta13827;
}));

(cljs.core.async.t_cljs$core$async13826.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13826.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async13826.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13826.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async13826.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5804__auto__)){
var m = temp__5804__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async13826.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async13826.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async13826.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta13827","meta13827",1752928370,null)], null);
}));

(cljs.core.async.t_cljs$core$async13826.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async13826.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13826");

(cljs.core.async.t_cljs$core$async13826.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async13826");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async13826.
 */
cljs.core.async.__GT_t_cljs$core$async13826 = (function cljs$core$async$__GT_t_cljs$core$async13826(ch,topic_fn,buf_fn,mults,ensure_mult,meta13827){
return (new cljs.core.async.t_cljs$core$async13826(ch,topic_fn,buf_fn,mults,ensure_mult,meta13827));
});


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__13813 = arguments.length;
switch (G__13813) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__5002__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__13806_SHARP_){
if(cljs.core.truth_((p1__13806_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__13806_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__13806_SHARP_.call(null,topic)))){
return p1__13806_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__13806_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (new cljs.core.async.t_cljs$core$async13826(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
var c__12385__auto___15692 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12386__auto__ = (function (){var switch__12086__auto__ = (function (state_13931){
var state_val_13932 = (state_13931[(1)]);
if((state_val_13932 === (7))){
var inst_13926 = (state_13931[(2)]);
var state_13931__$1 = state_13931;
var statearr_13948_15693 = state_13931__$1;
(statearr_13948_15693[(2)] = inst_13926);

(statearr_13948_15693[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (20))){
var state_13931__$1 = state_13931;
var statearr_13952_15694 = state_13931__$1;
(statearr_13952_15694[(2)] = null);

(statearr_13952_15694[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (1))){
var state_13931__$1 = state_13931;
var statearr_13958_15695 = state_13931__$1;
(statearr_13958_15695[(2)] = null);

(statearr_13958_15695[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (24))){
var inst_13908 = (state_13931[(7)]);
var inst_13918 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_13908);
var state_13931__$1 = state_13931;
var statearr_13959_15696 = state_13931__$1;
(statearr_13959_15696[(2)] = inst_13918);

(statearr_13959_15696[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (4))){
var inst_13846 = (state_13931[(8)]);
var inst_13846__$1 = (state_13931[(2)]);
var inst_13848 = (inst_13846__$1 == null);
var state_13931__$1 = (function (){var statearr_13962 = state_13931;
(statearr_13962[(8)] = inst_13846__$1);

return statearr_13962;
})();
if(cljs.core.truth_(inst_13848)){
var statearr_13963_15700 = state_13931__$1;
(statearr_13963_15700[(1)] = (5));

} else {
var statearr_13964_15701 = state_13931__$1;
(statearr_13964_15701[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (15))){
var inst_13900 = (state_13931[(2)]);
var state_13931__$1 = state_13931;
var statearr_13965_15702 = state_13931__$1;
(statearr_13965_15702[(2)] = inst_13900);

(statearr_13965_15702[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (21))){
var inst_13923 = (state_13931[(2)]);
var state_13931__$1 = (function (){var statearr_13966 = state_13931;
(statearr_13966[(9)] = inst_13923);

return statearr_13966;
})();
var statearr_13967_15703 = state_13931__$1;
(statearr_13967_15703[(2)] = null);

(statearr_13967_15703[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (13))){
var inst_13881 = (state_13931[(10)]);
var inst_13883 = cljs.core.chunked_seq_QMARK_(inst_13881);
var state_13931__$1 = state_13931;
if(inst_13883){
var statearr_13973_15704 = state_13931__$1;
(statearr_13973_15704[(1)] = (16));

} else {
var statearr_13974_15705 = state_13931__$1;
(statearr_13974_15705[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (22))){
var inst_13915 = (state_13931[(2)]);
var state_13931__$1 = state_13931;
if(cljs.core.truth_(inst_13915)){
var statearr_13975_15706 = state_13931__$1;
(statearr_13975_15706[(1)] = (23));

} else {
var statearr_13976_15707 = state_13931__$1;
(statearr_13976_15707[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (6))){
var inst_13910 = (state_13931[(11)]);
var inst_13908 = (state_13931[(7)]);
var inst_13846 = (state_13931[(8)]);
var inst_13908__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_13846) : topic_fn.call(null,inst_13846));
var inst_13909 = cljs.core.deref(mults);
var inst_13910__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_13909,inst_13908__$1);
var state_13931__$1 = (function (){var statearr_13977 = state_13931;
(statearr_13977[(11)] = inst_13910__$1);

(statearr_13977[(7)] = inst_13908__$1);

return statearr_13977;
})();
if(cljs.core.truth_(inst_13910__$1)){
var statearr_13978_15708 = state_13931__$1;
(statearr_13978_15708[(1)] = (19));

} else {
var statearr_13979_15709 = state_13931__$1;
(statearr_13979_15709[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (25))){
var inst_13920 = (state_13931[(2)]);
var state_13931__$1 = state_13931;
var statearr_13980_15710 = state_13931__$1;
(statearr_13980_15710[(2)] = inst_13920);

(statearr_13980_15710[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (17))){
var inst_13881 = (state_13931[(10)]);
var inst_13891 = cljs.core.first(inst_13881);
var inst_13892 = cljs.core.async.muxch_STAR_(inst_13891);
var inst_13893 = cljs.core.async.close_BANG_(inst_13892);
var inst_13894 = cljs.core.next(inst_13881);
var inst_13860 = inst_13894;
var inst_13861 = null;
var inst_13862 = (0);
var inst_13863 = (0);
var state_13931__$1 = (function (){var statearr_13981 = state_13931;
(statearr_13981[(12)] = inst_13862);

(statearr_13981[(13)] = inst_13863);

(statearr_13981[(14)] = inst_13860);

(statearr_13981[(15)] = inst_13893);

(statearr_13981[(16)] = inst_13861);

return statearr_13981;
})();
var statearr_13982_15714 = state_13931__$1;
(statearr_13982_15714[(2)] = null);

(statearr_13982_15714[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (3))){
var inst_13928 = (state_13931[(2)]);
var state_13931__$1 = state_13931;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13931__$1,inst_13928);
} else {
if((state_val_13932 === (12))){
var inst_13902 = (state_13931[(2)]);
var state_13931__$1 = state_13931;
var statearr_13984_15715 = state_13931__$1;
(statearr_13984_15715[(2)] = inst_13902);

(statearr_13984_15715[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (2))){
var state_13931__$1 = state_13931;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13931__$1,(4),ch);
} else {
if((state_val_13932 === (23))){
var state_13931__$1 = state_13931;
var statearr_13986_15716 = state_13931__$1;
(statearr_13986_15716[(2)] = null);

(statearr_13986_15716[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (19))){
var inst_13910 = (state_13931[(11)]);
var inst_13846 = (state_13931[(8)]);
var inst_13913 = cljs.core.async.muxch_STAR_(inst_13910);
var state_13931__$1 = state_13931;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13931__$1,(22),inst_13913,inst_13846);
} else {
if((state_val_13932 === (11))){
var inst_13881 = (state_13931[(10)]);
var inst_13860 = (state_13931[(14)]);
var inst_13881__$1 = cljs.core.seq(inst_13860);
var state_13931__$1 = (function (){var statearr_13987 = state_13931;
(statearr_13987[(10)] = inst_13881__$1);

return statearr_13987;
})();
if(inst_13881__$1){
var statearr_13988_15717 = state_13931__$1;
(statearr_13988_15717[(1)] = (13));

} else {
var statearr_13989_15718 = state_13931__$1;
(statearr_13989_15718[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (9))){
var inst_13904 = (state_13931[(2)]);
var state_13931__$1 = state_13931;
var statearr_13990_15719 = state_13931__$1;
(statearr_13990_15719[(2)] = inst_13904);

(statearr_13990_15719[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (5))){
var inst_13857 = cljs.core.deref(mults);
var inst_13858 = cljs.core.vals(inst_13857);
var inst_13859 = cljs.core.seq(inst_13858);
var inst_13860 = inst_13859;
var inst_13861 = null;
var inst_13862 = (0);
var inst_13863 = (0);
var state_13931__$1 = (function (){var statearr_13994 = state_13931;
(statearr_13994[(12)] = inst_13862);

(statearr_13994[(13)] = inst_13863);

(statearr_13994[(14)] = inst_13860);

(statearr_13994[(16)] = inst_13861);

return statearr_13994;
})();
var statearr_13995_15720 = state_13931__$1;
(statearr_13995_15720[(2)] = null);

(statearr_13995_15720[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (14))){
var state_13931__$1 = state_13931;
var statearr_13999_15721 = state_13931__$1;
(statearr_13999_15721[(2)] = null);

(statearr_13999_15721[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (16))){
var inst_13881 = (state_13931[(10)]);
var inst_13886 = cljs.core.chunk_first(inst_13881);
var inst_13887 = cljs.core.chunk_rest(inst_13881);
var inst_13888 = cljs.core.count(inst_13886);
var inst_13860 = inst_13887;
var inst_13861 = inst_13886;
var inst_13862 = inst_13888;
var inst_13863 = (0);
var state_13931__$1 = (function (){var statearr_14000 = state_13931;
(statearr_14000[(12)] = inst_13862);

(statearr_14000[(13)] = inst_13863);

(statearr_14000[(14)] = inst_13860);

(statearr_14000[(16)] = inst_13861);

return statearr_14000;
})();
var statearr_14001_15725 = state_13931__$1;
(statearr_14001_15725[(2)] = null);

(statearr_14001_15725[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (10))){
var inst_13862 = (state_13931[(12)]);
var inst_13863 = (state_13931[(13)]);
var inst_13860 = (state_13931[(14)]);
var inst_13861 = (state_13931[(16)]);
var inst_13870 = cljs.core._nth(inst_13861,inst_13863);
var inst_13872 = cljs.core.async.muxch_STAR_(inst_13870);
var inst_13873 = cljs.core.async.close_BANG_(inst_13872);
var inst_13878 = (inst_13863 + (1));
var tmp13996 = inst_13862;
var tmp13997 = inst_13860;
var tmp13998 = inst_13861;
var inst_13860__$1 = tmp13997;
var inst_13861__$1 = tmp13998;
var inst_13862__$1 = tmp13996;
var inst_13863__$1 = inst_13878;
var state_13931__$1 = (function (){var statearr_14005 = state_13931;
(statearr_14005[(12)] = inst_13862__$1);

(statearr_14005[(13)] = inst_13863__$1);

(statearr_14005[(14)] = inst_13860__$1);

(statearr_14005[(16)] = inst_13861__$1);

(statearr_14005[(17)] = inst_13873);

return statearr_14005;
})();
var statearr_14006_15737 = state_13931__$1;
(statearr_14006_15737[(2)] = null);

(statearr_14006_15737[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (18))){
var inst_13897 = (state_13931[(2)]);
var state_13931__$1 = state_13931;
var statearr_14007_15738 = state_13931__$1;
(statearr_14007_15738[(2)] = inst_13897);

(statearr_14007_15738[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (8))){
var inst_13862 = (state_13931[(12)]);
var inst_13863 = (state_13931[(13)]);
var inst_13865 = (inst_13863 < inst_13862);
var inst_13866 = inst_13865;
var state_13931__$1 = state_13931;
if(cljs.core.truth_(inst_13866)){
var statearr_14008_15739 = state_13931__$1;
(statearr_14008_15739[(1)] = (10));

} else {
var statearr_14009_15740 = state_13931__$1;
(statearr_14009_15740[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__12087__auto__ = null;
var cljs$core$async$state_machine__12087__auto____0 = (function (){
var statearr_14010 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14010[(0)] = cljs$core$async$state_machine__12087__auto__);

(statearr_14010[(1)] = (1));

return statearr_14010;
});
var cljs$core$async$state_machine__12087__auto____1 = (function (state_13931){
while(true){
var ret_value__12088__auto__ = (function (){try{while(true){
var result__12089__auto__ = switch__12086__auto__(state_13931);
if(cljs.core.keyword_identical_QMARK_(result__12089__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12089__auto__;
}
break;
}
}catch (e14011){var ex__12090__auto__ = e14011;
var statearr_14012_15743 = state_13931;
(statearr_14012_15743[(2)] = ex__12090__auto__);


if(cljs.core.seq((state_13931[(4)]))){
var statearr_14015_15744 = state_13931;
(statearr_14015_15744[(1)] = cljs.core.first((state_13931[(4)])));

} else {
throw ex__12090__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15745 = state_13931;
state_13931 = G__15745;
continue;
} else {
return ret_value__12088__auto__;
}
break;
}
});
cljs$core$async$state_machine__12087__auto__ = function(state_13931){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12087__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12087__auto____1.call(this,state_13931);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12087__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12087__auto____0;
cljs$core$async$state_machine__12087__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12087__auto____1;
return cljs$core$async$state_machine__12087__auto__;
})()
})();
var state__12387__auto__ = (function (){var statearr_14016 = f__12386__auto__();
(statearr_14016[(6)] = c__12385__auto___15692);

return statearr_14016;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12387__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__14022 = arguments.length;
switch (G__14022) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__14033 = arguments.length;
switch (G__14033) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__14043 = arguments.length;
switch (G__14043) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
if((cnt === (0))){
cljs.core.async.close_BANG_(out);
} else {
var c__12385__auto___15763 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12386__auto__ = (function (){var switch__12086__auto__ = (function (state_14116){
var state_val_14117 = (state_14116[(1)]);
if((state_val_14117 === (7))){
var state_14116__$1 = state_14116;
var statearr_14124_15764 = state_14116__$1;
(statearr_14124_15764[(2)] = null);

(statearr_14124_15764[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14117 === (1))){
var state_14116__$1 = state_14116;
var statearr_14126_15765 = state_14116__$1;
(statearr_14126_15765[(2)] = null);

(statearr_14126_15765[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14117 === (4))){
var inst_14067 = (state_14116[(7)]);
var inst_14066 = (state_14116[(8)]);
var inst_14069 = (inst_14067 < inst_14066);
var state_14116__$1 = state_14116;
if(cljs.core.truth_(inst_14069)){
var statearr_14127_15766 = state_14116__$1;
(statearr_14127_15766[(1)] = (6));

} else {
var statearr_14140_15767 = state_14116__$1;
(statearr_14140_15767[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14117 === (15))){
var inst_14097 = (state_14116[(9)]);
var inst_14102 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_14097);
var state_14116__$1 = state_14116;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14116__$1,(17),out,inst_14102);
} else {
if((state_val_14117 === (13))){
var inst_14097 = (state_14116[(9)]);
var inst_14097__$1 = (state_14116[(2)]);
var inst_14098 = cljs.core.some(cljs.core.nil_QMARK_,inst_14097__$1);
var state_14116__$1 = (function (){var statearr_14157 = state_14116;
(statearr_14157[(9)] = inst_14097__$1);

return statearr_14157;
})();
if(cljs.core.truth_(inst_14098)){
var statearr_14158_15768 = state_14116__$1;
(statearr_14158_15768[(1)] = (14));

} else {
var statearr_14162_15769 = state_14116__$1;
(statearr_14162_15769[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14117 === (6))){
var state_14116__$1 = state_14116;
var statearr_14164_15770 = state_14116__$1;
(statearr_14164_15770[(2)] = null);

(statearr_14164_15770[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14117 === (17))){
var inst_14104 = (state_14116[(2)]);
var state_14116__$1 = (function (){var statearr_14178 = state_14116;
(statearr_14178[(10)] = inst_14104);

return statearr_14178;
})();
var statearr_14179_15771 = state_14116__$1;
(statearr_14179_15771[(2)] = null);

(statearr_14179_15771[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14117 === (3))){
var inst_14109 = (state_14116[(2)]);
var state_14116__$1 = state_14116;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14116__$1,inst_14109);
} else {
if((state_val_14117 === (12))){
var _ = (function (){var statearr_14180 = state_14116;
(statearr_14180[(4)] = cljs.core.rest((state_14116[(4)])));

return statearr_14180;
})();
var state_14116__$1 = state_14116;
var ex14168 = (state_14116__$1[(2)]);
var statearr_14186_15772 = state_14116__$1;
(statearr_14186_15772[(5)] = ex14168);


if((ex14168 instanceof Object)){
var statearr_14188_15773 = state_14116__$1;
(statearr_14188_15773[(1)] = (11));

(statearr_14188_15773[(5)] = null);

} else {
throw ex14168;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14117 === (2))){
var inst_14062 = cljs.core.reset_BANG_(dctr,cnt);
var inst_14066 = cnt;
var inst_14067 = (0);
var state_14116__$1 = (function (){var statearr_14194 = state_14116;
(statearr_14194[(7)] = inst_14067);

(statearr_14194[(8)] = inst_14066);

(statearr_14194[(11)] = inst_14062);

return statearr_14194;
})();
var statearr_14195_15774 = state_14116__$1;
(statearr_14195_15774[(2)] = null);

(statearr_14195_15774[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14117 === (11))){
var inst_14073 = (state_14116[(2)]);
var inst_14074 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_14116__$1 = (function (){var statearr_14198 = state_14116;
(statearr_14198[(12)] = inst_14073);

return statearr_14198;
})();
var statearr_14199_15779 = state_14116__$1;
(statearr_14199_15779[(2)] = inst_14074);

(statearr_14199_15779[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14117 === (9))){
var inst_14067 = (state_14116[(7)]);
var _ = (function (){var statearr_14204 = state_14116;
(statearr_14204[(4)] = cljs.core.cons((12),(state_14116[(4)])));

return statearr_14204;
})();
var inst_14080 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_14067) : chs__$1.call(null,inst_14067));
var inst_14081 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_14067) : done.call(null,inst_14067));
var inst_14082 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_14080,inst_14081);
var ___$1 = (function (){var statearr_14208 = state_14116;
(statearr_14208[(4)] = cljs.core.rest((state_14116[(4)])));

return statearr_14208;
})();
var state_14116__$1 = state_14116;
var statearr_14210_15783 = state_14116__$1;
(statearr_14210_15783[(2)] = inst_14082);

(statearr_14210_15783[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14117 === (5))){
var inst_14092 = (state_14116[(2)]);
var state_14116__$1 = (function (){var statearr_14211 = state_14116;
(statearr_14211[(13)] = inst_14092);

return statearr_14211;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14116__$1,(13),dchan);
} else {
if((state_val_14117 === (14))){
var inst_14100 = cljs.core.async.close_BANG_(out);
var state_14116__$1 = state_14116;
var statearr_14216_15787 = state_14116__$1;
(statearr_14216_15787[(2)] = inst_14100);

(statearr_14216_15787[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14117 === (16))){
var inst_14107 = (state_14116[(2)]);
var state_14116__$1 = state_14116;
var statearr_14220_15788 = state_14116__$1;
(statearr_14220_15788[(2)] = inst_14107);

(statearr_14220_15788[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14117 === (10))){
var inst_14067 = (state_14116[(7)]);
var inst_14085 = (state_14116[(2)]);
var inst_14086 = (inst_14067 + (1));
var inst_14067__$1 = inst_14086;
var state_14116__$1 = (function (){var statearr_14222 = state_14116;
(statearr_14222[(14)] = inst_14085);

(statearr_14222[(7)] = inst_14067__$1);

return statearr_14222;
})();
var statearr_14223_15789 = state_14116__$1;
(statearr_14223_15789[(2)] = null);

(statearr_14223_15789[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14117 === (8))){
var inst_14090 = (state_14116[(2)]);
var state_14116__$1 = state_14116;
var statearr_14227_15790 = state_14116__$1;
(statearr_14227_15790[(2)] = inst_14090);

(statearr_14227_15790[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__12087__auto__ = null;
var cljs$core$async$state_machine__12087__auto____0 = (function (){
var statearr_14232 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14232[(0)] = cljs$core$async$state_machine__12087__auto__);

(statearr_14232[(1)] = (1));

return statearr_14232;
});
var cljs$core$async$state_machine__12087__auto____1 = (function (state_14116){
while(true){
var ret_value__12088__auto__ = (function (){try{while(true){
var result__12089__auto__ = switch__12086__auto__(state_14116);
if(cljs.core.keyword_identical_QMARK_(result__12089__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12089__auto__;
}
break;
}
}catch (e14233){var ex__12090__auto__ = e14233;
var statearr_14234_15792 = state_14116;
(statearr_14234_15792[(2)] = ex__12090__auto__);


if(cljs.core.seq((state_14116[(4)]))){
var statearr_14235_15794 = state_14116;
(statearr_14235_15794[(1)] = cljs.core.first((state_14116[(4)])));

} else {
throw ex__12090__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15795 = state_14116;
state_14116 = G__15795;
continue;
} else {
return ret_value__12088__auto__;
}
break;
}
});
cljs$core$async$state_machine__12087__auto__ = function(state_14116){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12087__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12087__auto____1.call(this,state_14116);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12087__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12087__auto____0;
cljs$core$async$state_machine__12087__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12087__auto____1;
return cljs$core$async$state_machine__12087__auto__;
})()
})();
var state__12387__auto__ = (function (){var statearr_14246 = f__12386__auto__();
(statearr_14246[(6)] = c__12385__auto___15763);

return statearr_14246;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12387__auto__);
}));

}

return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__14252 = arguments.length;
switch (G__14252) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12385__auto___15797 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12386__auto__ = (function (){var switch__12086__auto__ = (function (state_14289){
var state_val_14290 = (state_14289[(1)]);
if((state_val_14290 === (7))){
var inst_14268 = (state_14289[(7)]);
var inst_14269 = (state_14289[(8)]);
var inst_14268__$1 = (state_14289[(2)]);
var inst_14269__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14268__$1,(0),null);
var inst_14270 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14268__$1,(1),null);
var inst_14271 = (inst_14269__$1 == null);
var state_14289__$1 = (function (){var statearr_14291 = state_14289;
(statearr_14291[(7)] = inst_14268__$1);

(statearr_14291[(9)] = inst_14270);

(statearr_14291[(8)] = inst_14269__$1);

return statearr_14291;
})();
if(cljs.core.truth_(inst_14271)){
var statearr_14292_15799 = state_14289__$1;
(statearr_14292_15799[(1)] = (8));

} else {
var statearr_14293_15800 = state_14289__$1;
(statearr_14293_15800[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14290 === (1))){
var inst_14258 = cljs.core.vec(chs);
var inst_14259 = inst_14258;
var state_14289__$1 = (function (){var statearr_14298 = state_14289;
(statearr_14298[(10)] = inst_14259);

return statearr_14298;
})();
var statearr_14299_15801 = state_14289__$1;
(statearr_14299_15801[(2)] = null);

(statearr_14299_15801[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14290 === (4))){
var inst_14259 = (state_14289[(10)]);
var state_14289__$1 = state_14289;
return cljs.core.async.ioc_alts_BANG_(state_14289__$1,(7),inst_14259);
} else {
if((state_val_14290 === (6))){
var inst_14285 = (state_14289[(2)]);
var state_14289__$1 = state_14289;
var statearr_14302_15802 = state_14289__$1;
(statearr_14302_15802[(2)] = inst_14285);

(statearr_14302_15802[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14290 === (3))){
var inst_14287 = (state_14289[(2)]);
var state_14289__$1 = state_14289;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14289__$1,inst_14287);
} else {
if((state_val_14290 === (2))){
var inst_14259 = (state_14289[(10)]);
var inst_14261 = cljs.core.count(inst_14259);
var inst_14262 = (inst_14261 > (0));
var state_14289__$1 = state_14289;
if(cljs.core.truth_(inst_14262)){
var statearr_14304_15803 = state_14289__$1;
(statearr_14304_15803[(1)] = (4));

} else {
var statearr_14305_15804 = state_14289__$1;
(statearr_14305_15804[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14290 === (11))){
var inst_14259 = (state_14289[(10)]);
var inst_14278 = (state_14289[(2)]);
var tmp14303 = inst_14259;
var inst_14259__$1 = tmp14303;
var state_14289__$1 = (function (){var statearr_14307 = state_14289;
(statearr_14307[(11)] = inst_14278);

(statearr_14307[(10)] = inst_14259__$1);

return statearr_14307;
})();
var statearr_14308_15805 = state_14289__$1;
(statearr_14308_15805[(2)] = null);

(statearr_14308_15805[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14290 === (9))){
var inst_14269 = (state_14289[(8)]);
var state_14289__$1 = state_14289;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14289__$1,(11),out,inst_14269);
} else {
if((state_val_14290 === (5))){
var inst_14283 = cljs.core.async.close_BANG_(out);
var state_14289__$1 = state_14289;
var statearr_14311_15810 = state_14289__$1;
(statearr_14311_15810[(2)] = inst_14283);

(statearr_14311_15810[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14290 === (10))){
var inst_14281 = (state_14289[(2)]);
var state_14289__$1 = state_14289;
var statearr_14312_15811 = state_14289__$1;
(statearr_14312_15811[(2)] = inst_14281);

(statearr_14312_15811[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14290 === (8))){
var inst_14268 = (state_14289[(7)]);
var inst_14270 = (state_14289[(9)]);
var inst_14259 = (state_14289[(10)]);
var inst_14269 = (state_14289[(8)]);
var inst_14273 = (function (){var cs = inst_14259;
var vec__14264 = inst_14268;
var v = inst_14269;
var c = inst_14270;
return (function (p1__14247_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__14247_SHARP_);
});
})();
var inst_14274 = cljs.core.filterv(inst_14273,inst_14259);
var inst_14259__$1 = inst_14274;
var state_14289__$1 = (function (){var statearr_14313 = state_14289;
(statearr_14313[(10)] = inst_14259__$1);

return statearr_14313;
})();
var statearr_14318_15816 = state_14289__$1;
(statearr_14318_15816[(2)] = null);

(statearr_14318_15816[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__12087__auto__ = null;
var cljs$core$async$state_machine__12087__auto____0 = (function (){
var statearr_14320 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14320[(0)] = cljs$core$async$state_machine__12087__auto__);

(statearr_14320[(1)] = (1));

return statearr_14320;
});
var cljs$core$async$state_machine__12087__auto____1 = (function (state_14289){
while(true){
var ret_value__12088__auto__ = (function (){try{while(true){
var result__12089__auto__ = switch__12086__auto__(state_14289);
if(cljs.core.keyword_identical_QMARK_(result__12089__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12089__auto__;
}
break;
}
}catch (e14321){var ex__12090__auto__ = e14321;
var statearr_14322_15817 = state_14289;
(statearr_14322_15817[(2)] = ex__12090__auto__);


if(cljs.core.seq((state_14289[(4)]))){
var statearr_14325_15821 = state_14289;
(statearr_14325_15821[(1)] = cljs.core.first((state_14289[(4)])));

} else {
throw ex__12090__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15825 = state_14289;
state_14289 = G__15825;
continue;
} else {
return ret_value__12088__auto__;
}
break;
}
});
cljs$core$async$state_machine__12087__auto__ = function(state_14289){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12087__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12087__auto____1.call(this,state_14289);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12087__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12087__auto____0;
cljs$core$async$state_machine__12087__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12087__auto____1;
return cljs$core$async$state_machine__12087__auto__;
})()
})();
var state__12387__auto__ = (function (){var statearr_14326 = f__12386__auto__();
(statearr_14326[(6)] = c__12385__auto___15797);

return statearr_14326;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12387__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__14333 = arguments.length;
switch (G__14333) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12385__auto___15827 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12386__auto__ = (function (){var switch__12086__auto__ = (function (state_14360){
var state_val_14361 = (state_14360[(1)]);
if((state_val_14361 === (7))){
var inst_14341 = (state_14360[(7)]);
var inst_14341__$1 = (state_14360[(2)]);
var inst_14342 = (inst_14341__$1 == null);
var inst_14343 = cljs.core.not(inst_14342);
var state_14360__$1 = (function (){var statearr_14366 = state_14360;
(statearr_14366[(7)] = inst_14341__$1);

return statearr_14366;
})();
if(inst_14343){
var statearr_14367_15832 = state_14360__$1;
(statearr_14367_15832[(1)] = (8));

} else {
var statearr_14369_15833 = state_14360__$1;
(statearr_14369_15833[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14361 === (1))){
var inst_14335 = (0);
var state_14360__$1 = (function (){var statearr_14373 = state_14360;
(statearr_14373[(8)] = inst_14335);

return statearr_14373;
})();
var statearr_14374_15834 = state_14360__$1;
(statearr_14374_15834[(2)] = null);

(statearr_14374_15834[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14361 === (4))){
var state_14360__$1 = state_14360;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14360__$1,(7),ch);
} else {
if((state_val_14361 === (6))){
var inst_14355 = (state_14360[(2)]);
var state_14360__$1 = state_14360;
var statearr_14375_15835 = state_14360__$1;
(statearr_14375_15835[(2)] = inst_14355);

(statearr_14375_15835[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14361 === (3))){
var inst_14357 = (state_14360[(2)]);
var inst_14358 = cljs.core.async.close_BANG_(out);
var state_14360__$1 = (function (){var statearr_14377 = state_14360;
(statearr_14377[(9)] = inst_14357);

return statearr_14377;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_14360__$1,inst_14358);
} else {
if((state_val_14361 === (2))){
var inst_14335 = (state_14360[(8)]);
var inst_14337 = (inst_14335 < n);
var state_14360__$1 = state_14360;
if(cljs.core.truth_(inst_14337)){
var statearr_14378_15836 = state_14360__$1;
(statearr_14378_15836[(1)] = (4));

} else {
var statearr_14379_15837 = state_14360__$1;
(statearr_14379_15837[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14361 === (11))){
var inst_14335 = (state_14360[(8)]);
var inst_14346 = (state_14360[(2)]);
var inst_14348 = (inst_14335 + (1));
var inst_14335__$1 = inst_14348;
var state_14360__$1 = (function (){var statearr_14381 = state_14360;
(statearr_14381[(10)] = inst_14346);

(statearr_14381[(8)] = inst_14335__$1);

return statearr_14381;
})();
var statearr_14382_15838 = state_14360__$1;
(statearr_14382_15838[(2)] = null);

(statearr_14382_15838[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14361 === (9))){
var state_14360__$1 = state_14360;
var statearr_14384_15839 = state_14360__$1;
(statearr_14384_15839[(2)] = null);

(statearr_14384_15839[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14361 === (5))){
var state_14360__$1 = state_14360;
var statearr_14385_15840 = state_14360__$1;
(statearr_14385_15840[(2)] = null);

(statearr_14385_15840[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14361 === (10))){
var inst_14352 = (state_14360[(2)]);
var state_14360__$1 = state_14360;
var statearr_14388_15842 = state_14360__$1;
(statearr_14388_15842[(2)] = inst_14352);

(statearr_14388_15842[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14361 === (8))){
var inst_14341 = (state_14360[(7)]);
var state_14360__$1 = state_14360;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14360__$1,(11),out,inst_14341);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__12087__auto__ = null;
var cljs$core$async$state_machine__12087__auto____0 = (function (){
var statearr_14389 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14389[(0)] = cljs$core$async$state_machine__12087__auto__);

(statearr_14389[(1)] = (1));

return statearr_14389;
});
var cljs$core$async$state_machine__12087__auto____1 = (function (state_14360){
while(true){
var ret_value__12088__auto__ = (function (){try{while(true){
var result__12089__auto__ = switch__12086__auto__(state_14360);
if(cljs.core.keyword_identical_QMARK_(result__12089__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12089__auto__;
}
break;
}
}catch (e14390){var ex__12090__auto__ = e14390;
var statearr_14395_15843 = state_14360;
(statearr_14395_15843[(2)] = ex__12090__auto__);


if(cljs.core.seq((state_14360[(4)]))){
var statearr_14396_15845 = state_14360;
(statearr_14396_15845[(1)] = cljs.core.first((state_14360[(4)])));

} else {
throw ex__12090__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15849 = state_14360;
state_14360 = G__15849;
continue;
} else {
return ret_value__12088__auto__;
}
break;
}
});
cljs$core$async$state_machine__12087__auto__ = function(state_14360){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12087__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12087__auto____1.call(this,state_14360);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12087__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12087__auto____0;
cljs$core$async$state_machine__12087__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12087__auto____1;
return cljs$core$async$state_machine__12087__auto__;
})()
})();
var state__12387__auto__ = (function (){var statearr_14400 = f__12386__auto__();
(statearr_14400[(6)] = c__12385__auto___15827);

return statearr_14400;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12387__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14432 = (function (f,ch,meta14416,_,fn1,meta14433){
this.f = f;
this.ch = ch;
this.meta14416 = meta14416;
this._ = _;
this.fn1 = fn1;
this.meta14433 = meta14433;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async14432.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14434,meta14433__$1){
var self__ = this;
var _14434__$1 = this;
return (new cljs.core.async.t_cljs$core$async14432(self__.f,self__.ch,self__.meta14416,self__._,self__.fn1,meta14433__$1));
}));

(cljs.core.async.t_cljs$core$async14432.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14434){
var self__ = this;
var _14434__$1 = this;
return self__.meta14433;
}));

(cljs.core.async.t_cljs$core$async14432.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14432.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async14432.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async14432.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__14401_SHARP_){
var G__14451 = (((p1__14401_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__14401_SHARP_) : self__.f.call(null,p1__14401_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__14451) : f1.call(null,G__14451));
});
}));

(cljs.core.async.t_cljs$core$async14432.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta14416","meta14416",1444131596,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async14415","cljs.core.async/t_cljs$core$async14415",35347149,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta14433","meta14433",592303566,null)], null);
}));

(cljs.core.async.t_cljs$core$async14432.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async14432.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14432");

(cljs.core.async.t_cljs$core$async14432.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async14432");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async14432.
 */
cljs.core.async.__GT_t_cljs$core$async14432 = (function cljs$core$async$__GT_t_cljs$core$async14432(f,ch,meta14416,_,fn1,meta14433){
return (new cljs.core.async.t_cljs$core$async14432(f,ch,meta14416,_,fn1,meta14433));
});



/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14415 = (function (f,ch,meta14416){
this.f = f;
this.ch = ch;
this.meta14416 = meta14416;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async14415.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14417,meta14416__$1){
var self__ = this;
var _14417__$1 = this;
return (new cljs.core.async.t_cljs$core$async14415(self__.f,self__.ch,meta14416__$1));
}));

(cljs.core.async.t_cljs$core$async14415.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14417){
var self__ = this;
var _14417__$1 = this;
return self__.meta14416;
}));

(cljs.core.async.t_cljs$core$async14415.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14415.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async14415.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async14415.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14415.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(new cljs.core.async.t_cljs$core$async14432(self__.f,self__.ch,self__.meta14416,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY)));
if(cljs.core.truth_((function (){var and__5000__auto__ = ret;
if(cljs.core.truth_(and__5000__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__5000__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__14459 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__14459) : self__.f.call(null,G__14459));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async14415.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14415.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async14415.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta14416","meta14416",1444131596,null)], null);
}));

(cljs.core.async.t_cljs$core$async14415.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async14415.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14415");

(cljs.core.async.t_cljs$core$async14415.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async14415");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async14415.
 */
cljs.core.async.__GT_t_cljs$core$async14415 = (function cljs$core$async$__GT_t_cljs$core$async14415(f,ch,meta14416){
return (new cljs.core.async.t_cljs$core$async14415(f,ch,meta14416));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
return (new cljs.core.async.t_cljs$core$async14415(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14460 = (function (f,ch,meta14461){
this.f = f;
this.ch = ch;
this.meta14461 = meta14461;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async14460.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14462,meta14461__$1){
var self__ = this;
var _14462__$1 = this;
return (new cljs.core.async.t_cljs$core$async14460(self__.f,self__.ch,meta14461__$1));
}));

(cljs.core.async.t_cljs$core$async14460.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14462){
var self__ = this;
var _14462__$1 = this;
return self__.meta14461;
}));

(cljs.core.async.t_cljs$core$async14460.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14460.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async14460.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14460.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async14460.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14460.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async14460.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta14461","meta14461",893839826,null)], null);
}));

(cljs.core.async.t_cljs$core$async14460.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async14460.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14460");

(cljs.core.async.t_cljs$core$async14460.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async14460");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async14460.
 */
cljs.core.async.__GT_t_cljs$core$async14460 = (function cljs$core$async$__GT_t_cljs$core$async14460(f,ch,meta14461){
return (new cljs.core.async.t_cljs$core$async14460(f,ch,meta14461));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
return (new cljs.core.async.t_cljs$core$async14460(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14475 = (function (p,ch,meta14476){
this.p = p;
this.ch = ch;
this.meta14476 = meta14476;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async14475.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14477,meta14476__$1){
var self__ = this;
var _14477__$1 = this;
return (new cljs.core.async.t_cljs$core$async14475(self__.p,self__.ch,meta14476__$1));
}));

(cljs.core.async.t_cljs$core$async14475.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14477){
var self__ = this;
var _14477__$1 = this;
return self__.meta14476;
}));

(cljs.core.async.t_cljs$core$async14475.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14475.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async14475.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async14475.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14475.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async14475.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14475.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async14475.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta14476","meta14476",-1816855907,null)], null);
}));

(cljs.core.async.t_cljs$core$async14475.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async14475.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14475");

(cljs.core.async.t_cljs$core$async14475.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async14475");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async14475.
 */
cljs.core.async.__GT_t_cljs$core$async14475 = (function cljs$core$async$__GT_t_cljs$core$async14475(p,ch,meta14476){
return (new cljs.core.async.t_cljs$core$async14475(p,ch,meta14476));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
return (new cljs.core.async.t_cljs$core$async14475(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__14486 = arguments.length;
switch (G__14486) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12385__auto___15876 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12386__auto__ = (function (){var switch__12086__auto__ = (function (state_14512){
var state_val_14513 = (state_14512[(1)]);
if((state_val_14513 === (7))){
var inst_14508 = (state_14512[(2)]);
var state_14512__$1 = state_14512;
var statearr_14514_15877 = state_14512__$1;
(statearr_14514_15877[(2)] = inst_14508);

(statearr_14514_15877[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14513 === (1))){
var state_14512__$1 = state_14512;
var statearr_14515_15878 = state_14512__$1;
(statearr_14515_15878[(2)] = null);

(statearr_14515_15878[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14513 === (4))){
var inst_14494 = (state_14512[(7)]);
var inst_14494__$1 = (state_14512[(2)]);
var inst_14495 = (inst_14494__$1 == null);
var state_14512__$1 = (function (){var statearr_14516 = state_14512;
(statearr_14516[(7)] = inst_14494__$1);

return statearr_14516;
})();
if(cljs.core.truth_(inst_14495)){
var statearr_14517_15880 = state_14512__$1;
(statearr_14517_15880[(1)] = (5));

} else {
var statearr_14518_15881 = state_14512__$1;
(statearr_14518_15881[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14513 === (6))){
var inst_14494 = (state_14512[(7)]);
var inst_14499 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_14494) : p.call(null,inst_14494));
var state_14512__$1 = state_14512;
if(cljs.core.truth_(inst_14499)){
var statearr_14519_15883 = state_14512__$1;
(statearr_14519_15883[(1)] = (8));

} else {
var statearr_14520_15884 = state_14512__$1;
(statearr_14520_15884[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14513 === (3))){
var inst_14510 = (state_14512[(2)]);
var state_14512__$1 = state_14512;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14512__$1,inst_14510);
} else {
if((state_val_14513 === (2))){
var state_14512__$1 = state_14512;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14512__$1,(4),ch);
} else {
if((state_val_14513 === (11))){
var inst_14502 = (state_14512[(2)]);
var state_14512__$1 = state_14512;
var statearr_14521_15890 = state_14512__$1;
(statearr_14521_15890[(2)] = inst_14502);

(statearr_14521_15890[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14513 === (9))){
var state_14512__$1 = state_14512;
var statearr_14522_15891 = state_14512__$1;
(statearr_14522_15891[(2)] = null);

(statearr_14522_15891[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14513 === (5))){
var inst_14497 = cljs.core.async.close_BANG_(out);
var state_14512__$1 = state_14512;
var statearr_14523_15892 = state_14512__$1;
(statearr_14523_15892[(2)] = inst_14497);

(statearr_14523_15892[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14513 === (10))){
var inst_14505 = (state_14512[(2)]);
var state_14512__$1 = (function (){var statearr_14524 = state_14512;
(statearr_14524[(8)] = inst_14505);

return statearr_14524;
})();
var statearr_14525_15893 = state_14512__$1;
(statearr_14525_15893[(2)] = null);

(statearr_14525_15893[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14513 === (8))){
var inst_14494 = (state_14512[(7)]);
var state_14512__$1 = state_14512;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14512__$1,(11),out,inst_14494);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__12087__auto__ = null;
var cljs$core$async$state_machine__12087__auto____0 = (function (){
var statearr_14526 = [null,null,null,null,null,null,null,null,null];
(statearr_14526[(0)] = cljs$core$async$state_machine__12087__auto__);

(statearr_14526[(1)] = (1));

return statearr_14526;
});
var cljs$core$async$state_machine__12087__auto____1 = (function (state_14512){
while(true){
var ret_value__12088__auto__ = (function (){try{while(true){
var result__12089__auto__ = switch__12086__auto__(state_14512);
if(cljs.core.keyword_identical_QMARK_(result__12089__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12089__auto__;
}
break;
}
}catch (e14527){var ex__12090__auto__ = e14527;
var statearr_14528_15901 = state_14512;
(statearr_14528_15901[(2)] = ex__12090__auto__);


if(cljs.core.seq((state_14512[(4)]))){
var statearr_14529_15902 = state_14512;
(statearr_14529_15902[(1)] = cljs.core.first((state_14512[(4)])));

} else {
throw ex__12090__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15903 = state_14512;
state_14512 = G__15903;
continue;
} else {
return ret_value__12088__auto__;
}
break;
}
});
cljs$core$async$state_machine__12087__auto__ = function(state_14512){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12087__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12087__auto____1.call(this,state_14512);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12087__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12087__auto____0;
cljs$core$async$state_machine__12087__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12087__auto____1;
return cljs$core$async$state_machine__12087__auto__;
})()
})();
var state__12387__auto__ = (function (){var statearr_14530 = f__12386__auto__();
(statearr_14530[(6)] = c__12385__auto___15876);

return statearr_14530;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12387__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__14534 = arguments.length;
switch (G__14534) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__12385__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12386__auto__ = (function (){var switch__12086__auto__ = (function (state_14602){
var state_val_14603 = (state_14602[(1)]);
if((state_val_14603 === (7))){
var inst_14597 = (state_14602[(2)]);
var state_14602__$1 = state_14602;
var statearr_14608_15911 = state_14602__$1;
(statearr_14608_15911[(2)] = inst_14597);

(statearr_14608_15911[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14603 === (20))){
var inst_14567 = (state_14602[(7)]);
var inst_14578 = (state_14602[(2)]);
var inst_14579 = cljs.core.next(inst_14567);
var inst_14553 = inst_14579;
var inst_14554 = null;
var inst_14555 = (0);
var inst_14556 = (0);
var state_14602__$1 = (function (){var statearr_14609 = state_14602;
(statearr_14609[(8)] = inst_14553);

(statearr_14609[(9)] = inst_14554);

(statearr_14609[(10)] = inst_14556);

(statearr_14609[(11)] = inst_14578);

(statearr_14609[(12)] = inst_14555);

return statearr_14609;
})();
var statearr_14610_15912 = state_14602__$1;
(statearr_14610_15912[(2)] = null);

(statearr_14610_15912[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14603 === (1))){
var state_14602__$1 = state_14602;
var statearr_14611_15913 = state_14602__$1;
(statearr_14611_15913[(2)] = null);

(statearr_14611_15913[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14603 === (4))){
var inst_14542 = (state_14602[(13)]);
var inst_14542__$1 = (state_14602[(2)]);
var inst_14543 = (inst_14542__$1 == null);
var state_14602__$1 = (function (){var statearr_14612 = state_14602;
(statearr_14612[(13)] = inst_14542__$1);

return statearr_14612;
})();
if(cljs.core.truth_(inst_14543)){
var statearr_14613_15926 = state_14602__$1;
(statearr_14613_15926[(1)] = (5));

} else {
var statearr_14614_15927 = state_14602__$1;
(statearr_14614_15927[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14603 === (15))){
var state_14602__$1 = state_14602;
var statearr_14621_15928 = state_14602__$1;
(statearr_14621_15928[(2)] = null);

(statearr_14621_15928[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14603 === (21))){
var state_14602__$1 = state_14602;
var statearr_14622_15929 = state_14602__$1;
(statearr_14622_15929[(2)] = null);

(statearr_14622_15929[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14603 === (13))){
var inst_14553 = (state_14602[(8)]);
var inst_14554 = (state_14602[(9)]);
var inst_14556 = (state_14602[(10)]);
var inst_14555 = (state_14602[(12)]);
var inst_14563 = (state_14602[(2)]);
var inst_14564 = (inst_14556 + (1));
var tmp14618 = inst_14553;
var tmp14619 = inst_14554;
var tmp14620 = inst_14555;
var inst_14553__$1 = tmp14618;
var inst_14554__$1 = tmp14619;
var inst_14555__$1 = tmp14620;
var inst_14556__$1 = inst_14564;
var state_14602__$1 = (function (){var statearr_14623 = state_14602;
(statearr_14623[(14)] = inst_14563);

(statearr_14623[(8)] = inst_14553__$1);

(statearr_14623[(9)] = inst_14554__$1);

(statearr_14623[(10)] = inst_14556__$1);

(statearr_14623[(12)] = inst_14555__$1);

return statearr_14623;
})();
var statearr_14624_15930 = state_14602__$1;
(statearr_14624_15930[(2)] = null);

(statearr_14624_15930[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14603 === (22))){
var state_14602__$1 = state_14602;
var statearr_14625_15935 = state_14602__$1;
(statearr_14625_15935[(2)] = null);

(statearr_14625_15935[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14603 === (6))){
var inst_14542 = (state_14602[(13)]);
var inst_14551 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_14542) : f.call(null,inst_14542));
var inst_14552 = cljs.core.seq(inst_14551);
var inst_14553 = inst_14552;
var inst_14554 = null;
var inst_14555 = (0);
var inst_14556 = (0);
var state_14602__$1 = (function (){var statearr_14626 = state_14602;
(statearr_14626[(8)] = inst_14553);

(statearr_14626[(9)] = inst_14554);

(statearr_14626[(10)] = inst_14556);

(statearr_14626[(12)] = inst_14555);

return statearr_14626;
})();
var statearr_14627_15937 = state_14602__$1;
(statearr_14627_15937[(2)] = null);

(statearr_14627_15937[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14603 === (17))){
var inst_14567 = (state_14602[(7)]);
var inst_14571 = cljs.core.chunk_first(inst_14567);
var inst_14572 = cljs.core.chunk_rest(inst_14567);
var inst_14573 = cljs.core.count(inst_14571);
var inst_14553 = inst_14572;
var inst_14554 = inst_14571;
var inst_14555 = inst_14573;
var inst_14556 = (0);
var state_14602__$1 = (function (){var statearr_14632 = state_14602;
(statearr_14632[(8)] = inst_14553);

(statearr_14632[(9)] = inst_14554);

(statearr_14632[(10)] = inst_14556);

(statearr_14632[(12)] = inst_14555);

return statearr_14632;
})();
var statearr_14633_15938 = state_14602__$1;
(statearr_14633_15938[(2)] = null);

(statearr_14633_15938[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14603 === (3))){
var inst_14599 = (state_14602[(2)]);
var state_14602__$1 = state_14602;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14602__$1,inst_14599);
} else {
if((state_val_14603 === (12))){
var inst_14587 = (state_14602[(2)]);
var state_14602__$1 = state_14602;
var statearr_14634_15939 = state_14602__$1;
(statearr_14634_15939[(2)] = inst_14587);

(statearr_14634_15939[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14603 === (2))){
var state_14602__$1 = state_14602;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14602__$1,(4),in$);
} else {
if((state_val_14603 === (23))){
var inst_14595 = (state_14602[(2)]);
var state_14602__$1 = state_14602;
var statearr_14639_15941 = state_14602__$1;
(statearr_14639_15941[(2)] = inst_14595);

(statearr_14639_15941[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14603 === (19))){
var inst_14582 = (state_14602[(2)]);
var state_14602__$1 = state_14602;
var statearr_14640_15943 = state_14602__$1;
(statearr_14640_15943[(2)] = inst_14582);

(statearr_14640_15943[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14603 === (11))){
var inst_14567 = (state_14602[(7)]);
var inst_14553 = (state_14602[(8)]);
var inst_14567__$1 = cljs.core.seq(inst_14553);
var state_14602__$1 = (function (){var statearr_14641 = state_14602;
(statearr_14641[(7)] = inst_14567__$1);

return statearr_14641;
})();
if(inst_14567__$1){
var statearr_14642_15945 = state_14602__$1;
(statearr_14642_15945[(1)] = (14));

} else {
var statearr_14643_15946 = state_14602__$1;
(statearr_14643_15946[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14603 === (9))){
var inst_14589 = (state_14602[(2)]);
var inst_14590 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_14602__$1 = (function (){var statearr_14644 = state_14602;
(statearr_14644[(15)] = inst_14589);

return statearr_14644;
})();
if(cljs.core.truth_(inst_14590)){
var statearr_14645_15947 = state_14602__$1;
(statearr_14645_15947[(1)] = (21));

} else {
var statearr_14646_15948 = state_14602__$1;
(statearr_14646_15948[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14603 === (5))){
var inst_14545 = cljs.core.async.close_BANG_(out);
var state_14602__$1 = state_14602;
var statearr_14647_15949 = state_14602__$1;
(statearr_14647_15949[(2)] = inst_14545);

(statearr_14647_15949[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14603 === (14))){
var inst_14567 = (state_14602[(7)]);
var inst_14569 = cljs.core.chunked_seq_QMARK_(inst_14567);
var state_14602__$1 = state_14602;
if(inst_14569){
var statearr_14648_15950 = state_14602__$1;
(statearr_14648_15950[(1)] = (17));

} else {
var statearr_14649_15951 = state_14602__$1;
(statearr_14649_15951[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14603 === (16))){
var inst_14585 = (state_14602[(2)]);
var state_14602__$1 = state_14602;
var statearr_14650_15952 = state_14602__$1;
(statearr_14650_15952[(2)] = inst_14585);

(statearr_14650_15952[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14603 === (10))){
var inst_14554 = (state_14602[(9)]);
var inst_14556 = (state_14602[(10)]);
var inst_14561 = cljs.core._nth(inst_14554,inst_14556);
var state_14602__$1 = state_14602;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14602__$1,(13),out,inst_14561);
} else {
if((state_val_14603 === (18))){
var inst_14567 = (state_14602[(7)]);
var inst_14576 = cljs.core.first(inst_14567);
var state_14602__$1 = state_14602;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14602__$1,(20),out,inst_14576);
} else {
if((state_val_14603 === (8))){
var inst_14556 = (state_14602[(10)]);
var inst_14555 = (state_14602[(12)]);
var inst_14558 = (inst_14556 < inst_14555);
var inst_14559 = inst_14558;
var state_14602__$1 = state_14602;
if(cljs.core.truth_(inst_14559)){
var statearr_14651_15953 = state_14602__$1;
(statearr_14651_15953[(1)] = (10));

} else {
var statearr_14652_15954 = state_14602__$1;
(statearr_14652_15954[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__12087__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__12087__auto____0 = (function (){
var statearr_14656 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14656[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__12087__auto__);

(statearr_14656[(1)] = (1));

return statearr_14656;
});
var cljs$core$async$mapcat_STAR__$_state_machine__12087__auto____1 = (function (state_14602){
while(true){
var ret_value__12088__auto__ = (function (){try{while(true){
var result__12089__auto__ = switch__12086__auto__(state_14602);
if(cljs.core.keyword_identical_QMARK_(result__12089__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12089__auto__;
}
break;
}
}catch (e14657){var ex__12090__auto__ = e14657;
var statearr_14658_15956 = state_14602;
(statearr_14658_15956[(2)] = ex__12090__auto__);


if(cljs.core.seq((state_14602[(4)]))){
var statearr_14659_15957 = state_14602;
(statearr_14659_15957[(1)] = cljs.core.first((state_14602[(4)])));

} else {
throw ex__12090__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15961 = state_14602;
state_14602 = G__15961;
continue;
} else {
return ret_value__12088__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__12087__auto__ = function(state_14602){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__12087__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__12087__auto____1.call(this,state_14602);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__12087__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__12087__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__12087__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__12087__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__12087__auto__;
})()
})();
var state__12387__auto__ = (function (){var statearr_14662 = f__12386__auto__();
(statearr_14662[(6)] = c__12385__auto__);

return statearr_14662;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12387__auto__);
}));

return c__12385__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__14664 = arguments.length;
switch (G__14664) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__14669 = arguments.length;
switch (G__14669) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__14674 = arguments.length;
switch (G__14674) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12385__auto___15967 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12386__auto__ = (function (){var switch__12086__auto__ = (function (state_14698){
var state_val_14699 = (state_14698[(1)]);
if((state_val_14699 === (7))){
var inst_14693 = (state_14698[(2)]);
var state_14698__$1 = state_14698;
var statearr_14700_15968 = state_14698__$1;
(statearr_14700_15968[(2)] = inst_14693);

(statearr_14700_15968[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14699 === (1))){
var inst_14675 = null;
var state_14698__$1 = (function (){var statearr_14701 = state_14698;
(statearr_14701[(7)] = inst_14675);

return statearr_14701;
})();
var statearr_14702_15969 = state_14698__$1;
(statearr_14702_15969[(2)] = null);

(statearr_14702_15969[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14699 === (4))){
var inst_14678 = (state_14698[(8)]);
var inst_14678__$1 = (state_14698[(2)]);
var inst_14679 = (inst_14678__$1 == null);
var inst_14680 = cljs.core.not(inst_14679);
var state_14698__$1 = (function (){var statearr_14703 = state_14698;
(statearr_14703[(8)] = inst_14678__$1);

return statearr_14703;
})();
if(inst_14680){
var statearr_14704_15970 = state_14698__$1;
(statearr_14704_15970[(1)] = (5));

} else {
var statearr_14705_15971 = state_14698__$1;
(statearr_14705_15971[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14699 === (6))){
var state_14698__$1 = state_14698;
var statearr_14706_15972 = state_14698__$1;
(statearr_14706_15972[(2)] = null);

(statearr_14706_15972[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14699 === (3))){
var inst_14695 = (state_14698[(2)]);
var inst_14696 = cljs.core.async.close_BANG_(out);
var state_14698__$1 = (function (){var statearr_14710 = state_14698;
(statearr_14710[(9)] = inst_14695);

return statearr_14710;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_14698__$1,inst_14696);
} else {
if((state_val_14699 === (2))){
var state_14698__$1 = state_14698;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14698__$1,(4),ch);
} else {
if((state_val_14699 === (11))){
var inst_14678 = (state_14698[(8)]);
var inst_14687 = (state_14698[(2)]);
var inst_14675 = inst_14678;
var state_14698__$1 = (function (){var statearr_14711 = state_14698;
(statearr_14711[(7)] = inst_14675);

(statearr_14711[(10)] = inst_14687);

return statearr_14711;
})();
var statearr_14712_15977 = state_14698__$1;
(statearr_14712_15977[(2)] = null);

(statearr_14712_15977[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14699 === (9))){
var inst_14678 = (state_14698[(8)]);
var state_14698__$1 = state_14698;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14698__$1,(11),out,inst_14678);
} else {
if((state_val_14699 === (5))){
var inst_14675 = (state_14698[(7)]);
var inst_14678 = (state_14698[(8)]);
var inst_14682 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_14678,inst_14675);
var state_14698__$1 = state_14698;
if(inst_14682){
var statearr_14714_15979 = state_14698__$1;
(statearr_14714_15979[(1)] = (8));

} else {
var statearr_14715_15983 = state_14698__$1;
(statearr_14715_15983[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14699 === (10))){
var inst_14690 = (state_14698[(2)]);
var state_14698__$1 = state_14698;
var statearr_14719_15984 = state_14698__$1;
(statearr_14719_15984[(2)] = inst_14690);

(statearr_14719_15984[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14699 === (8))){
var inst_14675 = (state_14698[(7)]);
var tmp14713 = inst_14675;
var inst_14675__$1 = tmp14713;
var state_14698__$1 = (function (){var statearr_14725 = state_14698;
(statearr_14725[(7)] = inst_14675__$1);

return statearr_14725;
})();
var statearr_14726_15996 = state_14698__$1;
(statearr_14726_15996[(2)] = null);

(statearr_14726_15996[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__12087__auto__ = null;
var cljs$core$async$state_machine__12087__auto____0 = (function (){
var statearr_14729 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14729[(0)] = cljs$core$async$state_machine__12087__auto__);

(statearr_14729[(1)] = (1));

return statearr_14729;
});
var cljs$core$async$state_machine__12087__auto____1 = (function (state_14698){
while(true){
var ret_value__12088__auto__ = (function (){try{while(true){
var result__12089__auto__ = switch__12086__auto__(state_14698);
if(cljs.core.keyword_identical_QMARK_(result__12089__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12089__auto__;
}
break;
}
}catch (e14730){var ex__12090__auto__ = e14730;
var statearr_14731_15997 = state_14698;
(statearr_14731_15997[(2)] = ex__12090__auto__);


if(cljs.core.seq((state_14698[(4)]))){
var statearr_14732_15998 = state_14698;
(statearr_14732_15998[(1)] = cljs.core.first((state_14698[(4)])));

} else {
throw ex__12090__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15999 = state_14698;
state_14698 = G__15999;
continue;
} else {
return ret_value__12088__auto__;
}
break;
}
});
cljs$core$async$state_machine__12087__auto__ = function(state_14698){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12087__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12087__auto____1.call(this,state_14698);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12087__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12087__auto____0;
cljs$core$async$state_machine__12087__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12087__auto____1;
return cljs$core$async$state_machine__12087__auto__;
})()
})();
var state__12387__auto__ = (function (){var statearr_14736 = f__12386__auto__();
(statearr_14736[(6)] = c__12385__auto___15967);

return statearr_14736;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12387__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__14738 = arguments.length;
switch (G__14738) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12385__auto___16006 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12386__auto__ = (function (){var switch__12086__auto__ = (function (state_14783){
var state_val_14784 = (state_14783[(1)]);
if((state_val_14784 === (7))){
var inst_14779 = (state_14783[(2)]);
var state_14783__$1 = state_14783;
var statearr_14785_16007 = state_14783__$1;
(statearr_14785_16007[(2)] = inst_14779);

(statearr_14785_16007[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (1))){
var inst_14746 = (new Array(n));
var inst_14747 = inst_14746;
var inst_14748 = (0);
var state_14783__$1 = (function (){var statearr_14789 = state_14783;
(statearr_14789[(7)] = inst_14747);

(statearr_14789[(8)] = inst_14748);

return statearr_14789;
})();
var statearr_14790_16012 = state_14783__$1;
(statearr_14790_16012[(2)] = null);

(statearr_14790_16012[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (4))){
var inst_14751 = (state_14783[(9)]);
var inst_14751__$1 = (state_14783[(2)]);
var inst_14752 = (inst_14751__$1 == null);
var inst_14753 = cljs.core.not(inst_14752);
var state_14783__$1 = (function (){var statearr_14791 = state_14783;
(statearr_14791[(9)] = inst_14751__$1);

return statearr_14791;
})();
if(inst_14753){
var statearr_14792_16013 = state_14783__$1;
(statearr_14792_16013[(1)] = (5));

} else {
var statearr_14793_16014 = state_14783__$1;
(statearr_14793_16014[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (15))){
var inst_14773 = (state_14783[(2)]);
var state_14783__$1 = state_14783;
var statearr_14797_16015 = state_14783__$1;
(statearr_14797_16015[(2)] = inst_14773);

(statearr_14797_16015[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (13))){
var state_14783__$1 = state_14783;
var statearr_14798_16016 = state_14783__$1;
(statearr_14798_16016[(2)] = null);

(statearr_14798_16016[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (6))){
var inst_14748 = (state_14783[(8)]);
var inst_14769 = (inst_14748 > (0));
var state_14783__$1 = state_14783;
if(cljs.core.truth_(inst_14769)){
var statearr_14799_16017 = state_14783__$1;
(statearr_14799_16017[(1)] = (12));

} else {
var statearr_14800_16018 = state_14783__$1;
(statearr_14800_16018[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (3))){
var inst_14781 = (state_14783[(2)]);
var state_14783__$1 = state_14783;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14783__$1,inst_14781);
} else {
if((state_val_14784 === (12))){
var inst_14747 = (state_14783[(7)]);
var inst_14771 = cljs.core.vec(inst_14747);
var state_14783__$1 = state_14783;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14783__$1,(15),out,inst_14771);
} else {
if((state_val_14784 === (2))){
var state_14783__$1 = state_14783;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14783__$1,(4),ch);
} else {
if((state_val_14784 === (11))){
var inst_14763 = (state_14783[(2)]);
var inst_14764 = (new Array(n));
var inst_14747 = inst_14764;
var inst_14748 = (0);
var state_14783__$1 = (function (){var statearr_14805 = state_14783;
(statearr_14805[(7)] = inst_14747);

(statearr_14805[(10)] = inst_14763);

(statearr_14805[(8)] = inst_14748);

return statearr_14805;
})();
var statearr_14806_16024 = state_14783__$1;
(statearr_14806_16024[(2)] = null);

(statearr_14806_16024[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (9))){
var inst_14747 = (state_14783[(7)]);
var inst_14761 = cljs.core.vec(inst_14747);
var state_14783__$1 = state_14783;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14783__$1,(11),out,inst_14761);
} else {
if((state_val_14784 === (5))){
var inst_14747 = (state_14783[(7)]);
var inst_14751 = (state_14783[(9)]);
var inst_14756 = (state_14783[(11)]);
var inst_14748 = (state_14783[(8)]);
var inst_14755 = (inst_14747[inst_14748] = inst_14751);
var inst_14756__$1 = (inst_14748 + (1));
var inst_14757 = (inst_14756__$1 < n);
var state_14783__$1 = (function (){var statearr_14807 = state_14783;
(statearr_14807[(11)] = inst_14756__$1);

(statearr_14807[(12)] = inst_14755);

return statearr_14807;
})();
if(cljs.core.truth_(inst_14757)){
var statearr_14808_16029 = state_14783__$1;
(statearr_14808_16029[(1)] = (8));

} else {
var statearr_14809_16030 = state_14783__$1;
(statearr_14809_16030[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (14))){
var inst_14776 = (state_14783[(2)]);
var inst_14777 = cljs.core.async.close_BANG_(out);
var state_14783__$1 = (function (){var statearr_14811 = state_14783;
(statearr_14811[(13)] = inst_14776);

return statearr_14811;
})();
var statearr_14812_16035 = state_14783__$1;
(statearr_14812_16035[(2)] = inst_14777);

(statearr_14812_16035[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (10))){
var inst_14767 = (state_14783[(2)]);
var state_14783__$1 = state_14783;
var statearr_14816_16036 = state_14783__$1;
(statearr_14816_16036[(2)] = inst_14767);

(statearr_14816_16036[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14784 === (8))){
var inst_14747 = (state_14783[(7)]);
var inst_14756 = (state_14783[(11)]);
var tmp14810 = inst_14747;
var inst_14747__$1 = tmp14810;
var inst_14748 = inst_14756;
var state_14783__$1 = (function (){var statearr_14817 = state_14783;
(statearr_14817[(7)] = inst_14747__$1);

(statearr_14817[(8)] = inst_14748);

return statearr_14817;
})();
var statearr_14818_16037 = state_14783__$1;
(statearr_14818_16037[(2)] = null);

(statearr_14818_16037[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__12087__auto__ = null;
var cljs$core$async$state_machine__12087__auto____0 = (function (){
var statearr_14819 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14819[(0)] = cljs$core$async$state_machine__12087__auto__);

(statearr_14819[(1)] = (1));

return statearr_14819;
});
var cljs$core$async$state_machine__12087__auto____1 = (function (state_14783){
while(true){
var ret_value__12088__auto__ = (function (){try{while(true){
var result__12089__auto__ = switch__12086__auto__(state_14783);
if(cljs.core.keyword_identical_QMARK_(result__12089__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12089__auto__;
}
break;
}
}catch (e14820){var ex__12090__auto__ = e14820;
var statearr_14821_16038 = state_14783;
(statearr_14821_16038[(2)] = ex__12090__auto__);


if(cljs.core.seq((state_14783[(4)]))){
var statearr_14822_16039 = state_14783;
(statearr_14822_16039[(1)] = cljs.core.first((state_14783[(4)])));

} else {
throw ex__12090__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16040 = state_14783;
state_14783 = G__16040;
continue;
} else {
return ret_value__12088__auto__;
}
break;
}
});
cljs$core$async$state_machine__12087__auto__ = function(state_14783){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12087__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12087__auto____1.call(this,state_14783);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12087__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12087__auto____0;
cljs$core$async$state_machine__12087__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12087__auto____1;
return cljs$core$async$state_machine__12087__auto__;
})()
})();
var state__12387__auto__ = (function (){var statearr_14823 = f__12386__auto__();
(statearr_14823[(6)] = c__12385__auto___16006);

return statearr_14823;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12387__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__14842 = arguments.length;
switch (G__14842) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12385__auto___16042 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12386__auto__ = (function (){var switch__12086__auto__ = (function (state_14913){
var state_val_14914 = (state_14913[(1)]);
if((state_val_14914 === (7))){
var inst_14903 = (state_14913[(2)]);
var state_14913__$1 = state_14913;
var statearr_14915_16043 = state_14913__$1;
(statearr_14915_16043[(2)] = inst_14903);

(statearr_14915_16043[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14914 === (1))){
var inst_14849 = [];
var inst_14850 = inst_14849;
var inst_14851 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_14913__$1 = (function (){var statearr_14916 = state_14913;
(statearr_14916[(7)] = inst_14851);

(statearr_14916[(8)] = inst_14850);

return statearr_14916;
})();
var statearr_14919_16044 = state_14913__$1;
(statearr_14919_16044[(2)] = null);

(statearr_14919_16044[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14914 === (4))){
var inst_14854 = (state_14913[(9)]);
var inst_14854__$1 = (state_14913[(2)]);
var inst_14855 = (inst_14854__$1 == null);
var inst_14856 = cljs.core.not(inst_14855);
var state_14913__$1 = (function (){var statearr_14920 = state_14913;
(statearr_14920[(9)] = inst_14854__$1);

return statearr_14920;
})();
if(inst_14856){
var statearr_14921_16045 = state_14913__$1;
(statearr_14921_16045[(1)] = (5));

} else {
var statearr_14923_16046 = state_14913__$1;
(statearr_14923_16046[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14914 === (15))){
var inst_14850 = (state_14913[(8)]);
var inst_14895 = cljs.core.vec(inst_14850);
var state_14913__$1 = state_14913;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14913__$1,(18),out,inst_14895);
} else {
if((state_val_14914 === (13))){
var inst_14890 = (state_14913[(2)]);
var state_14913__$1 = state_14913;
var statearr_14924_16047 = state_14913__$1;
(statearr_14924_16047[(2)] = inst_14890);

(statearr_14924_16047[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14914 === (6))){
var inst_14850 = (state_14913[(8)]);
var inst_14892 = inst_14850.length;
var inst_14893 = (inst_14892 > (0));
var state_14913__$1 = state_14913;
if(cljs.core.truth_(inst_14893)){
var statearr_14925_16049 = state_14913__$1;
(statearr_14925_16049[(1)] = (15));

} else {
var statearr_14938_16051 = state_14913__$1;
(statearr_14938_16051[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14914 === (17))){
var inst_14900 = (state_14913[(2)]);
var inst_14901 = cljs.core.async.close_BANG_(out);
var state_14913__$1 = (function (){var statearr_14939 = state_14913;
(statearr_14939[(10)] = inst_14900);

return statearr_14939;
})();
var statearr_14940_16052 = state_14913__$1;
(statearr_14940_16052[(2)] = inst_14901);

(statearr_14940_16052[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14914 === (3))){
var inst_14905 = (state_14913[(2)]);
var state_14913__$1 = state_14913;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14913__$1,inst_14905);
} else {
if((state_val_14914 === (12))){
var inst_14850 = (state_14913[(8)]);
var inst_14883 = cljs.core.vec(inst_14850);
var state_14913__$1 = state_14913;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14913__$1,(14),out,inst_14883);
} else {
if((state_val_14914 === (2))){
var state_14913__$1 = state_14913;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14913__$1,(4),ch);
} else {
if((state_val_14914 === (11))){
var inst_14866 = (state_14913[(11)]);
var inst_14854 = (state_14913[(9)]);
var inst_14850 = (state_14913[(8)]);
var inst_14880 = inst_14850.push(inst_14854);
var tmp14944 = inst_14850;
var inst_14850__$1 = tmp14944;
var inst_14851 = inst_14866;
var state_14913__$1 = (function (){var statearr_14945 = state_14913;
(statearr_14945[(7)] = inst_14851);

(statearr_14945[(12)] = inst_14880);

(statearr_14945[(8)] = inst_14850__$1);

return statearr_14945;
})();
var statearr_14946_16053 = state_14913__$1;
(statearr_14946_16053[(2)] = null);

(statearr_14946_16053[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14914 === (9))){
var inst_14851 = (state_14913[(7)]);
var inst_14873 = cljs.core.keyword_identical_QMARK_(inst_14851,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_14913__$1 = state_14913;
var statearr_14947_16055 = state_14913__$1;
(statearr_14947_16055[(2)] = inst_14873);

(statearr_14947_16055[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14914 === (5))){
var inst_14867 = (state_14913[(13)]);
var inst_14866 = (state_14913[(11)]);
var inst_14851 = (state_14913[(7)]);
var inst_14854 = (state_14913[(9)]);
var inst_14866__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_14854) : f.call(null,inst_14854));
var inst_14867__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_14866__$1,inst_14851);
var state_14913__$1 = (function (){var statearr_14948 = state_14913;
(statearr_14948[(13)] = inst_14867__$1);

(statearr_14948[(11)] = inst_14866__$1);

return statearr_14948;
})();
if(inst_14867__$1){
var statearr_14949_16059 = state_14913__$1;
(statearr_14949_16059[(1)] = (8));

} else {
var statearr_14950_16060 = state_14913__$1;
(statearr_14950_16060[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14914 === (14))){
var inst_14866 = (state_14913[(11)]);
var inst_14854 = (state_14913[(9)]);
var inst_14885 = (state_14913[(2)]);
var inst_14886 = [];
var inst_14887 = inst_14886.push(inst_14854);
var inst_14850 = inst_14886;
var inst_14851 = inst_14866;
var state_14913__$1 = (function (){var statearr_14951 = state_14913;
(statearr_14951[(14)] = inst_14887);

(statearr_14951[(7)] = inst_14851);

(statearr_14951[(15)] = inst_14885);

(statearr_14951[(8)] = inst_14850);

return statearr_14951;
})();
var statearr_14952_16061 = state_14913__$1;
(statearr_14952_16061[(2)] = null);

(statearr_14952_16061[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14914 === (16))){
var state_14913__$1 = state_14913;
var statearr_14953_16062 = state_14913__$1;
(statearr_14953_16062[(2)] = null);

(statearr_14953_16062[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14914 === (10))){
var inst_14878 = (state_14913[(2)]);
var state_14913__$1 = state_14913;
if(cljs.core.truth_(inst_14878)){
var statearr_14954_16068 = state_14913__$1;
(statearr_14954_16068[(1)] = (11));

} else {
var statearr_14955_16069 = state_14913__$1;
(statearr_14955_16069[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14914 === (18))){
var inst_14897 = (state_14913[(2)]);
var state_14913__$1 = state_14913;
var statearr_14956_16070 = state_14913__$1;
(statearr_14956_16070[(2)] = inst_14897);

(statearr_14956_16070[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14914 === (8))){
var inst_14867 = (state_14913[(13)]);
var state_14913__$1 = state_14913;
var statearr_14957_16071 = state_14913__$1;
(statearr_14957_16071[(2)] = inst_14867);

(statearr_14957_16071[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__12087__auto__ = null;
var cljs$core$async$state_machine__12087__auto____0 = (function (){
var statearr_14958 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14958[(0)] = cljs$core$async$state_machine__12087__auto__);

(statearr_14958[(1)] = (1));

return statearr_14958;
});
var cljs$core$async$state_machine__12087__auto____1 = (function (state_14913){
while(true){
var ret_value__12088__auto__ = (function (){try{while(true){
var result__12089__auto__ = switch__12086__auto__(state_14913);
if(cljs.core.keyword_identical_QMARK_(result__12089__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12089__auto__;
}
break;
}
}catch (e14959){var ex__12090__auto__ = e14959;
var statearr_14960_16078 = state_14913;
(statearr_14960_16078[(2)] = ex__12090__auto__);


if(cljs.core.seq((state_14913[(4)]))){
var statearr_14961_16079 = state_14913;
(statearr_14961_16079[(1)] = cljs.core.first((state_14913[(4)])));

} else {
throw ex__12090__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16080 = state_14913;
state_14913 = G__16080;
continue;
} else {
return ret_value__12088__auto__;
}
break;
}
});
cljs$core$async$state_machine__12087__auto__ = function(state_14913){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12087__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12087__auto____1.call(this,state_14913);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12087__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12087__auto____0;
cljs$core$async$state_machine__12087__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12087__auto____1;
return cljs$core$async$state_machine__12087__auto__;
})()
})();
var state__12387__auto__ = (function (){var statearr_14962 = f__12386__auto__();
(statearr_14962[(6)] = c__12385__auto___16042);

return statearr_14962;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12387__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
