goog.provide('taoensso.telemere.utils');
/**
 * `:info` -> "INFO",
 *     `5` -> "LEVEL:5", etc.
 */
taoensso.telemere.utils.format_level = taoensso.encore.signals.format_level;

/**
 * `:foo.bar/baz` -> "::baz", etc.
 */
taoensso.telemere.utils.format_id = taoensso.encore.signals.format_id;
/**
 * Alpha, subject to change.
 *   Returns a (fn nano-uid [root?]) that returns a random nano-style uid string like:
 *  "r76-B8LoIPs5lBG1_Uhdy" - 126 bit (21 char)     root         uid
 *  "tMEYoZH0K-"            - 60  bit (10 char) non-root (child) uid
 */
taoensso.telemere.utils.nano_uid_fn = (function taoensso$telemere$utils$nano_uid_fn(var_args){
var G__17005 = arguments.length;
switch (G__17005) {
case 0:
return taoensso.telemere.utils.nano_uid_fn.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.telemere.utils.nano_uid_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(taoensso.telemere.utils.nano_uid_fn.cljs$core$IFn$_invoke$arity$0 = (function (){
return taoensso.telemere.utils.nano_uid_fn.cljs$core$IFn$_invoke$arity$1(null);
}));

(taoensso.telemere.utils.nano_uid_fn.cljs$core$IFn$_invoke$arity$1 = (function (p__17007){
var map__17008 = p__17007;
var map__17008__$1 = cljs.core.__destructure_map(map__17008);
var secure_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17008__$1,new cljs.core.Keyword(null,"secure?","secure?",-368029718));
var root_len = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__17008__$1,new cljs.core.Keyword(null,"root-len","root-len",-204417175),(21));
var child_len = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__17008__$1,new cljs.core.Keyword(null,"child-len","child-len",1548141543),(10));
var root_len__$1 = cljs.core.long$(root_len);
var child_len__$1 = cljs.core.long$(child_len);
return (function taoensso$telemere$utils$nano_uid(root_QMARK_){
if(cljs.core.truth_(root_QMARK_)){
return taoensso.encore.nanoid.cljs$core$IFn$_invoke$arity$2(secure_QMARK_,root_len__$1);
} else {
return taoensso.encore.nanoid.cljs$core$IFn$_invoke$arity$2(secure_QMARK_,child_len__$1);
}
});
}));

(taoensso.telemere.utils.nano_uid_fn.cljs$lang$maxFixedArity = 1);

/**
 * Alpha, subject to change.
 *   Returns a (fn hex-uid [root?]) that returns a random hex-style uid string like:
 *  "05039666eb9dc3206475f44ab9f3d843" - 128 bit (32 char)     root         uid
 *  "721fcef639a51513"                 - 64  bit (16 char) non-root (child) uid
 */
taoensso.telemere.utils.hex_uid_fn = (function taoensso$telemere$utils$hex_uid_fn(var_args){
var G__17010 = arguments.length;
switch (G__17010) {
case 0:
return taoensso.telemere.utils.hex_uid_fn.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.telemere.utils.hex_uid_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(taoensso.telemere.utils.hex_uid_fn.cljs$core$IFn$_invoke$arity$0 = (function (){
return taoensso.telemere.utils.hex_uid_fn.cljs$core$IFn$_invoke$arity$1(null);
}));

(taoensso.telemere.utils.hex_uid_fn.cljs$core$IFn$_invoke$arity$1 = (function (p__17011){
var map__17012 = p__17011;
var map__17012__$1 = cljs.core.__destructure_map(map__17012);
var secure_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17012__$1,new cljs.core.Keyword(null,"secure?","secure?",-368029718));
var root_len = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__17012__$1,new cljs.core.Keyword(null,"root-len","root-len",-204417175),(32));
var child_len = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__17012__$1,new cljs.core.Keyword(null,"child-len","child-len",1548141543),(16));
var root_len__$1 = cljs.core.long$(root_len);
var child_len__$1 = cljs.core.long$(child_len);
var rand_bytes_fn = (cljs.core.truth_(secure_QMARK_)?cljs.core.partial.cljs$core$IFn$_invoke$arity$2(taoensso.encore.rand_bytes,true):cljs.core.partial.cljs$core$IFn$_invoke$arity$2(taoensso.encore.rand_bytes,false));
var hex_uid_root = taoensso.encore.rand_id_fn(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"chars","chars",-1094630317),new cljs.core.Keyword(null,"hex-lowercase","hex-lowercase",1090135664),new cljs.core.Keyword(null,"len","len",1423657078),root_len__$1,new cljs.core.Keyword(null,"rand-bytes-fn","rand-bytes-fn",501267911),rand_bytes_fn], null));
var hex_uid_child = taoensso.encore.rand_id_fn(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"chars","chars",-1094630317),new cljs.core.Keyword(null,"hex-lowercase","hex-lowercase",1090135664),new cljs.core.Keyword(null,"len","len",1423657078),child_len__$1,new cljs.core.Keyword(null,"rand-bytes-fn","rand-bytes-fn",501267911),rand_bytes_fn], null));
return (function taoensso$telemere$utils$hex_uid(root_QMARK_){
if(cljs.core.truth_(root_QMARK_)){
return hex_uid_root();
} else {
return hex_uid_child();
}
});
}));

(taoensso.telemere.utils.hex_uid_fn.cljs$lang$maxFixedArity = 1);

/**
 * Private, don't use.
 *   Returns (fn uid [root?]) for given uid kind.
 */
taoensso.telemere.utils.parse_uid_fn = (function taoensso$telemere$utils$parse_uid_fn(kind){
var G__17014 = kind;
var G__17014__$1 = (((G__17014 instanceof cljs.core.Keyword))?G__17014.fqn:null);
switch (G__17014__$1) {
case "uuid":
return (function (_root_QMARK_){
return taoensso.encore.uuid();
});

break;
case "uuid-str":
return (function (_root_QMARK_){
return taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$0();
});

break;
case "default":
return taoensso.telemere.utils.nano_uid_fn.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"secure?","secure?",-368029718),false], null));

break;
case "nano/insecure":
return taoensso.telemere.utils.nano_uid_fn.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"secure?","secure?",-368029718),false], null));

break;
case "nano/secure":
return taoensso.telemere.utils.nano_uid_fn.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"secure?","secure?",-368029718),true], null));

break;
case "hex/insecure":
return taoensso.telemere.utils.hex_uid_fn.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"secure?","secure?",-368029718),false], null));

break;
case "hex/secure":
return taoensso.telemere.utils.hex_uid_fn.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"secure?","secure?",-368029718),true], null));

break;
default:
var or__5002__auto__ = ((cljs.core.vector_QMARK_(kind))?(function (){var vec__17015 = kind;
var kind__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17015,(0),null);
var root_len = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17015,(1),null);
var child_len = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17015,(2),null);
var G__17018 = kind__$1;
var G__17018__$1 = (((G__17018 instanceof cljs.core.Keyword))?G__17018.fqn:null);
switch (G__17018__$1) {
case "nano/insecure":
return taoensso.telemere.utils.nano_uid_fn.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"secure?","secure?",-368029718),false,new cljs.core.Keyword(null,"root-len","root-len",-204417175),root_len,new cljs.core.Keyword(null,"child-len","child-len",1548141543),child_len], null));

break;
case "nano/secure":
return taoensso.telemere.utils.nano_uid_fn.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"secure?","secure?",-368029718),true,new cljs.core.Keyword(null,"root-len","root-len",-204417175),root_len,new cljs.core.Keyword(null,"child-len","child-len",1548141543),child_len], null));

break;
case "hex/insecure":
return taoensso.telemere.utils.hex_uid_fn.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"secure?","secure?",-368029718),false,new cljs.core.Keyword(null,"root-len","root-len",-204417175),root_len,new cljs.core.Keyword(null,"child-len","child-len",1548141543),child_len], null));

break;
case "hex/secure":
return taoensso.telemere.utils.hex_uid_fn.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"secure?","secure?",-368029718),true,new cljs.core.Keyword(null,"root-len","root-len",-204417175),root_len,new cljs.core.Keyword(null,"child-len","child-len",1548141543),child_len], null));

break;
default:
return null;

}
})():null);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return taoensso.truss.unexpected_arg_BANG__STAR_("taoensso.telemere.utils",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [122,7], null),kind,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"param","param",2013631823),new cljs.core.Symbol(null,"kind","kind",923265724,null),new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Symbol("taoensso.telemere.utils","uid-fn","taoensso.telemere.utils/uid-fn",790130699,null),new cljs.core.Keyword(null,"expected","expected",1583670997),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Keyword(null,"default","default",-1987822328),"null",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nano","insecure","nano/insecure",-1399463185),new cljs.core.Symbol(null,"<root-len>","<root-len>",-540063912,null),new cljs.core.Symbol(null,"<child-len>","<child-len>",-1454733286,null)], null),"null",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nano","secure","nano/secure",174489112),new cljs.core.Symbol(null,"<root-len>","<root-len>",-540063912,null),new cljs.core.Symbol(null,"<child-len>","<child-len>",-1454733286,null)], null),"null",new cljs.core.Keyword("nano","insecure","nano/insecure",-1399463185),"null",new cljs.core.Keyword(null,"uuid-str","uuid-str",358395442),"null",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("hex","insecure","hex/insecure",-1411913130),new cljs.core.Symbol(null,"<root-len>","<root-len>",-540063912,null),new cljs.core.Symbol(null,"<child-len>","<child-len>",-1454733286,null)], null),"null",new cljs.core.Keyword("hex","insecure","hex/insecure",-1411913130),"null",new cljs.core.Keyword("nano","secure","nano/secure",174489112),"null",new cljs.core.Keyword(null,"uuid","uuid",-2145095719),"null",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("hex","secure","hex/secure",177509789),new cljs.core.Symbol(null,"<root-len>","<root-len>",-540063912,null),new cljs.core.Symbol(null,"<child-len>","<child-len>",-1454733286,null)], null),"null",new cljs.core.Keyword("hex","secure","hex/secure",177509789),"null"], null), null)], null));
}

}
});
/**
 * Single system newline
 */
taoensso.telemere.utils.newline = "\n";

/**
 * Prints given arg to an edn string readable with `read-edn`.
 */
taoensso.telemere.utils.pr_edn = taoensso.encore.pr_edn;

/**
 * Returns a random UUID string of given length (max 36).
 *   Uses strong randomness when possible. See also `uuid`, `nanoid`, `rand-id-fn`.
 */
taoensso.telemere.utils.uuid_str = taoensso.encore.uuid_str;

/**
 * Returns given Cljs argument as JSON string.
 */
taoensso.telemere.utils.pr_json = taoensso.encore.pr_json;
/**
 * Returns JavaScript console logger to match given signal level:
 *     `:debug` -> `js/console.debug`,
 *     `:error` -> `js/console.error`, etc.
 * 
 *   Defaults to `js.console.log` for unmatched signal levels.
 *   NB: assumes that `js/console` exists, handler constructors should check first!
 */
taoensso.telemere.utils.js_console_logger = (function taoensso$telemere$utils$js_console_logger(level){
var G__17019 = level;
var G__17019__$1 = (((G__17019 instanceof cljs.core.Keyword))?G__17019.fqn:null);
switch (G__17019__$1) {
case "trace":
return console.debug;

break;
case "debug":
return console.debug;

break;
case "info":
return console.info;

break;
case "warn":
return console.warn;

break;
case "error":
return console.error;

break;
case "fatal":
return console.error;

break;
case "report":
return console.info;

break;
default:
return console.log;

}
});
/**
 * Returns true iff given signal has an `:error` value, or a `:kind` or `:level`
 *   that indicates that it's an error.
 */
taoensso.telemere.utils.error_signal_QMARK_ = (function taoensso$telemere$utils$error_signal_QMARK_(signal){
var and__5000__auto__ = signal;
if(cljs.core.truth_(and__5000__auto__)){
return cljs.core.boolean$((function (){var or__5002__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(signal,new cljs.core.Keyword(null,"error","error",-978969032));
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
var or__5002__auto____$1 = cljs.core.keyword_identical_QMARK_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(signal,new cljs.core.Keyword(null,"kind","kind",-717265803)),new cljs.core.Keyword(null,"error","error",-978969032));
if(or__5002__auto____$1){
return or__5002__auto____$1;
} else {
var or__5002__auto____$2 = (function (){var G__17020 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(signal,new cljs.core.Keyword(null,"level","level",1290497552));
var G__17020__$1 = (((G__17020 instanceof cljs.core.Keyword))?G__17020.fqn:null);
switch (G__17020__$1) {
case "error":
case "fatal":
return true;

break;
default:
return false;

}
})();
if(cljs.core.truth_(or__5002__auto____$2)){
return or__5002__auto____$2;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(signal,new cljs.core.Keyword(null,"error?","error?",-460689159));
}
}
}
})());
} else {
return and__5000__auto__;
}
});
/**
 * Private, don't use.
 *   Returns given signal without app-level kvs or `:kvs` key.
 */
taoensso.telemere.utils.remove_signal_kvs = (function taoensso$telemere$utils$remove_signal_kvs(signal){
var temp__5802__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(signal,new cljs.core.Keyword(null,"kvs","kvs",958455492));
if(cljs.core.truth_(temp__5802__auto__)){
var kvs = temp__5802__auto__;
return cljs.core.reduce_kv((function (m,k,_v){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(m,k);
}),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(signal,new cljs.core.Keyword(null,"kvs","kvs",958455492)),kvs);
} else {
return signal;
}
});
/**
 * Private, don't use.
 *   Returns given signal with nil-valued keys removed.
 */
taoensso.telemere.utils.remove_signal_nils = (function taoensso$telemere$utils$remove_signal_nils(signal){
if(taoensso.encore.editable_QMARK_(signal)){
return cljs.core.persistent_BANG_(cljs.core.reduce_kv((function (m,k,v){
if((v == null)){
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2(m,k);
} else {
return m;
}
}),cljs.core.transient$(signal),signal));
} else {
return cljs.core.persistent_BANG_(cljs.core.reduce_kv((function (m,k,v){
if((v == null)){
return m;
} else {
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
}),cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),signal));
}
});
/**
 * Private, don't use.
 *   Returns given signal with possible `:msg_` value forced (realized when a delay).
 */
taoensso.telemere.utils.force_signal_msg = (function taoensso$telemere$utils$force_signal_msg(signal){
var temp__5802__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(signal,new cljs.core.Keyword(null,"msg_","msg_",-1925147000));
if(cljs.core.truth_(temp__5802__auto__)){
var msg_ = temp__5802__auto__;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(signal,new cljs.core.Keyword(null,"msg_","msg_",-1925147000),cljs.core.force(msg_));
} else {
return signal;
}
});
/**
 * Private, don't use.
 *   Returns given signal with possible `:error` replaced by
 *   [{:keys [type msg data]} ...] cause chain.
 */
taoensso.telemere.utils.expand_signal_error = (function taoensso$telemere$utils$expand_signal_error(signal){
var b2__11384__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(signal,new cljs.core.Keyword(null,"error","error",-978969032));
if(cljs.core.truth_(b2__11384__auto__)){
var error = b2__11384__auto__;
var b2__11384__auto____$1 = taoensso.truss.ex_chain.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"as-map","as-map",633645847),error);
if(cljs.core.truth_(b2__11384__auto____$1)){
var chain = b2__11384__auto____$1;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(signal,new cljs.core.Keyword(null,"error","error",-978969032),chain);
} else {
return signal;
}
} else {
return signal;
}
});
/**
 * Alpha, subject to change.
 *   Returns a (fn format [nanosecs]) that:
 *  - Takes a long nanoseconds (e.g. runtime).
 *  - Returns a human-readable string like:
 *    "1.00m", "4.20s", "340ms", "822μs", etc.
 */
taoensso.telemere.utils.format_nsecs_fn = (function taoensso$telemere$utils$format_nsecs_fn(var_args){
var G__17024 = arguments.length;
switch (G__17024) {
case 0:
return taoensso.telemere.utils.format_nsecs_fn.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.telemere.utils.format_nsecs_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(taoensso.telemere.utils.format_nsecs_fn.cljs$core$IFn$_invoke$arity$0 = (function (){
return taoensso.telemere.utils.format_nsecs_fn.cljs$core$IFn$_invoke$arity$1(null);
}));

(taoensso.telemere.utils.format_nsecs_fn.cljs$core$IFn$_invoke$arity$1 = (function (p__17025){
var map__17026 = p__17025;
var map__17026__$1 = cljs.core.__destructure_map(map__17026);
var _opts = map__17026__$1;
return (function taoensso$telemere$utils$format_nsecs(nanosecs){
return taoensso.encore.format_nsecs(nanosecs);
});
}));

(taoensso.telemere.utils.format_nsecs_fn.cljs$lang$maxFixedArity = 1);

/**
 * Experimental, subject to change without notice.
 * 
 *   Returns a (fn format [instant]) that:
 *  - Takes a platform instant (`java.time.Instant` or `js/Date`).
 *  - Returns a formatted human-readable instant string.
 * 
 *   Options:
 *  `:formatter`
 *    Clj:  `java.time.format.DateTimeFormatter`
 *    Cljs: `goog.i18n.DateTimeFormat`
 * 
 *    Defaults to `ISO8601` formatter (`YYYY-MM-DDTHH:mm:ss.sssZ`),
 *    e.g.: "2011-12-03T10:15:130Z".
 * 
 *  `:zone` (Clj only) `java.time.ZoneOffset` (defaults to UTC).
 *   Note that zone may be ignored by some `DateTimeFormatter`s,
 *   including the default (`DateTimeFormatter/ISO_INSTANT`)!
 */
taoensso.telemere.utils.format_inst_fn = taoensso.encore.format_inst_fn;
/**
 * Alpha, subject to change.
 *   Returns a (fn format [error]) that:
 *  - Takes a platform error (`Throwable` or `js/Error`).
 *  - Returns a human-readable error string.
 */
taoensso.telemere.utils.format_error_fn = (function taoensso$telemere$utils$format_error_fn(var_args){
var G__17029 = arguments.length;
switch (G__17029) {
case 0:
return taoensso.telemere.utils.format_error_fn.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.telemere.utils.format_error_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(taoensso.telemere.utils.format_error_fn.cljs$core$IFn$_invoke$arity$0 = (function (){
return taoensso.telemere.utils.format_error_fn.cljs$core$IFn$_invoke$arity$1(null);
}));

(taoensso.telemere.utils.format_error_fn.cljs$core$IFn$_invoke$arity$1 = (function (p__17031){
var map__17032 = p__17031;
var map__17032__$1 = cljs.core.__destructure_map(map__17032);
var _opts = map__17032__$1;
var nl = "\n";
var nls = taoensso.encore.newlines;
return (function taoensso$telemere$utils$format_error(error){
var temp__5804__auto__ = taoensso.truss.ex_map(error);
if(cljs.core.truth_(temp__5804__auto__)){
var em = temp__5804__auto__;
var sb = taoensso.encore.str_builder.cljs$core$IFn$_invoke$arity$0();
var s_PLUS_ = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(taoensso.encore.sb_append,sb);
var map__17033 = em;
var map__17033__$1 = cljs.core.__destructure_map(map__17033);
var chain = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17033__$1,new cljs.core.Keyword(null,"chain","chain",15631029));
var trace = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17033__$1,new cljs.core.Keyword(null,"trace","trace",-1082747415));
var s_PLUS_cause_17118 = taoensso.encore.sb_appender.cljs$core$IFn$_invoke$arity$2(sb,[nls,"Caused: "].join(''));
s_PLUS_("Root: ");

var seq__17034_17119 = cljs.core.seq(cljs.core.rseq(chain));
var chunk__17035_17120 = null;
var count__17036_17121 = (0);
var i__17037_17122 = (0);
while(true){
if((i__17037_17122 < count__17036_17121)){
var map__17040_17123 = chunk__17035_17120.cljs$core$IIndexed$_nth$arity$2(null,i__17037_17122);
var map__17040_17124__$1 = cljs.core.__destructure_map(map__17040_17123);
var type_17125 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17040_17124__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var msg_17126 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17040_17124__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
var data_17127 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17040_17124__$1,new cljs.core.Keyword(null,"data","data",-232669377));
s_PLUS_cause_17118(type_17125," - ",msg_17126);

if(cljs.core.truth_(data_17127)){
s_PLUS_(nl,"data: ",taoensso.encore.pr_edn_STAR_(data_17127));
} else {
}


var G__17128 = seq__17034_17119;
var G__17129 = chunk__17035_17120;
var G__17130 = count__17036_17121;
var G__17131 = (i__17037_17122 + (1));
seq__17034_17119 = G__17128;
chunk__17035_17120 = G__17129;
count__17036_17121 = G__17130;
i__17037_17122 = G__17131;
continue;
} else {
var temp__5804__auto___17132__$1 = cljs.core.seq(seq__17034_17119);
if(temp__5804__auto___17132__$1){
var seq__17034_17133__$1 = temp__5804__auto___17132__$1;
if(cljs.core.chunked_seq_QMARK_(seq__17034_17133__$1)){
var c__5525__auto___17134 = cljs.core.chunk_first(seq__17034_17133__$1);
var G__17135 = cljs.core.chunk_rest(seq__17034_17133__$1);
var G__17136 = c__5525__auto___17134;
var G__17137 = cljs.core.count(c__5525__auto___17134);
var G__17138 = (0);
seq__17034_17119 = G__17135;
chunk__17035_17120 = G__17136;
count__17036_17121 = G__17137;
i__17037_17122 = G__17138;
continue;
} else {
var map__17041_17139 = cljs.core.first(seq__17034_17133__$1);
var map__17041_17140__$1 = cljs.core.__destructure_map(map__17041_17139);
var type_17141 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17041_17140__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var msg_17142 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17041_17140__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
var data_17143 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17041_17140__$1,new cljs.core.Keyword(null,"data","data",-232669377));
s_PLUS_cause_17118(type_17141," - ",msg_17142);

if(cljs.core.truth_(data_17143)){
s_PLUS_(nl,"data: ",taoensso.encore.pr_edn_STAR_(data_17143));
} else {
}


var G__17145 = cljs.core.next(seq__17034_17133__$1);
var G__17146 = null;
var G__17147 = (0);
var G__17148 = (0);
seq__17034_17119 = G__17145;
chunk__17035_17120 = G__17146;
count__17036_17121 = G__17147;
i__17037_17122 = G__17148;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(trace)){
s_PLUS_(nl,nl,"Root stack trace:",nl);

s_PLUS_(trace);
} else {
}

return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb);
} else {
return null;
}
});
}));

(taoensso.telemere.utils.format_error_fn.cljs$lang$maxFixedArity = 1);

/**
 * Alpha, subject to change.
 *   Returns a (fn preamble [signal]) that:
 *  - Takes a Telemere signal (map).
 *  - Returns a signal preamble ?string like:
 *    "2024-03-26T11:14:51.806Z INFO EVENT Hostname taoensso.telemere[2,21] ::ev-id msg"
 * 
 *   Options:
 *  `:format-inst-fn` - (fn format [instant]) => string.
 *  `:format-id-fn` --- (fn format [ns id])   => string.
 *  `:format-msg-fn` -- (fn format [msg])     => string.
 */
taoensso.telemere.utils.signal_preamble_fn = (function taoensso$telemere$utils$signal_preamble_fn(var_args){
var G__17043 = arguments.length;
switch (G__17043) {
case 0:
return taoensso.telemere.utils.signal_preamble_fn.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.telemere.utils.signal_preamble_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(taoensso.telemere.utils.signal_preamble_fn.cljs$core$IFn$_invoke$arity$0 = (function (){
return taoensso.telemere.utils.signal_preamble_fn.cljs$core$IFn$_invoke$arity$1(null);
}));

(taoensso.telemere.utils.signal_preamble_fn.cljs$core$IFn$_invoke$arity$1 = (function (p__17044){
var map__17045 = p__17044;
var map__17045__$1 = cljs.core.__destructure_map(map__17045);
var format_inst_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__17045__$1,new cljs.core.Keyword(null,"format-inst-fn","format-inst-fn",518148350),(taoensso.telemere.utils.format_inst_fn.cljs$core$IFn$_invoke$arity$0 ? taoensso.telemere.utils.format_inst_fn.cljs$core$IFn$_invoke$arity$0() : taoensso.telemere.utils.format_inst_fn.call(null)));
var format_id_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__17045__$1,new cljs.core.Keyword(null,"format-id-fn","format-id-fn",513589829),taoensso.telemere.utils.format_id);
var format_msg_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__17045__$1,new cljs.core.Keyword(null,"format-msg-fn","format-msg-fn",-1387049398),cljs.core.identity);
return (function taoensso$telemere$utils$signal_preamble(signal){
var map__17046 = signal;
var map__17046__$1 = cljs.core.__destructure_map(map__17046);
var inst = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17046__$1,new cljs.core.Keyword(null,"inst","inst",645962501));
var level = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17046__$1,new cljs.core.Keyword(null,"level","level",1290497552));
var kind = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17046__$1,new cljs.core.Keyword(null,"kind","kind",-717265803));
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17046__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17046__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var msg_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17046__$1,new cljs.core.Keyword(null,"msg_","msg_",-1925147000));
var sb = taoensso.encore.str_builder.cljs$core$IFn$_invoke$arity$0();
var s_PLUS_spc = taoensso.encore.sb_appender.cljs$core$IFn$_invoke$arity$2(sb," ");
if(cljs.core.truth_(inst)){
var temp__5804__auto___17150 = format_inst_fn;
if(cljs.core.truth_(temp__5804__auto___17150)){
var ff_17151 = temp__5804__auto___17150;
s_PLUS_spc((ff_17151.cljs$core$IFn$_invoke$arity$1 ? ff_17151.cljs$core$IFn$_invoke$arity$1(inst) : ff_17151.call(null,inst)));
} else {
}
} else {
}

if(cljs.core.truth_(level)){
s_PLUS_spc((taoensso.telemere.utils.format_level.cljs$core$IFn$_invoke$arity$1 ? taoensso.telemere.utils.format_level.cljs$core$IFn$_invoke$arity$1(level) : taoensso.telemere.utils.format_level.call(null,level)));
} else {
}

if(cljs.core.truth_(kind)){
s_PLUS_spc((taoensso.encore.signals.upper_qn.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.signals.upper_qn.cljs$core$IFn$_invoke$arity$1(kind) : taoensso.encore.signals.upper_qn.call(null,kind)));
} else {
}

if(cljs.core.truth_(ns)){
s_PLUS_spc(taoensso.encore.signals.format_callsite.cljs$core$IFn$_invoke$arity$2(ns,cljs.core.get.cljs$core$IFn$_invoke$arity$2(signal,new cljs.core.Keyword(null,"coords","coords",-599429112))));
} else {
}

if(cljs.core.truth_(id)){
var temp__5804__auto___17153 = format_id_fn;
if(cljs.core.truth_(temp__5804__auto___17153)){
var ff_17154 = temp__5804__auto___17153;
s_PLUS_spc((ff_17154.cljs$core$IFn$_invoke$arity$2 ? ff_17154.cljs$core$IFn$_invoke$arity$2(ns,id) : ff_17154.call(null,ns,id)));
} else {
}
} else {
}

var b2__11384__auto___17155 = format_msg_fn;
if(cljs.core.truth_(b2__11384__auto___17155)){
var ff_17156 = b2__11384__auto___17155;
var b2__11384__auto___17157__$1 = cljs.core.force(msg_);
if(cljs.core.truth_(b2__11384__auto___17157__$1)){
var msg_17158 = b2__11384__auto___17157__$1;
s_PLUS_spc((ff_17156.cljs$core$IFn$_invoke$arity$1 ? ff_17156.cljs$core$IFn$_invoke$arity$1(msg_17158) : ff_17156.call(null,msg_17158)));
} else {
}
} else {
}

if((taoensso.encore.sb_length(sb) === (0))){
return null;
} else {
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb);
}
});
}));

(taoensso.telemere.utils.signal_preamble_fn.cljs$lang$maxFixedArity = 1);

taoensso.telemere.utils.format_parent = (function taoensso$telemere$utils$format_parent(ns,p__17047){
var map__17048 = p__17047;
var map__17048__$1 = cljs.core.__destructure_map(map__17048);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17048__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var uid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17048__$1,new cljs.core.Keyword(null,"uid","uid",-1447769400));
if(cljs.core.truth_(id)){
if(cljs.core.truth_(uid)){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id","id",-1388402092),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((taoensso.telemere.utils.format_id.cljs$core$IFn$_invoke$arity$2 ? taoensso.telemere.utils.format_id.cljs$core$IFn$_invoke$arity$2(ns,id) : taoensso.telemere.utils.format_id.call(null,ns,id))),new cljs.core.Keyword(null,"uid","uid",-1447769400),uid], null);
} else {
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"id","id",-1388402092),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((taoensso.telemere.utils.format_id.cljs$core$IFn$_invoke$arity$2 ? taoensso.telemere.utils.format_id.cljs$core$IFn$_invoke$arity$2(ns,id) : taoensso.telemere.utils.format_id.call(null,ns,id)))], null);
}
} else {
if(cljs.core.truth_(uid)){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"uid","uid",-1447769400),uid], null);
} else {
return null;
}
}
});
/**
 * Alpha, subject to change.
 *   Returns a (fn content [signal]) that:
 *  - Takes a Telemere signal (map).
 *  - Returns a human-readable signal content ?string (incl. data, ctx, etc.).
 * 
 *   Options:
 *  `:raw-error?` ------ Retain unformatted error? (default false)
 *  `:incl-keys` ------- Subset of signal keys to retain from those
 *                       otherwise excluded by default: #{:kvs :host :thread}
 *  `:format-nsecs-fn` - (fn [nanosecs]) => string.
 *  `:format-error-fn` - (fn [error])    => string.
 */
taoensso.telemere.utils.signal_content_fn = (function taoensso$telemere$utils$signal_content_fn(var_args){
var G__17050 = arguments.length;
switch (G__17050) {
case 0:
return taoensso.telemere.utils.signal_content_fn.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.telemere.utils.signal_content_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(taoensso.telemere.utils.signal_content_fn.cljs$core$IFn$_invoke$arity$0 = (function (){
return taoensso.telemere.utils.signal_content_fn.cljs$core$IFn$_invoke$arity$1(null);
}));

(taoensso.telemere.utils.signal_content_fn.cljs$core$IFn$_invoke$arity$1 = (function (p__17051){
var map__17052 = p__17051;
var map__17052__$1 = cljs.core.__destructure_map(map__17052);
var raw_error_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17052__$1,new cljs.core.Keyword(null,"raw-error?","raw-error?",-39485940));
var incl_keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17052__$1,new cljs.core.Keyword(null,"incl-keys","incl-keys",625658308));
var format_nsecs_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__17052__$1,new cljs.core.Keyword(null,"format-nsecs-fn","format-nsecs-fn",-1487810716),taoensso.telemere.utils.format_nsecs_fn.cljs$core$IFn$_invoke$arity$0());
var format_error_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__17052__$1,new cljs.core.Keyword(null,"format-error-fn","format-error-fn",-560488578),taoensso.telemere.utils.format_error_fn.cljs$core$IFn$_invoke$arity$0());
var nl = taoensso.telemere.utils.newline;
var err_start = [nl,"<<< error <<<",nl].join('');
var err_stop = [nl,">>> error >>>"].join('');
var incl_kvs_QMARK_ = cljs.core.contains_QMARK_(incl_keys,new cljs.core.Keyword(null,"kvs","kvs",958455492));
var incl_host_QMARK_ = cljs.core.contains_QMARK_(incl_keys,new cljs.core.Keyword(null,"host","host",-1558485167));
var incl_thread_QMARK_ = cljs.core.contains_QMARK_(incl_keys,new cljs.core.Keyword(null,"thread","thread",947001524));
return (function() {
var taoensso$telemere$utils$signal_content = null;
var taoensso$telemere$utils$signal_content__1 = (function (signal){
var sb = taoensso.encore.str_builder.cljs$core$IFn$_invoke$arity$0();
var s_PLUS__PLUS_ = taoensso.encore.sb_appender.cljs$core$IFn$_invoke$arity$2(sb,nl);
taoensso$telemere$utils$signal_content.cljs$core$IFn$_invoke$arity$3(signal,s_PLUS__PLUS_,taoensso.encore.pr_edn_STAR_);

if((taoensso.encore.sb_length(sb) === (0))){
return null;
} else {
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb);
}
});
var taoensso$telemere$utils$signal_content__3 = (function (signal,append_fn,val_fn){
var af = append_fn;
var vf = val_fn;
var map__17053_17167 = signal;
var map__17053_17168__$1 = cljs.core.__destructure_map(map__17053_17167);
var ns_17169 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17053_17168__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var uid_17170 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17053_17168__$1,new cljs.core.Keyword(null,"uid","uid",-1447769400));
var parent_17171 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17053_17168__$1,new cljs.core.Keyword(null,"parent","parent",-878878779));
var root_17172 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17053_17168__$1,new cljs.core.Keyword(null,"root","root",-448657453));
var data_17173 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17053_17168__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var kvs_17174 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17053_17168__$1,new cljs.core.Keyword(null,"kvs","kvs",958455492));
var ctx_17175 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17053_17168__$1,new cljs.core.Keyword(null,"ctx","ctx",-493610118));
var sample_17176 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17053_17168__$1,new cljs.core.Keyword(null,"sample","sample",79023601));
if(cljs.core.truth_(sample_17176)){
var G__17054_17177 = " sample: ";
var G__17055_17178 = (vf.cljs$core$IFn$_invoke$arity$1 ? vf.cljs$core$IFn$_invoke$arity$1(sample_17176) : vf.call(null,sample_17176));
(af.cljs$core$IFn$_invoke$arity$2 ? af.cljs$core$IFn$_invoke$arity$2(G__17054_17177,G__17055_17178) : af.call(null,G__17054_17177,G__17055_17178));
} else {
}

if(cljs.core.truth_(uid_17170)){
var G__17056_17179 = "    uid: ";
var G__17057_17180 = (vf.cljs$core$IFn$_invoke$arity$1 ? vf.cljs$core$IFn$_invoke$arity$1(uid_17170) : vf.call(null,uid_17170));
(af.cljs$core$IFn$_invoke$arity$2 ? af.cljs$core$IFn$_invoke$arity$2(G__17056_17179,G__17057_17180) : af.call(null,G__17056_17179,G__17057_17180));
} else {
}

if(cljs.core.truth_((function (){var and__5000__auto__ = parent_17171;
if(cljs.core.truth_(and__5000__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(parent_17171,root_17172);
} else {
return and__5000__auto__;
}
})())){
var G__17058_17181 = " parent: ";
var G__17059_17182 = (function (){var G__17060 = taoensso.telemere.utils.format_parent(ns_17169,parent_17171);
return (vf.cljs$core$IFn$_invoke$arity$1 ? vf.cljs$core$IFn$_invoke$arity$1(G__17060) : vf.call(null,G__17060));
})();
(af.cljs$core$IFn$_invoke$arity$2 ? af.cljs$core$IFn$_invoke$arity$2(G__17058_17181,G__17059_17182) : af.call(null,G__17058_17181,G__17059_17182));
} else {
}

if(cljs.core.truth_(root_17172)){
var G__17061_17183 = "   root: ";
var G__17062_17184 = (function (){var G__17063 = taoensso.telemere.utils.format_parent(ns_17169,root_17172);
return (vf.cljs$core$IFn$_invoke$arity$1 ? vf.cljs$core$IFn$_invoke$arity$1(G__17063) : vf.call(null,G__17063));
})();
(af.cljs$core$IFn$_invoke$arity$2 ? af.cljs$core$IFn$_invoke$arity$2(G__17061_17183,G__17062_17184) : af.call(null,G__17061_17183,G__17062_17184));
} else {
}

if(cljs.core.truth_(taoensso.encore.not_empty_coll(data_17173))){
var G__17064_17185 = "   data: ";
var G__17065_17186 = (vf.cljs$core$IFn$_invoke$arity$1 ? vf.cljs$core$IFn$_invoke$arity$1(data_17173) : vf.call(null,data_17173));
(af.cljs$core$IFn$_invoke$arity$2 ? af.cljs$core$IFn$_invoke$arity$2(G__17064_17185,G__17065_17186) : af.call(null,G__17064_17185,G__17065_17186));
} else {
}

if(cljs.core.truth_(taoensso.encore.not_empty_coll(ctx_17175))){
var G__17066_17187 = "    ctx: ";
var G__17067_17188 = (vf.cljs$core$IFn$_invoke$arity$1 ? vf.cljs$core$IFn$_invoke$arity$1(ctx_17175) : vf.call(null,ctx_17175));
(af.cljs$core$IFn$_invoke$arity$2 ? af.cljs$core$IFn$_invoke$arity$2(G__17066_17187,G__17067_17188) : af.call(null,G__17066_17187,G__17067_17188));
} else {
}

if((cljs.core.truth_(kvs_17174)?incl_kvs_QMARK_:false)){
var G__17068_17189 = "    kvs: ";
var G__17069_17190 = (vf.cljs$core$IFn$_invoke$arity$1 ? vf.cljs$core$IFn$_invoke$arity$1(kvs_17174) : vf.call(null,kvs_17174));
(af.cljs$core$IFn$_invoke$arity$2 ? af.cljs$core$IFn$_invoke$arity$2(G__17068_17189,G__17069_17190) : af.call(null,G__17068_17189,G__17069_17190));
} else {
}

var map__17070 = signal;
var map__17070__$1 = cljs.core.__destructure_map(map__17070);
var run_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17070__$1,new cljs.core.Keyword(null,"run-form","run-form",405647397));
var error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17070__$1,new cljs.core.Keyword(null,"error","error",-978969032));
if(cljs.core.truth_(run_form)){
var map__17071_17191 = signal;
var map__17071_17192__$1 = cljs.core.__destructure_map(map__17071_17191);
var run_val_17193 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17071_17192__$1,new cljs.core.Keyword(null,"run-val","run-val",-304326520));
var run_nsecs_17194 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17071_17192__$1,new cljs.core.Keyword(null,"run-nsecs","run-nsecs",32621724));
var run_time_17195 = (cljs.core.truth_(run_nsecs_17194)?(function (){var temp__5804__auto__ = format_nsecs_fn;
if(cljs.core.truth_(temp__5804__auto__)){
var ff = temp__5804__auto__;
return (ff.cljs$core$IFn$_invoke$arity$1 ? ff.cljs$core$IFn$_invoke$arity$1(run_nsecs_17194) : ff.call(null,run_nsecs_17194));
} else {
return null;
}
})():null);
var run_info_17196 = (cljs.core.truth_(error)?new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"form","form",-1624062471),run_form,new cljs.core.Keyword(null,"time","time",1385887882),run_time_17195,new cljs.core.Keyword(null,"nsecs","nsecs",1510077757),run_nsecs_17194], null):new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"form","form",-1624062471),run_form,new cljs.core.Keyword(null,"time","time",1385887882),run_time_17195,new cljs.core.Keyword(null,"nsecs","nsecs",1510077757),run_nsecs_17194,new cljs.core.Keyword(null,"val","val",128701612),run_val_17193], null));
var G__17072_17199 = "    run: ";
var G__17073_17200 = (vf.cljs$core$IFn$_invoke$arity$1 ? vf.cljs$core$IFn$_invoke$arity$1(run_info_17196) : vf.call(null,run_info_17196));
(af.cljs$core$IFn$_invoke$arity$2 ? af.cljs$core$IFn$_invoke$arity$2(G__17072_17199,G__17073_17200) : af.call(null,G__17072_17199,G__17073_17200));
} else {
}

if(cljs.core.truth_(error)){
if(cljs.core.truth_(raw_error_QMARK_)){
return (af.cljs$core$IFn$_invoke$arity$2 ? af.cljs$core$IFn$_invoke$arity$2("  error: ",error) : af.call(null,"  error: ",error));
} else {
var temp__5804__auto__ = format_error_fn;
if(cljs.core.truth_(temp__5804__auto__)){
var ff = temp__5804__auto__;
var G__17074 = err_start;
var G__17075 = (ff.cljs$core$IFn$_invoke$arity$1 ? ff.cljs$core$IFn$_invoke$arity$1(error) : ff.call(null,error));
var G__17076 = err_stop;
return (af.cljs$core$IFn$_invoke$arity$3 ? af.cljs$core$IFn$_invoke$arity$3(G__17074,G__17075,G__17076) : af.call(null,G__17074,G__17075,G__17076));
} else {
return null;
}
}
} else {
return null;
}
});
taoensso$telemere$utils$signal_content = function(signal,append_fn,val_fn){
switch(arguments.length){
case 1:
return taoensso$telemere$utils$signal_content__1.call(this,signal);
case 3:
return taoensso$telemere$utils$signal_content__3.call(this,signal,append_fn,val_fn);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$telemere$utils$signal_content.cljs$core$IFn$_invoke$arity$1 = taoensso$telemere$utils$signal_content__1;
taoensso$telemere$utils$signal_content.cljs$core$IFn$_invoke$arity$3 = taoensso$telemere$utils$signal_content__3;
return taoensso$telemere$utils$signal_content;
})()
}));

(taoensso.telemere.utils.signal_content_fn.cljs$lang$maxFixedArity = 1);

/**
 * Alpha, subject to change.
 *   Returns a (fn clean [signal]) that:
 *  - Takes a Telemere  signal (map).
 *  - Returns a minimal signal (map) ready for printing, etc.
 * 
 *   Signals are optimized for cheap creation and easy handling, so tend to be
 *   verbose and may contain things like nil values and duplicated content.
 * 
 *   This util efficiently cleans signals of such noise, helping reduce
 *   storage/transmission size, and making key info easier to see.
 * 
 *   Options:
 *  `:incl-nils?` - Include signal's keys with nil values? (default false)
 *  `:incl-kvs?` -- Include signal's app-level root kvs?   (default false)
 *  `:incl-keys` -- Subset of signal keys to retain from those otherwise
 *                  excluded by default: #{:schema :kvs :host :thread}
 */
taoensso.telemere.utils.clean_signal_fn = (function taoensso$telemere$utils$clean_signal_fn(var_args){
var G__17078 = arguments.length;
switch (G__17078) {
case 0:
return taoensso.telemere.utils.clean_signal_fn.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.telemere.utils.clean_signal_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(taoensso.telemere.utils.clean_signal_fn.cljs$core$IFn$_invoke$arity$0 = (function (){
return taoensso.telemere.utils.clean_signal_fn.cljs$core$IFn$_invoke$arity$1(null);
}));

(taoensso.telemere.utils.clean_signal_fn.cljs$core$IFn$_invoke$arity$1 = (function (p__17079){
var map__17080 = p__17079;
var map__17080__$1 = cljs.core.__destructure_map(map__17080);
var opts = map__17080__$1;
var incl_kvs_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17080__$1,new cljs.core.Keyword(null,"incl-kvs?","incl-kvs?",1936239040));
var incl_nils_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17080__$1,new cljs.core.Keyword(null,"incl-nils?","incl-nils?",-1704506526));
var incl_keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17080__$1,new cljs.core.Keyword(null,"incl-keys","incl-keys",625658308));
var assoc_BANG__STAR_ = ((cljs.core.not(incl_nils_QMARK_))?(function (m,k,v){
if((v == null)){
return m;
} else {
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
}):cljs.core.assoc_BANG_);
var incl_schema_QMARK_ = cljs.core.contains_QMARK_(incl_keys,new cljs.core.Keyword(null,"schema","schema",-1582001791));
var incl_kvs_key_QMARK_ = cljs.core.contains_QMARK_(incl_keys,new cljs.core.Keyword(null,"kvs","kvs",958455492));
var incl_host_QMARK_ = cljs.core.contains_QMARK_(incl_keys,new cljs.core.Keyword(null,"host","host",-1558485167));
var incl_thread_QMARK_ = cljs.core.contains_QMARK_(incl_keys,new cljs.core.Keyword(null,"thread","thread",947001524));
return (function taoensso$telemere$utils$clean_signal(signal){
if(cljs.core.map_QMARK_(signal)){
return cljs.core.persistent_BANG_(cljs.core.reduce_kv((function (m,k,v){
var G__17085 = k;
var G__17085__$1 = (((G__17085 instanceof cljs.core.Keyword))?G__17085.fqn:null);
switch (G__17085__$1) {
case "data":
case "run-nsecs":
case "ctx":
case "kind":
case "id":
case "root":
case "sample":
case "level":
case "ns":
case "uid":
case "run-val":
case "coords":
case "parent":
case "inst":
case "run-form":
case "end-inst":
return (assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3 ? assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3(m,k,v) : assoc_BANG__STAR_.call(null,m,k,v));

break;
case "error":
var temp__5802__auto__ = taoensso.truss.ex_chain.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"as-map","as-map",633645847),v);
if(cljs.core.truth_(temp__5802__auto__)){
var chain = temp__5802__auto__;
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(m,k,chain);
} else {
return m;
}

break;
case "msg_":
var G__17086 = m;
var G__17087 = k;
var G__17088 = cljs.core.force(v);
return (assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3 ? assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3(G__17086,G__17087,G__17088) : assoc_BANG__STAR_.call(null,G__17086,G__17087,G__17088));

break;
case "_otel-context":
return m;

break;
case "schema":
if(incl_schema_QMARK_){
return (assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3 ? assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3(m,k,v) : assoc_BANG__STAR_.call(null,m,k,v));
} else {
return m;
}

break;
case "kvs":
if(incl_kvs_key_QMARK_){
return (assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3 ? assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3(m,k,v) : assoc_BANG__STAR_.call(null,m,k,v));
} else {
return m;
}

break;
case "thread":
if(incl_thread_QMARK_){
return (assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3 ? assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3(m,k,v) : assoc_BANG__STAR_.call(null,m,k,v));
} else {
return m;
}

break;
case "host":
if(incl_host_QMARK_){
return (assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3 ? assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3(m,k,v) : assoc_BANG__STAR_.call(null,m,k,v));
} else {
return m;
}

break;
default:
if(cljs.core.truth_(incl_kvs_QMARK_)){
return (assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3 ? assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3(m,k,v) : assoc_BANG__STAR_.call(null,m,k,v));
} else {
if(cljs.core.contains_QMARK_(incl_keys,k)){
return (assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3 ? assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3(m,k,v) : assoc_BANG__STAR_.call(null,m,k,v));
} else {
return m;
}
}

}
}),cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),signal));
} else {
return null;
}
});
}));

(taoensso.telemere.utils.clean_signal_fn.cljs$lang$maxFixedArity = 1);

/**
 * Alpha, subject to change.
 *   Returns a (fn pr [signal]) that:
 *  - Takes a Telemere signal (map).
 *  - Returns a machine-readable signal string.
 * 
 *   Options:
 *  `:pr-fn` --------- ∈ #{<unary-fn> :edn (default) :json (Cljs only)}
 *  `:clean-fn` ------ (fn [signal]) => clean signal map, see [1]
 *  `:incl-newline?` - Include terminating system newline? (default true)
 * 
 *   Examples:
 * 
 *  ;; To print as edn:
 *  (pr-signal-fn {:pr-fn :edn})
 * 
 *  ;; To print as JSON:
 *  ;; Ref.  <https://github.com/metosin/jsonista> (or any alt JSON lib)
 *  #?(:clj (require '[jsonista.core :as jsonista]))
 *  (pr-signal-fn
 *    {:pr-fn
 *      #?(:cljs :json ; Use js/JSON.stringify
 *         :clj  jsonista/write-value-as-string)})
 * 
 *   [1] `taoensso.telemere.utils/clean-signal-fn`, etc.
 * 
 *   See also `format-signal-fn` for an alternative to `pr-signal-fn`
 *   that produces human-readable output.
 */
taoensso.telemere.utils.pr_signal_fn = (function taoensso$telemere$utils$pr_signal_fn(var_args){
var G__17090 = arguments.length;
switch (G__17090) {
case 0:
return taoensso.telemere.utils.pr_signal_fn.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.telemere.utils.pr_signal_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(taoensso.telemere.utils.pr_signal_fn.cljs$core$IFn$_invoke$arity$0 = (function (){
return taoensso.telemere.utils.pr_signal_fn.cljs$core$IFn$_invoke$arity$1(null);
}));

(taoensso.telemere.utils.pr_signal_fn.cljs$core$IFn$_invoke$arity$1 = (function (p__17091){
var map__17092 = p__17091;
var map__17092__$1 = cljs.core.__destructure_map(map__17092);
var opts = map__17092__$1;
var pr_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__17092__$1,new cljs.core.Keyword(null,"pr-fn","pr-fn",2001500794),new cljs.core.Keyword(null,"edn","edn",1317840885));
var clean_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__17092__$1,new cljs.core.Keyword(null,"clean-fn","clean-fn",-1262646726),taoensso.telemere.utils.clean_signal_fn.cljs$core$IFn$_invoke$arity$0());
var incl_newline_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__17092__$1,new cljs.core.Keyword(null,"incl-newline?","incl-newline?",1384416974),true);
var nl = taoensso.telemere.utils.newline;
var pr_fn__$1 = (function (){var G__17093 = pr_fn;
var G__17093__$1 = (((G__17093 instanceof cljs.core.Keyword))?G__17093.fqn:null);
switch (G__17093__$1) {
case "edn":
return taoensso.telemere.utils.pr_edn;

break;
case "json":
return taoensso.telemere.utils.pr_json;

break;
default:
if(cljs.core.fn_QMARK_(pr_fn)){
return pr_fn;
} else {
return taoensso.truss.unexpected_arg_BANG__STAR_("taoensso.telemere.utils",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [762,16], null),pr_fn,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"param","param",2013631823),new cljs.core.Symbol(null,"pr-fn","pr-fn",-652934975,null),new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Symbol("taoensso.telemere.utils","pr-signal-fn","taoensso.telemere.utils/pr-signal-fn",-829484633,null),new cljs.core.Keyword(null,"expected","expected",1583670997),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Symbol(null,"unary-fn","unary-fn",1332940686,null),"null",new cljs.core.Keyword(null,"edn","edn",1317840885),"null",new cljs.core.Keyword(null,"json","json",1279968570),"null"], null), null)], null));
}

}
})();
return (function taoensso$telemere$utils$pr_signal(signal){
if(cljs.core.map_QMARK_(signal)){
if(cljs.core.truth_(incl_newline_QMARK_)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__17095 = (clean_fn.cljs$core$IFn$_invoke$arity$1 ? clean_fn.cljs$core$IFn$_invoke$arity$1(signal) : clean_fn.call(null,signal));
return (pr_fn__$1.cljs$core$IFn$_invoke$arity$1 ? pr_fn__$1.cljs$core$IFn$_invoke$arity$1(G__17095) : pr_fn__$1.call(null,G__17095));
})()),nl].join('');
} else {
var G__17096 = (clean_fn.cljs$core$IFn$_invoke$arity$1 ? clean_fn.cljs$core$IFn$_invoke$arity$1(signal) : clean_fn.call(null,signal));
return (pr_fn__$1.cljs$core$IFn$_invoke$arity$1 ? pr_fn__$1.cljs$core$IFn$_invoke$arity$1(G__17096) : pr_fn__$1.call(null,G__17096));
}
} else {
return null;
}
});
}));

(taoensso.telemere.utils.pr_signal_fn.cljs$lang$maxFixedArity = 1);

/**
 * Alpha, subject to change.
 *   Returns a (fn format [signal]) that:
 *  - Takes a Telemere signal (map).
 *  - Returns a human-readable signal string.
 * 
 *   Options:
 *  `:incl-newline?` - Include terminating system newline? (default true)
 *  `:preamble-fn` --- (fn [signal]) => signal preamble string, see [1]
 *  `:content-fn` ---- (fn [signal]) => signal content  string, see [2]
 * 
 *   [1] `taoensso.telemere.utils/signal-preamble-fn`, etc.
 *   [2] `taoensso.telemere.utils/signal-content-fn`,  etc.
 * 
 *   See also `pr-signal-fn` for an alternative to `format-signal-fn`
 *   that produces machine-readable output (edn, JSON, etc.).
 */
taoensso.telemere.utils.format_signal_fn = (function taoensso$telemere$utils$format_signal_fn(var_args){
var G__17098 = arguments.length;
switch (G__17098) {
case 0:
return taoensso.telemere.utils.format_signal_fn.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.telemere.utils.format_signal_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(taoensso.telemere.utils.format_signal_fn.cljs$core$IFn$_invoke$arity$0 = (function (){
return taoensso.telemere.utils.format_signal_fn.cljs$core$IFn$_invoke$arity$1(null);
}));

(taoensso.telemere.utils.format_signal_fn.cljs$core$IFn$_invoke$arity$1 = (function (p__17099){
var map__17100 = p__17099;
var map__17100__$1 = cljs.core.__destructure_map(map__17100);
var incl_newline_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__17100__$1,new cljs.core.Keyword(null,"incl-newline?","incl-newline?",1384416974),true);
var preamble_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__17100__$1,new cljs.core.Keyword(null,"preamble-fn","preamble-fn",-900320209),taoensso.telemere.utils.signal_preamble_fn.cljs$core$IFn$_invoke$arity$0());
var content_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__17100__$1,new cljs.core.Keyword(null,"content-fn","content-fn",-1280686114),taoensso.telemere.utils.signal_content_fn.cljs$core$IFn$_invoke$arity$0());
var nl = taoensso.telemere.utils.newline;
return (function taoensso$telemere$utils$format_signal(signal){
var preamble = (cljs.core.truth_(preamble_fn)?(preamble_fn.cljs$core$IFn$_invoke$arity$1 ? preamble_fn.cljs$core$IFn$_invoke$arity$1(signal) : preamble_fn.call(null,signal)):null);
var content = (cljs.core.truth_(content_fn)?(content_fn.cljs$core$IFn$_invoke$arity$1 ? content_fn.cljs$core$IFn$_invoke$arity$1(signal) : content_fn.call(null,signal)):null);
if(cljs.core.truth_((function (){var and__5000__auto__ = preamble;
if(cljs.core.truth_(and__5000__auto__)){
return content;
} else {
return and__5000__auto__;
}
})())){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(preamble),nl,cljs.core.str.cljs$core$IFn$_invoke$arity$1(content),(cljs.core.truth_(incl_newline_QMARK_)?nl:null)].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(preamble),cljs.core.str.cljs$core$IFn$_invoke$arity$1(content),(cljs.core.truth_(incl_newline_QMARK_)?nl:null)].join('');
}
});
}));

(taoensso.telemere.utils.format_signal_fn.cljs$lang$maxFixedArity = 1);


//# sourceMappingURL=taoensso.telemere.utils.js.map
