goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = true;

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_12929 = (function (this$){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (shadow.dom._to_dom[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5351__auto__.call(null,this$));
} else {
var m__5349__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5349__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_12929(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_12935 = (function (this$){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (shadow.dom._to_svg[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5351__auto__.call(null,this$));
} else {
var m__5349__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5349__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_12935(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__11744 = coll;
var G__11745 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__11744,G__11745) : shadow.dom.lazy_native_coll_seq.call(null,G__11744,G__11745));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__5002__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__11759 = arguments.length;
switch (G__11759) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__11761 = arguments.length;
switch (G__11761) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__11763 = arguments.length;
switch (G__11763) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__11783 = arguments.length;
switch (G__11783) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__11787 = arguments.length;
switch (G__11787) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__11791 = arguments.length;
switch (G__11791) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__5002__auto__ = (!((typeof document !== 'undefined')));
if(or__5002__auto__){
return or__5002__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e11833){if((e11833 instanceof Object)){
var e = e11833;
return console.log("didnt support attachEvent",el,e);
} else {
throw e11833;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__5002__auto__ = (!((typeof document !== 'undefined')));
if(or__5002__auto__){
return or__5002__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__11840 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__11841 = null;
var count__11842 = (0);
var i__11843 = (0);
while(true){
if((i__11843 < count__11842)){
var el = chunk__11841.cljs$core$IIndexed$_nth$arity$2(null,i__11843);
var handler_12984__$1 = ((function (seq__11840,chunk__11841,count__11842,i__11843,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__11840,chunk__11841,count__11842,i__11843,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_12984__$1);


var G__12985 = seq__11840;
var G__12986 = chunk__11841;
var G__12987 = count__11842;
var G__12988 = (i__11843 + (1));
seq__11840 = G__12985;
chunk__11841 = G__12986;
count__11842 = G__12987;
i__11843 = G__12988;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__11840);
if(temp__5804__auto__){
var seq__11840__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11840__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__11840__$1);
var G__12989 = cljs.core.chunk_rest(seq__11840__$1);
var G__12990 = c__5525__auto__;
var G__12991 = cljs.core.count(c__5525__auto__);
var G__12992 = (0);
seq__11840 = G__12989;
chunk__11841 = G__12990;
count__11842 = G__12991;
i__11843 = G__12992;
continue;
} else {
var el = cljs.core.first(seq__11840__$1);
var handler_12994__$1 = ((function (seq__11840,chunk__11841,count__11842,i__11843,el,seq__11840__$1,temp__5804__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__11840,chunk__11841,count__11842,i__11843,el,seq__11840__$1,temp__5804__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_12994__$1);


var G__12999 = cljs.core.next(seq__11840__$1);
var G__13000 = null;
var G__13001 = (0);
var G__13002 = (0);
seq__11840 = G__12999;
chunk__11841 = G__13000;
count__11842 = G__13001;
i__11843 = G__13002;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__11863 = arguments.length;
switch (G__11863) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__11866 = cljs.core.seq(events);
var chunk__11867 = null;
var count__11868 = (0);
var i__11869 = (0);
while(true){
if((i__11869 < count__11868)){
var vec__11876 = chunk__11867.cljs$core$IIndexed$_nth$arity$2(null,i__11869);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11876,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11876,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__13013 = seq__11866;
var G__13014 = chunk__11867;
var G__13015 = count__11868;
var G__13016 = (i__11869 + (1));
seq__11866 = G__13013;
chunk__11867 = G__13014;
count__11868 = G__13015;
i__11869 = G__13016;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__11866);
if(temp__5804__auto__){
var seq__11866__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11866__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__11866__$1);
var G__13018 = cljs.core.chunk_rest(seq__11866__$1);
var G__13019 = c__5525__auto__;
var G__13020 = cljs.core.count(c__5525__auto__);
var G__13021 = (0);
seq__11866 = G__13018;
chunk__11867 = G__13019;
count__11868 = G__13020;
i__11869 = G__13021;
continue;
} else {
var vec__11907 = cljs.core.first(seq__11866__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11907,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11907,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__13022 = cljs.core.next(seq__11866__$1);
var G__13023 = null;
var G__13024 = (0);
var G__13025 = (0);
seq__11866 = G__13022;
chunk__11867 = G__13023;
count__11868 = G__13024;
i__11869 = G__13025;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__11910 = cljs.core.seq(styles);
var chunk__11911 = null;
var count__11912 = (0);
var i__11913 = (0);
while(true){
if((i__11913 < count__11912)){
var vec__11920 = chunk__11911.cljs$core$IIndexed$_nth$arity$2(null,i__11913);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11920,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11920,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__13032 = seq__11910;
var G__13033 = chunk__11911;
var G__13034 = count__11912;
var G__13035 = (i__11913 + (1));
seq__11910 = G__13032;
chunk__11911 = G__13033;
count__11912 = G__13034;
i__11913 = G__13035;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__11910);
if(temp__5804__auto__){
var seq__11910__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11910__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__11910__$1);
var G__13036 = cljs.core.chunk_rest(seq__11910__$1);
var G__13037 = c__5525__auto__;
var G__13038 = cljs.core.count(c__5525__auto__);
var G__13039 = (0);
seq__11910 = G__13036;
chunk__11911 = G__13037;
count__11912 = G__13038;
i__11913 = G__13039;
continue;
} else {
var vec__11923 = cljs.core.first(seq__11910__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11923,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11923,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__13043 = cljs.core.next(seq__11910__$1);
var G__13044 = null;
var G__13045 = (0);
var G__13046 = (0);
seq__11910 = G__13043;
chunk__11911 = G__13044;
count__11912 = G__13045;
i__11913 = G__13046;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__11926_13047 = key;
var G__11926_13048__$1 = (((G__11926_13047 instanceof cljs.core.Keyword))?G__11926_13047.fqn:null);
switch (G__11926_13048__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_13058 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__5002__auto__ = goog.string.startsWith(ks_13058,"data-");
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return goog.string.startsWith(ks_13058,"aria-");
}
})())){
el.setAttribute(ks_13058,value);
} else {
(el[ks_13058] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__11932){
var map__11933 = p__11932;
var map__11933__$1 = cljs.core.__destructure_map(map__11933);
var props = map__11933__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11933__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__11936 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11936,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11936,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11936,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__11941 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__11941,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__11941;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__11944 = arguments.length;
switch (G__11944) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5804__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5804__auto__)){
var n = temp__5804__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5804__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5804__auto__)){
var n = temp__5804__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__11954){
var vec__11955 = p__11954;
var seq__11956 = cljs.core.seq(vec__11955);
var first__11957 = cljs.core.first(seq__11956);
var seq__11956__$1 = cljs.core.next(seq__11956);
var nn = first__11957;
var first__11957__$1 = cljs.core.first(seq__11956__$1);
var seq__11956__$2 = cljs.core.next(seq__11956__$1);
var np = first__11957__$1;
var nc = seq__11956__$2;
var node = vec__11955;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__11959 = nn;
var G__11960 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__11959,G__11960) : create_fn.call(null,G__11959,G__11960));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__11961 = nn;
var G__11962 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__11961,G__11962) : create_fn.call(null,G__11961,G__11962));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__11964 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11964,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11964,(1),null);
var seq__11967_13117 = cljs.core.seq(node_children);
var chunk__11968_13118 = null;
var count__11969_13119 = (0);
var i__11970_13120 = (0);
while(true){
if((i__11970_13120 < count__11969_13119)){
var child_struct_13122 = chunk__11968_13118.cljs$core$IIndexed$_nth$arity$2(null,i__11970_13120);
var children_13123 = shadow.dom.dom_node(child_struct_13122);
if(cljs.core.seq_QMARK_(children_13123)){
var seq__12018_13124 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_13123));
var chunk__12020_13125 = null;
var count__12021_13126 = (0);
var i__12022_13127 = (0);
while(true){
if((i__12022_13127 < count__12021_13126)){
var child_13130 = chunk__12020_13125.cljs$core$IIndexed$_nth$arity$2(null,i__12022_13127);
if(cljs.core.truth_(child_13130)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_13130);


var G__13133 = seq__12018_13124;
var G__13134 = chunk__12020_13125;
var G__13135 = count__12021_13126;
var G__13136 = (i__12022_13127 + (1));
seq__12018_13124 = G__13133;
chunk__12020_13125 = G__13134;
count__12021_13126 = G__13135;
i__12022_13127 = G__13136;
continue;
} else {
var G__13138 = seq__12018_13124;
var G__13139 = chunk__12020_13125;
var G__13140 = count__12021_13126;
var G__13141 = (i__12022_13127 + (1));
seq__12018_13124 = G__13138;
chunk__12020_13125 = G__13139;
count__12021_13126 = G__13140;
i__12022_13127 = G__13141;
continue;
}
} else {
var temp__5804__auto___13143 = cljs.core.seq(seq__12018_13124);
if(temp__5804__auto___13143){
var seq__12018_13145__$1 = temp__5804__auto___13143;
if(cljs.core.chunked_seq_QMARK_(seq__12018_13145__$1)){
var c__5525__auto___13146 = cljs.core.chunk_first(seq__12018_13145__$1);
var G__13147 = cljs.core.chunk_rest(seq__12018_13145__$1);
var G__13148 = c__5525__auto___13146;
var G__13149 = cljs.core.count(c__5525__auto___13146);
var G__13150 = (0);
seq__12018_13124 = G__13147;
chunk__12020_13125 = G__13148;
count__12021_13126 = G__13149;
i__12022_13127 = G__13150;
continue;
} else {
var child_13151 = cljs.core.first(seq__12018_13145__$1);
if(cljs.core.truth_(child_13151)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_13151);


var G__13152 = cljs.core.next(seq__12018_13145__$1);
var G__13153 = null;
var G__13154 = (0);
var G__13155 = (0);
seq__12018_13124 = G__13152;
chunk__12020_13125 = G__13153;
count__12021_13126 = G__13154;
i__12022_13127 = G__13155;
continue;
} else {
var G__13156 = cljs.core.next(seq__12018_13145__$1);
var G__13157 = null;
var G__13158 = (0);
var G__13159 = (0);
seq__12018_13124 = G__13156;
chunk__12020_13125 = G__13157;
count__12021_13126 = G__13158;
i__12022_13127 = G__13159;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_13123);
}


var G__13161 = seq__11967_13117;
var G__13162 = chunk__11968_13118;
var G__13163 = count__11969_13119;
var G__13164 = (i__11970_13120 + (1));
seq__11967_13117 = G__13161;
chunk__11968_13118 = G__13162;
count__11969_13119 = G__13163;
i__11970_13120 = G__13164;
continue;
} else {
var temp__5804__auto___13166 = cljs.core.seq(seq__11967_13117);
if(temp__5804__auto___13166){
var seq__11967_13167__$1 = temp__5804__auto___13166;
if(cljs.core.chunked_seq_QMARK_(seq__11967_13167__$1)){
var c__5525__auto___13168 = cljs.core.chunk_first(seq__11967_13167__$1);
var G__13170 = cljs.core.chunk_rest(seq__11967_13167__$1);
var G__13171 = c__5525__auto___13168;
var G__13172 = cljs.core.count(c__5525__auto___13168);
var G__13173 = (0);
seq__11967_13117 = G__13170;
chunk__11968_13118 = G__13171;
count__11969_13119 = G__13172;
i__11970_13120 = G__13173;
continue;
} else {
var child_struct_13174 = cljs.core.first(seq__11967_13167__$1);
var children_13175 = shadow.dom.dom_node(child_struct_13174);
if(cljs.core.seq_QMARK_(children_13175)){
var seq__12055_13176 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_13175));
var chunk__12057_13177 = null;
var count__12058_13178 = (0);
var i__12059_13179 = (0);
while(true){
if((i__12059_13179 < count__12058_13178)){
var child_13180 = chunk__12057_13177.cljs$core$IIndexed$_nth$arity$2(null,i__12059_13179);
if(cljs.core.truth_(child_13180)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_13180);


var G__13181 = seq__12055_13176;
var G__13182 = chunk__12057_13177;
var G__13183 = count__12058_13178;
var G__13184 = (i__12059_13179 + (1));
seq__12055_13176 = G__13181;
chunk__12057_13177 = G__13182;
count__12058_13178 = G__13183;
i__12059_13179 = G__13184;
continue;
} else {
var G__13185 = seq__12055_13176;
var G__13186 = chunk__12057_13177;
var G__13187 = count__12058_13178;
var G__13188 = (i__12059_13179 + (1));
seq__12055_13176 = G__13185;
chunk__12057_13177 = G__13186;
count__12058_13178 = G__13187;
i__12059_13179 = G__13188;
continue;
}
} else {
var temp__5804__auto___13189__$1 = cljs.core.seq(seq__12055_13176);
if(temp__5804__auto___13189__$1){
var seq__12055_13190__$1 = temp__5804__auto___13189__$1;
if(cljs.core.chunked_seq_QMARK_(seq__12055_13190__$1)){
var c__5525__auto___13191 = cljs.core.chunk_first(seq__12055_13190__$1);
var G__13194 = cljs.core.chunk_rest(seq__12055_13190__$1);
var G__13195 = c__5525__auto___13191;
var G__13196 = cljs.core.count(c__5525__auto___13191);
var G__13197 = (0);
seq__12055_13176 = G__13194;
chunk__12057_13177 = G__13195;
count__12058_13178 = G__13196;
i__12059_13179 = G__13197;
continue;
} else {
var child_13198 = cljs.core.first(seq__12055_13190__$1);
if(cljs.core.truth_(child_13198)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_13198);


var G__13200 = cljs.core.next(seq__12055_13190__$1);
var G__13201 = null;
var G__13202 = (0);
var G__13203 = (0);
seq__12055_13176 = G__13200;
chunk__12057_13177 = G__13201;
count__12058_13178 = G__13202;
i__12059_13179 = G__13203;
continue;
} else {
var G__13204 = cljs.core.next(seq__12055_13190__$1);
var G__13205 = null;
var G__13206 = (0);
var G__13207 = (0);
seq__12055_13176 = G__13204;
chunk__12057_13177 = G__13205;
count__12058_13178 = G__13206;
i__12059_13179 = G__13207;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_13175);
}


var G__13210 = cljs.core.next(seq__11967_13167__$1);
var G__13211 = null;
var G__13212 = (0);
var G__13213 = (0);
seq__11967_13117 = G__13210;
chunk__11968_13118 = G__13211;
count__11969_13119 = G__13212;
i__11970_13120 = G__13213;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__12094 = cljs.core.seq(node);
var chunk__12095 = null;
var count__12096 = (0);
var i__12097 = (0);
while(true){
if((i__12097 < count__12096)){
var n = chunk__12095.cljs$core$IIndexed$_nth$arity$2(null,i__12097);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__13228 = seq__12094;
var G__13229 = chunk__12095;
var G__13230 = count__12096;
var G__13231 = (i__12097 + (1));
seq__12094 = G__13228;
chunk__12095 = G__13229;
count__12096 = G__13230;
i__12097 = G__13231;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__12094);
if(temp__5804__auto__){
var seq__12094__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__12094__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__12094__$1);
var G__13232 = cljs.core.chunk_rest(seq__12094__$1);
var G__13233 = c__5525__auto__;
var G__13234 = cljs.core.count(c__5525__auto__);
var G__13235 = (0);
seq__12094 = G__13232;
chunk__12095 = G__13233;
count__12096 = G__13234;
i__12097 = G__13235;
continue;
} else {
var n = cljs.core.first(seq__12094__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__13236 = cljs.core.next(seq__12094__$1);
var G__13237 = null;
var G__13238 = (0);
var G__13239 = (0);
seq__12094 = G__13236;
chunk__12095 = G__13237;
count__12096 = G__13238;
i__12097 = G__13239;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__12119 = arguments.length;
switch (G__12119) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__12129 = arguments.length;
switch (G__12129) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__12244 = arguments.length;
switch (G__12244) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__5002__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__5732__auto__ = [];
var len__5726__auto___13262 = arguments.length;
var i__5727__auto___13263 = (0);
while(true){
if((i__5727__auto___13263 < len__5726__auto___13262)){
args__5732__auto__.push((arguments[i__5727__auto___13263]));

var G__13265 = (i__5727__auto___13263 + (1));
i__5727__auto___13263 = G__13265;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((0) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__5733__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__12331_13267 = cljs.core.seq(nodes);
var chunk__12332_13268 = null;
var count__12333_13269 = (0);
var i__12334_13270 = (0);
while(true){
if((i__12334_13270 < count__12333_13269)){
var node_13274 = chunk__12332_13268.cljs$core$IIndexed$_nth$arity$2(null,i__12334_13270);
fragment.appendChild(shadow.dom._to_dom(node_13274));


var G__13276 = seq__12331_13267;
var G__13277 = chunk__12332_13268;
var G__13278 = count__12333_13269;
var G__13279 = (i__12334_13270 + (1));
seq__12331_13267 = G__13276;
chunk__12332_13268 = G__13277;
count__12333_13269 = G__13278;
i__12334_13270 = G__13279;
continue;
} else {
var temp__5804__auto___13280 = cljs.core.seq(seq__12331_13267);
if(temp__5804__auto___13280){
var seq__12331_13283__$1 = temp__5804__auto___13280;
if(cljs.core.chunked_seq_QMARK_(seq__12331_13283__$1)){
var c__5525__auto___13287 = cljs.core.chunk_first(seq__12331_13283__$1);
var G__13289 = cljs.core.chunk_rest(seq__12331_13283__$1);
var G__13290 = c__5525__auto___13287;
var G__13291 = cljs.core.count(c__5525__auto___13287);
var G__13292 = (0);
seq__12331_13267 = G__13289;
chunk__12332_13268 = G__13290;
count__12333_13269 = G__13291;
i__12334_13270 = G__13292;
continue;
} else {
var node_13293 = cljs.core.first(seq__12331_13283__$1);
fragment.appendChild(shadow.dom._to_dom(node_13293));


var G__13297 = cljs.core.next(seq__12331_13283__$1);
var G__13298 = null;
var G__13299 = (0);
var G__13300 = (0);
seq__12331_13267 = G__13297;
chunk__12332_13268 = G__13298;
count__12333_13269 = G__13299;
i__12334_13270 = G__13300;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq12293){
var self__5712__auto__ = this;
return self__5712__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq12293));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__12367_13301 = cljs.core.seq(scripts);
var chunk__12368_13302 = null;
var count__12369_13303 = (0);
var i__12370_13304 = (0);
while(true){
if((i__12370_13304 < count__12369_13303)){
var vec__12404_13305 = chunk__12368_13302.cljs$core$IIndexed$_nth$arity$2(null,i__12370_13304);
var script_tag_13306 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12404_13305,(0),null);
var script_body_13307 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12404_13305,(1),null);
eval(script_body_13307);


var G__13310 = seq__12367_13301;
var G__13311 = chunk__12368_13302;
var G__13312 = count__12369_13303;
var G__13313 = (i__12370_13304 + (1));
seq__12367_13301 = G__13310;
chunk__12368_13302 = G__13311;
count__12369_13303 = G__13312;
i__12370_13304 = G__13313;
continue;
} else {
var temp__5804__auto___13314 = cljs.core.seq(seq__12367_13301);
if(temp__5804__auto___13314){
var seq__12367_13316__$1 = temp__5804__auto___13314;
if(cljs.core.chunked_seq_QMARK_(seq__12367_13316__$1)){
var c__5525__auto___13318 = cljs.core.chunk_first(seq__12367_13316__$1);
var G__13319 = cljs.core.chunk_rest(seq__12367_13316__$1);
var G__13320 = c__5525__auto___13318;
var G__13321 = cljs.core.count(c__5525__auto___13318);
var G__13322 = (0);
seq__12367_13301 = G__13319;
chunk__12368_13302 = G__13320;
count__12369_13303 = G__13321;
i__12370_13304 = G__13322;
continue;
} else {
var vec__12414_13324 = cljs.core.first(seq__12367_13316__$1);
var script_tag_13325 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12414_13324,(0),null);
var script_body_13326 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12414_13324,(1),null);
eval(script_body_13326);


var G__13329 = cljs.core.next(seq__12367_13316__$1);
var G__13330 = null;
var G__13331 = (0);
var G__13332 = (0);
seq__12367_13301 = G__13329;
chunk__12368_13302 = G__13330;
count__12369_13303 = G__13331;
i__12370_13304 = G__13332;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__12419){
var vec__12421 = p__12419;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12421,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12421,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__12439 = arguments.length;
switch (G__12439) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__12455 = cljs.core.seq(style_keys);
var chunk__12456 = null;
var count__12457 = (0);
var i__12458 = (0);
while(true){
if((i__12458 < count__12457)){
var it = chunk__12456.cljs$core$IIndexed$_nth$arity$2(null,i__12458);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__13363 = seq__12455;
var G__13364 = chunk__12456;
var G__13365 = count__12457;
var G__13366 = (i__12458 + (1));
seq__12455 = G__13363;
chunk__12456 = G__13364;
count__12457 = G__13365;
i__12458 = G__13366;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__12455);
if(temp__5804__auto__){
var seq__12455__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__12455__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__12455__$1);
var G__13374 = cljs.core.chunk_rest(seq__12455__$1);
var G__13375 = c__5525__auto__;
var G__13376 = cljs.core.count(c__5525__auto__);
var G__13377 = (0);
seq__12455 = G__13374;
chunk__12456 = G__13375;
count__12457 = G__13376;
i__12458 = G__13377;
continue;
} else {
var it = cljs.core.first(seq__12455__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__13379 = cljs.core.next(seq__12455__$1);
var G__13380 = null;
var G__13381 = (0);
var G__13382 = (0);
seq__12455 = G__13379;
chunk__12456 = G__13380;
count__12457 = G__13381;
i__12458 = G__13382;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5300__auto__,k__5301__auto__){
var self__ = this;
var this__5300__auto____$1 = this;
return this__5300__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5301__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5302__auto__,k12472,else__5303__auto__){
var self__ = this;
var this__5302__auto____$1 = this;
var G__12491 = k12472;
var G__12491__$1 = (((G__12491 instanceof cljs.core.Keyword))?G__12491.fqn:null);
switch (G__12491__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12472,else__5303__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5320__auto__,f__5321__auto__,init__5322__auto__){
var self__ = this;
var this__5320__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5323__auto__,p__12509){
var vec__12511 = p__12509;
var k__5324__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12511,(0),null);
var v__5325__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12511,(1),null);
return (f__5321__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5321__auto__.cljs$core$IFn$_invoke$arity$3(ret__5323__auto__,k__5324__auto__,v__5325__auto__) : f__5321__auto__.call(null,ret__5323__auto__,k__5324__auto__,v__5325__auto__));
}),init__5322__auto__,this__5320__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5315__auto__,writer__5316__auto__,opts__5317__auto__){
var self__ = this;
var this__5315__auto____$1 = this;
var pr_pair__5318__auto__ = (function (keyval__5319__auto__){
return cljs.core.pr_sequential_writer(writer__5316__auto__,cljs.core.pr_writer,""," ","",opts__5317__auto__,keyval__5319__auto__);
});
return cljs.core.pr_sequential_writer(writer__5316__auto__,pr_pair__5318__auto__,"#shadow.dom.Coordinate{",", ","}",opts__5317__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12471){
var self__ = this;
var G__12471__$1 = this;
return (new cljs.core.RecordIter((0),G__12471__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5298__auto__){
var self__ = this;
var this__5298__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5295__auto__){
var self__ = this;
var this__5295__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5304__auto__){
var self__ = this;
var this__5304__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5296__auto__){
var self__ = this;
var this__5296__auto____$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = (function (coll__5297__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__5297__auto__));
})(this__5296__auto____$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12473,other12474){
var self__ = this;
var this12473__$1 = this;
return (((!((other12474 == null)))) && ((((this12473__$1.constructor === other12474.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12473__$1.x,other12474.x)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12473__$1.y,other12474.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12473__$1.__extmap,other12474.__extmap)))))))));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5310__auto__,k__5311__auto__){
var self__ = this;
var this__5310__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__5311__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5310__auto____$1),self__.__meta),k__5311__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5311__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5307__auto__,k12472){
var self__ = this;
var this__5307__auto____$1 = this;
var G__12548 = k12472;
var G__12548__$1 = (((G__12548 instanceof cljs.core.Keyword))?G__12548.fqn:null);
switch (G__12548__$1) {
case "x":
case "y":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k12472);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5308__auto__,k__5309__auto__,G__12471){
var self__ = this;
var this__5308__auto____$1 = this;
var pred__12549 = cljs.core.keyword_identical_QMARK_;
var expr__12550 = k__5309__auto__;
if(cljs.core.truth_((pred__12549.cljs$core$IFn$_invoke$arity$2 ? pred__12549.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__12550) : pred__12549.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__12550)))){
return (new shadow.dom.Coordinate(G__12471,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12549.cljs$core$IFn$_invoke$arity$2 ? pred__12549.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__12550) : pred__12549.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__12550)))){
return (new shadow.dom.Coordinate(self__.x,G__12471,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5309__auto__,G__12471),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5313__auto__){
var self__ = this;
var this__5313__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5299__auto__,G__12471){
var self__ = this;
var this__5299__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__12471,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5305__auto__,entry__5306__auto__){
var self__ = this;
var this__5305__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5306__auto__)){
return this__5305__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__5306__auto__,(0)),cljs.core._nth(entry__5306__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5305__auto____$1,entry__5306__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__5346__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__5346__auto__,writer__5347__auto__){
return cljs.core._write(writer__5347__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__12485){
var extmap__5342__auto__ = (function (){var G__12569 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12485,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__12485)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12569);
} else {
return G__12569;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__12485),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__12485),null,cljs.core.not_empty(extmap__5342__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5300__auto__,k__5301__auto__){
var self__ = this;
var this__5300__auto____$1 = this;
return this__5300__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5301__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5302__auto__,k12587,else__5303__auto__){
var self__ = this;
var this__5302__auto____$1 = this;
var G__12599 = k12587;
var G__12599__$1 = (((G__12599 instanceof cljs.core.Keyword))?G__12599.fqn:null);
switch (G__12599__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12587,else__5303__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5320__auto__,f__5321__auto__,init__5322__auto__){
var self__ = this;
var this__5320__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5323__auto__,p__12606){
var vec__12607 = p__12606;
var k__5324__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12607,(0),null);
var v__5325__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12607,(1),null);
return (f__5321__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5321__auto__.cljs$core$IFn$_invoke$arity$3(ret__5323__auto__,k__5324__auto__,v__5325__auto__) : f__5321__auto__.call(null,ret__5323__auto__,k__5324__auto__,v__5325__auto__));
}),init__5322__auto__,this__5320__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5315__auto__,writer__5316__auto__,opts__5317__auto__){
var self__ = this;
var this__5315__auto____$1 = this;
var pr_pair__5318__auto__ = (function (keyval__5319__auto__){
return cljs.core.pr_sequential_writer(writer__5316__auto__,cljs.core.pr_writer,""," ","",opts__5317__auto__,keyval__5319__auto__);
});
return cljs.core.pr_sequential_writer(writer__5316__auto__,pr_pair__5318__auto__,"#shadow.dom.Size{",", ","}",opts__5317__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12586){
var self__ = this;
var G__12586__$1 = this;
return (new cljs.core.RecordIter((0),G__12586__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5298__auto__){
var self__ = this;
var this__5298__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5295__auto__){
var self__ = this;
var this__5295__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5304__auto__){
var self__ = this;
var this__5304__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5296__auto__){
var self__ = this;
var this__5296__auto____$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = (function (coll__5297__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__5297__auto__));
})(this__5296__auto____$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12588,other12589){
var self__ = this;
var this12588__$1 = this;
return (((!((other12589 == null)))) && ((((this12588__$1.constructor === other12589.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12588__$1.w,other12589.w)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12588__$1.h,other12589.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12588__$1.__extmap,other12589.__extmap)))))))));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5310__auto__,k__5311__auto__){
var self__ = this;
var this__5310__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__5311__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5310__auto____$1),self__.__meta),k__5311__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5311__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5307__auto__,k12587){
var self__ = this;
var this__5307__auto____$1 = this;
var G__12627 = k12587;
var G__12627__$1 = (((G__12627 instanceof cljs.core.Keyword))?G__12627.fqn:null);
switch (G__12627__$1) {
case "w":
case "h":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k12587);

}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5308__auto__,k__5309__auto__,G__12586){
var self__ = this;
var this__5308__auto____$1 = this;
var pred__12631 = cljs.core.keyword_identical_QMARK_;
var expr__12632 = k__5309__auto__;
if(cljs.core.truth_((pred__12631.cljs$core$IFn$_invoke$arity$2 ? pred__12631.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__12632) : pred__12631.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__12632)))){
return (new shadow.dom.Size(G__12586,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12631.cljs$core$IFn$_invoke$arity$2 ? pred__12631.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__12632) : pred__12631.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__12632)))){
return (new shadow.dom.Size(self__.w,G__12586,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5309__auto__,G__12586),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5313__auto__){
var self__ = this;
var this__5313__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5299__auto__,G__12586){
var self__ = this;
var this__5299__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__12586,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5305__auto__,entry__5306__auto__){
var self__ = this;
var this__5305__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5306__auto__)){
return this__5305__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__5306__auto__,(0)),cljs.core._nth(entry__5306__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5305__auto____$1,entry__5306__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__5346__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__5346__auto__,writer__5347__auto__){
return cljs.core._write(writer__5347__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__12590){
var extmap__5342__auto__ = (function (){var G__12642 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12590,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__12590)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12642);
} else {
return G__12642;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__12590),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__12590),null,cljs.core.not_empty(extmap__5342__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__5590__auto__ = opts;
var l__5591__auto__ = a__5590__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__5591__auto__)){
var G__13588 = (i + (1));
var G__13589 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__13588;
ret = G__13589;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__12689){
var vec__12690 = p__12689;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12690,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12690,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__12696 = arguments.length;
switch (G__12696) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5802__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5802__auto__)){
var child = temp__5802__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__13620 = ps;
var G__13624 = (i + (1));
el__$1 = G__13620;
i = G__13624;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__12749 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12749,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12749,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12749,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__12753_13665 = cljs.core.seq(props);
var chunk__12754_13666 = null;
var count__12755_13667 = (0);
var i__12756_13668 = (0);
while(true){
if((i__12756_13668 < count__12755_13667)){
var vec__12776_13681 = chunk__12754_13666.cljs$core$IIndexed$_nth$arity$2(null,i__12756_13668);
var k_13682 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12776_13681,(0),null);
var v_13683 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12776_13681,(1),null);
el.setAttributeNS((function (){var temp__5804__auto__ = cljs.core.namespace(k_13682);
if(cljs.core.truth_(temp__5804__auto__)){
var ns = temp__5804__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_13682),v_13683);


var G__13685 = seq__12753_13665;
var G__13686 = chunk__12754_13666;
var G__13687 = count__12755_13667;
var G__13688 = (i__12756_13668 + (1));
seq__12753_13665 = G__13685;
chunk__12754_13666 = G__13686;
count__12755_13667 = G__13687;
i__12756_13668 = G__13688;
continue;
} else {
var temp__5804__auto___13689 = cljs.core.seq(seq__12753_13665);
if(temp__5804__auto___13689){
var seq__12753_13690__$1 = temp__5804__auto___13689;
if(cljs.core.chunked_seq_QMARK_(seq__12753_13690__$1)){
var c__5525__auto___13691 = cljs.core.chunk_first(seq__12753_13690__$1);
var G__13692 = cljs.core.chunk_rest(seq__12753_13690__$1);
var G__13693 = c__5525__auto___13691;
var G__13694 = cljs.core.count(c__5525__auto___13691);
var G__13695 = (0);
seq__12753_13665 = G__13692;
chunk__12754_13666 = G__13693;
count__12755_13667 = G__13694;
i__12756_13668 = G__13695;
continue;
} else {
var vec__12781_13697 = cljs.core.first(seq__12753_13690__$1);
var k_13698 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12781_13697,(0),null);
var v_13699 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12781_13697,(1),null);
el.setAttributeNS((function (){var temp__5804__auto____$1 = cljs.core.namespace(k_13698);
if(cljs.core.truth_(temp__5804__auto____$1)){
var ns = temp__5804__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_13698),v_13699);


var G__13701 = cljs.core.next(seq__12753_13690__$1);
var G__13702 = null;
var G__13703 = (0);
var G__13704 = (0);
seq__12753_13665 = G__13701;
chunk__12754_13666 = G__13702;
count__12755_13667 = G__13703;
i__12756_13668 = G__13704;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__12791 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12791,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12791,(1),null);
var seq__12794_13708 = cljs.core.seq(node_children);
var chunk__12796_13709 = null;
var count__12797_13710 = (0);
var i__12798_13711 = (0);
while(true){
if((i__12798_13711 < count__12797_13710)){
var child_struct_13713 = chunk__12796_13709.cljs$core$IIndexed$_nth$arity$2(null,i__12798_13711);
if((!((child_struct_13713 == null)))){
if(typeof child_struct_13713 === 'string'){
var text_13717 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_13717),child_struct_13713].join(''));
} else {
var children_13721 = shadow.dom.svg_node(child_struct_13713);
if(cljs.core.seq_QMARK_(children_13721)){
var seq__12845_13723 = cljs.core.seq(children_13721);
var chunk__12847_13724 = null;
var count__12848_13725 = (0);
var i__12849_13726 = (0);
while(true){
if((i__12849_13726 < count__12848_13725)){
var child_13727 = chunk__12847_13724.cljs$core$IIndexed$_nth$arity$2(null,i__12849_13726);
if(cljs.core.truth_(child_13727)){
node.appendChild(child_13727);


var G__13730 = seq__12845_13723;
var G__13731 = chunk__12847_13724;
var G__13732 = count__12848_13725;
var G__13733 = (i__12849_13726 + (1));
seq__12845_13723 = G__13730;
chunk__12847_13724 = G__13731;
count__12848_13725 = G__13732;
i__12849_13726 = G__13733;
continue;
} else {
var G__13734 = seq__12845_13723;
var G__13735 = chunk__12847_13724;
var G__13736 = count__12848_13725;
var G__13737 = (i__12849_13726 + (1));
seq__12845_13723 = G__13734;
chunk__12847_13724 = G__13735;
count__12848_13725 = G__13736;
i__12849_13726 = G__13737;
continue;
}
} else {
var temp__5804__auto___13738 = cljs.core.seq(seq__12845_13723);
if(temp__5804__auto___13738){
var seq__12845_13740__$1 = temp__5804__auto___13738;
if(cljs.core.chunked_seq_QMARK_(seq__12845_13740__$1)){
var c__5525__auto___13741 = cljs.core.chunk_first(seq__12845_13740__$1);
var G__13742 = cljs.core.chunk_rest(seq__12845_13740__$1);
var G__13743 = c__5525__auto___13741;
var G__13744 = cljs.core.count(c__5525__auto___13741);
var G__13745 = (0);
seq__12845_13723 = G__13742;
chunk__12847_13724 = G__13743;
count__12848_13725 = G__13744;
i__12849_13726 = G__13745;
continue;
} else {
var child_13746 = cljs.core.first(seq__12845_13740__$1);
if(cljs.core.truth_(child_13746)){
node.appendChild(child_13746);


var G__13747 = cljs.core.next(seq__12845_13740__$1);
var G__13748 = null;
var G__13749 = (0);
var G__13750 = (0);
seq__12845_13723 = G__13747;
chunk__12847_13724 = G__13748;
count__12848_13725 = G__13749;
i__12849_13726 = G__13750;
continue;
} else {
var G__13752 = cljs.core.next(seq__12845_13740__$1);
var G__13753 = null;
var G__13754 = (0);
var G__13755 = (0);
seq__12845_13723 = G__13752;
chunk__12847_13724 = G__13753;
count__12848_13725 = G__13754;
i__12849_13726 = G__13755;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_13721);
}
}


var G__13757 = seq__12794_13708;
var G__13758 = chunk__12796_13709;
var G__13759 = count__12797_13710;
var G__13760 = (i__12798_13711 + (1));
seq__12794_13708 = G__13757;
chunk__12796_13709 = G__13758;
count__12797_13710 = G__13759;
i__12798_13711 = G__13760;
continue;
} else {
var G__13764 = seq__12794_13708;
var G__13765 = chunk__12796_13709;
var G__13766 = count__12797_13710;
var G__13767 = (i__12798_13711 + (1));
seq__12794_13708 = G__13764;
chunk__12796_13709 = G__13765;
count__12797_13710 = G__13766;
i__12798_13711 = G__13767;
continue;
}
} else {
var temp__5804__auto___13768 = cljs.core.seq(seq__12794_13708);
if(temp__5804__auto___13768){
var seq__12794_13770__$1 = temp__5804__auto___13768;
if(cljs.core.chunked_seq_QMARK_(seq__12794_13770__$1)){
var c__5525__auto___13772 = cljs.core.chunk_first(seq__12794_13770__$1);
var G__13773 = cljs.core.chunk_rest(seq__12794_13770__$1);
var G__13774 = c__5525__auto___13772;
var G__13775 = cljs.core.count(c__5525__auto___13772);
var G__13776 = (0);
seq__12794_13708 = G__13773;
chunk__12796_13709 = G__13774;
count__12797_13710 = G__13775;
i__12798_13711 = G__13776;
continue;
} else {
var child_struct_13777 = cljs.core.first(seq__12794_13770__$1);
if((!((child_struct_13777 == null)))){
if(typeof child_struct_13777 === 'string'){
var text_13787 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_13787),child_struct_13777].join(''));
} else {
var children_13788 = shadow.dom.svg_node(child_struct_13777);
if(cljs.core.seq_QMARK_(children_13788)){
var seq__12876_13790 = cljs.core.seq(children_13788);
var chunk__12878_13791 = null;
var count__12879_13792 = (0);
var i__12880_13793 = (0);
while(true){
if((i__12880_13793 < count__12879_13792)){
var child_13794 = chunk__12878_13791.cljs$core$IIndexed$_nth$arity$2(null,i__12880_13793);
if(cljs.core.truth_(child_13794)){
node.appendChild(child_13794);


var G__13796 = seq__12876_13790;
var G__13797 = chunk__12878_13791;
var G__13798 = count__12879_13792;
var G__13799 = (i__12880_13793 + (1));
seq__12876_13790 = G__13796;
chunk__12878_13791 = G__13797;
count__12879_13792 = G__13798;
i__12880_13793 = G__13799;
continue;
} else {
var G__13800 = seq__12876_13790;
var G__13801 = chunk__12878_13791;
var G__13802 = count__12879_13792;
var G__13803 = (i__12880_13793 + (1));
seq__12876_13790 = G__13800;
chunk__12878_13791 = G__13801;
count__12879_13792 = G__13802;
i__12880_13793 = G__13803;
continue;
}
} else {
var temp__5804__auto___13805__$1 = cljs.core.seq(seq__12876_13790);
if(temp__5804__auto___13805__$1){
var seq__12876_13806__$1 = temp__5804__auto___13805__$1;
if(cljs.core.chunked_seq_QMARK_(seq__12876_13806__$1)){
var c__5525__auto___13807 = cljs.core.chunk_first(seq__12876_13806__$1);
var G__13808 = cljs.core.chunk_rest(seq__12876_13806__$1);
var G__13809 = c__5525__auto___13807;
var G__13810 = cljs.core.count(c__5525__auto___13807);
var G__13811 = (0);
seq__12876_13790 = G__13808;
chunk__12878_13791 = G__13809;
count__12879_13792 = G__13810;
i__12880_13793 = G__13811;
continue;
} else {
var child_13812 = cljs.core.first(seq__12876_13806__$1);
if(cljs.core.truth_(child_13812)){
node.appendChild(child_13812);


var G__13813 = cljs.core.next(seq__12876_13806__$1);
var G__13814 = null;
var G__13815 = (0);
var G__13816 = (0);
seq__12876_13790 = G__13813;
chunk__12878_13791 = G__13814;
count__12879_13792 = G__13815;
i__12880_13793 = G__13816;
continue;
} else {
var G__13817 = cljs.core.next(seq__12876_13806__$1);
var G__13818 = null;
var G__13819 = (0);
var G__13820 = (0);
seq__12876_13790 = G__13817;
chunk__12878_13791 = G__13818;
count__12879_13792 = G__13819;
i__12880_13793 = G__13820;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_13788);
}
}


var G__13821 = cljs.core.next(seq__12794_13770__$1);
var G__13822 = null;
var G__13823 = (0);
var G__13824 = (0);
seq__12794_13708 = G__13821;
chunk__12796_13709 = G__13822;
count__12797_13710 = G__13823;
i__12798_13711 = G__13824;
continue;
} else {
var G__13827 = cljs.core.next(seq__12794_13770__$1);
var G__13828 = null;
var G__13829 = (0);
var G__13830 = (0);
seq__12794_13708 = G__13827;
chunk__12796_13709 = G__13828;
count__12797_13710 = G__13829;
i__12798_13711 = G__13830;
continue;
}
}
} else {
}
}
break;
}

return node;
});
(shadow.dom.SVGElement["string"] = true);

(shadow.dom._to_svg["string"] = (function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

(shadow.dom.SVGElement["null"] = true);

(shadow.dom._to_svg["null"] = (function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__5732__auto__ = [];
var len__5726__auto___13839 = arguments.length;
var i__5727__auto___13842 = (0);
while(true){
if((i__5727__auto___13842 < len__5726__auto___13839)){
args__5732__auto__.push((arguments[i__5727__auto___13842]));

var G__13844 = (i__5727__auto___13842 + (1));
i__5727__auto___13842 = G__13844;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((1) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5733__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq12901){
var G__12902 = cljs.core.first(seq12901);
var seq12901__$1 = cljs.core.next(seq12901);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12902,seq12901__$1);
}));


//# sourceMappingURL=shadow.dom.js.map
