goog.provide('atlas_ui.graph');
var module$node_modules$cytoscape$dist$cytoscape_cjs=shadow.js.require("module$node_modules$cytoscape$dist$cytoscape_cjs", {});
var module$node_modules$cytoscape_navigator$cytoscape_navigator=shadow.js.require("module$node_modules$cytoscape_navigator$cytoscape_navigator", {});
/**
 * Truncate label to max-chars, adding ellipsis if needed.
 *   Preserves newlines for badge text.
 */
atlas_ui.graph.truncate_label = (function atlas_ui$graph$truncate_label(label,max_chars){
if(clojure.string.includes_QMARK_(label,"\n")){
var vec__18380 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(label,/\n/);
var seq__18381 = cljs.core.seq(vec__18380);
var first__18382 = cljs.core.first(seq__18381);
var seq__18381__$1 = cljs.core.next(seq__18381);
var first_line = first__18382;
var rest_lines = seq__18381__$1;
var truncated_first = (((cljs.core.count(first_line) > max_chars))?[cljs.core.subs.cljs$core$IFn$_invoke$arity$3(first_line,(0),max_chars),"..."].join(''):first_line);
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.cons(truncated_first,rest_lines));
} else {
if((cljs.core.count(label) > max_chars)){
return [cljs.core.subs.cljs$core$IFn$_invoke$arity$3(label,(0),max_chars),"..."].join('');
} else {
return label;
}
}
});
atlas_ui.graph.build_cytoscape_elements = (function atlas_ui$graph$build_cytoscape_elements(graph_data,selections,negated_aspects,query_mode,min_score,highlighted_entity_id,highlighted_entity_aspects,registry,hide_unmatched_QMARK_,search_term){
var query = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("atlas.query","selected","atlas.query/selected",1069414447),selections,new cljs.core.Keyword("atlas.query","negated","atlas.query/negated",1430445364),negated_aspects,new cljs.core.Keyword("atlas.query","mode","atlas.query/mode",1284108834),query_mode,new cljs.core.Keyword("atlas.query","min-score","atlas.query/min-score",-135983776),(cljs.core.truth_(hide_unmatched_QMARK_)?min_score:0.0)], null);
var search_lower = clojure.string.lower_case((function (){var or__5002__auto__ = search_term;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return "";
}
})());
var node_matches_search_QMARK_ = (function (node){
if(cljs.core.seq(search_term)){
return clojure.string.includes_QMARK_(clojure.string.lower_case(new cljs.core.Keyword("atlas-ui.graph.node","label","atlas-ui.graph.node/label",1764673194).cljs$core$IFn$_invoke$arity$1(node)),search_lower);
} else {
return true;
}
});
var should_show_node_QMARK_ = (function (node){
if(cljs.core.truth_(hide_unmatched_QMARK_)){
var G__18396 = new cljs.core.Keyword("atlas-ui.graph.node","type","atlas-ui.graph.node/type",1053813014).cljs$core$IFn$_invoke$arity$1(node);
var G__18396__$1 = (((G__18396 instanceof cljs.core.Keyword))?G__18396.fqn:null);
switch (G__18396__$1) {
case "entity":
return atlas.query.query_matches_QMARK_(new cljs.core.Keyword("atlas-ui.graph.node","identity","atlas-ui.graph.node/identity",1626823993).cljs$core$IFn$_invoke$arity$1(node),query);

break;
case "aspect":
return ((cljs.core.contains_QMARK_(selections,new cljs.core.Keyword("atlas-ui.graph.node","id","atlas-ui.graph.node/id",-1392721478).cljs$core$IFn$_invoke$arity$1(node))) || (cljs.core.contains_QMARK_(negated_aspects,new cljs.core.Keyword("atlas-ui.graph.node","id","atlas-ui.graph.node/id",-1392721478).cljs$core$IFn$_invoke$arity$1(node))));

break;
default:
return true;

}
} else {
return true;
}
});
var entity_shape = (function (identity){
return "round-rectangle";
});
var nodes = (function (){var iter__5480__auto__ = (function atlas_ui$graph$build_cytoscape_elements_$_iter__18397(s__18398){
return (new cljs.core.LazySeq(null,(function (){
var s__18398__$1 = s__18398;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__18398__$1);
if(temp__5804__auto__){
var s__18398__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__18398__$2)){
var c__5478__auto__ = cljs.core.chunk_first(s__18398__$2);
var size__5479__auto__ = cljs.core.count(c__5478__auto__);
var b__18400 = cljs.core.chunk_buffer(size__5479__auto__);
if((function (){var i__18399 = (0);
while(true){
if((i__18399 < size__5479__auto__)){
var node = cljs.core._nth(c__5478__auto__,i__18399);
if(cljs.core.truth_(should_show_node_QMARK_(node))){
cljs.core.chunk_append(b__18400,(function (){var color = atlas_ui.colors_v2.node_color(node,query,highlighted_entity_id,highlighted_entity_aspects);
var opacity = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("atlas-ui.graph.node","type","atlas-ui.graph.node/type",1053813014).cljs$core$IFn$_invoke$arity$1(node),new cljs.core.Keyword(null,"entity","entity",-450970276)))?atlas_ui.colors_v2.calculate_opacity((function (){var or__5002__auto__ = new cljs.core.Keyword("atlas-ui.graph.node","aspects","atlas-ui.graph.node/aspects",1959787835).cljs$core$IFn$_invoke$arity$1(node);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return new cljs.core.Keyword("atlas-ui.graph.node","identity","atlas-ui.graph.node/identity",1626823993).cljs$core$IFn$_invoke$arity$1(node);
}
})(),query):1.0);
var is_selected = cljs.core.contains_QMARK_(selections,new cljs.core.Keyword("atlas-ui.graph.node","id","atlas-ui.graph.node/id",-1392721478).cljs$core$IFn$_invoke$arity$1(node));
var is_negated = cljs.core.contains_QMARK_(negated_aspects,new cljs.core.Keyword("atlas-ui.graph.node","id","atlas-ui.graph.node/id",-1392721478).cljs$core$IFn$_invoke$arity$1(node));
var matches_search = node_matches_search_QMARK_(node);
var shape = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("atlas-ui.graph.node","type","atlas-ui.graph.node/type",1053813014).cljs$core$IFn$_invoke$arity$1(node),new cljs.core.Keyword(null,"entity","entity",-450970276)))?entity_shape(new cljs.core.Keyword("atlas-ui.graph.node","identity","atlas-ui.graph.node/identity",1626823993).cljs$core$IFn$_invoke$arity$1(node)):"ellipse");
var badges = new cljs.core.Keyword("atlas-ui.graph.node","aspect-badges","atlas-ui.graph.node/aspect-badges",-86040126).cljs$core$IFn$_invoke$arity$1(node);
var badge_text = ((cljs.core.seq(badges))?["\n",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (i__18399,s__18398__$1,color,opacity,is_selected,is_negated,matches_search,shape,badges,node,c__5478__auto__,size__5479__auto__,b__18400,s__18398__$2,temp__5804__auto__,query,search_lower,node_matches_search_QMARK_,should_show_node_QMARK_,entity_shape){
return (function (p1__18384_SHARP_){
return ["\uD83C\uDFF7\uFE0F",cljs.core.name(p1__18384_SHARP_)].join('');
});})(i__18399,s__18398__$1,color,opacity,is_selected,is_negated,matches_search,shape,badges,node,c__5478__auto__,size__5479__auto__,b__18400,s__18398__$2,temp__5804__auto__,query,search_lower,node_matches_search_QMARK_,should_show_node_QMARK_,entity_shape))
,cljs.core.take.cljs$core$IFn$_invoke$arity$2((3),badges)))].join(''):null);
var full_label = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("atlas-ui.graph.node","label","atlas-ui.graph.node/label",1764673194).cljs$core$IFn$_invoke$arity$1(node)),(function (){var or__5002__auto__ = badge_text;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return "";
}
})()].join('');
var truncated_label = atlas_ui.graph.truncate_label(full_label,(18));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"identity","identity",1647396035),new cljs.core.Keyword(null,"selected","selected",574897764),new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"search-match","search-match",812229448),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"highlighted","highlighted",1723498733),new cljs.core.Keyword(null,"opacity","opacity",397153780),new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.Keyword(null,"negated","negated",-273117033),new cljs.core.Keyword(null,"fullLabel","fullLabel",2124644760)],[new cljs.core.Keyword("atlas-ui.graph.node","identity","atlas-ui.graph.node/identity",1626823993).cljs$core$IFn$_invoke$arity$1(node),cljs.core.str.cljs$core$IFn$_invoke$arity$1(is_selected),color,cljs.core.str.cljs$core$IFn$_invoke$arity$1(matches_search),cljs.core.name(new cljs.core.Keyword("atlas-ui.graph.node","type","atlas-ui.graph.node/type",1053813014).cljs$core$IFn$_invoke$arity$1(node)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("atlas-ui.graph.node","id","atlas-ui.graph.node/id",-1392721478).cljs$core$IFn$_invoke$arity$1(node),highlighted_entity_id)),((((cljs.core.seq(search_term)) && ((!(matches_search)))))?(opacity * 0.3):opacity),truncated_label,atlas_ui.id.id__GT_string(new cljs.core.Keyword("atlas-ui.graph.node","id","atlas-ui.graph.node/id",-1392721478).cljs$core$IFn$_invoke$arity$1(node)),shape,cljs.core.str.cljs$core$IFn$_invoke$arity$1(is_negated),full_label])], null);
})());

var G__18655 = (i__18399 + (1));
i__18399 = G__18655;
continue;
} else {
var G__18657 = (i__18399 + (1));
i__18399 = G__18657;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__18400),atlas_ui$graph$build_cytoscape_elements_$_iter__18397(cljs.core.chunk_rest(s__18398__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__18400),null);
}
} else {
var node = cljs.core.first(s__18398__$2);
if(cljs.core.truth_(should_show_node_QMARK_(node))){
return cljs.core.cons((function (){var color = atlas_ui.colors_v2.node_color(node,query,highlighted_entity_id,highlighted_entity_aspects);
var opacity = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("atlas-ui.graph.node","type","atlas-ui.graph.node/type",1053813014).cljs$core$IFn$_invoke$arity$1(node),new cljs.core.Keyword(null,"entity","entity",-450970276)))?atlas_ui.colors_v2.calculate_opacity((function (){var or__5002__auto__ = new cljs.core.Keyword("atlas-ui.graph.node","aspects","atlas-ui.graph.node/aspects",1959787835).cljs$core$IFn$_invoke$arity$1(node);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return new cljs.core.Keyword("atlas-ui.graph.node","identity","atlas-ui.graph.node/identity",1626823993).cljs$core$IFn$_invoke$arity$1(node);
}
})(),query):1.0);
var is_selected = cljs.core.contains_QMARK_(selections,new cljs.core.Keyword("atlas-ui.graph.node","id","atlas-ui.graph.node/id",-1392721478).cljs$core$IFn$_invoke$arity$1(node));
var is_negated = cljs.core.contains_QMARK_(negated_aspects,new cljs.core.Keyword("atlas-ui.graph.node","id","atlas-ui.graph.node/id",-1392721478).cljs$core$IFn$_invoke$arity$1(node));
var matches_search = node_matches_search_QMARK_(node);
var shape = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("atlas-ui.graph.node","type","atlas-ui.graph.node/type",1053813014).cljs$core$IFn$_invoke$arity$1(node),new cljs.core.Keyword(null,"entity","entity",-450970276)))?entity_shape(new cljs.core.Keyword("atlas-ui.graph.node","identity","atlas-ui.graph.node/identity",1626823993).cljs$core$IFn$_invoke$arity$1(node)):"ellipse");
var badges = new cljs.core.Keyword("atlas-ui.graph.node","aspect-badges","atlas-ui.graph.node/aspect-badges",-86040126).cljs$core$IFn$_invoke$arity$1(node);
var badge_text = ((cljs.core.seq(badges))?["\n",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (s__18398__$1,color,opacity,is_selected,is_negated,matches_search,shape,badges,node,s__18398__$2,temp__5804__auto__,query,search_lower,node_matches_search_QMARK_,should_show_node_QMARK_,entity_shape){
return (function (p1__18384_SHARP_){
return ["\uD83C\uDFF7\uFE0F",cljs.core.name(p1__18384_SHARP_)].join('');
});})(s__18398__$1,color,opacity,is_selected,is_negated,matches_search,shape,badges,node,s__18398__$2,temp__5804__auto__,query,search_lower,node_matches_search_QMARK_,should_show_node_QMARK_,entity_shape))
,cljs.core.take.cljs$core$IFn$_invoke$arity$2((3),badges)))].join(''):null);
var full_label = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("atlas-ui.graph.node","label","atlas-ui.graph.node/label",1764673194).cljs$core$IFn$_invoke$arity$1(node)),(function (){var or__5002__auto__ = badge_text;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return "";
}
})()].join('');
var truncated_label = atlas_ui.graph.truncate_label(full_label,(18));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"identity","identity",1647396035),new cljs.core.Keyword(null,"selected","selected",574897764),new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"search-match","search-match",812229448),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"highlighted","highlighted",1723498733),new cljs.core.Keyword(null,"opacity","opacity",397153780),new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.Keyword(null,"negated","negated",-273117033),new cljs.core.Keyword(null,"fullLabel","fullLabel",2124644760)],[new cljs.core.Keyword("atlas-ui.graph.node","identity","atlas-ui.graph.node/identity",1626823993).cljs$core$IFn$_invoke$arity$1(node),cljs.core.str.cljs$core$IFn$_invoke$arity$1(is_selected),color,cljs.core.str.cljs$core$IFn$_invoke$arity$1(matches_search),cljs.core.name(new cljs.core.Keyword("atlas-ui.graph.node","type","atlas-ui.graph.node/type",1053813014).cljs$core$IFn$_invoke$arity$1(node)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("atlas-ui.graph.node","id","atlas-ui.graph.node/id",-1392721478).cljs$core$IFn$_invoke$arity$1(node),highlighted_entity_id)),((((cljs.core.seq(search_term)) && ((!(matches_search)))))?(opacity * 0.3):opacity),truncated_label,atlas_ui.id.id__GT_string(new cljs.core.Keyword("atlas-ui.graph.node","id","atlas-ui.graph.node/id",-1392721478).cljs$core$IFn$_invoke$arity$1(node)),shape,cljs.core.str.cljs$core$IFn$_invoke$arity$1(is_negated),full_label])], null);
})(),atlas_ui$graph$build_cytoscape_elements_$_iter__18397(cljs.core.rest(s__18398__$2)));
} else {
var G__18666 = cljs.core.rest(s__18398__$2);
s__18398__$1 = G__18666;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5480__auto__(new cljs.core.Keyword("atlas-ui.graph.data","all-nodes","atlas-ui.graph.data/all-nodes",187343157).cljs$core$IFn$_invoke$arity$1(graph_data));
})();
var visible_node_ids = cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__18385_SHARP_){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__18385_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377),new cljs.core.Keyword(null,"id","id",-1388402092)], null));
}),nodes));
var edges = (function (){var iter__5480__auto__ = (function atlas_ui$graph$build_cytoscape_elements_$_iter__18413(s__18414){
return (new cljs.core.LazySeq(null,(function (){
var s__18414__$1 = s__18414;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__18414__$1);
if(temp__5804__auto__){
var s__18414__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__18414__$2)){
var c__5478__auto__ = cljs.core.chunk_first(s__18414__$2);
var size__5479__auto__ = cljs.core.count(c__5478__auto__);
var b__18416 = cljs.core.chunk_buffer(size__5479__auto__);
if((function (){var i__18415 = (0);
while(true){
if((i__18415 < size__5479__auto__)){
var edge = cljs.core._nth(c__5478__auto__,i__18415);
var source_id = atlas_ui.id.id__GT_string(new cljs.core.Keyword("atlas-ui.graph.edge","source","atlas-ui.graph.edge/source",-454253894).cljs$core$IFn$_invoke$arity$1(edge));
var target_id = atlas_ui.id.id__GT_string(new cljs.core.Keyword("atlas-ui.graph.edge","target","atlas-ui.graph.edge/target",298493892).cljs$core$IFn$_invoke$arity$1(edge));
var edge_type = new cljs.core.Keyword("atlas-ui.graph.edge","type","atlas-ui.graph.edge/type",1052485841).cljs$core$IFn$_invoke$arity$1(edge);
if(((cljs.core.contains_QMARK_(visible_node_ids,source_id)) && (((cljs.core.contains_QMARK_(visible_node_ids,target_id)) && (cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(source_id,target_id)))))){
cljs.core.chunk_append(b__18416,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"source","source",-433931539),source_id,new cljs.core.Keyword(null,"target","target",253001721),target_id,new cljs.core.Keyword(null,"edge-type","edge-type",1113487045),cljs.core.name(edge_type),new cljs.core.Keyword(null,"edge-label","edge-label",1582257813),(function (){var G__18423 = edge_type;
var G__18423__$1 = (((G__18423 instanceof cljs.core.Keyword))?G__18423.fqn:null);
switch (G__18423__$1) {
case "membership":
return "has";

break;
case "dependency":
return "uses";

break;
default:
return "";

}
})(),new cljs.core.Keyword(null,"color","color",1011675173),atlas_ui.colors_v2.edge_color(edge_type)], null)], null));

var G__18717 = (i__18415 + (1));
i__18415 = G__18717;
continue;
} else {
var G__18718 = (i__18415 + (1));
i__18415 = G__18718;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__18416),atlas_ui$graph$build_cytoscape_elements_$_iter__18413(cljs.core.chunk_rest(s__18414__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__18416),null);
}
} else {
var edge = cljs.core.first(s__18414__$2);
var source_id = atlas_ui.id.id__GT_string(new cljs.core.Keyword("atlas-ui.graph.edge","source","atlas-ui.graph.edge/source",-454253894).cljs$core$IFn$_invoke$arity$1(edge));
var target_id = atlas_ui.id.id__GT_string(new cljs.core.Keyword("atlas-ui.graph.edge","target","atlas-ui.graph.edge/target",298493892).cljs$core$IFn$_invoke$arity$1(edge));
var edge_type = new cljs.core.Keyword("atlas-ui.graph.edge","type","atlas-ui.graph.edge/type",1052485841).cljs$core$IFn$_invoke$arity$1(edge);
if(((cljs.core.contains_QMARK_(visible_node_ids,source_id)) && (((cljs.core.contains_QMARK_(visible_node_ids,target_id)) && (cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(source_id,target_id)))))){
return cljs.core.cons(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"source","source",-433931539),source_id,new cljs.core.Keyword(null,"target","target",253001721),target_id,new cljs.core.Keyword(null,"edge-type","edge-type",1113487045),cljs.core.name(edge_type),new cljs.core.Keyword(null,"edge-label","edge-label",1582257813),(function (){var G__18424 = edge_type;
var G__18424__$1 = (((G__18424 instanceof cljs.core.Keyword))?G__18424.fqn:null);
switch (G__18424__$1) {
case "membership":
return "has";

break;
case "dependency":
return "uses";

break;
default:
return "";

}
})(),new cljs.core.Keyword(null,"color","color",1011675173),atlas_ui.colors_v2.edge_color(edge_type)], null)], null),atlas_ui$graph$build_cytoscape_elements_$_iter__18413(cljs.core.rest(s__18414__$2)));
} else {
var G__18720 = cljs.core.rest(s__18414__$2);
s__18414__$1 = G__18720;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5480__auto__(new cljs.core.Keyword("atlas-ui.graph.data","edges","atlas-ui.graph.data/edges",-707560193).cljs$core$IFn$_invoke$arity$1(graph_data));
})();
var _ = console.log("\uD83D\uDCCA Edges:",cljs.core.count(edges),"visible (",cljs.core.count(cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__18386_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("dependency",cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__18386_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377),new cljs.core.Keyword(null,"edge-type","edge-type",1113487045)], null)));
}),edges)),"dependency,",cljs.core.count(cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__18387_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("membership",cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__18387_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377),new cljs.core.Keyword(null,"edge-type","edge-type",1113487045)], null)));
}),edges)),"membership)");
return cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"nodes","nodes",-2099585805),nodes,new cljs.core.Keyword(null,"edges","edges",-694791395),edges], null));
});
atlas_ui.graph.legend_focus_node_ids = (function atlas_ui$graph$legend_focus_node_ids(graph_data,legend_focus){
var G__18429 = new cljs.core.Keyword(null,"kind","kind",-717265803).cljs$core$IFn$_invoke$arity$1(legend_focus);
var G__18429__$1 = (((G__18429 instanceof cljs.core.Keyword))?G__18429.fqn:null);
switch (G__18429__$1) {
case "entity-type":
return cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("atlas-ui.graph.node","id","atlas-ui.graph.node/id",-1392721478),cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (entity){
return cljs.core.contains_QMARK_(new cljs.core.Keyword("atlas-ui.graph.node","identity","atlas-ui.graph.node/identity",1626823993).cljs$core$IFn$_invoke$arity$1(entity),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(legend_focus));
}),new cljs.core.Keyword("atlas-ui.graph.data","entities","atlas-ui.graph.data/entities",-1980533303).cljs$core$IFn$_invoke$arity$1(graph_data))));

break;
case "aspect-namespace":
return cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("atlas-ui.graph.node","id","atlas-ui.graph.node/id",-1392721478),cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (aspect){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(new cljs.core.Keyword("atlas-ui.graph.node","id","atlas-ui.graph.node/id",-1392721478).cljs$core$IFn$_invoke$arity$1(aspect)),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(legend_focus));
}),new cljs.core.Keyword("atlas-ui.graph.data","aspects","atlas-ui.graph.data/aspects",1960033811).cljs$core$IFn$_invoke$arity$1(graph_data))));

break;
default:
return cljs.core.PersistentHashSet.EMPTY;

}
});
atlas_ui.graph.apply_pinned_BANG_ = (function atlas_ui$graph$apply_pinned_BANG_(cy,graph_data,highlighted_entity_id,highlighted_aspect_id,legend_focus){
var all_elements = cy.elements();
var focus_ids = (cljs.core.truth_(highlighted_entity_id)?cljs.core.PersistentHashSet.createAsIfByAssoc([highlighted_entity_id]):(cljs.core.truth_(highlighted_aspect_id)?cljs.core.PersistentHashSet.createAsIfByAssoc([highlighted_aspect_id]):((cljs.core.seq(legend_focus))?atlas_ui.graph.legend_focus_node_ids(graph_data,legend_focus):cljs.core.PersistentHashSet.EMPTY
)));
var focus_set = cljs.core.set(focus_ids);
all_elements.removeClass("pinned");

all_elements.removeClass("pinned-dim");

if(cljs.core.seq(focus_set)){
var focus_nodes = cy.nodes().filter((function (ele){
return cljs.core.contains_QMARK_(focus_set,atlas_ui.id.string__GT_id(ele.data("id")));
}));
var connected_edges = focus_nodes.connectedEdges();
var connected_nodes = connected_edges.connectedNodes();
var pinned = focus_nodes.union(connected_edges).union(connected_nodes);
var to_dim = all_elements.difference(pinned);
pinned.addClass("pinned");

return to_dim.addClass("pinned-dim");
} else {
return null;
}
});
atlas_ui.graph.cytoscape_style = (function atlas_ui$graph$cytoscape_style(){

return cljs.core.clj__GT_js(new cljs.core.PersistentVector(null, 17, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"selector","selector",762528866),"node",new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"text-halign","text-halign",-235553725),new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"font-size","font-size",-1847940346),new cljs.core.Keyword(null,"font-weight","font-weight",2085804583),new cljs.core.Keyword(null,"text-valign","text-valign",1610902696),new cljs.core.Keyword(null,"background-color","background-color",570434026),new cljs.core.Keyword(null,"width","width",-384071477),new cljs.core.Keyword(null,"border-opacity","border-opacity",-1046826610),new cljs.core.Keyword(null,"text-max-width","text-max-width",365808495),new cljs.core.Keyword(null,"border-width","border-width",-1512605390),new cljs.core.Keyword(null,"text-wrap","text-wrap",1566347251),new cljs.core.Keyword(null,"opacity","opacity",397153780),new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.Keyword(null,"border-color","border-color",-2059162761),new cljs.core.Keyword(null,"transition-property","transition-property",2036650935),new cljs.core.Keyword(null,"transition-duration","transition-duration",85784092),new cljs.core.Keyword(null,"font-family","font-family",-667419874),new cljs.core.Keyword(null,"height","height",1025178622)],["center","#1f2937","12px","500","center","data(color)","70px","0.3","100px","2px","wrap","data(opacity)","data(label)","data(shape)","#9ca3af","background-color, opacity, border-color, border-width","0.3s","system-ui, -apple-system, sans-serif","70px"])], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"selector","selector",762528866),"node[type='aspect']",new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"width","width",-384071477),"60px",new cljs.core.Keyword(null,"height","height",1025178622),"60px",new cljs.core.Keyword(null,"shape","shape",1190694006),"ellipse",new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"11px",new cljs.core.Keyword(null,"border-width","border-width",-1512605390),"2px"], null)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"selector","selector",762528866),"node[type='entity']",new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"width","width",-384071477),"80px",new cljs.core.Keyword(null,"height","height",1025178622),"70px",new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"12px",new cljs.core.Keyword(null,"border-width","border-width",-1512605390),"2px"], null)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"selector","selector",762528866),"node[type='aspect'][selected='true']",new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"border-width","border-width",-1512605390),"4px",new cljs.core.Keyword(null,"border-color","border-color",-2059162761),"#8b5cf6",new cljs.core.Keyword(null,"border-opacity","border-opacity",-1046826610),"1.0",new cljs.core.Keyword(null,"border-style","border-style",-485574304),"solid"], null)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"selector","selector",762528866),"node[type='aspect'][negated='true']",new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"border-width","border-width",-1512605390),"4px",new cljs.core.Keyword(null,"border-color","border-color",-2059162761),"#ef4444",new cljs.core.Keyword(null,"border-opacity","border-opacity",-1046826610),"1.0",new cljs.core.Keyword(null,"border-style","border-style",-485574304),"solid"], null)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"selector","selector",762528866),"node[type='entity'][highlighted='true']",new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"border-width","border-width",-1512605390),"4px",new cljs.core.Keyword(null,"border-color","border-color",-2059162761),"#f59e0b",new cljs.core.Keyword(null,"border-opacity","border-opacity",-1046826610),"1.0",new cljs.core.Keyword(null,"border-style","border-style",-485574304),"solid"], null)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"selector","selector",762528866),"node.pinned",new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"border-width","border-width",-1512605390),"3px",new cljs.core.Keyword(null,"border-color","border-color",-2059162761),"#f59e0b",new cljs.core.Keyword(null,"border-opacity","border-opacity",-1046826610),"0.9"], null)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"selector","selector",762528866),"node.pinned-dim",new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"opacity","opacity",397153780),"0.15",new cljs.core.Keyword(null,"text-opacity","text-opacity",-124349139),"0.15"], null)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"selector","selector",762528866),"node.dimmed",new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"opacity","opacity",397153780),"0.15",new cljs.core.Keyword(null,"text-opacity","text-opacity",-124349139),"0.15"], null)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"selector","selector",762528866),"node.highlighted",new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"opacity","opacity",397153780),"1.0",new cljs.core.Keyword(null,"text-opacity","text-opacity",-124349139),"1.0",new cljs.core.Keyword(null,"border-width","border-width",-1512605390),"3px",new cljs.core.Keyword(null,"border-color","border-color",-2059162761),"#3b82f6",new cljs.core.Keyword(null,"border-opacity","border-opacity",-1046826610),"0.8"], null)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"selector","selector",762528866),"edge[edge-type='membership']",new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"text-background-color","text-background-color",-53196508),new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"font-size","font-size",-1847940346),new cljs.core.Keyword(null,"line-color","line-color",1331573993),new cljs.core.Keyword(null,"text-background-opacity","text-background-opacity",-669179670),new cljs.core.Keyword(null,"width","width",-384071477),new cljs.core.Keyword(null,"text-opacity","text-opacity",-124349139),new cljs.core.Keyword(null,"target-arrow-color","target-arrow-color",-2103311276),new cljs.core.Keyword(null,"opacity","opacity",397153780),new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.Keyword(null,"arrow-scale","arrow-scale",95071413),new cljs.core.Keyword(null,"curve-style","curve-style",-1780785834),new cljs.core.Keyword(null,"transition-property","transition-property",2036650935),new cljs.core.Keyword(null,"target-arrow-shape","target-arrow-shape",-599109893),new cljs.core.Keyword(null,"transition-duration","transition-duration",85784092),new cljs.core.Keyword(null,"line-style","line-style",1551007708),new cljs.core.Keyword(null,"text-background-padding","text-background-padding",-494061089)],["#ffffff","#6b7280","11px","#d1d5db","0.8","2px","0","#d1d5db","0.5","data(edge-label)","1.0","bezier","line-color, opacity, text-opacity","triangle","0.3s","solid","3px"])], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"selector","selector",762528866),"edge[edge-type='dependency']",new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"text-background-color","text-background-color",-53196508),new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"font-size","font-size",-1847940346),new cljs.core.Keyword(null,"font-weight","font-weight",2085804583),new cljs.core.Keyword(null,"line-color","line-color",1331573993),new cljs.core.Keyword(null,"text-background-opacity","text-background-opacity",-669179670),new cljs.core.Keyword(null,"width","width",-384071477),new cljs.core.Keyword(null,"text-opacity","text-opacity",-124349139),new cljs.core.Keyword(null,"target-arrow-color","target-arrow-color",-2103311276),new cljs.core.Keyword(null,"opacity","opacity",397153780),new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.Keyword(null,"arrow-scale","arrow-scale",95071413),new cljs.core.Keyword(null,"curve-style","curve-style",-1780785834),new cljs.core.Keyword(null,"transition-property","transition-property",2036650935),new cljs.core.Keyword(null,"target-arrow-shape","target-arrow-shape",-599109893),new cljs.core.Keyword(null,"transition-duration","transition-duration",85784092),new cljs.core.Keyword(null,"line-style","line-style",1551007708),new cljs.core.Keyword(null,"text-background-padding","text-background-padding",-494061089)],["#ffffff","#475569","12px","600","#94a3b8","0.9","3px","0","#94a3b8","0.7","data(edge-label)","1.2","bezier","line-color, opacity, text-opacity","triangle","0.3s","solid","4px"])], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"selector","selector",762528866),"edge:selected",new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"text-opacity","text-opacity",-124349139),"1.0"], null)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"selector","selector",762528866),"edge.highlighted",new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"width","width",-384071477),"4px",new cljs.core.Keyword(null,"opacity","opacity",397153780),"1.0",new cljs.core.Keyword(null,"text-opacity","text-opacity",-124349139),"1.0",new cljs.core.Keyword(null,"line-color","line-color",1331573993),"#3b82f6",new cljs.core.Keyword(null,"target-arrow-color","target-arrow-color",-2103311276),"#3b82f6",new cljs.core.Keyword(null,"z-index","z-index",1892827090),"999"], null)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"selector","selector",762528866),"edge.pinned",new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"width","width",-384071477),"4px",new cljs.core.Keyword(null,"opacity","opacity",397153780),"1.0",new cljs.core.Keyword(null,"text-opacity","text-opacity",-124349139),"1.0",new cljs.core.Keyword(null,"line-color","line-color",1331573993),"#f59e0b",new cljs.core.Keyword(null,"target-arrow-color","target-arrow-color",-2103311276),"#f59e0b",new cljs.core.Keyword(null,"z-index","z-index",1892827090),"998"], null)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"selector","selector",762528866),"edge.pinned-dim",new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opacity","opacity",397153780),"0.1"], null)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"selector","selector",762528866),"edge.dimmed",new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opacity","opacity",397153780),"0.1"], null)], null)], null));
});
/**
 * Creates a circular layout with aspects on the perimeter and entities in center.
 *   Aspects are grouped by type (tier, domain, protocol, etc.) for visual organization.
 */
atlas_ui.graph.circular_aspect_layout = (function atlas_ui$graph$circular_aspect_layout(cy){
var nodes = cy.nodes();
var all_nodes = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(nodes.jsons(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var aspect_nodes = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__18450_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("aspect",cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__18450_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377),new cljs.core.Keyword(null,"type","type",1174270348)], null)));
}),all_nodes);
var entity_nodes = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__18451_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("entity",cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__18451_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377),new cljs.core.Keyword(null,"type","type",1174270348)], null)));
}),all_nodes);
var aspect_groups = cljs.core.group_by((function (node){
var id = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(node,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377),new cljs.core.Keyword(null,"id","id",-1388402092)], null));
return cljs.core.first(clojure.string.split.cljs$core$IFn$_invoke$arity$2(id,/\//));
}),aspect_nodes);
var extent = cy.extent();
var viewport_width = (extent.x2 - extent.x1);
var viewport_height = (extent.y2 - extent.y1);
var center_x = (viewport_width / (2));
var center_y = (viewport_height / (2));
var min_dimension = (function (){var x__5090__auto__ = viewport_width;
var y__5091__auto__ = viewport_height;
return ((x__5090__auto__ < y__5091__auto__) ? x__5090__auto__ : y__5091__auto__);
})();
var outer_radius = (2.42 * min_dimension);
var inner_radius = (0.35 * min_dimension);
var aspect_positions = (function (){var group_order = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(cljs.core.keys(aspect_groups));
var total_aspects = cljs.core.count(aspect_nodes);
var angle_step = (((2) * Math.PI) / total_aspects);
var groups = group_order;
var current_angle = (0);
var positions = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(cljs.core.empty_QMARK_(groups)){
return positions;
} else {
var group = cljs.core.first(groups);
var group_aspects = cljs.core.get.cljs$core$IFn$_invoke$arity$2(aspect_groups,group);
var group_positions = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (groups,current_angle,positions,group,group_aspects,group_order,total_aspects,angle_step,nodes,all_nodes,aspect_nodes,entity_nodes,aspect_groups,extent,viewport_width,viewport_height,center_x,center_y,min_dimension,outer_radius,inner_radius){
return (function (idx,aspect){
var angle = (current_angle + (idx * angle_step));
var x = (center_x + (outer_radius * Math.cos(angle)));
var y = (center_y + (outer_radius * Math.sin(angle)));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(aspect,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377),new cljs.core.Keyword(null,"id","id",-1388402092)], null)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"x","x",2099068185),x,new cljs.core.Keyword(null,"y","y",-1757859776),y], null)], null);
});})(groups,current_angle,positions,group,group_aspects,group_order,total_aspects,angle_step,nodes,all_nodes,aspect_nodes,entity_nodes,aspect_groups,extent,viewport_width,viewport_height,center_x,center_y,min_dimension,outer_radius,inner_radius))
,group_aspects));
var G__18732 = cljs.core.rest(groups);
var G__18733 = (current_angle + (cljs.core.count(group_aspects) * angle_step));
var G__18734 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([positions,group_positions], 0));
groups = G__18732;
current_angle = G__18733;
positions = G__18734;
continue;
}
break;
}
})();
var entity_positions = (function (){var num_entities = cljs.core.count(entity_nodes);
var entities_per_ring = (4);
var num_rings = Math.ceil((num_entities / entities_per_ring));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (idx,entity){
var ring = Math.floor((idx / entities_per_ring));
var pos_in_ring = cljs.core.mod(idx,entities_per_ring);
var total_in_ring = (function (){var x__5090__auto__ = entities_per_ring;
var y__5091__auto__ = (num_entities - (ring * entities_per_ring));
return ((x__5090__auto__ < y__5091__auto__) ? x__5090__auto__ : y__5091__auto__);
})();
var ring_radius = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(num_rings,(1)))?(inner_radius * 0.3):((inner_radius * 0.2) + ((inner_radius * 3.8) * (ring / (num_rings - (1))))));
var angle = ((((2) * Math.PI) * (pos_in_ring / total_in_ring)) + ((ring * Math.PI) * 0.2));
var x = (center_x + (ring_radius * Math.cos(angle)));
var y = (center_y + (ring_radius * Math.sin(angle)));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(entity,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377),new cljs.core.Keyword(null,"id","id",-1388402092)], null)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"x","x",2099068185),x,new cljs.core.Keyword(null,"y","y",-1757859776),y], null)], null);
}),entity_nodes));
})();
var seq__18470_18750 = cljs.core.seq(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([aspect_positions,entity_positions], 0)));
var chunk__18471_18751 = null;
var count__18472_18752 = (0);
var i__18473_18753 = (0);
while(true){
if((i__18473_18753 < count__18472_18752)){
var vec__18484_18754 = chunk__18471_18751.cljs$core$IIndexed$_nth$arity$2(null,i__18473_18753);
var node_id_18755 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18484_18754,(0),null);
var pos_18756 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18484_18754,(1),null);
var temp__5804__auto___18757 = cy.getElementById(node_id_18755);
if(cljs.core.truth_(temp__5804__auto___18757)){
var node_18758 = temp__5804__auto___18757;
node_18758.position(cljs.core.clj__GT_js(pos_18756));
} else {
}


var G__18759 = seq__18470_18750;
var G__18760 = chunk__18471_18751;
var G__18761 = count__18472_18752;
var G__18762 = (i__18473_18753 + (1));
seq__18470_18750 = G__18759;
chunk__18471_18751 = G__18760;
count__18472_18752 = G__18761;
i__18473_18753 = G__18762;
continue;
} else {
var temp__5804__auto___18763 = cljs.core.seq(seq__18470_18750);
if(temp__5804__auto___18763){
var seq__18470_18764__$1 = temp__5804__auto___18763;
if(cljs.core.chunked_seq_QMARK_(seq__18470_18764__$1)){
var c__5525__auto___18765 = cljs.core.chunk_first(seq__18470_18764__$1);
var G__18770 = cljs.core.chunk_rest(seq__18470_18764__$1);
var G__18771 = c__5525__auto___18765;
var G__18772 = cljs.core.count(c__5525__auto___18765);
var G__18773 = (0);
seq__18470_18750 = G__18770;
chunk__18471_18751 = G__18771;
count__18472_18752 = G__18772;
i__18473_18753 = G__18773;
continue;
} else {
var vec__18491_18774 = cljs.core.first(seq__18470_18764__$1);
var node_id_18775 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18491_18774,(0),null);
var pos_18776 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18491_18774,(1),null);
var temp__5804__auto___18777__$1 = cy.getElementById(node_id_18775);
if(cljs.core.truth_(temp__5804__auto___18777__$1)){
var node_18778 = temp__5804__auto___18777__$1;
node_18778.position(cljs.core.clj__GT_js(pos_18776));
} else {
}


var G__18779 = cljs.core.next(seq__18470_18764__$1);
var G__18780 = null;
var G__18781 = (0);
var G__18782 = (0);
seq__18470_18750 = G__18779;
chunk__18471_18751 = G__18780;
count__18472_18752 = G__18781;
i__18473_18753 = G__18782;
continue;
}
} else {
}
}
break;
}

setTimeout((function (){
return cy.fit(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"padding","padding",1660304693),(60)], null)));
}),(200));

return console.log("\u00F0\u0178\u017D\u00AF Circular layout applied:","\n  Viewport:",(viewport_width | (0)),"x",(viewport_height | (0)),"\n  Center: (",(center_x | (0)),",",(center_y | (0)),")","\n  Outer radius:",(outer_radius | (0)),"px","\n  Inner radius:",(inner_radius | (0)),"px (EXPANDED!)","\n  Aspects:",cljs.core.count(aspect_nodes),"in",cljs.core.count(aspect_groups),"groups","\n  Entities:",cljs.core.count(entity_nodes),"in",atlas_ui.graph.num_rings,"rings (",atlas_ui.graph.entities_per_ring,"per ring)");
});
atlas_ui.graph.init_cytoscape_BANG_ = (function atlas_ui$graph$init_cytoscape_BANG_(container,elements,graph_data,lens,on_toggle_aspect,on_click_entity,on_click_aspect){
var layout_config = (cljs.core.truth_(lens)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),"grid",new cljs.core.Keyword(null,"animate","animate",1850194573),true,new cljs.core.Keyword(null,"animationDuration","animationDuration",-322932146),(500),new cljs.core.Keyword(null,"avoidOverlap","avoidOverlap",-2113241329),true,new cljs.core.Keyword(null,"avoidOverlapPadding","avoidOverlapPadding",2097358454),(100),new cljs.core.Keyword(null,"condense","condense",-441962794),false], null),new cljs.core.Keyword(null,"layout-config","layout-config",-1439964126).cljs$core$IFn$_invoke$arity$1(lens)], 0)):new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"name","name",1843675177),"preset",new cljs.core.Keyword(null,"animate","animate",1850194573),false,new cljs.core.Keyword(null,"fit","fit",869444807),true,new cljs.core.Keyword(null,"padding","padding",1660304693),(50)], null));
var cy = module$node_modules$cytoscape$dist$cytoscape_cjs(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"container","container",-1736937707),container,new cljs.core.Keyword(null,"elements","elements",657646735),elements,new cljs.core.Keyword(null,"style","style",-496642736),atlas_ui.graph.cytoscape_style(),new cljs.core.Keyword(null,"layout","layout",-2120940921),layout_config,new cljs.core.Keyword(null,"minZoom","minZoom",1002989305),0.2,new cljs.core.Keyword(null,"maxZoom","maxZoom",566190639),(3),new cljs.core.Keyword(null,"wheelSensitivity","wheelSensitivity",338922130),0.2], null)));
console.log("\uD83C\uDFA8 Using layout:",(cljs.core.truth_(lens)?"grid (lens mode)":"circular (target view)"));

if(cljs.core.truth_(lens)){
} else {
setTimeout((function (){
return atlas_ui.graph.circular_aspect_layout(cy);
}),(100));
}

cy.on("tap","node",(function (evt){
try{var node = evt.target;
var node_data = node.data();
var node_id = node_data.id;
var node_type = node_data.type;
var node_label = node_data.label;
var shift_key_QMARK_ = evt.originalEvent.shiftKey;
console.log("Clicked node:",node_id,"type:",node_type,"shift:",shift_key_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(node_type,"aspect")){
var G__18510 = atlas_ui.id.string__GT_id(node_id);
var G__18511 = shift_key_QMARK_;
return (on_click_aspect.cljs$core$IFn$_invoke$arity$2 ? on_click_aspect.cljs$core$IFn$_invoke$arity$2(G__18510,G__18511) : on_click_aspect.call(null,G__18510,G__18511));
} else {
var entity_id = atlas_ui.id.string__GT_id(node_id);
var full_entity = cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__18501_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("atlas-ui.graph.node","id","atlas-ui.graph.node/id",-1392721478).cljs$core$IFn$_invoke$arity$1(p1__18501_SHARP_),entity_id);
}),new cljs.core.Keyword("atlas-ui.graph.data","all-nodes","atlas-ui.graph.data/all-nodes",187343157).cljs$core$IFn$_invoke$arity$1(graph_data)));
return (on_click_entity.cljs$core$IFn$_invoke$arity$1 ? on_click_entity.cljs$core$IFn$_invoke$arity$1(full_entity) : on_click_entity.call(null,full_entity));
}
}catch (e18506){if((e18506 instanceof Error)){
var e = e18506;
return console.error("ERROR:",e);
} else {
throw e18506;

}
}}));

cy.on("tap",(function (evt){
if((evt.target === cy)){
console.log("Clicked background");

(on_click_entity.cljs$core$IFn$_invoke$arity$1 ? on_click_entity.cljs$core$IFn$_invoke$arity$1(null) : on_click_entity.call(null,null));

return (on_click_aspect.cljs$core$IFn$_invoke$arity$1 ? on_click_aspect.cljs$core$IFn$_invoke$arity$1(null) : on_click_aspect.call(null,null));
} else {
return null;
}
}));

cy.on("dbltap","node",(function (evt){
var node = evt.target;
var connected_edges = node.connectedEdges();
var connected_nodes = connected_edges.connectedNodes();
var focus_collection = node.union(connected_edges).union(connected_nodes);
console.log("\u00F0\u0178\u017D\u00AF Double-click focus on node");

cy.fit(focus_collection,(50));

focus_collection.addClass("highlighted");

cy.elements().difference(focus_collection).addClass("dimmed");

return setTimeout((function (){
cy.elements().removeClass("highlighted");

return cy.elements().removeClass("dimmed");
}),(3000));
}));

cy.on("mouseover","node",(function (evt){
var node = evt.target;
var connected_edges = node.connectedEdges();
var connected_nodes = connected_edges.connectedNodes();
var all_elements = cy.elements();
var pinned = cy.elements(".pinned");
var focus_collection = node.union(connected_edges).union(connected_nodes);
var keep_visible = focus_collection.union(pinned);
node.addClass("highlighted");

connected_edges.addClass("highlighted");

connected_nodes.addClass("highlighted");

var to_dim = all_elements.difference(keep_visible);
return to_dim.addClass("dimmed");
}));

cy.on("mouseout","node",(function (evt){
cy.elements().removeClass("highlighted");

return cy.elements().removeClass("dimmed");
}));

cy.on("mouseover","node",(function (evt){
var node = evt.target;
var full_label = node.data("fullLabel");
var node_id = node.data("id");
var node_type = node.data("type");
var identity = node.data("identity");
if(cljs.core.truth_(full_label)){
var identity_set = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(identity,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var aspects = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.keyword_QMARK_,identity_set);
var tooltip_html = ["<div style='padding:8px;background:white;border-radius:6px;box-shadow:0 2px 8px rgba(0,0,0,0.2);max-width:250px;'>","<div style='font-weight:600;margin-bottom:6px;color:#1f2937;'>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(full_label),"</div>","<div style='font-size:11px;color:#6b7280;margin-bottom:4px;'>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_id),"</div>",((cljs.core.seq(aspects))?["<div style='font-size:10px;color:#9ca3af;margin-top:6px;'>",clojure.string.join.cljs$core$IFn$_invoke$arity$2(", ",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.name,cljs.core.take.cljs$core$IFn$_invoke$arity$2((5),aspects))),"</div>"].join(''):null),"</div>"].join('');
var temp__5804__auto___18796 = document.getElementById("cy-tooltip");
if(cljs.core.truth_(temp__5804__auto___18796)){
var existing_tooltip_18798 = temp__5804__auto___18796;
existing_tooltip_18798.remove();
} else {
}

var tooltip = document.createElement("div");
(tooltip.id = "cy-tooltip");

(tooltip.innerHTML = tooltip_html);

(tooltip.style.position = "absolute");

(tooltip.style.zIndex = "10000");

(tooltip.style.pointerEvents = "none");

document.body.appendChild(tooltip);

return cy.on("mousemove","node",(function (move_evt){
var browser_evt = move_evt.originalEvent;
(tooltip.style.left = [cljs.core.str.cljs$core$IFn$_invoke$arity$1((browser_evt.pageX + (15))),"px"].join(''));

return (tooltip.style.top = [cljs.core.str.cljs$core$IFn$_invoke$arity$1((browser_evt.pageY + (15))),"px"].join(''));
}));
} else {
return null;
}
}));

cy.on("mouseout","node",(function (evt){
var temp__5804__auto___18799 = document.getElementById("cy-tooltip");
if(cljs.core.truth_(temp__5804__auto___18799)){
var tooltip_18800 = temp__5804__auto___18799;
tooltip_18800.remove();
} else {
}

return cy.off("mousemove","node");
}));

var update_zoom_labels_BANG__18801 = (function (){
var zoom = cy.zoom();
var nodes = cy.nodes();
if((zoom < 0.5)){
nodes.style("font-size","0px");

return nodes.style("text-opacity","0");
} else {
if((zoom < 1.0)){
nodes.style("font-size","10px");

return nodes.style("text-opacity","0.8");
} else {
nodes.style("font-size","12px");

return nodes.style("text-opacity","1.0");

}
}
});
update_zoom_labels_BANG__18801();

cy.on("zoom",update_zoom_labels_BANG__18801);

try{console.log("\u00E2\u0161\u00A0\u00EF\u00B8\uFFFD Minimap disabled for debugging edge overlap issue");
}catch (e18520){if((e18520 instanceof Error)){
var e_18802 = e18520;
console.warn("\u00E2\u0161\u00A0\u00EF\u00B8\uFFFD Navigator extension not available:",e_18802.message);
} else {
throw e18520;

}
}
var keyboard_handler_18805 = (function (evt){
var key = evt.key;
var ctrl_QMARK_ = evt.ctrlKey;
var shift_QMARK_ = evt.shiftKey;
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,"f")) && (((cljs.core.not(ctrl_QMARK_)) && (cljs.core.not(shift_QMARK_)))))){
evt.preventDefault();

cy.fit();

return console.log("\u00C3\u00A2\u00C5\u00A1\u00C2\u00A1 Keyboard: Fit to viewport");
} else {
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,"r")) && (((cljs.core.not(ctrl_QMARK_)) && (cljs.core.not(shift_QMARK_)))))){
evt.preventDefault();

cy.zoom(1.0);

cy.center();

return console.log("\u00C3\u00A2\u00C5\u00A1\u00C2\u00A1 Keyboard: Reset zoom");
} else {
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,"c")) && (((cljs.core.not(ctrl_QMARK_)) && (cljs.core.not(shift_QMARK_)))))){
evt.preventDefault();

var selected = cy.nodes(":selected");
if((selected.length > (0))){
cy.center(selected);

return console.log("\u00E2\u0161\u00A1 Keyboard: Center on selection");
} else {
return null;
}
} else {
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,"+")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,"=")))){
evt.preventDefault();

var current_zoom = cy.zoom();
cy.zoom((current_zoom * 1.2));

return console.log("\u00C3\u00A2\u00C5\u00A1\u00C2\u00A1 Keyboard: Zoom in");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,"-")){
evt.preventDefault();

var current_zoom = cy.zoom();
cy.zoom((current_zoom * 0.8));

return console.log("\u00E2\u0161\u00A1 Keyboard: Zoom out");
} else {
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,"h")) && (((cljs.core.not(ctrl_QMARK_)) && (cljs.core.not(shift_QMARK_)))))){
evt.preventDefault();

if(cljs.core.truth_(cy.elements().hasClass("dimmed"))){
cy.elements().removeClass("highlighted");

cy.elements().removeClass("dimmed");

return console.log("\u00E2\u0161\u00A1 Keyboard: Clear highlighting");
} else {
return console.log("\u00E2\u0161\u00A1 Keyboard: Hover a node to highlight");
}
} else {
return null;
}
}
}
}
}
}
});
document.addEventListener("keydown",keyboard_handler_18805);

cy.data("keyboardHandler",keyboard_handler_18805);

console.log("\u00E2\u0152\u00A8\u00EF\u00B8\uFFFD  Keyboard shortcuts enabled: F=fit, R=reset, C=center, +/-=zoom, H=toggle");

return cy;
});
atlas_ui.graph.update_colors_BANG_ = (function atlas_ui$graph$update_colors_BANG_(cy,graph_data,selections,negated_aspects,query_mode,min_score,highlighted_entity_id,highlighted_entity_aspects,highlighted_aspect_id,registry,hide_unmatched_QMARK_,search_term,legend_focus){
console.log("\u00F0\u0178\u017D\u00A8 UPDATE COLORS! selections:",cljs.core.clj__GT_js(selections),"mode:",query_mode,"highlighted:",highlighted_entity_id);

try{var elements_18806 = atlas_ui.graph.build_cytoscape_elements(graph_data,selections,negated_aspects,query_mode,min_score,highlighted_entity_id,highlighted_entity_aspects,registry,hide_unmatched_QMARK_,search_term);
var nodes_array_18807 = elements_18806.nodes;
var edges_array_18808 = elements_18806.edges;
console.log("   Colored",nodes_array_18807.length,"nodes");

var seq__18533_18809 = cljs.core.seq(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(nodes_array_18807,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
var chunk__18534_18810 = null;
var count__18535_18811 = (0);
var i__18536_18812 = (0);
while(true){
if((i__18536_18812 < count__18535_18811)){
var node_data_18813 = chunk__18534_18810.cljs$core$IIndexed$_nth$arity$2(null,i__18536_18812);
var node_id_18814 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(node_data_18813,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377),new cljs.core.Keyword(null,"id","id",-1388402092)], null));
var color_18815 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(node_data_18813,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377),new cljs.core.Keyword(null,"color","color",1011675173)], null));
var opacity_18816 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(node_data_18813,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377),new cljs.core.Keyword(null,"opacity","opacity",397153780)], null));
var selected_18817 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(node_data_18813,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377),new cljs.core.Keyword(null,"selected","selected",574897764)], null));
var negated_18818 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(node_data_18813,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377),new cljs.core.Keyword(null,"negated","negated",-273117033)], null));
var highlighted_18819 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(node_data_18813,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377),new cljs.core.Keyword(null,"highlighted","highlighted",1723498733)], null));
var search_match_18820 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(node_data_18813,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377),new cljs.core.Keyword(null,"search-match","search-match",812229448)], null));
var node_18821 = cy.getElementById(node_id_18814);
if(cljs.core.truth_(node_18821)){
node_18821.data("color",color_18815);

node_18821.data("opacity",opacity_18816);

node_18821.data("selected",selected_18817);

node_18821.data("negated",negated_18818);

node_18821.data("highlighted",highlighted_18819);

node_18821.data("search-match",search_match_18820);

var temp__5804__auto___18822 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(node_data_18813,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377),new cljs.core.Keyword(null,"shape","shape",1190694006)], null));
if(cljs.core.truth_(temp__5804__auto___18822)){
var shape_18823 = temp__5804__auto___18822;
node_18821.data("shape",shape_18823);
} else {
}
} else {
}


var G__18824 = seq__18533_18809;
var G__18825 = chunk__18534_18810;
var G__18826 = count__18535_18811;
var G__18827 = (i__18536_18812 + (1));
seq__18533_18809 = G__18824;
chunk__18534_18810 = G__18825;
count__18535_18811 = G__18826;
i__18536_18812 = G__18827;
continue;
} else {
var temp__5804__auto___18828 = cljs.core.seq(seq__18533_18809);
if(temp__5804__auto___18828){
var seq__18533_18829__$1 = temp__5804__auto___18828;
if(cljs.core.chunked_seq_QMARK_(seq__18533_18829__$1)){
var c__5525__auto___18830 = cljs.core.chunk_first(seq__18533_18829__$1);
var G__18831 = cljs.core.chunk_rest(seq__18533_18829__$1);
var G__18832 = c__5525__auto___18830;
var G__18833 = cljs.core.count(c__5525__auto___18830);
var G__18834 = (0);
seq__18533_18809 = G__18831;
chunk__18534_18810 = G__18832;
count__18535_18811 = G__18833;
i__18536_18812 = G__18834;
continue;
} else {
var node_data_18835 = cljs.core.first(seq__18533_18829__$1);
var node_id_18836 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(node_data_18835,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377),new cljs.core.Keyword(null,"id","id",-1388402092)], null));
var color_18837 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(node_data_18835,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377),new cljs.core.Keyword(null,"color","color",1011675173)], null));
var opacity_18838 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(node_data_18835,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377),new cljs.core.Keyword(null,"opacity","opacity",397153780)], null));
var selected_18839 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(node_data_18835,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377),new cljs.core.Keyword(null,"selected","selected",574897764)], null));
var negated_18840 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(node_data_18835,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377),new cljs.core.Keyword(null,"negated","negated",-273117033)], null));
var highlighted_18841 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(node_data_18835,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377),new cljs.core.Keyword(null,"highlighted","highlighted",1723498733)], null));
var search_match_18842 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(node_data_18835,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377),new cljs.core.Keyword(null,"search-match","search-match",812229448)], null));
var node_18843 = cy.getElementById(node_id_18836);
if(cljs.core.truth_(node_18843)){
node_18843.data("color",color_18837);

node_18843.data("opacity",opacity_18838);

node_18843.data("selected",selected_18839);

node_18843.data("negated",negated_18840);

node_18843.data("highlighted",highlighted_18841);

node_18843.data("search-match",search_match_18842);

var temp__5804__auto___18844__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(node_data_18835,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377),new cljs.core.Keyword(null,"shape","shape",1190694006)], null));
if(cljs.core.truth_(temp__5804__auto___18844__$1)){
var shape_18845 = temp__5804__auto___18844__$1;
node_18843.data("shape",shape_18845);
} else {
}
} else {
}


var G__18846 = cljs.core.next(seq__18533_18829__$1);
var G__18847 = null;
var G__18848 = (0);
var G__18849 = (0);
seq__18533_18809 = G__18846;
chunk__18534_18810 = G__18847;
count__18535_18811 = G__18848;
i__18536_18812 = G__18849;
continue;
}
} else {
}
}
break;
}

var seq__18573_18850 = cljs.core.seq(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(edges_array_18808,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
var chunk__18574_18851 = null;
var count__18575_18852 = (0);
var i__18576_18853 = (0);
while(true){
if((i__18576_18853 < count__18575_18852)){
var edge_data_18854 = chunk__18574_18851.cljs$core$IIndexed$_nth$arity$2(null,i__18576_18853);
var source_18855 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(edge_data_18854,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377),new cljs.core.Keyword(null,"source","source",-433931539)], null));
var target_18856 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(edge_data_18854,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377),new cljs.core.Keyword(null,"target","target",253001721)], null));
var color_18857 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(edge_data_18854,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377),new cljs.core.Keyword(null,"color","color",1011675173)], null));
var edges_18858 = cy.edges(["[source='",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source_18855),"'][target='",cljs.core.str.cljs$core$IFn$_invoke$arity$1(target_18856),"']"].join(''));
if((edges_18858.length > (0))){
edges_18858.forEach(((function (seq__18573_18850,chunk__18574_18851,count__18575_18852,i__18576_18853,source_18855,target_18856,color_18857,edges_18858,edge_data_18854,elements_18806,nodes_array_18807,edges_array_18808){
return (function (edge){
return edge.data("color",color_18857);
});})(seq__18573_18850,chunk__18574_18851,count__18575_18852,i__18576_18853,source_18855,target_18856,color_18857,edges_18858,edge_data_18854,elements_18806,nodes_array_18807,edges_array_18808))
);
} else {
}


var G__18859 = seq__18573_18850;
var G__18860 = chunk__18574_18851;
var G__18861 = count__18575_18852;
var G__18862 = (i__18576_18853 + (1));
seq__18573_18850 = G__18859;
chunk__18574_18851 = G__18860;
count__18575_18852 = G__18861;
i__18576_18853 = G__18862;
continue;
} else {
var temp__5804__auto___18863 = cljs.core.seq(seq__18573_18850);
if(temp__5804__auto___18863){
var seq__18573_18864__$1 = temp__5804__auto___18863;
if(cljs.core.chunked_seq_QMARK_(seq__18573_18864__$1)){
var c__5525__auto___18865 = cljs.core.chunk_first(seq__18573_18864__$1);
var G__18866 = cljs.core.chunk_rest(seq__18573_18864__$1);
var G__18867 = c__5525__auto___18865;
var G__18868 = cljs.core.count(c__5525__auto___18865);
var G__18869 = (0);
seq__18573_18850 = G__18866;
chunk__18574_18851 = G__18867;
count__18575_18852 = G__18868;
i__18576_18853 = G__18869;
continue;
} else {
var edge_data_18870 = cljs.core.first(seq__18573_18864__$1);
var source_18871 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(edge_data_18870,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377),new cljs.core.Keyword(null,"source","source",-433931539)], null));
var target_18872 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(edge_data_18870,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377),new cljs.core.Keyword(null,"target","target",253001721)], null));
var color_18873 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(edge_data_18870,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377),new cljs.core.Keyword(null,"color","color",1011675173)], null));
var edges_18874 = cy.edges(["[source='",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source_18871),"'][target='",cljs.core.str.cljs$core$IFn$_invoke$arity$1(target_18872),"']"].join(''));
if((edges_18874.length > (0))){
edges_18874.forEach(((function (seq__18573_18850,chunk__18574_18851,count__18575_18852,i__18576_18853,source_18871,target_18872,color_18873,edges_18874,edge_data_18870,seq__18573_18864__$1,temp__5804__auto___18863,elements_18806,nodes_array_18807,edges_array_18808){
return (function (edge){
return edge.data("color",color_18873);
});})(seq__18573_18850,chunk__18574_18851,count__18575_18852,i__18576_18853,source_18871,target_18872,color_18873,edges_18874,edge_data_18870,seq__18573_18864__$1,temp__5804__auto___18863,elements_18806,nodes_array_18807,edges_array_18808))
);
} else {
}


var G__18875 = cljs.core.next(seq__18573_18864__$1);
var G__18876 = null;
var G__18877 = (0);
var G__18878 = (0);
seq__18573_18850 = G__18875;
chunk__18574_18851 = G__18876;
count__18575_18852 = G__18877;
i__18576_18853 = G__18878;
continue;
}
} else {
}
}
break;
}

return atlas_ui.graph.apply_pinned_BANG_(cy,graph_data,highlighted_entity_id,highlighted_aspect_id,legend_focus);
}catch (e18532){if((e18532 instanceof Error)){
var e = e18532;
return console.error("\u00E2\uFFFD\u0152 ERROR updating colors:",e);
} else {
throw e18532;

}
}});
atlas_ui.graph.graph_component = (function atlas_ui$graph$graph_component(graph_data,selections,negated_aspects,query_mode,min_score,registry,highlighted_entity_id,highlighted_entity_aspects,highlighted_aspect_id,hide_unmatched_QMARK_,search_term,lens,on_toggle_aspect,on_click_entity,on_click_aspect,legend_focus){
var cy_instance = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var container_id = "cy-container";
return reagent.core.create_class.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"component-did-mount","component-did-mount",-1126910518),(function (this$){
var container = document.getElementById(container_id);
var elements = atlas_ui.graph.build_cytoscape_elements(graph_data,selections,negated_aspects,query_mode,min_score,highlighted_entity_id,highlighted_entity_aspects,registry,hide_unmatched_QMARK_,search_term);
console.log("\u00F0\u0178\u201C\u0160 Graph mounted with multi-selection support");

cljs.core.reset_BANG_(cy_instance,atlas_ui.graph.init_cytoscape_BANG_(container,elements,graph_data,lens,on_toggle_aspect,on_click_entity,on_click_aspect));

if(cljs.core.truth_((function (){var or__5002__auto__ = cljs.core.seq(selections);
if(or__5002__auto__){
return or__5002__auto__;
} else {
var or__5002__auto____$1 = cljs.core.seq(negated_aspects);
if(or__5002__auto____$1){
return or__5002__auto____$1;
} else {
var or__5002__auto____$2 = highlighted_entity_id;
if(cljs.core.truth_(or__5002__auto____$2)){
return or__5002__auto____$2;
} else {
var or__5002__auto____$3 = highlighted_aspect_id;
if(cljs.core.truth_(or__5002__auto____$3)){
return or__5002__auto____$3;
} else {
return legend_focus;
}
}
}
}
})())){
return atlas_ui.graph.update_colors_BANG_(cljs.core.deref(cy_instance),graph_data,selections,negated_aspects,query_mode,min_score,highlighted_entity_id,highlighted_entity_aspects,highlighted_aspect_id,registry,hide_unmatched_QMARK_,search_term,legend_focus);
} else {
return null;
}
}),new cljs.core.Keyword(null,"component-did-update","component-did-update",-1468549173),(function (this$,prev_argv){
var curr_argv = reagent.core.argv(this$);
var curr_graph_data = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(curr_argv,(1));
var curr_selections = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(curr_argv,(2));
var curr_negated_aspects = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(curr_argv,(3));
var curr_query_mode = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(curr_argv,(4));
var curr_min_score = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(curr_argv,(5));
var curr_registry = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(curr_argv,(6));
var curr_highlighted_entity_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(curr_argv,(7));
var curr_highlighted_entity_aspects = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(curr_argv,(8));
var curr_highlighted_aspect_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(curr_argv,(9));
var curr_hide_unmatched_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(curr_argv,(10));
var curr_search_term = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(curr_argv,(11));
var curr_lens = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(curr_argv,(12));
var curr_legend_focus = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(curr_argv,(16));
var prev_graph_data = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(prev_argv,(1));
var prev_selections = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(prev_argv,(2));
var prev_negated_aspects = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(prev_argv,(3));
var prev_query_mode = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(prev_argv,(4));
var prev_min_score = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(prev_argv,(5));
var prev_highlighted_entity_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(prev_argv,(7));
var prev_highlighted_entity_aspects = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(prev_argv,(8));
var prev_highlighted_aspect_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(prev_argv,(9));
var prev_hide_unmatched_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(prev_argv,(10));
var prev_search_term = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(prev_argv,(11));
var prev_lens = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(prev_argv,(12));
var prev_legend_focus = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(prev_argv,(16));
var selections_changed_QMARK_ = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(prev_selections,curr_selections);
var negations_changed_QMARK_ = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(prev_negated_aspects,curr_negated_aspects);
var mode_changed_QMARK_ = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(prev_query_mode,curr_query_mode);
var min_score_changed_QMARK_ = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(prev_min_score,curr_min_score);
var graph_changed_QMARK_ = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(prev_graph_data,curr_graph_data);
var entity_highlight_changed_QMARK_ = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(prev_highlighted_entity_id,curr_highlighted_entity_id);
var aspect_highlight_changed_QMARK_ = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(prev_highlighted_entity_aspects,curr_highlighted_entity_aspects);
var highlighted_aspect_changed_QMARK_ = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(prev_highlighted_aspect_id,curr_highlighted_aspect_id);
var hide_changed_QMARK_ = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(prev_hide_unmatched_QMARK_,curr_hide_unmatched_QMARK_);
var search_changed_QMARK_ = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(prev_search_term,curr_search_term);
var lens_changed_QMARK_ = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(prev_lens,curr_lens);
var legend_focus_changed_QMARK_ = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(prev_legend_focus,curr_legend_focus);
if(cljs.core.truth_((function (){var and__5000__auto__ = cljs.core.deref(cy_instance);
if(cljs.core.truth_(and__5000__auto__)){
return ((selections_changed_QMARK_) || (((negations_changed_QMARK_) || (((mode_changed_QMARK_) || (((min_score_changed_QMARK_) || (((graph_changed_QMARK_) || (((entity_highlight_changed_QMARK_) || (((aspect_highlight_changed_QMARK_) || (((highlighted_aspect_changed_QMARK_) || (((hide_changed_QMARK_) || (((search_changed_QMARK_) || (((lens_changed_QMARK_) || (legend_focus_changed_QMARK_))))))))))))))))))))));
} else {
return and__5000__auto__;
}
})())){
var needs_rebuild_QMARK_ = (function (){var or__5002__auto__ = graph_changed_QMARK_;
if(or__5002__auto__){
return or__5002__auto__;
} else {
var or__5002__auto____$1 = hide_changed_QMARK_;
if(or__5002__auto____$1){
return or__5002__auto____$1;
} else {
var or__5002__auto____$2 = search_changed_QMARK_;
if(or__5002__auto____$2){
return or__5002__auto____$2;
} else {
var or__5002__auto____$3 = lens_changed_QMARK_;
if(or__5002__auto____$3){
return or__5002__auto____$3;
} else {
var and__5000__auto__ = curr_hide_unmatched_QMARK_;
if(cljs.core.truth_(and__5000__auto__)){
return ((selections_changed_QMARK_) || (((negations_changed_QMARK_) || (((mode_changed_QMARK_) || (min_score_changed_QMARK_))))));
} else {
return and__5000__auto__;
}
}
}
}
}
})();
console.log("\u00E2\u0153\u00A8 State changed, updating",(cljs.core.truth_(needs_rebuild_QMARK_)?"graph structure":"colors"));

if(cljs.core.truth_(needs_rebuild_QMARK_)){
var container = document.getElementById(container_id);
var elements = atlas_ui.graph.build_cytoscape_elements(curr_graph_data,curr_selections,curr_negated_aspects,curr_query_mode,curr_min_score,curr_highlighted_entity_id,curr_highlighted_entity_aspects,curr_registry,curr_hide_unmatched_QMARK_,curr_search_term);
cljs.core.deref(cy_instance).destroy();

cljs.core.reset_BANG_(cy_instance,atlas_ui.graph.init_cytoscape_BANG_(container,elements,curr_graph_data,curr_lens,on_toggle_aspect,on_click_entity,on_click_aspect));

if(cljs.core.truth_((function (){var or__5002__auto__ = curr_highlighted_entity_id;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
var or__5002__auto____$1 = curr_highlighted_aspect_id;
if(cljs.core.truth_(or__5002__auto____$1)){
return or__5002__auto____$1;
} else {
return curr_legend_focus;
}
}
})())){
return atlas_ui.graph.apply_pinned_BANG_(cljs.core.deref(cy_instance),curr_graph_data,curr_highlighted_entity_id,curr_highlighted_aspect_id,curr_legend_focus);
} else {
return null;
}
} else {
return atlas_ui.graph.update_colors_BANG_(cljs.core.deref(cy_instance),curr_graph_data,curr_selections,curr_negated_aspects,curr_query_mode,curr_min_score,curr_highlighted_entity_id,curr_highlighted_entity_aspects,curr_highlighted_aspect_id,curr_registry,curr_hide_unmatched_QMARK_,curr_search_term,curr_legend_focus);
}
} else {
return null;
}
}),new cljs.core.Keyword(null,"reagent-render","reagent-render",-985383853),(function (graph_data__$1,selections__$1,negated_aspects__$1,query_mode__$1,min_score__$1,registry__$1,highlighted_entity_id__$1,highlighted_entity_aspects__$1,highlighted_aspect_id__$1,hide_unmatched_QMARK___$1,search_term__$1,lens__$1,on_toggle_aspect__$1,on_click_entity__$1,on_click_aspect__$1,legend_focus__$1){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id","id",-1388402092),container_id,new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"width","width",-384071477),"100%",new cljs.core.Keyword(null,"height","height",1025178622),"100%",new cljs.core.Keyword(null,"background-color","background-color",570434026),"#f9fafb"], null)], null)], null);
})], null));
});

//# sourceMappingURL=atlas_ui.graph.js.map
