goog.provide('atlas.registry.lookup');
/**
 * Find the [identity value] pair for a given dev-id.
 * Delegates to atlas.query/find-by-dev-id.
 */
atlas.registry.lookup.fetch_by_dev_id = (function atlas$registry$lookup$fetch_by_dev_id(dev_id){
return atlas.query.find_by_dev_id(cljs.core.deref(atlas.registry.registry),dev_id);
});
atlas.registry.lookup.identity_for = (function atlas$registry$lookup$identity_for(dev_id){
return cljs.core.first(atlas.registry.lookup.fetch_by_dev_id(dev_id));
});
atlas.registry.lookup.props_for = (function atlas$registry$lookup$props_for(dev_id){
return cljs.core.second(atlas.registry.lookup.fetch_by_dev_id(dev_id));
});
atlas.registry.lookup.has_aspect_QMARK_ = (function atlas$registry$lookup$has_aspect_QMARK_(dev_id,aspect){
return cljs.core.contains_QMARK_(atlas.registry.lookup.identity_for(dev_id),aspect);
});
/**
 * Find all dev-ids with given aspect.
 * Delegates to atlas.query/find-dev-ids-with-aspect.
 */
atlas.registry.lookup.all_with_aspect = (function atlas$registry$lookup$all_with_aspect(aspect){
return atlas.query.find_dev_ids_with_aspect(cljs.core.deref(atlas.registry.registry),aspect);
});

//# sourceMappingURL=atlas.registry.lookup.js.map
