goog.provide('atlas_ui_v2.data');
/**
 * Extract all unique aspects from registry.
 * Returns set of namespaced keywords.
 */
atlas_ui_v2.data.extract_all_aspects = (function atlas_ui_v2$data$extract_all_aspects(registry){
return cljs.core.set(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.keyword_QMARK_,cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.identity,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.keys(registry)], 0))));
});
/**
 * Build hierarchical map of aspects grouped by namespace.
 * 
 * Input: registry
 * Output: {:domain #{:users :auth :scheduling}
 *          :tier #{:service :api :foundation}
 *          :protocol #{:oauth :user-repository}
 *          ...}
 */
atlas_ui_v2.data.build_aspects_map = (function atlas_ui_v2$data$build_aspects_map(registry){
var aspects = atlas_ui_v2.data.extract_all_aspects(registry);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map(),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__22398){
var vec__22399 = p__22398;
var ns_kw = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22399,(0),null);
var aspects_list = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22399,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns_kw,cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__22397_SHARP_){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.name(p1__22397_SHARP_));
}),aspects_list))], null);
}),cljs.core.group_by((function (p1__22396_SHARP_){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.namespace(p1__22396_SHARP_));
}),aspects)));
});
/**
 * Extract the atlas entity type from a compound identity.
 * Returns the :atlas/* keyword if present.
 */
atlas_ui_v2.data.extract_entity_type = (function atlas_ui_v2$data$extract_entity_type(compound_identity){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__22402_SHARP_){
return (((p1__22402_SHARP_ instanceof cljs.core.Keyword)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("atlas",cljs.core.namespace(p1__22402_SHARP_))));
}),compound_identity));
});
/**
 * Build hierarchical map of entities grouped by type.
 * 
 * Input: registry
 * Output: {:atlas/execution-function
 *            {:fn/find-users-by-language #{:tier/service :domain/users ...}
 *             :fn/refresh-oauth-token #{:tier/service :domain/google ...}}
 *          :atlas/structure-component
 *            {:component/db #{:tier/foundation :domain/users ...}}
 *          ...}
 */
atlas_ui_v2.data.build_entities_map = (function atlas_ui_v2$data$build_entities_map(registry){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map(),cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p__22430){
var vec__22431 = p__22430;
var entity_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22431,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22431,(1),null);
return entity_type;
}),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__22434){
var vec__22435 = p__22434;
var entity_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22435,(0),null);
var entries = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22435,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [entity_type,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map(),cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p__22438){
var vec__22439 = p__22438;
var dev_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22439,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22439,(1),null);
return dev_id;
}),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__22442){
var vec__22443 = p__22442;
var identity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22443,(0),null);
var props = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22443,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553).cljs$core$IFn$_invoke$arity$1(props),identity], null);
}),entries)))], null);
}),cljs.core.group_by((function (p__22446){
var vec__22447 = p__22446;
var identity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22447,(0),null);
var _props = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22447,(1),null);
return atlas_ui_v2.data.extract_entity_type(identity);
}),registry))));
});
/**
 * Count how many entities have each aspect.
 * Returns map of {aspect-keyword -> count}
 */
atlas_ui_v2.data.count_entities_by_aspect = (function atlas_ui_v2$data$count_entities_by_aspect(registry){
return cljs.core.frequencies(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.keyword_QMARK_,cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.identity,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.keys(registry)], 0))));
});
/**
 * Compute statistics about the registry
 */
atlas_ui_v2.data.stats = (function atlas_ui_v2$data$stats(registry){
var aspects_map = atlas_ui_v2.data.build_aspects_map(registry);
var entities_map = atlas_ui_v2.data.build_entities_map(registry);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"aspect-count","aspect-count",-95316145),cljs.core.count(atlas_ui_v2.data.extract_all_aspects(registry)),new cljs.core.Keyword(null,"namespace-count","namespace-count",187554941),cljs.core.count(aspects_map),new cljs.core.Keyword(null,"entity-count","entity-count",870517368),cljs.core.count(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.keys,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.vals(entities_map)], 0))),new cljs.core.Keyword(null,"type-count","type-count",1208627925),cljs.core.count(entities_map)], null);
});
/**
 * Convert aspect-stats from API (vector of {:aspect/aspect kw :aspect/count N})
 * to a map of {aspect-kw -> count} for easier lookup.
 */
atlas_ui_v2.data.aspect_stats__GT_map = (function atlas_ui_v2$data$aspect_stats__GT_map(aspect_stats){
return cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (entry){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("aspect","aspect","aspect/aspect",299955306).cljs$core$IFn$_invoke$arity$1(entry),new cljs.core.Keyword("aspect","count","aspect/count",870152861).cljs$core$IFn$_invoke$arity$1(entry)], null);
})),aspect_stats);
});
/**
 * Compute statistics for each namespace from aspect-stats.
 * Returns map of ns-keyword -> {:total-usage N :aspect-count N}
 */
atlas_ui_v2.data.namespace_stats = (function atlas_ui_v2$data$namespace_stats(aspect_stats_map){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__22452){
var vec__22453 = p__22452;
var aspect = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22453,(0),null);
var cnt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22453,(1),null);
var temp__5802__auto__ = cljs.core.namespace(aspect);
if(cljs.core.truth_(temp__5802__auto__)){
var ns = temp__5802__auto__;
var ns_key = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(ns);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns_key,new cljs.core.Keyword(null,"total-usage","total-usage",-1744675894)], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,(0)),cnt),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns_key,new cljs.core.Keyword(null,"aspect-count","aspect-count",-95316145)], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.inc,(0)));
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,aspect_stats_map);
});
/**
 * Sort the aspects map based on sort-by option.
 * aspect-stats-map: {aspect-kw -> count} from aspect-stats->map
 * 
 * Options:
 * - :alpha-asc - Alphabetical A-Z (default)
 * - :alpha-desc - Alphabetical Z-A
 * - :usage-desc - By total usage (most used first)
 * - :usage-asc - By total usage (least used first)
 * - :count-desc - By aspect count (most aspects first)
 * - :count-asc - By aspect count (fewest aspects first)
 */
atlas_ui_v2.data.sort_aspects_map = (function atlas_ui_v2$data$sort_aspects_map(aspects_map,aspect_stats_map,sort_by){
var ns_stats = atlas_ui_v2.data.namespace_stats(aspect_stats_map);
console.log("sort-aspects-map ns-stats sample:",cljs.core.clj__GT_js(cljs.core.take.cljs$core$IFn$_invoke$arity$2((3),ns_stats)));

var G__22460 = sort_by;
var G__22460__$1 = (((G__22460 instanceof cljs.core.Keyword))?G__22460.fqn:null);
switch (G__22460__$1) {
case "alpha-asc":
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map(),aspects_map);

break;
case "alpha-desc":
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map_by((function (p1__22459_SHARP_,p2__22458_SHARP_){
return cljs.core.compare(p2__22458_SHARP_,p1__22459_SHARP_);
})),aspects_map);

break;
case "usage-desc":
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map_by((function (k1,k2){
var u1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$3(ns_stats,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k1,new cljs.core.Keyword(null,"total-usage","total-usage",-1744675894)], null),(0));
var u2 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$3(ns_stats,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k2,new cljs.core.Keyword(null,"total-usage","total-usage",-1744675894)], null),(0));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(u1,u2)){
return cljs.core.compare(k1,k2);
} else {
return cljs.core.compare(u2,u1);
}
})),aspects_map);

break;
case "usage-asc":
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map_by((function (k1,k2){
var u1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$3(ns_stats,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k1,new cljs.core.Keyword(null,"total-usage","total-usage",-1744675894)], null),(0));
var u2 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$3(ns_stats,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k2,new cljs.core.Keyword(null,"total-usage","total-usage",-1744675894)], null),(0));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(u1,u2)){
return cljs.core.compare(k1,k2);
} else {
return cljs.core.compare(u1,u2);
}
})),aspects_map);

break;
case "count-desc":
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map_by((function (k1,k2){
var c1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$3(ns_stats,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k1,new cljs.core.Keyword(null,"aspect-count","aspect-count",-95316145)], null),(0));
var c2 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$3(ns_stats,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k2,new cljs.core.Keyword(null,"aspect-count","aspect-count",-95316145)], null),(0));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(c1,c2)){
return cljs.core.compare(k1,k2);
} else {
return cljs.core.compare(c2,c1);
}
})),aspects_map);

break;
case "count-asc":
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map_by((function (k1,k2){
var c1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$3(ns_stats,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k1,new cljs.core.Keyword(null,"aspect-count","aspect-count",-95316145)], null),(0));
var c2 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$3(ns_stats,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k2,new cljs.core.Keyword(null,"aspect-count","aspect-count",-95316145)], null),(0));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(c1,c2)){
return cljs.core.compare(k1,k2);
} else {
return cljs.core.compare(c1,c2);
}
})),aspects_map);

break;
default:
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map(),aspects_map);

}
});
/**
 * Sort aspect names within a namespace.
 * 
 * Options:
 * - :alpha-asc - Alphabetical A-Z (default)
 * - :alpha-desc - Alphabetical Z-A
 * - :usage-desc - By usage count (most used first)
 * - :usage-asc - By usage count (least used first)
 */
atlas_ui_v2.data.sort_aspect_names = (function atlas_ui_v2$data$sort_aspect_names(ns_key,aspect_names,aspect_stats_map,sort_by){
var result = (function (){var G__22467 = sort_by;
var G__22467__$1 = (((G__22467 instanceof cljs.core.Keyword))?G__22467.fqn:null);
switch (G__22467__$1) {
case "alpha-asc":
return cljs.core.sort.cljs$core$IFn$_invoke$arity$1(aspect_names);

break;
case "alpha-desc":
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((function (p1__22466_SHARP_,p2__22465_SHARP_){
return cljs.core.compare(p2__22465_SHARP_,p1__22466_SHARP_);
}),aspect_names);

break;
case "usage-desc":
return cljs.core.reverse((function (){var G__22468 = (function (aspect_name){
var full_aspect = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(cljs.core.name(ns_key),cljs.core.name(aspect_name));
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(aspect_stats_map,full_aspect,(0));
});
var G__22469 = aspect_names;
return (sort_by.cljs$core$IFn$_invoke$arity$2 ? sort_by.cljs$core$IFn$_invoke$arity$2(G__22468,G__22469) : sort_by.call(null,G__22468,G__22469));
})());

break;
case "usage-asc":
var G__22472 = (function (aspect_name){
var full_aspect = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(cljs.core.name(ns_key),cljs.core.name(aspect_name));
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(aspect_stats_map,full_aspect,(0));
});
var G__22473 = aspect_names;
return (sort_by.cljs$core$IFn$_invoke$arity$2 ? sort_by.cljs$core$IFn$_invoke$arity$2(G__22472,G__22473) : sort_by.call(null,G__22472,G__22473));

break;
default:
return cljs.core.sort.cljs$core$IFn$_invoke$arity$1(aspect_names);

}
})();
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns_key,new cljs.core.Keyword(null,"domain","domain",1847214937))) && (cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"usage-asc","usage-asc",-762149175),null,new cljs.core.Keyword(null,"usage-desc","usage-desc",-202614700),null], null), null),sort_by)))){
var first_3_22554 = cljs.core.take.cljs$core$IFn$_invoke$arity$2((3),result);
var counts_str_22555 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(", ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (aspect_name){
var full_aspect = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(cljs.core.name(ns_key),cljs.core.name(aspect_name));
var cnt = cljs.core.get.cljs$core$IFn$_invoke$arity$3(aspect_stats_map,full_aspect,(0));
return [cljs.core.name(aspect_name),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cnt)].join('');
}),first_3_22554));
console.log("sort-aspect-names",cljs.core.name(ns_key),"sort-by:",cljs.core.name(sort_by),"first-3:",counts_str_22555);
} else {
}

return result;
});
/**
 * Sort the entities map based on sort-by option.
 * 
 * Options:
 * - :alpha-asc - Alphabetical A-Z by type name (default)
 * - :alpha-desc - Alphabetical Z-A by type name
 * - :count-desc - By count (most entities first)
 * - :count-asc - By count (fewest entities first)
 */
atlas_ui_v2.data.sort_entities_map = (function atlas_ui_v2$data$sort_entities_map(entities_map,sort_by){
console.log("sort-entities-map counts:",cljs.core.clj__GT_js(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__22478){
var vec__22479 = p__22478;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22479,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22479,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,cljs.core.count(v)], null);
}),entities_map))));

var G__22482 = sort_by;
var G__22482__$1 = (((G__22482 instanceof cljs.core.Keyword))?G__22482.fqn:null);
switch (G__22482__$1) {
case "alpha-asc":
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map(),entities_map);

break;
case "alpha-desc":
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map_by((function (p1__22477_SHARP_,p2__22476_SHARP_){
return cljs.core.compare(p2__22476_SHARP_,p1__22477_SHARP_);
})),entities_map);

break;
case "count-desc":
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map_by((function (k1,k2){
var c1 = cljs.core.count(cljs.core.get.cljs$core$IFn$_invoke$arity$2(entities_map,k1));
var c2 = cljs.core.count(cljs.core.get.cljs$core$IFn$_invoke$arity$2(entities_map,k2));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(c1,c2)){
return cljs.core.compare(k1,k2);
} else {
return cljs.core.compare(c2,c1);
}
})),entities_map);

break;
case "count-asc":
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map_by((function (k1,k2){
var c1 = cljs.core.count(cljs.core.get.cljs$core$IFn$_invoke$arity$2(entities_map,k1));
var c2 = cljs.core.count(cljs.core.get.cljs$core$IFn$_invoke$arity$2(entities_map,k2));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(c1,c2)){
return cljs.core.compare(k1,k2);
} else {
return cljs.core.compare(c1,c2);
}
})),entities_map);

break;
default:
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map(),entities_map);

}
});
/**
 * Sort dev-ids within an entity type.
 * 
 * Options:
 * - :alpha-asc - Alphabetical A-Z (default)
 * - :alpha-desc - Alphabetical Z-A
 * - :aspect-count-desc - By number of aspects (most first)
 * - :aspect-count-asc - By number of aspects (fewest first)
 */
atlas_ui_v2.data.sort_dev_ids = (function atlas_ui_v2$data$sort_dev_ids(dev_id_map,sort_by){
var result = (function (){var G__22489 = sort_by;
var G__22489__$1 = (((G__22489 instanceof cljs.core.Keyword))?G__22489.fqn:null);
switch (G__22489__$1) {
case "alpha-asc":
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map(),dev_id_map);

break;
case "alpha-desc":
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map_by((function (p1__22486_SHARP_,p2__22485_SHARP_){
return cljs.core.compare(p2__22485_SHARP_,p1__22486_SHARP_);
})),dev_id_map);

break;
case "aspect-count-desc":
return cljs.core.reverse((function (){var G__22490 = (function (p__22492){
var vec__22493 = p__22492;
var _dev_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22493,(0),null);
var identity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22493,(1),null);
return cljs.core.count(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.keyword_QMARK_,identity));
});
var G__22491 = dev_id_map;
return (sort_by.cljs$core$IFn$_invoke$arity$2 ? sort_by.cljs$core$IFn$_invoke$arity$2(G__22490,G__22491) : sort_by.call(null,G__22490,G__22491));
})());

break;
case "aspect-count-asc":
var G__22496 = (function (p__22498){
var vec__22499 = p__22498;
var _dev_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22499,(0),null);
var identity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22499,(1),null);
return cljs.core.count(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.keyword_QMARK_,identity));
});
var G__22497 = dev_id_map;
return (sort_by.cljs$core$IFn$_invoke$arity$2 ? sort_by.cljs$core$IFn$_invoke$arity$2(G__22496,G__22497) : sort_by.call(null,G__22496,G__22497));

break;
default:
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map(),dev_id_map);

}
})();
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"aspect-count-asc","aspect-count-asc",1495464104),null,new cljs.core.Keyword(null,"aspect-count-desc","aspect-count-desc",1617664369),null], null), null),sort_by)){
var first_3_22582 = cljs.core.take.cljs$core$IFn$_invoke$arity$2((3),result);
var counts_str_22583 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(", ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__22504){
var vec__22505 = p__22504;
var dev_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22505,(0),null);
var identity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22505,(1),null);
var cnt = cljs.core.count(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.keyword_QMARK_,identity));
return [cljs.core.name(dev_id),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cnt)].join('');
}),first_3_22582));
console.log("sort-dev-ids sort-by:",cljs.core.name(sort_by),"first-3:",counts_str_22583,"total:",cljs.core.count(dev_id_map));
} else {
}

return result;
});

//# sourceMappingURL=atlas_ui_v2.data.js.map
