goog.provide('atlas_ui_v2.entities_map');
/**
 * Sort dropdown component
 */
atlas_ui_v2.entities_map.sort_dropdown = (function atlas_ui_v2$entities_map$sort_dropdown(label,current_value,options,on_change){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"align-items","align-items",-267946462),"center",new cljs.core.Keyword(null,"gap","gap",80255254),"0.5rem"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"0.75rem",new cljs.core.Keyword(null,"color","color",1011675173),"#999"], null)], null),label], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),cljs.core.name(current_value),new cljs.core.Keyword(null,"on-change","on-change",-732046149),(function (p1__22575_SHARP_){
var G__22577 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(p1__22575_SHARP_.target.value);
return (on_change.cljs$core$IFn$_invoke$arity$1 ? on_change.cljs$core$IFn$_invoke$arity$1(G__22577) : on_change.call(null,G__22577));
}),new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"padding","padding",1660304693),"0.25rem 0.4rem",new cljs.core.Keyword(null,"background","background",-863952629),"#2a2a4a",new cljs.core.Keyword(null,"color","color",1011675173),"#eee",new cljs.core.Keyword(null,"border","border",1444987323),"1px solid #4a4a6a",new cljs.core.Keyword(null,"border-radius","border-radius",419594011),"3px",new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"0.75rem",new cljs.core.Keyword(null,"cursor","cursor",1011937484),"pointer"], null)], null),(function (){var iter__5480__auto__ = (function atlas_ui_v2$entities_map$sort_dropdown_$_iter__22578(s__22579){
return (new cljs.core.LazySeq(null,(function (){
var s__22579__$1 = s__22579;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__22579__$1);
if(temp__5804__auto__){
var s__22579__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__22579__$2)){
var c__5478__auto__ = cljs.core.chunk_first(s__22579__$2);
var size__5479__auto__ = cljs.core.count(c__5478__auto__);
var b__22581 = cljs.core.chunk_buffer(size__5479__auto__);
if((function (){var i__22580 = (0);
while(true){
if((i__22580 < size__5479__auto__)){
var vec__22584 = cljs.core._nth(c__5478__auto__,i__22580);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22584,(0),null);
var label_text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22584,(1),null);
cljs.core.chunk_append(b__22581,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),cljs.core.name(value)], null),label_text], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),value], null)));

var G__22622 = (i__22580 + (1));
i__22580 = G__22622;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__22581),atlas_ui_v2$entities_map$sort_dropdown_$_iter__22578(cljs.core.chunk_rest(s__22579__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__22581),null);
}
} else {
var vec__22587 = cljs.core.first(s__22579__$2);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22587,(0),null);
var label_text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22587,(1),null);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),cljs.core.name(value)], null),label_text], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),value], null)),atlas_ui_v2$entities_map$sort_dropdown_$_iter__22578(cljs.core.rest(s__22579__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5480__auto__(options);
})()], null)], null);
});
/**
 * Render the sorted compound identity aspects (excluding atlas entity type)
 */
atlas_ui_v2.entities_map.identity_aspects = (function atlas_ui_v2$entities_map$identity_aspects(identity,text_color){
var aspects = cljs.core.vec(cljs.core.sort.cljs$core$IFn$_invoke$arity$1(cljs.core.remove.cljs$core$IFn$_invoke$arity$2((function (p1__22590_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("atlas",cljs.core.namespace(p1__22590_SHARP_));
}),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.keyword_QMARK_,identity))));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"0.7rem",new cljs.core.Keyword(null,"color","color",1011675173),text_color,new cljs.core.Keyword(null,"font-family","font-family",-667419874),"monospace"], null)], null),cljs.core.str.cljs$core$IFn$_invoke$arity$1(aspects)], null);
});
/**
 * Render a single entity as a clickable row
 */
atlas_ui_v2.entities_map.entity_row = (function atlas_ui_v2$entities_map$entity_row(dev_id,identity,p__22592){
var map__22593 = p__22592;
var map__22593__$1 = cljs.core.__destructure_map(map__22593);
var selected_entities = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22593__$1,new cljs.core.Keyword(null,"selected-entities","selected-entities",-961620715));
var selected_entities_not = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22593__$1,new cljs.core.Keyword(null,"selected-entities-not","selected-entities-not",923796309));
var highlight_entities = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22593__$1,new cljs.core.Keyword(null,"highlight-entities","highlight-entities",1314574027));
var filter_mode = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22593__$1,new cljs.core.Keyword(null,"filter-mode","filter-mode",-84440349));
var on_entity_click = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22593__$1,new cljs.core.Keyword(null,"on-entity-click","on-entity-click",2106101276));
var selected_QMARK_ = cljs.core.contains_QMARK_(selected_entities,dev_id);
var not_selected_QMARK_ = cljs.core.contains_QMARK_(selected_entities_not,dev_id);
var highlighted_QMARK_ = (function (){var and__5000__auto__ = highlight_entities;
if(cljs.core.truth_(and__5000__auto__)){
return cljs.core.contains_QMARK_(highlight_entities,dev_id);
} else {
return and__5000__auto__;
}
})();
var should_hide_QMARK_ = (function (){var and__5000__auto__ = highlight_entities;
if(cljs.core.truth_(and__5000__auto__)){
return ((cljs.core.not(highlighted_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(filter_mode,new cljs.core.Keyword(null,"hide","hide",-596913169))));
} else {
return and__5000__auto__;
}
})();
var dimmed_QMARK_ = (function (){var and__5000__auto__ = highlight_entities;
if(cljs.core.truth_(and__5000__auto__)){
return ((cljs.core.not(highlighted_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(filter_mode,new cljs.core.Keyword(null,"highlight","highlight",-800930873))));
} else {
return and__5000__auto__;
}
})();
var identity_text_color = ((selected_QMARK_)?"#cce5ff":((not_selected_QMARK_)?"#ffcccc":(cljs.core.truth_(highlighted_QMARK_)?"#a8e6c1":(cljs.core.truth_(dimmed_QMARK_)?"#444":"#888"
))));
if(cljs.core.truth_(should_hide_QMARK_)){
return null;
} else {
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),(function (){
return (on_entity_click.cljs$core$IFn$_invoke$arity$1 ? on_entity_click.cljs$core$IFn$_invoke$arity$1(dev_id) : on_entity_click.call(null,dev_id));
}),new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"align-items","align-items",-267946462),new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"transition","transition",765692007),new cljs.core.Keyword(null,"background","background",-863952629),new cljs.core.Keyword(null,"cursor","cursor",1011937484),new cljs.core.Keyword(null,"border-left","border-left",-1150760178),new cljs.core.Keyword(null,"opacity","opacity",397153780),new cljs.core.Keyword(null,"padding","padding",1660304693),new cljs.core.Keyword(null,"justify-content","justify-content",-1990475787),new cljs.core.Keyword(null,"display","display",242065432),new cljs.core.Keyword(null,"border-radius","border-radius",419594011),new cljs.core.Keyword(null,"margin","margin",-995903681)],["center",((selected_QMARK_)?"#fff":((not_selected_QMARK_)?"#fff":(cljs.core.truth_(dimmed_QMARK_)?"#444":"#bbb"
))),"all 0.2s ease",((selected_QMARK_)?"#4a9eff":((not_selected_QMARK_)?"#ef4a4a":(cljs.core.truth_(highlighted_QMARK_)?"#3a7a5a":"transparent"
))),"pointer",((selected_QMARK_)?"3px solid #6ab4ff":((not_selected_QMARK_)?"3px solid #ff6a6a":"3px solid transparent"
)),(cljs.core.truth_(dimmed_QMARK_)?0.4:(1)),"0.3rem 0.5rem","space-between","flex","4px","0.2rem 0"])], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"0.85rem"], null)], null),cljs.core.str.cljs$core$IFn$_invoke$arity$1(dev_id)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v2.entities_map.identity_aspects,identity,identity_text_color], null)], null);
}
});
/**
 * Render an entity type with its entities
 */
atlas_ui_v2.entities_map.type_section = (function atlas_ui_v2$entities_map$type_section(entity_type,dev_id_map,sort_items,opts){
var map__22595 = opts;
var map__22595__$1 = cljs.core.__destructure_map(map__22595);
var selected_types = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22595__$1,new cljs.core.Keyword(null,"selected-types","selected-types",-1725213152));
var highlight_entities = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22595__$1,new cljs.core.Keyword(null,"highlight-entities","highlight-entities",1314574027));
var filter_mode = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22595__$1,new cljs.core.Keyword(null,"filter-mode","filter-mode",-84440349));
var on_type_click = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22595__$1,new cljs.core.Keyword(null,"on-type-click","on-type-click",535036770));
var selected_QMARK_ = cljs.core.contains_QMARK_(selected_types,entity_type);
var type_has_highlight_QMARK_ = (function (){var and__5000__auto__ = highlight_entities;
if(cljs.core.truth_(and__5000__auto__)){
return cljs.core.some((function (p__22596){
var vec__22597 = p__22596;
var dev_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22597,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22597,(1),null);
return cljs.core.contains_QMARK_(highlight_entities,dev_id);
}),dev_id_map);
} else {
return and__5000__auto__;
}
})();
var should_hide_type_QMARK_ = (function (){var and__5000__auto__ = highlight_entities;
if(cljs.core.truth_(and__5000__auto__)){
return ((cljs.core.not(type_has_highlight_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(filter_mode,new cljs.core.Keyword(null,"hide","hide",-596913169))));
} else {
return and__5000__auto__;
}
})();
var dimmed_type_QMARK_ = (function (){var and__5000__auto__ = highlight_entities;
if(cljs.core.truth_(and__5000__auto__)){
return ((cljs.core.not(type_has_highlight_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(filter_mode,new cljs.core.Keyword(null,"highlight","highlight",-800930873))));
} else {
return and__5000__auto__;
}
})();
var sorted_entities = atlas_ui_v2.data.sort_dev_ids(dev_id_map,sort_items);
if(cljs.core.truth_(should_hide_type_QMARK_)){
return null;
} else {
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"margin-bottom","margin-bottom",388334941),"1.5rem",new cljs.core.Keyword(null,"opacity","opacity",397153780),(cljs.core.truth_(dimmed_type_QMARK_)?0.4:(1)),new cljs.core.Keyword(null,"transition","transition",765692007),"opacity 0.2s ease"], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),(function (){
return (on_type_click.cljs$core$IFn$_invoke$arity$1 ? on_type_click.cljs$core$IFn$_invoke$arity$1(entity_type) : on_type_click.call(null,entity_type));
}),new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"align-items","align-items",-267946462),new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"font-size","font-size",-1847940346),new cljs.core.Keyword(null,"font-weight","font-weight",2085804583),new cljs.core.Keyword(null,"background","background",-863952629),new cljs.core.Keyword(null,"cursor","cursor",1011937484),new cljs.core.Keyword(null,"border-left","border-left",-1150760178),new cljs.core.Keyword(null,"padding","padding",1660304693),new cljs.core.Keyword(null,"justify-content","justify-content",-1990475787),new cljs.core.Keyword(null,"display","display",242065432),new cljs.core.Keyword(null,"border-radius","border-radius",419594011),new cljs.core.Keyword(null,"margin-bottom","margin-bottom",388334941)],["center",((selected_QMARK_)?"#4a9eff":"#9a9aba"),"0.95rem","bold",((selected_QMARK_)?"#2a3a5a":"#1a1a2e"),"pointer",((selected_QMARK_)?"4px solid #4a9eff":"4px solid #4a4a6a"),"0.3rem 0.5rem","space-between","flex","4px","0.5rem"])], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),cljs.core.name(entity_type)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"color","color",1011675173),"#5a5a7a",new cljs.core.Keyword(null,"font-weight","font-weight",2085804583),"normal",new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"0.85rem"], null)], null),["(",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(dev_id_map)),")"].join('')], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"padding-left","padding-left",-1180879053),"0.5rem"], null)], null),(function (){var iter__5480__auto__ = (function atlas_ui_v2$entities_map$type_section_$_iter__22600(s__22601){
return (new cljs.core.LazySeq(null,(function (){
var s__22601__$1 = s__22601;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__22601__$1);
if(temp__5804__auto__){
var s__22601__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__22601__$2)){
var c__5478__auto__ = cljs.core.chunk_first(s__22601__$2);
var size__5479__auto__ = cljs.core.count(c__5478__auto__);
var b__22603 = cljs.core.chunk_buffer(size__5479__auto__);
if((function (){var i__22602 = (0);
while(true){
if((i__22602 < size__5479__auto__)){
var vec__22604 = cljs.core._nth(c__5478__auto__,i__22602);
var dev_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22604,(0),null);
var identity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22604,(1),null);
cljs.core.chunk_append(b__22603,cljs.core.with_meta(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v2.entities_map.entity_row,dev_id,identity,opts], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),dev_id], null)));

var G__22623 = (i__22602 + (1));
i__22602 = G__22623;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__22603),atlas_ui_v2$entities_map$type_section_$_iter__22600(cljs.core.chunk_rest(s__22601__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__22603),null);
}
} else {
var vec__22607 = cljs.core.first(s__22601__$2);
var dev_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22607,(0),null);
var identity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22607,(1),null);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v2.entities_map.entity_row,dev_id,identity,opts], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),dev_id], null)),atlas_ui_v2$entities_map$type_section_$_iter__22600(cljs.core.rest(s__22601__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5480__auto__(sorted_entities);
})()], null)], null);
}
});
/**
 * Main entities map component
 */
atlas_ui_v2.entities_map.entities_map_view = (function atlas_ui_v2$entities_map$entities_map_view(entities_data,opts){
var map__22610 = entities_data;
var map__22610__$1 = cljs.core.__destructure_map(map__22610);
var entities_map = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22610__$1,new cljs.core.Keyword(null,"entities-map","entities-map",-1465680347));
var sort_items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22610__$1,new cljs.core.Keyword(null,"sort-items","sort-items",814834777));
var map__22611 = opts;
var map__22611__$1 = cljs.core.__destructure_map(map__22611);
var sort_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22611__$1,new cljs.core.Keyword(null,"sort-type","sort-type",-2053499504));
var on_sort_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22611__$1,new cljs.core.Keyword(null,"on-sort-type","on-sort-type",1838409267));
var on_sort_items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22611__$1,new cljs.core.Keyword(null,"on-sort-items","on-sort-items",-1283971727));
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"flex-direction","flex-direction",364609438),"column",new cljs.core.Keyword(null,"height","height",1025178622),"100%"], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"padding","padding",1660304693),"0.75rem 1rem",new cljs.core.Keyword(null,"background","background",-863952629),"#1a1a2e",new cljs.core.Keyword(null,"border-bottom","border-bottom",2110948415),"1px solid #333"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h2","h2",-372662728),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"1.1rem",new cljs.core.Keyword(null,"margin","margin",-995903681),"0 0 0.75rem 0",new cljs.core.Keyword(null,"color","color",1011675173),"#aaa"], null)], null),"Entities by Type"], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"gap","gap",80255254),"0.75rem",new cljs.core.Keyword(null,"flex-wrap","flex-wrap",455413707),"wrap"], null)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v2.entities_map.sort_dropdown,"Type",sort_type,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"alpha-asc","alpha-asc",859183168),"A-Z"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"alpha-desc","alpha-desc",96961375),"Z-A"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"count-desc","count-desc",-386573389),"Most Entities"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"count-asc","count-asc",-1556365878),"Fewest Entities"], null)], null),on_sort_type], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v2.entities_map.sort_dropdown,"Items",sort_items,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"alpha-asc","alpha-asc",859183168),"A-Z"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"alpha-desc","alpha-desc",96961375),"Z-A"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"aspect-count-desc","aspect-count-desc",1617664369),"Most Aspects"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"aspect-count-asc","aspect-count-asc",1495464104),"Fewest Aspects"], null)], null),on_sort_items], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"flex","flex",-1425124628),(1),new cljs.core.Keyword(null,"overflow","overflow",2058931880),"auto",new cljs.core.Keyword(null,"padding","padding",1660304693),"1rem",new cljs.core.Keyword(null,"color","color",1011675173),"#eee"], null)], null),((cljs.core.empty_QMARK_(entities_map))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"color","color",1011675173),"#666"], null)], null),"No entities found"], null):(function (){var iter__5480__auto__ = (function atlas_ui_v2$entities_map$entities_map_view_$_iter__22612(s__22613){
return (new cljs.core.LazySeq(null,(function (){
var s__22613__$1 = s__22613;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__22613__$1);
if(temp__5804__auto__){
var s__22613__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__22613__$2)){
var c__5478__auto__ = cljs.core.chunk_first(s__22613__$2);
var size__5479__auto__ = cljs.core.count(c__5478__auto__);
var b__22615 = cljs.core.chunk_buffer(size__5479__auto__);
if((function (){var i__22614 = (0);
while(true){
if((i__22614 < size__5479__auto__)){
var vec__22616 = cljs.core._nth(c__5478__auto__,i__22614);
var entity_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22616,(0),null);
var dev_id_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22616,(1),null);
cljs.core.chunk_append(b__22615,cljs.core.with_meta(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v2.entities_map.type_section,entity_type,dev_id_map,sort_items,opts], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),entity_type], null)));

var G__22624 = (i__22614 + (1));
i__22614 = G__22624;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__22615),atlas_ui_v2$entities_map$entities_map_view_$_iter__22612(cljs.core.chunk_rest(s__22613__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__22615),null);
}
} else {
var vec__22619 = cljs.core.first(s__22613__$2);
var entity_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22619,(0),null);
var dev_id_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22619,(1),null);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v2.entities_map.type_section,entity_type,dev_id_map,sort_items,opts], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),entity_type], null)),atlas_ui_v2$entities_map$entities_map_view_$_iter__22612(cljs.core.rest(s__22613__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5480__auto__(entities_map);
})())], null)], null);
});

//# sourceMappingURL=atlas_ui_v2.entities_map.js.map
