goog.provide('atlas_ui_v2.api');
atlas_ui_v2.api.api_url = (function atlas_ui_v2$api$api_url(){
var host = location.hostname;
return ["http://",cljs.core.str.cljs$core$IFn$_invoke$arity$1(host),":8082/api/atlas/registry"].join('');
});
atlas_ui_v2.api.decode_transit = (function atlas_ui_v2$api$decode_transit(s){
var reader = cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"json","json",1279968570));
return cognitect.transit.read(reader,s);
});
/**
 * Fetch registry from backend, call on-success or on-error
 */
atlas_ui_v2.api.fetch_registry_BANG_ = (function atlas_ui_v2$api$fetch_registry_BANG_(on_success,on_error){
console.log("Fetching registry from:",atlas_ui_v2.api.api_url());

return ajax.core.GET.cljs$core$IFn$_invoke$arity$variadic(atlas_ui_v2.api.api_url(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.PersistentArrayMap(null, 1, ["Accept","application/transit+json"], null),new cljs.core.Keyword(null,"response-format","response-format",1664465322),new cljs.core.Keyword(null,"text","text",-1790561697),new cljs.core.Keyword(null,"handler","handler",-195596612),(function (response_text){
try{var data = atlas_ui_v2.api.decode_transit(response_text);
console.log("Registry loaded successfully");

return (on_success.cljs$core$IFn$_invoke$arity$1 ? on_success.cljs$core$IFn$_invoke$arity$1(data) : on_success.call(null,data));
}catch (e22534){var e = e22534;
console.error("Error decoding transit:",e);

var G__22538 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"decode-error","decode-error",-454125835),new cljs.core.Keyword(null,"error","error",-978969032),e], null);
return (on_error.cljs$core$IFn$_invoke$arity$1 ? on_error.cljs$core$IFn$_invoke$arity$1(G__22538) : on_error.call(null,G__22538));
}}),new cljs.core.Keyword(null,"error-handler","error-handler",-484945776),(function (error){
console.warn("API error:",error);

var G__22540 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fetch-error","fetch-error",1710778920),new cljs.core.Keyword(null,"error","error",-978969032),error], null);
return (on_error.cljs$core$IFn$_invoke$arity$1 ? on_error.cljs$core$IFn$_invoke$arity$1(G__22540) : on_error.call(null,G__22540));
})], null)], 0));
});

//# sourceMappingURL=atlas_ui_v2.api.js.map
