goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = true;

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_12458 = (function (this$){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (shadow.dom._to_dom[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5351__auto__.call(null,this$));
} else {
var m__5349__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5349__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_12458(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_12461 = (function (this$){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (shadow.dom._to_svg[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5351__auto__.call(null,this$));
} else {
var m__5349__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5349__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_12461(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__11741 = coll;
var G__11742 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__11741,G__11742) : shadow.dom.lazy_native_coll_seq.call(null,G__11741,G__11742));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__5002__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__11773 = arguments.length;
switch (G__11773) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__11775 = arguments.length;
switch (G__11775) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__11777 = arguments.length;
switch (G__11777) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__11779 = arguments.length;
switch (G__11779) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__11798 = arguments.length;
switch (G__11798) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__11801 = arguments.length;
switch (G__11801) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__5002__auto__ = (!((typeof document !== 'undefined')));
if(or__5002__auto__){
return or__5002__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e11814){if((e11814 instanceof Object)){
var e = e11814;
return console.log("didnt support attachEvent",el,e);
} else {
throw e11814;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__5002__auto__ = (!((typeof document !== 'undefined')));
if(or__5002__auto__){
return or__5002__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__11836 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__11837 = null;
var count__11838 = (0);
var i__11839 = (0);
while(true){
if((i__11839 < count__11838)){
var el = chunk__11837.cljs$core$IIndexed$_nth$arity$2(null,i__11839);
var handler_12488__$1 = ((function (seq__11836,chunk__11837,count__11838,i__11839,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__11836,chunk__11837,count__11838,i__11839,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_12488__$1);


var G__12490 = seq__11836;
var G__12491 = chunk__11837;
var G__12492 = count__11838;
var G__12493 = (i__11839 + (1));
seq__11836 = G__12490;
chunk__11837 = G__12491;
count__11838 = G__12492;
i__11839 = G__12493;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__11836);
if(temp__5804__auto__){
var seq__11836__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11836__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__11836__$1);
var G__12494 = cljs.core.chunk_rest(seq__11836__$1);
var G__12495 = c__5525__auto__;
var G__12496 = cljs.core.count(c__5525__auto__);
var G__12497 = (0);
seq__11836 = G__12494;
chunk__11837 = G__12495;
count__11838 = G__12496;
i__11839 = G__12497;
continue;
} else {
var el = cljs.core.first(seq__11836__$1);
var handler_12498__$1 = ((function (seq__11836,chunk__11837,count__11838,i__11839,el,seq__11836__$1,temp__5804__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__11836,chunk__11837,count__11838,i__11839,el,seq__11836__$1,temp__5804__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_12498__$1);


var G__12500 = cljs.core.next(seq__11836__$1);
var G__12501 = null;
var G__12502 = (0);
var G__12503 = (0);
seq__11836 = G__12500;
chunk__11837 = G__12501;
count__11838 = G__12502;
i__11839 = G__12503;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__11843 = arguments.length;
switch (G__11843) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__11853 = cljs.core.seq(events);
var chunk__11854 = null;
var count__11855 = (0);
var i__11856 = (0);
while(true){
if((i__11856 < count__11855)){
var vec__11863 = chunk__11854.cljs$core$IIndexed$_nth$arity$2(null,i__11856);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11863,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11863,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__12507 = seq__11853;
var G__12508 = chunk__11854;
var G__12509 = count__11855;
var G__12510 = (i__11856 + (1));
seq__11853 = G__12507;
chunk__11854 = G__12508;
count__11855 = G__12509;
i__11856 = G__12510;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__11853);
if(temp__5804__auto__){
var seq__11853__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11853__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__11853__$1);
var G__12511 = cljs.core.chunk_rest(seq__11853__$1);
var G__12512 = c__5525__auto__;
var G__12513 = cljs.core.count(c__5525__auto__);
var G__12514 = (0);
seq__11853 = G__12511;
chunk__11854 = G__12512;
count__11855 = G__12513;
i__11856 = G__12514;
continue;
} else {
var vec__11868 = cljs.core.first(seq__11853__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11868,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11868,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__12515 = cljs.core.next(seq__11853__$1);
var G__12516 = null;
var G__12517 = (0);
var G__12518 = (0);
seq__11853 = G__12515;
chunk__11854 = G__12516;
count__11855 = G__12517;
i__11856 = G__12518;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__11872 = cljs.core.seq(styles);
var chunk__11873 = null;
var count__11874 = (0);
var i__11875 = (0);
while(true){
if((i__11875 < count__11874)){
var vec__11887 = chunk__11873.cljs$core$IIndexed$_nth$arity$2(null,i__11875);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11887,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11887,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__12521 = seq__11872;
var G__12522 = chunk__11873;
var G__12523 = count__11874;
var G__12524 = (i__11875 + (1));
seq__11872 = G__12521;
chunk__11873 = G__12522;
count__11874 = G__12523;
i__11875 = G__12524;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__11872);
if(temp__5804__auto__){
var seq__11872__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11872__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__11872__$1);
var G__12526 = cljs.core.chunk_rest(seq__11872__$1);
var G__12527 = c__5525__auto__;
var G__12528 = cljs.core.count(c__5525__auto__);
var G__12529 = (0);
seq__11872 = G__12526;
chunk__11873 = G__12527;
count__11874 = G__12528;
i__11875 = G__12529;
continue;
} else {
var vec__11893 = cljs.core.first(seq__11872__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11893,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11893,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__12532 = cljs.core.next(seq__11872__$1);
var G__12534 = null;
var G__12535 = (0);
var G__12536 = (0);
seq__11872 = G__12532;
chunk__11873 = G__12534;
count__11874 = G__12535;
i__11875 = G__12536;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__11898_12537 = key;
var G__11898_12538__$1 = (((G__11898_12537 instanceof cljs.core.Keyword))?G__11898_12537.fqn:null);
switch (G__11898_12538__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_12556 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__5002__auto__ = goog.string.startsWith(ks_12556,"data-");
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return goog.string.startsWith(ks_12556,"aria-");
}
})())){
el.setAttribute(ks_12556,value);
} else {
(el[ks_12556] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__11926){
var map__11927 = p__11926;
var map__11927__$1 = cljs.core.__destructure_map(map__11927);
var props = map__11927__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11927__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__11928 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11928,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11928,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11928,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__11931 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__11931,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__11931;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__11933 = arguments.length;
switch (G__11933) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5804__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5804__auto__)){
var n = temp__5804__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5804__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5804__auto__)){
var n = temp__5804__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__11934){
var vec__11935 = p__11934;
var seq__11936 = cljs.core.seq(vec__11935);
var first__11937 = cljs.core.first(seq__11936);
var seq__11936__$1 = cljs.core.next(seq__11936);
var nn = first__11937;
var first__11937__$1 = cljs.core.first(seq__11936__$1);
var seq__11936__$2 = cljs.core.next(seq__11936__$1);
var np = first__11937__$1;
var nc = seq__11936__$2;
var node = vec__11935;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__11938 = nn;
var G__11939 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__11938,G__11939) : create_fn.call(null,G__11938,G__11939));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__11940 = nn;
var G__11941 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__11940,G__11941) : create_fn.call(null,G__11940,G__11941));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__11942 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11942,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11942,(1),null);
var seq__11945_12574 = cljs.core.seq(node_children);
var chunk__11946_12575 = null;
var count__11947_12576 = (0);
var i__11948_12577 = (0);
while(true){
if((i__11948_12577 < count__11947_12576)){
var child_struct_12578 = chunk__11946_12575.cljs$core$IIndexed$_nth$arity$2(null,i__11948_12577);
var children_12579 = shadow.dom.dom_node(child_struct_12578);
if(cljs.core.seq_QMARK_(children_12579)){
var seq__11961_12580 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_12579));
var chunk__11963_12581 = null;
var count__11964_12582 = (0);
var i__11965_12583 = (0);
while(true){
if((i__11965_12583 < count__11964_12582)){
var child_12584 = chunk__11963_12581.cljs$core$IIndexed$_nth$arity$2(null,i__11965_12583);
if(cljs.core.truth_(child_12584)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_12584);


var G__12585 = seq__11961_12580;
var G__12586 = chunk__11963_12581;
var G__12587 = count__11964_12582;
var G__12588 = (i__11965_12583 + (1));
seq__11961_12580 = G__12585;
chunk__11963_12581 = G__12586;
count__11964_12582 = G__12587;
i__11965_12583 = G__12588;
continue;
} else {
var G__12589 = seq__11961_12580;
var G__12590 = chunk__11963_12581;
var G__12591 = count__11964_12582;
var G__12592 = (i__11965_12583 + (1));
seq__11961_12580 = G__12589;
chunk__11963_12581 = G__12590;
count__11964_12582 = G__12591;
i__11965_12583 = G__12592;
continue;
}
} else {
var temp__5804__auto___12593 = cljs.core.seq(seq__11961_12580);
if(temp__5804__auto___12593){
var seq__11961_12595__$1 = temp__5804__auto___12593;
if(cljs.core.chunked_seq_QMARK_(seq__11961_12595__$1)){
var c__5525__auto___12597 = cljs.core.chunk_first(seq__11961_12595__$1);
var G__12598 = cljs.core.chunk_rest(seq__11961_12595__$1);
var G__12599 = c__5525__auto___12597;
var G__12600 = cljs.core.count(c__5525__auto___12597);
var G__12601 = (0);
seq__11961_12580 = G__12598;
chunk__11963_12581 = G__12599;
count__11964_12582 = G__12600;
i__11965_12583 = G__12601;
continue;
} else {
var child_12602 = cljs.core.first(seq__11961_12595__$1);
if(cljs.core.truth_(child_12602)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_12602);


var G__12603 = cljs.core.next(seq__11961_12595__$1);
var G__12604 = null;
var G__12605 = (0);
var G__12606 = (0);
seq__11961_12580 = G__12603;
chunk__11963_12581 = G__12604;
count__11964_12582 = G__12605;
i__11965_12583 = G__12606;
continue;
} else {
var G__12607 = cljs.core.next(seq__11961_12595__$1);
var G__12608 = null;
var G__12609 = (0);
var G__12610 = (0);
seq__11961_12580 = G__12607;
chunk__11963_12581 = G__12608;
count__11964_12582 = G__12609;
i__11965_12583 = G__12610;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_12579);
}


var G__12611 = seq__11945_12574;
var G__12612 = chunk__11946_12575;
var G__12613 = count__11947_12576;
var G__12614 = (i__11948_12577 + (1));
seq__11945_12574 = G__12611;
chunk__11946_12575 = G__12612;
count__11947_12576 = G__12613;
i__11948_12577 = G__12614;
continue;
} else {
var temp__5804__auto___12615 = cljs.core.seq(seq__11945_12574);
if(temp__5804__auto___12615){
var seq__11945_12616__$1 = temp__5804__auto___12615;
if(cljs.core.chunked_seq_QMARK_(seq__11945_12616__$1)){
var c__5525__auto___12621 = cljs.core.chunk_first(seq__11945_12616__$1);
var G__12622 = cljs.core.chunk_rest(seq__11945_12616__$1);
var G__12623 = c__5525__auto___12621;
var G__12624 = cljs.core.count(c__5525__auto___12621);
var G__12625 = (0);
seq__11945_12574 = G__12622;
chunk__11946_12575 = G__12623;
count__11947_12576 = G__12624;
i__11948_12577 = G__12625;
continue;
} else {
var child_struct_12627 = cljs.core.first(seq__11945_12616__$1);
var children_12628 = shadow.dom.dom_node(child_struct_12627);
if(cljs.core.seq_QMARK_(children_12628)){
var seq__11970_12629 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_12628));
var chunk__11972_12630 = null;
var count__11973_12631 = (0);
var i__11974_12632 = (0);
while(true){
if((i__11974_12632 < count__11973_12631)){
var child_12633 = chunk__11972_12630.cljs$core$IIndexed$_nth$arity$2(null,i__11974_12632);
if(cljs.core.truth_(child_12633)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_12633);


var G__12634 = seq__11970_12629;
var G__12635 = chunk__11972_12630;
var G__12636 = count__11973_12631;
var G__12637 = (i__11974_12632 + (1));
seq__11970_12629 = G__12634;
chunk__11972_12630 = G__12635;
count__11973_12631 = G__12636;
i__11974_12632 = G__12637;
continue;
} else {
var G__12638 = seq__11970_12629;
var G__12639 = chunk__11972_12630;
var G__12640 = count__11973_12631;
var G__12641 = (i__11974_12632 + (1));
seq__11970_12629 = G__12638;
chunk__11972_12630 = G__12639;
count__11973_12631 = G__12640;
i__11974_12632 = G__12641;
continue;
}
} else {
var temp__5804__auto___12642__$1 = cljs.core.seq(seq__11970_12629);
if(temp__5804__auto___12642__$1){
var seq__11970_12643__$1 = temp__5804__auto___12642__$1;
if(cljs.core.chunked_seq_QMARK_(seq__11970_12643__$1)){
var c__5525__auto___12644 = cljs.core.chunk_first(seq__11970_12643__$1);
var G__12645 = cljs.core.chunk_rest(seq__11970_12643__$1);
var G__12646 = c__5525__auto___12644;
var G__12647 = cljs.core.count(c__5525__auto___12644);
var G__12648 = (0);
seq__11970_12629 = G__12645;
chunk__11972_12630 = G__12646;
count__11973_12631 = G__12647;
i__11974_12632 = G__12648;
continue;
} else {
var child_12649 = cljs.core.first(seq__11970_12643__$1);
if(cljs.core.truth_(child_12649)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_12649);


var G__12650 = cljs.core.next(seq__11970_12643__$1);
var G__12651 = null;
var G__12652 = (0);
var G__12653 = (0);
seq__11970_12629 = G__12650;
chunk__11972_12630 = G__12651;
count__11973_12631 = G__12652;
i__11974_12632 = G__12653;
continue;
} else {
var G__12654 = cljs.core.next(seq__11970_12643__$1);
var G__12655 = null;
var G__12656 = (0);
var G__12657 = (0);
seq__11970_12629 = G__12654;
chunk__11972_12630 = G__12655;
count__11973_12631 = G__12656;
i__11974_12632 = G__12657;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_12628);
}


var G__12658 = cljs.core.next(seq__11945_12616__$1);
var G__12659 = null;
var G__12660 = (0);
var G__12661 = (0);
seq__11945_12574 = G__12658;
chunk__11946_12575 = G__12659;
count__11947_12576 = G__12660;
i__11948_12577 = G__12661;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__11980 = cljs.core.seq(node);
var chunk__11981 = null;
var count__11982 = (0);
var i__11983 = (0);
while(true){
if((i__11983 < count__11982)){
var n = chunk__11981.cljs$core$IIndexed$_nth$arity$2(null,i__11983);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__12665 = seq__11980;
var G__12666 = chunk__11981;
var G__12667 = count__11982;
var G__12668 = (i__11983 + (1));
seq__11980 = G__12665;
chunk__11981 = G__12666;
count__11982 = G__12667;
i__11983 = G__12668;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__11980);
if(temp__5804__auto__){
var seq__11980__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11980__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__11980__$1);
var G__12669 = cljs.core.chunk_rest(seq__11980__$1);
var G__12670 = c__5525__auto__;
var G__12671 = cljs.core.count(c__5525__auto__);
var G__12672 = (0);
seq__11980 = G__12669;
chunk__11981 = G__12670;
count__11982 = G__12671;
i__11983 = G__12672;
continue;
} else {
var n = cljs.core.first(seq__11980__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__12674 = cljs.core.next(seq__11980__$1);
var G__12675 = null;
var G__12676 = (0);
var G__12677 = (0);
seq__11980 = G__12674;
chunk__11981 = G__12675;
count__11982 = G__12676;
i__11983 = G__12677;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__11985 = arguments.length;
switch (G__11985) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__11987 = arguments.length;
switch (G__11987) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__11990 = arguments.length;
switch (G__11990) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__5002__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__5732__auto__ = [];
var len__5726__auto___12694 = arguments.length;
var i__5727__auto___12695 = (0);
while(true){
if((i__5727__auto___12695 < len__5726__auto___12694)){
args__5732__auto__.push((arguments[i__5727__auto___12695]));

var G__12697 = (i__5727__auto___12695 + (1));
i__5727__auto___12695 = G__12697;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((0) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__5733__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__12005_12700 = cljs.core.seq(nodes);
var chunk__12006_12701 = null;
var count__12007_12702 = (0);
var i__12008_12703 = (0);
while(true){
if((i__12008_12703 < count__12007_12702)){
var node_12704 = chunk__12006_12701.cljs$core$IIndexed$_nth$arity$2(null,i__12008_12703);
fragment.appendChild(shadow.dom._to_dom(node_12704));


var G__12705 = seq__12005_12700;
var G__12706 = chunk__12006_12701;
var G__12707 = count__12007_12702;
var G__12708 = (i__12008_12703 + (1));
seq__12005_12700 = G__12705;
chunk__12006_12701 = G__12706;
count__12007_12702 = G__12707;
i__12008_12703 = G__12708;
continue;
} else {
var temp__5804__auto___12709 = cljs.core.seq(seq__12005_12700);
if(temp__5804__auto___12709){
var seq__12005_12710__$1 = temp__5804__auto___12709;
if(cljs.core.chunked_seq_QMARK_(seq__12005_12710__$1)){
var c__5525__auto___12711 = cljs.core.chunk_first(seq__12005_12710__$1);
var G__12712 = cljs.core.chunk_rest(seq__12005_12710__$1);
var G__12713 = c__5525__auto___12711;
var G__12714 = cljs.core.count(c__5525__auto___12711);
var G__12715 = (0);
seq__12005_12700 = G__12712;
chunk__12006_12701 = G__12713;
count__12007_12702 = G__12714;
i__12008_12703 = G__12715;
continue;
} else {
var node_12716 = cljs.core.first(seq__12005_12710__$1);
fragment.appendChild(shadow.dom._to_dom(node_12716));


var G__12717 = cljs.core.next(seq__12005_12710__$1);
var G__12718 = null;
var G__12719 = (0);
var G__12720 = (0);
seq__12005_12700 = G__12717;
chunk__12006_12701 = G__12718;
count__12007_12702 = G__12719;
i__12008_12703 = G__12720;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq12004){
var self__5712__auto__ = this;
return self__5712__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq12004));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__12009_12722 = cljs.core.seq(scripts);
var chunk__12010_12723 = null;
var count__12011_12724 = (0);
var i__12012_12725 = (0);
while(true){
if((i__12012_12725 < count__12011_12724)){
var vec__12025_12726 = chunk__12010_12723.cljs$core$IIndexed$_nth$arity$2(null,i__12012_12725);
var script_tag_12727 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12025_12726,(0),null);
var script_body_12728 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12025_12726,(1),null);
eval(script_body_12728);


var G__12729 = seq__12009_12722;
var G__12730 = chunk__12010_12723;
var G__12731 = count__12011_12724;
var G__12732 = (i__12012_12725 + (1));
seq__12009_12722 = G__12729;
chunk__12010_12723 = G__12730;
count__12011_12724 = G__12731;
i__12012_12725 = G__12732;
continue;
} else {
var temp__5804__auto___12733 = cljs.core.seq(seq__12009_12722);
if(temp__5804__auto___12733){
var seq__12009_12734__$1 = temp__5804__auto___12733;
if(cljs.core.chunked_seq_QMARK_(seq__12009_12734__$1)){
var c__5525__auto___12735 = cljs.core.chunk_first(seq__12009_12734__$1);
var G__12736 = cljs.core.chunk_rest(seq__12009_12734__$1);
var G__12737 = c__5525__auto___12735;
var G__12738 = cljs.core.count(c__5525__auto___12735);
var G__12739 = (0);
seq__12009_12722 = G__12736;
chunk__12010_12723 = G__12737;
count__12011_12724 = G__12738;
i__12012_12725 = G__12739;
continue;
} else {
var vec__12028_12740 = cljs.core.first(seq__12009_12734__$1);
var script_tag_12741 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12028_12740,(0),null);
var script_body_12742 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12028_12740,(1),null);
eval(script_body_12742);


var G__12743 = cljs.core.next(seq__12009_12734__$1);
var G__12744 = null;
var G__12745 = (0);
var G__12746 = (0);
seq__12009_12722 = G__12743;
chunk__12010_12723 = G__12744;
count__12011_12724 = G__12745;
i__12012_12725 = G__12746;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__12031){
var vec__12032 = p__12031;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12032,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12032,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__12039 = arguments.length;
switch (G__12039) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__12043 = cljs.core.seq(style_keys);
var chunk__12044 = null;
var count__12045 = (0);
var i__12046 = (0);
while(true){
if((i__12046 < count__12045)){
var it = chunk__12044.cljs$core$IIndexed$_nth$arity$2(null,i__12046);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__12753 = seq__12043;
var G__12754 = chunk__12044;
var G__12755 = count__12045;
var G__12756 = (i__12046 + (1));
seq__12043 = G__12753;
chunk__12044 = G__12754;
count__12045 = G__12755;
i__12046 = G__12756;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__12043);
if(temp__5804__auto__){
var seq__12043__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__12043__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__12043__$1);
var G__12757 = cljs.core.chunk_rest(seq__12043__$1);
var G__12758 = c__5525__auto__;
var G__12759 = cljs.core.count(c__5525__auto__);
var G__12760 = (0);
seq__12043 = G__12757;
chunk__12044 = G__12758;
count__12045 = G__12759;
i__12046 = G__12760;
continue;
} else {
var it = cljs.core.first(seq__12043__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__12761 = cljs.core.next(seq__12043__$1);
var G__12762 = null;
var G__12763 = (0);
var G__12764 = (0);
seq__12043 = G__12761;
chunk__12044 = G__12762;
count__12045 = G__12763;
i__12046 = G__12764;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5300__auto__,k__5301__auto__){
var self__ = this;
var this__5300__auto____$1 = this;
return this__5300__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5301__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5302__auto__,k12048,else__5303__auto__){
var self__ = this;
var this__5302__auto____$1 = this;
var G__12052 = k12048;
var G__12052__$1 = (((G__12052 instanceof cljs.core.Keyword))?G__12052.fqn:null);
switch (G__12052__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12048,else__5303__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5320__auto__,f__5321__auto__,init__5322__auto__){
var self__ = this;
var this__5320__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5323__auto__,p__12053){
var vec__12054 = p__12053;
var k__5324__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12054,(0),null);
var v__5325__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12054,(1),null);
return (f__5321__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5321__auto__.cljs$core$IFn$_invoke$arity$3(ret__5323__auto__,k__5324__auto__,v__5325__auto__) : f__5321__auto__.call(null,ret__5323__auto__,k__5324__auto__,v__5325__auto__));
}),init__5322__auto__,this__5320__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5315__auto__,writer__5316__auto__,opts__5317__auto__){
var self__ = this;
var this__5315__auto____$1 = this;
var pr_pair__5318__auto__ = (function (keyval__5319__auto__){
return cljs.core.pr_sequential_writer(writer__5316__auto__,cljs.core.pr_writer,""," ","",opts__5317__auto__,keyval__5319__auto__);
});
return cljs.core.pr_sequential_writer(writer__5316__auto__,pr_pair__5318__auto__,"#shadow.dom.Coordinate{",", ","}",opts__5317__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12047){
var self__ = this;
var G__12047__$1 = this;
return (new cljs.core.RecordIter((0),G__12047__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5298__auto__){
var self__ = this;
var this__5298__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5295__auto__){
var self__ = this;
var this__5295__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5304__auto__){
var self__ = this;
var this__5304__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5296__auto__){
var self__ = this;
var this__5296__auto____$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = (function (coll__5297__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__5297__auto__));
})(this__5296__auto____$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12049,other12050){
var self__ = this;
var this12049__$1 = this;
return (((!((other12050 == null)))) && ((((this12049__$1.constructor === other12050.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12049__$1.x,other12050.x)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12049__$1.y,other12050.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12049__$1.__extmap,other12050.__extmap)))))))));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5310__auto__,k__5311__auto__){
var self__ = this;
var this__5310__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__5311__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5310__auto____$1),self__.__meta),k__5311__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5311__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5307__auto__,k12048){
var self__ = this;
var this__5307__auto____$1 = this;
var G__12059 = k12048;
var G__12059__$1 = (((G__12059 instanceof cljs.core.Keyword))?G__12059.fqn:null);
switch (G__12059__$1) {
case "x":
case "y":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k12048);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5308__auto__,k__5309__auto__,G__12047){
var self__ = this;
var this__5308__auto____$1 = this;
var pred__12065 = cljs.core.keyword_identical_QMARK_;
var expr__12066 = k__5309__auto__;
if(cljs.core.truth_((pred__12065.cljs$core$IFn$_invoke$arity$2 ? pred__12065.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__12066) : pred__12065.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__12066)))){
return (new shadow.dom.Coordinate(G__12047,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12065.cljs$core$IFn$_invoke$arity$2 ? pred__12065.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__12066) : pred__12065.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__12066)))){
return (new shadow.dom.Coordinate(self__.x,G__12047,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5309__auto__,G__12047),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5313__auto__){
var self__ = this;
var this__5313__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5299__auto__,G__12047){
var self__ = this;
var this__5299__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__12047,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5305__auto__,entry__5306__auto__){
var self__ = this;
var this__5305__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5306__auto__)){
return this__5305__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__5306__auto__,(0)),cljs.core._nth(entry__5306__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5305__auto____$1,entry__5306__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__5346__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__5346__auto__,writer__5347__auto__){
return cljs.core._write(writer__5347__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__12051){
var extmap__5342__auto__ = (function (){var G__12073 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12051,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__12051)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12073);
} else {
return G__12073;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__12051),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__12051),null,cljs.core.not_empty(extmap__5342__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5300__auto__,k__5301__auto__){
var self__ = this;
var this__5300__auto____$1 = this;
return this__5300__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5301__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5302__auto__,k12082,else__5303__auto__){
var self__ = this;
var this__5302__auto____$1 = this;
var G__12090 = k12082;
var G__12090__$1 = (((G__12090 instanceof cljs.core.Keyword))?G__12090.fqn:null);
switch (G__12090__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12082,else__5303__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5320__auto__,f__5321__auto__,init__5322__auto__){
var self__ = this;
var this__5320__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5323__auto__,p__12091){
var vec__12092 = p__12091;
var k__5324__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12092,(0),null);
var v__5325__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12092,(1),null);
return (f__5321__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5321__auto__.cljs$core$IFn$_invoke$arity$3(ret__5323__auto__,k__5324__auto__,v__5325__auto__) : f__5321__auto__.call(null,ret__5323__auto__,k__5324__auto__,v__5325__auto__));
}),init__5322__auto__,this__5320__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5315__auto__,writer__5316__auto__,opts__5317__auto__){
var self__ = this;
var this__5315__auto____$1 = this;
var pr_pair__5318__auto__ = (function (keyval__5319__auto__){
return cljs.core.pr_sequential_writer(writer__5316__auto__,cljs.core.pr_writer,""," ","",opts__5317__auto__,keyval__5319__auto__);
});
return cljs.core.pr_sequential_writer(writer__5316__auto__,pr_pair__5318__auto__,"#shadow.dom.Size{",", ","}",opts__5317__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12081){
var self__ = this;
var G__12081__$1 = this;
return (new cljs.core.RecordIter((0),G__12081__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5298__auto__){
var self__ = this;
var this__5298__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5295__auto__){
var self__ = this;
var this__5295__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5304__auto__){
var self__ = this;
var this__5304__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5296__auto__){
var self__ = this;
var this__5296__auto____$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = (function (coll__5297__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__5297__auto__));
})(this__5296__auto____$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12083,other12084){
var self__ = this;
var this12083__$1 = this;
return (((!((other12084 == null)))) && ((((this12083__$1.constructor === other12084.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12083__$1.w,other12084.w)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12083__$1.h,other12084.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12083__$1.__extmap,other12084.__extmap)))))))));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5310__auto__,k__5311__auto__){
var self__ = this;
var this__5310__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__5311__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5310__auto____$1),self__.__meta),k__5311__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5311__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5307__auto__,k12082){
var self__ = this;
var this__5307__auto____$1 = this;
var G__12102 = k12082;
var G__12102__$1 = (((G__12102 instanceof cljs.core.Keyword))?G__12102.fqn:null);
switch (G__12102__$1) {
case "w":
case "h":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k12082);

}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5308__auto__,k__5309__auto__,G__12081){
var self__ = this;
var this__5308__auto____$1 = this;
var pred__12104 = cljs.core.keyword_identical_QMARK_;
var expr__12105 = k__5309__auto__;
if(cljs.core.truth_((pred__12104.cljs$core$IFn$_invoke$arity$2 ? pred__12104.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__12105) : pred__12104.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__12105)))){
return (new shadow.dom.Size(G__12081,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12104.cljs$core$IFn$_invoke$arity$2 ? pred__12104.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__12105) : pred__12104.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__12105)))){
return (new shadow.dom.Size(self__.w,G__12081,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5309__auto__,G__12081),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5313__auto__){
var self__ = this;
var this__5313__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5299__auto__,G__12081){
var self__ = this;
var this__5299__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__12081,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5305__auto__,entry__5306__auto__){
var self__ = this;
var this__5305__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5306__auto__)){
return this__5305__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__5306__auto__,(0)),cljs.core._nth(entry__5306__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5305__auto____$1,entry__5306__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__5346__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__5346__auto__,writer__5347__auto__){
return cljs.core._write(writer__5347__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__12085){
var extmap__5342__auto__ = (function (){var G__12122 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12085,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__12085)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12122);
} else {
return G__12122;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__12085),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__12085),null,cljs.core.not_empty(extmap__5342__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__5590__auto__ = opts;
var l__5591__auto__ = a__5590__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__5591__auto__)){
var G__12852 = (i + (1));
var G__12853 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__12852;
ret = G__12853;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__12168){
var vec__12170 = p__12168;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12170,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12170,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__12192 = arguments.length;
switch (G__12192) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5802__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5802__auto__)){
var child = temp__5802__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__12860 = ps;
var G__12861 = (i + (1));
el__$1 = G__12860;
i = G__12861;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__12253 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12253,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12253,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12253,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__12260_12865 = cljs.core.seq(props);
var chunk__12261_12866 = null;
var count__12262_12867 = (0);
var i__12263_12868 = (0);
while(true){
if((i__12263_12868 < count__12262_12867)){
var vec__12274_12869 = chunk__12261_12866.cljs$core$IIndexed$_nth$arity$2(null,i__12263_12868);
var k_12870 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12274_12869,(0),null);
var v_12871 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12274_12869,(1),null);
el.setAttributeNS((function (){var temp__5804__auto__ = cljs.core.namespace(k_12870);
if(cljs.core.truth_(temp__5804__auto__)){
var ns = temp__5804__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_12870),v_12871);


var G__12872 = seq__12260_12865;
var G__12873 = chunk__12261_12866;
var G__12874 = count__12262_12867;
var G__12875 = (i__12263_12868 + (1));
seq__12260_12865 = G__12872;
chunk__12261_12866 = G__12873;
count__12262_12867 = G__12874;
i__12263_12868 = G__12875;
continue;
} else {
var temp__5804__auto___12876 = cljs.core.seq(seq__12260_12865);
if(temp__5804__auto___12876){
var seq__12260_12877__$1 = temp__5804__auto___12876;
if(cljs.core.chunked_seq_QMARK_(seq__12260_12877__$1)){
var c__5525__auto___12878 = cljs.core.chunk_first(seq__12260_12877__$1);
var G__12879 = cljs.core.chunk_rest(seq__12260_12877__$1);
var G__12880 = c__5525__auto___12878;
var G__12881 = cljs.core.count(c__5525__auto___12878);
var G__12882 = (0);
seq__12260_12865 = G__12879;
chunk__12261_12866 = G__12880;
count__12262_12867 = G__12881;
i__12263_12868 = G__12882;
continue;
} else {
var vec__12278_12883 = cljs.core.first(seq__12260_12877__$1);
var k_12884 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12278_12883,(0),null);
var v_12885 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12278_12883,(1),null);
el.setAttributeNS((function (){var temp__5804__auto____$1 = cljs.core.namespace(k_12884);
if(cljs.core.truth_(temp__5804__auto____$1)){
var ns = temp__5804__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_12884),v_12885);


var G__12886 = cljs.core.next(seq__12260_12877__$1);
var G__12887 = null;
var G__12888 = (0);
var G__12889 = (0);
seq__12260_12865 = G__12886;
chunk__12261_12866 = G__12887;
count__12262_12867 = G__12888;
i__12263_12868 = G__12889;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__12290 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12290,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12290,(1),null);
var seq__12294_12890 = cljs.core.seq(node_children);
var chunk__12296_12891 = null;
var count__12297_12892 = (0);
var i__12298_12893 = (0);
while(true){
if((i__12298_12893 < count__12297_12892)){
var child_struct_12894 = chunk__12296_12891.cljs$core$IIndexed$_nth$arity$2(null,i__12298_12893);
if((!((child_struct_12894 == null)))){
if(typeof child_struct_12894 === 'string'){
var text_12895 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_12895),child_struct_12894].join(''));
} else {
var children_12896 = shadow.dom.svg_node(child_struct_12894);
if(cljs.core.seq_QMARK_(children_12896)){
var seq__12382_12897 = cljs.core.seq(children_12896);
var chunk__12384_12898 = null;
var count__12385_12899 = (0);
var i__12386_12900 = (0);
while(true){
if((i__12386_12900 < count__12385_12899)){
var child_12901 = chunk__12384_12898.cljs$core$IIndexed$_nth$arity$2(null,i__12386_12900);
if(cljs.core.truth_(child_12901)){
node.appendChild(child_12901);


var G__12902 = seq__12382_12897;
var G__12903 = chunk__12384_12898;
var G__12904 = count__12385_12899;
var G__12905 = (i__12386_12900 + (1));
seq__12382_12897 = G__12902;
chunk__12384_12898 = G__12903;
count__12385_12899 = G__12904;
i__12386_12900 = G__12905;
continue;
} else {
var G__12906 = seq__12382_12897;
var G__12907 = chunk__12384_12898;
var G__12908 = count__12385_12899;
var G__12909 = (i__12386_12900 + (1));
seq__12382_12897 = G__12906;
chunk__12384_12898 = G__12907;
count__12385_12899 = G__12908;
i__12386_12900 = G__12909;
continue;
}
} else {
var temp__5804__auto___12910 = cljs.core.seq(seq__12382_12897);
if(temp__5804__auto___12910){
var seq__12382_12911__$1 = temp__5804__auto___12910;
if(cljs.core.chunked_seq_QMARK_(seq__12382_12911__$1)){
var c__5525__auto___12912 = cljs.core.chunk_first(seq__12382_12911__$1);
var G__12913 = cljs.core.chunk_rest(seq__12382_12911__$1);
var G__12914 = c__5525__auto___12912;
var G__12915 = cljs.core.count(c__5525__auto___12912);
var G__12916 = (0);
seq__12382_12897 = G__12913;
chunk__12384_12898 = G__12914;
count__12385_12899 = G__12915;
i__12386_12900 = G__12916;
continue;
} else {
var child_12918 = cljs.core.first(seq__12382_12911__$1);
if(cljs.core.truth_(child_12918)){
node.appendChild(child_12918);


var G__12919 = cljs.core.next(seq__12382_12911__$1);
var G__12920 = null;
var G__12921 = (0);
var G__12922 = (0);
seq__12382_12897 = G__12919;
chunk__12384_12898 = G__12920;
count__12385_12899 = G__12921;
i__12386_12900 = G__12922;
continue;
} else {
var G__12923 = cljs.core.next(seq__12382_12911__$1);
var G__12924 = null;
var G__12925 = (0);
var G__12926 = (0);
seq__12382_12897 = G__12923;
chunk__12384_12898 = G__12924;
count__12385_12899 = G__12925;
i__12386_12900 = G__12926;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_12896);
}
}


var G__12927 = seq__12294_12890;
var G__12928 = chunk__12296_12891;
var G__12929 = count__12297_12892;
var G__12930 = (i__12298_12893 + (1));
seq__12294_12890 = G__12927;
chunk__12296_12891 = G__12928;
count__12297_12892 = G__12929;
i__12298_12893 = G__12930;
continue;
} else {
var G__12931 = seq__12294_12890;
var G__12932 = chunk__12296_12891;
var G__12933 = count__12297_12892;
var G__12934 = (i__12298_12893 + (1));
seq__12294_12890 = G__12931;
chunk__12296_12891 = G__12932;
count__12297_12892 = G__12933;
i__12298_12893 = G__12934;
continue;
}
} else {
var temp__5804__auto___12935 = cljs.core.seq(seq__12294_12890);
if(temp__5804__auto___12935){
var seq__12294_12936__$1 = temp__5804__auto___12935;
if(cljs.core.chunked_seq_QMARK_(seq__12294_12936__$1)){
var c__5525__auto___12937 = cljs.core.chunk_first(seq__12294_12936__$1);
var G__12938 = cljs.core.chunk_rest(seq__12294_12936__$1);
var G__12939 = c__5525__auto___12937;
var G__12940 = cljs.core.count(c__5525__auto___12937);
var G__12941 = (0);
seq__12294_12890 = G__12938;
chunk__12296_12891 = G__12939;
count__12297_12892 = G__12940;
i__12298_12893 = G__12941;
continue;
} else {
var child_struct_12942 = cljs.core.first(seq__12294_12936__$1);
if((!((child_struct_12942 == null)))){
if(typeof child_struct_12942 === 'string'){
var text_12943 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_12943),child_struct_12942].join(''));
} else {
var children_12944 = shadow.dom.svg_node(child_struct_12942);
if(cljs.core.seq_QMARK_(children_12944)){
var seq__12397_12945 = cljs.core.seq(children_12944);
var chunk__12399_12946 = null;
var count__12400_12947 = (0);
var i__12401_12948 = (0);
while(true){
if((i__12401_12948 < count__12400_12947)){
var child_12949 = chunk__12399_12946.cljs$core$IIndexed$_nth$arity$2(null,i__12401_12948);
if(cljs.core.truth_(child_12949)){
node.appendChild(child_12949);


var G__12950 = seq__12397_12945;
var G__12951 = chunk__12399_12946;
var G__12952 = count__12400_12947;
var G__12953 = (i__12401_12948 + (1));
seq__12397_12945 = G__12950;
chunk__12399_12946 = G__12951;
count__12400_12947 = G__12952;
i__12401_12948 = G__12953;
continue;
} else {
var G__12954 = seq__12397_12945;
var G__12955 = chunk__12399_12946;
var G__12956 = count__12400_12947;
var G__12957 = (i__12401_12948 + (1));
seq__12397_12945 = G__12954;
chunk__12399_12946 = G__12955;
count__12400_12947 = G__12956;
i__12401_12948 = G__12957;
continue;
}
} else {
var temp__5804__auto___12958__$1 = cljs.core.seq(seq__12397_12945);
if(temp__5804__auto___12958__$1){
var seq__12397_12959__$1 = temp__5804__auto___12958__$1;
if(cljs.core.chunked_seq_QMARK_(seq__12397_12959__$1)){
var c__5525__auto___12960 = cljs.core.chunk_first(seq__12397_12959__$1);
var G__12961 = cljs.core.chunk_rest(seq__12397_12959__$1);
var G__12962 = c__5525__auto___12960;
var G__12963 = cljs.core.count(c__5525__auto___12960);
var G__12964 = (0);
seq__12397_12945 = G__12961;
chunk__12399_12946 = G__12962;
count__12400_12947 = G__12963;
i__12401_12948 = G__12964;
continue;
} else {
var child_12965 = cljs.core.first(seq__12397_12959__$1);
if(cljs.core.truth_(child_12965)){
node.appendChild(child_12965);


var G__12966 = cljs.core.next(seq__12397_12959__$1);
var G__12967 = null;
var G__12968 = (0);
var G__12969 = (0);
seq__12397_12945 = G__12966;
chunk__12399_12946 = G__12967;
count__12400_12947 = G__12968;
i__12401_12948 = G__12969;
continue;
} else {
var G__12970 = cljs.core.next(seq__12397_12959__$1);
var G__12971 = null;
var G__12972 = (0);
var G__12973 = (0);
seq__12397_12945 = G__12970;
chunk__12399_12946 = G__12971;
count__12400_12947 = G__12972;
i__12401_12948 = G__12973;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_12944);
}
}


var G__12975 = cljs.core.next(seq__12294_12936__$1);
var G__12976 = null;
var G__12977 = (0);
var G__12978 = (0);
seq__12294_12890 = G__12975;
chunk__12296_12891 = G__12976;
count__12297_12892 = G__12977;
i__12298_12893 = G__12978;
continue;
} else {
var G__12979 = cljs.core.next(seq__12294_12936__$1);
var G__12980 = null;
var G__12981 = (0);
var G__12982 = (0);
seq__12294_12890 = G__12979;
chunk__12296_12891 = G__12980;
count__12297_12892 = G__12981;
i__12298_12893 = G__12982;
continue;
}
}
} else {
}
}
break;
}

return node;
});
(shadow.dom.SVGElement["string"] = true);

(shadow.dom._to_svg["string"] = (function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

(shadow.dom.SVGElement["null"] = true);

(shadow.dom._to_svg["null"] = (function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__5732__auto__ = [];
var len__5726__auto___12985 = arguments.length;
var i__5727__auto___12986 = (0);
while(true){
if((i__5727__auto___12986 < len__5726__auto___12985)){
args__5732__auto__.push((arguments[i__5727__auto___12986]));

var G__12987 = (i__5727__auto___12986 + (1));
i__5727__auto___12986 = G__12987;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((1) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5733__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq12438){
var G__12439 = cljs.core.first(seq12438);
var seq12438__$1 = cljs.core.next(seq12438);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12439,seq12438__$1);
}));


//# sourceMappingURL=shadow.dom.js.map
