goog.provide('cljs.core.async');
goog.scope(function(){
  cljs.core.async.goog$module$goog$array = goog.module.get('goog.array');
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14800 = (function (f,blockable,meta14801){
this.f = f;
this.blockable = blockable;
this.meta14801 = meta14801;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async14800.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14802,meta14801__$1){
var self__ = this;
var _14802__$1 = this;
return (new cljs.core.async.t_cljs$core$async14800(self__.f,self__.blockable,meta14801__$1));
}));

(cljs.core.async.t_cljs$core$async14800.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14802){
var self__ = this;
var _14802__$1 = this;
return self__.meta14801;
}));

(cljs.core.async.t_cljs$core$async14800.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14800.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async14800.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async14800.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async14800.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta14801","meta14801",-721371747,null)], null);
}));

(cljs.core.async.t_cljs$core$async14800.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async14800.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14800");

(cljs.core.async.t_cljs$core$async14800.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async14800");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async14800.
 */
cljs.core.async.__GT_t_cljs$core$async14800 = (function cljs$core$async$__GT_t_cljs$core$async14800(f,blockable,meta14801){
return (new cljs.core.async.t_cljs$core$async14800(f,blockable,meta14801));
});


cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__14799 = arguments.length;
switch (G__14799) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
return (new cljs.core.async.t_cljs$core$async14800(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__14845 = arguments.length;
switch (G__14845) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__14848 = arguments.length;
switch (G__14848) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__14862 = arguments.length;
switch (G__14862) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_17703 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_17703) : fn1.call(null,val_17703));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_17703) : fn1.call(null,val_17703));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__14874 = arguments.length;
switch (G__14874) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5802__auto__)){
var ret = temp__5802__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5802__auto__)){
var retb = temp__5802__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5593__auto___17729 = n;
var x_17730 = (0);
while(true){
if((x_17730 < n__5593__auto___17729)){
(a[x_17730] = x_17730);

var G__17731 = (x_17730 + (1));
x_17730 = G__17731;
continue;
} else {
}
break;
}

cljs.core.async.goog$module$goog$array.shuffle(a);

return a;
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14883 = (function (flag,meta14884){
this.flag = flag;
this.meta14884 = meta14884;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async14883.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14885,meta14884__$1){
var self__ = this;
var _14885__$1 = this;
return (new cljs.core.async.t_cljs$core$async14883(self__.flag,meta14884__$1));
}));

(cljs.core.async.t_cljs$core$async14883.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14885){
var self__ = this;
var _14885__$1 = this;
return self__.meta14884;
}));

(cljs.core.async.t_cljs$core$async14883.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14883.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async14883.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async14883.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async14883.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta14884","meta14884",414107953,null)], null);
}));

(cljs.core.async.t_cljs$core$async14883.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async14883.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14883");

(cljs.core.async.t_cljs$core$async14883.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async14883");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async14883.
 */
cljs.core.async.__GT_t_cljs$core$async14883 = (function cljs$core$async$__GT_t_cljs$core$async14883(flag,meta14884){
return (new cljs.core.async.t_cljs$core$async14883(flag,meta14884));
});


cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
return (new cljs.core.async.t_cljs$core$async14883(flag,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14887 = (function (flag,cb,meta14888){
this.flag = flag;
this.cb = cb;
this.meta14888 = meta14888;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async14887.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14889,meta14888__$1){
var self__ = this;
var _14889__$1 = this;
return (new cljs.core.async.t_cljs$core$async14887(self__.flag,self__.cb,meta14888__$1));
}));

(cljs.core.async.t_cljs$core$async14887.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14889){
var self__ = this;
var _14889__$1 = this;
return self__.meta14888;
}));

(cljs.core.async.t_cljs$core$async14887.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14887.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async14887.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async14887.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async14887.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta14888","meta14888",-760349886,null)], null);
}));

(cljs.core.async.t_cljs$core$async14887.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async14887.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14887");

(cljs.core.async.t_cljs$core$async14887.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async14887");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async14887.
 */
cljs.core.async.__GT_t_cljs$core$async14887 = (function cljs$core$async$__GT_t_cljs$core$async14887(flag,cb,meta14888){
return (new cljs.core.async.t_cljs$core$async14887(flag,cb,meta14888));
});


cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
return (new cljs.core.async.t_cljs$core$async14887(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__14899_SHARP_){
var G__14901 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__14899_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__14901) : fret.call(null,G__14901));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__14900_SHARP_){
var G__14902 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__14900_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__14902) : fret.call(null,G__14902));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__5002__auto__ = wport;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return port;
}
})()], null));
} else {
var G__17736 = (i + (1));
i = G__17736;
continue;
}
} else {
return null;
}
break;
}
})();
var or__5002__auto__ = ret;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5804__auto__ = (function (){var and__5000__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__5000__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__5000__auto__;
}
})();
if(cljs.core.truth_(temp__5804__auto__)){
var got = temp__5804__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5732__auto__ = [];
var len__5726__auto___17737 = arguments.length;
var i__5727__auto___17738 = (0);
while(true){
if((i__5727__auto___17738 < len__5726__auto___17737)){
args__5732__auto__.push((arguments[i__5727__auto___17738]));

var G__17739 = (i__5727__auto___17738 + (1));
i__5727__auto___17738 = G__17739;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((1) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5733__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__14917){
var map__14918 = p__14917;
var map__14918__$1 = cljs.core.__destructure_map(map__14918);
var opts = map__14918__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq14911){
var G__14912 = cljs.core.first(seq14911);
var seq14911__$1 = cljs.core.next(seq14911);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14912,seq14911__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__14927 = arguments.length;
switch (G__14927) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__14693__auto___17743 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14694__auto__ = (function (){var switch__14359__auto__ = (function (state_14969){
var state_val_14970 = (state_14969[(1)]);
if((state_val_14970 === (7))){
var inst_14962 = (state_14969[(2)]);
var state_14969__$1 = state_14969;
var statearr_14988_17746 = state_14969__$1;
(statearr_14988_17746[(2)] = inst_14962);

(statearr_14988_17746[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14970 === (1))){
var state_14969__$1 = state_14969;
var statearr_14989_17747 = state_14969__$1;
(statearr_14989_17747[(2)] = null);

(statearr_14989_17747[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14970 === (4))){
var inst_14945 = (state_14969[(7)]);
var inst_14945__$1 = (state_14969[(2)]);
var inst_14946 = (inst_14945__$1 == null);
var state_14969__$1 = (function (){var statearr_14993 = state_14969;
(statearr_14993[(7)] = inst_14945__$1);

return statearr_14993;
})();
if(cljs.core.truth_(inst_14946)){
var statearr_14994_17748 = state_14969__$1;
(statearr_14994_17748[(1)] = (5));

} else {
var statearr_14995_17749 = state_14969__$1;
(statearr_14995_17749[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14970 === (13))){
var state_14969__$1 = state_14969;
var statearr_14996_17750 = state_14969__$1;
(statearr_14996_17750[(2)] = null);

(statearr_14996_17750[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14970 === (6))){
var inst_14945 = (state_14969[(7)]);
var state_14969__$1 = state_14969;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14969__$1,(11),to,inst_14945);
} else {
if((state_val_14970 === (3))){
var inst_14964 = (state_14969[(2)]);
var state_14969__$1 = state_14969;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14969__$1,inst_14964);
} else {
if((state_val_14970 === (12))){
var state_14969__$1 = state_14969;
var statearr_15001_17753 = state_14969__$1;
(statearr_15001_17753[(2)] = null);

(statearr_15001_17753[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14970 === (2))){
var state_14969__$1 = state_14969;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14969__$1,(4),from);
} else {
if((state_val_14970 === (11))){
var inst_14955 = (state_14969[(2)]);
var state_14969__$1 = state_14969;
if(cljs.core.truth_(inst_14955)){
var statearr_15003_17756 = state_14969__$1;
(statearr_15003_17756[(1)] = (12));

} else {
var statearr_15004_17757 = state_14969__$1;
(statearr_15004_17757[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14970 === (9))){
var state_14969__$1 = state_14969;
var statearr_15005_17758 = state_14969__$1;
(statearr_15005_17758[(2)] = null);

(statearr_15005_17758[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14970 === (5))){
var state_14969__$1 = state_14969;
if(cljs.core.truth_(close_QMARK_)){
var statearr_15006_17759 = state_14969__$1;
(statearr_15006_17759[(1)] = (8));

} else {
var statearr_15007_17760 = state_14969__$1;
(statearr_15007_17760[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14970 === (14))){
var inst_14960 = (state_14969[(2)]);
var state_14969__$1 = state_14969;
var statearr_15010_17761 = state_14969__$1;
(statearr_15010_17761[(2)] = inst_14960);

(statearr_15010_17761[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14970 === (10))){
var inst_14952 = (state_14969[(2)]);
var state_14969__$1 = state_14969;
var statearr_15012_17762 = state_14969__$1;
(statearr_15012_17762[(2)] = inst_14952);

(statearr_15012_17762[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14970 === (8))){
var inst_14949 = cljs.core.async.close_BANG_(to);
var state_14969__$1 = state_14969;
var statearr_15013_17763 = state_14969__$1;
(statearr_15013_17763[(2)] = inst_14949);

(statearr_15013_17763[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__14360__auto__ = null;
var cljs$core$async$state_machine__14360__auto____0 = (function (){
var statearr_15014 = [null,null,null,null,null,null,null,null];
(statearr_15014[(0)] = cljs$core$async$state_machine__14360__auto__);

(statearr_15014[(1)] = (1));

return statearr_15014;
});
var cljs$core$async$state_machine__14360__auto____1 = (function (state_14969){
while(true){
var ret_value__14361__auto__ = (function (){try{while(true){
var result__14362__auto__ = switch__14359__auto__(state_14969);
if(cljs.core.keyword_identical_QMARK_(result__14362__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14362__auto__;
}
break;
}
}catch (e15020){var ex__14363__auto__ = e15020;
var statearr_15021_17764 = state_14969;
(statearr_15021_17764[(2)] = ex__14363__auto__);


if(cljs.core.seq((state_14969[(4)]))){
var statearr_15023_17765 = state_14969;
(statearr_15023_17765[(1)] = cljs.core.first((state_14969[(4)])));

} else {
throw ex__14363__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14361__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17766 = state_14969;
state_14969 = G__17766;
continue;
} else {
return ret_value__14361__auto__;
}
break;
}
});
cljs$core$async$state_machine__14360__auto__ = function(state_14969){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14360__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14360__auto____1.call(this,state_14969);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14360__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14360__auto____0;
cljs$core$async$state_machine__14360__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14360__auto____1;
return cljs$core$async$state_machine__14360__auto__;
})()
})();
var state__14695__auto__ = (function (){var statearr_15026 = f__14694__auto__();
(statearr_15026[(6)] = c__14693__auto___17743);

return statearr_15026;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14695__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process__$1 = (function (p__15033){
var vec__15034 = p__15033;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15034,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15034,(1),null);
var job = vec__15034;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__14693__auto___17767 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14694__auto__ = (function (){var switch__14359__auto__ = (function (state_15046){
var state_val_15047 = (state_15046[(1)]);
if((state_val_15047 === (1))){
var state_15046__$1 = state_15046;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15046__$1,(2),res,v);
} else {
if((state_val_15047 === (2))){
var inst_15043 = (state_15046[(2)]);
var inst_15044 = cljs.core.async.close_BANG_(res);
var state_15046__$1 = (function (){var statearr_15048 = state_15046;
(statearr_15048[(7)] = inst_15043);

return statearr_15048;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_15046__$1,inst_15044);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14360__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14360__auto____0 = (function (){
var statearr_15049 = [null,null,null,null,null,null,null,null];
(statearr_15049[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14360__auto__);

(statearr_15049[(1)] = (1));

return statearr_15049;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14360__auto____1 = (function (state_15046){
while(true){
var ret_value__14361__auto__ = (function (){try{while(true){
var result__14362__auto__ = switch__14359__auto__(state_15046);
if(cljs.core.keyword_identical_QMARK_(result__14362__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14362__auto__;
}
break;
}
}catch (e15050){var ex__14363__auto__ = e15050;
var statearr_15051_17768 = state_15046;
(statearr_15051_17768[(2)] = ex__14363__auto__);


if(cljs.core.seq((state_15046[(4)]))){
var statearr_15052_17769 = state_15046;
(statearr_15052_17769[(1)] = cljs.core.first((state_15046[(4)])));

} else {
throw ex__14363__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14361__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17770 = state_15046;
state_15046 = G__17770;
continue;
} else {
return ret_value__14361__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14360__auto__ = function(state_15046){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14360__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14360__auto____1.call(this,state_15046);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14360__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14360__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14360__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14360__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14360__auto__;
})()
})();
var state__14695__auto__ = (function (){var statearr_15054 = f__14694__auto__();
(statearr_15054[(6)] = c__14693__auto___17767);

return statearr_15054;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14695__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__15056){
var vec__15057 = p__15056;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15057,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15057,(1),null);
var job = vec__15057;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__5593__auto___17771 = n;
var __17772 = (0);
while(true){
if((__17772 < n__5593__auto___17771)){
var G__15063_17773 = type;
var G__15063_17774__$1 = (((G__15063_17773 instanceof cljs.core.Keyword))?G__15063_17773.fqn:null);
switch (G__15063_17774__$1) {
case "compute":
var c__14693__auto___17776 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__17772,c__14693__auto___17776,G__15063_17773,G__15063_17774__$1,n__5593__auto___17771,jobs,results,process__$1,async){
return (function (){
var f__14694__auto__ = (function (){var switch__14359__auto__ = ((function (__17772,c__14693__auto___17776,G__15063_17773,G__15063_17774__$1,n__5593__auto___17771,jobs,results,process__$1,async){
return (function (state_15076){
var state_val_15077 = (state_15076[(1)]);
if((state_val_15077 === (1))){
var state_15076__$1 = state_15076;
var statearr_15079_17777 = state_15076__$1;
(statearr_15079_17777[(2)] = null);

(statearr_15079_17777[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15077 === (2))){
var state_15076__$1 = state_15076;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15076__$1,(4),jobs);
} else {
if((state_val_15077 === (3))){
var inst_15074 = (state_15076[(2)]);
var state_15076__$1 = state_15076;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15076__$1,inst_15074);
} else {
if((state_val_15077 === (4))){
var inst_15066 = (state_15076[(2)]);
var inst_15067 = process__$1(inst_15066);
var state_15076__$1 = state_15076;
if(cljs.core.truth_(inst_15067)){
var statearr_15085_17778 = state_15076__$1;
(statearr_15085_17778[(1)] = (5));

} else {
var statearr_15087_17779 = state_15076__$1;
(statearr_15087_17779[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15077 === (5))){
var state_15076__$1 = state_15076;
var statearr_15089_17780 = state_15076__$1;
(statearr_15089_17780[(2)] = null);

(statearr_15089_17780[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15077 === (6))){
var state_15076__$1 = state_15076;
var statearr_15090_17781 = state_15076__$1;
(statearr_15090_17781[(2)] = null);

(statearr_15090_17781[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15077 === (7))){
var inst_15072 = (state_15076[(2)]);
var state_15076__$1 = state_15076;
var statearr_15091_17782 = state_15076__$1;
(statearr_15091_17782[(2)] = inst_15072);

(statearr_15091_17782[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__17772,c__14693__auto___17776,G__15063_17773,G__15063_17774__$1,n__5593__auto___17771,jobs,results,process__$1,async))
;
return ((function (__17772,switch__14359__auto__,c__14693__auto___17776,G__15063_17773,G__15063_17774__$1,n__5593__auto___17771,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14360__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14360__auto____0 = (function (){
var statearr_15098 = [null,null,null,null,null,null,null];
(statearr_15098[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14360__auto__);

(statearr_15098[(1)] = (1));

return statearr_15098;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14360__auto____1 = (function (state_15076){
while(true){
var ret_value__14361__auto__ = (function (){try{while(true){
var result__14362__auto__ = switch__14359__auto__(state_15076);
if(cljs.core.keyword_identical_QMARK_(result__14362__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14362__auto__;
}
break;
}
}catch (e15100){var ex__14363__auto__ = e15100;
var statearr_15101_17783 = state_15076;
(statearr_15101_17783[(2)] = ex__14363__auto__);


if(cljs.core.seq((state_15076[(4)]))){
var statearr_15102_17784 = state_15076;
(statearr_15102_17784[(1)] = cljs.core.first((state_15076[(4)])));

} else {
throw ex__14363__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14361__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17788 = state_15076;
state_15076 = G__17788;
continue;
} else {
return ret_value__14361__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14360__auto__ = function(state_15076){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14360__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14360__auto____1.call(this,state_15076);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14360__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14360__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14360__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14360__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14360__auto__;
})()
;})(__17772,switch__14359__auto__,c__14693__auto___17776,G__15063_17773,G__15063_17774__$1,n__5593__auto___17771,jobs,results,process__$1,async))
})();
var state__14695__auto__ = (function (){var statearr_15104 = f__14694__auto__();
(statearr_15104[(6)] = c__14693__auto___17776);

return statearr_15104;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14695__auto__);
});})(__17772,c__14693__auto___17776,G__15063_17773,G__15063_17774__$1,n__5593__auto___17771,jobs,results,process__$1,async))
);


break;
case "async":
var c__14693__auto___17789 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__17772,c__14693__auto___17789,G__15063_17773,G__15063_17774__$1,n__5593__auto___17771,jobs,results,process__$1,async){
return (function (){
var f__14694__auto__ = (function (){var switch__14359__auto__ = ((function (__17772,c__14693__auto___17789,G__15063_17773,G__15063_17774__$1,n__5593__auto___17771,jobs,results,process__$1,async){
return (function (state_15120){
var state_val_15121 = (state_15120[(1)]);
if((state_val_15121 === (1))){
var state_15120__$1 = state_15120;
var statearr_15128_17790 = state_15120__$1;
(statearr_15128_17790[(2)] = null);

(statearr_15128_17790[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15121 === (2))){
var state_15120__$1 = state_15120;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15120__$1,(4),jobs);
} else {
if((state_val_15121 === (3))){
var inst_15118 = (state_15120[(2)]);
var state_15120__$1 = state_15120;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15120__$1,inst_15118);
} else {
if((state_val_15121 === (4))){
var inst_15109 = (state_15120[(2)]);
var inst_15110 = async(inst_15109);
var state_15120__$1 = state_15120;
if(cljs.core.truth_(inst_15110)){
var statearr_15133_17791 = state_15120__$1;
(statearr_15133_17791[(1)] = (5));

} else {
var statearr_15134_17792 = state_15120__$1;
(statearr_15134_17792[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15121 === (5))){
var state_15120__$1 = state_15120;
var statearr_15138_17793 = state_15120__$1;
(statearr_15138_17793[(2)] = null);

(statearr_15138_17793[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15121 === (6))){
var state_15120__$1 = state_15120;
var statearr_15139_17794 = state_15120__$1;
(statearr_15139_17794[(2)] = null);

(statearr_15139_17794[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15121 === (7))){
var inst_15116 = (state_15120[(2)]);
var state_15120__$1 = state_15120;
var statearr_15143_17795 = state_15120__$1;
(statearr_15143_17795[(2)] = inst_15116);

(statearr_15143_17795[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__17772,c__14693__auto___17789,G__15063_17773,G__15063_17774__$1,n__5593__auto___17771,jobs,results,process__$1,async))
;
return ((function (__17772,switch__14359__auto__,c__14693__auto___17789,G__15063_17773,G__15063_17774__$1,n__5593__auto___17771,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14360__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14360__auto____0 = (function (){
var statearr_15144 = [null,null,null,null,null,null,null];
(statearr_15144[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14360__auto__);

(statearr_15144[(1)] = (1));

return statearr_15144;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14360__auto____1 = (function (state_15120){
while(true){
var ret_value__14361__auto__ = (function (){try{while(true){
var result__14362__auto__ = switch__14359__auto__(state_15120);
if(cljs.core.keyword_identical_QMARK_(result__14362__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14362__auto__;
}
break;
}
}catch (e15146){var ex__14363__auto__ = e15146;
var statearr_15150_17796 = state_15120;
(statearr_15150_17796[(2)] = ex__14363__auto__);


if(cljs.core.seq((state_15120[(4)]))){
var statearr_15151_17797 = state_15120;
(statearr_15151_17797[(1)] = cljs.core.first((state_15120[(4)])));

} else {
throw ex__14363__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14361__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17798 = state_15120;
state_15120 = G__17798;
continue;
} else {
return ret_value__14361__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14360__auto__ = function(state_15120){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14360__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14360__auto____1.call(this,state_15120);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14360__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14360__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14360__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14360__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14360__auto__;
})()
;})(__17772,switch__14359__auto__,c__14693__auto___17789,G__15063_17773,G__15063_17774__$1,n__5593__auto___17771,jobs,results,process__$1,async))
})();
var state__14695__auto__ = (function (){var statearr_15154 = f__14694__auto__();
(statearr_15154[(6)] = c__14693__auto___17789);

return statearr_15154;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14695__auto__);
});})(__17772,c__14693__auto___17789,G__15063_17773,G__15063_17774__$1,n__5593__auto___17771,jobs,results,process__$1,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__15063_17774__$1)].join('')));

}

var G__17799 = (__17772 + (1));
__17772 = G__17799;
continue;
} else {
}
break;
}

var c__14693__auto___17800 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14694__auto__ = (function (){var switch__14359__auto__ = (function (state_15184){
var state_val_15185 = (state_15184[(1)]);
if((state_val_15185 === (7))){
var inst_15180 = (state_15184[(2)]);
var state_15184__$1 = state_15184;
var statearr_15208_17801 = state_15184__$1;
(statearr_15208_17801[(2)] = inst_15180);

(statearr_15208_17801[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15185 === (1))){
var state_15184__$1 = state_15184;
var statearr_15209_17802 = state_15184__$1;
(statearr_15209_17802[(2)] = null);

(statearr_15209_17802[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15185 === (4))){
var inst_15161 = (state_15184[(7)]);
var inst_15161__$1 = (state_15184[(2)]);
var inst_15162 = (inst_15161__$1 == null);
var state_15184__$1 = (function (){var statearr_15210 = state_15184;
(statearr_15210[(7)] = inst_15161__$1);

return statearr_15210;
})();
if(cljs.core.truth_(inst_15162)){
var statearr_15211_17803 = state_15184__$1;
(statearr_15211_17803[(1)] = (5));

} else {
var statearr_15212_17804 = state_15184__$1;
(statearr_15212_17804[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15185 === (6))){
var inst_15161 = (state_15184[(7)]);
var inst_15167 = (state_15184[(8)]);
var inst_15167__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_15170 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15172 = [inst_15161,inst_15167__$1];
var inst_15173 = (new cljs.core.PersistentVector(null,2,(5),inst_15170,inst_15172,null));
var state_15184__$1 = (function (){var statearr_15213 = state_15184;
(statearr_15213[(8)] = inst_15167__$1);

return statearr_15213;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15184__$1,(8),jobs,inst_15173);
} else {
if((state_val_15185 === (3))){
var inst_15182 = (state_15184[(2)]);
var state_15184__$1 = state_15184;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15184__$1,inst_15182);
} else {
if((state_val_15185 === (2))){
var state_15184__$1 = state_15184;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15184__$1,(4),from);
} else {
if((state_val_15185 === (9))){
var inst_15177 = (state_15184[(2)]);
var state_15184__$1 = (function (){var statearr_15215 = state_15184;
(statearr_15215[(9)] = inst_15177);

return statearr_15215;
})();
var statearr_15217_17810 = state_15184__$1;
(statearr_15217_17810[(2)] = null);

(statearr_15217_17810[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15185 === (5))){
var inst_15165 = cljs.core.async.close_BANG_(jobs);
var state_15184__$1 = state_15184;
var statearr_15219_17812 = state_15184__$1;
(statearr_15219_17812[(2)] = inst_15165);

(statearr_15219_17812[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15185 === (8))){
var inst_15167 = (state_15184[(8)]);
var inst_15175 = (state_15184[(2)]);
var state_15184__$1 = (function (){var statearr_15220 = state_15184;
(statearr_15220[(10)] = inst_15175);

return statearr_15220;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15184__$1,(9),results,inst_15167);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14360__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14360__auto____0 = (function (){
var statearr_15221 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_15221[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14360__auto__);

(statearr_15221[(1)] = (1));

return statearr_15221;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14360__auto____1 = (function (state_15184){
while(true){
var ret_value__14361__auto__ = (function (){try{while(true){
var result__14362__auto__ = switch__14359__auto__(state_15184);
if(cljs.core.keyword_identical_QMARK_(result__14362__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14362__auto__;
}
break;
}
}catch (e15222){var ex__14363__auto__ = e15222;
var statearr_15223_17814 = state_15184;
(statearr_15223_17814[(2)] = ex__14363__auto__);


if(cljs.core.seq((state_15184[(4)]))){
var statearr_15224_17815 = state_15184;
(statearr_15224_17815[(1)] = cljs.core.first((state_15184[(4)])));

} else {
throw ex__14363__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14361__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17816 = state_15184;
state_15184 = G__17816;
continue;
} else {
return ret_value__14361__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14360__auto__ = function(state_15184){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14360__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14360__auto____1.call(this,state_15184);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14360__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14360__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14360__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14360__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14360__auto__;
})()
})();
var state__14695__auto__ = (function (){var statearr_15225 = f__14694__auto__();
(statearr_15225[(6)] = c__14693__auto___17800);

return statearr_15225;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14695__auto__);
}));


var c__14693__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14694__auto__ = (function (){var switch__14359__auto__ = (function (state_15263){
var state_val_15264 = (state_15263[(1)]);
if((state_val_15264 === (7))){
var inst_15259 = (state_15263[(2)]);
var state_15263__$1 = state_15263;
var statearr_15286_17817 = state_15263__$1;
(statearr_15286_17817[(2)] = inst_15259);

(statearr_15286_17817[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15264 === (20))){
var state_15263__$1 = state_15263;
var statearr_15288_17818 = state_15263__$1;
(statearr_15288_17818[(2)] = null);

(statearr_15288_17818[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15264 === (1))){
var state_15263__$1 = state_15263;
var statearr_15291_17820 = state_15263__$1;
(statearr_15291_17820[(2)] = null);

(statearr_15291_17820[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15264 === (4))){
var inst_15228 = (state_15263[(7)]);
var inst_15228__$1 = (state_15263[(2)]);
var inst_15229 = (inst_15228__$1 == null);
var state_15263__$1 = (function (){var statearr_15293 = state_15263;
(statearr_15293[(7)] = inst_15228__$1);

return statearr_15293;
})();
if(cljs.core.truth_(inst_15229)){
var statearr_15294_17821 = state_15263__$1;
(statearr_15294_17821[(1)] = (5));

} else {
var statearr_15295_17822 = state_15263__$1;
(statearr_15295_17822[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15264 === (15))){
var inst_15241 = (state_15263[(8)]);
var state_15263__$1 = state_15263;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15263__$1,(18),to,inst_15241);
} else {
if((state_val_15264 === (21))){
var inst_15254 = (state_15263[(2)]);
var state_15263__$1 = state_15263;
var statearr_15298_17823 = state_15263__$1;
(statearr_15298_17823[(2)] = inst_15254);

(statearr_15298_17823[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15264 === (13))){
var inst_15256 = (state_15263[(2)]);
var state_15263__$1 = (function (){var statearr_15300 = state_15263;
(statearr_15300[(9)] = inst_15256);

return statearr_15300;
})();
var statearr_15303_17824 = state_15263__$1;
(statearr_15303_17824[(2)] = null);

(statearr_15303_17824[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15264 === (6))){
var inst_15228 = (state_15263[(7)]);
var state_15263__$1 = state_15263;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15263__$1,(11),inst_15228);
} else {
if((state_val_15264 === (17))){
var inst_15249 = (state_15263[(2)]);
var state_15263__$1 = state_15263;
if(cljs.core.truth_(inst_15249)){
var statearr_15305_17825 = state_15263__$1;
(statearr_15305_17825[(1)] = (19));

} else {
var statearr_15306_17826 = state_15263__$1;
(statearr_15306_17826[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15264 === (3))){
var inst_15261 = (state_15263[(2)]);
var state_15263__$1 = state_15263;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15263__$1,inst_15261);
} else {
if((state_val_15264 === (12))){
var inst_15238 = (state_15263[(10)]);
var state_15263__$1 = state_15263;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15263__$1,(14),inst_15238);
} else {
if((state_val_15264 === (2))){
var state_15263__$1 = state_15263;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15263__$1,(4),results);
} else {
if((state_val_15264 === (19))){
var state_15263__$1 = state_15263;
var statearr_15308_17831 = state_15263__$1;
(statearr_15308_17831[(2)] = null);

(statearr_15308_17831[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15264 === (11))){
var inst_15238 = (state_15263[(2)]);
var state_15263__$1 = (function (){var statearr_15309 = state_15263;
(statearr_15309[(10)] = inst_15238);

return statearr_15309;
})();
var statearr_15313_17832 = state_15263__$1;
(statearr_15313_17832[(2)] = null);

(statearr_15313_17832[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15264 === (9))){
var state_15263__$1 = state_15263;
var statearr_15314_17833 = state_15263__$1;
(statearr_15314_17833[(2)] = null);

(statearr_15314_17833[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15264 === (5))){
var state_15263__$1 = state_15263;
if(cljs.core.truth_(close_QMARK_)){
var statearr_15315_17834 = state_15263__$1;
(statearr_15315_17834[(1)] = (8));

} else {
var statearr_15316_17835 = state_15263__$1;
(statearr_15316_17835[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15264 === (14))){
var inst_15241 = (state_15263[(8)]);
var inst_15243 = (state_15263[(11)]);
var inst_15241__$1 = (state_15263[(2)]);
var inst_15242 = (inst_15241__$1 == null);
var inst_15243__$1 = cljs.core.not(inst_15242);
var state_15263__$1 = (function (){var statearr_15317 = state_15263;
(statearr_15317[(8)] = inst_15241__$1);

(statearr_15317[(11)] = inst_15243__$1);

return statearr_15317;
})();
if(inst_15243__$1){
var statearr_15318_17836 = state_15263__$1;
(statearr_15318_17836[(1)] = (15));

} else {
var statearr_15319_17837 = state_15263__$1;
(statearr_15319_17837[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15264 === (16))){
var inst_15243 = (state_15263[(11)]);
var state_15263__$1 = state_15263;
var statearr_15321_17838 = state_15263__$1;
(statearr_15321_17838[(2)] = inst_15243);

(statearr_15321_17838[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15264 === (10))){
var inst_15235 = (state_15263[(2)]);
var state_15263__$1 = state_15263;
var statearr_15322_17839 = state_15263__$1;
(statearr_15322_17839[(2)] = inst_15235);

(statearr_15322_17839[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15264 === (18))){
var inst_15246 = (state_15263[(2)]);
var state_15263__$1 = state_15263;
var statearr_15323_17840 = state_15263__$1;
(statearr_15323_17840[(2)] = inst_15246);

(statearr_15323_17840[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15264 === (8))){
var inst_15232 = cljs.core.async.close_BANG_(to);
var state_15263__$1 = state_15263;
var statearr_15324_17841 = state_15263__$1;
(statearr_15324_17841[(2)] = inst_15232);

(statearr_15324_17841[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14360__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14360__auto____0 = (function (){
var statearr_15327 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15327[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14360__auto__);

(statearr_15327[(1)] = (1));

return statearr_15327;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14360__auto____1 = (function (state_15263){
while(true){
var ret_value__14361__auto__ = (function (){try{while(true){
var result__14362__auto__ = switch__14359__auto__(state_15263);
if(cljs.core.keyword_identical_QMARK_(result__14362__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14362__auto__;
}
break;
}
}catch (e15328){var ex__14363__auto__ = e15328;
var statearr_15329_17842 = state_15263;
(statearr_15329_17842[(2)] = ex__14363__auto__);


if(cljs.core.seq((state_15263[(4)]))){
var statearr_15330_17843 = state_15263;
(statearr_15330_17843[(1)] = cljs.core.first((state_15263[(4)])));

} else {
throw ex__14363__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14361__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17844 = state_15263;
state_15263 = G__17844;
continue;
} else {
return ret_value__14361__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14360__auto__ = function(state_15263){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14360__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14360__auto____1.call(this,state_15263);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14360__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14360__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14360__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14360__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14360__auto__;
})()
})();
var state__14695__auto__ = (function (){var statearr_15331 = f__14694__auto__();
(statearr_15331[(6)] = c__14693__auto__);

return statearr_15331;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14695__auto__);
}));

return c__14693__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). The
 *   presumption is that af will return immediately, having launched some
 *   asynchronous operation whose completion/callback will put results on
 *   the channel, then close! it. Outputs will be returned in order
 *   relative to the inputs. By default, the to channel will be closed
 *   when the from channel closes, but can be determined by the close?
 *   parameter. Will stop consuming the from channel if the to channel
 *   closes. See also pipeline, pipeline-blocking.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__15333 = arguments.length;
switch (G__15333) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__15335 = arguments.length;
switch (G__15335) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__15352 = arguments.length;
switch (G__15352) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__14693__auto___17849 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14694__auto__ = (function (){var switch__14359__auto__ = (function (state_15382){
var state_val_15383 = (state_15382[(1)]);
if((state_val_15383 === (7))){
var inst_15378 = (state_15382[(2)]);
var state_15382__$1 = state_15382;
var statearr_15387_17850 = state_15382__$1;
(statearr_15387_17850[(2)] = inst_15378);

(statearr_15387_17850[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15383 === (1))){
var state_15382__$1 = state_15382;
var statearr_15388_17851 = state_15382__$1;
(statearr_15388_17851[(2)] = null);

(statearr_15388_17851[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15383 === (4))){
var inst_15359 = (state_15382[(7)]);
var inst_15359__$1 = (state_15382[(2)]);
var inst_15360 = (inst_15359__$1 == null);
var state_15382__$1 = (function (){var statearr_15389 = state_15382;
(statearr_15389[(7)] = inst_15359__$1);

return statearr_15389;
})();
if(cljs.core.truth_(inst_15360)){
var statearr_15390_17853 = state_15382__$1;
(statearr_15390_17853[(1)] = (5));

} else {
var statearr_15391_17854 = state_15382__$1;
(statearr_15391_17854[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15383 === (13))){
var state_15382__$1 = state_15382;
var statearr_15396_17855 = state_15382__$1;
(statearr_15396_17855[(2)] = null);

(statearr_15396_17855[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15383 === (6))){
var inst_15359 = (state_15382[(7)]);
var inst_15365 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_15359) : p.call(null,inst_15359));
var state_15382__$1 = state_15382;
if(cljs.core.truth_(inst_15365)){
var statearr_15402_17856 = state_15382__$1;
(statearr_15402_17856[(1)] = (9));

} else {
var statearr_15404_17857 = state_15382__$1;
(statearr_15404_17857[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15383 === (3))){
var inst_15380 = (state_15382[(2)]);
var state_15382__$1 = state_15382;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15382__$1,inst_15380);
} else {
if((state_val_15383 === (12))){
var state_15382__$1 = state_15382;
var statearr_15406_17858 = state_15382__$1;
(statearr_15406_17858[(2)] = null);

(statearr_15406_17858[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15383 === (2))){
var state_15382__$1 = state_15382;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15382__$1,(4),ch);
} else {
if((state_val_15383 === (11))){
var inst_15359 = (state_15382[(7)]);
var inst_15369 = (state_15382[(2)]);
var state_15382__$1 = state_15382;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15382__$1,(8),inst_15369,inst_15359);
} else {
if((state_val_15383 === (9))){
var state_15382__$1 = state_15382;
var statearr_15412_17860 = state_15382__$1;
(statearr_15412_17860[(2)] = tc);

(statearr_15412_17860[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15383 === (5))){
var inst_15362 = cljs.core.async.close_BANG_(tc);
var inst_15363 = cljs.core.async.close_BANG_(fc);
var state_15382__$1 = (function (){var statearr_15415 = state_15382;
(statearr_15415[(8)] = inst_15362);

return statearr_15415;
})();
var statearr_15416_17861 = state_15382__$1;
(statearr_15416_17861[(2)] = inst_15363);

(statearr_15416_17861[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15383 === (14))){
var inst_15376 = (state_15382[(2)]);
var state_15382__$1 = state_15382;
var statearr_15417_17863 = state_15382__$1;
(statearr_15417_17863[(2)] = inst_15376);

(statearr_15417_17863[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15383 === (10))){
var state_15382__$1 = state_15382;
var statearr_15421_17864 = state_15382__$1;
(statearr_15421_17864[(2)] = fc);

(statearr_15421_17864[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15383 === (8))){
var inst_15371 = (state_15382[(2)]);
var state_15382__$1 = state_15382;
if(cljs.core.truth_(inst_15371)){
var statearr_15425_17868 = state_15382__$1;
(statearr_15425_17868[(1)] = (12));

} else {
var statearr_15430_17869 = state_15382__$1;
(statearr_15430_17869[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__14360__auto__ = null;
var cljs$core$async$state_machine__14360__auto____0 = (function (){
var statearr_15431 = [null,null,null,null,null,null,null,null,null];
(statearr_15431[(0)] = cljs$core$async$state_machine__14360__auto__);

(statearr_15431[(1)] = (1));

return statearr_15431;
});
var cljs$core$async$state_machine__14360__auto____1 = (function (state_15382){
while(true){
var ret_value__14361__auto__ = (function (){try{while(true){
var result__14362__auto__ = switch__14359__auto__(state_15382);
if(cljs.core.keyword_identical_QMARK_(result__14362__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14362__auto__;
}
break;
}
}catch (e15432){var ex__14363__auto__ = e15432;
var statearr_15433_17870 = state_15382;
(statearr_15433_17870[(2)] = ex__14363__auto__);


if(cljs.core.seq((state_15382[(4)]))){
var statearr_15434_17871 = state_15382;
(statearr_15434_17871[(1)] = cljs.core.first((state_15382[(4)])));

} else {
throw ex__14363__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14361__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17872 = state_15382;
state_15382 = G__17872;
continue;
} else {
return ret_value__14361__auto__;
}
break;
}
});
cljs$core$async$state_machine__14360__auto__ = function(state_15382){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14360__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14360__auto____1.call(this,state_15382);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14360__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14360__auto____0;
cljs$core$async$state_machine__14360__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14360__auto____1;
return cljs$core$async$state_machine__14360__auto__;
})()
})();
var state__14695__auto__ = (function (){var statearr_15438 = f__14694__auto__();
(statearr_15438[(6)] = c__14693__auto___17849);

return statearr_15438;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14695__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__14693__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14694__auto__ = (function (){var switch__14359__auto__ = (function (state_15464){
var state_val_15467 = (state_15464[(1)]);
if((state_val_15467 === (7))){
var inst_15460 = (state_15464[(2)]);
var state_15464__$1 = state_15464;
var statearr_15468_17873 = state_15464__$1;
(statearr_15468_17873[(2)] = inst_15460);

(statearr_15468_17873[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15467 === (1))){
var inst_15442 = init;
var inst_15443 = inst_15442;
var state_15464__$1 = (function (){var statearr_15469 = state_15464;
(statearr_15469[(7)] = inst_15443);

return statearr_15469;
})();
var statearr_15470_17874 = state_15464__$1;
(statearr_15470_17874[(2)] = null);

(statearr_15470_17874[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15467 === (4))){
var inst_15447 = (state_15464[(8)]);
var inst_15447__$1 = (state_15464[(2)]);
var inst_15448 = (inst_15447__$1 == null);
var state_15464__$1 = (function (){var statearr_15471 = state_15464;
(statearr_15471[(8)] = inst_15447__$1);

return statearr_15471;
})();
if(cljs.core.truth_(inst_15448)){
var statearr_15472_17875 = state_15464__$1;
(statearr_15472_17875[(1)] = (5));

} else {
var statearr_15473_17876 = state_15464__$1;
(statearr_15473_17876[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15467 === (6))){
var inst_15451 = (state_15464[(9)]);
var inst_15447 = (state_15464[(8)]);
var inst_15443 = (state_15464[(7)]);
var inst_15451__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_15443,inst_15447) : f.call(null,inst_15443,inst_15447));
var inst_15452 = cljs.core.reduced_QMARK_(inst_15451__$1);
var state_15464__$1 = (function (){var statearr_15475 = state_15464;
(statearr_15475[(9)] = inst_15451__$1);

return statearr_15475;
})();
if(inst_15452){
var statearr_15476_17877 = state_15464__$1;
(statearr_15476_17877[(1)] = (8));

} else {
var statearr_15477_17878 = state_15464__$1;
(statearr_15477_17878[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15467 === (3))){
var inst_15462 = (state_15464[(2)]);
var state_15464__$1 = state_15464;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15464__$1,inst_15462);
} else {
if((state_val_15467 === (2))){
var state_15464__$1 = state_15464;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15464__$1,(4),ch);
} else {
if((state_val_15467 === (9))){
var inst_15451 = (state_15464[(9)]);
var inst_15443 = inst_15451;
var state_15464__$1 = (function (){var statearr_15479 = state_15464;
(statearr_15479[(7)] = inst_15443);

return statearr_15479;
})();
var statearr_15484_17879 = state_15464__$1;
(statearr_15484_17879[(2)] = null);

(statearr_15484_17879[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15467 === (5))){
var inst_15443 = (state_15464[(7)]);
var state_15464__$1 = state_15464;
var statearr_15493_17881 = state_15464__$1;
(statearr_15493_17881[(2)] = inst_15443);

(statearr_15493_17881[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15467 === (10))){
var inst_15458 = (state_15464[(2)]);
var state_15464__$1 = state_15464;
var statearr_15505_17882 = state_15464__$1;
(statearr_15505_17882[(2)] = inst_15458);

(statearr_15505_17882[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15467 === (8))){
var inst_15451 = (state_15464[(9)]);
var inst_15454 = cljs.core.deref(inst_15451);
var state_15464__$1 = state_15464;
var statearr_15508_17883 = state_15464__$1;
(statearr_15508_17883[(2)] = inst_15454);

(statearr_15508_17883[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__14360__auto__ = null;
var cljs$core$async$reduce_$_state_machine__14360__auto____0 = (function (){
var statearr_15509 = [null,null,null,null,null,null,null,null,null,null];
(statearr_15509[(0)] = cljs$core$async$reduce_$_state_machine__14360__auto__);

(statearr_15509[(1)] = (1));

return statearr_15509;
});
var cljs$core$async$reduce_$_state_machine__14360__auto____1 = (function (state_15464){
while(true){
var ret_value__14361__auto__ = (function (){try{while(true){
var result__14362__auto__ = switch__14359__auto__(state_15464);
if(cljs.core.keyword_identical_QMARK_(result__14362__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14362__auto__;
}
break;
}
}catch (e15510){var ex__14363__auto__ = e15510;
var statearr_15511_17885 = state_15464;
(statearr_15511_17885[(2)] = ex__14363__auto__);


if(cljs.core.seq((state_15464[(4)]))){
var statearr_15512_17886 = state_15464;
(statearr_15512_17886[(1)] = cljs.core.first((state_15464[(4)])));

} else {
throw ex__14363__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14361__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17887 = state_15464;
state_15464 = G__17887;
continue;
} else {
return ret_value__14361__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__14360__auto__ = function(state_15464){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__14360__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__14360__auto____1.call(this,state_15464);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__14360__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__14360__auto____0;
cljs$core$async$reduce_$_state_machine__14360__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__14360__auto____1;
return cljs$core$async$reduce_$_state_machine__14360__auto__;
})()
})();
var state__14695__auto__ = (function (){var statearr_15514 = f__14694__auto__();
(statearr_15514[(6)] = c__14693__auto__);

return statearr_15514;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14695__auto__);
}));

return c__14693__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__14693__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14694__auto__ = (function (){var switch__14359__auto__ = (function (state_15522){
var state_val_15523 = (state_15522[(1)]);
if((state_val_15523 === (1))){
var inst_15517 = cljs.core.async.reduce(f__$1,init,ch);
var state_15522__$1 = state_15522;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15522__$1,(2),inst_15517);
} else {
if((state_val_15523 === (2))){
var inst_15519 = (state_15522[(2)]);
var inst_15520 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_15519) : f__$1.call(null,inst_15519));
var state_15522__$1 = state_15522;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15522__$1,inst_15520);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__14360__auto__ = null;
var cljs$core$async$transduce_$_state_machine__14360__auto____0 = (function (){
var statearr_15524 = [null,null,null,null,null,null,null];
(statearr_15524[(0)] = cljs$core$async$transduce_$_state_machine__14360__auto__);

(statearr_15524[(1)] = (1));

return statearr_15524;
});
var cljs$core$async$transduce_$_state_machine__14360__auto____1 = (function (state_15522){
while(true){
var ret_value__14361__auto__ = (function (){try{while(true){
var result__14362__auto__ = switch__14359__auto__(state_15522);
if(cljs.core.keyword_identical_QMARK_(result__14362__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14362__auto__;
}
break;
}
}catch (e15535){var ex__14363__auto__ = e15535;
var statearr_15537_17888 = state_15522;
(statearr_15537_17888[(2)] = ex__14363__auto__);


if(cljs.core.seq((state_15522[(4)]))){
var statearr_15550_17889 = state_15522;
(statearr_15550_17889[(1)] = cljs.core.first((state_15522[(4)])));

} else {
throw ex__14363__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14361__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17890 = state_15522;
state_15522 = G__17890;
continue;
} else {
return ret_value__14361__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__14360__auto__ = function(state_15522){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__14360__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__14360__auto____1.call(this,state_15522);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__14360__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__14360__auto____0;
cljs$core$async$transduce_$_state_machine__14360__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__14360__auto____1;
return cljs$core$async$transduce_$_state_machine__14360__auto__;
})()
})();
var state__14695__auto__ = (function (){var statearr_15555 = f__14694__auto__();
(statearr_15555[(6)] = c__14693__auto__);

return statearr_15555;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14695__auto__);
}));

return c__14693__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__15562 = arguments.length;
switch (G__15562) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__14693__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14694__auto__ = (function (){var switch__14359__auto__ = (function (state_15630){
var state_val_15631 = (state_15630[(1)]);
if((state_val_15631 === (7))){
var inst_15604 = (state_15630[(2)]);
var state_15630__$1 = state_15630;
var statearr_15633_17892 = state_15630__$1;
(statearr_15633_17892[(2)] = inst_15604);

(statearr_15633_17892[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15631 === (1))){
var inst_15594 = cljs.core.seq(coll);
var inst_15595 = inst_15594;
var state_15630__$1 = (function (){var statearr_15634 = state_15630;
(statearr_15634[(7)] = inst_15595);

return statearr_15634;
})();
var statearr_15635_17893 = state_15630__$1;
(statearr_15635_17893[(2)] = null);

(statearr_15635_17893[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15631 === (4))){
var inst_15595 = (state_15630[(7)]);
var inst_15602 = cljs.core.first(inst_15595);
var state_15630__$1 = state_15630;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15630__$1,(7),ch,inst_15602);
} else {
if((state_val_15631 === (13))){
var inst_15619 = (state_15630[(2)]);
var state_15630__$1 = state_15630;
var statearr_15636_17894 = state_15630__$1;
(statearr_15636_17894[(2)] = inst_15619);

(statearr_15636_17894[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15631 === (6))){
var inst_15607 = (state_15630[(2)]);
var state_15630__$1 = state_15630;
if(cljs.core.truth_(inst_15607)){
var statearr_15638_17895 = state_15630__$1;
(statearr_15638_17895[(1)] = (8));

} else {
var statearr_15639_17896 = state_15630__$1;
(statearr_15639_17896[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15631 === (3))){
var inst_15624 = (state_15630[(2)]);
var state_15630__$1 = state_15630;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15630__$1,inst_15624);
} else {
if((state_val_15631 === (12))){
var state_15630__$1 = state_15630;
var statearr_15643_17897 = state_15630__$1;
(statearr_15643_17897[(2)] = null);

(statearr_15643_17897[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15631 === (2))){
var inst_15595 = (state_15630[(7)]);
var state_15630__$1 = state_15630;
if(cljs.core.truth_(inst_15595)){
var statearr_15647_17898 = state_15630__$1;
(statearr_15647_17898[(1)] = (4));

} else {
var statearr_15648_17899 = state_15630__$1;
(statearr_15648_17899[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15631 === (11))){
var inst_15616 = cljs.core.async.close_BANG_(ch);
var state_15630__$1 = state_15630;
var statearr_15649_17900 = state_15630__$1;
(statearr_15649_17900[(2)] = inst_15616);

(statearr_15649_17900[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15631 === (9))){
var state_15630__$1 = state_15630;
if(cljs.core.truth_(close_QMARK_)){
var statearr_15650_17901 = state_15630__$1;
(statearr_15650_17901[(1)] = (11));

} else {
var statearr_15651_17902 = state_15630__$1;
(statearr_15651_17902[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15631 === (5))){
var inst_15595 = (state_15630[(7)]);
var state_15630__$1 = state_15630;
var statearr_15652_17906 = state_15630__$1;
(statearr_15652_17906[(2)] = inst_15595);

(statearr_15652_17906[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15631 === (10))){
var inst_15621 = (state_15630[(2)]);
var state_15630__$1 = state_15630;
var statearr_15653_17907 = state_15630__$1;
(statearr_15653_17907[(2)] = inst_15621);

(statearr_15653_17907[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15631 === (8))){
var inst_15595 = (state_15630[(7)]);
var inst_15609 = cljs.core.next(inst_15595);
var inst_15595__$1 = inst_15609;
var state_15630__$1 = (function (){var statearr_15654 = state_15630;
(statearr_15654[(7)] = inst_15595__$1);

return statearr_15654;
})();
var statearr_15655_17908 = state_15630__$1;
(statearr_15655_17908[(2)] = null);

(statearr_15655_17908[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__14360__auto__ = null;
var cljs$core$async$state_machine__14360__auto____0 = (function (){
var statearr_15660 = [null,null,null,null,null,null,null,null];
(statearr_15660[(0)] = cljs$core$async$state_machine__14360__auto__);

(statearr_15660[(1)] = (1));

return statearr_15660;
});
var cljs$core$async$state_machine__14360__auto____1 = (function (state_15630){
while(true){
var ret_value__14361__auto__ = (function (){try{while(true){
var result__14362__auto__ = switch__14359__auto__(state_15630);
if(cljs.core.keyword_identical_QMARK_(result__14362__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14362__auto__;
}
break;
}
}catch (e15661){var ex__14363__auto__ = e15661;
var statearr_15662_17909 = state_15630;
(statearr_15662_17909[(2)] = ex__14363__auto__);


if(cljs.core.seq((state_15630[(4)]))){
var statearr_15663_17910 = state_15630;
(statearr_15663_17910[(1)] = cljs.core.first((state_15630[(4)])));

} else {
throw ex__14363__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14361__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17911 = state_15630;
state_15630 = G__17911;
continue;
} else {
return ret_value__14361__auto__;
}
break;
}
});
cljs$core$async$state_machine__14360__auto__ = function(state_15630){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14360__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14360__auto____1.call(this,state_15630);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14360__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14360__auto____0;
cljs$core$async$state_machine__14360__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14360__auto____1;
return cljs$core$async$state_machine__14360__auto__;
})()
})();
var state__14695__auto__ = (function (){var statearr_15664 = f__14694__auto__();
(statearr_15664[(6)] = c__14693__auto__);

return statearr_15664;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14695__auto__);
}));

return c__14693__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__15667 = arguments.length;
switch (G__15667) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_17916 = (function (_){
var x__5350__auto__ = (((_ == null))?null:_);
var m__5351__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5351__auto__.call(null,_));
} else {
var m__5349__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5349__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_17916(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_17918 = (function (m,ch,close_QMARK_){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5351__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__5349__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5349__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_17918(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_17923 = (function (m,ch){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5351__auto__.call(null,m,ch));
} else {
var m__5349__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5349__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_17923(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_17926 = (function (m){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5351__auto__.call(null,m));
} else {
var m__5349__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5349__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_17926(m);
}
});


/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15688 = (function (ch,cs,meta15689){
this.ch = ch;
this.cs = cs;
this.meta15689 = meta15689;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async15688.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15690,meta15689__$1){
var self__ = this;
var _15690__$1 = this;
return (new cljs.core.async.t_cljs$core$async15688(self__.ch,self__.cs,meta15689__$1));
}));

(cljs.core.async.t_cljs$core$async15688.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15690){
var self__ = this;
var _15690__$1 = this;
return self__.meta15689;
}));

(cljs.core.async.t_cljs$core$async15688.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15688.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async15688.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15688.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async15688.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async15688.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async15688.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta15689","meta15689",108513783,null)], null);
}));

(cljs.core.async.t_cljs$core$async15688.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async15688.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15688");

(cljs.core.async.t_cljs$core$async15688.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async15688");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async15688.
 */
cljs.core.async.__GT_t_cljs$core$async15688 = (function cljs$core$async$__GT_t_cljs$core$async15688(ch,cs,meta15689){
return (new cljs.core.async.t_cljs$core$async15688(ch,cs,meta15689));
});


/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (new cljs.core.async.t_cljs$core$async15688(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__14693__auto___17930 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14694__auto__ = (function (){var switch__14359__auto__ = (function (state_15840){
var state_val_15841 = (state_15840[(1)]);
if((state_val_15841 === (7))){
var inst_15836 = (state_15840[(2)]);
var state_15840__$1 = state_15840;
var statearr_15844_17931 = state_15840__$1;
(statearr_15844_17931[(2)] = inst_15836);

(statearr_15844_17931[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (20))){
var inst_15729 = (state_15840[(7)]);
var inst_15749 = cljs.core.first(inst_15729);
var inst_15750 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15749,(0),null);
var inst_15755 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15749,(1),null);
var state_15840__$1 = (function (){var statearr_15845 = state_15840;
(statearr_15845[(8)] = inst_15750);

return statearr_15845;
})();
if(cljs.core.truth_(inst_15755)){
var statearr_15846_17933 = state_15840__$1;
(statearr_15846_17933[(1)] = (22));

} else {
var statearr_15847_17937 = state_15840__$1;
(statearr_15847_17937[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (27))){
var inst_15783 = (state_15840[(9)]);
var inst_15790 = (state_15840[(10)]);
var inst_15785 = (state_15840[(11)]);
var inst_15698 = (state_15840[(12)]);
var inst_15790__$1 = cljs.core._nth(inst_15783,inst_15785);
var inst_15791 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_15790__$1,inst_15698,done);
var state_15840__$1 = (function (){var statearr_15849 = state_15840;
(statearr_15849[(10)] = inst_15790__$1);

return statearr_15849;
})();
if(cljs.core.truth_(inst_15791)){
var statearr_15850_17938 = state_15840__$1;
(statearr_15850_17938[(1)] = (30));

} else {
var statearr_15851_17939 = state_15840__$1;
(statearr_15851_17939[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (1))){
var state_15840__$1 = state_15840;
var statearr_15852_17940 = state_15840__$1;
(statearr_15852_17940[(2)] = null);

(statearr_15852_17940[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (24))){
var inst_15729 = (state_15840[(7)]);
var inst_15760 = (state_15840[(2)]);
var inst_15761 = cljs.core.next(inst_15729);
var inst_15707 = inst_15761;
var inst_15708 = null;
var inst_15709 = (0);
var inst_15710 = (0);
var state_15840__$1 = (function (){var statearr_15855 = state_15840;
(statearr_15855[(13)] = inst_15707);

(statearr_15855[(14)] = inst_15708);

(statearr_15855[(15)] = inst_15760);

(statearr_15855[(16)] = inst_15709);

(statearr_15855[(17)] = inst_15710);

return statearr_15855;
})();
var statearr_15856_17941 = state_15840__$1;
(statearr_15856_17941[(2)] = null);

(statearr_15856_17941[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (39))){
var state_15840__$1 = state_15840;
var statearr_15863_17942 = state_15840__$1;
(statearr_15863_17942[(2)] = null);

(statearr_15863_17942[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (4))){
var inst_15698 = (state_15840[(12)]);
var inst_15698__$1 = (state_15840[(2)]);
var inst_15699 = (inst_15698__$1 == null);
var state_15840__$1 = (function (){var statearr_15865 = state_15840;
(statearr_15865[(12)] = inst_15698__$1);

return statearr_15865;
})();
if(cljs.core.truth_(inst_15699)){
var statearr_15867_17943 = state_15840__$1;
(statearr_15867_17943[(1)] = (5));

} else {
var statearr_15869_17944 = state_15840__$1;
(statearr_15869_17944[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (15))){
var inst_15707 = (state_15840[(13)]);
var inst_15708 = (state_15840[(14)]);
var inst_15709 = (state_15840[(16)]);
var inst_15710 = (state_15840[(17)]);
var inst_15725 = (state_15840[(2)]);
var inst_15726 = (inst_15710 + (1));
var tmp15859 = inst_15707;
var tmp15860 = inst_15708;
var tmp15861 = inst_15709;
var inst_15707__$1 = tmp15859;
var inst_15708__$1 = tmp15860;
var inst_15709__$1 = tmp15861;
var inst_15710__$1 = inst_15726;
var state_15840__$1 = (function (){var statearr_15874 = state_15840;
(statearr_15874[(13)] = inst_15707__$1);

(statearr_15874[(18)] = inst_15725);

(statearr_15874[(14)] = inst_15708__$1);

(statearr_15874[(16)] = inst_15709__$1);

(statearr_15874[(17)] = inst_15710__$1);

return statearr_15874;
})();
var statearr_15877_17945 = state_15840__$1;
(statearr_15877_17945[(2)] = null);

(statearr_15877_17945[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (21))){
var inst_15764 = (state_15840[(2)]);
var state_15840__$1 = state_15840;
var statearr_15881_17946 = state_15840__$1;
(statearr_15881_17946[(2)] = inst_15764);

(statearr_15881_17946[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (31))){
var inst_15790 = (state_15840[(10)]);
var inst_15794 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_15790);
var state_15840__$1 = state_15840;
var statearr_15882_17947 = state_15840__$1;
(statearr_15882_17947[(2)] = inst_15794);

(statearr_15882_17947[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (32))){
var inst_15782 = (state_15840[(19)]);
var inst_15783 = (state_15840[(9)]);
var inst_15784 = (state_15840[(20)]);
var inst_15785 = (state_15840[(11)]);
var inst_15796 = (state_15840[(2)]);
var inst_15797 = (inst_15785 + (1));
var tmp15878 = inst_15782;
var tmp15879 = inst_15783;
var tmp15880 = inst_15784;
var inst_15782__$1 = tmp15878;
var inst_15783__$1 = tmp15879;
var inst_15784__$1 = tmp15880;
var inst_15785__$1 = inst_15797;
var state_15840__$1 = (function (){var statearr_15886 = state_15840;
(statearr_15886[(19)] = inst_15782__$1);

(statearr_15886[(21)] = inst_15796);

(statearr_15886[(9)] = inst_15783__$1);

(statearr_15886[(20)] = inst_15784__$1);

(statearr_15886[(11)] = inst_15785__$1);

return statearr_15886;
})();
var statearr_15911_17948 = state_15840__$1;
(statearr_15911_17948[(2)] = null);

(statearr_15911_17948[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (40))){
var inst_15809 = (state_15840[(22)]);
var inst_15813 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_15809);
var state_15840__$1 = state_15840;
var statearr_15913_17949 = state_15840__$1;
(statearr_15913_17949[(2)] = inst_15813);

(statearr_15913_17949[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (33))){
var inst_15800 = (state_15840[(23)]);
var inst_15802 = cljs.core.chunked_seq_QMARK_(inst_15800);
var state_15840__$1 = state_15840;
if(inst_15802){
var statearr_15918_17950 = state_15840__$1;
(statearr_15918_17950[(1)] = (36));

} else {
var statearr_15919_17951 = state_15840__$1;
(statearr_15919_17951[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (13))){
var inst_15719 = (state_15840[(24)]);
var inst_15722 = cljs.core.async.close_BANG_(inst_15719);
var state_15840__$1 = state_15840;
var statearr_15920_17952 = state_15840__$1;
(statearr_15920_17952[(2)] = inst_15722);

(statearr_15920_17952[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (22))){
var inst_15750 = (state_15840[(8)]);
var inst_15757 = cljs.core.async.close_BANG_(inst_15750);
var state_15840__$1 = state_15840;
var statearr_15922_17953 = state_15840__$1;
(statearr_15922_17953[(2)] = inst_15757);

(statearr_15922_17953[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (36))){
var inst_15800 = (state_15840[(23)]);
var inst_15804 = cljs.core.chunk_first(inst_15800);
var inst_15805 = cljs.core.chunk_rest(inst_15800);
var inst_15806 = cljs.core.count(inst_15804);
var inst_15782 = inst_15805;
var inst_15783 = inst_15804;
var inst_15784 = inst_15806;
var inst_15785 = (0);
var state_15840__$1 = (function (){var statearr_15923 = state_15840;
(statearr_15923[(19)] = inst_15782);

(statearr_15923[(9)] = inst_15783);

(statearr_15923[(20)] = inst_15784);

(statearr_15923[(11)] = inst_15785);

return statearr_15923;
})();
var statearr_15927_17954 = state_15840__$1;
(statearr_15927_17954[(2)] = null);

(statearr_15927_17954[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (41))){
var inst_15800 = (state_15840[(23)]);
var inst_15815 = (state_15840[(2)]);
var inst_15816 = cljs.core.next(inst_15800);
var inst_15782 = inst_15816;
var inst_15783 = null;
var inst_15784 = (0);
var inst_15785 = (0);
var state_15840__$1 = (function (){var statearr_15929 = state_15840;
(statearr_15929[(19)] = inst_15782);

(statearr_15929[(9)] = inst_15783);

(statearr_15929[(20)] = inst_15784);

(statearr_15929[(25)] = inst_15815);

(statearr_15929[(11)] = inst_15785);

return statearr_15929;
})();
var statearr_15930_17955 = state_15840__$1;
(statearr_15930_17955[(2)] = null);

(statearr_15930_17955[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (43))){
var state_15840__$1 = state_15840;
var statearr_15931_17956 = state_15840__$1;
(statearr_15931_17956[(2)] = null);

(statearr_15931_17956[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (29))){
var inst_15824 = (state_15840[(2)]);
var state_15840__$1 = state_15840;
var statearr_15936_17957 = state_15840__$1;
(statearr_15936_17957[(2)] = inst_15824);

(statearr_15936_17957[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (44))){
var inst_15833 = (state_15840[(2)]);
var state_15840__$1 = (function (){var statearr_15937 = state_15840;
(statearr_15937[(26)] = inst_15833);

return statearr_15937;
})();
var statearr_15938_17958 = state_15840__$1;
(statearr_15938_17958[(2)] = null);

(statearr_15938_17958[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (6))){
var inst_15774 = (state_15840[(27)]);
var inst_15773 = cljs.core.deref(cs);
var inst_15774__$1 = cljs.core.keys(inst_15773);
var inst_15775 = cljs.core.count(inst_15774__$1);
var inst_15776 = cljs.core.reset_BANG_(dctr,inst_15775);
var inst_15781 = cljs.core.seq(inst_15774__$1);
var inst_15782 = inst_15781;
var inst_15783 = null;
var inst_15784 = (0);
var inst_15785 = (0);
var state_15840__$1 = (function (){var statearr_15943 = state_15840;
(statearr_15943[(19)] = inst_15782);

(statearr_15943[(27)] = inst_15774__$1);

(statearr_15943[(9)] = inst_15783);

(statearr_15943[(28)] = inst_15776);

(statearr_15943[(20)] = inst_15784);

(statearr_15943[(11)] = inst_15785);

return statearr_15943;
})();
var statearr_15945_17959 = state_15840__$1;
(statearr_15945_17959[(2)] = null);

(statearr_15945_17959[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (28))){
var inst_15782 = (state_15840[(19)]);
var inst_15800 = (state_15840[(23)]);
var inst_15800__$1 = cljs.core.seq(inst_15782);
var state_15840__$1 = (function (){var statearr_15946 = state_15840;
(statearr_15946[(23)] = inst_15800__$1);

return statearr_15946;
})();
if(inst_15800__$1){
var statearr_15947_17960 = state_15840__$1;
(statearr_15947_17960[(1)] = (33));

} else {
var statearr_15948_17961 = state_15840__$1;
(statearr_15948_17961[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (25))){
var inst_15784 = (state_15840[(20)]);
var inst_15785 = (state_15840[(11)]);
var inst_15787 = (inst_15785 < inst_15784);
var inst_15788 = inst_15787;
var state_15840__$1 = state_15840;
if(cljs.core.truth_(inst_15788)){
var statearr_15950_17962 = state_15840__$1;
(statearr_15950_17962[(1)] = (27));

} else {
var statearr_15951_17963 = state_15840__$1;
(statearr_15951_17963[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (34))){
var state_15840__$1 = state_15840;
var statearr_15954_17964 = state_15840__$1;
(statearr_15954_17964[(2)] = null);

(statearr_15954_17964[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (17))){
var state_15840__$1 = state_15840;
var statearr_15957_17965 = state_15840__$1;
(statearr_15957_17965[(2)] = null);

(statearr_15957_17965[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (3))){
var inst_15838 = (state_15840[(2)]);
var state_15840__$1 = state_15840;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15840__$1,inst_15838);
} else {
if((state_val_15841 === (12))){
var inst_15769 = (state_15840[(2)]);
var state_15840__$1 = state_15840;
var statearr_15958_17966 = state_15840__$1;
(statearr_15958_17966[(2)] = inst_15769);

(statearr_15958_17966[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (2))){
var state_15840__$1 = state_15840;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15840__$1,(4),ch);
} else {
if((state_val_15841 === (23))){
var state_15840__$1 = state_15840;
var statearr_15960_17968 = state_15840__$1;
(statearr_15960_17968[(2)] = null);

(statearr_15960_17968[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (35))){
var inst_15822 = (state_15840[(2)]);
var state_15840__$1 = state_15840;
var statearr_15965_17969 = state_15840__$1;
(statearr_15965_17969[(2)] = inst_15822);

(statearr_15965_17969[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (19))){
var inst_15729 = (state_15840[(7)]);
var inst_15737 = cljs.core.chunk_first(inst_15729);
var inst_15738 = cljs.core.chunk_rest(inst_15729);
var inst_15739 = cljs.core.count(inst_15737);
var inst_15707 = inst_15738;
var inst_15708 = inst_15737;
var inst_15709 = inst_15739;
var inst_15710 = (0);
var state_15840__$1 = (function (){var statearr_15966 = state_15840;
(statearr_15966[(13)] = inst_15707);

(statearr_15966[(14)] = inst_15708);

(statearr_15966[(16)] = inst_15709);

(statearr_15966[(17)] = inst_15710);

return statearr_15966;
})();
var statearr_15967_17970 = state_15840__$1;
(statearr_15967_17970[(2)] = null);

(statearr_15967_17970[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (11))){
var inst_15707 = (state_15840[(13)]);
var inst_15729 = (state_15840[(7)]);
var inst_15729__$1 = cljs.core.seq(inst_15707);
var state_15840__$1 = (function (){var statearr_15969 = state_15840;
(statearr_15969[(7)] = inst_15729__$1);

return statearr_15969;
})();
if(inst_15729__$1){
var statearr_15970_17974 = state_15840__$1;
(statearr_15970_17974[(1)] = (16));

} else {
var statearr_15971_17975 = state_15840__$1;
(statearr_15971_17975[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (9))){
var inst_15771 = (state_15840[(2)]);
var state_15840__$1 = state_15840;
var statearr_15974_17976 = state_15840__$1;
(statearr_15974_17976[(2)] = inst_15771);

(statearr_15974_17976[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (5))){
var inst_15705 = cljs.core.deref(cs);
var inst_15706 = cljs.core.seq(inst_15705);
var inst_15707 = inst_15706;
var inst_15708 = null;
var inst_15709 = (0);
var inst_15710 = (0);
var state_15840__$1 = (function (){var statearr_15985 = state_15840;
(statearr_15985[(13)] = inst_15707);

(statearr_15985[(14)] = inst_15708);

(statearr_15985[(16)] = inst_15709);

(statearr_15985[(17)] = inst_15710);

return statearr_15985;
})();
var statearr_15986_17977 = state_15840__$1;
(statearr_15986_17977[(2)] = null);

(statearr_15986_17977[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (14))){
var state_15840__$1 = state_15840;
var statearr_15988_17978 = state_15840__$1;
(statearr_15988_17978[(2)] = null);

(statearr_15988_17978[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (45))){
var inst_15830 = (state_15840[(2)]);
var state_15840__$1 = state_15840;
var statearr_15989_17979 = state_15840__$1;
(statearr_15989_17979[(2)] = inst_15830);

(statearr_15989_17979[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (26))){
var inst_15774 = (state_15840[(27)]);
var inst_15826 = (state_15840[(2)]);
var inst_15827 = cljs.core.seq(inst_15774);
var state_15840__$1 = (function (){var statearr_15994 = state_15840;
(statearr_15994[(29)] = inst_15826);

return statearr_15994;
})();
if(inst_15827){
var statearr_15999_17980 = state_15840__$1;
(statearr_15999_17980[(1)] = (42));

} else {
var statearr_16000_17981 = state_15840__$1;
(statearr_16000_17981[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (16))){
var inst_15729 = (state_15840[(7)]);
var inst_15731 = cljs.core.chunked_seq_QMARK_(inst_15729);
var state_15840__$1 = state_15840;
if(inst_15731){
var statearr_16002_17982 = state_15840__$1;
(statearr_16002_17982[(1)] = (19));

} else {
var statearr_16003_17983 = state_15840__$1;
(statearr_16003_17983[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (38))){
var inst_15819 = (state_15840[(2)]);
var state_15840__$1 = state_15840;
var statearr_16004_17984 = state_15840__$1;
(statearr_16004_17984[(2)] = inst_15819);

(statearr_16004_17984[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (30))){
var state_15840__$1 = state_15840;
var statearr_16007_17985 = state_15840__$1;
(statearr_16007_17985[(2)] = null);

(statearr_16007_17985[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (10))){
var inst_15708 = (state_15840[(14)]);
var inst_15710 = (state_15840[(17)]);
var inst_15718 = cljs.core._nth(inst_15708,inst_15710);
var inst_15719 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15718,(0),null);
var inst_15720 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15718,(1),null);
var state_15840__$1 = (function (){var statearr_16010 = state_15840;
(statearr_16010[(24)] = inst_15719);

return statearr_16010;
})();
if(cljs.core.truth_(inst_15720)){
var statearr_16011_17986 = state_15840__$1;
(statearr_16011_17986[(1)] = (13));

} else {
var statearr_16013_17987 = state_15840__$1;
(statearr_16013_17987[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (18))){
var inst_15767 = (state_15840[(2)]);
var state_15840__$1 = state_15840;
var statearr_16016_17988 = state_15840__$1;
(statearr_16016_17988[(2)] = inst_15767);

(statearr_16016_17988[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (42))){
var state_15840__$1 = state_15840;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15840__$1,(45),dchan);
} else {
if((state_val_15841 === (37))){
var inst_15800 = (state_15840[(23)]);
var inst_15809 = (state_15840[(22)]);
var inst_15698 = (state_15840[(12)]);
var inst_15809__$1 = cljs.core.first(inst_15800);
var inst_15810 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_15809__$1,inst_15698,done);
var state_15840__$1 = (function (){var statearr_16020 = state_15840;
(statearr_16020[(22)] = inst_15809__$1);

return statearr_16020;
})();
if(cljs.core.truth_(inst_15810)){
var statearr_16021_17989 = state_15840__$1;
(statearr_16021_17989[(1)] = (39));

} else {
var statearr_16023_17990 = state_15840__$1;
(statearr_16023_17990[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15841 === (8))){
var inst_15709 = (state_15840[(16)]);
var inst_15710 = (state_15840[(17)]);
var inst_15712 = (inst_15710 < inst_15709);
var inst_15713 = inst_15712;
var state_15840__$1 = state_15840;
if(cljs.core.truth_(inst_15713)){
var statearr_16027_17991 = state_15840__$1;
(statearr_16027_17991[(1)] = (10));

} else {
var statearr_16028_17992 = state_15840__$1;
(statearr_16028_17992[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__14360__auto__ = null;
var cljs$core$async$mult_$_state_machine__14360__auto____0 = (function (){
var statearr_16030 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16030[(0)] = cljs$core$async$mult_$_state_machine__14360__auto__);

(statearr_16030[(1)] = (1));

return statearr_16030;
});
var cljs$core$async$mult_$_state_machine__14360__auto____1 = (function (state_15840){
while(true){
var ret_value__14361__auto__ = (function (){try{while(true){
var result__14362__auto__ = switch__14359__auto__(state_15840);
if(cljs.core.keyword_identical_QMARK_(result__14362__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14362__auto__;
}
break;
}
}catch (e16031){var ex__14363__auto__ = e16031;
var statearr_16032_17993 = state_15840;
(statearr_16032_17993[(2)] = ex__14363__auto__);


if(cljs.core.seq((state_15840[(4)]))){
var statearr_16034_17994 = state_15840;
(statearr_16034_17994[(1)] = cljs.core.first((state_15840[(4)])));

} else {
throw ex__14363__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14361__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17995 = state_15840;
state_15840 = G__17995;
continue;
} else {
return ret_value__14361__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__14360__auto__ = function(state_15840){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__14360__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__14360__auto____1.call(this,state_15840);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__14360__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__14360__auto____0;
cljs$core$async$mult_$_state_machine__14360__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__14360__auto____1;
return cljs$core$async$mult_$_state_machine__14360__auto__;
})()
})();
var state__14695__auto__ = (function (){var statearr_16037 = f__14694__auto__();
(statearr_16037[(6)] = c__14693__auto___17930);

return statearr_16037;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14695__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__16040 = arguments.length;
switch (G__16040) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_17998 = (function (m,ch){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5351__auto__.call(null,m,ch));
} else {
var m__5349__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5349__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_17998(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_17999 = (function (m,ch){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5351__auto__.call(null,m,ch));
} else {
var m__5349__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5349__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_17999(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_18001 = (function (m){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5351__auto__.call(null,m));
} else {
var m__5349__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5349__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_18001(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_18011 = (function (m,state_map){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5351__auto__.call(null,m,state_map));
} else {
var m__5349__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5349__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_18011(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_18012 = (function (m,mode){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5351__auto__.call(null,m,mode));
} else {
var m__5349__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5349__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_18012(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5732__auto__ = [];
var len__5726__auto___18015 = arguments.length;
var i__5727__auto___18016 = (0);
while(true){
if((i__5727__auto___18016 < len__5726__auto___18015)){
args__5732__auto__.push((arguments[i__5727__auto___18016]));

var G__18018 = (i__5727__auto___18016 + (1));
i__5727__auto___18016 = G__18018;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((3) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5733__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__16091){
var map__16092 = p__16091;
var map__16092__$1 = cljs.core.__destructure_map(map__16092);
var opts = map__16092__$1;
var statearr_16093_18019 = state;
(statearr_16093_18019[(1)] = cont_block);


var temp__5804__auto__ = cljs.core.async.do_alts((function (val){
var statearr_16094_18020 = state;
(statearr_16094_18020[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5804__auto__)){
var cb = temp__5804__auto__;
var statearr_16098_18021 = state;
(statearr_16098_18021[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq16077){
var G__16078 = cljs.core.first(seq16077);
var seq16077__$1 = cljs.core.next(seq16077);
var G__16079 = cljs.core.first(seq16077__$1);
var seq16077__$2 = cljs.core.next(seq16077__$1);
var G__16080 = cljs.core.first(seq16077__$2);
var seq16077__$3 = cljs.core.next(seq16077__$2);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16078,G__16079,G__16080,seq16077__$3);
}));


/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16113 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta16114){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta16114 = meta16114;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async16113.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16115,meta16114__$1){
var self__ = this;
var _16115__$1 = this;
return (new cljs.core.async.t_cljs$core$async16113(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta16114__$1));
}));

(cljs.core.async.t_cljs$core$async16113.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16115){
var self__ = this;
var _16115__$1 = this;
return self__.meta16114;
}));

(cljs.core.async.t_cljs$core$async16113.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16113.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async16113.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16113.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async16113.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async16113.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async16113.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async16113.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async16113.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta16114","meta16114",-1384101444,null)], null);
}));

(cljs.core.async.t_cljs$core$async16113.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async16113.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16113");

(cljs.core.async.t_cljs$core$async16113.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async16113");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async16113.
 */
cljs.core.async.__GT_t_cljs$core$async16113 = (function cljs$core$async$__GT_t_cljs$core$async16113(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta16114){
return (new cljs.core.async.t_cljs$core$async16113(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta16114));
});


/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (new cljs.core.async.t_cljs$core$async16113(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
var c__14693__auto___18025 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14694__auto__ = (function (){var switch__14359__auto__ = (function (state_16235){
var state_val_16236 = (state_16235[(1)]);
if((state_val_16236 === (7))){
var inst_16192 = (state_16235[(2)]);
var state_16235__$1 = state_16235;
if(cljs.core.truth_(inst_16192)){
var statearr_16237_18026 = state_16235__$1;
(statearr_16237_18026[(1)] = (8));

} else {
var statearr_16238_18027 = state_16235__$1;
(statearr_16238_18027[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16236 === (20))){
var inst_16185 = (state_16235[(7)]);
var state_16235__$1 = state_16235;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16235__$1,(23),out,inst_16185);
} else {
if((state_val_16236 === (1))){
var inst_16163 = calc_state();
var inst_16164 = cljs.core.__destructure_map(inst_16163);
var inst_16165 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16164,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_16166 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16164,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_16167 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16164,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_16168 = inst_16163;
var state_16235__$1 = (function (){var statearr_16239 = state_16235;
(statearr_16239[(8)] = inst_16168);

(statearr_16239[(9)] = inst_16166);

(statearr_16239[(10)] = inst_16165);

(statearr_16239[(11)] = inst_16167);

return statearr_16239;
})();
var statearr_16240_18028 = state_16235__$1;
(statearr_16240_18028[(2)] = null);

(statearr_16240_18028[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16236 === (24))){
var inst_16171 = (state_16235[(12)]);
var inst_16168 = inst_16171;
var state_16235__$1 = (function (){var statearr_16241 = state_16235;
(statearr_16241[(8)] = inst_16168);

return statearr_16241;
})();
var statearr_16242_18029 = state_16235__$1;
(statearr_16242_18029[(2)] = null);

(statearr_16242_18029[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16236 === (4))){
var inst_16187 = (state_16235[(13)]);
var inst_16185 = (state_16235[(7)]);
var inst_16184 = (state_16235[(2)]);
var inst_16185__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16184,(0),null);
var inst_16186 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16184,(1),null);
var inst_16187__$1 = (inst_16185__$1 == null);
var state_16235__$1 = (function (){var statearr_16243 = state_16235;
(statearr_16243[(14)] = inst_16186);

(statearr_16243[(13)] = inst_16187__$1);

(statearr_16243[(7)] = inst_16185__$1);

return statearr_16243;
})();
if(cljs.core.truth_(inst_16187__$1)){
var statearr_16244_18030 = state_16235__$1;
(statearr_16244_18030[(1)] = (5));

} else {
var statearr_16245_18035 = state_16235__$1;
(statearr_16245_18035[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16236 === (15))){
var inst_16172 = (state_16235[(15)]);
var inst_16209 = (state_16235[(16)]);
var inst_16209__$1 = cljs.core.empty_QMARK_(inst_16172);
var state_16235__$1 = (function (){var statearr_16246 = state_16235;
(statearr_16246[(16)] = inst_16209__$1);

return statearr_16246;
})();
if(inst_16209__$1){
var statearr_16247_18036 = state_16235__$1;
(statearr_16247_18036[(1)] = (17));

} else {
var statearr_16248_18037 = state_16235__$1;
(statearr_16248_18037[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16236 === (21))){
var inst_16171 = (state_16235[(12)]);
var inst_16168 = inst_16171;
var state_16235__$1 = (function (){var statearr_16249 = state_16235;
(statearr_16249[(8)] = inst_16168);

return statearr_16249;
})();
var statearr_16253_18038 = state_16235__$1;
(statearr_16253_18038[(2)] = null);

(statearr_16253_18038[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16236 === (13))){
var inst_16199 = (state_16235[(2)]);
var inst_16200 = calc_state();
var inst_16168 = inst_16200;
var state_16235__$1 = (function (){var statearr_16255 = state_16235;
(statearr_16255[(8)] = inst_16168);

(statearr_16255[(17)] = inst_16199);

return statearr_16255;
})();
var statearr_16256_18039 = state_16235__$1;
(statearr_16256_18039[(2)] = null);

(statearr_16256_18039[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16236 === (22))){
var inst_16229 = (state_16235[(2)]);
var state_16235__$1 = state_16235;
var statearr_16257_18040 = state_16235__$1;
(statearr_16257_18040[(2)] = inst_16229);

(statearr_16257_18040[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16236 === (6))){
var inst_16186 = (state_16235[(14)]);
var inst_16190 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_16186,change);
var state_16235__$1 = state_16235;
var statearr_16258_18041 = state_16235__$1;
(statearr_16258_18041[(2)] = inst_16190);

(statearr_16258_18041[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16236 === (25))){
var state_16235__$1 = state_16235;
var statearr_16267_18042 = state_16235__$1;
(statearr_16267_18042[(2)] = null);

(statearr_16267_18042[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16236 === (17))){
var inst_16186 = (state_16235[(14)]);
var inst_16173 = (state_16235[(18)]);
var inst_16211 = (inst_16173.cljs$core$IFn$_invoke$arity$1 ? inst_16173.cljs$core$IFn$_invoke$arity$1(inst_16186) : inst_16173.call(null,inst_16186));
var inst_16212 = cljs.core.not(inst_16211);
var state_16235__$1 = state_16235;
var statearr_16269_18043 = state_16235__$1;
(statearr_16269_18043[(2)] = inst_16212);

(statearr_16269_18043[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16236 === (3))){
var inst_16233 = (state_16235[(2)]);
var state_16235__$1 = state_16235;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16235__$1,inst_16233);
} else {
if((state_val_16236 === (12))){
var state_16235__$1 = state_16235;
var statearr_16270_18044 = state_16235__$1;
(statearr_16270_18044[(2)] = null);

(statearr_16270_18044[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16236 === (2))){
var inst_16168 = (state_16235[(8)]);
var inst_16171 = (state_16235[(12)]);
var inst_16171__$1 = cljs.core.__destructure_map(inst_16168);
var inst_16172 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16171__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_16173 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16171__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_16174 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16171__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_16235__$1 = (function (){var statearr_16275 = state_16235;
(statearr_16275[(18)] = inst_16173);

(statearr_16275[(15)] = inst_16172);

(statearr_16275[(12)] = inst_16171__$1);

return statearr_16275;
})();
return cljs.core.async.ioc_alts_BANG_(state_16235__$1,(4),inst_16174);
} else {
if((state_val_16236 === (23))){
var inst_16220 = (state_16235[(2)]);
var state_16235__$1 = state_16235;
if(cljs.core.truth_(inst_16220)){
var statearr_16278_18045 = state_16235__$1;
(statearr_16278_18045[(1)] = (24));

} else {
var statearr_16279_18046 = state_16235__$1;
(statearr_16279_18046[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16236 === (19))){
var inst_16215 = (state_16235[(2)]);
var state_16235__$1 = state_16235;
var statearr_16281_18047 = state_16235__$1;
(statearr_16281_18047[(2)] = inst_16215);

(statearr_16281_18047[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16236 === (11))){
var inst_16186 = (state_16235[(14)]);
var inst_16196 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_16186);
var state_16235__$1 = state_16235;
var statearr_16285_18048 = state_16235__$1;
(statearr_16285_18048[(2)] = inst_16196);

(statearr_16285_18048[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16236 === (9))){
var inst_16186 = (state_16235[(14)]);
var inst_16206 = (state_16235[(19)]);
var inst_16172 = (state_16235[(15)]);
var inst_16206__$1 = (inst_16172.cljs$core$IFn$_invoke$arity$1 ? inst_16172.cljs$core$IFn$_invoke$arity$1(inst_16186) : inst_16172.call(null,inst_16186));
var state_16235__$1 = (function (){var statearr_16286 = state_16235;
(statearr_16286[(19)] = inst_16206__$1);

return statearr_16286;
})();
if(cljs.core.truth_(inst_16206__$1)){
var statearr_16287_18049 = state_16235__$1;
(statearr_16287_18049[(1)] = (14));

} else {
var statearr_16288_18050 = state_16235__$1;
(statearr_16288_18050[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16236 === (5))){
var inst_16187 = (state_16235[(13)]);
var state_16235__$1 = state_16235;
var statearr_16289_18051 = state_16235__$1;
(statearr_16289_18051[(2)] = inst_16187);

(statearr_16289_18051[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16236 === (14))){
var inst_16206 = (state_16235[(19)]);
var state_16235__$1 = state_16235;
var statearr_16290_18052 = state_16235__$1;
(statearr_16290_18052[(2)] = inst_16206);

(statearr_16290_18052[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16236 === (26))){
var inst_16225 = (state_16235[(2)]);
var state_16235__$1 = state_16235;
var statearr_16294_18053 = state_16235__$1;
(statearr_16294_18053[(2)] = inst_16225);

(statearr_16294_18053[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16236 === (16))){
var inst_16217 = (state_16235[(2)]);
var state_16235__$1 = state_16235;
if(cljs.core.truth_(inst_16217)){
var statearr_16301_18054 = state_16235__$1;
(statearr_16301_18054[(1)] = (20));

} else {
var statearr_16302_18055 = state_16235__$1;
(statearr_16302_18055[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16236 === (10))){
var inst_16231 = (state_16235[(2)]);
var state_16235__$1 = state_16235;
var statearr_16306_18060 = state_16235__$1;
(statearr_16306_18060[(2)] = inst_16231);

(statearr_16306_18060[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16236 === (18))){
var inst_16209 = (state_16235[(16)]);
var state_16235__$1 = state_16235;
var statearr_16309_18061 = state_16235__$1;
(statearr_16309_18061[(2)] = inst_16209);

(statearr_16309_18061[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16236 === (8))){
var inst_16185 = (state_16235[(7)]);
var inst_16194 = (inst_16185 == null);
var state_16235__$1 = state_16235;
if(cljs.core.truth_(inst_16194)){
var statearr_16312_18062 = state_16235__$1;
(statearr_16312_18062[(1)] = (11));

} else {
var statearr_16313_18063 = state_16235__$1;
(statearr_16313_18063[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__14360__auto__ = null;
var cljs$core$async$mix_$_state_machine__14360__auto____0 = (function (){
var statearr_16319 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16319[(0)] = cljs$core$async$mix_$_state_machine__14360__auto__);

(statearr_16319[(1)] = (1));

return statearr_16319;
});
var cljs$core$async$mix_$_state_machine__14360__auto____1 = (function (state_16235){
while(true){
var ret_value__14361__auto__ = (function (){try{while(true){
var result__14362__auto__ = switch__14359__auto__(state_16235);
if(cljs.core.keyword_identical_QMARK_(result__14362__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14362__auto__;
}
break;
}
}catch (e16321){var ex__14363__auto__ = e16321;
var statearr_16322_18064 = state_16235;
(statearr_16322_18064[(2)] = ex__14363__auto__);


if(cljs.core.seq((state_16235[(4)]))){
var statearr_16323_18065 = state_16235;
(statearr_16323_18065[(1)] = cljs.core.first((state_16235[(4)])));

} else {
throw ex__14363__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14361__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18066 = state_16235;
state_16235 = G__18066;
continue;
} else {
return ret_value__14361__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__14360__auto__ = function(state_16235){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__14360__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__14360__auto____1.call(this,state_16235);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__14360__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__14360__auto____0;
cljs$core$async$mix_$_state_machine__14360__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__14360__auto____1;
return cljs$core$async$mix_$_state_machine__14360__auto__;
})()
})();
var state__14695__auto__ = (function (){var statearr_16328 = f__14694__auto__();
(statearr_16328[(6)] = c__14693__auto___18025);

return statearr_16328;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14695__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_18070 = (function (p,v,ch,close_QMARK_){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5351__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__5349__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5349__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_18070(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_18072 = (function (p,v,ch){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5351__auto__.call(null,p,v,ch));
} else {
var m__5349__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5349__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_18072(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_18073 = (function() {
var G__18074 = null;
var G__18074__1 = (function (p){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5351__auto__.call(null,p));
} else {
var m__5349__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5349__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__18074__2 = (function (p,v){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5351__auto__.call(null,p,v));
} else {
var m__5349__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5349__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__18074 = function(p,v){
switch(arguments.length){
case 1:
return G__18074__1.call(this,p);
case 2:
return G__18074__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18074.cljs$core$IFn$_invoke$arity$1 = G__18074__1;
G__18074.cljs$core$IFn$_invoke$arity$2 = G__18074__2;
return G__18074;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__16357 = arguments.length;
switch (G__16357) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_18073(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_18073(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);



/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16386 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta16387){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta16387 = meta16387;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async16386.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16388,meta16387__$1){
var self__ = this;
var _16388__$1 = this;
return (new cljs.core.async.t_cljs$core$async16386(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta16387__$1));
}));

(cljs.core.async.t_cljs$core$async16386.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16388){
var self__ = this;
var _16388__$1 = this;
return self__.meta16387;
}));

(cljs.core.async.t_cljs$core$async16386.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16386.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async16386.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16386.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async16386.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5804__auto__)){
var m = temp__5804__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async16386.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async16386.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async16386.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta16387","meta16387",-1188296890,null)], null);
}));

(cljs.core.async.t_cljs$core$async16386.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async16386.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16386");

(cljs.core.async.t_cljs$core$async16386.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async16386");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async16386.
 */
cljs.core.async.__GT_t_cljs$core$async16386 = (function cljs$core$async$__GT_t_cljs$core$async16386(ch,topic_fn,buf_fn,mults,ensure_mult,meta16387){
return (new cljs.core.async.t_cljs$core$async16386(ch,topic_fn,buf_fn,mults,ensure_mult,meta16387));
});


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__16374 = arguments.length;
switch (G__16374) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__5002__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__16370_SHARP_){
if(cljs.core.truth_((p1__16370_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16370_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__16370_SHARP_.call(null,topic)))){
return p1__16370_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__16370_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (new cljs.core.async.t_cljs$core$async16386(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
var c__14693__auto___18080 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14694__auto__ = (function (){var switch__14359__auto__ = (function (state_16481){
var state_val_16482 = (state_16481[(1)]);
if((state_val_16482 === (7))){
var inst_16475 = (state_16481[(2)]);
var state_16481__$1 = state_16481;
var statearr_16483_18081 = state_16481__$1;
(statearr_16483_18081[(2)] = inst_16475);

(statearr_16483_18081[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16482 === (20))){
var state_16481__$1 = state_16481;
var statearr_16484_18082 = state_16481__$1;
(statearr_16484_18082[(2)] = null);

(statearr_16484_18082[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16482 === (1))){
var state_16481__$1 = state_16481;
var statearr_16487_18083 = state_16481__$1;
(statearr_16487_18083[(2)] = null);

(statearr_16487_18083[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16482 === (24))){
var inst_16458 = (state_16481[(7)]);
var inst_16467 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_16458);
var state_16481__$1 = state_16481;
var statearr_16492_18084 = state_16481__$1;
(statearr_16492_18084[(2)] = inst_16467);

(statearr_16492_18084[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16482 === (4))){
var inst_16410 = (state_16481[(8)]);
var inst_16410__$1 = (state_16481[(2)]);
var inst_16411 = (inst_16410__$1 == null);
var state_16481__$1 = (function (){var statearr_16497 = state_16481;
(statearr_16497[(8)] = inst_16410__$1);

return statearr_16497;
})();
if(cljs.core.truth_(inst_16411)){
var statearr_16498_18086 = state_16481__$1;
(statearr_16498_18086[(1)] = (5));

} else {
var statearr_16501_18087 = state_16481__$1;
(statearr_16501_18087[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16482 === (15))){
var inst_16452 = (state_16481[(2)]);
var state_16481__$1 = state_16481;
var statearr_16503_18088 = state_16481__$1;
(statearr_16503_18088[(2)] = inst_16452);

(statearr_16503_18088[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16482 === (21))){
var inst_16472 = (state_16481[(2)]);
var state_16481__$1 = (function (){var statearr_16507 = state_16481;
(statearr_16507[(9)] = inst_16472);

return statearr_16507;
})();
var statearr_16508_18089 = state_16481__$1;
(statearr_16508_18089[(2)] = null);

(statearr_16508_18089[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16482 === (13))){
var inst_16434 = (state_16481[(10)]);
var inst_16436 = cljs.core.chunked_seq_QMARK_(inst_16434);
var state_16481__$1 = state_16481;
if(inst_16436){
var statearr_16511_18090 = state_16481__$1;
(statearr_16511_18090[(1)] = (16));

} else {
var statearr_16512_18091 = state_16481__$1;
(statearr_16512_18091[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16482 === (22))){
var inst_16464 = (state_16481[(2)]);
var state_16481__$1 = state_16481;
if(cljs.core.truth_(inst_16464)){
var statearr_16514_18092 = state_16481__$1;
(statearr_16514_18092[(1)] = (23));

} else {
var statearr_16519_18093 = state_16481__$1;
(statearr_16519_18093[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16482 === (6))){
var inst_16460 = (state_16481[(11)]);
var inst_16458 = (state_16481[(7)]);
var inst_16410 = (state_16481[(8)]);
var inst_16458__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_16410) : topic_fn.call(null,inst_16410));
var inst_16459 = cljs.core.deref(mults);
var inst_16460__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16459,inst_16458__$1);
var state_16481__$1 = (function (){var statearr_16522 = state_16481;
(statearr_16522[(11)] = inst_16460__$1);

(statearr_16522[(7)] = inst_16458__$1);

return statearr_16522;
})();
if(cljs.core.truth_(inst_16460__$1)){
var statearr_16531_18095 = state_16481__$1;
(statearr_16531_18095[(1)] = (19));

} else {
var statearr_16532_18096 = state_16481__$1;
(statearr_16532_18096[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16482 === (25))){
var inst_16469 = (state_16481[(2)]);
var state_16481__$1 = state_16481;
var statearr_16537_18097 = state_16481__$1;
(statearr_16537_18097[(2)] = inst_16469);

(statearr_16537_18097[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16482 === (17))){
var inst_16434 = (state_16481[(10)]);
var inst_16443 = cljs.core.first(inst_16434);
var inst_16444 = cljs.core.async.muxch_STAR_(inst_16443);
var inst_16445 = cljs.core.async.close_BANG_(inst_16444);
var inst_16446 = cljs.core.next(inst_16434);
var inst_16420 = inst_16446;
var inst_16421 = null;
var inst_16422 = (0);
var inst_16423 = (0);
var state_16481__$1 = (function (){var statearr_16547 = state_16481;
(statearr_16547[(12)] = inst_16422);

(statearr_16547[(13)] = inst_16445);

(statearr_16547[(14)] = inst_16423);

(statearr_16547[(15)] = inst_16420);

(statearr_16547[(16)] = inst_16421);

return statearr_16547;
})();
var statearr_16548_18098 = state_16481__$1;
(statearr_16548_18098[(2)] = null);

(statearr_16548_18098[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16482 === (3))){
var inst_16477 = (state_16481[(2)]);
var state_16481__$1 = state_16481;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16481__$1,inst_16477);
} else {
if((state_val_16482 === (12))){
var inst_16454 = (state_16481[(2)]);
var state_16481__$1 = state_16481;
var statearr_16550_18100 = state_16481__$1;
(statearr_16550_18100[(2)] = inst_16454);

(statearr_16550_18100[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16482 === (2))){
var state_16481__$1 = state_16481;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16481__$1,(4),ch);
} else {
if((state_val_16482 === (23))){
var state_16481__$1 = state_16481;
var statearr_16551_18101 = state_16481__$1;
(statearr_16551_18101[(2)] = null);

(statearr_16551_18101[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16482 === (19))){
var inst_16460 = (state_16481[(11)]);
var inst_16410 = (state_16481[(8)]);
var inst_16462 = cljs.core.async.muxch_STAR_(inst_16460);
var state_16481__$1 = state_16481;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16481__$1,(22),inst_16462,inst_16410);
} else {
if((state_val_16482 === (11))){
var inst_16434 = (state_16481[(10)]);
var inst_16420 = (state_16481[(15)]);
var inst_16434__$1 = cljs.core.seq(inst_16420);
var state_16481__$1 = (function (){var statearr_16554 = state_16481;
(statearr_16554[(10)] = inst_16434__$1);

return statearr_16554;
})();
if(inst_16434__$1){
var statearr_16555_18102 = state_16481__$1;
(statearr_16555_18102[(1)] = (13));

} else {
var statearr_16556_18103 = state_16481__$1;
(statearr_16556_18103[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16482 === (9))){
var inst_16456 = (state_16481[(2)]);
var state_16481__$1 = state_16481;
var statearr_16557_18104 = state_16481__$1;
(statearr_16557_18104[(2)] = inst_16456);

(statearr_16557_18104[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16482 === (5))){
var inst_16417 = cljs.core.deref(mults);
var inst_16418 = cljs.core.vals(inst_16417);
var inst_16419 = cljs.core.seq(inst_16418);
var inst_16420 = inst_16419;
var inst_16421 = null;
var inst_16422 = (0);
var inst_16423 = (0);
var state_16481__$1 = (function (){var statearr_16559 = state_16481;
(statearr_16559[(12)] = inst_16422);

(statearr_16559[(14)] = inst_16423);

(statearr_16559[(15)] = inst_16420);

(statearr_16559[(16)] = inst_16421);

return statearr_16559;
})();
var statearr_16561_18106 = state_16481__$1;
(statearr_16561_18106[(2)] = null);

(statearr_16561_18106[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16482 === (14))){
var state_16481__$1 = state_16481;
var statearr_16565_18107 = state_16481__$1;
(statearr_16565_18107[(2)] = null);

(statearr_16565_18107[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16482 === (16))){
var inst_16434 = (state_16481[(10)]);
var inst_16438 = cljs.core.chunk_first(inst_16434);
var inst_16439 = cljs.core.chunk_rest(inst_16434);
var inst_16440 = cljs.core.count(inst_16438);
var inst_16420 = inst_16439;
var inst_16421 = inst_16438;
var inst_16422 = inst_16440;
var inst_16423 = (0);
var state_16481__$1 = (function (){var statearr_16566 = state_16481;
(statearr_16566[(12)] = inst_16422);

(statearr_16566[(14)] = inst_16423);

(statearr_16566[(15)] = inst_16420);

(statearr_16566[(16)] = inst_16421);

return statearr_16566;
})();
var statearr_16568_18108 = state_16481__$1;
(statearr_16568_18108[(2)] = null);

(statearr_16568_18108[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16482 === (10))){
var inst_16422 = (state_16481[(12)]);
var inst_16423 = (state_16481[(14)]);
var inst_16420 = (state_16481[(15)]);
var inst_16421 = (state_16481[(16)]);
var inst_16428 = cljs.core._nth(inst_16421,inst_16423);
var inst_16429 = cljs.core.async.muxch_STAR_(inst_16428);
var inst_16430 = cljs.core.async.close_BANG_(inst_16429);
var inst_16431 = (inst_16423 + (1));
var tmp16562 = inst_16422;
var tmp16563 = inst_16420;
var tmp16564 = inst_16421;
var inst_16420__$1 = tmp16563;
var inst_16421__$1 = tmp16564;
var inst_16422__$1 = tmp16562;
var inst_16423__$1 = inst_16431;
var state_16481__$1 = (function (){var statearr_16570 = state_16481;
(statearr_16570[(17)] = inst_16430);

(statearr_16570[(12)] = inst_16422__$1);

(statearr_16570[(14)] = inst_16423__$1);

(statearr_16570[(15)] = inst_16420__$1);

(statearr_16570[(16)] = inst_16421__$1);

return statearr_16570;
})();
var statearr_16572_18109 = state_16481__$1;
(statearr_16572_18109[(2)] = null);

(statearr_16572_18109[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16482 === (18))){
var inst_16449 = (state_16481[(2)]);
var state_16481__$1 = state_16481;
var statearr_16574_18110 = state_16481__$1;
(statearr_16574_18110[(2)] = inst_16449);

(statearr_16574_18110[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16482 === (8))){
var inst_16422 = (state_16481[(12)]);
var inst_16423 = (state_16481[(14)]);
var inst_16425 = (inst_16423 < inst_16422);
var inst_16426 = inst_16425;
var state_16481__$1 = state_16481;
if(cljs.core.truth_(inst_16426)){
var statearr_16575_18111 = state_16481__$1;
(statearr_16575_18111[(1)] = (10));

} else {
var statearr_16577_18112 = state_16481__$1;
(statearr_16577_18112[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__14360__auto__ = null;
var cljs$core$async$state_machine__14360__auto____0 = (function (){
var statearr_16579 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16579[(0)] = cljs$core$async$state_machine__14360__auto__);

(statearr_16579[(1)] = (1));

return statearr_16579;
});
var cljs$core$async$state_machine__14360__auto____1 = (function (state_16481){
while(true){
var ret_value__14361__auto__ = (function (){try{while(true){
var result__14362__auto__ = switch__14359__auto__(state_16481);
if(cljs.core.keyword_identical_QMARK_(result__14362__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14362__auto__;
}
break;
}
}catch (e16583){var ex__14363__auto__ = e16583;
var statearr_16584_18113 = state_16481;
(statearr_16584_18113[(2)] = ex__14363__auto__);


if(cljs.core.seq((state_16481[(4)]))){
var statearr_16585_18114 = state_16481;
(statearr_16585_18114[(1)] = cljs.core.first((state_16481[(4)])));

} else {
throw ex__14363__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14361__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18115 = state_16481;
state_16481 = G__18115;
continue;
} else {
return ret_value__14361__auto__;
}
break;
}
});
cljs$core$async$state_machine__14360__auto__ = function(state_16481){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14360__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14360__auto____1.call(this,state_16481);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14360__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14360__auto____0;
cljs$core$async$state_machine__14360__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14360__auto____1;
return cljs$core$async$state_machine__14360__auto__;
})()
})();
var state__14695__auto__ = (function (){var statearr_16588 = f__14694__auto__();
(statearr_16588[(6)] = c__14693__auto___18080);

return statearr_16588;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14695__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__16590 = arguments.length;
switch (G__16590) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__16596 = arguments.length;
switch (G__16596) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__16606 = arguments.length;
switch (G__16606) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
if((cnt === (0))){
cljs.core.async.close_BANG_(out);
} else {
var c__14693__auto___18123 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14694__auto__ = (function (){var switch__14359__auto__ = (function (state_16664){
var state_val_16665 = (state_16664[(1)]);
if((state_val_16665 === (7))){
var state_16664__$1 = state_16664;
var statearr_16668_18124 = state_16664__$1;
(statearr_16668_18124[(2)] = null);

(statearr_16668_18124[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16665 === (1))){
var state_16664__$1 = state_16664;
var statearr_16672_18125 = state_16664__$1;
(statearr_16672_18125[(2)] = null);

(statearr_16672_18125[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16665 === (4))){
var inst_16621 = (state_16664[(7)]);
var inst_16620 = (state_16664[(8)]);
var inst_16623 = (inst_16621 < inst_16620);
var state_16664__$1 = state_16664;
if(cljs.core.truth_(inst_16623)){
var statearr_16677_18126 = state_16664__$1;
(statearr_16677_18126[(1)] = (6));

} else {
var statearr_16678_18127 = state_16664__$1;
(statearr_16678_18127[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16665 === (15))){
var inst_16648 = (state_16664[(9)]);
var inst_16653 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_16648);
var state_16664__$1 = state_16664;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16664__$1,(17),out,inst_16653);
} else {
if((state_val_16665 === (13))){
var inst_16648 = (state_16664[(9)]);
var inst_16648__$1 = (state_16664[(2)]);
var inst_16649 = cljs.core.some(cljs.core.nil_QMARK_,inst_16648__$1);
var state_16664__$1 = (function (){var statearr_16679 = state_16664;
(statearr_16679[(9)] = inst_16648__$1);

return statearr_16679;
})();
if(cljs.core.truth_(inst_16649)){
var statearr_16680_18131 = state_16664__$1;
(statearr_16680_18131[(1)] = (14));

} else {
var statearr_16681_18132 = state_16664__$1;
(statearr_16681_18132[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16665 === (6))){
var state_16664__$1 = state_16664;
var statearr_16684_18133 = state_16664__$1;
(statearr_16684_18133[(2)] = null);

(statearr_16684_18133[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16665 === (17))){
var inst_16655 = (state_16664[(2)]);
var state_16664__$1 = (function (){var statearr_16691 = state_16664;
(statearr_16691[(10)] = inst_16655);

return statearr_16691;
})();
var statearr_16692_18134 = state_16664__$1;
(statearr_16692_18134[(2)] = null);

(statearr_16692_18134[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16665 === (3))){
var inst_16660 = (state_16664[(2)]);
var state_16664__$1 = state_16664;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16664__$1,inst_16660);
} else {
if((state_val_16665 === (12))){
var _ = (function (){var statearr_16699 = state_16664;
(statearr_16699[(4)] = cljs.core.rest((state_16664[(4)])));

return statearr_16699;
})();
var state_16664__$1 = state_16664;
var ex16689 = (state_16664__$1[(2)]);
var statearr_16702_18136 = state_16664__$1;
(statearr_16702_18136[(5)] = ex16689);


if((ex16689 instanceof Object)){
var statearr_16703_18137 = state_16664__$1;
(statearr_16703_18137[(1)] = (11));

(statearr_16703_18137[(5)] = null);

} else {
throw ex16689;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16665 === (2))){
var inst_16619 = cljs.core.reset_BANG_(dctr,cnt);
var inst_16620 = cnt;
var inst_16621 = (0);
var state_16664__$1 = (function (){var statearr_16710 = state_16664;
(statearr_16710[(11)] = inst_16619);

(statearr_16710[(7)] = inst_16621);

(statearr_16710[(8)] = inst_16620);

return statearr_16710;
})();
var statearr_16711_18138 = state_16664__$1;
(statearr_16711_18138[(2)] = null);

(statearr_16711_18138[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16665 === (11))){
var inst_16627 = (state_16664[(2)]);
var inst_16628 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_16664__$1 = (function (){var statearr_16718 = state_16664;
(statearr_16718[(12)] = inst_16627);

return statearr_16718;
})();
var statearr_16722_18142 = state_16664__$1;
(statearr_16722_18142[(2)] = inst_16628);

(statearr_16722_18142[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16665 === (9))){
var inst_16621 = (state_16664[(7)]);
var _ = (function (){var statearr_16726 = state_16664;
(statearr_16726[(4)] = cljs.core.cons((12),(state_16664[(4)])));

return statearr_16726;
})();
var inst_16634 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_16621) : chs__$1.call(null,inst_16621));
var inst_16635 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_16621) : done.call(null,inst_16621));
var inst_16636 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_16634,inst_16635);
var ___$1 = (function (){var statearr_16727 = state_16664;
(statearr_16727[(4)] = cljs.core.rest((state_16664[(4)])));

return statearr_16727;
})();
var state_16664__$1 = state_16664;
var statearr_16729_18143 = state_16664__$1;
(statearr_16729_18143[(2)] = inst_16636);

(statearr_16729_18143[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16665 === (5))){
var inst_16646 = (state_16664[(2)]);
var state_16664__$1 = (function (){var statearr_16732 = state_16664;
(statearr_16732[(13)] = inst_16646);

return statearr_16732;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16664__$1,(13),dchan);
} else {
if((state_val_16665 === (14))){
var inst_16651 = cljs.core.async.close_BANG_(out);
var state_16664__$1 = state_16664;
var statearr_16746_18144 = state_16664__$1;
(statearr_16746_18144[(2)] = inst_16651);

(statearr_16746_18144[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16665 === (16))){
var inst_16658 = (state_16664[(2)]);
var state_16664__$1 = state_16664;
var statearr_16747_18145 = state_16664__$1;
(statearr_16747_18145[(2)] = inst_16658);

(statearr_16747_18145[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16665 === (10))){
var inst_16621 = (state_16664[(7)]);
var inst_16639 = (state_16664[(2)]);
var inst_16640 = (inst_16621 + (1));
var inst_16621__$1 = inst_16640;
var state_16664__$1 = (function (){var statearr_16748 = state_16664;
(statearr_16748[(7)] = inst_16621__$1);

(statearr_16748[(14)] = inst_16639);

return statearr_16748;
})();
var statearr_16749_18146 = state_16664__$1;
(statearr_16749_18146[(2)] = null);

(statearr_16749_18146[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16665 === (8))){
var inst_16644 = (state_16664[(2)]);
var state_16664__$1 = state_16664;
var statearr_16750_18147 = state_16664__$1;
(statearr_16750_18147[(2)] = inst_16644);

(statearr_16750_18147[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__14360__auto__ = null;
var cljs$core$async$state_machine__14360__auto____0 = (function (){
var statearr_16752 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16752[(0)] = cljs$core$async$state_machine__14360__auto__);

(statearr_16752[(1)] = (1));

return statearr_16752;
});
var cljs$core$async$state_machine__14360__auto____1 = (function (state_16664){
while(true){
var ret_value__14361__auto__ = (function (){try{while(true){
var result__14362__auto__ = switch__14359__auto__(state_16664);
if(cljs.core.keyword_identical_QMARK_(result__14362__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14362__auto__;
}
break;
}
}catch (e16758){var ex__14363__auto__ = e16758;
var statearr_16759_18150 = state_16664;
(statearr_16759_18150[(2)] = ex__14363__auto__);


if(cljs.core.seq((state_16664[(4)]))){
var statearr_16765_18151 = state_16664;
(statearr_16765_18151[(1)] = cljs.core.first((state_16664[(4)])));

} else {
throw ex__14363__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14361__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18152 = state_16664;
state_16664 = G__18152;
continue;
} else {
return ret_value__14361__auto__;
}
break;
}
});
cljs$core$async$state_machine__14360__auto__ = function(state_16664){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14360__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14360__auto____1.call(this,state_16664);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14360__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14360__auto____0;
cljs$core$async$state_machine__14360__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14360__auto____1;
return cljs$core$async$state_machine__14360__auto__;
})()
})();
var state__14695__auto__ = (function (){var statearr_16769 = f__14694__auto__();
(statearr_16769[(6)] = c__14693__auto___18123);

return statearr_16769;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14695__auto__);
}));

}

return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__16785 = arguments.length;
switch (G__16785) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__14693__auto___18154 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14694__auto__ = (function (){var switch__14359__auto__ = (function (state_16826){
var state_val_16827 = (state_16826[(1)]);
if((state_val_16827 === (7))){
var inst_16799 = (state_16826[(7)]);
var inst_16801 = (state_16826[(8)]);
var inst_16799__$1 = (state_16826[(2)]);
var inst_16801__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16799__$1,(0),null);
var inst_16802 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16799__$1,(1),null);
var inst_16804 = (inst_16801__$1 == null);
var state_16826__$1 = (function (){var statearr_16837 = state_16826;
(statearr_16837[(7)] = inst_16799__$1);

(statearr_16837[(9)] = inst_16802);

(statearr_16837[(8)] = inst_16801__$1);

return statearr_16837;
})();
if(cljs.core.truth_(inst_16804)){
var statearr_16842_18155 = state_16826__$1;
(statearr_16842_18155[(1)] = (8));

} else {
var statearr_16843_18156 = state_16826__$1;
(statearr_16843_18156[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16827 === (1))){
var inst_16789 = cljs.core.vec(chs);
var inst_16790 = inst_16789;
var state_16826__$1 = (function (){var statearr_16844 = state_16826;
(statearr_16844[(10)] = inst_16790);

return statearr_16844;
})();
var statearr_16845_18157 = state_16826__$1;
(statearr_16845_18157[(2)] = null);

(statearr_16845_18157[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16827 === (4))){
var inst_16790 = (state_16826[(10)]);
var state_16826__$1 = state_16826;
return cljs.core.async.ioc_alts_BANG_(state_16826__$1,(7),inst_16790);
} else {
if((state_val_16827 === (6))){
var inst_16822 = (state_16826[(2)]);
var state_16826__$1 = state_16826;
var statearr_16847_18161 = state_16826__$1;
(statearr_16847_18161[(2)] = inst_16822);

(statearr_16847_18161[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16827 === (3))){
var inst_16824 = (state_16826[(2)]);
var state_16826__$1 = state_16826;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16826__$1,inst_16824);
} else {
if((state_val_16827 === (2))){
var inst_16790 = (state_16826[(10)]);
var inst_16792 = cljs.core.count(inst_16790);
var inst_16793 = (inst_16792 > (0));
var state_16826__$1 = state_16826;
if(cljs.core.truth_(inst_16793)){
var statearr_16855_18162 = state_16826__$1;
(statearr_16855_18162[(1)] = (4));

} else {
var statearr_16857_18163 = state_16826__$1;
(statearr_16857_18163[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16827 === (11))){
var inst_16790 = (state_16826[(10)]);
var inst_16815 = (state_16826[(2)]);
var tmp16851 = inst_16790;
var inst_16790__$1 = tmp16851;
var state_16826__$1 = (function (){var statearr_16860 = state_16826;
(statearr_16860[(10)] = inst_16790__$1);

(statearr_16860[(11)] = inst_16815);

return statearr_16860;
})();
var statearr_16863_18164 = state_16826__$1;
(statearr_16863_18164[(2)] = null);

(statearr_16863_18164[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16827 === (9))){
var inst_16801 = (state_16826[(8)]);
var state_16826__$1 = state_16826;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16826__$1,(11),out,inst_16801);
} else {
if((state_val_16827 === (5))){
var inst_16820 = cljs.core.async.close_BANG_(out);
var state_16826__$1 = state_16826;
var statearr_16873_18165 = state_16826__$1;
(statearr_16873_18165[(2)] = inst_16820);

(statearr_16873_18165[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16827 === (10))){
var inst_16818 = (state_16826[(2)]);
var state_16826__$1 = state_16826;
var statearr_16878_18166 = state_16826__$1;
(statearr_16878_18166[(2)] = inst_16818);

(statearr_16878_18166[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16827 === (8))){
var inst_16799 = (state_16826[(7)]);
var inst_16790 = (state_16826[(10)]);
var inst_16802 = (state_16826[(9)]);
var inst_16801 = (state_16826[(8)]);
var inst_16810 = (function (){var cs = inst_16790;
var vec__16795 = inst_16799;
var v = inst_16801;
var c = inst_16802;
return (function (p1__16774_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__16774_SHARP_);
});
})();
var inst_16811 = cljs.core.filterv(inst_16810,inst_16790);
var inst_16790__$1 = inst_16811;
var state_16826__$1 = (function (){var statearr_16882 = state_16826;
(statearr_16882[(10)] = inst_16790__$1);

return statearr_16882;
})();
var statearr_16883_18167 = state_16826__$1;
(statearr_16883_18167[(2)] = null);

(statearr_16883_18167[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__14360__auto__ = null;
var cljs$core$async$state_machine__14360__auto____0 = (function (){
var statearr_16889 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16889[(0)] = cljs$core$async$state_machine__14360__auto__);

(statearr_16889[(1)] = (1));

return statearr_16889;
});
var cljs$core$async$state_machine__14360__auto____1 = (function (state_16826){
while(true){
var ret_value__14361__auto__ = (function (){try{while(true){
var result__14362__auto__ = switch__14359__auto__(state_16826);
if(cljs.core.keyword_identical_QMARK_(result__14362__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14362__auto__;
}
break;
}
}catch (e16890){var ex__14363__auto__ = e16890;
var statearr_16891_18168 = state_16826;
(statearr_16891_18168[(2)] = ex__14363__auto__);


if(cljs.core.seq((state_16826[(4)]))){
var statearr_16892_18169 = state_16826;
(statearr_16892_18169[(1)] = cljs.core.first((state_16826[(4)])));

} else {
throw ex__14363__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14361__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18170 = state_16826;
state_16826 = G__18170;
continue;
} else {
return ret_value__14361__auto__;
}
break;
}
});
cljs$core$async$state_machine__14360__auto__ = function(state_16826){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14360__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14360__auto____1.call(this,state_16826);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14360__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14360__auto____0;
cljs$core$async$state_machine__14360__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14360__auto____1;
return cljs$core$async$state_machine__14360__auto__;
})()
})();
var state__14695__auto__ = (function (){var statearr_16897 = f__14694__auto__();
(statearr_16897[(6)] = c__14693__auto___18154);

return statearr_16897;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14695__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__16908 = arguments.length;
switch (G__16908) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__14693__auto___18175 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14694__auto__ = (function (){var switch__14359__auto__ = (function (state_16933){
var state_val_16934 = (state_16933[(1)]);
if((state_val_16934 === (7))){
var inst_16915 = (state_16933[(7)]);
var inst_16915__$1 = (state_16933[(2)]);
var inst_16916 = (inst_16915__$1 == null);
var inst_16917 = cljs.core.not(inst_16916);
var state_16933__$1 = (function (){var statearr_16935 = state_16933;
(statearr_16935[(7)] = inst_16915__$1);

return statearr_16935;
})();
if(inst_16917){
var statearr_16937_18176 = state_16933__$1;
(statearr_16937_18176[(1)] = (8));

} else {
var statearr_16938_18177 = state_16933__$1;
(statearr_16938_18177[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16934 === (1))){
var inst_16910 = (0);
var state_16933__$1 = (function (){var statearr_16939 = state_16933;
(statearr_16939[(8)] = inst_16910);

return statearr_16939;
})();
var statearr_16940_18178 = state_16933__$1;
(statearr_16940_18178[(2)] = null);

(statearr_16940_18178[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16934 === (4))){
var state_16933__$1 = state_16933;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16933__$1,(7),ch);
} else {
if((state_val_16934 === (6))){
var inst_16928 = (state_16933[(2)]);
var state_16933__$1 = state_16933;
var statearr_16941_18179 = state_16933__$1;
(statearr_16941_18179[(2)] = inst_16928);

(statearr_16941_18179[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16934 === (3))){
var inst_16930 = (state_16933[(2)]);
var inst_16931 = cljs.core.async.close_BANG_(out);
var state_16933__$1 = (function (){var statearr_16942 = state_16933;
(statearr_16942[(9)] = inst_16930);

return statearr_16942;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_16933__$1,inst_16931);
} else {
if((state_val_16934 === (2))){
var inst_16910 = (state_16933[(8)]);
var inst_16912 = (inst_16910 < n);
var state_16933__$1 = state_16933;
if(cljs.core.truth_(inst_16912)){
var statearr_16944_18180 = state_16933__$1;
(statearr_16944_18180[(1)] = (4));

} else {
var statearr_16945_18181 = state_16933__$1;
(statearr_16945_18181[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16934 === (11))){
var inst_16910 = (state_16933[(8)]);
var inst_16920 = (state_16933[(2)]);
var inst_16921 = (inst_16910 + (1));
var inst_16910__$1 = inst_16921;
var state_16933__$1 = (function (){var statearr_16947 = state_16933;
(statearr_16947[(10)] = inst_16920);

(statearr_16947[(8)] = inst_16910__$1);

return statearr_16947;
})();
var statearr_16948_18182 = state_16933__$1;
(statearr_16948_18182[(2)] = null);

(statearr_16948_18182[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16934 === (9))){
var state_16933__$1 = state_16933;
var statearr_16952_18183 = state_16933__$1;
(statearr_16952_18183[(2)] = null);

(statearr_16952_18183[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16934 === (5))){
var state_16933__$1 = state_16933;
var statearr_16953_18184 = state_16933__$1;
(statearr_16953_18184[(2)] = null);

(statearr_16953_18184[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16934 === (10))){
var inst_16925 = (state_16933[(2)]);
var state_16933__$1 = state_16933;
var statearr_16954_18185 = state_16933__$1;
(statearr_16954_18185[(2)] = inst_16925);

(statearr_16954_18185[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16934 === (8))){
var inst_16915 = (state_16933[(7)]);
var state_16933__$1 = state_16933;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16933__$1,(11),out,inst_16915);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__14360__auto__ = null;
var cljs$core$async$state_machine__14360__auto____0 = (function (){
var statearr_16955 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_16955[(0)] = cljs$core$async$state_machine__14360__auto__);

(statearr_16955[(1)] = (1));

return statearr_16955;
});
var cljs$core$async$state_machine__14360__auto____1 = (function (state_16933){
while(true){
var ret_value__14361__auto__ = (function (){try{while(true){
var result__14362__auto__ = switch__14359__auto__(state_16933);
if(cljs.core.keyword_identical_QMARK_(result__14362__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14362__auto__;
}
break;
}
}catch (e16956){var ex__14363__auto__ = e16956;
var statearr_16957_18187 = state_16933;
(statearr_16957_18187[(2)] = ex__14363__auto__);


if(cljs.core.seq((state_16933[(4)]))){
var statearr_16958_18188 = state_16933;
(statearr_16958_18188[(1)] = cljs.core.first((state_16933[(4)])));

} else {
throw ex__14363__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14361__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18190 = state_16933;
state_16933 = G__18190;
continue;
} else {
return ret_value__14361__auto__;
}
break;
}
});
cljs$core$async$state_machine__14360__auto__ = function(state_16933){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14360__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14360__auto____1.call(this,state_16933);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14360__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14360__auto____0;
cljs$core$async$state_machine__14360__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14360__auto____1;
return cljs$core$async$state_machine__14360__auto__;
})()
})();
var state__14695__auto__ = (function (){var statearr_16960 = f__14694__auto__();
(statearr_16960[(6)] = c__14693__auto___18175);

return statearr_16960;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14695__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16967 = (function (f,ch,meta16963,_,fn1,meta16968){
this.f = f;
this.ch = ch;
this.meta16963 = meta16963;
this._ = _;
this.fn1 = fn1;
this.meta16968 = meta16968;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async16967.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16969,meta16968__$1){
var self__ = this;
var _16969__$1 = this;
return (new cljs.core.async.t_cljs$core$async16967(self__.f,self__.ch,self__.meta16963,self__._,self__.fn1,meta16968__$1));
}));

(cljs.core.async.t_cljs$core$async16967.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16969){
var self__ = this;
var _16969__$1 = this;
return self__.meta16968;
}));

(cljs.core.async.t_cljs$core$async16967.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16967.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async16967.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async16967.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__16961_SHARP_){
var G__16980 = (((p1__16961_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__16961_SHARP_) : self__.f.call(null,p1__16961_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__16980) : f1.call(null,G__16980));
});
}));

(cljs.core.async.t_cljs$core$async16967.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16963","meta16963",1593437849,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async16962","cljs.core.async/t_cljs$core$async16962",-230291409,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta16968","meta16968",-1301425412,null)], null);
}));

(cljs.core.async.t_cljs$core$async16967.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async16967.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16967");

(cljs.core.async.t_cljs$core$async16967.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async16967");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async16967.
 */
cljs.core.async.__GT_t_cljs$core$async16967 = (function cljs$core$async$__GT_t_cljs$core$async16967(f,ch,meta16963,_,fn1,meta16968){
return (new cljs.core.async.t_cljs$core$async16967(f,ch,meta16963,_,fn1,meta16968));
});



/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16962 = (function (f,ch,meta16963){
this.f = f;
this.ch = ch;
this.meta16963 = meta16963;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async16962.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16964,meta16963__$1){
var self__ = this;
var _16964__$1 = this;
return (new cljs.core.async.t_cljs$core$async16962(self__.f,self__.ch,meta16963__$1));
}));

(cljs.core.async.t_cljs$core$async16962.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16964){
var self__ = this;
var _16964__$1 = this;
return self__.meta16963;
}));

(cljs.core.async.t_cljs$core$async16962.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16962.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async16962.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async16962.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16962.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(new cljs.core.async.t_cljs$core$async16967(self__.f,self__.ch,self__.meta16963,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY)));
if(cljs.core.truth_((function (){var and__5000__auto__ = ret;
if(cljs.core.truth_(and__5000__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__5000__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__16987 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__16987) : self__.f.call(null,G__16987));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async16962.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16962.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async16962.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16963","meta16963",1593437849,null)], null);
}));

(cljs.core.async.t_cljs$core$async16962.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async16962.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16962");

(cljs.core.async.t_cljs$core$async16962.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async16962");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async16962.
 */
cljs.core.async.__GT_t_cljs$core$async16962 = (function cljs$core$async$__GT_t_cljs$core$async16962(f,ch,meta16963){
return (new cljs.core.async.t_cljs$core$async16962(f,ch,meta16963));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
return (new cljs.core.async.t_cljs$core$async16962(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16992 = (function (f,ch,meta16993){
this.f = f;
this.ch = ch;
this.meta16993 = meta16993;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async16992.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16994,meta16993__$1){
var self__ = this;
var _16994__$1 = this;
return (new cljs.core.async.t_cljs$core$async16992(self__.f,self__.ch,meta16993__$1));
}));

(cljs.core.async.t_cljs$core$async16992.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16994){
var self__ = this;
var _16994__$1 = this;
return self__.meta16993;
}));

(cljs.core.async.t_cljs$core$async16992.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16992.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async16992.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16992.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async16992.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16992.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async16992.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16993","meta16993",-2046922760,null)], null);
}));

(cljs.core.async.t_cljs$core$async16992.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async16992.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16992");

(cljs.core.async.t_cljs$core$async16992.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async16992");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async16992.
 */
cljs.core.async.__GT_t_cljs$core$async16992 = (function cljs$core$async$__GT_t_cljs$core$async16992(f,ch,meta16993){
return (new cljs.core.async.t_cljs$core$async16992(f,ch,meta16993));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
return (new cljs.core.async.t_cljs$core$async16992(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17004 = (function (p,ch,meta17005){
this.p = p;
this.ch = ch;
this.meta17005 = meta17005;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async17004.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17006,meta17005__$1){
var self__ = this;
var _17006__$1 = this;
return (new cljs.core.async.t_cljs$core$async17004(self__.p,self__.ch,meta17005__$1));
}));

(cljs.core.async.t_cljs$core$async17004.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17006){
var self__ = this;
var _17006__$1 = this;
return self__.meta17005;
}));

(cljs.core.async.t_cljs$core$async17004.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17004.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async17004.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async17004.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17004.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async17004.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17004.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async17004.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta17005","meta17005",-832257897,null)], null);
}));

(cljs.core.async.t_cljs$core$async17004.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async17004.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17004");

(cljs.core.async.t_cljs$core$async17004.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async17004");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async17004.
 */
cljs.core.async.__GT_t_cljs$core$async17004 = (function cljs$core$async$__GT_t_cljs$core$async17004(p,ch,meta17005){
return (new cljs.core.async.t_cljs$core$async17004(p,ch,meta17005));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
return (new cljs.core.async.t_cljs$core$async17004(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__17025 = arguments.length;
switch (G__17025) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__14693__auto___18196 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14694__auto__ = (function (){var switch__14359__auto__ = (function (state_17062){
var state_val_17064 = (state_17062[(1)]);
if((state_val_17064 === (7))){
var inst_17057 = (state_17062[(2)]);
var state_17062__$1 = state_17062;
var statearr_17090_18197 = state_17062__$1;
(statearr_17090_18197[(2)] = inst_17057);

(statearr_17090_18197[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17064 === (1))){
var state_17062__$1 = state_17062;
var statearr_17100_18198 = state_17062__$1;
(statearr_17100_18198[(2)] = null);

(statearr_17100_18198[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17064 === (4))){
var inst_17035 = (state_17062[(7)]);
var inst_17035__$1 = (state_17062[(2)]);
var inst_17039 = (inst_17035__$1 == null);
var state_17062__$1 = (function (){var statearr_17102 = state_17062;
(statearr_17102[(7)] = inst_17035__$1);

return statearr_17102;
})();
if(cljs.core.truth_(inst_17039)){
var statearr_17103_18199 = state_17062__$1;
(statearr_17103_18199[(1)] = (5));

} else {
var statearr_17104_18200 = state_17062__$1;
(statearr_17104_18200[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17064 === (6))){
var inst_17035 = (state_17062[(7)]);
var inst_17043 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_17035) : p.call(null,inst_17035));
var state_17062__$1 = state_17062;
if(cljs.core.truth_(inst_17043)){
var statearr_17106_18201 = state_17062__$1;
(statearr_17106_18201[(1)] = (8));

} else {
var statearr_17108_18202 = state_17062__$1;
(statearr_17108_18202[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17064 === (3))){
var inst_17059 = (state_17062[(2)]);
var state_17062__$1 = state_17062;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17062__$1,inst_17059);
} else {
if((state_val_17064 === (2))){
var state_17062__$1 = state_17062;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17062__$1,(4),ch);
} else {
if((state_val_17064 === (11))){
var inst_17050 = (state_17062[(2)]);
var state_17062__$1 = state_17062;
var statearr_17112_18203 = state_17062__$1;
(statearr_17112_18203[(2)] = inst_17050);

(statearr_17112_18203[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17064 === (9))){
var state_17062__$1 = state_17062;
var statearr_17113_18208 = state_17062__$1;
(statearr_17113_18208[(2)] = null);

(statearr_17113_18208[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17064 === (5))){
var inst_17041 = cljs.core.async.close_BANG_(out);
var state_17062__$1 = state_17062;
var statearr_17114_18209 = state_17062__$1;
(statearr_17114_18209[(2)] = inst_17041);

(statearr_17114_18209[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17064 === (10))){
var inst_17053 = (state_17062[(2)]);
var state_17062__$1 = (function (){var statearr_17115 = state_17062;
(statearr_17115[(8)] = inst_17053);

return statearr_17115;
})();
var statearr_17116_18213 = state_17062__$1;
(statearr_17116_18213[(2)] = null);

(statearr_17116_18213[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17064 === (8))){
var inst_17035 = (state_17062[(7)]);
var state_17062__$1 = state_17062;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17062__$1,(11),out,inst_17035);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__14360__auto__ = null;
var cljs$core$async$state_machine__14360__auto____0 = (function (){
var statearr_17123 = [null,null,null,null,null,null,null,null,null];
(statearr_17123[(0)] = cljs$core$async$state_machine__14360__auto__);

(statearr_17123[(1)] = (1));

return statearr_17123;
});
var cljs$core$async$state_machine__14360__auto____1 = (function (state_17062){
while(true){
var ret_value__14361__auto__ = (function (){try{while(true){
var result__14362__auto__ = switch__14359__auto__(state_17062);
if(cljs.core.keyword_identical_QMARK_(result__14362__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14362__auto__;
}
break;
}
}catch (e17125){var ex__14363__auto__ = e17125;
var statearr_17127_18214 = state_17062;
(statearr_17127_18214[(2)] = ex__14363__auto__);


if(cljs.core.seq((state_17062[(4)]))){
var statearr_17128_18215 = state_17062;
(statearr_17128_18215[(1)] = cljs.core.first((state_17062[(4)])));

} else {
throw ex__14363__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14361__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18216 = state_17062;
state_17062 = G__18216;
continue;
} else {
return ret_value__14361__auto__;
}
break;
}
});
cljs$core$async$state_machine__14360__auto__ = function(state_17062){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14360__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14360__auto____1.call(this,state_17062);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14360__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14360__auto____0;
cljs$core$async$state_machine__14360__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14360__auto____1;
return cljs$core$async$state_machine__14360__auto__;
})()
})();
var state__14695__auto__ = (function (){var statearr_17135 = f__14694__auto__();
(statearr_17135[(6)] = c__14693__auto___18196);

return statearr_17135;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14695__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__17137 = arguments.length;
switch (G__17137) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__14693__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14694__auto__ = (function (){var switch__14359__auto__ = (function (state_17212){
var state_val_17213 = (state_17212[(1)]);
if((state_val_17213 === (7))){
var inst_17208 = (state_17212[(2)]);
var state_17212__$1 = state_17212;
var statearr_17215_18221 = state_17212__$1;
(statearr_17215_18221[(2)] = inst_17208);

(statearr_17215_18221[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17213 === (20))){
var inst_17176 = (state_17212[(7)]);
var inst_17188 = (state_17212[(2)]);
var inst_17189 = cljs.core.next(inst_17176);
var inst_17161 = inst_17189;
var inst_17162 = null;
var inst_17163 = (0);
var inst_17164 = (0);
var state_17212__$1 = (function (){var statearr_17216 = state_17212;
(statearr_17216[(8)] = inst_17162);

(statearr_17216[(9)] = inst_17163);

(statearr_17216[(10)] = inst_17188);

(statearr_17216[(11)] = inst_17164);

(statearr_17216[(12)] = inst_17161);

return statearr_17216;
})();
var statearr_17217_18222 = state_17212__$1;
(statearr_17217_18222[(2)] = null);

(statearr_17217_18222[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17213 === (1))){
var state_17212__$1 = state_17212;
var statearr_17218_18223 = state_17212__$1;
(statearr_17218_18223[(2)] = null);

(statearr_17218_18223[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17213 === (4))){
var inst_17144 = (state_17212[(13)]);
var inst_17144__$1 = (state_17212[(2)]);
var inst_17145 = (inst_17144__$1 == null);
var state_17212__$1 = (function (){var statearr_17219 = state_17212;
(statearr_17219[(13)] = inst_17144__$1);

return statearr_17219;
})();
if(cljs.core.truth_(inst_17145)){
var statearr_17220_18224 = state_17212__$1;
(statearr_17220_18224[(1)] = (5));

} else {
var statearr_17222_18225 = state_17212__$1;
(statearr_17222_18225[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17213 === (15))){
var state_17212__$1 = state_17212;
var statearr_17226_18226 = state_17212__$1;
(statearr_17226_18226[(2)] = null);

(statearr_17226_18226[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17213 === (21))){
var state_17212__$1 = state_17212;
var statearr_17227_18227 = state_17212__$1;
(statearr_17227_18227[(2)] = null);

(statearr_17227_18227[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17213 === (13))){
var inst_17162 = (state_17212[(8)]);
var inst_17163 = (state_17212[(9)]);
var inst_17164 = (state_17212[(11)]);
var inst_17161 = (state_17212[(12)]);
var inst_17172 = (state_17212[(2)]);
var inst_17173 = (inst_17164 + (1));
var tmp17223 = inst_17162;
var tmp17224 = inst_17163;
var tmp17225 = inst_17161;
var inst_17161__$1 = tmp17225;
var inst_17162__$1 = tmp17223;
var inst_17163__$1 = tmp17224;
var inst_17164__$1 = inst_17173;
var state_17212__$1 = (function (){var statearr_17228 = state_17212;
(statearr_17228[(8)] = inst_17162__$1);

(statearr_17228[(9)] = inst_17163__$1);

(statearr_17228[(11)] = inst_17164__$1);

(statearr_17228[(14)] = inst_17172);

(statearr_17228[(12)] = inst_17161__$1);

return statearr_17228;
})();
var statearr_17229_18228 = state_17212__$1;
(statearr_17229_18228[(2)] = null);

(statearr_17229_18228[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17213 === (22))){
var state_17212__$1 = state_17212;
var statearr_17233_18229 = state_17212__$1;
(statearr_17233_18229[(2)] = null);

(statearr_17233_18229[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17213 === (6))){
var inst_17144 = (state_17212[(13)]);
var inst_17155 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_17144) : f.call(null,inst_17144));
var inst_17156 = cljs.core.seq(inst_17155);
var inst_17161 = inst_17156;
var inst_17162 = null;
var inst_17163 = (0);
var inst_17164 = (0);
var state_17212__$1 = (function (){var statearr_17235 = state_17212;
(statearr_17235[(8)] = inst_17162);

(statearr_17235[(9)] = inst_17163);

(statearr_17235[(11)] = inst_17164);

(statearr_17235[(12)] = inst_17161);

return statearr_17235;
})();
var statearr_17237_18230 = state_17212__$1;
(statearr_17237_18230[(2)] = null);

(statearr_17237_18230[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17213 === (17))){
var inst_17176 = (state_17212[(7)]);
var inst_17181 = cljs.core.chunk_first(inst_17176);
var inst_17182 = cljs.core.chunk_rest(inst_17176);
var inst_17183 = cljs.core.count(inst_17181);
var inst_17161 = inst_17182;
var inst_17162 = inst_17181;
var inst_17163 = inst_17183;
var inst_17164 = (0);
var state_17212__$1 = (function (){var statearr_17238 = state_17212;
(statearr_17238[(8)] = inst_17162);

(statearr_17238[(9)] = inst_17163);

(statearr_17238[(11)] = inst_17164);

(statearr_17238[(12)] = inst_17161);

return statearr_17238;
})();
var statearr_17239_18233 = state_17212__$1;
(statearr_17239_18233[(2)] = null);

(statearr_17239_18233[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17213 === (3))){
var inst_17210 = (state_17212[(2)]);
var state_17212__$1 = state_17212;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17212__$1,inst_17210);
} else {
if((state_val_17213 === (12))){
var inst_17198 = (state_17212[(2)]);
var state_17212__$1 = state_17212;
var statearr_17243_18234 = state_17212__$1;
(statearr_17243_18234[(2)] = inst_17198);

(statearr_17243_18234[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17213 === (2))){
var state_17212__$1 = state_17212;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17212__$1,(4),in$);
} else {
if((state_val_17213 === (23))){
var inst_17206 = (state_17212[(2)]);
var state_17212__$1 = state_17212;
var statearr_17248_18235 = state_17212__$1;
(statearr_17248_18235[(2)] = inst_17206);

(statearr_17248_18235[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17213 === (19))){
var inst_17192 = (state_17212[(2)]);
var state_17212__$1 = state_17212;
var statearr_17250_18236 = state_17212__$1;
(statearr_17250_18236[(2)] = inst_17192);

(statearr_17250_18236[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17213 === (11))){
var inst_17176 = (state_17212[(7)]);
var inst_17161 = (state_17212[(12)]);
var inst_17176__$1 = cljs.core.seq(inst_17161);
var state_17212__$1 = (function (){var statearr_17251 = state_17212;
(statearr_17251[(7)] = inst_17176__$1);

return statearr_17251;
})();
if(inst_17176__$1){
var statearr_17253_18237 = state_17212__$1;
(statearr_17253_18237[(1)] = (14));

} else {
var statearr_17254_18238 = state_17212__$1;
(statearr_17254_18238[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17213 === (9))){
var inst_17200 = (state_17212[(2)]);
var inst_17201 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_17212__$1 = (function (){var statearr_17256 = state_17212;
(statearr_17256[(15)] = inst_17200);

return statearr_17256;
})();
if(cljs.core.truth_(inst_17201)){
var statearr_17260_18243 = state_17212__$1;
(statearr_17260_18243[(1)] = (21));

} else {
var statearr_17262_18244 = state_17212__$1;
(statearr_17262_18244[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17213 === (5))){
var inst_17149 = cljs.core.async.close_BANG_(out);
var state_17212__$1 = state_17212;
var statearr_17263_18245 = state_17212__$1;
(statearr_17263_18245[(2)] = inst_17149);

(statearr_17263_18245[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17213 === (14))){
var inst_17176 = (state_17212[(7)]);
var inst_17179 = cljs.core.chunked_seq_QMARK_(inst_17176);
var state_17212__$1 = state_17212;
if(inst_17179){
var statearr_17265_18246 = state_17212__$1;
(statearr_17265_18246[(1)] = (17));

} else {
var statearr_17266_18247 = state_17212__$1;
(statearr_17266_18247[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17213 === (16))){
var inst_17196 = (state_17212[(2)]);
var state_17212__$1 = state_17212;
var statearr_17269_18252 = state_17212__$1;
(statearr_17269_18252[(2)] = inst_17196);

(statearr_17269_18252[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17213 === (10))){
var inst_17162 = (state_17212[(8)]);
var inst_17164 = (state_17212[(11)]);
var inst_17170 = cljs.core._nth(inst_17162,inst_17164);
var state_17212__$1 = state_17212;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17212__$1,(13),out,inst_17170);
} else {
if((state_val_17213 === (18))){
var inst_17176 = (state_17212[(7)]);
var inst_17186 = cljs.core.first(inst_17176);
var state_17212__$1 = state_17212;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17212__$1,(20),out,inst_17186);
} else {
if((state_val_17213 === (8))){
var inst_17163 = (state_17212[(9)]);
var inst_17164 = (state_17212[(11)]);
var inst_17166 = (inst_17164 < inst_17163);
var inst_17167 = inst_17166;
var state_17212__$1 = state_17212;
if(cljs.core.truth_(inst_17167)){
var statearr_17276_18254 = state_17212__$1;
(statearr_17276_18254[(1)] = (10));

} else {
var statearr_17278_18255 = state_17212__$1;
(statearr_17278_18255[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__14360__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__14360__auto____0 = (function (){
var statearr_17284 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17284[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__14360__auto__);

(statearr_17284[(1)] = (1));

return statearr_17284;
});
var cljs$core$async$mapcat_STAR__$_state_machine__14360__auto____1 = (function (state_17212){
while(true){
var ret_value__14361__auto__ = (function (){try{while(true){
var result__14362__auto__ = switch__14359__auto__(state_17212);
if(cljs.core.keyword_identical_QMARK_(result__14362__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14362__auto__;
}
break;
}
}catch (e17285){var ex__14363__auto__ = e17285;
var statearr_17289_18256 = state_17212;
(statearr_17289_18256[(2)] = ex__14363__auto__);


if(cljs.core.seq((state_17212[(4)]))){
var statearr_17291_18257 = state_17212;
(statearr_17291_18257[(1)] = cljs.core.first((state_17212[(4)])));

} else {
throw ex__14363__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14361__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18258 = state_17212;
state_17212 = G__18258;
continue;
} else {
return ret_value__14361__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__14360__auto__ = function(state_17212){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__14360__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__14360__auto____1.call(this,state_17212);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__14360__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__14360__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__14360__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__14360__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__14360__auto__;
})()
})();
var state__14695__auto__ = (function (){var statearr_17295 = f__14694__auto__();
(statearr_17295[(6)] = c__14693__auto__);

return statearr_17295;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14695__auto__);
}));

return c__14693__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__17302 = arguments.length;
switch (G__17302) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__17315 = arguments.length;
switch (G__17315) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__17328 = arguments.length;
switch (G__17328) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__14693__auto___18273 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14694__auto__ = (function (){var switch__14359__auto__ = (function (state_17361){
var state_val_17362 = (state_17361[(1)]);
if((state_val_17362 === (7))){
var inst_17356 = (state_17361[(2)]);
var state_17361__$1 = state_17361;
var statearr_17370_18274 = state_17361__$1;
(statearr_17370_18274[(2)] = inst_17356);

(statearr_17370_18274[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17362 === (1))){
var inst_17336 = null;
var state_17361__$1 = (function (){var statearr_17371 = state_17361;
(statearr_17371[(7)] = inst_17336);

return statearr_17371;
})();
var statearr_17373_18275 = state_17361__$1;
(statearr_17373_18275[(2)] = null);

(statearr_17373_18275[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17362 === (4))){
var inst_17340 = (state_17361[(8)]);
var inst_17340__$1 = (state_17361[(2)]);
var inst_17341 = (inst_17340__$1 == null);
var inst_17342 = cljs.core.not(inst_17341);
var state_17361__$1 = (function (){var statearr_17374 = state_17361;
(statearr_17374[(8)] = inst_17340__$1);

return statearr_17374;
})();
if(inst_17342){
var statearr_17375_18279 = state_17361__$1;
(statearr_17375_18279[(1)] = (5));

} else {
var statearr_17376_18280 = state_17361__$1;
(statearr_17376_18280[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17362 === (6))){
var state_17361__$1 = state_17361;
var statearr_17377_18282 = state_17361__$1;
(statearr_17377_18282[(2)] = null);

(statearr_17377_18282[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17362 === (3))){
var inst_17358 = (state_17361[(2)]);
var inst_17359 = cljs.core.async.close_BANG_(out);
var state_17361__$1 = (function (){var statearr_17379 = state_17361;
(statearr_17379[(9)] = inst_17358);

return statearr_17379;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_17361__$1,inst_17359);
} else {
if((state_val_17362 === (2))){
var state_17361__$1 = state_17361;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17361__$1,(4),ch);
} else {
if((state_val_17362 === (11))){
var inst_17340 = (state_17361[(8)]);
var inst_17350 = (state_17361[(2)]);
var inst_17336 = inst_17340;
var state_17361__$1 = (function (){var statearr_17380 = state_17361;
(statearr_17380[(7)] = inst_17336);

(statearr_17380[(10)] = inst_17350);

return statearr_17380;
})();
var statearr_17381_18283 = state_17361__$1;
(statearr_17381_18283[(2)] = null);

(statearr_17381_18283[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17362 === (9))){
var inst_17340 = (state_17361[(8)]);
var state_17361__$1 = state_17361;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17361__$1,(11),out,inst_17340);
} else {
if((state_val_17362 === (5))){
var inst_17336 = (state_17361[(7)]);
var inst_17340 = (state_17361[(8)]);
var inst_17345 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_17340,inst_17336);
var state_17361__$1 = state_17361;
if(inst_17345){
var statearr_17383_18287 = state_17361__$1;
(statearr_17383_18287[(1)] = (8));

} else {
var statearr_17384_18289 = state_17361__$1;
(statearr_17384_18289[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17362 === (10))){
var inst_17353 = (state_17361[(2)]);
var state_17361__$1 = state_17361;
var statearr_17388_18293 = state_17361__$1;
(statearr_17388_18293[(2)] = inst_17353);

(statearr_17388_18293[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17362 === (8))){
var inst_17336 = (state_17361[(7)]);
var tmp17382 = inst_17336;
var inst_17336__$1 = tmp17382;
var state_17361__$1 = (function (){var statearr_17392 = state_17361;
(statearr_17392[(7)] = inst_17336__$1);

return statearr_17392;
})();
var statearr_17393_18294 = state_17361__$1;
(statearr_17393_18294[(2)] = null);

(statearr_17393_18294[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__14360__auto__ = null;
var cljs$core$async$state_machine__14360__auto____0 = (function (){
var statearr_17394 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17394[(0)] = cljs$core$async$state_machine__14360__auto__);

(statearr_17394[(1)] = (1));

return statearr_17394;
});
var cljs$core$async$state_machine__14360__auto____1 = (function (state_17361){
while(true){
var ret_value__14361__auto__ = (function (){try{while(true){
var result__14362__auto__ = switch__14359__auto__(state_17361);
if(cljs.core.keyword_identical_QMARK_(result__14362__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14362__auto__;
}
break;
}
}catch (e17395){var ex__14363__auto__ = e17395;
var statearr_17396_18295 = state_17361;
(statearr_17396_18295[(2)] = ex__14363__auto__);


if(cljs.core.seq((state_17361[(4)]))){
var statearr_17397_18296 = state_17361;
(statearr_17397_18296[(1)] = cljs.core.first((state_17361[(4)])));

} else {
throw ex__14363__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14361__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18300 = state_17361;
state_17361 = G__18300;
continue;
} else {
return ret_value__14361__auto__;
}
break;
}
});
cljs$core$async$state_machine__14360__auto__ = function(state_17361){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14360__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14360__auto____1.call(this,state_17361);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14360__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14360__auto____0;
cljs$core$async$state_machine__14360__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14360__auto____1;
return cljs$core$async$state_machine__14360__auto__;
})()
})();
var state__14695__auto__ = (function (){var statearr_17398 = f__14694__auto__();
(statearr_17398[(6)] = c__14693__auto___18273);

return statearr_17398;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14695__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__17402 = arguments.length;
switch (G__17402) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__14693__auto___18303 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14694__auto__ = (function (){var switch__14359__auto__ = (function (state_17446){
var state_val_17447 = (state_17446[(1)]);
if((state_val_17447 === (7))){
var inst_17442 = (state_17446[(2)]);
var state_17446__$1 = state_17446;
var statearr_17452_18304 = state_17446__$1;
(statearr_17452_18304[(2)] = inst_17442);

(statearr_17452_18304[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17447 === (1))){
var inst_17408 = (new Array(n));
var inst_17409 = inst_17408;
var inst_17410 = (0);
var state_17446__$1 = (function (){var statearr_17456 = state_17446;
(statearr_17456[(7)] = inst_17410);

(statearr_17456[(8)] = inst_17409);

return statearr_17456;
})();
var statearr_17457_18309 = state_17446__$1;
(statearr_17457_18309[(2)] = null);

(statearr_17457_18309[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17447 === (4))){
var inst_17414 = (state_17446[(9)]);
var inst_17414__$1 = (state_17446[(2)]);
var inst_17415 = (inst_17414__$1 == null);
var inst_17416 = cljs.core.not(inst_17415);
var state_17446__$1 = (function (){var statearr_17461 = state_17446;
(statearr_17461[(9)] = inst_17414__$1);

return statearr_17461;
})();
if(inst_17416){
var statearr_17463_18310 = state_17446__$1;
(statearr_17463_18310[(1)] = (5));

} else {
var statearr_17464_18311 = state_17446__$1;
(statearr_17464_18311[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17447 === (15))){
var inst_17436 = (state_17446[(2)]);
var state_17446__$1 = state_17446;
var statearr_17466_18312 = state_17446__$1;
(statearr_17466_18312[(2)] = inst_17436);

(statearr_17466_18312[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17447 === (13))){
var state_17446__$1 = state_17446;
var statearr_17470_18313 = state_17446__$1;
(statearr_17470_18313[(2)] = null);

(statearr_17470_18313[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17447 === (6))){
var inst_17410 = (state_17446[(7)]);
var inst_17432 = (inst_17410 > (0));
var state_17446__$1 = state_17446;
if(cljs.core.truth_(inst_17432)){
var statearr_17476_18314 = state_17446__$1;
(statearr_17476_18314[(1)] = (12));

} else {
var statearr_17477_18315 = state_17446__$1;
(statearr_17477_18315[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17447 === (3))){
var inst_17444 = (state_17446[(2)]);
var state_17446__$1 = state_17446;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17446__$1,inst_17444);
} else {
if((state_val_17447 === (12))){
var inst_17409 = (state_17446[(8)]);
var inst_17434 = cljs.core.vec(inst_17409);
var state_17446__$1 = state_17446;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17446__$1,(15),out,inst_17434);
} else {
if((state_val_17447 === (2))){
var state_17446__$1 = state_17446;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17446__$1,(4),ch);
} else {
if((state_val_17447 === (11))){
var inst_17426 = (state_17446[(2)]);
var inst_17427 = (new Array(n));
var inst_17409 = inst_17427;
var inst_17410 = (0);
var state_17446__$1 = (function (){var statearr_17486 = state_17446;
(statearr_17486[(10)] = inst_17426);

(statearr_17486[(7)] = inst_17410);

(statearr_17486[(8)] = inst_17409);

return statearr_17486;
})();
var statearr_17488_18316 = state_17446__$1;
(statearr_17488_18316[(2)] = null);

(statearr_17488_18316[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17447 === (9))){
var inst_17409 = (state_17446[(8)]);
var inst_17424 = cljs.core.vec(inst_17409);
var state_17446__$1 = state_17446;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17446__$1,(11),out,inst_17424);
} else {
if((state_val_17447 === (5))){
var inst_17414 = (state_17446[(9)]);
var inst_17410 = (state_17446[(7)]);
var inst_17419 = (state_17446[(11)]);
var inst_17409 = (state_17446[(8)]);
var inst_17418 = (inst_17409[inst_17410] = inst_17414);
var inst_17419__$1 = (inst_17410 + (1));
var inst_17420 = (inst_17419__$1 < n);
var state_17446__$1 = (function (){var statearr_17492 = state_17446;
(statearr_17492[(12)] = inst_17418);

(statearr_17492[(11)] = inst_17419__$1);

return statearr_17492;
})();
if(cljs.core.truth_(inst_17420)){
var statearr_17494_18324 = state_17446__$1;
(statearr_17494_18324[(1)] = (8));

} else {
var statearr_17496_18325 = state_17446__$1;
(statearr_17496_18325[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17447 === (14))){
var inst_17439 = (state_17446[(2)]);
var inst_17440 = cljs.core.async.close_BANG_(out);
var state_17446__$1 = (function (){var statearr_17501 = state_17446;
(statearr_17501[(13)] = inst_17439);

return statearr_17501;
})();
var statearr_17502_18329 = state_17446__$1;
(statearr_17502_18329[(2)] = inst_17440);

(statearr_17502_18329[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17447 === (10))){
var inst_17430 = (state_17446[(2)]);
var state_17446__$1 = state_17446;
var statearr_17504_18330 = state_17446__$1;
(statearr_17504_18330[(2)] = inst_17430);

(statearr_17504_18330[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17447 === (8))){
var inst_17419 = (state_17446[(11)]);
var inst_17409 = (state_17446[(8)]);
var tmp17498 = inst_17409;
var inst_17409__$1 = tmp17498;
var inst_17410 = inst_17419;
var state_17446__$1 = (function (){var statearr_17508 = state_17446;
(statearr_17508[(7)] = inst_17410);

(statearr_17508[(8)] = inst_17409__$1);

return statearr_17508;
})();
var statearr_17509_18336 = state_17446__$1;
(statearr_17509_18336[(2)] = null);

(statearr_17509_18336[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__14360__auto__ = null;
var cljs$core$async$state_machine__14360__auto____0 = (function (){
var statearr_17514 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17514[(0)] = cljs$core$async$state_machine__14360__auto__);

(statearr_17514[(1)] = (1));

return statearr_17514;
});
var cljs$core$async$state_machine__14360__auto____1 = (function (state_17446){
while(true){
var ret_value__14361__auto__ = (function (){try{while(true){
var result__14362__auto__ = switch__14359__auto__(state_17446);
if(cljs.core.keyword_identical_QMARK_(result__14362__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14362__auto__;
}
break;
}
}catch (e17517){var ex__14363__auto__ = e17517;
var statearr_17519_18337 = state_17446;
(statearr_17519_18337[(2)] = ex__14363__auto__);


if(cljs.core.seq((state_17446[(4)]))){
var statearr_17520_18338 = state_17446;
(statearr_17520_18338[(1)] = cljs.core.first((state_17446[(4)])));

} else {
throw ex__14363__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14361__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18339 = state_17446;
state_17446 = G__18339;
continue;
} else {
return ret_value__14361__auto__;
}
break;
}
});
cljs$core$async$state_machine__14360__auto__ = function(state_17446){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14360__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14360__auto____1.call(this,state_17446);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14360__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14360__auto____0;
cljs$core$async$state_machine__14360__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14360__auto____1;
return cljs$core$async$state_machine__14360__auto__;
})()
})();
var state__14695__auto__ = (function (){var statearr_17524 = f__14694__auto__();
(statearr_17524[(6)] = c__14693__auto___18303);

return statearr_17524;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14695__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__17531 = arguments.length;
switch (G__17531) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__14693__auto___18345 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14694__auto__ = (function (){var switch__14359__auto__ = (function (state_17601){
var state_val_17602 = (state_17601[(1)]);
if((state_val_17602 === (7))){
var inst_17595 = (state_17601[(2)]);
var state_17601__$1 = state_17601;
var statearr_17609_18346 = state_17601__$1;
(statearr_17609_18346[(2)] = inst_17595);

(statearr_17609_18346[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17602 === (1))){
var inst_17544 = [];
var inst_17545 = inst_17544;
var inst_17546 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_17601__$1 = (function (){var statearr_17612 = state_17601;
(statearr_17612[(7)] = inst_17546);

(statearr_17612[(8)] = inst_17545);

return statearr_17612;
})();
var statearr_17614_18350 = state_17601__$1;
(statearr_17614_18350[(2)] = null);

(statearr_17614_18350[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17602 === (4))){
var inst_17549 = (state_17601[(9)]);
var inst_17549__$1 = (state_17601[(2)]);
var inst_17552 = (inst_17549__$1 == null);
var inst_17553 = cljs.core.not(inst_17552);
var state_17601__$1 = (function (){var statearr_17616 = state_17601;
(statearr_17616[(9)] = inst_17549__$1);

return statearr_17616;
})();
if(inst_17553){
var statearr_17619_18352 = state_17601__$1;
(statearr_17619_18352[(1)] = (5));

} else {
var statearr_17625_18353 = state_17601__$1;
(statearr_17625_18353[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17602 === (15))){
var inst_17545 = (state_17601[(8)]);
var inst_17587 = cljs.core.vec(inst_17545);
var state_17601__$1 = state_17601;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17601__$1,(18),out,inst_17587);
} else {
if((state_val_17602 === (13))){
var inst_17579 = (state_17601[(2)]);
var state_17601__$1 = state_17601;
var statearr_17637_18354 = state_17601__$1;
(statearr_17637_18354[(2)] = inst_17579);

(statearr_17637_18354[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17602 === (6))){
var inst_17545 = (state_17601[(8)]);
var inst_17582 = inst_17545.length;
var inst_17583 = (inst_17582 > (0));
var state_17601__$1 = state_17601;
if(cljs.core.truth_(inst_17583)){
var statearr_17641_18355 = state_17601__$1;
(statearr_17641_18355[(1)] = (15));

} else {
var statearr_17642_18356 = state_17601__$1;
(statearr_17642_18356[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17602 === (17))){
var inst_17592 = (state_17601[(2)]);
var inst_17593 = cljs.core.async.close_BANG_(out);
var state_17601__$1 = (function (){var statearr_17644 = state_17601;
(statearr_17644[(10)] = inst_17592);

return statearr_17644;
})();
var statearr_17647_18357 = state_17601__$1;
(statearr_17647_18357[(2)] = inst_17593);

(statearr_17647_18357[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17602 === (3))){
var inst_17597 = (state_17601[(2)]);
var state_17601__$1 = state_17601;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17601__$1,inst_17597);
} else {
if((state_val_17602 === (12))){
var inst_17545 = (state_17601[(8)]);
var inst_17569 = cljs.core.vec(inst_17545);
var state_17601__$1 = state_17601;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17601__$1,(14),out,inst_17569);
} else {
if((state_val_17602 === (2))){
var state_17601__$1 = state_17601;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17601__$1,(4),ch);
} else {
if((state_val_17602 === (11))){
var inst_17549 = (state_17601[(9)]);
var inst_17545 = (state_17601[(8)]);
var inst_17556 = (state_17601[(11)]);
var inst_17564 = inst_17545.push(inst_17549);
var tmp17650 = inst_17545;
var inst_17545__$1 = tmp17650;
var inst_17546 = inst_17556;
var state_17601__$1 = (function (){var statearr_17655 = state_17601;
(statearr_17655[(7)] = inst_17546);

(statearr_17655[(12)] = inst_17564);

(statearr_17655[(8)] = inst_17545__$1);

return statearr_17655;
})();
var statearr_17657_18362 = state_17601__$1;
(statearr_17657_18362[(2)] = null);

(statearr_17657_18362[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17602 === (9))){
var inst_17546 = (state_17601[(7)]);
var inst_17560 = cljs.core.keyword_identical_QMARK_(inst_17546,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_17601__$1 = state_17601;
var statearr_17663_18363 = state_17601__$1;
(statearr_17663_18363[(2)] = inst_17560);

(statearr_17663_18363[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17602 === (5))){
var inst_17549 = (state_17601[(9)]);
var inst_17546 = (state_17601[(7)]);
var inst_17556 = (state_17601[(11)]);
var inst_17557 = (state_17601[(13)]);
var inst_17556__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_17549) : f.call(null,inst_17549));
var inst_17557__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_17556__$1,inst_17546);
var state_17601__$1 = (function (){var statearr_17668 = state_17601;
(statearr_17668[(11)] = inst_17556__$1);

(statearr_17668[(13)] = inst_17557__$1);

return statearr_17668;
})();
if(inst_17557__$1){
var statearr_17669_18364 = state_17601__$1;
(statearr_17669_18364[(1)] = (8));

} else {
var statearr_17670_18365 = state_17601__$1;
(statearr_17670_18365[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17602 === (14))){
var inst_17549 = (state_17601[(9)]);
var inst_17556 = (state_17601[(11)]);
var inst_17571 = (state_17601[(2)]);
var inst_17575 = [];
var inst_17576 = inst_17575.push(inst_17549);
var inst_17545 = inst_17575;
var inst_17546 = inst_17556;
var state_17601__$1 = (function (){var statearr_17674 = state_17601;
(statearr_17674[(14)] = inst_17576);

(statearr_17674[(15)] = inst_17571);

(statearr_17674[(7)] = inst_17546);

(statearr_17674[(8)] = inst_17545);

return statearr_17674;
})();
var statearr_17677_18367 = state_17601__$1;
(statearr_17677_18367[(2)] = null);

(statearr_17677_18367[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17602 === (16))){
var state_17601__$1 = state_17601;
var statearr_17680_18368 = state_17601__$1;
(statearr_17680_18368[(2)] = null);

(statearr_17680_18368[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17602 === (10))){
var inst_17562 = (state_17601[(2)]);
var state_17601__$1 = state_17601;
if(cljs.core.truth_(inst_17562)){
var statearr_17682_18371 = state_17601__$1;
(statearr_17682_18371[(1)] = (11));

} else {
var statearr_17683_18372 = state_17601__$1;
(statearr_17683_18372[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17602 === (18))){
var inst_17589 = (state_17601[(2)]);
var state_17601__$1 = state_17601;
var statearr_17684_18373 = state_17601__$1;
(statearr_17684_18373[(2)] = inst_17589);

(statearr_17684_18373[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17602 === (8))){
var inst_17557 = (state_17601[(13)]);
var state_17601__$1 = state_17601;
var statearr_17685_18374 = state_17601__$1;
(statearr_17685_18374[(2)] = inst_17557);

(statearr_17685_18374[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__14360__auto__ = null;
var cljs$core$async$state_machine__14360__auto____0 = (function (){
var statearr_17686 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17686[(0)] = cljs$core$async$state_machine__14360__auto__);

(statearr_17686[(1)] = (1));

return statearr_17686;
});
var cljs$core$async$state_machine__14360__auto____1 = (function (state_17601){
while(true){
var ret_value__14361__auto__ = (function (){try{while(true){
var result__14362__auto__ = switch__14359__auto__(state_17601);
if(cljs.core.keyword_identical_QMARK_(result__14362__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14362__auto__;
}
break;
}
}catch (e17687){var ex__14363__auto__ = e17687;
var statearr_17688_18375 = state_17601;
(statearr_17688_18375[(2)] = ex__14363__auto__);


if(cljs.core.seq((state_17601[(4)]))){
var statearr_17689_18376 = state_17601;
(statearr_17689_18376[(1)] = cljs.core.first((state_17601[(4)])));

} else {
throw ex__14363__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14361__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18381 = state_17601;
state_17601 = G__18381;
continue;
} else {
return ret_value__14361__auto__;
}
break;
}
});
cljs$core$async$state_machine__14360__auto__ = function(state_17601){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14360__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14360__auto____1.call(this,state_17601);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14360__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14360__auto____0;
cljs$core$async$state_machine__14360__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14360__auto____1;
return cljs$core$async$state_machine__14360__auto__;
})()
})();
var state__14695__auto__ = (function (){var statearr_17691 = f__14694__auto__();
(statearr_17691[(6)] = c__14693__auto___18345);

return statearr_17691;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14695__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
