goog.provide('cljs.core');
goog.scope(function(){
  cljs.core.goog$module$goog$math$Long = goog.module.get('goog.math.Long');
  cljs.core.goog$module$goog$object = goog.module.get('goog.object');
  cljs.core.goog$module$goog$array = goog.module.get('goog.array');
});
cljs.core._STAR_clojurescript_version_STAR_ = "1.11.132";
cljs.core._STAR_unchecked_if_STAR_ = false;
cljs.core._STAR_unchecked_arrays_STAR_ = false;
cljs.core._STAR_warn_on_infer_STAR_ = false;
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.PROTOCOL_SENTINEL !== 'undefined')){
} else {
cljs.core.PROTOCOL_SENTINEL = ({});
}
cljs.core.MODULE_URIS = null;
cljs.core.MODULE_INFOS = null;
/**
 * Var bound to the name value of the compiler build :target option.
 *   For example, if the compiler build :target is :nodejs, *target* will be bound
 *   to "nodejs". *target* is a Google Closure define and can be set by compiler
 *   :closure-defines option.
 * @define {string}
 */
cljs.core._STAR_target_STAR_ = goog.define("cljs.core._STAR_target_STAR_","default");
/**
 * Manually set the JavaScript global context. Only "window", "self"
 *   , and "global" supported. 
 * @define {string}
 */
cljs.core._STAR_global_STAR_ = goog.define("cljs.core._STAR_global_STAR_","default");
/**
 * Var bound to the current namespace. Only used for bootstrapping.
 * @type {*}
 */
cljs.core._STAR_ns_STAR_ = null;
/**
 * @type {*}
 */
cljs.core._STAR_out_STAR_ = null;
cljs.core._STAR_assert_STAR_ = true;
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core._STAR_print_fn_STAR_ !== 'undefined')){
} else {
/**
 * Each runtime environment provides a different way to print output.
 *   Whatever function *print-fn* is bound to will be passed any
 *   Strings which should be printed.
 */
cljs.core._STAR_print_fn_STAR_ = null;
}
/**
 * Arranges to have tap functions executed via the supplied f, a
 *   function of no arguments. Returns true if successful, false otherwise.
 */
cljs.core._STAR_exec_tap_fn_STAR_ = (function cljs$core$_STAR_exec_tap_fn_STAR_(f){
var and__5000__auto__ = (typeof setTimeout !== 'undefined');
if(and__5000__auto__){
var G__6046 = setTimeout(f,(0));
return (cljs.core.boolean$.cljs$core$IFn$_invoke$arity$1 ? cljs.core.boolean$.cljs$core$IFn$_invoke$arity$1(G__6046) : cljs.core.boolean$.call(null,G__6046));
} else {
return and__5000__auto__;
}
});
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core._STAR_print_err_fn_STAR_ !== 'undefined')){
} else {
/**
 * Each runtime environment provides a different way to print error output.
 *   Whatever function *print-err-fn* is bound to will be passed any
 *   Strings which should be printed.
 */
cljs.core._STAR_print_err_fn_STAR_ = null;
}
/**
 * Set *print-fn* to f.
 */
cljs.core.set_print_fn_BANG_ = (function cljs$core$set_print_fn_BANG_(f){
return (cljs.core._STAR_print_fn_STAR_ = f);
});
/**
 * Set *print-err-fn* to f.
 */
cljs.core.set_print_err_fn_BANG_ = (function cljs$core$set_print_err_fn_BANG_(f){
return (cljs.core._STAR_print_err_fn_STAR_ = f);
});
/**
 * When set to true, output will be flushed whenever a newline is printed.
 * 
 *   Defaults to true.
 */
cljs.core._STAR_flush_on_newline_STAR_ = true;
/**
 * When set to logical false will drop newlines from printing calls.
 *   This is to work around the implicit newlines emitted by standard JavaScript
 *   console objects.
 */
cljs.core._STAR_print_newline_STAR_ = true;
/**
 * When set to logical false, strings and characters will be printed with
 *   non-alphanumeric characters converted to the appropriate escape sequences.
 * 
 *   Defaults to true
 */
cljs.core._STAR_print_readably_STAR_ = true;
/**
 * If set to logical true, when printing an object, its metadata will also
 *   be printed in a form that can be read back by the reader.
 * 
 *   Defaults to false.
 */
cljs.core._STAR_print_meta_STAR_ = false;
/**
 * When set to logical true, objects will be printed in a way that preserves
 *   their type when read in later.
 * 
 *   Defaults to false.
 */
cljs.core._STAR_print_dup_STAR_ = false;
/**
 * *print-namespace-maps* controls whether the printer will print
 *   namespace map literal syntax.
 * 
 *   Defaults to false, but the REPL binds it to true.
 */
cljs.core._STAR_print_namespace_maps_STAR_ = false;
/**
 * *print-length* controls how many items of each collection the
 *   printer will print. If it is bound to logical false, there is no
 *   limit. Otherwise, it must be bound to an integer indicating the maximum
 *   number of items of each collection to print. If a collection contains
 *   more items, the printer will print items up to the limit followed by
 *   '...' to represent the remaining items. The root binding is nil
 *   indicating no limit.
 * @type {null|number}
 */
cljs.core._STAR_print_length_STAR_ = null;
/**
 * *print-level* controls how many levels deep the printer will
 *   print nested objects. If it is bound to logical false, there is no
 *   limit. Otherwise, it must be bound to an integer indicating the maximum
 *   level to print. Each argument to print is at level 0; if an argument is a
 *   collection, its items are at level 1; and so on. If an object is a
 *   collection and is at a level greater than or equal to the value bound to
 *   *print-level*, the printer prints '#' to represent it. The root binding
 *   is nil indicating no limit.
 * @type {null|number}
 */
cljs.core._STAR_print_level_STAR_ = null;
/**
 * *print-fns-bodies* controls whether functions print their source or
 *  only their names.
 */
cljs.core._STAR_print_fn_bodies_STAR_ = false;
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core._STAR_loaded_libs_STAR_ !== 'undefined')){
} else {
/**
 * @type {*}
 */
cljs.core._STAR_loaded_libs_STAR_ = null;
}
cljs.core.pr_opts = (function cljs$core$pr_opts(){
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"flush-on-newline","flush-on-newline",-151457939),cljs.core._STAR_flush_on_newline_STAR_,new cljs.core.Keyword(null,"readably","readably",1129599760),cljs.core._STAR_print_readably_STAR_,new cljs.core.Keyword(null,"meta","meta",1499536964),cljs.core._STAR_print_meta_STAR_,new cljs.core.Keyword(null,"dup","dup",556298533),cljs.core._STAR_print_dup_STAR_,new cljs.core.Keyword(null,"print-length","print-length",1931866356),cljs.core._STAR_print_length_STAR_], null);
});
/**
 * Set *print-fn* to console.log
 */
cljs.core.enable_console_print_BANG_ = (function cljs$core$enable_console_print_BANG_(){
(cljs.core._STAR_print_newline_STAR_ = false);

cljs.core.set_print_fn_BANG_((function (){
var xs = arguments;
return console.log.apply(console,cljs.core.goog$module$goog$array.clone(xs));
}));

cljs.core.set_print_err_fn_BANG_((function (){
var xs = arguments;
return console.error.apply(console,cljs.core.goog$module$goog$array.clone(xs));
}));

return null;
});
/**
 * Internal - do not use!
 */
cljs.core.truth_ = (function cljs$core$truth_(x){
return (x != null && x !== false);
});
cljs.core.not_native = null;

/**
 * Tests if 2 arguments are the same object
 */
cljs.core.identical_QMARK_ = (function cljs$core$identical_QMARK_(x,y){
return (x === y);
});
/**
 * Returns true if x is nil, false otherwise.
 */
cljs.core.nil_QMARK_ = (function cljs$core$nil_QMARK_(x){
return (x == null);
});
/**
 * Returns true if x is a JavaScript array.
 */
cljs.core.array_QMARK_ = (function cljs$core$array_QMARK_(x){
if((cljs.core._STAR_target_STAR_ === "nodejs")){
return Array.isArray(x);
} else {
return (x instanceof Array);
}
});
/**
 * Returns true if x is a JavaScript number.
 */
cljs.core.number_QMARK_ = (function cljs$core$number_QMARK_(x){
return typeof x === 'number';
});
/**
 * Returns true if x is logical false, false otherwise.
 */
cljs.core.not = (function cljs$core$not(x){
if((x == null)){
return true;
} else {
if(x === false){
return true;
} else {
return false;

}
}
});
/**
 * Returns true if x is not nil, false otherwise.
 */
cljs.core.some_QMARK_ = (function cljs$core$some_QMARK_(x){
return (!((x == null)));
});
/**
 * Returns true if x's constructor is Object
 */
cljs.core.object_QMARK_ = (function cljs$core$object_QMARK_(x){
if((!((x == null)))){
return (x.constructor === Object);
} else {
return false;
}
});
/**
 * Returns true if x is a JavaScript string.
 */
cljs.core.string_QMARK_ = (function cljs$core$string_QMARK_(x){
return ("string" === goog.typeOf(x));
});
/**
 * Returns true if x is a JavaScript string of length one.
 */
cljs.core.char_QMARK_ = (function cljs$core$char_QMARK_(x){
return ((typeof x === 'string') && (((1) === x.length)));
});
/**
 * Returns true if given any argument.
 */
cljs.core.any_QMARK_ = (function cljs$core$any_QMARK_(x){
return true;
});
/**
 * Internal - do not use!
 */
cljs.core.native_satisfies_QMARK_ = (function cljs$core$native_satisfies_QMARK_(p,x){
var x__$1 = (((x == null))?null:x);
if((p[goog.typeOf(x__$1)])){
return true;
} else {
if((p["_"])){
return true;
} else {
return false;

}
}
});
cljs.core.is_proto_ = (function cljs$core$is_proto_(x){
return (x.constructor.prototype === x);
});
/**
 * When compiled for a command-line target, whatever function
 *   *main-cli-fn* is set to will be called with the command-line
 *   argv as arguments
 */
cljs.core._STAR_main_cli_fn_STAR_ = null;
/**
 * A sequence of the supplied command line arguments, or nil if
 *   none were supplied
 */
cljs.core._STAR_command_line_args_STAR_ = null;
/**
 * Return x's constructor.
 */
cljs.core.type = (function cljs$core$type(x){
if((x == null)){
return null;
} else {
return x.constructor;
}
});
cljs.core.missing_protocol = (function cljs$core$missing_protocol(proto,obj){
var ty = cljs.core.type(obj);
var ty__$1 = (cljs.core.truth_((function (){var and__5000__auto__ = ty;
if(cljs.core.truth_(and__5000__auto__)){
return ty.cljs$lang$type;
} else {
return and__5000__auto__;
}
})())?ty.cljs$lang$ctorStr:goog.typeOf(obj));
return (new Error(["No protocol method ",proto," defined for type ",ty__$1,": ",obj].join("")));
});
cljs.core.type__GT_str = (function cljs$core$type__GT_str(ty){
var temp__5802__auto__ = ty.cljs$lang$ctorStr;
if(cljs.core.truth_(temp__5802__auto__)){
var s = temp__5802__auto__;
return s;
} else {
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(ty);
}
});
cljs.core.load_file = (function cljs$core$load_file(file){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
return goog.nodeGlobalRequire(file);
}
});
if((((typeof Symbol !== 'undefined')) && ((goog.typeOf(Symbol) === "function")))){
cljs.core.ITER_SYMBOL = Symbol.iterator;
} else {
cljs.core.ITER_SYMBOL = "@@iterator";
}
/**
 * @enum {string}
 */
cljs.core.CHAR_MAP = ({"]": "_RBRACK_", "'": "_SINGLEQUOTE_", "=": "_EQ_", "\"": "_DOUBLEQUOTE_", "!": "_BANG_", "*": "_STAR_", "%": "_PERCENT_", "|": "_BAR_", "~": "_TILDE_", "/": "_SLASH_", "\\": "_BSLASH_", "-": "_", "?": "_QMARK_", "&": "_AMPERSAND_", ":": "_COLON_", "<": "_LT_", "{": "_LBRACE_", "}": "_RBRACE_", "[": "_LBRACK_", "#": "_SHARP_", "^": "_CARET_", "+": "_PLUS_", "@": "_CIRCA_", ">": "_GT_"});
/**
 * @enum {string}
 */
cljs.core.DEMUNGE_MAP = ({"_RBRACE_": "}", "_COLON_": ":", "_BANG_": "!", "_QMARK_": "?", "_BSLASH_": "\\\\", "_SLASH_": "/", "_PERCENT_": "%", "_PLUS_": "+", "_SHARP_": "#", "_LBRACE_": "{", "_BAR_": "|", "_LBRACK_": "[", "_EQ_": "=", "_": "-", "_TILDE_": "~", "_RBRACK_": "]", "_GT_": ">", "_SINGLEQUOTE_": "'", "_CIRCA_": "@", "_AMPERSAND_": "&", "_DOUBLEQUOTE_": "\\\"", "_CARET_": "^", "_LT_": "<", "_STAR_": "*"});
cljs.core.DEMUNGE_PATTERN = null;
/**
 * Returns highest resolution time offered by host in milliseconds.
 */
cljs.core.system_time = (function cljs$core$system_time(){
if((((typeof performance !== 'undefined')) && ((!((performance.now == null)))))){
return performance.now();
} else {
if((((typeof process !== 'undefined')) && ((!((process.hrtime == null)))))){
var t = process.hrtime();
return ((((t[(0)]) * 1.0E9) + (t[(1)])) / 1000000.0);
} else {
return (new Date()).getTime();

}
}
});
/**
 * Construct a JavaScript array of the specified dimensions. Accepts ignored
 *   type argument for compatibility with Clojure. Note that there is no efficient
 *   way to allocate multi-dimensional arrays in JavaScript; as such, this function
 *   will run in polynomial time when called with 3 or more arguments.
 */
cljs.core.make_array = (function cljs$core$make_array(var_args){
var G__6051 = arguments.length;
switch (G__6051) {
case 1:
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___7647 = arguments.length;
var i__5727__auto___7649 = (0);
while(true){
if((i__5727__auto___7649 < len__5726__auto___7647)){
args_arr__5751__auto__.push((arguments[i__5727__auto___7649]));

var G__7650 = (i__5727__auto___7649 + (1));
i__5727__auto___7649 = G__7650;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.make_array.cljs$core$IFn$_invoke$arity$1 = (function (size){
return (new Array(size));
}));

(cljs.core.make_array.cljs$core$IFn$_invoke$arity$2 = (function (type,size){
return (new Array(size));
}));

(cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic = (function (type,size,more_sizes){
var dims = more_sizes;
var dimarray = (new Array(size));
var n__5593__auto___7651 = dimarray.length;
var i_7652 = (0);
while(true){
if((i_7652 < n__5593__auto___7651)){
(dimarray[i_7652] = (cljs.core.apply.cljs$core$IFn$_invoke$arity$3 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.make_array,null,dims) : cljs.core.apply.call(null,cljs.core.make_array,null,dims)));

var G__7653 = (i_7652 + (1));
i_7652 = G__7653;
continue;
} else {
}
break;
}

return dimarray;
}));

/** @this {Function} */
(cljs.core.make_array.cljs$lang$applyTo = (function (seq6048){
var G__6049 = (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq6048) : cljs.core.first.call(null,seq6048));
var seq6048__$1 = (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq6048) : cljs.core.next.call(null,seq6048));
var G__6050 = (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq6048__$1) : cljs.core.first.call(null,seq6048__$1));
var seq6048__$2 = (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq6048__$1) : cljs.core.next.call(null,seq6048__$1));
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6049,G__6050,seq6048__$2);
}));

(cljs.core.make_array.cljs$lang$maxFixedArity = (2));

/**
 * Returns a javascript array, cloned from the passed in array
 */
cljs.core.aclone = (function cljs$core$aclone(arr){
var len = arr.length;
var new_arr = (new Array(len));
var n__5593__auto___7662 = len;
var i_7663 = (0);
while(true){
if((i_7663 < n__5593__auto___7662)){
(new_arr[i_7663] = (arr[i_7663]));

var G__7664 = (i_7663 + (1));
i_7663 = G__7664;
continue;
} else {
}
break;
}

return new_arr;
});
/**
 * Creates a new javascript array.
 * @param {...*} var_args
 */
cljs.core.array = (function cljs$core$array(var_args){
var a = (new Array(arguments.length));
var i = (0);
while(true){
if((i < a.length)){
(a[i] = (arguments[i]));

var G__7665 = (i + (1));
i = G__7665;
continue;
} else {
return a;
}
break;
}
});
cljs.core.maybe_warn = (function cljs$core$maybe_warn(e){
if(cljs.core.truth_(cljs.core._STAR_print_err_fn_STAR_)){
return cljs.core._STAR_print_err_fn_STAR_.call(null,e);
} else {
return null;
}
});
cljs.core.checked_aget = (function cljs$core$checked_aget(var_args){
var G__6056 = arguments.length;
switch (G__6056) {
case 2:
return cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___7671 = arguments.length;
var i__5727__auto___7679 = (0);
while(true){
if((i__5727__auto___7679 < len__5726__auto___7671)){
args_arr__5751__auto__.push((arguments[i__5727__auto___7679]));

var G__7680 = (i__5727__auto___7679 + (1));
i__5727__auto___7679 = G__7680;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2 = (function (array,idx){
try{if(cljs.core.truth_((function (){var or__5002__auto__ = cljs.core.array_QMARK_(array);
if(or__5002__auto__){
return or__5002__auto__;
} else {
return goog.isArrayLike(array);
}
})())){
} else {
throw (new Error("Assert failed: (or (array? array) (goog/isArrayLike array))"));
}

if(typeof idx === 'number'){
} else {
throw (new Error("Assert failed: (number? idx)"));
}

if((!((idx < (0))))){
} else {
throw (new Error("Assert failed: (not (neg? idx))"));
}

if((idx < array.length)){
} else {
throw (new Error("Assert failed: (< idx (alength array))"));
}
}catch (e6057){var e_7681 = e6057;
cljs.core.maybe_warn(e_7681);
}
return (array[idx]);
}));

(cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$variadic = (function (array,idx,idxs){
var G__6058 = cljs.core.checked_aget;
var G__6059 = cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2(array,idx);
var G__6060 = idxs;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$3 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$3(G__6058,G__6059,G__6060) : cljs.core.apply.call(null,G__6058,G__6059,G__6060));
}));

/** @this {Function} */
(cljs.core.checked_aget.cljs$lang$applyTo = (function (seq6053){
var G__6054 = (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq6053) : cljs.core.first.call(null,seq6053));
var seq6053__$1 = (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq6053) : cljs.core.next.call(null,seq6053));
var G__6055 = (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq6053__$1) : cljs.core.first.call(null,seq6053__$1));
var seq6053__$2 = (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq6053__$1) : cljs.core.next.call(null,seq6053__$1));
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6054,G__6055,seq6053__$2);
}));

(cljs.core.checked_aget.cljs$lang$maxFixedArity = (2));

cljs.core.checked_aset = (function cljs$core$checked_aset(var_args){
var G__6066 = arguments.length;
switch (G__6066) {
case 3:
return cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___7683 = arguments.length;
var i__5727__auto___7684 = (0);
while(true){
if((i__5727__auto___7684 < len__5726__auto___7683)){
args_arr__5751__auto__.push((arguments[i__5727__auto___7684]));

var G__7685 = (i__5727__auto___7684 + (1));
i__5727__auto___7684 = G__7685;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((3) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((3)),(0),null)):null);
return cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5752__auto__);

}
});

(cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$3 = (function (array,idx,val){
try{if(cljs.core.truth_((function (){var or__5002__auto__ = cljs.core.array_QMARK_(array);
if(or__5002__auto__){
return or__5002__auto__;
} else {
return goog.isArrayLike(array);
}
})())){
} else {
throw (new Error("Assert failed: (or (array? array) (goog/isArrayLike array))"));
}

if(typeof idx === 'number'){
} else {
throw (new Error("Assert failed: (number? idx)"));
}

if((!((idx < (0))))){
} else {
throw (new Error("Assert failed: (not (neg? idx))"));
}

if((idx < array.length)){
} else {
throw (new Error("Assert failed: (< idx (alength array))"));
}
}catch (e6067){var e_7690 = e6067;
cljs.core.maybe_warn(e_7690);
}
return (array[idx] = val);
}));

(cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$variadic = (function (array,idx,idx2,idxv){
var G__6068 = cljs.core.checked_aset;
var G__6069 = cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2(array,idx);
var G__6070 = idx2;
var G__6071 = idxv;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$4 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$4(G__6068,G__6069,G__6070,G__6071) : cljs.core.apply.call(null,G__6068,G__6069,G__6070,G__6071));
}));

/** @this {Function} */
(cljs.core.checked_aset.cljs$lang$applyTo = (function (seq6062){
var G__6063 = (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq6062) : cljs.core.first.call(null,seq6062));
var seq6062__$1 = (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq6062) : cljs.core.next.call(null,seq6062));
var G__6064 = (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq6062__$1) : cljs.core.first.call(null,seq6062__$1));
var seq6062__$2 = (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq6062__$1) : cljs.core.next.call(null,seq6062__$1));
var G__6065 = (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq6062__$2) : cljs.core.first.call(null,seq6062__$2));
var seq6062__$3 = (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq6062__$2) : cljs.core.next.call(null,seq6062__$2));
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6063,G__6064,G__6065,seq6062__$3);
}));

(cljs.core.checked_aset.cljs$lang$maxFixedArity = (3));

cljs.core.checked_aget_SINGLEQUOTE_ = (function cljs$core$checked_aget_SINGLEQUOTE_(var_args){
var G__6076 = arguments.length;
switch (G__6076) {
case 2:
return cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___7723 = arguments.length;
var i__5727__auto___7724 = (0);
while(true){
if((i__5727__auto___7724 < len__5726__auto___7723)){
args_arr__5751__auto__.push((arguments[i__5727__auto___7724]));

var G__7725 = (i__5727__auto___7724 + (1));
i__5727__auto___7724 = G__7725;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2 = (function (array,idx){
if(cljs.core.truth_((function (){var or__5002__auto__ = cljs.core.array_QMARK_(array);
if(or__5002__auto__){
return or__5002__auto__;
} else {
return goog.isArrayLike(array);
}
})())){
} else {
throw (new Error("Assert failed: (or (array? array) (goog/isArrayLike array))"));
}

if(typeof idx === 'number'){
} else {
throw (new Error("Assert failed: (number? idx)"));
}

if((!((idx < (0))))){
} else {
throw (new Error("Assert failed: (not (neg? idx))"));
}

if((idx < array.length)){
} else {
throw (new Error("Assert failed: (< idx (alength array))"));
}

return (array[idx]);
}));

(cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic = (function (array,idx,idxs){
var G__6077 = cljs.core.checked_aget_SINGLEQUOTE_;
var G__6078 = cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2(array,idx);
var G__6079 = idxs;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$3 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$3(G__6077,G__6078,G__6079) : cljs.core.apply.call(null,G__6077,G__6078,G__6079));
}));

/** @this {Function} */
(cljs.core.checked_aget_SINGLEQUOTE_.cljs$lang$applyTo = (function (seq6073){
var G__6074 = (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq6073) : cljs.core.first.call(null,seq6073));
var seq6073__$1 = (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq6073) : cljs.core.next.call(null,seq6073));
var G__6075 = (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq6073__$1) : cljs.core.first.call(null,seq6073__$1));
var seq6073__$2 = (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq6073__$1) : cljs.core.next.call(null,seq6073__$1));
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6074,G__6075,seq6073__$2);
}));

(cljs.core.checked_aget_SINGLEQUOTE_.cljs$lang$maxFixedArity = (2));

cljs.core.checked_aset_SINGLEQUOTE_ = (function cljs$core$checked_aset_SINGLEQUOTE_(var_args){
var G__6085 = arguments.length;
switch (G__6085) {
case 3:
return cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___7731 = arguments.length;
var i__5727__auto___7732 = (0);
while(true){
if((i__5727__auto___7732 < len__5726__auto___7731)){
args_arr__5751__auto__.push((arguments[i__5727__auto___7732]));

var G__7733 = (i__5727__auto___7732 + (1));
i__5727__auto___7732 = G__7733;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((3) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((3)),(0),null)):null);
return cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5752__auto__);

}
});

(cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$3 = (function (array,idx,val){
if(cljs.core.truth_((function (){var or__5002__auto__ = cljs.core.array_QMARK_(array);
if(or__5002__auto__){
return or__5002__auto__;
} else {
return goog.isArrayLike(array);
}
})())){
} else {
throw (new Error("Assert failed: (or (array? array) (goog/isArrayLike array))"));
}

if(typeof idx === 'number'){
} else {
throw (new Error("Assert failed: (number? idx)"));
}

if((!((idx < (0))))){
} else {
throw (new Error("Assert failed: (not (neg? idx))"));
}

if((idx < array.length)){
} else {
throw (new Error("Assert failed: (< idx (alength array))"));
}

return (array[idx] = val);
}));

(cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic = (function (array,idx,idx2,idxv){
var G__6086 = cljs.core.checked_aset_SINGLEQUOTE_;
var G__6087 = cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2(array,idx);
var G__6088 = idx2;
var G__6089 = idxv;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$4 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$4(G__6086,G__6087,G__6088,G__6089) : cljs.core.apply.call(null,G__6086,G__6087,G__6088,G__6089));
}));

/** @this {Function} */
(cljs.core.checked_aset_SINGLEQUOTE_.cljs$lang$applyTo = (function (seq6081){
var G__6082 = (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq6081) : cljs.core.first.call(null,seq6081));
var seq6081__$1 = (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq6081) : cljs.core.next.call(null,seq6081));
var G__6083 = (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq6081__$1) : cljs.core.first.call(null,seq6081__$1));
var seq6081__$2 = (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq6081__$1) : cljs.core.next.call(null,seq6081__$1));
var G__6084 = (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq6081__$2) : cljs.core.first.call(null,seq6081__$2));
var seq6081__$3 = (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq6081__$2) : cljs.core.next.call(null,seq6081__$2));
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6082,G__6083,G__6084,seq6081__$3);
}));

(cljs.core.checked_aset_SINGLEQUOTE_.cljs$lang$maxFixedArity = (3));

/**
 * Returns the value at the index/indices. Works on JavaScript arrays.
 */
cljs.core.aget = (function cljs$core$aget(var_args){
var G__6094 = arguments.length;
switch (G__6094) {
case 2:
return cljs.core.aget.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___7736 = arguments.length;
var i__5727__auto___7737 = (0);
while(true){
if((i__5727__auto___7737 < len__5726__auto___7736)){
args_arr__5751__auto__.push((arguments[i__5727__auto___7737]));

var G__7738 = (i__5727__auto___7737 + (1));
i__5727__auto___7737 = G__7738;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.aget.cljs$core$IFn$_invoke$arity$2 = (function (array,idx){
return (array[idx]);
}));

(cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic = (function (array,idx,idxs){
var G__6095 = cljs.core.aget;
var G__6096 = (array[idx]);
var G__6097 = idxs;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$3 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$3(G__6095,G__6096,G__6097) : cljs.core.apply.call(null,G__6095,G__6096,G__6097));
}));

/** @this {Function} */
(cljs.core.aget.cljs$lang$applyTo = (function (seq6091){
var G__6092 = (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq6091) : cljs.core.first.call(null,seq6091));
var seq6091__$1 = (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq6091) : cljs.core.next.call(null,seq6091));
var G__6093 = (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq6091__$1) : cljs.core.first.call(null,seq6091__$1));
var seq6091__$2 = (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq6091__$1) : cljs.core.next.call(null,seq6091__$1));
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6092,G__6093,seq6091__$2);
}));

(cljs.core.aget.cljs$lang$maxFixedArity = (2));

/**
 * Sets the value at the index/indices. Works on JavaScript arrays.
 *   Returns val.
 */
cljs.core.aset = (function cljs$core$aset(var_args){
var G__6103 = arguments.length;
switch (G__6103) {
case 3:
return cljs.core.aset.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___7740 = arguments.length;
var i__5727__auto___7741 = (0);
while(true){
if((i__5727__auto___7741 < len__5726__auto___7740)){
args_arr__5751__auto__.push((arguments[i__5727__auto___7741]));

var G__7742 = (i__5727__auto___7741 + (1));
i__5727__auto___7741 = G__7742;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((3) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((3)),(0),null)):null);
return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5752__auto__);

}
});

(cljs.core.aset.cljs$core$IFn$_invoke$arity$3 = (function (array,idx,val){
return (array[idx] = val);
}));

(cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic = (function (array,idx,idx2,idxv){
var G__6104 = cljs.core.aset;
var G__6105 = (array[idx]);
var G__6106 = idx2;
var G__6107 = idxv;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$4 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$4(G__6104,G__6105,G__6106,G__6107) : cljs.core.apply.call(null,G__6104,G__6105,G__6106,G__6107));
}));

/** @this {Function} */
(cljs.core.aset.cljs$lang$applyTo = (function (seq6099){
var G__6100 = (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq6099) : cljs.core.first.call(null,seq6099));
var seq6099__$1 = (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq6099) : cljs.core.next.call(null,seq6099));
var G__6101 = (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq6099__$1) : cljs.core.first.call(null,seq6099__$1));
var seq6099__$2 = (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq6099__$1) : cljs.core.next.call(null,seq6099__$1));
var G__6102 = (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq6099__$2) : cljs.core.first.call(null,seq6099__$2));
var seq6099__$3 = (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq6099__$2) : cljs.core.next.call(null,seq6099__$2));
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6100,G__6101,G__6102,seq6099__$3);
}));

(cljs.core.aset.cljs$lang$maxFixedArity = (3));

/**
 * Returns the length of the array. Works on arrays of all types.
 */
cljs.core.alength = (function cljs$core$alength(array){
return array.length;
});
/**
 * Returns an array with components set to the values in aseq. Optional type
 *   argument accepted for compatibility with Clojure.
 */
cljs.core.into_array = (function cljs$core$into_array(var_args){
var G__6109 = arguments.length;
switch (G__6109) {
case 1:
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 = (function (aseq){
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2(null,aseq);
}));

(cljs.core.into_array.cljs$core$IFn$_invoke$arity$2 = (function (type,aseq){
var G__6110 = (function (a,x){
a.push(x);

return a;
});
var G__6111 = [];
var G__6112 = aseq;
return (cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__6110,G__6111,G__6112) : cljs.core.reduce.call(null,G__6110,G__6111,G__6112));
}));

(cljs.core.into_array.cljs$lang$maxFixedArity = 2);

/**
 * Invoke JavaScript object method via string. Needed when the
 *   string is not a valid unquoted property name.
 */
cljs.core.js_invoke = (function cljs$core$js_invoke(var_args){
var args__5732__auto__ = [];
var len__5726__auto___7745 = arguments.length;
var i__5727__auto___7747 = (0);
while(true){
if((i__5727__auto___7747 < len__5726__auto___7745)){
args__5732__auto__.push((arguments[i__5727__auto___7747]));

var G__7748 = (i__5727__auto___7747 + (1));
i__5727__auto___7747 = G__7748;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((2) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((2)),(0),null)):null);
return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5733__auto__);
});

(cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic = (function (obj,s,args){
return (obj[s]).apply(obj,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args));
}));

(cljs.core.js_invoke.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(cljs.core.js_invoke.cljs$lang$applyTo = (function (seq6113){
var G__6114 = (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq6113) : cljs.core.first.call(null,seq6113));
var seq6113__$1 = (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq6113) : cljs.core.next.call(null,seq6113));
var G__6115 = (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq6113__$1) : cljs.core.first.call(null,seq6113__$1));
var seq6113__$2 = (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq6113__$1) : cljs.core.next.call(null,seq6113__$1));
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6114,G__6115,seq6113__$2);
}));

/**
 * Returns true if x is an instance of Symbol
 */
cljs.core.js_symbol_QMARK_ = (function cljs$core$js_symbol_QMARK_(x){
return (((goog.typeOf(x) === "symbol")) || ((((typeof Symbol !== 'undefined')) && ((x instanceof Symbol)))));
});

/**
 * Marker protocol
 * @interface
 */
cljs.core.Fn = function(){};


/**
 * Protocol for adding the ability to invoke an object as a function.
 *   For example, a vector can also be used to look up a value:
 *   ([1 2 3 4] 1) => 2
 * @interface
 */
cljs.core.IFn = function(){};

var cljs$core$IFn$_invoke$dyn_7750 = (function() {
var G__7751 = null;
var G__7751__1 = (function (this$){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._invoke[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5351__auto__.call(null,this$));
} else {
var m__5349__auto__ = (cljs.core._invoke["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5349__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__7751__2 = (function (this$,a){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._invoke[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(this$,a) : m__5351__auto__.call(null,this$,a));
} else {
var m__5349__auto__ = (cljs.core._invoke["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(this$,a) : m__5349__auto__.call(null,this$,a));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__7751__3 = (function (this$,a,b){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._invoke[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(this$,a,b) : m__5351__auto__.call(null,this$,a,b));
} else {
var m__5349__auto__ = (cljs.core._invoke["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(this$,a,b) : m__5349__auto__.call(null,this$,a,b));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__7751__4 = (function (this$,a,b,c){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._invoke[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$4(this$,a,b,c) : m__5351__auto__.call(null,this$,a,b,c));
} else {
var m__5349__auto__ = (cljs.core._invoke["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$4(this$,a,b,c) : m__5349__auto__.call(null,this$,a,b,c));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__7751__5 = (function (this$,a,b,c,d){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._invoke[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$5 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d) : m__5351__auto__.call(null,this$,a,b,c,d));
} else {
var m__5349__auto__ = (cljs.core._invoke["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$5 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d) : m__5349__auto__.call(null,this$,a,b,c,d));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__7751__6 = (function (this$,a,b,c,d,e){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._invoke[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$6 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e) : m__5351__auto__.call(null,this$,a,b,c,d,e));
} else {
var m__5349__auto__ = (cljs.core._invoke["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$6 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e) : m__5349__auto__.call(null,this$,a,b,c,d,e));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__7751__7 = (function (this$,a,b,c,d,e,f){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._invoke[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$7 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f) : m__5351__auto__.call(null,this$,a,b,c,d,e,f));
} else {
var m__5349__auto__ = (cljs.core._invoke["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$7 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f) : m__5349__auto__.call(null,this$,a,b,c,d,e,f));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__7751__8 = (function (this$,a,b,c,d,e,f,g){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._invoke[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$8 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g) : m__5351__auto__.call(null,this$,a,b,c,d,e,f,g));
} else {
var m__5349__auto__ = (cljs.core._invoke["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$8 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g) : m__5349__auto__.call(null,this$,a,b,c,d,e,f,g));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__7751__9 = (function (this$,a,b,c,d,e,f,g,h){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._invoke[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$9 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h) : m__5351__auto__.call(null,this$,a,b,c,d,e,f,g,h));
} else {
var m__5349__auto__ = (cljs.core._invoke["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$9 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h) : m__5349__auto__.call(null,this$,a,b,c,d,e,f,g,h));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__7751__10 = (function (this$,a,b,c,d,e,f,g,h,i){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._invoke[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$10 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i) : m__5351__auto__.call(null,this$,a,b,c,d,e,f,g,h,i));
} else {
var m__5349__auto__ = (cljs.core._invoke["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$10 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i) : m__5349__auto__.call(null,this$,a,b,c,d,e,f,g,h,i));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__7751__11 = (function (this$,a,b,c,d,e,f,g,h,i,j){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._invoke[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$11 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j) : m__5351__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j));
} else {
var m__5349__auto__ = (cljs.core._invoke["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$11 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j) : m__5349__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__7751__12 = (function (this$,a,b,c,d,e,f,g,h,i,j,k){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._invoke[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$12 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k) : m__5351__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k));
} else {
var m__5349__auto__ = (cljs.core._invoke["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$12 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k) : m__5349__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__7751__13 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._invoke[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$13 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l) : m__5351__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l));
} else {
var m__5349__auto__ = (cljs.core._invoke["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$13 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l) : m__5349__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__7751__14 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._invoke[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$14 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m) : m__5351__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m));
} else {
var m__5349__auto__ = (cljs.core._invoke["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$14 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m) : m__5349__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__7751__15 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._invoke[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$15 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n) : m__5351__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
} else {
var m__5349__auto__ = (cljs.core._invoke["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$15 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n) : m__5349__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__7751__16 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._invoke[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$16 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : m__5351__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
} else {
var m__5349__auto__ = (cljs.core._invoke["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$16 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : m__5349__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__7751__17 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._invoke[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$17 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : m__5351__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
} else {
var m__5349__auto__ = (cljs.core._invoke["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$17 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : m__5349__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__7751__18 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._invoke[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$18 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : m__5351__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
} else {
var m__5349__auto__ = (cljs.core._invoke["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$18 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : m__5349__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__7751__19 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._invoke[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$19 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : m__5351__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
} else {
var m__5349__auto__ = (cljs.core._invoke["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$19 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : m__5349__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__7751__20 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._invoke[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$20 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : m__5351__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
} else {
var m__5349__auto__ = (cljs.core._invoke["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$20 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : m__5349__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__7751__21 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._invoke[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$21 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s, new cljs.core.IndexedSeq([t],0,null)) : m__5351__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
} else {
var m__5349__auto__ = (cljs.core._invoke["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$21 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s, new cljs.core.IndexedSeq([t],0,null)) : m__5349__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__7751__22 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._invoke[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$21 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s, new cljs.core.IndexedSeq([t,rest],0,null)) : m__5351__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));
} else {
var m__5349__auto__ = (cljs.core._invoke["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$21 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s, new cljs.core.IndexedSeq([t,rest],0,null)) : m__5349__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
G__7751 = function(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return G__7751__1.call(this,this$);
case 2:
return G__7751__2.call(this,this$,a);
case 3:
return G__7751__3.call(this,this$,a,b);
case 4:
return G__7751__4.call(this,this$,a,b,c);
case 5:
return G__7751__5.call(this,this$,a,b,c,d);
case 6:
return G__7751__6.call(this,this$,a,b,c,d,e);
case 7:
return G__7751__7.call(this,this$,a,b,c,d,e,f);
case 8:
return G__7751__8.call(this,this$,a,b,c,d,e,f,g);
case 9:
return G__7751__9.call(this,this$,a,b,c,d,e,f,g,h);
case 10:
return G__7751__10.call(this,this$,a,b,c,d,e,f,g,h,i);
case 11:
return G__7751__11.call(this,this$,a,b,c,d,e,f,g,h,i,j);
case 12:
return G__7751__12.call(this,this$,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return G__7751__13.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return G__7751__14.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return G__7751__15.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return G__7751__16.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return G__7751__17.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return G__7751__18.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return G__7751__19.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return G__7751__20.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return G__7751__21.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return G__7751__22.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7751.cljs$core$IFn$_invoke$arity$1 = G__7751__1;
G__7751.cljs$core$IFn$_invoke$arity$2 = G__7751__2;
G__7751.cljs$core$IFn$_invoke$arity$3 = G__7751__3;
G__7751.cljs$core$IFn$_invoke$arity$4 = G__7751__4;
G__7751.cljs$core$IFn$_invoke$arity$5 = G__7751__5;
G__7751.cljs$core$IFn$_invoke$arity$6 = G__7751__6;
G__7751.cljs$core$IFn$_invoke$arity$7 = G__7751__7;
G__7751.cljs$core$IFn$_invoke$arity$8 = G__7751__8;
G__7751.cljs$core$IFn$_invoke$arity$9 = G__7751__9;
G__7751.cljs$core$IFn$_invoke$arity$10 = G__7751__10;
G__7751.cljs$core$IFn$_invoke$arity$11 = G__7751__11;
G__7751.cljs$core$IFn$_invoke$arity$12 = G__7751__12;
G__7751.cljs$core$IFn$_invoke$arity$13 = G__7751__13;
G__7751.cljs$core$IFn$_invoke$arity$14 = G__7751__14;
G__7751.cljs$core$IFn$_invoke$arity$15 = G__7751__15;
G__7751.cljs$core$IFn$_invoke$arity$16 = G__7751__16;
G__7751.cljs$core$IFn$_invoke$arity$17 = G__7751__17;
G__7751.cljs$core$IFn$_invoke$arity$18 = G__7751__18;
G__7751.cljs$core$IFn$_invoke$arity$19 = G__7751__19;
G__7751.cljs$core$IFn$_invoke$arity$20 = G__7751__20;
G__7751.cljs$core$IFn$_invoke$arity$21 = G__7751__21;
G__7751.cljs$core$IFn$_invoke$arity$22 = G__7751__22;
return G__7751;
})()
;
cljs.core._invoke = (function cljs$core$_invoke(var_args){
var G__6117 = arguments.length;
switch (G__6117) {
case 1:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
case 9:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
case 11:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$11((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]));

break;
case 12:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$12((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]));

break;
case 13:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$13((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]));

break;
case 14:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$14((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]));

break;
case 15:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$15((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]));

break;
case 16:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$16((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]));

break;
case 17:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$17((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]));

break;
case 18:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$18((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]));

break;
case 19:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$19((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]));

break;
case 20:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$20((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]));

break;
case 21:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$21((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]));

break;
case 22:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$22((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]),(arguments[(21)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$1 = (function (this$){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$1 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$1(this$);
} else {
return cljs$core$IFn$_invoke$dyn_7750(this$);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$2 = (function (this$,a){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$2 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$2(this$,a);
} else {
return cljs$core$IFn$_invoke$dyn_7750(this$,a);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$3 = (function (this$,a,b){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$3 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$3(this$,a,b);
} else {
return cljs$core$IFn$_invoke$dyn_7750(this$,a,b);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$4 = (function (this$,a,b,c){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$4 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$4(this$,a,b,c);
} else {
return cljs$core$IFn$_invoke$dyn_7750(this$,a,b,c);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$5 = (function (this$,a,b,c,d){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$5 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d);
} else {
return cljs$core$IFn$_invoke$dyn_7750(this$,a,b,c,d);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$6 = (function (this$,a,b,c,d,e){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$6 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e);
} else {
return cljs$core$IFn$_invoke$dyn_7750(this$,a,b,c,d,e);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$7 = (function (this$,a,b,c,d,e,f){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$7 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f);
} else {
return cljs$core$IFn$_invoke$dyn_7750(this$,a,b,c,d,e,f);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$8 = (function (this$,a,b,c,d,e,f,g){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$8 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g);
} else {
return cljs$core$IFn$_invoke$dyn_7750(this$,a,b,c,d,e,f,g);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$9 = (function (this$,a,b,c,d,e,f,g,h){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$9 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h);
} else {
return cljs$core$IFn$_invoke$dyn_7750(this$,a,b,c,d,e,f,g,h);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$10 = (function (this$,a,b,c,d,e,f,g,h,i){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$10 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i);
} else {
return cljs$core$IFn$_invoke$dyn_7750(this$,a,b,c,d,e,f,g,h,i);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$11 = (function (this$,a,b,c,d,e,f,g,h,i,j){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$11 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j);
} else {
return cljs$core$IFn$_invoke$dyn_7750(this$,a,b,c,d,e,f,g,h,i,j);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$12 = (function (this$,a,b,c,d,e,f,g,h,i,j,k){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$12 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k);
} else {
return cljs$core$IFn$_invoke$dyn_7750(this$,a,b,c,d,e,f,g,h,i,j,k);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$13 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$13 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l);
} else {
return cljs$core$IFn$_invoke$dyn_7750(this$,a,b,c,d,e,f,g,h,i,j,k,l);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$14 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$14 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
} else {
return cljs$core$IFn$_invoke$dyn_7750(this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$15 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$15 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
} else {
return cljs$core$IFn$_invoke$dyn_7750(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$16 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$16 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
} else {
return cljs$core$IFn$_invoke$dyn_7750(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$17 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$17 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
} else {
return cljs$core$IFn$_invoke$dyn_7750(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$18 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$18 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
} else {
return cljs$core$IFn$_invoke$dyn_7750(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$19 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$19 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
} else {
return cljs$core$IFn$_invoke$dyn_7750(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$20 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$20 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
} else {
return cljs$core$IFn$_invoke$dyn_7750(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$21 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$21 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
} else {
return cljs$core$IFn$_invoke$dyn_7750(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$22 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$22 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
} else {
return cljs$core$IFn$_invoke$dyn_7750(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
}));

(cljs.core._invoke.cljs$lang$maxFixedArity = 22);



/**
 * Protocol for cloning a value.
 * @interface
 */
cljs.core.ICloneable = function(){};

var cljs$core$ICloneable$_clone$dyn_7886 = (function (value){
var x__5350__auto__ = (((value == null))?null:value);
var m__5351__auto__ = (cljs.core._clone[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(value) : m__5351__auto__.call(null,value));
} else {
var m__5349__auto__ = (cljs.core._clone["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(value) : m__5349__auto__.call(null,value));
} else {
throw cljs.core.missing_protocol("ICloneable.-clone",value);
}
}
});
/**
 * Creates a clone of value.
 */
cljs.core._clone = (function cljs$core$_clone(value){
if((((!((value == null)))) && ((!((value.cljs$core$ICloneable$_clone$arity$1 == null)))))){
return value.cljs$core$ICloneable$_clone$arity$1(value);
} else {
return cljs$core$ICloneable$_clone$dyn_7886(value);
}
});


/**
 * Protocol for adding the ability to count a collection in constant time.
 * @interface
 */
cljs.core.ICounted = function(){};

var cljs$core$ICounted$_count$dyn_7894 = (function (coll){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._count[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5351__auto__.call(null,coll));
} else {
var m__5349__auto__ = (cljs.core._count["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5349__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("ICounted.-count",coll);
}
}
});
/**
 * Calculates the count of coll in constant time. Used by cljs.core/count.
 */
cljs.core._count = (function cljs$core$_count(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$ICounted$_count$arity$1 == null)))))){
return coll.cljs$core$ICounted$_count$arity$1(coll);
} else {
return cljs$core$ICounted$_count$dyn_7894(coll);
}
});


/**
 * Protocol for creating an empty collection.
 * @interface
 */
cljs.core.IEmptyableCollection = function(){};

var cljs$core$IEmptyableCollection$_empty$dyn_7896 = (function (coll){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._empty[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5351__auto__.call(null,coll));
} else {
var m__5349__auto__ = (cljs.core._empty["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5349__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IEmptyableCollection.-empty",coll);
}
}
});
/**
 * Returns an empty collection of the same category as coll. Used
 *   by cljs.core/empty.
 */
cljs.core._empty = (function cljs$core$_empty(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IEmptyableCollection$_empty$arity$1 == null)))))){
return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll);
} else {
return cljs$core$IEmptyableCollection$_empty$dyn_7896(coll);
}
});


/**
 * Protocol for adding to a collection.
 * @interface
 */
cljs.core.ICollection = function(){};

var cljs$core$ICollection$_conj$dyn_7897 = (function (coll,o){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._conj[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(coll,o) : m__5351__auto__.call(null,coll,o));
} else {
var m__5349__auto__ = (cljs.core._conj["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(coll,o) : m__5349__auto__.call(null,coll,o));
} else {
throw cljs.core.missing_protocol("ICollection.-conj",coll);
}
}
});
/**
 * Returns a new collection of coll with o added to it. The new item
 *   should be added to the most efficient place, e.g.
 *   (conj [1 2 3 4] 5) => [1 2 3 4 5]
 *   (conj '(2 3 4 5) 1) => '(1 2 3 4 5)
 */
cljs.core._conj = (function cljs$core$_conj(coll,o){
if((((!((coll == null)))) && ((!((coll.cljs$core$ICollection$_conj$arity$2 == null)))))){
return coll.cljs$core$ICollection$_conj$arity$2(coll,o);
} else {
return cljs$core$ICollection$_conj$dyn_7897(coll,o);
}
});


/**
 * Protocol for collections to provide indexed-based access to their items.
 * @interface
 */
cljs.core.IIndexed = function(){};

var cljs$core$IIndexed$_nth$dyn_7902 = (function() {
var G__7903 = null;
var G__7903__2 = (function (coll,n){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._nth[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(coll,n) : m__5351__auto__.call(null,coll,n));
} else {
var m__5349__auto__ = (cljs.core._nth["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(coll,n) : m__5349__auto__.call(null,coll,n));
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
});
var G__7903__3 = (function (coll,n,not_found){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._nth[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,not_found) : m__5351__auto__.call(null,coll,n,not_found));
} else {
var m__5349__auto__ = (cljs.core._nth["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,not_found) : m__5349__auto__.call(null,coll,n,not_found));
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
});
G__7903 = function(coll,n,not_found){
switch(arguments.length){
case 2:
return G__7903__2.call(this,coll,n);
case 3:
return G__7903__3.call(this,coll,n,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7903.cljs$core$IFn$_invoke$arity$2 = G__7903__2;
G__7903.cljs$core$IFn$_invoke$arity$3 = G__7903__3;
return G__7903;
})()
;
/**
 * Returns the value at the index n in the collection coll.
 *   Returns not-found if index n is out of bounds and not-found is supplied.
 */
cljs.core._nth = (function cljs$core$_nth(var_args){
var G__6119 = arguments.length;
switch (G__6119) {
case 2:
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._nth.cljs$core$IFn$_invoke$arity$2 = (function (coll,n){
if((((!((coll == null)))) && ((!((coll.cljs$core$IIndexed$_nth$arity$2 == null)))))){
return coll.cljs$core$IIndexed$_nth$arity$2(coll,n);
} else {
return cljs$core$IIndexed$_nth$dyn_7902(coll,n);
}
}));

(cljs.core._nth.cljs$core$IFn$_invoke$arity$3 = (function (coll,n,not_found){
if((((!((coll == null)))) && ((!((coll.cljs$core$IIndexed$_nth$arity$3 == null)))))){
return coll.cljs$core$IIndexed$_nth$arity$3(coll,n,not_found);
} else {
return cljs$core$IIndexed$_nth$dyn_7902(coll,n,not_found);
}
}));

(cljs.core._nth.cljs$lang$maxFixedArity = 3);



/**
 * Marker protocol indicating an array sequence.
 * @interface
 */
cljs.core.ASeq = function(){};


/**
 * Protocol for collections to provide access to their items as sequences.
 * @interface
 */
cljs.core.ISeq = function(){};

var cljs$core$ISeq$_first$dyn_7907 = (function (coll){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._first[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5351__auto__.call(null,coll));
} else {
var m__5349__auto__ = (cljs.core._first["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5349__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("ISeq.-first",coll);
}
}
});
/**
 * Returns the first item in the collection coll. Used by cljs.core/first.
 */
cljs.core._first = (function cljs$core$_first(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISeq$_first$arity$1 == null)))))){
return coll.cljs$core$ISeq$_first$arity$1(coll);
} else {
return cljs$core$ISeq$_first$dyn_7907(coll);
}
});

var cljs$core$ISeq$_rest$dyn_7912 = (function (coll){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._rest[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5351__auto__.call(null,coll));
} else {
var m__5349__auto__ = (cljs.core._rest["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5349__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("ISeq.-rest",coll);
}
}
});
/**
 * Returns a new collection of coll without the first item. It should
 *   always return a seq, e.g.
 *   (rest []) => ()
 *   (rest nil) => ()
 */
cljs.core._rest = (function cljs$core$_rest(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISeq$_rest$arity$1 == null)))))){
return coll.cljs$core$ISeq$_rest$arity$1(coll);
} else {
return cljs$core$ISeq$_rest$dyn_7912(coll);
}
});


/**
 * Protocol for accessing the next items of a collection.
 * @interface
 */
cljs.core.INext = function(){};

var cljs$core$INext$_next$dyn_7914 = (function (coll){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._next[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5351__auto__.call(null,coll));
} else {
var m__5349__auto__ = (cljs.core._next["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5349__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("INext.-next",coll);
}
}
});
/**
 * Returns a new collection of coll without the first item. In contrast to
 *   rest, it should return nil if there are no more items, e.g.
 *   (next []) => nil
 *   (next nil) => nil
 */
cljs.core._next = (function cljs$core$_next(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$INext$_next$arity$1 == null)))))){
return coll.cljs$core$INext$_next$arity$1(coll);
} else {
return cljs$core$INext$_next$dyn_7914(coll);
}
});


/**
 * Protocol for looking up a value in a data structure.
 * @interface
 */
cljs.core.ILookup = function(){};

var cljs$core$ILookup$_lookup$dyn_7918 = (function() {
var G__7919 = null;
var G__7919__2 = (function (o,k){
var x__5350__auto__ = (((o == null))?null:o);
var m__5351__auto__ = (cljs.core._lookup[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(o,k) : m__5351__auto__.call(null,o,k));
} else {
var m__5349__auto__ = (cljs.core._lookup["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(o,k) : m__5349__auto__.call(null,o,k));
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
});
var G__7919__3 = (function (o,k,not_found){
var x__5350__auto__ = (((o == null))?null:o);
var m__5351__auto__ = (cljs.core._lookup[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(o,k,not_found) : m__5351__auto__.call(null,o,k,not_found));
} else {
var m__5349__auto__ = (cljs.core._lookup["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(o,k,not_found) : m__5349__auto__.call(null,o,k,not_found));
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
});
G__7919 = function(o,k,not_found){
switch(arguments.length){
case 2:
return G__7919__2.call(this,o,k);
case 3:
return G__7919__3.call(this,o,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7919.cljs$core$IFn$_invoke$arity$2 = G__7919__2;
G__7919.cljs$core$IFn$_invoke$arity$3 = G__7919__3;
return G__7919;
})()
;
/**
 * Use k to look up a value in o. If not-found is supplied and k is not
 *   a valid value that can be used for look up, not-found is returned.
 */
cljs.core._lookup = (function cljs$core$_lookup(var_args){
var G__6121 = arguments.length;
switch (G__6121) {
case 2:
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._lookup.cljs$core$IFn$_invoke$arity$2 = (function (o,k){
if((((!((o == null)))) && ((!((o.cljs$core$ILookup$_lookup$arity$2 == null)))))){
return o.cljs$core$ILookup$_lookup$arity$2(o,k);
} else {
return cljs$core$ILookup$_lookup$dyn_7918(o,k);
}
}));

(cljs.core._lookup.cljs$core$IFn$_invoke$arity$3 = (function (o,k,not_found){
if((((!((o == null)))) && ((!((o.cljs$core$ILookup$_lookup$arity$3 == null)))))){
return o.cljs$core$ILookup$_lookup$arity$3(o,k,not_found);
} else {
return cljs$core$ILookup$_lookup$dyn_7918(o,k,not_found);
}
}));

(cljs.core._lookup.cljs$lang$maxFixedArity = 3);



/**
 * Protocol for adding associativity to collections.
 * @interface
 */
cljs.core.IAssociative = function(){};

var cljs$core$IAssociative$_contains_key_QMARK_$dyn_7933 = (function (coll,k){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._contains_key_QMARK_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__5351__auto__.call(null,coll,k));
} else {
var m__5349__auto__ = (cljs.core._contains_key_QMARK_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__5349__auto__.call(null,coll,k));
} else {
throw cljs.core.missing_protocol("IAssociative.-contains-key?",coll);
}
}
});
/**
 * Returns true if k is a key in coll.
 */
cljs.core._contains_key_QMARK_ = (function cljs$core$_contains_key_QMARK_(coll,k){
if((((!((coll == null)))) && ((!((coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 == null)))))){
return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll,k);
} else {
return cljs$core$IAssociative$_contains_key_QMARK_$dyn_7933(coll,k);
}
});

var cljs$core$IAssociative$_assoc$dyn_7938 = (function (coll,k,v){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._assoc[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,v) : m__5351__auto__.call(null,coll,k,v));
} else {
var m__5349__auto__ = (cljs.core._assoc["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,v) : m__5349__auto__.call(null,coll,k,v));
} else {
throw cljs.core.missing_protocol("IAssociative.-assoc",coll);
}
}
});
/**
 * Returns a new collection of coll with a mapping from key k to
 *   value v added to it.
 */
cljs.core._assoc = (function cljs$core$_assoc(coll,k,v){
if((((!((coll == null)))) && ((!((coll.cljs$core$IAssociative$_assoc$arity$3 == null)))))){
return coll.cljs$core$IAssociative$_assoc$arity$3(coll,k,v);
} else {
return cljs$core$IAssociative$_assoc$dyn_7938(coll,k,v);
}
});


/**
 * Protocol for implementing entry finding in collections.
 * @interface
 */
cljs.core.IFind = function(){};

var cljs$core$IFind$_find$dyn_7941 = (function (coll,k){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._find[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__5351__auto__.call(null,coll,k));
} else {
var m__5349__auto__ = (cljs.core._find["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__5349__auto__.call(null,coll,k));
} else {
throw cljs.core.missing_protocol("IFind.-find",coll);
}
}
});
/**
 * Returns the map entry for key, or nil if key not present.
 */
cljs.core._find = (function cljs$core$_find(coll,k){
if((((!((coll == null)))) && ((!((coll.cljs$core$IFind$_find$arity$2 == null)))))){
return coll.cljs$core$IFind$_find$arity$2(coll,k);
} else {
return cljs$core$IFind$_find$dyn_7941(coll,k);
}
});


/**
 * Protocol for adding mapping functionality to collections.
 * @interface
 */
cljs.core.IMap = function(){};

var cljs$core$IMap$_dissoc$dyn_7942 = (function (coll,k){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._dissoc[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__5351__auto__.call(null,coll,k));
} else {
var m__5349__auto__ = (cljs.core._dissoc["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__5349__auto__.call(null,coll,k));
} else {
throw cljs.core.missing_protocol("IMap.-dissoc",coll);
}
}
});
/**
 * Returns a new collection of coll without the mapping for key k.
 */
cljs.core._dissoc = (function cljs$core$_dissoc(coll,k){
if((((!((coll == null)))) && ((!((coll.cljs$core$IMap$_dissoc$arity$2 == null)))))){
return coll.cljs$core$IMap$_dissoc$arity$2(coll,k);
} else {
return cljs$core$IMap$_dissoc$dyn_7942(coll,k);
}
});


/**
 * Protocol for examining a map entry.
 * @interface
 */
cljs.core.IMapEntry = function(){};

var cljs$core$IMapEntry$_key$dyn_7943 = (function (coll){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._key[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5351__auto__.call(null,coll));
} else {
var m__5349__auto__ = (cljs.core._key["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5349__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IMapEntry.-key",coll);
}
}
});
/**
 * Returns the key of the map entry.
 */
cljs.core._key = (function cljs$core$_key(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IMapEntry$_key$arity$1 == null)))))){
return coll.cljs$core$IMapEntry$_key$arity$1(coll);
} else {
return cljs$core$IMapEntry$_key$dyn_7943(coll);
}
});

var cljs$core$IMapEntry$_val$dyn_7944 = (function (coll){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._val[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5351__auto__.call(null,coll));
} else {
var m__5349__auto__ = (cljs.core._val["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5349__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IMapEntry.-val",coll);
}
}
});
/**
 * Returns the value of the map entry.
 */
cljs.core._val = (function cljs$core$_val(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IMapEntry$_val$arity$1 == null)))))){
return coll.cljs$core$IMapEntry$_val$arity$1(coll);
} else {
return cljs$core$IMapEntry$_val$dyn_7944(coll);
}
});


/**
 * Protocol for adding set functionality to a collection.
 * @interface
 */
cljs.core.ISet = function(){};

var cljs$core$ISet$_disjoin$dyn_7945 = (function (coll,v){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._disjoin[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(coll,v) : m__5351__auto__.call(null,coll,v));
} else {
var m__5349__auto__ = (cljs.core._disjoin["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(coll,v) : m__5349__auto__.call(null,coll,v));
} else {
throw cljs.core.missing_protocol("ISet.-disjoin",coll);
}
}
});
/**
 * Returns a new collection of coll that does not contain v.
 */
cljs.core._disjoin = (function cljs$core$_disjoin(coll,v){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISet$_disjoin$arity$2 == null)))))){
return coll.cljs$core$ISet$_disjoin$arity$2(coll,v);
} else {
return cljs$core$ISet$_disjoin$dyn_7945(coll,v);
}
});


/**
 * Protocol for collections to provide access to their items as stacks. The top
 *   of the stack should be accessed in the most efficient way for the different
 *   data structures.
 * @interface
 */
cljs.core.IStack = function(){};

var cljs$core$IStack$_peek$dyn_7948 = (function (coll){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._peek[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5351__auto__.call(null,coll));
} else {
var m__5349__auto__ = (cljs.core._peek["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5349__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IStack.-peek",coll);
}
}
});
/**
 * Returns the item from the top of the stack. Is used by cljs.core/peek.
 */
cljs.core._peek = (function cljs$core$_peek(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IStack$_peek$arity$1 == null)))))){
return coll.cljs$core$IStack$_peek$arity$1(coll);
} else {
return cljs$core$IStack$_peek$dyn_7948(coll);
}
});

var cljs$core$IStack$_pop$dyn_7956 = (function (coll){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._pop[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5351__auto__.call(null,coll));
} else {
var m__5349__auto__ = (cljs.core._pop["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5349__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IStack.-pop",coll);
}
}
});
/**
 * Returns a new stack without the item on top of the stack. Is used
 *   by cljs.core/pop.
 */
cljs.core._pop = (function cljs$core$_pop(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IStack$_pop$arity$1 == null)))))){
return coll.cljs$core$IStack$_pop$arity$1(coll);
} else {
return cljs$core$IStack$_pop$dyn_7956(coll);
}
});


/**
 * Protocol for adding vector functionality to collections.
 * @interface
 */
cljs.core.IVector = function(){};

var cljs$core$IVector$_assoc_n$dyn_7959 = (function (coll,n,val){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._assoc_n[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,val) : m__5351__auto__.call(null,coll,n,val));
} else {
var m__5349__auto__ = (cljs.core._assoc_n["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,val) : m__5349__auto__.call(null,coll,n,val));
} else {
throw cljs.core.missing_protocol("IVector.-assoc-n",coll);
}
}
});
/**
 * Returns a new vector with value val added at position n.
 */
cljs.core._assoc_n = (function cljs$core$_assoc_n(coll,n,val){
if((((!((coll == null)))) && ((!((coll.cljs$core$IVector$_assoc_n$arity$3 == null)))))){
return coll.cljs$core$IVector$_assoc_n$arity$3(coll,n,val);
} else {
return cljs$core$IVector$_assoc_n$dyn_7959(coll,n,val);
}
});


/**
 * Protocol for adding dereference functionality to a reference.
 * @interface
 */
cljs.core.IDeref = function(){};

var cljs$core$IDeref$_deref$dyn_7964 = (function (o){
var x__5350__auto__ = (((o == null))?null:o);
var m__5351__auto__ = (cljs.core._deref[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__5351__auto__.call(null,o));
} else {
var m__5349__auto__ = (cljs.core._deref["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__5349__auto__.call(null,o));
} else {
throw cljs.core.missing_protocol("IDeref.-deref",o);
}
}
});
/**
 * Returns the value of the reference o.
 */
cljs.core._deref = (function cljs$core$_deref(o){
if((((!((o == null)))) && ((!((o.cljs$core$IDeref$_deref$arity$1 == null)))))){
return o.cljs$core$IDeref$_deref$arity$1(o);
} else {
return cljs$core$IDeref$_deref$dyn_7964(o);
}
});


/**
 * @interface
 */
cljs.core.IDerefWithTimeout = function(){};

var cljs$core$IDerefWithTimeout$_deref_with_timeout$dyn_7965 = (function (o,msec,timeout_val){
var x__5350__auto__ = (((o == null))?null:o);
var m__5351__auto__ = (cljs.core._deref_with_timeout[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(o,msec,timeout_val) : m__5351__auto__.call(null,o,msec,timeout_val));
} else {
var m__5349__auto__ = (cljs.core._deref_with_timeout["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(o,msec,timeout_val) : m__5349__auto__.call(null,o,msec,timeout_val));
} else {
throw cljs.core.missing_protocol("IDerefWithTimeout.-deref-with-timeout",o);
}
}
});
cljs.core._deref_with_timeout = (function cljs$core$_deref_with_timeout(o,msec,timeout_val){
if((((!((o == null)))) && ((!((o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3 == null)))))){
return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o,msec,timeout_val);
} else {
return cljs$core$IDerefWithTimeout$_deref_with_timeout$dyn_7965(o,msec,timeout_val);
}
});


/**
 * Protocol for accessing the metadata of an object.
 * @interface
 */
cljs.core.IMeta = function(){};

var cljs$core$IMeta$_meta$dyn_7966 = (function (o){
var x__5350__auto__ = (((o == null))?null:o);
var m__5351__auto__ = (cljs.core._meta[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__5351__auto__.call(null,o));
} else {
var m__5349__auto__ = (cljs.core._meta["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__5349__auto__.call(null,o));
} else {
throw cljs.core.missing_protocol("IMeta.-meta",o);
}
}
});
/**
 * Returns the metadata of object o.
 */
cljs.core._meta = (function cljs$core$_meta(o){
if((((!((o == null)))) && ((!((o.cljs$core$IMeta$_meta$arity$1 == null)))))){
return o.cljs$core$IMeta$_meta$arity$1(o);
} else {
return cljs$core$IMeta$_meta$dyn_7966(o);
}
});


/**
 * Protocol for adding metadata to an object.
 * @interface
 */
cljs.core.IWithMeta = function(){};

var cljs$core$IWithMeta$_with_meta$dyn_7967 = (function (o,meta){
var x__5350__auto__ = (((o == null))?null:o);
var m__5351__auto__ = (cljs.core._with_meta[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(o,meta) : m__5351__auto__.call(null,o,meta));
} else {
var m__5349__auto__ = (cljs.core._with_meta["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(o,meta) : m__5349__auto__.call(null,o,meta));
} else {
throw cljs.core.missing_protocol("IWithMeta.-with-meta",o);
}
}
});
/**
 * Returns a new object with value of o and metadata meta added to it.
 */
cljs.core._with_meta = (function cljs$core$_with_meta(o,meta){
if((((!((o == null)))) && ((!((o.cljs$core$IWithMeta$_with_meta$arity$2 == null)))))){
return o.cljs$core$IWithMeta$_with_meta$arity$2(o,meta);
} else {
return cljs$core$IWithMeta$_with_meta$dyn_7967(o,meta);
}
});


/**
 * Protocol for seq types that can reduce themselves.
 *   Called by cljs.core/reduce.
 * @interface
 */
cljs.core.IReduce = function(){};

var cljs$core$IReduce$_reduce$dyn_7968 = (function() {
var G__7969 = null;
var G__7969__2 = (function (coll,f){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._reduce[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(coll,f) : m__5351__auto__.call(null,coll,f));
} else {
var m__5349__auto__ = (cljs.core._reduce["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(coll,f) : m__5349__auto__.call(null,coll,f));
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
});
var G__7969__3 = (function (coll,f,start){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._reduce[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,start) : m__5351__auto__.call(null,coll,f,start));
} else {
var m__5349__auto__ = (cljs.core._reduce["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,start) : m__5349__auto__.call(null,coll,f,start));
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
});
G__7969 = function(coll,f,start){
switch(arguments.length){
case 2:
return G__7969__2.call(this,coll,f);
case 3:
return G__7969__3.call(this,coll,f,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7969.cljs$core$IFn$_invoke$arity$2 = G__7969__2;
G__7969.cljs$core$IFn$_invoke$arity$3 = G__7969__3;
return G__7969;
})()
;
/**
 * f should be a function of 2 arguments. If start is not supplied,
 *   returns the result of applying f to the first 2 items in coll, then
 *   applying f to that result and the 3rd item, etc.
 */
cljs.core._reduce = (function cljs$core$_reduce(var_args){
var G__6123 = arguments.length;
switch (G__6123) {
case 2:
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._reduce.cljs$core$IFn$_invoke$arity$2 = (function (coll,f){
if((((!((coll == null)))) && ((!((coll.cljs$core$IReduce$_reduce$arity$2 == null)))))){
return coll.cljs$core$IReduce$_reduce$arity$2(coll,f);
} else {
return cljs$core$IReduce$_reduce$dyn_7968(coll,f);
}
}));

(cljs.core._reduce.cljs$core$IFn$_invoke$arity$3 = (function (coll,f,start){
if((((!((coll == null)))) && ((!((coll.cljs$core$IReduce$_reduce$arity$3 == null)))))){
return coll.cljs$core$IReduce$_reduce$arity$3(coll,f,start);
} else {
return cljs$core$IReduce$_reduce$dyn_7968(coll,f,start);
}
}));

(cljs.core._reduce.cljs$lang$maxFixedArity = 3);



/**
 * Protocol for associative types that can reduce themselves
 *   via a function of key and val. Called by cljs.core/reduce-kv.
 * @interface
 */
cljs.core.IKVReduce = function(){};

var cljs$core$IKVReduce$_kv_reduce$dyn_7973 = (function (coll,f,init){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._kv_reduce[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,init) : m__5351__auto__.call(null,coll,f,init));
} else {
var m__5349__auto__ = (cljs.core._kv_reduce["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,init) : m__5349__auto__.call(null,coll,f,init));
} else {
throw cljs.core.missing_protocol("IKVReduce.-kv-reduce",coll);
}
}
});
/**
 * Reduces an associative collection and returns the result. f should be
 *   a function that takes three arguments.
 */
cljs.core._kv_reduce = (function cljs$core$_kv_reduce(coll,f,init){
if((((!((coll == null)))) && ((!((coll.cljs$core$IKVReduce$_kv_reduce$arity$3 == null)))))){
return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll,f,init);
} else {
return cljs$core$IKVReduce$_kv_reduce$dyn_7973(coll,f,init);
}
});


/**
 * Protocol for adding value comparison functionality to a type.
 * @interface
 */
cljs.core.IEquiv = function(){};

var cljs$core$IEquiv$_equiv$dyn_7974 = (function (o,other){
var x__5350__auto__ = (((o == null))?null:o);
var m__5351__auto__ = (cljs.core._equiv[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(o,other) : m__5351__auto__.call(null,o,other));
} else {
var m__5349__auto__ = (cljs.core._equiv["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(o,other) : m__5349__auto__.call(null,o,other));
} else {
throw cljs.core.missing_protocol("IEquiv.-equiv",o);
}
}
});
/**
 * Returns true if o and other are equal, false otherwise.
 */
cljs.core._equiv = (function cljs$core$_equiv(o,other){
if((((!((o == null)))) && ((!((o.cljs$core$IEquiv$_equiv$arity$2 == null)))))){
return o.cljs$core$IEquiv$_equiv$arity$2(o,other);
} else {
return cljs$core$IEquiv$_equiv$dyn_7974(o,other);
}
});


/**
 * Protocol for adding hashing functionality to a type.
 * @interface
 */
cljs.core.IHash = function(){};

var cljs$core$IHash$_hash$dyn_7975 = (function (o){
var x__5350__auto__ = (((o == null))?null:o);
var m__5351__auto__ = (cljs.core._hash[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__5351__auto__.call(null,o));
} else {
var m__5349__auto__ = (cljs.core._hash["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__5349__auto__.call(null,o));
} else {
throw cljs.core.missing_protocol("IHash.-hash",o);
}
}
});
/**
 * Returns the hash code of o.
 */
cljs.core._hash = (function cljs$core$_hash(o){
if((((!((o == null)))) && ((!((o.cljs$core$IHash$_hash$arity$1 == null)))))){
return o.cljs$core$IHash$_hash$arity$1(o);
} else {
return cljs$core$IHash$_hash$dyn_7975(o);
}
});


/**
 * Protocol for adding the ability to a type to be transformed into a sequence.
 * @interface
 */
cljs.core.ISeqable = function(){};

var cljs$core$ISeqable$_seq$dyn_7976 = (function (o){
var x__5350__auto__ = (((o == null))?null:o);
var m__5351__auto__ = (cljs.core._seq[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__5351__auto__.call(null,o));
} else {
var m__5349__auto__ = (cljs.core._seq["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__5349__auto__.call(null,o));
} else {
throw cljs.core.missing_protocol("ISeqable.-seq",o);
}
}
});
/**
 * Returns a seq of o, or nil if o is empty.
 */
cljs.core._seq = (function cljs$core$_seq(o){
if((((!((o == null)))) && ((!((o.cljs$core$ISeqable$_seq$arity$1 == null)))))){
return o.cljs$core$ISeqable$_seq$arity$1(o);
} else {
return cljs$core$ISeqable$_seq$dyn_7976(o);
}
});


/**
 * Marker interface indicating a persistent collection of sequential items
 * @interface
 */
cljs.core.ISequential = function(){};


/**
 * Marker interface indicating a persistent list
 * @interface
 */
cljs.core.IList = function(){};


/**
 * Marker interface indicating a record object
 * @interface
 */
cljs.core.IRecord = function(){};


/**
 * Protocol for reversing a seq.
 * @interface
 */
cljs.core.IReversible = function(){};

var cljs$core$IReversible$_rseq$dyn_7977 = (function (coll){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._rseq[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5351__auto__.call(null,coll));
} else {
var m__5349__auto__ = (cljs.core._rseq["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5349__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IReversible.-rseq",coll);
}
}
});
/**
 * Returns a seq of the items in coll in reversed order.
 */
cljs.core._rseq = (function cljs$core$_rseq(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IReversible$_rseq$arity$1 == null)))))){
return coll.cljs$core$IReversible$_rseq$arity$1(coll);
} else {
return cljs$core$IReversible$_rseq$dyn_7977(coll);
}
});


/**
 * Protocol for a collection which can represent their items
 *   in a sorted manner. 
 * @interface
 */
cljs.core.ISorted = function(){};

var cljs$core$ISorted$_sorted_seq$dyn_7981 = (function (coll,ascending_QMARK_){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._sorted_seq[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(coll,ascending_QMARK_) : m__5351__auto__.call(null,coll,ascending_QMARK_));
} else {
var m__5349__auto__ = (cljs.core._sorted_seq["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(coll,ascending_QMARK_) : m__5349__auto__.call(null,coll,ascending_QMARK_));
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq",coll);
}
}
});
/**
 * Returns a sorted seq from coll in either ascending or descending order.
 */
cljs.core._sorted_seq = (function cljs$core$_sorted_seq(coll,ascending_QMARK_){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISorted$_sorted_seq$arity$2 == null)))))){
return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll,ascending_QMARK_);
} else {
return cljs$core$ISorted$_sorted_seq$dyn_7981(coll,ascending_QMARK_);
}
});

var cljs$core$ISorted$_sorted_seq_from$dyn_7983 = (function (coll,k,ascending_QMARK_){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._sorted_seq_from[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,ascending_QMARK_) : m__5351__auto__.call(null,coll,k,ascending_QMARK_));
} else {
var m__5349__auto__ = (cljs.core._sorted_seq_from["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,ascending_QMARK_) : m__5349__auto__.call(null,coll,k,ascending_QMARK_));
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq-from",coll);
}
}
});
/**
 * Returns a sorted seq from coll in either ascending or descending order.
 *   If ascending is true, the result should contain all items which are > or >=
 *   than k. If ascending is false, the result should contain all items which
 *   are < or <= than k, e.g.
 *   (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 true) => (3 4 5)
 *   (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 false) => (3 2 1)
 */
cljs.core._sorted_seq_from = (function cljs$core$_sorted_seq_from(coll,k,ascending_QMARK_){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISorted$_sorted_seq_from$arity$3 == null)))))){
return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll,k,ascending_QMARK_);
} else {
return cljs$core$ISorted$_sorted_seq_from$dyn_7983(coll,k,ascending_QMARK_);
}
});

var cljs$core$ISorted$_entry_key$dyn_7984 = (function (coll,entry){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._entry_key[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(coll,entry) : m__5351__auto__.call(null,coll,entry));
} else {
var m__5349__auto__ = (cljs.core._entry_key["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(coll,entry) : m__5349__auto__.call(null,coll,entry));
} else {
throw cljs.core.missing_protocol("ISorted.-entry-key",coll);
}
}
});
/**
 * Returns the key for entry.
 */
cljs.core._entry_key = (function cljs$core$_entry_key(coll,entry){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISorted$_entry_key$arity$2 == null)))))){
return coll.cljs$core$ISorted$_entry_key$arity$2(coll,entry);
} else {
return cljs$core$ISorted$_entry_key$dyn_7984(coll,entry);
}
});

var cljs$core$ISorted$_comparator$dyn_7987 = (function (coll){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._comparator[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5351__auto__.call(null,coll));
} else {
var m__5349__auto__ = (cljs.core._comparator["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5349__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("ISorted.-comparator",coll);
}
}
});
/**
 * Returns the comparator for coll.
 */
cljs.core._comparator = (function cljs$core$_comparator(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISorted$_comparator$arity$1 == null)))))){
return coll.cljs$core$ISorted$_comparator$arity$1(coll);
} else {
return cljs$core$ISorted$_comparator$dyn_7987(coll);
}
});


/**
 * Protocol for writing. Currently only implemented by StringBufferWriter.
 * @interface
 */
cljs.core.IWriter = function(){};

var cljs$core$IWriter$_write$dyn_7988 = (function (writer,s){
var x__5350__auto__ = (((writer == null))?null:writer);
var m__5351__auto__ = (cljs.core._write[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(writer,s) : m__5351__auto__.call(null,writer,s));
} else {
var m__5349__auto__ = (cljs.core._write["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(writer,s) : m__5349__auto__.call(null,writer,s));
} else {
throw cljs.core.missing_protocol("IWriter.-write",writer);
}
}
});
/**
 * Writes s with writer and returns the result.
 */
cljs.core._write = (function cljs$core$_write(writer,s){
if((((!((writer == null)))) && ((!((writer.cljs$core$IWriter$_write$arity$2 == null)))))){
return writer.cljs$core$IWriter$_write$arity$2(writer,s);
} else {
return cljs$core$IWriter$_write$dyn_7988(writer,s);
}
});

var cljs$core$IWriter$_flush$dyn_7989 = (function (writer){
var x__5350__auto__ = (((writer == null))?null:writer);
var m__5351__auto__ = (cljs.core._flush[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(writer) : m__5351__auto__.call(null,writer));
} else {
var m__5349__auto__ = (cljs.core._flush["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(writer) : m__5349__auto__.call(null,writer));
} else {
throw cljs.core.missing_protocol("IWriter.-flush",writer);
}
}
});
/**
 * Flush writer.
 */
cljs.core._flush = (function cljs$core$_flush(writer){
if((((!((writer == null)))) && ((!((writer.cljs$core$IWriter$_flush$arity$1 == null)))))){
return writer.cljs$core$IWriter$_flush$arity$1(writer);
} else {
return cljs$core$IWriter$_flush$dyn_7989(writer);
}
});


/**
 * The old IPrintable protocol's implementation consisted of building a giant
 * list of strings to concatenate.  This involved lots of concat calls,
 * intermediate vectors, and lazy-seqs, and was very slow in some older JS
 * engines.  IPrintWithWriter implements printing via the IWriter protocol, so it
 * be implemented efficiently in terms of e.g. a StringBuffer append.
 * @interface
 */
cljs.core.IPrintWithWriter = function(){};

var cljs$core$IPrintWithWriter$_pr_writer$dyn_7990 = (function (o,writer,opts){
var x__5350__auto__ = (((o == null))?null:o);
var m__5351__auto__ = (cljs.core._pr_writer[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(o,writer,opts) : m__5351__auto__.call(null,o,writer,opts));
} else {
var m__5349__auto__ = (cljs.core._pr_writer["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(o,writer,opts) : m__5349__auto__.call(null,o,writer,opts));
} else {
throw cljs.core.missing_protocol("IPrintWithWriter.-pr-writer",o);
}
}
});
cljs.core._pr_writer = (function cljs$core$_pr_writer(o,writer,opts){
if((((!((o == null)))) && ((!((o.cljs$core$IPrintWithWriter$_pr_writer$arity$3 == null)))))){
return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3(o,writer,opts);
} else {
return cljs$core$IPrintWithWriter$_pr_writer$dyn_7990(o,writer,opts);
}
});


/**
 * Protocol for types which can have a deferred realization. Currently only
 *   implemented by Delay and LazySeq.
 * @interface
 */
cljs.core.IPending = function(){};

var cljs$core$IPending$_realized_QMARK_$dyn_7991 = (function (x){
var x__5350__auto__ = (((x == null))?null:x);
var m__5351__auto__ = (cljs.core._realized_QMARK_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__5351__auto__.call(null,x));
} else {
var m__5349__auto__ = (cljs.core._realized_QMARK_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__5349__auto__.call(null,x));
} else {
throw cljs.core.missing_protocol("IPending.-realized?",x);
}
}
});
/**
 * Returns true if a value for x has been produced, false otherwise.
 */
cljs.core._realized_QMARK_ = (function cljs$core$_realized_QMARK_(x){
if((((!((x == null)))) && ((!((x.cljs$core$IPending$_realized_QMARK_$arity$1 == null)))))){
return x.cljs$core$IPending$_realized_QMARK_$arity$1(x);
} else {
return cljs$core$IPending$_realized_QMARK_$dyn_7991(x);
}
});


/**
 * Protocol for types that can be watched. Currently only implemented by Atom.
 * @interface
 */
cljs.core.IWatchable = function(){};

var cljs$core$IWatchable$_notify_watches$dyn_7992 = (function (this$,oldval,newval){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._notify_watches[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(this$,oldval,newval) : m__5351__auto__.call(null,this$,oldval,newval));
} else {
var m__5349__auto__ = (cljs.core._notify_watches["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(this$,oldval,newval) : m__5349__auto__.call(null,this$,oldval,newval));
} else {
throw cljs.core.missing_protocol("IWatchable.-notify-watches",this$);
}
}
});
/**
 * Calls all watchers with this, oldval and newval.
 */
cljs.core._notify_watches = (function cljs$core$_notify_watches(this$,oldval,newval){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IWatchable$_notify_watches$arity$3 == null)))))){
return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$,oldval,newval);
} else {
return cljs$core$IWatchable$_notify_watches$dyn_7992(this$,oldval,newval);
}
});

var cljs$core$IWatchable$_add_watch$dyn_7993 = (function (this$,key,f){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._add_watch[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(this$,key,f) : m__5351__auto__.call(null,this$,key,f));
} else {
var m__5349__auto__ = (cljs.core._add_watch["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(this$,key,f) : m__5349__auto__.call(null,this$,key,f));
} else {
throw cljs.core.missing_protocol("IWatchable.-add-watch",this$);
}
}
});
/**
 * Adds a watcher function f to this. Keys must be unique per reference,
 *   and can be used to remove the watch with -remove-watch.
 */
cljs.core._add_watch = (function cljs$core$_add_watch(this$,key,f){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IWatchable$_add_watch$arity$3 == null)))))){
return this$.cljs$core$IWatchable$_add_watch$arity$3(this$,key,f);
} else {
return cljs$core$IWatchable$_add_watch$dyn_7993(this$,key,f);
}
});

var cljs$core$IWatchable$_remove_watch$dyn_7994 = (function (this$,key){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._remove_watch[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(this$,key) : m__5351__auto__.call(null,this$,key));
} else {
var m__5349__auto__ = (cljs.core._remove_watch["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(this$,key) : m__5349__auto__.call(null,this$,key));
} else {
throw cljs.core.missing_protocol("IWatchable.-remove-watch",this$);
}
}
});
/**
 * Removes watcher that corresponds to key from this.
 */
cljs.core._remove_watch = (function cljs$core$_remove_watch(this$,key){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IWatchable$_remove_watch$arity$2 == null)))))){
return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$,key);
} else {
return cljs$core$IWatchable$_remove_watch$dyn_7994(this$,key);
}
});


/**
 * Protocol for collections which can transformed to transients.
 * @interface
 */
cljs.core.IEditableCollection = function(){};

var cljs$core$IEditableCollection$_as_transient$dyn_7995 = (function (coll){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._as_transient[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5351__auto__.call(null,coll));
} else {
var m__5349__auto__ = (cljs.core._as_transient["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5349__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IEditableCollection.-as-transient",coll);
}
}
});
/**
 * Returns a new, transient version of the collection, in constant time.
 */
cljs.core._as_transient = (function cljs$core$_as_transient(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IEditableCollection$_as_transient$arity$1 == null)))))){
return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll);
} else {
return cljs$core$IEditableCollection$_as_transient$dyn_7995(coll);
}
});


/**
 * Protocol for adding basic functionality to transient collections.
 * @interface
 */
cljs.core.ITransientCollection = function(){};

var cljs$core$ITransientCollection$_conj_BANG_$dyn_7996 = (function (tcoll,val){
var x__5350__auto__ = (((tcoll == null))?null:tcoll);
var m__5351__auto__ = (cljs.core._conj_BANG_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,val) : m__5351__auto__.call(null,tcoll,val));
} else {
var m__5349__auto__ = (cljs.core._conj_BANG_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,val) : m__5349__auto__.call(null,tcoll,val));
} else {
throw cljs.core.missing_protocol("ITransientCollection.-conj!",tcoll);
}
}
});
/**
 * Adds value val to tcoll and returns tcoll.
 */
cljs.core._conj_BANG_ = (function cljs$core$_conj_BANG_(tcoll,val){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2 == null)))))){
return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll,val);
} else {
return cljs$core$ITransientCollection$_conj_BANG_$dyn_7996(tcoll,val);
}
});

var cljs$core$ITransientCollection$_persistent_BANG_$dyn_7997 = (function (tcoll){
var x__5350__auto__ = (((tcoll == null))?null:tcoll);
var m__5351__auto__ = (cljs.core._persistent_BANG_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__5351__auto__.call(null,tcoll));
} else {
var m__5349__auto__ = (cljs.core._persistent_BANG_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__5349__auto__.call(null,tcoll));
} else {
throw cljs.core.missing_protocol("ITransientCollection.-persistent!",tcoll);
}
}
});
/**
 * Creates a persistent data structure from tcoll and returns it.
 */
cljs.core._persistent_BANG_ = (function cljs$core$_persistent_BANG_(tcoll){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 == null)))))){
return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll);
} else {
return cljs$core$ITransientCollection$_persistent_BANG_$dyn_7997(tcoll);
}
});


/**
 * Protocol for adding associativity to transient collections.
 * @interface
 */
cljs.core.ITransientAssociative = function(){};

var cljs$core$ITransientAssociative$_assoc_BANG_$dyn_8002 = (function (tcoll,key,val){
var x__5350__auto__ = (((tcoll == null))?null:tcoll);
var m__5351__auto__ = (cljs.core._assoc_BANG_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,key,val) : m__5351__auto__.call(null,tcoll,key,val));
} else {
var m__5349__auto__ = (cljs.core._assoc_BANG_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,key,val) : m__5349__auto__.call(null,tcoll,key,val));
} else {
throw cljs.core.missing_protocol("ITransientAssociative.-assoc!",tcoll);
}
}
});
/**
 * Returns a new transient collection of tcoll with a mapping from key to
 *   val added to it.
 */
cljs.core._assoc_BANG_ = (function cljs$core$_assoc_BANG_(tcoll,key,val){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 == null)))))){
return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll,key,val);
} else {
return cljs$core$ITransientAssociative$_assoc_BANG_$dyn_8002(tcoll,key,val);
}
});


/**
 * Protocol for adding mapping functionality to transient collections.
 * @interface
 */
cljs.core.ITransientMap = function(){};

var cljs$core$ITransientMap$_dissoc_BANG_$dyn_8003 = (function (tcoll,key){
var x__5350__auto__ = (((tcoll == null))?null:tcoll);
var m__5351__auto__ = (cljs.core._dissoc_BANG_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,key) : m__5351__auto__.call(null,tcoll,key));
} else {
var m__5349__auto__ = (cljs.core._dissoc_BANG_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,key) : m__5349__auto__.call(null,tcoll,key));
} else {
throw cljs.core.missing_protocol("ITransientMap.-dissoc!",tcoll);
}
}
});
/**
 * Returns a new transient collection of tcoll without the mapping for key.
 */
cljs.core._dissoc_BANG_ = (function cljs$core$_dissoc_BANG_(tcoll,key){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 == null)))))){
return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll,key);
} else {
return cljs$core$ITransientMap$_dissoc_BANG_$dyn_8003(tcoll,key);
}
});


/**
 * Protocol for adding vector functionality to transient collections.
 * @interface
 */
cljs.core.ITransientVector = function(){};

var cljs$core$ITransientVector$_assoc_n_BANG_$dyn_8006 = (function (tcoll,n,val){
var x__5350__auto__ = (((tcoll == null))?null:tcoll);
var m__5351__auto__ = (cljs.core._assoc_n_BANG_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,n,val) : m__5351__auto__.call(null,tcoll,n,val));
} else {
var m__5349__auto__ = (cljs.core._assoc_n_BANG_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,n,val) : m__5349__auto__.call(null,tcoll,n,val));
} else {
throw cljs.core.missing_protocol("ITransientVector.-assoc-n!",tcoll);
}
}
});
/**
 * Returns tcoll with value val added at position n.
 */
cljs.core._assoc_n_BANG_ = (function cljs$core$_assoc_n_BANG_(tcoll,n,val){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 == null)))))){
return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll,n,val);
} else {
return cljs$core$ITransientVector$_assoc_n_BANG_$dyn_8006(tcoll,n,val);
}
});

var cljs$core$ITransientVector$_pop_BANG_$dyn_8007 = (function (tcoll){
var x__5350__auto__ = (((tcoll == null))?null:tcoll);
var m__5351__auto__ = (cljs.core._pop_BANG_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__5351__auto__.call(null,tcoll));
} else {
var m__5349__auto__ = (cljs.core._pop_BANG_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__5349__auto__.call(null,tcoll));
} else {
throw cljs.core.missing_protocol("ITransientVector.-pop!",tcoll);
}
}
});
/**
 * Returns tcoll with the last item removed from it.
 */
cljs.core._pop_BANG_ = (function cljs$core$_pop_BANG_(tcoll){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1 == null)))))){
return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll);
} else {
return cljs$core$ITransientVector$_pop_BANG_$dyn_8007(tcoll);
}
});


/**
 * Protocol for adding set functionality to a transient collection.
 * @interface
 */
cljs.core.ITransientSet = function(){};

var cljs$core$ITransientSet$_disjoin_BANG_$dyn_8011 = (function (tcoll,v){
var x__5350__auto__ = (((tcoll == null))?null:tcoll);
var m__5351__auto__ = (cljs.core._disjoin_BANG_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,v) : m__5351__auto__.call(null,tcoll,v));
} else {
var m__5349__auto__ = (cljs.core._disjoin_BANG_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,v) : m__5349__auto__.call(null,tcoll,v));
} else {
throw cljs.core.missing_protocol("ITransientSet.-disjoin!",tcoll);
}
}
});
/**
 * Returns tcoll without v.
 */
cljs.core._disjoin_BANG_ = (function cljs$core$_disjoin_BANG_(tcoll,v){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 == null)))))){
return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll,v);
} else {
return cljs$core$ITransientSet$_disjoin_BANG_$dyn_8011(tcoll,v);
}
});


/**
 * Protocol for values that can be compared.
 * @interface
 */
cljs.core.IComparable = function(){};

var cljs$core$IComparable$_compare$dyn_8012 = (function (x,y){
var x__5350__auto__ = (((x == null))?null:x);
var m__5351__auto__ = (cljs.core._compare[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(x,y) : m__5351__auto__.call(null,x,y));
} else {
var m__5349__auto__ = (cljs.core._compare["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(x,y) : m__5349__auto__.call(null,x,y));
} else {
throw cljs.core.missing_protocol("IComparable.-compare",x);
}
}
});
/**
 * Returns a negative number, zero, or a positive number when x is logically
 *   'less than', 'equal to', or 'greater than' y.
 */
cljs.core._compare = (function cljs$core$_compare(x,y){
if((((!((x == null)))) && ((!((x.cljs$core$IComparable$_compare$arity$2 == null)))))){
return x.cljs$core$IComparable$_compare$arity$2(x,y);
} else {
return cljs$core$IComparable$_compare$dyn_8012(x,y);
}
});


/**
 * Protocol for accessing the items of a chunk.
 * @interface
 */
cljs.core.IChunk = function(){};

var cljs$core$IChunk$_drop_first$dyn_8013 = (function (coll){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._drop_first[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5351__auto__.call(null,coll));
} else {
var m__5349__auto__ = (cljs.core._drop_first["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5349__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunk.-drop-first",coll);
}
}
});
/**
 * Return a new chunk of coll with the first item removed.
 */
cljs.core._drop_first = (function cljs$core$_drop_first(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IChunk$_drop_first$arity$1 == null)))))){
return coll.cljs$core$IChunk$_drop_first$arity$1(coll);
} else {
return cljs$core$IChunk$_drop_first$dyn_8013(coll);
}
});


/**
 * Protocol for accessing a collection as sequential chunks.
 * @interface
 */
cljs.core.IChunkedSeq = function(){};

var cljs$core$IChunkedSeq$_chunked_first$dyn_8014 = (function (coll){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._chunked_first[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5351__auto__.call(null,coll));
} else {
var m__5349__auto__ = (cljs.core._chunked_first["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5349__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-first",coll);
}
}
});
/**
 * Returns the first chunk in coll.
 */
cljs.core._chunked_first = (function cljs$core$_chunked_first(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IChunkedSeq$_chunked_first$arity$1 == null)))))){
return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1(coll);
} else {
return cljs$core$IChunkedSeq$_chunked_first$dyn_8014(coll);
}
});

var cljs$core$IChunkedSeq$_chunked_rest$dyn_8015 = (function (coll){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._chunked_rest[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5351__auto__.call(null,coll));
} else {
var m__5349__auto__ = (cljs.core._chunked_rest["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5349__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-rest",coll);
}
}
});
/**
 * Return a new collection of coll with the first chunk removed.
 */
cljs.core._chunked_rest = (function cljs$core$_chunked_rest(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1 == null)))))){
return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll);
} else {
return cljs$core$IChunkedSeq$_chunked_rest$dyn_8015(coll);
}
});


/**
 * Protocol for accessing the chunks of a collection.
 * @interface
 */
cljs.core.IChunkedNext = function(){};

var cljs$core$IChunkedNext$_chunked_next$dyn_8016 = (function (coll){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._chunked_next[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5351__auto__.call(null,coll));
} else {
var m__5349__auto__ = (cljs.core._chunked_next["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5349__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunkedNext.-chunked-next",coll);
}
}
});
/**
 * Returns a new collection of coll without the first chunk.
 */
cljs.core._chunked_next = (function cljs$core$_chunked_next(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IChunkedNext$_chunked_next$arity$1 == null)))))){
return coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll);
} else {
return cljs$core$IChunkedNext$_chunked_next$dyn_8016(coll);
}
});


/**
 * Protocol for adding a name.
 * @interface
 */
cljs.core.INamed = function(){};

var cljs$core$INamed$_name$dyn_8017 = (function (x){
var x__5350__auto__ = (((x == null))?null:x);
var m__5351__auto__ = (cljs.core._name[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__5351__auto__.call(null,x));
} else {
var m__5349__auto__ = (cljs.core._name["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__5349__auto__.call(null,x));
} else {
throw cljs.core.missing_protocol("INamed.-name",x);
}
}
});
/**
 * Returns the name String of x.
 */
cljs.core._name = (function cljs$core$_name(x){
if((((!((x == null)))) && ((!((x.cljs$core$INamed$_name$arity$1 == null)))))){
return x.cljs$core$INamed$_name$arity$1(x);
} else {
return cljs$core$INamed$_name$dyn_8017(x);
}
});

var cljs$core$INamed$_namespace$dyn_8018 = (function (x){
var x__5350__auto__ = (((x == null))?null:x);
var m__5351__auto__ = (cljs.core._namespace[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__5351__auto__.call(null,x));
} else {
var m__5349__auto__ = (cljs.core._namespace["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__5349__auto__.call(null,x));
} else {
throw cljs.core.missing_protocol("INamed.-namespace",x);
}
}
});
/**
 * Returns the namespace String of x.
 */
cljs.core._namespace = (function cljs$core$_namespace(x){
if((((!((x == null)))) && ((!((x.cljs$core$INamed$_namespace$arity$1 == null)))))){
return x.cljs$core$INamed$_namespace$arity$1(x);
} else {
return cljs$core$INamed$_namespace$dyn_8018(x);
}
});


/**
 * Marker protocol indicating an atom.
 * @interface
 */
cljs.core.IAtom = function(){};


/**
 * Protocol for adding resetting functionality.
 * @interface
 */
cljs.core.IReset = function(){};

var cljs$core$IReset$_reset_BANG_$dyn_8019 = (function (o,new_value){
var x__5350__auto__ = (((o == null))?null:o);
var m__5351__auto__ = (cljs.core._reset_BANG_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__5351__auto__.call(null,o,new_value));
} else {
var m__5349__auto__ = (cljs.core._reset_BANG_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__5349__auto__.call(null,o,new_value));
} else {
throw cljs.core.missing_protocol("IReset.-reset!",o);
}
}
});
/**
 * Sets the value of o to new-value.
 */
cljs.core._reset_BANG_ = (function cljs$core$_reset_BANG_(o,new_value){
if((((!((o == null)))) && ((!((o.cljs$core$IReset$_reset_BANG_$arity$2 == null)))))){
return o.cljs$core$IReset$_reset_BANG_$arity$2(o,new_value);
} else {
return cljs$core$IReset$_reset_BANG_$dyn_8019(o,new_value);
}
});


/**
 * Protocol for adding swapping functionality.
 * @interface
 */
cljs.core.ISwap = function(){};

var cljs$core$ISwap$_swap_BANG_$dyn_8023 = (function() {
var G__8024 = null;
var G__8024__2 = (function (o,f){
var x__5350__auto__ = (((o == null))?null:o);
var m__5351__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(o,f) : m__5351__auto__.call(null,o,f));
} else {
var m__5349__auto__ = (cljs.core._swap_BANG_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(o,f) : m__5349__auto__.call(null,o,f));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
});
var G__8024__3 = (function (o,f,a){
var x__5350__auto__ = (((o == null))?null:o);
var m__5351__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(o,f,a) : m__5351__auto__.call(null,o,f,a));
} else {
var m__5349__auto__ = (cljs.core._swap_BANG_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(o,f,a) : m__5349__auto__.call(null,o,f,a));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
});
var G__8024__4 = (function (o,f,a,b){
var x__5350__auto__ = (((o == null))?null:o);
var m__5351__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$4(o,f,a,b) : m__5351__auto__.call(null,o,f,a,b));
} else {
var m__5349__auto__ = (cljs.core._swap_BANG_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$4(o,f,a,b) : m__5349__auto__.call(null,o,f,a,b));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
});
var G__8024__5 = (function (o,f,a,b,xs){
var x__5350__auto__ = (((o == null))?null:o);
var m__5351__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$5 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$5(o,f,a,b,xs) : m__5351__auto__.call(null,o,f,a,b,xs));
} else {
var m__5349__auto__ = (cljs.core._swap_BANG_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$5 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$5(o,f,a,b,xs) : m__5349__auto__.call(null,o,f,a,b,xs));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
});
G__8024 = function(o,f,a,b,xs){
switch(arguments.length){
case 2:
return G__8024__2.call(this,o,f);
case 3:
return G__8024__3.call(this,o,f,a);
case 4:
return G__8024__4.call(this,o,f,a,b);
case 5:
return G__8024__5.call(this,o,f,a,b,xs);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8024.cljs$core$IFn$_invoke$arity$2 = G__8024__2;
G__8024.cljs$core$IFn$_invoke$arity$3 = G__8024__3;
G__8024.cljs$core$IFn$_invoke$arity$4 = G__8024__4;
G__8024.cljs$core$IFn$_invoke$arity$5 = G__8024__5;
return G__8024;
})()
;
/**
 * Swaps the value of o to be (apply f current-value-of-atom args).
 */
cljs.core._swap_BANG_ = (function cljs$core$_swap_BANG_(var_args){
var G__6125 = arguments.length;
switch (G__6125) {
case 2:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (o,f){
if((((!((o == null)))) && ((!((o.cljs$core$ISwap$_swap_BANG_$arity$2 == null)))))){
return o.cljs$core$ISwap$_swap_BANG_$arity$2(o,f);
} else {
return cljs$core$ISwap$_swap_BANG_$dyn_8023(o,f);
}
}));

(cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (o,f,a){
if((((!((o == null)))) && ((!((o.cljs$core$ISwap$_swap_BANG_$arity$3 == null)))))){
return o.cljs$core$ISwap$_swap_BANG_$arity$3(o,f,a);
} else {
return cljs$core$ISwap$_swap_BANG_$dyn_8023(o,f,a);
}
}));

(cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (o,f,a,b){
if((((!((o == null)))) && ((!((o.cljs$core$ISwap$_swap_BANG_$arity$4 == null)))))){
return o.cljs$core$ISwap$_swap_BANG_$arity$4(o,f,a,b);
} else {
return cljs$core$ISwap$_swap_BANG_$dyn_8023(o,f,a,b);
}
}));

(cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (o,f,a,b,xs){
if((((!((o == null)))) && ((!((o.cljs$core$ISwap$_swap_BANG_$arity$5 == null)))))){
return o.cljs$core$ISwap$_swap_BANG_$arity$5(o,f,a,b,xs);
} else {
return cljs$core$ISwap$_swap_BANG_$dyn_8023(o,f,a,b,xs);
}
}));

(cljs.core._swap_BANG_.cljs$lang$maxFixedArity = 5);



/**
 * Protocol for adding volatile functionality.
 * @interface
 */
cljs.core.IVolatile = function(){};

var cljs$core$IVolatile$_vreset_BANG_$dyn_8030 = (function (o,new_value){
var x__5350__auto__ = (((o == null))?null:o);
var m__5351__auto__ = (cljs.core._vreset_BANG_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__5351__auto__.call(null,o,new_value));
} else {
var m__5349__auto__ = (cljs.core._vreset_BANG_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__5349__auto__.call(null,o,new_value));
} else {
throw cljs.core.missing_protocol("IVolatile.-vreset!",o);
}
}
});
/**
 * Sets the value of volatile o to new-value without regard for the
 *   current value. Returns new-value.
 */
cljs.core._vreset_BANG_ = (function cljs$core$_vreset_BANG_(o,new_value){
if((((!((o == null)))) && ((!((o.cljs$core$IVolatile$_vreset_BANG_$arity$2 == null)))))){
return o.cljs$core$IVolatile$_vreset_BANG_$arity$2(o,new_value);
} else {
return cljs$core$IVolatile$_vreset_BANG_$dyn_8030(o,new_value);
}
});


/**
 * Protocol for iterating over a collection.
 * @interface
 */
cljs.core.IIterable = function(){};

var cljs$core$IIterable$_iterator$dyn_8031 = (function (coll){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._iterator[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5351__auto__.call(null,coll));
} else {
var m__5349__auto__ = (cljs.core._iterator["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5349__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IIterable.-iterator",coll);
}
}
});
/**
 * Returns an iterator for coll.
 */
cljs.core._iterator = (function cljs$core$_iterator(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IIterable$_iterator$arity$1 == null)))))){
return coll.cljs$core$IIterable$_iterator$arity$1(coll);
} else {
return cljs$core$IIterable$_iterator$dyn_8031(coll);
}
});


/**
 * Protocol for persistent or algorithmically defined collections to provide a
 *   means of dropping N items that is more efficient than sequential walking.
 * @interface
 */
cljs.core.IDrop = function(){};

var cljs$core$IDrop$_drop$dyn_8032 = (function (coll,n){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._drop[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(coll,n) : m__5351__auto__.call(null,coll,n));
} else {
var m__5349__auto__ = (cljs.core._drop["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(coll,n) : m__5349__auto__.call(null,coll,n));
} else {
throw cljs.core.missing_protocol("IDrop.-drop",coll);
}
}
});
/**
 * Returns a collection that is ISequential, ISeq, and IReduce, or nil if past
 *   the end. The number of items to drop n must be > 0. It is also useful if the
 *   returned coll implements IDrop for subsequent use in a partition-like scenario.
 */
cljs.core._drop = (function cljs$core$_drop(coll,n){
if((((!((coll == null)))) && ((!((coll.cljs$core$IDrop$_drop$arity$2 == null)))))){
return coll.cljs$core$IDrop$_drop$arity$2(coll,n);
} else {
return cljs$core$IDrop$_drop$dyn_8032(coll,n);
}
});


/**
* @constructor
 * @implements {cljs.core.IWriter}
*/
cljs.core.StringBufferWriter = (function (sb){
this.sb = sb;
this.cljs$lang$protocol_mask$partition0$ = 1073741824;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_write$arity$2 = (function (_,s){
var self__ = this;
var ___$1 = this;
return self__.sb.append(s);
}));

(cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_flush$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return null;
}));

(cljs.core.StringBufferWriter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"sb","sb",-1249746442,null)], null);
}));

(cljs.core.StringBufferWriter.cljs$lang$type = true);

(cljs.core.StringBufferWriter.cljs$lang$ctorStr = "cljs.core/StringBufferWriter");

(cljs.core.StringBufferWriter.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/StringBufferWriter");
}));

/**
 * Positional factory function for cljs.core/StringBufferWriter.
 */
cljs.core.__GT_StringBufferWriter = (function cljs$core$__GT_StringBufferWriter(sb){
return (new cljs.core.StringBufferWriter(sb));
});

/**
 * Support so that collections can implement toString without
 * loading all the printing machinery.
 */
cljs.core.pr_str_STAR_ = (function cljs$core$pr_str_STAR_(obj){
var sb = (new goog.string.StringBuffer());
var writer = (new cljs.core.StringBufferWriter(sb));
obj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null,writer,cljs.core.pr_opts());

writer.cljs$core$IWriter$_flush$arity$1(null);

return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb);
});
cljs.core.int_rotate_left = (function cljs$core$int_rotate_left(x,n){
return ((x << n) | (x >>> (- n)));
});
if((((typeof Math !== 'undefined') && (typeof Math.imul !== 'undefined')) && ((!((Math.imul((4294967295),(5)) === (0))))))){
cljs.core.imul = (function cljs$core$imul(a,b){
return Math.imul(a,b);
});
} else {
cljs.core.imul = (function cljs$core$imul(a,b){
var ah = ((a >>> (16)) & (65535));
var al = (a & (65535));
var bh = ((b >>> (16)) & (65535));
var bl = (b & (65535));
return (((al * bl) + ((((ah * bl) + (al * bh)) << (16)) >>> (0))) | (0));
});
}
cljs.core.m3_seed = (0);
cljs.core.m3_C1 = ((3432918353) | (0));
cljs.core.m3_C2 = ((461845907) | (0));
cljs.core.m3_mix_K1 = (function cljs$core$m3_mix_K1(k1){
return cljs.core.imul(cljs.core.int_rotate_left(cljs.core.imul((k1 | (0)),cljs.core.m3_C1),(15)),cljs.core.m3_C2);
});
cljs.core.m3_mix_H1 = (function cljs$core$m3_mix_H1(h1,k1){
return ((cljs.core.imul(cljs.core.int_rotate_left(((h1 | (0)) ^ (k1 | (0))),(13)),(5)) + ((3864292196) | (0))) | (0));
});
cljs.core.m3_fmix = (function cljs$core$m3_fmix(h1,len){
var h1__$1 = (h1 | (0));
var h1__$2 = (h1__$1 ^ len);
var h1__$3 = (h1__$2 ^ (h1__$2 >>> (16)));
var h1__$4 = cljs.core.imul(h1__$3,((2246822507) | (0)));
var h1__$5 = (h1__$4 ^ (h1__$4 >>> (13)));
var h1__$6 = cljs.core.imul(h1__$5,((3266489909) | (0)));
return (h1__$6 ^ (h1__$6 >>> (16)));
});
cljs.core.m3_hash_int = (function cljs$core$m3_hash_int(in$){
if((in$ === (0))){
return in$;
} else {
var k1 = cljs.core.m3_mix_K1(in$);
var h1 = cljs.core.m3_mix_H1(cljs.core.m3_seed,k1);
return cljs.core.m3_fmix(h1,(4));
}
});
cljs.core.hash_long = (function cljs$core$hash_long(high,low){
return (high ^ low);
});
cljs.core.hash_double = (function cljs$core$hash_double(f){
var arr = (function (){var G__6126 = (new Float64Array((1)));
(G__6126[(0)] = f);

return G__6126;
})();
var buf = arr.buffer;
var high = (new DataView(buf,(0),(4))).getInt32();
var low = (new DataView(buf,(4),(4))).getInt32();
return cljs.core.hash_long(high,low);
});
cljs.core.m3_hash_unencoded_chars = (function cljs$core$m3_hash_unencoded_chars(in$){
var h1 = (function (){var i = (1);
var h1 = cljs.core.m3_seed;
while(true){
if((i < in$.length)){
var G__8039 = (i + (2));
var G__8040 = cljs.core.m3_mix_H1(h1,cljs.core.m3_mix_K1((in$.charCodeAt((i - (1))) | (in$.charCodeAt(i) << (16)))));
i = G__8039;
h1 = G__8040;
continue;
} else {
return h1;
}
break;
}
})();
var h1__$1 = ((((in$.length & (1)) === (1)))?(h1 ^ cljs.core.m3_mix_K1(in$.charCodeAt((in$.length - (1))))):h1);
return cljs.core.m3_fmix(h1__$1,cljs.core.imul((2),in$.length));
});



cljs.core.string_hash_cache = ({});
cljs.core.string_hash_cache_count = (0);
cljs.core.hash_string_STAR_ = (function cljs$core$hash_string_STAR_(s){
if((!((s == null)))){
var len = s.length;
if((len > (0))){
var i = (0);
var hash = (0);
while(true){
if((i < len)){
var G__8044 = (i + (1));
var G__8045 = (cljs.core.imul((31),hash) + s.charCodeAt(i));
i = G__8044;
hash = G__8045;
continue;
} else {
return hash;
}
break;
}
} else {
return (0);
}
} else {
return (0);
}
});
cljs.core.add_to_string_hash_cache = (function cljs$core$add_to_string_hash_cache(k){
var h = cljs.core.hash_string_STAR_(k);
cljs.core.goog$module$goog$object.set(cljs.core.string_hash_cache,k,h);

(cljs.core.string_hash_cache_count = (cljs.core.string_hash_cache_count + (1)));

return h;
});
cljs.core.hash_string = (function cljs$core$hash_string(k){
if((cljs.core.string_hash_cache_count > (255))){
(cljs.core.string_hash_cache = ({}));

(cljs.core.string_hash_cache_count = (0));
} else {
}

if((k == null)){
return (0);
} else {
var h = (cljs.core.string_hash_cache[k]);
if(typeof h === 'number'){
return h;
} else {
return cljs.core.add_to_string_hash_cache(k);
}
}
});
/**
 * Returns the hash code of its argument. Note this is the hash code
 * consistent with =.
 */
cljs.core.hash = (function cljs$core$hash(o){
if((((!((o == null))))?(((((o.cljs$lang$protocol_mask$partition0$ & (4194304))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$IHash$))))?true:false):false)){
return (o.cljs$core$IHash$_hash$arity$1(null) ^ (0));
} else {
if(typeof o === 'number'){
if(isFinite(o)){
if((!(Number.isSafeInteger(o)))){
return cljs.core.hash_double(o);
} else {
return (Math.floor(o) % (2147483647));
}
} else {
var G__6132 = o;
switch (G__6132) {
case Infinity:
return (2146435072);

break;
case -Infinity:
return (-1048576);

break;
default:
return (2146959360);

}
}
} else {
if(o === true){
return (1231);
} else {
if(o === false){
return (1237);
} else {
if(typeof o === 'string'){
return cljs.core.m3_hash_int(cljs.core.hash_string(o));
} else {
if((o instanceof Date)){
return (o.valueOf() ^ (0));
} else {
if((o == null)){
return (0);
} else {
return (cljs.core._hash(o) ^ (0));

}
}
}
}
}
}
}
});
cljs.core.hash_combine = (function cljs$core$hash_combine(seed,hash){
return (seed ^ (((hash + (2654435769)) + (seed << (6))) + (seed >> (2))));
});
/**
 * Evaluates x and tests if it is an instance of the type
 *   c. Returns true or false
 */
cljs.core.instance_QMARK_ = (function cljs$core$instance_QMARK_(c,x){
return (x instanceof c);
});
/**
 * Return true if x is a Symbol
 */
cljs.core.symbol_QMARK_ = (function cljs$core$symbol_QMARK_(x){
return (x instanceof cljs.core.Symbol);
});
cljs.core.hash_symbol = (function cljs$core$hash_symbol(sym){
return cljs.core.hash_combine(cljs.core.m3_hash_unencoded_chars(sym.name),cljs.core.hash_string(sym.ns));
});
cljs.core.compare_symbols = (function cljs$core$compare_symbols(a,b){
if((a.str === b.str)){
return (0);
} else {
if(cljs.core.truth_((function (){var and__5000__auto__ = cljs.core.not(a.ns);
if(and__5000__auto__){
return b.ns;
} else {
return and__5000__auto__;
}
})())){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = cljs.core.goog$module$goog$array.defaultCompare(a.ns,b.ns);
if(((0) === nsc)){
return cljs.core.goog$module$goog$array.defaultCompare(a.name,b.name);
} else {
return nsc;
}
}
} else {
return cljs.core.goog$module$goog$array.defaultCompare(a.name,b.name);

}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.INamed}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.Symbol = (function (ns,name,str,_hash,_meta){
this.ns = ns;
this.name = name;
this.str = str;
this._hash = _hash;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 2154168321;
this.cljs$lang$protocol_mask$partition1$ = 4096;
});
(cljs.core.Symbol.prototype.toString = (function (){
var self__ = this;
var _ = this;
return self__.str;
}));

(cljs.core.Symbol.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.Symbol.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Symbol)){
return (self__.str === other.str);
} else {
return false;
}
}));

(cljs.core.Symbol.prototype.call = (function (unused__10318__auto__){
var self__ = this;
var self__ = this;
var G__6134 = (arguments.length - (1));
switch (G__6134) {
case (1):
return self__.cljs$core$IFn$_invoke$arity$1((arguments[(1)]));

break;
case (2):
return self__.cljs$core$IFn$_invoke$arity$2((arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (1)))].join('')));

}
}));

(cljs.core.Symbol.prototype.apply = (function (self__,args6133){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args6133)));
}));

(cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var self__ = this;
var sym = this;
return (cljs.core.get.cljs$core$IFn$_invoke$arity$2 ? cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,sym) : cljs.core.get.call(null,coll,sym));
}));

(cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$2 = (function (coll,not_found){
var self__ = this;
var sym = this;
return (cljs.core.get.cljs$core$IFn$_invoke$arity$3 ? cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found) : cljs.core.get.call(null,coll,sym,not_found));
}));

(cljs.core.Symbol.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__._meta;
}));

(cljs.core.Symbol.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Symbol(self__.ns,self__.name,self__.str,self__._hash,new_meta));
}));

(cljs.core.Symbol.prototype.cljs$core$IHash$_hash$arity$1 = (function (sym){
var self__ = this;
var sym__$1 = this;
var h__5111__auto__ = self__._hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_symbol(sym__$1);
(self__._hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.Symbol.prototype.cljs$core$INamed$_name$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.name;
}));

(cljs.core.Symbol.prototype.cljs$core$INamed$_namespace$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ns;
}));

(cljs.core.Symbol.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,self__.str);
}));

(cljs.core.Symbol.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ns","ns",2082130287,null),new cljs.core.Symbol(null,"name","name",-810760592,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_hash","_hash",-2130838312,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
}));

(cljs.core.Symbol.cljs$lang$type = true);

(cljs.core.Symbol.cljs$lang$ctorStr = "cljs.core/Symbol");

(cljs.core.Symbol.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/Symbol");
}));

/**
 * Positional factory function for cljs.core/Symbol.
 */
cljs.core.__GT_Symbol = (function cljs$core$__GT_Symbol(ns,name,str,_hash,_meta){
return (new cljs.core.Symbol(ns,name,str,_hash,_meta));
});

/**
 * Returns true if v is of type cljs.core.Var
 */
cljs.core.var_QMARK_ = (function cljs$core$var_QMARK_(v){
return (v instanceof cljs.core.Var);
});
/**
 * Returns a Symbol with the given namespace and name. Arity-1 works
 *   on strings, keywords, and vars.
 */
cljs.core.symbol = (function cljs$core$symbol(var_args){
var G__6136 = arguments.length;
switch (G__6136) {
case 1:
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1 = (function (name){
while(true){
if((name instanceof cljs.core.Symbol)){
return name;
} else {
if(typeof name === 'string'){
var idx = name.indexOf("/");
if((idx < (1))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(null,name);
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(name.substring((0),idx),name.substring((idx + (1)),name.length));
}
} else {
if(cljs.core.var_QMARK_(name)){
return name.sym;
} else {
if((name instanceof cljs.core.Keyword)){
var G__8051 = name.fqn;
name = G__8051;
continue;
} else {
throw (new Error("no conversion to symbol"));

}
}
}
}
break;
}
}));

(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2 = (function (ns,name){
var sym_str = (((!((ns == null))))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):name);
return (new cljs.core.Symbol(ns,name,sym_str,null,null));
}));

(cljs.core.symbol.cljs$lang$maxFixedArity = 2);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.Fn}
 * @implements {cljs.core.IDeref}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.Var = (function (val,sym,_meta){
this.val = val;
this.sym = sym;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 6717441;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.Var.prototype.isMacro = (function (){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).cljs$lang$macro;
}));

(cljs.core.Var.prototype.toString = (function (){
var self__ = this;
var _ = this;
return ["#'",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.sym)].join('');
}));

(cljs.core.Var.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
}));

(cljs.core.Var.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__._meta;
}));

(cljs.core.Var.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Var(self__.val,self__.sym,new_meta));
}));

(cljs.core.Var.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
if((other instanceof cljs.core.Var)){
var G__6138 = this$__$1.sym;
var G__6139 = other.sym;
return (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2 ? cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(G__6138,G__6139) : cljs.core._EQ_.call(null,G__6138,G__6139));
} else {
return false;
}
}));

(cljs.core.Var.prototype.cljs$core$IHash$_hash$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.hash_symbol(self__.sym);
}));

(cljs.core.Var.prototype.cljs$core$Fn$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Var.prototype.call = (function (unused__10318__auto__){
var self__ = this;
var self__ = this;
var G__6140 = (arguments.length - (1));
switch (G__6140) {
case (0):
return self__.cljs$core$IFn$_invoke$arity$0();

break;
case (1):
return self__.cljs$core$IFn$_invoke$arity$1((arguments[(1)]));

break;
case (2):
return self__.cljs$core$IFn$_invoke$arity$2((arguments[(1)]),(arguments[(2)]));

break;
case (3):
return self__.cljs$core$IFn$_invoke$arity$3((arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case (4):
return self__.cljs$core$IFn$_invoke$arity$4((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case (5):
return self__.cljs$core$IFn$_invoke$arity$5((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case (6):
return self__.cljs$core$IFn$_invoke$arity$6((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case (7):
return self__.cljs$core$IFn$_invoke$arity$7((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
case (8):
return self__.cljs$core$IFn$_invoke$arity$8((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case (9):
return self__.cljs$core$IFn$_invoke$arity$9((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
case (10):
return self__.cljs$core$IFn$_invoke$arity$10((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]));

break;
case (11):
return self__.cljs$core$IFn$_invoke$arity$11((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]));

break;
case (12):
return self__.cljs$core$IFn$_invoke$arity$12((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]));

break;
case (13):
return self__.cljs$core$IFn$_invoke$arity$13((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]));

break;
case (14):
return self__.cljs$core$IFn$_invoke$arity$14((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]));

break;
case (15):
return self__.cljs$core$IFn$_invoke$arity$15((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]));

break;
case (16):
return self__.cljs$core$IFn$_invoke$arity$16((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]));

break;
case (17):
return self__.cljs$core$IFn$_invoke$arity$17((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]));

break;
case (18):
return self__.cljs$core$IFn$_invoke$arity$18((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]));

break;
case (19):
return self__.cljs$core$IFn$_invoke$arity$19((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]));

break;
case (20):
return self__.cljs$core$IFn$_invoke$arity$20((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]));

break;
case (21):
return self__.cljs$core$IFn$_invoke$arity$21((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]),(arguments[(21)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (1)))].join('')));

}
}));

(cljs.core.Var.prototype.apply = (function (self__,args6137){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args6137)));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$0 = (function (){
var self__ = this;
var _ = this;
var fexpr__6141 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__6141.cljs$core$IFn$_invoke$arity$0 ? fexpr__6141.cljs$core$IFn$_invoke$arity$0() : fexpr__6141.call(null));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$1 = (function (a){
var self__ = this;
var _ = this;
var fexpr__6142 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__6142.cljs$core$IFn$_invoke$arity$1 ? fexpr__6142.cljs$core$IFn$_invoke$arity$1(a) : fexpr__6142.call(null,a));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
var self__ = this;
var _ = this;
var fexpr__6143 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__6143.cljs$core$IFn$_invoke$arity$2 ? fexpr__6143.cljs$core$IFn$_invoke$arity$2(a,b) : fexpr__6143.call(null,a,b));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
var self__ = this;
var _ = this;
var fexpr__6144 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__6144.cljs$core$IFn$_invoke$arity$3 ? fexpr__6144.cljs$core$IFn$_invoke$arity$3(a,b,c) : fexpr__6144.call(null,a,b,c));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
var self__ = this;
var _ = this;
var fexpr__6145 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__6145.cljs$core$IFn$_invoke$arity$4 ? fexpr__6145.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : fexpr__6145.call(null,a,b,c,d));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
var self__ = this;
var _ = this;
var fexpr__6146 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__6146.cljs$core$IFn$_invoke$arity$5 ? fexpr__6146.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : fexpr__6146.call(null,a,b,c,d,e));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$6 = (function (a,b,c,d,e,f){
var self__ = this;
var _ = this;
var fexpr__6147 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__6147.cljs$core$IFn$_invoke$arity$6 ? fexpr__6147.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : fexpr__6147.call(null,a,b,c,d,e,f));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$7 = (function (a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
var fexpr__6148 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__6148.cljs$core$IFn$_invoke$arity$7 ? fexpr__6148.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : fexpr__6148.call(null,a,b,c,d,e,f,g));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$8 = (function (a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
var fexpr__6149 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__6149.cljs$core$IFn$_invoke$arity$8 ? fexpr__6149.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : fexpr__6149.call(null,a,b,c,d,e,f,g,h));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$9 = (function (a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
var fexpr__6150 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__6150.cljs$core$IFn$_invoke$arity$9 ? fexpr__6150.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : fexpr__6150.call(null,a,b,c,d,e,f,g,h,i));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$10 = (function (a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
var fexpr__6151 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__6151.cljs$core$IFn$_invoke$arity$10 ? fexpr__6151.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : fexpr__6151.call(null,a,b,c,d,e,f,g,h,i,j));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$11 = (function (a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
var fexpr__6152 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__6152.cljs$core$IFn$_invoke$arity$11 ? fexpr__6152.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : fexpr__6152.call(null,a,b,c,d,e,f,g,h,i,j,k));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$12 = (function (a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
var fexpr__6153 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__6153.cljs$core$IFn$_invoke$arity$12 ? fexpr__6153.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : fexpr__6153.call(null,a,b,c,d,e,f,g,h,i,j,k,l));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$13 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
var fexpr__6154 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__6154.cljs$core$IFn$_invoke$arity$13 ? fexpr__6154.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : fexpr__6154.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$14 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
var fexpr__6155 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__6155.cljs$core$IFn$_invoke$arity$14 ? fexpr__6155.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : fexpr__6155.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$15 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
var fexpr__6156 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__6156.cljs$core$IFn$_invoke$arity$15 ? fexpr__6156.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : fexpr__6156.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$16 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
var fexpr__6157 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__6157.cljs$core$IFn$_invoke$arity$16 ? fexpr__6157.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : fexpr__6157.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$17 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
var fexpr__6158 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__6158.cljs$core$IFn$_invoke$arity$17 ? fexpr__6158.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : fexpr__6158.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$18 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
var fexpr__6159 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__6159.cljs$core$IFn$_invoke$arity$18 ? fexpr__6159.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : fexpr__6159.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$19 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
var fexpr__6160 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__6160.cljs$core$IFn$_invoke$arity$19 ? fexpr__6160.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : fexpr__6160.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$20 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
var fexpr__6161 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__6161.cljs$core$IFn$_invoke$arity$20 ? fexpr__6161.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : fexpr__6161.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$21 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
var G__6162 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
var G__6163 = a;
var G__6164 = b;
var G__6165 = c;
var G__6166 = d;
var G__6167 = e;
var G__6168 = f;
var G__6169 = g;
var G__6170 = h;
var G__6171 = i;
var G__6172 = j;
var G__6173 = k;
var G__6174 = l;
var G__6175 = m;
var G__6176 = n;
var G__6177 = o;
var G__6178 = p;
var G__6179 = q;
var G__6180 = r;
var G__6181 = s;
var G__6182 = t;
var G__6183 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$21 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$21(G__6162,G__6163,G__6164,G__6165,G__6166,G__6167,G__6168,G__6169,G__6170,G__6171,G__6172,G__6173,G__6174,G__6175,G__6176,G__6177,G__6178,G__6179,G__6180,G__6181, new cljs.core.IndexedSeq([G__6182,G__6183],0,null)) : cljs.core.apply.call(null,G__6162,G__6163,G__6164,G__6165,G__6166,G__6167,G__6168,G__6169,G__6170,G__6171,G__6172,G__6173,G__6174,G__6175,G__6176,G__6177,G__6178,G__6179,G__6180,G__6181,G__6182,G__6183));
}));

(cljs.core.Var.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"sym","sym",195671222,null),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
}));

(cljs.core.Var.cljs$lang$type = true);

(cljs.core.Var.cljs$lang$ctorStr = "cljs.core/Var");

(cljs.core.Var.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/Var");
}));

/**
 * Positional factory function for cljs.core/Var.
 */
cljs.core.__GT_Var = (function cljs$core$__GT_Var(val,sym,_meta){
return (new cljs.core.Var(val,sym,_meta));
});



/**
 * Return true if x implements IIterable protocol.
 */
cljs.core.iterable_QMARK_ = (function cljs$core$iterable_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition1$ & (131072))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IIterable$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition1$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,x);
}
});
/**
 * Return true if x has a JavaScript iterator property
 */
cljs.core.js_iterable_QMARK_ = (function cljs$core$js_iterable_QMARK_(x){
return (((!((x == null)))) && ((!((x[cljs.core.ITER_SYMBOL] == null)))));
});
/**
 * Clone the supplied value which must implement ICloneable.
 */
cljs.core.clone = (function cljs$core$clone(value){
return cljs.core._clone(value);
});
/**
 * Return true if x implements ICloneable protocol.
 */
cljs.core.cloneable_QMARK_ = (function cljs$core$cloneable_QMARK_(value){
if((!((value == null)))){
if((((value.cljs$lang$protocol_mask$partition1$ & (8192))) || ((cljs.core.PROTOCOL_SENTINEL === value.cljs$core$ICloneable$)))){
return true;
} else {
if((!value.cljs$lang$protocol_mask$partition1$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,value);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,value);
}
});
/**
 * Returns a seq on the collection. If the collection is
 *   empty, returns nil.  (seq nil) returns nil. seq also works on
 *   Strings.
 */
cljs.core.seq = (function cljs$core$seq(coll){
if((coll == null)){
return null;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeqable$))))?true:false):false)){
return coll.cljs$core$ISeqable$_seq$arity$1(null);
} else {
if(cljs.core.array_QMARK_(coll)){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0),null));
}
} else {
if(typeof coll === 'string'){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0),null));
}
} else {
if(cljs.core.js_iterable_QMARK_(coll)){
var G__6187 = cljs.core.goog$module$goog$object.get(coll,cljs.core.ITER_SYMBOL).call(coll);
return (cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1(G__6187) : cljs.core.es6_iterator_seq.call(null,G__6187));
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,coll)){
return cljs.core._seq(coll);
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll)," is not ISeqable"].join('')));

}
}
}
}
}
}
});
/**
 * Returns the first item in the collection. Calls seq on its
 *   argument. If coll is nil, returns nil.
 */
cljs.core.first = (function cljs$core$first(coll){
if((coll == null)){
return null;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false)){
return coll.cljs$core$ISeq$_first$arity$1(null);
} else {
var s = cljs.core.seq(coll);
if((s == null)){
return null;
} else {
return cljs.core._first(s);
}
}
}
});
/**
 * Returns a possibly empty seq of the items after the first. Calls seq on its
 *   argument.
 */
cljs.core.rest = (function cljs$core$rest(coll){
if((!((coll == null)))){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false)){
return coll.cljs$core$ISeq$_rest$arity$1(null);
} else {
var s = cljs.core.seq(coll);
if(s){
return s.cljs$core$ISeq$_rest$arity$1(null);
} else {
return cljs.core.List.EMPTY;
}
}
} else {
return cljs.core.List.EMPTY;
}
});
/**
 * Returns a seq of the items after the first. Calls seq on its
 *   argument.  If there are no more items, returns nil
 */
cljs.core.next = (function cljs$core$next(coll){
if((coll == null)){
return null;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$INext$))))?true:false):false)){
return coll.cljs$core$INext$_next$arity$1(null);
} else {
return cljs.core.seq(cljs.core.rest(coll));
}
}
});
/**
 * Equality. Returns true if x equals y, false if not. Compares
 *   numbers and collections in a type-independent manner.  Clojure's immutable data
 *   structures define -equiv (and thus =) as a value, not an identity,
 *   comparison.
 */
cljs.core._EQ_ = (function cljs$core$_EQ_(var_args){
var G__6195 = arguments.length;
switch (G__6195) {
case 1:
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8071 = arguments.length;
var i__5727__auto___8072 = (0);
while(true){
if((i__5727__auto___8072 < len__5726__auto___8071)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8072]));

var G__8073 = (i__5727__auto___8072 + (1));
i__5727__auto___8072 = G__8073;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
}));

(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
if((x == null)){
return (y == null);
} else {
return (((x === y)) || (cljs.core._equiv(x,y)));
}
}));

(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
if(cljs.core.next(more)){
var G__8074 = y;
var G__8075 = cljs.core.first(more);
var G__8076 = cljs.core.next(more);
x = G__8074;
y = G__8075;
more = G__8076;
continue;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(y,cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._EQ_.cljs$lang$applyTo = (function (seq6192){
var G__6193 = cljs.core.first(seq6192);
var seq6192__$1 = cljs.core.next(seq6192);
var G__6194 = cljs.core.first(seq6192__$1);
var seq6192__$2 = cljs.core.next(seq6192__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6193,G__6194,seq6192__$2);
}));

(cljs.core._EQ_.cljs$lang$maxFixedArity = (2));


/**
* @constructor
*/
cljs.core.ES6Iterator = (function (s){
this.s = s;
});
(cljs.core.ES6Iterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if((!((self__.s == null)))){
var x = cljs.core.first(self__.s);
(self__.s = cljs.core.next(self__.s));

return ({"value": x, "done": false});
} else {
return ({"value": null, "done": true});
}
}));

(cljs.core.ES6Iterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ES6Iterator.cljs$lang$type = true);

(cljs.core.ES6Iterator.cljs$lang$ctorStr = "cljs.core/ES6Iterator");

(cljs.core.ES6Iterator.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/ES6Iterator");
}));

/**
 * Positional factory function for cljs.core/ES6Iterator.
 */
cljs.core.__GT_ES6Iterator = (function cljs$core$__GT_ES6Iterator(s){
return (new cljs.core.ES6Iterator(s));
});

/**
 * Return a ES2015+ compatible iterator for coll.
 */
cljs.core.es6_iterator = (function cljs$core$es6_iterator(coll){
return (new cljs.core.ES6Iterator(cljs.core.seq(coll)));
});

/**
* @constructor
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
*/
cljs.core.ES6IteratorSeq = (function (value,iter,_rest){
this.value = value;
this.iter = iter;
this._rest = _rest;
this.cljs$lang$protocol_mask$partition0$ = 8388672;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
}));

(cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.value;
}));

(cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if((self__._rest == null)){
(self__._rest = (cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1(self__.iter) : cljs.core.es6_iterator_seq.call(null,self__.iter)));
} else {
}

return self__._rest;
}));

(cljs.core.ES6IteratorSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"value","value",1946509744,null),new cljs.core.Symbol(null,"iter","iter",-1346195486,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_rest","_rest",-2100466189,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ES6IteratorSeq.cljs$lang$type = true);

(cljs.core.ES6IteratorSeq.cljs$lang$ctorStr = "cljs.core/ES6IteratorSeq");

(cljs.core.ES6IteratorSeq.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/ES6IteratorSeq");
}));

/**
 * Positional factory function for cljs.core/ES6IteratorSeq.
 */
cljs.core.__GT_ES6IteratorSeq = (function cljs$core$__GT_ES6IteratorSeq(value,iter,_rest){
return (new cljs.core.ES6IteratorSeq(value,iter,_rest));
});

/**
 * Given an ES2015+ compatible iterator return a seq.
 */
cljs.core.es6_iterator_seq = (function cljs$core$es6_iterator_seq(iter){
var v = iter.next();
if(cljs.core.truth_(v.done)){
return null;
} else {
return (new cljs.core.ES6IteratorSeq(v.value,iter,null));
}
});
/**
 * Mix final collection hash for ordered or unordered collections.
 * hash-basis is the combined collection hash, count is the number
 * of elements included in the basis. Note this is the hash code
 * consistent with =, different from .hashCode.
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.mix_collection_hash = (function cljs$core$mix_collection_hash(hash_basis,count){
var h1 = cljs.core.m3_seed;
var k1 = cljs.core.m3_mix_K1(hash_basis);
var h1__$1 = cljs.core.m3_mix_H1(h1,k1);
return cljs.core.m3_fmix(h1__$1,count);
});
/**
 * Returns the hash code, consistent with =, for an external ordered
 * collection implementing Iterable.
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.hash_ordered_coll = (function cljs$core$hash_ordered_coll(coll){
var n = (0);
var hash_code = (1);
var coll__$1 = cljs.core.seq(coll);
while(true){
if((!((coll__$1 == null)))){
var G__8078 = (n + (1));
var G__8079 = ((cljs.core.imul((31),hash_code) + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__8080 = cljs.core.next(coll__$1);
n = G__8078;
hash_code = G__8079;
coll__$1 = G__8080;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_ordered_hash = cljs.core.mix_collection_hash((1),(0));
/**
 * Returns the hash code, consistent with =, for an external unordered
 * collection implementing Iterable. For maps, the iterator should
 * return map entries whose hash is computed as
 *   (hash-ordered-coll [k v]).
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.hash_unordered_coll = (function cljs$core$hash_unordered_coll(coll){
var n = (0);
var hash_code = (0);
var coll__$1 = cljs.core.seq(coll);
while(true){
if((!((coll__$1 == null)))){
var G__8081 = (n + (1));
var G__8082 = ((hash_code + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__8083 = cljs.core.next(coll__$1);
n = G__8081;
hash_code = G__8082;
coll__$1 = G__8083;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_unordered_hash = cljs.core.mix_collection_hash((0),(0));


(cljs.core.ICounted["null"] = true);

(cljs.core._count["null"] = (function (_){
return (0);
}));
(Date.prototype.cljs$core$IEquiv$ = cljs.core.PROTOCOL_SENTINEL);

(Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var o__$1 = this;
return (((other instanceof Date)) && ((o__$1.valueOf() === other.valueOf())));
}));

(Date.prototype.cljs$core$IComparable$ = cljs.core.PROTOCOL_SENTINEL);

(Date.prototype.cljs$core$IComparable$_compare$arity$2 = (function (this$,other){
var this$__$1 = this;
if((other instanceof Date)){
return cljs.core.goog$module$goog$array.defaultCompare(this$__$1.valueOf(),other.valueOf());
} else {
throw (new Error(["Cannot compare ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(this$__$1)," to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(other)].join('')));
}
}));

/**
 * @interface
 */
cljs.core.Inst = function(){};

var cljs$core$Inst$inst_ms_STAR_$dyn_8087 = (function (inst){
var x__5350__auto__ = (((inst == null))?null:inst);
var m__5351__auto__ = (cljs.core.inst_ms_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(inst) : m__5351__auto__.call(null,inst));
} else {
var m__5349__auto__ = (cljs.core.inst_ms_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(inst) : m__5349__auto__.call(null,inst));
} else {
throw cljs.core.missing_protocol("Inst.inst-ms*",inst);
}
}
});
cljs.core.inst_ms_STAR_ = (function cljs$core$inst_ms_STAR_(inst){
if((((!((inst == null)))) && ((!((inst.cljs$core$Inst$inst_ms_STAR_$arity$1 == null)))))){
return inst.cljs$core$Inst$inst_ms_STAR_$arity$1(inst);
} else {
return cljs$core$Inst$inst_ms_STAR_$dyn_8087(inst);
}
});

(Date.prototype.cljs$core$Inst$ = cljs.core.PROTOCOL_SENTINEL);

(Date.prototype.cljs$core$Inst$inst_ms_STAR_$arity$1 = (function (inst){
var inst__$1 = this;
return inst__$1.getTime();
}));
/**
 * Return the number of milliseconds since January 1, 1970, 00:00:00 GMT
 */
cljs.core.inst_ms = (function cljs$core$inst_ms(inst){
return cljs.core.inst_ms_STAR_(inst);
});
/**
 * Return true if x satisfies Inst
 */
cljs.core.inst_QMARK_ = (function cljs$core$inst_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$Inst$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.Inst,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.Inst,x);
}
});
(cljs.core.IEquiv["number"] = true);

(cljs.core._equiv["number"] = (function (x,o){
return (x === o);
}));
(cljs.core.Fn["function"] = true);

(cljs.core.IMeta["function"] = true);

(cljs.core._meta["function"] = (function (_){
return null;
}));
(cljs.core.IHash["_"] = true);

(cljs.core._hash["_"] = (function (o){
return goog.getUid(o);
}));
/**
 * Returns a number one greater than num.
 */
cljs.core.inc = (function cljs$core$inc(x){
return (x + (1));
});

/**
* @constructor
 * @implements {cljs.core.IDeref}
*/
cljs.core.Reduced = (function (val){
this.val = val;
this.cljs$lang$protocol_mask$partition0$ = 32768;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = (function (o){
var self__ = this;
var o__$1 = this;
return self__.val;
}));

(cljs.core.Reduced.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null)], null);
}));

(cljs.core.Reduced.cljs$lang$type = true);

(cljs.core.Reduced.cljs$lang$ctorStr = "cljs.core/Reduced");

(cljs.core.Reduced.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/Reduced");
}));

/**
 * Positional factory function for cljs.core/Reduced.
 */
cljs.core.__GT_Reduced = (function cljs$core$__GT_Reduced(val){
return (new cljs.core.Reduced(val));
});

/**
 * Wraps x in a way such that a reduce will terminate with the value x
 */
cljs.core.reduced = (function cljs$core$reduced(x){
return (new cljs.core.Reduced(x));
});
/**
 * Returns true if x is the result of a call to reduced
 */
cljs.core.reduced_QMARK_ = (function cljs$core$reduced_QMARK_(r){
return (r instanceof cljs.core.Reduced);
});
/**
 * If x is already reduced?, returns it, else returns (reduced x)
 */
cljs.core.ensure_reduced = (function cljs$core$ensure_reduced(x){
if(cljs.core.reduced_QMARK_(x)){
return x;
} else {
return cljs.core.reduced(x);
}
});
/**
 * If x is reduced?, returns (deref x), else returns x
 */
cljs.core.unreduced = (function cljs$core$unreduced(x){
if(cljs.core.reduced_QMARK_(x)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(x) : cljs.core.deref.call(null,x));
} else {
return x;
}
});
/**
 * Also reader macro: @var/@atom/@delay. Returns the
 * most-recently-committed value of ref. When applied to a var
 * or atom, returns its current state. When applied to a delay, forces
 * it if not already forced. See also - realized?.
 */
cljs.core.deref = (function cljs$core$deref(o){
return cljs.core._deref(o);
});
/**
 * Accepts any collection which satisfies the ICount and IIndexed protocols and
 * reduces them without incurring seq initialization
 */
cljs.core.ci_reduce = (function cljs$core$ci_reduce(var_args){
var G__6198 = arguments.length;
switch (G__6198) {
case 2:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2 = (function (cicoll,f){
var cnt = cicoll.cljs$core$ICounted$_count$arity$1(null);
if((cnt === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var val = cicoll.cljs$core$IIndexed$_nth$arity$2(null,(0));
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__6199 = val;
var G__6200 = cicoll.cljs$core$IIndexed$_nth$arity$2(null,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6199,G__6200) : f.call(null,G__6199,G__6200));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__8092 = nval;
var G__8093 = (n + (1));
val = G__8092;
n = G__8093;
continue;
}
} else {
return val;
}
break;
}
}
}));

(cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3 = (function (cicoll,f,val){
var cnt = cicoll.cljs$core$ICounted$_count$arity$1(null);
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__6201 = val__$1;
var G__6202 = cicoll.cljs$core$IIndexed$_nth$arity$2(null,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6201,G__6202) : f.call(null,G__6201,G__6202));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__8094 = nval;
var G__8095 = (n + (1));
val__$1 = G__8094;
n = G__8095;
continue;
}
} else {
return val__$1;
}
break;
}
}));

(cljs.core.ci_reduce.cljs$lang$maxFixedArity = 3);

cljs.core.array_reduce = (function cljs$core$array_reduce(var_args){
var G__6204 = arguments.length;
switch (G__6204) {
case 2:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2 = (function (arr,f){
var cnt = arr.length;
if((arr.length === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var val = (arr[(0)]);
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__6205 = val;
var G__6206 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6205,G__6206) : f.call(null,G__6205,G__6206));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__8097 = nval;
var G__8098 = (n + (1));
val = G__8097;
n = G__8098;
continue;
}
} else {
return val;
}
break;
}
}
}));

(cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3 = (function (arr,f,val){
var cnt = arr.length;
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__6207 = val__$1;
var G__6208 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6207,G__6208) : f.call(null,G__6207,G__6208));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__8099 = nval;
var G__8100 = (n + (1));
val__$1 = G__8099;
n = G__8100;
continue;
}
} else {
return val__$1;
}
break;
}
}));

(cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4 = (function (arr,f,val,idx){
var cnt = arr.length;
var val__$1 = val;
var n = idx;
while(true){
if((n < cnt)){
var nval = (function (){var G__6209 = val__$1;
var G__6210 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6209,G__6210) : f.call(null,G__6209,G__6210));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__8101 = nval;
var G__8102 = (n + (1));
val__$1 = G__8101;
n = G__8102;
continue;
}
} else {
return val__$1;
}
break;
}
}));

(cljs.core.array_reduce.cljs$lang$maxFixedArity = 4);







/**
 * Returns true if coll implements count in constant time
 */
cljs.core.counted_QMARK_ = (function cljs$core$counted_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (2))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ICounted$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,x);
}
});
/**
 * Returns true if coll implements nth in constant time
 */
cljs.core.indexed_QMARK_ = (function cljs$core$indexed_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (16))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IIndexed$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,x);
}
});
cljs.core._indexOf = (function cljs$core$_indexOf(var_args){
var G__6214 = arguments.length;
switch (G__6214) {
case 2:
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._indexOf.cljs$core$IFn$_invoke$arity$2 = (function (coll,x){
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
}));

(cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3 = (function (coll,x,start){
var len = (cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null,coll));
if((start >= len)){
return (-1);
} else {
var idx = (((start > (0)))?start:(((start < (0)))?(function (){var x__5087__auto__ = (0);
var y__5088__auto__ = (start + len);
return ((x__5087__auto__ > y__5088__auto__) ? x__5087__auto__ : y__5088__auto__);
})():start
));
while(true){
if((idx < len)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((cljs.core.nth.cljs$core$IFn$_invoke$arity$2 ? cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll,idx) : cljs.core.nth.call(null,coll,idx)),x)){
return idx;
} else {
var G__8106 = (idx + (1));
idx = G__8106;
continue;
}
} else {
return (-1);
}
break;
}
}
}));

(cljs.core._indexOf.cljs$lang$maxFixedArity = 3);

cljs.core._lastIndexOf = (function cljs$core$_lastIndexOf(var_args){
var G__6216 = arguments.length;
switch (G__6216) {
case 2:
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$2 = (function (coll,x){
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null,coll)));
}));

(cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3 = (function (coll,x,start){
var len = (cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null,coll));
if((len === (0))){
return (-1);
} else {
var idx = (((start > (0)))?(function (){var x__5090__auto__ = (len - (1));
var y__5091__auto__ = start;
return ((x__5090__auto__ < y__5091__auto__) ? x__5090__auto__ : y__5091__auto__);
})():(((start < (0)))?(len + start):start
));
while(true){
if((idx >= (0))){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((cljs.core.nth.cljs$core$IFn$_invoke$arity$2 ? cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll,idx) : cljs.core.nth.call(null,coll,idx)),x)){
return idx;
} else {
var G__8110 = (idx - (1));
idx = G__8110;
continue;
}
} else {
return (-1);
}
break;
}
}
}));

(cljs.core._lastIndexOf.cljs$lang$maxFixedArity = 3);


/**
* @constructor
*/
cljs.core.IndexedSeqIterator = (function (arr,i){
this.arr = arr;
this.i = i;
});
(cljs.core.IndexedSeqIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
}));

(cljs.core.IndexedSeqIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
(self__.i = (self__.i + (1)));

return ret;
}));

(cljs.core.IndexedSeqIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.IndexedSeqIterator.cljs$lang$type = true);

(cljs.core.IndexedSeqIterator.cljs$lang$ctorStr = "cljs.core/IndexedSeqIterator");

(cljs.core.IndexedSeqIterator.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/IndexedSeqIterator");
}));

/**
 * Positional factory function for cljs.core/IndexedSeqIterator.
 */
cljs.core.__GT_IndexedSeqIterator = (function cljs$core$__GT_IndexedSeqIterator(arr,i){
return (new cljs.core.IndexedSeqIterator(arr,i));
});


/**
* @constructor
 * @implements {cljs.core.IDrop}
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.IndexedSeq = (function (arr,i,meta){
this.arr = arr;
this.i = i;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 166592766;
this.cljs$lang$protocol_mask$partition1$ = 401408;
});
(cljs.core.IndexedSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.IndexedSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.IndexedSeq.prototype.indexOf = (function() {
var G__8111 = null;
var G__8111__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__8111__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__8111 = function(x,start){
switch(arguments.length){
case 1:
return G__8111__1.call(this,x);
case 2:
return G__8111__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8111.cljs$core$IFn$_invoke$arity$1 = G__8111__1;
G__8111.cljs$core$IFn$_invoke$arity$2 = G__8111__2;
return G__8111;
})()
);

(cljs.core.IndexedSeq.prototype.lastIndexOf = (function() {
var G__8112 = null;
var G__8112__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null,coll)));
});
var G__8112__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__8112 = function(x,start){
switch(arguments.length){
case 1:
return G__8112__1.call(this,x);
case 2:
return G__8112__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8112.cljs$core$IFn$_invoke$arity$1 = G__8112__1;
G__8112.cljs$core$IFn$_invoke$arity$2 = G__8112__2;
return G__8112;
})()
);

(cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if(((((0) <= i__$1)) && ((i__$1 < self__.arr.length)))){
return (self__.arr[i__$1]);
} else {
throw (new Error("Index out of bounds"));
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if(((((0) <= i__$1)) && ((i__$1 < self__.arr.length)))){
return (self__.arr[i__$1]);
} else {
return not_found;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.IndexedSeqIterator(self__.arr,self__.i));
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.IndexedSeq(self__.arr,self__.i,self__.meta));
}));

(cljs.core.IndexedSeq.prototype.cljs$core$INext$_next$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1)),null));
} else {
return null;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var x__5087__auto__ = (0);
var y__5088__auto__ = (self__.arr.length - self__.i);
return ((x__5087__auto__ > y__5088__auto__) ? x__5087__auto__ : y__5088__auto__);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var c = coll__$1.cljs$core$ICounted$_count$arity$1(null);
if((c > (0))){
return (new cljs.core.RSeq(coll__$1,(c - (1)),null));
} else {
return null;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return (cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(coll__$1,other) : cljs.core.equiv_sequential.call(null,coll__$1,other));
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.i]),(self__.i + (1)));
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.i);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.arr[self__.i]);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1)),null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.i < self__.arr.length)){
return this$__$1;
} else {
return null;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.IndexedSeq(self__.arr,self__.i,new_meta));
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(o,coll__$1) : cljs.core.cons.call(null,o,coll__$1));
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IDrop$_drop$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if((n > (0))){
if(((self__.i + n) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + n),null));
} else {
return null;
}
} else {
return coll__$1;
}
}));

(cljs.core.IndexedSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null);
}));

(cljs.core.IndexedSeq.cljs$lang$type = true);

(cljs.core.IndexedSeq.cljs$lang$ctorStr = "cljs.core/IndexedSeq");

(cljs.core.IndexedSeq.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/IndexedSeq");
}));

/**
 * Positional factory function for cljs.core/IndexedSeq.
 */
cljs.core.__GT_IndexedSeq = (function cljs$core$__GT_IndexedSeq(arr,i,meta){
return (new cljs.core.IndexedSeq(arr,i,meta));
});

(cljs.core.IndexedSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));
/**
 * Create seq from a primitive JavaScript Array-like.
 */
cljs.core.prim_seq = (function cljs$core$prim_seq(var_args){
var G__6218 = arguments.length;
switch (G__6218) {
case 1:
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1 = (function (prim){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(prim,(0));
}));

(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2 = (function (prim,i){
if((i < prim.length)){
return (new cljs.core.IndexedSeq(prim,i,null));
} else {
return null;
}
}));

(cljs.core.prim_seq.cljs$lang$maxFixedArity = 2);

/**
 * Create a seq from a JavaScript array.
 */
cljs.core.array_seq = (function cljs$core$array_seq(var_args){
var G__6220 = arguments.length;
switch (G__6220) {
case 1:
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1 = (function (array){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,(0));
}));

(cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2 = (function (array,i){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,i);
}));

(cljs.core.array_seq.cljs$lang$maxFixedArity = 2);



/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.RSeq = (function (ci,i,meta){
this.ci = ci;
this.i = i;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
(cljs.core.RSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.RSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.RSeq.prototype.indexOf = (function() {
var G__8117 = null;
var G__8117__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__8117__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__8117 = function(x,start){
switch(arguments.length){
case 1:
return G__8117__1.call(this,x);
case 2:
return G__8117__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8117.cljs$core$IFn$_invoke$arity$1 = G__8117__1;
G__8117.cljs$core$IFn$_invoke$arity$2 = G__8117__2;
return G__8117;
})()
);

(cljs.core.RSeq.prototype.lastIndexOf = (function() {
var G__8118 = null;
var G__8118__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null,coll)));
});
var G__8118__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__8118 = function(x,start){
switch(arguments.length){
case 1:
return G__8118__1.call(this,x);
case 2:
return G__8118__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8118.cljs$core$IFn$_invoke$arity$1 = G__8118__1;
G__8118.cljs$core$IFn$_invoke$arity$2 = G__8118__2;
return G__8118;
})()
);

(cljs.core.RSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.RSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.RSeq(self__.ci,self__.i,self__.meta));
}));

(cljs.core.RSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return null;
}
}));

(cljs.core.RSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.i + (1));
}));

(cljs.core.RSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
}));

(cljs.core.RSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return (cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(coll__$1,other) : cljs.core.equiv_sequential.call(null,coll__$1,other));
}));

(cljs.core.RSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (col,f){
var self__ = this;
var col__$1 = this;
return (cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,col__$1) : cljs.core.seq_reduce.call(null,f,col__$1));
}));

(cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (col,f,start){
var self__ = this;
var col__$1 = this;
return (cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,col__$1) : cljs.core.seq_reduce.call(null,f,start,col__$1));
}));

(cljs.core.RSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth(self__.ci,self__.i);
}));

(cljs.core.RSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.RSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.RSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.RSeq(self__.ci,self__.i,new_meta));
}
}));

(cljs.core.RSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(o,coll__$1) : cljs.core.cons.call(null,o,coll__$1));
}));

(cljs.core.RSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ci","ci",2049808339,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null);
}));

(cljs.core.RSeq.cljs$lang$type = true);

(cljs.core.RSeq.cljs$lang$ctorStr = "cljs.core/RSeq");

(cljs.core.RSeq.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/RSeq");
}));

/**
 * Positional factory function for cljs.core/RSeq.
 */
cljs.core.__GT_RSeq = (function cljs$core$__GT_RSeq(ci,i,meta){
return (new cljs.core.RSeq(ci,i,meta));
});

(cljs.core.RSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));
/**
 * Same as (first (next x))
 */
cljs.core.second = (function cljs$core$second(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
 * Same as (first (first x))
 */
cljs.core.ffirst = (function cljs$core$ffirst(coll){
return cljs.core.first(cljs.core.first(coll));
});
/**
 * Same as (next (first x))
 */
cljs.core.nfirst = (function cljs$core$nfirst(coll){
return cljs.core.next(cljs.core.first(coll));
});
/**
 * Same as (first (next x))
 */
cljs.core.fnext = (function cljs$core$fnext(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
 * Same as (next (next x))
 */
cljs.core.nnext = (function cljs$core$nnext(coll){
return cljs.core.next(cljs.core.next(coll));
});
/**
 * Return the last item in coll, in linear time
 */
cljs.core.last = (function cljs$core$last(s){
while(true){
var sn = cljs.core.next(s);
if((!((sn == null)))){
var G__8119 = sn;
s = G__8119;
continue;
} else {
return cljs.core.first(s);
}
break;
}
});
(cljs.core.IEquiv["_"] = true);

(cljs.core._equiv["_"] = (function (x,o){
return (x === o);
}));
/**
 * conj[oin]. Returns a new collection with the xs
 *   'added'. (conj nil item) returns (item).
 *   (conj coll) returns coll. (conj) returns [].
 *   The 'addition' may happen at different 'places' depending
 *   on the concrete type.
 */
cljs.core.conj = (function cljs$core$conj(var_args){
var G__6225 = arguments.length;
switch (G__6225) {
case 0:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8121 = arguments.length;
var i__5727__auto___8122 = (0);
while(true){
if((i__5727__auto___8122 < len__5726__auto___8121)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8122]));

var G__8123 = (i__5727__auto___8122 + (1));
i__5727__auto___8122 = G__8123;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.conj.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.PersistentVector.EMPTY;
}));

(cljs.core.conj.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
}));

(cljs.core.conj.cljs$core$IFn$_invoke$arity$2 = (function (coll,x){
if((!((coll == null)))){
return cljs.core._conj(coll,x);
} else {
return (new cljs.core.List(null,x,null,(1),null));
}
}));

(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic = (function (coll,x,xs){
while(true){
if(cljs.core.truth_(xs)){
var G__8124 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
var G__8125 = cljs.core.first(xs);
var G__8126 = cljs.core.next(xs);
coll = G__8124;
x = G__8125;
xs = G__8126;
continue;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
break;
}
}));

/** @this {Function} */
(cljs.core.conj.cljs$lang$applyTo = (function (seq6222){
var G__6223 = cljs.core.first(seq6222);
var seq6222__$1 = cljs.core.next(seq6222);
var G__6224 = cljs.core.first(seq6222__$1);
var seq6222__$2 = cljs.core.next(seq6222__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6223,G__6224,seq6222__$2);
}));

(cljs.core.conj.cljs$lang$maxFixedArity = (2));

/**
 * Returns an empty collection of the same category as coll, or nil
 */
cljs.core.empty = (function cljs$core$empty(coll){
if((coll == null)){
return null;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IEmptyableCollection$))))?true:false):false)){
return coll.cljs$core$IEmptyableCollection$_empty$arity$1(null);
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IEmptyableCollection$))))?true:(((!coll.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IEmptyableCollection,coll):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IEmptyableCollection,coll))){
return cljs.core._empty(coll);
} else {
return null;

}
}
}
});
cljs.core.accumulating_seq_count = (function cljs$core$accumulating_seq_count(coll){
var s = cljs.core.seq(coll);
var acc = (0);
while(true){
if(cljs.core.counted_QMARK_(s)){
return (acc + cljs.core._count(s));
} else {
var G__8127 = cljs.core.next(s);
var G__8128 = (acc + (1));
s = G__8127;
acc = G__8128;
continue;
}
break;
}
});
/**
 * Returns the number of items in the collection. (count nil) returns
 *   0.  Also works on strings, arrays, and Maps
 */
cljs.core.count = (function cljs$core$count(coll){
if((!((coll == null)))){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (2))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ICounted$))))?true:false):false)){
return coll.cljs$core$ICounted$_count$arity$1(null);
} else {
if(cljs.core.array_QMARK_(coll)){
return coll.length;
} else {
if(typeof coll === 'string'){
return coll.length;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeqable$))))?true:false):false)){
return cljs.core.accumulating_seq_count(coll);
} else {
return cljs.core._count(coll);

}
}
}
}
} else {
return (0);
}
});
cljs.core.linear_traversal_nth = (function cljs$core$linear_traversal_nth(var_args){
var G__6231 = arguments.length;
switch (G__6231) {
case 2:
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2 = (function (coll,n){
while(true){
if((coll == null)){
throw (new Error("Index out of bounds"));
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
throw (new Error("Index out of bounds"));
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth(coll,n);
} else {
if(cljs.core.seq(coll)){
var G__8130 = cljs.core.next(coll);
var G__8131 = (n - (1));
coll = G__8130;
n = G__8131;
continue;
} else {
throw (new Error("Index out of bounds"));

}
}
}
}
break;
}
}));

(cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3 = (function (coll,n,not_found){
while(true){
if((coll == null)){
return not_found;
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
return not_found;
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth(coll,n,not_found);
} else {
if(cljs.core.seq(coll)){
var G__8132 = cljs.core.next(coll);
var G__8133 = (n - (1));
var G__8134 = not_found;
coll = G__8132;
n = G__8133;
not_found = G__8134;
continue;
} else {
return not_found;

}
}
}
}
break;
}
}));

(cljs.core.linear_traversal_nth.cljs$lang$maxFixedArity = 3);

/**
 * Returns the value at the index. get returns nil if index out of
 *   bounds, nth throws an exception unless not-found is supplied.  nth
 *   also works for strings, arrays, regex Matchers and Lists, and,
 *   in O(n) time, for sequences.
 */
cljs.core.nth = (function cljs$core$nth(var_args){
var G__6233 = arguments.length;
switch (G__6233) {
case 2:
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.nth.cljs$core$IFn$_invoke$arity$2 = (function (coll,n){
if((!(typeof n === 'number'))){
throw (new Error("Index argument to nth must be a number"));
} else {
if((coll == null)){
return coll;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (16))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IIndexed$))))?true:false):false)){
return coll.cljs$core$IIndexed$_nth$arity$2(null,n);
} else {
if(cljs.core.array_QMARK_(coll)){
if(((((-1) < n)) && ((n < coll.length)))){
return (coll[(n | (0))]);
} else {
throw (new Error("Index out of bounds"));
}
} else {
if(typeof coll === 'string'){
if(((((-1) < n)) && ((n < coll.length)))){
return coll.charAt((n | (0)));
} else {
throw (new Error("Index out of bounds"));
}
} else {
if((function (){var or__5002__auto__ = (((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false);
if(or__5002__auto__){
return or__5002__auto__;
} else {
if((!((coll == null)))){
if((((coll.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISequential$)))){
return true;
} else {
return false;
}
} else {
return false;
}
}
})()){
if((n < (0))){
throw (new Error("Index out of bounds"));
} else {
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(coll,n);
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth(coll,n);
} else {
throw (new Error(["nth not supported on this type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
}));

(cljs.core.nth.cljs$core$IFn$_invoke$arity$3 = (function (coll,n,not_found){
if((!(typeof n === 'number'))){
throw (new Error("Index argument to nth must be a number."));
} else {
if((coll == null)){
return not_found;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (16))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IIndexed$))))?true:false):false)){
return coll.cljs$core$IIndexed$_nth$arity$3(null,n,not_found);
} else {
if(cljs.core.array_QMARK_(coll)){
if(((((-1) < n)) && ((n < coll.length)))){
return (coll[(n | (0))]);
} else {
return not_found;
}
} else {
if(typeof coll === 'string'){
if(((((-1) < n)) && ((n < coll.length)))){
return coll.charAt((n | (0)));
} else {
return not_found;
}
} else {
if((function (){var or__5002__auto__ = (((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false);
if(or__5002__auto__){
return or__5002__auto__;
} else {
if((!((coll == null)))){
if((((coll.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISequential$)))){
return true;
} else {
return false;
}
} else {
return false;
}
}
})()){
if((n < (0))){
return not_found;
} else {
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth(coll,n,not_found);
} else {
throw (new Error(["nth not supported on this type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
}));

(cljs.core.nth.cljs$lang$maxFixedArity = 3);

/**
 * Returns the nth rest of coll, coll when n is 0.
 */
cljs.core.nthrest = (function cljs$core$nthrest(coll,n){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition1$ & (262144))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IDrop$))))?true:false):false)){
if((n > (0))){
var or__5002__auto__ = coll.cljs$core$IDrop$_drop$arity$2(null,Math.ceil(n));
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.List.EMPTY;
}
} else {
return coll;
}
} else {
var n__$1 = n;
var xs = coll;
while(true){
var temp__5802__auto__ = (((n__$1 > (0))) && (cljs.core.seq(xs)));
if(temp__5802__auto__){
var xs__$1 = temp__5802__auto__;
var G__8139 = (n__$1 - (1));
var G__8140 = cljs.core.rest(xs__$1);
n__$1 = G__8139;
xs = G__8140;
continue;
} else {
return xs;
}
break;
}
}
});
/**
 * Returns the value mapped to key, not-found or nil if key not present
 *   in associative collection, set, string, array, or ILookup instance.
 */
cljs.core.get = (function cljs$core$get(var_args){
var G__6242 = arguments.length;
switch (G__6242) {
case 2:
return cljs.core.get.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.get.cljs$core$IFn$_invoke$arity$2 = (function (o,k){
if((o == null)){
return null;
} else {
if((((!((o == null))))?(((((o.cljs$lang$protocol_mask$partition0$ & (256))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$ILookup$))))?true:false):false)){
return o.cljs$core$ILookup$_lookup$arity$2(null,k);
} else {
if(cljs.core.array_QMARK_(o)){
if((((!((k == null)))) && ((k < o.length)))){
return (o[(k | (0))]);
} else {
return null;
}
} else {
if(typeof o === 'string'){
if((((!((k == null)))) && (((((-1) < k)) && ((k < o.length)))))){
return o.charAt((k | (0)));
} else {
return null;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup(o,k);
} else {
return null;

}
}
}
}
}
}));

(cljs.core.get.cljs$core$IFn$_invoke$arity$3 = (function (o,k,not_found){
if((!((o == null)))){
if((((!((o == null))))?(((((o.cljs$lang$protocol_mask$partition0$ & (256))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$ILookup$))))?true:false):false)){
return o.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
} else {
if(cljs.core.array_QMARK_(o)){
if((((!((k == null)))) && (((((-1) < k)) && ((k < o.length)))))){
return (o[(k | (0))]);
} else {
return not_found;
}
} else {
if(typeof o === 'string'){
if((((!((k == null)))) && (((((-1) < k)) && ((k < o.length)))))){
return o.charAt((k | (0)));
} else {
return not_found;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup(o,k,not_found);
} else {
return not_found;

}
}
}
}
} else {
return not_found;
}
}));

(cljs.core.get.cljs$lang$maxFixedArity = 3);



/**
 * assoc[iate]. When applied to a map, returns a new map of the
 * same (hashed/sorted) type, that contains the mapping of key(s) to
 * val(s). When applied to a vector, returns a new vector that
 * contains val at index. Note - index must be <= (count vector).
 */
cljs.core.assoc = (function cljs$core$assoc(var_args){
var G__6250 = arguments.length;
switch (G__6250) {
case 3:
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8144 = arguments.length;
var i__5727__auto___8145 = (0);
while(true){
if((i__5727__auto___8145 < len__5726__auto___8144)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8145]));

var G__8146 = (i__5727__auto___8145 + (1));
i__5727__auto___8145 = G__8146;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((3) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((3)),(0),null)):null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5752__auto__);

}
});

(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3 = (function (coll,k,v){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (512))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IAssociative$))))?true:false):false)){
return coll.cljs$core$IAssociative$_assoc$arity$3(null,k,v);
} else {
if((!((coll == null)))){
return cljs.core._assoc(coll,k,v);
} else {
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k,v]);
}
}
}));

(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic = (function (coll,k,v,kvs){
while(true){
var ret = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(coll,k,v);
if(cljs.core.truth_(kvs)){
var G__8147 = ret;
var G__8148 = cljs.core.first(kvs);
var G__8149 = cljs.core.second(kvs);
var G__8150 = cljs.core.nnext(kvs);
coll = G__8147;
k = G__8148;
v = G__8149;
kvs = G__8150;
continue;
} else {
return ret;
}
break;
}
}));

/** @this {Function} */
(cljs.core.assoc.cljs$lang$applyTo = (function (seq6246){
var G__6247 = cljs.core.first(seq6246);
var seq6246__$1 = cljs.core.next(seq6246);
var G__6248 = cljs.core.first(seq6246__$1);
var seq6246__$2 = cljs.core.next(seq6246__$1);
var G__6249 = cljs.core.first(seq6246__$2);
var seq6246__$3 = cljs.core.next(seq6246__$2);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6247,G__6248,G__6249,seq6246__$3);
}));

(cljs.core.assoc.cljs$lang$maxFixedArity = (3));

/**
 * dissoc[iate]. Returns a new map of the same (hashed/sorted) type,
 *   that does not contain a mapping for key(s).
 */
cljs.core.dissoc = (function cljs$core$dissoc(var_args){
var G__6256 = arguments.length;
switch (G__6256) {
case 1:
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8152 = arguments.length;
var i__5727__auto___8153 = (0);
while(true){
if((i__5727__auto___8153 < len__5726__auto___8152)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8153]));

var G__8154 = (i__5727__auto___8153 + (1));
i__5727__auto___8153 = G__8154;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
}));

(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2 = (function (coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._dissoc(coll,k);
}
}));

(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic = (function (coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__8159 = ret;
var G__8160 = cljs.core.first(ks);
var G__8161 = cljs.core.next(ks);
coll = G__8159;
k = G__8160;
ks = G__8161;
continue;
} else {
return ret;
}
}
break;
}
}));

/** @this {Function} */
(cljs.core.dissoc.cljs$lang$applyTo = (function (seq6253){
var G__6254 = cljs.core.first(seq6253);
var seq6253__$1 = cljs.core.next(seq6253);
var G__6255 = cljs.core.first(seq6253__$1);
var seq6253__$2 = cljs.core.next(seq6253__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6254,G__6255,seq6253__$2);
}));

(cljs.core.dissoc.cljs$lang$maxFixedArity = (2));

/**
 * Return true if f is a JavaScript function or satisfies the Fn protocol.
 */
cljs.core.fn_QMARK_ = (function cljs$core$fn_QMARK_(f){
var or__5002__auto__ = typeof f === 'function';
if(or__5002__auto__){
return or__5002__auto__;
} else {
if((!((f == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === f.cljs$core$Fn$)))){
return true;
} else {
if((!f.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,f);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,f);
}
}
});

/**
* @constructor
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.Fn}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.MetaFn = (function (afn,meta){
this.afn = afn;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 393217;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.MetaFn.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.meta;
}));

(cljs.core.MetaFn.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.MetaFn(self__.afn,new_meta));
}));

(cljs.core.MetaFn.prototype.cljs$core$Fn$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.MetaFn.prototype.call = (function (unused__10318__auto__){
var self__ = this;
var self__ = this;
var G__6259 = (arguments.length - (1));
switch (G__6259) {
case (0):
return self__.cljs$core$IFn$_invoke$arity$0();

break;
case (1):
return self__.cljs$core$IFn$_invoke$arity$1((arguments[(1)]));

break;
case (2):
return self__.cljs$core$IFn$_invoke$arity$2((arguments[(1)]),(arguments[(2)]));

break;
case (3):
return self__.cljs$core$IFn$_invoke$arity$3((arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case (4):
return self__.cljs$core$IFn$_invoke$arity$4((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case (5):
return self__.cljs$core$IFn$_invoke$arity$5((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case (6):
return self__.cljs$core$IFn$_invoke$arity$6((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case (7):
return self__.cljs$core$IFn$_invoke$arity$7((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
case (8):
return self__.cljs$core$IFn$_invoke$arity$8((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case (9):
return self__.cljs$core$IFn$_invoke$arity$9((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
case (10):
return self__.cljs$core$IFn$_invoke$arity$10((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]));

break;
case (11):
return self__.cljs$core$IFn$_invoke$arity$11((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]));

break;
case (12):
return self__.cljs$core$IFn$_invoke$arity$12((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]));

break;
case (13):
return self__.cljs$core$IFn$_invoke$arity$13((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]));

break;
case (14):
return self__.cljs$core$IFn$_invoke$arity$14((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]));

break;
case (15):
return self__.cljs$core$IFn$_invoke$arity$15((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]));

break;
case (16):
return self__.cljs$core$IFn$_invoke$arity$16((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]));

break;
case (17):
return self__.cljs$core$IFn$_invoke$arity$17((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]));

break;
case (18):
return self__.cljs$core$IFn$_invoke$arity$18((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]));

break;
case (19):
return self__.cljs$core$IFn$_invoke$arity$19((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]));

break;
case (20):
return self__.cljs$core$IFn$_invoke$arity$20((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]));

break;
case (21):
return self__.cljs$core$IFn$_invoke$arity$21((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]),(arguments[(21)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (1)))].join('')));

}
}));

(cljs.core.MetaFn.prototype.apply = (function (self__,args6258){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args6258)));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$0 = (function (){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$1 = (function (a){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(a) : self__.afn.call(null,a));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(a,b) : self__.afn.call(null,a,b));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(a,b,c) : self__.afn.call(null,a,b,c));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : self__.afn.call(null,a,b,c,d));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : self__.afn.call(null,a,b,c,d,e));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$6 = (function (a,b,c,d,e,f){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : self__.afn.call(null,a,b,c,d,e,f));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$7 = (function (a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : self__.afn.call(null,a,b,c,d,e,f,g));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$8 = (function (a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : self__.afn.call(null,a,b,c,d,e,f,g,h));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$9 = (function (a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : self__.afn.call(null,a,b,c,d,e,f,g,h,i));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$10 = (function (a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$11 = (function (a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$12 = (function (a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$13 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$14 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$15 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$16 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$17 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$18 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$19 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$20 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$21 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$21 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$21(self__.afn,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s, new cljs.core.IndexedSeq([t,rest],0,null)) : cljs.core.apply.call(null,self__.afn,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));
}));

(cljs.core.MetaFn.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null);
}));

(cljs.core.MetaFn.cljs$lang$type = true);

(cljs.core.MetaFn.cljs$lang$ctorStr = "cljs.core/MetaFn");

(cljs.core.MetaFn.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/MetaFn");
}));

/**
 * Positional factory function for cljs.core/MetaFn.
 */
cljs.core.__GT_MetaFn = (function cljs$core$__GT_MetaFn(afn,meta){
return (new cljs.core.MetaFn(afn,meta));
});

/**
 * Returns an object of the same type and value as obj, with
 *   map m as its metadata.
 */
cljs.core.with_meta = (function cljs$core$with_meta(o,meta){
if(typeof o === 'function'){
return (new cljs.core.MetaFn(o,meta));
} else {
if((o == null)){
return null;
} else {
return cljs.core._with_meta(o,meta);
}
}
});
/**
 * Returns the metadata of obj, returns nil if there is no metadata.
 */
cljs.core.meta = (function cljs$core$meta(o){
if((function (){var and__5000__auto__ = (!((o == null)));
if(and__5000__auto__){
if((!((o == null)))){
if((((o.cljs$lang$protocol_mask$partition0$ & (131072))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$IMeta$)))){
return true;
} else {
if((!o.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,o);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,o);
}
} else {
return and__5000__auto__;
}
})()){
return cljs.core._meta(o);
} else {
return null;
}
});
/**
 * For a list or queue, same as first, for a vector, same as, but much
 *   more efficient than, last. If the collection is empty, returns nil.
 */
cljs.core.peek = (function cljs$core$peek(coll){
if((coll == null)){
return null;
} else {
return cljs.core._peek(coll);
}
});
/**
 * For a list or queue, returns a new list/queue without the first
 *   item, for a vector, returns a new vector without the last item.
 *   Note - not the same as next/butlast.
 */
cljs.core.pop = (function cljs$core$pop(coll){
if((coll == null)){
return null;
} else {
return cljs.core._pop(coll);
}
});
/**
 * disj[oin]. Returns a new set of the same (hashed/sorted) type, that
 *   does not contain key(s).
 */
cljs.core.disj = (function cljs$core$disj(var_args){
var G__6265 = arguments.length;
switch (G__6265) {
case 1:
return cljs.core.disj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8179 = arguments.length;
var i__5727__auto___8180 = (0);
while(true){
if((i__5727__auto___8180 < len__5726__auto___8179)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8180]));

var G__8181 = (i__5727__auto___8180 + (1));
i__5727__auto___8180 = G__8181;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.disj.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
}));

(cljs.core.disj.cljs$core$IFn$_invoke$arity$2 = (function (coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._disjoin(coll,k);
}
}));

(cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic = (function (coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__8182 = ret;
var G__8183 = cljs.core.first(ks);
var G__8184 = cljs.core.next(ks);
coll = G__8182;
k = G__8183;
ks = G__8184;
continue;
} else {
return ret;
}
}
break;
}
}));

/** @this {Function} */
(cljs.core.disj.cljs$lang$applyTo = (function (seq6262){
var G__6263 = cljs.core.first(seq6262);
var seq6262__$1 = cljs.core.next(seq6262);
var G__6264 = cljs.core.first(seq6262__$1);
var seq6262__$2 = cljs.core.next(seq6262__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6263,G__6264,seq6262__$2);
}));

(cljs.core.disj.cljs$lang$maxFixedArity = (2));

/**
 * Returns true if coll has no items. To check the emptiness of a seq,
 *   please use the idiom (seq x) rather than (not (empty? x))
 */
cljs.core.empty_QMARK_ = (function cljs$core$empty_QMARK_(coll){
if((coll == null)){
return true;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (2))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ICounted$))))?true:(((!coll.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,coll):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,coll))){
return (cljs.core._count(coll) === (0));
} else {
return cljs.core.not(cljs.core.seq(coll));

}
}
});
/**
 * Returns true if x satisfies ICollection
 */
cljs.core.coll_QMARK_ = (function cljs$core$coll_QMARK_(x){
if((x == null)){
return false;
} else {
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (8))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ICollection$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,x);
}
}
});
/**
 * Returns true if x satisfies ISet
 */
cljs.core.set_QMARK_ = (function cljs$core$set_QMARK_(x){
if((x == null)){
return false;
} else {
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISet$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x);
}
}
});
/**
 * Returns true if coll implements IAssociative
 */
cljs.core.associative_QMARK_ = (function cljs$core$associative_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (512))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IAssociative$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,x);
}
});
/**
 * Returns true if coll implements IFind
 */
cljs.core.ifind_QMARK_ = (function cljs$core$ifind_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IFind$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IFind,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IFind,x);
}
});
/**
 * Returns true if coll satisfies ISequential
 */
cljs.core.sequential_QMARK_ = (function cljs$core$sequential_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISequential$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x);
}
});
/**
 * Returns true if coll satisfies ISorted
 */
cljs.core.sorted_QMARK_ = (function cljs$core$sorted_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (268435456))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISorted$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,x);
}
});
/**
 * Returns true if coll satisfies IReduce
 */
cljs.core.reduceable_QMARK_ = (function cljs$core$reduceable_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (524288))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IReduce$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,x);
}
});
/**
 * Return true if x satisfies IMap
 */
cljs.core.map_QMARK_ = (function cljs$core$map_QMARK_(x){
if((x == null)){
return false;
} else {
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (1024))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IMap$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x);
}
}
});
/**
 * Return true if x satisfies IRecord
 */
cljs.core.record_QMARK_ = (function cljs$core$record_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (67108864))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IRecord$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord,x);
}
});
/**
 * Return true if x satisfies IVector
 */
cljs.core.vector_QMARK_ = (function cljs$core$vector_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (16384))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IVector$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,x);
}
});

/**
 * Return true if x satisfies IChunkedSeq.
 */
cljs.core.chunked_seq_QMARK_ = (function cljs$core$chunked_seq_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition1$ & (512))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IChunkedSeq$)))){
return true;
} else {
return false;
}
} else {
return false;
}
});
/**
 * Create JavaSript object from an even number arguments representing
 *   interleaved keys and values.
 */
cljs.core.js_obj = (function cljs$core$js_obj(var_args){
var G__6280 = arguments.length;
switch (G__6280) {
case 0:
return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0();

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8189 = arguments.length;
var i__5727__auto___8190 = (0);
while(true){
if((i__5727__auto___8190 < len__5726__auto___8189)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8190]));

var G__8191 = (i__5727__auto___8190 + (1));
i__5727__auto___8190 = G__8191;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((0) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((0)),(0),null)):null);
return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(argseq__5752__auto__);

}
});

(cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0 = (function (){
return ({});
}));

(cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$2 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.goog$module$goog$object.create,keyvals) : cljs.core.apply.call(null,cljs.core.goog$module$goog$object.create,keyvals));
}));

/** @this {Function} */
(cljs.core.js_obj.cljs$lang$applyTo = (function (seq6279){
var self__5712__auto__ = this;
return self__5712__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq6279));
}));

(cljs.core.js_obj.cljs$lang$maxFixedArity = (0));

/**
 * Return the JavaScript keys for an object.
 */
cljs.core.js_keys = (function cljs$core$js_keys(obj){
return cljs.core.goog$module$goog$object.getKeys(obj);
});
/**
 * Delete a property from a JavaScript object.
 *   Returns true upon success, false otherwise.
 */
cljs.core.js_delete = (function cljs$core$js_delete(obj,key){
return delete obj[key];
});
cljs.core.array_copy = (function cljs$core$array_copy(from,i,to,j,len){
var i__$1 = i;
var j__$1 = j;
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__8197 = (i__$1 + (1));
var G__8198 = (j__$1 + (1));
var G__8199 = (len__$1 - (1));
i__$1 = G__8197;
j__$1 = G__8198;
len__$1 = G__8199;
continue;
}
break;
}
});
cljs.core.array_copy_downward = (function cljs$core$array_copy_downward(from,i,to,j,len){
var i__$1 = (i + (len - (1)));
var j__$1 = (j + (len - (1)));
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__8211 = (i__$1 - (1));
var G__8212 = (j__$1 - (1));
var G__8213 = (len__$1 - (1));
i__$1 = G__8211;
j__$1 = G__8212;
len__$1 = G__8213;
continue;
}
break;
}
});
cljs.core.lookup_sentinel = ({});
/**
 * Returns true if x is the value false, false otherwise.
 */
cljs.core.false_QMARK_ = (function cljs$core$false_QMARK_(x){
return x === false;
});
/**
 * Returns true if x is the value true, false otherwise.
 */
cljs.core.true_QMARK_ = (function cljs$core$true_QMARK_(x){
return x === true;
});
/**
 * Return true if x is a Boolean
 */
cljs.core.boolean_QMARK_ = (function cljs$core$boolean_QMARK_(x){
return ((x === true) || (x === false));
});
/**
 * Returns true if x identical to the JavaScript undefined value.
 */
cljs.core.undefined_QMARK_ = (function cljs$core$undefined_QMARK_(x){
return (void 0 === x);
});
/**
 * Return true if s satisfies ISeq
 */
cljs.core.seq_QMARK_ = (function cljs$core$seq_QMARK_(s){
if((s == null)){
return false;
} else {
if((!((s == null)))){
if((((s.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === s.cljs$core$ISeq$)))){
return true;
} else {
if((!s.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,s);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,s);
}
}
});
/**
 * Return true if the seq function is supported for s
 */
cljs.core.seqable_QMARK_ = (function cljs$core$seqable_QMARK_(s){
var or__5002__auto__ = (s == null);
if(or__5002__auto__){
return or__5002__auto__;
} else {
var or__5002__auto____$1 = (((!((s == null))))?(((((s.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === s.cljs$core$ISeqable$))))?true:(((!s.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,s):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,s));
if(or__5002__auto____$1){
return or__5002__auto____$1;
} else {
return ((cljs.core.array_QMARK_(s)) || (typeof s === 'string'));
}
}
});
/**
 * Coerce to boolean
 */
cljs.core.boolean$ = (function cljs$core$boolean(x){
if((x == null)){
return false;
} else {
if(x === false){
return false;
} else {
return true;

}
}
});
/**
 * Returns true if f returns true for fn? or satisfies IFn.
 */
cljs.core.ifn_QMARK_ = (function cljs$core$ifn_QMARK_(f){
var or__5002__auto__ = cljs.core.fn_QMARK_(f);
if(or__5002__auto__){
return or__5002__auto__;
} else {
if((!((f == null)))){
if((((f.cljs$lang$protocol_mask$partition0$ & (1))) || ((cljs.core.PROTOCOL_SENTINEL === f.cljs$core$IFn$)))){
return true;
} else {
if((!f.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,f);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,f);
}
}
});
/**
 * Returns true if n is a JavaScript number with no decimal part.
 */
cljs.core.integer_QMARK_ = (function cljs$core$integer_QMARK_(n){
return ((typeof n === 'number') && ((((!(isNaN(n)))) && ((((!((n === Infinity)))) && ((parseFloat(n) === parseInt(n,(10)))))))));
});
/**
 * INTERNAL: do not use
 */
cljs.core.LongImpl = cljs.core.goog$module$goog$math$Long;
/**
 * Return true if x satisfies integer? or is an instance of goog.math.Integer
 * or goog.math.Long.
 */
cljs.core.int_QMARK_ = (function cljs$core$int_QMARK_(x){
return ((cljs.core.integer_QMARK_(x)) || ((((x instanceof goog.math.Integer)) || ((x instanceof cljs.core.goog$module$goog$math$Long)))));
});
/**
 * Return true if x satisfies int? and is positive.
 */
cljs.core.pos_int_QMARK_ = (function cljs$core$pos_int_QMARK_(x){
if(cljs.core.integer_QMARK_(x)){
return (x > (0));
} else {
if((x instanceof goog.math.Integer)){
return ((cljs.core.not(x.isNegative())) && (cljs.core.not(x.isZero())));
} else {
if((x instanceof cljs.core.goog$module$goog$math$Long)){
return ((cljs.core.not(x.isNegative())) && (cljs.core.not(x.isZero())));
} else {
return false;

}
}
}
});
/**
 * Return true if x satisfies int? and is negative.
 */
cljs.core.neg_int_QMARK_ = (function cljs$core$neg_int_QMARK_(x){
if(cljs.core.integer_QMARK_(x)){
return (x < (0));
} else {
if((x instanceof goog.math.Integer)){
return x.isNegative();
} else {
if((x instanceof cljs.core.goog$module$goog$math$Long)){
return x.isNegative();
} else {
return false;

}
}
}
});
/**
 * Return true if x satisfies int? and is a natural integer value.
 */
cljs.core.nat_int_QMARK_ = (function cljs$core$nat_int_QMARK_(x){
if(cljs.core.integer_QMARK_(x)){
return (!((x < (0))));
} else {
if((x instanceof goog.math.Integer)){
return cljs.core.not(x.isNegative());
} else {
if((x instanceof cljs.core.goog$module$goog$math$Long)){
return cljs.core.not(x.isNegative());
} else {
return false;

}
}
}
});
/**
 * Returns true for JavaScript numbers, false otherwise.
 */
cljs.core.float_QMARK_ = (function cljs$core$float_QMARK_(x){
return typeof x === 'number';
});
/**
 * Returns true for JavaScript numbers, false otherwise.
 */
cljs.core.double_QMARK_ = (function cljs$core$double_QMARK_(x){
return typeof x === 'number';
});
/**
 * Returns true for Infinity and -Infinity values.
 */
cljs.core.infinite_QMARK_ = (function cljs$core$infinite_QMARK_(x){
return (((x === Number.POSITIVE_INFINITY)) || ((x === Number.NEGATIVE_INFINITY)));
});
/**
 * Returns true if key is present in the given collection, otherwise
 *   returns false.  Note that for numerically indexed collections like
 *   vectors and arrays, this tests if the numeric key is within the
 *   range of indexes. 'contains?' operates constant or logarithmic time;
 *   it will not perform a linear search for a value.  See also 'some'.
 */
cljs.core.contains_QMARK_ = (function cljs$core$contains_QMARK_(coll,v){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (512))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IAssociative$))))?true:false):false)){
return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(null,v);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,coll)){
return cljs.core._contains_key_QMARK_(coll,v);
} else {
if((cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,v,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return false;
} else {
return true;

}
}
}
});
/**
 * Returns the map entry for key, or nil if key not present.
 */
cljs.core.find = (function cljs$core$find(coll,k){
if(cljs.core.ifind_QMARK_(coll)){
return cljs.core._find(coll,k);
} else {
if((((!((coll == null)))) && (((cljs.core.associative_QMARK_(coll)) && (cljs.core.contains_QMARK_(coll,k)))))){
return (new cljs.core.MapEntry(k,cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,k),null));
} else {
return null;
}
}
});
/**
 * Returns true if no two of the arguments are =
 */
cljs.core.distinct_QMARK_ = (function cljs$core$distinct_QMARK_(var_args){
var G__6293 = arguments.length;
switch (G__6293) {
case 1:
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8244 = arguments.length;
var i__5727__auto___8249 = (0);
while(true){
if((i__5727__auto___8249 < len__5726__auto___8244)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8249]));

var G__8251 = (i__5727__auto___8249 + (1));
i__5727__auto___8249 = G__8251;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
}));

(cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)));
}));

(cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
if((!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)))){
var s = cljs.core.PersistentHashSet.createAsIfByAssoc([x,y]);
var xs = more;
while(true){
var x__$1 = cljs.core.first(xs);
var etc = cljs.core.next(xs);
if(cljs.core.truth_(xs)){
if(cljs.core.contains_QMARK_(s,x__$1)){
return false;
} else {
var G__8258 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(s,x__$1);
var G__8259 = etc;
s = G__8258;
xs = G__8259;
continue;
}
} else {
return true;
}
break;
}
} else {
return false;
}
}));

/** @this {Function} */
(cljs.core.distinct_QMARK_.cljs$lang$applyTo = (function (seq6290){
var G__6291 = cljs.core.first(seq6290);
var seq6290__$1 = cljs.core.next(seq6290);
var G__6292 = cljs.core.first(seq6290__$1);
var seq6290__$2 = cljs.core.next(seq6290__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6291,G__6292,seq6290__$2);
}));

(cljs.core.distinct_QMARK_.cljs$lang$maxFixedArity = (2));

/**
 * Comparator. Returns a negative number, zero, or a positive number
 *   when x is logically 'less than', 'equal to', or 'greater than'
 *   y. Uses IComparable if available and google.array.defaultCompare for objects
 *  of the same type and special-cases nil to be less than any other object.
 */
cljs.core.compare = (function cljs$core$compare(x,y){
if((x === y)){
return (0);
} else {
if((x == null)){
return (-1);
} else {
if((y == null)){
return (1);
} else {
if(typeof x === 'number'){
if(typeof y === 'number'){
return cljs.core.goog$module$goog$array.defaultCompare(x,y);
} else {
throw (new Error(["Cannot compare ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)," to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(y)].join('')));
}
} else {
if((((!((x == null))))?(((((x.cljs$lang$protocol_mask$partition1$ & (2048))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IComparable$))))?true:(((!x.cljs$lang$protocol_mask$partition1$))?cljs.core.native_satisfies_QMARK_(cljs.core.IComparable,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IComparable,x))){
return cljs.core._compare(x,y);
} else {
if(((((typeof x === 'string') || (((cljs.core.array_QMARK_(x)) || (((x === true) || (x === false))))))) && ((cljs.core.type(x) === cljs.core.type(y))))){
return cljs.core.goog$module$goog$array.defaultCompare(x,y);
} else {
throw (new Error(["Cannot compare ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)," to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(y)].join('')));
}

}
}
}
}
}
});
/**
 * Compare indexed collection.
 */
cljs.core.compare_indexed = (function cljs$core$compare_indexed(var_args){
var G__6296 = arguments.length;
switch (G__6296) {
case 2:
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2 = (function (xs,ys){
var xl = cljs.core.count(xs);
var yl = cljs.core.count(ys);
if((xl < yl)){
return (-1);
} else {
if((xl > yl)){
return (1);
} else {
if((xl === (0))){
return (0);
} else {
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4(xs,ys,xl,(0));

}
}
}
}));

(cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4 = (function (xs,ys,len,n){
while(true){
var d = cljs.core.compare(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(xs,n),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ys,n));
if((((d === (0))) && (((n + (1)) < len)))){
var G__8261 = xs;
var G__8262 = ys;
var G__8263 = len;
var G__8264 = (n + (1));
xs = G__8261;
ys = G__8262;
len = G__8263;
n = G__8264;
continue;
} else {
return d;
}
break;
}
}));

(cljs.core.compare_indexed.cljs$lang$maxFixedArity = 4);

/**
 * Given a fn that might be boolean valued or a comparator,
 * return a fn that is a comparator.
 */
cljs.core.fn__GT_comparator = (function cljs$core$fn__GT_comparator(f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f,cljs.core.compare)){
return cljs.core.compare;
} else {
return (function (x,y){
var r = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y));
if(typeof r === 'number'){
return r;
} else {
if(cljs.core.truth_(r)){
return (-1);
} else {
if(cljs.core.truth_((f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(y,x) : f.call(null,y,x)))){
return (1);
} else {
return (0);
}
}
}
});
}
});
/**
 * Returns a sorted sequence of the items in coll. Comp can be
 * boolean-valued comparison function, or a -/0/+ valued comparator.
 * Comp defaults to compare.
 */
cljs.core.sort = (function cljs$core$sort(var_args){
var G__6298 = arguments.length;
switch (G__6298) {
case 1:
return cljs.core.sort.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.sort.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,coll);
}));

(cljs.core.sort.cljs$core$IFn$_invoke$arity$2 = (function (comp,coll){
if(cljs.core.seq(coll)){
var a = (cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.to_array.call(null,coll));
cljs.core.goog$module$goog$array.stableSort(a,cljs.core.fn__GT_comparator(comp));

return cljs.core.with_meta(cljs.core.seq(a),cljs.core.meta(coll));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.sort.cljs$lang$maxFixedArity = 2);

/**
 * Returns a sorted sequence of the items in coll, where the sort
 * order is determined by comparing (keyfn item).  Comp can be
 * boolean-valued comparison function, or a -/0/+ valued comparator.
 * Comp defaults to compare.
 */
cljs.core.sort_by = (function cljs$core$sort_by(var_args){
var G__6300 = arguments.length;
switch (G__6300) {
case 2:
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,coll){
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,cljs.core.compare,coll);
}));

(cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3 = (function (keyfn,comp,coll){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((function (x,y){
var G__6302 = (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(x) : keyfn.call(null,x));
var G__6303 = (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(y) : keyfn.call(null,y));
var fexpr__6301 = cljs.core.fn__GT_comparator(comp);
return (fexpr__6301.cljs$core$IFn$_invoke$arity$2 ? fexpr__6301.cljs$core$IFn$_invoke$arity$2(G__6302,G__6303) : fexpr__6301.call(null,G__6302,G__6303));
}),coll);
}));

(cljs.core.sort_by.cljs$lang$maxFixedArity = 3);

cljs.core.seq_reduce = (function cljs$core$seq_reduce(var_args){
var G__6305 = arguments.length;
switch (G__6305) {
case 2:
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
var temp__5802__auto__ = cljs.core.seq(coll);
if(temp__5802__auto__){
var s = temp__5802__auto__;
var G__6306 = f;
var G__6307 = cljs.core.first(s);
var G__6308 = cljs.core.next(s);
return (cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__6306,G__6307,G__6308) : cljs.core.reduce.call(null,G__6306,G__6307,G__6308));
} else {
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
}
}));

(cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 = (function (f,val,coll){
var val__$1 = val;
var coll__$1 = cljs.core.seq(coll);
while(true){
if(coll__$1){
var nval = (function (){var G__6309 = val__$1;
var G__6310 = cljs.core.first(coll__$1);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6309,G__6310) : f.call(null,G__6309,G__6310));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__8280 = nval;
var G__8281 = cljs.core.next(coll__$1);
val__$1 = G__8280;
coll__$1 = G__8281;
continue;
}
} else {
return val__$1;
}
break;
}
}));

(cljs.core.seq_reduce.cljs$lang$maxFixedArity = 3);

/**
 * Return a random permutation of coll
 */
cljs.core.shuffle = (function cljs$core$shuffle(coll){
var a = (cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.to_array.call(null,coll));
cljs.core.goog$module$goog$array.shuffle(a);

return (cljs.core.vec.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vec.cljs$core$IFn$_invoke$arity$1(a) : cljs.core.vec.call(null,a));
});
cljs.core.iter_reduce = (function cljs$core$iter_reduce(var_args){
var G__6312 = arguments.length;
switch (G__6312) {
case 2:
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2 = (function (coll,f){
var iter = cljs.core._iterator(coll);
if(cljs.core.truth_(iter.hasNext())){
var init = iter.next();
var acc = init;
while(true){
if(iter.hasNext()){
var nacc = (function (){var G__6313 = acc;
var G__6314 = iter.next();
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6313,G__6314) : f.call(null,G__6313,G__6314));
})();
if(cljs.core.reduced_QMARK_(nacc)){
return cljs.core.deref(nacc);
} else {
var G__8283 = nacc;
acc = G__8283;
continue;
}
} else {
return acc;
}
break;
}
} else {
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
}
}));

(cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3 = (function (coll,f,init){
var iter = cljs.core._iterator(coll);
var acc = init;
while(true){
if(iter.hasNext()){
var nacc = (function (){var G__6315 = acc;
var G__6316 = iter.next();
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6315,G__6316) : f.call(null,G__6315,G__6316));
})();
if(cljs.core.reduced_QMARK_(nacc)){
return cljs.core.deref(nacc);
} else {
var G__8284 = nacc;
acc = G__8284;
continue;
}
} else {
return acc;
}
break;
}
}));

(cljs.core.iter_reduce.cljs$lang$maxFixedArity = 3);

/**
 * f should be a function of 2 arguments. If val is not supplied,
 *   returns the result of applying f to the first 2 items in coll, then
 *   applying f to that result and the 3rd item, etc. If coll contains no
 *   items, f must accept no arguments as well, and reduce returns the
 *   result of calling f with no arguments.  If coll has only 1 item, it
 *   is returned and f is not called.  If val is supplied, returns the
 *   result of applying f to val and the first item in coll, then
 *   applying f to that result and the 2nd item, etc. If coll contains no
 *   items, returns val and f is not called.
 */
cljs.core.reduce = (function cljs$core$reduce(var_args){
var G__6318 = arguments.length;
switch (G__6318) {
case 2:
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.reduce.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (524288))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReduce$))))?true:false):false)){
return coll.cljs$core$IReduce$_reduce$arity$2(null,f);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce(coll,f);
} else {
if(cljs.core.iterable_QMARK_(coll)){
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll);

}
}
}
}
}
}));

(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 = (function (f,val,coll){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (524288))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReduce$))))?true:false):false)){
return coll.cljs$core$IReduce$_reduce$arity$3(null,f,val);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce(coll,f,val);
} else {
if(cljs.core.iterable_QMARK_(coll)){
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,val,coll);

}
}
}
}
}
}));

(cljs.core.reduce.cljs$lang$maxFixedArity = 3);

/**
 * Reduces an associative collection. f should be a function of 3
 *   arguments. Returns the result of applying f to init, the first key
 *   and the first value in coll, then applying f to that result and the
 *   2nd key and value, etc. If coll contains no entries, returns init
 *   and f is not called. Note that reduce-kv is supported on vectors,
 *   where the keys will be the ordinals.
 */
cljs.core.reduce_kv = (function cljs$core$reduce_kv(f,init,coll){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (1048576))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IKVReduce$))))?true:(((!coll.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IKVReduce,coll):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IKVReduce,coll))){
return cljs.core._kv_reduce(coll,f,init);
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret,me){
var G__6322 = ret;
var G__6323 = cljs.core._key(me);
var G__6324 = cljs.core._val(me);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__6322,G__6323,G__6324) : f.call(null,G__6322,G__6323,G__6324));
}),init,coll);
}
});
/**
 * Returns its argument.
 */
cljs.core.identity = (function cljs$core$identity(x){
return x;
});
/**
 * Takes a reducing function f of 2 args and returns a fn suitable for
 *   transduce by adding an arity-1 signature that calls cf (default -
 *   identity) on the result argument.
 */
cljs.core.completing = (function cljs$core$completing(var_args){
var G__6326 = arguments.length;
switch (G__6326) {
case 1:
return cljs.core.completing.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.completing.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.completing.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.completing.cljs$core$IFn$_invoke$arity$2(f,cljs.core.identity);
}));

(cljs.core.completing.cljs$core$IFn$_invoke$arity$2 = (function (f,cf){
return (function() {
var G__8287 = null;
var G__8287__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
});
var G__8287__1 = (function (x){
return (cf.cljs$core$IFn$_invoke$arity$1 ? cf.cljs$core$IFn$_invoke$arity$1(x) : cf.call(null,x));
});
var G__8287__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y));
});
G__8287 = function(x,y){
switch(arguments.length){
case 0:
return G__8287__0.call(this);
case 1:
return G__8287__1.call(this,x);
case 2:
return G__8287__2.call(this,x,y);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8287.cljs$core$IFn$_invoke$arity$0 = G__8287__0;
G__8287.cljs$core$IFn$_invoke$arity$1 = G__8287__1;
G__8287.cljs$core$IFn$_invoke$arity$2 = G__8287__2;
return G__8287;
})()
}));

(cljs.core.completing.cljs$lang$maxFixedArity = 2);

/**
 * reduce with a transformation of f (xf). If init is not
 *   supplied, (f) will be called to produce it. f should be a reducing
 *   step function that accepts both 1 and 2 arguments, if it accepts
 *   only 2 you can add the arity-1 with 'completing'. Returns the result
 *   of applying (the transformed) xf to init and the first item in coll,
 *   then applying xf to that result and the 2nd item, etc. If coll
 *   contains no items, returns init and f is not called. Note that
 *   certain transforms may inject or skip items.
 */
cljs.core.transduce = (function cljs$core$transduce(var_args){
var G__6328 = arguments.length;
switch (G__6328) {
case 3:
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.transduce.cljs$core$IFn$_invoke$arity$3 = (function (xform,f,coll){
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,f,(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)),coll);
}));

(cljs.core.transduce.cljs$core$IFn$_invoke$arity$4 = (function (xform,f,init,coll){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var ret = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f__$1,init,coll);
return (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(ret) : f__$1.call(null,ret));
}));

(cljs.core.transduce.cljs$lang$maxFixedArity = 4);

/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core._PLUS_ = (function cljs$core$_PLUS_(var_args){
var G__6333 = arguments.length;
switch (G__6333) {
case 0:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8290 = arguments.length;
var i__5727__auto___8291 = (0);
while(true){
if((i__5727__auto___8291 < len__5726__auto___8290)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8291]));

var G__8292 = (i__5727__auto___8291 + (1));
i__5727__auto___8291 = G__8292;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0 = (function (){
return (0);
}));

(cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
}));

(cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x + y);
}));

(cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(x + y),more);
}));

/** @this {Function} */
(cljs.core._PLUS_.cljs$lang$applyTo = (function (seq6330){
var G__6331 = cljs.core.first(seq6330);
var seq6330__$1 = cljs.core.next(seq6330);
var G__6332 = cljs.core.first(seq6330__$1);
var seq6330__$2 = cljs.core.next(seq6330__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6331,G__6332,seq6330__$2);
}));

(cljs.core._PLUS_.cljs$lang$maxFixedArity = (2));

/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core._ = (function cljs$core$_(var_args){
var G__6338 = arguments.length;
switch (G__6338) {
case 1:
return cljs.core._.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8294 = arguments.length;
var i__5727__auto___8295 = (0);
while(true){
if((i__5727__auto___8295 < len__5726__auto___8294)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8295]));

var G__8296 = (i__5727__auto___8295 + (1));
i__5727__auto___8295 = G__8296;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core._.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (- x);
}));

(cljs.core._.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x - y);
}));

(cljs.core._.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._,(x - y),more);
}));

/** @this {Function} */
(cljs.core._.cljs$lang$applyTo = (function (seq6335){
var G__6336 = cljs.core.first(seq6335);
var seq6335__$1 = cljs.core.next(seq6335);
var G__6337 = cljs.core.first(seq6335__$1);
var seq6335__$2 = cljs.core.next(seq6335__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6336,G__6337,seq6335__$2);
}));

(cljs.core._.cljs$lang$maxFixedArity = (2));

/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core._STAR_ = (function cljs$core$_STAR_(var_args){
var G__6343 = arguments.length;
switch (G__6343) {
case 0:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8298 = arguments.length;
var i__5727__auto___8299 = (0);
while(true){
if((i__5727__auto___8299 < len__5726__auto___8298)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8299]));

var G__8300 = (i__5727__auto___8299 + (1));
i__5727__auto___8299 = G__8300;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0 = (function (){
return (1);
}));

(cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
}));

(cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x * y);
}));

(cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_,(x * y),more);
}));

/** @this {Function} */
(cljs.core._STAR_.cljs$lang$applyTo = (function (seq6340){
var G__6341 = cljs.core.first(seq6340);
var seq6340__$1 = cljs.core.next(seq6340);
var G__6342 = cljs.core.first(seq6340__$1);
var seq6340__$2 = cljs.core.next(seq6340__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6341,G__6342,seq6340__$2);
}));

(cljs.core._STAR_.cljs$lang$maxFixedArity = (2));

/**
 * If no denominators are supplied, returns 1/numerator,
 *   else returns numerator divided by all of the denominators.
 */
cljs.core._SLASH_ = (function cljs$core$_SLASH_(var_args){
var G__6348 = arguments.length;
switch (G__6348) {
case 1:
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8302 = arguments.length;
var i__5727__auto___8303 = (0);
while(true){
if((i__5727__auto___8303 < len__5726__auto___8302)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8303]));

var G__8305 = (i__5727__auto___8303 + (1));
i__5727__auto___8303 = G__8305;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return ((1) / x);
}));

(cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x / y);
}));

(cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_,(x / y),more);
}));

/** @this {Function} */
(cljs.core._SLASH_.cljs$lang$applyTo = (function (seq6345){
var G__6346 = cljs.core.first(seq6345);
var seq6345__$1 = cljs.core.next(seq6345);
var G__6347 = cljs.core.first(seq6345__$1);
var seq6345__$2 = cljs.core.next(seq6345__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6346,G__6347,seq6345__$2);
}));

(cljs.core._SLASH_.cljs$lang$maxFixedArity = (2));

/**
 * Returns non-nil if nums are in monotonically increasing order,
 *   otherwise false.
 */
cljs.core._LT_ = (function cljs$core$_LT_(var_args){
var G__6353 = arguments.length;
switch (G__6353) {
case 1:
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8307 = arguments.length;
var i__5727__auto___8308 = (0);
while(true){
if((i__5727__auto___8308 < len__5726__auto___8307)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8308]));

var G__8309 = (i__5727__auto___8308 + (1));
i__5727__auto___8308 = G__8309;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core._LT_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
}));

(cljs.core._LT_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x < y);
}));

(cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x < y)){
if(cljs.core.next(more)){
var G__8310 = y;
var G__8311 = cljs.core.first(more);
var G__8312 = cljs.core.next(more);
x = G__8310;
y = G__8311;
more = G__8312;
continue;
} else {
return (y < cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._LT_.cljs$lang$applyTo = (function (seq6350){
var G__6351 = cljs.core.first(seq6350);
var seq6350__$1 = cljs.core.next(seq6350);
var G__6352 = cljs.core.first(seq6350__$1);
var seq6350__$2 = cljs.core.next(seq6350__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6351,G__6352,seq6350__$2);
}));

(cljs.core._LT_.cljs$lang$maxFixedArity = (2));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 *   otherwise false.
 */
cljs.core._LT__EQ_ = (function cljs$core$_LT__EQ_(var_args){
var G__6358 = arguments.length;
switch (G__6358) {
case 1:
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8314 = arguments.length;
var i__5727__auto___8315 = (0);
while(true){
if((i__5727__auto___8315 < len__5726__auto___8314)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8315]));

var G__8316 = (i__5727__auto___8315 + (1));
i__5727__auto___8315 = G__8316;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
}));

(cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x <= y);
}));

(cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x <= y)){
if(cljs.core.next(more)){
var G__8318 = y;
var G__8319 = cljs.core.first(more);
var G__8320 = cljs.core.next(more);
x = G__8318;
y = G__8319;
more = G__8320;
continue;
} else {
return (y <= cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._LT__EQ_.cljs$lang$applyTo = (function (seq6355){
var G__6356 = cljs.core.first(seq6355);
var seq6355__$1 = cljs.core.next(seq6355);
var G__6357 = cljs.core.first(seq6355__$1);
var seq6355__$2 = cljs.core.next(seq6355__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6356,G__6357,seq6355__$2);
}));

(cljs.core._LT__EQ_.cljs$lang$maxFixedArity = (2));

/**
 * Returns non-nil if nums are in monotonically decreasing order,
 *   otherwise false.
 */
cljs.core._GT_ = (function cljs$core$_GT_(var_args){
var G__6363 = arguments.length;
switch (G__6363) {
case 1:
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8322 = arguments.length;
var i__5727__auto___8323 = (0);
while(true){
if((i__5727__auto___8323 < len__5726__auto___8322)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8323]));

var G__8324 = (i__5727__auto___8323 + (1));
i__5727__auto___8323 = G__8324;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core._GT_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
}));

(cljs.core._GT_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x > y);
}));

(cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x > y)){
if(cljs.core.next(more)){
var G__8325 = y;
var G__8326 = cljs.core.first(more);
var G__8327 = cljs.core.next(more);
x = G__8325;
y = G__8326;
more = G__8327;
continue;
} else {
return (y > cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._GT_.cljs$lang$applyTo = (function (seq6360){
var G__6361 = cljs.core.first(seq6360);
var seq6360__$1 = cljs.core.next(seq6360);
var G__6362 = cljs.core.first(seq6360__$1);
var seq6360__$2 = cljs.core.next(seq6360__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6361,G__6362,seq6360__$2);
}));

(cljs.core._GT_.cljs$lang$maxFixedArity = (2));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 *   otherwise false.
 */
cljs.core._GT__EQ_ = (function cljs$core$_GT__EQ_(var_args){
var G__6368 = arguments.length;
switch (G__6368) {
case 1:
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8329 = arguments.length;
var i__5727__auto___8330 = (0);
while(true){
if((i__5727__auto___8330 < len__5726__auto___8329)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8330]));

var G__8331 = (i__5727__auto___8330 + (1));
i__5727__auto___8330 = G__8331;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
}));

(cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x >= y);
}));

(cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x >= y)){
if(cljs.core.next(more)){
var G__8332 = y;
var G__8333 = cljs.core.first(more);
var G__8334 = cljs.core.next(more);
x = G__8332;
y = G__8333;
more = G__8334;
continue;
} else {
return (y >= cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._GT__EQ_.cljs$lang$applyTo = (function (seq6365){
var G__6366 = cljs.core.first(seq6365);
var seq6365__$1 = cljs.core.next(seq6365);
var G__6367 = cljs.core.first(seq6365__$1);
var seq6365__$2 = cljs.core.next(seq6365__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6366,G__6367,seq6365__$2);
}));

(cljs.core._GT__EQ_.cljs$lang$maxFixedArity = (2));

/**
 * Returns a number one less than num.
 */
cljs.core.dec = (function cljs$core$dec(x){
return (x - (1));
});
/**
 * Returns the absolute value of a.
 */
cljs.core.abs = (function cljs$core$abs(a){
return Math.abs(a);
});
/**
 * Returns the greatest of the nums.
 */
cljs.core.max = (function cljs$core$max(var_args){
var G__6373 = arguments.length;
switch (G__6373) {
case 1:
return cljs.core.max.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.max.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8336 = arguments.length;
var i__5727__auto___8337 = (0);
while(true){
if((i__5727__auto___8337 < len__5726__auto___8336)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8337]));

var G__8338 = (i__5727__auto___8337 + (1));
i__5727__auto___8337 = G__8338;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.max.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
}));

(cljs.core.max.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
var x__5087__auto__ = x;
var y__5088__auto__ = y;
return ((x__5087__auto__ > y__5088__auto__) ? x__5087__auto__ : y__5088__auto__);
}));

(cljs.core.max.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.max,(function (){var x__5087__auto__ = x;
var y__5088__auto__ = y;
return ((x__5087__auto__ > y__5088__auto__) ? x__5087__auto__ : y__5088__auto__);
})(),more);
}));

/** @this {Function} */
(cljs.core.max.cljs$lang$applyTo = (function (seq6370){
var G__6371 = cljs.core.first(seq6370);
var seq6370__$1 = cljs.core.next(seq6370);
var G__6372 = cljs.core.first(seq6370__$1);
var seq6370__$2 = cljs.core.next(seq6370__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6371,G__6372,seq6370__$2);
}));

(cljs.core.max.cljs$lang$maxFixedArity = (2));

/**
 * Returns the least of the nums.
 */
cljs.core.min = (function cljs$core$min(var_args){
var G__6378 = arguments.length;
switch (G__6378) {
case 1:
return cljs.core.min.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.min.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8340 = arguments.length;
var i__5727__auto___8341 = (0);
while(true){
if((i__5727__auto___8341 < len__5726__auto___8340)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8341]));

var G__8342 = (i__5727__auto___8341 + (1));
i__5727__auto___8341 = G__8342;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.min.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
}));

(cljs.core.min.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
var x__5090__auto__ = x;
var y__5091__auto__ = y;
return ((x__5090__auto__ < y__5091__auto__) ? x__5090__auto__ : y__5091__auto__);
}));

(cljs.core.min.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.min,(function (){var x__5090__auto__ = x;
var y__5091__auto__ = y;
return ((x__5090__auto__ < y__5091__auto__) ? x__5090__auto__ : y__5091__auto__);
})(),more);
}));

/** @this {Function} */
(cljs.core.min.cljs$lang$applyTo = (function (seq6375){
var G__6376 = cljs.core.first(seq6375);
var seq6375__$1 = cljs.core.next(seq6375);
var G__6377 = cljs.core.first(seq6375__$1);
var seq6375__$2 = cljs.core.next(seq6375__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6376,G__6377,seq6375__$2);
}));

(cljs.core.min.cljs$lang$maxFixedArity = (2));

cljs.core.byte$ = (function cljs$core$byte(x){
return x;
});
/**
 * Coerce to char
 */
cljs.core.char$ = (function cljs$core$char(x){
if(typeof x === 'number'){
return String.fromCharCode(x);
} else {
if(((typeof x === 'string') && ((x.length === (1))))){
return x;
} else {
throw (new Error("Argument to char must be a character or number"));

}
}
});
cljs.core.short$ = (function cljs$core$short(x){
return x;
});
cljs.core.float$ = (function cljs$core$float(x){
return x;
});
cljs.core.double$ = (function cljs$core$double(x){
return x;
});
cljs.core.unchecked_byte = (function cljs$core$unchecked_byte(x){
return x;
});
cljs.core.unchecked_char = (function cljs$core$unchecked_char(x){
return x;
});
cljs.core.unchecked_short = (function cljs$core$unchecked_short(x){
return x;
});
cljs.core.unchecked_float = (function cljs$core$unchecked_float(x){
return x;
});
cljs.core.unchecked_double = (function cljs$core$unchecked_double(x){
return x;
});
/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core.unchecked_add = (function cljs$core$unchecked_add(var_args){
var G__6383 = arguments.length;
switch (G__6383) {
case 0:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8345 = arguments.length;
var i__5727__auto___8346 = (0);
while(true){
if((i__5727__auto___8346 < len__5726__auto___8345)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8346]));

var G__8347 = (i__5727__auto___8346 + (1));
i__5727__auto___8346 = G__8347;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0 = (function (){
return (0);
}));

(cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
}));

(cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x + y);
}));

(cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add,(x + y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_add.cljs$lang$applyTo = (function (seq6380){
var G__6381 = cljs.core.first(seq6380);
var seq6380__$1 = cljs.core.next(seq6380);
var G__6382 = cljs.core.first(seq6380__$1);
var seq6380__$2 = cljs.core.next(seq6380__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6381,G__6382,seq6380__$2);
}));

(cljs.core.unchecked_add.cljs$lang$maxFixedArity = (2));

/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core.unchecked_add_int = (function cljs$core$unchecked_add_int(var_args){
var G__6388 = arguments.length;
switch (G__6388) {
case 0:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8349 = arguments.length;
var i__5727__auto___8350 = (0);
while(true){
if((i__5727__auto___8350 < len__5726__auto___8349)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8350]));

var G__8351 = (i__5727__auto___8350 + (1));
i__5727__auto___8350 = G__8351;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0 = (function (){
return (0);
}));

(cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
}));

(cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x + y);
}));

(cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add_int,(x + y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_add_int.cljs$lang$applyTo = (function (seq6385){
var G__6386 = cljs.core.first(seq6385);
var seq6385__$1 = cljs.core.next(seq6385);
var G__6387 = cljs.core.first(seq6385__$1);
var seq6385__$2 = cljs.core.next(seq6385__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6386,G__6387,seq6385__$2);
}));

(cljs.core.unchecked_add_int.cljs$lang$maxFixedArity = (2));

/**
 * Returns a number one less than x, an int.
 */
cljs.core.unchecked_dec = (function cljs$core$unchecked_dec(x){
return (x - (1));
});
/**
 * Returns a number one less than x, an int.
 */
cljs.core.unchecked_dec_int = (function cljs$core$unchecked_dec_int(x){
return (x - (1));
});
/**
 * If no denominators are supplied, returns 1/numerator,
 *   else returns numerator divided by all of the denominators.
 */
cljs.core.unchecked_divide_int = (function cljs$core$unchecked_divide_int(var_args){
var G__6393 = arguments.length;
switch (G__6393) {
case 1:
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8353 = arguments.length;
var i__5727__auto___8354 = (0);
while(true){
if((i__5727__auto___8354 < len__5726__auto___8353)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8354]));

var G__8355 = (i__5727__auto___8354 + (1));
i__5727__auto___8354 = G__8355;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return ((1) / x);
}));

(cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x / y);
}));

(cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_divide_int,(x / y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_divide_int.cljs$lang$applyTo = (function (seq6390){
var G__6391 = cljs.core.first(seq6390);
var seq6390__$1 = cljs.core.next(seq6390);
var G__6392 = cljs.core.first(seq6390__$1);
var seq6390__$2 = cljs.core.next(seq6390__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6391,G__6392,seq6390__$2);
}));

(cljs.core.unchecked_divide_int.cljs$lang$maxFixedArity = (2));

cljs.core.unchecked_inc = (function cljs$core$unchecked_inc(x){
return (x + (1));
});
cljs.core.unchecked_inc_int = (function cljs$core$unchecked_inc_int(x){
return (x + (1));
});
/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core.unchecked_multiply = (function cljs$core$unchecked_multiply(var_args){
var G__6398 = arguments.length;
switch (G__6398) {
case 0:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8357 = arguments.length;
var i__5727__auto___8358 = (0);
while(true){
if((i__5727__auto___8358 < len__5726__auto___8357)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8358]));

var G__8359 = (i__5727__auto___8358 + (1));
i__5727__auto___8358 = G__8359;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0 = (function (){
return (1);
}));

(cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
}));

(cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x * y);
}));

(cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply,(x * y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_multiply.cljs$lang$applyTo = (function (seq6395){
var G__6396 = cljs.core.first(seq6395);
var seq6395__$1 = cljs.core.next(seq6395);
var G__6397 = cljs.core.first(seq6395__$1);
var seq6395__$2 = cljs.core.next(seq6395__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6396,G__6397,seq6395__$2);
}));

(cljs.core.unchecked_multiply.cljs$lang$maxFixedArity = (2));

/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core.unchecked_multiply_int = (function cljs$core$unchecked_multiply_int(var_args){
var G__6403 = arguments.length;
switch (G__6403) {
case 0:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8361 = arguments.length;
var i__5727__auto___8362 = (0);
while(true){
if((i__5727__auto___8362 < len__5726__auto___8361)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8362]));

var G__8363 = (i__5727__auto___8362 + (1));
i__5727__auto___8362 = G__8363;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0 = (function (){
return (1);
}));

(cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
}));

(cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x * y);
}));

(cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply_int,(x * y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_multiply_int.cljs$lang$applyTo = (function (seq6400){
var G__6401 = cljs.core.first(seq6400);
var seq6400__$1 = cljs.core.next(seq6400);
var G__6402 = cljs.core.first(seq6400__$1);
var seq6400__$2 = cljs.core.next(seq6400__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6401,G__6402,seq6400__$2);
}));

(cljs.core.unchecked_multiply_int.cljs$lang$maxFixedArity = (2));

cljs.core.unchecked_negate = (function cljs$core$unchecked_negate(x){
return (- x);
});
cljs.core.unchecked_negate_int = (function cljs$core$unchecked_negate_int(x){
return (- x);
});
cljs.core.unchecked_remainder_int = (function cljs$core$unchecked_remainder_int(x,n){
return (cljs.core.mod.cljs$core$IFn$_invoke$arity$2 ? cljs.core.mod.cljs$core$IFn$_invoke$arity$2(x,n) : cljs.core.mod.call(null,x,n));
});
/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core.unchecked_subtract = (function cljs$core$unchecked_subtract(var_args){
var G__6408 = arguments.length;
switch (G__6408) {
case 1:
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8365 = arguments.length;
var i__5727__auto___8366 = (0);
while(true){
if((i__5727__auto___8366 < len__5726__auto___8365)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8366]));

var G__8367 = (i__5727__auto___8366 + (1));
i__5727__auto___8366 = G__8367;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (- x);
}));

(cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x - y);
}));

(cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract,(x - y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_subtract.cljs$lang$applyTo = (function (seq6405){
var G__6406 = cljs.core.first(seq6405);
var seq6405__$1 = cljs.core.next(seq6405);
var G__6407 = cljs.core.first(seq6405__$1);
var seq6405__$2 = cljs.core.next(seq6405__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6406,G__6407,seq6405__$2);
}));

(cljs.core.unchecked_subtract.cljs$lang$maxFixedArity = (2));

/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core.unchecked_subtract_int = (function cljs$core$unchecked_subtract_int(var_args){
var G__6413 = arguments.length;
switch (G__6413) {
case 1:
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8369 = arguments.length;
var i__5727__auto___8370 = (0);
while(true){
if((i__5727__auto___8370 < len__5726__auto___8369)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8370]));

var G__8371 = (i__5727__auto___8370 + (1));
i__5727__auto___8370 = G__8371;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (- x);
}));

(cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x - y);
}));

(cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract_int,(x - y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_subtract_int.cljs$lang$applyTo = (function (seq6410){
var G__6411 = cljs.core.first(seq6410);
var seq6410__$1 = cljs.core.next(seq6410);
var G__6412 = cljs.core.first(seq6410__$1);
var seq6410__$2 = cljs.core.next(seq6410__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6411,G__6412,seq6410__$2);
}));

(cljs.core.unchecked_subtract_int.cljs$lang$maxFixedArity = (2));

cljs.core.fix = (function cljs$core$fix(q){
if((q >= (0))){
return Math.floor(q);
} else {
return Math.ceil(q);
}
});
/**
 * Coerce to int by stripping decimal places.
 */
cljs.core.int$ = (function cljs$core$int(x){
return (x | (0));
});
/**
 * Coerce to int by stripping decimal places.
 */
cljs.core.unchecked_int = (function cljs$core$unchecked_int(x){
return cljs.core.fix(x);
});
/**
 * Coerce to long by stripping decimal places. Identical to `int'.
 */
cljs.core.long$ = (function cljs$core$long(x){
return cljs.core.fix(x);
});
/**
 * Coerce to long by stripping decimal places. Identical to `int'.
 */
cljs.core.unchecked_long = (function cljs$core$unchecked_long(x){
return cljs.core.fix(x);
});
cljs.core.booleans = (function cljs$core$booleans(x){
return x;
});
cljs.core.bytes = (function cljs$core$bytes(x){
return x;
});
cljs.core.chars = (function cljs$core$chars(x){
return x;
});
cljs.core.shorts = (function cljs$core$shorts(x){
return x;
});
cljs.core.ints = (function cljs$core$ints(x){
return x;
});
cljs.core.floats = (function cljs$core$floats(x){
return x;
});
cljs.core.doubles = (function cljs$core$doubles(x){
return x;
});
cljs.core.longs = (function cljs$core$longs(x){
return x;
});
/**
 * Modulus of num and div with original javascript behavior. i.e. bug for negative numbers
 */
cljs.core.js_mod = (function cljs$core$js_mod(n,d){
return (n % d);
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
cljs.core.mod = (function cljs$core$mod(n,d){
return (((n % d) + d) % d);
});
/**
 * quot[ient] of dividing numerator by denominator.
 */
cljs.core.quot = (function cljs$core$quot(n,d){
var rem = (n % d);
return cljs.core.fix(((n - rem) / d));
});
/**
 * remainder of dividing numerator by denominator.
 */
cljs.core.rem = (function cljs$core$rem(n,d){
var q = cljs.core.quot(n,d);
return (n - (d * q));
});
/**
 * Bitwise exclusive or
 */
cljs.core.bit_xor = (function cljs$core$bit_xor(var_args){
var G__6418 = arguments.length;
switch (G__6418) {
case 2:
return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8373 = arguments.length;
var i__5727__auto___8374 = (0);
while(true){
if((i__5727__auto___8374 < len__5726__auto___8373)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8374]));

var G__8375 = (i__5727__auto___8374 + (1));
i__5727__auto___8374 = G__8375;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x ^ y);
}));

(cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_xor,(x ^ y),more);
}));

/** @this {Function} */
(cljs.core.bit_xor.cljs$lang$applyTo = (function (seq6415){
var G__6416 = cljs.core.first(seq6415);
var seq6415__$1 = cljs.core.next(seq6415);
var G__6417 = cljs.core.first(seq6415__$1);
var seq6415__$2 = cljs.core.next(seq6415__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6416,G__6417,seq6415__$2);
}));

(cljs.core.bit_xor.cljs$lang$maxFixedArity = (2));

/**
 * Bitwise and
 */
cljs.core.bit_and = (function cljs$core$bit_and(var_args){
var G__6423 = arguments.length;
switch (G__6423) {
case 2:
return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8377 = arguments.length;
var i__5727__auto___8378 = (0);
while(true){
if((i__5727__auto___8378 < len__5726__auto___8377)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8378]));

var G__8379 = (i__5727__auto___8378 + (1));
i__5727__auto___8378 = G__8379;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x & y);
}));

(cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and,(x & y),more);
}));

/** @this {Function} */
(cljs.core.bit_and.cljs$lang$applyTo = (function (seq6420){
var G__6421 = cljs.core.first(seq6420);
var seq6420__$1 = cljs.core.next(seq6420);
var G__6422 = cljs.core.first(seq6420__$1);
var seq6420__$2 = cljs.core.next(seq6420__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6421,G__6422,seq6420__$2);
}));

(cljs.core.bit_and.cljs$lang$maxFixedArity = (2));

/**
 * Bitwise or
 */
cljs.core.bit_or = (function cljs$core$bit_or(var_args){
var G__6428 = arguments.length;
switch (G__6428) {
case 2:
return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8383 = arguments.length;
var i__5727__auto___8384 = (0);
while(true){
if((i__5727__auto___8384 < len__5726__auto___8383)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8384]));

var G__8385 = (i__5727__auto___8384 + (1));
i__5727__auto___8384 = G__8385;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x | y);
}));

(cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_or,(x | y),more);
}));

/** @this {Function} */
(cljs.core.bit_or.cljs$lang$applyTo = (function (seq6425){
var G__6426 = cljs.core.first(seq6425);
var seq6425__$1 = cljs.core.next(seq6425);
var G__6427 = cljs.core.first(seq6425__$1);
var seq6425__$2 = cljs.core.next(seq6425__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6426,G__6427,seq6425__$2);
}));

(cljs.core.bit_or.cljs$lang$maxFixedArity = (2));

/**
 * Bitwise and with complement
 */
cljs.core.bit_and_not = (function cljs$core$bit_and_not(var_args){
var G__6433 = arguments.length;
switch (G__6433) {
case 2:
return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8390 = arguments.length;
var i__5727__auto___8391 = (0);
while(true){
if((i__5727__auto___8391 < len__5726__auto___8390)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8391]));

var G__8392 = (i__5727__auto___8391 + (1));
i__5727__auto___8391 = G__8392;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x & ~y);
}));

(cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and_not,(x & ~y),more);
}));

/** @this {Function} */
(cljs.core.bit_and_not.cljs$lang$applyTo = (function (seq6430){
var G__6431 = cljs.core.first(seq6430);
var seq6430__$1 = cljs.core.next(seq6430);
var G__6432 = cljs.core.first(seq6430__$1);
var seq6430__$2 = cljs.core.next(seq6430__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6431,G__6432,seq6430__$2);
}));

(cljs.core.bit_and_not.cljs$lang$maxFixedArity = (2));

/**
 * Clear bit at index n
 */
cljs.core.bit_clear = (function cljs$core$bit_clear(x,n){
return (x & ~(1 << n));
});
/**
 * Flip bit at index n
 */
cljs.core.bit_flip = (function cljs$core$bit_flip(x,n){
return (x ^ (1 << n));
});
/**
 * Bitwise complement
 */
cljs.core.bit_not = (function cljs$core$bit_not(x){
return (~ x);
});
/**
 * Set bit at index n
 */
cljs.core.bit_set = (function cljs$core$bit_set(x,n){
return (x | (1 << n));
});
/**
 * Test bit at index n
 */
cljs.core.bit_test = (function cljs$core$bit_test(x,n){
return ((x & (1 << n)) != 0);
});
/**
 * Bitwise shift left
 */
cljs.core.bit_shift_left = (function cljs$core$bit_shift_left(x,n){
return (x << n);
});
/**
 * Bitwise shift right
 */
cljs.core.bit_shift_right = (function cljs$core$bit_shift_right(x,n){
return (x >> n);
});
/**
 * DEPRECATED: Bitwise shift right with zero fill
 */
cljs.core.bit_shift_right_zero_fill = (function cljs$core$bit_shift_right_zero_fill(x,n){
return (x >>> n);
});
/**
 * Bitwise shift right with zero fill
 */
cljs.core.unsigned_bit_shift_right = (function cljs$core$unsigned_bit_shift_right(x,n){
return (x >>> n);
});
/**
 * Counts the number of bits set in n
 */
cljs.core.bit_count = (function cljs$core$bit_count(v){
var v__$1 = (v - ((v >> (1)) & (1431655765)));
var v__$2 = ((v__$1 & (858993459)) + ((v__$1 >> (2)) & (858993459)));
return ((((v__$2 + (v__$2 >> (4))) & (252645135)) * (16843009)) >> (24));
});
/**
 * Returns non-nil if nums all have the equivalent
 *   value, otherwise false. Behavior on non nums is
 *   undefined.
 */
cljs.core._EQ__EQ_ = (function cljs$core$_EQ__EQ_(var_args){
var G__6438 = arguments.length;
switch (G__6438) {
case 1:
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8395 = arguments.length;
var i__5727__auto___8396 = (0);
while(true){
if((i__5727__auto___8396 < len__5726__auto___8395)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8396]));

var G__8397 = (i__5727__auto___8396 + (1));
i__5727__auto___8396 = G__8397;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
}));

(cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return cljs.core._equiv(x,y);
}));

(cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x === y)){
if(cljs.core.next(more)){
var G__8398 = y;
var G__8399 = cljs.core.first(more);
var G__8400 = cljs.core.next(more);
x = G__8398;
y = G__8399;
more = G__8400;
continue;
} else {
return (y === cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._EQ__EQ_.cljs$lang$applyTo = (function (seq6435){
var G__6436 = cljs.core.first(seq6435);
var seq6435__$1 = cljs.core.next(seq6435);
var G__6437 = cljs.core.first(seq6435__$1);
var seq6435__$2 = cljs.core.next(seq6435__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6436,G__6437,seq6435__$2);
}));

(cljs.core._EQ__EQ_.cljs$lang$maxFixedArity = (2));

/**
 * Returns true if num is greater than zero, else false
 */
cljs.core.pos_QMARK_ = (function cljs$core$pos_QMARK_(x){
return (x > (0));
});
/**
 * Returns true if num is zero, else false
 */
cljs.core.zero_QMARK_ = (function cljs$core$zero_QMARK_(x){
return (x === (0));
});
/**
 * Returns true if num is less than zero, else false
 */
cljs.core.neg_QMARK_ = (function cljs$core$neg_QMARK_(x){
return (x < (0));
});
/**
 * Returns the nth next of coll, (seq coll) when n is 0.
 */
cljs.core.nthnext = (function cljs$core$nthnext(coll,n){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition1$ & (262144))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IDrop$))))?true:false):false)){
if((n > (0))){
return coll.cljs$core$IDrop$_drop$arity$2(null,Math.ceil(n));
} else {
return cljs.core.seq(coll);
}
} else {
var n__$1 = n;
var xs = cljs.core.seq(coll);
while(true){
if(((xs) && ((n__$1 > (0))))){
var G__8401 = (n__$1 - (1));
var G__8402 = cljs.core.next(xs);
n__$1 = G__8401;
xs = G__8402;
continue;
} else {
return xs;
}
break;
}
}
});
/**
 * With no args, returns the empty string. With one arg x, returns
 *   x.toString().  (str nil) returns the empty string. With more than
 *   one arg, returns the concatenation of the str values of the args.
 */
cljs.core.str = (function cljs$core$str(var_args){
var G__6443 = arguments.length;
switch (G__6443) {
case 0:
return cljs.core.str.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8405 = arguments.length;
var i__5727__auto___8406 = (0);
while(true){
if((i__5727__auto___8406 < len__5726__auto___8405)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8406]));

var G__8407 = (i__5727__auto___8406 + (1));
i__5727__auto___8406 = G__8407;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((1) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((1)),(0),null)):null);
return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5752__auto__);

}
});

(cljs.core.str.cljs$core$IFn$_invoke$arity$0 = (function (){
return "";
}));

(cljs.core.str.cljs$core$IFn$_invoke$arity$1 = (function (x){
if((x == null)){
return "";
} else {
return [x].join("");
}
}));

(cljs.core.str.cljs$core$IFn$_invoke$arity$variadic = (function (x,ys){
var sb = (new goog.string.StringBuffer(cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)));
var more = ys;
while(true){
if(cljs.core.truth_(more)){
var G__8408 = sb.append(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(more)));
var G__8409 = cljs.core.next(more);
sb = G__8408;
more = G__8409;
continue;
} else {
return sb.toString();
}
break;
}
}));

/** @this {Function} */
(cljs.core.str.cljs$lang$applyTo = (function (seq6441){
var G__6442 = cljs.core.first(seq6441);
var seq6441__$1 = cljs.core.next(seq6441);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6442,seq6441__$1);
}));

(cljs.core.str.cljs$lang$maxFixedArity = (1));

/**
 * Returns the substring of s beginning at start inclusive, and ending
 *   at end (defaults to length of string), exclusive.
 */
cljs.core.subs = (function cljs$core$subs(var_args){
var G__6445 = arguments.length;
switch (G__6445) {
case 2:
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.subs.cljs$core$IFn$_invoke$arity$2 = (function (s,start){
return s.substring(start);
}));

(cljs.core.subs.cljs$core$IFn$_invoke$arity$3 = (function (s,start,end){
return s.substring(start,end);
}));

(cljs.core.subs.cljs$lang$maxFixedArity = 3);


/**
 * Assumes x is sequential. Returns true if x equals y, otherwise
 *   returns false.
 */
cljs.core.equiv_sequential = (function cljs$core$equiv_sequential(x,y){
return cljs.core.boolean$(((cljs.core.sequential_QMARK_(y))?((((cljs.core.counted_QMARK_(x)) && (((cljs.core.counted_QMARK_(y)) && ((!((cljs.core.count(x) === cljs.core.count(y)))))))))?false:(function (){var xs = cljs.core.seq(x);
var ys = cljs.core.seq(y);
while(true){
if((xs == null)){
return (ys == null);
} else {
if((ys == null)){
return false;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(xs),cljs.core.first(ys))){
var G__8411 = cljs.core.next(xs);
var G__8412 = cljs.core.next(ys);
xs = G__8411;
ys = G__8412;
continue;
} else {
return false;

}
}
}
break;
}
})()):null));
});
cljs.core.hash_coll = (function cljs$core$hash_coll(coll){
if(cljs.core.seq(coll)){
var res = cljs.core.hash(cljs.core.first(coll));
var s = cljs.core.next(coll);
while(true){
if((s == null)){
return res;
} else {
var G__8413 = cljs.core.hash_combine(res,cljs.core.hash(cljs.core.first(s)));
var G__8414 = cljs.core.next(s);
res = G__8413;
s = G__8414;
continue;
}
break;
}
} else {
return (0);
}
});

cljs.core.hash_imap = (function cljs$core$hash_imap(m){
var h = (0);
var s = cljs.core.seq(m);
while(true){
if(s){
var e = cljs.core.first(s);
var G__8415 = ((h + (cljs.core.hash((cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.key.call(null,e))) ^ cljs.core.hash((cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.val.call(null,e))))) % (4503599627370496));
var G__8416 = cljs.core.next(s);
h = G__8415;
s = G__8416;
continue;
} else {
return h;
}
break;
}
});
cljs.core.hash_iset = (function cljs$core$hash_iset(s){
var h = (0);
var s__$1 = cljs.core.seq(s);
while(true){
if(s__$1){
var e = cljs.core.first(s__$1);
var G__8417 = ((h + cljs.core.hash(e)) % (4503599627370496));
var G__8418 = cljs.core.next(s__$1);
h = G__8417;
s__$1 = G__8418;
continue;
} else {
return h;
}
break;
}
});


/**
 * Takes a JavaScript object and a map of names to functions and
 *   attaches said functions as methods on the object.  Any references to
 *   JavaScript's implicit this (via the this-as macro) will resolve to the
 *   object that the function is attached.
 */
cljs.core.extend_object_BANG_ = (function cljs$core$extend_object_BANG_(obj,fn_map){
var seq__6446_8419 = cljs.core.seq(fn_map);
var chunk__6447_8420 = null;
var count__6448_8421 = (0);
var i__6449_8422 = (0);
while(true){
if((i__6449_8422 < count__6448_8421)){
var vec__6456_8423 = chunk__6447_8420.cljs$core$IIndexed$_nth$arity$2(null,i__6449_8422);
var key_name_8424 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6456_8423,(0),null);
var f_8425 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6456_8423,(1),null);
var str_name_8426 = (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(key_name_8424) : cljs.core.name.call(null,key_name_8424));
cljs.core.goog$module$goog$object.set(obj,str_name_8426,f_8425);


var G__8427 = seq__6446_8419;
var G__8428 = chunk__6447_8420;
var G__8429 = count__6448_8421;
var G__8430 = (i__6449_8422 + (1));
seq__6446_8419 = G__8427;
chunk__6447_8420 = G__8428;
count__6448_8421 = G__8429;
i__6449_8422 = G__8430;
continue;
} else {
var temp__5804__auto___8431 = cljs.core.seq(seq__6446_8419);
if(temp__5804__auto___8431){
var seq__6446_8432__$1 = temp__5804__auto___8431;
if(cljs.core.chunked_seq_QMARK_(seq__6446_8432__$1)){
var c__5525__auto___8433 = (cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1(seq__6446_8432__$1) : cljs.core.chunk_first.call(null,seq__6446_8432__$1));
var G__8434 = (cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1(seq__6446_8432__$1) : cljs.core.chunk_rest.call(null,seq__6446_8432__$1));
var G__8435 = c__5525__auto___8433;
var G__8436 = cljs.core.count(c__5525__auto___8433);
var G__8437 = (0);
seq__6446_8419 = G__8434;
chunk__6447_8420 = G__8435;
count__6448_8421 = G__8436;
i__6449_8422 = G__8437;
continue;
} else {
var vec__6459_8438 = cljs.core.first(seq__6446_8432__$1);
var key_name_8439 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6459_8438,(0),null);
var f_8440 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6459_8438,(1),null);
var str_name_8441 = (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(key_name_8439) : cljs.core.name.call(null,key_name_8439));
cljs.core.goog$module$goog$object.set(obj,str_name_8441,f_8440);


var G__8442 = cljs.core.next(seq__6446_8432__$1);
var G__8443 = null;
var G__8444 = (0);
var G__8445 = (0);
seq__6446_8419 = G__8442;
chunk__6447_8420 = G__8443;
count__6448_8421 = G__8444;
i__6449_8422 = G__8445;
continue;
}
} else {
}
}
break;
}

return obj;
});

/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.List = (function (meta,first,rest,count,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.count = count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65937646;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
(cljs.core.List.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.List.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.List.prototype.indexOf = (function() {
var G__8446 = null;
var G__8446__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__8446__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__8446 = function(x,start){
switch(arguments.length){
case 1:
return G__8446__1.call(this,x);
case 2:
return G__8446__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8446.cljs$core$IFn$_invoke$arity$1 = G__8446__1;
G__8446.cljs$core$IFn$_invoke$arity$2 = G__8446__2;
return G__8446;
})()
);

(cljs.core.List.prototype.lastIndexOf = (function() {
var G__8447 = null;
var G__8447__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,self__.count);
});
var G__8447__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__8447 = function(x,start){
switch(arguments.length){
case 1:
return G__8447__1.call(this,x);
case 2:
return G__8447__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8447.cljs$core$IFn$_invoke$arity$1 = G__8447__1;
G__8447.cljs$core$IFn$_invoke$arity$2 = G__8447__2;
return G__8447;
})()
);

(cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.List.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.List(self__.meta,self__.first,self__.rest,self__.count,self__.__hash));
}));

(cljs.core.List.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return null;
} else {
return self__.rest;
}
}));

(cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
}));

(cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
}));

(cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ISeq$_rest$arity$1(null);
}));

(cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);
}));

(cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
}));

(cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
}));

(cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.List(new_meta,self__.first,self__.rest,self__.count,self__.__hash));
}
}));

(cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,coll__$1,(self__.count + (1)),null));
}));

(cljs.core.List.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rest","rest",398835108,null),new cljs.core.Symbol(null,"count","count",-514511684,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.List.cljs$lang$type = true);

(cljs.core.List.cljs$lang$ctorStr = "cljs.core/List");

(cljs.core.List.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/List");
}));

/**
 * Positional factory function for cljs.core/List.
 */
cljs.core.__GT_List = (function cljs$core$__GT_List(meta,first,rest,count,__hash){
return (new cljs.core.List(meta,first,rest,count,__hash));
});

/**
 * Returns true if x implements IList
 */
cljs.core.list_QMARK_ = (function cljs$core$list_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (33554432))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IList$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,x);
}
});
(cljs.core.List.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.EmptyList = (function (meta){
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 65937614;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
(cljs.core.EmptyList.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.EmptyList.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.EmptyList.prototype.indexOf = (function() {
var G__8457 = null;
var G__8457__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__8457__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__8457 = function(x,start){
switch(arguments.length){
case 1:
return G__8457__1.call(this,x);
case 2:
return G__8457__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8457.cljs$core$IFn$_invoke$arity$1 = G__8457__1;
G__8457.cljs$core$IFn$_invoke$arity$2 = G__8457__2;
return G__8457;
})()
);

(cljs.core.EmptyList.prototype.lastIndexOf = (function() {
var G__8460 = null;
var G__8460__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__8460__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__8460 = function(x,start){
switch(arguments.length){
case 1:
return G__8460__1.call(this,x);
case 2:
return G__8460__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8460.cljs$core$IFn$_invoke$arity$1 = G__8460__1;
G__8460.cljs$core$IFn$_invoke$arity$2 = G__8460__2;
return G__8460;
})()
);

(cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.EmptyList.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.EmptyList(self__.meta));
}));

(cljs.core.EmptyList.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
}));

(cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (0);
}));

(cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
}));

(cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
throw (new Error("Can't pop empty list"));
}));

(cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.empty_ordered_hash;
}));

(cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if(((cljs.core.list_QMARK_(other)) || (cljs.core.sequential_QMARK_(other)))){
return (cljs.core.seq(other) == null);
} else {
return false;
}
}));

(cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
}));

(cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
}));

(cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.EmptyList(new_meta));
}
}));

(cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,null,(1),null));
}));

(cljs.core.EmptyList.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null);
}));

(cljs.core.EmptyList.cljs$lang$type = true);

(cljs.core.EmptyList.cljs$lang$ctorStr = "cljs.core/EmptyList");

(cljs.core.EmptyList.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/EmptyList");
}));

/**
 * Positional factory function for cljs.core/EmptyList.
 */
cljs.core.__GT_EmptyList = (function cljs$core$__GT_EmptyList(meta){
return (new cljs.core.EmptyList(meta));
});

(cljs.core.List.EMPTY = (new cljs.core.EmptyList(null)));
(cljs.core.EmptyList.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));
/**
 * Returns true if coll satisfies? IReversible.
 */
cljs.core.reversible_QMARK_ = (function cljs$core$reversible_QMARK_(coll){
if((!((coll == null)))){
if((((coll.cljs$lang$protocol_mask$partition0$ & (134217728))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReversible$)))){
return true;
} else {
if((!coll.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,coll);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,coll);
}
});
/**
 * Returns, in constant time, a seq of the items in rev (which
 *   can be a vector or sorted-map), in reverse order. If rev is empty returns nil
 */
cljs.core.rseq = (function cljs$core$rseq(rev){
return cljs.core._rseq(rev);
});
/**
 * Returns a seq of the items in coll in reverse order. Not lazy.
 */
cljs.core.reverse = (function cljs$core$reverse(coll){
if(cljs.core.reversible_QMARK_(coll)){
var or__5002__auto__ = cljs.core.rseq(coll);
if(or__5002__auto__){
return or__5002__auto__;
} else {
return cljs.core.List.EMPTY;
}
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.List.EMPTY,coll);
}
});
/**
 * Creates a new list containing the items.
 */
cljs.core.list = (function cljs$core$list(var_args){
var args__5732__auto__ = [];
var len__5726__auto___8462 = arguments.length;
var i__5727__auto___8463 = (0);
while(true){
if((i__5727__auto___8463 < len__5726__auto___8462)){
args__5732__auto__.push((arguments[i__5727__auto___8463]));

var G__8464 = (i__5727__auto___8463 + (1));
i__5727__auto___8463 = G__8464;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((0) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((0)),(0),null)):null);
return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(argseq__5733__auto__);
});

(cljs.core.list.cljs$core$IFn$_invoke$arity$variadic = (function (xs){
var arr = (((((xs instanceof cljs.core.IndexedSeq)) && ((xs.i === (0)))))?xs.arr:(function (){var arr = [];
var xs__$1 = xs;
while(true){
if((!((xs__$1 == null)))){
arr.push(cljs.core._first(xs__$1));

var G__8466 = cljs.core._next(xs__$1);
xs__$1 = G__8466;
continue;
} else {
return arr;
}
break;
}
})());
var i = arr.length;
var r = cljs.core.List.EMPTY;
while(true){
if((i > (0))){
var G__8467 = (i - (1));
var G__8468 = cljs.core._conj(r,(arr[(i - (1))]));
i = G__8467;
r = G__8468;
continue;
} else {
return r;
}
break;
}
}));

(cljs.core.list.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(cljs.core.list.cljs$lang$applyTo = (function (seq6464){
var self__5712__auto__ = this;
return self__5712__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq6464));
}));


/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Cons = (function (meta,first,rest,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65929452;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
(cljs.core.Cons.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.Cons.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.Cons.prototype.indexOf = (function() {
var G__8471 = null;
var G__8471__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__8471__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__8471 = function(x,start){
switch(arguments.length){
case 1:
return G__8471__1.call(this,x);
case 2:
return G__8471__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8471.cljs$core$IFn$_invoke$arity$1 = G__8471__1;
G__8471.cljs$core$IFn$_invoke$arity$2 = G__8471__2;
return G__8471;
})()
);

(cljs.core.Cons.prototype.lastIndexOf = (function() {
var G__8472 = null;
var G__8472__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__8472__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__8472 = function(x,start){
switch(arguments.length){
case 1:
return G__8472__1.call(this,x);
case 2:
return G__8472__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8472.cljs$core$IFn$_invoke$arity$1 = G__8472__1;
G__8472.cljs$core$IFn$_invoke$arity$2 = G__8472__2;
return G__8472;
})()
);

(cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Cons.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Cons(self__.meta,self__.first,self__.rest,self__.__hash));
}));

(cljs.core.Cons.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return null;
} else {
return cljs.core.seq(self__.rest);
}
}));

(cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
}));

(cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
}));

(cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.Cons(new_meta,self__.first,self__.rest,self__.__hash));
}
}));

(cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.Cons(null,o,coll__$1,null));
}));

(cljs.core.Cons.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rest","rest",398835108,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Cons.cljs$lang$type = true);

(cljs.core.Cons.cljs$lang$ctorStr = "cljs.core/Cons");

(cljs.core.Cons.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/Cons");
}));

/**
 * Positional factory function for cljs.core/Cons.
 */
cljs.core.__GT_Cons = (function cljs$core$__GT_Cons(meta,first,rest,__hash){
return (new cljs.core.Cons(meta,first,rest,__hash));
});

(cljs.core.Cons.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));
/**
 * Returns a new seq where x is the first element and coll is the rest.
 */
cljs.core.cons = (function cljs$core$cons(x,coll){
if((coll == null)){
return (new cljs.core.List(null,x,null,(1),null));
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false)){
return (new cljs.core.Cons(null,x,coll,null));
} else {
return (new cljs.core.Cons(null,x,cljs.core.seq(coll),null));

}
}
});
cljs.core.hash_keyword = (function cljs$core$hash_keyword(k){
return ((cljs.core.hash_symbol(k) + (2654435769)) | (0));
});
cljs.core.compare_keywords = (function cljs$core$compare_keywords(a,b){
if((a.fqn === b.fqn)){
return (0);
} else {
if(cljs.core.truth_((function (){var and__5000__auto__ = cljs.core.not(a.ns);
if(and__5000__auto__){
return b.ns;
} else {
return and__5000__auto__;
}
})())){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = cljs.core.goog$module$goog$array.defaultCompare(a.ns,b.ns);
if(((0) === nsc)){
return cljs.core.goog$module$goog$array.defaultCompare(a.name,b.name);
} else {
return nsc;
}
}
} else {
return cljs.core.goog$module$goog$array.defaultCompare(a.name,b.name);

}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.INamed}
 * @implements {cljs.core.IPrintWithWriter}
*/
cljs.core.Keyword = (function (ns,name,fqn,_hash){
this.ns = ns;
this.name = name;
this.fqn = fqn;
this._hash = _hash;
this.cljs$lang$protocol_mask$partition0$ = 2153775105;
this.cljs$lang$protocol_mask$partition1$ = 4096;
});
(cljs.core.Keyword.prototype.toString = (function (){
var self__ = this;
var _ = this;
return [":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.fqn)].join('');
}));

(cljs.core.Keyword.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.Keyword.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Keyword)){
return (self__.fqn === other.fqn);
} else {
return false;
}
}));

(cljs.core.Keyword.prototype.call = (function (unused__10318__auto__){
var self__ = this;
var self__ = this;
var G__6467 = (arguments.length - (1));
switch (G__6467) {
case (1):
return self__.cljs$core$IFn$_invoke$arity$1((arguments[(1)]));

break;
case (2):
return self__.cljs$core$IFn$_invoke$arity$2((arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (1)))].join('')));

}
}));

(cljs.core.Keyword.prototype.apply = (function (self__,args6466){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args6466)));
}));

(cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);
}));

(cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$2 = (function (coll,not_found){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);
}));

(cljs.core.Keyword.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__5111__auto__ = self__._hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_keyword(this$__$1);
(self__._hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.Keyword.prototype.cljs$core$INamed$_name$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.name;
}));

(cljs.core.Keyword.prototype.cljs$core$INamed$_namespace$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ns;
}));

(cljs.core.Keyword.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,[":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.fqn)].join(''));
}));

(cljs.core.Keyword.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ns","ns",2082130287,null),new cljs.core.Symbol(null,"name","name",-810760592,null),new cljs.core.Symbol(null,"fqn","fqn",-1749334463,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_hash","_hash",-2130838312,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Keyword.cljs$lang$type = true);

(cljs.core.Keyword.cljs$lang$ctorStr = "cljs.core/Keyword");

(cljs.core.Keyword.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/Keyword");
}));

/**
 * Positional factory function for cljs.core/Keyword.
 */
cljs.core.__GT_Keyword = (function cljs$core$__GT_Keyword(ns,name,fqn,_hash){
return (new cljs.core.Keyword(ns,name,fqn,_hash));
});

/**
 * Return true if x is a Keyword
 */
cljs.core.keyword_QMARK_ = (function cljs$core$keyword_QMARK_(x){
return (x instanceof cljs.core.Keyword);
});
/**
 * Efficient test to determine that two keywords are identical.
 */
cljs.core.keyword_identical_QMARK_ = (function cljs$core$keyword_identical_QMARK_(x,y){
if((x === y)){
return true;
} else {
if((((x instanceof cljs.core.Keyword)) && ((y instanceof cljs.core.Keyword)))){
return (x.fqn === y.fqn);
} else {
return false;
}
}
});
/**
 * Efficient test to determine that two symbols are identical.
 */
cljs.core.symbol_identical_QMARK_ = (function cljs$core$symbol_identical_QMARK_(x,y){
if((x === y)){
return true;
} else {
if((((x instanceof cljs.core.Symbol)) && ((y instanceof cljs.core.Symbol)))){
return (x.str === y.str);
} else {
return false;
}
}
});
/**
 * Returns the namespace String of a symbol or keyword, or nil if not present.
 */
cljs.core.namespace = (function cljs$core$namespace(x){
if((((!((x == null))))?(((((x.cljs$lang$protocol_mask$partition1$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$INamed$))))?true:false):false)){
return x.cljs$core$INamed$_namespace$arity$1(null);
} else {
throw (new Error(["Doesn't support namespace: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('')));
}
});
/**
 * Return true if x is a symbol or keyword
 */
cljs.core.ident_QMARK_ = (function cljs$core$ident_QMARK_(x){
return (((x instanceof cljs.core.Keyword)) || ((x instanceof cljs.core.Symbol)));
});
/**
 * Return true if x is a symbol or keyword without a namespace
 */
cljs.core.simple_ident_QMARK_ = (function cljs$core$simple_ident_QMARK_(x){
return ((cljs.core.ident_QMARK_(x)) && ((cljs.core.namespace(x) == null)));
});
/**
 * Return true if x is a symbol or keyword with a namespace
 */
cljs.core.qualified_ident_QMARK_ = (function cljs$core$qualified_ident_QMARK_(x){
return cljs.core.boolean$((function (){var and__5000__auto__ = cljs.core.ident_QMARK_(x);
if(and__5000__auto__){
var and__5000__auto____$1 = cljs.core.namespace(x);
if(cljs.core.truth_(and__5000__auto____$1)){
return true;
} else {
return and__5000__auto____$1;
}
} else {
return and__5000__auto__;
}
})());
});
/**
 * Return true if x is a symbol without a namespace
 */
cljs.core.simple_symbol_QMARK_ = (function cljs$core$simple_symbol_QMARK_(x){
return (((x instanceof cljs.core.Symbol)) && ((cljs.core.namespace(x) == null)));
});
/**
 * Return true if x is a symbol with a namespace
 */
cljs.core.qualified_symbol_QMARK_ = (function cljs$core$qualified_symbol_QMARK_(x){
return cljs.core.boolean$((function (){var and__5000__auto__ = (x instanceof cljs.core.Symbol);
if(and__5000__auto__){
var and__5000__auto____$1 = cljs.core.namespace(x);
if(cljs.core.truth_(and__5000__auto____$1)){
return true;
} else {
return and__5000__auto____$1;
}
} else {
return and__5000__auto__;
}
})());
});
/**
 * Return true if x is a keyword without a namespace
 */
cljs.core.simple_keyword_QMARK_ = (function cljs$core$simple_keyword_QMARK_(x){
return (((x instanceof cljs.core.Keyword)) && ((cljs.core.namespace(x) == null)));
});
/**
 * Return true if x is a keyword with a namespace
 */
cljs.core.qualified_keyword_QMARK_ = (function cljs$core$qualified_keyword_QMARK_(x){
return cljs.core.boolean$((function (){var and__5000__auto__ = (x instanceof cljs.core.Keyword);
if(and__5000__auto__){
var and__5000__auto____$1 = cljs.core.namespace(x);
if(cljs.core.truth_(and__5000__auto____$1)){
return true;
} else {
return and__5000__auto____$1;
}
} else {
return and__5000__auto__;
}
})());
});
/**
 * Returns a Keyword with the given namespace and name.  Do not use :
 *   in the keyword strings, it will be added automatically.
 */
cljs.core.keyword = (function cljs$core$keyword(var_args){
var G__6470 = arguments.length;
switch (G__6470) {
case 1:
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.keyword.cljs$core$IFn$_invoke$arity$1 = (function (name){
if((name instanceof cljs.core.Keyword)){
return name;
} else {
if((name instanceof cljs.core.Symbol)){
return (new cljs.core.Keyword(cljs.core.namespace(name),(cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(name) : cljs.core.name.call(null,name)),name.str,null));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("/",name)){
return (new cljs.core.Keyword(null,name,name,null));
} else {
if(typeof name === 'string'){
var parts = name.split("/");
if((parts.length === (2))){
return (new cljs.core.Keyword((parts[(0)]),(parts[(1)]),name,null));
} else {
return (new cljs.core.Keyword(null,(parts[(0)]),name,null));
}
} else {
return null;
}
}
}
}
}));

(cljs.core.keyword.cljs$core$IFn$_invoke$arity$2 = (function (ns,name){
var ns__$1 = (((ns instanceof cljs.core.Keyword))?(cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(ns) : cljs.core.name.call(null,ns)):(((ns instanceof cljs.core.Symbol))?(cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(ns) : cljs.core.name.call(null,ns)):ns
));
var name__$1 = (((name instanceof cljs.core.Keyword))?(cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(name) : cljs.core.name.call(null,name)):(((name instanceof cljs.core.Symbol))?(cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(name) : cljs.core.name.call(null,name)):name
));
return (new cljs.core.Keyword(ns__$1,name__$1,[(cljs.core.truth_(ns__$1)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns__$1),"/"].join(''):null),cljs.core.str.cljs$core$IFn$_invoke$arity$1(name__$1)].join(''),null));
}));

(cljs.core.keyword.cljs$lang$maxFixedArity = 2);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.LazySeq = (function (meta,fn,s,__hash){
this.meta = meta;
this.fn = fn;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 1;
});
(cljs.core.LazySeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.LazySeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.LazySeq.prototype.sval = (function (){
var self__ = this;
var coll = this;
if((self__.fn == null)){
return self__.s;
} else {
(self__.s = (self__.fn.cljs$core$IFn$_invoke$arity$0 ? self__.fn.cljs$core$IFn$_invoke$arity$0() : self__.fn.call(null)));

(self__.fn = null);

return self__.s;
}
}));

(cljs.core.LazySeq.prototype.indexOf = (function() {
var G__8477 = null;
var G__8477__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__8477__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__8477 = function(x,start){
switch(arguments.length){
case 1:
return G__8477__1.call(this,x);
case 2:
return G__8477__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8477.cljs$core$IFn$_invoke$arity$1 = G__8477__1;
G__8477.cljs$core$IFn$_invoke$arity$2 = G__8477__2;
return G__8477;
})()
);

(cljs.core.LazySeq.prototype.lastIndexOf = (function() {
var G__8478 = null;
var G__8478__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__8478__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__8478 = function(x,start){
switch(arguments.length){
case 1:
return G__8478__1.call(this,x);
case 2:
return G__8478__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8478.cljs$core$IFn$_invoke$arity$1 = G__8478__1;
G__8478.cljs$core$IFn$_invoke$arity$2 = G__8478__2;
return G__8478;
})()
);

(cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.LazySeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
coll__$1.cljs$core$ISeqable$_seq$arity$1(null);

if((self__.s == null)){
return null;
} else {
return cljs.core.next(self__.s);
}
}));

(cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);
}));

(cljs.core.LazySeq.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.not(self__.fn);
}));

(cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
coll__$1.cljs$core$ISeqable$_seq$arity$1(null);

if((self__.s == null)){
return null;
} else {
return cljs.core.first(self__.s);
}
}));

(cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
coll__$1.cljs$core$ISeqable$_seq$arity$1(null);

if((!((self__.s == null)))){
return cljs.core.rest(self__.s);
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
coll__$1.sval();

if((self__.s == null)){
return null;
} else {
var ls = self__.s;
while(true){
if((ls instanceof cljs.core.LazySeq)){
var G__8479 = ls.sval();
ls = G__8479;
continue;
} else {
(self__.s = ls);

return cljs.core.seq(self__.s);
}
break;
}
}
}));

(cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.LazySeq(new_meta,(function (){
return coll__$1.cljs$core$ISeqable$_seq$arity$1(null);
}),null,self__.__hash));
}
}));

(cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.LazySeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),cljs.core.with_meta(new cljs.core.Symbol(null,"fn","fn",465265323,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.LazySeq.cljs$lang$type = true);

(cljs.core.LazySeq.cljs$lang$ctorStr = "cljs.core/LazySeq");

(cljs.core.LazySeq.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/LazySeq");
}));

/**
 * Positional factory function for cljs.core/LazySeq.
 */
cljs.core.__GT_LazySeq = (function cljs$core$__GT_LazySeq(meta,fn,s,__hash){
return (new cljs.core.LazySeq(meta,fn,s,__hash));
});

(cljs.core.LazySeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.ICounted}
*/
cljs.core.ChunkBuffer = (function (buf,end){
this.buf = buf;
this.end = end;
this.cljs$lang$protocol_mask$partition0$ = 2;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.ChunkBuffer.prototype.add = (function (o){
var self__ = this;
var _ = this;
(self__.buf[self__.end] = o);

return (self__.end = (self__.end + (1)));
}));

(cljs.core.ChunkBuffer.prototype.chunk = (function (){
var self__ = this;
var _ = this;
var ret = (new cljs.core.ArrayChunk(self__.buf,(0),self__.end));
(self__.buf = null);

return ret;
}));

(cljs.core.ChunkBuffer.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.end;
}));

(cljs.core.ChunkBuffer.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"buf","buf",1426618187,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ChunkBuffer.cljs$lang$type = true);

(cljs.core.ChunkBuffer.cljs$lang$ctorStr = "cljs.core/ChunkBuffer");

(cljs.core.ChunkBuffer.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/ChunkBuffer");
}));

/**
 * Positional factory function for cljs.core/ChunkBuffer.
 */
cljs.core.__GT_ChunkBuffer = (function cljs$core$__GT_ChunkBuffer(buf,end){
return (new cljs.core.ChunkBuffer(buf,end));
});

cljs.core.chunk_buffer = (function cljs$core$chunk_buffer(capacity){
return (new cljs.core.ChunkBuffer((new Array(capacity)),(0)));
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.IChunk}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ArrayChunk = (function (arr,off,end){
this.arr = arr;
this.off = off;
this.end = end;
this.cljs$lang$protocol_mask$partition0$ = 524306;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.ArrayChunk.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.end - self__.off);
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,i){
var self__ = this;
var coll__$1 = this;
return (self__.arr[(self__.off + i)]);
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,i,not_found){
var self__ = this;
var coll__$1 = this;
if((((i >= (0))) && ((i < (self__.end - self__.off))))){
return (self__.arr[(self__.off + i)]);
} else {
return not_found;
}
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IChunk$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.ArrayChunk.prototype.cljs$core$IChunk$_drop_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.off === self__.end)){
throw (new Error("-drop-first of empty chunk"));
} else {
return (new cljs.core.ArrayChunk(self__.arr,(self__.off + (1)),self__.end));
}
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.off]),(self__.off + (1)));
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.off);
}));

(cljs.core.ArrayChunk.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"off","off",-2047994980,null),new cljs.core.Symbol(null,"end","end",1372345569,null)], null);
}));

(cljs.core.ArrayChunk.cljs$lang$type = true);

(cljs.core.ArrayChunk.cljs$lang$ctorStr = "cljs.core/ArrayChunk");

(cljs.core.ArrayChunk.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/ArrayChunk");
}));

/**
 * Positional factory function for cljs.core/ArrayChunk.
 */
cljs.core.__GT_ArrayChunk = (function cljs$core$__GT_ArrayChunk(arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
});

cljs.core.array_chunk = (function cljs$core$array_chunk(var_args){
var G__6472 = arguments.length;
switch (G__6472) {
case 1:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1 = (function (arr){
return (new cljs.core.ArrayChunk(arr,(0),arr.length));
}));

(cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2 = (function (arr,off){
return (new cljs.core.ArrayChunk(arr,off,arr.length));
}));

(cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3 = (function (arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
}));

(cljs.core.array_chunk.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IChunkedNext}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IChunkedSeq}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.ChunkedCons = (function (chunk,more,meta,__hash){
this.chunk = chunk;
this.more = more;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31850732;
this.cljs$lang$protocol_mask$partition1$ = 1536;
});
(cljs.core.ChunkedCons.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.ChunkedCons.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.ChunkedCons.prototype.indexOf = (function() {
var G__8483 = null;
var G__8483__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__8483__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__8483 = function(x,start){
switch(arguments.length){
case 1:
return G__8483__1.call(this,x);
case 2:
return G__8483__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8483.cljs$core$IFn$_invoke$arity$1 = G__8483__1;
G__8483.cljs$core$IFn$_invoke$arity$2 = G__8483__2;
return G__8483;
})()
);

(cljs.core.ChunkedCons.prototype.lastIndexOf = (function() {
var G__8484 = null;
var G__8484__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__8484__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__8484 = function(x,start){
switch(arguments.length){
case 1:
return G__8484__1.call(this,x);
case 2:
return G__8484__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8484.cljs$core$IFn$_invoke$arity$1 = G__8484__1;
G__8484.cljs$core$IFn$_invoke$arity$2 = G__8484__2;
return G__8484;
})()
);

(cljs.core.ChunkedCons.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.ChunkedCons.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,null,null));
} else {
if((self__.more == null)){
return null;
} else {
return cljs.core._seq(self__.more);
}
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth(self__.chunk,(0));
}));

(cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,null,null));
} else {
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.chunk;
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.ChunkedCons(self__.chunk,self__.more,new_meta,self__.__hash));
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,o){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons(o,this$__$1);
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return null;
} else {
return self__.more;
}
}));

(cljs.core.ChunkedCons.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"chunk","chunk",449371907,null),new cljs.core.Symbol(null,"more","more",-418290273,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ChunkedCons.cljs$lang$type = true);

(cljs.core.ChunkedCons.cljs$lang$ctorStr = "cljs.core/ChunkedCons");

(cljs.core.ChunkedCons.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/ChunkedCons");
}));

/**
 * Positional factory function for cljs.core/ChunkedCons.
 */
cljs.core.__GT_ChunkedCons = (function cljs$core$__GT_ChunkedCons(chunk,more,meta,__hash){
return (new cljs.core.ChunkedCons(chunk,more,meta,__hash));
});

(cljs.core.ChunkedCons.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));
cljs.core.chunk_cons = (function cljs$core$chunk_cons(chunk,rest){
if((cljs.core._count(chunk) === (0))){
return rest;
} else {
return (new cljs.core.ChunkedCons(chunk,rest,null,null));
}
});
cljs.core.chunk_append = (function cljs$core$chunk_append(b,x){
return b.add(x);
});
cljs.core.chunk = (function cljs$core$chunk(b){
return b.chunk();
});
cljs.core.chunk_first = (function cljs$core$chunk_first(s){
return cljs.core._chunked_first(s);
});
cljs.core.chunk_rest = (function cljs$core$chunk_rest(s){
return cljs.core._chunked_rest(s);
});
cljs.core.chunk_next = (function cljs$core$chunk_next(s){
if((((!((s == null))))?(((((s.cljs$lang$protocol_mask$partition1$ & (1024))) || ((cljs.core.PROTOCOL_SENTINEL === s.cljs$core$IChunkedNext$))))?true:false):false)){
return s.cljs$core$IChunkedNext$_chunked_next$arity$1(null);
} else {
return cljs.core.seq(cljs.core._chunked_rest(s));
}
});
/**
 * Returns an array containing the contents of coll.
 */
cljs.core.to_array = (function cljs$core$to_array(coll){
var ary = [];
var s = cljs.core.seq(coll);
while(true){
if((!((s == null)))){
ary.push(cljs.core.first(s));

var G__8487 = cljs.core.next(s);
s = G__8487;
continue;
} else {
return ary;
}
break;
}
});
/**
 * Returns a (potentially-ragged) 2-dimensional array
 *   containing the contents of coll.
 */
cljs.core.to_array_2d = (function cljs$core$to_array_2d(coll){
var ret = (new Array(cljs.core.count(coll)));
var i_8488 = (0);
var xs_8489 = cljs.core.seq(coll);
while(true){
if((xs_8489 == null)){
} else {
(ret[i_8488] = cljs.core.to_array(cljs.core.first(xs_8489)));

var G__8490 = (i_8488 + (1));
var G__8491 = cljs.core.next(xs_8489);
i_8488 = G__8490;
xs_8489 = G__8491;
continue;
}
break;
}

return ret;
});
/**
 * Creates an array of ints. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.int_array = (function cljs$core$int_array(var_args){
var G__6475 = arguments.length;
switch (G__6475) {
case 1:
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.int_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
}));

(cljs.core.int_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if(((s__$1) && ((i < size)))){
(a[i] = cljs.core.first(s__$1));

var G__8494 = (i + (1));
var G__8495 = cljs.core.next(s__$1);
i = G__8494;
s__$1 = G__8495;
continue;
} else {
return a;
}
break;
}
} else {
var n__5593__auto___8496 = size;
var i_8497 = (0);
while(true){
if((i_8497 < n__5593__auto___8496)){
(a[i_8497] = init_val_or_seq);

var G__8498 = (i_8497 + (1));
i_8497 = G__8498;
continue;
} else {
}
break;
}

return a;
}
}));

(cljs.core.int_array.cljs$lang$maxFixedArity = 2);

/**
 * Creates an array of longs. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.long_array = (function cljs$core$long_array(var_args){
var G__6477 = arguments.length;
switch (G__6477) {
case 1:
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.long_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
}));

(cljs.core.long_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if(((s__$1) && ((i < size)))){
(a[i] = cljs.core.first(s__$1));

var G__8500 = (i + (1));
var G__8501 = cljs.core.next(s__$1);
i = G__8500;
s__$1 = G__8501;
continue;
} else {
return a;
}
break;
}
} else {
var n__5593__auto___8502 = size;
var i_8503 = (0);
while(true){
if((i_8503 < n__5593__auto___8502)){
(a[i_8503] = init_val_or_seq);

var G__8504 = (i_8503 + (1));
i_8503 = G__8504;
continue;
} else {
}
break;
}

return a;
}
}));

(cljs.core.long_array.cljs$lang$maxFixedArity = 2);

/**
 * Creates an array of doubles. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.double_array = (function cljs$core$double_array(var_args){
var G__6479 = arguments.length;
switch (G__6479) {
case 1:
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.double_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
}));

(cljs.core.double_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if(((s__$1) && ((i < size)))){
(a[i] = cljs.core.first(s__$1));

var G__8506 = (i + (1));
var G__8507 = cljs.core.next(s__$1);
i = G__8506;
s__$1 = G__8507;
continue;
} else {
return a;
}
break;
}
} else {
var n__5593__auto___8508 = size;
var i_8509 = (0);
while(true){
if((i_8509 < n__5593__auto___8508)){
(a[i_8509] = init_val_or_seq);

var G__8510 = (i_8509 + (1));
i_8509 = G__8510;
continue;
} else {
}
break;
}

return a;
}
}));

(cljs.core.double_array.cljs$lang$maxFixedArity = 2);

/**
 * Creates an array of objects. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.object_array = (function cljs$core$object_array(var_args){
var G__6481 = arguments.length;
switch (G__6481) {
case 1:
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.object_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
}));

(cljs.core.object_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if(((s__$1) && ((i < size)))){
(a[i] = cljs.core.first(s__$1));

var G__8517 = (i + (1));
var G__8518 = cljs.core.next(s__$1);
i = G__8517;
s__$1 = G__8518;
continue;
} else {
return a;
}
break;
}
} else {
var n__5593__auto___8519 = size;
var i_8520 = (0);
while(true){
if((i_8520 < n__5593__auto___8519)){
(a[i_8520] = init_val_or_seq);

var G__8521 = (i_8520 + (1));
i_8520 = G__8521;
continue;
} else {
}
break;
}

return a;
}
}));

(cljs.core.object_array.cljs$lang$maxFixedArity = 2);

/**
 * If coll is counted? returns its count, else will count at most the first n
 * elements of coll using its seq
 */
cljs.core.bounded_count = (function cljs$core$bounded_count(n,coll){
if(cljs.core.counted_QMARK_(coll)){
return cljs.core.count(coll);
} else {
var i = (0);
var s = cljs.core.seq(coll);
while(true){
if((((!((s == null)))) && ((i < n)))){
var G__8522 = (i + (1));
var G__8523 = cljs.core.next(s);
i = G__8522;
s = G__8523;
continue;
} else {
return i;
}
break;
}
}
});
cljs.core.spread = (function cljs$core$spread(arglist){
if((arglist == null)){
return null;
} else {
var n = cljs.core.next(arglist);
if((n == null)){
return cljs.core.seq(cljs.core.first(arglist));
} else {
return cljs.core.cons(cljs.core.first(arglist),(cljs.core.spread.cljs$core$IFn$_invoke$arity$1 ? cljs.core.spread.cljs$core$IFn$_invoke$arity$1(n) : cljs.core.spread.call(null,n)));
}
}
});
/**
 * Returns a lazy seq representing the concatenation of the elements in the supplied colls.
 */
cljs.core.concat = (function cljs$core$concat(var_args){
var G__6486 = arguments.length;
switch (G__6486) {
case 0:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8525 = arguments.length;
var i__5727__auto___8526 = (0);
while(true){
if((i__5727__auto___8526 < len__5726__auto___8525)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8526]));

var G__8527 = (i__5727__auto___8526 + (1));
i__5727__auto___8526 = G__8527;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.concat.cljs$core$IFn$_invoke$arity$0 = (function (){
return (new cljs.core.LazySeq(null,(function (){
return null;
}),null,null));
}));

(cljs.core.concat.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (new cljs.core.LazySeq(null,(function (){
return x;
}),null,null));
}));

(cljs.core.concat.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (new cljs.core.LazySeq(null,(function (){
var s = cljs.core.seq(x);
if(s){
if(cljs.core.chunked_seq_QMARK_(s)){
return cljs.core.chunk_cons(cljs.core.chunk_first(s),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.chunk_rest(s),y));
} else {
return cljs.core.cons(cljs.core.first(s),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s),y));
}
} else {
return y;
}
}),null,null));
}));

(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,zs){
var cat = (function cljs$core$cat(xys,zs__$1){
return (new cljs.core.LazySeq(null,(function (){
var xys__$1 = cljs.core.seq(xys);
if(xys__$1){
if(cljs.core.chunked_seq_QMARK_(xys__$1)){
return cljs.core.chunk_cons(cljs.core.chunk_first(xys__$1),cljs$core$cat(cljs.core.chunk_rest(xys__$1),zs__$1));
} else {
return cljs.core.cons(cljs.core.first(xys__$1),cljs$core$cat(cljs.core.rest(xys__$1),zs__$1));
}
} else {
if(cljs.core.truth_(zs__$1)){
return cljs$core$cat(cljs.core.first(zs__$1),cljs.core.next(zs__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(x,y),zs);
}));

/** @this {Function} */
(cljs.core.concat.cljs$lang$applyTo = (function (seq6483){
var G__6484 = cljs.core.first(seq6483);
var seq6483__$1 = cljs.core.next(seq6483);
var G__6485 = cljs.core.first(seq6483__$1);
var seq6483__$2 = cljs.core.next(seq6483__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6484,G__6485,seq6483__$2);
}));

(cljs.core.concat.cljs$lang$maxFixedArity = (2));

/**
 * Creates a new list containing the items prepended to the rest, the
 *   last of which will be treated as a sequence.
 */
cljs.core.list_STAR_ = (function cljs$core$list_STAR_(var_args){
var G__6493 = arguments.length;
switch (G__6493) {
case 1:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8529 = arguments.length;
var i__5727__auto___8530 = (0);
while(true){
if((i__5727__auto___8530 < len__5726__auto___8529)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8530]));

var G__8531 = (i__5727__auto___8530 + (1));
i__5727__auto___8530 = G__8531;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((4) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((4)),(0),null)):null);
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__5752__auto__);

}
});

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (args){
return cljs.core.seq(args);
}));

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (a,args){
return cljs.core.cons(a,args);
}));

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3 = (function (a,b,args){
return cljs.core.cons(a,cljs.core.cons(b,args));
}));

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,args){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,args)));
}));

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,more){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,cljs.core.spread(more)))));
}));

/** @this {Function} */
(cljs.core.list_STAR_.cljs$lang$applyTo = (function (seq6488){
var G__6489 = cljs.core.first(seq6488);
var seq6488__$1 = cljs.core.next(seq6488);
var G__6490 = cljs.core.first(seq6488__$1);
var seq6488__$2 = cljs.core.next(seq6488__$1);
var G__6491 = cljs.core.first(seq6488__$2);
var seq6488__$3 = cljs.core.next(seq6488__$2);
var G__6492 = cljs.core.first(seq6488__$3);
var seq6488__$4 = cljs.core.next(seq6488__$3);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6489,G__6490,G__6491,G__6492,seq6488__$4);
}));

(cljs.core.list_STAR_.cljs$lang$maxFixedArity = (4));

/**
 * Returns a new, transient version of the collection, in constant time.
 */
cljs.core.transient$ = (function cljs$core$transient(coll){
return cljs.core._as_transient(coll);
});
/**
 * Returns a new, persistent version of the transient collection, in
 *   constant time. The transient collection cannot be used after this
 *   call, any such use will throw an exception.
 */
cljs.core.persistent_BANG_ = (function cljs$core$persistent_BANG_(tcoll){
return cljs.core._persistent_BANG_(tcoll);
});
/**
 * Adds val to the transient collection, and return tcoll. The 'addition'
 *   may happen at different 'places' depending on the concrete type.
 */
cljs.core.conj_BANG_ = (function cljs$core$conj_BANG_(var_args){
var G__6498 = arguments.length;
switch (G__6498) {
case 0:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8533 = arguments.length;
var i__5727__auto___8534 = (0);
while(true){
if((i__5727__auto___8534 < len__5726__auto___8533)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8534]));

var G__8535 = (i__5727__auto___8534 + (1));
i__5727__auto___8534 = G__8535;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.transient$(cljs.core.PersistentVector.EMPTY);
}));

(cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (tcoll){
return tcoll;
}));

(cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (tcoll,val){
return cljs.core._conj_BANG_(tcoll,val);
}));

(cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,val,vals){
while(true){
var ntcoll = cljs.core._conj_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__8536 = ntcoll;
var G__8537 = cljs.core.first(vals);
var G__8538 = cljs.core.next(vals);
tcoll = G__8536;
val = G__8537;
vals = G__8538;
continue;
} else {
return ntcoll;
}
break;
}
}));

/** @this {Function} */
(cljs.core.conj_BANG_.cljs$lang$applyTo = (function (seq6495){
var G__6496 = cljs.core.first(seq6495);
var seq6495__$1 = cljs.core.next(seq6495);
var G__6497 = cljs.core.first(seq6495__$1);
var seq6495__$2 = cljs.core.next(seq6495__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6496,G__6497,seq6495__$2);
}));

(cljs.core.conj_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * When applied to a transient map, adds mapping of key(s) to
 *   val(s). When applied to a transient vector, sets the val at index.
 *   Note - index must be <= (count vector). Returns coll.
 */
cljs.core.assoc_BANG_ = (function cljs$core$assoc_BANG_(var_args){
var G__6504 = arguments.length;
switch (G__6504) {
case 3:
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8543 = arguments.length;
var i__5727__auto___8544 = (0);
while(true){
if((i__5727__auto___8544 < len__5726__auto___8543)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8544]));

var G__8545 = (i__5727__auto___8544 + (1));
i__5727__auto___8544 = G__8545;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((3) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((3)),(0),null)):null);
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5752__auto__);

}
});

(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (tcoll,key,val){
return cljs.core._assoc_BANG_(tcoll,key,val);
}));

(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,key,val,kvs){
while(true){
var ntcoll = cljs.core._assoc_BANG_(tcoll,key,val);
if(cljs.core.truth_(kvs)){
var G__8546 = ntcoll;
var G__8547 = cljs.core.first(kvs);
var G__8548 = cljs.core.second(kvs);
var G__8549 = cljs.core.nnext(kvs);
tcoll = G__8546;
key = G__8547;
val = G__8548;
kvs = G__8549;
continue;
} else {
return ntcoll;
}
break;
}
}));

/** @this {Function} */
(cljs.core.assoc_BANG_.cljs$lang$applyTo = (function (seq6500){
var G__6501 = cljs.core.first(seq6500);
var seq6500__$1 = cljs.core.next(seq6500);
var G__6502 = cljs.core.first(seq6500__$1);
var seq6500__$2 = cljs.core.next(seq6500__$1);
var G__6503 = cljs.core.first(seq6500__$2);
var seq6500__$3 = cljs.core.next(seq6500__$2);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6501,G__6502,G__6503,seq6500__$3);
}));

(cljs.core.assoc_BANG_.cljs$lang$maxFixedArity = (3));

/**
 * Returns a transient map that doesn't contain a mapping for key(s).
 */
cljs.core.dissoc_BANG_ = (function cljs$core$dissoc_BANG_(var_args){
var G__6509 = arguments.length;
switch (G__6509) {
case 2:
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8551 = arguments.length;
var i__5727__auto___8552 = (0);
while(true){
if((i__5727__auto___8552 < len__5726__auto___8551)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8552]));

var G__8553 = (i__5727__auto___8552 + (1));
i__5727__auto___8552 = G__8553;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (tcoll,key){
return cljs.core._dissoc_BANG_(tcoll,key);
}));

(cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,key,ks){
while(true){
var ntcoll = cljs.core._dissoc_BANG_(tcoll,key);
if(cljs.core.truth_(ks)){
var G__8554 = ntcoll;
var G__8555 = cljs.core.first(ks);
var G__8556 = cljs.core.next(ks);
tcoll = G__8554;
key = G__8555;
ks = G__8556;
continue;
} else {
return ntcoll;
}
break;
}
}));

/** @this {Function} */
(cljs.core.dissoc_BANG_.cljs$lang$applyTo = (function (seq6506){
var G__6507 = cljs.core.first(seq6506);
var seq6506__$1 = cljs.core.next(seq6506);
var G__6508 = cljs.core.first(seq6506__$1);
var seq6506__$2 = cljs.core.next(seq6506__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6507,G__6508,seq6506__$2);
}));

(cljs.core.dissoc_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * Removes the last item from a transient vector. If
 *   the collection is empty, throws an exception. Returns tcoll
 */
cljs.core.pop_BANG_ = (function cljs$core$pop_BANG_(tcoll){
return cljs.core._pop_BANG_(tcoll);
});
/**
 * disj[oin]. Returns a transient set of the same (hashed/sorted) type, that
 *   does not contain key(s).
 */
cljs.core.disj_BANG_ = (function cljs$core$disj_BANG_(var_args){
var G__6514 = arguments.length;
switch (G__6514) {
case 2:
return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8558 = arguments.length;
var i__5727__auto___8559 = (0);
while(true){
if((i__5727__auto___8559 < len__5726__auto___8558)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8559]));

var G__8560 = (i__5727__auto___8559 + (1));
i__5727__auto___8559 = G__8560;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (tcoll,val){
return cljs.core._disjoin_BANG_(tcoll,val);
}));

(cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,val,vals){
while(true){
var ntcoll = cljs.core._disjoin_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__8561 = ntcoll;
var G__8562 = cljs.core.first(vals);
var G__8563 = cljs.core.next(vals);
tcoll = G__8561;
val = G__8562;
vals = G__8563;
continue;
} else {
return ntcoll;
}
break;
}
}));

/** @this {Function} */
(cljs.core.disj_BANG_.cljs$lang$applyTo = (function (seq6511){
var G__6512 = cljs.core.first(seq6511);
var seq6511__$1 = cljs.core.next(seq6511);
var G__6513 = cljs.core.first(seq6511__$1);
var seq6511__$2 = cljs.core.next(seq6511__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6512,G__6513,seq6511__$2);
}));

(cljs.core.disj_BANG_.cljs$lang$maxFixedArity = (2));


cljs.core.apply_to = (function cljs$core$apply_to(f,argc,args){
var args__$1 = cljs.core.seq(args);
if((argc === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var a1 = cljs.core._first(args__$1);
var args__$2 = cljs.core._rest(args__$1);
if((argc === (1))){
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(a1) : f.call(null,a1));
} else {
var b2 = cljs.core._first(args__$2);
var args__$3 = cljs.core._rest(args__$2);
if((argc === (2))){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(a1,b2) : f.call(null,a1,b2));
} else {
var c3 = cljs.core._first(args__$3);
var args__$4 = cljs.core._rest(args__$3);
if((argc === (3))){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(a1,b2,c3) : f.call(null,a1,b2,c3));
} else {
var d4 = cljs.core._first(args__$4);
var args__$5 = cljs.core._rest(args__$4);
if((argc === (4))){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(a1,b2,c3,d4) : f.call(null,a1,b2,c3,d4));
} else {
var e5 = cljs.core._first(args__$5);
var args__$6 = cljs.core._rest(args__$5);
if((argc === (5))){
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(a1,b2,c3,d4,e5) : f.call(null,a1,b2,c3,d4,e5));
} else {
var f6 = cljs.core._first(args__$6);
var args__$7 = cljs.core._rest(args__$6);
if((argc === (6))){
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(a1,b2,c3,d4,e5,f6) : f.call(null,a1,b2,c3,d4,e5,f6));
} else {
var g7 = cljs.core._first(args__$7);
var args__$8 = cljs.core._rest(args__$7);
if((argc === (7))){
return (f.cljs$core$IFn$_invoke$arity$7 ? f.cljs$core$IFn$_invoke$arity$7(a1,b2,c3,d4,e5,f6,g7) : f.call(null,a1,b2,c3,d4,e5,f6,g7));
} else {
var h8 = cljs.core._first(args__$8);
var args__$9 = cljs.core._rest(args__$8);
if((argc === (8))){
return (f.cljs$core$IFn$_invoke$arity$8 ? f.cljs$core$IFn$_invoke$arity$8(a1,b2,c3,d4,e5,f6,g7,h8) : f.call(null,a1,b2,c3,d4,e5,f6,g7,h8));
} else {
var i9 = cljs.core._first(args__$9);
var args__$10 = cljs.core._rest(args__$9);
if((argc === (9))){
return (f.cljs$core$IFn$_invoke$arity$9 ? f.cljs$core$IFn$_invoke$arity$9(a1,b2,c3,d4,e5,f6,g7,h8,i9) : f.call(null,a1,b2,c3,d4,e5,f6,g7,h8,i9));
} else {
var j10 = cljs.core._first(args__$10);
var args__$11 = cljs.core._rest(args__$10);
if((argc === (10))){
return (f.cljs$core$IFn$_invoke$arity$10 ? f.cljs$core$IFn$_invoke$arity$10(a1,b2,c3,d4,e5,f6,g7,h8,i9,j10) : f.call(null,a1,b2,c3,d4,e5,f6,g7,h8,i9,j10));
} else {
var k11 = cljs.core._first(args__$11);
var args__$12 = cljs.core._rest(args__$11);
if((argc === (11))){
return (f.cljs$core$IFn$_invoke$arity$11 ? f.cljs$core$IFn$_invoke$arity$11(a1,b2,c3,d4,e5,f6,g7,h8,i9,j10,k11) : f.call(null,a1,b2,c3,d4,e5,f6,g7,h8,i9,j10,k11));
} else {
var l12 = cljs.core._first(args__$12);
var args__$13 = cljs.core._rest(args__$12);
if((argc === (12))){
return (f.cljs$core$IFn$_invoke$arity$12 ? f.cljs$core$IFn$_invoke$arity$12(a1,b2,c3,d4,e5,f6,g7,h8,i9,j10,k11,l12) : f.call(null,a1,b2,c3,d4,e5,f6,g7,h8,i9,j10,k11,l12));
} else {
var m13 = cljs.core._first(args__$13);
var args__$14 = cljs.core._rest(args__$13);
if((argc === (13))){
return (f.cljs$core$IFn$_invoke$arity$13 ? f.cljs$core$IFn$_invoke$arity$13(a1,b2,c3,d4,e5,f6,g7,h8,i9,j10,k11,l12,m13) : f.call(null,a1,b2,c3,d4,e5,f6,g7,h8,i9,j10,k11,l12,m13));
} else {
var n14 = cljs.core._first(args__$14);
var args__$15 = cljs.core._rest(args__$14);
if((argc === (14))){
return (f.cljs$core$IFn$_invoke$arity$14 ? f.cljs$core$IFn$_invoke$arity$14(a1,b2,c3,d4,e5,f6,g7,h8,i9,j10,k11,l12,m13,n14) : f.call(null,a1,b2,c3,d4,e5,f6,g7,h8,i9,j10,k11,l12,m13,n14));
} else {
var o15 = cljs.core._first(args__$15);
var args__$16 = cljs.core._rest(args__$15);
if((argc === (15))){
return (f.cljs$core$IFn$_invoke$arity$15 ? f.cljs$core$IFn$_invoke$arity$15(a1,b2,c3,d4,e5,f6,g7,h8,i9,j10,k11,l12,m13,n14,o15) : f.call(null,a1,b2,c3,d4,e5,f6,g7,h8,i9,j10,k11,l12,m13,n14,o15));
} else {
var p16 = cljs.core._first(args__$16);
var args__$17 = cljs.core._rest(args__$16);
if((argc === (16))){
return (f.cljs$core$IFn$_invoke$arity$16 ? f.cljs$core$IFn$_invoke$arity$16(a1,b2,c3,d4,e5,f6,g7,h8,i9,j10,k11,l12,m13,n14,o15,p16) : f.call(null,a1,b2,c3,d4,e5,f6,g7,h8,i9,j10,k11,l12,m13,n14,o15,p16));
} else {
var q17 = cljs.core._first(args__$17);
var args__$18 = cljs.core._rest(args__$17);
if((argc === (17))){
return (f.cljs$core$IFn$_invoke$arity$17 ? f.cljs$core$IFn$_invoke$arity$17(a1,b2,c3,d4,e5,f6,g7,h8,i9,j10,k11,l12,m13,n14,o15,p16,q17) : f.call(null,a1,b2,c3,d4,e5,f6,g7,h8,i9,j10,k11,l12,m13,n14,o15,p16,q17));
} else {
var r18 = cljs.core._first(args__$18);
var args__$19 = cljs.core._rest(args__$18);
if((argc === (18))){
return (f.cljs$core$IFn$_invoke$arity$18 ? f.cljs$core$IFn$_invoke$arity$18(a1,b2,c3,d4,e5,f6,g7,h8,i9,j10,k11,l12,m13,n14,o15,p16,q17,r18) : f.call(null,a1,b2,c3,d4,e5,f6,g7,h8,i9,j10,k11,l12,m13,n14,o15,p16,q17,r18));
} else {
var s19 = cljs.core._first(args__$19);
var args__$20 = cljs.core._rest(args__$19);
if((argc === (19))){
return (f.cljs$core$IFn$_invoke$arity$19 ? f.cljs$core$IFn$_invoke$arity$19(a1,b2,c3,d4,e5,f6,g7,h8,i9,j10,k11,l12,m13,n14,o15,p16,q17,r18,s19) : f.call(null,a1,b2,c3,d4,e5,f6,g7,h8,i9,j10,k11,l12,m13,n14,o15,p16,q17,r18,s19));
} else {
var t20 = cljs.core._first(args__$20);
var args__$21 = cljs.core._rest(args__$20);
if((argc === (20))){
return (f.cljs$core$IFn$_invoke$arity$20 ? f.cljs$core$IFn$_invoke$arity$20(a1,b2,c3,d4,e5,f6,g7,h8,i9,j10,k11,l12,m13,n14,o15,p16,q17,r18,s19,t20) : f.call(null,a1,b2,c3,d4,e5,f6,g7,h8,i9,j10,k11,l12,m13,n14,o15,p16,q17,r18,s19,t20));
} else {
throw (new Error("Only up to 20 arguments supported on functions"));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});

/**
 * Internal. DO NOT USE! Next without the nil? check.
 */
cljs.core.next_STAR_ = (function cljs$core$next_STAR_(coll){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$INext$))))?true:false):false)){
return coll.cljs$core$INext$_next$arity$1(null);
} else {
return cljs.core.seq(cljs.core.rest(coll));
}
});
/**
 * Internal. DO NOT USE!
 *   Assumes args was already called with seq beforehand!
 */
cljs.core.apply_to_simple = (function cljs$core$apply_to_simple(var_args){
var G__6517 = arguments.length;
switch (G__6517) {
case 2:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$2 = (function (f,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$0){
return f.cljs$core$IFn$_invoke$arity$0();
} else {
return f.call(f);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3(f,cljs.core._first(args),cljs.core.next_STAR_(args));
}
}));

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3 = (function (f,a0,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$1){
return f.cljs$core$IFn$_invoke$arity$1(a0);
} else {
return f.call(f,a0);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4(f,a0,cljs.core._first(args),cljs.core.next_STAR_(args));
}
}));

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4 = (function (f,a0,a1,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$2){
return f.cljs$core$IFn$_invoke$arity$2(a0,a1);
} else {
return f.call(f,a0,a1);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5(f,a0,a1,cljs.core._first(args),cljs.core.next_STAR_(args));
}
}));

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5 = (function (f,a0,a1,a2,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$3){
return f.cljs$core$IFn$_invoke$arity$3(a0,a1,a2);
} else {
return f.call(f,a0,a1,a2);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6(f,a0,a1,a2,cljs.core._first(args),cljs.core.next_STAR_(args));
}
}));

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6 = (function (f,a0,a1,a2,a3,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$4){
return f.cljs$core$IFn$_invoke$arity$4(a0,a1,a2,a3);
} else {
return f.call(f,a0,a1,a2,a3);
}
} else {
var a4 = cljs.core._first(args);
var next_4 = cljs.core.next(args);
if((next_4 == null)){
if(f.cljs$core$IFn$_invoke$arity$5){
return f.cljs$core$IFn$_invoke$arity$5(a0,a1,a2,a3,a4);
} else {
return f.call(f,a0,a1,a2,a3,a4);
}
} else {
var a5 = cljs.core._first(next_4);
var next_5 = cljs.core.next(next_4);
if((next_5 == null)){
if(f.cljs$core$IFn$_invoke$arity$6){
return f.cljs$core$IFn$_invoke$arity$6(a0,a1,a2,a3,a4,a5);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5);
}
} else {
var a6 = cljs.core._first(next_5);
var next_6 = cljs.core.next(next_5);
if((next_6 == null)){
if(f.cljs$core$IFn$_invoke$arity$7){
return f.cljs$core$IFn$_invoke$arity$7(a0,a1,a2,a3,a4,a5,a6);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6);
}
} else {
var a7 = cljs.core._first(next_6);
var next_7 = cljs.core.next(next_6);
if((next_7 == null)){
if(f.cljs$core$IFn$_invoke$arity$8){
return f.cljs$core$IFn$_invoke$arity$8(a0,a1,a2,a3,a4,a5,a6,a7);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7);
}
} else {
var a8 = cljs.core._first(next_7);
var next_8 = cljs.core.next(next_7);
if((next_8 == null)){
if(f.cljs$core$IFn$_invoke$arity$9){
return f.cljs$core$IFn$_invoke$arity$9(a0,a1,a2,a3,a4,a5,a6,a7,a8);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8);
}
} else {
var a9 = cljs.core._first(next_8);
var next_9 = cljs.core.next(next_8);
if((next_9 == null)){
if(f.cljs$core$IFn$_invoke$arity$10){
return f.cljs$core$IFn$_invoke$arity$10(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9);
}
} else {
var a10 = cljs.core._first(next_9);
var next_10 = cljs.core.next(next_9);
if((next_10 == null)){
if(f.cljs$core$IFn$_invoke$arity$11){
return f.cljs$core$IFn$_invoke$arity$11(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10);
}
} else {
var a11 = cljs.core._first(next_10);
var next_11 = cljs.core.next(next_10);
if((next_11 == null)){
if(f.cljs$core$IFn$_invoke$arity$12){
return f.cljs$core$IFn$_invoke$arity$12(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11);
}
} else {
var a12 = cljs.core._first(next_11);
var next_12 = cljs.core.next(next_11);
if((next_12 == null)){
if(f.cljs$core$IFn$_invoke$arity$13){
return f.cljs$core$IFn$_invoke$arity$13(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12);
}
} else {
var a13 = cljs.core._first(next_12);
var next_13 = cljs.core.next(next_12);
if((next_13 == null)){
if(f.cljs$core$IFn$_invoke$arity$14){
return f.cljs$core$IFn$_invoke$arity$14(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13);
}
} else {
var a14 = cljs.core._first(next_13);
var next_14 = cljs.core.next(next_13);
if((next_14 == null)){
if(f.cljs$core$IFn$_invoke$arity$15){
return f.cljs$core$IFn$_invoke$arity$15(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14);
}
} else {
var a15 = cljs.core._first(next_14);
var next_15 = cljs.core.next(next_14);
if((next_15 == null)){
if(f.cljs$core$IFn$_invoke$arity$16){
return f.cljs$core$IFn$_invoke$arity$16(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15);
}
} else {
var a16 = cljs.core._first(next_15);
var next_16 = cljs.core.next(next_15);
if((next_16 == null)){
if(f.cljs$core$IFn$_invoke$arity$17){
return f.cljs$core$IFn$_invoke$arity$17(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16);
}
} else {
var a17 = cljs.core._first(next_16);
var next_17 = cljs.core.next(next_16);
if((next_17 == null)){
if(f.cljs$core$IFn$_invoke$arity$18){
return f.cljs$core$IFn$_invoke$arity$18(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17);
}
} else {
var a18 = cljs.core._first(next_17);
var next_18 = cljs.core.next(next_17);
if((next_18 == null)){
if(f.cljs$core$IFn$_invoke$arity$19){
return f.cljs$core$IFn$_invoke$arity$19(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18);
}
} else {
var a19 = cljs.core._first(next_18);
var next_19 = cljs.core.next(next_18);
if((next_19 == null)){
if(f.cljs$core$IFn$_invoke$arity$20){
return f.cljs$core$IFn$_invoke$arity$20(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19);
}
} else {
var arr__5641__auto__ = [a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19];
var s__5642__auto___8576 = next_19;
while(true){
if(s__5642__auto___8576){
arr__5641__auto__.push(cljs.core._first(s__5642__auto___8576));

var G__8577 = cljs.core.next(s__5642__auto___8576);
s__5642__auto___8576 = G__8577;
continue;
} else {
}
break;
}

return f.apply(f,arr__5641__auto__);
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(cljs.core.apply_to_simple.cljs$lang$maxFixedArity = 6);

/**
 * Applies fn f to the argument list formed by prepending intervening arguments to args.
 */
cljs.core.apply = (function cljs$core$apply(var_args){
var G__6525 = arguments.length;
switch (G__6525) {
case 2:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8579 = arguments.length;
var i__5727__auto___8580 = (0);
while(true){
if((i__5727__auto___8580 < len__5726__auto___8579)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8580]));

var G__8581 = (i__5727__auto___8580 + (1));
i__5727__auto___8580 = G__8581;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((5) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((5)),(0),null)):null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__5752__auto__);

}
});

(cljs.core.apply.cljs$core$IFn$_invoke$arity$2 = (function (f,args){
if(f.cljs$lang$applyTo){
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = cljs.core.bounded_count((fixed_arity + (1)),args);
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,args);
} else {
return f.cljs$lang$applyTo(args);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$2(f,cljs.core.seq(args));
}
}));

(cljs.core.apply.cljs$core$IFn$_invoke$arity$3 = (function (f,x,args){
if(f.cljs$lang$applyTo){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(x,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = (cljs.core.bounded_count(fixed_arity,args) + (1));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3(f,x,cljs.core.seq(args));
}
}));

(cljs.core.apply.cljs$core$IFn$_invoke$arity$4 = (function (f,x,y,args){
if(f.cljs$lang$applyTo){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(x,y,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = ((2) + cljs.core.bounded_count((fixed_arity - (1)),args));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4(f,x,y,cljs.core.seq(args));
}
}));

(cljs.core.apply.cljs$core$IFn$_invoke$arity$5 = (function (f,x,y,z,args){
if(f.cljs$lang$applyTo){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(x,y,z,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = ((3) + cljs.core.bounded_count((fixed_arity - (2)),args));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5(f,x,y,z,cljs.core.seq(args));
}
}));

(cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic = (function (f,a,b,c,d,args){
if(f.cljs$lang$applyTo){
var spread_args = cljs.core.spread(args);
var arglist = cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,spread_args))));
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = ((4) + cljs.core.bounded_count((fixed_arity - (3)),spread_args));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6(f,a,b,c,d,cljs.core.spread(args));
}
}));

/** @this {Function} */
(cljs.core.apply.cljs$lang$applyTo = (function (seq6519){
var G__6520 = cljs.core.first(seq6519);
var seq6519__$1 = cljs.core.next(seq6519);
var G__6521 = cljs.core.first(seq6519__$1);
var seq6519__$2 = cljs.core.next(seq6519__$1);
var G__6522 = cljs.core.first(seq6519__$2);
var seq6519__$3 = cljs.core.next(seq6519__$2);
var G__6523 = cljs.core.first(seq6519__$3);
var seq6519__$4 = cljs.core.next(seq6519__$3);
var G__6524 = cljs.core.first(seq6519__$4);
var seq6519__$5 = cljs.core.next(seq6519__$4);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6520,G__6521,G__6522,G__6523,G__6524,seq6519__$5);
}));

(cljs.core.apply.cljs$lang$maxFixedArity = (5));

cljs.core.__destructure_map = (function cljs$core$__destructure_map(gmap){
if((((!((gmap == null))))?(((((gmap.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === gmap.cljs$core$ISeq$))))?true:false):false)){
if(cljs.core.next(gmap)){
return cljs.core.PersistentArrayMap.createAsIfByAssoc(cljs.core.to_array(gmap));
} else {
if(cljs.core.seq(gmap)){
return cljs.core.first(gmap);
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
}
} else {
return gmap;
}
});
/**
 * Returns an object of the same type and value as obj, with
 *   (apply f (meta obj) args) as its metadata.
 */
cljs.core.vary_meta = (function cljs$core$vary_meta(var_args){
var G__6535 = arguments.length;
switch (G__6535) {
case 2:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8586 = arguments.length;
var i__5727__auto___8587 = (0);
while(true){
if((i__5727__auto___8587 < len__5726__auto___8586)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8587]));

var G__8588 = (i__5727__auto___8587 + (1));
i__5727__auto___8587 = G__8588;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((6) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((6)),(0),null)):null);
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__5752__auto__);

}
});

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2 = (function (obj,f){
return cljs.core.with_meta(obj,(function (){var G__6536 = cljs.core.meta(obj);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__6536) : f.call(null,G__6536));
})());
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3 = (function (obj,f,a){
return cljs.core.with_meta(obj,(function (){var G__6537 = cljs.core.meta(obj);
var G__6538 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6537,G__6538) : f.call(null,G__6537,G__6538));
})());
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4 = (function (obj,f,a,b){
return cljs.core.with_meta(obj,(function (){var G__6539 = cljs.core.meta(obj);
var G__6540 = a;
var G__6541 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__6539,G__6540,G__6541) : f.call(null,G__6539,G__6540,G__6541));
})());
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5 = (function (obj,f,a,b,c){
return cljs.core.with_meta(obj,(function (){var G__6542 = cljs.core.meta(obj);
var G__6543 = a;
var G__6544 = b;
var G__6545 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__6542,G__6543,G__6544,G__6545) : f.call(null,G__6542,G__6543,G__6544,G__6545));
})());
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6 = (function (obj,f,a,b,c,d){
return cljs.core.with_meta(obj,(function (){var G__6546 = cljs.core.meta(obj);
var G__6547 = a;
var G__6548 = b;
var G__6549 = c;
var G__6550 = d;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__6546,G__6547,G__6548,G__6549,G__6550) : f.call(null,G__6546,G__6547,G__6548,G__6549,G__6550));
})());
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic = (function (obj,f,a,b,c,d,args){
return cljs.core.with_meta(obj,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.meta(obj),a,b,c,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([d,args], 0)));
}));

/** @this {Function} */
(cljs.core.vary_meta.cljs$lang$applyTo = (function (seq6528){
var G__6529 = cljs.core.first(seq6528);
var seq6528__$1 = cljs.core.next(seq6528);
var G__6530 = cljs.core.first(seq6528__$1);
var seq6528__$2 = cljs.core.next(seq6528__$1);
var G__6531 = cljs.core.first(seq6528__$2);
var seq6528__$3 = cljs.core.next(seq6528__$2);
var G__6532 = cljs.core.first(seq6528__$3);
var seq6528__$4 = cljs.core.next(seq6528__$3);
var G__6533 = cljs.core.first(seq6528__$4);
var seq6528__$5 = cljs.core.next(seq6528__$4);
var G__6534 = cljs.core.first(seq6528__$5);
var seq6528__$6 = cljs.core.next(seq6528__$5);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6529,G__6530,G__6531,G__6532,G__6533,G__6534,seq6528__$6);
}));

(cljs.core.vary_meta.cljs$lang$maxFixedArity = (6));

/**
 * Same as (not (= obj1 obj2))
 */
cljs.core.not_EQ_ = (function cljs$core$not_EQ_(var_args){
var G__6555 = arguments.length;
switch (G__6555) {
case 1:
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8595 = arguments.length;
var i__5727__auto___8596 = (0);
while(true){
if((i__5727__auto___8596 < len__5726__auto___8595)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8596]));

var G__8597 = (i__5727__auto___8596 + (1));
i__5727__auto___8596 = G__8597;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return false;
}));

(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)));
}));

(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core._EQ_,x,y,more));
}));

/** @this {Function} */
(cljs.core.not_EQ_.cljs$lang$applyTo = (function (seq6552){
var G__6553 = cljs.core.first(seq6552);
var seq6552__$1 = cljs.core.next(seq6552);
var G__6554 = cljs.core.first(seq6552__$1);
var seq6552__$2 = cljs.core.next(seq6552__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6553,G__6554,seq6552__$2);
}));

(cljs.core.not_EQ_.cljs$lang$maxFixedArity = (2));

/**
 * If coll is empty, returns nil, else coll
 */
cljs.core.not_empty = (function cljs$core$not_empty(coll){
if(cljs.core.seq(coll)){
return coll;
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.t_cljs$core6556 = (function (meta6557){
this.meta6557 = meta6557;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.t_cljs$core6556.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_6558,meta6557__$1){
var self__ = this;
var _6558__$1 = this;
return (new cljs.core.t_cljs$core6556(meta6557__$1));
}));

(cljs.core.t_cljs$core6556.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_6558){
var self__ = this;
var _6558__$1 = this;
return self__.meta6557;
}));

(cljs.core.t_cljs$core6556.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return false;
}));

(cljs.core.t_cljs$core6556.prototype.next = (function (){
var self__ = this;
var _ = this;
return (new Error("No such element"));
}));

(cljs.core.t_cljs$core6556.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.t_cljs$core6556.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta6557","meta6557",659465472,null)], null);
}));

(cljs.core.t_cljs$core6556.cljs$lang$type = true);

(cljs.core.t_cljs$core6556.cljs$lang$ctorStr = "cljs.core/t_cljs$core6556");

(cljs.core.t_cljs$core6556.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/t_cljs$core6556");
}));

/**
 * Positional factory function for cljs.core/t_cljs$core6556.
 */
cljs.core.__GT_t_cljs$core6556 = (function cljs$core$__GT_t_cljs$core6556(meta6557){
return (new cljs.core.t_cljs$core6556(meta6557));
});


cljs.core.nil_iter = (function cljs$core$nil_iter(){
return (new cljs.core.t_cljs$core6556(cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
*/
cljs.core.StringIter = (function (s,i){
this.s = s;
this.i = i;
});
(cljs.core.StringIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.s.length);
}));

(cljs.core.StringIter.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = self__.s.charAt(self__.i);
(self__.i = (self__.i + (1)));

return ret;
}));

(cljs.core.StringIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.StringIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.StringIter.cljs$lang$type = true);

(cljs.core.StringIter.cljs$lang$ctorStr = "cljs.core/StringIter");

(cljs.core.StringIter.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/StringIter");
}));

/**
 * Positional factory function for cljs.core/StringIter.
 */
cljs.core.__GT_StringIter = (function cljs$core$__GT_StringIter(s,i){
return (new cljs.core.StringIter(s,i));
});

cljs.core.string_iter = (function cljs$core$string_iter(x){
return (new cljs.core.StringIter(x,(0)));
});

/**
* @constructor
*/
cljs.core.ArrayIter = (function (arr,i){
this.arr = arr;
this.i = i;
});
(cljs.core.ArrayIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
}));

(cljs.core.ArrayIter.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
(self__.i = (self__.i + (1)));

return ret;
}));

(cljs.core.ArrayIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.ArrayIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ArrayIter.cljs$lang$type = true);

(cljs.core.ArrayIter.cljs$lang$ctorStr = "cljs.core/ArrayIter");

(cljs.core.ArrayIter.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/ArrayIter");
}));

/**
 * Positional factory function for cljs.core/ArrayIter.
 */
cljs.core.__GT_ArrayIter = (function cljs$core$__GT_ArrayIter(arr,i){
return (new cljs.core.ArrayIter(arr,i));
});

cljs.core.array_iter = (function cljs$core$array_iter(x){
return (new cljs.core.ArrayIter(x,(0)));
});
cljs.core.INIT = ({});
cljs.core.START = ({});

/**
* @constructor
*/
cljs.core.SeqIter = (function (_seq,_next){
this._seq = _seq;
this._next = _next;
});
(cljs.core.SeqIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
if((self__._seq === cljs.core.INIT)){
(self__._seq = cljs.core.START);

(self__._next = cljs.core.seq(self__._next));
} else {
if((self__._seq === self__._next)){
(self__._next = cljs.core.next(self__._seq));
} else {
}
}

return (!((self__._next == null)));
}));

(cljs.core.SeqIter.prototype.next = (function (){
var self__ = this;
var this$ = this;
if((!(this$.hasNext()))){
throw (new Error("No such element"));
} else {
(self__._seq = self__._next);

return cljs.core.first(self__._next);
}
}));

(cljs.core.SeqIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.SeqIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"_seq","_seq",-449557847,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"_next","_next",101877036,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.SeqIter.cljs$lang$type = true);

(cljs.core.SeqIter.cljs$lang$ctorStr = "cljs.core/SeqIter");

(cljs.core.SeqIter.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/SeqIter");
}));

/**
 * Positional factory function for cljs.core/SeqIter.
 */
cljs.core.__GT_SeqIter = (function cljs$core$__GT_SeqIter(_seq,_next){
return (new cljs.core.SeqIter(_seq,_next));
});

cljs.core.seq_iter = (function cljs$core$seq_iter(coll){
return (new cljs.core.SeqIter(cljs.core.INIT,coll));
});
cljs.core.iter = (function cljs$core$iter(coll){
if(cljs.core.iterable_QMARK_(coll)){
return cljs.core._iterator(coll);
} else {
if((coll == null)){
return cljs.core.nil_iter();
} else {
if(typeof coll === 'string'){
return cljs.core.string_iter(coll);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_iter(coll);
} else {
if(cljs.core.seqable_QMARK_(coll)){
return cljs.core.seq_iter(coll);
} else {
throw (new Error(["Cannot create iterator from ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll)].join('')));

}
}
}
}
}
});

/**
* @constructor
*/
cljs.core.Many = (function (vals){
this.vals = vals;
});
(cljs.core.Many.prototype.add = (function (o){
var self__ = this;
var this$ = this;
self__.vals.push(o);

return this$;
}));

(cljs.core.Many.prototype.remove = (function (){
var self__ = this;
var this$ = this;
return self__.vals.shift();
}));

(cljs.core.Many.prototype.isEmpty = (function (){
var self__ = this;
var this$ = this;
return (self__.vals.length === (0));
}));

(cljs.core.Many.prototype.toString = (function (){
var self__ = this;
var this$ = this;
return ["Many: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.vals)].join('');
}));

(cljs.core.Many.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"vals","vals",-1886377036,null)], null);
}));

(cljs.core.Many.cljs$lang$type = true);

(cljs.core.Many.cljs$lang$ctorStr = "cljs.core/Many");

(cljs.core.Many.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/Many");
}));

/**
 * Positional factory function for cljs.core/Many.
 */
cljs.core.__GT_Many = (function cljs$core$__GT_Many(vals){
return (new cljs.core.Many(vals));
});

cljs.core.NONE = ({});

/**
* @constructor
*/
cljs.core.Single = (function (val){
this.val = val;
});
(cljs.core.Single.prototype.add = (function (o){
var self__ = this;
var this$ = this;
if((self__.val === cljs.core.NONE)){
(self__.val = o);

return this$;
} else {
return (new cljs.core.Many([self__.val,o]));
}
}));

(cljs.core.Single.prototype.remove = (function (){
var self__ = this;
var this$ = this;
if((self__.val === cljs.core.NONE)){
throw (new Error("Removing object from empty buffer"));
} else {
var ret = self__.val;
(self__.val = cljs.core.NONE);

return ret;
}
}));

(cljs.core.Single.prototype.isEmpty = (function (){
var self__ = this;
var this$ = this;
return (self__.val === cljs.core.NONE);
}));

(cljs.core.Single.prototype.toString = (function (){
var self__ = this;
var this$ = this;
return ["Single: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.val)].join('');
}));

(cljs.core.Single.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Single.cljs$lang$type = true);

(cljs.core.Single.cljs$lang$ctorStr = "cljs.core/Single");

(cljs.core.Single.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/Single");
}));

/**
 * Positional factory function for cljs.core/Single.
 */
cljs.core.__GT_Single = (function cljs$core$__GT_Single(val){
return (new cljs.core.Single(val));
});


/**
* @constructor
*/
cljs.core.Empty = (function (){
});
(cljs.core.Empty.prototype.add = (function (o){
var self__ = this;
var this$ = this;
return (new cljs.core.Single(o));
}));

(cljs.core.Empty.prototype.remove = (function (){
var self__ = this;
var this$ = this;
throw (new Error("Removing object from empty buffer"));
}));

(cljs.core.Empty.prototype.isEmpty = (function (){
var self__ = this;
var this$ = this;
return true;
}));

(cljs.core.Empty.prototype.toString = (function (){
var self__ = this;
var this$ = this;
return "Empty";
}));

(cljs.core.Empty.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
}));

(cljs.core.Empty.cljs$lang$type = true);

(cljs.core.Empty.cljs$lang$ctorStr = "cljs.core/Empty");

(cljs.core.Empty.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/Empty");
}));

/**
 * Positional factory function for cljs.core/Empty.
 */
cljs.core.__GT_Empty = (function cljs$core$__GT_Empty(){
return (new cljs.core.Empty());
});

cljs.core.EMPTY = (new cljs.core.Empty());

/**
* @constructor
*/
cljs.core.MultiIterator = (function (iters){
this.iters = iters;
});
(cljs.core.MultiIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
var iters__$1 = cljs.core.seq(self__.iters);
while(true){
if((!((iters__$1 == null)))){
var iter = cljs.core.first(iters__$1);
if((!(iter.hasNext()))){
return false;
} else {
var G__8610 = cljs.core.next(iters__$1);
iters__$1 = G__8610;
continue;
}
} else {
return true;
}
break;
}
}));

(cljs.core.MultiIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var nexts = [];
var n__5593__auto___8612 = self__.iters.length;
var i_8613 = (0);
while(true){
if((i_8613 < n__5593__auto___8612)){
(nexts[i_8613] = (self__.iters[i_8613]).next());

var G__8614 = (i_8613 + (1));
i_8613 = G__8614;
continue;
} else {
}
break;
}

return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(nexts,(0));
}));

(cljs.core.MultiIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"iters","iters",719353031,null)], null);
}));

(cljs.core.MultiIterator.cljs$lang$type = true);

(cljs.core.MultiIterator.cljs$lang$ctorStr = "cljs.core/MultiIterator");

(cljs.core.MultiIterator.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/MultiIterator");
}));

/**
 * Positional factory function for cljs.core/MultiIterator.
 */
cljs.core.__GT_MultiIterator = (function cljs$core$__GT_MultiIterator(iters){
return (new cljs.core.MultiIterator(iters));
});

cljs.core.chunkIteratorSeq = (function cljs$core$chunkIteratorSeq(iter){
return (new cljs.core.LazySeq(null,(function (){
if(iter.hasNext()){
var arr = [];
var n = (0);
while(true){
if(cljs.core.truth_((function (){var and__5000__auto__ = iter.hasNext();
if(cljs.core.truth_(and__5000__auto__)){
return (n < (32));
} else {
return and__5000__auto__;
}
})())){
(arr[n] = iter.next());

var G__8616 = (n + (1));
n = G__8616;
continue;
} else {
return cljs.core.chunk_cons(cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3(arr,(0),n),(cljs.core.chunkIteratorSeq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunkIteratorSeq.cljs$core$IFn$_invoke$arity$1(iter) : cljs.core.chunkIteratorSeq.call(null,iter)));
}
break;
}
} else {
return null;
}
}),null,null));
});

/**
* @constructor
*/
cljs.core.TransformerIterator = (function (buffer,_next,completed,xf,sourceIter,multi){
this.buffer = buffer;
this._next = _next;
this.completed = completed;
this.xf = xf;
this.sourceIter = sourceIter;
this.multi = multi;
});
(cljs.core.TransformerIterator.prototype.step = (function (){
var self__ = this;
var this$ = this;
if((!((self__._next === cljs.core.NONE)))){
return true;
} else {
while(true){
if((self__._next === cljs.core.NONE)){
if(self__.buffer.isEmpty()){
if(self__.completed){
return false;
} else {
if(self__.sourceIter.hasNext()){
var iter = ((self__.multi)?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(self__.xf,cljs.core.cons(null,self__.sourceIter.next())):(function (){var G__6559 = null;
var G__6560 = self__.sourceIter.next();
return (self__.xf.cljs$core$IFn$_invoke$arity$2 ? self__.xf.cljs$core$IFn$_invoke$arity$2(G__6559,G__6560) : self__.xf.call(null,G__6559,G__6560));
})());
if(cljs.core.reduced_QMARK_(iter)){
(self__.xf.cljs$core$IFn$_invoke$arity$1 ? self__.xf.cljs$core$IFn$_invoke$arity$1(null) : self__.xf.call(null,null));

(self__.completed = true);
} else {
}

continue;
} else {
(self__.xf.cljs$core$IFn$_invoke$arity$1 ? self__.xf.cljs$core$IFn$_invoke$arity$1(null) : self__.xf.call(null,null));

(self__.completed = true);

continue;
}
}
} else {
(self__._next = self__.buffer.remove());

continue;
}
} else {
return true;
}
break;
}
}
}));

(cljs.core.TransformerIterator.prototype.hasNext = (function (){
var self__ = this;
var this$ = this;
return this$.step();
}));

(cljs.core.TransformerIterator.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(this$.hasNext()){
var ret = self__._next;
(self__._next = cljs.core.NONE);

return ret;
} else {
throw (new Error("No such element"));
}
}));

(cljs.core.TransformerIterator.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.TransformerIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"buffer","buffer",-2037140571,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"_next","_next",101877036,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"completed","completed",1154475024,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"xf","xf",2042434515,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"sourceIter","sourceIter",1068220306,null),new cljs.core.Symbol(null,"multi","multi",1450238522,null)], null);
}));

(cljs.core.TransformerIterator.cljs$lang$type = true);

(cljs.core.TransformerIterator.cljs$lang$ctorStr = "cljs.core/TransformerIterator");

(cljs.core.TransformerIterator.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/TransformerIterator");
}));

/**
 * Positional factory function for cljs.core/TransformerIterator.
 */
cljs.core.__GT_TransformerIterator = (function cljs$core$__GT_TransformerIterator(buffer,_next,completed,xf,sourceIter,multi){
return (new cljs.core.TransformerIterator(buffer,_next,completed,xf,sourceIter,multi));
});

(cljs.core.TransformerIterator.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));
cljs.core.transformer_iterator = (function cljs$core$transformer_iterator(xform,sourceIter,multi){
var iterator = (new cljs.core.TransformerIterator(cljs.core.EMPTY,cljs.core.NONE,false,null,sourceIter,multi));
(iterator.xf = (function (){var G__6561 = (function() {
var G__8625 = null;
var G__8625__0 = (function (){
return null;
});
var G__8625__1 = (function (acc){
return acc;
});
var G__8625__2 = (function (acc,o){
(iterator.buffer = iterator.buffer.add(o));

return acc;
});
G__8625 = function(acc,o){
switch(arguments.length){
case 0:
return G__8625__0.call(this);
case 1:
return G__8625__1.call(this,acc);
case 2:
return G__8625__2.call(this,acc,o);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8625.cljs$core$IFn$_invoke$arity$0 = G__8625__0;
G__8625.cljs$core$IFn$_invoke$arity$1 = G__8625__1;
G__8625.cljs$core$IFn$_invoke$arity$2 = G__8625__2;
return G__8625;
})()
;
return (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__6561) : xform.call(null,G__6561));
})());

return iterator;
});
(cljs.core.TransformerIterator.create = (function (xform,source){
return cljs.core.transformer_iterator(xform,source,false);
}));
(cljs.core.TransformerIterator.createMulti = (function (xform,sources){
return cljs.core.transformer_iterator(xform,(new cljs.core.MultiIterator(cljs.core.to_array(sources))),true);
}));
/**
 * Coerces coll to a (possibly empty) sequence, if it is not already
 *   one. Will not force a lazy seq. (sequence nil) yields (), When a
 *   transducer is supplied, returns a lazy sequence of applications of
 *   the transform to the items in coll(s), i.e. to the set of first
 *   items of each coll, followed by the set of second
 *   items in each coll, until any one of the colls is exhausted.  Any
 *   remaining items in other colls are ignored. The transform should accept
 *   number-of-colls arguments
 */
cljs.core.sequence = (function cljs$core$sequence(var_args){
var G__6566 = arguments.length;
switch (G__6566) {
case 1:
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8631 = arguments.length;
var i__5727__auto___8632 = (0);
while(true){
if((i__5727__auto___8632 < len__5726__auto___8631)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8632]));

var G__8634 = (i__5727__auto___8632 + (1));
i__5727__auto___8632 = G__8634;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1 = (function (coll){
if(cljs.core.seq_QMARK_(coll)){
return coll;
} else {
var or__5002__auto__ = cljs.core.seq(coll);
if(or__5002__auto__){
return or__5002__auto__;
} else {
return cljs.core.List.EMPTY;
}
}
}));

(cljs.core.sequence.cljs$core$IFn$_invoke$arity$2 = (function (xform,coll){
var or__5002__auto__ = cljs.core.chunkIteratorSeq(cljs.core.TransformerIterator.create(xform,cljs.core.iter(coll)));
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic = (function (xform,coll,colls){
var or__5002__auto__ = cljs.core.chunkIteratorSeq(cljs.core.TransformerIterator.createMulti(xform,(function (){var G__6567 = cljs.core.iter;
var G__6568 = cljs.core.cons(coll,colls);
return (cljs.core.map.cljs$core$IFn$_invoke$arity$2 ? cljs.core.map.cljs$core$IFn$_invoke$arity$2(G__6567,G__6568) : cljs.core.map.call(null,G__6567,G__6568));
})()));
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.List.EMPTY;
}
}));

/** @this {Function} */
(cljs.core.sequence.cljs$lang$applyTo = (function (seq6563){
var G__6564 = cljs.core.first(seq6563);
var seq6563__$1 = cljs.core.next(seq6563);
var G__6565 = cljs.core.first(seq6563__$1);
var seq6563__$2 = cljs.core.next(seq6563__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6564,G__6565,seq6563__$2);
}));

(cljs.core.sequence.cljs$lang$maxFixedArity = (2));

/**
 * Returns true if (pred x) is logical true for every x in coll, else
 *   false.
 */
cljs.core.every_QMARK_ = (function cljs$core$every_QMARK_(pred,coll){
while(true){
if((cljs.core.seq(coll) == null)){
return true;
} else {
if(cljs.core.truth_((function (){var G__6569 = cljs.core.first(coll);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__6569) : pred.call(null,G__6569));
})())){
var G__8644 = pred;
var G__8645 = cljs.core.next(coll);
pred = G__8644;
coll = G__8645;
continue;
} else {
return false;

}
}
break;
}
});
/**
 * Returns false if (pred x) is logical true for every x in
 *   coll, else true.
 */
cljs.core.not_every_QMARK_ = (function cljs$core$not_every_QMARK_(pred,coll){
return (!(cljs.core.every_QMARK_(pred,coll)));
});
/**
 * Returns the first logical true value of (pred x) for any x in coll,
 *   else nil.  One common idiom is to use a set as pred, for example
 *   this will return :fred if :fred is in the sequence, otherwise nil:
 *   (some #{:fred} coll)
 */
cljs.core.some = (function cljs$core$some(pred,coll){
while(true){
var temp__5804__auto__ = cljs.core.seq(coll);
if(temp__5804__auto__){
var s = temp__5804__auto__;
var or__5002__auto__ = (function (){var G__6570 = cljs.core.first(s);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__6570) : pred.call(null,G__6570));
})();
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
var G__8648 = pred;
var G__8649 = cljs.core.next(s);
pred = G__8648;
coll = G__8649;
continue;
}
} else {
return null;
}
break;
}
});
/**
 * Returns false if (pred x) is logical true for any x in coll,
 *   else true.
 */
cljs.core.not_any_QMARK_ = (function cljs$core$not_any_QMARK_(pred,coll){
return cljs.core.not(cljs.core.some(pred,coll));
});
/**
 * Returns true if n is even, throws an exception if n is not an integer
 */
cljs.core.even_QMARK_ = (function cljs$core$even_QMARK_(n){
if(cljs.core.integer_QMARK_(n)){
return ((n & (1)) === (0));
} else {
throw (new Error(["Argument must be an integer: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)].join('')));
}
});
/**
 * Returns true if n is odd, throws an exception if n is not an integer
 */
cljs.core.odd_QMARK_ = (function cljs$core$odd_QMARK_(n){
return (!(cljs.core.even_QMARK_(n)));
});
/**
 * Takes a fn f and returns a fn that takes the same arguments as f,
 *   has the same effects, if any, and returns the opposite truth value.
 */
cljs.core.complement = (function cljs$core$complement(f){
return (function() {
var G__8654 = null;
var G__8654__0 = (function (){
return cljs.core.not((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
});
var G__8654__1 = (function (x){
return cljs.core.not((f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null,x)));
});
var G__8654__2 = (function (x,y){
return cljs.core.not((f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y)));
});
var G__8654__3 = (function() { 
var G__8657__delegate = function (x,y,zs){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(f,x,y,zs));
};
var G__8657 = function (x,y,var_args){
var zs = null;
if (arguments.length > 2) {
var G__8659__i = 0, G__8659__a = new Array(arguments.length -  2);
while (G__8659__i < G__8659__a.length) {G__8659__a[G__8659__i] = arguments[G__8659__i + 2]; ++G__8659__i;}
  zs = new cljs.core.IndexedSeq(G__8659__a,0,null);
} 
return G__8657__delegate.call(this,x,y,zs);};
G__8657.cljs$lang$maxFixedArity = 2;
G__8657.cljs$lang$applyTo = (function (arglist__8660){
var x = cljs.core.first(arglist__8660);
arglist__8660 = cljs.core.next(arglist__8660);
var y = cljs.core.first(arglist__8660);
var zs = cljs.core.rest(arglist__8660);
return G__8657__delegate(x,y,zs);
});
G__8657.cljs$core$IFn$_invoke$arity$variadic = G__8657__delegate;
return G__8657;
})()
;
G__8654 = function(x,y,var_args){
var zs = var_args;
switch(arguments.length){
case 0:
return G__8654__0.call(this);
case 1:
return G__8654__1.call(this,x);
case 2:
return G__8654__2.call(this,x,y);
default:
var G__8661 = null;
if (arguments.length > 2) {
var G__8662__i = 0, G__8662__a = new Array(arguments.length -  2);
while (G__8662__i < G__8662__a.length) {G__8662__a[G__8662__i] = arguments[G__8662__i + 2]; ++G__8662__i;}
G__8661 = new cljs.core.IndexedSeq(G__8662__a,0,null);
}
return G__8654__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8661);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8654.cljs$lang$maxFixedArity = 2;
G__8654.cljs$lang$applyTo = G__8654__3.cljs$lang$applyTo;
G__8654.cljs$core$IFn$_invoke$arity$0 = G__8654__0;
G__8654.cljs$core$IFn$_invoke$arity$1 = G__8654__1;
G__8654.cljs$core$IFn$_invoke$arity$2 = G__8654__2;
G__8654.cljs$core$IFn$_invoke$arity$variadic = G__8654__3.cljs$core$IFn$_invoke$arity$variadic;
return G__8654;
})()
});
/**
 * Returns a function that takes any number of arguments and returns x.
 */
cljs.core.constantly = (function cljs$core$constantly(x){
return (function() { 
var G__8663__delegate = function (args){
return x;
};
var G__8663 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__8664__i = 0, G__8664__a = new Array(arguments.length -  0);
while (G__8664__i < G__8664__a.length) {G__8664__a[G__8664__i] = arguments[G__8664__i + 0]; ++G__8664__i;}
  args = new cljs.core.IndexedSeq(G__8664__a,0,null);
} 
return G__8663__delegate.call(this,args);};
G__8663.cljs$lang$maxFixedArity = 0;
G__8663.cljs$lang$applyTo = (function (arglist__8665){
var args = cljs.core.seq(arglist__8665);
return G__8663__delegate(args);
});
G__8663.cljs$core$IFn$_invoke$arity$variadic = G__8663__delegate;
return G__8663;
})()
;
});
/**
 * Takes a set of functions and returns a fn that is the composition
 *   of those fns.  The returned fn takes a variable number of args,
 *   applies the rightmost of fns to the args, the next
 *   fn (right-to-left) to the result, etc.
 */
cljs.core.comp = (function cljs$core$comp(var_args){
var G__6576 = arguments.length;
switch (G__6576) {
case 0:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8667 = arguments.length;
var i__5727__auto___8668 = (0);
while(true){
if((i__5727__auto___8668 < len__5726__auto___8667)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8668]));

var G__8672 = (i__5727__auto___8668 + (1));
i__5727__auto___8668 = G__8672;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((3) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((3)),(0),null)):null);
return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5752__auto__);

}
});

(cljs.core.comp.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.identity;
}));

(cljs.core.comp.cljs$core$IFn$_invoke$arity$1 = (function (f){
return f;
}));

(cljs.core.comp.cljs$core$IFn$_invoke$arity$2 = (function (f,g){
return (function() {
var G__8678 = null;
var G__8678__0 = (function (){
var G__6577 = (g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__6577) : f.call(null,G__6577));
});
var G__8678__1 = (function (x){
var G__6578 = (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(x) : g.call(null,x));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__6578) : f.call(null,G__6578));
});
var G__8678__2 = (function (x,y){
var G__6579 = (g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(x,y) : g.call(null,x,y));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__6579) : f.call(null,G__6579));
});
var G__8678__3 = (function (x,y,z){
var G__6580 = (g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(x,y,z) : g.call(null,x,y,z));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__6580) : f.call(null,G__6580));
});
var G__8678__4 = (function() { 
var G__8681__delegate = function (x,y,z,args){
var G__6581 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__6581) : f.call(null,G__6581));
};
var G__8681 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8682__i = 0, G__8682__a = new Array(arguments.length -  3);
while (G__8682__i < G__8682__a.length) {G__8682__a[G__8682__i] = arguments[G__8682__i + 3]; ++G__8682__i;}
  args = new cljs.core.IndexedSeq(G__8682__a,0,null);
} 
return G__8681__delegate.call(this,x,y,z,args);};
G__8681.cljs$lang$maxFixedArity = 3;
G__8681.cljs$lang$applyTo = (function (arglist__8683){
var x = cljs.core.first(arglist__8683);
arglist__8683 = cljs.core.next(arglist__8683);
var y = cljs.core.first(arglist__8683);
arglist__8683 = cljs.core.next(arglist__8683);
var z = cljs.core.first(arglist__8683);
var args = cljs.core.rest(arglist__8683);
return G__8681__delegate(x,y,z,args);
});
G__8681.cljs$core$IFn$_invoke$arity$variadic = G__8681__delegate;
return G__8681;
})()
;
G__8678 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__8678__0.call(this);
case 1:
return G__8678__1.call(this,x);
case 2:
return G__8678__2.call(this,x,y);
case 3:
return G__8678__3.call(this,x,y,z);
default:
var G__8684 = null;
if (arguments.length > 3) {
var G__8685__i = 0, G__8685__a = new Array(arguments.length -  3);
while (G__8685__i < G__8685__a.length) {G__8685__a[G__8685__i] = arguments[G__8685__i + 3]; ++G__8685__i;}
G__8684 = new cljs.core.IndexedSeq(G__8685__a,0,null);
}
return G__8678__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8684);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8678.cljs$lang$maxFixedArity = 3;
G__8678.cljs$lang$applyTo = G__8678__4.cljs$lang$applyTo;
G__8678.cljs$core$IFn$_invoke$arity$0 = G__8678__0;
G__8678.cljs$core$IFn$_invoke$arity$1 = G__8678__1;
G__8678.cljs$core$IFn$_invoke$arity$2 = G__8678__2;
G__8678.cljs$core$IFn$_invoke$arity$3 = G__8678__3;
G__8678.cljs$core$IFn$_invoke$arity$variadic = G__8678__4.cljs$core$IFn$_invoke$arity$variadic;
return G__8678;
})()
}));

(cljs.core.comp.cljs$core$IFn$_invoke$arity$3 = (function (f,g,h){
return (function() {
var G__8686 = null;
var G__8686__0 = (function (){
var G__6582 = (function (){var G__6583 = (h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__6583) : g.call(null,G__6583));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__6582) : f.call(null,G__6582));
});
var G__8686__1 = (function (x){
var G__6584 = (function (){var G__6585 = (h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(x) : h.call(null,x));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__6585) : g.call(null,G__6585));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__6584) : f.call(null,G__6584));
});
var G__8686__2 = (function (x,y){
var G__6586 = (function (){var G__6587 = (h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(x,y) : h.call(null,x,y));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__6587) : g.call(null,G__6587));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__6586) : f.call(null,G__6586));
});
var G__8686__3 = (function (x,y,z){
var G__6588 = (function (){var G__6589 = (h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(x,y,z) : h.call(null,x,y,z));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__6589) : g.call(null,G__6589));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__6588) : f.call(null,G__6588));
});
var G__8686__4 = (function() { 
var G__8689__delegate = function (x,y,z,args){
var G__6590 = (function (){var G__6591 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h,x,y,z,args);
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__6591) : g.call(null,G__6591));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__6590) : f.call(null,G__6590));
};
var G__8689 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8690__i = 0, G__8690__a = new Array(arguments.length -  3);
while (G__8690__i < G__8690__a.length) {G__8690__a[G__8690__i] = arguments[G__8690__i + 3]; ++G__8690__i;}
  args = new cljs.core.IndexedSeq(G__8690__a,0,null);
} 
return G__8689__delegate.call(this,x,y,z,args);};
G__8689.cljs$lang$maxFixedArity = 3;
G__8689.cljs$lang$applyTo = (function (arglist__8691){
var x = cljs.core.first(arglist__8691);
arglist__8691 = cljs.core.next(arglist__8691);
var y = cljs.core.first(arglist__8691);
arglist__8691 = cljs.core.next(arglist__8691);
var z = cljs.core.first(arglist__8691);
var args = cljs.core.rest(arglist__8691);
return G__8689__delegate(x,y,z,args);
});
G__8689.cljs$core$IFn$_invoke$arity$variadic = G__8689__delegate;
return G__8689;
})()
;
G__8686 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__8686__0.call(this);
case 1:
return G__8686__1.call(this,x);
case 2:
return G__8686__2.call(this,x,y);
case 3:
return G__8686__3.call(this,x,y,z);
default:
var G__8692 = null;
if (arguments.length > 3) {
var G__8693__i = 0, G__8693__a = new Array(arguments.length -  3);
while (G__8693__i < G__8693__a.length) {G__8693__a[G__8693__i] = arguments[G__8693__i + 3]; ++G__8693__i;}
G__8692 = new cljs.core.IndexedSeq(G__8693__a,0,null);
}
return G__8686__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8692);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8686.cljs$lang$maxFixedArity = 3;
G__8686.cljs$lang$applyTo = G__8686__4.cljs$lang$applyTo;
G__8686.cljs$core$IFn$_invoke$arity$0 = G__8686__0;
G__8686.cljs$core$IFn$_invoke$arity$1 = G__8686__1;
G__8686.cljs$core$IFn$_invoke$arity$2 = G__8686__2;
G__8686.cljs$core$IFn$_invoke$arity$3 = G__8686__3;
G__8686.cljs$core$IFn$_invoke$arity$variadic = G__8686__4.cljs$core$IFn$_invoke$arity$variadic;
return G__8686;
})()
}));

(cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic = (function (f1,f2,f3,fs){
var fs__$1 = cljs.core.reverse(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f1,f2,f3,fs));
return (function() { 
var G__8694__delegate = function (args){
var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.first(fs__$1),args);
var fs__$2 = cljs.core.next(fs__$1);
while(true){
if(fs__$2){
var G__8698 = (function (){var fexpr__6592 = cljs.core.first(fs__$2);
return (fexpr__6592.cljs$core$IFn$_invoke$arity$1 ? fexpr__6592.cljs$core$IFn$_invoke$arity$1(ret) : fexpr__6592.call(null,ret));
})();
var G__8699 = cljs.core.next(fs__$2);
ret = G__8698;
fs__$2 = G__8699;
continue;
} else {
return ret;
}
break;
}
};
var G__8694 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__8700__i = 0, G__8700__a = new Array(arguments.length -  0);
while (G__8700__i < G__8700__a.length) {G__8700__a[G__8700__i] = arguments[G__8700__i + 0]; ++G__8700__i;}
  args = new cljs.core.IndexedSeq(G__8700__a,0,null);
} 
return G__8694__delegate.call(this,args);};
G__8694.cljs$lang$maxFixedArity = 0;
G__8694.cljs$lang$applyTo = (function (arglist__8701){
var args = cljs.core.seq(arglist__8701);
return G__8694__delegate(args);
});
G__8694.cljs$core$IFn$_invoke$arity$variadic = G__8694__delegate;
return G__8694;
})()
;
}));

/** @this {Function} */
(cljs.core.comp.cljs$lang$applyTo = (function (seq6572){
var G__6573 = cljs.core.first(seq6572);
var seq6572__$1 = cljs.core.next(seq6572);
var G__6574 = cljs.core.first(seq6572__$1);
var seq6572__$2 = cljs.core.next(seq6572__$1);
var G__6575 = cljs.core.first(seq6572__$2);
var seq6572__$3 = cljs.core.next(seq6572__$2);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6573,G__6574,G__6575,seq6572__$3);
}));

(cljs.core.comp.cljs$lang$maxFixedArity = (3));

/**
 * Takes a function f and fewer than the normal arguments to f, and
 *   returns a fn that takes a variable number of additional args. When
 *   called, the returned function calls f with args + additional args.
 */
cljs.core.partial = (function cljs$core$partial(var_args){
var G__6599 = arguments.length;
switch (G__6599) {
case 1:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8703 = arguments.length;
var i__5727__auto___8704 = (0);
while(true){
if((i__5727__auto___8704 < len__5726__auto___8703)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8704]));

var G__8705 = (i__5727__auto___8704 + (1));
i__5727__auto___8704 = G__8705;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((4) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((4)),(0),null)):null);
return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__5752__auto__);

}
});

(cljs.core.partial.cljs$core$IFn$_invoke$arity$1 = (function (f){
return f;
}));

(cljs.core.partial.cljs$core$IFn$_invoke$arity$2 = (function (f,arg1){
return (function() {
var G__8706 = null;
var G__8706__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(arg1) : f.call(null,arg1));
});
var G__8706__1 = (function (x){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(arg1,x) : f.call(null,arg1,x));
});
var G__8706__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,x,y) : f.call(null,arg1,x,y));
});
var G__8706__3 = (function (x,y,z){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,x,y,z) : f.call(null,arg1,x,y,z));
});
var G__8706__4 = (function() { 
var G__8707__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,x,y,z,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
};
var G__8707 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8708__i = 0, G__8708__a = new Array(arguments.length -  3);
while (G__8708__i < G__8708__a.length) {G__8708__a[G__8708__i] = arguments[G__8708__i + 3]; ++G__8708__i;}
  args = new cljs.core.IndexedSeq(G__8708__a,0,null);
} 
return G__8707__delegate.call(this,x,y,z,args);};
G__8707.cljs$lang$maxFixedArity = 3;
G__8707.cljs$lang$applyTo = (function (arglist__8709){
var x = cljs.core.first(arglist__8709);
arglist__8709 = cljs.core.next(arglist__8709);
var y = cljs.core.first(arglist__8709);
arglist__8709 = cljs.core.next(arglist__8709);
var z = cljs.core.first(arglist__8709);
var args = cljs.core.rest(arglist__8709);
return G__8707__delegate(x,y,z,args);
});
G__8707.cljs$core$IFn$_invoke$arity$variadic = G__8707__delegate;
return G__8707;
})()
;
G__8706 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__8706__0.call(this);
case 1:
return G__8706__1.call(this,x);
case 2:
return G__8706__2.call(this,x,y);
case 3:
return G__8706__3.call(this,x,y,z);
default:
var G__8714 = null;
if (arguments.length > 3) {
var G__8715__i = 0, G__8715__a = new Array(arguments.length -  3);
while (G__8715__i < G__8715__a.length) {G__8715__a[G__8715__i] = arguments[G__8715__i + 3]; ++G__8715__i;}
G__8714 = new cljs.core.IndexedSeq(G__8715__a,0,null);
}
return G__8706__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8714);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8706.cljs$lang$maxFixedArity = 3;
G__8706.cljs$lang$applyTo = G__8706__4.cljs$lang$applyTo;
G__8706.cljs$core$IFn$_invoke$arity$0 = G__8706__0;
G__8706.cljs$core$IFn$_invoke$arity$1 = G__8706__1;
G__8706.cljs$core$IFn$_invoke$arity$2 = G__8706__2;
G__8706.cljs$core$IFn$_invoke$arity$3 = G__8706__3;
G__8706.cljs$core$IFn$_invoke$arity$variadic = G__8706__4.cljs$core$IFn$_invoke$arity$variadic;
return G__8706;
})()
}));

(cljs.core.partial.cljs$core$IFn$_invoke$arity$3 = (function (f,arg1,arg2){
return (function() {
var G__8716 = null;
var G__8716__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(arg1,arg2) : f.call(null,arg1,arg2));
});
var G__8716__1 = (function (x){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,arg2,x) : f.call(null,arg1,arg2,x));
});
var G__8716__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,arg2,x,y) : f.call(null,arg1,arg2,x,y));
});
var G__8716__3 = (function (x,y,z){
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(arg1,arg2,x,y,z) : f.call(null,arg1,arg2,x,y,z));
});
var G__8716__4 = (function() { 
var G__8720__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,x,y,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([z,args], 0));
};
var G__8720 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8721__i = 0, G__8721__a = new Array(arguments.length -  3);
while (G__8721__i < G__8721__a.length) {G__8721__a[G__8721__i] = arguments[G__8721__i + 3]; ++G__8721__i;}
  args = new cljs.core.IndexedSeq(G__8721__a,0,null);
} 
return G__8720__delegate.call(this,x,y,z,args);};
G__8720.cljs$lang$maxFixedArity = 3;
G__8720.cljs$lang$applyTo = (function (arglist__8722){
var x = cljs.core.first(arglist__8722);
arglist__8722 = cljs.core.next(arglist__8722);
var y = cljs.core.first(arglist__8722);
arglist__8722 = cljs.core.next(arglist__8722);
var z = cljs.core.first(arglist__8722);
var args = cljs.core.rest(arglist__8722);
return G__8720__delegate(x,y,z,args);
});
G__8720.cljs$core$IFn$_invoke$arity$variadic = G__8720__delegate;
return G__8720;
})()
;
G__8716 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__8716__0.call(this);
case 1:
return G__8716__1.call(this,x);
case 2:
return G__8716__2.call(this,x,y);
case 3:
return G__8716__3.call(this,x,y,z);
default:
var G__8726 = null;
if (arguments.length > 3) {
var G__8727__i = 0, G__8727__a = new Array(arguments.length -  3);
while (G__8727__i < G__8727__a.length) {G__8727__a[G__8727__i] = arguments[G__8727__i + 3]; ++G__8727__i;}
G__8726 = new cljs.core.IndexedSeq(G__8727__a,0,null);
}
return G__8716__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8726);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8716.cljs$lang$maxFixedArity = 3;
G__8716.cljs$lang$applyTo = G__8716__4.cljs$lang$applyTo;
G__8716.cljs$core$IFn$_invoke$arity$0 = G__8716__0;
G__8716.cljs$core$IFn$_invoke$arity$1 = G__8716__1;
G__8716.cljs$core$IFn$_invoke$arity$2 = G__8716__2;
G__8716.cljs$core$IFn$_invoke$arity$3 = G__8716__3;
G__8716.cljs$core$IFn$_invoke$arity$variadic = G__8716__4.cljs$core$IFn$_invoke$arity$variadic;
return G__8716;
})()
}));

(cljs.core.partial.cljs$core$IFn$_invoke$arity$4 = (function (f,arg1,arg2,arg3){
return (function() {
var G__8728 = null;
var G__8728__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,arg2,arg3) : f.call(null,arg1,arg2,arg3));
});
var G__8728__1 = (function (x){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,arg2,arg3,x) : f.call(null,arg1,arg2,arg3,x));
});
var G__8728__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(arg1,arg2,arg3,x,y) : f.call(null,arg1,arg2,arg3,x,y));
});
var G__8728__3 = (function (x,y,z){
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(arg1,arg2,arg3,x,y,z) : f.call(null,arg1,arg2,arg3,x,y,z));
});
var G__8728__4 = (function() { 
var G__8732__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,arg3,x,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([y,z,args], 0));
};
var G__8732 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8734__i = 0, G__8734__a = new Array(arguments.length -  3);
while (G__8734__i < G__8734__a.length) {G__8734__a[G__8734__i] = arguments[G__8734__i + 3]; ++G__8734__i;}
  args = new cljs.core.IndexedSeq(G__8734__a,0,null);
} 
return G__8732__delegate.call(this,x,y,z,args);};
G__8732.cljs$lang$maxFixedArity = 3;
G__8732.cljs$lang$applyTo = (function (arglist__8735){
var x = cljs.core.first(arglist__8735);
arglist__8735 = cljs.core.next(arglist__8735);
var y = cljs.core.first(arglist__8735);
arglist__8735 = cljs.core.next(arglist__8735);
var z = cljs.core.first(arglist__8735);
var args = cljs.core.rest(arglist__8735);
return G__8732__delegate(x,y,z,args);
});
G__8732.cljs$core$IFn$_invoke$arity$variadic = G__8732__delegate;
return G__8732;
})()
;
G__8728 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__8728__0.call(this);
case 1:
return G__8728__1.call(this,x);
case 2:
return G__8728__2.call(this,x,y);
case 3:
return G__8728__3.call(this,x,y,z);
default:
var G__8737 = null;
if (arguments.length > 3) {
var G__8738__i = 0, G__8738__a = new Array(arguments.length -  3);
while (G__8738__i < G__8738__a.length) {G__8738__a[G__8738__i] = arguments[G__8738__i + 3]; ++G__8738__i;}
G__8737 = new cljs.core.IndexedSeq(G__8738__a,0,null);
}
return G__8728__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8737);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8728.cljs$lang$maxFixedArity = 3;
G__8728.cljs$lang$applyTo = G__8728__4.cljs$lang$applyTo;
G__8728.cljs$core$IFn$_invoke$arity$0 = G__8728__0;
G__8728.cljs$core$IFn$_invoke$arity$1 = G__8728__1;
G__8728.cljs$core$IFn$_invoke$arity$2 = G__8728__2;
G__8728.cljs$core$IFn$_invoke$arity$3 = G__8728__3;
G__8728.cljs$core$IFn$_invoke$arity$variadic = G__8728__4.cljs$core$IFn$_invoke$arity$variadic;
return G__8728;
})()
}));

(cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic = (function (f,arg1,arg2,arg3,more){
return (function() { 
var G__8739__delegate = function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,arg1,arg2,arg3,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(more,args));
};
var G__8739 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__8741__i = 0, G__8741__a = new Array(arguments.length -  0);
while (G__8741__i < G__8741__a.length) {G__8741__a[G__8741__i] = arguments[G__8741__i + 0]; ++G__8741__i;}
  args = new cljs.core.IndexedSeq(G__8741__a,0,null);
} 
return G__8739__delegate.call(this,args);};
G__8739.cljs$lang$maxFixedArity = 0;
G__8739.cljs$lang$applyTo = (function (arglist__8742){
var args = cljs.core.seq(arglist__8742);
return G__8739__delegate(args);
});
G__8739.cljs$core$IFn$_invoke$arity$variadic = G__8739__delegate;
return G__8739;
})()
;
}));

/** @this {Function} */
(cljs.core.partial.cljs$lang$applyTo = (function (seq6594){
var G__6595 = cljs.core.first(seq6594);
var seq6594__$1 = cljs.core.next(seq6594);
var G__6596 = cljs.core.first(seq6594__$1);
var seq6594__$2 = cljs.core.next(seq6594__$1);
var G__6597 = cljs.core.first(seq6594__$2);
var seq6594__$3 = cljs.core.next(seq6594__$2);
var G__6598 = cljs.core.first(seq6594__$3);
var seq6594__$4 = cljs.core.next(seq6594__$3);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6595,G__6596,G__6597,G__6598,seq6594__$4);
}));

(cljs.core.partial.cljs$lang$maxFixedArity = (4));

/**
 * Takes a function f, and returns a function that calls f, replacing
 *   a nil first argument to f with the supplied value x. Higher arity
 *   versions can replace arguments in the second and third
 *   positions (y, z). Note that the function f can take any number of
 *   arguments, not just the one(s) being nil-patched.
 */
cljs.core.fnil = (function cljs$core$fnil(var_args){
var G__6601 = arguments.length;
switch (G__6601) {
case 2:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.fnil.cljs$core$IFn$_invoke$arity$2 = (function (f,x){
return (function() {
var G__8747 = null;
var G__8747__1 = (function (a){
var G__6602 = (((a == null))?x:a);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__6602) : f.call(null,G__6602));
});
var G__8747__2 = (function (a,b){
var G__6603 = (((a == null))?x:a);
var G__6604 = b;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6603,G__6604) : f.call(null,G__6603,G__6604));
});
var G__8747__3 = (function (a,b,c){
var G__6605 = (((a == null))?x:a);
var G__6606 = b;
var G__6607 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__6605,G__6606,G__6607) : f.call(null,G__6605,G__6606,G__6607));
});
var G__8747__4 = (function() { 
var G__8751__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),b,c,ds);
};
var G__8751 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__8753__i = 0, G__8753__a = new Array(arguments.length -  3);
while (G__8753__i < G__8753__a.length) {G__8753__a[G__8753__i] = arguments[G__8753__i + 3]; ++G__8753__i;}
  ds = new cljs.core.IndexedSeq(G__8753__a,0,null);
} 
return G__8751__delegate.call(this,a,b,c,ds);};
G__8751.cljs$lang$maxFixedArity = 3;
G__8751.cljs$lang$applyTo = (function (arglist__8754){
var a = cljs.core.first(arglist__8754);
arglist__8754 = cljs.core.next(arglist__8754);
var b = cljs.core.first(arglist__8754);
arglist__8754 = cljs.core.next(arglist__8754);
var c = cljs.core.first(arglist__8754);
var ds = cljs.core.rest(arglist__8754);
return G__8751__delegate(a,b,c,ds);
});
G__8751.cljs$core$IFn$_invoke$arity$variadic = G__8751__delegate;
return G__8751;
})()
;
G__8747 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 1:
return G__8747__1.call(this,a);
case 2:
return G__8747__2.call(this,a,b);
case 3:
return G__8747__3.call(this,a,b,c);
default:
var G__8755 = null;
if (arguments.length > 3) {
var G__8756__i = 0, G__8756__a = new Array(arguments.length -  3);
while (G__8756__i < G__8756__a.length) {G__8756__a[G__8756__i] = arguments[G__8756__i + 3]; ++G__8756__i;}
G__8755 = new cljs.core.IndexedSeq(G__8756__a,0,null);
}
return G__8747__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__8755);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8747.cljs$lang$maxFixedArity = 3;
G__8747.cljs$lang$applyTo = G__8747__4.cljs$lang$applyTo;
G__8747.cljs$core$IFn$_invoke$arity$1 = G__8747__1;
G__8747.cljs$core$IFn$_invoke$arity$2 = G__8747__2;
G__8747.cljs$core$IFn$_invoke$arity$3 = G__8747__3;
G__8747.cljs$core$IFn$_invoke$arity$variadic = G__8747__4.cljs$core$IFn$_invoke$arity$variadic;
return G__8747;
})()
}));

(cljs.core.fnil.cljs$core$IFn$_invoke$arity$3 = (function (f,x,y){
return (function() {
var G__8757 = null;
var G__8757__2 = (function (a,b){
var G__6608 = (((a == null))?x:a);
var G__6609 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6608,G__6609) : f.call(null,G__6608,G__6609));
});
var G__8757__3 = (function (a,b,c){
var G__6610 = (((a == null))?x:a);
var G__6611 = (((b == null))?y:b);
var G__6612 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__6610,G__6611,G__6612) : f.call(null,G__6610,G__6611,G__6612));
});
var G__8757__4 = (function() { 
var G__8759__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),c,ds);
};
var G__8759 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__8763__i = 0, G__8763__a = new Array(arguments.length -  3);
while (G__8763__i < G__8763__a.length) {G__8763__a[G__8763__i] = arguments[G__8763__i + 3]; ++G__8763__i;}
  ds = new cljs.core.IndexedSeq(G__8763__a,0,null);
} 
return G__8759__delegate.call(this,a,b,c,ds);};
G__8759.cljs$lang$maxFixedArity = 3;
G__8759.cljs$lang$applyTo = (function (arglist__8764){
var a = cljs.core.first(arglist__8764);
arglist__8764 = cljs.core.next(arglist__8764);
var b = cljs.core.first(arglist__8764);
arglist__8764 = cljs.core.next(arglist__8764);
var c = cljs.core.first(arglist__8764);
var ds = cljs.core.rest(arglist__8764);
return G__8759__delegate(a,b,c,ds);
});
G__8759.cljs$core$IFn$_invoke$arity$variadic = G__8759__delegate;
return G__8759;
})()
;
G__8757 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return G__8757__2.call(this,a,b);
case 3:
return G__8757__3.call(this,a,b,c);
default:
var G__8769 = null;
if (arguments.length > 3) {
var G__8770__i = 0, G__8770__a = new Array(arguments.length -  3);
while (G__8770__i < G__8770__a.length) {G__8770__a[G__8770__i] = arguments[G__8770__i + 3]; ++G__8770__i;}
G__8769 = new cljs.core.IndexedSeq(G__8770__a,0,null);
}
return G__8757__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__8769);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8757.cljs$lang$maxFixedArity = 3;
G__8757.cljs$lang$applyTo = G__8757__4.cljs$lang$applyTo;
G__8757.cljs$core$IFn$_invoke$arity$2 = G__8757__2;
G__8757.cljs$core$IFn$_invoke$arity$3 = G__8757__3;
G__8757.cljs$core$IFn$_invoke$arity$variadic = G__8757__4.cljs$core$IFn$_invoke$arity$variadic;
return G__8757;
})()
}));

(cljs.core.fnil.cljs$core$IFn$_invoke$arity$4 = (function (f,x,y,z){
return (function() {
var G__8772 = null;
var G__8772__2 = (function (a,b){
var G__6613 = (((a == null))?x:a);
var G__6614 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6613,G__6614) : f.call(null,G__6613,G__6614));
});
var G__8772__3 = (function (a,b,c){
var G__6615 = (((a == null))?x:a);
var G__6616 = (((b == null))?y:b);
var G__6617 = (((c == null))?z:c);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__6615,G__6616,G__6617) : f.call(null,G__6615,G__6616,G__6617));
});
var G__8772__4 = (function() { 
var G__8773__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),(((c == null))?z:c),ds);
};
var G__8773 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__8774__i = 0, G__8774__a = new Array(arguments.length -  3);
while (G__8774__i < G__8774__a.length) {G__8774__a[G__8774__i] = arguments[G__8774__i + 3]; ++G__8774__i;}
  ds = new cljs.core.IndexedSeq(G__8774__a,0,null);
} 
return G__8773__delegate.call(this,a,b,c,ds);};
G__8773.cljs$lang$maxFixedArity = 3;
G__8773.cljs$lang$applyTo = (function (arglist__8776){
var a = cljs.core.first(arglist__8776);
arglist__8776 = cljs.core.next(arglist__8776);
var b = cljs.core.first(arglist__8776);
arglist__8776 = cljs.core.next(arglist__8776);
var c = cljs.core.first(arglist__8776);
var ds = cljs.core.rest(arglist__8776);
return G__8773__delegate(a,b,c,ds);
});
G__8773.cljs$core$IFn$_invoke$arity$variadic = G__8773__delegate;
return G__8773;
})()
;
G__8772 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return G__8772__2.call(this,a,b);
case 3:
return G__8772__3.call(this,a,b,c);
default:
var G__8777 = null;
if (arguments.length > 3) {
var G__8778__i = 0, G__8778__a = new Array(arguments.length -  3);
while (G__8778__i < G__8778__a.length) {G__8778__a[G__8778__i] = arguments[G__8778__i + 3]; ++G__8778__i;}
G__8777 = new cljs.core.IndexedSeq(G__8778__a,0,null);
}
return G__8772__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__8777);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8772.cljs$lang$maxFixedArity = 3;
G__8772.cljs$lang$applyTo = G__8772__4.cljs$lang$applyTo;
G__8772.cljs$core$IFn$_invoke$arity$2 = G__8772__2;
G__8772.cljs$core$IFn$_invoke$arity$3 = G__8772__3;
G__8772.cljs$core$IFn$_invoke$arity$variadic = G__8772__4.cljs$core$IFn$_invoke$arity$variadic;
return G__8772;
})()
}));

(cljs.core.fnil.cljs$lang$maxFixedArity = 4);

/**
 * Returns a lazy sequence consisting of the result of applying f to 0
 *   and the first item of coll, followed by applying f to 1 and the second
 *   item in coll, etc, until coll is exhausted. Thus function f should
 *   accept 2 arguments, index and item. Returns a stateful transducer when
 *   no collection is provided.
 */
cljs.core.map_indexed = (function cljs$core$map_indexed(var_args){
var G__6619 = arguments.length;
switch (G__6619) {
case 1:
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
var i = (cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1 ? cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1((-1)) : cljs.core.volatile_BANG_.call(null,(-1)));
return (function() {
var G__8782 = null;
var G__8782__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8782__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__8782__2 = (function (result,input){
var G__6620 = result;
var G__6621 = (function (){var G__6622 = cljs.core._vreset_BANG_(i,(cljs.core._deref(i) + (1)));
var G__6623 = input;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6622,G__6623) : f.call(null,G__6622,G__6623));
})();
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__6620,G__6621) : rf.call(null,G__6620,G__6621));
});
G__8782 = function(result,input){
switch(arguments.length){
case 0:
return G__8782__0.call(this);
case 1:
return G__8782__1.call(this,result);
case 2:
return G__8782__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8782.cljs$core$IFn$_invoke$arity$0 = G__8782__0;
G__8782.cljs$core$IFn$_invoke$arity$1 = G__8782__1;
G__8782.cljs$core$IFn$_invoke$arity$2 = G__8782__2;
return G__8782;
})()
});
}));

(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
var mapi = (function cljs$core$mapi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__5804__auto__ = cljs.core.seq(coll__$1);
if(temp__5804__auto__){
var s = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__5593__auto___8785 = size;
var i_8787 = (0);
while(true){
if((i_8787 < n__5593__auto___8785)){
cljs.core.chunk_append(b,(function (){var G__6628 = (idx + i_8787);
var G__6629 = cljs.core._nth(c,i_8787);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6628,G__6629) : f.call(null,G__6628,G__6629));
})());

var G__8788 = (i_8787 + (1));
i_8787 = G__8788;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$mapi((idx + size),cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__6630 = idx;
var G__6631 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6630,G__6631) : f.call(null,G__6630,G__6631));
})(),cljs$core$mapi((idx + (1)),cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
});
return mapi((0),coll);
}));

(cljs.core.map_indexed.cljs$lang$maxFixedArity = 2);

/**
 * Returns a lazy sequence of the non-nil results of (f item). Note,
 *   this means false return values will be included.  f must be free of
 *   side-effects.  Returns a transducer when no collection is provided.
 */
cljs.core.keep = (function cljs$core$keep(var_args){
var G__6633 = arguments.length;
switch (G__6633) {
case 1:
return cljs.core.keep.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.keep.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
return (function() {
var G__8793 = null;
var G__8793__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8793__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__8793__2 = (function (result,input){
var v = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(input) : f.call(null,input));
if((v == null)){
return result;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v));
}
});
G__8793 = function(result,input){
switch(arguments.length){
case 0:
return G__8793__0.call(this);
case 1:
return G__8793__1.call(this,result);
case 2:
return G__8793__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8793.cljs$core$IFn$_invoke$arity$0 = G__8793__0;
G__8793.cljs$core$IFn$_invoke$arity$1 = G__8793__1;
G__8793.cljs$core$IFn$_invoke$arity$2 = G__8793__2;
return G__8793;
})()
});
}));

(cljs.core.keep.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__5804__auto__ = cljs.core.seq(coll);
if(temp__5804__auto__){
var s = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__5593__auto___8795 = size;
var i_8796 = (0);
while(true){
if((i_8796 < n__5593__auto___8795)){
var x_8797 = (function (){var G__6634 = cljs.core._nth(c,i_8796);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__6634) : f.call(null,G__6634));
})();
if((x_8797 == null)){
} else {
cljs.core.chunk_append(b,x_8797);
}

var G__8798 = (i_8796 + (1));
i_8796 = G__8798;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__6635 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__6635) : f.call(null,G__6635));
})();
if((x == null)){
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s));
} else {
return cljs.core.cons(x,cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.keep.cljs$lang$maxFixedArity = 2);


/**
* @constructor
 * @implements {cljs.core.IWatchable}
 * @implements {cljs.core.IAtom}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IDeref}
*/
cljs.core.Atom = (function (state,meta,validator,watches){
this.state = state;
this.meta = meta;
this.validator = validator;
this.watches = watches;
this.cljs$lang$protocol_mask$partition1$ = 16386;
this.cljs$lang$protocol_mask$partition0$ = 6455296;
});
(cljs.core.Atom.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var self__ = this;
var o__$1 = this;
return (o__$1 === other);
}));

(cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.state;
}));

(cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.meta;
}));

(cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = (function (this$,oldval,newval){
var self__ = this;
var this$__$1 = this;
var seq__6636 = cljs.core.seq(self__.watches);
var chunk__6637 = null;
var count__6638 = (0);
var i__6639 = (0);
while(true){
if((i__6639 < count__6638)){
var vec__6646 = chunk__6637.cljs$core$IIndexed$_nth$arity$2(null,i__6639);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6646,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6646,(1),null);
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(key,this$__$1,oldval,newval) : f.call(null,key,this$__$1,oldval,newval));


var G__8799 = seq__6636;
var G__8800 = chunk__6637;
var G__8801 = count__6638;
var G__8802 = (i__6639 + (1));
seq__6636 = G__8799;
chunk__6637 = G__8800;
count__6638 = G__8801;
i__6639 = G__8802;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__6636);
if(temp__5804__auto__){
var seq__6636__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__6636__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__6636__$1);
var G__8803 = cljs.core.chunk_rest(seq__6636__$1);
var G__8804 = c__5525__auto__;
var G__8805 = cljs.core.count(c__5525__auto__);
var G__8806 = (0);
seq__6636 = G__8803;
chunk__6637 = G__8804;
count__6638 = G__8805;
i__6639 = G__8806;
continue;
} else {
var vec__6649 = cljs.core.first(seq__6636__$1);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6649,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6649,(1),null);
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(key,this$__$1,oldval,newval) : f.call(null,key,this$__$1,oldval,newval));


var G__8807 = cljs.core.next(seq__6636__$1);
var G__8808 = null;
var G__8809 = (0);
var G__8810 = (0);
seq__6636 = G__8807;
chunk__6637 = G__8808;
count__6638 = G__8809;
i__6639 = G__8810;
continue;
}
} else {
return null;
}
}
break;
}
}));

(cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = (function (this$,key,f){
var self__ = this;
var this$__$1 = this;
(this$__$1.watches = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.watches,key,f));

return this$__$1;
}));

(cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
return (this$__$1.watches = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.watches,key));
}));

(cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return goog.getUid(this$__$1);
}));

(cljs.core.Atom.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"validator","validator",-325659154,null),new cljs.core.Symbol(null,"watches","watches",1367433992,null)], null);
}));

(cljs.core.Atom.cljs$lang$type = true);

(cljs.core.Atom.cljs$lang$ctorStr = "cljs.core/Atom");

(cljs.core.Atom.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/Atom");
}));

/**
 * Positional factory function for cljs.core/Atom.
 */
cljs.core.__GT_Atom = (function cljs$core$__GT_Atom(state,meta,validator,watches){
return (new cljs.core.Atom(state,meta,validator,watches));
});

/**
 * Creates and returns an Atom with an initial value of x and zero or
 *   more options (in any order):
 * 
 *   :meta metadata-map
 * 
 *   :validator validate-fn
 * 
 *   If metadata-map is supplied, it will become the metadata on the
 *   atom. validate-fn must be nil or a side-effect-free fn of one
 *   argument, which will be passed the intended new state on any state
 *   change. If the new state is unacceptable, the validate-fn should
 *   return false or throw an Error.  If either of these error conditions
 *   occur, then the value of the atom will not change.
 */
cljs.core.atom = (function cljs$core$atom(var_args){
var G__6655 = arguments.length;
switch (G__6655) {
case 1:
return cljs.core.atom.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8813 = arguments.length;
var i__5727__auto___8814 = (0);
while(true){
if((i__5727__auto___8814 < len__5726__auto___8813)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8814]));

var G__8815 = (i__5727__auto___8814 + (1));
i__5727__auto___8814 = G__8815;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((1) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((1)),(0),null)):null);
return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5752__auto__);

}
});

(cljs.core.atom.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (new cljs.core.Atom(x,null,null,null));
}));

(cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic = (function (x,p__6656){
var map__6657 = p__6656;
var map__6657__$1 = cljs.core.__destructure_map(map__6657);
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6657__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var validator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6657__$1,new cljs.core.Keyword(null,"validator","validator",-1966190681));
return (new cljs.core.Atom(x,meta,validator,null));
}));

/** @this {Function} */
(cljs.core.atom.cljs$lang$applyTo = (function (seq6653){
var G__6654 = cljs.core.first(seq6653);
var seq6653__$1 = cljs.core.next(seq6653);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6654,seq6653__$1);
}));

(cljs.core.atom.cljs$lang$maxFixedArity = (1));

/**
 * Sets the value of atom to newval without regard for the
 *   current value. Returns new-value.
 */
cljs.core.reset_BANG_ = (function cljs$core$reset_BANG_(a,new_value){
if((a instanceof cljs.core.Atom)){
var validate = a.validator;
if((validate == null)){
} else {
if(cljs.core.truth_((validate.cljs$core$IFn$_invoke$arity$1 ? validate.cljs$core$IFn$_invoke$arity$1(new_value) : validate.call(null,new_value)))){
} else {
throw (new Error("Validator rejected reference state"));
}
}

var old_value = a.state;
(a.state = new_value);

if((a.watches == null)){
} else {
a.cljs$core$IWatchable$_notify_watches$arity$3(null,old_value,new_value);
}

return new_value;
} else {
return cljs.core._reset_BANG_(a,new_value);
}
});
/**
 * Sets the value of atom to newval. Returns [old new], the value of the
 * atom before and after the reset.
 */
cljs.core.reset_vals_BANG_ = (function cljs$core$reset_vals_BANG_(a,new_value){
if((a instanceof cljs.core.Atom)){
var validate = a.validator;
if((validate == null)){
} else {
if(cljs.core.truth_((validate.cljs$core$IFn$_invoke$arity$1 ? validate.cljs$core$IFn$_invoke$arity$1(new_value) : validate.call(null,new_value)))){
} else {
throw (new Error("Validator rejected reference state"));
}
}

var old_value = a.state;
(a.state = new_value);

if((a.watches == null)){
} else {
a.cljs$core$IWatchable$_notify_watches$arity$3(null,old_value,new_value);
}

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [old_value,new_value], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._deref(a),cljs.core._reset_BANG_(a,new_value)], null);
}
});
/**
 * Atomically swaps the value of atom to be:
 *   (apply f current-value-of-atom args). Note that f may be called
 *   multiple times, and thus should be free of side effects.  Returns
 *   the value that was swapped in.
 */
cljs.core.swap_BANG_ = (function cljs$core$swap_BANG_(var_args){
var G__6664 = arguments.length;
switch (G__6664) {
case 2:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8842 = arguments.length;
var i__5727__auto___8843 = (0);
while(true){
if((i__5727__auto___8843 < len__5726__auto___8842)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8843]));

var G__8844 = (i__5727__auto___8843 + (1));
i__5727__auto___8843 = G__8844;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((4) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((4)),(0),null)):null);
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__5752__auto__);

}
});

(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (a,f){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__6665 = a.state;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__6665) : f.call(null,G__6665));
})());
} else {
return cljs.core._swap_BANG_(a,f);
}
}));

(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (a,f,x){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__6666 = a.state;
var G__6667 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6666,G__6667) : f.call(null,G__6666,G__6667));
})());
} else {
return cljs.core._swap_BANG_(a,f,x);
}
}));

(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (a,f,x,y){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__6668 = a.state;
var G__6669 = x;
var G__6670 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__6668,G__6669,G__6670) : f.call(null,G__6668,G__6669,G__6670));
})());
} else {
return cljs.core._swap_BANG_(a,f,x,y);
}
}));

(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (a,f,x,y,more){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,a.state,x,y,more));
} else {
return cljs.core._swap_BANG_(a,f,x,y,more);
}
}));

/** @this {Function} */
(cljs.core.swap_BANG_.cljs$lang$applyTo = (function (seq6659){
var G__6660 = cljs.core.first(seq6659);
var seq6659__$1 = cljs.core.next(seq6659);
var G__6661 = cljs.core.first(seq6659__$1);
var seq6659__$2 = cljs.core.next(seq6659__$1);
var G__6662 = cljs.core.first(seq6659__$2);
var seq6659__$3 = cljs.core.next(seq6659__$2);
var G__6663 = cljs.core.first(seq6659__$3);
var seq6659__$4 = cljs.core.next(seq6659__$3);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6660,G__6661,G__6662,G__6663,seq6659__$4);
}));

(cljs.core.swap_BANG_.cljs$lang$maxFixedArity = (4));

/**
 * Atomically swaps the value of atom to be:
 *   (apply f current-value-of-atom args). Note that f may be called
 *   multiple times, and thus should be free of side effects.
 *   Returns [old new], the value of the atom before and after the swap.
 */
cljs.core.swap_vals_BANG_ = (function cljs$core$swap_vals_BANG_(var_args){
var G__6677 = arguments.length;
switch (G__6677) {
case 2:
return cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8846 = arguments.length;
var i__5727__auto___8847 = (0);
while(true){
if((i__5727__auto___8847 < len__5726__auto___8846)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8847]));

var G__8848 = (i__5727__auto___8847 + (1));
i__5727__auto___8847 = G__8848;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((4) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((4)),(0),null)):null);
return cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__5752__auto__);

}
});

(cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (a,f){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_vals_BANG_(a,(function (){var G__6678 = a.state;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__6678) : f.call(null,G__6678));
})());
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._deref(a),cljs.core._swap_BANG_(a,f)], null);
}
}));

(cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (a,f,x){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_vals_BANG_(a,(function (){var G__6679 = a.state;
var G__6680 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6679,G__6680) : f.call(null,G__6679,G__6680));
})());
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._deref(a),cljs.core._swap_BANG_(a,f,x)], null);
}
}));

(cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (a,f,x,y){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_vals_BANG_(a,(function (){var G__6681 = a.state;
var G__6682 = x;
var G__6683 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__6681,G__6682,G__6683) : f.call(null,G__6681,G__6682,G__6683));
})());
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._deref(a),cljs.core._swap_BANG_(a,f,x,y)], null);
}
}));

(cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (a,f,x,y,more){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_vals_BANG_(a,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,a.state,x,y,more));
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._deref(a),cljs.core._swap_BANG_(a,f,x,y,more)], null);
}
}));

/** @this {Function} */
(cljs.core.swap_vals_BANG_.cljs$lang$applyTo = (function (seq6672){
var G__6673 = cljs.core.first(seq6672);
var seq6672__$1 = cljs.core.next(seq6672);
var G__6674 = cljs.core.first(seq6672__$1);
var seq6672__$2 = cljs.core.next(seq6672__$1);
var G__6675 = cljs.core.first(seq6672__$2);
var seq6672__$3 = cljs.core.next(seq6672__$2);
var G__6676 = cljs.core.first(seq6672__$3);
var seq6672__$4 = cljs.core.next(seq6672__$3);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6673,G__6674,G__6675,G__6676,seq6672__$4);
}));

(cljs.core.swap_vals_BANG_.cljs$lang$maxFixedArity = (4));

/**
 * Atomically sets the value of atom to newval if and only if the
 *   current value of the atom is equal to oldval. Returns true if
 *   set happened, else false.
 */
cljs.core.compare_and_set_BANG_ = (function cljs$core$compare_and_set_BANG_(a,oldval,newval){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a.cljs$core$IDeref$_deref$arity$1(null),oldval)){
cljs.core.reset_BANG_(a,newval);

return true;
} else {
return false;
}
});
/**
 * Sets the validator-fn for an atom. validator-fn must be nil or a
 *   side-effect-free fn of one argument, which will be passed the intended
 *   new state on any state change. If the new state is unacceptable, the
 *   validator-fn should return false or throw an Error. If the current state
 *   is not acceptable to the new validator, an Error will be thrown and the
 *   validator will not be changed.
 */
cljs.core.set_validator_BANG_ = (function cljs$core$set_validator_BANG_(iref,val){
if((((!((val == null)))) && (cljs.core.not((function (){var G__6684 = cljs.core._deref(iref);
return (val.cljs$core$IFn$_invoke$arity$1 ? val.cljs$core$IFn$_invoke$arity$1(G__6684) : val.call(null,G__6684));
})())))){
throw (new Error("Validator rejected reference state"));
} else {
}

return (iref.validator = val);
});
/**
 * Gets the validator-fn for a var/ref/agent/atom.
 */
cljs.core.get_validator = (function cljs$core$get_validator(iref){
return iref.validator;
});

/**
* @constructor
 * @implements {cljs.core.IVolatile}
 * @implements {cljs.core.IDeref}
*/
cljs.core.Volatile = (function (state){
this.state = state;
this.cljs$lang$protocol_mask$partition0$ = 32768;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.Volatile.prototype.cljs$core$IVolatile$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Volatile.prototype.cljs$core$IVolatile$_vreset_BANG_$arity$2 = (function (_,new_state){
var self__ = this;
var ___$1 = this;
return (self__.state = new_state);
}));

(cljs.core.Volatile.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.state;
}));

(cljs.core.Volatile.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Volatile.cljs$lang$type = true);

(cljs.core.Volatile.cljs$lang$ctorStr = "cljs.core/Volatile");

(cljs.core.Volatile.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/Volatile");
}));

/**
 * Positional factory function for cljs.core/Volatile.
 */
cljs.core.__GT_Volatile = (function cljs$core$__GT_Volatile(state){
return (new cljs.core.Volatile(state));
});

/**
 * Creates and returns a Volatile with an initial value of val.
 */
cljs.core.volatile_BANG_ = (function cljs$core$volatile_BANG_(val){
return (new cljs.core.Volatile(val));
});
/**
 * Returns true if x is a volatile.
 */
cljs.core.volatile_QMARK_ = (function cljs$core$volatile_QMARK_(x){
return (x instanceof cljs.core.Volatile);
});
/**
 * Sets the value of volatile to newval without regard for the
 * current value. Returns newval.
 */
cljs.core.vreset_BANG_ = (function cljs$core$vreset_BANG_(vol,newval){
return cljs.core._vreset_BANG_(vol,newval);
});
/**
 * Returns a lazy sequence of the non-nil results of (f index item). Note,
 *   this means false return values will be included.  f must be free of
 *   side-effects.  Returns a stateful transducer when no collection is
 *   provided.
 */
cljs.core.keep_indexed = (function cljs$core$keep_indexed(var_args){
var G__6686 = arguments.length;
switch (G__6686) {
case 1:
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
var ia = cljs.core.volatile_BANG_((-1));
return (function() {
var G__8853 = null;
var G__8853__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8853__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__8853__2 = (function (result,input){
var i = ia.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(ia.cljs$core$IDeref$_deref$arity$1(null) + (1)));
var v = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(i,input) : f.call(null,i,input));
if((v == null)){
return result;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v));
}
});
G__8853 = function(result,input){
switch(arguments.length){
case 0:
return G__8853__0.call(this);
case 1:
return G__8853__1.call(this,result);
case 2:
return G__8853__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8853.cljs$core$IFn$_invoke$arity$0 = G__8853__0;
G__8853.cljs$core$IFn$_invoke$arity$1 = G__8853__1;
G__8853.cljs$core$IFn$_invoke$arity$2 = G__8853__2;
return G__8853;
})()
});
}));

(cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
var keepi = (function cljs$core$keepi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__5804__auto__ = cljs.core.seq(coll__$1);
if(temp__5804__auto__){
var s = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__5593__auto___8854 = size;
var i_8855 = (0);
while(true){
if((i_8855 < n__5593__auto___8854)){
var x_8856 = (function (){var G__6691 = (idx + i_8855);
var G__6692 = cljs.core._nth(c,i_8855);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6691,G__6692) : f.call(null,G__6691,G__6692));
})();
if((x_8856 == null)){
} else {
cljs.core.chunk_append(b,x_8856);
}

var G__8857 = (i_8855 + (1));
i_8855 = G__8857;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$keepi((idx + size),cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__6693 = idx;
var G__6694 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6693,G__6694) : f.call(null,G__6693,G__6694));
})();
if((x == null)){
return cljs$core$keepi((idx + (1)),cljs.core.rest(s));
} else {
return cljs.core.cons(x,cljs$core$keepi((idx + (1)),cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
});
return keepi((0),coll);
}));

(cljs.core.keep_indexed.cljs$lang$maxFixedArity = 2);

/**
 * Takes a set of predicates and returns a function f that returns true if all of its
 *   composing predicates return a logical true value against all of its arguments, else it returns
 *   false. Note that f is short-circuiting in that it will stop execution on the first
 *   argument that triggers a logical false result against the original predicates.
 */
cljs.core.every_pred = (function cljs$core$every_pred(var_args){
var G__6706 = arguments.length;
switch (G__6706) {
case 1:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8859 = arguments.length;
var i__5727__auto___8860 = (0);
while(true){
if((i__5727__auto___8860 < len__5726__auto___8859)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8860]));

var G__8862 = (i__5727__auto___8860 + (1));
i__5727__auto___8860 = G__8862;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((3) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((3)),(0),null)):null);
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5752__auto__);

}
});

(cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1 = (function (p){
return (function() {
var cljs$core$ep1 = null;
var cljs$core$ep1__0 = (function (){
return true;
});
var cljs$core$ep1__1 = (function (x){
return cljs.core.boolean$((p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x)));
});
var cljs$core$ep1__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__5000__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(and__5000__auto__)){
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
} else {
return and__5000__auto__;
}
})());
});
var cljs$core$ep1__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__5000__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(and__5000__auto__)){
var and__5000__auto____$1 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
if(cljs.core.truth_(and__5000__auto____$1)){
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(z) : p.call(null,z));
} else {
return and__5000__auto____$1;
}
} else {
return and__5000__auto__;
}
})());
});
var cljs$core$ep1__4 = (function() { 
var G__8864__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__5000__auto__ = cljs$core$ep1.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__5000__auto__)){
return cljs.core.every_QMARK_(p,args);
} else {
return and__5000__auto__;
}
})());
};
var G__8864 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8867__i = 0, G__8867__a = new Array(arguments.length -  3);
while (G__8867__i < G__8867__a.length) {G__8867__a[G__8867__i] = arguments[G__8867__i + 3]; ++G__8867__i;}
  args = new cljs.core.IndexedSeq(G__8867__a,0,null);
} 
return G__8864__delegate.call(this,x,y,z,args);};
G__8864.cljs$lang$maxFixedArity = 3;
G__8864.cljs$lang$applyTo = (function (arglist__8868){
var x = cljs.core.first(arglist__8868);
arglist__8868 = cljs.core.next(arglist__8868);
var y = cljs.core.first(arglist__8868);
arglist__8868 = cljs.core.next(arglist__8868);
var z = cljs.core.first(arglist__8868);
var args = cljs.core.rest(arglist__8868);
return G__8864__delegate(x,y,z,args);
});
G__8864.cljs$core$IFn$_invoke$arity$variadic = G__8864__delegate;
return G__8864;
})()
;
cljs$core$ep1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$ep1__0.call(this);
case 1:
return cljs$core$ep1__1.call(this,x);
case 2:
return cljs$core$ep1__2.call(this,x,y);
case 3:
return cljs$core$ep1__3.call(this,x,y,z);
default:
var G__8869 = null;
if (arguments.length > 3) {
var G__8870__i = 0, G__8870__a = new Array(arguments.length -  3);
while (G__8870__i < G__8870__a.length) {G__8870__a[G__8870__i] = arguments[G__8870__i + 3]; ++G__8870__i;}
G__8869 = new cljs.core.IndexedSeq(G__8870__a,0,null);
}
return cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8869);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$ep1.cljs$lang$maxFixedArity = 3;
cljs$core$ep1.cljs$lang$applyTo = cljs$core$ep1__4.cljs$lang$applyTo;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep1__0;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep1__1;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep1__2;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep1__3;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$ep1;
})()
}));

(cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2 = (function (p1,p2){
return (function() {
var cljs$core$ep2 = null;
var cljs$core$ep2__0 = (function (){
return true;
});
var cljs$core$ep2__1 = (function (x){
return cljs.core.boolean$((function (){var and__5000__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__5000__auto__)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
} else {
return and__5000__auto__;
}
})());
});
var cljs$core$ep2__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__5000__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__5000__auto__)){
var and__5000__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__5000__auto____$1)){
var and__5000__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__5000__auto____$2)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
} else {
return and__5000__auto____$2;
}
} else {
return and__5000__auto____$1;
}
} else {
return and__5000__auto__;
}
})());
});
var cljs$core$ep2__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__5000__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__5000__auto__)){
var and__5000__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__5000__auto____$1)){
var and__5000__auto____$2 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(and__5000__auto____$2)){
var and__5000__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__5000__auto____$3)){
var and__5000__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(and__5000__auto____$4)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
} else {
return and__5000__auto____$4;
}
} else {
return and__5000__auto____$3;
}
} else {
return and__5000__auto____$2;
}
} else {
return and__5000__auto____$1;
}
} else {
return and__5000__auto__;
}
})());
});
var cljs$core$ep2__4 = (function() { 
var G__8871__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__5000__auto__ = cljs$core$ep2.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__5000__auto__)){
return cljs.core.every_QMARK_((function (p1__6695_SHARP_){
var and__5000__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__6695_SHARP_) : p1.call(null,p1__6695_SHARP_));
if(cljs.core.truth_(and__5000__auto____$1)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__6695_SHARP_) : p2.call(null,p1__6695_SHARP_));
} else {
return and__5000__auto____$1;
}
}),args);
} else {
return and__5000__auto__;
}
})());
};
var G__8871 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8873__i = 0, G__8873__a = new Array(arguments.length -  3);
while (G__8873__i < G__8873__a.length) {G__8873__a[G__8873__i] = arguments[G__8873__i + 3]; ++G__8873__i;}
  args = new cljs.core.IndexedSeq(G__8873__a,0,null);
} 
return G__8871__delegate.call(this,x,y,z,args);};
G__8871.cljs$lang$maxFixedArity = 3;
G__8871.cljs$lang$applyTo = (function (arglist__8874){
var x = cljs.core.first(arglist__8874);
arglist__8874 = cljs.core.next(arglist__8874);
var y = cljs.core.first(arglist__8874);
arglist__8874 = cljs.core.next(arglist__8874);
var z = cljs.core.first(arglist__8874);
var args = cljs.core.rest(arglist__8874);
return G__8871__delegate(x,y,z,args);
});
G__8871.cljs$core$IFn$_invoke$arity$variadic = G__8871__delegate;
return G__8871;
})()
;
cljs$core$ep2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$ep2__0.call(this);
case 1:
return cljs$core$ep2__1.call(this,x);
case 2:
return cljs$core$ep2__2.call(this,x,y);
case 3:
return cljs$core$ep2__3.call(this,x,y,z);
default:
var G__8875 = null;
if (arguments.length > 3) {
var G__8876__i = 0, G__8876__a = new Array(arguments.length -  3);
while (G__8876__i < G__8876__a.length) {G__8876__a[G__8876__i] = arguments[G__8876__i + 3]; ++G__8876__i;}
G__8875 = new cljs.core.IndexedSeq(G__8876__a,0,null);
}
return cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8875);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$ep2.cljs$lang$maxFixedArity = 3;
cljs$core$ep2.cljs$lang$applyTo = cljs$core$ep2__4.cljs$lang$applyTo;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep2__0;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep2__1;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep2__2;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep2__3;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$ep2;
})()
}));

(cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3 = (function (p1,p2,p3){
return (function() {
var cljs$core$ep3 = null;
var cljs$core$ep3__0 = (function (){
return true;
});
var cljs$core$ep3__1 = (function (x){
return cljs.core.boolean$((function (){var and__5000__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__5000__auto__)){
var and__5000__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__5000__auto____$1)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
} else {
return and__5000__auto____$1;
}
} else {
return and__5000__auto__;
}
})());
});
var cljs$core$ep3__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__5000__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__5000__auto__)){
var and__5000__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__5000__auto____$1)){
var and__5000__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__5000__auto____$2)){
var and__5000__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(and__5000__auto____$3)){
var and__5000__auto____$4 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(and__5000__auto____$4)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
} else {
return and__5000__auto____$4;
}
} else {
return and__5000__auto____$3;
}
} else {
return and__5000__auto____$2;
}
} else {
return and__5000__auto____$1;
}
} else {
return and__5000__auto__;
}
})());
});
var cljs$core$ep3__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__5000__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__5000__auto__)){
var and__5000__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__5000__auto____$1)){
var and__5000__auto____$2 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(and__5000__auto____$2)){
var and__5000__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__5000__auto____$3)){
var and__5000__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(and__5000__auto____$4)){
var and__5000__auto____$5 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
if(cljs.core.truth_(and__5000__auto____$5)){
var and__5000__auto____$6 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(and__5000__auto____$6)){
var and__5000__auto____$7 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
if(cljs.core.truth_(and__5000__auto____$7)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(z) : p3.call(null,z));
} else {
return and__5000__auto____$7;
}
} else {
return and__5000__auto____$6;
}
} else {
return and__5000__auto____$5;
}
} else {
return and__5000__auto____$4;
}
} else {
return and__5000__auto____$3;
}
} else {
return and__5000__auto____$2;
}
} else {
return and__5000__auto____$1;
}
} else {
return and__5000__auto__;
}
})());
});
var cljs$core$ep3__4 = (function() { 
var G__8879__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__5000__auto__ = cljs$core$ep3.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__5000__auto__)){
return cljs.core.every_QMARK_((function (p1__6696_SHARP_){
var and__5000__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__6696_SHARP_) : p1.call(null,p1__6696_SHARP_));
if(cljs.core.truth_(and__5000__auto____$1)){
var and__5000__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__6696_SHARP_) : p2.call(null,p1__6696_SHARP_));
if(cljs.core.truth_(and__5000__auto____$2)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(p1__6696_SHARP_) : p3.call(null,p1__6696_SHARP_));
} else {
return and__5000__auto____$2;
}
} else {
return and__5000__auto____$1;
}
}),args);
} else {
return and__5000__auto__;
}
})());
};
var G__8879 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8881__i = 0, G__8881__a = new Array(arguments.length -  3);
while (G__8881__i < G__8881__a.length) {G__8881__a[G__8881__i] = arguments[G__8881__i + 3]; ++G__8881__i;}
  args = new cljs.core.IndexedSeq(G__8881__a,0,null);
} 
return G__8879__delegate.call(this,x,y,z,args);};
G__8879.cljs$lang$maxFixedArity = 3;
G__8879.cljs$lang$applyTo = (function (arglist__8882){
var x = cljs.core.first(arglist__8882);
arglist__8882 = cljs.core.next(arglist__8882);
var y = cljs.core.first(arglist__8882);
arglist__8882 = cljs.core.next(arglist__8882);
var z = cljs.core.first(arglist__8882);
var args = cljs.core.rest(arglist__8882);
return G__8879__delegate(x,y,z,args);
});
G__8879.cljs$core$IFn$_invoke$arity$variadic = G__8879__delegate;
return G__8879;
})()
;
cljs$core$ep3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$ep3__0.call(this);
case 1:
return cljs$core$ep3__1.call(this,x);
case 2:
return cljs$core$ep3__2.call(this,x,y);
case 3:
return cljs$core$ep3__3.call(this,x,y,z);
default:
var G__8883 = null;
if (arguments.length > 3) {
var G__8884__i = 0, G__8884__a = new Array(arguments.length -  3);
while (G__8884__i < G__8884__a.length) {G__8884__a[G__8884__i] = arguments[G__8884__i + 3]; ++G__8884__i;}
G__8883 = new cljs.core.IndexedSeq(G__8884__a,0,null);
}
return cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8883);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$ep3.cljs$lang$maxFixedArity = 3;
cljs$core$ep3.cljs$lang$applyTo = cljs$core$ep3__4.cljs$lang$applyTo;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep3__0;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep3__1;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep3__2;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep3__3;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$ep3;
})()
}));

(cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic = (function (p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return (function() {
var cljs$core$epn = null;
var cljs$core$epn__0 = (function (){
return true;
});
var cljs$core$epn__1 = (function (x){
return cljs.core.every_QMARK_((function (p1__6697_SHARP_){
return (p1__6697_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__6697_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__6697_SHARP_.call(null,x));
}),ps__$1);
});
var cljs$core$epn__2 = (function (x,y){
return cljs.core.every_QMARK_((function (p1__6698_SHARP_){
var and__5000__auto__ = (p1__6698_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__6698_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__6698_SHARP_.call(null,x));
if(cljs.core.truth_(and__5000__auto__)){
return (p1__6698_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__6698_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__6698_SHARP_.call(null,y));
} else {
return and__5000__auto__;
}
}),ps__$1);
});
var cljs$core$epn__3 = (function (x,y,z){
return cljs.core.every_QMARK_((function (p1__6699_SHARP_){
var and__5000__auto__ = (p1__6699_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__6699_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__6699_SHARP_.call(null,x));
if(cljs.core.truth_(and__5000__auto__)){
var and__5000__auto____$1 = (p1__6699_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__6699_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__6699_SHARP_.call(null,y));
if(cljs.core.truth_(and__5000__auto____$1)){
return (p1__6699_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__6699_SHARP_.cljs$core$IFn$_invoke$arity$1(z) : p1__6699_SHARP_.call(null,z));
} else {
return and__5000__auto____$1;
}
} else {
return and__5000__auto__;
}
}),ps__$1);
});
var cljs$core$epn__4 = (function() { 
var G__8885__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__5000__auto__ = cljs$core$epn.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__5000__auto__)){
return cljs.core.every_QMARK_((function (p1__6700_SHARP_){
return cljs.core.every_QMARK_(p1__6700_SHARP_,args);
}),ps__$1);
} else {
return and__5000__auto__;
}
})());
};
var G__8885 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8886__i = 0, G__8886__a = new Array(arguments.length -  3);
while (G__8886__i < G__8886__a.length) {G__8886__a[G__8886__i] = arguments[G__8886__i + 3]; ++G__8886__i;}
  args = new cljs.core.IndexedSeq(G__8886__a,0,null);
} 
return G__8885__delegate.call(this,x,y,z,args);};
G__8885.cljs$lang$maxFixedArity = 3;
G__8885.cljs$lang$applyTo = (function (arglist__8887){
var x = cljs.core.first(arglist__8887);
arglist__8887 = cljs.core.next(arglist__8887);
var y = cljs.core.first(arglist__8887);
arglist__8887 = cljs.core.next(arglist__8887);
var z = cljs.core.first(arglist__8887);
var args = cljs.core.rest(arglist__8887);
return G__8885__delegate(x,y,z,args);
});
G__8885.cljs$core$IFn$_invoke$arity$variadic = G__8885__delegate;
return G__8885;
})()
;
cljs$core$epn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$epn__0.call(this);
case 1:
return cljs$core$epn__1.call(this,x);
case 2:
return cljs$core$epn__2.call(this,x,y);
case 3:
return cljs$core$epn__3.call(this,x,y,z);
default:
var G__8888 = null;
if (arguments.length > 3) {
var G__8889__i = 0, G__8889__a = new Array(arguments.length -  3);
while (G__8889__i < G__8889__a.length) {G__8889__a[G__8889__i] = arguments[G__8889__i + 3]; ++G__8889__i;}
G__8888 = new cljs.core.IndexedSeq(G__8889__a,0,null);
}
return cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8888);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$epn.cljs$lang$maxFixedArity = 3;
cljs$core$epn.cljs$lang$applyTo = cljs$core$epn__4.cljs$lang$applyTo;
cljs$core$epn.cljs$core$IFn$_invoke$arity$0 = cljs$core$epn__0;
cljs$core$epn.cljs$core$IFn$_invoke$arity$1 = cljs$core$epn__1;
cljs$core$epn.cljs$core$IFn$_invoke$arity$2 = cljs$core$epn__2;
cljs$core$epn.cljs$core$IFn$_invoke$arity$3 = cljs$core$epn__3;
cljs$core$epn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$epn;
})()
}));

/** @this {Function} */
(cljs.core.every_pred.cljs$lang$applyTo = (function (seq6702){
var G__6703 = cljs.core.first(seq6702);
var seq6702__$1 = cljs.core.next(seq6702);
var G__6704 = cljs.core.first(seq6702__$1);
var seq6702__$2 = cljs.core.next(seq6702__$1);
var G__6705 = cljs.core.first(seq6702__$2);
var seq6702__$3 = cljs.core.next(seq6702__$2);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6703,G__6704,G__6705,seq6702__$3);
}));

(cljs.core.every_pred.cljs$lang$maxFixedArity = (3));

/**
 * Takes a set of predicates and returns a function f that returns the first logical true value
 *   returned by one of its composing predicates against any of its arguments, else it returns
 *   logical false. Note that f is short-circuiting in that it will stop execution on the first
 *   argument that triggers a logical true result against the original predicates.
 */
cljs.core.some_fn = (function cljs$core$some_fn(var_args){
var G__6718 = arguments.length;
switch (G__6718) {
case 1:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8891 = arguments.length;
var i__5727__auto___8892 = (0);
while(true){
if((i__5727__auto___8892 < len__5726__auto___8891)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8892]));

var G__8893 = (i__5727__auto___8892 + (1));
i__5727__auto___8892 = G__8893;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((3) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((3)),(0),null)):null);
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5752__auto__);

}
});

(cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1 = (function (p){
return (function() {
var cljs$core$sp1 = null;
var cljs$core$sp1__0 = (function (){
return null;
});
var cljs$core$sp1__1 = (function (x){
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
});
var cljs$core$sp1__2 = (function (x,y){
var or__5002__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
}
});
var cljs$core$sp1__3 = (function (x,y,z){
var or__5002__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
var or__5002__auto____$1 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
if(cljs.core.truth_(or__5002__auto____$1)){
return or__5002__auto____$1;
} else {
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(z) : p.call(null,z));
}
}
});
var cljs$core$sp1__4 = (function() { 
var G__8894__delegate = function (x,y,z,args){
var or__5002__auto__ = cljs$core$sp1.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.some(p,args);
}
};
var G__8894 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8895__i = 0, G__8895__a = new Array(arguments.length -  3);
while (G__8895__i < G__8895__a.length) {G__8895__a[G__8895__i] = arguments[G__8895__i + 3]; ++G__8895__i;}
  args = new cljs.core.IndexedSeq(G__8895__a,0,null);
} 
return G__8894__delegate.call(this,x,y,z,args);};
G__8894.cljs$lang$maxFixedArity = 3;
G__8894.cljs$lang$applyTo = (function (arglist__8896){
var x = cljs.core.first(arglist__8896);
arglist__8896 = cljs.core.next(arglist__8896);
var y = cljs.core.first(arglist__8896);
arglist__8896 = cljs.core.next(arglist__8896);
var z = cljs.core.first(arglist__8896);
var args = cljs.core.rest(arglist__8896);
return G__8894__delegate(x,y,z,args);
});
G__8894.cljs$core$IFn$_invoke$arity$variadic = G__8894__delegate;
return G__8894;
})()
;
cljs$core$sp1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$sp1__0.call(this);
case 1:
return cljs$core$sp1__1.call(this,x);
case 2:
return cljs$core$sp1__2.call(this,x,y);
case 3:
return cljs$core$sp1__3.call(this,x,y,z);
default:
var G__8897 = null;
if (arguments.length > 3) {
var G__8898__i = 0, G__8898__a = new Array(arguments.length -  3);
while (G__8898__i < G__8898__a.length) {G__8898__a[G__8898__i] = arguments[G__8898__i + 3]; ++G__8898__i;}
G__8897 = new cljs.core.IndexedSeq(G__8898__a,0,null);
}
return cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8897);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sp1.cljs$lang$maxFixedArity = 3;
cljs$core$sp1.cljs$lang$applyTo = cljs$core$sp1__4.cljs$lang$applyTo;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp1__0;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp1__1;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp1__2;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp1__3;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$sp1;
})()
}));

(cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2 = (function (p1,p2){
return (function() {
var cljs$core$sp2 = null;
var cljs$core$sp2__0 = (function (){
return null;
});
var cljs$core$sp2__1 = (function (x){
var or__5002__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
}
});
var cljs$core$sp2__2 = (function (x,y){
var or__5002__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
var or__5002__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__5002__auto____$1)){
return or__5002__auto____$1;
} else {
var or__5002__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__5002__auto____$2)){
return or__5002__auto____$2;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
}
}
}
});
var cljs$core$sp2__3 = (function (x,y,z){
var or__5002__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
var or__5002__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__5002__auto____$1)){
return or__5002__auto____$1;
} else {
var or__5002__auto____$2 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(or__5002__auto____$2)){
return or__5002__auto____$2;
} else {
var or__5002__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__5002__auto____$3)){
return or__5002__auto____$3;
} else {
var or__5002__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(or__5002__auto____$4)){
return or__5002__auto____$4;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
}
}
}
}
}
});
var cljs$core$sp2__4 = (function() { 
var G__8904__delegate = function (x,y,z,args){
var or__5002__auto__ = cljs$core$sp2.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.some((function (p1__6707_SHARP_){
var or__5002__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__6707_SHARP_) : p1.call(null,p1__6707_SHARP_));
if(cljs.core.truth_(or__5002__auto____$1)){
return or__5002__auto____$1;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__6707_SHARP_) : p2.call(null,p1__6707_SHARP_));
}
}),args);
}
};
var G__8904 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8905__i = 0, G__8905__a = new Array(arguments.length -  3);
while (G__8905__i < G__8905__a.length) {G__8905__a[G__8905__i] = arguments[G__8905__i + 3]; ++G__8905__i;}
  args = new cljs.core.IndexedSeq(G__8905__a,0,null);
} 
return G__8904__delegate.call(this,x,y,z,args);};
G__8904.cljs$lang$maxFixedArity = 3;
G__8904.cljs$lang$applyTo = (function (arglist__8906){
var x = cljs.core.first(arglist__8906);
arglist__8906 = cljs.core.next(arglist__8906);
var y = cljs.core.first(arglist__8906);
arglist__8906 = cljs.core.next(arglist__8906);
var z = cljs.core.first(arglist__8906);
var args = cljs.core.rest(arglist__8906);
return G__8904__delegate(x,y,z,args);
});
G__8904.cljs$core$IFn$_invoke$arity$variadic = G__8904__delegate;
return G__8904;
})()
;
cljs$core$sp2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$sp2__0.call(this);
case 1:
return cljs$core$sp2__1.call(this,x);
case 2:
return cljs$core$sp2__2.call(this,x,y);
case 3:
return cljs$core$sp2__3.call(this,x,y,z);
default:
var G__8907 = null;
if (arguments.length > 3) {
var G__8908__i = 0, G__8908__a = new Array(arguments.length -  3);
while (G__8908__i < G__8908__a.length) {G__8908__a[G__8908__i] = arguments[G__8908__i + 3]; ++G__8908__i;}
G__8907 = new cljs.core.IndexedSeq(G__8908__a,0,null);
}
return cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8907);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sp2.cljs$lang$maxFixedArity = 3;
cljs$core$sp2.cljs$lang$applyTo = cljs$core$sp2__4.cljs$lang$applyTo;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp2__0;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp2__1;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp2__2;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp2__3;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$sp2;
})()
}));

(cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3 = (function (p1,p2,p3){
return (function() {
var cljs$core$sp3 = null;
var cljs$core$sp3__0 = (function (){
return null;
});
var cljs$core$sp3__1 = (function (x){
var or__5002__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
var or__5002__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__5002__auto____$1)){
return or__5002__auto____$1;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
}
}
});
var cljs$core$sp3__2 = (function (x,y){
var or__5002__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
var or__5002__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__5002__auto____$1)){
return or__5002__auto____$1;
} else {
var or__5002__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__5002__auto____$2)){
return or__5002__auto____$2;
} else {
var or__5002__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(or__5002__auto____$3)){
return or__5002__auto____$3;
} else {
var or__5002__auto____$4 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(or__5002__auto____$4)){
return or__5002__auto____$4;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
}
}
}
}
}
});
var cljs$core$sp3__3 = (function (x,y,z){
var or__5002__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
var or__5002__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__5002__auto____$1)){
return or__5002__auto____$1;
} else {
var or__5002__auto____$2 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(or__5002__auto____$2)){
return or__5002__auto____$2;
} else {
var or__5002__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__5002__auto____$3)){
return or__5002__auto____$3;
} else {
var or__5002__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(or__5002__auto____$4)){
return or__5002__auto____$4;
} else {
var or__5002__auto____$5 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
if(cljs.core.truth_(or__5002__auto____$5)){
return or__5002__auto____$5;
} else {
var or__5002__auto____$6 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(or__5002__auto____$6)){
return or__5002__auto____$6;
} else {
var or__5002__auto____$7 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
if(cljs.core.truth_(or__5002__auto____$7)){
return or__5002__auto____$7;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(z) : p3.call(null,z));
}
}
}
}
}
}
}
}
});
var cljs$core$sp3__4 = (function() { 
var G__8909__delegate = function (x,y,z,args){
var or__5002__auto__ = cljs$core$sp3.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.some((function (p1__6708_SHARP_){
var or__5002__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__6708_SHARP_) : p1.call(null,p1__6708_SHARP_));
if(cljs.core.truth_(or__5002__auto____$1)){
return or__5002__auto____$1;
} else {
var or__5002__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__6708_SHARP_) : p2.call(null,p1__6708_SHARP_));
if(cljs.core.truth_(or__5002__auto____$2)){
return or__5002__auto____$2;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(p1__6708_SHARP_) : p3.call(null,p1__6708_SHARP_));
}
}
}),args);
}
};
var G__8909 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8910__i = 0, G__8910__a = new Array(arguments.length -  3);
while (G__8910__i < G__8910__a.length) {G__8910__a[G__8910__i] = arguments[G__8910__i + 3]; ++G__8910__i;}
  args = new cljs.core.IndexedSeq(G__8910__a,0,null);
} 
return G__8909__delegate.call(this,x,y,z,args);};
G__8909.cljs$lang$maxFixedArity = 3;
G__8909.cljs$lang$applyTo = (function (arglist__8911){
var x = cljs.core.first(arglist__8911);
arglist__8911 = cljs.core.next(arglist__8911);
var y = cljs.core.first(arglist__8911);
arglist__8911 = cljs.core.next(arglist__8911);
var z = cljs.core.first(arglist__8911);
var args = cljs.core.rest(arglist__8911);
return G__8909__delegate(x,y,z,args);
});
G__8909.cljs$core$IFn$_invoke$arity$variadic = G__8909__delegate;
return G__8909;
})()
;
cljs$core$sp3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$sp3__0.call(this);
case 1:
return cljs$core$sp3__1.call(this,x);
case 2:
return cljs$core$sp3__2.call(this,x,y);
case 3:
return cljs$core$sp3__3.call(this,x,y,z);
default:
var G__8912 = null;
if (arguments.length > 3) {
var G__8913__i = 0, G__8913__a = new Array(arguments.length -  3);
while (G__8913__i < G__8913__a.length) {G__8913__a[G__8913__i] = arguments[G__8913__i + 3]; ++G__8913__i;}
G__8912 = new cljs.core.IndexedSeq(G__8913__a,0,null);
}
return cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8912);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sp3.cljs$lang$maxFixedArity = 3;
cljs$core$sp3.cljs$lang$applyTo = cljs$core$sp3__4.cljs$lang$applyTo;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp3__0;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp3__1;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp3__2;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp3__3;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$sp3;
})()
}));

(cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic = (function (p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return (function() {
var cljs$core$spn = null;
var cljs$core$spn__0 = (function (){
return null;
});
var cljs$core$spn__1 = (function (x){
return cljs.core.some((function (p1__6709_SHARP_){
return (p1__6709_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__6709_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__6709_SHARP_.call(null,x));
}),ps__$1);
});
var cljs$core$spn__2 = (function (x,y){
return cljs.core.some((function (p1__6710_SHARP_){
var or__5002__auto__ = (p1__6710_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__6710_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__6710_SHARP_.call(null,x));
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return (p1__6710_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__6710_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__6710_SHARP_.call(null,y));
}
}),ps__$1);
});
var cljs$core$spn__3 = (function (x,y,z){
return cljs.core.some((function (p1__6711_SHARP_){
var or__5002__auto__ = (p1__6711_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__6711_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__6711_SHARP_.call(null,x));
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
var or__5002__auto____$1 = (p1__6711_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__6711_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__6711_SHARP_.call(null,y));
if(cljs.core.truth_(or__5002__auto____$1)){
return or__5002__auto____$1;
} else {
return (p1__6711_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__6711_SHARP_.cljs$core$IFn$_invoke$arity$1(z) : p1__6711_SHARP_.call(null,z));
}
}
}),ps__$1);
});
var cljs$core$spn__4 = (function() { 
var G__8914__delegate = function (x,y,z,args){
var or__5002__auto__ = cljs$core$spn.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.some((function (p1__6712_SHARP_){
return cljs.core.some(p1__6712_SHARP_,args);
}),ps__$1);
}
};
var G__8914 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8915__i = 0, G__8915__a = new Array(arguments.length -  3);
while (G__8915__i < G__8915__a.length) {G__8915__a[G__8915__i] = arguments[G__8915__i + 3]; ++G__8915__i;}
  args = new cljs.core.IndexedSeq(G__8915__a,0,null);
} 
return G__8914__delegate.call(this,x,y,z,args);};
G__8914.cljs$lang$maxFixedArity = 3;
G__8914.cljs$lang$applyTo = (function (arglist__8916){
var x = cljs.core.first(arglist__8916);
arglist__8916 = cljs.core.next(arglist__8916);
var y = cljs.core.first(arglist__8916);
arglist__8916 = cljs.core.next(arglist__8916);
var z = cljs.core.first(arglist__8916);
var args = cljs.core.rest(arglist__8916);
return G__8914__delegate(x,y,z,args);
});
G__8914.cljs$core$IFn$_invoke$arity$variadic = G__8914__delegate;
return G__8914;
})()
;
cljs$core$spn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$spn__0.call(this);
case 1:
return cljs$core$spn__1.call(this,x);
case 2:
return cljs$core$spn__2.call(this,x,y);
case 3:
return cljs$core$spn__3.call(this,x,y,z);
default:
var G__8917 = null;
if (arguments.length > 3) {
var G__8918__i = 0, G__8918__a = new Array(arguments.length -  3);
while (G__8918__i < G__8918__a.length) {G__8918__a[G__8918__i] = arguments[G__8918__i + 3]; ++G__8918__i;}
G__8917 = new cljs.core.IndexedSeq(G__8918__a,0,null);
}
return cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8917);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$spn.cljs$lang$maxFixedArity = 3;
cljs$core$spn.cljs$lang$applyTo = cljs$core$spn__4.cljs$lang$applyTo;
cljs$core$spn.cljs$core$IFn$_invoke$arity$0 = cljs$core$spn__0;
cljs$core$spn.cljs$core$IFn$_invoke$arity$1 = cljs$core$spn__1;
cljs$core$spn.cljs$core$IFn$_invoke$arity$2 = cljs$core$spn__2;
cljs$core$spn.cljs$core$IFn$_invoke$arity$3 = cljs$core$spn__3;
cljs$core$spn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$spn;
})()
}));

/** @this {Function} */
(cljs.core.some_fn.cljs$lang$applyTo = (function (seq6714){
var G__6715 = cljs.core.first(seq6714);
var seq6714__$1 = cljs.core.next(seq6714);
var G__6716 = cljs.core.first(seq6714__$1);
var seq6714__$2 = cljs.core.next(seq6714__$1);
var G__6717 = cljs.core.first(seq6714__$2);
var seq6714__$3 = cljs.core.next(seq6714__$2);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6715,G__6716,G__6717,seq6714__$3);
}));

(cljs.core.some_fn.cljs$lang$maxFixedArity = (3));

/**
 * Returns a lazy sequence consisting of the result of applying f to
 *   the set of first items of each coll, followed by applying f to the
 *   set of second items in each coll, until any one of the colls is
 *   exhausted.  Any remaining items in other colls are ignored. Function
 *   f should accept number-of-colls arguments. Returns a transducer when
 *   no collection is provided.
 */
cljs.core.map = (function cljs$core$map(var_args){
var G__6726 = arguments.length;
switch (G__6726) {
case 1:
return cljs.core.map.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.map.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___8924 = arguments.length;
var i__5727__auto___8925 = (0);
while(true){
if((i__5727__auto___8925 < len__5726__auto___8924)){
args_arr__5751__auto__.push((arguments[i__5727__auto___8925]));

var G__8926 = (i__5727__auto___8925 + (1));
i__5727__auto___8925 = G__8926;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((4) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((4)),(0),null)):null);
return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__5752__auto__);

}
});

(cljs.core.map.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
return (function() {
var G__8927 = null;
var G__8927__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8927__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__8927__2 = (function (result,input){
var G__6727 = result;
var G__6728 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(input) : f.call(null,input));
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__6727,G__6728) : rf.call(null,G__6727,G__6728));
});
var G__8927__3 = (function() { 
var G__8928__delegate = function (result,input,inputs){
var G__6729 = result;
var G__6730 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,input,inputs);
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__6729,G__6730) : rf.call(null,G__6729,G__6730));
};
var G__8928 = function (result,input,var_args){
var inputs = null;
if (arguments.length > 2) {
var G__8929__i = 0, G__8929__a = new Array(arguments.length -  2);
while (G__8929__i < G__8929__a.length) {G__8929__a[G__8929__i] = arguments[G__8929__i + 2]; ++G__8929__i;}
  inputs = new cljs.core.IndexedSeq(G__8929__a,0,null);
} 
return G__8928__delegate.call(this,result,input,inputs);};
G__8928.cljs$lang$maxFixedArity = 2;
G__8928.cljs$lang$applyTo = (function (arglist__8930){
var result = cljs.core.first(arglist__8930);
arglist__8930 = cljs.core.next(arglist__8930);
var input = cljs.core.first(arglist__8930);
var inputs = cljs.core.rest(arglist__8930);
return G__8928__delegate(result,input,inputs);
});
G__8928.cljs$core$IFn$_invoke$arity$variadic = G__8928__delegate;
return G__8928;
})()
;
G__8927 = function(result,input,var_args){
var inputs = var_args;
switch(arguments.length){
case 0:
return G__8927__0.call(this);
case 1:
return G__8927__1.call(this,result);
case 2:
return G__8927__2.call(this,result,input);
default:
var G__8931 = null;
if (arguments.length > 2) {
var G__8932__i = 0, G__8932__a = new Array(arguments.length -  2);
while (G__8932__i < G__8932__a.length) {G__8932__a[G__8932__i] = arguments[G__8932__i + 2]; ++G__8932__i;}
G__8931 = new cljs.core.IndexedSeq(G__8932__a,0,null);
}
return G__8927__3.cljs$core$IFn$_invoke$arity$variadic(result,input, G__8931);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8927.cljs$lang$maxFixedArity = 2;
G__8927.cljs$lang$applyTo = G__8927__3.cljs$lang$applyTo;
G__8927.cljs$core$IFn$_invoke$arity$0 = G__8927__0;
G__8927.cljs$core$IFn$_invoke$arity$1 = G__8927__1;
G__8927.cljs$core$IFn$_invoke$arity$2 = G__8927__2;
G__8927.cljs$core$IFn$_invoke$arity$variadic = G__8927__3.cljs$core$IFn$_invoke$arity$variadic;
return G__8927;
})()
});
}));

(cljs.core.map.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__5804__auto__ = cljs.core.seq(coll);
if(temp__5804__auto__){
var s = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__5593__auto___8933 = size;
var i_8934 = (0);
while(true){
if((i_8934 < n__5593__auto___8933)){
cljs.core.chunk_append(b,(function (){var G__6731 = cljs.core._nth(c,i_8934);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__6731) : f.call(null,G__6731));
})());

var G__8935 = (i_8934 + (1));
i_8934 = G__8935;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__6732 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__6732) : f.call(null,G__6732));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.map.cljs$core$IFn$_invoke$arity$3 = (function (f,c1,c2){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if(((s1) && (s2))){
return cljs.core.cons((function (){var G__6733 = cljs.core.first(s1);
var G__6734 = cljs.core.first(s2);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6733,G__6734) : f.call(null,G__6733,G__6734));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,cljs.core.rest(s1),cljs.core.rest(s2)));
} else {
return null;
}
}),null,null));
}));

(cljs.core.map.cljs$core$IFn$_invoke$arity$4 = (function (f,c1,c2,c3){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
var s3 = cljs.core.seq(c3);
if(((s1) && (((s2) && (s3))))){
return cljs.core.cons((function (){var G__6735 = cljs.core.first(s1);
var G__6736 = cljs.core.first(s2);
var G__6737 = cljs.core.first(s3);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__6735,G__6736,G__6737) : f.call(null,G__6735,G__6736,G__6737));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$4(f,cljs.core.rest(s1),cljs.core.rest(s2),cljs.core.rest(s3)));
} else {
return null;
}
}),null,null));
}));

(cljs.core.map.cljs$core$IFn$_invoke$arity$variadic = (function (f,c1,c2,c3,colls){
var step = (function cljs$core$step(cs){
return (new cljs.core.LazySeq(null,(function (){
var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cs);
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.cons(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs$core$step(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
});
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__6719_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,p1__6719_SHARP_);
}),step(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c3,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c2,c1], 0))));
}));

/** @this {Function} */
(cljs.core.map.cljs$lang$applyTo = (function (seq6721){
var G__6722 = cljs.core.first(seq6721);
var seq6721__$1 = cljs.core.next(seq6721);
var G__6723 = cljs.core.first(seq6721__$1);
var seq6721__$2 = cljs.core.next(seq6721__$1);
var G__6724 = cljs.core.first(seq6721__$2);
var seq6721__$3 = cljs.core.next(seq6721__$2);
var G__6725 = cljs.core.first(seq6721__$3);
var seq6721__$4 = cljs.core.next(seq6721__$3);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6722,G__6723,G__6724,G__6725,seq6721__$4);
}));

(cljs.core.map.cljs$lang$maxFixedArity = (4));

/**
 * Returns a lazy sequence of the first n items in coll, or all items if
 *   there are fewer than n.  Returns a stateful transducer when
 *   no collection is provided.
 */
cljs.core.take = (function cljs$core$take(var_args){
var G__6739 = arguments.length;
switch (G__6739) {
case 1:
return cljs.core.take.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.take.cljs$core$IFn$_invoke$arity$1 = (function (n){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (function (rf){
var na = cljs.core.volatile_BANG_(n);
return (function() {
var G__8947 = null;
var G__8947__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8947__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__8947__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
var nn = na.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(na.cljs$core$IDeref$_deref$arity$1(null) - (1)));
var result__$1 = (((n__$1 > (0)))?(rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input)):result);
if((!((nn > (0))))){
return cljs.core.ensure_reduced(result__$1);
} else {
return result__$1;
}
});
G__8947 = function(result,input){
switch(arguments.length){
case 0:
return G__8947__0.call(this);
case 1:
return G__8947__1.call(this,result);
case 2:
return G__8947__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8947.cljs$core$IFn$_invoke$arity$0 = G__8947__0;
G__8947.cljs$core$IFn$_invoke$arity$1 = G__8947__1;
G__8947.cljs$core$IFn$_invoke$arity$2 = G__8947__2;
return G__8947;
})()
});
}));

(cljs.core.take.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (new cljs.core.LazySeq(null,(function (){
if((n > (0))){
var temp__5804__auto__ = cljs.core.seq(coll);
if(temp__5804__auto__){
var s = temp__5804__auto__;
return cljs.core.cons(cljs.core.first(s),cljs.core.take.cljs$core$IFn$_invoke$arity$2((n - (1)),cljs.core.rest(s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.take.cljs$lang$maxFixedArity = 2);

/**
 * Returns a laziness-preserving sequence of all but the first n items in coll.
 *   Returns a stateful transducer when no collection is provided.
 */
cljs.core.drop = (function cljs$core$drop(var_args){
var G__6741 = arguments.length;
switch (G__6741) {
case 1:
return cljs.core.drop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.drop.cljs$core$IFn$_invoke$arity$1 = (function (n){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (function (rf){
var na = cljs.core.volatile_BANG_(n);
return (function() {
var G__8960 = null;
var G__8960__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8960__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__8960__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
na.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(na.cljs$core$IDeref$_deref$arity$1(null) - (1)));

if((n__$1 > (0))){
return result;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
G__8960 = function(result,input){
switch(arguments.length){
case 0:
return G__8960__0.call(this);
case 1:
return G__8960__1.call(this,result);
case 2:
return G__8960__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8960.cljs$core$IFn$_invoke$arity$0 = G__8960__0;
G__8960.cljs$core$IFn$_invoke$arity$1 = G__8960__1;
G__8960.cljs$core$IFn$_invoke$arity$2 = G__8960__2;
return G__8960;
})()
});
}));

(cljs.core.drop.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition1$ & (262144))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IDrop$))))?true:false):false)){
var or__5002__auto__ = (((n > (0)))?coll.cljs$core$IDrop$_drop$arity$2(null,Math.ceil(n)):cljs.core.seq(coll));
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.List.EMPTY;
}
} else {
var step = (function (n__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if((((n__$1 > (0))) && (s))){
var G__8966 = (n__$1 - (1));
var G__8967 = cljs.core.rest(s);
n__$1 = G__8966;
coll__$1 = G__8967;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,(function (){
return step(n,coll);
}),null,null));
}
}));

(cljs.core.drop.cljs$lang$maxFixedArity = 2);

/**
 * Return a lazy sequence of all but the last n (default 1) items in coll
 */
cljs.core.drop_last = (function cljs$core$drop_last(var_args){
var G__6744 = arguments.length;
switch (G__6744) {
case 1:
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((1),s);
}));

(cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2 = (function (n,s){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3((function (x,_){
return x;
}),s,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,s));
}));

(cljs.core.drop_last.cljs$lang$maxFixedArity = 2);

/**
 * Returns a seq of the last n items in coll.  Depending on the type
 *   of coll may be no better than linear time.  For vectors, see also subvec.
 */
cljs.core.take_last = (function cljs$core$take_last(n,coll){
var s = cljs.core.seq(coll);
var lead = cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll));
while(true){
if(lead){
var G__8969 = cljs.core.next(s);
var G__8970 = cljs.core.next(lead);
s = G__8969;
lead = G__8970;
continue;
} else {
return s;
}
break;
}
});
/**
 * Returns a lazy sequence of the items in coll starting from the
 *   first item for which (pred item) returns logical false.  Returns a
 *   stateful transducer when no collection is provided.
 */
cljs.core.drop_while = (function cljs$core$drop_while(var_args){
var G__6746 = arguments.length;
switch (G__6746) {
case 1:
return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return (function (rf){
var da = cljs.core.volatile_BANG_(true);
return (function() {
var G__8972 = null;
var G__8972__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8972__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__8972__2 = (function (result,input){
var drop_QMARK_ = cljs.core.deref(da);
if(cljs.core.truth_((function (){var and__5000__auto__ = drop_QMARK_;
if(cljs.core.truth_(and__5000__auto__)){
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(input) : pred.call(null,input));
} else {
return and__5000__auto__;
}
})())){
return result;
} else {
cljs.core.vreset_BANG_(da,null);

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
G__8972 = function(result,input){
switch(arguments.length){
case 0:
return G__8972__0.call(this);
case 1:
return G__8972__1.call(this,result);
case 2:
return G__8972__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8972.cljs$core$IFn$_invoke$arity$0 = G__8972__0;
G__8972.cljs$core$IFn$_invoke$arity$1 = G__8972__1;
G__8972.cljs$core$IFn$_invoke$arity$2 = G__8972__2;
return G__8972;
})()
});
}));

(cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
var step = (function (pred__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if(cljs.core.truth_((function (){var and__5000__auto__ = s;
if(and__5000__auto__){
var G__6747 = cljs.core.first(s);
return (pred__$1.cljs$core$IFn$_invoke$arity$1 ? pred__$1.cljs$core$IFn$_invoke$arity$1(G__6747) : pred__$1.call(null,G__6747));
} else {
return and__5000__auto__;
}
})())){
var G__8977 = pred__$1;
var G__8978 = cljs.core.rest(s);
pred__$1 = G__8977;
coll__$1 = G__8978;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,(function (){
return step(pred,coll);
}),null,null));
}));

(cljs.core.drop_while.cljs$lang$maxFixedArity = 2);


/**
* @constructor
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Cycle = (function (meta,all,prev,current,_next){
this.meta = meta;
this.all = all;
this.prev = prev;
this.current = current;
this._next = _next;
this.cljs$lang$protocol_mask$partition0$ = 26083532;
this.cljs$lang$protocol_mask$partition1$ = 1;
});
(cljs.core.Cycle.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.Cycle.prototype.currentval = (function (){
var self__ = this;
var coll = this;
if(self__.current){
} else {
var temp__5802__auto___8979 = cljs.core.next(self__.prev);
if(temp__5802__auto___8979){
var c_8980 = temp__5802__auto___8979;
(self__.current = c_8980);
} else {
(self__.current = self__.all);
}
}

return self__.current;
}));

(cljs.core.Cycle.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Cycle.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ISeq$_rest$arity$1(null);
}));

(cljs.core.Cycle.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.Cycle.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (!((self__.current == null)));
}));

(cljs.core.Cycle.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
var s = coll__$1.currentval();
var ret = cljs.core.first(s);
while(true){
var s__$1 = (function (){var or__5002__auto__ = cljs.core.next(s);
if(or__5002__auto__){
return or__5002__auto__;
} else {
return self__.all;
}
})();
var ret__$1 = (function (){var G__6750 = ret;
var G__6751 = cljs.core.first(s__$1);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6750,G__6751) : f.call(null,G__6750,G__6751));
})();
if(cljs.core.reduced_QMARK_(ret__$1)){
return cljs.core.deref(ret__$1);
} else {
var G__8981 = s__$1;
var G__8982 = ret__$1;
s = G__8981;
ret = G__8982;
continue;
}
break;
}
}));

(cljs.core.Cycle.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
var s = coll__$1.currentval();
var ret = start;
while(true){
var ret__$1 = (function (){var G__6752 = ret;
var G__6753 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6752,G__6753) : f.call(null,G__6752,G__6753));
})();
if(cljs.core.reduced_QMARK_(ret__$1)){
return cljs.core.deref(ret__$1);
} else {
var G__8983 = (function (){var or__5002__auto__ = cljs.core.next(s);
if(or__5002__auto__){
return or__5002__auto__;
} else {
return self__.all;
}
})();
var G__8984 = ret__$1;
s = G__8983;
ret = G__8984;
continue;
}
break;
}
}));

(cljs.core.Cycle.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(coll__$1.currentval());
}));

(cljs.core.Cycle.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__._next == null)){
(self__._next = (new cljs.core.Cycle(null,self__.all,coll__$1.currentval(),null,null)));
} else {
}

return self__._next;
}));

(cljs.core.Cycle.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.Cycle.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.Cycle(new_meta,self__.all,self__.prev,self__.current,self__._next));
}
}));

(cljs.core.Cycle.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.Cycle.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"all","all",-1762306027,null),new cljs.core.Symbol(null,"prev","prev",43462301,null),cljs.core.with_meta(new cljs.core.Symbol(null,"current","current",552492924,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"_next","_next",101877036,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Cycle.cljs$lang$type = true);

(cljs.core.Cycle.cljs$lang$ctorStr = "cljs.core/Cycle");

(cljs.core.Cycle.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/Cycle");
}));

/**
 * Positional factory function for cljs.core/Cycle.
 */
cljs.core.__GT_Cycle = (function cljs$core$__GT_Cycle(meta,all,prev,current,_next){
return (new cljs.core.Cycle(meta,all,prev,current,_next));
});

/**
 * Returns a lazy (infinite!) sequence of repetitions of the items in coll.
 */
cljs.core.cycle = (function cljs$core$cycle(coll){
var temp__5802__auto__ = cljs.core.seq(coll);
if(temp__5802__auto__){
var vals = temp__5802__auto__;
return (new cljs.core.Cycle(null,vals,null,vals,null));
} else {
return cljs.core.List.EMPTY;
}
});
/**
 * Returns a vector of [(take n coll) (drop n coll)]
 */
cljs.core.split_at = (function cljs$core$split_at(n,coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,coll),cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll)], null);
});

/**
* @constructor
 * @implements {cljs.core.IDrop}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Repeat = (function (meta,count,val,next,__hash){
this.meta = meta;
this.count = count;
this.val = val;
this.next = next;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 262145;
});
(cljs.core.Repeat.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.Repeat.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.Repeat.prototype.indexOf = (function() {
var G__8987 = null;
var G__8987__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__8987__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__8987 = function(x,start){
switch(arguments.length){
case 1:
return G__8987__1.call(this,x);
case 2:
return G__8987__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8987.cljs$core$IFn$_invoke$arity$1 = G__8987__1;
G__8987.cljs$core$IFn$_invoke$arity$2 = G__8987__2;
return G__8987;
})()
);

(cljs.core.Repeat.prototype.lastIndexOf = (function() {
var G__8988 = null;
var G__8988__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,self__.count);
});
var G__8988__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__8988 = function(x,start){
switch(arguments.length){
case 1:
return G__8988__1.call(this,x);
case 2:
return G__8988__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8988.cljs$core$IFn$_invoke$arity$1 = G__8988__1;
G__8988.cljs$core$IFn$_invoke$arity$2 = G__8988__2;
return G__8988;
})()
);

(cljs.core.Repeat.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Repeat.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.next == null)){
if((self__.count > (1))){
(self__.next = (new cljs.core.Repeat(null,(self__.count - (1)),self__.val,null,null)));

return self__.next;
} else {
if(((-1) === self__.count)){
return coll__$1;
} else {
return null;
}
}
} else {
return self__.next;
}
}));

(cljs.core.Repeat.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.Repeat.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.Repeat.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.Repeat.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return false;
}));

(cljs.core.Repeat.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
if((self__.count === (-1))){
var ret = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(self__.val,self__.val) : f.call(null,self__.val,self__.val));
while(true){
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.deref(ret);
} else {
var G__8991 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret,self__.val) : f.call(null,ret,self__.val));
ret = G__8991;
continue;
}
break;
}
} else {
var i = (1);
var ret = self__.val;
while(true){
if((i < self__.count)){
var ret__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret,self__.val) : f.call(null,ret,self__.val));
if(cljs.core.reduced_QMARK_(ret__$1)){
return cljs.core.deref(ret__$1);
} else {
var G__8992 = (i + (1));
var G__8993 = ret__$1;
i = G__8992;
ret = G__8993;
continue;
}
} else {
return ret;
}
break;
}
}
}));

(cljs.core.Repeat.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
if((self__.count === (-1))){
var ret = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(start,self__.val) : f.call(null,start,self__.val));
while(true){
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.deref(ret);
} else {
var G__8994 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret,self__.val) : f.call(null,ret,self__.val));
ret = G__8994;
continue;
}
break;
}
} else {
var i = (0);
var ret = start;
while(true){
if((i < self__.count)){
var ret__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret,self__.val) : f.call(null,ret,self__.val));
if(cljs.core.reduced_QMARK_(ret__$1)){
return cljs.core.deref(ret__$1);
} else {
var G__8995 = (i + (1));
var G__8996 = ret__$1;
i = G__8995;
ret = G__8996;
continue;
}
} else {
return ret;
}
break;
}
}
}));

(cljs.core.Repeat.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.val;
}));

(cljs.core.Repeat.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.next == null)){
if((self__.count > (1))){
(self__.next = (new cljs.core.Repeat(null,(self__.count - (1)),self__.val,null,null)));

return self__.next;
} else {
if(((-1) === self__.count)){
return coll__$1;
} else {
return cljs.core.List.EMPTY;
}
}
} else {
return self__.next;
}
}));

(cljs.core.Repeat.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.Repeat.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.Repeat(new_meta,self__.count,self__.val,self__.next,null));
}
}));

(cljs.core.Repeat.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.Repeat.prototype.cljs$core$IDrop$_drop$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if((self__.count === (-1))){
return coll__$1;
} else {
var dropped_count = (self__.count - n);
if((dropped_count > (0))){
return (new cljs.core.Repeat(null,dropped_count,self__.val,null,null));
} else {
return null;
}
}
}));

(cljs.core.Repeat.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"val","val",1769233139,null),cljs.core.with_meta(new cljs.core.Symbol(null,"next","next",1522830042,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Repeat.cljs$lang$type = true);

(cljs.core.Repeat.cljs$lang$ctorStr = "cljs.core/Repeat");

(cljs.core.Repeat.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/Repeat");
}));

/**
 * Positional factory function for cljs.core/Repeat.
 */
cljs.core.__GT_Repeat = (function cljs$core$__GT_Repeat(meta,count,val,next,__hash){
return (new cljs.core.Repeat(meta,count,val,next,__hash));
});

/**
 * Returns a lazy (infinite!, or length n if supplied) sequence of xs.
 */
cljs.core.repeat = (function cljs$core$repeat(var_args){
var G__6755 = arguments.length;
switch (G__6755) {
case 1:
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.repeat.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (new cljs.core.Repeat(null,(-1),x,null,null));
}));

(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2 = (function (n,x){
if((n > (0))){
return (new cljs.core.Repeat(null,n,x,null,null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.repeat.cljs$lang$maxFixedArity = 2);

/**
 * DEPRECATED: Use 'repeat' instead.
 *   Returns a lazy seq of n xs.
 */
cljs.core.replicate = (function cljs$core$replicate(n,x){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
});
/**
 * Takes a function of no args, presumably with side effects, and
 *   returns an infinite (or length n if supplied) lazy sequence of calls
 *   to it
 */
cljs.core.repeatedly = (function cljs$core$repeatedly(var_args){
var G__6757 = arguments.length;
switch (G__6757) {
case 1:
return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
}),null,null));
}));

(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2 = (function (n,f){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
}));

(cljs.core.repeatedly.cljs$lang$maxFixedArity = 2);

cljs.core.UNREALIZED_SEED = ({});

/**
* @constructor
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Iterate = (function (meta,f,prev_seed,seed,next){
this.meta = meta;
this.f = f;
this.prev_seed = prev_seed;
this.seed = seed;
this.next = next;
this.cljs$lang$protocol_mask$partition0$ = 26083532;
this.cljs$lang$protocol_mask$partition1$ = 1;
});
(cljs.core.Iterate.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.Iterate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Iterate.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ISeq$_rest$arity$1(null);
}));

(cljs.core.Iterate.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.Iterate.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (!((self__.seed === cljs.core.UNREALIZED_SEED)));
}));

(cljs.core.Iterate.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,rf){
var self__ = this;
var coll__$1 = this;
var first = coll__$1.cljs$core$ISeq$_first$arity$1(null);
var v = (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(first) : self__.f.call(null,first));
var ret = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(first,v) : rf.call(null,first,v));
var v__$1 = v;
while(true){
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.deref(ret);
} else {
var v__$2 = (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(v__$1) : self__.f.call(null,v__$1));
var G__9010 = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(ret,v__$2) : rf.call(null,ret,v__$2));
var G__9011 = v__$2;
ret = G__9010;
v__$1 = G__9011;
continue;
}
break;
}
}));

(cljs.core.Iterate.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,rf,start){
var self__ = this;
var coll__$1 = this;
var v = coll__$1.cljs$core$ISeq$_first$arity$1(null);
var ret = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(start,v) : rf.call(null,start,v));
var v__$1 = v;
while(true){
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.deref(ret);
} else {
var v__$2 = (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(v__$1) : self__.f.call(null,v__$1));
var G__9014 = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(ret,v__$2) : rf.call(null,ret,v__$2));
var G__9015 = v__$2;
ret = G__9014;
v__$1 = G__9015;
continue;
}
break;
}
}));

(cljs.core.Iterate.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core.UNREALIZED_SEED === self__.seed)){
(self__.seed = (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(self__.prev_seed) : self__.f.call(null,self__.prev_seed)));
} else {
}

return self__.seed;
}));

(cljs.core.Iterate.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.next == null)){
(self__.next = (new cljs.core.Iterate(null,self__.f,coll__$1.cljs$core$ISeq$_first$arity$1(null),cljs.core.UNREALIZED_SEED,null)));
} else {
}

return self__.next;
}));

(cljs.core.Iterate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.Iterate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.Iterate(new_meta,self__.f,self__.prev_seed,self__.seed,self__.next));
}
}));

(cljs.core.Iterate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.Iterate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"prev-seed","prev-seed",2126381367,null),cljs.core.with_meta(new cljs.core.Symbol(null,"seed","seed",1709144854,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"next","next",1522830042,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Iterate.cljs$lang$type = true);

(cljs.core.Iterate.cljs$lang$ctorStr = "cljs.core/Iterate");

(cljs.core.Iterate.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/Iterate");
}));

/**
 * Positional factory function for cljs.core/Iterate.
 */
cljs.core.__GT_Iterate = (function cljs$core$__GT_Iterate(meta,f,prev_seed,seed,next){
return (new cljs.core.Iterate(meta,f,prev_seed,seed,next));
});

/**
 * Returns a lazy sequence of x, (f x), (f (f x)) etc. f must be free of side-effects
 */
cljs.core.iterate = (function cljs$core$iterate(f,x){
return (new cljs.core.Iterate(null,f,null,x,null));
});
/**
 * Returns a lazy seq of the first item in each coll, then the second etc.
 */
cljs.core.interleave = (function cljs$core$interleave(var_args){
var G__6762 = arguments.length;
switch (G__6762) {
case 0:
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___9018 = arguments.length;
var i__5727__auto___9019 = (0);
while(true){
if((i__5727__auto___9019 < len__5726__auto___9018)){
args_arr__5751__auto__.push((arguments[i__5727__auto___9019]));

var G__9020 = (i__5727__auto___9019 + (1));
i__5727__auto___9019 = G__9020;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.interleave.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.List.EMPTY;
}));

(cljs.core.interleave.cljs$core$IFn$_invoke$arity$1 = (function (c1){
return (new cljs.core.LazySeq(null,(function (){
return c1;
}),null,null));
}));

(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2 = (function (c1,c2){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if(((s1) && (s2))){
return cljs.core.cons(cljs.core.first(s1),cljs.core.cons(cljs.core.first(s2),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s1),cljs.core.rest(s2))));
} else {
return null;
}
}),null,null));
}));

(cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic = (function (c1,c2,colls){
return (new cljs.core.LazySeq(null,(function (){
var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c2,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c1], 0)));
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.interleave,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
}));

/** @this {Function} */
(cljs.core.interleave.cljs$lang$applyTo = (function (seq6759){
var G__6760 = cljs.core.first(seq6759);
var seq6759__$1 = cljs.core.next(seq6759);
var G__6761 = cljs.core.first(seq6759__$1);
var seq6759__$2 = cljs.core.next(seq6759__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6760,G__6761,seq6759__$2);
}));

(cljs.core.interleave.cljs$lang$maxFixedArity = (2));

/**
 * Returns a lazy seq of the elements of coll separated by sep.
 *   Returns a stateful transducer when no collection is provided.
 */
cljs.core.interpose = (function cljs$core$interpose(var_args){
var G__6764 = arguments.length;
switch (G__6764) {
case 1:
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.interpose.cljs$core$IFn$_invoke$arity$1 = (function (sep){
return (function (rf){
var started = cljs.core.volatile_BANG_(false);
return (function() {
var G__9024 = null;
var G__9024__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__9024__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__9024__2 = (function (result,input){
if(cljs.core.truth_(cljs.core.deref(started))){
var sepr = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,sep) : rf.call(null,result,sep));
if(cljs.core.reduced_QMARK_(sepr)){
return sepr;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(sepr,input) : rf.call(null,sepr,input));
}
} else {
cljs.core.vreset_BANG_(started,true);

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
G__9024 = function(result,input){
switch(arguments.length){
case 0:
return G__9024__0.call(this);
case 1:
return G__9024__1.call(this,result);
case 2:
return G__9024__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9024.cljs$core$IFn$_invoke$arity$0 = G__9024__0;
G__9024.cljs$core$IFn$_invoke$arity$1 = G__9024__1;
G__9024.cljs$core$IFn$_invoke$arity$2 = G__9024__2;
return G__9024;
})()
});
}));

(cljs.core.interpose.cljs$core$IFn$_invoke$arity$2 = (function (sep,coll){
return cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(sep),coll));
}));

(cljs.core.interpose.cljs$lang$maxFixedArity = 2);

/**
 * Take a collection of collections, and return a lazy seq
 *   of items from the inner collection
 */
cljs.core.flatten1 = (function cljs$core$flatten1(colls){
var cat = (function cljs$core$flatten1_$_cat(coll,colls__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__5802__auto__ = cljs.core.seq(coll);
if(temp__5802__auto__){
var coll__$1 = temp__5802__auto__;
return cljs.core.cons(cljs.core.first(coll__$1),cljs$core$flatten1_$_cat(cljs.core.rest(coll__$1),colls__$1));
} else {
if(cljs.core.seq(colls__$1)){
return cljs$core$flatten1_$_cat(cljs.core.first(colls__$1),cljs.core.rest(colls__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(null,colls);
});
/**
 * Returns the result of applying concat to the result of applying map
 *   to f and colls.  Thus function f should return a collection. Returns
 *   a transducer when no collections are provided
 */
cljs.core.mapcat = (function cljs$core$mapcat(var_args){
var G__6768 = arguments.length;
switch (G__6768) {
case 1:
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___9026 = arguments.length;
var i__5727__auto___9027 = (0);
while(true){
if((i__5727__auto___9027 < len__5726__auto___9026)){
args_arr__5751__auto__.push((arguments[i__5727__auto___9027]));

var G__9029 = (i__5727__auto___9027 + (1));
i__5727__auto___9027 = G__9029;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((1) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((1)),(0),null)):null);
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5752__auto__);

}
});

(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$1(f),cljs.core.cat);
}));

(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic = (function (f,colls){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.map,f,colls));
}));

/** @this {Function} */
(cljs.core.mapcat.cljs$lang$applyTo = (function (seq6766){
var G__6767 = cljs.core.first(seq6766);
var seq6766__$1 = cljs.core.next(seq6766);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6767,seq6766__$1);
}));

(cljs.core.mapcat.cljs$lang$maxFixedArity = (1));

/**
 * Returns a lazy sequence of the items in coll for which
 *   (pred item) returns logical true. pred must be free of side-effects.
 *   Returns a transducer when no collection is provided.
 */
cljs.core.filter = (function cljs$core$filter(var_args){
var G__6770 = arguments.length;
switch (G__6770) {
case 1:
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.filter.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return (function (rf){
return (function() {
var G__9038 = null;
var G__9038__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__9038__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__9038__2 = (function (result,input){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(input) : pred.call(null,input)))){
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
} else {
return result;
}
});
G__9038 = function(result,input){
switch(arguments.length){
case 0:
return G__9038__0.call(this);
case 1:
return G__9038__1.call(this,result);
case 2:
return G__9038__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9038.cljs$core$IFn$_invoke$arity$0 = G__9038__0;
G__9038.cljs$core$IFn$_invoke$arity$1 = G__9038__1;
G__9038.cljs$core$IFn$_invoke$arity$2 = G__9038__2;
return G__9038;
})()
});
}));

(cljs.core.filter.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__5804__auto__ = cljs.core.seq(coll);
if(temp__5804__auto__){
var s = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__5593__auto___9039 = size;
var i_9040 = (0);
while(true){
if((i_9040 < n__5593__auto___9039)){
if(cljs.core.truth_((function (){var G__6771 = cljs.core._nth(c,i_9040);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__6771) : pred.call(null,G__6771));
})())){
cljs.core.chunk_append(b,cljs.core._nth(c,i_9040));
} else {
}

var G__9041 = (i_9040 + (1));
i_9040 = G__9041;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,cljs.core.chunk_rest(s)));
} else {
var f = cljs.core.first(s);
var r = cljs.core.rest(s);
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(f) : pred.call(null,f)))){
return cljs.core.cons(f,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,r));
} else {
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,r);
}
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.filter.cljs$lang$maxFixedArity = 2);

/**
 * Returns a lazy sequence of the items in coll for which
 *   (pred item) returns logical false. pred must be free of side-effects.
 *   Returns a transducer when no collection is provided.
 */
cljs.core.remove = (function cljs$core$remove(var_args){
var G__6773 = arguments.length;
switch (G__6773) {
case 1:
return cljs.core.remove.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.remove.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1(cljs.core.complement(pred));
}));

(cljs.core.remove.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(pred),coll);
}));

(cljs.core.remove.cljs$lang$maxFixedArity = 2);

/**
 * Returns a lazy sequence of the nodes in a tree, via a depth-first walk.
 *   branch? must be a fn of one arg that returns true if passed a node
 *   that can have children (but may not).  children must be a fn of one
 *   arg that returns a sequence of the children. Will only be called on
 *   nodes for which branch? returns true. Root is the root node of the
 *   tree.
 */
cljs.core.tree_seq = (function cljs$core$tree_seq(branch_QMARK_,children,root){
var walk = (function cljs$core$tree_seq_$_walk(node){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons(node,(cljs.core.truth_((branch_QMARK_.cljs$core$IFn$_invoke$arity$1 ? branch_QMARK_.cljs$core$IFn$_invoke$arity$1(node) : branch_QMARK_.call(null,node)))?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs$core$tree_seq_$_walk,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(children.cljs$core$IFn$_invoke$arity$1 ? children.cljs$core$IFn$_invoke$arity$1(node) : children.call(null,node))], 0)):null));
}),null,null));
});
return walk(root);
});
/**
 * Takes any nested combination of sequential things (lists, vectors,
 *   etc.) and returns their contents as a single, flat sequence.
 *   (flatten nil) returns nil.
 */
cljs.core.flatten = (function cljs$core$flatten(x){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__6774_SHARP_){
return (!(cljs.core.sequential_QMARK_(p1__6774_SHARP_)));
}),cljs.core.rest(cljs.core.tree_seq(cljs.core.sequential_QMARK_,cljs.core.seq,x)));
});
/**
 * Returns a new coll consisting of to-coll with all of the items of
 *   from-coll conjoined. A transducer may be supplied.
 */
cljs.core.into = (function cljs$core$into(var_args){
var G__6776 = arguments.length;
switch (G__6776) {
case 0:
return cljs.core.into.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.into.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.into.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.into.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.into.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.PersistentVector.EMPTY;
}));

(cljs.core.into.cljs$core$IFn$_invoke$arity$1 = (function (to){
return to;
}));

(cljs.core.into.cljs$core$IFn$_invoke$arity$2 = (function (to,from){
if((!((to == null)))){
if((((!((to == null))))?(((((to.cljs$lang$protocol_mask$partition1$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === to.cljs$core$IEditableCollection$))))?true:false):false)){
return cljs.core._with_meta(cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core.transient$(to),from)),cljs.core.meta(to));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,to,from);
}
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,to,from);
}
}));

(cljs.core.into.cljs$core$IFn$_invoke$arity$3 = (function (to,xform,from){
if((((!((to == null))))?(((((to.cljs$lang$protocol_mask$partition1$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === to.cljs$core$IEditableCollection$))))?true:false):false)){
var tm = cljs.core.meta(to);
var rf = (function() {
var G__9045 = null;
var G__9045__1 = (function (coll){
return cljs.core._with_meta(cljs.core.persistent_BANG_(coll),tm);
});
var G__9045__2 = (function (coll,v){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(coll,v);
});
G__9045 = function(coll,v){
switch(arguments.length){
case 1:
return G__9045__1.call(this,coll);
case 2:
return G__9045__2.call(this,coll,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9045.cljs$core$IFn$_invoke$arity$1 = G__9045__1;
G__9045.cljs$core$IFn$_invoke$arity$2 = G__9045__2;
return G__9045;
})()
;
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,rf,cljs.core.transient$(to),from);
} else {
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,cljs.core.conj,to,from);
}
}));

(cljs.core.into.cljs$lang$maxFixedArity = 3);

/**
 * Returns a vector consisting of the result of applying f to the
 *   set of first items of each coll, followed by applying f to the set
 *   of second items in each coll, until any one of the colls is
 *   exhausted.  Any remaining items in other colls are ignored. Function
 *   f should accept number-of-colls arguments.
 */
cljs.core.mapv = (function cljs$core$mapv(var_args){
var G__6785 = arguments.length;
switch (G__6785) {
case 2:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___9048 = arguments.length;
var i__5727__auto___9049 = (0);
while(true){
if((i__5727__auto___9049 < len__5726__auto___9048)){
args_arr__5751__auto__.push((arguments[i__5727__auto___9049]));

var G__9050 = (i__5727__auto___9049 + (1));
i__5727__auto___9049 = G__9050;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((4) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((4)),(0),null)):null);
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__5752__auto__);

}
});

(cljs.core.mapv.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (v,o){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(o) : f.call(null,o)));
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
}));

(cljs.core.mapv.cljs$core$IFn$_invoke$arity$3 = (function (f,c1,c2){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,c1,c2));
}));

(cljs.core.mapv.cljs$core$IFn$_invoke$arity$4 = (function (f,c1,c2,c3){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$4(f,c1,c2,c3));
}));

(cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic = (function (f,c1,c2,c3,colls){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.map,f,c1,c2,c3,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([colls], 0)));
}));

/** @this {Function} */
(cljs.core.mapv.cljs$lang$applyTo = (function (seq6780){
var G__6781 = cljs.core.first(seq6780);
var seq6780__$1 = cljs.core.next(seq6780);
var G__6782 = cljs.core.first(seq6780__$1);
var seq6780__$2 = cljs.core.next(seq6780__$1);
var G__6783 = cljs.core.first(seq6780__$2);
var seq6780__$3 = cljs.core.next(seq6780__$2);
var G__6784 = cljs.core.first(seq6780__$3);
var seq6780__$4 = cljs.core.next(seq6780__$3);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6781,G__6782,G__6783,G__6784,seq6780__$4);
}));

(cljs.core.mapv.cljs$lang$maxFixedArity = (4));

/**
 * Returns a vector of the items in coll for which
 *   (pred item) returns logical true. pred must be free of side-effects.
 */
cljs.core.filterv = (function cljs$core$filterv(pred,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (v,o){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(o) : pred.call(null,o)))){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,o);
} else {
return v;
}
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
});
/**
 * Returns a lazy sequence of lists of n items each, at offsets step
 *   apart. If step is not supplied, defaults to n, i.e. the partitions
 *   do not overlap. If a pad collection is supplied, use its elements as
 *   necessary to complete last partition up to n items. In case there are
 *   not enough padding elements, return a partition with less than n items.
 */
cljs.core.partition = (function cljs$core$partition(var_args){
var G__6787 = arguments.length;
switch (G__6787) {
case 2:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
return cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n,n,coll);
}));

(cljs.core.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,step,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__5804__auto__ = cljs.core.seq(coll);
if(temp__5804__auto__){
var s = temp__5804__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n,step,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.partition.cljs$core$IFn$_invoke$arity$4 = (function (n,step,pad,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__5804__auto__ = cljs.core.seq(coll);
if(temp__5804__auto__){
var s = temp__5804__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,cljs.core.partition.cljs$core$IFn$_invoke$arity$4(n,step,pad,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return (new cljs.core.List(null,cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(p,pad)),null,(1),null));
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.partition.cljs$lang$maxFixedArity = 4);

/**
 * Returns the value in a nested associative structure,
 *   where ks is a sequence of keys. Returns nil if the key is not present,
 *   or the not-found value if supplied.
 */
cljs.core.get_in = (function cljs$core$get_in(var_args){
var G__6789 = arguments.length;
switch (G__6789) {
case 2:
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2 = (function (m,ks){
var m__$1 = m;
var ks__$1 = cljs.core.seq(ks);
while(true){
if((ks__$1 == null)){
return m__$1;
} else {
var G__9062 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m__$1,cljs.core.first(ks__$1));
var G__9063 = cljs.core.next(ks__$1);
m__$1 = G__9062;
ks__$1 = G__9063;
continue;
}
break;
}
}));

(cljs.core.get_in.cljs$core$IFn$_invoke$arity$3 = (function (m,ks,not_found){
var sentinel = cljs.core.lookup_sentinel;
var m__$1 = m;
var ks__$1 = cljs.core.seq(ks);
while(true){
if((!((ks__$1 == null)))){
var m__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(m__$1,cljs.core.first(ks__$1),sentinel);
if((sentinel === m__$2)){
return not_found;
} else {
var G__9064 = sentinel;
var G__9065 = m__$2;
var G__9066 = cljs.core.next(ks__$1);
sentinel = G__9064;
m__$1 = G__9065;
ks__$1 = G__9066;
continue;
}
} else {
return m__$1;
}
break;
}
}));

(cljs.core.get_in.cljs$lang$maxFixedArity = 3);

/**
 * Associates a value in a nested associative structure, where ks is a
 *   sequence of keys and v is the new value and returns a new nested structure.
 *   If any levels do not exist, hash-maps will be created.
 */
cljs.core.assoc_in = (function cljs$core$assoc_in(m,p__6790,v){
var vec__6791 = p__6790;
var seq__6792 = cljs.core.seq(vec__6791);
var first__6793 = cljs.core.first(seq__6792);
var seq__6792__$1 = cljs.core.next(seq__6792);
var k = first__6793;
var ks = seq__6792__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__6794 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__6795 = ks;
var G__6796 = v;
return (cljs.core.assoc_in.cljs$core$IFn$_invoke$arity$3 ? cljs.core.assoc_in.cljs$core$IFn$_invoke$arity$3(G__6794,G__6795,G__6796) : cljs.core.assoc_in.call(null,G__6794,G__6795,G__6796));
})());
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
});
/**
 * 'Updates' a value in a nested associative structure, where ks is a
 *   sequence of keys and f is a function that will take the old value
 *   and any supplied args and return the new value, and returns a new
 *   nested structure.  If any levels do not exist, hash-maps will be
 *   created.
 */
cljs.core.update_in = (function cljs$core$update_in(var_args){
var G__6805 = arguments.length;
switch (G__6805) {
case 3:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___9072 = arguments.length;
var i__5727__auto___9073 = (0);
while(true){
if((i__5727__auto___9073 < len__5726__auto___9072)){
args_arr__5751__auto__.push((arguments[i__5727__auto___9073]));

var G__9074 = (i__5727__auto___9073 + (1));
i__5727__auto___9073 = G__9074;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((6) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((6)),(0),null)):null);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__5752__auto__);

}
});

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$3 = (function (m,p__6806,f){
var vec__6807 = p__6806;
var seq__6808 = cljs.core.seq(vec__6807);
var first__6809 = cljs.core.first(seq__6808);
var seq__6808__$1 = cljs.core.next(seq__6808);
var k = first__6809;
var ks = seq__6808__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__6810 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__6810) : f.call(null,G__6810));
})());
}
}));

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$4 = (function (m,p__6811,f,a){
var vec__6812 = p__6811;
var seq__6813 = cljs.core.seq(vec__6812);
var first__6814 = cljs.core.first(seq__6813);
var seq__6813__$1 = cljs.core.next(seq__6813);
var k = first__6814;
var ks = seq__6813__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__6815 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__6816 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6815,G__6816) : f.call(null,G__6815,G__6816));
})());
}
}));

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$5 = (function (m,p__6817,f,a,b){
var vec__6818 = p__6817;
var seq__6819 = cljs.core.seq(vec__6818);
var first__6820 = cljs.core.first(seq__6819);
var seq__6819__$1 = cljs.core.next(seq__6819);
var k = first__6820;
var ks = seq__6819__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$5(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__6821 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__6822 = a;
var G__6823 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__6821,G__6822,G__6823) : f.call(null,G__6821,G__6822,G__6823));
})());
}
}));

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$6 = (function (m,p__6824,f,a,b,c){
var vec__6825 = p__6824;
var seq__6826 = cljs.core.seq(vec__6825);
var first__6827 = cljs.core.first(seq__6826);
var seq__6826__$1 = cljs.core.next(seq__6826);
var k = first__6827;
var ks = seq__6826__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$6(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b,c));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__6828 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__6829 = a;
var G__6830 = b;
var G__6831 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__6828,G__6829,G__6830,G__6831) : f.call(null,G__6828,G__6829,G__6830,G__6831));
})());
}
}));

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic = (function (m,p__6832,f,a,b,c,args){
var vec__6833 = p__6832;
var seq__6834 = cljs.core.seq(vec__6833);
var first__6835 = cljs.core.first(seq__6834);
var seq__6834__$1 = cljs.core.next(seq__6834);
var k = first__6835;
var ks = seq__6834__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.update_in,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([b,c,args], 0)));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),a,b,c,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0)));
}
}));

/** @this {Function} */
(cljs.core.update_in.cljs$lang$applyTo = (function (seq6798){
var G__6799 = cljs.core.first(seq6798);
var seq6798__$1 = cljs.core.next(seq6798);
var G__6800 = cljs.core.first(seq6798__$1);
var seq6798__$2 = cljs.core.next(seq6798__$1);
var G__6801 = cljs.core.first(seq6798__$2);
var seq6798__$3 = cljs.core.next(seq6798__$2);
var G__6802 = cljs.core.first(seq6798__$3);
var seq6798__$4 = cljs.core.next(seq6798__$3);
var G__6803 = cljs.core.first(seq6798__$4);
var seq6798__$5 = cljs.core.next(seq6798__$4);
var G__6804 = cljs.core.first(seq6798__$5);
var seq6798__$6 = cljs.core.next(seq6798__$5);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6799,G__6800,G__6801,G__6802,G__6803,G__6804,seq6798__$6);
}));

(cljs.core.update_in.cljs$lang$maxFixedArity = (6));

/**
 * 'Updates' a value in an associative structure, where k is a
 *   key and f is a function that will take the old value
 *   and any supplied args and return the new value, and returns a new
 *   structure.  If the key does not exist, nil is passed as the old value.
 */
cljs.core.update = (function cljs$core$update(var_args){
var G__6844 = arguments.length;
switch (G__6844) {
case 3:
return cljs.core.update.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.update.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.update.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.update.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___9088 = arguments.length;
var i__5727__auto___9089 = (0);
while(true){
if((i__5727__auto___9089 < len__5726__auto___9088)){
args_arr__5751__auto__.push((arguments[i__5727__auto___9089]));

var G__9090 = (i__5727__auto___9089 + (1));
i__5727__auto___9089 = G__9090;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((6) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((6)),(0),null)):null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__5752__auto__);

}
});

(cljs.core.update.cljs$core$IFn$_invoke$arity$3 = (function (m,k,f){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__6845 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__6845) : f.call(null,G__6845));
})());
}));

(cljs.core.update.cljs$core$IFn$_invoke$arity$4 = (function (m,k,f,x){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__6846 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__6847 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6846,G__6847) : f.call(null,G__6846,G__6847));
})());
}));

(cljs.core.update.cljs$core$IFn$_invoke$arity$5 = (function (m,k,f,x,y){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__6848 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__6849 = x;
var G__6850 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__6848,G__6849,G__6850) : f.call(null,G__6848,G__6849,G__6850));
})());
}));

(cljs.core.update.cljs$core$IFn$_invoke$arity$6 = (function (m,k,f,x,y,z){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__6851 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__6852 = x;
var G__6853 = y;
var G__6854 = z;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__6851,G__6852,G__6853,G__6854) : f.call(null,G__6851,G__6852,G__6853,G__6854));
})());
}));

(cljs.core.update.cljs$core$IFn$_invoke$arity$variadic = (function (m,k,f,x,y,z,more){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),x,y,z,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([more], 0)));
}));

/** @this {Function} */
(cljs.core.update.cljs$lang$applyTo = (function (seq6837){
var G__6838 = cljs.core.first(seq6837);
var seq6837__$1 = cljs.core.next(seq6837);
var G__6839 = cljs.core.first(seq6837__$1);
var seq6837__$2 = cljs.core.next(seq6837__$1);
var G__6840 = cljs.core.first(seq6837__$2);
var seq6837__$3 = cljs.core.next(seq6837__$2);
var G__6841 = cljs.core.first(seq6837__$3);
var seq6837__$4 = cljs.core.next(seq6837__$3);
var G__6842 = cljs.core.first(seq6837__$4);
var seq6837__$5 = cljs.core.next(seq6837__$4);
var G__6843 = cljs.core.first(seq6837__$5);
var seq6837__$6 = cljs.core.next(seq6837__$5);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6838,G__6839,G__6840,G__6841,G__6842,G__6843,seq6837__$6);
}));

(cljs.core.update.cljs$lang$maxFixedArity = (6));


/**
* @constructor
*/
cljs.core.VectorNode = (function (edit,arr){
this.edit = edit;
this.arr = arr;
});

(cljs.core.VectorNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),new cljs.core.Symbol(null,"arr","arr",2115492975,null)], null);
}));

(cljs.core.VectorNode.cljs$lang$type = true);

(cljs.core.VectorNode.cljs$lang$ctorStr = "cljs.core/VectorNode");

(cljs.core.VectorNode.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/VectorNode");
}));

/**
 * Positional factory function for cljs.core/VectorNode.
 */
cljs.core.__GT_VectorNode = (function cljs$core$__GT_VectorNode(edit,arr){
return (new cljs.core.VectorNode(edit,arr));
});

cljs.core.pv_fresh_node = (function cljs$core$pv_fresh_node(edit){
return (new cljs.core.VectorNode(edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
});
cljs.core.pv_aget = (function cljs$core$pv_aget(node,idx){
return (node.arr[idx]);
});
cljs.core.pv_aset = (function cljs$core$pv_aset(node,idx,val){
return (node.arr[idx] = val);
});
cljs.core.pv_clone_node = (function cljs$core$pv_clone_node(node){
return (new cljs.core.VectorNode(node.edit,cljs.core.aclone(node.arr)));
});
cljs.core.tail_off = (function cljs$core$tail_off(pv){
var cnt = pv.cnt;
if((cnt < (32))){
return (0);
} else {
return (((cnt - (1)) >>> (5)) << (5));
}
});
cljs.core.new_path = (function cljs$core$new_path(edit,level,node){
var ll = level;
var ret = node;
while(true){
if((ll === (0))){
return ret;
} else {
var embed = ret;
var r = cljs.core.pv_fresh_node(edit);
var _ = cljs.core.pv_aset(r,(0),embed);
var G__9102 = (ll - (5));
var G__9103 = r;
ll = G__9102;
ret = G__9103;
continue;
}
break;
}
});
cljs.core.push_tail = (function cljs$core$push_tail(pv,level,parent,tailnode){
var ret = cljs.core.pv_clone_node(parent);
var subidx = (((pv.cnt - (1)) >>> level) & (31));
if(((5) === level)){
cljs.core.pv_aset(ret,subidx,tailnode);

return ret;
} else {
var child = cljs.core.pv_aget(parent,subidx);
if((!((child == null)))){
var node_to_insert = (function (){var G__6855 = pv;
var G__6856 = (level - (5));
var G__6857 = child;
var G__6858 = tailnode;
return (cljs.core.push_tail.cljs$core$IFn$_invoke$arity$4 ? cljs.core.push_tail.cljs$core$IFn$_invoke$arity$4(G__6855,G__6856,G__6857,G__6858) : cljs.core.push_tail.call(null,G__6855,G__6856,G__6857,G__6858));
})();
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
} else {
var node_to_insert = cljs.core.new_path(null,(level - (5)),tailnode);
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
}
}
});
cljs.core.vector_index_out_of_bounds = (function cljs$core$vector_index_out_of_bounds(i,cnt){
throw (new Error(["No item ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(i)," in vector of length ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cnt)].join('')));
});
cljs.core.first_array_for_longvec = (function cljs$core$first_array_for_longvec(pv){
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__9107 = cljs.core.pv_aget(node,(0));
var G__9108 = (level - (5));
node = G__9107;
level = G__9108;
continue;
} else {
return node.arr;
}
break;
}
});
cljs.core.unchecked_array_for = (function cljs$core$unchecked_array_for(pv,i){
if((i >= cljs.core.tail_off(pv))){
return pv.tail;
} else {
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__9112 = cljs.core.pv_aget(node,((i >>> level) & (31)));
var G__9113 = (level - (5));
node = G__9112;
level = G__9113;
continue;
} else {
return node.arr;
}
break;
}
}
});
cljs.core.array_for = (function cljs$core$array_for(pv,i){
if(((((0) <= i)) && ((i < pv.cnt)))){
return cljs.core.unchecked_array_for(pv,i);
} else {
return cljs.core.vector_index_out_of_bounds(i,pv.cnt);
}
});
cljs.core.do_assoc = (function cljs$core$do_assoc(pv,level,node,i,val){
var ret = cljs.core.pv_clone_node(node);
if((level === (0))){
cljs.core.pv_aset(ret,(i & (31)),val);

return ret;
} else {
var subidx = ((i >>> level) & (31));
cljs.core.pv_aset(ret,subidx,(function (){var G__6859 = pv;
var G__6860 = (level - (5));
var G__6861 = cljs.core.pv_aget(node,subidx);
var G__6862 = i;
var G__6863 = val;
return (cljs.core.do_assoc.cljs$core$IFn$_invoke$arity$5 ? cljs.core.do_assoc.cljs$core$IFn$_invoke$arity$5(G__6859,G__6860,G__6861,G__6862,G__6863) : cljs.core.do_assoc.call(null,G__6859,G__6860,G__6861,G__6862,G__6863));
})());

return ret;
}
});
cljs.core.pop_tail = (function cljs$core$pop_tail(pv,level,node){
var subidx = (((pv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = (function (){var G__6864 = pv;
var G__6865 = (level - (5));
var G__6866 = cljs.core.pv_aget(node,subidx);
return (cljs.core.pop_tail.cljs$core$IFn$_invoke$arity$3 ? cljs.core.pop_tail.cljs$core$IFn$_invoke$arity$3(G__6864,G__6865,G__6866) : cljs.core.pop_tail.call(null,G__6864,G__6865,G__6866));
})();
if((((new_child == null)) && ((subidx === (0))))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,new_child);

return ret;
}
} else {
if((subidx === (0))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,null);

return ret;

}
}
});

/**
* @constructor
*/
cljs.core.RangedIterator = (function (i,base,arr,v,start,end){
this.i = i;
this.base = base;
this.arr = arr;
this.v = v;
this.start = start;
this.end = end;
});
(cljs.core.RangedIterator.prototype.hasNext = (function (){
var self__ = this;
var this$ = this;
return (self__.i < self__.end);
}));

(cljs.core.RangedIterator.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(((self__.i - self__.base) === (32))){
(self__.arr = cljs.core.unchecked_array_for(self__.v,self__.i));

(self__.base = (self__.base + (32)));
} else {
}

var ret = (self__.arr[(self__.i & (31))]);
(self__.i = (self__.i + (1)));

return ret;
}));

(cljs.core.RangedIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"base","base",1825810849,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null)], null);
}));

(cljs.core.RangedIterator.cljs$lang$type = true);

(cljs.core.RangedIterator.cljs$lang$ctorStr = "cljs.core/RangedIterator");

(cljs.core.RangedIterator.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/RangedIterator");
}));

/**
 * Positional factory function for cljs.core/RangedIterator.
 */
cljs.core.__GT_RangedIterator = (function cljs$core$__GT_RangedIterator(i,base,arr,v,start,end){
return (new cljs.core.RangedIterator(i,base,arr,v,start,end));
});

cljs.core.ranged_iterator = (function cljs$core$ranged_iterator(v,start,end){
var i = start;
return (new cljs.core.RangedIterator(i,(i - (i % (32))),(((start < cljs.core.count(v)))?cljs.core.unchecked_array_for(v,i):null),v,start,end));
});
cljs.core.pv_reduce = (function cljs$core$pv_reduce(var_args){
var G__6868 = arguments.length;
switch (G__6868) {
case 4:
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4 = (function (pv,f,start,end){
if((start < end)){
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5(pv,f,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(pv,start),(start + (1)),end);
} else {
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
}
}));

(cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5 = (function (pv,f,init,start,end){
var acc = init;
var i = start;
var arr = cljs.core.unchecked_array_for(pv,start);
while(true){
if((i < end)){
var j = (i & (31));
var arr__$1 = (((j === (0)))?cljs.core.unchecked_array_for(pv,i):arr);
var nacc = (function (){var G__6869 = acc;
var G__6870 = (arr__$1[j]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6869,G__6870) : f.call(null,G__6869,G__6870));
})();
if(cljs.core.reduced_QMARK_(nacc)){
return cljs.core.deref(nacc);
} else {
var G__9119 = nacc;
var G__9120 = (i + (1));
var G__9121 = arr__$1;
acc = G__9119;
i = G__9120;
arr = G__9121;
continue;
}
} else {
return acc;
}
break;
}
}));

(cljs.core.pv_reduce.cljs$lang$maxFixedArity = 5);







/**
 * Marker protocol
 * @interface
 */
cljs.core.APersistentVector = function(){};


/**
* @constructor
 * @implements {cljs.core.IDrop}
 * @implements {cljs.core.APersistentVector}
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentVector = (function (meta,cnt,shift,root,tail,__hash){
this.meta = meta;
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167666463;
this.cljs$lang$protocol_mask$partition1$ = 401412;
});
(cljs.core.PersistentVector.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.cljs$core$IFind$_find$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if(((((0) <= n)) && ((n < self__.cnt)))){
return (new cljs.core.MapEntry(n,(cljs.core.unchecked_array_for(coll__$1,n)[(n & (31))]),null));
} else {
return null;
}
}));

(cljs.core.PersistentVector.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentVector.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentVector.prototype.indexOf = (function() {
var G__9124 = null;
var G__9124__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__9124__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__9124 = function(x,start){
switch(arguments.length){
case 1:
return G__9124__1.call(this,x);
case 2:
return G__9124__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9124.cljs$core$IFn$_invoke$arity$1 = G__9124__1;
G__9124.cljs$core$IFn$_invoke$arity$2 = G__9124__2;
return G__9124;
})()
);

(cljs.core.PersistentVector.prototype.lastIndexOf = (function() {
var G__9125 = null;
var G__9125__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__9125__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__9125 = function(x,start){
switch(arguments.length){
case 1:
return G__9125__1.call(this,x);
case 2:
return G__9125__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9125.cljs$core$IFn$_invoke$arity$1 = G__9125__1;
G__9125.cljs$core$IFn$_invoke$arity$2 = G__9125__2;
return G__9125;
})()
);

(cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return coll__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
} else {
return not_found;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__6872 = init__$2;
var G__6873 = (j + i);
var G__6874 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__6872,G__6873,G__6874) : f.call(null,G__6872,G__6873,G__6874));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__9131 = (j + (1));
var G__9132 = init__$3;
j = G__9131;
init__$2 = G__9132;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__9133 = (i + len);
var G__9134 = init__$2;
i = G__9133;
init__$1 = G__9134;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$APersistentVector$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
}));

(cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if(((((0) <= n)) && ((n < self__.cnt)))){
return (cljs.core.unchecked_array_for(coll__$1,n)[(n & (31))]);
} else {
return not_found;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (coll,n,val){
var self__ = this;
var coll__$1 = this;
if(((((0) <= n)) && ((n < self__.cnt)))){
if((cljs.core.tail_off(coll__$1) <= n)){
var new_tail = cljs.core.aclone(self__.tail);
(new_tail[(n & (31))] = val);

return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,cljs.core.do_assoc(coll__$1,self__.shift,self__.root,n,val),self__.tail,null));
}
} else {
if((n === self__.cnt)){
return coll__$1.cljs$core$ICollection$_conj$arity$2(null,val);
} else {
throw (new Error(["Index ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)," out of bounds  [0,",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.cnt),"]"].join('')));

}
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.ranged_iterator(this$__$1,(0),self__.cnt);
}));

(cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentVector.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
}));

(cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
}));

(cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return coll__$1.cljs$core$IIndexed$_nth$arity$2(null,(self__.cnt - (1)));
} else {
return null;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
} else {
if(((1) < (self__.cnt - cljs.core.tail_off(coll__$1)))){
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt - (1)),self__.shift,self__.root,self__.tail.slice((0),(-1)),null));
} else {
var new_tail = cljs.core.unchecked_array_for(coll__$1,(self__.cnt - (2)));
var nr = cljs.core.pop_tail(coll__$1,self__.shift,self__.root);
var new_root = (((nr == null))?cljs.core.PersistentVector.EMPTY_NODE:nr);
var cnt_1 = (self__.cnt - (1));
if(((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null)))){
return (new cljs.core.PersistentVector(self__.meta,cnt_1,(self__.shift - (5)),cljs.core.pv_aget(new_root,(0)),new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,cnt_1,self__.shift,new_root,new_tail,null));
}

}
}
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return (new cljs.core.RSeq(coll__$1,(self__.cnt - (1)),null));
} else {
return null;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if((other instanceof cljs.core.PersistentVector)){
if((self__.cnt === cljs.core.count(other))){
var me_iter = coll__$1.cljs$core$IIterable$_iterator$arity$1(null);
var you_iter = other.cljs$core$IIterable$_iterator$arity$1(null);
while(true){
if(me_iter.hasNext()){
var x = me_iter.next();
var y = you_iter.next();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return cljs.core.equiv_sequential(coll__$1,other);
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientVector(self__.cnt,self__.shift,(cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1(self__.root) : cljs.core.tv_editable_root.call(null,self__.root)),(cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1(self__.tail) : cljs.core.tv_editable_tail.call(null,self__.tail))));
}));

(cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
}));

(cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (v,f){
var self__ = this;
var v__$1 = this;
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4(v__$1,f,(0),self__.cnt);
}));

(cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__6875 = init__$2;
var G__6876 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6875,G__6876) : f.call(null,G__6875,G__6876));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__9149 = (j + (1));
var G__9150 = init__$3;
j = G__9149;
init__$2 = G__9150;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__9154 = (i + len);
var G__9155 = init__$2;
i = G__9154;
init__$1 = G__9155;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return coll__$1.cljs$core$IVector$_assoc_n$arity$3(null,k,v);
} else {
throw (new Error("Vector's key for assoc must be a number."));
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if(cljs.core.integer_QMARK_(k)){
return ((((0) <= k)) && ((k < self__.cnt)));
} else {
return false;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
return null;
} else {
if((self__.cnt <= (32))){
return (new cljs.core.IndexedSeq(self__.tail,(0),null));
} else {
var G__6877 = coll__$1;
var G__6878 = cljs.core.first_array_for_longvec(coll__$1);
var G__6879 = (0);
var G__6880 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__6877,G__6878,G__6879,G__6880) : cljs.core.chunked_seq.call(null,G__6877,G__6878,G__6879,G__6880));

}
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentVector(new_meta,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
if(((self__.cnt - cljs.core.tail_off(coll__$1)) < (32))){
var len = self__.tail.length;
var new_tail = (new Array((len + (1))));
var n__5593__auto___9157 = len;
var i_9158 = (0);
while(true){
if((i_9158 < n__5593__auto___9157)){
(new_tail[i_9158] = (self__.tail[i_9158]));

var G__9160 = (i_9158 + (1));
i_9158 = G__9160;
continue;
} else {
}
break;
}

(new_tail[len] = o);

return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),self__.shift,self__.root,new_tail,null));
} else {
var root_overflow_QMARK_ = ((self__.cnt >>> (5)) > ((1) << self__.shift));
var new_shift = ((root_overflow_QMARK_)?(self__.shift + (5)):self__.shift);
var new_root = ((root_overflow_QMARK_)?(function (){var n_r = cljs.core.pv_fresh_node(null);
cljs.core.pv_aset(n_r,(0),self__.root);

cljs.core.pv_aset(n_r,(1),cljs.core.new_path(null,self__.shift,(new cljs.core.VectorNode(null,self__.tail))));

return n_r;
})():cljs.core.push_tail(coll__$1,self__.shift,self__.root,(new cljs.core.VectorNode(null,self__.tail))));
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),new_shift,new_root,[o],null));
}
}));

(cljs.core.PersistentVector.prototype.call = (function (unused__10318__auto__){
var self__ = this;
var self__ = this;
var G__6881 = (arguments.length - (1));
switch (G__6881) {
case (1):
return self__.cljs$core$IFn$_invoke$arity$1((arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (1)))].join('')));

}
}));

(cljs.core.PersistentVector.prototype.apply = (function (self__,args6871){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args6871)));
}));

(cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
if(typeof k === 'number'){
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
} else {
throw (new Error("Key must be integer"));
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IDrop$_drop$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if((n < self__.cnt)){
var offset = (n % (32));
var G__6882 = coll__$1;
var G__6883 = cljs.core.unchecked_array_for(coll__$1,n);
var G__6884 = (n - offset);
var G__6885 = offset;
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__6882,G__6883,G__6884,G__6885) : cljs.core.chunked_seq.call(null,G__6882,G__6883,G__6884,G__6885));
} else {
return null;
}
}));

(cljs.core.PersistentVector.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.Symbol(null,"shift","shift",-1657295705,null),new cljs.core.Symbol(null,"root","root",1191874074,null),new cljs.core.Symbol(null,"tail","tail",494507963,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentVector.cljs$lang$type = true);

(cljs.core.PersistentVector.cljs$lang$ctorStr = "cljs.core/PersistentVector");

(cljs.core.PersistentVector.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/PersistentVector");
}));

/**
 * Positional factory function for cljs.core/PersistentVector.
 */
cljs.core.__GT_PersistentVector = (function cljs$core$__GT_PersistentVector(meta,cnt,shift,root,tail,__hash){
return (new cljs.core.PersistentVector(meta,cnt,shift,root,tail,__hash));
});

(cljs.core.PersistentVector.EMPTY_NODE = (new cljs.core.VectorNode(null,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null])));
(cljs.core.PersistentVector.EMPTY = (new cljs.core.PersistentVector(null,(0),(5),cljs.core.PersistentVector.EMPTY_NODE,[],cljs.core.empty_ordered_hash)));
(cljs.core.PersistentVector.fromArray = (function (xs,no_clone){
var l = xs.length;
var xs__$1 = ((no_clone)?xs:cljs.core.aclone(xs));
if((l < (32))){
return (new cljs.core.PersistentVector(null,l,(5),cljs.core.PersistentVector.EMPTY_NODE,xs__$1,null));
} else {
var node = xs__$1.slice((0),(32));
var v = (new cljs.core.PersistentVector(null,(32),(5),cljs.core.PersistentVector.EMPTY_NODE,node,null));
var i = (32);
var out = v.cljs$core$IEditableCollection$_as_transient$arity$1(null);
while(true){
if((i < l)){
var G__9180 = (i + (1));
var G__9181 = cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(out,(xs__$1[i]));
i = G__9180;
out = G__9181;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
}
}));
(cljs.core.PersistentVector.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));
/**
 * Creates a new vector containing the contents of coll. JavaScript arrays
 *   will be aliased and should not be modified.
 */
cljs.core.vec = (function cljs$core$vec(coll){
if(cljs.core.truth_((cljs.core.map_entry_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.core.map_entry_QMARK_.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.map_entry_QMARK_.call(null,coll)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.key.call(null,coll)),(cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.val.call(null,coll))], null);
} else {
if(cljs.core.vector_QMARK_(coll)){
return cljs.core.with_meta(coll,null);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.PersistentVector.fromArray(coll,true);
} else {
return cljs.core._persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core._as_transient(cljs.core.PersistentVector.EMPTY),coll));

}
}
}
});
/**
 * Creates a new vector containing the args.
 */
cljs.core.vector = (function cljs$core$vector(var_args){
var args__5732__auto__ = [];
var len__5726__auto___9185 = arguments.length;
var i__5727__auto___9186 = (0);
while(true){
if((i__5727__auto___9186 < len__5726__auto___9185)){
args__5732__auto__.push((arguments[i__5727__auto___9186]));

var G__9187 = (i__5727__auto___9186 + (1));
i__5727__auto___9186 = G__9187;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((0) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((0)),(0),null)):null);
return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(argseq__5733__auto__);
});

(cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic = (function (args){
if((((args instanceof cljs.core.IndexedSeq)) && ((args.i === (0))))){
return cljs.core.PersistentVector.fromArray(args.arr,(!(cljs.core.array_QMARK_(args.arr))));
} else {
return cljs.core.vec(args);
}
}));

(cljs.core.vector.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(cljs.core.vector.cljs$lang$applyTo = (function (seq6886){
var self__5712__auto__ = this;
return self__5712__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq6886));
}));


/**
* @constructor
 * @implements {cljs.core.IDrop}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IChunkedNext}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IChunkedSeq}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ChunkedSeq = (function (vec,node,i,off,meta,__hash){
this.vec = vec;
this.node = node;
this.i = i;
this.off = off;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32375020;
this.cljs$lang$protocol_mask$partition1$ = 263680;
});
(cljs.core.ChunkedSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.ChunkedSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.ChunkedSeq.prototype.indexOf = (function() {
var G__9191 = null;
var G__9191__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__9191__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__9191 = function(x,start){
switch(arguments.length){
case 1:
return G__9191__1.call(this,x);
case 2:
return G__9191__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9191.cljs$core$IFn$_invoke$arity$1 = G__9191__1;
G__9191.cljs$core$IFn$_invoke$arity$2 = G__9191__2;
return G__9191;
})()
);

(cljs.core.ChunkedSeq.prototype.lastIndexOf = (function() {
var G__9192 = null;
var G__9192__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__9192__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__9192 = function(x,start){
switch(arguments.length){
case 1:
return G__9192__1.call(this,x);
case 2:
return G__9192__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9192.cljs$core$IFn$_invoke$arity$1 = G__9192__1;
G__9192.cljs$core$IFn$_invoke$arity$2 = G__9192__2;
return G__9192;
})()
);

(cljs.core.ChunkedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = (function (){var G__6887 = self__.vec;
var G__6888 = self__.node;
var G__6889 = self__.i;
var G__6890 = (self__.off + (1));
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__6887,G__6888,G__6889,G__6890) : cljs.core.chunked_seq.call(null,G__6887,G__6888,G__6889,G__6890));
})();
if((s == null)){
return null;
} else {
return s;
}
} else {
return coll__$1.cljs$core$IChunkedNext$_chunked_next$arity$1(null);
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4(self__.vec,f,(self__.i + self__.off),cljs.core.count(self__.vec));
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5(self__.vec,f,start,(self__.i + self__.off),cljs.core.count(self__.vec));
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.node[self__.off]);
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = (function (){var G__6891 = self__.vec;
var G__6892 = self__.node;
var G__6893 = self__.i;
var G__6894 = (self__.off + (1));
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__6891,G__6892,G__6893,G__6894) : cljs.core.chunked_seq.call(null,G__6891,G__6892,G__6893,G__6894));
})();
if((s == null)){
return cljs.core.List.EMPTY;
} else {
return s;
}
} else {
return coll__$1.cljs$core$IChunkedSeq$_chunked_rest$arity$1(null);
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2(self__.node,self__.off);
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
var G__6895 = self__.vec;
var G__6896 = cljs.core.unchecked_array_for(self__.vec,end);
var G__6897 = end;
var G__6898 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__6895,G__6896,G__6897,G__6898) : cljs.core.chunked_seq.call(null,G__6895,G__6896,G__6897,G__6898));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5(self__.vec,self__.node,self__.i,self__.off,new_meta) : cljs.core.chunked_seq.call(null,self__.vec,self__.node,self__.i,self__.off,new_meta));
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IDrop$_drop$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
var o = (self__.off + n);
if((o < self__.node.length)){
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec,self__.node,self__.i,o) : cljs.core.chunked_seq.call(null,self__.vec,self__.node,self__.i,o));
} else {
var i__$1 = (self__.i + o);
if((i__$1 < cljs.core._count(self__.vec))){
var new_offset = (i__$1 % (32));
var G__6899 = self__.vec;
var G__6900 = cljs.core.unchecked_array_for(self__.vec,i__$1);
var G__6901 = (i__$1 - new_offset);
var G__6902 = new_offset;
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__6899,G__6900,G__6901,G__6902) : cljs.core.chunked_seq.call(null,G__6899,G__6900,G__6901,G__6902));
} else {
return null;
}
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
var G__6903 = self__.vec;
var G__6904 = cljs.core.unchecked_array_for(self__.vec,end);
var G__6905 = end;
var G__6906 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__6903,G__6904,G__6905,G__6906) : cljs.core.chunked_seq.call(null,G__6903,G__6904,G__6905,G__6906));
} else {
return null;
}
}));

(cljs.core.ChunkedSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"vec","vec",982683596,null),new cljs.core.Symbol(null,"node","node",-2073234571,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"off","off",-2047994980,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ChunkedSeq.cljs$lang$type = true);

(cljs.core.ChunkedSeq.cljs$lang$ctorStr = "cljs.core/ChunkedSeq");

(cljs.core.ChunkedSeq.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/ChunkedSeq");
}));

/**
 * Positional factory function for cljs.core/ChunkedSeq.
 */
cljs.core.__GT_ChunkedSeq = (function cljs$core$__GT_ChunkedSeq(vec,node,i,off,meta,__hash){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,__hash));
});

(cljs.core.ChunkedSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));
cljs.core.chunked_seq = (function cljs$core$chunked_seq(var_args){
var G__6908 = arguments.length;
switch (G__6908) {
case 3:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3 = (function (vec,i,off){
return (new cljs.core.ChunkedSeq(vec,cljs.core.array_for(vec,i),i,off,null,null));
}));

(cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 = (function (vec,node,i,off){
return (new cljs.core.ChunkedSeq(vec,node,i,off,null,null));
}));

(cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 = (function (vec,node,i,off,meta){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,null));
}));

(cljs.core.chunked_seq.cljs$lang$maxFixedArity = 5);


/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Subvec = (function (meta,v,start,end,__hash){
this.meta = meta;
this.v = v;
this.start = start;
this.end = end;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167666463;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(cljs.core.Subvec.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Subvec.prototype.cljs$core$IFind$_find$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if((n < (0))){
return null;
} else {
var idx = (self__.start + n);
if((idx < self__.end)){
return (new cljs.core.MapEntry(n,cljs.core._lookup(self__.v,idx),null));
} else {
return null;
}
}
}));

(cljs.core.Subvec.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.Subvec.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.Subvec.prototype.indexOf = (function() {
var G__9216 = null;
var G__9216__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__9216__2 = (function (x,start__$1){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start__$1);
});
G__9216 = function(x,start__$1){
switch(arguments.length){
case 1:
return G__9216__1.call(this,x);
case 2:
return G__9216__2.call(this,x,start__$1);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9216.cljs$core$IFn$_invoke$arity$1 = G__9216__1;
G__9216.cljs$core$IFn$_invoke$arity$2 = G__9216__2;
return G__9216;
})()
);

(cljs.core.Subvec.prototype.lastIndexOf = (function() {
var G__9223 = null;
var G__9223__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__9223__2 = (function (x,start__$1){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start__$1);
});
G__9223 = function(x,start__$1){
switch(arguments.length){
case 1:
return G__9223__1.call(this,x);
case 2:
return G__9223__2.call(this,x,start__$1);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9223.cljs$core$IFn$_invoke$arity$1 = G__9223__1;
G__9223.cljs$core$IFn$_invoke$arity$2 = G__9223__2;
return G__9223;
})()
);

(cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return coll__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
} else {
return not_found;
}
}));

(cljs.core.Subvec.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var i = self__.start;
var j = (0);
var init__$1 = init;
while(true){
if((i < self__.end)){
var init__$2 = (function (){var G__6910 = init__$1;
var G__6911 = j;
var G__6912 = cljs.core._nth(self__.v,i);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__6910,G__6911,G__6912) : f.call(null,G__6910,G__6911,G__6912));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__9227 = (i + (1));
var G__9228 = (j + (1));
var G__9229 = init__$2;
i = G__9227;
j = G__9228;
init__$1 = G__9229;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if((((n < (0))) || ((self__.end <= (self__.start + n))))){
return cljs.core.vector_index_out_of_bounds(n,(self__.end - self__.start));
} else {
return cljs.core._nth(self__.v,(self__.start + n));
}
}));

(cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if((((n < (0))) || ((self__.end <= (self__.start + n))))){
return not_found;
} else {
return cljs.core._nth(self__.v,(self__.start + n),not_found);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (coll,n,val){
var self__ = this;
var coll__$1 = this;
var v_pos = (self__.start + n);
if((((n < (0))) || (((self__.end + (1)) <= v_pos)))){
throw (new Error(["Index ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)," out of bounds [0,",cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll__$1.cljs$core$ICounted$_count$arity$1(null)),"]"].join('')));
} else {
var G__6913 = self__.meta;
var G__6914 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.v,v_pos,val);
var G__6915 = self__.start;
var G__6916 = (function (){var x__5087__auto__ = self__.end;
var y__5088__auto__ = (v_pos + (1));
return ((x__5087__auto__ > y__5088__auto__) ? x__5087__auto__ : y__5088__auto__);
})();
var G__6917 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__6913,G__6914,G__6915,G__6916,G__6917) : cljs.core.build_subvec.call(null,G__6913,G__6914,G__6915,G__6916,G__6917));
}
}));

(cljs.core.Subvec.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((((!((self__.v == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === self__.v.cljs$core$APersistentVector$))))?true:false):false)){
return cljs.core.ranged_iterator(self__.v,self__.start,self__.end);
} else {
return cljs.core.seq_iter(coll__$1);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Subvec.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Subvec(self__.meta,self__.v,self__.start,self__.end,self__.__hash));
}));

(cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.end - self__.start);
}));

(cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.start === self__.end)){
return null;
} else {
return cljs.core._nth(self__.v,(self__.end - (1)));
}
}));

(cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.start === self__.end)){
throw (new Error("Can't pop empty vector"));
} else {
var G__6919 = self__.meta;
var G__6920 = self__.v;
var G__6921 = self__.start;
var G__6922 = (self__.end - (1));
var G__6923 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__6919,G__6920,G__6921,G__6922,G__6923) : cljs.core.build_subvec.call(null,G__6919,G__6920,G__6921,G__6922,G__6923));
}
}));

(cljs.core.Subvec.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((!((self__.start === self__.end)))){
return (new cljs.core.RSeq(coll__$1,((self__.end - self__.start) - (1)),null));
} else {
return null;
}
}));

(cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
}));

(cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
if((((!((self__.v == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === self__.v.cljs$core$APersistentVector$))))?true:false):false)){
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4(self__.v,f,self__.start,self__.end);
} else {
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(coll__$1,f);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
if((((!((self__.v == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === self__.v.cljs$core$APersistentVector$))))?true:false):false)){
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5(self__.v,f,init,self__.start,self__.end);
} else {
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(coll__$1,f,init);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,key,val){
var self__ = this;
var coll__$1 = this;
if(typeof key === 'number'){
return coll__$1.cljs$core$IVector$_assoc_n$arity$3(null,key,val);
} else {
throw (new Error("Subvec's key for assoc must be a number."));
}
}));

(cljs.core.Subvec.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,key){
var self__ = this;
var coll__$1 = this;
if(cljs.core.integer_QMARK_(key)){
return ((((0) <= key)) && ((key < (self__.end - self__.start))));
} else {
return false;
}
}));

(cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var subvec_seq = (function cljs$core$subvec_seq(i){
if((i === self__.end)){
return null;
} else {
return cljs.core.cons(cljs.core._nth(self__.v,i),(new cljs.core.LazySeq(null,(function (){
return cljs$core$subvec_seq((i + (1)));
}),null,null)));
}
});
return subvec_seq(self__.start);
}));

(cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(new_meta,self__.v,self__.start,self__.end,self__.__hash) : cljs.core.build_subvec.call(null,new_meta,self__.v,self__.start,self__.end,self__.__hash));
}
}));

(cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
var G__6926 = self__.meta;
var G__6927 = cljs.core._assoc_n(self__.v,self__.end,o);
var G__6928 = self__.start;
var G__6929 = (self__.end + (1));
var G__6930 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__6926,G__6927,G__6928,G__6929,G__6930) : cljs.core.build_subvec.call(null,G__6926,G__6927,G__6928,G__6929,G__6930));
}));

(cljs.core.Subvec.prototype.call = (function (unused__10318__auto__){
var self__ = this;
var self__ = this;
var G__6931 = (arguments.length - (1));
switch (G__6931) {
case (1):
return self__.cljs$core$IFn$_invoke$arity$1((arguments[(1)]));

break;
case (2):
return self__.cljs$core$IFn$_invoke$arity$2((arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (1)))].join('')));

}
}));

(cljs.core.Subvec.prototype.apply = (function (self__,args6909){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args6909)));
}));

(cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
}));

(cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.Subvec.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Subvec.cljs$lang$type = true);

(cljs.core.Subvec.cljs$lang$ctorStr = "cljs.core/Subvec");

(cljs.core.Subvec.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/Subvec");
}));

/**
 * Positional factory function for cljs.core/Subvec.
 */
cljs.core.__GT_Subvec = (function cljs$core$__GT_Subvec(meta,v,start,end,__hash){
return (new cljs.core.Subvec(meta,v,start,end,__hash));
});

(cljs.core.Subvec.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));
cljs.core.build_subvec = (function cljs$core$build_subvec(meta,v,start,end,__hash){
while(true){
if((v instanceof cljs.core.Subvec)){
var G__9250 = meta;
var G__9251 = v.v;
var G__9252 = (v.start + start);
var G__9253 = (v.start + end);
var G__9254 = __hash;
meta = G__9250;
v = G__9251;
start = G__9252;
end = G__9253;
__hash = G__9254;
continue;
} else {
if(cljs.core.vector_QMARK_(v)){
} else {
throw (new Error("v must satisfy IVector"));
}

if((((start < (0))) || ((((end < start)) || ((end > cljs.core.count(v))))))){
throw (new Error("Index out of bounds"));
} else {
}

return (new cljs.core.Subvec(meta,v,start,end,__hash));
}
break;
}
});
/**
 * Returns a persistent vector of the items in vector from
 *   start (inclusive) to end (exclusive).  If end is not supplied,
 *   defaults to (count vector). This operation is O(1) and very fast, as
 *   the resulting vector shares structure with the original and no
 *   trimming is done.
 */
cljs.core.subvec = (function cljs$core$subvec(var_args){
var G__6933 = arguments.length;
switch (G__6933) {
case 2:
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.subvec.cljs$core$IFn$_invoke$arity$2 = (function (v,start){
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(v,start,cljs.core.count(v));
}));

(cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 = (function (v,start,end){
if((((!((start == null)))) && ((!((end == null)))))){
} else {
throw (new Error("Assert failed: (and (not (nil? start)) (not (nil? end)))"));
}

return cljs.core.build_subvec(null,v,(start | (0)),(end | (0)),null);
}));

(cljs.core.subvec.cljs$lang$maxFixedArity = 3);

cljs.core.tv_ensure_editable = (function cljs$core$tv_ensure_editable(edit,node){
if((edit === node.edit)){
return node;
} else {
return (new cljs.core.VectorNode(edit,cljs.core.aclone(node.arr)));
}
});
cljs.core.tv_editable_root = (function cljs$core$tv_editable_root(node){
return (new cljs.core.VectorNode(({}),cljs.core.aclone(node.arr)));
});
cljs.core.tv_editable_tail = (function cljs$core$tv_editable_tail(tl){
var ret = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
cljs.core.array_copy(tl,(0),ret,(0),tl.length);

return ret;
});
cljs.core.tv_push_tail = (function cljs$core$tv_push_tail(tv,level,parent,tail_node){
var ret = cljs.core.tv_ensure_editable(tv.root.edit,parent);
var subidx = (((tv.cnt - (1)) >>> level) & (31));
cljs.core.pv_aset(ret,subidx,(((level === (5)))?tail_node:(function (){var child = cljs.core.pv_aget(ret,subidx);
if((!((child == null)))){
var G__6936 = tv;
var G__6937 = (level - (5));
var G__6938 = child;
var G__6939 = tail_node;
return (cljs.core.tv_push_tail.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tv_push_tail.cljs$core$IFn$_invoke$arity$4(G__6936,G__6937,G__6938,G__6939) : cljs.core.tv_push_tail.call(null,G__6936,G__6937,G__6938,G__6939));
} else {
return cljs.core.new_path(tv.root.edit,(level - (5)),tail_node);
}
})()));

return ret;
});
cljs.core.tv_pop_tail = (function cljs$core$tv_pop_tail(tv,level,node){
var node__$1 = cljs.core.tv_ensure_editable(tv.root.edit,node);
var subidx = (((tv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = (function (){var G__6940 = tv;
var G__6941 = (level - (5));
var G__6942 = cljs.core.pv_aget(node__$1,subidx);
return (cljs.core.tv_pop_tail.cljs$core$IFn$_invoke$arity$3 ? cljs.core.tv_pop_tail.cljs$core$IFn$_invoke$arity$3(G__6940,G__6941,G__6942) : cljs.core.tv_pop_tail.call(null,G__6940,G__6941,G__6942));
})();
if((((new_child == null)) && ((subidx === (0))))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,new_child);

return node__$1;
}
} else {
if((subidx === (0))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,null);

return node__$1;

}
}
});
cljs.core.unchecked_editable_array_for = (function cljs$core$unchecked_editable_array_for(tv,i){
if((i >= cljs.core.tail_off(tv))){
return tv.tail;
} else {
var root = tv.root;
var node = root;
var level = tv.shift;
while(true){
if((level > (0))){
var G__9261 = cljs.core.tv_ensure_editable(root.edit,cljs.core.pv_aget(node,((i >>> level) & (31))));
var G__9262 = (level - (5));
node = G__9261;
level = G__9262;
continue;
} else {
return node.arr;
}
break;
}
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientVector}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientVector = (function (cnt,shift,root,tail){
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.cljs$lang$protocol_mask$partition1$ = 88;
this.cljs$lang$protocol_mask$partition0$ = 275;
});
(cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if(((self__.cnt - cljs.core.tail_off(tcoll__$1)) < (32))){
(self__.tail[(self__.cnt & (31))] = o);

(self__.cnt = (self__.cnt + (1)));

return tcoll__$1;
} else {
var tail_node = (new cljs.core.VectorNode(self__.root.edit,self__.tail));
var new_tail = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(new_tail[(0)] = o);

(self__.tail = new_tail);

if(((self__.cnt >>> (5)) > ((1) << self__.shift))){
var new_root_array = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var new_shift = (self__.shift + (5));
(new_root_array[(0)] = self__.root);

(new_root_array[(1)] = cljs.core.new_path(self__.root.edit,self__.shift,tail_node));

(self__.root = (new cljs.core.VectorNode(self__.root.edit,new_root_array)));

(self__.shift = new_shift);

(self__.cnt = (self__.cnt + (1)));

return tcoll__$1;
} else {
var new_root = cljs.core.tv_push_tail(tcoll__$1,self__.shift,self__.root,tail_node);
(self__.root = new_root);

(self__.cnt = (self__.cnt + (1)));

return tcoll__$1;
}
}
} else {
throw (new Error("conj! after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
(self__.root.edit = null);

var len = (self__.cnt - cljs.core.tail_off(tcoll__$1));
var trimmed_tail = (new Array(len));
cljs.core.array_copy(self__.tail,(0),trimmed_tail,(0),len);

return (new cljs.core.PersistentVector(null,self__.cnt,self__.shift,self__.root,trimmed_tail,null));
} else {
throw (new Error("persistent! called twice"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(typeof key === 'number'){
return tcoll__$1.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(null,key,val);
} else {
throw (new Error("TransientVector's key for assoc! must be a number."));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = (function (tcoll,n,val){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if(((((0) <= n)) && ((n < self__.cnt)))){
if((cljs.core.tail_off(tcoll__$1) <= n)){
(self__.tail[(n & (31))] = val);

return tcoll__$1;
} else {
var new_root = (function cljs$core$go(level,node){
var node__$1 = cljs.core.tv_ensure_editable(self__.root.edit,node);
if((level === (0))){
cljs.core.pv_aset(node__$1,(n & (31)),val);

return node__$1;
} else {
var subidx = ((n >>> level) & (31));
cljs.core.pv_aset(node__$1,subidx,cljs$core$go((level - (5)),cljs.core.pv_aget(node__$1,subidx)));

return node__$1;
}
})(self__.shift,self__.root);
(self__.root = new_root);

return tcoll__$1;
}
} else {
if((n === self__.cnt)){
return tcoll__$1.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null,val);
} else {
throw (new Error(["Index ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)," out of bounds for TransientVector of length",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.cnt)].join('')));

}
}
} else {
throw (new Error("assoc! after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
(self__.cnt = (0));

return tcoll__$1;
} else {
if((((self__.cnt - (1)) & (31)) > (0))){
(self__.cnt = (self__.cnt - (1)));

return tcoll__$1;
} else {
var new_tail = cljs.core.unchecked_editable_array_for(tcoll__$1,(self__.cnt - (2)));
var new_root = (function (){var nr = cljs.core.tv_pop_tail(tcoll__$1,self__.shift,self__.root);
if((!((nr == null)))){
return nr;
} else {
return (new cljs.core.VectorNode(self__.root.edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
}
})();
if(((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null)))){
var new_root__$1 = cljs.core.tv_ensure_editable(self__.root.edit,cljs.core.pv_aget(new_root,(0)));
(self__.root = new_root__$1);

(self__.shift = (self__.shift - (5)));

(self__.cnt = (self__.cnt - (1)));

(self__.tail = new_tail);

return tcoll__$1;
} else {
(self__.root = new_root);

(self__.cnt = (self__.cnt - (1)));

(self__.tail = new_tail);

return tcoll__$1;
}

}
}
}
} else {
throw (new Error("pop! after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return self__.cnt;
} else {
throw (new Error("count after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
} else {
throw (new Error("nth after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if(((((0) <= n)) && ((n < self__.cnt)))){
return coll__$1.cljs$core$IIndexed$_nth$arity$2(null,n);
} else {
return not_found;
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if((!(self__.root.edit))){
throw (new Error("lookup after persistent!"));
} else {
if(typeof k === 'number'){
return coll__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
} else {
return not_found;

}
}
}));

(cljs.core.TransientVector.prototype.call = (function (unused__10318__auto__){
var self__ = this;
var self__ = this;
var G__6944 = (arguments.length - (1));
switch (G__6944) {
case (1):
return self__.cljs$core$IFn$_invoke$arity$1((arguments[(1)]));

break;
case (2):
return self__.cljs$core$IFn$_invoke$arity$2((arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (1)))].join('')));

}
}));

(cljs.core.TransientVector.prototype.apply = (function (self__,args6943){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args6943)));
}));

(cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
}));

(cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.TransientVector.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"shift","shift",-1657295705,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"root","root",1191874074,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"tail","tail",494507963,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.TransientVector.cljs$lang$type = true);

(cljs.core.TransientVector.cljs$lang$ctorStr = "cljs.core/TransientVector");

(cljs.core.TransientVector.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/TransientVector");
}));

/**
 * Positional factory function for cljs.core/TransientVector.
 */
cljs.core.__GT_TransientVector = (function cljs$core$__GT_TransientVector(cnt,shift,root,tail){
return (new cljs.core.TransientVector(cnt,shift,root,tail));
});


/**
* @constructor
*/
cljs.core.PersistentQueueIter = (function (fseq,riter){
this.fseq = fseq;
this.riter = riter;
});
(cljs.core.PersistentQueueIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
var or__5002__auto__ = (((!((self__.fseq == null)))) && (cljs.core.seq(self__.fseq)));
if(or__5002__auto__){
return or__5002__auto__;
} else {
var and__5000__auto__ = (!((self__.riter == null)));
if(and__5000__auto__){
return self__.riter.hasNext();
} else {
return and__5000__auto__;
}
}
}));

(cljs.core.PersistentQueueIter.prototype.next = (function (){
var self__ = this;
var _ = this;
if((!((self__.fseq == null)))){
var ret = cljs.core.first(self__.fseq);
(self__.fseq = cljs.core.next(self__.fseq));

return ret;
} else {
if((((!((self__.riter == null)))) && (self__.riter.hasNext()))){
return self__.riter.next();
} else {
throw (new Error("No such element"));

}
}
}));

(cljs.core.PersistentQueueIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.PersistentQueueIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"fseq","fseq",-1466412450,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"riter","riter",-237834262,null)], null);
}));

(cljs.core.PersistentQueueIter.cljs$lang$type = true);

(cljs.core.PersistentQueueIter.cljs$lang$ctorStr = "cljs.core/PersistentQueueIter");

(cljs.core.PersistentQueueIter.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/PersistentQueueIter");
}));

/**
 * Positional factory function for cljs.core/PersistentQueueIter.
 */
cljs.core.__GT_PersistentQueueIter = (function cljs$core$__GT_PersistentQueueIter(fseq,riter){
return (new cljs.core.PersistentQueueIter(fseq,riter));
});


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.PersistentQueueSeq = (function (meta,front,rear,__hash){
this.meta = meta;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31850700;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.PersistentQueueSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentQueueSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentQueueSeq.prototype.indexOf = (function() {
var G__9289 = null;
var G__9289__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__9289__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__9289 = function(x,start){
switch(arguments.length){
case 1:
return G__9289__1.call(this,x);
case 2:
return G__9289__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9289.cljs$core$IFn$_invoke$arity$1 = G__9289__1;
G__9289.cljs$core$IFn$_invoke$arity$2 = G__9289__2;
return G__9289;
})()
);

(cljs.core.PersistentQueueSeq.prototype.lastIndexOf = (function() {
var G__9300 = null;
var G__9300__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__9300__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__9300 = function(x,start){
switch(arguments.length){
case 1:
return G__9300__1.call(this,x);
case 2:
return G__9300__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9300.cljs$core$IFn$_invoke$arity$1 = G__9300__1;
G__9300.cljs$core$IFn$_invoke$arity$2 = G__9300__2;
return G__9300;
})()
);

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var temp__5802__auto__ = cljs.core.next(self__.front);
if(temp__5802__auto__){
var f1 = temp__5802__auto__;
return (new cljs.core.PersistentQueueSeq(self__.meta,f1,self__.rear,null));
} else {
if((!((self__.rear == null)))){
return (new cljs.core.PersistentQueueSeq(self__.meta,self__.rear,null,null));
} else {
return null;
}
}
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var temp__5802__auto__ = cljs.core.next(self__.front);
if(temp__5802__auto__){
var f1 = temp__5802__auto__;
return (new cljs.core.PersistentQueueSeq(self__.meta,f1,self__.rear,null));
} else {
if((self__.rear == null)){
return coll__$1.cljs$core$IEmptyableCollection$_empty$arity$1(null);
} else {
return (new cljs.core.PersistentQueueSeq(self__.meta,self__.rear,null,null));
}
}
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentQueueSeq(new_meta,self__.front,self__.rear,self__.__hash));
}
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.PersistentQueueSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"front","front",117022539,null),new cljs.core.Symbol(null,"rear","rear",-900164830,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentQueueSeq.cljs$lang$type = true);

(cljs.core.PersistentQueueSeq.cljs$lang$ctorStr = "cljs.core/PersistentQueueSeq");

(cljs.core.PersistentQueueSeq.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/PersistentQueueSeq");
}));

/**
 * Positional factory function for cljs.core/PersistentQueueSeq.
 */
cljs.core.__GT_PersistentQueueSeq = (function cljs$core$__GT_PersistentQueueSeq(meta,front,rear,__hash){
return (new cljs.core.PersistentQueueSeq(meta,front,rear,__hash));
});

(cljs.core.PersistentQueueSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.PersistentQueue = (function (meta,count,front,rear,__hash){
this.meta = meta;
this.count = count;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 139264;
this.cljs$lang$protocol_mask$partition0$ = 31858766;
});
(cljs.core.PersistentQueue.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentQueue.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentQueue.prototype.indexOf = (function() {
var G__9307 = null;
var G__9307__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__9307__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__9307 = function(x,start){
switch(arguments.length){
case 1:
return G__9307__1.call(this,x);
case 2:
return G__9307__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9307.cljs$core$IFn$_invoke$arity$1 = G__9307__1;
G__9307.cljs$core$IFn$_invoke$arity$2 = G__9307__2;
return G__9307;
})()
);

(cljs.core.PersistentQueue.prototype.lastIndexOf = (function() {
var G__9308 = null;
var G__9308__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(self__.count.cljs$core$IFn$_invoke$arity$1 ? self__.count.cljs$core$IFn$_invoke$arity$1(coll) : self__.count.call(null,coll)));
});
var G__9308__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__9308 = function(x,start){
switch(arguments.length){
case 1:
return G__9308__1.call(this,x);
case 2:
return G__9308__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9308.cljs$core$IFn$_invoke$arity$1 = G__9308__1;
G__9308.cljs$core$IFn$_invoke$arity$2 = G__9308__2;
return G__9308;
})()
);

(cljs.core.PersistentQueue.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueueIter(self__.front,cljs.core._iterator(self__.rear)));
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueue(self__.meta,self__.count,self__.front,self__.rear,self__.__hash));
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
var temp__5802__auto__ = cljs.core.next(self__.front);
if(temp__5802__auto__){
var f1 = temp__5802__auto__;
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),f1,self__.rear,null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),cljs.core.seq(self__.rear),cljs.core.PersistentVector.EMPTY,null));
}
} else {
return coll__$1;
}
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentQueue.EMPTY,self__.meta);
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.rest(cljs.core.seq(coll__$1));
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var rear__$1 = cljs.core.seq(self__.rear);
if(cljs.core.truth_((function (){var or__5002__auto__ = self__.front;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return rear__$1;
}
})())){
return (new cljs.core.PersistentQueueSeq(null,self__.front,cljs.core.seq(rear__$1),null));
} else {
return null;
}
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentQueue(new_meta,self__.count,self__.front,self__.rear,self__.__hash));
}
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),self__.front,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__5002__auto__ = self__.rear;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),o),null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(self__.front,o),cljs.core.PersistentVector.EMPTY,null));
}
}));

(cljs.core.PersistentQueue.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"front","front",117022539,null),new cljs.core.Symbol(null,"rear","rear",-900164830,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentQueue.cljs$lang$type = true);

(cljs.core.PersistentQueue.cljs$lang$ctorStr = "cljs.core/PersistentQueue");

(cljs.core.PersistentQueue.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/PersistentQueue");
}));

/**
 * Positional factory function for cljs.core/PersistentQueue.
 */
cljs.core.__GT_PersistentQueue = (function cljs$core$__GT_PersistentQueue(meta,count,front,rear,__hash){
return (new cljs.core.PersistentQueue(meta,count,front,rear,__hash));
});

(cljs.core.PersistentQueue.EMPTY = (new cljs.core.PersistentQueue(null,(0),null,cljs.core.PersistentVector.EMPTY,cljs.core.empty_ordered_hash)));
(cljs.core.PersistentQueue.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IEquiv}
*/
cljs.core.NeverEquiv = (function (){
this.cljs$lang$protocol_mask$partition0$ = 2097152;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.NeverEquiv.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var self__ = this;
var o__$1 = this;
return false;
}));

(cljs.core.NeverEquiv.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
}));

(cljs.core.NeverEquiv.cljs$lang$type = true);

(cljs.core.NeverEquiv.cljs$lang$ctorStr = "cljs.core/NeverEquiv");

(cljs.core.NeverEquiv.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/NeverEquiv");
}));

/**
 * Positional factory function for cljs.core/NeverEquiv.
 */
cljs.core.__GT_NeverEquiv = (function cljs$core$__GT_NeverEquiv(){
return (new cljs.core.NeverEquiv());
});

cljs.core.never_equiv = (new cljs.core.NeverEquiv());
/**
 * Test map equivalence. Returns true if x equals y, otherwise returns false.
 */
cljs.core.equiv_map = (function cljs$core$equiv_map(x,y){
return cljs.core.boolean$(((((cljs.core.map_QMARK_(y)) && ((!(cljs.core.record_QMARK_(y))))))?(((cljs.core.count(x) === cljs.core.count(y)))?(((((!((x == null))))?(((((x.cljs$lang$protocol_mask$partition0$ & (1048576))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IKVReduce$))))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IKVReduce,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IKVReduce,x)))?cljs.core.reduce_kv((function (_,k,v){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(y,k,cljs.core.never_equiv),v)){
return true;
} else {
return cljs.core.reduced(false);
}
}),true,x):cljs.core.every_QMARK_((function (xkv){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(y,cljs.core.first(xkv),cljs.core.never_equiv),cljs.core.second(xkv));
}),x)):null):null));
});
cljs.core.scan_array = (function cljs$core$scan_array(incr,k,array){
var len = array.length;
var i = (0);
while(true){
if((i < len)){
if((k === (array[i]))){
return i;
} else {
var G__9376 = (i + incr);
i = G__9376;
continue;
}
} else {
return null;
}
break;
}
});
cljs.core.obj_map_compare_keys = (function cljs$core$obj_map_compare_keys(a,b){
var a__$1 = cljs.core.hash(a);
var b__$1 = cljs.core.hash(b);
if((a__$1 < b__$1)){
return (-1);
} else {
if((a__$1 > b__$1)){
return (1);
} else {
return (0);

}
}
});
cljs.core.obj_map__GT_hash_map = (function cljs$core$obj_map__GT_hash_map(m,k,v){
var ks = m.keys;
var len = ks.length;
var so = m.strobj;
var mm = cljs.core.meta(m);
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var k__$1 = (ks[i]);
var G__9377 = (i + (1));
var G__9378 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k__$1,cljs.core.goog$module$goog$object.get(so,k__$1));
i = G__9377;
out = G__9378;
continue;
} else {
return cljs.core._with_meta(cljs.core.persistent_BANG_(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k,v)),mm);
}
break;
}
});
cljs.core.obj_clone = (function cljs$core$obj_clone(obj,ks){
var new_obj = ({});
var l = ks.length;
var i_9379 = (0);
while(true){
if((i_9379 < l)){
var k_9380 = (ks[i_9379]);
cljs.core.goog$module$goog$object.set(new_obj,k_9380,cljs.core.goog$module$goog$object.get(obj,k_9380));

var G__9381 = (i_9379 + (1));
i_9379 = G__9381;
continue;
} else {
}
break;
}

return new_obj;
});

/**
* @constructor
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.core.ObjMap = (function (meta,keys,strobj,update_count,__hash){
this.meta = meta;
this.keys = keys;
this.strobj = strobj;
this.update_count = update_count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 4;
});
(cljs.core.ObjMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.ObjMap.prototype.cljs$core$IFind$_find$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if(((typeof k === 'string') && ((!((cljs.core.scan_array((1),k,self__.keys) == null)))))){
return (new cljs.core.MapEntry(k,(self__.strobj[k]),null));
} else {
return null;
}
}));

(cljs.core.ObjMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.ObjMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(((typeof k === 'string') && ((!((cljs.core.scan_array((1),k,self__.keys) == null)))))){
return (self__.strobj[k]);
} else {
return not_found;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.keys.length;
var keys__$1 = self__.keys.sort(cljs.core.obj_map_compare_keys);
var init__$1 = init;
while(true){
if(cljs.core.seq(keys__$1)){
var k = cljs.core.first(keys__$1);
var init__$2 = (function (){var G__6950 = init__$1;
var G__6951 = k;
var G__6952 = (self__.strobj[k]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__6950,G__6951,G__6952) : f.call(null,G__6950,G__6951,G__6952));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__9386 = cljs.core.rest(keys__$1);
var G__9387 = init__$2;
keys__$1 = G__9386;
init__$1 = G__9387;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.keys.length;
}));

(cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
}));

(cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.transient$(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1));
}));

(cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.ObjMap.EMPTY,self__.meta);
}));

(cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if(((typeof k === 'string') && ((!((cljs.core.scan_array((1),k,self__.keys) == null)))))){
var new_keys = cljs.core.aclone(self__.keys);
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
new_keys.splice(cljs.core.scan_array((1),k,new_keys),(1));

delete new_strobj[k];

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
} else {
return coll__$1;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'string'){
if((((self__.update_count > cljs.core.ObjMap.HASHMAP_THRESHOLD)) || ((self__.keys.length >= cljs.core.ObjMap.HASHMAP_THRESHOLD)))){
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
} else {
if((!((cljs.core.scan_array((1),k,self__.keys) == null)))){
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
cljs.core.goog$module$goog$object.set(new_strobj,k,v);

return (new cljs.core.ObjMap(self__.meta,self__.keys,new_strobj,(self__.update_count + (1)),null));
} else {
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
var new_keys = cljs.core.aclone(self__.keys);
cljs.core.goog$module$goog$object.set(new_strobj,k,v);

new_keys.push(k);

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
}
}
} else {
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if(((typeof k === 'string') && ((!((cljs.core.scan_array((1),k,self__.keys) == null)))))){
return true;
} else {
return false;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.keys.length > (0))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__6948_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[p1__6948_SHARP_,(self__.strobj[p1__6948_SHARP_])],null));
}),self__.keys.sort(cljs.core.obj_map_compare_keys));
} else {
return null;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.ObjMap(new_meta,self__.keys,self__.strobj,self__.update_count,self__.__hash));
}
}));

(cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return coll__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry,(0)),cljs.core._nth(entry,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,coll__$1,entry);
}
}));

(cljs.core.ObjMap.prototype.call = (function (unused__10318__auto__){
var self__ = this;
var self__ = this;
var G__6953 = (arguments.length - (1));
switch (G__6953) {
case (1):
return self__.cljs$core$IFn$_invoke$arity$1((arguments[(1)]));

break;
case (2):
return self__.cljs$core$IFn$_invoke$arity$2((arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (1)))].join('')));

}
}));

(cljs.core.ObjMap.prototype.apply = (function (self__,args6949){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args6949)));
}));

(cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
}));

(cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.ObjMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"keys","keys",-1586012071,null),new cljs.core.Symbol(null,"strobj","strobj",1088091283,null),new cljs.core.Symbol(null,"update-count","update-count",-411982269,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ObjMap.cljs$lang$type = true);

(cljs.core.ObjMap.cljs$lang$ctorStr = "cljs.core/ObjMap");

(cljs.core.ObjMap.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/ObjMap");
}));

/**
 * Positional factory function for cljs.core/ObjMap.
 */
cljs.core.__GT_ObjMap = (function cljs$core$__GT_ObjMap(meta,keys,strobj,update_count,__hash){
return (new cljs.core.ObjMap(meta,keys,strobj,update_count,__hash));
});

(cljs.core.ObjMap.EMPTY = (new cljs.core.ObjMap(null,[],({}),(0),cljs.core.empty_unordered_hash)));
(cljs.core.ObjMap.HASHMAP_THRESHOLD = (8));
(cljs.core.ObjMap.fromObject = (function (ks,obj){
return (new cljs.core.ObjMap(null,ks,obj,(0),null));
}));

/**
* @constructor
*/
cljs.core.RecordIter = (function (i,record,base_count,fields,ext_map_iter){
this.i = i;
this.record = record;
this.base_count = base_count;
this.fields = fields;
this.ext_map_iter = ext_map_iter;
});
(cljs.core.RecordIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
var or__5002__auto__ = (self__.i < self__.base_count);
if(or__5002__auto__){
return or__5002__auto__;
} else {
return self__.ext_map_iter.hasNext();
}
}));

(cljs.core.RecordIter.prototype.next = (function (){
var self__ = this;
var _ = this;
if((self__.i < self__.base_count)){
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(self__.fields,self__.i);
(self__.i = (self__.i + (1)));

return (new cljs.core.MapEntry(k,cljs.core._lookup(self__.record,k),null));
} else {
return self__.ext_map_iter.next();
}
}));

(cljs.core.RecordIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.RecordIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"record","record",861424668,null),new cljs.core.Symbol(null,"base-count","base-count",-1180647182,null),new cljs.core.Symbol(null,"fields","fields",-291534703,null),new cljs.core.Symbol(null,"ext-map-iter","ext-map-iter",-1215982757,null)], null);
}));

(cljs.core.RecordIter.cljs$lang$type = true);

(cljs.core.RecordIter.cljs$lang$ctorStr = "cljs.core/RecordIter");

(cljs.core.RecordIter.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/RecordIter");
}));

/**
 * Positional factory function for cljs.core/RecordIter.
 */
cljs.core.__GT_RecordIter = (function cljs$core$__GT_RecordIter(i,record,base_count,fields,ext_map_iter){
return (new cljs.core.RecordIter(i,record,base_count,fields,ext_map_iter));
});


/**
* @constructor
*/
cljs.core.ES6EntriesIterator = (function (s){
this.s = s;
});
(cljs.core.ES6EntriesIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if((!((self__.s == null)))){
var vec__6956 = cljs.core.first(self__.s);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6956,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6956,(1),null);
(self__.s = cljs.core.next(self__.s));

return ({"value": [k,v], "done": false});
} else {
return ({"value": null, "done": true});
}
}));

(cljs.core.ES6EntriesIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ES6EntriesIterator.cljs$lang$type = true);

(cljs.core.ES6EntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6EntriesIterator");

(cljs.core.ES6EntriesIterator.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/ES6EntriesIterator");
}));

/**
 * Positional factory function for cljs.core/ES6EntriesIterator.
 */
cljs.core.__GT_ES6EntriesIterator = (function cljs$core$__GT_ES6EntriesIterator(s){
return (new cljs.core.ES6EntriesIterator(s));
});

cljs.core.es6_entries_iterator = (function cljs$core$es6_entries_iterator(coll){
return (new cljs.core.ES6EntriesIterator(cljs.core.seq(coll)));
});

/**
* @constructor
*/
cljs.core.ES6SetEntriesIterator = (function (s){
this.s = s;
});
(cljs.core.ES6SetEntriesIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if((!((self__.s == null)))){
var x = cljs.core.first(self__.s);
(self__.s = cljs.core.next(self__.s));

return ({"value": [x,x], "done": false});
} else {
return ({"value": null, "done": true});
}
}));

(cljs.core.ES6SetEntriesIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ES6SetEntriesIterator.cljs$lang$type = true);

(cljs.core.ES6SetEntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6SetEntriesIterator");

(cljs.core.ES6SetEntriesIterator.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/ES6SetEntriesIterator");
}));

/**
 * Positional factory function for cljs.core/ES6SetEntriesIterator.
 */
cljs.core.__GT_ES6SetEntriesIterator = (function cljs$core$__GT_ES6SetEntriesIterator(s){
return (new cljs.core.ES6SetEntriesIterator(s));
});

cljs.core.es6_set_entries_iterator = (function cljs$core$es6_set_entries_iterator(coll){
return (new cljs.core.ES6SetEntriesIterator(cljs.core.seq(coll)));
});
cljs.core.array_index_of_nil_QMARK_ = (function cljs$core$array_index_of_nil_QMARK_(arr){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(((arr[i]) == null)){
return i;
} else {
var G__9409 = (i + (2));
i = G__9409;
continue;

}
}
break;
}
});
cljs.core.array_index_of_keyword_QMARK_ = (function cljs$core$array_index_of_keyword_QMARK_(arr,k){
var len = arr.length;
var kstr = k.fqn;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(((((arr[i]) instanceof cljs.core.Keyword)) && ((kstr === (arr[i]).fqn)))){
return i;
} else {
var G__9410 = (i + (2));
i = G__9410;
continue;

}
}
break;
}
});
cljs.core.array_index_of_symbol_QMARK_ = (function cljs$core$array_index_of_symbol_QMARK_(arr,k){
var len = arr.length;
var kstr = k.str;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(((((arr[i]) instanceof cljs.core.Symbol)) && ((kstr === (arr[i]).str)))){
return i;
} else {
var G__9411 = (i + (2));
i = G__9411;
continue;

}
}
break;
}
});
cljs.core.array_index_of_identical_QMARK_ = (function cljs$core$array_index_of_identical_QMARK_(arr,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((k === (arr[i]))){
return i;
} else {
var G__9412 = (i + (2));
i = G__9412;
continue;

}
}
break;
}
});
cljs.core.array_index_of_equiv_QMARK_ = (function cljs$core$array_index_of_equiv_QMARK_(arr,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(arr[i]))){
return i;
} else {
var G__9413 = (i + (2));
i = G__9413;
continue;

}
}
break;
}
});
cljs.core.array_index_of = (function cljs$core$array_index_of(arr,k){
if((k instanceof cljs.core.Keyword)){
return cljs.core.array_index_of_keyword_QMARK_(arr,k);
} else {
if(((typeof k === 'string') || (typeof k === 'number'))){
return cljs.core.array_index_of_identical_QMARK_(arr,k);
} else {
if((k instanceof cljs.core.Symbol)){
return cljs.core.array_index_of_symbol_QMARK_(arr,k);
} else {
if((k == null)){
return cljs.core.array_index_of_nil_QMARK_(arr);
} else {
return cljs.core.array_index_of_equiv_QMARK_(arr,k);

}
}
}
}
});
cljs.core.array_map_index_of = (function cljs$core$array_map_index_of(m,k){
return cljs.core.array_index_of(m.arr,k);
});
cljs.core.array_extend_kv = (function cljs$core$array_extend_kv(arr,k,v){
var l = arr.length;
var narr = (new Array((l + (2))));
var i_9414 = (0);
while(true){
if((i_9414 < l)){
(narr[i_9414] = (arr[i_9414]));

var G__9415 = (i_9414 + (1));
i_9414 = G__9415;
continue;
} else {
}
break;
}

(narr[l] = k);

(narr[(l + (1))] = v);

return narr;
});
cljs.core.array_map_extend_kv = (function cljs$core$array_map_extend_kv(m,k,v){
return cljs.core.array_extend_kv(m.arr,k,v);
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.MapEntry = (function (key,val,__hash){
this.key = key;
this.val = val;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 166619935;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.MapEntry.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.MapEntry.prototype.cljs$core$IFind$_find$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
var G__6960 = k;
switch (G__6960) {
case (0):
return (new cljs.core.MapEntry((0),self__.key,null));

break;
case (1):
return (new cljs.core.MapEntry((1),self__.val,null));

break;
default:
return null;

}
}));

(cljs.core.MapEntry.prototype.indexOf = (function() {
var G__9417 = null;
var G__9417__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__9417__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__9417 = function(x,start){
switch(arguments.length){
case 1:
return G__9417__1.call(this,x);
case 2:
return G__9417__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9417.cljs$core$IFn$_invoke$arity$1 = G__9417__1;
G__9417.cljs$core$IFn$_invoke$arity$2 = G__9417__2;
return G__9417;
})()
);

(cljs.core.MapEntry.prototype.lastIndexOf = (function() {
var G__9418 = null;
var G__9418__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__9418__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__9418 = function(x,start){
switch(arguments.length){
case 1:
return G__9418__1.call(this,x);
case 2:
return G__9418__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9418.cljs$core$IFn$_invoke$arity$1 = G__9418__1;
G__9418.cljs$core$IFn$_invoke$arity$2 = G__9418__2;
return G__9418;
})()
);

(cljs.core.MapEntry.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,null);
}));

(cljs.core.MapEntry.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.MapEntry.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
throw (new Error("Index out of bounds"));

}
}
}));

(cljs.core.MapEntry.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
}));

(cljs.core.MapEntry.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
}));

(cljs.core.MapEntry.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.MapEntry.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (2);
}));

(cljs.core.MapEntry.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.key;
}));

(cljs.core.MapEntry.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.MapEntry.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.MapEntry.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
}));

(cljs.core.MapEntry.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.val,self__.key],(0),null));
}));

(cljs.core.MapEntry.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.MapEntry.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.MapEntry.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.MapEntry.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
}));

(cljs.core.MapEntry.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
}));

(cljs.core.MapEntry.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
}));

(cljs.core.MapEntry.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return (((k === (0))) || ((k === (1))));
}));

(cljs.core.MapEntry.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.key,self__.val],(0),null));
}));

(cljs.core.MapEntry.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
}));

(cljs.core.MapEntry.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
}));

(cljs.core.MapEntry.prototype.call = (function (unused__10318__auto__){
var self__ = this;
var self__ = this;
var G__6961 = (arguments.length - (1));
switch (G__6961) {
case (1):
return self__.cljs$core$IFn$_invoke$arity$1((arguments[(1)]));

break;
case (2):
return self__.cljs$core$IFn$_invoke$arity$2((arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (1)))].join('')));

}
}));

(cljs.core.MapEntry.prototype.apply = (function (self__,args6959){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args6959)));
}));

(cljs.core.MapEntry.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
}));

(cljs.core.MapEntry.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.MapEntry.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"val","val",1769233139,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.MapEntry.cljs$lang$type = true);

(cljs.core.MapEntry.cljs$lang$ctorStr = "cljs.core/MapEntry");

(cljs.core.MapEntry.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/MapEntry");
}));

/**
 * Positional factory function for cljs.core/MapEntry.
 */
cljs.core.__GT_MapEntry = (function cljs$core$__GT_MapEntry(key,val,__hash){
return (new cljs.core.MapEntry(key,val,__hash));
});

/**
 * Returns true if x satisfies IMapEntry
 */
cljs.core.map_entry_QMARK_ = (function cljs$core$map_entry_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (2048))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IMapEntry$)))){
return true;
} else {
return false;
}
} else {
return false;
}
});

/**
* @constructor
 * @implements {cljs.core.IDrop}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentArrayMapSeq = (function (arr,i,_meta){
this.arr = arr;
this.i = i;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 262144;
});
(cljs.core.PersistentArrayMapSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentArrayMapSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentArrayMapSeq.prototype.indexOf = (function() {
var G__9420 = null;
var G__9420__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__9420__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__9420 = function(x,start){
switch(arguments.length){
case 1:
return G__9420__1.call(this,x);
case 2:
return G__9420__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9420.cljs$core$IFn$_invoke$arity$1 = G__9420__1;
G__9420.cljs$core$IFn$_invoke$arity$2 = G__9420__2;
return G__9420;
})()
);

(cljs.core.PersistentArrayMapSeq.prototype.lastIndexOf = (function() {
var G__9421 = null;
var G__9421__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__9421__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__9421 = function(x,start){
switch(arguments.length){
case 1:
return G__9421__1.call(this,x);
case 2:
return G__9421__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9421.cljs$core$IFn$_invoke$arity$1 = G__9421__1;
G__9421.cljs$core$IFn$_invoke$arity$2 = G__9421__2;
return G__9421;
})()
);

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),null));
} else {
return null;
}
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return ((self__.arr.length - self__.i) / (2));
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.MapEntry((self__.arr[self__.i]),(self__.arr[(self__.i + (1))]),null));
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__._meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentArrayMapSeq(self__.arr,self__.i,new_meta));
}
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IDrop$_drop$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if((n < coll__$1.cljs$core$ICounted$_count$arity$1(null))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + ((2) * n)),null));
} else {
return null;
}
}));

(cljs.core.PersistentArrayMapSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
}));

(cljs.core.PersistentArrayMapSeq.cljs$lang$type = true);

(cljs.core.PersistentArrayMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapSeq");

(cljs.core.PersistentArrayMapSeq.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/PersistentArrayMapSeq");
}));

/**
 * Positional factory function for cljs.core/PersistentArrayMapSeq.
 */
cljs.core.__GT_PersistentArrayMapSeq = (function cljs$core$__GT_PersistentArrayMapSeq(arr,i,_meta){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
});

(cljs.core.PersistentArrayMapSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));
cljs.core.persistent_array_map_seq = (function cljs$core$persistent_array_map_seq(arr,i,_meta){
if((i <= (arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
} else {
return null;
}
});


/**
* @constructor
*/
cljs.core.PersistentArrayMapIterator = (function (arr,i,cnt){
this.arr = arr;
this.i = i;
this.cnt = cnt;
});
(cljs.core.PersistentArrayMapIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.cnt);
}));

(cljs.core.PersistentArrayMapIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = (new cljs.core.MapEntry((self__.arr[self__.i]),(self__.arr[(self__.i + (1))]),null));
(self__.i = (self__.i + (2)));

return ret;
}));

(cljs.core.PersistentArrayMapIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null)], null);
}));

(cljs.core.PersistentArrayMapIterator.cljs$lang$type = true);

(cljs.core.PersistentArrayMapIterator.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapIterator");

(cljs.core.PersistentArrayMapIterator.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/PersistentArrayMapIterator");
}));

/**
 * Positional factory function for cljs.core/PersistentArrayMapIterator.
 */
cljs.core.__GT_PersistentArrayMapIterator = (function cljs$core$__GT_PersistentArrayMapIterator(arr,i,cnt){
return (new cljs.core.PersistentArrayMapIterator(arr,i,cnt));
});


/**
* @constructor
 * @implements {cljs.core.IDrop}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentArrayMap = (function (meta,cnt,arr,__hash){
this.meta = meta;
this.cnt = cnt;
this.arr = arr;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16647951;
this.cljs$lang$protocol_mask$partition1$ = 401412;
});
(cljs.core.PersistentArrayMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentArrayMap.prototype.cljs$core$IFind$_find$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
return null;
} else {
return (new cljs.core.MapEntry((self__.arr[idx]),(self__.arr[(idx + (1))]),null));
}
}));

(cljs.core.PersistentArrayMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentArrayMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentArrayMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.keys.call(null,coll)));
}));

(cljs.core.PersistentArrayMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
}));

(cljs.core.PersistentArrayMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.vals.call(null,coll)));
}));

(cljs.core.PersistentArrayMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
}));

(cljs.core.PersistentArrayMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.PersistentArrayMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__6964 = cljs.core.seq(coll);
var chunk__6965 = null;
var count__6966 = (0);
var i__6967 = (0);
while(true){
if((i__6967 < count__6966)){
var vec__6974 = chunk__6965.cljs$core$IIndexed$_nth$arity$2(null,i__6967);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6974,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6974,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__9423 = seq__6964;
var G__9424 = chunk__6965;
var G__9425 = count__6966;
var G__9426 = (i__6967 + (1));
seq__6964 = G__9423;
chunk__6965 = G__9424;
count__6966 = G__9425;
i__6967 = G__9426;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__6964);
if(temp__5804__auto__){
var seq__6964__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__6964__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__6964__$1);
var G__9427 = cljs.core.chunk_rest(seq__6964__$1);
var G__9428 = c__5525__auto__;
var G__9429 = cljs.core.count(c__5525__auto__);
var G__9430 = (0);
seq__6964 = G__9427;
chunk__6965 = G__9428;
count__6966 = G__9429;
i__6967 = G__9430;
continue;
} else {
var vec__6977 = cljs.core.first(seq__6964__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6977,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6977,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__9434 = cljs.core.next(seq__6964__$1);
var G__9435 = null;
var G__9436 = (0);
var G__9437 = (0);
seq__6964 = G__9434;
chunk__6965 = G__9435;
count__6966 = G__9436;
i__6967 = G__9437;
continue;
}
} else {
return null;
}
}
break;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var G__6980 = init__$1;
var G__6981 = (self__.arr[i]);
var G__6982 = (self__.arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__6980,G__6981,G__6982) : f.call(null,G__6980,G__6981,G__6982));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__9438 = (i + (2));
var G__9439 = init__$2;
i = G__9438;
init__$1 = G__9439;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return (new cljs.core.PersistentArrayMapIterator(self__.arr,(0),(self__.cnt * (2))));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,self__.arr,self__.__hash));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if(((cljs.core.map_QMARK_(other)) && ((!(cljs.core.record_QMARK_(other)))))){
var alen = self__.arr.length;
var other__$1 = other;
if((self__.cnt === other__$1.cljs$core$ICounted$_count$arity$1(null))){
var i = (0);
while(true){
if((i < alen)){
var v = other__$1.cljs$core$ILookup$_lookup$arity$3(null,(self__.arr[i]),cljs.core.lookup_sentinel);
if((!((v === cljs.core.lookup_sentinel)))){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[(i + (1))]),v)){
var G__9442 = (i + (2));
i = G__9442;
continue;
} else {
return false;
}
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return false;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientArrayMap(({}),self__.arr.length,cljs.core.aclone(self__.arr)));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentArrayMap.EMPTY,self__.meta);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2(coll__$1,f);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3(coll__$1,f,start);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx >= (0))){
var len = self__.arr.length;
var new_len = (len - (2));
if((new_len === (0))){
return coll__$1.cljs$core$IEmptyableCollection$_empty$arity$1(null);
} else {
var new_arr = (new Array(new_len));
var s = (0);
var d = (0);
while(true){
if((s >= len)){
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt - (1)),new_arr,null));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(self__.arr[s]))){
var G__9445 = (s + (2));
var G__9446 = d;
s = G__9445;
d = G__9446;
continue;
} else {
(new_arr[d] = (self__.arr[s]));

(new_arr[(d + (1))] = (self__.arr[(s + (1))]));

var G__9447 = (s + (2));
var G__9448 = (d + (2));
s = G__9447;
d = G__9448;
continue;

}
}
break;
}
}
} else {
return coll__$1;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
if((self__.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD)){
var arr__$1 = cljs.core.array_map_extend_kv(coll__$1,k,v);
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt + (1)),arr__$1,null));
} else {
return cljs.core._with_meta(cljs.core._assoc(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1),k,v),self__.meta);
}
} else {
if((v === (self__.arr[(idx + (1))]))){
return coll__$1;
} else {
var arr__$1 = (function (){var G__6985 = cljs.core.aclone(self__.arr);
(G__6985[(idx + (1))] = v);

return G__6985;
})();
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,arr__$1,null));

}
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return (!((cljs.core.array_map_index_of(coll__$1,k) === (-1))));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.persistent_array_map_seq(self__.arr,(0),null);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentArrayMap(new_meta,self__.cnt,self__.arr,self__.__hash));
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return coll__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry,(0)),cljs.core._nth(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__9451 = cljs.core._assoc(ret,cljs.core._nth(e,(0)),cljs.core._nth(e,(1)));
var G__9452 = cljs.core.next(es);
ret = G__9451;
es = G__9452;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
}));

(cljs.core.PersistentArrayMap.prototype.call = (function (unused__10318__auto__){
var self__ = this;
var self__ = this;
var G__6986 = (arguments.length - (1));
switch (G__6986) {
case (1):
return self__.cljs$core$IFn$_invoke$arity$1((arguments[(1)]));

break;
case (2):
return self__.cljs$core$IFn$_invoke$arity$2((arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (1)))].join('')));

}
}));

(cljs.core.PersistentArrayMap.prototype.apply = (function (self__,args6963){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args6963)));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IDrop$_drop$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
var temp__5808__auto__ = coll__$1.cljs$core$ISeqable$_seq$arity$1(null);
if((temp__5808__auto__ == null)){
return null;
} else {
var s = temp__5808__auto__;
return cljs.core._drop(s,n);
}
}));

(cljs.core.PersistentArrayMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentArrayMap.cljs$lang$type = true);

(cljs.core.PersistentArrayMap.cljs$lang$ctorStr = "cljs.core/PersistentArrayMap");

(cljs.core.PersistentArrayMap.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/PersistentArrayMap");
}));

/**
 * Positional factory function for cljs.core/PersistentArrayMap.
 */
cljs.core.__GT_PersistentArrayMap = (function cljs$core$__GT_PersistentArrayMap(meta,cnt,arr,__hash){
return (new cljs.core.PersistentArrayMap(meta,cnt,arr,__hash));
});

(cljs.core.PersistentArrayMap.EMPTY = (new cljs.core.PersistentArrayMap(null,(0),[],cljs.core.empty_unordered_hash)));
(cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = (8));
(cljs.core.PersistentArrayMap.fromArray = (function (arr,no_clone,no_check){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
var arr__$2 = ((no_check)?arr__$1:(function (){var ret = [];
var i_9455 = (0);
while(true){
if((i_9455 < arr__$1.length)){
var k_9456 = (arr__$1[i_9455]);
var v_9457 = (arr__$1[(i_9455 + (1))]);
var idx_9458 = cljs.core.array_index_of(ret,k_9456);
if((idx_9458 === (-1))){
ret.push(k_9456);

ret.push(v_9457);
} else {
}

var G__9460 = (i_9455 + (2));
i_9455 = G__9460;
continue;
} else {
}
break;
}

return ret;
})());
var cnt = (arr__$2.length / (2));
return (new cljs.core.PersistentArrayMap(null,cnt,arr__$2,null));
}));
(cljs.core.PersistentArrayMap.createWithCheck = (function (arr){
var ret = [];
var i_9461 = (0);
while(true){
if((i_9461 < arr.length)){
var k_9462 = (arr[i_9461]);
var v_9463 = (arr[(i_9461 + (1))]);
var idx_9464 = cljs.core.array_index_of(ret,k_9462);
if((idx_9464 === (-1))){
var G__6987_9465 = ret;
G__6987_9465.push(k_9462);

G__6987_9465.push(v_9463);

} else {
throw (new Error(["Duplicate key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k_9462)].join('')));
}

var G__9466 = (i_9461 + (2));
i_9461 = G__9466;
continue;
} else {
}
break;
}

var cnt = (arr.length / (2));
return (new cljs.core.PersistentArrayMap(null,cnt,arr,null));
}));
cljs.core.key_test = (function cljs$core$key_test(key,other){
if((key === other)){
return true;
} else {
if(cljs.core.keyword_identical_QMARK_(key,other)){
return true;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,other);

}
}
});
cljs.core.pam_dupes_QMARK_ = (function cljs$core$pam_dupes_QMARK_(arr){
var i = (0);
while(true){
if((i < arr.length)){
var dupe_QMARK_ = (function (){var j = (0);
while(true){
if((j < i)){
var or__5002__auto__ = cljs.core.key_test((arr[i]),(arr[j]));
if(or__5002__auto__){
return or__5002__auto__;
} else {
var G__9467 = ((2) + j);
j = G__9467;
continue;
}
} else {
return false;
}
break;
}
})();
var or__5002__auto__ = dupe_QMARK_;
if(or__5002__auto__){
return or__5002__auto__;
} else {
var G__9468 = ((2) + i);
i = G__9468;
continue;
}
} else {
return false;
}
break;
}
});
cljs.core.pam_new_size = (function cljs$core$pam_new_size(arr){
var i = (0);
var n = (0);
while(true){
if((i < arr.length)){
var dupe_QMARK_ = (function (){var j = (0);
while(true){
if((j < i)){
var or__5002__auto__ = cljs.core.key_test((arr[i]),(arr[j]));
if(or__5002__auto__){
return or__5002__auto__;
} else {
var G__9469 = ((2) + j);
j = G__9469;
continue;
}
} else {
return false;
}
break;
}
})();
var G__9470 = ((2) + i);
var G__9471 = ((dupe_QMARK_)?n:(n + (2)));
i = G__9470;
n = G__9471;
continue;
} else {
return n;
}
break;
}
});
cljs.core.pam_grow_seed_array = (function cljs$core$pam_grow_seed_array(seed,trailing){
var seed_cnt = (seed.length - (1));
var extra_kvs = cljs.core.seq(trailing);
var ret = (new Array((seed_cnt + ((2) * cljs.core.count(extra_kvs)))));
var ret__$1 = cljs.core.array_copy(seed,(0),ret,(0),seed_cnt);
var i = seed_cnt;
var extra_kvs__$1 = extra_kvs;
while(true){
if(extra_kvs__$1){
var kv = cljs.core.first(extra_kvs__$1);
(ret__$1[i] = cljs.core._key(kv));

(ret__$1[(i + (1))] = cljs.core._val(kv));

var G__9472 = ((2) + seed_cnt);
var G__9473 = cljs.core.next(extra_kvs__$1);
i = G__9472;
extra_kvs__$1 = G__9473;
continue;
} else {
return ret__$1;
}
break;
}
});
(cljs.core.PersistentArrayMap.createAsIfByAssoc = (function (init){
var len = init.length;
var has_trailing_QMARK_ = ((1) === (len & (1)));
if((!(((has_trailing_QMARK_) || (cljs.core.pam_dupes_QMARK_(init)))))){
return (new cljs.core.PersistentArrayMap(null,(len / (2)),init,null));
} else {
return cljs.core.PersistentArrayMap.createAsIfByAssocComplexPath(init,has_trailing_QMARK_);
}
}));
(cljs.core.PersistentArrayMap.createAsIfByAssocComplexPath = (function (init,has_trailing_QMARK_){
var init__$1 = ((has_trailing_QMARK_)?cljs.core.pam_grow_seed_array(init,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(init[(init.length - (1))]))):init);
var n = cljs.core.pam_new_size(init__$1);
var len = init__$1.length;
if((n < len)){
var nodups = (new Array(n));
var i_9474 = (0);
var m_9475 = (0);
while(true){
if((i_9474 < len)){
var dupe_QMARK__9476 = (function (){var j = (0);
while(true){
if((j < m_9475)){
var or__5002__auto__ = cljs.core.key_test((init__$1[i_9474]),(init__$1[j]));
if(or__5002__auto__){
return or__5002__auto__;
} else {
var G__9477 = ((2) + j);
j = G__9477;
continue;
}
} else {
return false;
}
break;
}
})();
if((!(dupe_QMARK__9476))){
var j_9478 = (function (){var j_9478 = (len - (2));
while(true){
if((j_9478 >= i_9474)){
if(cljs.core.key_test((init__$1[i_9474]),(init__$1[j_9478]))){
return j_9478;
} else {
var G__9479 = (j_9478 - (2));
j_9478 = G__9479;
continue;
}
} else {
return j_9478;
}
break;
}
})();
(nodups[m_9475] = (init__$1[i_9474]));

(nodups[(m_9475 + (1))] = (init__$1[(j_9478 + (1))]));

var G__9480 = ((2) + i_9474);
var G__9481 = ((2) + m_9475);
i_9474 = G__9480;
m_9475 = G__9481;
continue;
} else {
var G__9482 = ((2) + i_9474);
var G__9483 = m_9475;
i_9474 = G__9482;
m_9475 = G__9483;
continue;
}
} else {
}
break;
}

return (new cljs.core.PersistentArrayMap(null,(nodups.length / (2)),nodups,null));
} else {
return (new cljs.core.PersistentArrayMap(null,(init__$1.length / (2)),init__$1,null));
}
}));
(cljs.core.PersistentArrayMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ITransientMap}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientArrayMap = (function (editable_QMARK_,len,arr){
this.editable_QMARK_ = editable_QMARK_;
this.len = len;
this.arr = arr;
this.cljs$lang$protocol_mask$partition0$ = 259;
this.cljs$lang$protocol_mask$partition1$ = 56;
});
(cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
return cljs.core.quot(self__.len,(2));
} else {
throw (new Error("count after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,k){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
var idx = cljs.core.array_map_index_of(tcoll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
} else {
throw (new Error("lookup after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
if(cljs.core.map_entry_QMARK_(o)){
return tcoll__$1.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null,(cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(o) : cljs.core.key.call(null,o)),(cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(o) : cljs.core.val.call(null,o)));
} else {
if(cljs.core.vector_QMARK_(o)){
return tcoll__$1.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null,(o.cljs$core$IFn$_invoke$arity$1 ? o.cljs$core$IFn$_invoke$arity$1((0)) : o.call(null,(0))),(o.cljs$core$IFn$_invoke$arity$1 ? o.cljs$core$IFn$_invoke$arity$1((1)) : o.call(null,(1))));
} else {
var es = cljs.core.seq(o);
var tcoll__$2 = tcoll__$1;
while(true){
var temp__5802__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__5802__auto__)){
var e = temp__5802__auto__;
var G__9484 = cljs.core.next(es);
var G__9485 = cljs.core._assoc_BANG_(tcoll__$2,(cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.key.call(null,e)),(cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.val.call(null,e)));
es = G__9484;
tcoll__$2 = G__9485;
continue;
} else {
return tcoll__$2;
}
break;
}

}
}
} else {
throw (new Error("conj! after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
(self__.editable_QMARK_ = false);

return (new cljs.core.PersistentArrayMap(null,cljs.core.quot(self__.len,(2)),self__.arr,null));
} else {
throw (new Error("persistent! called twice"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx === (-1))){
if(((self__.len + (2)) <= ((2) * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD))){
(self__.len = (self__.len + (2)));

self__.arr.push(key);

self__.arr.push(val);

return tcoll__$1;
} else {
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3((cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2 ? cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2(self__.len,self__.arr) : cljs.core.array__GT_transient_hash_map.call(null,self__.len,self__.arr)),key,val);
}
} else {
if((val === (self__.arr[(idx + (1))]))){
return tcoll__$1;
} else {
(self__.arr[(idx + (1))] = val);

return tcoll__$1;
}
}
} else {
throw (new Error("assoc! after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function (tcoll,key){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx >= (0))){
(self__.arr[idx] = (self__.arr[(self__.len - (2))]));

(self__.arr[(idx + (1))] = (self__.arr[(self__.len - (1))]));

var G__6989_9486 = self__.arr;
G__6989_9486.pop();

G__6989_9486.pop();


(self__.len = (self__.len - (2)));
} else {
}

return tcoll__$1;
} else {
throw (new Error("dissoc! after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.call = (function (unused__10318__auto__){
var self__ = this;
var self__ = this;
var G__6990 = (arguments.length - (1));
switch (G__6990) {
case (1):
return self__.cljs$core$IFn$_invoke$arity$1((arguments[(1)]));

break;
case (2):
return self__.cljs$core$IFn$_invoke$arity$2((arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (1)))].join('')));

}
}));

(cljs.core.TransientArrayMap.prototype.apply = (function (self__,args6988){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args6988)));
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (key){
var self__ = this;
var tcoll = this;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,null);
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (key,not_found){
var self__ = this;
var tcoll = this;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,not_found);
}));

(cljs.core.TransientArrayMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"editable?","editable?",-164945806,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"len","len",-1230778691,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"arr","arr",2115492975,null)], null);
}));

(cljs.core.TransientArrayMap.cljs$lang$type = true);

(cljs.core.TransientArrayMap.cljs$lang$ctorStr = "cljs.core/TransientArrayMap");

(cljs.core.TransientArrayMap.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/TransientArrayMap");
}));

/**
 * Positional factory function for cljs.core/TransientArrayMap.
 */
cljs.core.__GT_TransientArrayMap = (function cljs$core$__GT_TransientArrayMap(editable_QMARK_,len,arr){
return (new cljs.core.TransientArrayMap(editable_QMARK_,len,arr));
});

cljs.core.array__GT_transient_hash_map = (function cljs$core$array__GT_transient_hash_map(len,arr){
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
var i = (0);
while(true){
if((i < len)){
var G__9491 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,(arr[i]),(arr[(i + (1))]));
var G__9492 = (i + (2));
out = G__9491;
i = G__9492;
continue;
} else {
return out;
}
break;
}
});

/**
* @constructor
*/
cljs.core.Box = (function (val){
this.val = val;
});

(cljs.core.Box.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Box.cljs$lang$type = true);

(cljs.core.Box.cljs$lang$ctorStr = "cljs.core/Box");

(cljs.core.Box.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/Box");
}));

/**
 * Positional factory function for cljs.core/Box.
 */
cljs.core.__GT_Box = (function cljs$core$__GT_Box(val){
return (new cljs.core.Box(val));
});



cljs.core.mask = (function cljs$core$mask(hash,shift){
return ((hash >>> shift) & (31));
});
cljs.core.clone_and_set = (function cljs$core$clone_and_set(var_args){
var G__6992 = arguments.length;
switch (G__6992) {
case 3:
return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3 = (function (arr,i,a){
var G__6993 = cljs.core.aclone(arr);
(G__6993[i] = a);

return G__6993;
}));

(cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5 = (function (arr,i,a,j,b){
var G__6994 = cljs.core.aclone(arr);
(G__6994[i] = a);

(G__6994[j] = b);

return G__6994;
}));

(cljs.core.clone_and_set.cljs$lang$maxFixedArity = 5);

cljs.core.remove_pair = (function cljs$core$remove_pair(arr,i){
var new_arr = (new Array((arr.length - (2))));
cljs.core.array_copy(arr,(0),new_arr,(0),((2) * i));

cljs.core.array_copy(arr,((2) * (i + (1))),new_arr,((2) * i),(new_arr.length - ((2) * i)));

return new_arr;
});
cljs.core.bitmap_indexed_node_index = (function cljs$core$bitmap_indexed_node_index(bitmap,bit){
return cljs.core.bit_count((bitmap & (bit - (1))));
});
cljs.core.bitpos = (function cljs$core$bitpos(hash,shift){
return ((1) << ((hash >>> shift) & 0x01f));
});
cljs.core.edit_and_set = (function cljs$core$edit_and_set(var_args){
var G__6996 = arguments.length;
switch (G__6996) {
case 4:
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4 = (function (inode,edit,i,a){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

return editable;
}));

(cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6 = (function (inode,edit,i,a,j,b){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

(editable.arr[j] = b);

return editable;
}));

(cljs.core.edit_and_set.cljs$lang$maxFixedArity = 6);

cljs.core.inode_kv_reduce = (function cljs$core$inode_kv_reduce(arr,f,init){
var len = arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var k = (arr[i]);
if((!((k == null)))){
var G__6997 = init__$1;
var G__6998 = k;
var G__6999 = (arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__6997,G__6998,G__6999) : f.call(null,G__6997,G__6998,G__6999));
} else {
var node = (arr[(i + (1))]);
if((!((node == null)))){
return node.kv_reduce(f,init__$1);
} else {
return init__$1;
}
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return init__$2;
} else {
var G__9499 = (i + (2));
var G__9500 = init__$2;
i = G__9499;
init__$1 = G__9500;
continue;
}
} else {
return init__$1;
}
break;
}
});

/**
* @constructor
*/
cljs.core.NodeIterator = (function (arr,i,next_entry,next_iter){
this.arr = arr;
this.i = i;
this.next_entry = next_entry;
this.next_iter = next_iter;
});
(cljs.core.NodeIterator.prototype.advance = (function (){
var self__ = this;
var this$ = this;
var len = self__.arr.length;
while(true){
if((self__.i < len)){
var key = (self__.arr[self__.i]);
var node_or_val = (self__.arr[(self__.i + (1))]);
var found = (((!((key == null))))?(self__.next_entry = (new cljs.core.MapEntry(key,node_or_val,null))):(((!((node_or_val == null))))?(function (){var new_iter = cljs.core._iterator(node_or_val);
if(new_iter.hasNext()){
return (self__.next_iter = new_iter);
} else {
return false;
}
})():false
));
(self__.i = (self__.i + (2)));

if(found){
return true;
} else {
continue;
}
} else {
return false;
}
break;
}
}));

(cljs.core.NodeIterator.prototype.hasNext = (function (){
var self__ = this;
var this$ = this;
var or__5002__auto__ = (!((self__.next_entry == null)));
if(or__5002__auto__){
return or__5002__auto__;
} else {
var or__5002__auto____$1 = (!((self__.next_iter == null)));
if(or__5002__auto____$1){
return or__5002__auto____$1;
} else {
return this$.advance();
}
}
}));

(cljs.core.NodeIterator.prototype.next = (function (){
var self__ = this;
var this$ = this;
if((!((self__.next_entry == null)))){
var ret = self__.next_entry;
(self__.next_entry = null);

return ret;
} else {
if((!((self__.next_iter == null)))){
var ret = self__.next_iter.next();
if(self__.next_iter.hasNext()){
} else {
(self__.next_iter = null);
}

return ret;
} else {
if(this$.advance()){
return this$.next();
} else {
throw (new Error("No such element"));

}
}
}
}));

(cljs.core.NodeIterator.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.NodeIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"next-entry","next-entry",1091342476,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"next-iter","next-iter",1526626239,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.NodeIterator.cljs$lang$type = true);

(cljs.core.NodeIterator.cljs$lang$ctorStr = "cljs.core/NodeIterator");

(cljs.core.NodeIterator.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/NodeIterator");
}));

/**
 * Positional factory function for cljs.core/NodeIterator.
 */
cljs.core.__GT_NodeIterator = (function cljs$core$__GT_NodeIterator(arr,i,next_entry,next_iter){
return (new cljs.core.NodeIterator(arr,i,next_entry,next_iter));
});


/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.BitmapIndexedNode = (function (edit,bitmap,arr){
this.edit = edit;
this.bitmap = bitmap;
this.arr = arr;
this.cljs$lang$protocol_mask$partition1$ = 131072;
this.cljs$lang$protocol_mask$partition0$ = 0;
});
(cljs.core.BitmapIndexedNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var n = cljs.core.bit_count(self__.bitmap);
var new_arr = (new Array((((n < (0)))?(4):((2) * (n + (1))))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * n));

return (new cljs.core.BitmapIndexedNode(e,self__.bitmap,new_arr));
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
if((!((n == null)))){
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
} else {
if((self__.bitmap === bit)){
return null;
} else {
return inode.edit_and_remove_pair(edit__$1,bit,idx);

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
(removed_leaf_QMARK_.val = true);

return inode.edit_and_remove_pair(edit__$1,bit,idx);
} else {
return inode;

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = (function (e,bit,i){
var self__ = this;
var inode = this;
if((self__.bitmap === bit)){
return null;
} else {
var editable = inode.ensure_editable(e);
var earr = editable.arr;
var len = earr.length;
(editable.bitmap = (bit ^ editable.bitmap));

cljs.core.array_copy(earr,((2) * (i + (1))),earr,((2) * i),(len - ((2) * (i + (1)))));

(earr[(len - (2))] = null);

(earr[(len - (1))] = null);

return editable;
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(self__.arr) : cljs.core.create_inode_seq.call(null,self__.arr));
}));

(cljs.core.BitmapIndexedNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
}));

(cljs.core.BitmapIndexedNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return val_or_node;
} else {
return not_found;

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((((2) * n) < self__.arr.length)){
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
(added_leaf_QMARK_.val = true);

cljs.core.array_copy_downward(earr,((2) * idx),earr,((2) * (idx + (1))),((2) * (n - idx)));

(earr[((2) * idx)] = key);

(earr[(((2) * idx) + (1))] = val);

(editable.bitmap = (editable.bitmap | bit));

return editable;
} else {
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_9504 = (0);
var j_9505 = (0);
while(true){
if((i_9504 < (32))){
if((((self__.bitmap >>> i_9504) & (1)) === (0))){
var G__9507 = (i_9504 + (1));
var G__9508 = j_9505;
i_9504 = G__9507;
j_9505 = G__9508;
continue;
} else {
(nodes[i_9504] = (((!(((self__.arr[j_9505]) == null))))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),cljs.core.hash((self__.arr[j_9505])),(self__.arr[j_9505]),(self__.arr[(j_9505 + (1))]),added_leaf_QMARK_):(self__.arr[(j_9505 + (1))])));

var G__9510 = (i_9504 + (1));
var G__9511 = (j_9505 + (2));
i_9504 = G__9510;
j_9505 = G__9511;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(edit__$1,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (4)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

(added_leaf_QMARK_.val = true);

var editable = inode.ensure_editable(edit__$1);
(editable.arr = new_arr);

(editable.bitmap = (editable.bitmap | bit));

return editable;

}
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),val);
}
} else {
(added_leaf_QMARK_.val = true);

return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * idx),null,(((2) * idx) + (1)),(function (){var G__7000 = edit__$1;
var G__7001 = (shift + (5));
var G__7002 = key_or_nil;
var G__7003 = val_or_node;
var G__7004 = hash;
var G__7005 = key;
var G__7006 = val;
return (cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$7(G__7000,G__7001,G__7002,G__7003,G__7004,G__7005,G__7006) : cljs.core.create_node.call(null,G__7000,G__7001,G__7002,G__7003,G__7004,G__7005,G__7006));
})());

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_9517 = (0);
var j_9518 = (0);
while(true){
if((i_9517 < (32))){
if((((self__.bitmap >>> i_9517) & (1)) === (0))){
var G__9520 = (i_9517 + (1));
var G__9521 = j_9518;
i_9517 = G__9520;
j_9518 = G__9521;
continue;
} else {
(nodes[i_9517] = (((!(((self__.arr[j_9518]) == null))))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),cljs.core.hash((self__.arr[j_9518])),(self__.arr[j_9518]),(self__.arr[(j_9518 + (1))]),added_leaf_QMARK_):(self__.arr[(j_9518 + (1))])));

var G__9523 = (i_9517 + (1));
var G__9524 = (j_9518 + (2));
i_9517 = G__9523;
j_9518 = G__9524;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(null,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

(added_leaf_QMARK_.val = true);

return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap | bit),new_arr));
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),val)));
}
} else {
(added_leaf_QMARK_.val = true);

return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5(self__.arr,((2) * idx),null,(((2) * idx) + (1)),(function (){var G__7007 = (shift + (5));
var G__7008 = key_or_nil;
var G__7009 = val_or_node;
var G__7010 = hash;
var G__7011 = key;
var G__7012 = val;
return (cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$6(G__7007,G__7008,G__7009,G__7010,G__7011,G__7012) : cljs.core.create_node.call(null,G__7007,G__7008,G__7009,G__7010,G__7011,G__7012));
})())));

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_find((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return (new cljs.core.MapEntry(key_or_nil,val_or_node,null));
} else {
return not_found;

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without((shift + (5)),hash,key);
if((n === val_or_node)){
return inode;
} else {
if((!((n == null)))){
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
} else {
if((self__.bitmap === bit)){
return null;
} else {
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((self__.bitmap === bit)){
return null;
} else {
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));
}
} else {
return inode;

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.NodeIterator(self__.arr,(0),null,null));
}));

(cljs.core.BitmapIndexedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),cljs.core.with_meta(new cljs.core.Symbol(null,"bitmap","bitmap",501334601,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.BitmapIndexedNode.cljs$lang$type = true);

(cljs.core.BitmapIndexedNode.cljs$lang$ctorStr = "cljs.core/BitmapIndexedNode");

(cljs.core.BitmapIndexedNode.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/BitmapIndexedNode");
}));

/**
 * Positional factory function for cljs.core/BitmapIndexedNode.
 */
cljs.core.__GT_BitmapIndexedNode = (function cljs$core$__GT_BitmapIndexedNode(edit,bitmap,arr){
return (new cljs.core.BitmapIndexedNode(edit,bitmap,arr));
});

(cljs.core.BitmapIndexedNode.EMPTY = (new cljs.core.BitmapIndexedNode(null,(0),[])));
cljs.core.pack_array_node = (function cljs$core$pack_array_node(array_node,edit,idx){
var arr = array_node.arr;
var len = arr.length;
var new_arr = (new Array(((2) * (array_node.cnt - (1)))));
var i = (0);
var j = (1);
var bitmap = (0);
while(true){
if((i < len)){
if((((!((i === idx)))) && ((!(((arr[i]) == null)))))){
(new_arr[j] = (arr[i]));

var G__9527 = (i + (1));
var G__9528 = (j + (2));
var G__9529 = (bitmap | ((1) << i));
i = G__9527;
j = G__9528;
bitmap = G__9529;
continue;
} else {
var G__9530 = (i + (1));
var G__9531 = j;
var G__9532 = bitmap;
i = G__9530;
j = G__9531;
bitmap = G__9532;
continue;
}
} else {
return (new cljs.core.BitmapIndexedNode(edit,bitmap,new_arr));
}
break;
}
});

/**
* @constructor
*/
cljs.core.ArrayNodeIterator = (function (arr,i,next_iter){
this.arr = arr;
this.i = i;
this.next_iter = next_iter;
});
(cljs.core.ArrayNodeIterator.prototype.hasNext = (function (){
var self__ = this;
var this$ = this;
var len = self__.arr.length;
while(true){
if((!((((!((self__.next_iter == null)))) && (self__.next_iter.hasNext()))))){
if((self__.i < len)){
var node = (self__.arr[self__.i]);
(self__.i = (self__.i + (1)));

if((!((node == null)))){
(self__.next_iter = cljs.core._iterator(node));
} else {
}

continue;
} else {
return false;
}
} else {
return true;
}
break;
}
}));

(cljs.core.ArrayNodeIterator.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(this$.hasNext()){
return self__.next_iter.next();
} else {
throw (new Error("No such element"));
}
}));

(cljs.core.ArrayNodeIterator.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.ArrayNodeIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"next-iter","next-iter",1526626239,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ArrayNodeIterator.cljs$lang$type = true);

(cljs.core.ArrayNodeIterator.cljs$lang$ctorStr = "cljs.core/ArrayNodeIterator");

(cljs.core.ArrayNodeIterator.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/ArrayNodeIterator");
}));

/**
 * Positional factory function for cljs.core/ArrayNodeIterator.
 */
cljs.core.__GT_ArrayNodeIterator = (function cljs$core$__GT_ArrayNodeIterator(arr,i,next_iter){
return (new cljs.core.ArrayNodeIterator(arr,i,next_iter));
});


/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.ArrayNode = (function (edit,cnt,arr){
this.edit = edit;
this.cnt = cnt;
this.arr = arr;
this.cljs$lang$protocol_mask$partition1$ = 131072;
this.cljs$lang$protocol_mask$partition0$ = 0;
});
(cljs.core.ArrayNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
return (new cljs.core.ArrayNode(e,self__.cnt,cljs.core.aclone(self__.arr)));
}
}));

(cljs.core.ArrayNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return inode;
} else {
var n = node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,edit__$1,idx);
} else {
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
(editable.cnt = (editable.cnt - (1)));

return editable;
}
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);

}
}
}
}));

(cljs.core.ArrayNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
return (cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1(self__.arr) : cljs.core.create_array_node_seq.call(null,self__.arr));
}));

(cljs.core.ArrayNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var node = (self__.arr[i]);
if((!((node == null)))){
var init__$2 = node.kv_reduce(f,init__$1);
if(cljs.core.reduced_QMARK_(init__$2)){
return init__$2;
} else {
var G__9533 = (i + (1));
var G__9534 = init__$2;
i = G__9533;
init__$1 = G__9534;
continue;
}
} else {
var G__9535 = (i + (1));
var G__9536 = init__$1;
i = G__9535;
init__$1 = G__9536;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.ArrayNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((!((node == null)))){
return node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
}));

(cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));
(editable.cnt = (editable.cnt + (1)));

return editable;
} else {
var n = node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
}
}
}));

(cljs.core.ArrayNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return (new cljs.core.ArrayNode(null,(self__.cnt + (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_))));
} else {
var n = node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
}
}));

(cljs.core.ArrayNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((!((node == null)))){
return node.inode_find((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
}));

(cljs.core.ArrayNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((!((node == null)))){
var n = node.inode_without((shift + (5)),hash,key);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,null,idx);
} else {
return (new cljs.core.ArrayNode(null,(self__.cnt - (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));

}
}
} else {
return inode;
}
}));

(cljs.core.ArrayNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ArrayNodeIterator(self__.arr,(0),null));
}));

(cljs.core.ArrayNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),cljs.core.with_meta(new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ArrayNode.cljs$lang$type = true);

(cljs.core.ArrayNode.cljs$lang$ctorStr = "cljs.core/ArrayNode");

(cljs.core.ArrayNode.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/ArrayNode");
}));

/**
 * Positional factory function for cljs.core/ArrayNode.
 */
cljs.core.__GT_ArrayNode = (function cljs$core$__GT_ArrayNode(edit,cnt,arr){
return (new cljs.core.ArrayNode(edit,cnt,arr));
});

cljs.core.hash_collision_node_find_index = (function cljs$core$hash_collision_node_find_index(arr,cnt,key){
var lim = ((2) * cnt);
var i = (0);
while(true){
if((i < lim)){
if(cljs.core.key_test(key,(arr[i]))){
return i;
} else {
var G__9539 = (i + (2));
i = G__9539;
continue;
}
} else {
return (-1);
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.HashCollisionNode = (function (edit,collision_hash,cnt,arr){
this.edit = edit;
this.collision_hash = collision_hash;
this.cnt = cnt;
this.arr = arr;
this.cljs$lang$protocol_mask$partition1$ = 131072;
this.cljs$lang$protocol_mask$partition0$ = 0;
});
(cljs.core.HashCollisionNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var new_arr = (new Array(((2) * (self__.cnt + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * self__.cnt));

return (new cljs.core.HashCollisionNode(e,self__.collision_hash,self__.cnt,new_arr));
}
}));

(cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
(removed_leaf_QMARK_.val = true);

if((self__.cnt === (1))){
return null;
} else {
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
(earr[idx] = (earr[(((2) * self__.cnt) - (2))]));

(earr[(idx + (1))] = (earr[(((2) * self__.cnt) - (1))]));

(earr[(((2) * self__.cnt) - (1))] = null);

(earr[(((2) * self__.cnt) - (2))] = null);

(editable.cnt = (editable.cnt - (1)));

return editable;
}
}
}));

(cljs.core.HashCollisionNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(self__.arr) : cljs.core.create_inode_seq.call(null,self__.arr));
}));

(cljs.core.HashCollisionNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
}));

(cljs.core.HashCollisionNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test(key,(self__.arr[idx]))){
return (self__.arr[(idx + (1))]);
} else {
return not_found;

}
}
}));

(cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
if((self__.arr.length > ((2) * self__.cnt))){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * self__.cnt),key,(((2) * self__.cnt) + (1)),val);
(added_leaf_QMARK_.val = true);

(editable.cnt = (editable.cnt + (1)));

return editable;
} else {
var len = self__.arr.length;
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

(added_leaf_QMARK_.val = true);

return inode.ensure_editable_array(edit__$1,(self__.cnt + (1)),new_arr);
}
} else {
if(((self__.arr[(idx + (1))]) === val)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(idx + (1)),val);
}
}
} else {
return (new cljs.core.BitmapIndexedNode(edit__$1,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode,null,null])).inode_assoc_BANG_(edit__$1,shift,hash,key,val,added_leaf_QMARK_);
}
}));

(cljs.core.HashCollisionNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
var len = ((2) * self__.cnt);
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

(added_leaf_QMARK_.val = true);

return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt + (1)),new_arr));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[(idx + (1))]),val)){
return inode;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(idx + (1)),val)));
}
}
} else {
return (new cljs.core.BitmapIndexedNode(null,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode])).inode_assoc(shift,hash,key,val,added_leaf_QMARK_);
}
}));

(cljs.core.HashCollisionNode.prototype.ensure_editable_array = (function (e,count,array){
var self__ = this;
var inode = this;
if((e === self__.edit)){
(self__.arr = array);

(self__.cnt = count);

return inode;
} else {
return (new cljs.core.HashCollisionNode(self__.edit,self__.collision_hash,count,array));
}
}));

(cljs.core.HashCollisionNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test(key,(self__.arr[idx]))){
return (new cljs.core.MapEntry((self__.arr[idx]),(self__.arr[(idx + (1))]),null));
} else {
return not_found;

}
}
}));

(cljs.core.HashCollisionNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
if((self__.cnt === (1))){
return null;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt - (1)),cljs.core.remove_pair(self__.arr,cljs.core.quot(idx,(2)))));

}
}
}));

(cljs.core.HashCollisionNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.NodeIterator(self__.arr,(0),null,null));
}));

(cljs.core.HashCollisionNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),cljs.core.with_meta(new cljs.core.Symbol(null,"collision-hash","collision-hash",-35831342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.HashCollisionNode.cljs$lang$type = true);

(cljs.core.HashCollisionNode.cljs$lang$ctorStr = "cljs.core/HashCollisionNode");

(cljs.core.HashCollisionNode.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/HashCollisionNode");
}));

/**
 * Positional factory function for cljs.core/HashCollisionNode.
 */
cljs.core.__GT_HashCollisionNode = (function cljs$core$__GT_HashCollisionNode(edit,collision_hash,cnt,arr){
return (new cljs.core.HashCollisionNode(edit,collision_hash,cnt,arr));
});

cljs.core.create_node = (function cljs$core$create_node(var_args){
var G__7014 = arguments.length;
switch (G__7014) {
case 6:
return cljs.core.create_node.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return cljs.core.create_node.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 = (function (shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc(shift,key2hash,key2,val2,added_leaf_QMARK_);
}
}));

(cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 = (function (edit,shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit,shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc_BANG_(edit,shift,key2hash,key2,val2,added_leaf_QMARK_);
}
}));

(cljs.core.create_node.cljs$lang$maxFixedArity = 7);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.NodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.NodeSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.NodeSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.NodeSeq.prototype.indexOf = (function() {
var G__9544 = null;
var G__9544__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__9544__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__9544 = function(x,start){
switch(arguments.length){
case 1:
return G__9544__1.call(this,x);
case 2:
return G__9544__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9544.cljs$core$IFn$_invoke$arity$1 = G__9544__1;
G__9544.cljs$core$IFn$_invoke$arity$2 = G__9544__2;
return G__9544;
})()
);

(cljs.core.NodeSeq.prototype.lastIndexOf = (function() {
var G__9546 = null;
var G__9546__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__9546__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__9546 = function(x,start){
switch(arguments.length){
case 1:
return G__9546__1.call(this,x);
case 2:
return G__9546__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9546.cljs$core$IFn$_invoke$arity$1 = G__9546__1;
G__9546.cljs$core$IFn$_invoke$arity$2 = G__9546__2;
return G__9546;
})()
);

(cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.NodeSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
var G__7015 = self__.nodes;
var G__7016 = (self__.i + (2));
var G__7017 = null;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__7015,G__7016,G__7017) : cljs.core.create_inode_seq.call(null,G__7015,G__7016,G__7017));
} else {
var G__7018 = self__.nodes;
var G__7019 = self__.i;
var G__7020 = cljs.core.next(self__.s);
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__7018,G__7019,G__7020) : cljs.core.create_inode_seq.call(null,G__7018,G__7019,G__7020));
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
return (new cljs.core.MapEntry((self__.nodes[self__.i]),(self__.nodes[(self__.i + (1))]),null));
} else {
return cljs.core.first(self__.s);
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var ret = (((self__.s == null))?(function (){var G__7021 = self__.nodes;
var G__7022 = (self__.i + (2));
var G__7023 = null;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__7021,G__7022,G__7023) : cljs.core.create_inode_seq.call(null,G__7021,G__7022,G__7023));
})():(function (){var G__7024 = self__.nodes;
var G__7025 = self__.i;
var G__7026 = cljs.core.next(self__.s);
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__7024,G__7025,G__7026) : cljs.core.create_inode_seq.call(null,G__7024,G__7025,G__7026));
})());
if((!((ret == null)))){
return ret;
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
}));

(cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.NodeSeq(new_meta,self__.nodes,self__.i,self__.s,self__.__hash));
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.NodeSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"nodes","nodes",-459054278,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"s","s",-948495851,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.NodeSeq.cljs$lang$type = true);

(cljs.core.NodeSeq.cljs$lang$ctorStr = "cljs.core/NodeSeq");

(cljs.core.NodeSeq.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/NodeSeq");
}));

/**
 * Positional factory function for cljs.core/NodeSeq.
 */
cljs.core.__GT_NodeSeq = (function cljs$core$__GT_NodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.NodeSeq(meta,nodes,i,s,__hash));
});

(cljs.core.NodeSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));
cljs.core.create_inode_seq = (function cljs$core$create_inode_seq(var_args){
var G__7028 = arguments.length;
switch (G__7028) {
case 1:
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 = (function (nodes){
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(nodes,(0),null);
}));

(cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 = (function (nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
if((!(((nodes[j]) == null)))){
return (new cljs.core.NodeSeq(null,nodes,j,null,null));
} else {
var temp__5802__auto__ = (nodes[(j + (1))]);
if(cljs.core.truth_(temp__5802__auto__)){
var node = temp__5802__auto__;
var temp__5802__auto____$1 = node.inode_seq();
if(cljs.core.truth_(temp__5802__auto____$1)){
var node_seq = temp__5802__auto____$1;
return (new cljs.core.NodeSeq(null,nodes,(j + (2)),node_seq,null));
} else {
var G__9570 = (j + (2));
j = G__9570;
continue;
}
} else {
var G__9571 = (j + (2));
j = G__9571;
continue;
}
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.NodeSeq(null,nodes,i,s,null));
}
}));

(cljs.core.create_inode_seq.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ArrayNodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.ArrayNodeSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.ArrayNodeSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.ArrayNodeSeq.prototype.indexOf = (function() {
var G__9572 = null;
var G__9572__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__9572__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__9572 = function(x,start){
switch(arguments.length){
case 1:
return G__9572__1.call(this,x);
case 2:
return G__9572__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9572.cljs$core$IFn$_invoke$arity$1 = G__9572__1;
G__9572.cljs$core$IFn$_invoke$arity$2 = G__9572__2;
return G__9572;
})()
);

(cljs.core.ArrayNodeSeq.prototype.lastIndexOf = (function() {
var G__9573 = null;
var G__9573__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__9573__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__9573 = function(x,start){
switch(arguments.length){
case 1:
return G__9573__1.call(this,x);
case 2:
return G__9573__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9573.cljs$core$IFn$_invoke$arity$1 = G__9573__1;
G__9573.cljs$core$IFn$_invoke$arity$2 = G__9573__2;
return G__9573;
})()
);

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var G__7029 = self__.nodes;
var G__7030 = self__.i;
var G__7031 = cljs.core.next(self__.s);
return (cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3(G__7029,G__7030,G__7031) : cljs.core.create_array_node_seq.call(null,G__7029,G__7030,G__7031));
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.s);
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var ret = (function (){var G__7032 = self__.nodes;
var G__7033 = self__.i;
var G__7034 = cljs.core.next(self__.s);
return (cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3(G__7032,G__7033,G__7034) : cljs.core.create_array_node_seq.call(null,G__7032,G__7033,G__7034));
})();
if((!((ret == null)))){
return ret;
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.ArrayNodeSeq(new_meta,self__.nodes,self__.i,self__.s,self__.__hash));
}
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.ArrayNodeSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"nodes","nodes",-459054278,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"s","s",-948495851,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ArrayNodeSeq.cljs$lang$type = true);

(cljs.core.ArrayNodeSeq.cljs$lang$ctorStr = "cljs.core/ArrayNodeSeq");

(cljs.core.ArrayNodeSeq.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/ArrayNodeSeq");
}));

/**
 * Positional factory function for cljs.core/ArrayNodeSeq.
 */
cljs.core.__GT_ArrayNodeSeq = (function cljs$core$__GT_ArrayNodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.ArrayNodeSeq(meta,nodes,i,s,__hash));
});

(cljs.core.ArrayNodeSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));
cljs.core.create_array_node_seq = (function cljs$core$create_array_node_seq(var_args){
var G__7036 = arguments.length;
switch (G__7036) {
case 1:
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 = (function (nodes){
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3(nodes,(0),null);
}));

(cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3 = (function (nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
var temp__5802__auto__ = (nodes[j]);
if(cljs.core.truth_(temp__5802__auto__)){
var nj = temp__5802__auto__;
var temp__5802__auto____$1 = nj.inode_seq();
if(cljs.core.truth_(temp__5802__auto____$1)){
var ns = temp__5802__auto____$1;
return (new cljs.core.ArrayNodeSeq(null,nodes,(j + (1)),ns,null));
} else {
var G__9600 = (j + (1));
j = G__9600;
continue;
}
} else {
var G__9601 = (j + (1));
j = G__9601;
continue;
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.ArrayNodeSeq(null,nodes,i,s,null));
}
}));

(cljs.core.create_array_node_seq.cljs$lang$maxFixedArity = 3);


/**
* @constructor
*/
cljs.core.HashMapIter = (function (nil_val,root_iter,seen){
this.nil_val = nil_val;
this.root_iter = root_iter;
this.seen = seen;
});
(cljs.core.HashMapIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (((!(self__.seen))) || (self__.root_iter.hasNext()));
}));

(cljs.core.HashMapIter.prototype.next = (function (){
var self__ = this;
var _ = this;
if((!(self__.seen))){
(self__.seen = true);

return (new cljs.core.MapEntry(null,self__.nil_val,null));
} else {
return self__.root_iter.next();
}
}));

(cljs.core.HashMapIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.HashMapIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"nil-val","nil-val",-513933559,null),new cljs.core.Symbol(null,"root-iter","root-iter",1974672108,null),cljs.core.with_meta(new cljs.core.Symbol(null,"seen","seen",1121531738,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.HashMapIter.cljs$lang$type = true);

(cljs.core.HashMapIter.cljs$lang$ctorStr = "cljs.core/HashMapIter");

(cljs.core.HashMapIter.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/HashMapIter");
}));

/**
 * Positional factory function for cljs.core/HashMapIter.
 */
cljs.core.__GT_HashMapIter = (function cljs$core$__GT_HashMapIter(nil_val,root_iter,seen){
return (new cljs.core.HashMapIter(nil_val,root_iter,seen));
});


/**
* @constructor
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.core.PersistentHashMap = (function (meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
this.meta = meta;
this.cnt = cnt;
this.root = root;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 139268;
});
(cljs.core.PersistentHashMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentHashMap.prototype.cljs$core$IFind$_find$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return (new cljs.core.MapEntry(null,self__.nil_val,null));
} else {
return null;
}
} else {
if((self__.root == null)){
return null;
} else {
return self__.root.inode_find((0),cljs.core.hash(k),k,null);

}
}
}));

(cljs.core.PersistentHashMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentHashMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentHashMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.keys.call(null,coll)));
}));

(cljs.core.PersistentHashMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
}));

(cljs.core.PersistentHashMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.vals.call(null,coll)));
}));

(cljs.core.PersistentHashMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
}));

(cljs.core.PersistentHashMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.PersistentHashMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__7038 = cljs.core.seq(coll);
var chunk__7039 = null;
var count__7040 = (0);
var i__7041 = (0);
while(true){
if((i__7041 < count__7040)){
var vec__7048 = chunk__7039.cljs$core$IIndexed$_nth$arity$2(null,i__7041);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7048,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7048,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__9602 = seq__7038;
var G__9603 = chunk__7039;
var G__9604 = count__7040;
var G__9605 = (i__7041 + (1));
seq__7038 = G__9602;
chunk__7039 = G__9603;
count__7040 = G__9604;
i__7041 = G__9605;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__7038);
if(temp__5804__auto__){
var seq__7038__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__7038__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__7038__$1);
var G__9606 = cljs.core.chunk_rest(seq__7038__$1);
var G__9607 = c__5525__auto__;
var G__9608 = cljs.core.count(c__5525__auto__);
var G__9609 = (0);
seq__7038 = G__9606;
chunk__7039 = G__9607;
count__7040 = G__9608;
i__7041 = G__9609;
continue;
} else {
var vec__7051 = cljs.core.first(seq__7038__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7051,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7051,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__9610 = cljs.core.next(seq__7038__$1);
var G__9611 = null;
var G__9612 = (0);
var G__9613 = (0);
seq__7038 = G__9610;
chunk__7039 = G__9611;
count__7040 = G__9612;
i__7041 = G__9613;
continue;
}
} else {
return null;
}
}
break;
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);

}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var init__$1 = ((self__.has_nil_QMARK_)?(f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(init,null,self__.nil_val) : f.call(null,init,null,self__.nil_val)):init);
if(cljs.core.reduced_QMARK_(init__$1)){
return cljs.core.deref(init__$1);
} else {
if((!((self__.root == null)))){
return cljs.core.unreduced(self__.root.kv_reduce(f,init__$1));
} else {
return init__$1;

}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var root_iter = ((self__.root)?cljs.core._iterator(self__.root):cljs.core.nil_iter());
if(self__.has_nil_QMARK_){
return (new cljs.core.HashMapIter(self__.nil_val,root_iter,false));
} else {
return root_iter;
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentHashMap(self__.meta,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientHashMap(({}),self__.root,self__.cnt,self__.has_nil_QMARK_,self__.nil_val));
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentHashMap.EMPTY,self__.meta);
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),self__.root,false,null,null));
} else {
return coll__$1;
}
} else {
if((self__.root == null)){
return coll__$1;
} else {
var new_root = self__.root.inode_without((0),cljs.core.hash(k),k);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}

}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(((self__.has_nil_QMARK_) && ((v === self__.nil_val)))){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((self__.has_nil_QMARK_)?self__.cnt:(self__.cnt + (1))),self__.root,true,v,null));
}
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var new_root = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc((0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((added_leaf_QMARK_.val)?(self__.cnt + (1)):self__.cnt),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
return self__.has_nil_QMARK_;
} else {
if((self__.root == null)){
return false;
} else {
return (!((self__.root.inode_lookup((0),cljs.core.hash(k),k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)));

}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
var s = (((!((self__.root == null))))?self__.root.inode_seq():null);
if(self__.has_nil_QMARK_){
return cljs.core.cons((new cljs.core.MapEntry(null,self__.nil_val,null)),s);
} else {
return s;
}
} else {
return null;
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(new_meta,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return coll__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry,(0)),cljs.core._nth(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__9616 = cljs.core._assoc(ret,cljs.core._nth(e,(0)),cljs.core._nth(e,(1)));
var G__9617 = cljs.core.next(es);
ret = G__9616;
es = G__9617;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
}));

(cljs.core.PersistentHashMap.prototype.call = (function (unused__10318__auto__){
var self__ = this;
var self__ = this;
var G__7056 = (arguments.length - (1));
switch (G__7056) {
case (1):
return self__.cljs$core$IFn$_invoke$arity$1((arguments[(1)]));

break;
case (2):
return self__.cljs$core$IFn$_invoke$arity$2((arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (1)))].join('')));

}
}));

(cljs.core.PersistentHashMap.prototype.apply = (function (self__,args7037){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args7037)));
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.PersistentHashMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.Symbol(null,"root","root",1191874074,null),cljs.core.with_meta(new cljs.core.Symbol(null,"has-nil?","has-nil?",825886722,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null)], null)),new cljs.core.Symbol(null,"nil-val","nil-val",-513933559,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentHashMap.cljs$lang$type = true);

(cljs.core.PersistentHashMap.cljs$lang$ctorStr = "cljs.core/PersistentHashMap");

(cljs.core.PersistentHashMap.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/PersistentHashMap");
}));

/**
 * Positional factory function for cljs.core/PersistentHashMap.
 */
cljs.core.__GT_PersistentHashMap = (function cljs$core$__GT_PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
return (new cljs.core.PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash));
});

(cljs.core.PersistentHashMap.EMPTY = (new cljs.core.PersistentHashMap(null,(0),null,false,null,cljs.core.empty_unordered_hash)));
(cljs.core.PersistentHashMap.fromArray = (function (arr,no_clone){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
var len = arr__$1.length;
var i = (0);
var ret = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var G__9646 = (i + (2));
var G__9647 = cljs.core._assoc_BANG_(ret,(arr__$1[i]),(arr__$1[(i + (1))]));
i = G__9646;
ret = G__9647;
continue;
} else {
return cljs.core._persistent_BANG_(ret);
}
break;
}
}));
(cljs.core.PersistentHashMap.fromArrays = (function (ks,vs){
var len = ks.length;
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
if((vs.length <= i)){
throw (new Error(["No value supplied for key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((ks[i]))].join('')));
} else {
var G__9648 = (i + (1));
var G__9649 = cljs.core._assoc_BANG_(out,(ks[i]),(vs[i]));
i = G__9648;
out = G__9649;
continue;
}
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
}));
(cljs.core.PersistentHashMap.createWithCheck = (function (arr){
var len = arr.length;
var ret = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
var i_9650 = (0);
while(true){
if((i_9650 < len)){
cljs.core._assoc_BANG_(ret,(arr[i_9650]),(arr[(i_9650 + (1))]));

if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core._count(ret),((i_9650 / (2)) + (1)))){
throw (new Error(["Duplicate key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arr[i_9650]))].join('')));
} else {
var G__9651 = (i_9650 + (2));
i_9650 = G__9651;
continue;
}
} else {
}
break;
}

return cljs.core._persistent_BANG_(ret);
}));
(cljs.core.PersistentHashMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ITransientMap}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientHashMap = (function (edit,root,count,has_nil_QMARK_,nil_val){
this.edit = edit;
this.root = root;
this.count = count;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.cljs$lang$protocol_mask$partition0$ = 259;
this.cljs$lang$protocol_mask$partition1$ = 56;
});
(cljs.core.TransientHashMap.prototype.conj_BANG_ = (function (o){
var self__ = this;
var tcoll = this;
if(self__.edit){
if(cljs.core.map_entry_QMARK_(o)){
return tcoll.assoc_BANG_((cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(o) : cljs.core.key.call(null,o)),(cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(o) : cljs.core.val.call(null,o)));
} else {
if(cljs.core.vector_QMARK_(o)){
return tcoll.assoc_BANG_((o.cljs$core$IFn$_invoke$arity$1 ? o.cljs$core$IFn$_invoke$arity$1((0)) : o.call(null,(0))),(o.cljs$core$IFn$_invoke$arity$1 ? o.cljs$core$IFn$_invoke$arity$1((1)) : o.call(null,(1))));
} else {
var es = cljs.core.seq(o);
var tcoll__$1 = tcoll;
while(true){
var temp__5802__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__5802__auto__)){
var e = temp__5802__auto__;
var G__9652 = cljs.core.next(es);
var G__9653 = tcoll__$1.assoc_BANG_((cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.key.call(null,e)),(cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.val.call(null,e)));
es = G__9652;
tcoll__$1 = G__9653;
continue;
} else {
return tcoll__$1;
}
break;
}

}
}
} else {
throw (new Error("conj! after persistent"));
}
}));

(cljs.core.TransientHashMap.prototype.assoc_BANG_ = (function (k,v){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if((self__.nil_val === v)){
} else {
(self__.nil_val = v);
}

if(self__.has_nil_QMARK_){
} else {
(self__.count = (self__.count + (1)));

(self__.has_nil_QMARK_ = true);
}

return tcoll;
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var node = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc_BANG_(self__.edit,(0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((node === self__.root)){
} else {
(self__.root = node);
}

if(added_leaf_QMARK_.val){
(self__.count = (self__.count + (1)));
} else {
}

return tcoll;
}
} else {
throw (new Error("assoc! after persistent!"));
}
}));

(cljs.core.TransientHashMap.prototype.without_BANG_ = (function (k){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if(self__.has_nil_QMARK_){
(self__.has_nil_QMARK_ = false);

(self__.nil_val = null);

(self__.count = (self__.count - (1)));

return tcoll;
} else {
return tcoll;
}
} else {
if((self__.root == null)){
return tcoll;
} else {
var removed_leaf_QMARK_ = (new cljs.core.Box(false));
var node = self__.root.inode_without_BANG_(self__.edit,(0),cljs.core.hash(k),k,removed_leaf_QMARK_);
if((node === self__.root)){
} else {
(self__.root = node);
}

if(removed_leaf_QMARK_.val){
(self__.count = (self__.count - (1)));
} else {
}

return tcoll;
}
}
} else {
throw (new Error("dissoc! after persistent!"));
}
}));

(cljs.core.TransientHashMap.prototype.persistent_BANG_ = (function (){
var self__ = this;
var tcoll = this;
if(self__.edit){
(self__.edit = null);

return (new cljs.core.PersistentHashMap(null,self__.count,self__.root,self__.has_nil_QMARK_,self__.nil_val,null));
} else {
throw (new Error("persistent! called twice"));
}
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(self__.edit){
return self__.count;
} else {
throw (new Error("count after persistent!"));
}
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,k){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return null;
}
} else {
if((self__.root == null)){
return null;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k);
}
}
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);
}
}
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.conj_BANG_(val);
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.persistent_BANG_();
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.assoc_BANG_(key,val);
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function (tcoll,key){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.without_BANG_(key);
}));

(cljs.core.TransientHashMap.prototype.call = (function (unused__10318__auto__){
var self__ = this;
var self__ = this;
var G__7058 = (arguments.length - (1));
switch (G__7058) {
case (1):
return self__.cljs$core$IFn$_invoke$arity$1((arguments[(1)]));

break;
case (2):
return self__.cljs$core$IFn$_invoke$arity$2((arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (1)))].join('')));

}
}));

(cljs.core.TransientHashMap.prototype.apply = (function (self__,args7057){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args7057)));
}));

(cljs.core.TransientHashMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (key){
var self__ = this;
var tcoll = this;
return tcoll.cljs$core$ILookup$_lookup$arity$2(null,key);
}));

(cljs.core.TransientHashMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (key,not_found){
var self__ = this;
var tcoll = this;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,not_found);
}));

(cljs.core.TransientHashMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"edit","edit",-1302639,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"root","root",1191874074,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"has-nil?","has-nil?",825886722,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"nil-val","nil-val",-513933559,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.TransientHashMap.cljs$lang$type = true);

(cljs.core.TransientHashMap.cljs$lang$ctorStr = "cljs.core/TransientHashMap");

(cljs.core.TransientHashMap.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/TransientHashMap");
}));

/**
 * Positional factory function for cljs.core/TransientHashMap.
 */
cljs.core.__GT_TransientHashMap = (function cljs$core$__GT_TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val){
return (new cljs.core.TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val));
});

cljs.core.tree_map_seq_push = (function cljs$core$tree_map_seq_push(node,stack,ascending_QMARK_){
var t = node;
var stack__$1 = stack;
while(true){
if((!((t == null)))){
var G__9666 = ((ascending_QMARK_)?t.left:t.right);
var G__9667 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack__$1,t);
t = G__9666;
stack__$1 = G__9667;
continue;
} else {
return stack__$1;
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentTreeMapSeq = (function (meta,stack,ascending_QMARK_,cnt,__hash){
this.meta = meta;
this.stack = stack;
this.ascending_QMARK_ = ascending_QMARK_;
this.cnt = cnt;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.PersistentTreeMapSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentTreeMapSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentTreeMapSeq.prototype.indexOf = (function() {
var G__9668 = null;
var G__9668__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__9668__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__9668 = function(x,start){
switch(arguments.length){
case 1:
return G__9668__1.call(this,x);
case 2:
return G__9668__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9668.cljs$core$IFn$_invoke$arity$1 = G__9668__1;
G__9668.cljs$core$IFn$_invoke$arity$2 = G__9668__2;
return G__9668;
})()
);

(cljs.core.PersistentTreeMapSeq.prototype.lastIndexOf = (function() {
var G__9669 = null;
var G__9669__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__9669__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__9669 = function(x,start){
switch(arguments.length){
case 1:
return G__9669__1.call(this,x);
case 2:
return G__9669__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9669.cljs$core$IFn$_invoke$arity$1 = G__9669__1;
G__9669.cljs$core$IFn$_invoke$arity$2 = G__9669__2;
return G__9669;
})()
);

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$INext$_next$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var t = cljs.core.first(self__.stack);
var next_stack = cljs.core.tree_map_seq_push(((self__.ascending_QMARK_)?t.right:t.left),cljs.core.next(self__.stack),self__.ascending_QMARK_);
if((next_stack == null)){
return null;
} else {
return (new cljs.core.PersistentTreeMapSeq(null,next_stack,self__.ascending_QMARK_,(self__.cnt - (1)),null));
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt < (0))){
return (cljs.core.count(cljs.core.next(coll__$1)) + (1));
} else {
return self__.cnt;
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.peek(self__.stack);
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var t = cljs.core.first(self__.stack);
var next_stack = cljs.core.tree_map_seq_push(((self__.ascending_QMARK_)?t.right:t.left),cljs.core.next(self__.stack),self__.ascending_QMARK_);
if((!((next_stack == null)))){
return (new cljs.core.PersistentTreeMapSeq(null,next_stack,self__.ascending_QMARK_,(self__.cnt - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMapSeq(new_meta,self__.stack,self__.ascending_QMARK_,self__.cnt,self__.__hash));
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.PersistentTreeMapSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"stack","stack",847125597,null),cljs.core.with_meta(new cljs.core.Symbol(null,"ascending?","ascending?",-1938452653,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null)], null)),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentTreeMapSeq.cljs$lang$type = true);

(cljs.core.PersistentTreeMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentTreeMapSeq");

(cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/PersistentTreeMapSeq");
}));

/**
 * Positional factory function for cljs.core/PersistentTreeMapSeq.
 */
cljs.core.__GT_PersistentTreeMapSeq = (function cljs$core$__GT_PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash){
return (new cljs.core.PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash));
});

(cljs.core.PersistentTreeMapSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));
cljs.core.create_tree_map_seq = (function cljs$core$create_tree_map_seq(tree,ascending_QMARK_,cnt){
return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.tree_map_seq_push(tree,null,ascending_QMARK_),ascending_QMARK_,cnt,null));
});

cljs.core.balance_left = (function cljs$core$balance_left(key,val,ins,right){
if((ins instanceof cljs.core.RedNode)){
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,ins.left.blacken(),(new cljs.core.BlackNode(key,val,ins.right,right,null)),null));
} else {
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.right.key,ins.right.val,(new cljs.core.BlackNode(ins.key,ins.val,ins.left,ins.right.left,null)),(new cljs.core.BlackNode(key,val,ins.right.right,right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));
}
});
cljs.core.balance_right = (function cljs$core$balance_right(key,val,left,ins){
if((ins instanceof cljs.core.RedNode)){
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,(new cljs.core.BlackNode(key,val,left,ins.left,null)),ins.right.blacken(),null));
} else {
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.left.key,ins.left.val,(new cljs.core.BlackNode(key,val,left,ins.left.left,null)),(new cljs.core.BlackNode(ins.key,ins.val,ins.left.right,ins.right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));
}
});
cljs.core.balance_left_del = (function cljs$core$balance_left_del(key,val,del,right){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,del.blacken(),right,null));
} else {
if((right instanceof cljs.core.BlackNode)){
return cljs.core.balance_right(key,val,del,right.redden());
} else {
if((((right instanceof cljs.core.RedNode)) && ((right.left instanceof cljs.core.BlackNode)))){
return (new cljs.core.RedNode(right.left.key,right.left.val,(new cljs.core.BlackNode(key,val,del,right.left.left,null)),cljs.core.balance_right(right.key,right.val,right.left.right,right.right.redden()),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.balance_right_del = (function cljs$core$balance_right_del(key,val,left,del){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,left,del.blacken(),null));
} else {
if((left instanceof cljs.core.BlackNode)){
return cljs.core.balance_left(key,val,left.redden(),del);
} else {
if((((left instanceof cljs.core.RedNode)) && ((left.right instanceof cljs.core.BlackNode)))){
return (new cljs.core.RedNode(left.right.key,left.right.val,cljs.core.balance_left(left.key,left.val,left.left.redden(),left.right.left),(new cljs.core.BlackNode(key,val,left.right.right,del,null)),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.tree_map_kv_reduce = (function cljs$core$tree_map_kv_reduce(node,f,init){
var init__$1 = (((!((node.left == null))))?(function (){var G__7059 = node.left;
var G__7060 = f;
var G__7061 = init;
return (cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3(G__7059,G__7060,G__7061) : cljs.core.tree_map_kv_reduce.call(null,G__7059,G__7060,G__7061));
})():init);
if(cljs.core.reduced_QMARK_(init__$1)){
return init__$1;
} else {
var init__$2 = (function (){var G__7062 = init__$1;
var G__7063 = node.key;
var G__7064 = node.val;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__7062,G__7063,G__7064) : f.call(null,G__7062,G__7063,G__7064));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return init__$2;
} else {
if((!((node.right == null)))){
var G__7065 = node.right;
var G__7066 = f;
var G__7067 = init__$2;
return (cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3(G__7065,G__7066,G__7067) : cljs.core.tree_map_kv_reduce.call(null,G__7065,G__7066,G__7067));
} else {
return init__$2;
}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.BlackNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 166619935;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.BlackNode.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.BlackNode.prototype.cljs$core$IFind$_find$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
var G__7069 = k;
switch (G__7069) {
case (0):
return (new cljs.core.MapEntry((0),self__.key,null));

break;
case (1):
return (new cljs.core.MapEntry((1),self__.val,null));

break;
default:
return null;

}
}));

(cljs.core.BlackNode.prototype.lastIndexOf = (function() {
var G__9691 = null;
var G__9691__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__9691__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__9691 = function(x,start){
switch(arguments.length){
case 1:
return G__9691__1.call(this,x);
case 2:
return G__9691__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9691.cljs$core$IFn$_invoke$arity$1 = G__9691__1;
G__9691.cljs$core$IFn$_invoke$arity$2 = G__9691__2;
return G__9691;
})()
);

(cljs.core.BlackNode.prototype.indexOf = (function() {
var G__9692 = null;
var G__9692__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__9692__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__9692 = function(x,start){
switch(arguments.length){
case 1:
return G__9692__1.call(this,x);
case 2:
return G__9692__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9692.cljs$core$IFn$_invoke$arity$1 = G__9692__1;
G__9692.cljs$core$IFn$_invoke$arity$2 = G__9692__2;
return G__9692;
})()
);

(cljs.core.BlackNode.prototype.add_right = (function (ins){
var self__ = this;
var node = this;
return ins.balance_right(node);
}));

(cljs.core.BlackNode.prototype.redden = (function (){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,self__.right,null));
}));

(cljs.core.BlackNode.prototype.blacken = (function (){
var self__ = this;
var node = this;
return node;
}));

(cljs.core.BlackNode.prototype.add_left = (function (ins){
var self__ = this;
var node = this;
return ins.balance_left(node);
}));

(cljs.core.BlackNode.prototype.replace = (function (key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(key__$1,val__$1,left__$1,right__$1,null));
}));

(cljs.core.BlackNode.prototype.balance_left = (function (parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));
}));

(cljs.core.BlackNode.prototype.balance_right = (function (parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));
}));

(cljs.core.BlackNode.prototype.remove_left = (function (del){
var self__ = this;
var node = this;
return cljs.core.balance_left_del(self__.key,self__.val,del,self__.right);
}));

(cljs.core.BlackNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
}));

(cljs.core.BlackNode.prototype.remove_right = (function (del){
var self__ = this;
var node = this;
return cljs.core.balance_right_del(self__.key,self__.val,self__.left,del);
}));

(cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,null);
}));

(cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
throw (new Error("Index out of bounds"));

}
}
}));

(cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
}));

(cljs.core.BlackNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
}));

(cljs.core.BlackNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.BlackNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (2);
}));

(cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.key;
}));

(cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.BlackNode.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.BlackNode.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
}));

(cljs.core.BlackNode.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.val,self__.key],(0),null));
}));

(cljs.core.BlackNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.BlackNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
}));

(cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
}));

(cljs.core.BlackNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
}));

(cljs.core.BlackNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return (((k === (0))) || ((k === (1))));
}));

(cljs.core.BlackNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.key,self__.val],(0),null));
}));

(cljs.core.BlackNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core._with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
}));

(cljs.core.BlackNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
}));

(cljs.core.BlackNode.prototype.call = (function (unused__10318__auto__){
var self__ = this;
var self__ = this;
var G__7070 = (arguments.length - (1));
switch (G__7070) {
case (1):
return self__.cljs$core$IFn$_invoke$arity$1((arguments[(1)]));

break;
case (2):
return self__.cljs$core$IFn$_invoke$arity$2((arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (1)))].join('')));

}
}));

(cljs.core.BlackNode.prototype.apply = (function (self__,args7068){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args7068)));
}));

(cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
}));

(cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.BlackNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"left","left",1241415590,null),new cljs.core.Symbol(null,"right","right",1187949694,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.BlackNode.cljs$lang$type = true);

(cljs.core.BlackNode.cljs$lang$ctorStr = "cljs.core/BlackNode");

(cljs.core.BlackNode.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/BlackNode");
}));

/**
 * Positional factory function for cljs.core/BlackNode.
 */
cljs.core.__GT_BlackNode = (function cljs$core$__GT_BlackNode(key,val,left,right,__hash){
return (new cljs.core.BlackNode(key,val,left,right,__hash));
});

(cljs.core.BlackNode.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.RedNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 166619935;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.RedNode.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.RedNode.prototype.cljs$core$IFind$_find$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
var G__7072 = k;
switch (G__7072) {
case (0):
return (new cljs.core.MapEntry((0),self__.key,null));

break;
case (1):
return (new cljs.core.MapEntry((1),self__.val,null));

break;
default:
return null;

}
}));

(cljs.core.RedNode.prototype.lastIndexOf = (function() {
var G__9703 = null;
var G__9703__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__9703__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__9703 = function(x,start){
switch(arguments.length){
case 1:
return G__9703__1.call(this,x);
case 2:
return G__9703__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9703.cljs$core$IFn$_invoke$arity$1 = G__9703__1;
G__9703.cljs$core$IFn$_invoke$arity$2 = G__9703__2;
return G__9703;
})()
);

(cljs.core.RedNode.prototype.indexOf = (function() {
var G__9704 = null;
var G__9704__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__9704__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__9704 = function(x,start){
switch(arguments.length){
case 1:
return G__9704__1.call(this,x);
case 2:
return G__9704__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9704.cljs$core$IFn$_invoke$arity$1 = G__9704__1;
G__9704.cljs$core$IFn$_invoke$arity$2 = G__9704__2;
return G__9704;
})()
);

(cljs.core.RedNode.prototype.add_right = (function (ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,ins,null));
}));

(cljs.core.RedNode.prototype.redden = (function (){
var self__ = this;
var node = this;
throw (new Error("red-black tree invariant violation"));
}));

(cljs.core.RedNode.prototype.blacken = (function (){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right,null));
}));

(cljs.core.RedNode.prototype.add_left = (function (ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,ins,self__.right,null));
}));

(cljs.core.RedNode.prototype.replace = (function (key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(key__$1,val__$1,left__$1,right__$1,null));
}));

(cljs.core.RedNode.prototype.balance_left = (function (parent){
var self__ = this;
var node = this;
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,self__.left.blacken(),(new cljs.core.BlackNode(parent.key,parent.val,self__.right,parent.right,null)),null));
} else {
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.right.key,self__.right.val,(new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right.left,null)),(new cljs.core.BlackNode(parent.key,parent.val,self__.right.right,parent.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));

}
}
}));

(cljs.core.RedNode.prototype.balance_right = (function (parent){
var self__ = this;
var node = this;
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left,null)),self__.right.blacken(),null));
} else {
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.left.key,self__.left.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left.left,null)),(new cljs.core.BlackNode(self__.key,self__.val,self__.left.right,self__.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));

}
}
}));

(cljs.core.RedNode.prototype.remove_left = (function (del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,del,self__.right,null));
}));

(cljs.core.RedNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
}));

(cljs.core.RedNode.prototype.remove_right = (function (del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,del,null));
}));

(cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,null);
}));

(cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
throw (new Error("Index out of bounds"));

}
}
}));

(cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
}));

(cljs.core.RedNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
}));

(cljs.core.RedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.RedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (2);
}));

(cljs.core.RedNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.key;
}));

(cljs.core.RedNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.RedNode.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.RedNode.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
}));

(cljs.core.RedNode.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.val,self__.key],(0),null));
}));

(cljs.core.RedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.RedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
}));

(cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
}));

(cljs.core.RedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
}));

(cljs.core.RedNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return (((k === (0))) || ((k === (1))));
}));

(cljs.core.RedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.key,self__.val],(0),null));
}));

(cljs.core.RedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core._with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
}));

(cljs.core.RedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
}));

(cljs.core.RedNode.prototype.call = (function (unused__10318__auto__){
var self__ = this;
var self__ = this;
var G__7073 = (arguments.length - (1));
switch (G__7073) {
case (1):
return self__.cljs$core$IFn$_invoke$arity$1((arguments[(1)]));

break;
case (2):
return self__.cljs$core$IFn$_invoke$arity$2((arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (1)))].join('')));

}
}));

(cljs.core.RedNode.prototype.apply = (function (self__,args7071){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args7071)));
}));

(cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
}));

(cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.RedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"left","left",1241415590,null),new cljs.core.Symbol(null,"right","right",1187949694,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.RedNode.cljs$lang$type = true);

(cljs.core.RedNode.cljs$lang$ctorStr = "cljs.core/RedNode");

(cljs.core.RedNode.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/RedNode");
}));

/**
 * Positional factory function for cljs.core/RedNode.
 */
cljs.core.__GT_RedNode = (function cljs$core$__GT_RedNode(key,val,left,right,__hash){
return (new cljs.core.RedNode(key,val,left,right,__hash));
});

(cljs.core.RedNode.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));
cljs.core.tree_map_add = (function cljs$core$tree_map_add(comp,tree,k,v,found){
if((tree == null)){
return (new cljs.core.RedNode(k,v,null,null,null));
} else {
var c = (function (){var G__7074 = k;
var G__7075 = tree.key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__7074,G__7075) : comp.call(null,G__7074,G__7075));
})();
if((c === (0))){
(found[(0)] = tree);

return null;
} else {
if((c < (0))){
var ins = (function (){var G__7076 = comp;
var G__7077 = tree.left;
var G__7078 = k;
var G__7079 = v;
var G__7080 = found;
return (cljs.core.tree_map_add.cljs$core$IFn$_invoke$arity$5 ? cljs.core.tree_map_add.cljs$core$IFn$_invoke$arity$5(G__7076,G__7077,G__7078,G__7079,G__7080) : cljs.core.tree_map_add.call(null,G__7076,G__7077,G__7078,G__7079,G__7080));
})();
if((!((ins == null)))){
return tree.add_left(ins);
} else {
return null;
}
} else {
var ins = (function (){var G__7081 = comp;
var G__7082 = tree.right;
var G__7083 = k;
var G__7084 = v;
var G__7085 = found;
return (cljs.core.tree_map_add.cljs$core$IFn$_invoke$arity$5 ? cljs.core.tree_map_add.cljs$core$IFn$_invoke$arity$5(G__7081,G__7082,G__7083,G__7084,G__7085) : cljs.core.tree_map_add.call(null,G__7081,G__7082,G__7083,G__7084,G__7085));
})();
if((!((ins == null)))){
return tree.add_right(ins);
} else {
return null;
}

}
}
}
});
cljs.core.tree_map_append = (function cljs$core$tree_map_append(left,right){
if((left == null)){
return right;
} else {
if((right == null)){
return left;
} else {
if((left instanceof cljs.core.RedNode)){
if((right instanceof cljs.core.RedNode)){
var app = (function (){var G__7086 = left.right;
var G__7087 = right.left;
return (cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2 ? cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2(G__7086,G__7087) : cljs.core.tree_map_append.call(null,G__7086,G__7087));
})();
if((app instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(app.key,app.val,(new cljs.core.RedNode(left.key,left.val,left.left,app.left,null)),(new cljs.core.RedNode(right.key,right.val,app.right,right.right,null)),null));
} else {
return (new cljs.core.RedNode(left.key,left.val,left.left,(new cljs.core.RedNode(right.key,right.val,app,right.right,null)),null));
}
} else {
return (new cljs.core.RedNode(left.key,left.val,left.left,(function (){var G__7088 = left.right;
var G__7089 = right;
return (cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2 ? cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2(G__7088,G__7089) : cljs.core.tree_map_append.call(null,G__7088,G__7089));
})(),null));
}
} else {
if((right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(right.key,right.val,(function (){var G__7090 = left;
var G__7091 = right.left;
return (cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2 ? cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2(G__7090,G__7091) : cljs.core.tree_map_append.call(null,G__7090,G__7091));
})(),right.right,null));
} else {
var app = (function (){var G__7092 = left.right;
var G__7093 = right.left;
return (cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2 ? cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2(G__7092,G__7093) : cljs.core.tree_map_append.call(null,G__7092,G__7093));
})();
if((app instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(app.key,app.val,(new cljs.core.BlackNode(left.key,left.val,left.left,app.left,null)),(new cljs.core.BlackNode(right.key,right.val,app.right,right.right,null)),null));
} else {
return cljs.core.balance_left_del(left.key,left.val,left.left,(new cljs.core.BlackNode(right.key,right.val,app,right.right,null)));
}

}
}
}
}
});
cljs.core.tree_map_remove = (function cljs$core$tree_map_remove(comp,tree,k,found){
if((!((tree == null)))){
var c = (function (){var G__7094 = k;
var G__7095 = tree.key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__7094,G__7095) : comp.call(null,G__7094,G__7095));
})();
if((c === (0))){
(found[(0)] = tree);

return cljs.core.tree_map_append(tree.left,tree.right);
} else {
if((c < (0))){
var del = (function (){var G__7096 = comp;
var G__7097 = tree.left;
var G__7098 = k;
var G__7099 = found;
return (cljs.core.tree_map_remove.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tree_map_remove.cljs$core$IFn$_invoke$arity$4(G__7096,G__7097,G__7098,G__7099) : cljs.core.tree_map_remove.call(null,G__7096,G__7097,G__7098,G__7099));
})();
if((((!((del == null)))) || ((!(((found[(0)]) == null)))))){
if((tree.left instanceof cljs.core.BlackNode)){
return cljs.core.balance_left_del(tree.key,tree.val,del,tree.right);
} else {
return (new cljs.core.RedNode(tree.key,tree.val,del,tree.right,null));
}
} else {
return null;
}
} else {
var del = (function (){var G__7100 = comp;
var G__7101 = tree.right;
var G__7102 = k;
var G__7103 = found;
return (cljs.core.tree_map_remove.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tree_map_remove.cljs$core$IFn$_invoke$arity$4(G__7100,G__7101,G__7102,G__7103) : cljs.core.tree_map_remove.call(null,G__7100,G__7101,G__7102,G__7103));
})();
if((((!((del == null)))) || ((!(((found[(0)]) == null)))))){
if((tree.right instanceof cljs.core.BlackNode)){
return cljs.core.balance_right_del(tree.key,tree.val,tree.left,del);
} else {
return (new cljs.core.RedNode(tree.key,tree.val,tree.left,del,null));
}
} else {
return null;
}

}
}
} else {
return null;
}
});
cljs.core.tree_map_replace = (function cljs$core$tree_map_replace(comp,tree,k,v){
var tk = tree.key;
var c = (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(k,tk) : comp.call(null,k,tk));
if((c === (0))){
return tree.replace(tk,v,tree.left,tree.right);
} else {
if((c < (0))){
return tree.replace(tk,tree.val,(function (){var G__7104 = comp;
var G__7105 = tree.left;
var G__7106 = k;
var G__7107 = v;
return (cljs.core.tree_map_replace.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tree_map_replace.cljs$core$IFn$_invoke$arity$4(G__7104,G__7105,G__7106,G__7107) : cljs.core.tree_map_replace.call(null,G__7104,G__7105,G__7106,G__7107));
})(),tree.right);
} else {
return tree.replace(tk,tree.val,tree.left,(function (){var G__7108 = comp;
var G__7109 = tree.right;
var G__7110 = k;
var G__7111 = v;
return (cljs.core.tree_map_replace.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tree_map_replace.cljs$core$IFn$_invoke$arity$4(G__7108,G__7109,G__7110,G__7111) : cljs.core.tree_map_replace.call(null,G__7108,G__7109,G__7110,G__7111));
})());

}
}
});

/**
* @constructor
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.core.PersistentTreeMap = (function (comp,tree,cnt,meta,__hash){
this.comp = comp;
this.tree = tree;
this.cnt = cnt;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 418776847;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
(cljs.core.PersistentTreeMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentTreeMap.prototype.cljs$core$IFind$_find$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.entry_at(k);
}));

(cljs.core.PersistentTreeMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__7113 = cljs.core.seq(coll);
var chunk__7114 = null;
var count__7115 = (0);
var i__7116 = (0);
while(true){
if((i__7116 < count__7115)){
var vec__7123 = chunk__7114.cljs$core$IIndexed$_nth$arity$2(null,i__7116);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7123,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7123,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__9723 = seq__7113;
var G__9724 = chunk__7114;
var G__9725 = count__7115;
var G__9726 = (i__7116 + (1));
seq__7113 = G__9723;
chunk__7114 = G__9724;
count__7115 = G__9725;
i__7116 = G__9726;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__7113);
if(temp__5804__auto__){
var seq__7113__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__7113__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__7113__$1);
var G__9727 = cljs.core.chunk_rest(seq__7113__$1);
var G__9728 = c__5525__auto__;
var G__9729 = cljs.core.count(c__5525__auto__);
var G__9730 = (0);
seq__7113 = G__9727;
chunk__7114 = G__9728;
count__7115 = G__9729;
i__7116 = G__9730;
continue;
} else {
var vec__7126 = cljs.core.first(seq__7113__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7126,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7126,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__9731 = cljs.core.next(seq__7113__$1);
var G__9732 = null;
var G__9733 = (0);
var G__9734 = (0);
seq__7113 = G__9731;
chunk__7114 = G__9732;
count__7115 = G__9733;
i__7116 = G__9734;
continue;
}
} else {
return null;
}
}
break;
}
}));

(cljs.core.PersistentTreeMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.PersistentTreeMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
}));

(cljs.core.PersistentTreeMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentTreeMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.keys.call(null,coll)));
}));

(cljs.core.PersistentTreeMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.vals.call(null,coll)));
}));

(cljs.core.PersistentTreeMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentTreeMap.prototype.entry_at = (function (k){
var self__ = this;
var coll = this;
var t = self__.tree;
while(true){
if((!((t == null)))){
var c = (function (){var G__7129 = k;
var G__7130 = t.key;
return (self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__7129,G__7130) : self__.comp.call(null,G__7129,G__7130));
})();
if((c === (0))){
return t;
} else {
if((c < (0))){
var G__9736 = t.left;
t = G__9736;
continue;
} else {
var G__9737 = t.right;
t = G__9737;
continue;

}
}
} else {
return null;
}
break;
}
}));

(cljs.core.PersistentTreeMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
var n = coll__$1.entry_at(k);
if((!((n == null)))){
return n.val;
} else {
return not_found;
}
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
if((!((self__.tree == null)))){
return cljs.core.unreduced(cljs.core.tree_map_kv_reduce(self__.tree,f,init));
} else {
return init;
}
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,self__.tree,self__.cnt,self__.meta,self__.__hash));
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,false,self__.cnt);
} else {
return null;
}
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,null,(0),self__.meta,(0)));
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
var found = [null];
var t = cljs.core.tree_map_remove(self__.comp,self__.tree,k,found);
if((t == null)){
if((cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found,(0)) == null)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,null,(0),self__.meta,null));
}
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,t.blacken(),(self__.cnt - (1)),self__.meta,null));
}
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
var found = [null];
var t = cljs.core.tree_map_add(self__.comp,self__.tree,k,v,found);
if((t == null)){
var found_node = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found,(0));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(v,found_node.val)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,cljs.core.tree_map_replace(self__.comp,self__.tree,k,v),self__.cnt,self__.meta,null));
}
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,t.blacken(),(self__.cnt + (1)),self__.meta,null));
}
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return (!((coll__$1.entry_at(k) == null)));
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,true,self__.cnt);
} else {
return null;
}
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,self__.tree,self__.cnt,new_meta,self__.__hash));
}
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return coll__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry,(0)),cljs.core._nth(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__9748 = cljs.core._assoc(ret,cljs.core._nth(e,(0)),cljs.core._nth(e,(1)));
var G__9749 = cljs.core.next(es);
ret = G__9748;
es = G__9749;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
}));

(cljs.core.PersistentTreeMap.prototype.call = (function (unused__10318__auto__){
var self__ = this;
var self__ = this;
var G__7131 = (arguments.length - (1));
switch (G__7131) {
case (1):
return self__.cljs$core$IFn$_invoke$arity$1((arguments[(1)]));

break;
case (2):
return self__.cljs$core$IFn$_invoke$arity$2((arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (1)))].join('')));

}
}));

(cljs.core.PersistentTreeMap.prototype.apply = (function (self__,args7112){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args7112)));
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (coll,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,ascending_QMARK_,self__.cnt);
} else {
return null;
}
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (coll,k,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
var stack = null;
var t = self__.tree;
while(true){
if((!((t == null)))){
var c = (function (){var G__7134 = k;
var G__7135 = t.key;
return (self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__7134,G__7135) : self__.comp.call(null,G__7134,G__7135));
})();
if((c === (0))){
return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t),ascending_QMARK_,(-1),null));
} else {
if(cljs.core.truth_(ascending_QMARK_)){
if((c < (0))){
var G__9760 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t);
var G__9761 = t.left;
stack = G__9760;
t = G__9761;
continue;
} else {
var G__9762 = stack;
var G__9763 = t.right;
stack = G__9762;
t = G__9763;
continue;
}
} else {
if((c > (0))){
var G__9764 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t);
var G__9765 = t.right;
stack = G__9764;
t = G__9765;
continue;
} else {
var G__9766 = stack;
var G__9767 = t.left;
stack = G__9766;
t = G__9767;
continue;
}

}
}
} else {
if((stack == null)){
return null;
} else {
return (new cljs.core.PersistentTreeMapSeq(null,stack,ascending_QMARK_,(-1),null));
}
}
break;
}
} else {
return null;
}
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(entry) : cljs.core.key.call(null,entry));
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.comp;
}));

(cljs.core.PersistentTreeMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"comp","comp",-1462482139,null),new cljs.core.Symbol(null,"tree","tree",1444219499,null),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentTreeMap.cljs$lang$type = true);

(cljs.core.PersistentTreeMap.cljs$lang$ctorStr = "cljs.core/PersistentTreeMap");

(cljs.core.PersistentTreeMap.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/PersistentTreeMap");
}));

/**
 * Positional factory function for cljs.core/PersistentTreeMap.
 */
cljs.core.__GT_PersistentTreeMap = (function cljs$core$__GT_PersistentTreeMap(comp,tree,cnt,meta,__hash){
return (new cljs.core.PersistentTreeMap(comp,tree,cnt,meta,__hash));
});

(cljs.core.PersistentTreeMap.EMPTY = (new cljs.core.PersistentTreeMap(cljs.core.compare,null,(0),null,cljs.core.empty_unordered_hash)));
(cljs.core.PersistentTreeMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));
/**
 * keyval => key val
 *   Returns a new hash map with supplied mappings.
 */
cljs.core.hash_map = (function cljs$core$hash_map(var_args){
var args__5732__auto__ = [];
var len__5726__auto___9778 = arguments.length;
var i__5727__auto___9779 = (0);
while(true){
if((i__5727__auto___9779 < len__5726__auto___9778)){
args__5732__auto__.push((arguments[i__5727__auto___9779]));

var G__9780 = (i__5727__auto___9779 + (1));
i__5727__auto___9779 = G__9780;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((0) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((0)),(0),null)):null);
return cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic(argseq__5733__auto__);
});

(cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if(in$){
var in_SINGLEQUOTE_ = cljs.core.next(in$);
if((in_SINGLEQUOTE_ == null)){
throw (new Error(["No value supplied for key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(in$))].join('')));
} else {
var G__9785 = cljs.core.next(in_SINGLEQUOTE_);
var G__9786 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.first(in_SINGLEQUOTE_));
in$ = G__9785;
out = G__9786;
continue;
}
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
}));

(cljs.core.hash_map.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(cljs.core.hash_map.cljs$lang$applyTo = (function (seq7136){
var self__5712__auto__ = this;
return self__5712__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq7136));
}));

/**
 * keyval => key val
 *   Returns a new array map with supplied mappings.
 */
cljs.core.array_map = (function cljs$core$array_map(var_args){
var args__5732__auto__ = [];
var len__5726__auto___9793 = arguments.length;
var i__5727__auto___9794 = (0);
while(true){
if((i__5727__auto___9794 < len__5726__auto___9793)){
args__5732__auto__.push((arguments[i__5727__auto___9794]));

var G__9795 = (i__5727__auto___9794 + (1));
i__5727__auto___9794 = G__9795;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((0) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((0)),(0),null)):null);
return cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic(argseq__5733__auto__);
});

(cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var arr = (((((keyvals instanceof cljs.core.IndexedSeq)) && ((keyvals.i === (0)))))?keyvals.arr:cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(keyvals));
if(cljs.core.odd_QMARK_(arr.length)){
throw (new Error(["No value supplied for key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last(arr))].join('')));
} else {
return cljs.core.PersistentArrayMap.createAsIfByAssoc(arr);
}
}));

(cljs.core.array_map.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(cljs.core.array_map.cljs$lang$applyTo = (function (seq7137){
var self__5712__auto__ = this;
return self__5712__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq7137));
}));

/**
 * Builds a map from a seq as described in
 *   https://clojure.org/reference/special_forms#keyword-arguments
 */
cljs.core.seq_to_map_for_destructuring = (function cljs$core$seq_to_map_for_destructuring(s){
if(cljs.core.next(s)){
return cljs.core.PersistentArrayMap.createAsIfByAssoc(cljs.core.to_array(s));
} else {
if(cljs.core.seq(s)){
return cljs.core.first(s);
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
}
});
/**
 * keyval => key val
 *   Returns a new object map with supplied mappings.
 */
cljs.core.obj_map = (function cljs$core$obj_map(var_args){
var args__5732__auto__ = [];
var len__5726__auto___9799 = arguments.length;
var i__5727__auto___9800 = (0);
while(true){
if((i__5727__auto___9800 < len__5726__auto___9799)){
args__5732__auto__.push((arguments[i__5727__auto___9800]));

var G__9802 = (i__5727__auto___9800 + (1));
i__5727__auto___9800 = G__9802;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((0) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((0)),(0),null)):null);
return cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic(argseq__5733__auto__);
});

(cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var ks = [];
var obj = ({});
var kvs = cljs.core.seq(keyvals);
while(true){
if(kvs){
ks.push(cljs.core.first(kvs));

cljs.core.goog$module$goog$object.set(obj,cljs.core.first(kvs),cljs.core.second(kvs));

var G__9805 = cljs.core.nnext(kvs);
kvs = G__9805;
continue;
} else {
return cljs.core.ObjMap.fromObject(ks,obj);
}
break;
}
}));

(cljs.core.obj_map.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(cljs.core.obj_map.cljs$lang$applyTo = (function (seq7138){
var self__5712__auto__ = this;
return self__5712__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq7138));
}));

/**
 * keyval => key val
 *   Returns a new sorted map with supplied mappings.
 */
cljs.core.sorted_map = (function cljs$core$sorted_map(var_args){
var args__5732__auto__ = [];
var len__5726__auto___9806 = arguments.length;
var i__5727__auto___9808 = (0);
while(true){
if((i__5727__auto___9808 < len__5726__auto___9806)){
args__5732__auto__.push((arguments[i__5727__auto___9808]));

var G__9810 = (i__5727__auto___9808 + (1));
i__5727__auto___9808 = G__9810;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((0) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((0)),(0),null)):null);
return cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic(argseq__5733__auto__);
});

(cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = cljs.core.PersistentTreeMap.EMPTY;
while(true){
if(in$){
var G__9817 = cljs.core.nnext(in$);
var G__9818 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__9817;
out = G__9818;
continue;
} else {
return out;
}
break;
}
}));

(cljs.core.sorted_map.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(cljs.core.sorted_map.cljs$lang$applyTo = (function (seq7141){
var self__5712__auto__ = this;
return self__5712__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq7141));
}));

/**
 * keyval => key val
 *   Returns a new sorted map with supplied mappings, using the supplied comparator.
 */
cljs.core.sorted_map_by = (function cljs$core$sorted_map_by(var_args){
var args__5732__auto__ = [];
var len__5726__auto___9822 = arguments.length;
var i__5727__auto___9823 = (0);
while(true){
if((i__5727__auto___9823 < len__5726__auto___9822)){
args__5732__auto__.push((arguments[i__5727__auto___9823]));

var G__9825 = (i__5727__auto___9823 + (1));
i__5727__auto___9823 = G__9825;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((1) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((1)),(0),null)):null);
return cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5733__auto__);
});

(cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = (new cljs.core.PersistentTreeMap(cljs.core.fn__GT_comparator(comparator),null,(0),null,(0)));
while(true){
if(in$){
var G__9827 = cljs.core.nnext(in$);
var G__9828 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__9827;
out = G__9828;
continue;
} else {
return out;
}
break;
}
}));

(cljs.core.sorted_map_by.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.sorted_map_by.cljs$lang$applyTo = (function (seq7142){
var G__7143 = cljs.core.first(seq7142);
var seq7142__$1 = cljs.core.next(seq7142);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__7143,seq7142__$1);
}));


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.KeySeq = (function (mseq,_meta){
this.mseq = mseq;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.KeySeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.KeySeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.KeySeq.prototype.indexOf = (function() {
var G__9832 = null;
var G__9832__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__9832__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__9832 = function(x,start){
switch(arguments.length){
case 1:
return G__9832__1.call(this,x);
case 2:
return G__9832__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9832.cljs$core$IFn$_invoke$arity$1 = G__9832__1;
G__9832.cljs$core$IFn$_invoke$arity$2 = G__9832__2;
return G__9832;
})()
);

(cljs.core.KeySeq.prototype.lastIndexOf = (function() {
var G__9833 = null;
var G__9833__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__9833__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__9833 = function(x,start){
switch(arguments.length){
case 1:
return G__9833__1.call(this,x);
case 2:
return G__9833__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9833.cljs$core$IFn$_invoke$arity$1 = G__9833__1;
G__9833.cljs$core$IFn$_invoke$arity$2 = G__9833__2;
return G__9833;
})()
);

(cljs.core.KeySeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
}));

(cljs.core.KeySeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((((!((self__.mseq == null))))?(((((self__.mseq.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === self__.mseq.cljs$core$INext$))))?true:(((!self__.mseq.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq):false)):cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq)))?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if((nseq == null)){
return null;
} else {
return (new cljs.core.KeySeq(nseq,null));
}
}));

(cljs.core.KeySeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
}));

(cljs.core.KeySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.KeySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.KeySeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var me = self__.mseq.cljs$core$ISeq$_first$arity$1(null);
return me.cljs$core$IMapEntry$_key$arity$1(null);
}));

(cljs.core.KeySeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((((!((self__.mseq == null))))?(((((self__.mseq.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === self__.mseq.cljs$core$INext$))))?true:(((!self__.mseq.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq):false)):cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq)))?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if((!((nseq == null)))){
return (new cljs.core.KeySeq(nseq,null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.KeySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.KeySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__._meta)){
return coll__$1;
} else {
return (new cljs.core.KeySeq(self__.mseq,new_meta));
}
}));

(cljs.core.KeySeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.KeySeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mseq","mseq",1602647196,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"not-native","not-native",-236392494,null)], null)),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
}));

(cljs.core.KeySeq.cljs$lang$type = true);

(cljs.core.KeySeq.cljs$lang$ctorStr = "cljs.core/KeySeq");

(cljs.core.KeySeq.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/KeySeq");
}));

/**
 * Positional factory function for cljs.core/KeySeq.
 */
cljs.core.__GT_KeySeq = (function cljs$core$__GT_KeySeq(mseq,_meta){
return (new cljs.core.KeySeq(mseq,_meta));
});

(cljs.core.KeySeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));
/**
 * Returns a sequence of the map's keys, in the same order as (seq map).
 */
cljs.core.keys = (function cljs$core$keys(map){
var temp__5804__auto__ = cljs.core.seq(map);
if(temp__5804__auto__){
var mseq = temp__5804__auto__;
return (new cljs.core.KeySeq(mseq,null));
} else {
return null;
}
});
/**
 * Returns the key of the map entry.
 */
cljs.core.key = (function cljs$core$key(map_entry){
return cljs.core._key(map_entry);
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ValSeq = (function (mseq,_meta){
this.mseq = mseq;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.ValSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.ValSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.ValSeq.prototype.indexOf = (function() {
var G__9840 = null;
var G__9840__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__9840__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__9840 = function(x,start){
switch(arguments.length){
case 1:
return G__9840__1.call(this,x);
case 2:
return G__9840__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9840.cljs$core$IFn$_invoke$arity$1 = G__9840__1;
G__9840.cljs$core$IFn$_invoke$arity$2 = G__9840__2;
return G__9840;
})()
);

(cljs.core.ValSeq.prototype.lastIndexOf = (function() {
var G__9841 = null;
var G__9841__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__9841__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__9841 = function(x,start){
switch(arguments.length){
case 1:
return G__9841__1.call(this,x);
case 2:
return G__9841__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9841.cljs$core$IFn$_invoke$arity$1 = G__9841__1;
G__9841.cljs$core$IFn$_invoke$arity$2 = G__9841__2;
return G__9841;
})()
);

(cljs.core.ValSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
}));

(cljs.core.ValSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((((!((self__.mseq == null))))?(((((self__.mseq.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === self__.mseq.cljs$core$INext$))))?true:(((!self__.mseq.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq):false)):cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq)))?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if((nseq == null)){
return null;
} else {
return (new cljs.core.ValSeq(nseq,null));
}
}));

(cljs.core.ValSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
}));

(cljs.core.ValSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.ValSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.ValSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var me = self__.mseq.cljs$core$ISeq$_first$arity$1(null);
return me.cljs$core$IMapEntry$_val$arity$1(null);
}));

(cljs.core.ValSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((((!((self__.mseq == null))))?(((((self__.mseq.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === self__.mseq.cljs$core$INext$))))?true:(((!self__.mseq.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq):false)):cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq)))?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if((!((nseq == null)))){
return (new cljs.core.ValSeq(nseq,null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.ValSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.ValSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__._meta)){
return coll__$1;
} else {
return (new cljs.core.ValSeq(self__.mseq,new_meta));
}
}));

(cljs.core.ValSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.ValSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mseq","mseq",1602647196,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"not-native","not-native",-236392494,null)], null)),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
}));

(cljs.core.ValSeq.cljs$lang$type = true);

(cljs.core.ValSeq.cljs$lang$ctorStr = "cljs.core/ValSeq");

(cljs.core.ValSeq.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/ValSeq");
}));

/**
 * Positional factory function for cljs.core/ValSeq.
 */
cljs.core.__GT_ValSeq = (function cljs$core$__GT_ValSeq(mseq,_meta){
return (new cljs.core.ValSeq(mseq,_meta));
});

(cljs.core.ValSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));
/**
 * Returns a sequence of the map's values, in the same order as (seq map).
 */
cljs.core.vals = (function cljs$core$vals(map){
var temp__5804__auto__ = cljs.core.seq(map);
if(temp__5804__auto__){
var mseq = temp__5804__auto__;
return (new cljs.core.ValSeq(mseq,null));
} else {
return null;
}
});
/**
 * Returns the value in the map entry.
 */
cljs.core.val = (function cljs$core$val(map_entry){
return cljs.core._val(map_entry);
});
/**
 * Returns a map that consists of the rest of the maps conj-ed onto
 *   the first.  If a key occurs in more than one map, the mapping from
 *   the latter (left-to-right) will be the mapping in the result.
 */
cljs.core.merge = (function cljs$core$merge(var_args){
var args__5732__auto__ = [];
var len__5726__auto___9845 = arguments.length;
var i__5727__auto___9846 = (0);
while(true){
if((i__5727__auto___9846 < len__5726__auto___9845)){
args__5732__auto__.push((arguments[i__5727__auto___9846]));

var G__9847 = (i__5727__auto___9846 + (1));
i__5727__auto___9846 = G__9847;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((0) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((0)),(0),null)):null);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(argseq__5733__auto__);
});

(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic = (function (maps){
if(cljs.core.truth_(cljs.core.some(cljs.core.identity,maps))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__7148_SHARP_,p2__7149_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__5002__auto__ = p1__7148_SHARP_;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),p2__7149_SHARP_);
}),maps);
} else {
return null;
}
}));

(cljs.core.merge.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(cljs.core.merge.cljs$lang$applyTo = (function (seq7150){
var self__5712__auto__ = this;
return self__5712__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq7150));
}));

/**
 * Returns a map that consists of the rest of the maps conj-ed onto
 *   the first.  If a key occurs in more than one map, the mapping(s)
 *   from the latter (left-to-right) will be combined with the mapping in
 *   the result by calling (f val-in-result val-in-latter).
 */
cljs.core.merge_with = (function cljs$core$merge_with(var_args){
var args__5732__auto__ = [];
var len__5726__auto___9848 = arguments.length;
var i__5727__auto___9849 = (0);
while(true){
if((i__5727__auto___9849 < len__5726__auto___9848)){
args__5732__auto__.push((arguments[i__5727__auto___9849]));

var G__9850 = (i__5727__auto___9849 + (1));
i__5727__auto___9849 = G__9850;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((1) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((1)),(0),null)):null);
return cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5733__auto__);
});

(cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic = (function (f,maps){
if(cljs.core.truth_(cljs.core.some(cljs.core.identity,maps))){
var merge_entry = (function (m,e){
var k = cljs.core.key(e);
var v = cljs.core.val(e);
if(cljs.core.contains_QMARK_(m,k)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__7153 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__7154 = v;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7153,G__7154) : f.call(null,G__7153,G__7154));
})());
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
});
var merge2 = (function (m1,m2){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(merge_entry,(function (){var or__5002__auto__ = m1;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),cljs.core.seq(m2));
});
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(merge2,maps);
} else {
return null;
}
}));

(cljs.core.merge_with.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.merge_with.cljs$lang$applyTo = (function (seq7151){
var G__7152 = cljs.core.first(seq7151);
var seq7151__$1 = cljs.core.next(seq7151);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__7152,seq7151__$1);
}));

/**
 * Returns a map containing only those entries in map whose key is in keys
 */
cljs.core.select_keys = (function cljs$core$select_keys(map,keyseq){
var ret = cljs.core.PersistentArrayMap.EMPTY;
var keys = cljs.core.seq(keyseq);
while(true){
if(keys){
var key = cljs.core.first(keys);
var entry = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map,key,new cljs.core.Keyword("cljs.core","not-found","cljs.core/not-found",-1572889185));
var G__9851 = ((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(entry,new cljs.core.Keyword("cljs.core","not-found","cljs.core/not-found",-1572889185)))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ret,key,entry):ret);
var G__9852 = cljs.core.next(keys);
ret = G__9851;
keys = G__9852;
continue;
} else {
return cljs.core._with_meta(ret,cljs.core.meta(map));
}
break;
}
});

/**
* @constructor
*/
cljs.core.HashSetIter = (function (iter){
this.iter = iter;
});
(cljs.core.HashSetIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return self__.iter.hasNext();
}));

(cljs.core.HashSetIter.prototype.next = (function (){
var self__ = this;
var _ = this;
if(self__.iter.hasNext()){
return self__.iter.next().key;
} else {
throw (new Error("No such element"));
}
}));

(cljs.core.HashSetIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.HashSetIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"iter","iter",-1346195486,null)], null);
}));

(cljs.core.HashSetIter.cljs$lang$type = true);

(cljs.core.HashSetIter.cljs$lang$ctorStr = "cljs.core/HashSetIter");

(cljs.core.HashSetIter.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/HashSetIter");
}));

/**
 * Positional factory function for cljs.core/HashSetIter.
 */
cljs.core.__GT_HashSetIter = (function cljs$core$__GT_HashSetIter(iter){
return (new cljs.core.HashSetIter(iter));
});


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.ISet}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.ILookup}
*/
cljs.core.PersistentHashSet = (function (meta,hash_map,__hash){
this.meta = meta;
this.hash_map = hash_map;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 15077647;
this.cljs$lang$protocol_mask$partition1$ = 139268;
});
(cljs.core.PersistentHashSet.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentHashSet.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentHashSet.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
}));

(cljs.core.PersistentHashSet.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_set_entries_iterator(cljs.core.seq(coll));
}));

(cljs.core.PersistentHashSet.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
}));

(cljs.core.PersistentHashSet.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
}));

(cljs.core.PersistentHashSet.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__7158 = cljs.core.seq(coll);
var chunk__7159 = null;
var count__7160 = (0);
var i__7161 = (0);
while(true){
if((i__7161 < count__7160)){
var vec__7168 = chunk__7159.cljs$core$IIndexed$_nth$arity$2(null,i__7161);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7168,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7168,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__9855 = seq__7158;
var G__9856 = chunk__7159;
var G__9857 = count__7160;
var G__9858 = (i__7161 + (1));
seq__7158 = G__9855;
chunk__7159 = G__9856;
count__7160 = G__9857;
i__7161 = G__9858;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__7158);
if(temp__5804__auto__){
var seq__7158__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__7158__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__7158__$1);
var G__9859 = cljs.core.chunk_rest(seq__7158__$1);
var G__9860 = c__5525__auto__;
var G__9861 = cljs.core.count(c__5525__auto__);
var G__9862 = (0);
seq__7158 = G__9859;
chunk__7159 = G__9860;
count__7160 = G__9861;
i__7161 = G__9862;
continue;
} else {
var vec__7171 = cljs.core.first(seq__7158__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7171,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7171,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__9863 = cljs.core.next(seq__7158__$1);
var G__9864 = null;
var G__9865 = (0);
var G__9866 = (0);
seq__7158 = G__9863;
chunk__7159 = G__9864;
count__7160 = G__9865;
i__7161 = G__9866;
continue;
}
} else {
return null;
}
}
break;
}
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,v,null);
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,v,not_found){
var self__ = this;
var coll__$1 = this;
var temp__5802__auto__ = cljs.core._find(self__.hash_map,v);
if(cljs.core.truth_(temp__5802__auto__)){
var entry = temp__5802__auto__;
return cljs.core.key(entry);
} else {
return not_found;
}
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.HashSetIter(cljs.core._iterator(self__.hash_map)));
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,self__.hash_map,self__.__hash));
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._count(self__.hash_map);
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
var and__5000__auto__ = cljs.core.set_QMARK_(other);
if(and__5000__auto__){
var and__5000__auto____$1 = (cljs.core.count(coll__$1) === cljs.core.count(other));
if(and__5000__auto____$1){
try{return cljs.core.reduce_kv((function (p1__7156_SHARP_,p2__7155_SHARP_){
var or__5002__auto__ = cljs.core.contains_QMARK_(other,p2__7155_SHARP_);
if(or__5002__auto__){
return or__5002__auto__;
} else {
return cljs.core.reduced(false);
}
}),true,self__.hash_map);
}catch (e7174){if((e7174 instanceof Error)){
var ex = e7174;
return false;
} else {
throw e7174;

}
}} else {
return and__5000__auto____$1;
}
} else {
return and__5000__auto__;
}
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientHashSet(cljs.core._as_transient(self__.hash_map)));
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentHashSet.EMPTY,self__.meta);
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$ISet$_disjoin$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,cljs.core._dissoc(self__.hash_map,v),null));
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.keys(self__.hash_map);
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashSet(new_meta,self__.hash_map,self__.__hash));
}
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.hash_map,o,null),null));
}));

(cljs.core.PersistentHashSet.prototype.call = (function (unused__10318__auto__){
var self__ = this;
var self__ = this;
var G__7175 = (arguments.length - (1));
switch (G__7175) {
case (1):
return self__.cljs$core$IFn$_invoke$arity$1((arguments[(1)]));

break;
case (2):
return self__.cljs$core$IFn$_invoke$arity$2((arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (1)))].join('')));

}
}));

(cljs.core.PersistentHashSet.prototype.apply = (function (self__,args7157){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args7157)));
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.PersistentHashSet.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"hash-map","hash-map",-439030950,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentHashSet.cljs$lang$type = true);

(cljs.core.PersistentHashSet.cljs$lang$ctorStr = "cljs.core/PersistentHashSet");

(cljs.core.PersistentHashSet.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/PersistentHashSet");
}));

/**
 * Positional factory function for cljs.core/PersistentHashSet.
 */
cljs.core.__GT_PersistentHashSet = (function cljs$core$__GT_PersistentHashSet(meta,hash_map,__hash){
return (new cljs.core.PersistentHashSet(meta,hash_map,__hash));
});

(cljs.core.PersistentHashSet.EMPTY = (new cljs.core.PersistentHashSet(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.empty_unordered_hash)));
(cljs.core.PersistentHashSet.fromArray = (function (items,no_clone){
var len = items.length;
if((len <= cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD)){
var arr = ((no_clone)?items:cljs.core.aclone(items));
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
while(true){
if((i < len)){
var G__9869 = (i + (1));
var G__9870 = cljs.core._assoc_BANG_(out,(items[i]),null);
i = G__9869;
out = G__9870;
continue;
} else {
return (new cljs.core.PersistentHashSet(null,cljs.core._persistent_BANG_(out),null));
}
break;
}
} else {
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashSet.EMPTY);
while(true){
if((i < len)){
var G__9