goog.provide('atlas_ui_v2.entities_map');
/**
 * Render a compact preview of a compound identity
 */
atlas_ui_v2.entities_map.identity_preview = (function atlas_ui_v2$entities_map$identity_preview(identity){
var by_ns = cljs.core.group_by(cljs.core.namespace,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.keyword_QMARK_,identity));
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"0.7rem",new cljs.core.Keyword(null,"color","color",1011675173),"#666"], null)], null),(function (){var iter__5480__auto__ = (function atlas_ui_v2$entities_map$identity_preview_$_iter__19007(s__19008){
return (new cljs.core.LazySeq(null,(function (){
var s__19008__$1 = s__19008;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__19008__$1);
if(temp__5804__auto__){
var s__19008__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__19008__$2)){
var c__5478__auto__ = cljs.core.chunk_first(s__19008__$2);
var size__5479__auto__ = cljs.core.count(c__5478__auto__);
var b__19010 = cljs.core.chunk_buffer(size__5479__auto__);
if((function (){var i__19009 = (0);
while(true){
if((i__19009 < size__5479__auto__)){
var vec__19011 = cljs.core._nth(c__5478__auto__,i__19009);
var ns_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19011,(0),null);
var aspects = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19011,(1),null);
cljs.core.chunk_append(b__19010,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"margin-right","margin-right",809689658),"0.3rem"], null)], null),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns_name),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(aspects))].join('')], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),ns_name], null)));

var G__19044 = (i__19009 + (1));
i__19009 = G__19044;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__19010),atlas_ui_v2$entities_map$identity_preview_$_iter__19007(cljs.core.chunk_rest(s__19008__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__19010),null);
}
} else {
var vec__19014 = cljs.core.first(s__19008__$2);
var ns_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19014,(0),null);
var aspects = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19014,(1),null);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"margin-right","margin-right",809689658),"0.3rem"], null)], null),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns_name),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(aspects))].join('')], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),ns_name], null)),atlas_ui_v2$entities_map$identity_preview_$_iter__19007(cljs.core.rest(s__19008__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5480__auto__(cljs.core.take.cljs$core$IFn$_invoke$arity$2((3),cljs.core.sort.cljs$core$IFn$_invoke$arity$1(by_ns)));
})(),(((cljs.core.count(by_ns) > (3)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"..."], null):null)], null);
});
/**
 * Render a single entity as a clickable row
 */
atlas_ui_v2.entities_map.entity_row = (function atlas_ui_v2$entities_map$entity_row(dev_id,identity,p__19017){
var map__19018 = p__19017;
var map__19018__$1 = cljs.core.__destructure_map(map__19018);
var selected_entities = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19018__$1,new cljs.core.Keyword(null,"selected-entities","selected-entities",-961620715));
var highlight_entities = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19018__$1,new cljs.core.Keyword(null,"highlight-entities","highlight-entities",1314574027));
var filter_mode = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19018__$1,new cljs.core.Keyword(null,"filter-mode","filter-mode",-84440349));
var on_entity_click = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19018__$1,new cljs.core.Keyword(null,"on-entity-click","on-entity-click",2106101276));
var selected_QMARK_ = cljs.core.contains_QMARK_(selected_entities,dev_id);
var highlighted_QMARK_ = (function (){var and__5000__auto__ = highlight_entities;
if(cljs.core.truth_(and__5000__auto__)){
return cljs.core.contains_QMARK_(highlight_entities,dev_id);
} else {
return and__5000__auto__;
}
})();
var should_hide_QMARK_ = (function (){var and__5000__auto__ = highlight_entities;
if(cljs.core.truth_(and__5000__auto__)){
return ((cljs.core.not(highlighted_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(filter_mode,new cljs.core.Keyword(null,"hide","hide",-596913169))));
} else {
return and__5000__auto__;
}
})();
var dimmed_QMARK_ = (function (){var and__5000__auto__ = highlight_entities;
if(cljs.core.truth_(and__5000__auto__)){
return ((cljs.core.not(highlighted_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(filter_mode,new cljs.core.Keyword(null,"highlight","highlight",-800930873))));
} else {
return and__5000__auto__;
}
})();
if(cljs.core.truth_(should_hide_QMARK_)){
return null;
} else {
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),(function (){
return (on_entity_click.cljs$core$IFn$_invoke$arity$1 ? on_entity_click.cljs$core$IFn$_invoke$arity$1(dev_id) : on_entity_click.call(null,dev_id));
}),new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"align-items","align-items",-267946462),new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"transition","transition",765692007),new cljs.core.Keyword(null,"background","background",-863952629),new cljs.core.Keyword(null,"cursor","cursor",1011937484),new cljs.core.Keyword(null,"border-left","border-left",-1150760178),new cljs.core.Keyword(null,"opacity","opacity",397153780),new cljs.core.Keyword(null,"padding","padding",1660304693),new cljs.core.Keyword(null,"justify-content","justify-content",-1990475787),new cljs.core.Keyword(null,"display","display",242065432),new cljs.core.Keyword(null,"border-radius","border-radius",419594011),new cljs.core.Keyword(null,"margin","margin",-995903681)],["center",((selected_QMARK_)?"#fff":(cljs.core.truth_(dimmed_QMARK_)?"#444":"#bbb"
)),"all 0.2s ease",((selected_QMARK_)?"#4a9eff":(cljs.core.truth_(highlighted_QMARK_)?"#3a7a5a":"transparent"
)),"pointer",((selected_QMARK_)?"3px solid #6ab4ff":"3px solid transparent"),(cljs.core.truth_(dimmed_QMARK_)?0.4:(1)),"0.3rem 0.5rem","space-between","flex","4px","0.2rem 0"])], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"0.85rem"], null)], null),cljs.core.str.cljs$core$IFn$_invoke$arity$1(dev_id)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v2.entities_map.identity_preview,identity], null)], null);
}
});
/**
 * Render an entity type with its entities
 */
atlas_ui_v2.entities_map.type_section = (function atlas_ui_v2$entities_map$type_section(entity_type,dev_id_map,opts){
var map__19019 = opts;
var map__19019__$1 = cljs.core.__destructure_map(map__19019);
var selected_types = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19019__$1,new cljs.core.Keyword(null,"selected-types","selected-types",-1725213152));
var highlight_entities = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19019__$1,new cljs.core.Keyword(null,"highlight-entities","highlight-entities",1314574027));
var filter_mode = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19019__$1,new cljs.core.Keyword(null,"filter-mode","filter-mode",-84440349));
var on_type_click = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19019__$1,new cljs.core.Keyword(null,"on-type-click","on-type-click",535036770));
var selected_QMARK_ = cljs.core.contains_QMARK_(selected_types,entity_type);
var type_has_highlight_QMARK_ = (function (){var and__5000__auto__ = highlight_entities;
if(cljs.core.truth_(and__5000__auto__)){
return cljs.core.some((function (p__19020){
var vec__19021 = p__19020;
var dev_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19021,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19021,(1),null);
return cljs.core.contains_QMARK_(highlight_entities,dev_id);
}),dev_id_map);
} else {
return and__5000__auto__;
}
})();
var should_hide_type_QMARK_ = (function (){var and__5000__auto__ = highlight_entities;
if(cljs.core.truth_(and__5000__auto__)){
return ((cljs.core.not(type_has_highlight_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(filter_mode,new cljs.core.Keyword(null,"hide","hide",-596913169))));
} else {
return and__5000__auto__;
}
})();
var dimmed_type_QMARK_ = (function (){var and__5000__auto__ = highlight_entities;
if(cljs.core.truth_(and__5000__auto__)){
return ((cljs.core.not(type_has_highlight_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(filter_mode,new cljs.core.Keyword(null,"highlight","highlight",-800930873))));
} else {
return and__5000__auto__;
}
})();
if(cljs.core.truth_(should_hide_type_QMARK_)){
return null;
} else {
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"margin-bottom","margin-bottom",388334941),"1.5rem",new cljs.core.Keyword(null,"opacity","opacity",397153780),(cljs.core.truth_(dimmed_type_QMARK_)?0.4:(1)),new cljs.core.Keyword(null,"transition","transition",765692007),"opacity 0.2s ease"], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),(function (){
return (on_type_click.cljs$core$IFn$_invoke$arity$1 ? on_type_click.cljs$core$IFn$_invoke$arity$1(entity_type) : on_type_click.call(null,entity_type));
}),new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"align-items","align-items",-267946462),new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"font-size","font-size",-1847940346),new cljs.core.Keyword(null,"font-weight","font-weight",2085804583),new cljs.core.Keyword(null,"background","background",-863952629),new cljs.core.Keyword(null,"cursor","cursor",1011937484),new cljs.core.Keyword(null,"border-left","border-left",-1150760178),new cljs.core.Keyword(null,"padding","padding",1660304693),new cljs.core.Keyword(null,"justify-content","justify-content",-1990475787),new cljs.core.Keyword(null,"display","display",242065432),new cljs.core.Keyword(null,"border-radius","border-radius",419594011),new cljs.core.Keyword(null,"margin-bottom","margin-bottom",388334941)],["center",((selected_QMARK_)?"#4a9eff":"#9a9aba"),"0.95rem","bold",((selected_QMARK_)?"#2a3a5a":"#1a1a2e"),"pointer",((selected_QMARK_)?"4px solid #4a9eff":"4px solid #4a4a6a"),"0.3rem 0.5rem","space-between","flex","4px","0.5rem"])], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),cljs.core.name(entity_type)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"color","color",1011675173),"#5a5a7a",new cljs.core.Keyword(null,"font-weight","font-weight",2085804583),"normal",new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"0.85rem"], null)], null),["(",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(dev_id_map)),")"].join('')], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"padding-left","padding-left",-1180879053),"0.5rem"], null)], null),(function (){var iter__5480__auto__ = (function atlas_ui_v2$entities_map$type_section_$_iter__19024(s__19025){
return (new cljs.core.LazySeq(null,(function (){
var s__19025__$1 = s__19025;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__19025__$1);
if(temp__5804__auto__){
var s__19025__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__19025__$2)){
var c__5478__auto__ = cljs.core.chunk_first(s__19025__$2);
var size__5479__auto__ = cljs.core.count(c__5478__auto__);
var b__19027 = cljs.core.chunk_buffer(size__5479__auto__);
if((function (){var i__19026 = (0);
while(true){
if((i__19026 < size__5479__auto__)){
var vec__19028 = cljs.core._nth(c__5478__auto__,i__19026);
var dev_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19028,(0),null);
var identity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19028,(1),null);
cljs.core.chunk_append(b__19027,cljs.core.with_meta(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v2.entities_map.entity_row,dev_id,identity,opts], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),dev_id], null)));

var G__19045 = (i__19026 + (1));
i__19026 = G__19045;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__19027),atlas_ui_v2$entities_map$type_section_$_iter__19024(cljs.core.chunk_rest(s__19025__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__19027),null);
}
} else {
var vec__19031 = cljs.core.first(s__19025__$2);
var dev_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19031,(0),null);
var identity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19031,(1),null);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v2.entities_map.entity_row,dev_id,identity,opts], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),dev_id], null)),atlas_ui_v2$entities_map$type_section_$_iter__19024(cljs.core.rest(s__19025__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5480__auto__(dev_id_map);
})()], null)], null);
}
});
/**
 * Main entities map component
 */
atlas_ui_v2.entities_map.entities_map_view = (function atlas_ui_v2$entities_map$entities_map_view(entities_map,opts){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"padding","padding",1660304693),"1rem",new cljs.core.Keyword(null,"color","color",1011675173),"#eee"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h2","h2",-372662728),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"1.1rem",new cljs.core.Keyword(null,"margin-bottom","margin-bottom",388334941),"1rem",new cljs.core.Keyword(null,"color","color",1011675173),"#aaa"], null)], null),"Entities by Type"], null),((cljs.core.empty_QMARK_(entities_map))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"color","color",1011675173),"#666"], null)], null),"No entities found"], null):(function (){var iter__5480__auto__ = (function atlas_ui_v2$entities_map$entities_map_view_$_iter__19034(s__19035){
return (new cljs.core.LazySeq(null,(function (){
var s__19035__$1 = s__19035;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__19035__$1);
if(temp__5804__auto__){
var s__19035__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__19035__$2)){
var c__5478__auto__ = cljs.core.chunk_first(s__19035__$2);
var size__5479__auto__ = cljs.core.count(c__5478__auto__);
var b__19037 = cljs.core.chunk_buffer(size__5479__auto__);
if((function (){var i__19036 = (0);
while(true){
if((i__19036 < size__5479__auto__)){
var vec__19038 = cljs.core._nth(c__5478__auto__,i__19036);
var entity_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19038,(0),null);
var dev_id_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19038,(1),null);
cljs.core.chunk_append(b__19037,cljs.core.with_meta(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v2.entities_map.type_section,entity_type,dev_id_map,opts], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),entity_type], null)));

var G__19046 = (i__19036 + (1));
i__19036 = G__19046;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__19037),atlas_ui_v2$entities_map$entities_map_view_$_iter__19034(cljs.core.chunk_rest(s__19035__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__19037),null);
}
} else {
var vec__19041 = cljs.core.first(s__19035__$2);
var entity_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19041,(0),null);
var dev_id_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19041,(1),null);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v2.entities_map.type_section,entity_type,dev_id_map,opts], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),entity_type], null)),atlas_ui_v2$entities_map$entities_map_view_$_iter__19034(cljs.core.rest(s__19035__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5480__auto__(entities_map);
})())], null);
});

//# sourceMappingURL=atlas_ui_v2.entities_map.js.map
