goog.provide('atlas_ui_v2.core');
if((typeof atlas_ui_v2 !== 'undefined') && (typeof atlas_ui_v2.core !== 'undefined') && (typeof atlas_ui_v2.core.app_state !== 'undefined')){
} else {
atlas_ui_v2.core.app_state = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"registry","registry",1021159018),null,new cljs.core.Keyword(null,"loading?","loading?",1905707049),true,new cljs.core.Keyword(null,"error","error",-978969032),null,new cljs.core.Keyword(null,"aspects-and","aspects-and",-655179438),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword(null,"aspects-or","aspects-or",-313383808),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword(null,"selected-types","selected-types",-1725213152),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword(null,"selected-entities","selected-entities",-961620715),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword(null,"filter-mode","filter-mode",-84440349),new cljs.core.Keyword(null,"hide","hide",-596913169)], null));
}
/**
 * Build aspects map: namespace -> #{aspect-names}
 */
atlas_ui_v2.core.aspects_map_data = (function atlas_ui_v2$core$aspects_map_data(registry){
if(cljs.core.truth_(registry)){
return atlas_ui_v2.data.build_aspects_map(registry);
} else {
return null;
}
});
/**
 * Build entities map: type -> {dev-id -> identity}
 */
atlas_ui_v2.core.entities_map_data = (function atlas_ui_v2$core$entities_map_data(registry){
if(cljs.core.truth_(registry)){
return atlas_ui_v2.data.build_entities_map(registry);
} else {
return null;
}
});
/**
 * Cycle aspect through: not selected → AND (blue) → OR (green) → not selected
 */
atlas_ui_v2.core.cycle_aspect_BANG_ = (function atlas_ui_v2$core$cycle_aspect_BANG_(aspect){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(atlas_ui_v2.core.app_state,(function (state){
var in_and_QMARK_ = cljs.core.contains_QMARK_(new cljs.core.Keyword(null,"aspects-and","aspects-and",-655179438).cljs$core$IFn$_invoke$arity$1(state),aspect);
var in_or_QMARK_ = cljs.core.contains_QMARK_(new cljs.core.Keyword(null,"aspects-or","aspects-or",-313383808).cljs$core$IFn$_invoke$arity$1(state),aspect);
if((((!(in_and_QMARK_))) && ((!(in_or_QMARK_))))){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(state,new cljs.core.Keyword(null,"aspects-and","aspects-and",-655179438),cljs.core.conj,aspect);
} else {
if(in_and_QMARK_){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(cljs.core.update.cljs$core$IFn$_invoke$arity$4(state,new cljs.core.Keyword(null,"aspects-and","aspects-and",-655179438),cljs.core.disj,aspect),new cljs.core.Keyword(null,"aspects-or","aspects-or",-313383808),cljs.core.conj,aspect);
} else {
if(in_or_QMARK_){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(state,new cljs.core.Keyword(null,"aspects-or","aspects-or",-313383808),cljs.core.disj,aspect);
} else {
return null;
}
}
}
}));
});
/**
 * Toggle selection of an entity type
 */
atlas_ui_v2.core.toggle_type_BANG_ = (function atlas_ui_v2$core$toggle_type_BANG_(entity_type){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(atlas_ui_v2.core.app_state,cljs.core.update,new cljs.core.Keyword(null,"selected-types","selected-types",-1725213152),(function (selected){
if(cljs.core.contains_QMARK_(selected,entity_type)){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(selected,entity_type);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(selected,entity_type);
}
}));
});
/**
 * Toggle selection of a specific entity by dev-id
 */
atlas_ui_v2.core.toggle_entity_BANG_ = (function atlas_ui_v2$core$toggle_entity_BANG_(dev_id){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(atlas_ui_v2.core.app_state,cljs.core.update,new cljs.core.Keyword(null,"selected-entities","selected-entities",-961620715),(function (selected){
if(cljs.core.contains_QMARK_(selected,dev_id)){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(selected,dev_id);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(selected,dev_id);
}
}));
});
/**
 * Clear all selections
 */
atlas_ui_v2.core.clear_selection_BANG_ = (function atlas_ui_v2$core$clear_selection_BANG_(){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(atlas_ui_v2.core.app_state,cljs.core.assoc,new cljs.core.Keyword(null,"aspects-and","aspects-and",-655179438),cljs.core.PersistentHashSet.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"aspects-or","aspects-or",-313383808),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword(null,"selected-types","selected-types",-1725213152),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword(null,"selected-entities","selected-entities",-961620715),cljs.core.PersistentHashSet.EMPTY], 0));
});
/**
 * Toggle between highlight and hide modes
 */
atlas_ui_v2.core.toggle_filter_mode_BANG_ = (function atlas_ui_v2$core$toggle_filter_mode_BANG_(){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(atlas_ui_v2.core.app_state,cljs.core.update,new cljs.core.Keyword(null,"filter-mode","filter-mode",-84440349),(function (mode){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"highlight","highlight",-800930873))){
return new cljs.core.Keyword(null,"hide","hide",-596913169);
} else {
return new cljs.core.Keyword(null,"highlight","highlight",-800930873);
}
}));
});
/**
 * Find all dev-ids matching the AND/OR aspect criteria.
 * - Entity matches if it has ALL aspects from aspects-and
 * - OR entity matches if it has ANY aspect from aspects-or
 */
atlas_ui_v2.core.entities_matching_aspects = (function atlas_ui_v2$core$entities_matching_aspects(registry,aspects_and,aspects_or){
if(((cljs.core.seq(aspects_and)) || (cljs.core.seq(aspects_or)))){
return cljs.core.set(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.some_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__19076){
var vec__19077 = p__19076;
var _identity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19077,(0),null);
var props = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19077,(1),null);
return new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553).cljs$core$IFn$_invoke$arity$1(props);
}),cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p__19080){
var vec__19081 = p__19080;
var identity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19081,(0),null);
var _props = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19081,(1),null);
var matches_and_QMARK_ = ((cljs.core.seq(aspects_and)) && (cljs.core.every_QMARK_((function (p1__19074_SHARP_){
return cljs.core.contains_QMARK_(identity,p1__19074_SHARP_);
}),aspects_and)));
var matches_or_QMARK_ = (function (){var and__5000__auto__ = cljs.core.seq(aspects_or);
if(and__5000__auto__){
return cljs.core.some((function (p1__19075_SHARP_){
return cljs.core.contains_QMARK_(identity,p1__19075_SHARP_);
}),aspects_or);
} else {
return and__5000__auto__;
}
})();
var or__5002__auto__ = matches_and_QMARK_;
if(or__5002__auto__){
return or__5002__auto__;
} else {
return matches_or_QMARK_;
}
}),registry))));
} else {
return null;
}
});
/**
 * Get all aspects for a dev-id
 */
atlas_ui_v2.core.aspects_for_entity = (function atlas_ui_v2$core$aspects_for_entity(registry,dev_id){
return cljs.core.first(cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p__19084){
var vec__19085 = p__19084;
var _identity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19085,(0),null);
var props = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19085,(1),null);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(dev_id,new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553).cljs$core$IFn$_invoke$arity$1(props));
}),registry)));
});
/**
 * Get union of all aspects for multiple dev-ids
 */
atlas_ui_v2.core.aspects_for_entities = (function atlas_ui_v2$core$aspects_for_entities(registry,dev_ids){
if(cljs.core.seq(dev_ids)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(clojure.set.union,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.some_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__19088_SHARP_){
return atlas_ui_v2.core.aspects_for_entity(registry,p1__19088_SHARP_);
}),dev_ids)));
} else {
return null;
}
});
/**
 * Get all aspects used by entities of a type
 */
atlas_ui_v2.core.aspects_for_type = (function atlas_ui_v2$core$aspects_for_type(registry,entity_type){
return cljs.core.set(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((function (p__19089){
var vec__19090 = p__19089;
var identity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19090,(0),null);
var _props = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19090,(1),null);
return identity;
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p__19093){
var vec__19094 = p__19093;
var identity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19094,(0),null);
var _props = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19094,(1),null);
return cljs.core.contains_QMARK_(identity,entity_type);
}),registry)], 0)));
});
/**
 * Get union of all aspects for multiple types
 */
atlas_ui_v2.core.aspects_for_types = (function atlas_ui_v2$core$aspects_for_types(registry,entity_types){
if(cljs.core.seq(entity_types)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(clojure.set.union,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__19097_SHARP_){
return atlas_ui_v2.core.aspects_for_type(registry,p1__19097_SHARP_);
}),entity_types));
} else {
return null;
}
});
atlas_ui_v2.core.header = (function atlas_ui_v2$core$header(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"padding","padding",1660304693),"1rem",new cljs.core.Keyword(null,"background","background",-863952629),"#1a1a2e",new cljs.core.Keyword(null,"color","color",1011675173),"#eee",new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"justify-content","justify-content",-1990475787),"space-between",new cljs.core.Keyword(null,"align-items","align-items",-267946462),"center"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h1","h1",-1896887462),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"margin","margin",-995903681),(0),new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"1.5rem"], null)], null),"Atlas Explorer v2"], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"gap","gap",80255254),"1rem",new cljs.core.Keyword(null,"align-items","align-items",-267946462),"center"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),atlas_ui_v2.core.clear_selection_BANG_,new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"padding","padding",1660304693),"0.5rem 1rem",new cljs.core.Keyword(null,"background","background",-863952629),"#4a4a6a",new cljs.core.Keyword(null,"color","color",1011675173),"#eee",new cljs.core.Keyword(null,"border","border",1444987323),"none",new cljs.core.Keyword(null,"border-radius","border-radius",419594011),"4px",new cljs.core.Keyword(null,"cursor","cursor",1011937484),"pointer"], null)], null),"Clear Selection"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),atlas_ui_v2.core.toggle_filter_mode_BANG_,new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"padding","padding",1660304693),"0.5rem 1rem",new cljs.core.Keyword(null,"background","background",-863952629),((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"filter-mode","filter-mode",-84440349).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui_v2.core.app_state)),new cljs.core.Keyword(null,"highlight","highlight",-800930873)))?"#6a6a8a":"#8a4a4a"),new cljs.core.Keyword(null,"color","color",1011675173),"#eee",new cljs.core.Keyword(null,"border","border",1444987323),"none",new cljs.core.Keyword(null,"border-radius","border-radius",419594011),"4px",new cljs.core.Keyword(null,"cursor","cursor",1011937484),"pointer"], null)], null),((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"filter-mode","filter-mode",-84440349).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(atlas_ui_v2.core.app_state)),new cljs.core.Keyword(null,"highlight","highlight",-800930873)))?"Mode: Highlight":"Mode: Hide")], null)], null)], null);
});
atlas_ui_v2.core.selection_info = (function atlas_ui_v2$core$selection_info(){
var map__19098 = cljs.core.deref(atlas_ui_v2.core.app_state);
var map__19098__$1 = cljs.core.__destructure_map(map__19098);
var aspects_and = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19098__$1,new cljs.core.Keyword(null,"aspects-and","aspects-and",-655179438));
var aspects_or = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19098__$1,new cljs.core.Keyword(null,"aspects-or","aspects-or",-313383808));
var selected_types = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19098__$1,new cljs.core.Keyword(null,"selected-types","selected-types",-1725213152));
var selected_entities = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19098__$1,new cljs.core.Keyword(null,"selected-entities","selected-entities",-961620715));
if(((cljs.core.seq(aspects_and)) || (((cljs.core.seq(aspects_or)) || (((cljs.core.seq(selected_types)) || (cljs.core.seq(selected_entities)))))))){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"padding","padding",1660304693),"0.5rem 1rem",new cljs.core.Keyword(null,"background","background",-863952629),"#2a2a4e",new cljs.core.Keyword(null,"color","color",1011675173),"#aaa",new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"0.85rem",new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"flex-wrap","flex-wrap",455413707),"wrap",new cljs.core.Keyword(null,"gap","gap",80255254),"1rem"], null)], null),((cljs.core.seq(aspects_and))?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"color","color",1011675173),"#4a9eff"], null)], null),"AND: ",cljs.core.count(aspects_and)], null):null),((cljs.core.seq(aspects_or))?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"color","color",1011675173),"#4aef7a"], null)], null),"OR: ",cljs.core.count(aspects_or)], null):null),((cljs.core.seq(selected_types))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"Types: ",cljs.core.count(selected_types)], null):null),((cljs.core.seq(selected_entities))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"Entities: ",cljs.core.count(selected_entities)], null):null)], null);
} else {
return null;
}
});
atlas_ui_v2.core.loading_view = (function atlas_ui_v2$core$loading_view(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"justify-content","justify-content",-1990475787),"center",new cljs.core.Keyword(null,"align-items","align-items",-267946462),"center",new cljs.core.Keyword(null,"height","height",1025178622),"100vh",new cljs.core.Keyword(null,"background","background",-863952629),"#0f0f1a",new cljs.core.Keyword(null,"color","color",1011675173),"#eee"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),"Loading registry..."], null)], null);
});
atlas_ui_v2.core.error_view = (function atlas_ui_v2$core$error_view(error){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"justify-content","justify-content",-1990475787),"center",new cljs.core.Keyword(null,"align-items","align-items",-267946462),"center",new cljs.core.Keyword(null,"height","height",1025178622),"100vh",new cljs.core.Keyword(null,"background","background",-863952629),"#0f0f1a",new cljs.core.Keyword(null,"color","color",1011675173),"#ff6b6b"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h2","h2",-372662728),"Error loading registry"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pre","pre",2118456869),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error], 0))], null)], null)], null);
});
atlas_ui_v2.core.main_view = (function atlas_ui_v2$core$main_view(){
var map__19099 = cljs.core.deref(atlas_ui_v2.core.app_state);
var map__19099__$1 = cljs.core.__destructure_map(map__19099);
var registry = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19099__$1,new cljs.core.Keyword(null,"registry","registry",1021159018));
var aspects_and = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19099__$1,new cljs.core.Keyword(null,"aspects-and","aspects-and",-655179438));
var aspects_or = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19099__$1,new cljs.core.Keyword(null,"aspects-or","aspects-or",-313383808));
var selected_types = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19099__$1,new cljs.core.Keyword(null,"selected-types","selected-types",-1725213152));
var selected_entities = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19099__$1,new cljs.core.Keyword(null,"selected-entities","selected-entities",-961620715));
var filter_mode = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19099__$1,new cljs.core.Keyword(null,"filter-mode","filter-mode",-84440349));
var aspects_data = atlas_ui_v2.core.aspects_map_data(registry);
var entities_data = atlas_ui_v2.core.entities_map_data(registry);
var highlight_entities = ((((cljs.core.seq(aspects_and)) || (cljs.core.seq(aspects_or))))?atlas_ui_v2.core.entities_matching_aspects(registry,aspects_and,aspects_or):null);
var highlight_aspects = ((cljs.core.seq(selected_entities))?atlas_ui_v2.core.aspects_for_entities(registry,selected_entities):((cljs.core.seq(selected_types))?atlas_ui_v2.core.aspects_for_types(registry,selected_types):null
));
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"flex-direction","flex-direction",364609438),"column",new cljs.core.Keyword(null,"height","height",1025178622),"100vh",new cljs.core.Keyword(null,"background","background",-863952629),"#0f0f1a"], null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v2.core.header], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v2.core.selection_info], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"flex","flex",-1425124628),(1),new cljs.core.Keyword(null,"overflow","overflow",2058931880),"hidden"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"flex","flex",-1425124628),(1),new cljs.core.Keyword(null,"overflow","overflow",2058931880),"auto",new cljs.core.Keyword(null,"border-right","border-right",-668932860),"1px solid #333"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v2.aspects_map.aspects_map_view,aspects_data,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"aspects-and","aspects-and",-655179438),aspects_and,new cljs.core.Keyword(null,"aspects-or","aspects-or",-313383808),aspects_or,new cljs.core.Keyword(null,"highlight-aspects","highlight-aspects",-369675008),highlight_aspects,new cljs.core.Keyword(null,"filter-mode","filter-mode",-84440349),filter_mode,new cljs.core.Keyword(null,"on-click","on-click",1632826543),atlas_ui_v2.core.cycle_aspect_BANG_], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"flex","flex",-1425124628),(1),new cljs.core.Keyword(null,"overflow","overflow",2058931880),"auto"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v2.entities_map.entities_map_view,entities_data,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"selected-types","selected-types",-1725213152),selected_types,new cljs.core.Keyword(null,"selected-entities","selected-entities",-961620715),selected_entities,new cljs.core.Keyword(null,"highlight-entities","highlight-entities",1314574027),highlight_entities,new cljs.core.Keyword(null,"filter-mode","filter-mode",-84440349),filter_mode,new cljs.core.Keyword(null,"on-type-click","on-type-click",535036770),atlas_ui_v2.core.toggle_type_BANG_,new cljs.core.Keyword(null,"on-entity-click","on-entity-click",2106101276),atlas_ui_v2.core.toggle_entity_BANG_], null)], null)], null)], null)], null);
});
atlas_ui_v2.core.app = (function atlas_ui_v2$core$app(){
var map__19100 = cljs.core.deref(atlas_ui_v2.core.app_state);
var map__19100__$1 = cljs.core.__destructure_map(map__19100);
var loading_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19100__$1,new cljs.core.Keyword(null,"loading?","loading?",1905707049));
var error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19100__$1,new cljs.core.Keyword(null,"error","error",-978969032));
var registry = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19100__$1,new cljs.core.Keyword(null,"registry","registry",1021159018));
if(cljs.core.truth_(loading_QMARK_)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v2.core.loading_view], null);
} else {
if(cljs.core.truth_(error)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v2.core.error_view,error], null);
} else {
if((registry == null)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v2.core.loading_view], null);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v2.core.main_view], null);

}
}
}
});
atlas_ui_v2.core.on_registry_loaded = (function atlas_ui_v2$core$on_registry_loaded(data){
var registry = (function (){var or__5002__auto__ = new cljs.core.Keyword("atlas-ui.api.response","registry","atlas-ui.api.response/registry",-156359811).cljs$core$IFn$_invoke$arity$1(data);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return data;
}
})();
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(atlas_ui_v2.core.app_state,cljs.core.assoc,new cljs.core.Keyword(null,"registry","registry",1021159018),registry,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"loading?","loading?",1905707049),false,new cljs.core.Keyword(null,"error","error",-978969032),null], 0));
});
atlas_ui_v2.core.on_registry_error = (function atlas_ui_v2$core$on_registry_error(error){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(atlas_ui_v2.core.app_state,cljs.core.assoc,new cljs.core.Keyword(null,"loading?","loading?",1905707049),false,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"error","error",-978969032),error], 0));
});
atlas_ui_v2.core.mount_root = (function atlas_ui_v2$core$mount_root(){
var temp__5804__auto__ = document.getElementById("app");
if(cljs.core.truth_(temp__5804__auto__)){
var el = temp__5804__auto__;
return reagent.dom.render.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [atlas_ui_v2.core.app], null),el);
} else {
return null;
}
});
atlas_ui_v2.core.init = (function atlas_ui_v2$core$init(){
console.log("Atlas UI v2 initializing...");

atlas_ui_v2.api.fetch_registry_BANG_(atlas_ui_v2.core.on_registry_loaded,atlas_ui_v2.core.on_registry_error);

return atlas_ui_v2.core.mount_root();
});

//# sourceMappingURL=atlas_ui_v2.core.js.map
