goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = true;

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_11339 = (function (this$){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (shadow.dom._to_dom[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5351__auto__.call(null,this$));
} else {
var m__5349__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5349__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_11339(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_11355 = (function (this$){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (shadow.dom._to_svg[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5351__auto__.call(null,this$));
} else {
var m__5349__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5349__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_11355(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__10114 = coll;
var G__10115 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__10114,G__10115) : shadow.dom.lazy_native_coll_seq.call(null,G__10114,G__10115));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__5002__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__10128 = arguments.length;
switch (G__10128) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__10130 = arguments.length;
switch (G__10130) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__10132 = arguments.length;
switch (G__10132) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__10148 = arguments.length;
switch (G__10148) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__10158 = arguments.length;
switch (G__10158) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__10168 = arguments.length;
switch (G__10168) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__5002__auto__ = (!((typeof document !== 'undefined')));
if(or__5002__auto__){
return or__5002__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e10172){if((e10172 instanceof Object)){
var e = e10172;
return console.log("didnt support attachEvent",el,e);
} else {
throw e10172;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__5002__auto__ = (!((typeof document !== 'undefined')));
if(or__5002__auto__){
return or__5002__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__10176 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__10177 = null;
var count__10178 = (0);
var i__10179 = (0);
while(true){
if((i__10179 < count__10178)){
var el = chunk__10177.cljs$core$IIndexed$_nth$arity$2(null,i__10179);
var handler_11479__$1 = ((function (seq__10176,chunk__10177,count__10178,i__10179,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__10176,chunk__10177,count__10178,i__10179,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_11479__$1);


var G__11482 = seq__10176;
var G__11483 = chunk__10177;
var G__11484 = count__10178;
var G__11485 = (i__10179 + (1));
seq__10176 = G__11482;
chunk__10177 = G__11483;
count__10178 = G__11484;
i__10179 = G__11485;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__10176);
if(temp__5804__auto__){
var seq__10176__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10176__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__10176__$1);
var G__11486 = cljs.core.chunk_rest(seq__10176__$1);
var G__11487 = c__5525__auto__;
var G__11488 = cljs.core.count(c__5525__auto__);
var G__11489 = (0);
seq__10176 = G__11486;
chunk__10177 = G__11487;
count__10178 = G__11488;
i__10179 = G__11489;
continue;
} else {
var el = cljs.core.first(seq__10176__$1);
var handler_11490__$1 = ((function (seq__10176,chunk__10177,count__10178,i__10179,el,seq__10176__$1,temp__5804__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__10176,chunk__10177,count__10178,i__10179,el,seq__10176__$1,temp__5804__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_11490__$1);


var G__11493 = cljs.core.next(seq__10176__$1);
var G__11494 = null;
var G__11495 = (0);
var G__11496 = (0);
seq__10176 = G__11493;
chunk__10177 = G__11494;
count__10178 = G__11495;
i__10179 = G__11496;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__10185 = arguments.length;
switch (G__10185) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__10186 = cljs.core.seq(events);
var chunk__10187 = null;
var count__10188 = (0);
var i__10189 = (0);
while(true){
if((i__10189 < count__10188)){
var vec__10198 = chunk__10187.cljs$core$IIndexed$_nth$arity$2(null,i__10189);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10198,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10198,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__11511 = seq__10186;
var G__11512 = chunk__10187;
var G__11513 = count__10188;
var G__11514 = (i__10189 + (1));
seq__10186 = G__11511;
chunk__10187 = G__11512;
count__10188 = G__11513;
i__10189 = G__11514;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__10186);
if(temp__5804__auto__){
var seq__10186__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10186__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__10186__$1);
var G__11515 = cljs.core.chunk_rest(seq__10186__$1);
var G__11516 = c__5525__auto__;
var G__11517 = cljs.core.count(c__5525__auto__);
var G__11518 = (0);
seq__10186 = G__11515;
chunk__10187 = G__11516;
count__10188 = G__11517;
i__10189 = G__11518;
continue;
} else {
var vec__10203 = cljs.core.first(seq__10186__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10203,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10203,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__11554 = cljs.core.next(seq__10186__$1);
var G__11556 = null;
var G__11557 = (0);
var G__11558 = (0);
seq__10186 = G__11554;
chunk__10187 = G__11556;
count__10188 = G__11557;
i__10189 = G__11558;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__10208 = cljs.core.seq(styles);
var chunk__10209 = null;
var count__10210 = (0);
var i__10211 = (0);
while(true){
if((i__10211 < count__10210)){
var vec__10220 = chunk__10209.cljs$core$IIndexed$_nth$arity$2(null,i__10211);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10220,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10220,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__11609 = seq__10208;
var G__11610 = chunk__10209;
var G__11611 = count__10210;
var G__11612 = (i__10211 + (1));
seq__10208 = G__11609;
chunk__10209 = G__11610;
count__10210 = G__11611;
i__10211 = G__11612;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__10208);
if(temp__5804__auto__){
var seq__10208__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10208__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__10208__$1);
var G__11613 = cljs.core.chunk_rest(seq__10208__$1);
var G__11614 = c__5525__auto__;
var G__11615 = cljs.core.count(c__5525__auto__);
var G__11616 = (0);
seq__10208 = G__11613;
chunk__10209 = G__11614;
count__10210 = G__11615;
i__10211 = G__11616;
continue;
} else {
var vec__10223 = cljs.core.first(seq__10208__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10223,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10223,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__11618 = cljs.core.next(seq__10208__$1);
var G__11619 = null;
var G__11620 = (0);
var G__11621 = (0);
seq__10208 = G__11618;
chunk__10209 = G__11619;
count__10210 = G__11620;
i__10211 = G__11621;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__10226_11623 = key;
var G__10226_11624__$1 = (((G__10226_11623 instanceof cljs.core.Keyword))?G__10226_11623.fqn:null);
switch (G__10226_11624__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_11640 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__5002__auto__ = goog.string.startsWith(ks_11640,"data-");
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return goog.string.startsWith(ks_11640,"aria-");
}
})())){
el.setAttribute(ks_11640,value);
} else {
(el[ks_11640] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__10243){
var map__10244 = p__10243;
var map__10244__$1 = cljs.core.__destructure_map(map__10244);
var props = map__10244__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10244__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__10245 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10245,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10245,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10245,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__10248 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__10248,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__10248;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__10251 = arguments.length;
switch (G__10251) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5804__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5804__auto__)){
var n = temp__5804__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5804__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5804__auto__)){
var n = temp__5804__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__10252){
var vec__10253 = p__10252;
var seq__10254 = cljs.core.seq(vec__10253);
var first__10255 = cljs.core.first(seq__10254);
var seq__10254__$1 = cljs.core.next(seq__10254);
var nn = first__10255;
var first__10255__$1 = cljs.core.first(seq__10254__$1);
var seq__10254__$2 = cljs.core.next(seq__10254__$1);
var np = first__10255__$1;
var nc = seq__10254__$2;
var node = vec__10253;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__10256 = nn;
var G__10257 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__10256,G__10257) : create_fn.call(null,G__10256,G__10257));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__10258 = nn;
var G__10259 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__10258,G__10259) : create_fn.call(null,G__10258,G__10259));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__10260 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10260,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10260,(1),null);
var seq__10263_11714 = cljs.core.seq(node_children);
var chunk__10264_11716 = null;
var count__10265_11717 = (0);
var i__10266_11718 = (0);
while(true){
if((i__10266_11718 < count__10265_11717)){
var child_struct_11723 = chunk__10264_11716.cljs$core$IIndexed$_nth$arity$2(null,i__10266_11718);
var children_11725 = shadow.dom.dom_node(child_struct_11723);
if(cljs.core.seq_QMARK_(children_11725)){
var seq__10282_11727 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_11725));
var chunk__10284_11728 = null;
var count__10285_11729 = (0);
var i__10286_11730 = (0);
while(true){
if((i__10286_11730 < count__10285_11729)){
var child_11746 = chunk__10284_11728.cljs$core$IIndexed$_nth$arity$2(null,i__10286_11730);
if(cljs.core.truth_(child_11746)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_11746);


var G__11750 = seq__10282_11727;
var G__11751 = chunk__10284_11728;
var G__11752 = count__10285_11729;
var G__11753 = (i__10286_11730 + (1));
seq__10282_11727 = G__11750;
chunk__10284_11728 = G__11751;
count__10285_11729 = G__11752;
i__10286_11730 = G__11753;
continue;
} else {
var G__11754 = seq__10282_11727;
var G__11755 = chunk__10284_11728;
var G__11756 = count__10285_11729;
var G__11757 = (i__10286_11730 + (1));
seq__10282_11727 = G__11754;
chunk__10284_11728 = G__11755;
count__10285_11729 = G__11756;
i__10286_11730 = G__11757;
continue;
}
} else {
var temp__5804__auto___11758 = cljs.core.seq(seq__10282_11727);
if(temp__5804__auto___11758){
var seq__10282_11759__$1 = temp__5804__auto___11758;
if(cljs.core.chunked_seq_QMARK_(seq__10282_11759__$1)){
var c__5525__auto___11760 = cljs.core.chunk_first(seq__10282_11759__$1);
var G__11762 = cljs.core.chunk_rest(seq__10282_11759__$1);
var G__11763 = c__5525__auto___11760;
var G__11764 = cljs.core.count(c__5525__auto___11760);
var G__11765 = (0);
seq__10282_11727 = G__11762;
chunk__10284_11728 = G__11763;
count__10285_11729 = G__11764;
i__10286_11730 = G__11765;
continue;
} else {
var child_11766 = cljs.core.first(seq__10282_11759__$1);
if(cljs.core.truth_(child_11766)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_11766);


var G__11767 = cljs.core.next(seq__10282_11759__$1);
var G__11768 = null;
var G__11769 = (0);
var G__11770 = (0);
seq__10282_11727 = G__11767;
chunk__10284_11728 = G__11768;
count__10285_11729 = G__11769;
i__10286_11730 = G__11770;
continue;
} else {
var G__11771 = cljs.core.next(seq__10282_11759__$1);
var G__11772 = null;
var G__11773 = (0);
var G__11774 = (0);
seq__10282_11727 = G__11771;
chunk__10284_11728 = G__11772;
count__10285_11729 = G__11773;
i__10286_11730 = G__11774;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_11725);
}


var G__11776 = seq__10263_11714;
var G__11777 = chunk__10264_11716;
var G__11778 = count__10265_11717;
var G__11779 = (i__10266_11718 + (1));
seq__10263_11714 = G__11776;
chunk__10264_11716 = G__11777;
count__10265_11717 = G__11778;
i__10266_11718 = G__11779;
continue;
} else {
var temp__5804__auto___11781 = cljs.core.seq(seq__10263_11714);
if(temp__5804__auto___11781){
var seq__10263_11782__$1 = temp__5804__auto___11781;
if(cljs.core.chunked_seq_QMARK_(seq__10263_11782__$1)){
var c__5525__auto___11783 = cljs.core.chunk_first(seq__10263_11782__$1);
var G__11785 = cljs.core.chunk_rest(seq__10263_11782__$1);
var G__11786 = c__5525__auto___11783;
var G__11787 = cljs.core.count(c__5525__auto___11783);
var G__11788 = (0);
seq__10263_11714 = G__11785;
chunk__10264_11716 = G__11786;
count__10265_11717 = G__11787;
i__10266_11718 = G__11788;
continue;
} else {
var child_struct_11789 = cljs.core.first(seq__10263_11782__$1);
var children_11790 = shadow.dom.dom_node(child_struct_11789);
if(cljs.core.seq_QMARK_(children_11790)){
var seq__10294_11791 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_11790));
var chunk__10296_11792 = null;
var count__10297_11793 = (0);
var i__10298_11794 = (0);
while(true){
if((i__10298_11794 < count__10297_11793)){
var child_11801 = chunk__10296_11792.cljs$core$IIndexed$_nth$arity$2(null,i__10298_11794);
if(cljs.core.truth_(child_11801)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_11801);


var G__11803 = seq__10294_11791;
var G__11804 = chunk__10296_11792;
var G__11805 = count__10297_11793;
var G__11806 = (i__10298_11794 + (1));
seq__10294_11791 = G__11803;
chunk__10296_11792 = G__11804;
count__10297_11793 = G__11805;
i__10298_11794 = G__11806;
continue;
} else {
var G__11807 = seq__10294_11791;
var G__11808 = chunk__10296_11792;
var G__11809 = count__10297_11793;
var G__11810 = (i__10298_11794 + (1));
seq__10294_11791 = G__11807;
chunk__10296_11792 = G__11808;
count__10297_11793 = G__11809;
i__10298_11794 = G__11810;
continue;
}
} else {
var temp__5804__auto___11811__$1 = cljs.core.seq(seq__10294_11791);
if(temp__5804__auto___11811__$1){
var seq__10294_11812__$1 = temp__5804__auto___11811__$1;
if(cljs.core.chunked_seq_QMARK_(seq__10294_11812__$1)){
var c__5525__auto___11813 = cljs.core.chunk_first(seq__10294_11812__$1);
var G__11829 = cljs.core.chunk_rest(seq__10294_11812__$1);
var G__11830 = c__5525__auto___11813;
var G__11831 = cljs.core.count(c__5525__auto___11813);
var G__11833 = (0);
seq__10294_11791 = G__11829;
chunk__10296_11792 = G__11830;
count__10297_11793 = G__11831;
i__10298_11794 = G__11833;
continue;
} else {
var child_11857 = cljs.core.first(seq__10294_11812__$1);
if(cljs.core.truth_(child_11857)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_11857);


var G__11858 = cljs.core.next(seq__10294_11812__$1);
var G__11859 = null;
var G__11860 = (0);
var G__11861 = (0);
seq__10294_11791 = G__11858;
chunk__10296_11792 = G__11859;
count__10297_11793 = G__11860;
i__10298_11794 = G__11861;
continue;
} else {
var G__11862 = cljs.core.next(seq__10294_11812__$1);
var G__11863 = null;
var G__11864 = (0);
var G__11865 = (0);
seq__10294_11791 = G__11862;
chunk__10296_11792 = G__11863;
count__10297_11793 = G__11864;
i__10298_11794 = G__11865;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_11790);
}


var G__11866 = cljs.core.next(seq__10263_11782__$1);
var G__11867 = null;
var G__11868 = (0);
var G__11869 = (0);
seq__10263_11714 = G__11866;
chunk__10264_11716 = G__11867;
count__10265_11717 = G__11868;
i__10266_11718 = G__11869;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__10336 = cljs.core.seq(node);
var chunk__10337 = null;
var count__10338 = (0);
var i__10339 = (0);
while(true){
if((i__10339 < count__10338)){
var n = chunk__10337.cljs$core$IIndexed$_nth$arity$2(null,i__10339);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__11884 = seq__10336;
var G__11885 = chunk__10337;
var G__11886 = count__10338;
var G__11887 = (i__10339 + (1));
seq__10336 = G__11884;
chunk__10337 = G__11885;
count__10338 = G__11886;
i__10339 = G__11887;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__10336);
if(temp__5804__auto__){
var seq__10336__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10336__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__10336__$1);
var G__11889 = cljs.core.chunk_rest(seq__10336__$1);
var G__11890 = c__5525__auto__;
var G__11891 = cljs.core.count(c__5525__auto__);
var G__11892 = (0);
seq__10336 = G__11889;
chunk__10337 = G__11890;
count__10338 = G__11891;
i__10339 = G__11892;
continue;
} else {
var n = cljs.core.first(seq__10336__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__11894 = cljs.core.next(seq__10336__$1);
var G__11895 = null;
var G__11896 = (0);
var G__11897 = (0);
seq__10336 = G__11894;
chunk__10337 = G__11895;
count__10338 = G__11896;
i__10339 = G__11897;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__10379 = arguments.length;
switch (G__10379) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__10399 = arguments.length;
switch (G__10399) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__10405 = arguments.length;
switch (G__10405) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__5002__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__5732__auto__ = [];
var len__5726__auto___11937 = arguments.length;
var i__5727__auto___11938 = (0);
while(true){
if((i__5727__auto___11938 < len__5726__auto___11937)){
args__5732__auto__.push((arguments[i__5727__auto___11938]));

var G__11939 = (i__5727__auto___11938 + (1));
i__5727__auto___11938 = G__11939;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((0) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__5733__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__10513_11940 = cljs.core.seq(nodes);
var chunk__10514_11941 = null;
var count__10515_11942 = (0);
var i__10516_11943 = (0);
while(true){
if((i__10516_11943 < count__10515_11942)){
var node_11945 = chunk__10514_11941.cljs$core$IIndexed$_nth$arity$2(null,i__10516_11943);
fragment.appendChild(shadow.dom._to_dom(node_11945));


var G__11948 = seq__10513_11940;
var G__11949 = chunk__10514_11941;
var G__11950 = count__10515_11942;
var G__11951 = (i__10516_11943 + (1));
seq__10513_11940 = G__11948;
chunk__10514_11941 = G__11949;
count__10515_11942 = G__11950;
i__10516_11943 = G__11951;
continue;
} else {
var temp__5804__auto___11952 = cljs.core.seq(seq__10513_11940);
if(temp__5804__auto___11952){
var seq__10513_11953__$1 = temp__5804__auto___11952;
if(cljs.core.chunked_seq_QMARK_(seq__10513_11953__$1)){
var c__5525__auto___11954 = cljs.core.chunk_first(seq__10513_11953__$1);
var G__11955 = cljs.core.chunk_rest(seq__10513_11953__$1);
var G__11956 = c__5525__auto___11954;
var G__11957 = cljs.core.count(c__5525__auto___11954);
var G__11958 = (0);
seq__10513_11940 = G__11955;
chunk__10514_11941 = G__11956;
count__10515_11942 = G__11957;
i__10516_11943 = G__11958;
continue;
} else {
var node_11960 = cljs.core.first(seq__10513_11953__$1);
fragment.appendChild(shadow.dom._to_dom(node_11960));


var G__11961 = cljs.core.next(seq__10513_11953__$1);
var G__11962 = null;
var G__11963 = (0);
var G__11964 = (0);
seq__10513_11940 = G__11961;
chunk__10514_11941 = G__11962;
count__10515_11942 = G__11963;
i__10516_11943 = G__11964;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq10473){
var self__5712__auto__ = this;
return self__5712__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq10473));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__10545_11980 = cljs.core.seq(scripts);
var chunk__10546_11981 = null;
var count__10547_11982 = (0);
var i__10548_11983 = (0);
while(true){
if((i__10548_11983 < count__10547_11982)){
var vec__10566_11984 = chunk__10546_11981.cljs$core$IIndexed$_nth$arity$2(null,i__10548_11983);
var script_tag_11985 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10566_11984,(0),null);
var script_body_11986 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10566_11984,(1),null);
eval(script_body_11986);


var G__11988 = seq__10545_11980;
var G__11989 = chunk__10546_11981;
var G__11990 = count__10547_11982;
var G__11991 = (i__10548_11983 + (1));
seq__10545_11980 = G__11988;
chunk__10546_11981 = G__11989;
count__10547_11982 = G__11990;
i__10548_11983 = G__11991;
continue;
} else {
var temp__5804__auto___11992 = cljs.core.seq(seq__10545_11980);
if(temp__5804__auto___11992){
var seq__10545_11993__$1 = temp__5804__auto___11992;
if(cljs.core.chunked_seq_QMARK_(seq__10545_11993__$1)){
var c__5525__auto___11995 = cljs.core.chunk_first(seq__10545_11993__$1);
var G__11997 = cljs.core.chunk_rest(seq__10545_11993__$1);
var G__11998 = c__5525__auto___11995;
var G__11999 = cljs.core.count(c__5525__auto___11995);
var G__12000 = (0);
seq__10545_11980 = G__11997;
chunk__10546_11981 = G__11998;
count__10547_11982 = G__11999;
i__10548_11983 = G__12000;
continue;
} else {
var vec__10580_12001 = cljs.core.first(seq__10545_11993__$1);
var script_tag_12002 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10580_12001,(0),null);
var script_body_12003 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10580_12001,(1),null);
eval(script_body_12003);


var G__12005 = cljs.core.next(seq__10545_11993__$1);
var G__12006 = null;
var G__12007 = (0);
var G__12008 = (0);
seq__10545_11980 = G__12005;
chunk__10546_11981 = G__12006;
count__10547_11982 = G__12007;
i__10548_11983 = G__12008;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__10587){
var vec__10588 = p__10587;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10588,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10588,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__10619 = arguments.length;
switch (G__10619) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__10648 = cljs.core.seq(style_keys);
var chunk__10649 = null;
var count__10650 = (0);
var i__10651 = (0);
while(true){
if((i__10651 < count__10650)){
var it = chunk__10649.cljs$core$IIndexed$_nth$arity$2(null,i__10651);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__12036 = seq__10648;
var G__12037 = chunk__10649;
var G__12038 = count__10650;
var G__12039 = (i__10651 + (1));
seq__10648 = G__12036;
chunk__10649 = G__12037;
count__10650 = G__12038;
i__10651 = G__12039;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__10648);
if(temp__5804__auto__){
var seq__10648__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10648__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__10648__$1);
var G__12043 = cljs.core.chunk_rest(seq__10648__$1);
var G__12044 = c__5525__auto__;
var G__12045 = cljs.core.count(c__5525__auto__);
var G__12046 = (0);
seq__10648 = G__12043;
chunk__10649 = G__12044;
count__10650 = G__12045;
i__10651 = G__12046;
continue;
} else {
var it = cljs.core.first(seq__10648__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__12048 = cljs.core.next(seq__10648__$1);
var G__12049 = null;
var G__12050 = (0);
var G__12051 = (0);
seq__10648 = G__12048;
chunk__10649 = G__12049;
count__10650 = G__12050;
i__10651 = G__12051;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5300__auto__,k__5301__auto__){
var self__ = this;
var this__5300__auto____$1 = this;
return this__5300__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5301__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5302__auto__,k10685,else__5303__auto__){
var self__ = this;
var this__5302__auto____$1 = this;
var G__10733 = k10685;
var G__10733__$1 = (((G__10733 instanceof cljs.core.Keyword))?G__10733.fqn:null);
switch (G__10733__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k10685,else__5303__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5320__auto__,f__5321__auto__,init__5322__auto__){
var self__ = this;
var this__5320__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5323__auto__,p__10739){
var vec__10740 = p__10739;
var k__5324__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10740,(0),null);
var v__5325__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10740,(1),null);
return (f__5321__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5321__auto__.cljs$core$IFn$_invoke$arity$3(ret__5323__auto__,k__5324__auto__,v__5325__auto__) : f__5321__auto__.call(null,ret__5323__auto__,k__5324__auto__,v__5325__auto__));
}),init__5322__auto__,this__5320__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5315__auto__,writer__5316__auto__,opts__5317__auto__){
var self__ = this;
var this__5315__auto____$1 = this;
var pr_pair__5318__auto__ = (function (keyval__5319__auto__){
return cljs.core.pr_sequential_writer(writer__5316__auto__,cljs.core.pr_writer,""," ","",opts__5317__auto__,keyval__5319__auto__);
});
return cljs.core.pr_sequential_writer(writer__5316__auto__,pr_pair__5318__auto__,"#shadow.dom.Coordinate{",", ","}",opts__5317__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__10684){
var self__ = this;
var G__10684__$1 = this;
return (new cljs.core.RecordIter((0),G__10684__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5298__auto__){
var self__ = this;
var this__5298__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5295__auto__){
var self__ = this;
var this__5295__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5304__auto__){
var self__ = this;
var this__5304__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5296__auto__){
var self__ = this;
var this__5296__auto____$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = (function (coll__5297__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__5297__auto__));
})(this__5296__auto____$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this10687,other10688){
var self__ = this;
var this10687__$1 = this;
return (((!((other10688 == null)))) && ((((this10687__$1.constructor === other10688.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this10687__$1.x,other10688.x)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this10687__$1.y,other10688.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this10687__$1.__extmap,other10688.__extmap)))))))));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5310__auto__,k__5311__auto__){
var self__ = this;
var this__5310__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__5311__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5310__auto____$1),self__.__meta),k__5311__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5311__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5307__auto__,k10685){
var self__ = this;
var this__5307__auto____$1 = this;
var G__10776 = k10685;
var G__10776__$1 = (((G__10776 instanceof cljs.core.Keyword))?G__10776.fqn:null);
switch (G__10776__$1) {
case "x":
case "y":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k10685);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5308__auto__,k__5309__auto__,G__10684){
var self__ = this;
var this__5308__auto____$1 = this;
var pred__10782 = cljs.core.keyword_identical_QMARK_;
var expr__10783 = k__5309__auto__;
if(cljs.core.truth_((pred__10782.cljs$core$IFn$_invoke$arity$2 ? pred__10782.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__10783) : pred__10782.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__10783)))){
return (new shadow.dom.Coordinate(G__10684,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__10782.cljs$core$IFn$_invoke$arity$2 ? pred__10782.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__10783) : pred__10782.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__10783)))){
return (new shadow.dom.Coordinate(self__.x,G__10684,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5309__auto__,G__10684),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5313__auto__){
var self__ = this;
var this__5313__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5299__auto__,G__10684){
var self__ = this;
var this__5299__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__10684,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5305__auto__,entry__5306__auto__){
var self__ = this;
var this__5305__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5306__auto__)){
return this__5305__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__5306__auto__,(0)),cljs.core._nth(entry__5306__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5305__auto____$1,entry__5306__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__5346__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__5346__auto__,writer__5347__auto__){
return cljs.core._write(writer__5347__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__10718){
var extmap__5342__auto__ = (function (){var G__10800 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__10718,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__10718)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__10800);
} else {
return G__10800;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__10718),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__10718),null,cljs.core.not_empty(extmap__5342__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5300__auto__,k__5301__auto__){
var self__ = this;
var this__5300__auto____$1 = this;
return this__5300__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5301__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5302__auto__,k10824,else__5303__auto__){
var self__ = this;
var this__5302__auto____$1 = this;
var G__10833 = k10824;
var G__10833__$1 = (((G__10833 instanceof cljs.core.Keyword))?G__10833.fqn:null);
switch (G__10833__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k10824,else__5303__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5320__auto__,f__5321__auto__,init__5322__auto__){
var self__ = this;
var this__5320__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5323__auto__,p__10836){
var vec__10839 = p__10836;
var k__5324__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10839,(0),null);
var v__5325__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10839,(1),null);
return (f__5321__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5321__auto__.cljs$core$IFn$_invoke$arity$3(ret__5323__auto__,k__5324__auto__,v__5325__auto__) : f__5321__auto__.call(null,ret__5323__auto__,k__5324__auto__,v__5325__auto__));
}),init__5322__auto__,this__5320__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5315__auto__,writer__5316__auto__,opts__5317__auto__){
var self__ = this;
var this__5315__auto____$1 = this;
var pr_pair__5318__auto__ = (function (keyval__5319__auto__){
return cljs.core.pr_sequential_writer(writer__5316__auto__,cljs.core.pr_writer,""," ","",opts__5317__auto__,keyval__5319__auto__);
});
return cljs.core.pr_sequential_writer(writer__5316__auto__,pr_pair__5318__auto__,"#shadow.dom.Size{",", ","}",opts__5317__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__10823){
var self__ = this;
var G__10823__$1 = this;
return (new cljs.core.RecordIter((0),G__10823__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5298__auto__){
var self__ = this;
var this__5298__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5295__auto__){
var self__ = this;
var this__5295__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5304__auto__){
var self__ = this;
var this__5304__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5296__auto__){
var self__ = this;
var this__5296__auto____$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = (function (coll__5297__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__5297__auto__));
})(this__5296__auto____$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this10825,other10826){
var self__ = this;
var this10825__$1 = this;
return (((!((other10826 == null)))) && ((((this10825__$1.constructor === other10826.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this10825__$1.w,other10826.w)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this10825__$1.h,other10826.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this10825__$1.__extmap,other10826.__extmap)))))))));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5310__auto__,k__5311__auto__){
var self__ = this;
var this__5310__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__5311__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5310__auto____$1),self__.__meta),k__5311__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5311__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5307__auto__,k10824){
var self__ = this;
var this__5307__auto____$1 = this;
var G__10894 = k10824;
var G__10894__$1 = (((G__10894 instanceof cljs.core.Keyword))?G__10894.fqn:null);
switch (G__10894__$1) {
case "w":
case "h":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k10824);

}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5308__auto__,k__5309__auto__,G__10823){
var self__ = this;
var this__5308__auto____$1 = this;
var pred__10897 = cljs.core.keyword_identical_QMARK_;
var expr__10898 = k__5309__auto__;
if(cljs.core.truth_((pred__10897.cljs$core$IFn$_invoke$arity$2 ? pred__10897.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__10898) : pred__10897.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__10898)))){
return (new shadow.dom.Size(G__10823,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__10897.cljs$core$IFn$_invoke$arity$2 ? pred__10897.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__10898) : pred__10897.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__10898)))){
return (new shadow.dom.Size(self__.w,G__10823,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5309__auto__,G__10823),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5313__auto__){
var self__ = this;
var this__5313__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5299__auto__,G__10823){
var self__ = this;
var this__5299__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__10823,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5305__auto__,entry__5306__auto__){
var self__ = this;
var this__5305__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5306__auto__)){
return this__5305__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__5306__auto__,(0)),cljs.core._nth(entry__5306__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5305__auto____$1,entry__5306__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__5346__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__5346__auto__,writer__5347__auto__){
return cljs.core._write(writer__5347__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__10827){
var extmap__5342__auto__ = (function (){var G__10922 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__10827,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__10827)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__10922);
} else {
return G__10922;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__10827),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__10827),null,cljs.core.not_empty(extmap__5342__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__5590__auto__ = opts;
var l__5591__auto__ = a__5590__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__5591__auto__)){
var G__12139 = (i + (1));
var G__12140 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__12139;
ret = G__12140;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__10957){
var vec__10959 = p__10957;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10959,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10959,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__10969 = arguments.length;
switch (G__10969) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5802__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5802__auto__)){
var child = temp__5802__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__12144 = ps;
var G__12145 = (i + (1));
el__$1 = G__12144;
i = G__12145;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__11015 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11015,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11015,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11015,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__11026_12152 = cljs.core.seq(props);
var chunk__11027_12153 = null;
var count__11028_12154 = (0);
var i__11029_12155 = (0);
while(true){
if((i__11029_12155 < count__11028_12154)){
var vec__11045_12156 = chunk__11027_12153.cljs$core$IIndexed$_nth$arity$2(null,i__11029_12155);
var k_12157 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11045_12156,(0),null);
var v_12158 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11045_12156,(1),null);
el.setAttributeNS((function (){var temp__5804__auto__ = cljs.core.namespace(k_12157);
if(cljs.core.truth_(temp__5804__auto__)){
var ns = temp__5804__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_12157),v_12158);


var G__12159 = seq__11026_12152;
var G__12160 = chunk__11027_12153;
var G__12161 = count__11028_12154;
var G__12162 = (i__11029_12155 + (1));
seq__11026_12152 = G__12159;
chunk__11027_12153 = G__12160;
count__11028_12154 = G__12161;
i__11029_12155 = G__12162;
continue;
} else {
var temp__5804__auto___12163 = cljs.core.seq(seq__11026_12152);
if(temp__5804__auto___12163){
var seq__11026_12165__$1 = temp__5804__auto___12163;
if(cljs.core.chunked_seq_QMARK_(seq__11026_12165__$1)){
var c__5525__auto___12166 = cljs.core.chunk_first(seq__11026_12165__$1);
var G__12167 = cljs.core.chunk_rest(seq__11026_12165__$1);
var G__12168 = c__5525__auto___12166;
var G__12169 = cljs.core.count(c__5525__auto___12166);
var G__12170 = (0);
seq__11026_12152 = G__12167;
chunk__11027_12153 = G__12168;
count__11028_12154 = G__12169;
i__11029_12155 = G__12170;
continue;
} else {
var vec__11055_12173 = cljs.core.first(seq__11026_12165__$1);
var k_12174 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11055_12173,(0),null);
var v_12175 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11055_12173,(1),null);
el.setAttributeNS((function (){var temp__5804__auto____$1 = cljs.core.namespace(k_12174);
if(cljs.core.truth_(temp__5804__auto____$1)){
var ns = temp__5804__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_12174),v_12175);


var G__12177 = cljs.core.next(seq__11026_12165__$1);
var G__12178 = null;
var G__12179 = (0);
var G__12180 = (0);
seq__11026_12152 = G__12177;
chunk__11027_12153 = G__12178;
count__11028_12154 = G__12179;
i__11029_12155 = G__12180;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__11070 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11070,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11070,(1),null);
var seq__11073_12188 = cljs.core.seq(node_children);
var chunk__11075_12189 = null;
var count__11076_12190 = (0);
var i__11077_12191 = (0);
while(true){
if((i__11077_12191 < count__11076_12190)){
var child_struct_12192 = chunk__11075_12189.cljs$core$IIndexed$_nth$arity$2(null,i__11077_12191);
if((!((child_struct_12192 == null)))){
if(typeof child_struct_12192 === 'string'){
var text_12193 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_12193),child_struct_12192].join(''));
} else {
var children_12194 = shadow.dom.svg_node(child_struct_12192);
if(cljs.core.seq_QMARK_(children_12194)){
var seq__11150_12196 = cljs.core.seq(children_12194);
var chunk__11152_12197 = null;
var count__11153_12198 = (0);
var i__11154_12199 = (0);
while(true){
if((i__11154_12199 < count__11153_12198)){
var child_12200 = chunk__11152_12197.cljs$core$IIndexed$_nth$arity$2(null,i__11154_12199);
if(cljs.core.truth_(child_12200)){
node.appendChild(child_12200);


var G__12205 = seq__11150_12196;
var G__12206 = chunk__11152_12197;
var G__12207 = count__11153_12198;
var G__12208 = (i__11154_12199 + (1));
seq__11150_12196 = G__12205;
chunk__11152_12197 = G__12206;
count__11153_12198 = G__12207;
i__11154_12199 = G__12208;
continue;
} else {
var G__12209 = seq__11150_12196;
var G__12210 = chunk__11152_12197;
var G__12211 = count__11153_12198;
var G__12212 = (i__11154_12199 + (1));
seq__11150_12196 = G__12209;
chunk__11152_12197 = G__12210;
count__11153_12198 = G__12211;
i__11154_12199 = G__12212;
continue;
}
} else {
var temp__5804__auto___12213 = cljs.core.seq(seq__11150_12196);
if(temp__5804__auto___12213){
var seq__11150_12214__$1 = temp__5804__auto___12213;
if(cljs.core.chunked_seq_QMARK_(seq__11150_12214__$1)){
var c__5525__auto___12215 = cljs.core.chunk_first(seq__11150_12214__$1);
var G__12217 = cljs.core.chunk_rest(seq__11150_12214__$1);
var G__12218 = c__5525__auto___12215;
var G__12219 = cljs.core.count(c__5525__auto___12215);
var G__12220 = (0);
seq__11150_12196 = G__12217;
chunk__11152_12197 = G__12218;
count__11153_12198 = G__12219;
i__11154_12199 = G__12220;
continue;
} else {
var child_12221 = cljs.core.first(seq__11150_12214__$1);
if(cljs.core.truth_(child_12221)){
node.appendChild(child_12221);


var G__12225 = cljs.core.next(seq__11150_12214__$1);
var G__12226 = null;
var G__12227 = (0);
var G__12228 = (0);
seq__11150_12196 = G__12225;
chunk__11152_12197 = G__12226;
count__11153_12198 = G__12227;
i__11154_12199 = G__12228;
continue;
} else {
var G__12229 = cljs.core.next(seq__11150_12214__$1);
var G__12230 = null;
var G__12231 = (0);
var G__12232 = (0);
seq__11150_12196 = G__12229;
chunk__11152_12197 = G__12230;
count__11153_12198 = G__12231;
i__11154_12199 = G__12232;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_12194);
}
}


var G__12234 = seq__11073_12188;
var G__12235 = chunk__11075_12189;
var G__12236 = count__11076_12190;
var G__12237 = (i__11077_12191 + (1));
seq__11073_12188 = G__12234;
chunk__11075_12189 = G__12235;
count__11076_12190 = G__12236;
i__11077_12191 = G__12237;
continue;
} else {
var G__12240 = seq__11073_12188;
var G__12241 = chunk__11075_12189;
var G__12242 = count__11076_12190;
var G__12243 = (i__11077_12191 + (1));
seq__11073_12188 = G__12240;
chunk__11075_12189 = G__12241;
count__11076_12190 = G__12242;
i__11077_12191 = G__12243;
continue;
}
} else {
var temp__5804__auto___12244 = cljs.core.seq(seq__11073_12188);
if(temp__5804__auto___12244){
var seq__11073_12245__$1 = temp__5804__auto___12244;
if(cljs.core.chunked_seq_QMARK_(seq__11073_12245__$1)){
var c__5525__auto___12246 = cljs.core.chunk_first(seq__11073_12245__$1);
var G__12249 = cljs.core.chunk_rest(seq__11073_12245__$1);
var G__12250 = c__5525__auto___12246;
var G__12251 = cljs.core.count(c__5525__auto___12246);
var G__12252 = (0);
seq__11073_12188 = G__12249;
chunk__11075_12189 = G__12250;
count__11076_12190 = G__12251;
i__11077_12191 = G__12252;
continue;
} else {
var child_struct_12253 = cljs.core.first(seq__11073_12245__$1);
if((!((child_struct_12253 == null)))){
if(typeof child_struct_12253 === 'string'){
var text_12256 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_12256),child_struct_12253].join(''));
} else {
var children_12257 = shadow.dom.svg_node(child_struct_12253);
if(cljs.core.seq_QMARK_(children_12257)){
var seq__11179_12260 = cljs.core.seq(children_12257);
var chunk__11182_12261 = null;
var count__11183_12262 = (0);
var i__11184_12263 = (0);
while(true){
if((i__11184_12263 < count__11183_12262)){
var child_12264 = chunk__11182_12261.cljs$core$IIndexed$_nth$arity$2(null,i__11184_12263);
if(cljs.core.truth_(child_12264)){
node.appendChild(child_12264);


var G__12265 = seq__11179_12260;
var G__12266 = chunk__11182_12261;
var G__12267 = count__11183_12262;
var G__12268 = (i__11184_12263 + (1));
seq__11179_12260 = G__12265;
chunk__11182_12261 = G__12266;
count__11183_12262 = G__12267;
i__11184_12263 = G__12268;
continue;
} else {
var G__12269 = seq__11179_12260;
var G__12270 = chunk__11182_12261;
var G__12271 = count__11183_12262;
var G__12272 = (i__11184_12263 + (1));
seq__11179_12260 = G__12269;
chunk__11182_12261 = G__12270;
count__11183_12262 = G__12271;
i__11184_12263 = G__12272;
continue;
}
} else {
var temp__5804__auto___12273__$1 = cljs.core.seq(seq__11179_12260);
if(temp__5804__auto___12273__$1){
var seq__11179_12275__$1 = temp__5804__auto___12273__$1;
if(cljs.core.chunked_seq_QMARK_(seq__11179_12275__$1)){
var c__5525__auto___12276 = cljs.core.chunk_first(seq__11179_12275__$1);
var G__12277 = cljs.core.chunk_rest(seq__11179_12275__$1);
var G__12278 = c__5525__auto___12276;
var G__12279 = cljs.core.count(c__5525__auto___12276);
var G__12280 = (0);
seq__11179_12260 = G__12277;
chunk__11182_12261 = G__12278;
count__11183_12262 = G__12279;
i__11184_12263 = G__12280;
continue;
} else {
var child_12281 = cljs.core.first(seq__11179_12275__$1);
if(cljs.core.truth_(child_12281)){
node.appendChild(child_12281);


var G__12282 = cljs.core.next(seq__11179_12275__$1);
var G__12283 = null;
var G__12284 = (0);
var G__12285 = (0);
seq__11179_12260 = G__12282;
chunk__11182_12261 = G__12283;
count__11183_12262 = G__12284;
i__11184_12263 = G__12285;
continue;
} else {
var G__12288 = cljs.core.next(seq__11179_12275__$1);
var G__12289 = null;
var G__12290 = (0);
var G__12291 = (0);
seq__11179_12260 = G__12288;
chunk__11182_12261 = G__12289;
count__11183_12262 = G__12290;
i__11184_12263 = G__12291;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_12257);
}
}


var G__12292 = cljs.core.next(seq__11073_12245__$1);
var G__12293 = null;
var G__12294 = (0);
var G__12295 = (0);
seq__11073_12188 = G__12292;
chunk__11075_12189 = G__12293;
count__11076_12190 = G__12294;
i__11077_12191 = G__12295;
continue;
} else {
var G__12298 = cljs.core.next(seq__11073_12245__$1);
var G__12299 = null;
var G__12300 = (0);
var G__12301 = (0);
seq__11073_12188 = G__12298;
chunk__11075_12189 = G__12299;
count__11076_12190 = G__12300;
i__11077_12191 = G__12301;
continue;
}
}
} else {
}
}
break;
}

return node;
});
(shadow.dom.SVGElement["string"] = true);

(shadow.dom._to_svg["string"] = (function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

(shadow.dom.SVGElement["null"] = true);

(shadow.dom._to_svg["null"] = (function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__5732__auto__ = [];
var len__5726__auto___12307 = arguments.length;
var i__5727__auto___12309 = (0);
while(true){
if((i__5727__auto___12309 < len__5726__auto___12307)){
args__5732__auto__.push((arguments[i__5727__auto___12309]));

var G__12310 = (i__5727__auto___12309 + (1));
i__5727__auto___12309 = G__12310;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((1) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5733__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq11250){
var G__11251 = cljs.core.first(seq11250);
var seq11250__$1 = cljs.core.next(seq11250);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__11251,seq11250__$1);
}));


//# sourceMappingURL=shadow.dom.js.map
