goog.provide('cljs.core.async');
goog.scope(function(){
  cljs.core.async.goog$module$goog$array = goog.module.get('goog.array');
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12468 = (function (f,blockable,meta12469){
this.f = f;
this.blockable = blockable;
this.meta12469 = meta12469;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12468.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12470,meta12469__$1){
var self__ = this;
var _12470__$1 = this;
return (new cljs.core.async.t_cljs$core$async12468(self__.f,self__.blockable,meta12469__$1));
}));

(cljs.core.async.t_cljs$core$async12468.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12470){
var self__ = this;
var _12470__$1 = this;
return self__.meta12469;
}));

(cljs.core.async.t_cljs$core$async12468.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12468.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async12468.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async12468.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async12468.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta12469","meta12469",-917523799,null)], null);
}));

(cljs.core.async.t_cljs$core$async12468.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12468.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12468");

(cljs.core.async.t_cljs$core$async12468.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async12468");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12468.
 */
cljs.core.async.__GT_t_cljs$core$async12468 = (function cljs$core$async$__GT_t_cljs$core$async12468(f,blockable,meta12469){
return (new cljs.core.async.t_cljs$core$async12468(f,blockable,meta12469));
});


cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__12467 = arguments.length;
switch (G__12467) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
return (new cljs.core.async.t_cljs$core$async12468(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__12474 = arguments.length;
switch (G__12474) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__12476 = arguments.length;
switch (G__12476) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__12481 = arguments.length;
switch (G__12481) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_14945 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_14945) : fn1.call(null,val_14945));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_14945) : fn1.call(null,val_14945));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__12488 = arguments.length;
switch (G__12488) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5802__auto__)){
var ret = temp__5802__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5802__auto__)){
var retb = temp__5802__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5593__auto___14947 = n;
var x_14948 = (0);
while(true){
if((x_14948 < n__5593__auto___14947)){
(a[x_14948] = x_14948);

var G__14949 = (x_14948 + (1));
x_14948 = G__14949;
continue;
} else {
}
break;
}

cljs.core.async.goog$module$goog$array.shuffle(a);

return a;
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12496 = (function (flag,meta12497){
this.flag = flag;
this.meta12497 = meta12497;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12496.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12498,meta12497__$1){
var self__ = this;
var _12498__$1 = this;
return (new cljs.core.async.t_cljs$core$async12496(self__.flag,meta12497__$1));
}));

(cljs.core.async.t_cljs$core$async12496.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12498){
var self__ = this;
var _12498__$1 = this;
return self__.meta12497;
}));

(cljs.core.async.t_cljs$core$async12496.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12496.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async12496.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async12496.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async12496.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta12497","meta12497",-417611694,null)], null);
}));

(cljs.core.async.t_cljs$core$async12496.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12496.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12496");

(cljs.core.async.t_cljs$core$async12496.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async12496");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12496.
 */
cljs.core.async.__GT_t_cljs$core$async12496 = (function cljs$core$async$__GT_t_cljs$core$async12496(flag,meta12497){
return (new cljs.core.async.t_cljs$core$async12496(flag,meta12497));
});


cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
return (new cljs.core.async.t_cljs$core$async12496(flag,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12499 = (function (flag,cb,meta12500){
this.flag = flag;
this.cb = cb;
this.meta12500 = meta12500;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12499.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12501,meta12500__$1){
var self__ = this;
var _12501__$1 = this;
return (new cljs.core.async.t_cljs$core$async12499(self__.flag,self__.cb,meta12500__$1));
}));

(cljs.core.async.t_cljs$core$async12499.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12501){
var self__ = this;
var _12501__$1 = this;
return self__.meta12500;
}));

(cljs.core.async.t_cljs$core$async12499.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12499.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async12499.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async12499.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async12499.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta12500","meta12500",-1199561887,null)], null);
}));

(cljs.core.async.t_cljs$core$async12499.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12499.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12499");

(cljs.core.async.t_cljs$core$async12499.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async12499");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12499.
 */
cljs.core.async.__GT_t_cljs$core$async12499 = (function cljs$core$async$__GT_t_cljs$core$async12499(flag,cb,meta12500){
return (new cljs.core.async.t_cljs$core$async12499(flag,cb,meta12500));
});


cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
return (new cljs.core.async.t_cljs$core$async12499(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__12506_SHARP_){
var G__12509 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__12506_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__12509) : fret.call(null,G__12509));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__12507_SHARP_){
var G__12510 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__12507_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__12510) : fret.call(null,G__12510));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__5002__auto__ = wport;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return port;
}
})()], null));
} else {
var G__14962 = (i + (1));
i = G__14962;
continue;
}
} else {
return null;
}
break;
}
})();
var or__5002__auto__ = ret;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5804__auto__ = (function (){var and__5000__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__5000__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__5000__auto__;
}
})();
if(cljs.core.truth_(temp__5804__auto__)){
var got = temp__5804__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5732__auto__ = [];
var len__5726__auto___14967 = arguments.length;
var i__5727__auto___14968 = (0);
while(true){
if((i__5727__auto___14968 < len__5726__auto___14967)){
args__5732__auto__.push((arguments[i__5727__auto___14968]));

var G__14969 = (i__5727__auto___14968 + (1));
i__5727__auto___14968 = G__14969;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((1) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5733__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__12517){
var map__12518 = p__12517;
var map__12518__$1 = cljs.core.__destructure_map(map__12518);
var opts = map__12518__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq12512){
var G__12513 = cljs.core.first(seq12512);
var seq12512__$1 = cljs.core.next(seq12512);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12513,seq12512__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__12531 = arguments.length;
switch (G__12531) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__12372__auto___14977 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12373__auto__ = (function (){var switch__12128__auto__ = (function (state_12555){
var state_val_12556 = (state_12555[(1)]);
if((state_val_12556 === (7))){
var inst_12551 = (state_12555[(2)]);
var state_12555__$1 = state_12555;
var statearr_12557_14978 = state_12555__$1;
(statearr_12557_14978[(2)] = inst_12551);

(statearr_12557_14978[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12556 === (1))){
var state_12555__$1 = state_12555;
var statearr_12558_14980 = state_12555__$1;
(statearr_12558_14980[(2)] = null);

(statearr_12558_14980[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12556 === (4))){
var inst_12534 = (state_12555[(7)]);
var inst_12534__$1 = (state_12555[(2)]);
var inst_12535 = (inst_12534__$1 == null);
var state_12555__$1 = (function (){var statearr_12563 = state_12555;
(statearr_12563[(7)] = inst_12534__$1);

return statearr_12563;
})();
if(cljs.core.truth_(inst_12535)){
var statearr_12565_14982 = state_12555__$1;
(statearr_12565_14982[(1)] = (5));

} else {
var statearr_12566_14983 = state_12555__$1;
(statearr_12566_14983[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12556 === (13))){
var state_12555__$1 = state_12555;
var statearr_12567_14984 = state_12555__$1;
(statearr_12567_14984[(2)] = null);

(statearr_12567_14984[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12556 === (6))){
var inst_12534 = (state_12555[(7)]);
var state_12555__$1 = state_12555;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12555__$1,(11),to,inst_12534);
} else {
if((state_val_12556 === (3))){
var inst_12553 = (state_12555[(2)]);
var state_12555__$1 = state_12555;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12555__$1,inst_12553);
} else {
if((state_val_12556 === (12))){
var state_12555__$1 = state_12555;
var statearr_12570_14985 = state_12555__$1;
(statearr_12570_14985[(2)] = null);

(statearr_12570_14985[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12556 === (2))){
var state_12555__$1 = state_12555;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12555__$1,(4),from);
} else {
if((state_val_12556 === (11))){
var inst_12544 = (state_12555[(2)]);
var state_12555__$1 = state_12555;
if(cljs.core.truth_(inst_12544)){
var statearr_12572_14986 = state_12555__$1;
(statearr_12572_14986[(1)] = (12));

} else {
var statearr_12573_14987 = state_12555__$1;
(statearr_12573_14987[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12556 === (9))){
var state_12555__$1 = state_12555;
var statearr_12574_14988 = state_12555__$1;
(statearr_12574_14988[(2)] = null);

(statearr_12574_14988[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12556 === (5))){
var state_12555__$1 = state_12555;
if(cljs.core.truth_(close_QMARK_)){
var statearr_12575_14989 = state_12555__$1;
(statearr_12575_14989[(1)] = (8));

} else {
var statearr_12576_14990 = state_12555__$1;
(statearr_12576_14990[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12556 === (14))){
var inst_12549 = (state_12555[(2)]);
var state_12555__$1 = state_12555;
var statearr_12577_14991 = state_12555__$1;
(statearr_12577_14991[(2)] = inst_12549);

(statearr_12577_14991[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12556 === (10))){
var inst_12541 = (state_12555[(2)]);
var state_12555__$1 = state_12555;
var statearr_12578_14992 = state_12555__$1;
(statearr_12578_14992[(2)] = inst_12541);

(statearr_12578_14992[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12556 === (8))){
var inst_12538 = cljs.core.async.close_BANG_(to);
var state_12555__$1 = state_12555;
var statearr_12579_14993 = state_12555__$1;
(statearr_12579_14993[(2)] = inst_12538);

(statearr_12579_14993[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__12129__auto__ = null;
var cljs$core$async$state_machine__12129__auto____0 = (function (){
var statearr_12580 = [null,null,null,null,null,null,null,null];
(statearr_12580[(0)] = cljs$core$async$state_machine__12129__auto__);

(statearr_12580[(1)] = (1));

return statearr_12580;
});
var cljs$core$async$state_machine__12129__auto____1 = (function (state_12555){
while(true){
var ret_value__12130__auto__ = (function (){try{while(true){
var result__12131__auto__ = switch__12128__auto__(state_12555);
if(cljs.core.keyword_identical_QMARK_(result__12131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12131__auto__;
}
break;
}
}catch (e12581){var ex__12132__auto__ = e12581;
var statearr_12582_14994 = state_12555;
(statearr_12582_14994[(2)] = ex__12132__auto__);


if(cljs.core.seq((state_12555[(4)]))){
var statearr_12583_14995 = state_12555;
(statearr_12583_14995[(1)] = cljs.core.first((state_12555[(4)])));

} else {
throw ex__12132__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12130__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14996 = state_12555;
state_12555 = G__14996;
continue;
} else {
return ret_value__12130__auto__;
}
break;
}
});
cljs$core$async$state_machine__12129__auto__ = function(state_12555){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12129__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12129__auto____1.call(this,state_12555);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12129__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12129__auto____0;
cljs$core$async$state_machine__12129__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12129__auto____1;
return cljs$core$async$state_machine__12129__auto__;
})()
})();
var state__12374__auto__ = (function (){var statearr_12584 = f__12373__auto__();
(statearr_12584[(6)] = c__12372__auto___14977);

return statearr_12584;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12374__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process__$1 = (function (p__12585){
var vec__12586 = p__12585;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12586,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12586,(1),null);
var job = vec__12586;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__12372__auto___15017 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12373__auto__ = (function (){var switch__12128__auto__ = (function (state_12593){
var state_val_12594 = (state_12593[(1)]);
if((state_val_12594 === (1))){
var state_12593__$1 = state_12593;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12593__$1,(2),res,v);
} else {
if((state_val_12594 === (2))){
var inst_12590 = (state_12593[(2)]);
var inst_12591 = cljs.core.async.close_BANG_(res);
var state_12593__$1 = (function (){var statearr_12595 = state_12593;
(statearr_12595[(7)] = inst_12590);

return statearr_12595;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_12593__$1,inst_12591);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12129__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12129__auto____0 = (function (){
var statearr_12596 = [null,null,null,null,null,null,null,null];
(statearr_12596[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12129__auto__);

(statearr_12596[(1)] = (1));

return statearr_12596;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12129__auto____1 = (function (state_12593){
while(true){
var ret_value__12130__auto__ = (function (){try{while(true){
var result__12131__auto__ = switch__12128__auto__(state_12593);
if(cljs.core.keyword_identical_QMARK_(result__12131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12131__auto__;
}
break;
}
}catch (e12597){var ex__12132__auto__ = e12597;
var statearr_12598_15025 = state_12593;
(statearr_12598_15025[(2)] = ex__12132__auto__);


if(cljs.core.seq((state_12593[(4)]))){
var statearr_12601_15026 = state_12593;
(statearr_12601_15026[(1)] = cljs.core.first((state_12593[(4)])));

} else {
throw ex__12132__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12130__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15027 = state_12593;
state_12593 = G__15027;
continue;
} else {
return ret_value__12130__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12129__auto__ = function(state_12593){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12129__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12129__auto____1.call(this,state_12593);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12129__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12129__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12129__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12129__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12129__auto__;
})()
})();
var state__12374__auto__ = (function (){var statearr_12604 = f__12373__auto__();
(statearr_12604[(6)] = c__12372__auto___15017);

return statearr_12604;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12374__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__12605){
var vec__12606 = p__12605;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12606,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12606,(1),null);
var job = vec__12606;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__5593__auto___15043 = n;
var __15044 = (0);
while(true){
if((__15044 < n__5593__auto___15043)){
var G__12612_15045 = type;
var G__12612_15046__$1 = (((G__12612_15045 instanceof cljs.core.Keyword))?G__12612_15045.fqn:null);
switch (G__12612_15046__$1) {
case "compute":
var c__12372__auto___15049 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__15044,c__12372__auto___15049,G__12612_15045,G__12612_15046__$1,n__5593__auto___15043,jobs,results,process__$1,async){
return (function (){
var f__12373__auto__ = (function (){var switch__12128__auto__ = ((function (__15044,c__12372__auto___15049,G__12612_15045,G__12612_15046__$1,n__5593__auto___15043,jobs,results,process__$1,async){
return (function (state_12628){
var state_val_12629 = (state_12628[(1)]);
if((state_val_12629 === (1))){
var state_12628__$1 = state_12628;
var statearr_12631_15050 = state_12628__$1;
(statearr_12631_15050[(2)] = null);

(statearr_12631_15050[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12629 === (2))){
var state_12628__$1 = state_12628;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12628__$1,(4),jobs);
} else {
if((state_val_12629 === (3))){
var inst_12626 = (state_12628[(2)]);
var state_12628__$1 = state_12628;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12628__$1,inst_12626);
} else {
if((state_val_12629 === (4))){
var inst_12618 = (state_12628[(2)]);
var inst_12619 = process__$1(inst_12618);
var state_12628__$1 = state_12628;
if(cljs.core.truth_(inst_12619)){
var statearr_12637_15057 = state_12628__$1;
(statearr_12637_15057[(1)] = (5));

} else {
var statearr_12638_15058 = state_12628__$1;
(statearr_12638_15058[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12629 === (5))){
var state_12628__$1 = state_12628;
var statearr_12640_15059 = state_12628__$1;
(statearr_12640_15059[(2)] = null);

(statearr_12640_15059[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12629 === (6))){
var state_12628__$1 = state_12628;
var statearr_12641_15060 = state_12628__$1;
(statearr_12641_15060[(2)] = null);

(statearr_12641_15060[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12629 === (7))){
var inst_12624 = (state_12628[(2)]);
var state_12628__$1 = state_12628;
var statearr_12644_15061 = state_12628__$1;
(statearr_12644_15061[(2)] = inst_12624);

(statearr_12644_15061[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__15044,c__12372__auto___15049,G__12612_15045,G__12612_15046__$1,n__5593__auto___15043,jobs,results,process__$1,async))
;
return ((function (__15044,switch__12128__auto__,c__12372__auto___15049,G__12612_15045,G__12612_15046__$1,n__5593__auto___15043,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12129__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12129__auto____0 = (function (){
var statearr_12658 = [null,null,null,null,null,null,null];
(statearr_12658[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12129__auto__);

(statearr_12658[(1)] = (1));

return statearr_12658;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12129__auto____1 = (function (state_12628){
while(true){
var ret_value__12130__auto__ = (function (){try{while(true){
var result__12131__auto__ = switch__12128__auto__(state_12628);
if(cljs.core.keyword_identical_QMARK_(result__12131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12131__auto__;
}
break;
}
}catch (e12662){var ex__12132__auto__ = e12662;
var statearr_12663_15067 = state_12628;
(statearr_12663_15067[(2)] = ex__12132__auto__);


if(cljs.core.seq((state_12628[(4)]))){
var statearr_12664_15068 = state_12628;
(statearr_12664_15068[(1)] = cljs.core.first((state_12628[(4)])));

} else {
throw ex__12132__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12130__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15069 = state_12628;
state_12628 = G__15069;
continue;
} else {
return ret_value__12130__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12129__auto__ = function(state_12628){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12129__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12129__auto____1.call(this,state_12628);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12129__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12129__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12129__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12129__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12129__auto__;
})()
;})(__15044,switch__12128__auto__,c__12372__auto___15049,G__12612_15045,G__12612_15046__$1,n__5593__auto___15043,jobs,results,process__$1,async))
})();
var state__12374__auto__ = (function (){var statearr_12672 = f__12373__auto__();
(statearr_12672[(6)] = c__12372__auto___15049);

return statearr_12672;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12374__auto__);
});})(__15044,c__12372__auto___15049,G__12612_15045,G__12612_15046__$1,n__5593__auto___15043,jobs,results,process__$1,async))
);


break;
case "async":
var c__12372__auto___15070 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__15044,c__12372__auto___15070,G__12612_15045,G__12612_15046__$1,n__5593__auto___15043,jobs,results,process__$1,async){
return (function (){
var f__12373__auto__ = (function (){var switch__12128__auto__ = ((function (__15044,c__12372__auto___15070,G__12612_15045,G__12612_15046__$1,n__5593__auto___15043,jobs,results,process__$1,async){
return (function (state_12687){
var state_val_12688 = (state_12687[(1)]);
if((state_val_12688 === (1))){
var state_12687__$1 = state_12687;
var statearr_12712_15071 = state_12687__$1;
(statearr_12712_15071[(2)] = null);

(statearr_12712_15071[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12688 === (2))){
var state_12687__$1 = state_12687;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12687__$1,(4),jobs);
} else {
if((state_val_12688 === (3))){
var inst_12685 = (state_12687[(2)]);
var state_12687__$1 = state_12687;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12687__$1,inst_12685);
} else {
if((state_val_12688 === (4))){
var inst_12677 = (state_12687[(2)]);
var inst_12678 = async(inst_12677);
var state_12687__$1 = state_12687;
if(cljs.core.truth_(inst_12678)){
var statearr_12717_15074 = state_12687__$1;
(statearr_12717_15074[(1)] = (5));

} else {
var statearr_12719_15075 = state_12687__$1;
(statearr_12719_15075[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12688 === (5))){
var state_12687__$1 = state_12687;
var statearr_12724_15076 = state_12687__$1;
(statearr_12724_15076[(2)] = null);

(statearr_12724_15076[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12688 === (6))){
var state_12687__$1 = state_12687;
var statearr_12725_15077 = state_12687__$1;
(statearr_12725_15077[(2)] = null);

(statearr_12725_15077[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12688 === (7))){
var inst_12683 = (state_12687[(2)]);
var state_12687__$1 = state_12687;
var statearr_12726_15078 = state_12687__$1;
(statearr_12726_15078[(2)] = inst_12683);

(statearr_12726_15078[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__15044,c__12372__auto___15070,G__12612_15045,G__12612_15046__$1,n__5593__auto___15043,jobs,results,process__$1,async))
;
return ((function (__15044,switch__12128__auto__,c__12372__auto___15070,G__12612_15045,G__12612_15046__$1,n__5593__auto___15043,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12129__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12129__auto____0 = (function (){
var statearr_12730 = [null,null,null,null,null,null,null];
(statearr_12730[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12129__auto__);

(statearr_12730[(1)] = (1));

return statearr_12730;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12129__auto____1 = (function (state_12687){
while(true){
var ret_value__12130__auto__ = (function (){try{while(true){
var result__12131__auto__ = switch__12128__auto__(state_12687);
if(cljs.core.keyword_identical_QMARK_(result__12131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12131__auto__;
}
break;
}
}catch (e12733){var ex__12132__auto__ = e12733;
var statearr_12742_15081 = state_12687;
(statearr_12742_15081[(2)] = ex__12132__auto__);


if(cljs.core.seq((state_12687[(4)]))){
var statearr_12749_15082 = state_12687;
(statearr_12749_15082[(1)] = cljs.core.first((state_12687[(4)])));

} else {
throw ex__12132__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12130__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15083 = state_12687;
state_12687 = G__15083;
continue;
} else {
return ret_value__12130__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12129__auto__ = function(state_12687){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12129__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12129__auto____1.call(this,state_12687);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12129__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12129__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12129__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12129__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12129__auto__;
})()
;})(__15044,switch__12128__auto__,c__12372__auto___15070,G__12612_15045,G__12612_15046__$1,n__5593__auto___15043,jobs,results,process__$1,async))
})();
var state__12374__auto__ = (function (){var statearr_12751 = f__12373__auto__();
(statearr_12751[(6)] = c__12372__auto___15070);

return statearr_12751;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12374__auto__);
});})(__15044,c__12372__auto___15070,G__12612_15045,G__12612_15046__$1,n__5593__auto___15043,jobs,results,process__$1,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__12612_15046__$1)].join('')));

}

var G__15087 = (__15044 + (1));
__15044 = G__15087;
continue;
} else {
}
break;
}

var c__12372__auto___15088 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12373__auto__ = (function (){var switch__12128__auto__ = (function (state_12784){
var state_val_12786 = (state_12784[(1)]);
if((state_val_12786 === (7))){
var inst_12779 = (state_12784[(2)]);
var state_12784__$1 = state_12784;
var statearr_12793_15089 = state_12784__$1;
(statearr_12793_15089[(2)] = inst_12779);

(statearr_12793_15089[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12786 === (1))){
var state_12784__$1 = state_12784;
var statearr_12794_15090 = state_12784__$1;
(statearr_12794_15090[(2)] = null);

(statearr_12794_15090[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12786 === (4))){
var inst_12762 = (state_12784[(7)]);
var inst_12762__$1 = (state_12784[(2)]);
var inst_12763 = (inst_12762__$1 == null);
var state_12784__$1 = (function (){var statearr_12798 = state_12784;
(statearr_12798[(7)] = inst_12762__$1);

return statearr_12798;
})();
if(cljs.core.truth_(inst_12763)){
var statearr_12801_15092 = state_12784__$1;
(statearr_12801_15092[(1)] = (5));

} else {
var statearr_12802_15093 = state_12784__$1;
(statearr_12802_15093[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12786 === (6))){
var inst_12768 = (state_12784[(8)]);
var inst_12762 = (state_12784[(7)]);
var inst_12768__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_12769 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_12770 = [inst_12762,inst_12768__$1];
var inst_12771 = (new cljs.core.PersistentVector(null,2,(5),inst_12769,inst_12770,null));
var state_12784__$1 = (function (){var statearr_12803 = state_12784;
(statearr_12803[(8)] = inst_12768__$1);

return statearr_12803;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12784__$1,(8),jobs,inst_12771);
} else {
if((state_val_12786 === (3))){
var inst_12782 = (state_12784[(2)]);
var state_12784__$1 = state_12784;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12784__$1,inst_12782);
} else {
if((state_val_12786 === (2))){
var state_12784__$1 = state_12784;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12784__$1,(4),from);
} else {
if((state_val_12786 === (9))){
var inst_12775 = (state_12784[(2)]);
var state_12784__$1 = (function (){var statearr_12805 = state_12784;
(statearr_12805[(9)] = inst_12775);

return statearr_12805;
})();
var statearr_12806_15097 = state_12784__$1;
(statearr_12806_15097[(2)] = null);

(statearr_12806_15097[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12786 === (5))){
var inst_12765 = cljs.core.async.close_BANG_(jobs);
var state_12784__$1 = state_12784;
var statearr_12807_15098 = state_12784__$1;
(statearr_12807_15098[(2)] = inst_12765);

(statearr_12807_15098[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12786 === (8))){
var inst_12768 = (state_12784[(8)]);
var inst_12773 = (state_12784[(2)]);
var state_12784__$1 = (function (){var statearr_12808 = state_12784;
(statearr_12808[(10)] = inst_12773);

return statearr_12808;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12784__$1,(9),results,inst_12768);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12129__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12129__auto____0 = (function (){
var statearr_12809 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_12809[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12129__auto__);

(statearr_12809[(1)] = (1));

return statearr_12809;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12129__auto____1 = (function (state_12784){
while(true){
var ret_value__12130__auto__ = (function (){try{while(true){
var result__12131__auto__ = switch__12128__auto__(state_12784);
if(cljs.core.keyword_identical_QMARK_(result__12131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12131__auto__;
}
break;
}
}catch (e12810){var ex__12132__auto__ = e12810;
var statearr_12812_15107 = state_12784;
(statearr_12812_15107[(2)] = ex__12132__auto__);


if(cljs.core.seq((state_12784[(4)]))){
var statearr_12813_15108 = state_12784;
(statearr_12813_15108[(1)] = cljs.core.first((state_12784[(4)])));

} else {
throw ex__12132__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12130__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15109 = state_12784;
state_12784 = G__15109;
continue;
} else {
return ret_value__12130__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12129__auto__ = function(state_12784){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12129__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12129__auto____1.call(this,state_12784);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12129__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12129__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12129__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12129__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12129__auto__;
})()
})();
var state__12374__auto__ = (function (){var statearr_12814 = f__12373__auto__();
(statearr_12814[(6)] = c__12372__auto___15088);

return statearr_12814;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12374__auto__);
}));


var c__12372__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12373__auto__ = (function (){var switch__12128__auto__ = (function (state_12853){
var state_val_12854 = (state_12853[(1)]);
if((state_val_12854 === (7))){
var inst_12849 = (state_12853[(2)]);
var state_12853__$1 = state_12853;
var statearr_12868_15113 = state_12853__$1;
(statearr_12868_15113[(2)] = inst_12849);

(statearr_12868_15113[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12854 === (20))){
var state_12853__$1 = state_12853;
var statearr_12873_15114 = state_12853__$1;
(statearr_12873_15114[(2)] = null);

(statearr_12873_15114[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12854 === (1))){
var state_12853__$1 = state_12853;
var statearr_12876_15115 = state_12853__$1;
(statearr_12876_15115[(2)] = null);

(statearr_12876_15115[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12854 === (4))){
var inst_12817 = (state_12853[(7)]);
var inst_12817__$1 = (state_12853[(2)]);
var inst_12818 = (inst_12817__$1 == null);
var state_12853__$1 = (function (){var statearr_12878 = state_12853;
(statearr_12878[(7)] = inst_12817__$1);

return statearr_12878;
})();
if(cljs.core.truth_(inst_12818)){
var statearr_12879_15116 = state_12853__$1;
(statearr_12879_15116[(1)] = (5));

} else {
var statearr_12880_15117 = state_12853__$1;
(statearr_12880_15117[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12854 === (15))){
var inst_12830 = (state_12853[(8)]);
var state_12853__$1 = state_12853;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12853__$1,(18),to,inst_12830);
} else {
if((state_val_12854 === (21))){
var inst_12844 = (state_12853[(2)]);
var state_12853__$1 = state_12853;
var statearr_12882_15118 = state_12853__$1;
(statearr_12882_15118[(2)] = inst_12844);

(statearr_12882_15118[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12854 === (13))){
var inst_12846 = (state_12853[(2)]);
var state_12853__$1 = (function (){var statearr_12883 = state_12853;
(statearr_12883[(9)] = inst_12846);

return statearr_12883;
})();
var statearr_12884_15119 = state_12853__$1;
(statearr_12884_15119[(2)] = null);

(statearr_12884_15119[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12854 === (6))){
var inst_12817 = (state_12853[(7)]);
var state_12853__$1 = state_12853;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12853__$1,(11),inst_12817);
} else {
if((state_val_12854 === (17))){
var inst_12839 = (state_12853[(2)]);
var state_12853__$1 = state_12853;
if(cljs.core.truth_(inst_12839)){
var statearr_12888_15120 = state_12853__$1;
(statearr_12888_15120[(1)] = (19));

} else {
var statearr_12889_15121 = state_12853__$1;
(statearr_12889_15121[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12854 === (3))){
var inst_12851 = (state_12853[(2)]);
var state_12853__$1 = state_12853;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12853__$1,inst_12851);
} else {
if((state_val_12854 === (12))){
var inst_12827 = (state_12853[(10)]);
var state_12853__$1 = state_12853;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12853__$1,(14),inst_12827);
} else {
if((state_val_12854 === (2))){
var state_12853__$1 = state_12853;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12853__$1,(4),results);
} else {
if((state_val_12854 === (19))){
var state_12853__$1 = state_12853;
var statearr_12891_15122 = state_12853__$1;
(statearr_12891_15122[(2)] = null);

(statearr_12891_15122[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12854 === (11))){
var inst_12827 = (state_12853[(2)]);
var state_12853__$1 = (function (){var statearr_12893 = state_12853;
(statearr_12893[(10)] = inst_12827);

return statearr_12893;
})();
var statearr_12894_15126 = state_12853__$1;
(statearr_12894_15126[(2)] = null);

(statearr_12894_15126[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12854 === (9))){
var state_12853__$1 = state_12853;
var statearr_12895_15130 = state_12853__$1;
(statearr_12895_15130[(2)] = null);

(statearr_12895_15130[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12854 === (5))){
var state_12853__$1 = state_12853;
if(cljs.core.truth_(close_QMARK_)){
var statearr_12896_15133 = state_12853__$1;
(statearr_12896_15133[(1)] = (8));

} else {
var statearr_12897_15134 = state_12853__$1;
(statearr_12897_15134[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12854 === (14))){
var inst_12832 = (state_12853[(11)]);
var inst_12830 = (state_12853[(8)]);
var inst_12830__$1 = (state_12853[(2)]);
var inst_12831 = (inst_12830__$1 == null);
var inst_12832__$1 = cljs.core.not(inst_12831);
var state_12853__$1 = (function (){var statearr_12898 = state_12853;
(statearr_12898[(11)] = inst_12832__$1);

(statearr_12898[(8)] = inst_12830__$1);

return statearr_12898;
})();
if(inst_12832__$1){
var statearr_12899_15135 = state_12853__$1;
(statearr_12899_15135[(1)] = (15));

} else {
var statearr_12900_15136 = state_12853__$1;
(statearr_12900_15136[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12854 === (16))){
var inst_12832 = (state_12853[(11)]);
var state_12853__$1 = state_12853;
var statearr_12901_15137 = state_12853__$1;
(statearr_12901_15137[(2)] = inst_12832);

(statearr_12901_15137[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12854 === (10))){
var inst_12824 = (state_12853[(2)]);
var state_12853__$1 = state_12853;
var statearr_12903_15141 = state_12853__$1;
(statearr_12903_15141[(2)] = inst_12824);

(statearr_12903_15141[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12854 === (18))){
var inst_12836 = (state_12853[(2)]);
var state_12853__$1 = state_12853;
var statearr_12904_15144 = state_12853__$1;
(statearr_12904_15144[(2)] = inst_12836);

(statearr_12904_15144[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12854 === (8))){
var inst_12821 = cljs.core.async.close_BANG_(to);
var state_12853__$1 = state_12853;
var statearr_12906_15145 = state_12853__$1;
(statearr_12906_15145[(2)] = inst_12821);

(statearr_12906_15145[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12129__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12129__auto____0 = (function (){
var statearr_12910 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12910[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12129__auto__);

(statearr_12910[(1)] = (1));

return statearr_12910;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12129__auto____1 = (function (state_12853){
while(true){
var ret_value__12130__auto__ = (function (){try{while(true){
var result__12131__auto__ = switch__12128__auto__(state_12853);
if(cljs.core.keyword_identical_QMARK_(result__12131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12131__auto__;
}
break;
}
}catch (e12911){var ex__12132__auto__ = e12911;
var statearr_12912_15150 = state_12853;
(statearr_12912_15150[(2)] = ex__12132__auto__);


if(cljs.core.seq((state_12853[(4)]))){
var statearr_12917_15151 = state_12853;
(statearr_12917_15151[(1)] = cljs.core.first((state_12853[(4)])));

} else {
throw ex__12132__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12130__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15152 = state_12853;
state_12853 = G__15152;
continue;
} else {
return ret_value__12130__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12129__auto__ = function(state_12853){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12129__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12129__auto____1.call(this,state_12853);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12129__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12129__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12129__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12129__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12129__auto__;
})()
})();
var state__12374__auto__ = (function (){var statearr_12939 = f__12373__auto__();
(statearr_12939[(6)] = c__12372__auto__);

return statearr_12939;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12374__auto__);
}));

return c__12372__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). The
 *   presumption is that af will return immediately, having launched some
 *   asynchronous operation whose completion/callback will put results on
 *   the channel, then close! it. Outputs will be returned in order
 *   relative to the inputs. By default, the to channel will be closed
 *   when the from channel closes, but can be determined by the close?
 *   parameter. Will stop consuming the from channel if the to channel
 *   closes. See also pipeline, pipeline-blocking.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__12948 = arguments.length;
switch (G__12948) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__12956 = arguments.length;
switch (G__12956) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__12980 = arguments.length;
switch (G__12980) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__12372__auto___15179 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12373__auto__ = (function (){var switch__12128__auto__ = (function (state_13019){
var state_val_13020 = (state_13019[(1)]);
if((state_val_13020 === (7))){
var inst_13015 = (state_13019[(2)]);
var state_13019__$1 = state_13019;
var statearr_13022_15180 = state_13019__$1;
(statearr_13022_15180[(2)] = inst_13015);

(statearr_13022_15180[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13020 === (1))){
var state_13019__$1 = state_13019;
var statearr_13029_15185 = state_13019__$1;
(statearr_13029_15185[(2)] = null);

(statearr_13029_15185[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13020 === (4))){
var inst_12990 = (state_13019[(7)]);
var inst_12990__$1 = (state_13019[(2)]);
var inst_12991 = (inst_12990__$1 == null);
var state_13019__$1 = (function (){var statearr_13030 = state_13019;
(statearr_13030[(7)] = inst_12990__$1);

return statearr_13030;
})();
if(cljs.core.truth_(inst_12991)){
var statearr_13031_15186 = state_13019__$1;
(statearr_13031_15186[(1)] = (5));

} else {
var statearr_13032_15187 = state_13019__$1;
(statearr_13032_15187[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13020 === (13))){
var state_13019__$1 = state_13019;
var statearr_13036_15188 = state_13019__$1;
(statearr_13036_15188[(2)] = null);

(statearr_13036_15188[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13020 === (6))){
var inst_12990 = (state_13019[(7)]);
var inst_13002 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_12990) : p.call(null,inst_12990));
var state_13019__$1 = state_13019;
if(cljs.core.truth_(inst_13002)){
var statearr_13037_15189 = state_13019__$1;
(statearr_13037_15189[(1)] = (9));

} else {
var statearr_13038_15190 = state_13019__$1;
(statearr_13038_15190[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13020 === (3))){
var inst_13017 = (state_13019[(2)]);
var state_13019__$1 = state_13019;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13019__$1,inst_13017);
} else {
if((state_val_13020 === (12))){
var state_13019__$1 = state_13019;
var statearr_13042_15191 = state_13019__$1;
(statearr_13042_15191[(2)] = null);

(statearr_13042_15191[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13020 === (2))){
var state_13019__$1 = state_13019;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13019__$1,(4),ch);
} else {
if((state_val_13020 === (11))){
var inst_12990 = (state_13019[(7)]);
var inst_13006 = (state_13019[(2)]);
var state_13019__$1 = state_13019;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13019__$1,(8),inst_13006,inst_12990);
} else {
if((state_val_13020 === (9))){
var state_13019__$1 = state_13019;
var statearr_13043_15192 = state_13019__$1;
(statearr_13043_15192[(2)] = tc);

(statearr_13043_15192[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13020 === (5))){
var inst_12993 = cljs.core.async.close_BANG_(tc);
var inst_12994 = cljs.core.async.close_BANG_(fc);
var state_13019__$1 = (function (){var statearr_13044 = state_13019;
(statearr_13044[(8)] = inst_12993);

return statearr_13044;
})();
var statearr_13046_15193 = state_13019__$1;
(statearr_13046_15193[(2)] = inst_12994);

(statearr_13046_15193[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13020 === (14))){
var inst_13013 = (state_13019[(2)]);
var state_13019__$1 = state_13019;
var statearr_13047_15194 = state_13019__$1;
(statearr_13047_15194[(2)] = inst_13013);

(statearr_13047_15194[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13020 === (10))){
var state_13019__$1 = state_13019;
var statearr_13048_15195 = state_13019__$1;
(statearr_13048_15195[(2)] = fc);

(statearr_13048_15195[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13020 === (8))){
var inst_13008 = (state_13019[(2)]);
var state_13019__$1 = state_13019;
if(cljs.core.truth_(inst_13008)){
var statearr_13049_15196 = state_13019__$1;
(statearr_13049_15196[(1)] = (12));

} else {
var statearr_13050_15197 = state_13019__$1;
(statearr_13050_15197[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__12129__auto__ = null;
var cljs$core$async$state_machine__12129__auto____0 = (function (){
var statearr_13051 = [null,null,null,null,null,null,null,null,null];
(statearr_13051[(0)] = cljs$core$async$state_machine__12129__auto__);

(statearr_13051[(1)] = (1));

return statearr_13051;
});
var cljs$core$async$state_machine__12129__auto____1 = (function (state_13019){
while(true){
var ret_value__12130__auto__ = (function (){try{while(true){
var result__12131__auto__ = switch__12128__auto__(state_13019);
if(cljs.core.keyword_identical_QMARK_(result__12131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12131__auto__;
}
break;
}
}catch (e13052){var ex__12132__auto__ = e13052;
var statearr_13053_15201 = state_13019;
(statearr_13053_15201[(2)] = ex__12132__auto__);


if(cljs.core.seq((state_13019[(4)]))){
var statearr_13054_15202 = state_13019;
(statearr_13054_15202[(1)] = cljs.core.first((state_13019[(4)])));

} else {
throw ex__12132__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12130__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15203 = state_13019;
state_13019 = G__15203;
continue;
} else {
return ret_value__12130__auto__;
}
break;
}
});
cljs$core$async$state_machine__12129__auto__ = function(state_13019){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12129__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12129__auto____1.call(this,state_13019);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12129__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12129__auto____0;
cljs$core$async$state_machine__12129__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12129__auto____1;
return cljs$core$async$state_machine__12129__auto__;
})()
})();
var state__12374__auto__ = (function (){var statearr_13055 = f__12373__auto__();
(statearr_13055[(6)] = c__12372__auto___15179);

return statearr_13055;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12374__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__12372__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12373__auto__ = (function (){var switch__12128__auto__ = (function (state_13078){
var state_val_13079 = (state_13078[(1)]);
if((state_val_13079 === (7))){
var inst_13074 = (state_13078[(2)]);
var state_13078__$1 = state_13078;
var statearr_13080_15204 = state_13078__$1;
(statearr_13080_15204[(2)] = inst_13074);

(statearr_13080_15204[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13079 === (1))){
var inst_13057 = init;
var inst_13058 = inst_13057;
var state_13078__$1 = (function (){var statearr_13089 = state_13078;
(statearr_13089[(7)] = inst_13058);

return statearr_13089;
})();
var statearr_13094_15205 = state_13078__$1;
(statearr_13094_15205[(2)] = null);

(statearr_13094_15205[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13079 === (4))){
var inst_13061 = (state_13078[(8)]);
var inst_13061__$1 = (state_13078[(2)]);
var inst_13062 = (inst_13061__$1 == null);
var state_13078__$1 = (function (){var statearr_13103 = state_13078;
(statearr_13103[(8)] = inst_13061__$1);

return statearr_13103;
})();
if(cljs.core.truth_(inst_13062)){
var statearr_13104_15206 = state_13078__$1;
(statearr_13104_15206[(1)] = (5));

} else {
var statearr_13105_15207 = state_13078__$1;
(statearr_13105_15207[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13079 === (6))){
var inst_13058 = (state_13078[(7)]);
var inst_13065 = (state_13078[(9)]);
var inst_13061 = (state_13078[(8)]);
var inst_13065__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_13058,inst_13061) : f.call(null,inst_13058,inst_13061));
var inst_13066 = cljs.core.reduced_QMARK_(inst_13065__$1);
var state_13078__$1 = (function (){var statearr_13107 = state_13078;
(statearr_13107[(9)] = inst_13065__$1);

return statearr_13107;
})();
if(inst_13066){
var statearr_13108_15208 = state_13078__$1;
(statearr_13108_15208[(1)] = (8));

} else {
var statearr_13109_15209 = state_13078__$1;
(statearr_13109_15209[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13079 === (3))){
var inst_13076 = (state_13078[(2)]);
var state_13078__$1 = state_13078;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13078__$1,inst_13076);
} else {
if((state_val_13079 === (2))){
var state_13078__$1 = state_13078;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13078__$1,(4),ch);
} else {
if((state_val_13079 === (9))){
var inst_13065 = (state_13078[(9)]);
var inst_13058 = inst_13065;
var state_13078__$1 = (function (){var statearr_13110 = state_13078;
(statearr_13110[(7)] = inst_13058);

return statearr_13110;
})();
var statearr_13111_15213 = state_13078__$1;
(statearr_13111_15213[(2)] = null);

(statearr_13111_15213[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13079 === (5))){
var inst_13058 = (state_13078[(7)]);
var state_13078__$1 = state_13078;
var statearr_13112_15214 = state_13078__$1;
(statearr_13112_15214[(2)] = inst_13058);

(statearr_13112_15214[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13079 === (10))){
var inst_13072 = (state_13078[(2)]);
var state_13078__$1 = state_13078;
var statearr_13113_15215 = state_13078__$1;
(statearr_13113_15215[(2)] = inst_13072);

(statearr_13113_15215[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13079 === (8))){
var inst_13065 = (state_13078[(9)]);
var inst_13068 = cljs.core.deref(inst_13065);
var state_13078__$1 = state_13078;
var statearr_13114_15216 = state_13078__$1;
(statearr_13114_15216[(2)] = inst_13068);

(statearr_13114_15216[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__12129__auto__ = null;
var cljs$core$async$reduce_$_state_machine__12129__auto____0 = (function (){
var statearr_13115 = [null,null,null,null,null,null,null,null,null,null];
(statearr_13115[(0)] = cljs$core$async$reduce_$_state_machine__12129__auto__);

(statearr_13115[(1)] = (1));

return statearr_13115;
});
var cljs$core$async$reduce_$_state_machine__12129__auto____1 = (function (state_13078){
while(true){
var ret_value__12130__auto__ = (function (){try{while(true){
var result__12131__auto__ = switch__12128__auto__(state_13078);
if(cljs.core.keyword_identical_QMARK_(result__12131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12131__auto__;
}
break;
}
}catch (e13116){var ex__12132__auto__ = e13116;
var statearr_13117_15221 = state_13078;
(statearr_13117_15221[(2)] = ex__12132__auto__);


if(cljs.core.seq((state_13078[(4)]))){
var statearr_13118_15222 = state_13078;
(statearr_13118_15222[(1)] = cljs.core.first((state_13078[(4)])));

} else {
throw ex__12132__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12130__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15223 = state_13078;
state_13078 = G__15223;
continue;
} else {
return ret_value__12130__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__12129__auto__ = function(state_13078){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__12129__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__12129__auto____1.call(this,state_13078);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__12129__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__12129__auto____0;
cljs$core$async$reduce_$_state_machine__12129__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__12129__auto____1;
return cljs$core$async$reduce_$_state_machine__12129__auto__;
})()
})();
var state__12374__auto__ = (function (){var statearr_13120 = f__12373__auto__();
(statearr_13120[(6)] = c__12372__auto__);

return statearr_13120;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12374__auto__);
}));

return c__12372__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__12372__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12373__auto__ = (function (){var switch__12128__auto__ = (function (state_13127){
var state_val_13128 = (state_13127[(1)]);
if((state_val_13128 === (1))){
var inst_13121 = cljs.core.async.reduce(f__$1,init,ch);
var state_13127__$1 = state_13127;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13127__$1,(2),inst_13121);
} else {
if((state_val_13128 === (2))){
var inst_13123 = (state_13127[(2)]);
var inst_13124 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_13123) : f__$1.call(null,inst_13123));
var state_13127__$1 = state_13127;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13127__$1,inst_13124);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__12129__auto__ = null;
var cljs$core$async$transduce_$_state_machine__12129__auto____0 = (function (){
var statearr_13131 = [null,null,null,null,null,null,null];
(statearr_13131[(0)] = cljs$core$async$transduce_$_state_machine__12129__auto__);

(statearr_13131[(1)] = (1));

return statearr_13131;
});
var cljs$core$async$transduce_$_state_machine__12129__auto____1 = (function (state_13127){
while(true){
var ret_value__12130__auto__ = (function (){try{while(true){
var result__12131__auto__ = switch__12128__auto__(state_13127);
if(cljs.core.keyword_identical_QMARK_(result__12131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12131__auto__;
}
break;
}
}catch (e13132){var ex__12132__auto__ = e13132;
var statearr_13133_15231 = state_13127;
(statearr_13133_15231[(2)] = ex__12132__auto__);


if(cljs.core.seq((state_13127[(4)]))){
var statearr_13137_15233 = state_13127;
(statearr_13137_15233[(1)] = cljs.core.first((state_13127[(4)])));

} else {
throw ex__12132__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12130__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15235 = state_13127;
state_13127 = G__15235;
continue;
} else {
return ret_value__12130__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__12129__auto__ = function(state_13127){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__12129__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__12129__auto____1.call(this,state_13127);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__12129__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__12129__auto____0;
cljs$core$async$transduce_$_state_machine__12129__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__12129__auto____1;
return cljs$core$async$transduce_$_state_machine__12129__auto__;
})()
})();
var state__12374__auto__ = (function (){var statearr_13138 = f__12373__auto__();
(statearr_13138[(6)] = c__12372__auto__);

return statearr_13138;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12374__auto__);
}));

return c__12372__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__13140 = arguments.length;
switch (G__13140) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__12372__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12373__auto__ = (function (){var switch__12128__auto__ = (function (state_13166){
var state_val_13167 = (state_13166[(1)]);
if((state_val_13167 === (7))){
var inst_13148 = (state_13166[(2)]);
var state_13166__$1 = state_13166;
var statearr_13168_15238 = state_13166__$1;
(statearr_13168_15238[(2)] = inst_13148);

(statearr_13168_15238[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13167 === (1))){
var inst_13141 = cljs.core.seq(coll);
var inst_13142 = inst_13141;
var state_13166__$1 = (function (){var statearr_13172 = state_13166;
(statearr_13172[(7)] = inst_13142);

return statearr_13172;
})();
var statearr_13173_15240 = state_13166__$1;
(statearr_13173_15240[(2)] = null);

(statearr_13173_15240[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13167 === (4))){
var inst_13142 = (state_13166[(7)]);
var inst_13146 = cljs.core.first(inst_13142);
var state_13166__$1 = state_13166;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13166__$1,(7),ch,inst_13146);
} else {
if((state_val_13167 === (13))){
var inst_13160 = (state_13166[(2)]);
var state_13166__$1 = state_13166;
var statearr_13178_15241 = state_13166__$1;
(statearr_13178_15241[(2)] = inst_13160);

(statearr_13178_15241[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13167 === (6))){
var inst_13151 = (state_13166[(2)]);
var state_13166__$1 = state_13166;
if(cljs.core.truth_(inst_13151)){
var statearr_13179_15242 = state_13166__$1;
(statearr_13179_15242[(1)] = (8));

} else {
var statearr_13180_15243 = state_13166__$1;
(statearr_13180_15243[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13167 === (3))){
var inst_13164 = (state_13166[(2)]);
var state_13166__$1 = state_13166;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13166__$1,inst_13164);
} else {
if((state_val_13167 === (12))){
var state_13166__$1 = state_13166;
var statearr_13181_15248 = state_13166__$1;
(statearr_13181_15248[(2)] = null);

(statearr_13181_15248[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13167 === (2))){
var inst_13142 = (state_13166[(7)]);
var state_13166__$1 = state_13166;
if(cljs.core.truth_(inst_13142)){
var statearr_13183_15250 = state_13166__$1;
(statearr_13183_15250[(1)] = (4));

} else {
var statearr_13184_15251 = state_13166__$1;
(statearr_13184_15251[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13167 === (11))){
var inst_13157 = cljs.core.async.close_BANG_(ch);
var state_13166__$1 = state_13166;
var statearr_13185_15252 = state_13166__$1;
(statearr_13185_15252[(2)] = inst_13157);

(statearr_13185_15252[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13167 === (9))){
var state_13166__$1 = state_13166;
if(cljs.core.truth_(close_QMARK_)){
var statearr_13186_15253 = state_13166__$1;
(statearr_13186_15253[(1)] = (11));

} else {
var statearr_13187_15254 = state_13166__$1;
(statearr_13187_15254[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13167 === (5))){
var inst_13142 = (state_13166[(7)]);
var state_13166__$1 = state_13166;
var statearr_13189_15255 = state_13166__$1;
(statearr_13189_15255[(2)] = inst_13142);

(statearr_13189_15255[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13167 === (10))){
var inst_13162 = (state_13166[(2)]);
var state_13166__$1 = state_13166;
var statearr_13190_15256 = state_13166__$1;
(statearr_13190_15256[(2)] = inst_13162);

(statearr_13190_15256[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13167 === (8))){
var inst_13142 = (state_13166[(7)]);
var inst_13153 = cljs.core.next(inst_13142);
var inst_13142__$1 = inst_13153;
var state_13166__$1 = (function (){var statearr_13191 = state_13166;
(statearr_13191[(7)] = inst_13142__$1);

return statearr_13191;
})();
var statearr_13192_15257 = state_13166__$1;
(statearr_13192_15257[(2)] = null);

(statearr_13192_15257[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__12129__auto__ = null;
var cljs$core$async$state_machine__12129__auto____0 = (function (){
var statearr_13193 = [null,null,null,null,null,null,null,null];
(statearr_13193[(0)] = cljs$core$async$state_machine__12129__auto__);

(statearr_13193[(1)] = (1));

return statearr_13193;
});
var cljs$core$async$state_machine__12129__auto____1 = (function (state_13166){
while(true){
var ret_value__12130__auto__ = (function (){try{while(true){
var result__12131__auto__ = switch__12128__auto__(state_13166);
if(cljs.core.keyword_identical_QMARK_(result__12131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12131__auto__;
}
break;
}
}catch (e13194){var ex__12132__auto__ = e13194;
var statearr_13195_15261 = state_13166;
(statearr_13195_15261[(2)] = ex__12132__auto__);


if(cljs.core.seq((state_13166[(4)]))){
var statearr_13196_15262 = state_13166;
(statearr_13196_15262[(1)] = cljs.core.first((state_13166[(4)])));

} else {
throw ex__12132__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12130__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15263 = state_13166;
state_13166 = G__15263;
continue;
} else {
return ret_value__12130__auto__;
}
break;
}
});
cljs$core$async$state_machine__12129__auto__ = function(state_13166){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12129__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12129__auto____1.call(this,state_13166);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12129__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12129__auto____0;
cljs$core$async$state_machine__12129__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12129__auto____1;
return cljs$core$async$state_machine__12129__auto__;
})()
})();
var state__12374__auto__ = (function (){var statearr_13198 = f__12373__auto__();
(statearr_13198[(6)] = c__12372__auto__);

return statearr_13198;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12374__auto__);
}));

return c__12372__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__13204 = arguments.length;
switch (G__13204) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_15268 = (function (_){
var x__5350__auto__ = (((_ == null))?null:_);
var m__5351__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5351__auto__.call(null,_));
} else {
var m__5349__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5349__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_15268(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_15270 = (function (m,ch,close_QMARK_){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5351__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__5349__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5349__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_15270(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_15271 = (function (m,ch){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5351__auto__.call(null,m,ch));
} else {
var m__5349__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5349__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_15271(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_15275 = (function (m){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5351__auto__.call(null,m));
} else {
var m__5349__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5349__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_15275(m);
}
});


/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13229 = (function (ch,cs,meta13230){
this.ch = ch;
this.cs = cs;
this.meta13230 = meta13230;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async13229.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13231,meta13230__$1){
var self__ = this;
var _13231__$1 = this;
return (new cljs.core.async.t_cljs$core$async13229(self__.ch,self__.cs,meta13230__$1));
}));

(cljs.core.async.t_cljs$core$async13229.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13231){
var self__ = this;
var _13231__$1 = this;
return self__.meta13230;
}));

(cljs.core.async.t_cljs$core$async13229.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13229.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async13229.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13229.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async13229.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async13229.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async13229.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta13230","meta13230",1532436611,null)], null);
}));

(cljs.core.async.t_cljs$core$async13229.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async13229.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13229");

(cljs.core.async.t_cljs$core$async13229.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async13229");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async13229.
 */
cljs.core.async.__GT_t_cljs$core$async13229 = (function cljs$core$async$__GT_t_cljs$core$async13229(ch,cs,meta13230){
return (new cljs.core.async.t_cljs$core$async13229(ch,cs,meta13230));
});


/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (new cljs.core.async.t_cljs$core$async13229(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__12372__auto___15286 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12373__auto__ = (function (){var switch__12128__auto__ = (function (state_13385){
var state_val_13386 = (state_13385[(1)]);
if((state_val_13386 === (7))){
var inst_13381 = (state_13385[(2)]);
var state_13385__$1 = state_13385;
var statearr_13388_15287 = state_13385__$1;
(statearr_13388_15287[(2)] = inst_13381);

(statearr_13388_15287[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13386 === (20))){
var inst_13273 = (state_13385[(7)]);
var inst_13292 = cljs.core.first(inst_13273);
var inst_13293 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13292,(0),null);
var inst_13294 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13292,(1),null);
var state_13385__$1 = (function (){var statearr_13394 = state_13385;
(statearr_13394[(8)] = inst_13293);

return statearr_13394;
})();
if(cljs.core.truth_(inst_13294)){
var statearr_13395_15297 = state_13385__$1;
(statearr_13395_15297[(1)] = (22));

} else {
var statearr_13398_15299 = state_13385__$1;
(statearr_13398_15299[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13386 === (27))){
var inst_13241 = (state_13385[(9)]);
var inst_13334 = (state_13385[(10)]);
var inst_13329 = (state_13385[(11)]);
var inst_13327 = (state_13385[(12)]);
var inst_13334__$1 = cljs.core._nth(inst_13327,inst_13329);
var inst_13335 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_13334__$1,inst_13241,done);
var state_13385__$1 = (function (){var statearr_13399 = state_13385;
(statearr_13399[(10)] = inst_13334__$1);

return statearr_13399;
})();
if(cljs.core.truth_(inst_13335)){
var statearr_13400_15306 = state_13385__$1;
(statearr_13400_15306[(1)] = (30));

} else {
var statearr_13401_15307 = state_13385__$1;
(statearr_13401_15307[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13386 === (1))){
var state_13385__$1 = state_13385;
var statearr_13402_15311 = state_13385__$1;
(statearr_13402_15311[(2)] = null);

(statearr_13402_15311[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13386 === (24))){
var inst_13273 = (state_13385[(7)]);
var inst_13300 = (state_13385[(2)]);
var inst_13301 = cljs.core.next(inst_13273);
var inst_13251 = inst_13301;
var inst_13252 = null;
var inst_13253 = (0);
var inst_13254 = (0);
var state_13385__$1 = (function (){var statearr_13404 = state_13385;
(statearr_13404[(13)] = inst_13300);

(statearr_13404[(14)] = inst_13251);

(statearr_13404[(15)] = inst_13252);

(statearr_13404[(16)] = inst_13253);

(statearr_13404[(17)] = inst_13254);

return statearr_13404;
})();
var statearr_13409_15312 = state_13385__$1;
(statearr_13409_15312[(2)] = null);

(statearr_13409_15312[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13386 === (39))){
var state_13385__$1 = state_13385;
var statearr_13414_15313 = state_13385__$1;
(statearr_13414_15313[(2)] = null);

(statearr_13414_15313[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13386 === (4))){
var inst_13241 = (state_13385[(9)]);
var inst_13241__$1 = (state_13385[(2)]);
var inst_13242 = (inst_13241__$1 == null);
var state_13385__$1 = (function (){var statearr_13415 = state_13385;
(statearr_13415[(9)] = inst_13241__$1);

return statearr_13415;
})();
if(cljs.core.truth_(inst_13242)){
var statearr_13416_15317 = state_13385__$1;
(statearr_13416_15317[(1)] = (5));

} else {
var statearr_13417_15318 = state_13385__$1;
(statearr_13417_15318[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13386 === (15))){
var inst_13251 = (state_13385[(14)]);
var inst_13252 = (state_13385[(15)]);
var inst_13253 = (state_13385[(16)]);
var inst_13254 = (state_13385[(17)]);
var inst_13269 = (state_13385[(2)]);
var inst_13270 = (inst_13254 + (1));
var tmp13411 = inst_13251;
var tmp13412 = inst_13252;
var tmp13413 = inst_13253;
var inst_13251__$1 = tmp13411;
var inst_13252__$1 = tmp13412;
var inst_13253__$1 = tmp13413;
var inst_13254__$1 = inst_13270;
var state_13385__$1 = (function (){var statearr_13420 = state_13385;
(statearr_13420[(14)] = inst_13251__$1);

(statearr_13420[(15)] = inst_13252__$1);

(statearr_13420[(16)] = inst_13253__$1);

(statearr_13420[(18)] = inst_13269);

(statearr_13420[(17)] = inst_13254__$1);

return statearr_13420;
})();
var statearr_13421_15326 = state_13385__$1;
(statearr_13421_15326[(2)] = null);

(statearr_13421_15326[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13386 === (21))){
var inst_13304 = (state_13385[(2)]);
var state_13385__$1 = state_13385;
var statearr_13429_15330 = state_13385__$1;
(statearr_13429_15330[(2)] = inst_13304);

(statearr_13429_15330[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13386 === (31))){
var inst_13334 = (state_13385[(10)]);
var inst_13339 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_13334);
var state_13385__$1 = state_13385;
var statearr_13430_15331 = state_13385__$1;
(statearr_13430_15331[(2)] = inst_13339);

(statearr_13430_15331[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13386 === (32))){
var inst_13328 = (state_13385[(19)]);
var inst_13329 = (state_13385[(11)]);
var inst_13327 = (state_13385[(12)]);
var inst_13326 = (state_13385[(20)]);
var inst_13341 = (state_13385[(2)]);
var inst_13342 = (inst_13329 + (1));
var tmp13422 = inst_13328;
var tmp13423 = inst_13327;
var tmp13424 = inst_13326;
var inst_13326__$1 = tmp13424;
var inst_13327__$1 = tmp13423;
var inst_13328__$1 = tmp13422;
var inst_13329__$1 = inst_13342;
var state_13385__$1 = (function (){var statearr_13431 = state_13385;
(statearr_13431[(21)] = inst_13341);

(statearr_13431[(19)] = inst_13328__$1);

(statearr_13431[(11)] = inst_13329__$1);

(statearr_13431[(12)] = inst_13327__$1);

(statearr_13431[(20)] = inst_13326__$1);

return statearr_13431;
})();
var statearr_13432_15332 = state_13385__$1;
(statearr_13432_15332[(2)] = null);

(statearr_13432_15332[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13386 === (40))){
var inst_13354 = (state_13385[(22)]);
var inst_13358 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_13354);
var state_13385__$1 = state_13385;
var statearr_13434_15339 = state_13385__$1;
(statearr_13434_15339[(2)] = inst_13358);

(statearr_13434_15339[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13386 === (33))){
var inst_13345 = (state_13385[(23)]);
var inst_13347 = cljs.core.chunked_seq_QMARK_(inst_13345);
var state_13385__$1 = state_13385;
if(inst_13347){
var statearr_13435_15347 = state_13385__$1;
(statearr_13435_15347[(1)] = (36));

} else {
var statearr_13436_15348 = state_13385__$1;
(statearr_13436_15348[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13386 === (13))){
var inst_13263 = (state_13385[(24)]);
var inst_13266 = cljs.core.async.close_BANG_(inst_13263);
var state_13385__$1 = state_13385;
var statearr_13437_15352 = state_13385__$1;
(statearr_13437_15352[(2)] = inst_13266);

(statearr_13437_15352[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13386 === (22))){
var inst_13293 = (state_13385[(8)]);
var inst_13297 = cljs.core.async.close_BANG_(inst_13293);
var state_13385__$1 = state_13385;
var statearr_13438_15356 = state_13385__$1;
(statearr_13438_15356[(2)] = inst_13297);

(statearr_13438_15356[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13386 === (36))){
var inst_13345 = (state_13385[(23)]);
var inst_13349 = cljs.core.chunk_first(inst_13345);
var inst_13350 = cljs.core.chunk_rest(inst_13345);
var inst_13351 = cljs.core.count(inst_13349);
var inst_13326 = inst_13350;
var inst_13327 = inst_13349;
var inst_13328 = inst_13351;
var inst_13329 = (0);
var state_13385__$1 = (function (){var statearr_13440 = state_13385;
(statearr_13440[(19)] = inst_13328);

(statearr_13440[(11)] = inst_13329);

(statearr_13440[(12)] = inst_13327);

(statearr_13440[(20)] = inst_13326);

return statearr_13440;
})();
var statearr_13441_15361 = state_13385__$1;
(statearr_13441_15361[(2)] = null);

(statearr_13441_15361[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13386 === (41))){
var inst_13345 = (state_13385[(23)]);
var inst_13360 = (state_13385[(2)]);
var inst_13361 = cljs.core.next(inst_13345);
var inst_13326 = inst_13361;
var inst_13327 = null;
var inst_13328 = (0);
var inst_13329 = (0);
var state_13385__$1 = (function (){var statearr_13442 = state_13385;
(statearr_13442[(19)] = inst_13328);

(statearr_13442[(11)] = inst_13329);

(statearr_13442[(12)] = inst_13327);

(statearr_13442[(20)] = inst_13326);

(statearr_13442[(25)] = inst_13360);

return statearr_13442;
})();
var statearr_13443_15362 = state_13385__$1;
(statearr_13443_15362[(2)] = null);

(statearr_13443_15362[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13386 === (43))){
var state_13385__$1 = state_13385;
var statearr_13444_15363 = state_13385__$1;
(statearr_13444_15363[(2)] = null);

(statearr_13444_15363[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13386 === (29))){
var inst_13369 = (state_13385[(2)]);
var state_13385__$1 = state_13385;
var statearr_13445_15364 = state_13385__$1;
(statearr_13445_15364[(2)] = inst_13369);

(statearr_13445_15364[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13386 === (44))){
var inst_13378 = (state_13385[(2)]);
var state_13385__$1 = (function (){var statearr_13447 = state_13385;
(statearr_13447[(26)] = inst_13378);

return statearr_13447;
})();
var statearr_13448_15371 = state_13385__$1;
(statearr_13448_15371[(2)] = null);

(statearr_13448_15371[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13386 === (6))){
var inst_13314 = (state_13385[(27)]);
var inst_13313 = cljs.core.deref(cs);
var inst_13314__$1 = cljs.core.keys(inst_13313);
var inst_13316 = cljs.core.count(inst_13314__$1);
var inst_13317 = cljs.core.reset_BANG_(dctr,inst_13316);
var inst_13325 = cljs.core.seq(inst_13314__$1);
var inst_13326 = inst_13325;
var inst_13327 = null;
var inst_13328 = (0);
var inst_13329 = (0);
var state_13385__$1 = (function (){var statearr_13453 = state_13385;
(statearr_13453[(28)] = inst_13317);

(statearr_13453[(19)] = inst_13328);

(statearr_13453[(27)] = inst_13314__$1);

(statearr_13453[(11)] = inst_13329);

(statearr_13453[(12)] = inst_13327);

(statearr_13453[(20)] = inst_13326);

return statearr_13453;
})();
var statearr_13454_15372 = state_13385__$1;
(statearr_13454_15372[(2)] = null);

(statearr_13454_15372[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13386 === (28))){
var inst_13345 = (state_13385[(23)]);
var inst_13326 = (state_13385[(20)]);
var inst_13345__$1 = cljs.core.seq(inst_13326);
var state_13385__$1 = (function (){var statearr_13455 = state_13385;
(statearr_13455[(23)] = inst_13345__$1);

return statearr_13455;
})();
if(inst_13345__$1){
var statearr_13456_15373 = state_13385__$1;
(statearr_13456_15373[(1)] = (33));

} else {
var statearr_13457_15374 = state_13385__$1;
(statearr_13457_15374[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13386 === (25))){
var inst_13328 = (state_13385[(19)]);
var inst_13329 = (state_13385[(11)]);
var inst_13331 = (inst_13329 < inst_13328);
var inst_13332 = inst_13331;
var state_13385__$1 = state_13385;
if(cljs.core.truth_(inst_13332)){
var statearr_13458_15375 = state_13385__$1;
(statearr_13458_15375[(1)] = (27));

} else {
var statearr_13459_15376 = state_13385__$1;
(statearr_13459_15376[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13386 === (34))){
var state_13385__$1 = state_13385;
var statearr_13461_15377 = state_13385__$1;
(statearr_13461_15377[(2)] = null);

(statearr_13461_15377[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13386 === (17))){
var state_13385__$1 = state_13385;
var statearr_13462_15378 = state_13385__$1;
(statearr_13462_15378[(2)] = null);

(statearr_13462_15378[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13386 === (3))){
var inst_13383 = (state_13385[(2)]);
var state_13385__$1 = state_13385;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13385__$1,inst_13383);
} else {
if((state_val_13386 === (12))){
var inst_13309 = (state_13385[(2)]);
var state_13385__$1 = state_13385;
var statearr_13463_15379 = state_13385__$1;
(statearr_13463_15379[(2)] = inst_13309);

(statearr_13463_15379[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13386 === (2))){
var state_13385__$1 = state_13385;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13385__$1,(4),ch);
} else {
if((state_val_13386 === (23))){
var state_13385__$1 = state_13385;
var statearr_13465_15380 = state_13385__$1;
(statearr_13465_15380[(2)] = null);

(statearr_13465_15380[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13386 === (35))){
var inst_13367 = (state_13385[(2)]);
var state_13385__$1 = state_13385;
var statearr_13466_15381 = state_13385__$1;
(statearr_13466_15381[(2)] = inst_13367);

(statearr_13466_15381[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13386 === (19))){
var inst_13273 = (state_13385[(7)]);
var inst_13283 = cljs.core.chunk_first(inst_13273);
var inst_13284 = cljs.core.chunk_rest(inst_13273);
var inst_13285 = cljs.core.count(inst_13283);
var inst_13251 = inst_13284;
var inst_13252 = inst_13283;
var inst_13253 = inst_13285;
var inst_13254 = (0);
var state_13385__$1 = (function (){var statearr_13468 = state_13385;
(statearr_13468[(14)] = inst_13251);

(statearr_13468[(15)] = inst_13252);

(statearr_13468[(16)] = inst_13253);

(statearr_13468[(17)] = inst_13254);

return statearr_13468;
})();
var statearr_13469_15382 = state_13385__$1;
(statearr_13469_15382[(2)] = null);

(statearr_13469_15382[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13386 === (11))){
var inst_13251 = (state_13385[(14)]);
var inst_13273 = (state_13385[(7)]);
var inst_13273__$1 = cljs.core.seq(inst_13251);
var state_13385__$1 = (function (){var statearr_13470 = state_13385;
(statearr_13470[(7)] = inst_13273__$1);

return statearr_13470;
})();
if(inst_13273__$1){
var statearr_13475_15383 = state_13385__$1;
(statearr_13475_15383[(1)] = (16));

} else {
var statearr_13476_15384 = state_13385__$1;
(statearr_13476_15384[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13386 === (9))){
var inst_13311 = (state_13385[(2)]);
var state_13385__$1 = state_13385;
var statearr_13478_15385 = state_13385__$1;
(statearr_13478_15385[(2)] = inst_13311);

(statearr_13478_15385[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13386 === (5))){
var inst_13249 = cljs.core.deref(cs);
var inst_13250 = cljs.core.seq(inst_13249);
var inst_13251 = inst_13250;
var inst_13252 = null;
var inst_13253 = (0);
var inst_13254 = (0);
var state_13385__$1 = (function (){var statearr_13479 = state_13385;
(statearr_13479[(14)] = inst_13251);

(statearr_13479[(15)] = inst_13252);

(statearr_13479[(16)] = inst_13253);

(statearr_13479[(17)] = inst_13254);

return statearr_13479;
})();
var statearr_13480_15386 = state_13385__$1;
(statearr_13480_15386[(2)] = null);

(statearr_13480_15386[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13386 === (14))){
var state_13385__$1 = state_13385;
var statearr_13482_15387 = state_13385__$1;
(statearr_13482_15387[(2)] = null);

(statearr_13482_15387[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13386 === (45))){
var inst_13375 = (state_13385[(2)]);
var state_13385__$1 = state_13385;
var statearr_13484_15388 = state_13385__$1;
(statearr_13484_15388[(2)] = inst_13375);

(statearr_13484_15388[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13386 === (26))){
var inst_13314 = (state_13385[(27)]);
var inst_13371 = (state_13385[(2)]);
var inst_13372 = cljs.core.seq(inst_13314);
var state_13385__$1 = (function (){var statearr_13485 = state_13385;
(statearr_13485[(29)] = inst_13371);

return statearr_13485;
})();
if(inst_13372){
var statearr_13487_15391 = state_13385__$1;
(statearr_13487_15391[(1)] = (42));

} else {
var statearr_13491_15392 = state_13385__$1;
(statearr_13491_15392[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13386 === (16))){
var inst_13273 = (state_13385[(7)]);
var inst_13275 = cljs.core.chunked_seq_QMARK_(inst_13273);
var state_13385__$1 = state_13385;
if(inst_13275){
var statearr_13492_15393 = state_13385__$1;
(statearr_13492_15393[(1)] = (19));

} else {
var statearr_13493_15394 = state_13385__$1;
(statearr_13493_15394[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13386 === (38))){
var inst_13364 = (state_13385[(2)]);
var state_13385__$1 = state_13385;
var statearr_13495_15395 = state_13385__$1;
(statearr_13495_15395[(2)] = inst_13364);

(statearr_13495_15395[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13386 === (30))){
var state_13385__$1 = state_13385;
var statearr_13496_15396 = state_13385__$1;
(statearr_13496_15396[(2)] = null);

(statearr_13496_15396[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13386 === (10))){
var inst_13252 = (state_13385[(15)]);
var inst_13254 = (state_13385[(17)]);
var inst_13262 = cljs.core._nth(inst_13252,inst_13254);
var inst_13263 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13262,(0),null);
var inst_13264 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13262,(1),null);
var state_13385__$1 = (function (){var statearr_13497 = state_13385;
(statearr_13497[(24)] = inst_13263);

return statearr_13497;
})();
if(cljs.core.truth_(inst_13264)){
var statearr_13498_15397 = state_13385__$1;
(statearr_13498_15397[(1)] = (13));

} else {
var statearr_13499_15398 = state_13385__$1;
(statearr_13499_15398[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13386 === (18))){
var inst_13307 = (state_13385[(2)]);
var state_13385__$1 = state_13385;
var statearr_13500_15399 = state_13385__$1;
(statearr_13500_15399[(2)] = inst_13307);

(statearr_13500_15399[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13386 === (42))){
var state_13385__$1 = state_13385;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13385__$1,(45),dchan);
} else {
if((state_val_13386 === (37))){
var inst_13241 = (state_13385[(9)]);
var inst_13354 = (state_13385[(22)]);
var inst_13345 = (state_13385[(23)]);
var inst_13354__$1 = cljs.core.first(inst_13345);
var inst_13355 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_13354__$1,inst_13241,done);
var state_13385__$1 = (function (){var statearr_13502 = state_13385;
(statearr_13502[(22)] = inst_13354__$1);

return statearr_13502;
})();
if(cljs.core.truth_(inst_13355)){
var statearr_13503_15400 = state_13385__$1;
(statearr_13503_15400[(1)] = (39));

} else {
var statearr_13504_15402 = state_13385__$1;
(statearr_13504_15402[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13386 === (8))){
var inst_13253 = (state_13385[(16)]);
var inst_13254 = (state_13385[(17)]);
var inst_13256 = (inst_13254 < inst_13253);
var inst_13257 = inst_13256;
var state_13385__$1 = state_13385;
if(cljs.core.truth_(inst_13257)){
var statearr_13505_15403 = state_13385__$1;
(statearr_13505_15403[(1)] = (10));

} else {
var statearr_13506_15404 = state_13385__$1;
(statearr_13506_15404[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__12129__auto__ = null;
var cljs$core$async$mult_$_state_machine__12129__auto____0 = (function (){
var statearr_13507 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13507[(0)] = cljs$core$async$mult_$_state_machine__12129__auto__);

(statearr_13507[(1)] = (1));

return statearr_13507;
});
var cljs$core$async$mult_$_state_machine__12129__auto____1 = (function (state_13385){
while(true){
var ret_value__12130__auto__ = (function (){try{while(true){
var result__12131__auto__ = switch__12128__auto__(state_13385);
if(cljs.core.keyword_identical_QMARK_(result__12131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12131__auto__;
}
break;
}
}catch (e13509){var ex__12132__auto__ = e13509;
var statearr_13510_15405 = state_13385;
(statearr_13510_15405[(2)] = ex__12132__auto__);


if(cljs.core.seq((state_13385[(4)]))){
var statearr_13511_15406 = state_13385;
(statearr_13511_15406[(1)] = cljs.core.first((state_13385[(4)])));

} else {
throw ex__12132__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12130__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15407 = state_13385;
state_13385 = G__15407;
continue;
} else {
return ret_value__12130__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__12129__auto__ = function(state_13385){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__12129__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__12129__auto____1.call(this,state_13385);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__12129__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__12129__auto____0;
cljs$core$async$mult_$_state_machine__12129__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__12129__auto____1;
return cljs$core$async$mult_$_state_machine__12129__auto__;
})()
})();
var state__12374__auto__ = (function (){var statearr_13513 = f__12373__auto__();
(statearr_13513[(6)] = c__12372__auto___15286);

return statearr_13513;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12374__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__13518 = arguments.length;
switch (G__13518) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_15411 = (function (m,ch){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5351__auto__.call(null,m,ch));
} else {
var m__5349__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5349__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_15411(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_15413 = (function (m,ch){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5351__auto__.call(null,m,ch));
} else {
var m__5349__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5349__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_15413(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_15445 = (function (m){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5351__auto__.call(null,m));
} else {
var m__5349__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5349__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_15445(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_15446 = (function (m,state_map){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5351__auto__.call(null,m,state_map));
} else {
var m__5349__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5349__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_15446(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_15449 = (function (m,mode){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5351__auto__.call(null,m,mode));
} else {
var m__5349__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5349__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_15449(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5732__auto__ = [];
var len__5726__auto___15451 = arguments.length;
var i__5727__auto___15452 = (0);
while(true){
if((i__5727__auto___15452 < len__5726__auto___15451)){
args__5732__auto__.push((arguments[i__5727__auto___15452]));

var G__15453 = (i__5727__auto___15452 + (1));
i__5727__auto___15452 = G__15453;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((3) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5733__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__13540){
var map__13541 = p__13540;
var map__13541__$1 = cljs.core.__destructure_map(map__13541);
var opts = map__13541__$1;
var statearr_13542_15454 = state;
(statearr_13542_15454[(1)] = cont_block);


var temp__5804__auto__ = cljs.core.async.do_alts((function (val){
var statearr_13543_15455 = state;
(statearr_13543_15455[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5804__auto__)){
var cb = temp__5804__auto__;
var statearr_13544_15456 = state;
(statearr_13544_15456[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq13535){
var G__13536 = cljs.core.first(seq13535);
var seq13535__$1 = cljs.core.next(seq13535);
var G__13537 = cljs.core.first(seq13535__$1);
var seq13535__$2 = cljs.core.next(seq13535__$1);
var G__13538 = cljs.core.first(seq13535__$2);
var seq13535__$3 = cljs.core.next(seq13535__$2);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__13536,G__13537,G__13538,seq13535__$3);
}));


/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13551 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta13552){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta13552 = meta13552;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async13551.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13553,meta13552__$1){
var self__ = this;
var _13553__$1 = this;
return (new cljs.core.async.t_cljs$core$async13551(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta13552__$1));
}));

(cljs.core.async.t_cljs$core$async13551.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13553){
var self__ = this;
var _13553__$1 = this;
return self__.meta13552;
}));

(cljs.core.async.t_cljs$core$async13551.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13551.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async13551.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13551.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async13551.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async13551.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async13551.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async13551.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async13551.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta13552","meta13552",169689971,null)], null);
}));

(cljs.core.async.t_cljs$core$async13551.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async13551.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13551");

(cljs.core.async.t_cljs$core$async13551.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async13551");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async13551.
 */
cljs.core.async.__GT_t_cljs$core$async13551 = (function cljs$core$async$__GT_t_cljs$core$async13551(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta13552){
return (new cljs.core.async.t_cljs$core$async13551(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta13552));
});


/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (new cljs.core.async.t_cljs$core$async13551(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
var c__12372__auto___15490 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12373__auto__ = (function (){var switch__12128__auto__ = (function (state_13629){
var state_val_13630 = (state_13629[(1)]);
if((state_val_13630 === (7))){
var inst_13589 = (state_13629[(2)]);
var state_13629__$1 = state_13629;
if(cljs.core.truth_(inst_13589)){
var statearr_13634_15497 = state_13629__$1;
(statearr_13634_15497[(1)] = (8));

} else {
var statearr_13635_15498 = state_13629__$1;
(statearr_13635_15498[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13630 === (20))){
var inst_13582 = (state_13629[(7)]);
var state_13629__$1 = state_13629;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13629__$1,(23),out,inst_13582);
} else {
if((state_val_13630 === (1))){
var inst_13565 = calc_state();
var inst_13566 = cljs.core.__destructure_map(inst_13565);
var inst_13567 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_13566,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_13568 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_13566,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_13569 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_13566,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_13570 = inst_13565;
var state_13629__$1 = (function (){var statearr_13637 = state_13629;
(statearr_13637[(8)] = inst_13569);

(statearr_13637[(9)] = inst_13567);

(statearr_13637[(10)] = inst_13570);

(statearr_13637[(11)] = inst_13568);

return statearr_13637;
})();
var statearr_13639_15515 = state_13629__$1;
(statearr_13639_15515[(2)] = null);

(statearr_13639_15515[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13630 === (24))){
var inst_13573 = (state_13629[(12)]);
var inst_13570 = inst_13573;
var state_13629__$1 = (function (){var statearr_13640 = state_13629;
(statearr_13640[(10)] = inst_13570);

return statearr_13640;
})();
var statearr_13641_15516 = state_13629__$1;
(statearr_13641_15516[(2)] = null);

(statearr_13641_15516[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13630 === (4))){
var inst_13584 = (state_13629[(13)]);
var inst_13582 = (state_13629[(7)]);
var inst_13581 = (state_13629[(2)]);
var inst_13582__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13581,(0),null);
var inst_13583 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13581,(1),null);
var inst_13584__$1 = (inst_13582__$1 == null);
var state_13629__$1 = (function (){var statearr_13642 = state_13629;
(statearr_13642[(13)] = inst_13584__$1);

(statearr_13642[(7)] = inst_13582__$1);

(statearr_13642[(14)] = inst_13583);

return statearr_13642;
})();
if(cljs.core.truth_(inst_13584__$1)){
var statearr_13643_15517 = state_13629__$1;
(statearr_13643_15517[(1)] = (5));

} else {
var statearr_13644_15518 = state_13629__$1;
(statearr_13644_15518[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13630 === (15))){
var inst_13603 = (state_13629[(15)]);
var inst_13574 = (state_13629[(16)]);
var inst_13603__$1 = cljs.core.empty_QMARK_(inst_13574);
var state_13629__$1 = (function (){var statearr_13682 = state_13629;
(statearr_13682[(15)] = inst_13603__$1);

return statearr_13682;
})();
if(inst_13603__$1){
var statearr_13683_15519 = state_13629__$1;
(statearr_13683_15519[(1)] = (17));

} else {
var statearr_13684_15520 = state_13629__$1;
(statearr_13684_15520[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13630 === (21))){
var inst_13573 = (state_13629[(12)]);
var inst_13570 = inst_13573;
var state_13629__$1 = (function (){var statearr_13686 = state_13629;
(statearr_13686[(10)] = inst_13570);

return statearr_13686;
})();
var statearr_13688_15522 = state_13629__$1;
(statearr_13688_15522[(2)] = null);

(statearr_13688_15522[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13630 === (13))){
var inst_13596 = (state_13629[(2)]);
var inst_13597 = calc_state();
var inst_13570 = inst_13597;
var state_13629__$1 = (function (){var statearr_13691 = state_13629;
(statearr_13691[(10)] = inst_13570);

(statearr_13691[(17)] = inst_13596);

return statearr_13691;
})();
var statearr_13693_15531 = state_13629__$1;
(statearr_13693_15531[(2)] = null);

(statearr_13693_15531[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13630 === (22))){
var inst_13623 = (state_13629[(2)]);
var state_13629__$1 = state_13629;
var statearr_13696_15532 = state_13629__$1;
(statearr_13696_15532[(2)] = inst_13623);

(statearr_13696_15532[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13630 === (6))){
var inst_13583 = (state_13629[(14)]);
var inst_13587 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_13583,change);
var state_13629__$1 = state_13629;
var statearr_13699_15533 = state_13629__$1;
(statearr_13699_15533[(2)] = inst_13587);

(statearr_13699_15533[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13630 === (25))){
var state_13629__$1 = state_13629;
var statearr_13701_15537 = state_13629__$1;
(statearr_13701_15537[(2)] = null);

(statearr_13701_15537[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13630 === (17))){
var inst_13583 = (state_13629[(14)]);
var inst_13575 = (state_13629[(18)]);
var inst_13605 = (inst_13575.cljs$core$IFn$_invoke$arity$1 ? inst_13575.cljs$core$IFn$_invoke$arity$1(inst_13583) : inst_13575.call(null,inst_13583));
var inst_13606 = cljs.core.not(inst_13605);
var state_13629__$1 = state_13629;
var statearr_13705_15538 = state_13629__$1;
(statearr_13705_15538[(2)] = inst_13606);

(statearr_13705_15538[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13630 === (3))){
var inst_13627 = (state_13629[(2)]);
var state_13629__$1 = state_13629;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13629__$1,inst_13627);
} else {
if((state_val_13630 === (12))){
var state_13629__$1 = state_13629;
var statearr_13707_15539 = state_13629__$1;
(statearr_13707_15539[(2)] = null);

(statearr_13707_15539[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13630 === (2))){
var inst_13573 = (state_13629[(12)]);
var inst_13570 = (state_13629[(10)]);
var inst_13573__$1 = cljs.core.__destructure_map(inst_13570);
var inst_13574 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_13573__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_13575 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_13573__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_13576 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_13573__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_13629__$1 = (function (){var statearr_13711 = state_13629;
(statearr_13711[(12)] = inst_13573__$1);

(statearr_13711[(18)] = inst_13575);

(statearr_13711[(16)] = inst_13574);

return statearr_13711;
})();
return cljs.core.async.ioc_alts_BANG_(state_13629__$1,(4),inst_13576);
} else {
if((state_val_13630 === (23))){
var inst_13614 = (state_13629[(2)]);
var state_13629__$1 = state_13629;
if(cljs.core.truth_(inst_13614)){
var statearr_13716_15542 = state_13629__$1;
(statearr_13716_15542[(1)] = (24));

} else {
var statearr_13718_15543 = state_13629__$1;
(statearr_13718_15543[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13630 === (19))){
var inst_13609 = (state_13629[(2)]);
var state_13629__$1 = state_13629;
var statearr_13719_15544 = state_13629__$1;
(statearr_13719_15544[(2)] = inst_13609);

(statearr_13719_15544[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13630 === (11))){
var inst_13583 = (state_13629[(14)]);
var inst_13593 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_13583);
var state_13629__$1 = state_13629;
var statearr_13721_15545 = state_13629__$1;
(statearr_13721_15545[(2)] = inst_13593);

(statearr_13721_15545[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13630 === (9))){
var inst_13583 = (state_13629[(14)]);
var inst_13600 = (state_13629[(19)]);
var inst_13574 = (state_13629[(16)]);
var inst_13600__$1 = (inst_13574.cljs$core$IFn$_invoke$arity$1 ? inst_13574.cljs$core$IFn$_invoke$arity$1(inst_13583) : inst_13574.call(null,inst_13583));
var state_13629__$1 = (function (){var statearr_13773 = state_13629;
(statearr_13773[(19)] = inst_13600__$1);

return statearr_13773;
})();
if(cljs.core.truth_(inst_13600__$1)){
var statearr_13774_15546 = state_13629__$1;
(statearr_13774_15546[(1)] = (14));

} else {
var statearr_13777_15547 = state_13629__$1;
(statearr_13777_15547[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13630 === (5))){
var inst_13584 = (state_13629[(13)]);
var state_13629__$1 = state_13629;
var statearr_13779_15548 = state_13629__$1;
(statearr_13779_15548[(2)] = inst_13584);

(statearr_13779_15548[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13630 === (14))){
var inst_13600 = (state_13629[(19)]);
var state_13629__$1 = state_13629;
var statearr_13781_15549 = state_13629__$1;
(statearr_13781_15549[(2)] = inst_13600);

(statearr_13781_15549[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13630 === (26))){
var inst_13619 = (state_13629[(2)]);
var state_13629__$1 = state_13629;
var statearr_13785_15550 = state_13629__$1;
(statearr_13785_15550[(2)] = inst_13619);

(statearr_13785_15550[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13630 === (16))){
var inst_13611 = (state_13629[(2)]);
var state_13629__$1 = state_13629;
if(cljs.core.truth_(inst_13611)){
var statearr_13787_15551 = state_13629__$1;
(statearr_13787_15551[(1)] = (20));

} else {
var statearr_13788_15552 = state_13629__$1;
(statearr_13788_15552[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13630 === (10))){
var inst_13625 = (state_13629[(2)]);
var state_13629__$1 = state_13629;
var statearr_13792_15553 = state_13629__$1;
(statearr_13792_15553[(2)] = inst_13625);

(statearr_13792_15553[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13630 === (18))){
var inst_13603 = (state_13629[(15)]);
var state_13629__$1 = state_13629;
var statearr_13793_15554 = state_13629__$1;
(statearr_13793_15554[(2)] = inst_13603);

(statearr_13793_15554[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13630 === (8))){
var inst_13582 = (state_13629[(7)]);
var inst_13591 = (inst_13582 == null);
var state_13629__$1 = state_13629;
if(cljs.core.truth_(inst_13591)){
var statearr_13794_15555 = state_13629__$1;
(statearr_13794_15555[(1)] = (11));

} else {
var statearr_13795_15556 = state_13629__$1;
(statearr_13795_15556[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__12129__auto__ = null;
var cljs$core$async$mix_$_state_machine__12129__auto____0 = (function (){
var statearr_13796 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13796[(0)] = cljs$core$async$mix_$_state_machine__12129__auto__);

(statearr_13796[(1)] = (1));

return statearr_13796;
});
var cljs$core$async$mix_$_state_machine__12129__auto____1 = (function (state_13629){
while(true){
var ret_value__12130__auto__ = (function (){try{while(true){
var result__12131__auto__ = switch__12128__auto__(state_13629);
if(cljs.core.keyword_identical_QMARK_(result__12131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12131__auto__;
}
break;
}
}catch (e13797){var ex__12132__auto__ = e13797;
var statearr_13798_15557 = state_13629;
(statearr_13798_15557[(2)] = ex__12132__auto__);


if(cljs.core.seq((state_13629[(4)]))){
var statearr_13799_15558 = state_13629;
(statearr_13799_15558[(1)] = cljs.core.first((state_13629[(4)])));

} else {
throw ex__12132__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12130__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15559 = state_13629;
state_13629 = G__15559;
continue;
} else {
return ret_value__12130__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__12129__auto__ = function(state_13629){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__12129__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__12129__auto____1.call(this,state_13629);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__12129__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__12129__auto____0;
cljs$core$async$mix_$_state_machine__12129__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__12129__auto____1;
return cljs$core$async$mix_$_state_machine__12129__auto__;
})()
})();
var state__12374__auto__ = (function (){var statearr_13800 = f__12373__auto__();
(statearr_13800[(6)] = c__12372__auto___15490);

return statearr_13800;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12374__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_15560 = (function (p,v,ch,close_QMARK_){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5351__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__5349__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5349__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_15560(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_15561 = (function (p,v,ch){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5351__auto__.call(null,p,v,ch));
} else {
var m__5349__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5349__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_15561(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_15567 = (function() {
var G__15568 = null;
var G__15568__1 = (function (p){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5351__auto__.call(null,p));
} else {
var m__5349__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5349__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__15568__2 = (function (p,v){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5351__auto__.call(null,p,v));
} else {
var m__5349__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5349__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__15568 = function(p,v){
switch(arguments.length){
case 1:
return G__15568__1.call(this,p);
case 2:
return G__15568__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__15568.cljs$core$IFn$_invoke$arity$1 = G__15568__1;
G__15568.cljs$core$IFn$_invoke$arity$2 = G__15568__2;
return G__15568;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__13866 = arguments.length;
switch (G__13866) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_15567(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_15567(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);



/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13879 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta13880){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta13880 = meta13880;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async13879.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13881,meta13880__$1){
var self__ = this;
var _13881__$1 = this;
return (new cljs.core.async.t_cljs$core$async13879(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta13880__$1));
}));

(cljs.core.async.t_cljs$core$async13879.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13881){
var self__ = this;
var _13881__$1 = this;
return self__.meta13880;
}));

(cljs.core.async.t_cljs$core$async13879.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13879.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async13879.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13879.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async13879.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5804__auto__)){
var m = temp__5804__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async13879.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async13879.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async13879.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta13880","meta13880",789274293,null)], null);
}));

(cljs.core.async.t_cljs$core$async13879.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async13879.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13879");

(cljs.core.async.t_cljs$core$async13879.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async13879");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async13879.
 */
cljs.core.async.__GT_t_cljs$core$async13879 = (function cljs$core$async$__GT_t_cljs$core$async13879(ch,topic_fn,buf_fn,mults,ensure_mult,meta13880){
return (new cljs.core.async.t_cljs$core$async13879(ch,topic_fn,buf_fn,mults,ensure_mult,meta13880));
});


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__13870 = arguments.length;
switch (G__13870) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__5002__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__13868_SHARP_){
if(cljs.core.truth_((p1__13868_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__13868_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__13868_SHARP_.call(null,topic)))){
return p1__13868_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__13868_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (new cljs.core.async.t_cljs$core$async13879(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
var c__12372__auto___15601 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12373__auto__ = (function (){var switch__12128__auto__ = (function (state_13966){
var state_val_13967 = (state_13966[(1)]);
if((state_val_13967 === (7))){
var inst_13962 = (state_13966[(2)]);
var state_13966__$1 = state_13966;
var statearr_13972_15602 = state_13966__$1;
(statearr_13972_15602[(2)] = inst_13962);

(statearr_13972_15602[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13967 === (20))){
var state_13966__$1 = state_13966;
var statearr_13973_15603 = state_13966__$1;
(statearr_13973_15603[(2)] = null);

(statearr_13973_15603[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13967 === (1))){
var state_13966__$1 = state_13966;
var statearr_13978_15604 = state_13966__$1;
(statearr_13978_15604[(2)] = null);

(statearr_13978_15604[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13967 === (24))){
var inst_13944 = (state_13966[(7)]);
var inst_13953 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_13944);
var state_13966__$1 = state_13966;
var statearr_13979_15605 = state_13966__$1;
(statearr_13979_15605[(2)] = inst_13953);

(statearr_13979_15605[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13967 === (4))){
var inst_13894 = (state_13966[(8)]);
var inst_13894__$1 = (state_13966[(2)]);
var inst_13895 = (inst_13894__$1 == null);
var state_13966__$1 = (function (){var statearr_13980 = state_13966;
(statearr_13980[(8)] = inst_13894__$1);

return statearr_13980;
})();
if(cljs.core.truth_(inst_13895)){
var statearr_13981_15606 = state_13966__$1;
(statearr_13981_15606[(1)] = (5));

} else {
var statearr_13982_15607 = state_13966__$1;
(statearr_13982_15607[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13967 === (15))){
var inst_13938 = (state_13966[(2)]);
var state_13966__$1 = state_13966;
var statearr_13983_15609 = state_13966__$1;
(statearr_13983_15609[(2)] = inst_13938);

(statearr_13983_15609[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13967 === (21))){
var inst_13959 = (state_13966[(2)]);
var state_13966__$1 = (function (){var statearr_13984 = state_13966;
(statearr_13984[(9)] = inst_13959);

return statearr_13984;
})();
var statearr_13985_15610 = state_13966__$1;
(statearr_13985_15610[(2)] = null);

(statearr_13985_15610[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13967 === (13))){
var inst_13918 = (state_13966[(10)]);
var inst_13920 = cljs.core.chunked_seq_QMARK_(inst_13918);
var state_13966__$1 = state_13966;
if(inst_13920){
var statearr_13986_15611 = state_13966__$1;
(statearr_13986_15611[(1)] = (16));

} else {
var statearr_13987_15612 = state_13966__$1;
(statearr_13987_15612[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13967 === (22))){
var inst_13950 = (state_13966[(2)]);
var state_13966__$1 = state_13966;
if(cljs.core.truth_(inst_13950)){
var statearr_13988_15613 = state_13966__$1;
(statearr_13988_15613[(1)] = (23));

} else {
var statearr_13989_15618 = state_13966__$1;
(statearr_13989_15618[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13967 === (6))){
var inst_13946 = (state_13966[(11)]);
var inst_13944 = (state_13966[(7)]);
var inst_13894 = (state_13966[(8)]);
var inst_13944__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_13894) : topic_fn.call(null,inst_13894));
var inst_13945 = cljs.core.deref(mults);
var inst_13946__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_13945,inst_13944__$1);
var state_13966__$1 = (function (){var statearr_13990 = state_13966;
(statearr_13990[(11)] = inst_13946__$1);

(statearr_13990[(7)] = inst_13944__$1);

return statearr_13990;
})();
if(cljs.core.truth_(inst_13946__$1)){
var statearr_13991_15622 = state_13966__$1;
(statearr_13991_15622[(1)] = (19));

} else {
var statearr_13994_15623 = state_13966__$1;
(statearr_13994_15623[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13967 === (25))){
var inst_13956 = (state_13966[(2)]);
var state_13966__$1 = state_13966;
var statearr_13995_15624 = state_13966__$1;
(statearr_13995_15624[(2)] = inst_13956);

(statearr_13995_15624[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13967 === (17))){
var inst_13918 = (state_13966[(10)]);
var inst_13929 = cljs.core.first(inst_13918);
var inst_13930 = cljs.core.async.muxch_STAR_(inst_13929);
var inst_13931 = cljs.core.async.close_BANG_(inst_13930);
var inst_13932 = cljs.core.next(inst_13918);
var inst_13904 = inst_13932;
var inst_13905 = null;
var inst_13906 = (0);
var inst_13907 = (0);
var state_13966__$1 = (function (){var statearr_13996 = state_13966;
(statearr_13996[(12)] = inst_13931);

(statearr_13996[(13)] = inst_13906);

(statearr_13996[(14)] = inst_13905);

(statearr_13996[(15)] = inst_13904);

(statearr_13996[(16)] = inst_13907);

return statearr_13996;
})();
var statearr_13997_15625 = state_13966__$1;
(statearr_13997_15625[(2)] = null);

(statearr_13997_15625[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13967 === (3))){
var inst_13964 = (state_13966[(2)]);
var state_13966__$1 = state_13966;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13966__$1,inst_13964);
} else {
if((state_val_13967 === (12))){
var inst_13940 = (state_13966[(2)]);
var state_13966__$1 = state_13966;
var statearr_13998_15626 = state_13966__$1;
(statearr_13998_15626[(2)] = inst_13940);

(statearr_13998_15626[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13967 === (2))){
var state_13966__$1 = state_13966;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13966__$1,(4),ch);
} else {
if((state_val_13967 === (23))){
var state_13966__$1 = state_13966;
var statearr_14023_15627 = state_13966__$1;
(statearr_14023_15627[(2)] = null);

(statearr_14023_15627[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13967 === (19))){
var inst_13946 = (state_13966[(11)]);
var inst_13894 = (state_13966[(8)]);
var inst_13948 = cljs.core.async.muxch_STAR_(inst_13946);
var state_13966__$1 = state_13966;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13966__$1,(22),inst_13948,inst_13894);
} else {
if((state_val_13967 === (11))){
var inst_13904 = (state_13966[(15)]);
var inst_13918 = (state_13966[(10)]);
var inst_13918__$1 = cljs.core.seq(inst_13904);
var state_13966__$1 = (function (){var statearr_14024 = state_13966;
(statearr_14024[(10)] = inst_13918__$1);

return statearr_14024;
})();
if(inst_13918__$1){
var statearr_14025_15628 = state_13966__$1;
(statearr_14025_15628[(1)] = (13));

} else {
var statearr_14026_15630 = state_13966__$1;
(statearr_14026_15630[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13967 === (9))){
var inst_13942 = (state_13966[(2)]);
var state_13966__$1 = state_13966;
var statearr_14027_15632 = state_13966__$1;
(statearr_14027_15632[(2)] = inst_13942);

(statearr_14027_15632[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13967 === (5))){
var inst_13901 = cljs.core.deref(mults);
var inst_13902 = cljs.core.vals(inst_13901);
var inst_13903 = cljs.core.seq(inst_13902);
var inst_13904 = inst_13903;
var inst_13905 = null;
var inst_13906 = (0);
var inst_13907 = (0);
var state_13966__$1 = (function (){var statearr_14028 = state_13966;
(statearr_14028[(13)] = inst_13906);

(statearr_14028[(14)] = inst_13905);

(statearr_14028[(15)] = inst_13904);

(statearr_14028[(16)] = inst_13907);

return statearr_14028;
})();
var statearr_14029_15634 = state_13966__$1;
(statearr_14029_15634[(2)] = null);

(statearr_14029_15634[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13967 === (14))){
var state_13966__$1 = state_13966;
var statearr_14035_15635 = state_13966__$1;
(statearr_14035_15635[(2)] = null);

(statearr_14035_15635[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13967 === (16))){
var inst_13918 = (state_13966[(10)]);
var inst_13923 = cljs.core.chunk_first(inst_13918);
var inst_13924 = cljs.core.chunk_rest(inst_13918);
var inst_13925 = cljs.core.count(inst_13923);
var inst_13904 = inst_13924;
var inst_13905 = inst_13923;
var inst_13906 = inst_13925;
var inst_13907 = (0);
var state_13966__$1 = (function (){var statearr_14038 = state_13966;
(statearr_14038[(13)] = inst_13906);

(statearr_14038[(14)] = inst_13905);

(statearr_14038[(15)] = inst_13904);

(statearr_14038[(16)] = inst_13907);

return statearr_14038;
})();
var statearr_14039_15636 = state_13966__$1;
(statearr_14039_15636[(2)] = null);

(statearr_14039_15636[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13967 === (10))){
var inst_13906 = (state_13966[(13)]);
var inst_13905 = (state_13966[(14)]);
var inst_13904 = (state_13966[(15)]);
var inst_13907 = (state_13966[(16)]);
var inst_13912 = cljs.core._nth(inst_13905,inst_13907);
var inst_13913 = cljs.core.async.muxch_STAR_(inst_13912);
var inst_13914 = cljs.core.async.close_BANG_(inst_13913);
var inst_13915 = (inst_13907 + (1));
var tmp14030 = inst_13906;
var tmp14031 = inst_13905;
var tmp14032 = inst_13904;
var inst_13904__$1 = tmp14032;
var inst_13905__$1 = tmp14031;
var inst_13906__$1 = tmp14030;
var inst_13907__$1 = inst_13915;
var state_13966__$1 = (function (){var statearr_14040 = state_13966;
(statearr_14040[(13)] = inst_13906__$1);

(statearr_14040[(14)] = inst_13905__$1);

(statearr_14040[(15)] = inst_13904__$1);

(statearr_14040[(17)] = inst_13914);

(statearr_14040[(16)] = inst_13907__$1);

return statearr_14040;
})();
var statearr_14041_15651 = state_13966__$1;
(statearr_14041_15651[(2)] = null);

(statearr_14041_15651[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13967 === (18))){
var inst_13935 = (state_13966[(2)]);
var state_13966__$1 = state_13966;
var statearr_14042_15655 = state_13966__$1;
(statearr_14042_15655[(2)] = inst_13935);

(statearr_14042_15655[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13967 === (8))){
var inst_13906 = (state_13966[(13)]);
var inst_13907 = (state_13966[(16)]);
var inst_13909 = (inst_13907 < inst_13906);
var inst_13910 = inst_13909;
var state_13966__$1 = state_13966;
if(cljs.core.truth_(inst_13910)){
var statearr_14043_15657 = state_13966__$1;
(statearr_14043_15657[(1)] = (10));

} else {
var statearr_14044_15658 = state_13966__$1;
(statearr_14044_15658[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__12129__auto__ = null;
var cljs$core$async$state_machine__12129__auto____0 = (function (){
var statearr_14045 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14045[(0)] = cljs$core$async$state_machine__12129__auto__);

(statearr_14045[(1)] = (1));

return statearr_14045;
});
var cljs$core$async$state_machine__12129__auto____1 = (function (state_13966){
while(true){
var ret_value__12130__auto__ = (function (){try{while(true){
var result__12131__auto__ = switch__12128__auto__(state_13966);
if(cljs.core.keyword_identical_QMARK_(result__12131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12131__auto__;
}
break;
}
}catch (e14046){var ex__12132__auto__ = e14046;
var statearr_14047_15659 = state_13966;
(statearr_14047_15659[(2)] = ex__12132__auto__);


if(cljs.core.seq((state_13966[(4)]))){
var statearr_14048_15660 = state_13966;
(statearr_14048_15660[(1)] = cljs.core.first((state_13966[(4)])));

} else {
throw ex__12132__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12130__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15661 = state_13966;
state_13966 = G__15661;
continue;
} else {
return ret_value__12130__auto__;
}
break;
}
});
cljs$core$async$state_machine__12129__auto__ = function(state_13966){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12129__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12129__auto____1.call(this,state_13966);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12129__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12129__auto____0;
cljs$core$async$state_machine__12129__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12129__auto____1;
return cljs$core$async$state_machine__12129__auto__;
})()
})();
var state__12374__auto__ = (function (){var statearr_14049 = f__12373__auto__();
(statearr_14049[(6)] = c__12372__auto___15601);

return statearr_14049;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12374__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__14069 = arguments.length;
switch (G__14069) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__14080 = arguments.length;
switch (G__14080) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__14093 = arguments.length;
switch (G__14093) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
if((cnt === (0))){
cljs.core.async.close_BANG_(out);
} else {
var c__12372__auto___15666 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12373__auto__ = (function (){var switch__12128__auto__ = (function (state_14149){
var state_val_14150 = (state_14149[(1)]);
if((state_val_14150 === (7))){
var state_14149__$1 = state_14149;
var statearr_14155_15667 = state_14149__$1;
(statearr_14155_15667[(2)] = null);

(statearr_14155_15667[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14150 === (1))){
var state_14149__$1 = state_14149;
var statearr_14156_15668 = state_14149__$1;
(statearr_14156_15668[(2)] = null);

(statearr_14156_15668[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14150 === (4))){
var inst_14102 = (state_14149[(7)]);
var inst_14101 = (state_14149[(8)]);
var inst_14104 = (inst_14102 < inst_14101);
var state_14149__$1 = state_14149;
if(cljs.core.truth_(inst_14104)){
var statearr_14164_15669 = state_14149__$1;
(statearr_14164_15669[(1)] = (6));

} else {
var statearr_14166_15673 = state_14149__$1;
(statearr_14166_15673[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14150 === (15))){
var inst_14135 = (state_14149[(9)]);
var inst_14140 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_14135);
var state_14149__$1 = state_14149;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14149__$1,(17),out,inst_14140);
} else {
if((state_val_14150 === (13))){
var inst_14135 = (state_14149[(9)]);
var inst_14135__$1 = (state_14149[(2)]);
var inst_14136 = cljs.core.some(cljs.core.nil_QMARK_,inst_14135__$1);
var state_14149__$1 = (function (){var statearr_14168 = state_14149;
(statearr_14168[(9)] = inst_14135__$1);

return statearr_14168;
})();
if(cljs.core.truth_(inst_14136)){
var statearr_14172_15674 = state_14149__$1;
(statearr_14172_15674[(1)] = (14));

} else {
var statearr_14173_15675 = state_14149__$1;
(statearr_14173_15675[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14150 === (6))){
var state_14149__$1 = state_14149;
var statearr_14175_15676 = state_14149__$1;
(statearr_14175_15676[(2)] = null);

(statearr_14175_15676[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14150 === (17))){
var inst_14142 = (state_14149[(2)]);
var state_14149__$1 = (function (){var statearr_14183 = state_14149;
(statearr_14183[(10)] = inst_14142);

return statearr_14183;
})();
var statearr_14184_15677 = state_14149__$1;
(statearr_14184_15677[(2)] = null);

(statearr_14184_15677[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14150 === (3))){
var inst_14147 = (state_14149[(2)]);
var state_14149__$1 = state_14149;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14149__$1,inst_14147);
} else {
if((state_val_14150 === (12))){
var _ = (function (){var statearr_14189 = state_14149;
(statearr_14189[(4)] = cljs.core.rest((state_14149[(4)])));

return statearr_14189;
})();
var state_14149__$1 = state_14149;
var ex14179 = (state_14149__$1[(2)]);
var statearr_14193_15679 = state_14149__$1;
(statearr_14193_15679[(5)] = ex14179);


if((ex14179 instanceof Object)){
var statearr_14195_15680 = state_14149__$1;
(statearr_14195_15680[(1)] = (11));

(statearr_14195_15680[(5)] = null);

} else {
throw ex14179;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14150 === (2))){
var inst_14100 = cljs.core.reset_BANG_(dctr,cnt);
var inst_14101 = cnt;
var inst_14102 = (0);
var state_14149__$1 = (function (){var statearr_14200 = state_14149;
(statearr_14200[(7)] = inst_14102);

(statearr_14200[(8)] = inst_14101);

(statearr_14200[(11)] = inst_14100);

return statearr_14200;
})();
var statearr_14201_15681 = state_14149__$1;
(statearr_14201_15681[(2)] = null);

(statearr_14201_15681[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14150 === (11))){
var inst_14110 = (state_14149[(2)]);
var inst_14111 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_14149__$1 = (function (){var statearr_14205 = state_14149;
(statearr_14205[(12)] = inst_14110);

return statearr_14205;
})();
var statearr_14207_15685 = state_14149__$1;
(statearr_14207_15685[(2)] = inst_14111);

(statearr_14207_15685[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14150 === (9))){
var inst_14102 = (state_14149[(7)]);
var _ = (function (){var statearr_14208 = state_14149;
(statearr_14208[(4)] = cljs.core.cons((12),(state_14149[(4)])));

return statearr_14208;
})();
var inst_14120 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_14102) : chs__$1.call(null,inst_14102));
var inst_14121 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_14102) : done.call(null,inst_14102));
var inst_14122 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_14120,inst_14121);
var ___$1 = (function (){var statearr_14209 = state_14149;
(statearr_14209[(4)] = cljs.core.rest((state_14149[(4)])));

return statearr_14209;
})();
var state_14149__$1 = state_14149;
var statearr_14210_15690 = state_14149__$1;
(statearr_14210_15690[(2)] = inst_14122);

(statearr_14210_15690[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14150 === (5))){
var inst_14132 = (state_14149[(2)]);
var state_14149__$1 = (function (){var statearr_14211 = state_14149;
(statearr_14211[(13)] = inst_14132);

return statearr_14211;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14149__$1,(13),dchan);
} else {
if((state_val_14150 === (14))){
var inst_14138 = cljs.core.async.close_BANG_(out);
var state_14149__$1 = state_14149;
var statearr_14212_15694 = state_14149__$1;
(statearr_14212_15694[(2)] = inst_14138);

(statearr_14212_15694[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14150 === (16))){
var inst_14145 = (state_14149[(2)]);
var state_14149__$1 = state_14149;
var statearr_14213_15695 = state_14149__$1;
(statearr_14213_15695[(2)] = inst_14145);

(statearr_14213_15695[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14150 === (10))){
var inst_14102 = (state_14149[(7)]);
var inst_14125 = (state_14149[(2)]);
var inst_14126 = (inst_14102 + (1));
var inst_14102__$1 = inst_14126;
var state_14149__$1 = (function (){var statearr_14215 = state_14149;
(statearr_14215[(7)] = inst_14102__$1);

(statearr_14215[(14)] = inst_14125);

return statearr_14215;
})();
var statearr_14216_15697 = state_14149__$1;
(statearr_14216_15697[(2)] = null);

(statearr_14216_15697[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14150 === (8))){
var inst_14130 = (state_14149[(2)]);
var state_14149__$1 = state_14149;
var statearr_14217_15698 = state_14149__$1;
(statearr_14217_15698[(2)] = inst_14130);

(statearr_14217_15698[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__12129__auto__ = null;
var cljs$core$async$state_machine__12129__auto____0 = (function (){
var statearr_14221 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14221[(0)] = cljs$core$async$state_machine__12129__auto__);

(statearr_14221[(1)] = (1));

return statearr_14221;
});
var cljs$core$async$state_machine__12129__auto____1 = (function (state_14149){
while(true){
var ret_value__12130__auto__ = (function (){try{while(true){
var result__12131__auto__ = switch__12128__auto__(state_14149);
if(cljs.core.keyword_identical_QMARK_(result__12131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12131__auto__;
}
break;
}
}catch (e14222){var ex__12132__auto__ = e14222;
var statearr_14223_15706 = state_14149;
(statearr_14223_15706[(2)] = ex__12132__auto__);


if(cljs.core.seq((state_14149[(4)]))){
var statearr_14224_15707 = state_14149;
(statearr_14224_15707[(1)] = cljs.core.first((state_14149[(4)])));

} else {
throw ex__12132__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12130__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15709 = state_14149;
state_14149 = G__15709;
continue;
} else {
return ret_value__12130__auto__;
}
break;
}
});
cljs$core$async$state_machine__12129__auto__ = function(state_14149){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12129__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12129__auto____1.call(this,state_14149);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12129__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12129__auto____0;
cljs$core$async$state_machine__12129__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12129__auto____1;
return cljs$core$async$state_machine__12129__auto__;
})()
})();
var state__12374__auto__ = (function (){var statearr_14225 = f__12373__auto__();
(statearr_14225[(6)] = c__12372__auto___15666);

return statearr_14225;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12374__auto__);
}));

}

return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__14228 = arguments.length;
switch (G__14228) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12372__auto___15712 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12373__auto__ = (function (){var switch__12128__auto__ = (function (state_14266){
var state_val_14267 = (state_14266[(1)]);
if((state_val_14267 === (7))){
var inst_14244 = (state_14266[(7)]);
var inst_14245 = (state_14266[(8)]);
var inst_14244__$1 = (state_14266[(2)]);
var inst_14245__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14244__$1,(0),null);
var inst_14246 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14244__$1,(1),null);
var inst_14247 = (inst_14245__$1 == null);
var state_14266__$1 = (function (){var statearr_14272 = state_14266;
(statearr_14272[(7)] = inst_14244__$1);

(statearr_14272[(8)] = inst_14245__$1);

(statearr_14272[(9)] = inst_14246);

return statearr_14272;
})();
if(cljs.core.truth_(inst_14247)){
var statearr_14276_15726 = state_14266__$1;
(statearr_14276_15726[(1)] = (8));

} else {
var statearr_14277_15727 = state_14266__$1;
(statearr_14277_15727[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14267 === (1))){
var inst_14234 = cljs.core.vec(chs);
var inst_14235 = inst_14234;
var state_14266__$1 = (function (){var statearr_14279 = state_14266;
(statearr_14279[(10)] = inst_14235);

return statearr_14279;
})();
var statearr_14280_15728 = state_14266__$1;
(statearr_14280_15728[(2)] = null);

(statearr_14280_15728[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14267 === (4))){
var inst_14235 = (state_14266[(10)]);
var state_14266__$1 = state_14266;
return cljs.core.async.ioc_alts_BANG_(state_14266__$1,(7),inst_14235);
} else {
if((state_val_14267 === (6))){
var inst_14262 = (state_14266[(2)]);
var state_14266__$1 = state_14266;
var statearr_14287_15732 = state_14266__$1;
(statearr_14287_15732[(2)] = inst_14262);

(statearr_14287_15732[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14267 === (3))){
var inst_14264 = (state_14266[(2)]);
var state_14266__$1 = state_14266;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14266__$1,inst_14264);
} else {
if((state_val_14267 === (2))){
var inst_14235 = (state_14266[(10)]);
var inst_14237 = cljs.core.count(inst_14235);
var inst_14238 = (inst_14237 > (0));
var state_14266__$1 = state_14266;
if(cljs.core.truth_(inst_14238)){
var statearr_14292_15733 = state_14266__$1;
(statearr_14292_15733[(1)] = (4));

} else {
var statearr_14296_15734 = state_14266__$1;
(statearr_14296_15734[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14267 === (11))){
var inst_14235 = (state_14266[(10)]);
var inst_14255 = (state_14266[(2)]);
var tmp14289 = inst_14235;
var inst_14235__$1 = tmp14289;
var state_14266__$1 = (function (){var statearr_14298 = state_14266;
(statearr_14298[(11)] = inst_14255);

(statearr_14298[(10)] = inst_14235__$1);

return statearr_14298;
})();
var statearr_14299_15735 = state_14266__$1;
(statearr_14299_15735[(2)] = null);

(statearr_14299_15735[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14267 === (9))){
var inst_14245 = (state_14266[(8)]);
var state_14266__$1 = state_14266;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14266__$1,(11),out,inst_14245);
} else {
if((state_val_14267 === (5))){
var inst_14260 = cljs.core.async.close_BANG_(out);
var state_14266__$1 = state_14266;
var statearr_14308_15739 = state_14266__$1;
(statearr_14308_15739[(2)] = inst_14260);

(statearr_14308_15739[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14267 === (10))){
var inst_14258 = (state_14266[(2)]);
var state_14266__$1 = state_14266;
var statearr_14310_15740 = state_14266__$1;
(statearr_14310_15740[(2)] = inst_14258);

(statearr_14310_15740[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14267 === (8))){
var inst_14244 = (state_14266[(7)]);
var inst_14235 = (state_14266[(10)]);
var inst_14245 = (state_14266[(8)]);
var inst_14246 = (state_14266[(9)]);
var inst_14250 = (function (){var cs = inst_14235;
var vec__14240 = inst_14244;
var v = inst_14245;
var c = inst_14246;
return (function (p1__14226_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__14226_SHARP_);
});
})();
var inst_14251 = cljs.core.filterv(inst_14250,inst_14235);
var inst_14235__$1 = inst_14251;
var state_14266__$1 = (function (){var statearr_14311 = state_14266;
(statearr_14311[(10)] = inst_14235__$1);

return statearr_14311;
})();
var statearr_14312_15742 = state_14266__$1;
(statearr_14312_15742[(2)] = null);

(statearr_14312_15742[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__12129__auto__ = null;
var cljs$core$async$state_machine__12129__auto____0 = (function (){
var statearr_14314 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14314[(0)] = cljs$core$async$state_machine__12129__auto__);

(statearr_14314[(1)] = (1));

return statearr_14314;
});
var cljs$core$async$state_machine__12129__auto____1 = (function (state_14266){
while(true){
var ret_value__12130__auto__ = (function (){try{while(true){
var result__12131__auto__ = switch__12128__auto__(state_14266);
if(cljs.core.keyword_identical_QMARK_(result__12131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12131__auto__;
}
break;
}
}catch (e14315){var ex__12132__auto__ = e14315;
var statearr_14316_15747 = state_14266;
(statearr_14316_15747[(2)] = ex__12132__auto__);


if(cljs.core.seq((state_14266[(4)]))){
var statearr_14321_15748 = state_14266;
(statearr_14321_15748[(1)] = cljs.core.first((state_14266[(4)])));

} else {
throw ex__12132__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12130__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15749 = state_14266;
state_14266 = G__15749;
continue;
} else {
return ret_value__12130__auto__;
}
break;
}
});
cljs$core$async$state_machine__12129__auto__ = function(state_14266){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12129__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12129__auto____1.call(this,state_14266);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12129__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12129__auto____0;
cljs$core$async$state_machine__12129__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12129__auto____1;
return cljs$core$async$state_machine__12129__auto__;
})()
})();
var state__12374__auto__ = (function (){var statearr_14326 = f__12373__auto__();
(statearr_14326[(6)] = c__12372__auto___15712);

return statearr_14326;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12374__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__14329 = arguments.length;
switch (G__14329) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12372__auto___15753 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12373__auto__ = (function (){var switch__12128__auto__ = (function (state_14355){
var state_val_14356 = (state_14355[(1)]);
if((state_val_14356 === (7))){
var inst_14336 = (state_14355[(7)]);
var inst_14336__$1 = (state_14355[(2)]);
var inst_14338 = (inst_14336__$1 == null);
var inst_14339 = cljs.core.not(inst_14338);
var state_14355__$1 = (function (){var statearr_14357 = state_14355;
(statearr_14357[(7)] = inst_14336__$1);

return statearr_14357;
})();
if(inst_14339){
var statearr_14358_15754 = state_14355__$1;
(statearr_14358_15754[(1)] = (8));

} else {
var statearr_14359_15755 = state_14355__$1;
(statearr_14359_15755[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14356 === (1))){
var inst_14330 = (0);
var state_14355__$1 = (function (){var statearr_14360 = state_14355;
(statearr_14360[(8)] = inst_14330);

return statearr_14360;
})();
var statearr_14361_15757 = state_14355__$1;
(statearr_14361_15757[(2)] = null);

(statearr_14361_15757[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14356 === (4))){
var state_14355__$1 = state_14355;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14355__$1,(7),ch);
} else {
if((state_val_14356 === (6))){
var inst_14350 = (state_14355[(2)]);
var state_14355__$1 = state_14355;
var statearr_14362_15760 = state_14355__$1;
(statearr_14362_15760[(2)] = inst_14350);

(statearr_14362_15760[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14356 === (3))){
var inst_14352 = (state_14355[(2)]);
var inst_14353 = cljs.core.async.close_BANG_(out);
var state_14355__$1 = (function (){var statearr_14364 = state_14355;
(statearr_14364[(9)] = inst_14352);

return statearr_14364;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_14355__$1,inst_14353);
} else {
if((state_val_14356 === (2))){
var inst_14330 = (state_14355[(8)]);
var inst_14333 = (inst_14330 < n);
var state_14355__$1 = state_14355;
if(cljs.core.truth_(inst_14333)){
var statearr_14368_15764 = state_14355__$1;
(statearr_14368_15764[(1)] = (4));

} else {
var statearr_14369_15765 = state_14355__$1;
(statearr_14369_15765[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14356 === (11))){
var inst_14330 = (state_14355[(8)]);
var inst_14342 = (state_14355[(2)]);
var inst_14343 = (inst_14330 + (1));
var inst_14330__$1 = inst_14343;
var state_14355__$1 = (function (){var statearr_14370 = state_14355;
(statearr_14370[(8)] = inst_14330__$1);

(statearr_14370[(10)] = inst_14342);

return statearr_14370;
})();
var statearr_14371_15766 = state_14355__$1;
(statearr_14371_15766[(2)] = null);

(statearr_14371_15766[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14356 === (9))){
var state_14355__$1 = state_14355;
var statearr_14372_15767 = state_14355__$1;
(statearr_14372_15767[(2)] = null);

(statearr_14372_15767[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14356 === (5))){
var state_14355__$1 = state_14355;
var statearr_14373_15768 = state_14355__$1;
(statearr_14373_15768[(2)] = null);

(statearr_14373_15768[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14356 === (10))){
var inst_14347 = (state_14355[(2)]);
var state_14355__$1 = state_14355;
var statearr_14374_15771 = state_14355__$1;
(statearr_14374_15771[(2)] = inst_14347);

(statearr_14374_15771[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14356 === (8))){
var inst_14336 = (state_14355[(7)]);
var state_14355__$1 = state_14355;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14355__$1,(11),out,inst_14336);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__12129__auto__ = null;
var cljs$core$async$state_machine__12129__auto____0 = (function (){
var statearr_14375 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14375[(0)] = cljs$core$async$state_machine__12129__auto__);

(statearr_14375[(1)] = (1));

return statearr_14375;
});
var cljs$core$async$state_machine__12129__auto____1 = (function (state_14355){
while(true){
var ret_value__12130__auto__ = (function (){try{while(true){
var result__12131__auto__ = switch__12128__auto__(state_14355);
if(cljs.core.keyword_identical_QMARK_(result__12131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12131__auto__;
}
break;
}
}catch (e14376){var ex__12132__auto__ = e14376;
var statearr_14377_15774 = state_14355;
(statearr_14377_15774[(2)] = ex__12132__auto__);


if(cljs.core.seq((state_14355[(4)]))){
var statearr_14378_15775 = state_14355;
(statearr_14378_15775[(1)] = cljs.core.first((state_14355[(4)])));

} else {
throw ex__12132__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12130__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15776 = state_14355;
state_14355 = G__15776;
continue;
} else {
return ret_value__12130__auto__;
}
break;
}
});
cljs$core$async$state_machine__12129__auto__ = function(state_14355){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12129__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12129__auto____1.call(this,state_14355);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12129__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12129__auto____0;
cljs$core$async$state_machine__12129__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12129__auto____1;
return cljs$core$async$state_machine__12129__auto__;
})()
})();
var state__12374__auto__ = (function (){var statearr_14380 = f__12373__auto__();
(statearr_14380[(6)] = c__12372__auto___15753);

return statearr_14380;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12374__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14397 = (function (f,ch,meta14383,_,fn1,meta14398){
this.f = f;
this.ch = ch;
this.meta14383 = meta14383;
this._ = _;
this.fn1 = fn1;
this.meta14398 = meta14398;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async14397.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14399,meta14398__$1){
var self__ = this;
var _14399__$1 = this;
return (new cljs.core.async.t_cljs$core$async14397(self__.f,self__.ch,self__.meta14383,self__._,self__.fn1,meta14398__$1));
}));

(cljs.core.async.t_cljs$core$async14397.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14399){
var self__ = this;
var _14399__$1 = this;
return self__.meta14398;
}));

(cljs.core.async.t_cljs$core$async14397.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14397.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async14397.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async14397.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__14381_SHARP_){
var G__14405 = (((p1__14381_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__14381_SHARP_) : self__.f.call(null,p1__14381_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__14405) : f1.call(null,G__14405));
});
}));

(cljs.core.async.t_cljs$core$async14397.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta14383","meta14383",-1106067187,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async14382","cljs.core.async/t_cljs$core$async14382",384885820,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta14398","meta14398",777316069,null)], null);
}));

(cljs.core.async.t_cljs$core$async14397.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async14397.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14397");

(cljs.core.async.t_cljs$core$async14397.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async14397");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async14397.
 */
cljs.core.async.__GT_t_cljs$core$async14397 = (function cljs$core$async$__GT_t_cljs$core$async14397(f,ch,meta14383,_,fn1,meta14398){
return (new cljs.core.async.t_cljs$core$async14397(f,ch,meta14383,_,fn1,meta14398));
});



/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14382 = (function (f,ch,meta14383){
this.f = f;
this.ch = ch;
this.meta14383 = meta14383;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async14382.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14384,meta14383__$1){
var self__ = this;
var _14384__$1 = this;
return (new cljs.core.async.t_cljs$core$async14382(self__.f,self__.ch,meta14383__$1));
}));

(cljs.core.async.t_cljs$core$async14382.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14384){
var self__ = this;
var _14384__$1 = this;
return self__.meta14383;
}));

(cljs.core.async.t_cljs$core$async14382.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14382.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async14382.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async14382.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14382.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(new cljs.core.async.t_cljs$core$async14397(self__.f,self__.ch,self__.meta14383,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY)));
if(cljs.core.truth_((function (){var and__5000__auto__ = ret;
if(cljs.core.truth_(and__5000__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__5000__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__14409 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__14409) : self__.f.call(null,G__14409));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async14382.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14382.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async14382.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta14383","meta14383",-1106067187,null)], null);
}));

(cljs.core.async.t_cljs$core$async14382.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async14382.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14382");

(cljs.core.async.t_cljs$core$async14382.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async14382");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async14382.
 */
cljs.core.async.__GT_t_cljs$core$async14382 = (function cljs$core$async$__GT_t_cljs$core$async14382(f,ch,meta14383){
return (new cljs.core.async.t_cljs$core$async14382(f,ch,meta14383));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
return (new cljs.core.async.t_cljs$core$async14382(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14413 = (function (f,ch,meta14414){
this.f = f;
this.ch = ch;
this.meta14414 = meta14414;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async14413.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14415,meta14414__$1){
var self__ = this;
var _14415__$1 = this;
return (new cljs.core.async.t_cljs$core$async14413(self__.f,self__.ch,meta14414__$1));
}));

(cljs.core.async.t_cljs$core$async14413.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14415){
var self__ = this;
var _14415__$1 = this;
return self__.meta14414;
}));

(cljs.core.async.t_cljs$core$async14413.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14413.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async14413.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14413.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async14413.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14413.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async14413.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta14414","meta14414",628498388,null)], null);
}));

(cljs.core.async.t_cljs$core$async14413.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async14413.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14413");

(cljs.core.async.t_cljs$core$async14413.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async14413");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async14413.
 */
cljs.core.async.__GT_t_cljs$core$async14413 = (function cljs$core$async$__GT_t_cljs$core$async14413(f,ch,meta14414){
return (new cljs.core.async.t_cljs$core$async14413(f,ch,meta14414));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
return (new cljs.core.async.t_cljs$core$async14413(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14420 = (function (p,ch,meta14421){
this.p = p;
this.ch = ch;
this.meta14421 = meta14421;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async14420.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14422,meta14421__$1){
var self__ = this;
var _14422__$1 = this;
return (new cljs.core.async.t_cljs$core$async14420(self__.p,self__.ch,meta14421__$1));
}));

(cljs.core.async.t_cljs$core$async14420.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14422){
var self__ = this;
var _14422__$1 = this;
return self__.meta14421;
}));

(cljs.core.async.t_cljs$core$async14420.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14420.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async14420.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async14420.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14420.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async14420.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14420.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async14420.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta14421","meta14421",-1679468893,null)], null);
}));

(cljs.core.async.t_cljs$core$async14420.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async14420.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14420");

(cljs.core.async.t_cljs$core$async14420.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async14420");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async14420.
 */
cljs.core.async.__GT_t_cljs$core$async14420 = (function cljs$core$async$__GT_t_cljs$core$async14420(p,ch,meta14421){
return (new cljs.core.async.t_cljs$core$async14420(p,ch,meta14421));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
return (new cljs.core.async.t_cljs$core$async14420(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__14436 = arguments.length;
switch (G__14436) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12372__auto___15790 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12373__auto__ = (function (){var switch__12128__auto__ = (function (state_14460){
var state_val_14461 = (state_14460[(1)]);
if((state_val_14461 === (7))){
var inst_14456 = (state_14460[(2)]);
var state_14460__$1 = state_14460;
var statearr_14462_15792 = state_14460__$1;
(statearr_14462_15792[(2)] = inst_14456);

(statearr_14462_15792[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14461 === (1))){
var state_14460__$1 = state_14460;
var statearr_14476_15793 = state_14460__$1;
(statearr_14476_15793[(2)] = null);

(statearr_14476_15793[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14461 === (4))){
var inst_14442 = (state_14460[(7)]);
var inst_14442__$1 = (state_14460[(2)]);
var inst_14443 = (inst_14442__$1 == null);
var state_14460__$1 = (function (){var statearr_14477 = state_14460;
(statearr_14477[(7)] = inst_14442__$1);

return statearr_14477;
})();
if(cljs.core.truth_(inst_14443)){
var statearr_14484_15795 = state_14460__$1;
(statearr_14484_15795[(1)] = (5));

} else {
var statearr_14485_15796 = state_14460__$1;
(statearr_14485_15796[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14461 === (6))){
var inst_14442 = (state_14460[(7)]);
var inst_14447 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_14442) : p.call(null,inst_14442));
var state_14460__$1 = state_14460;
if(cljs.core.truth_(inst_14447)){
var statearr_14486_15797 = state_14460__$1;
(statearr_14486_15797[(1)] = (8));

} else {
var statearr_14487_15798 = state_14460__$1;
(statearr_14487_15798[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14461 === (3))){
var inst_14458 = (state_14460[(2)]);
var state_14460__$1 = state_14460;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14460__$1,inst_14458);
} else {
if((state_val_14461 === (2))){
var state_14460__$1 = state_14460;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14460__$1,(4),ch);
} else {
if((state_val_14461 === (11))){
var inst_14450 = (state_14460[(2)]);
var state_14460__$1 = state_14460;
var statearr_14488_15803 = state_14460__$1;
(statearr_14488_15803[(2)] = inst_14450);

(statearr_14488_15803[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14461 === (9))){
var state_14460__$1 = state_14460;
var statearr_14493_15804 = state_14460__$1;
(statearr_14493_15804[(2)] = null);

(statearr_14493_15804[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14461 === (5))){
var inst_14445 = cljs.core.async.close_BANG_(out);
var state_14460__$1 = state_14460;
var statearr_14497_15805 = state_14460__$1;
(statearr_14497_15805[(2)] = inst_14445);

(statearr_14497_15805[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14461 === (10))){
var inst_14453 = (state_14460[(2)]);
var state_14460__$1 = (function (){var statearr_14498 = state_14460;
(statearr_14498[(8)] = inst_14453);

return statearr_14498;
})();
var statearr_14502_15807 = state_14460__$1;
(statearr_14502_15807[(2)] = null);

(statearr_14502_15807[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14461 === (8))){
var inst_14442 = (state_14460[(7)]);
var state_14460__$1 = state_14460;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14460__$1,(11),out,inst_14442);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__12129__auto__ = null;
var cljs$core$async$state_machine__12129__auto____0 = (function (){
var statearr_14503 = [null,null,null,null,null,null,null,null,null];
(statearr_14503[(0)] = cljs$core$async$state_machine__12129__auto__);

(statearr_14503[(1)] = (1));

return statearr_14503;
});
var cljs$core$async$state_machine__12129__auto____1 = (function (state_14460){
while(true){
var ret_value__12130__auto__ = (function (){try{while(true){
var result__12131__auto__ = switch__12128__auto__(state_14460);
if(cljs.core.keyword_identical_QMARK_(result__12131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12131__auto__;
}
break;
}
}catch (e14507){var ex__12132__auto__ = e14507;
var statearr_14508_15817 = state_14460;
(statearr_14508_15817[(2)] = ex__12132__auto__);


if(cljs.core.seq((state_14460[(4)]))){
var statearr_14509_15818 = state_14460;
(statearr_14509_15818[(1)] = cljs.core.first((state_14460[(4)])));

} else {
throw ex__12132__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12130__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15819 = state_14460;
state_14460 = G__15819;
continue;
} else {
return ret_value__12130__auto__;
}
break;
}
});
cljs$core$async$state_machine__12129__auto__ = function(state_14460){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12129__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12129__auto____1.call(this,state_14460);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12129__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12129__auto____0;
cljs$core$async$state_machine__12129__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12129__auto____1;
return cljs$core$async$state_machine__12129__auto__;
})()
})();
var state__12374__auto__ = (function (){var statearr_14510 = f__12373__auto__();
(statearr_14510[(6)] = c__12372__auto___15790);

return statearr_14510;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12374__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__14512 = arguments.length;
switch (G__14512) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__12372__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12373__auto__ = (function (){var switch__12128__auto__ = (function (state_14583){
var state_val_14584 = (state_14583[(1)]);
if((state_val_14584 === (7))){
var inst_14579 = (state_14583[(2)]);
var state_14583__$1 = state_14583;
var statearr_14588_15837 = state_14583__$1;
(statearr_14588_15837[(2)] = inst_14579);

(statearr_14588_15837[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14584 === (20))){
var inst_14545 = (state_14583[(7)]);
var inst_14557 = (state_14583[(2)]);
var inst_14558 = cljs.core.next(inst_14545);
var inst_14531 = inst_14558;
var inst_14532 = null;
var inst_14533 = (0);
var inst_14534 = (0);
var state_14583__$1 = (function (){var statearr_14589 = state_14583;
(statearr_14589[(8)] = inst_14532);

(statearr_14589[(9)] = inst_14533);

(statearr_14589[(10)] = inst_14531);

(statearr_14589[(11)] = inst_14557);

(statearr_14589[(12)] = inst_14534);

return statearr_14589;
})();
var statearr_14590_15850 = state_14583__$1;
(statearr_14590_15850[(2)] = null);

(statearr_14590_15850[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14584 === (1))){
var state_14583__$1 = state_14583;
var statearr_14591_15851 = state_14583__$1;
(statearr_14591_15851[(2)] = null);

(statearr_14591_15851[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14584 === (4))){
var inst_14520 = (state_14583[(13)]);
var inst_14520__$1 = (state_14583[(2)]);
var inst_14521 = (inst_14520__$1 == null);
var state_14583__$1 = (function (){var statearr_14592 = state_14583;
(statearr_14592[(13)] = inst_14520__$1);

return statearr_14592;
})();
if(cljs.core.truth_(inst_14521)){
var statearr_14593_15852 = state_14583__$1;
(statearr_14593_15852[(1)] = (5));

} else {
var statearr_14594_15853 = state_14583__$1;
(statearr_14594_15853[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14584 === (15))){
var state_14583__$1 = state_14583;
var statearr_14598_15854 = state_14583__$1;
(statearr_14598_15854[(2)] = null);

(statearr_14598_15854[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14584 === (21))){
var state_14583__$1 = state_14583;
var statearr_14599_15855 = state_14583__$1;
(statearr_14599_15855[(2)] = null);

(statearr_14599_15855[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14584 === (13))){
var inst_14532 = (state_14583[(8)]);
var inst_14533 = (state_14583[(9)]);
var inst_14531 = (state_14583[(10)]);
var inst_14534 = (state_14583[(12)]);
var inst_14541 = (state_14583[(2)]);
var inst_14542 = (inst_14534 + (1));
var tmp14595 = inst_14532;
var tmp14596 = inst_14533;
var tmp14597 = inst_14531;
var inst_14531__$1 = tmp14597;
var inst_14532__$1 = tmp14595;
var inst_14533__$1 = tmp14596;
var inst_14534__$1 = inst_14542;
var state_14583__$1 = (function (){var statearr_14600 = state_14583;
(statearr_14600[(8)] = inst_14532__$1);

(statearr_14600[(9)] = inst_14533__$1);

(statearr_14600[(10)] = inst_14531__$1);

(statearr_14600[(12)] = inst_14534__$1);

(statearr_14600[(14)] = inst_14541);

return statearr_14600;
})();
var statearr_14601_15857 = state_14583__$1;
(statearr_14601_15857[(2)] = null);

(statearr_14601_15857[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14584 === (22))){
var state_14583__$1 = state_14583;
var statearr_14602_15858 = state_14583__$1;
(statearr_14602_15858[(2)] = null);

(statearr_14602_15858[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14584 === (6))){
var inst_14520 = (state_14583[(13)]);
var inst_14529 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_14520) : f.call(null,inst_14520));
var inst_14530 = cljs.core.seq(inst_14529);
var inst_14531 = inst_14530;
var inst_14532 = null;
var inst_14533 = (0);
var inst_14534 = (0);
var state_14583__$1 = (function (){var statearr_14603 = state_14583;
(statearr_14603[(8)] = inst_14532);

(statearr_14603[(9)] = inst_14533);

(statearr_14603[(10)] = inst_14531);

(statearr_14603[(12)] = inst_14534);

return statearr_14603;
})();
var statearr_14604_15862 = state_14583__$1;
(statearr_14604_15862[(2)] = null);

(statearr_14604_15862[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14584 === (17))){
var inst_14545 = (state_14583[(7)]);
var inst_14549 = cljs.core.chunk_first(inst_14545);
var inst_14550 = cljs.core.chunk_rest(inst_14545);
var inst_14551 = cljs.core.count(inst_14549);
var inst_14531 = inst_14550;
var inst_14532 = inst_14549;
var inst_14533 = inst_14551;
var inst_14534 = (0);
var state_14583__$1 = (function (){var statearr_14607 = state_14583;
(statearr_14607[(8)] = inst_14532);

(statearr_14607[(9)] = inst_14533);

(statearr_14607[(10)] = inst_14531);

(statearr_14607[(12)] = inst_14534);

return statearr_14607;
})();
var statearr_14608_15863 = state_14583__$1;
(statearr_14608_15863[(2)] = null);

(statearr_14608_15863[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14584 === (3))){
var inst_14581 = (state_14583[(2)]);
var state_14583__$1 = state_14583;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14583__$1,inst_14581);
} else {
if((state_val_14584 === (12))){
var inst_14566 = (state_14583[(2)]);
var state_14583__$1 = state_14583;
var statearr_14610_15864 = state_14583__$1;
(statearr_14610_15864[(2)] = inst_14566);

(statearr_14610_15864[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14584 === (2))){
var state_14583__$1 = state_14583;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14583__$1,(4),in$);
} else {
if((state_val_14584 === (23))){
var inst_14577 = (state_14583[(2)]);
var state_14583__$1 = state_14583;
var statearr_14612_15869 = state_14583__$1;
(statearr_14612_15869[(2)] = inst_14577);

(statearr_14612_15869[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14584 === (19))){
var inst_14561 = (state_14583[(2)]);
var state_14583__$1 = state_14583;
var statearr_14613_15870 = state_14583__$1;
(statearr_14613_15870[(2)] = inst_14561);

(statearr_14613_15870[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14584 === (11))){
var inst_14545 = (state_14583[(7)]);
var inst_14531 = (state_14583[(10)]);
var inst_14545__$1 = cljs.core.seq(inst_14531);
var state_14583__$1 = (function (){var statearr_14614 = state_14583;
(statearr_14614[(7)] = inst_14545__$1);

return statearr_14614;
})();
if(inst_14545__$1){
var statearr_14615_15871 = state_14583__$1;
(statearr_14615_15871[(1)] = (14));

} else {
var statearr_14616_15872 = state_14583__$1;
(statearr_14616_15872[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14584 === (9))){
var inst_14568 = (state_14583[(2)]);
var inst_14572 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_14583__$1 = (function (){var statearr_14617 = state_14583;
(statearr_14617[(15)] = inst_14568);

return statearr_14617;
})();
if(cljs.core.truth_(inst_14572)){
var statearr_14618_15873 = state_14583__$1;
(statearr_14618_15873[(1)] = (21));

} else {
var statearr_14619_15874 = state_14583__$1;
(statearr_14619_15874[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14584 === (5))){
var inst_14523 = cljs.core.async.close_BANG_(out);
var state_14583__$1 = state_14583;
var statearr_14620_15875 = state_14583__$1;
(statearr_14620_15875[(2)] = inst_14523);

(statearr_14620_15875[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14584 === (14))){
var inst_14545 = (state_14583[(7)]);
var inst_14547 = cljs.core.chunked_seq_QMARK_(inst_14545);
var state_14583__$1 = state_14583;
if(inst_14547){
var statearr_14621_15876 = state_14583__$1;
(statearr_14621_15876[(1)] = (17));

} else {
var statearr_14622_15877 = state_14583__$1;
(statearr_14622_15877[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14584 === (16))){
var inst_14564 = (state_14583[(2)]);
var state_14583__$1 = state_14583;
var statearr_14623_15878 = state_14583__$1;
(statearr_14623_15878[(2)] = inst_14564);

(statearr_14623_15878[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14584 === (10))){
var inst_14532 = (state_14583[(8)]);
var inst_14534 = (state_14583[(12)]);
var inst_14539 = cljs.core._nth(inst_14532,inst_14534);
var state_14583__$1 = state_14583;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14583__$1,(13),out,inst_14539);
} else {
if((state_val_14584 === (18))){
var inst_14545 = (state_14583[(7)]);
var inst_14554 = cljs.core.first(inst_14545);
var state_14583__$1 = state_14583;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14583__$1,(20),out,inst_14554);
} else {
if((state_val_14584 === (8))){
var inst_14533 = (state_14583[(9)]);
var inst_14534 = (state_14583[(12)]);
var inst_14536 = (inst_14534 < inst_14533);
var inst_14537 = inst_14536;
var state_14583__$1 = state_14583;
if(cljs.core.truth_(inst_14537)){
var statearr_14627_15880 = state_14583__$1;
(statearr_14627_15880[(1)] = (10));

} else {
var statearr_14628_15881 = state_14583__$1;
(statearr_14628_15881[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__12129__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__12129__auto____0 = (function (){
var statearr_14629 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14629[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__12129__auto__);

(statearr_14629[(1)] = (1));

return statearr_14629;
});
var cljs$core$async$mapcat_STAR__$_state_machine__12129__auto____1 = (function (state_14583){
while(true){
var ret_value__12130__auto__ = (function (){try{while(true){
var result__12131__auto__ = switch__12128__auto__(state_14583);
if(cljs.core.keyword_identical_QMARK_(result__12131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12131__auto__;
}
break;
}
}catch (e14630){var ex__12132__auto__ = e14630;
var statearr_14631_15891 = state_14583;
(statearr_14631_15891[(2)] = ex__12132__auto__);


if(cljs.core.seq((state_14583[(4)]))){
var statearr_14632_15892 = state_14583;
(statearr_14632_15892[(1)] = cljs.core.first((state_14583[(4)])));

} else {
throw ex__12132__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12130__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15893 = state_14583;
state_14583 = G__15893;
continue;
} else {
return ret_value__12130__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__12129__auto__ = function(state_14583){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__12129__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__12129__auto____1.call(this,state_14583);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__12129__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__12129__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__12129__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__12129__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__12129__auto__;
})()
})();
var state__12374__auto__ = (function (){var statearr_14633 = f__12373__auto__();
(statearr_14633[(6)] = c__12372__auto__);

return statearr_14633;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12374__auto__);
}));

return c__12372__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__14635 = arguments.length;
switch (G__14635) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__14642 = arguments.length;
switch (G__14642) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__14649 = arguments.length;
switch (G__14649) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12372__auto___15908 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12373__auto__ = (function (){var switch__12128__auto__ = (function (state_14673){
var state_val_14674 = (state_14673[(1)]);
if((state_val_14674 === (7))){
var inst_14668 = (state_14673[(2)]);
var state_14673__$1 = state_14673;
var statearr_14675_15913 = state_14673__$1;
(statearr_14675_15913[(2)] = inst_14668);

(statearr_14675_15913[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14674 === (1))){
var inst_14650 = null;
var state_14673__$1 = (function (){var statearr_14679 = state_14673;
(statearr_14679[(7)] = inst_14650);

return statearr_14679;
})();
var statearr_14680_15917 = state_14673__$1;
(statearr_14680_15917[(2)] = null);

(statearr_14680_15917[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14674 === (4))){
var inst_14653 = (state_14673[(8)]);
var inst_14653__$1 = (state_14673[(2)]);
var inst_14654 = (inst_14653__$1 == null);
var inst_14655 = cljs.core.not(inst_14654);
var state_14673__$1 = (function (){var statearr_14681 = state_14673;
(statearr_14681[(8)] = inst_14653__$1);

return statearr_14681;
})();
if(inst_14655){
var statearr_14682_15922 = state_14673__$1;
(statearr_14682_15922[(1)] = (5));

} else {
var statearr_14683_15923 = state_14673__$1;
(statearr_14683_15923[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14674 === (6))){
var state_14673__$1 = state_14673;
var statearr_14684_15925 = state_14673__$1;
(statearr_14684_15925[(2)] = null);

(statearr_14684_15925[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14674 === (3))){
var inst_14670 = (state_14673[(2)]);
var inst_14671 = cljs.core.async.close_BANG_(out);
var state_14673__$1 = (function (){var statearr_14688 = state_14673;
(statearr_14688[(9)] = inst_14670);

return statearr_14688;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_14673__$1,inst_14671);
} else {
if((state_val_14674 === (2))){
var state_14673__$1 = state_14673;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14673__$1,(4),ch);
} else {
if((state_val_14674 === (11))){
var inst_14653 = (state_14673[(8)]);
var inst_14662 = (state_14673[(2)]);
var inst_14650 = inst_14653;
var state_14673__$1 = (function (){var statearr_14694 = state_14673;
(statearr_14694[(10)] = inst_14662);

(statearr_14694[(7)] = inst_14650);

return statearr_14694;
})();
var statearr_14697_15938 = state_14673__$1;
(statearr_14697_15938[(2)] = null);

(statearr_14697_15938[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14674 === (9))){
var inst_14653 = (state_14673[(8)]);
var state_14673__$1 = state_14673;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14673__$1,(11),out,inst_14653);
} else {
if((state_val_14674 === (5))){
var inst_14653 = (state_14673[(8)]);
var inst_14650 = (state_14673[(7)]);
var inst_14657 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_14653,inst_14650);
var state_14673__$1 = state_14673;
if(inst_14657){
var statearr_14699_15943 = state_14673__$1;
(statearr_14699_15943[(1)] = (8));

} else {
var statearr_14703_15944 = state_14673__$1;
(statearr_14703_15944[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14674 === (10))){
var inst_14665 = (state_14673[(2)]);
var state_14673__$1 = state_14673;
var statearr_14704_15945 = state_14673__$1;
(statearr_14704_15945[(2)] = inst_14665);

(statearr_14704_15945[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14674 === (8))){
var inst_14650 = (state_14673[(7)]);
var tmp14698 = inst_14650;
var inst_14650__$1 = tmp14698;
var state_14673__$1 = (function (){var statearr_14705 = state_14673;
(statearr_14705[(7)] = inst_14650__$1);

return statearr_14705;
})();
var statearr_14706_15949 = state_14673__$1;
(statearr_14706_15949[(2)] = null);

(statearr_14706_15949[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__12129__auto__ = null;
var cljs$core$async$state_machine__12129__auto____0 = (function (){
var statearr_14707 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14707[(0)] = cljs$core$async$state_machine__12129__auto__);

(statearr_14707[(1)] = (1));

return statearr_14707;
});
var cljs$core$async$state_machine__12129__auto____1 = (function (state_14673){
while(true){
var ret_value__12130__auto__ = (function (){try{while(true){
var result__12131__auto__ = switch__12128__auto__(state_14673);
if(cljs.core.keyword_identical_QMARK_(result__12131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12131__auto__;
}
break;
}
}catch (e14710){var ex__12132__auto__ = e14710;
var statearr_14713_15954 = state_14673;
(statearr_14713_15954[(2)] = ex__12132__auto__);


if(cljs.core.seq((state_14673[(4)]))){
var statearr_14714_15955 = state_14673;
(statearr_14714_15955[(1)] = cljs.core.first((state_14673[(4)])));

} else {
throw ex__12132__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12130__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15956 = state_14673;
state_14673 = G__15956;
continue;
} else {
return ret_value__12130__auto__;
}
break;
}
});
cljs$core$async$state_machine__12129__auto__ = function(state_14673){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12129__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12129__auto____1.call(this,state_14673);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12129__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12129__auto____0;
cljs$core$async$state_machine__12129__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12129__auto____1;
return cljs$core$async$state_machine__12129__auto__;
})()
})();
var state__12374__auto__ = (function (){var statearr_14716 = f__12373__auto__();
(statearr_14716[(6)] = c__12372__auto___15908);

return statearr_14716;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12374__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__14726 = arguments.length;
switch (G__14726) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12372__auto___15965 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12373__auto__ = (function (){var switch__12128__auto__ = (function (state_14769){
var state_val_14770 = (state_14769[(1)]);
if((state_val_14770 === (7))){
var inst_14765 = (state_14769[(2)]);
var state_14769__$1 = state_14769;
var statearr_14774_15966 = state_14769__$1;
(statearr_14774_15966[(2)] = inst_14765);

(statearr_14774_15966[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14770 === (1))){
var inst_14728 = (new Array(n));
var inst_14730 = inst_14728;
var inst_14731 = (0);
var state_14769__$1 = (function (){var statearr_14775 = state_14769;
(statearr_14775[(7)] = inst_14730);

(statearr_14775[(8)] = inst_14731);

return statearr_14775;
})();
var statearr_14776_16078 = state_14769__$1;
(statearr_14776_16078[(2)] = null);

(statearr_14776_16078[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14770 === (4))){
var inst_14734 = (state_14769[(9)]);
var inst_14734__$1 = (state_14769[(2)]);
var inst_14735 = (inst_14734__$1 == null);
var inst_14736 = cljs.core.not(inst_14735);
var state_14769__$1 = (function (){var statearr_14777 = state_14769;
(statearr_14777[(9)] = inst_14734__$1);

return statearr_14777;
})();
if(inst_14736){
var statearr_14778_16079 = state_14769__$1;
(statearr_14778_16079[(1)] = (5));

} else {
var statearr_14779_16084 = state_14769__$1;
(statearr_14779_16084[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14770 === (15))){
var inst_14759 = (state_14769[(2)]);
var state_14769__$1 = state_14769;
var statearr_14780_16086 = state_14769__$1;
(statearr_14780_16086[(2)] = inst_14759);

(statearr_14780_16086[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14770 === (13))){
var state_14769__$1 = state_14769;
var statearr_14781_16091 = state_14769__$1;
(statearr_14781_16091[(2)] = null);

(statearr_14781_16091[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14770 === (6))){
var inst_14731 = (state_14769[(8)]);
var inst_14755 = (inst_14731 > (0));
var state_14769__$1 = state_14769;
if(cljs.core.truth_(inst_14755)){
var statearr_14782_16095 = state_14769__$1;
(statearr_14782_16095[(1)] = (12));

} else {
var statearr_14783_16100 = state_14769__$1;
(statearr_14783_16100[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14770 === (3))){
var inst_14767 = (state_14769[(2)]);
var state_14769__$1 = state_14769;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14769__$1,inst_14767);
} else {
if((state_val_14770 === (12))){
var inst_14730 = (state_14769[(7)]);
var inst_14757 = cljs.core.vec(inst_14730);
var state_14769__$1 = state_14769;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14769__$1,(15),out,inst_14757);
} else {
if((state_val_14770 === (2))){
var state_14769__$1 = state_14769;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14769__$1,(4),ch);
} else {
if((state_val_14770 === (11))){
var inst_14749 = (state_14769[(2)]);
var inst_14750 = (new Array(n));
var inst_14730 = inst_14750;
var inst_14731 = (0);
var state_14769__$1 = (function (){var statearr_14788 = state_14769;
(statearr_14788[(7)] = inst_14730);

(statearr_14788[(8)] = inst_14731);

(statearr_14788[(10)] = inst_14749);

return statearr_14788;
})();
var statearr_14789_16113 = state_14769__$1;
(statearr_14789_16113[(2)] = null);

(statearr_14789_16113[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14770 === (9))){
var inst_14730 = (state_14769[(7)]);
var inst_14747 = cljs.core.vec(inst_14730);
var state_14769__$1 = state_14769;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14769__$1,(11),out,inst_14747);
} else {
if((state_val_14770 === (5))){
var inst_14730 = (state_14769[(7)]);
var inst_14731 = (state_14769[(8)]);
var inst_14734 = (state_14769[(9)]);
var inst_14739 = (state_14769[(11)]);
var inst_14738 = (inst_14730[inst_14731] = inst_14734);
var inst_14739__$1 = (inst_14731 + (1));
var inst_14740 = (inst_14739__$1 < n);
var state_14769__$1 = (function (){var statearr_14793 = state_14769;
(statearr_14793[(12)] = inst_14738);

(statearr_14793[(11)] = inst_14739__$1);

return statearr_14793;
})();
if(cljs.core.truth_(inst_14740)){
var statearr_14794_16134 = state_14769__$1;
(statearr_14794_16134[(1)] = (8));

} else {
var statearr_14796_16135 = state_14769__$1;
(statearr_14796_16135[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14770 === (14))){
var inst_14762 = (state_14769[(2)]);
var inst_14763 = cljs.core.async.close_BANG_(out);
var state_14769__$1 = (function (){var statearr_14801 = state_14769;
(statearr_14801[(13)] = inst_14762);

return statearr_14801;
})();
var statearr_14802_16140 = state_14769__$1;
(statearr_14802_16140[(2)] = inst_14763);

(statearr_14802_16140[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14770 === (10))){
var inst_14753 = (state_14769[(2)]);
var state_14769__$1 = state_14769;
var statearr_14803_16150 = state_14769__$1;
(statearr_14803_16150[(2)] = inst_14753);

(statearr_14803_16150[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14770 === (8))){
var inst_14730 = (state_14769[(7)]);
var inst_14739 = (state_14769[(11)]);
var tmp14800 = inst_14730;
var inst_14730__$1 = tmp14800;
var inst_14731 = inst_14739;
var state_14769__$1 = (function (){var statearr_14804 = state_14769;
(statearr_14804[(7)] = inst_14730__$1);

(statearr_14804[(8)] = inst_14731);

return statearr_14804;
})();
var statearr_14805_16151 = state_14769__$1;
(statearr_14805_16151[(2)] = null);

(statearr_14805_16151[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__12129__auto__ = null;
var cljs$core$async$state_machine__12129__auto____0 = (function (){
var statearr_14806 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14806[(0)] = cljs$core$async$state_machine__12129__auto__);

(statearr_14806[(1)] = (1));

return statearr_14806;
});
var cljs$core$async$state_machine__12129__auto____1 = (function (state_14769){
while(true){
var ret_value__12130__auto__ = (function (){try{while(true){
var result__12131__auto__ = switch__12128__auto__(state_14769);
if(cljs.core.keyword_identical_QMARK_(result__12131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12131__auto__;
}
break;
}
}catch (e14810){var ex__12132__auto__ = e14810;
var statearr_14811_16153 = state_14769;
(statearr_14811_16153[(2)] = ex__12132__auto__);


if(cljs.core.seq((state_14769[(4)]))){
var statearr_14812_16154 = state_14769;
(statearr_14812_16154[(1)] = cljs.core.first((state_14769[(4)])));

} else {
throw ex__12132__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12130__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16155 = state_14769;
state_14769 = G__16155;
continue;
} else {
return ret_value__12130__auto__;
}
break;
}
});
cljs$core$async$state_machine__12129__auto__ = function(state_14769){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12129__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12129__auto____1.call(this,state_14769);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12129__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12129__auto____0;
cljs$core$async$state_machine__12129__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12129__auto____1;
return cljs$core$async$state_machine__12129__auto__;
})()
})();
var state__12374__auto__ = (function (){var statearr_14813 = f__12373__auto__();
(statearr_14813[(6)] = c__12372__auto___15965);

return statearr_14813;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12374__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__14815 = arguments.length;
switch (G__14815) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12372__auto___16161 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12373__auto__ = (function (){var switch__12128__auto__ = (function (state_14865){
var state_val_14866 = (state_14865[(1)]);
if((state_val_14866 === (7))){
var inst_14861 = (state_14865[(2)]);
var state_14865__$1 = state_14865;
var statearr_14867_16162 = state_14865__$1;
(statearr_14867_16162[(2)] = inst_14861);

(statearr_14867_16162[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14866 === (1))){
var inst_14818 = [];
var inst_14819 = inst_14818;
var inst_14820 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_14865__$1 = (function (){var statearr_14880 = state_14865;
(statearr_14880[(7)] = inst_14820);

(statearr_14880[(8)] = inst_14819);

return statearr_14880;
})();
var statearr_14881_16163 = state_14865__$1;
(statearr_14881_16163[(2)] = null);

(statearr_14881_16163[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14866 === (4))){
var inst_14823 = (state_14865[(9)]);
var inst_14823__$1 = (state_14865[(2)]);
var inst_14824 = (inst_14823__$1 == null);
var inst_14825 = cljs.core.not(inst_14824);
var state_14865__$1 = (function (){var statearr_14882 = state_14865;
(statearr_14882[(9)] = inst_14823__$1);

return statearr_14882;
})();
if(inst_14825){
var statearr_14883_16165 = state_14865__$1;
(statearr_14883_16165[(1)] = (5));

} else {
var statearr_14884_16166 = state_14865__$1;
(statearr_14884_16166[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14866 === (15))){
var inst_14819 = (state_14865[(8)]);
var inst_14853 = cljs.core.vec(inst_14819);
var state_14865__$1 = state_14865;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14865__$1,(18),out,inst_14853);
} else {
if((state_val_14866 === (13))){
var inst_14848 = (state_14865[(2)]);
var state_14865__$1 = state_14865;
var statearr_14885_16179 = state_14865__$1;
(statearr_14885_16179[(2)] = inst_14848);

(statearr_14885_16179[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14866 === (6))){
var inst_14819 = (state_14865[(8)]);
var inst_14850 = inst_14819.length;
var inst_14851 = (inst_14850 > (0));
var state_14865__$1 = state_14865;
if(cljs.core.truth_(inst_14851)){
var statearr_14886_16181 = state_14865__$1;
(statearr_14886_16181[(1)] = (15));

} else {
var statearr_14887_16183 = state_14865__$1;
(statearr_14887_16183[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14866 === (17))){
var inst_14858 = (state_14865[(2)]);
var inst_14859 = cljs.core.async.close_BANG_(out);
var state_14865__$1 = (function (){var statearr_14888 = state_14865;
(statearr_14888[(10)] = inst_14858);

return statearr_14888;
})();
var statearr_14889_16184 = state_14865__$1;
(statearr_14889_16184[(2)] = inst_14859);

(statearr_14889_16184[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14866 === (3))){
var inst_14863 = (state_14865[(2)]);
var state_14865__$1 = state_14865;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14865__$1,inst_14863);
} else {
if((state_val_14866 === (12))){
var inst_14819 = (state_14865[(8)]);
var inst_14841 = cljs.core.vec(inst_14819);
var state_14865__$1 = state_14865;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14865__$1,(14),out,inst_14841);
} else {
if((state_val_14866 === (2))){
var state_14865__$1 = state_14865;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14865__$1,(4),ch);
} else {
if((state_val_14866 === (11))){
var inst_14823 = (state_14865[(9)]);
var inst_14819 = (state_14865[(8)]);
var inst_14827 = (state_14865[(11)]);
var inst_14838 = inst_14819.push(inst_14823);
var tmp14890 = inst_14819;
var inst_14819__$1 = tmp14890;
var inst_14820 = inst_14827;
var state_14865__$1 = (function (){var statearr_14891 = state_14865;
(statearr_14891[(7)] = inst_14820);

(statearr_14891[(8)] = inst_14819__$1);

(statearr_14891[(12)] = inst_14838);

return statearr_14891;
})();
var statearr_14892_16194 = state_14865__$1;
(statearr_14892_16194[(2)] = null);

(statearr_14892_16194[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14866 === (9))){
var inst_14820 = (state_14865[(7)]);
var inst_14831 = cljs.core.keyword_identical_QMARK_(inst_14820,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_14865__$1 = state_14865;
var statearr_14893_16195 = state_14865__$1;
(statearr_14893_16195[(2)] = inst_14831);

(statearr_14893_16195[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14866 === (5))){
var inst_14820 = (state_14865[(7)]);
var inst_14823 = (state_14865[(9)]);
var inst_14827 = (state_14865[(11)]);
var inst_14828 = (state_14865[(13)]);
var inst_14827__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_14823) : f.call(null,inst_14823));
var inst_14828__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_14827__$1,inst_14820);
var state_14865__$1 = (function (){var statearr_14894 = state_14865;
(statearr_14894[(11)] = inst_14827__$1);

(statearr_14894[(13)] = inst_14828__$1);

return statearr_14894;
})();
if(inst_14828__$1){
var statearr_14895_16196 = state_14865__$1;
(statearr_14895_16196[(1)] = (8));

} else {
var statearr_14896_16197 = state_14865__$1;
(statearr_14896_16197[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14866 === (14))){
var inst_14823 = (state_14865[(9)]);
var inst_14827 = (state_14865[(11)]);
var inst_14843 = (state_14865[(2)]);
var inst_14844 = [];
var inst_14845 = inst_14844.push(inst_14823);
var inst_14819 = inst_14844;
var inst_14820 = inst_14827;
var state_14865__$1 = (function (){var statearr_14897 = state_14865;
(statearr_14897[(7)] = inst_14820);

(statearr_14897[(8)] = inst_14819);

(statearr_14897[(14)] = inst_14843);

(statearr_14897[(15)] = inst_14845);

return statearr_14897;
})();
var statearr_14898_16198 = state_14865__$1;
(statearr_14898_16198[(2)] = null);

(statearr_14898_16198[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14866 === (16))){
var state_14865__$1 = state_14865;
var statearr_14899_16199 = state_14865__$1;
(statearr_14899_16199[(2)] = null);

(statearr_14899_16199[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14866 === (10))){
var inst_14833 = (state_14865[(2)]);
var state_14865__$1 = state_14865;
if(cljs.core.truth_(inst_14833)){
var statearr_14900_16200 = state_14865__$1;
(statearr_14900_16200[(1)] = (11));

} else {
var statearr_14904_16201 = state_14865__$1;
(statearr_14904_16201[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14866 === (18))){
var inst_14855 = (state_14865[(2)]);
var state_14865__$1 = state_14865;
var statearr_14909_16202 = state_14865__$1;
(statearr_14909_16202[(2)] = inst_14855);

(statearr_14909_16202[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14866 === (8))){
var inst_14828 = (state_14865[(13)]);
var state_14865__$1 = state_14865;
var statearr_14913_16203 = state_14865__$1;
(statearr_14913_16203[(2)] = inst_14828);

(statearr_14913_16203[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__12129__auto__ = null;
var cljs$core$async$state_machine__12129__auto____0 = (function (){
var statearr_14917 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14917[(0)] = cljs$core$async$state_machine__12129__auto__);

(statearr_14917[(1)] = (1));

return statearr_14917;
});
var cljs$core$async$state_machine__12129__auto____1 = (function (state_14865){
while(true){
var ret_value__12130__auto__ = (function (){try{while(true){
var result__12131__auto__ = switch__12128__auto__(state_14865);
if(cljs.core.keyword_identical_QMARK_(result__12131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12131__auto__;
}
break;
}
}catch (e14921){var ex__12132__auto__ = e14921;
var statearr_14922_16204 = state_14865;
(statearr_14922_16204[(2)] = ex__12132__auto__);


if(cljs.core.seq((state_14865[(4)]))){
var statearr_14923_16237 = state_14865;
(statearr_14923_16237[(1)] = cljs.core.first((state_14865[(4)])));

} else {
throw ex__12132__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12130__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16243 = state_14865;
state_14865 = G__16243;
continue;
} else {
return ret_value__12130__auto__;
}
break;
}
});
cljs$core$async$state_machine__12129__auto__ = function(state_14865){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12129__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12129__auto____1.call(this,state_14865);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12129__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12129__auto____0;
cljs$core$async$state_machine__12129__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12129__auto____1;
return cljs$core$async$state_machine__12129__auto__;
})()
})();
var state__12374__auto__ = (function (){var statearr_14924 = f__12373__auto__();
(statearr_14924[(6)] = c__12372__auto___16161);

return statearr_14924;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12374__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
