goog.provide('atlas_ui_v2.data');
/**
 * Extract all unique aspects from registry.
 * Returns set of namespaced keywords.
 */
atlas_ui_v2.data.extract_all_aspects = (function atlas_ui_v2$data$extract_all_aspects(registry){
return cljs.core.set(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.keyword_QMARK_,cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.identity,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.keys(registry)], 0))));
});
/**
 * Build hierarchical map of aspects grouped by namespace.
 * 
 * Input: registry
 * Output: {:domain #{:users :auth :scheduling}
 *          :tier #{:service :api :foundation}
 *          :protocol #{:oauth :user-repository}
 *          ...}
 */
atlas_ui_v2.data.build_aspects_map = (function atlas_ui_v2$data$build_aspects_map(registry){
var aspects = atlas_ui_v2.data.extract_all_aspects(registry);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map(),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__9658){
var vec__9661 = p__9658;
var ns_kw = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9661,(0),null);
var aspects_list = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9661,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns_kw,cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__9657_SHARP_){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.name(p1__9657_SHARP_));
}),aspects_list))], null);
}),cljs.core.group_by((function (p1__9656_SHARP_){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.namespace(p1__9656_SHARP_));
}),aspects)));
});
/**
 * Extract the atlas entity type from a compound identity.
 * Returns the :atlas/* keyword if present.
 */
atlas_ui_v2.data.extract_entity_type = (function atlas_ui_v2$data$extract_entity_type(compound_identity){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__9665_SHARP_){
return (((p1__9665_SHARP_ instanceof cljs.core.Keyword)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("atlas",cljs.core.namespace(p1__9665_SHARP_))));
}),compound_identity));
});
/**
 * Build hierarchical map of entities grouped by type.
 * 
 * Input: registry
 * Output: {:atlas/execution-function
 *            {:fn/find-users-by-language #{:tier/service :domain/users ...}
 *             :fn/refresh-oauth-token #{:tier/service :domain/google ...}}
 *          :atlas/structure-component
 *            {:component/db #{:tier/foundation :domain/users ...}}
 *          ...}
 */
atlas_ui_v2.data.build_entities_map = (function atlas_ui_v2$data$build_entities_map(registry){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map(),cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p__9670){
var vec__9671 = p__9670;
var entity_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9671,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9671,(1),null);
return entity_type;
}),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__9674){
var vec__9675 = p__9674;
var entity_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9675,(0),null);
var entries = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9675,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [entity_type,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map(),cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p__9678){
var vec__9679 = p__9678;
var dev_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9679,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9679,(1),null);
return dev_id;
}),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__9682){
var vec__9683 = p__9682;
var identity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9683,(0),null);
var props = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9683,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("atlas","dev-id","atlas/dev-id",2002261553).cljs$core$IFn$_invoke$arity$1(props),identity], null);
}),entries)))], null);
}),cljs.core.group_by((function (p__9686){
var vec__9687 = p__9686;
var identity = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9687,(0),null);
var _props = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9687,(1),null);
return atlas_ui_v2.data.extract_entity_type(identity);
}),registry))));
});
/**
 * Compute statistics about the registry
 */
atlas_ui_v2.data.stats = (function atlas_ui_v2$data$stats(registry){
var aspects_map = atlas_ui_v2.data.build_aspects_map(registry);
var entities_map = atlas_ui_v2.data.build_entities_map(registry);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"aspect-count","aspect-count",-95316145),cljs.core.count(atlas_ui_v2.data.extract_all_aspects(registry)),new cljs.core.Keyword(null,"namespace-count","namespace-count",187554941),cljs.core.count(aspects_map),new cljs.core.Keyword(null,"entity-count","entity-count",870517368),cljs.core.count(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.keys,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.vals(entities_map)], 0))),new cljs.core.Keyword(null,"type-count","type-count",1208627925),cljs.core.count(entities_map)], null);
});

//# sourceMappingURL=atlas_ui_v2.data.js.map
