/*
 * Decompiled with CFR 0.152.
 */
package com.nicheware.maven;

import java.util.Properties;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.providers.http.HttpWagon;
import org.apache.maven.wagon.proxy.ProxyInfoProvider;
import org.apache.maven.wagon.repository.Repository;

public class LeinGitlabWagon
extends HttpWagon {
    public void connect(Repository repository, AuthenticationInfo authenticationInfo, ProxyInfoProvider proxyInfoProvider) throws ConnectionException, AuthenticationException {
        String originalUrl = repository.getUrl();
        if (originalUrl.startsWith("gitlab:") || originalUrl.startsWith("gitlab-insecure:")) {
            String replacedBy = originalUrl.startsWith("gitlab:") ? "https:" : "http:";
            String newUrl = originalUrl.replaceFirst("gitlab.*?:", replacedBy);
            repository.setUrl(newUrl);
            this.setHttpHeadersForAuthentication(authenticationInfo);
            System.out.println(newUrl);
            super.connect(repository, null, proxyInfoProvider);
        } else {
            super.connect(repository, authenticationInfo, proxyInfoProvider);
        }
    }

    private void setHttpHeadersForAuthentication(AuthenticationInfo authenticationInfo) throws AuthenticationException {
        String token;
        Properties headerProperties = new Properties();
        String tokenName = authenticationInfo.getUserName() != null ? authenticationInfo.getUserName() : "Private-Token";
        String string = token = authenticationInfo.getPassword() != null ? authenticationInfo.getPassword() : authenticationInfo.getPassphrase();
        if (token == null || token.isEmpty()) {
            throw new AuthenticationException("No password or passphrase defined for GitLab token");
        }
        headerProperties.setProperty(tokenName, token);
        this.setHttpHeaders(headerProperties);
    }
}

