(ns io.github.ralfspoeth.cljson
  (:refer-clojure)
  (:require [clojure.java.io :as io])
  (:import (io.github.ralfspoeth.json Basic Element JsonArray JsonNull JsonObject)
           (io.github.ralfspoeth.json.io JsonReader)
           (java.io Reader))
  (:gen-class))




;; read an element from a Reader
^Element
(defn json [^Reader rdr]
  (with-open [jsrd (JsonReader. rdr)]
    (.readElement jsrd)))


;; read an element from a String
^Element
(defn json-from-string [^String str]
  (json (io/reader (char-array str))))


;; map a JSON element to its most
;; natural representation in Clojure.
;; the string keys of a JsonObject
;; are converted to keywords.
;; JsonObjects are clojure maps.
;; JsonArrays are sequences.
;; the basic mappings are obvious: nil, boolean, Strings and doubles.
(defn natural
  ([^Element elem]
   (cond
     (instance? JsonNull elem) nil,
     (instance? Basic elem) (.value ^Basic elem)
     (instance? JsonArray elem) (map natural (.elements ^JsonArray elem))
     (instance? JsonObject elem)
     (into {} (map (fn [[k, v]] [(keyword k), (natural v)]) (.members ^JsonObject elem)))))
  ([^String ns, ^Element elem]
   (cond
     (instance? JsonNull elem) nil,
     (instance? Basic elem) (.value ^Basic elem)
     (instance? JsonArray elem)
     (map #(natural ns, %) (.elements ^JsonArray elem))
     (instance? JsonObject elem)
     (into {} (map (fn [[k, v]] [(keyword ns k), (natural ns v)]) (.members ^JsonObject elem))))))


; natural mapping using the current namespace
(defn naturalq [^Element elem]
  (natural (str *ns*) elem))

