;   Copyright (c) Shantanu Kumar. All rights reserved.
;   The use and distribution terms for this software are covered by the
;   Eclipse Public License 1.0 (http://opensource.org/licenses/eclipse-1.0.php)
;   which can be found in the file LICENSE at the root of this distribution.
;   By using this software in any fashion, you are agreeing to be bound by
;   the terms of this license.
;   You must not remove this notice, or any other, from this software.


(ns plumcp.core.constant
  "Global constants"
  #?(:clj (:require
           [clojure.edn :as edn]
           [clojure.java.io :as io]
           [clojure.java.shell :as sh]
           [clojure.string :as str]))
  #?(:clj (:import [java.io IOException]))
  #?(:cljs (:require-macros [plumcp.core.constant :refer [find-version]])))


#?(:clj
   (defmacro find-version
     "Find version of this library in the following order:
      1. Release version, via `project.edn` generated by release process
      2. Git commit SHA (if running in a git repo)
      3. Fall back to `unknown-version`"
     []
     (if-let [r (io/resource "plumcp/core/project.edn")]
       (-> (slurp r)
           edn/read-string
           :version)
       (or (some-> (try
                     (sh/sh "git" "rev-parse" "--short" "HEAD")
                     (catch IOException _  ; when executable not found
                       nil))
                   :out     ; returns "" in a not git repo
                   str/trim
                   seq      ; turns nil if empty, so that some-> aborts
                   str/join ; join back as the string it was
                   (str " (git-commit)"))
           "unknown-version"))))


(def version "Current PluMCP version" (find-version))
