/*
 * Decompiled with CFR 0.152.
 */
package io.raven.db;

import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDao<E> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractDao.class);
    private final SessionFactory sessionFactory;
    private final Class<?> entityClass;

    protected AbstractDao(SessionFactory sessionFactory, Class<E> entityClass) {
        this.sessionFactory = Objects.requireNonNull(sessionFactory);
        this.entityClass = entityClass;
    }

    public Class<E> getEntityClass() {
        return this.entityClass;
    }

    protected E uniqueResult(Criteria criteria) throws HibernateException {
        return (E)Objects.requireNonNull(criteria).uniqueResult();
    }

    protected List<E> list(Criteria criteria) throws HibernateException {
        return Objects.requireNonNull(criteria).list();
    }

    protected Session currentSession() {
        return this.sessionFactory.getCurrentSession();
    }

    protected E persist(E entity) throws HibernateException {
        if (this.currentSession().contains(entity)) {
            this.currentSession().refresh(entity);
        }
        this.currentSession().saveOrUpdate(Objects.requireNonNull(entity));
        return entity;
    }

    protected List<E> persist(List<E> entities) throws HibernateException {
        for (E entity : entities) {
            this.currentSession().persist(entity);
        }
        this.currentSession().flush();
        this.currentSession().clear();
        return entities;
    }
}

