/*
 * Decompiled with CFR 0.152.
 */
package io.raven.db;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import io.raven.db.AbstractDao;
import io.raven.db.TransactionManager;
import io.raven.db.UniMatrixException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.persistence.Id;
import lombok.Generated;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.hibernate.Criteria;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MultiIdentifierLoadAccess;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityDao<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntityDao.class);
    private final Class<T> entityClass;
    private final EntityInternalDao dao;
    private final Field keyField;

    public EntityDao(SessionFactory sessionFactory, Class<T> entityClass) {
        this.dao = new EntityInternalDao(sessionFactory, entityClass);
        this.entityClass = entityClass;
        Field[] fields = FieldUtils.getFieldsWithAnnotation(entityClass, Id.class);
        Preconditions.checkArgument((fields.length != 0 ? 1 : 0) != 0, (Object)"At least one field needs to be sharding keys");
        Preconditions.checkArgument((fields.length == 1 ? 1 : 0) != 0, (Object)"Only one field can be sharding keys");
        this.keyField = fields[0];
    }

    public Optional<T> get(Long ids) throws UniMatrixException {
        return this.get(ids, (Optional<T> e) -> e);
    }

    public <U> Optional<U> get(Long ids, Function<Optional<T>, Optional<U>> handler) throws UniMatrixException {
        return TransactionManager.newTransaction().readOnly(true).sessionFactory(this.dao.sessionFactory).build().execute(this.dao::get, ids, handler);
    }

    public List<T> get(List<Long> ids) throws UniMatrixException {
        return this.get(ids, (List<T> e) -> e);
    }

    public <U> List<U> get(List<Long> ids, Function<List<T>, List<U>> handler) throws UniMatrixException {
        return TransactionManager.newTransaction().readOnly(true).sessionFactory(this.dao.sessionFactory).build().execute(this.dao::get, ids, handler);
    }

    public boolean exists(Long id) throws UniMatrixException {
        return this.get(id).isPresent();
    }

    public Optional<T> save(T entity) throws UniMatrixException {
        return Optional.ofNullable(this.save(entity, (T t) -> t));
    }

    public <U> U save(T entity, Function<T, U> handler) throws UniMatrixException {
        return TransactionManager.newTransaction().sessionFactory(this.dao.sessionFactory).readOnly(false).build().execute(this.dao::save, entity, handler);
    }

    public List<T> save(List<T> entities) throws UniMatrixException {
        return this.save(entities, (List<T> e) -> e);
    }

    public <U> List<U> save(List<T> entities, Function<List<T>, List<U>> handler) throws UniMatrixException {
        return TransactionManager.newTransaction().sessionFactory(this.dao.sessionFactory).readOnly(false).build().execute(this.dao::save, entities, handler);
    }

    public boolean updateInLock(Long id, UnaryOperator<Optional<T>> updater) throws UniMatrixException {
        return this.updateImpl(id, this.dao::getLockedForWrite, updater);
    }

    private boolean updateImpl(Long id, Function<Long, Optional<T>> getter, UnaryOperator<Optional<T>> updater) throws UniMatrixException {
        try {
            return TransactionManager.newTransaction().readOnly(false).sessionFactory(this.dao.sessionFactory).build().execute(getter, id, entity -> {
                if (entity.isEmpty()) {
                    return false;
                }
                Optional newEntity = (Optional)updater.apply((Optional<T>)entity);
                if (newEntity.isEmpty()) {
                    return false;
                }
                newEntity.ifPresent(this.dao::update);
                return true;
            });
        }
        catch (Exception e) {
            throw UniMatrixException.from().exception(e).build();
        }
    }

    public boolean update(Long id, UnaryOperator<Optional<T>> updater) throws UniMatrixException {
        return this.updateImpl(id, this.dao::get, updater);
    }

    public TransactionContext<T> getTransactionContext(Long id) {
        return new TransactionContext(this.dao.sessionFactory, this.dao::getLockedForWrite, id);
    }

    public TransactionContext<T> getTransactionContext(LongSupplier supplier) {
        return this.getTransactionContext(supplier.getAsLong());
    }

    public BatchTransactionContext<T> getBatchTransactionContext(List<Long> ids) {
        return new BatchTransactionContext(this.dao.sessionFactory, this.dao::getLockedForWrite, ids, true);
    }

    public BatchTransactionContext<T> getBatchTransactionContext(Supplier<List<Long>> supplier) {
        return this.getBatchTransactionContext(supplier.get());
    }

    public TransactionContext<T> saveTransactionContext(T entity) {
        return new TransactionContext<T>(this.dao.sessionFactory, this.dao::save, entity);
    }

    public TransactionContext<T> saveTransactionContext(Supplier<T> generator) {
        return this.saveTransactionContext(generator.get());
    }

    public BatchTransactionContext<T> saveBatchTransactionContext(List<T> entities) {
        return new BatchTransactionContext<T>(this.dao.sessionFactory, this.dao::save, entities);
    }

    public BatchTransactionContext<T> saveBatchTransactionContext(Supplier<List<T>> generator) {
        return this.saveBatchTransactionContext(generator.get());
    }

    public long count(DetachedCriteria criteria) throws UniMatrixException {
        return TransactionManager.newTransaction().readOnly(true).sessionFactory(this.dao.sessionFactory).build().execute(this.dao::count, criteria);
    }

    public BigDecimal sum(DetachedCriteria criteria, String propertyName) throws UniMatrixException {
        criteria.setProjection((Projection)Projections.sum((String)propertyName));
        return TransactionManager.newTransaction().readOnly(true).sessionFactory(this.dao.sessionFactory).build().execute(this.dao::sum, criteria);
    }

    public long max(DetachedCriteria criteria, String propertyName) throws UniMatrixException {
        return TransactionManager.newTransaction().readOnly(true).sessionFactory(this.dao.sessionFactory).build().execute(this.dao::max, MaxParams.builder().criteria(criteria).propertyName(propertyName).build());
    }

    public <U> List<U> select(DetachedCriteria detachedCriteria, Function<List<T>, List<U>> handler, int limit, int offset) throws UniMatrixException {
        return TransactionManager.newTransaction().readOnly(true).sessionFactory(this.dao.sessionFactory).build().execute(this.dao::select, CriteriaParams.builder().criteria(detachedCriteria).limit(limit).offset(offset).build(), handler);
    }

    public <U> List<U> select(DetachedCriteria criteria, Function<List<T>, List<U>> handler, int pageSize) throws UniMatrixException {
        return TransactionManager.newTransaction().readOnly(true).sessionFactory(this.dao.sessionFactory).build().execute(this.dao::select, CriteriaParams.builder().criteria(criteria).limit(pageSize).build(), handler);
    }

    public <U> List<U> select(DetachedCriteria criteria, Function<List<T>, List<U>> handler) throws UniMatrixException {
        return TransactionManager.newTransaction().readOnly(true).sessionFactory(this.dao.sessionFactory).build().execute(this.dao::select, criteria, handler);
    }

    public <U> List<U> select(String query, Map<String, Object> params, Function<List<T>, List<U>> handler) throws UniMatrixException {
        return TransactionManager.newTransaction().readOnly(true).sessionFactory(this.dao.sessionFactory).build().execute(this.dao::select, QueryParams.builder().query(query).params(params).build(), handler);
    }

    public Optional<T> selectSingle(DetachedCriteria detachedCriteria) throws UniMatrixException {
        return this.selectSingle(detachedCriteria, t -> t);
    }

    public <U> Optional<U> selectSingle(DetachedCriteria detachedCriteria, Function<T, U> handler) throws UniMatrixException {
        return Optional.ofNullable(TransactionManager.newTransaction().readOnly(true).sessionFactory(this.dao.sessionFactory).build().execute(this.dao::selectSingle, detachedCriteria, handler));
    }

    public int update(String query, Map<String, Object> params) throws UniMatrixException {
        return TransactionManager.newTransaction().readOnly(false).sessionFactory(this.dao.sessionFactory).build().execute(this.dao::update, QueryParams.builder().params(params).query(query).build());
    }

    public int updateNative(String query, Map<String, Object> params) throws UniMatrixException {
        return TransactionManager.newTransaction().readOnly(false).sessionFactory(this.dao.sessionFactory).build().execute(this.dao::update, QueryParams.builder().params(params).query(query).nativeQuery(true).build());
    }

    @Generated
    public EntityInternalDao getDao() {
        return this.dao;
    }

    @Generated
    public Field getKeyField() {
        return this.keyField;
    }

    private final class EntityInternalDao
    extends AbstractDao<T> {
        private final SessionFactory sessionFactory;

        public EntityInternalDao(SessionFactory sessionFactory, Class<T> entityClass) {
            super(sessionFactory, entityClass);
            this.sessionFactory = sessionFactory;
        }

        Optional<T> get(Long id) {
            return this.getLocked(id, LockMode.READ);
        }

        Optional<T> getLocked(Long id, LockMode lockMode) {
            return Optional.ofNullable(this.currentSession().get(EntityDao.this.entityClass, (Serializable)id, lockMode));
        }

        List<T> get(List<Long> ids) {
            return this.getLocked(ids, LockMode.READ);
        }

        List<T> getLocked(List<Long> ids, LockMode lockMode) {
            MultiIdentifierLoadAccess multiGet = this.currentSession().byMultipleIds(EntityDao.this.entityClass);
            return multiGet.with(new LockOptions(lockMode)).multiLoad(ids);
        }

        Optional<T> getLockedForWrite(Long id) {
            return this.getLocked(id, LockMode.UPGRADE_NOWAIT);
        }

        List<T> getLockedForWrite(List<Long> ids) {
            return this.getLocked(ids, LockMode.UPGRADE_NOWAIT);
        }

        T save(T entity) {
            return this.persist(entity);
        }

        List<T> save(List<T> entities) {
            ArrayList saved = new ArrayList();
            for (Object e : entities) {
                saved.add(this.persist(e));
            }
            return saved;
        }

        void update(T entity) {
            this.currentSession().evict(entity);
            this.currentSession().update(entity);
        }

        List<T> select(DetachedCriteria criteria) {
            return this.list(criteria.getExecutableCriteria(this.currentSession()));
        }

        public List<T> select(QueryParams queryParams) {
            Query tQuery = this.currentSession().createQuery(queryParams.query, this.getEntityClass());
            if (queryParams.params != null) {
                queryParams.params.forEach((arg_0, arg_1) -> ((Query)tQuery).setParameter(arg_0, arg_1));
            }
            return tQuery.getResultList();
        }

        public List<T> select(CriteriaParams criteriaParams) {
            Criteria exeCriteria = criteriaParams.criteria.getExecutableCriteria(this.currentSession());
            if (criteriaParams.limit != -1) {
                exeCriteria.setMaxResults(criteriaParams.limit);
            }
            if (criteriaParams.offset != -1) {
                exeCriteria.setFirstResult(criteriaParams.offset);
            }
            if (!Strings.isNullOrEmpty((String)criteriaParams.fetchProfile)) {
                this.currentSession().enableFetchProfile(criteriaParams.fetchProfile);
            }
            return this.list(exeCriteria);
        }

        public T selectSingle(DetachedCriteria criteria) {
            return this.uniqueResult(criteria.getExecutableCriteria(this.currentSession()));
        }

        long count(DetachedCriteria criteria) {
            return (Long)criteria.getExecutableCriteria(this.currentSession()).setProjection(Projections.rowCount()).uniqueResult();
        }

        BigDecimal sum(DetachedCriteria criteria) {
            return (BigDecimal)criteria.getExecutableCriteria(this.currentSession()).uniqueResult();
        }

        Long max(MaxParams maxParams) {
            return (Long)maxParams.criteria.getExecutableCriteria(this.currentSession()).setProjection((Projection)Projections.max((String)maxParams.propertyName)).uniqueResult();
        }

        public int update(QueryParams updateParams) {
            if (updateParams.nativeQuery) {
                NativeQuery tQuery = this.currentSession().createSQLQuery(updateParams.query);
                updateParams.params.forEach((arg_0, arg_1) -> ((NativeQuery)tQuery).setParameter(arg_0, arg_1));
                return tQuery.executeUpdate();
            }
            Query tQuery = this.currentSession().createQuery(updateParams.query);
            updateParams.params.forEach((arg_0, arg_1) -> ((Query)tQuery).setParameter(arg_0, arg_1));
            return tQuery.executeUpdate();
        }
    }

    public static class BatchTransactionContext<T> {
        private final SessionFactory sessionFactory;
        private final Mode mode;
        private Function<List<Long>, List<T>> function;
        private UnaryOperator<List<T>> saver;
        private List<T> entity;
        private List<Long> keys;
        private List<Function<List<T>, Void>> operations = Lists.newArrayList();

        public BatchTransactionContext(SessionFactory sessionFactory, Function<List<Long>, List<T>> getter, List<Long> keys, boolean read) {
            this.sessionFactory = sessionFactory;
            this.function = getter;
            this.keys = keys;
            this.mode = read ? Mode.READ : Mode.INSERT;
        }

        public BatchTransactionContext(SessionFactory sessionFactory, UnaryOperator<List<T>> saver, List<T> entity) {
            this.sessionFactory = sessionFactory;
            this.saver = saver;
            this.entity = entity;
            this.mode = Mode.INSERT;
        }

        public BatchTransactionContext<T> mutate(Mutator<T> mutator) {
            return this.apply(parent -> {
                mutator.mutator((List)parent);
                return null;
            });
        }

        public BatchTransactionContext<T> apply(Function<List<T>, Void> handler) {
            this.operations.add(handler);
            return this;
        }

        public <U> BatchTransactionContext<T> save(EntityDao<U> entityDao, Function<List<T>, List<U>> entityGenerator) {
            return this.apply(parent -> {
                try {
                    List entities = (List)entityGenerator.apply((List)parent);
                    entityDao.save(entities);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return null;
            });
        }

        public <U> BatchTransactionContext<T> saveAll(EntityDao<U> lookupDao, Function<List<T>, List<U>> entityGenerator, BiFunction<List<U>, List<T>, Void> postPersistHandler) {
            return this.apply(parent -> {
                try {
                    List entities = (List)entityGenerator.apply((List)parent);
                    lookupDao.save(entities);
                    postPersistHandler.apply(entities, (List)parent);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return null;
            });
        }

        public <U> BatchTransactionContext<T> save(EntityDao<U> lookupDao, Function<List<T>, Optional<U>> entityGenerator, BiFunction<Optional<U>, List<T>, Void> postPersistHandler) {
            return this.apply(parent -> {
                try {
                    Optional entity = (Optional)entityGenerator.apply((List)parent);
                    if (entity.isPresent()) {
                        lookupDao.save(entity.get());
                    }
                    postPersistHandler.apply(entity, (List)parent);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return null;
            });
        }

        public List<T> execute() {
            TransactionManager transactionManager = TransactionManager.newTransaction().sessionFactory(this.sessionFactory).readOnly(false).build();
            transactionManager.beforeStart();
            try {
                List result = this.generateEntity();
                this.operations.forEach(operation -> operation.apply(result));
                List list = result;
                return list;
            }
            catch (Exception e) {
                transactionManager.onError(e);
                throw e;
            }
            finally {
                transactionManager.afterEnd();
            }
        }

        private List<T> generateEntity() {
            List result = null;
            switch (this.mode) {
                case READ: {
                    result = this.function.apply(this.keys);
                    if (result != null) break;
                    throw new RuntimeException("Entity doesn't exist for keys: " + this.keys);
                }
                case INSERT: {
                    result = (List)this.saver.apply(this.entity);
                    break;
                }
            }
            return result;
        }

        @Generated
        public SessionFactory getSessionFactory() {
            return this.sessionFactory;
        }

        @Generated
        public Mode getMode() {
            return this.mode;
        }

        @Generated
        public Function<List<Long>, List<T>> getFunction() {
            return this.function;
        }

        @Generated
        public UnaryOperator<List<T>> getSaver() {
            return this.saver;
        }

        @Generated
        public List<T> getEntity() {
            return this.entity;
        }

        @Generated
        public List<Long> getKeys() {
            return this.keys;
        }

        @Generated
        public List<Function<List<T>, Void>> getOperations() {
            return this.operations;
        }

        @FunctionalInterface
        public static interface Mutator<T> {
            public void mutator(List<T> var1);
        }

        static enum Mode {
            READ,
            INSERT;

        }
    }

    public static class TransactionContext<T> {
        private final SessionFactory sessionFactory;
        private final Mode mode;
        private Function<Long, Optional<T>> function;
        private UnaryOperator<T> saver;
        private T entity;
        private Long key;
        private List<Function<T, Void>> operations = Lists.newArrayList();

        public TransactionContext(SessionFactory sessionFactory, Function<Long, Optional<T>> getter, Long key) {
            this.sessionFactory = sessionFactory;
            this.function = getter;
            this.key = key;
            this.mode = Mode.READ;
        }

        public TransactionContext(SessionFactory sessionFactory, UnaryOperator<T> saver, T entity) {
            this.sessionFactory = sessionFactory;
            this.saver = saver;
            this.entity = entity;
            this.mode = Mode.INSERT;
        }

        public TransactionContext<T> mutate(Mutator<T> mutator) {
            return this.apply(parent -> {
                mutator.mutator(parent);
                return null;
            });
        }

        public TransactionContext<T> apply(Function<T, Void> handler) {
            this.operations.add(handler);
            return this;
        }

        public <U> TransactionContext<T> save(EntityDao<U> lookupDao, Function<T, U> entityGenerator) {
            return this.apply(parent -> {
                try {
                    Object entity = entityGenerator.apply(parent);
                    lookupDao.save(entity);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return null;
            });
        }

        public <U> TransactionContext<T> save(EntityDao<U> lookupDao, Function<T, U> entityGenerator, BiFunction<U, T, Void> postPersistHandler) {
            return this.apply(parent -> {
                try {
                    Object entity = entityGenerator.apply(parent);
                    lookupDao.save(entity);
                    postPersistHandler.apply(entity, parent);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return null;
            });
        }

        public <U> TransactionContext<T> saveAll(EntityDao<U> lookupDao, Function<T, List<U>> entityGenerator) {
            return this.apply(parent -> {
                try {
                    List entities = (List)entityGenerator.apply(parent);
                    lookupDao.save(entities);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return null;
            });
        }

        public <U> TransactionContext<T> update(EntityDao<U> lookupDao, Long id, UnaryOperator<Optional<U>> handler) {
            return this.apply(parent -> {
                try {
                    lookupDao.update(id, handler);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return null;
            });
        }

        public <U> TransactionContext<T> update(EntityDao<U> lookupDao, String query, Map<String, Object> params) {
            return this.apply(parent -> {
                try {
                    int result = lookupDao.update(query, params);
                    if (result < 1) {
                        throw UniMatrixException.fromMessage().message("Update operation returned result " + result).build();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return null;
            });
        }

        public TransactionContext<T> filter(Predicate<T> predicate) {
            return this.filter(predicate, new IllegalArgumentException("Predicate check failed"));
        }

        public TransactionContext<T> filter(Predicate<T> predicate, RuntimeException failureException) {
            return this.apply(parent -> {
                boolean result = predicate.test(parent);
                if (!result) {
                    throw failureException;
                }
                return null;
            });
        }

        public T execute() {
            TransactionManager transactionManager = TransactionManager.newTransaction().readOnly(false).sessionFactory(this.sessionFactory).build();
            transactionManager.beforeStart();
            try {
                Object result = this.generateEntity();
                this.operations.forEach(operation -> operation.apply(result));
                Object t = result;
                return t;
            }
            catch (Exception e) {
                transactionManager.onError(e);
                throw e;
            }
            finally {
                transactionManager.afterEnd();
            }
        }

        private T generateEntity() {
            Optional<Object> result = Optional.empty();
            switch (this.mode) {
                case READ: {
                    result = this.function.apply(this.key);
                    if (!result.isEmpty()) break;
                    throw new RuntimeException("Entity doesn't exist for keys: " + this.key);
                }
                case INSERT: {
                    result = Optional.ofNullable(this.saver.apply(this.entity));
                    break;
                }
            }
            return result.orElse(null);
        }

        @Generated
        public SessionFactory getSessionFactory() {
            return this.sessionFactory;
        }

        @Generated
        public Mode getMode() {
            return this.mode;
        }

        @Generated
        public Function<Long, Optional<T>> getFunction() {
            return this.function;
        }

        @Generated
        public UnaryOperator<T> getSaver() {
            return this.saver;
        }

        @Generated
        public T getEntity() {
            return this.entity;
        }

        @Generated
        public Long getKey() {
            return this.key;
        }

        @Generated
        public List<Function<T, Void>> getOperations() {
            return this.operations;
        }

        @FunctionalInterface
        public static interface Mutator<T> {
            public void mutator(T var1);
        }

        static enum Mode {
            READ,
            INSERT;

        }
    }

    public static class MaxParams {
        private DetachedCriteria criteria;
        private String propertyName;

        @Generated
        MaxParams(DetachedCriteria criteria, String propertyName) {
            this.criteria = criteria;
            this.propertyName = propertyName;
        }

        @Generated
        public static MaxParamsBuilder builder() {
            return new MaxParamsBuilder();
        }

        @Generated
        public DetachedCriteria getCriteria() {
            return this.criteria;
        }

        @Generated
        public String getPropertyName() {
            return this.propertyName;
        }

        @Generated
        public void setCriteria(DetachedCriteria criteria) {
            this.criteria = criteria;
        }

        @Generated
        public void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MaxParams)) {
                return false;
            }
            MaxParams other = (MaxParams)o;
            if (!other.canEqual(this)) {
                return false;
            }
            DetachedCriteria this$criteria = this.getCriteria();
            DetachedCriteria other$criteria = other.getCriteria();
            if (this$criteria == null ? other$criteria != null : !this$criteria.equals(other$criteria)) {
                return false;
            }
            String this$propertyName = this.getPropertyName();
            String other$propertyName = other.getPropertyName();
            return !(this$propertyName == null ? other$propertyName != null : !this$propertyName.equals(other$propertyName));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof MaxParams;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            DetachedCriteria $criteria = this.getCriteria();
            result = result * 59 + ($criteria == null ? 43 : $criteria.hashCode());
            String $propertyName = this.getPropertyName();
            result = result * 59 + ($propertyName == null ? 43 : $propertyName.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "EntityDao.MaxParams(criteria=" + this.getCriteria() + ", propertyName=" + this.getPropertyName() + ")";
        }

        @Generated
        public static class MaxParamsBuilder {
            @Generated
            private DetachedCriteria criteria;
            @Generated
            private String propertyName;

            @Generated
            MaxParamsBuilder() {
            }

            @Generated
            public MaxParamsBuilder criteria(DetachedCriteria criteria) {
                this.criteria = criteria;
                return this;
            }

            @Generated
            public MaxParamsBuilder propertyName(String propertyName) {
                this.propertyName = propertyName;
                return this;
            }

            @Generated
            public MaxParams build() {
                return new MaxParams(this.criteria, this.propertyName);
            }

            @Generated
            public String toString() {
                return "EntityDao.MaxParams.MaxParamsBuilder(criteria=" + this.criteria + ", propertyName=" + this.propertyName + ")";
            }
        }
    }

    public static class QueryParams {
        private String query;
        private Map<String, Object> params;
        private boolean nativeQuery;
        private boolean propagateParent;
        private String targetProperty;

        @Generated
        QueryParams(String query, Map<String, Object> params, boolean nativeQuery, boolean propagateParent, String targetProperty) {
            this.query = query;
            this.params = params;
            this.nativeQuery = nativeQuery;
            this.propagateParent = propagateParent;
            this.targetProperty = targetProperty;
        }

        @Generated
        public static QueryParamsBuilder builder() {
            return new QueryParamsBuilder();
        }

        @Generated
        public String getQuery() {
            return this.query;
        }

        @Generated
        public Map<String, Object> getParams() {
            return this.params;
        }

        @Generated
        public boolean isNativeQuery() {
            return this.nativeQuery;
        }

        @Generated
        public boolean isPropagateParent() {
            return this.propagateParent;
        }

        @Generated
        public String getTargetProperty() {
            return this.targetProperty;
        }

        @Generated
        public void setQuery(String query) {
            this.query = query;
        }

        @Generated
        public void setParams(Map<String, Object> params) {
            this.params = params;
        }

        @Generated
        public void setNativeQuery(boolean nativeQuery) {
            this.nativeQuery = nativeQuery;
        }

        @Generated
        public void setPropagateParent(boolean propagateParent) {
            this.propagateParent = propagateParent;
        }

        @Generated
        public void setTargetProperty(String targetProperty) {
            this.targetProperty = targetProperty;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QueryParams)) {
                return false;
            }
            QueryParams other = (QueryParams)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isNativeQuery() != other.isNativeQuery()) {
                return false;
            }
            if (this.isPropagateParent() != other.isPropagateParent()) {
                return false;
            }
            String this$query = this.getQuery();
            String other$query = other.getQuery();
            if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
                return false;
            }
            Map<String, Object> this$params = this.getParams();
            Map<String, Object> other$params = other.getParams();
            if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
                return false;
            }
            String this$targetProperty = this.getTargetProperty();
            String other$targetProperty = other.getTargetProperty();
            return !(this$targetProperty == null ? other$targetProperty != null : !this$targetProperty.equals(other$targetProperty));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof QueryParams;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isNativeQuery() ? 79 : 97);
            result = result * 59 + (this.isPropagateParent() ? 79 : 97);
            String $query = this.getQuery();
            result = result * 59 + ($query == null ? 43 : $query.hashCode());
            Map<String, Object> $params = this.getParams();
            result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
            String $targetProperty = this.getTargetProperty();
            result = result * 59 + ($targetProperty == null ? 43 : $targetProperty.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "EntityDao.QueryParams(query=" + this.getQuery() + ", params=" + this.getParams() + ", nativeQuery=" + this.isNativeQuery() + ", propagateParent=" + this.isPropagateParent() + ", targetProperty=" + this.getTargetProperty() + ")";
        }

        @Generated
        public static class QueryParamsBuilder {
            @Generated
            private String query;
            @Generated
            private Map<String, Object> params;
            @Generated
            private boolean nativeQuery;
            @Generated
            private boolean propagateParent;
            @Generated
            private String targetProperty;

            @Generated
            QueryParamsBuilder() {
            }

            @Generated
            public QueryParamsBuilder query(String query) {
                this.query = query;
                return this;
            }

            @Generated
            public QueryParamsBuilder params(Map<String, Object> params) {
                this.params = params;
                return this;
            }

            @Generated
            public QueryParamsBuilder nativeQuery(boolean nativeQuery) {
                this.nativeQuery = nativeQuery;
                return this;
            }

            @Generated
            public QueryParamsBuilder propagateParent(boolean propagateParent) {
                this.propagateParent = propagateParent;
                return this;
            }

            @Generated
            public QueryParamsBuilder targetProperty(String targetProperty) {
                this.targetProperty = targetProperty;
                return this;
            }

            @Generated
            public QueryParams build() {
                return new QueryParams(this.query, this.params, this.nativeQuery, this.propagateParent, this.targetProperty);
            }

            @Generated
            public String toString() {
                return "EntityDao.QueryParams.QueryParamsBuilder(query=" + this.query + ", params=" + this.params + ", nativeQuery=" + this.nativeQuery + ", propagateParent=" + this.propagateParent + ", targetProperty=" + this.targetProperty + ")";
            }
        }
    }

    public static class CriteriaParams {
        private DetachedCriteria criteria;
        private int limit;
        private int offset;
        private String fetchProfile;

        @Generated
        private static int $default$limit() {
            return -1;
        }

        @Generated
        private static int $default$offset() {
            return -1;
        }

        @Generated
        CriteriaParams(DetachedCriteria criteria, int limit, int offset, String fetchProfile) {
            this.criteria = criteria;
            this.limit = limit;
            this.offset = offset;
            this.fetchProfile = fetchProfile;
        }

        @Generated
        public static CriteriaParamsBuilder builder() {
            return new CriteriaParamsBuilder();
        }

        @Generated
        public DetachedCriteria getCriteria() {
            return this.criteria;
        }

        @Generated
        public int getLimit() {
            return this.limit;
        }

        @Generated
        public int getOffset() {
            return this.offset;
        }

        @Generated
        public String getFetchProfile() {
            return this.fetchProfile;
        }

        @Generated
        public void setCriteria(DetachedCriteria criteria) {
            this.criteria = criteria;
        }

        @Generated
        public void setLimit(int limit) {
            this.limit = limit;
        }

        @Generated
        public void setOffset(int offset) {
            this.offset = offset;
        }

        @Generated
        public void setFetchProfile(String fetchProfile) {
            this.fetchProfile = fetchProfile;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CriteriaParams)) {
                return false;
            }
            CriteriaParams other = (CriteriaParams)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getLimit() != other.getLimit()) {
                return false;
            }
            if (this.getOffset() != other.getOffset()) {
                return false;
            }
            DetachedCriteria this$criteria = this.getCriteria();
            DetachedCriteria other$criteria = other.getCriteria();
            if (this$criteria == null ? other$criteria != null : !this$criteria.equals(other$criteria)) {
                return false;
            }
            String this$fetchProfile = this.getFetchProfile();
            String other$fetchProfile = other.getFetchProfile();
            return !(this$fetchProfile == null ? other$fetchProfile != null : !this$fetchProfile.equals(other$fetchProfile));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CriteriaParams;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLimit();
            result = result * 59 + this.getOffset();
            DetachedCriteria $criteria = this.getCriteria();
            result = result * 59 + ($criteria == null ? 43 : $criteria.hashCode());
            String $fetchProfile = this.getFetchProfile();
            result = result * 59 + ($fetchProfile == null ? 43 : $fetchProfile.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "EntityDao.CriteriaParams(criteria=" + this.getCriteria() + ", limit=" + this.getLimit() + ", offset=" + this.getOffset() + ", fetchProfile=" + this.getFetchProfile() + ")";
        }

        @Generated
        public static class CriteriaParamsBuilder {
            @Generated
            private DetachedCriteria criteria;
            @Generated
            private boolean limit$set;
            @Generated
            private int limit$value;
            @Generated
            private boolean offset$set;
            @Generated
            private int offset$value;
            @Generated
            private String fetchProfile;

            @Generated
            CriteriaParamsBuilder() {
            }

            @Generated
            public CriteriaParamsBuilder criteria(DetachedCriteria criteria) {
                this.criteria = criteria;
                return this;
            }

            @Generated
            public CriteriaParamsBuilder limit(int limit) {
                this.limit$value = limit;
                this.limit$set = true;
                return this;
            }

            @Generated
            public CriteriaParamsBuilder offset(int offset) {
                this.offset$value = offset;
                this.offset$set = true;
                return this;
            }

            @Generated
            public CriteriaParamsBuilder fetchProfile(String fetchProfile) {
                this.fetchProfile = fetchProfile;
                return this;
            }

            @Generated
            public CriteriaParams build() {
                int limit$value = this.limit$value;
                if (!this.limit$set) {
                    limit$value = CriteriaParams.$default$limit();
                }
                int offset$value = this.offset$value;
                if (!this.offset$set) {
                    offset$value = CriteriaParams.$default$offset();
                }
                return new CriteriaParams(this.criteria, limit$value, offset$value, this.fetchProfile);
            }

            @Generated
            public String toString() {
                return "EntityDao.CriteriaParams.CriteriaParamsBuilder(criteria=" + this.criteria + ", limit$value=" + this.limit$value + ", offset$value=" + this.offset$value + ", fetchProfile=" + this.fetchProfile + ")";
            }
        }
    }
}

