/*
 * Decompiled with CFR 0.152.
 */
package io.github.phaneesh;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.github.phaneesh.UniMatrixConfig;
import java.util.Objects;
import javax.sql.DataSource;
import org.jooq.DSLContext;
import org.jooq.SQLDialect;
import org.jooq.impl.DSL;

public class UniMatrix {
    private DSLContext dslContext;
    private HikariDataSource dataSource;
    private final UniMatrixConfig config;

    public UniMatrix(UniMatrixConfig uniMatrixConfig) {
        this.config = uniMatrixConfig;
        this.init();
    }

    public void close() {
        if (Objects.nonNull(this.dataSource)) {
            this.dataSource.close();
        }
    }

    private void init() {
        this.dslContext = this.getOrCreateDSLContext();
    }

    public synchronized DSLContext getOrCreateDSLContext() {
        if (!Objects.isNull(this.dslContext)) {
            return this.dslContext;
        }
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setJdbcUrl(this.config.getUrl());
        hikariConfig.setUsername(this.config.getUser());
        hikariConfig.setPassword(this.config.getPassword());
        hikariConfig.setDriverClassName(this.config.getDriverClass());
        hikariConfig.setMaximumPoolSize(this.config.getMaxPoolSize());
        hikariConfig.setMinimumIdle(this.config.getMinPoolSize());
        hikariConfig.setIdleTimeout((long)this.config.getIdleTimeout());
        hikariConfig.setAutoCommit(false);
        hikariConfig.setConnectionTimeout(30000L);
        hikariConfig.setConnectionTestQuery("SELECT 1");
        hikariConfig.setPoolName(this.config.getName());
        hikariConfig.setRegisterMbeans(true);
        hikariConfig.setMaxLifetime((long)this.config.getMaxAge());
        this.dataSource = new HikariDataSource(hikariConfig);
        this.dslContext = DSL.using((DataSource)this.dataSource, (SQLDialect)this.config.getDialect());
        return this.dslContext;
    }

    public static UniMatrixBuilder builder() {
        return new UniMatrixBuilder();
    }

    public DSLContext getDslContext() {
        return this.dslContext;
    }

    public static class UniMatrixBuilder {
        private UniMatrixConfig uniMatrixConfig;

        UniMatrixBuilder() {
        }

        public UniMatrixBuilder uniMatrixConfig(UniMatrixConfig uniMatrixConfig) {
            this.uniMatrixConfig = uniMatrixConfig;
            return this;
        }

        public UniMatrix build() {
            return new UniMatrix(this.uniMatrixConfig);
        }

        public String toString() {
            return "UniMatrix.UniMatrixBuilder(uniMatrixConfig=" + this.uniMatrixConfig + ")";
        }
    }
}

