/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.ipapi.filter;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.base.Strings;
import io.dropwizard.ipapi.client.IpApiClient;
import io.dropwizard.ipapi.config.IpApiConfig;
import io.dropwizard.ipapi.core.IpLocationResponse;
import java.io.IOException;
import java.net.InetAddress;
import java.time.Duration;
import java.util.Objects;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=3000)
public class IpApiRequestFilter
implements ContainerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(IpApiRequestFilter.class);
    private final IpApiConfig config;
    private final IpApiClient client;
    private LoadingCache<String, IpLocationResponse> locationCache = Caffeine.newBuilder().maximumSize(1000000L).expireAfterWrite(Duration.ofMinutes(60L)).build(this::getLocationInfo);

    public IpApiRequestFilter(IpApiConfig config, IpApiClient client) {
        this.config = config;
        this.client = client;
    }

    public void filter(ContainerRequestContext containerRequestContext) throws IOException {
        String[] addresses;
        String clientIp;
        String clientAddress = (String)containerRequestContext.getHeaders().getFirst((Object)this.config.getRemoteIpHeader());
        if (Strings.isNullOrEmpty((String)clientAddress)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Header: {} | Value: {}", (Object)this.config.getRemoteIpHeader(), (Object)clientAddress);
        }
        if (!Strings.isNullOrEmpty((String)(clientIp = (addresses = clientAddress.split(","))[0].split(":")[0]))) {
            InetAddress address;
            try {
                address = InetAddress.getByName(clientIp);
            }
            catch (Exception e) {
                log.warn("Cannot resolve address: {} | Error: {}", (Object)clientIp, (Object)e.getMessage());
                return;
            }
            if (address == null) {
                log.warn("Cannot resolve address: {}", (Object)clientIp);
                return;
            }
            try {
                IpLocationResponse locInfo = (IpLocationResponse)this.locationCache.get((Object)clientIp);
                if (Objects.nonNull(locInfo)) {
                    this.addLocationHeaders(locInfo, containerRequestContext);
                }
            }
            catch (Exception ex) {
                log.warn("IpAPI Error: {}", (Object)ex.getMessage());
            }
        }
    }

    private IpLocationResponse getLocationInfo(String address) {
        try {
            return this.client.location(address);
        }
        catch (Exception ex) {
            log.warn("IpAPI Error: {}", (Object)ex.getMessage());
            return null;
        }
    }

    private void addLocationHeaders(IpLocationResponse ipLocationResponse, ContainerRequestContext containerRequestContext) {
        if (!Strings.isNullOrEmpty((String)ipLocationResponse.getCountry())) {
            containerRequestContext.getHeaders().putSingle((Object)"X-REQUEST-COUNTRY", (Object)this.toAscii(ipLocationResponse.getCountry()));
        }
        if (!Strings.isNullOrEmpty((String)ipLocationResponse.getCountryCode())) {
            containerRequestContext.getHeaders().putSingle((Object)"X-REQUEST-COUNTRY-ISO", (Object)ipLocationResponse.getCountryCode());
        }
        if (!Strings.isNullOrEmpty((String)ipLocationResponse.getRegion())) {
            containerRequestContext.getHeaders().putSingle((Object)"X-REQUEST-STATE-ISO", (Object)ipLocationResponse.getRegion());
        }
        if (!Strings.isNullOrEmpty((String)ipLocationResponse.getRegionName())) {
            containerRequestContext.getHeaders().putSingle((Object)"X-REQUEST-STATE", (Object)ipLocationResponse.getRegionName());
        }
        if (!Strings.isNullOrEmpty((String)ipLocationResponse.getCity())) {
            containerRequestContext.getHeaders().putSingle((Object)"X-REQUEST-CITY", (Object)ipLocationResponse.getCity());
        }
        if (!Strings.isNullOrEmpty((String)ipLocationResponse.getIsp())) {
            containerRequestContext.getHeaders().putSingle((Object)"X-REQUEST-ISP", (Object)ipLocationResponse.getIsp());
        }
        if (!Strings.isNullOrEmpty((String)ipLocationResponse.getZip())) {
            containerRequestContext.getHeaders().putSingle((Object)"X-REQUEST-POSTAL-CODE", (Object)ipLocationResponse.getZip());
        }
        containerRequestContext.getHeaders().putSingle((Object)"X-REQUEST-LATITUDE", (Object)String.valueOf(ipLocationResponse.getLat()));
        containerRequestContext.getHeaders().putSingle((Object)"X-REQUEST-LONGITUDE", (Object)String.valueOf(ipLocationResponse.getLon()));
    }

    private String toAscii(String input) {
        if (!Strings.isNullOrEmpty((String)input)) {
            return input.replaceAll("[^\\x20-\\x7e]", "");
        }
        return input;
    }
}

