/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.ipapi.core;

public class LocationInfo {
    private String city;
    private String state;
    private String stateIso;
    private String country;
    private String countryIso;
    private String postal;
    private String isp;
    private double latitude;
    private double longitude;

    public static LocationInfoBuilder builder() {
        return new LocationInfoBuilder();
    }

    public String getCity() {
        return this.city;
    }

    public String getState() {
        return this.state;
    }

    public String getStateIso() {
        return this.stateIso;
    }

    public String getCountry() {
        return this.country;
    }

    public String getCountryIso() {
        return this.countryIso;
    }

    public String getPostal() {
        return this.postal;
    }

    public String getIsp() {
        return this.isp;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setStateIso(String stateIso) {
        this.stateIso = stateIso;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public void setCountryIso(String countryIso) {
        this.countryIso = countryIso;
    }

    public void setPostal(String postal) {
        this.postal = postal;
    }

    public void setIsp(String isp) {
        this.isp = isp;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocationInfo)) {
            return false;
        }
        LocationInfo other = (LocationInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getLatitude(), other.getLatitude()) != 0) {
            return false;
        }
        if (Double.compare(this.getLongitude(), other.getLongitude()) != 0) {
            return false;
        }
        String this$city = this.getCity();
        String other$city = other.getCity();
        if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
            return false;
        }
        String this$state = this.getState();
        String other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        String this$stateIso = this.getStateIso();
        String other$stateIso = other.getStateIso();
        if (this$stateIso == null ? other$stateIso != null : !this$stateIso.equals(other$stateIso)) {
            return false;
        }
        String this$country = this.getCountry();
        String other$country = other.getCountry();
        if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
            return false;
        }
        String this$countryIso = this.getCountryIso();
        String other$countryIso = other.getCountryIso();
        if (this$countryIso == null ? other$countryIso != null : !this$countryIso.equals(other$countryIso)) {
            return false;
        }
        String this$postal = this.getPostal();
        String other$postal = other.getPostal();
        if (this$postal == null ? other$postal != null : !this$postal.equals(other$postal)) {
            return false;
        }
        String this$isp = this.getIsp();
        String other$isp = other.getIsp();
        return !(this$isp == null ? other$isp != null : !this$isp.equals(other$isp));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LocationInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $latitude = Double.doubleToLongBits(this.getLatitude());
        result = result * 59 + (int)($latitude >>> 32 ^ $latitude);
        long $longitude = Double.doubleToLongBits(this.getLongitude());
        result = result * 59 + (int)($longitude >>> 32 ^ $longitude);
        String $city = this.getCity();
        result = result * 59 + ($city == null ? 43 : $city.hashCode());
        String $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        String $stateIso = this.getStateIso();
        result = result * 59 + ($stateIso == null ? 43 : $stateIso.hashCode());
        String $country = this.getCountry();
        result = result * 59 + ($country == null ? 43 : $country.hashCode());
        String $countryIso = this.getCountryIso();
        result = result * 59 + ($countryIso == null ? 43 : $countryIso.hashCode());
        String $postal = this.getPostal();
        result = result * 59 + ($postal == null ? 43 : $postal.hashCode());
        String $isp = this.getIsp();
        result = result * 59 + ($isp == null ? 43 : $isp.hashCode());
        return result;
    }

    public String toString() {
        return "LocationInfo(city=" + this.getCity() + ", state=" + this.getState() + ", stateIso=" + this.getStateIso() + ", country=" + this.getCountry() + ", countryIso=" + this.getCountryIso() + ", postal=" + this.getPostal() + ", isp=" + this.getIsp() + ", latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ")";
    }

    public LocationInfo(String city, String state, String stateIso, String country, String countryIso, String postal, String isp, double latitude, double longitude) {
        this.city = city;
        this.state = state;
        this.stateIso = stateIso;
        this.country = country;
        this.countryIso = countryIso;
        this.postal = postal;
        this.isp = isp;
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public LocationInfo() {
    }

    public static class LocationInfoBuilder {
        private String city;
        private String state;
        private String stateIso;
        private String country;
        private String countryIso;
        private String postal;
        private String isp;
        private double latitude;
        private double longitude;

        LocationInfoBuilder() {
        }

        public LocationInfoBuilder city(String city) {
            this.city = city;
            return this;
        }

        public LocationInfoBuilder state(String state) {
            this.state = state;
            return this;
        }

        public LocationInfoBuilder stateIso(String stateIso) {
            this.stateIso = stateIso;
            return this;
        }

        public LocationInfoBuilder country(String country) {
            this.country = country;
            return this;
        }

        public LocationInfoBuilder countryIso(String countryIso) {
            this.countryIso = countryIso;
            return this;
        }

        public LocationInfoBuilder postal(String postal) {
            this.postal = postal;
            return this;
        }

        public LocationInfoBuilder isp(String isp) {
            this.isp = isp;
            return this;
        }

        public LocationInfoBuilder latitude(double latitude) {
            this.latitude = latitude;
            return this;
        }

        public LocationInfoBuilder longitude(double longitude) {
            this.longitude = longitude;
            return this;
        }

        public LocationInfo build() {
            return new LocationInfo(this.city, this.state, this.stateIso, this.country, this.countryIso, this.postal, this.isp, this.latitude, this.longitude);
        }

        public String toString() {
            return "LocationInfo.LocationInfoBuilder(city=" + this.city + ", state=" + this.state + ", stateIso=" + this.stateIso + ", country=" + this.country + ", countryIso=" + this.countryIso + ", postal=" + this.postal + ", isp=" + this.isp + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ")";
        }
    }
}

