/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.ipapi.config;

public class IpApiConfig {
    private String remoteIpHeader = "X-FORWARDED-FOR";
    private int cacheTTL = 300;
    private int cacheMaxEntries = 10000;

    public static IpApiConfigBuilder builder() {
        return new IpApiConfigBuilder();
    }

    public String getRemoteIpHeader() {
        return this.remoteIpHeader;
    }

    public int getCacheTTL() {
        return this.cacheTTL;
    }

    public int getCacheMaxEntries() {
        return this.cacheMaxEntries;
    }

    public void setRemoteIpHeader(String remoteIpHeader) {
        this.remoteIpHeader = remoteIpHeader;
    }

    public void setCacheTTL(int cacheTTL) {
        this.cacheTTL = cacheTTL;
    }

    public void setCacheMaxEntries(int cacheMaxEntries) {
        this.cacheMaxEntries = cacheMaxEntries;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IpApiConfig)) {
            return false;
        }
        IpApiConfig other = (IpApiConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCacheTTL() != other.getCacheTTL()) {
            return false;
        }
        if (this.getCacheMaxEntries() != other.getCacheMaxEntries()) {
            return false;
        }
        String this$remoteIpHeader = this.getRemoteIpHeader();
        String other$remoteIpHeader = other.getRemoteIpHeader();
        return !(this$remoteIpHeader == null ? other$remoteIpHeader != null : !this$remoteIpHeader.equals(other$remoteIpHeader));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IpApiConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCacheTTL();
        result = result * 59 + this.getCacheMaxEntries();
        String $remoteIpHeader = this.getRemoteIpHeader();
        result = result * 59 + ($remoteIpHeader == null ? 43 : $remoteIpHeader.hashCode());
        return result;
    }

    public String toString() {
        return "IpApiConfig(remoteIpHeader=" + this.getRemoteIpHeader() + ", cacheTTL=" + this.getCacheTTL() + ", cacheMaxEntries=" + this.getCacheMaxEntries() + ")";
    }

    public IpApiConfig(String remoteIpHeader, int cacheTTL, int cacheMaxEntries) {
        this.remoteIpHeader = remoteIpHeader;
        this.cacheTTL = cacheTTL;
        this.cacheMaxEntries = cacheMaxEntries;
    }

    public IpApiConfig() {
    }

    public static class IpApiConfigBuilder {
        private String remoteIpHeader;
        private int cacheTTL;
        private int cacheMaxEntries;

        IpApiConfigBuilder() {
        }

        public IpApiConfigBuilder remoteIpHeader(String remoteIpHeader) {
            this.remoteIpHeader = remoteIpHeader;
            return this;
        }

        public IpApiConfigBuilder cacheTTL(int cacheTTL) {
            this.cacheTTL = cacheTTL;
            return this;
        }

        public IpApiConfigBuilder cacheMaxEntries(int cacheMaxEntries) {
            this.cacheMaxEntries = cacheMaxEntries;
            return this;
        }

        public IpApiConfig build() {
            return new IpApiConfig(this.remoteIpHeader, this.cacheTTL, this.cacheMaxEntries);
        }

        public String toString() {
            return "IpApiConfig.IpApiConfigBuilder(remoteIpHeader=" + this.remoteIpHeader + ", cacheTTL=" + this.cacheTTL + ", cacheMaxEntries=" + this.cacheMaxEntries + ")";
        }
    }
}

