/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.ipapi;

import feign.Client;
import feign.Feign;
import feign.Logger;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.okhttp.OkHttpClient;
import feign.slf4j.Slf4jLogger;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.ipapi.client.IpApiClient;
import io.dropwizard.ipapi.config.IpApiConfig;
import io.dropwizard.ipapi.filter.IpApiRequestFilter;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.ws.rs.WebApplicationException;
import org.apache.commons.io.IOUtils;

public abstract class IpApiBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    public abstract IpApiConfig getMaxMindConfig(T var1);

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public void run(T configuration, Environment environment) {
        IpApiConfig ipApiConfig = this.getMaxMindConfig(configuration);
        environment.jersey().register((Object)new IpApiRequestFilter(ipApiConfig, this.createIpApiClient(ipApiConfig, environment)));
    }

    private IpApiClient createIpApiClient(IpApiConfig ipApiConfig, Environment environment) {
        return (IpApiClient)Feign.builder().client((Client)new OkHttpClient()).encoder((Encoder)new JacksonEncoder(environment.getObjectMapper())).decoder((Decoder)new JacksonDecoder(environment.getObjectMapper())).logger((Logger)new Slf4jLogger(IpApiClient.class)).errorDecoder((methodKey, response) -> {
            try {
                return new WebApplicationException(IOUtils.toString((Reader)response.body().asReader(Charset.defaultCharset())), response.status());
            }
            catch (IOException e) {
                throw new WebApplicationException((Throwable)e);
            }
        }).logLevel(Logger.Level.FULL).target(IpApiClient.class, "http://ip-api.com");
    }
}

