(ns vybe.debug.flow-storm
  "See https://www.flow-storm.org/

  You should have Flow Storm as one of your dependencies
  before calling this ns."
  (:require
   [vybe.panama :as vp]
   [flow-storm.runtime.values :as fs.v]
   [flow-storm.debugger.ui.data-windows.visualizers :as viz]
   [flow-storm.debugger.main :as fs.dbg]
   [nrepl.server :refer [start-server]]
   [vybe.type :as vt]
   [vybe.raylib :as vr]
   [vybe.raylib.c :as vr.c]
   vybe.flecs)
  (:import
   (vybe.flecs VybeFlecsWorldMap)
   (vybe.panama VybePMap)
   (javafx.scene.image Image ImageView)
   (org.vybe.raylib raylib)))

(extend-protocol fs.v/SnapshotP
  VybeFlecsWorldMap
  (snapshot-value [_wm]
    "WORLD"))

(extend-protocol fs.v/SnapshotP
  VybePMap
  (snapshot-value [v]
    (let [c (vp/component v)]
      (with-meta (merge (into {} v)
                        (when (= c vr/RenderTexture2D)
                          {::meta
                           (let [{:keys [id width height]} (:texture v)]
                             {:texture-pixels
                              (->> (-> (vr.c/rl-read-texture-pixels
                                        id width height (raylib/RL_PIXELFORMAT_UNCOMPRESSED_R8G8B8A8))
                                       (vp/arr (* width height) vr/Color))
                                   (take #_(* width height) 10000)
                                   (mapv #(into {} %)))})}))
        {::vp/VybePMap {:component (symbol (vp/comp-name c))}}))))

#_(->> (-> (vr.c/rl-read-texture-pixels #_(:id (:texture rt)) 28
                                        600 600 (raylib/RL_PIXELFORMAT_UNCOMPRESSED_R8G8B8A8))
           (vp/arr (* 600 600) vr/Color))
     #_(take 100)
     fs.v/snapshot-value)

(viz/register-visualizer
 {:id :vyz/texture
  :pred (fn [val] true)
  :on-create (fn [val]
               (def val val)
               #_ (mapv (comp :val-preview meta) (:shallow-map/keys-refs val))
               {:fx/node
                (ImageView. (Image. "file:/Users/pfeodrippe/Downloads/gltfOverview-2.0.0-small.png"))})
  ;; OPTIONALLY
  #_ #_:on-update (fn [val created-ctx-map {:keys [new-val]}] )
  #_ #_:on-destroy (fn [created-ctx-map] )})

;; --- nREPL
;; We run the debugger in another JVM (because of the OSX's first thread
;; issue), so we start a nREPL server for this new process as well.
(defn start-nrepl!
  []
  (let [port (Long/parseLong
              (or (System/getProperty "VYBE_NREPL_PORT")
                  (System/getenv "VYBE_NREPL_PORT")
                  "7988"))]
    (try
      (start-server :port port)
      (catch Exception e
        (println :nrepl-connection/error "\n" e))
      (finally
        (println :nrepl-connection :port port)))))

(defn start-debugger
  [m]
  (start-nrepl!)
  (fs.dbg/start-debugger m))
