/*
contributors: Jamie Owen
description: Photoshop Lighten blend mode mplementations sourced from this article on https://mouaif.wordpress.com/2009/01/05/photoshop-math-with-glsl-shaders/
use: blendLighten(<float|float3> base, <float|float3> blend [, <float> opacity])
license: MIT License (MIT) Copyright (c) 2015 Jamie Owen
*/

#ifndef FNC_BLENDLIGHTEN
#define FNC_BLENDLIGHTEN
float blendLighten(in float base, in float blend) {
    return max(blend, base);
}

float3 blendLighten(in float3 base, in float3 blend) {
    return float3(  blendLighten(base.r, blend.r),
                    blendLighten(base.g, blend.g),
                    blendLighten(base.b, blend.b) );
}

float3 blendLighten(in float3 base, in float3 blend, in float opacity) {
    return (blendLighten(base, blend) * opacity + base * (1. - opacity));
}
#endif
